# ------------------------------------------------------------------------------
# <auto-generated>
#     This code was generated by a tool.
#     Changes to this file may cause incorrect behavior and will be lost if
#     the code is regenerated.
# </auto-generated>
#
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# ------------------------------------------------------------------------------

from .base_date_time import BaseDateTime
# pylint: disable=line-too-long


class ItalianDateTime:
    LangMarker = 'Ita'
    CheckBothBeforeAfter = False
    TillRegex = f'(?<till>\\b(fino\\s+a(l(l[aoe\'])?|gli|i|d)?|a(l(l[aoe\'])?|gli|i|d)?|e\\s+(il?|l[aoe\']|gli))\\b|--|-|—|——|~)'
    RestrictedTillRegex = f'(?<till>\\b(fino\\s+a(l(l[aoe\'])?|gli|i|d)?)\\b|--|-|—|——|~)'
    RangeConnectorRegex = f'(?<and>\\b(e(\\s+l[aoe\']|gli|i|d)?|a(l(l[aoe\'])?|gli|i|d)?)\\b|{BaseDateTime.RangeConnectorSymbolRegex})'
    RelativeRegex = f'\\b(?<order>((il?|l[ae])\\s+)?prossim[\'oaie]|((il?|l[ae])\\s+)?seguent[ei]|((il?|l[ae])\\s+)?successiv[oaei]|in\\s+arrivo|quest[\'oaie]|(l\'|gli\\s+|le\\s+)?ultim[\'oaie]|((il?|l[ae])\\s+)?passat[oaie]|((il?|l[ae])\\s+)?precedent[ei]|((lo|l[ae]|gli)\\s+)?scors[oaie]|((il?|l[ae])\\s+)?corrent[ei]|quest[\'oaei]|il?|l[oae\']|gli)'
    StrictRelativeRegex = f'(?<order>prossim[\'oaie]|seguent[ei]|successiv[oaei]|in\\s+arrivo|quest[\'oaie]|ultim[\'oaie]|passat[oaie]|precedent[ei]|scors[oaie]|corrent[ei]|quest[\'oaei])'
    NextSuffixRegex = f'(?<order>prossim[oaei]|seguent[ei]|successiv[oaei]|imminent[ei]|in\\s+arrivo)\\b'
    PastSuffixRegex = f'(?<order>precedent[ei]|scors[oaei]|passat[oaei]|ultim[\'oaie])\\b'
    ThisPrefixRegex = f'(quest[\'oa]|corrente)'
    UpcomingPrefixRegex = f'((quest[aoei]\\s+)?(stess[oaei]|imminent[ei])|in\\s+arrivo)'
    NextPrefixRegex = f'\\b(((il?|l[ae])\\s+)?successiv[oaei]|((il?|l[ae])\\s+)?seguent[ei]|((il?|l[ae])\\s+)?prossim[oaei]|{UpcomingPrefixRegex})\\b'
    AfterNextSuffixRegex = f'\\b(dopo\\s+(il|la)\\s+prossim[oa])\\b'
    PastPrefixRegex = f'\\b(((lo|l[ae]|gli)\\s+)?scors[oaei])\\b'
    PreviousPrefixRegex = f'\\b(((il?|l[ae])\\s+)?passat[oaei]|((il?|l[ae])\\s+)?precedent[ei]|(l\'|gli\\s+|le\\s+)?ultim[oaei]|{PastPrefixRegex})\\b'
    RangePrefixRegex = f'\\b(da(l(l[oae\'])?|i|gli)?|tra|fra|entro)(\\s+(il|l[aeo\']|gli|i))?\\b'
    WrittenOneToNineRegex = f'(uno|due|tre|quattro|cinque|sei|sette|otto|nove)'
    WrittenElevenToNineteenRegex = f'(undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove)'
    WrittenTensRegex = f'(dieci|venti?|trenta?|quaranta?|cinquanta?|sessanta?|settanta?|o?ttanta?|novanta?)'
    WrittenNumRegex = f'({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|({WrittenTensRegex}{WrittenOneToNineRegex}?))'
    FirstDayRegex = f'(primo(?=\\s+(aprile|apr|agosto|ago|dicembre|dic|febbraio|feb|gennaio|gen|luglio|lug|giugno|giu|marzo|mar|maggio|mag|novembre|nov|ottobre|ott|settembre|set|sett)\\b))'
    WrittenDayRegex = f'(?<day>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|ventuno|ventidue|ventitre|ventiquattro|venticinque|ventisei|ventisette|ventotto|ventinove|trenta|trentuno|{FirstDayRegex})'
    DayRegex = f'\\b((il|l\')\\s*)?(?<!\\d)(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(?!°)(?=\\b|t)'
    MonthNumRegex = f'(?<month>01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)\\b'
    WeekDayRegex = f'\\b(?<weekday>domenica|lunedì|martedì|mercoledì|giovedì|venerdì|sabato|lun|mar|mer|gio|ven|sab|dom)\\b'
    RelativeMonthRegex = f'(?<relmonth>((di|del|dell[o\'])\\s+)?(({ThisPrefixRegex}\\s+mese)|(mese\\s+({PastSuffixRegex}|{NextSuffixRegex}))|(({PastSuffixRegex}|{NextSuffixRegex})\\s+mese)))\\b'
    MonthRegex = f'(?<month>apr(ile)?|ago(sto)?|dic(embre)?|feb(braio)?|gen(naio)?|lug(lio)?|giu(gno)?|mar(zo)?|mag(gio)?|nov(embre)?|ott(obre)?|set(tembre|t)?)\\b'
    EngMonthRegex = f'(((il\\s+)?mese di\\s+)?{MonthRegex})'
    MonthSuffixRegex = f'(?<msuf>(in\\s+|nel(l[\'o])?\\s*|di\\s+|del(l[\'o])?\\s*|a([ld]|ll[\'o])?\\s*|(il|l[o\'])\\s*)?({RelativeMonthRegex}|{EngMonthRegex}))'
    SpecialDescRegex = f'((?<ipm>)p\\b)'
    AmDescRegex = f'({BaseDateTime.BaseAmDescRegex})'
    PmDescRegex = f'({BaseDateTime.BasePmDescRegex})'
    AmPmDescRegex = f'({BaseDateTime.BaseAmPmDescRegex})'
    DescRegex = f'(?<desc>in punto|{AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})'
    WrittenCenturyCardinalYearRegex = f'(cento|duecento|trecento|quattrocento|cinquecento|seicento|settecento|ottocento|novecento)'
    WrittenCenturyOrdinalYearRegex = f'(ventunesimo|ventiduesimo|primo|secondo|terzo|quarto|quinto|sesto|settimo|ottavo|nono|decimo|undicesimo|ventesimo|tredicesimo|quattordicesimo|quindicesimo|sedicesimo|diciassettesimo|diciottesimo|diciannovesimo|ventesimo)(\\s+secolo)?'
    WrittenCenturyFullYearRegex = f'(?<century>(mille|duemila)({WrittenCenturyCardinalYearRegex})?|{WrittenCenturyCardinalYearRegex})'
    CenturyRegex = f'\\b(?<century>{WrittenCenturyFullYearRegex})\\b'
    DecadeRegex = f'(?<decade>dieci|venti|trenta|quaranta|cinquanta|sessanta|settanta|o?ttanta|novanta|due mila)'
    DecadeWithCenturyRegex = f'\\b((gli\\s+)?anni\\s+)(((?<century>\\d|1\\d|2\\d)?(\')?(?<decade>\\d0)(\')?)|(({CenturyRegex})?{DecadeRegex})|{WrittenCenturyFullYearRegex}({DecadeRegex})?)\\b'
    RelativeDecadeRegex = f'\\b((((il?|l\'|gli)\\s*)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?decennio?)|(((il?|l\'|gli)\\s*)?((?<number>[\\w,]+)\\s+)?decennio?\\s+{RelativeRegex}))\\b'
    LastTwoYearNumRegex = f'({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}({WrittenOneToNineRegex})?)'
    FullTextYearRegex = f'\\b((?<firsttwoyearnum>{WrittenCenturyFullYearRegex})(?<lasttwoyearnum>{LastTwoYearNumRegex})?)\\b'
    TwoDigitYearRegex = f'\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b'
    DateYearRegex = f'(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})'
    YearSuffix = f'(,?\\s*({DateYearRegex}|{FullTextYearRegex}))'
    YearRegex = f'({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})'
    DateUnitRegex = f'\\b(?<unit>decennio|mese|settimana|(ann|giorn)(o|(?<plural>i))|(?<plural>decenni|mesi|settimane))\\b'
    SimpleCasesRegex = f'\\b((dal?|[tf]ra)\\s+)?({DayRegex})(\\s+{MonthSuffixRegex})?\\s*{TillRegex}\\s*({DayRegex}\\s+{MonthSuffixRegex}|{MonthSuffixRegex}\\s+{DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    MonthFrontSimpleCasesRegex = f'\\b((dal?|[tf]ra)\\s+)?{MonthSuffixRegex}\\s+((dal?|[tf]ra)\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    MonthFrontBetweenRegex = f'\\b{MonthSuffixRegex}\\s+([tf]ra\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    BetweenRegex = f'\\b([tf]ra\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b'
    YearWordRegex = f'\\b(?<year>l\'anno)\\b'
    MonthWithYear = f'\\b({MonthRegex}(\\.)?(\\s*)[/\\\\\\-\\.,]?(((\\s+del)?\\s+{YearRegex}|{TwoDigitYearRegex})|((\\s+(del|di|il))?\\s+(?<order>prossim[\'o]|passato|quest[\'o])\\s*anno)|((\\s+(del)?l\')anno\\s+(?<order>prossimo|passato))))'
    SpecialYearPrefixes = f'(?<special>fiscale|scolastico)'
    OneWordPeriodRegex = f'\\b((((il|l[o\'])\\s*)?((mese di\\s+)|({RelativeRegex}\\s*))?{MonthRegex}(\\s+{RelativeRegex})?)|dall\'inizio\\s+del(l\')\\s*(mese|anno)|({RelativeRegex}\\s*)?(mi[ao]\\s+)?(weekend|finesettimana|settimana|mese|anno)(\\s+{RelativeRegex})?(?!((\\s+di|del)?\\s+\\d+))(\\s+{AfterNextSuffixRegex})?)\\b'
    MonthNumWithYear = f'({YearRegex}[/\\-\\.]{MonthNumRegex})|({MonthNumRegex}[/\\-]{YearRegex})'
    WeekOfMonthRegex = f'\\b(?<wom>(l[a\']\\s*)?(?<cardinal>prima|seconda|terza|quarta|quinta|ultima)\\s+settimana\\s+{MonthSuffixRegex}(\\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\\s+year)?)\\b'
    WeekOfYearRegex = f'\\b(?<woy>(l[a\']\\s*)?(?<cardinal>prima|seconda|terza|quarta|quinta|ultima)\\s+settimana(\\s+(di|del(l[o\'])?))?\\s*({YearRegex}|({RelativeRegex}\\s*anno)|(anno\\s+(({NextSuffixRegex})|({PastSuffixRegex})))))'
    OfYearRegex = f'\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b'
    FirstLastRegex = f'\\b(the\\s+)?((?<first>first)|(?<last>last))\\b'
    FollowedDateUnit = f'^\\s*{DateUnitRegex}'
    NumberCombinedWithDateUnit = f'\\b(?<num>\\d+([\\.,]\\d*)?)\\s*{DateUnitRegex}'
    QuarterRegex = f'\\b((il|l\')\\s*)?(?<cardinal>primo|secondo|terzo|quarto|ultimo)\\s+trimestre((\\s+(di|del(l[o\'])?)|\\s*,\\s*)?\\s*({YearRegex}|({RelativeRegex}\\s*anno)|(anno\\s+(({NextSuffixRegex})|({PastSuffixRegex})))))?'
    QuarterRegexYearFront = f'({YearRegex}|l\'anno\\s+({PastSuffixRegex}|{NextSuffixRegex})|{RelativeRegex}\\s+anno)\\s+((per\\s+)?il\\s+)?(?<cardinal>primo|secondo|terzo|quarto)\\s+trimestre'
    AllHalfYearRegex = f'((la\\s+)?((prima|seconda)\\s+metà)(\\s+(di|del(l[o\'])?)|\\s*,\\s*)\\s*({RelativeRegex}?\\s*anno)|(il\\s+)?((primo|secondo)\\s+semestre)((\\s+(di|del(l[o\'])?)|\\s*,\\s*)\\s*({RelativeRegex}?\\s*anno))?)'
    EarlyPrefixRegex = f'\\b(?<EarlyPrefix>prima|a\\s+partire\\s+da(l(l[aoe\'])?)?|inizio(\\s+(di|del(l[ao\'])?))?)\\b'
    MidPrefixRegex = f'\\b(?<MidPrefix>metà(\\s+(di|del(l[ao\'])?))?)\\b'
    LaterPrefixRegex = f'\\b(?<LatePrefix>fine(\\s+(di|del(l[ao\'])?))?|(?<RelLate>più\\s+tardi(\\s+(in|a))?))\\b'
    PrefixPeriodRegex = f'({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})'
    PrefixDayRegex = f'\\b(((inizio|metà|fine)((\\s+(della\\s+)?giornata)|(\\s+del\\s+giorno)))|((prima|(più\\s+tardi))\\s+quel\\s+giorno))$'
    CenturySuffixRegex = f'(^secolo)\\b'
    SeasonRegex = f'\\b(l[a\']|{PrefixPeriodRegex}\\s*)?(((<seas>primavera|estate|autunno|inverno)\\s*({NextSuffixRegex}|{PastSuffixRegex}))|(?<season>({RelativeRegex}\\s*)?(?<seas>primavera|estate|autunno|inverno)((\\s+(di|del(l[o\'])?)|\\s*,\\s*)?\\s*({YearRegex}|{RelativeRegex}\\s*anno))?))\\b'
    WhichWeekRegex = f'\\b(settimana)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])\\b'
    WeekOfRegex = f'(la\\s+)?(settimana)(\\s*)(d[i\']|del(l[aeo\'])?|degli)'
    MonthOfRegex = f'(il\\s+)?(mese)(\\s*)(d[i\']|del(l[aeo\'])?|degli)'
    OnRegex = f'(?<=\\b(il|l\')\\s*)({DayRegex})\\b'
    RelaxedOnRegex = f'(?<=\\b(il|l\'|del(l\')?|di|al(l\')?|a)\\s*)((?<day>10|11|12|13|14|15|16|17|18|19|1°?|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9))(?!°)\\b'
    PrefixWeekDayRegex = f'(\\s*((,?\\s*(di|il))|[,-—–]))'
    ThisRegex = f'\\b(quest[oa](\\s+settimana{PrefixWeekDayRegex}?)?\\s*{WeekDayRegex})|({WeekDayRegex}((\\s+di)?\\s+questa\\s+settimana))\\b'
    LastDateRegex = f'\\b({WeekDayRegex}\\s+(del)?la\\s+(settimana\\s+{PastSuffixRegex}|{PastSuffixRegex}\\s+settimana))|(({PastSuffixRegex}\\s+settimana|settimana\\s+{PastSuffixRegex})(\\s*{PrefixWeekDayRegex}?\\s*{WeekDayRegex}))|({WeekDayRegex}(\\s+(mattina|pomeriggio|sera|notte))?\\s+{PastSuffixRegex})|({PastSuffixRegex}\\s+{WeekDayRegex})\\b'
    NextDateRegex = f'\\b({WeekDayRegex}\\s+(del)?la\\s+(settimana\\s+{NextSuffixRegex}|{NextSuffixRegex}\\s+settimana))|(({NextSuffixRegex}\\s+settimana|settimana\\s+{NextSuffixRegex})({PrefixWeekDayRegex}?\\s*{WeekDayRegex})?)|({WeekDayRegex}(\\s+(mattina|pomeriggio|sera|notte))?\\s+{NextSuffixRegex})|({NextSuffixRegex}\\s+{WeekDayRegex})\\b'
    SpecialDayRegex = f'\\b((avant\'?ieri)|(l\'altro\\s*ieri)|(ieri\\s+l\'altro)|(dopo\\s*domani)|(il\\s+giorno\\s+(dopo|seguente|passato|precedente|prima))|ieri|((l\')?in)?domani|(quest\')?oggi|in\\s+giornata|((il|la|l\')\\s*)?({RelativeRegex}|mi[oa])\\s*(giorno|giornata))\\b'
    SpecialDayWithNumRegex = f'\\b((?<number>{WrittenNumRegex})\\s+giorni\\s+da\\s+(?<day>ieri|domani|oggi))\\b'
    StrictWeekDay = f'\\b(?<weekday>domenica|lunedì|martedì|mercoledì|giovedì|venerdì|sabato|lun|mar|mer|gio|ven|sab|dom)\\b'
    RelativeDayRegex = f'\\b(((il|l\')\\s*)?{RelativeRegex}\\s+giorno)\\b'
    SetWeekDayRegex = f'\\b(?<prefix>(tutt[ei]\\s+)?(le|i)\\s+)(?<weekday>(?<g0>mattin|ser)|(?<g1>pomerigg)|(?<g2>nott)|(?<g3>luned|marted|mercoled|gioved|venerd)|(?<g4>domenic)|(?<g5>sabat))(e|i|ì|he)\\b'
    WeekDayOfMonthRegex = f'(?<wom>((la|il)\\s+)?(?<cardinal>prim[ao]|second[ao]|terz[ao]|quart[ao]|quint[ao]|ultim[ao])\\s+{WeekDayRegex}\\s+{MonthSuffixRegex})'
    RelativeWeekDayRegex = f'\\b({WrittenNumRegex}\\s+{WeekDayRegex}\\s+(da\\s+ora|dopo))\\b'
    SpecialDate = f'(?<=\\b(il|l\'|al(l\')?)\\s*){DayRegex}\\b'
    DateExtractor1 = f'\\b((quest[oa]\\s+)?{WeekDayRegex}\\s*[,-]?\\s*)?(({MonthRegex}(\\.)?\\s*[/\\\\.,-]?\\s*{DayRegex}(?!\\s*\\-\\s*\\d{{2}}\\b))|(\\({MonthRegex}\\s*[-.]\\s*{DayRegex}\\))|({DayRegex}\\s*[/\\\\.,-]?\\s*{MonthRegex}(\\.)?))(\\s*\\(\\s*{WeekDayRegex}\\s*\\))?'
    DateExtractor2 = f'({DateExtractor1}(\\s+|\\s*[\\-/,.]\\s*|\\s+del\\s+)({DateYearRegex}))\\b'
    DateExtractor3 = f'\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?({DayRegex}(\\.)?(\\s*[/,.\\- ]\\s*|\\s+di\\s+){MonthRegex}(\\.)?(\\s*[/,.\\- ]\\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\\s*[/,.\\- ]\\s*{DayRegex}\\s*[/,.\\- ]\\s*{MonthRegex})\\b'
    DateExtractor4 = f'\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?((il|l\')\\s*)?{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}(\\.)?\\s*[/\\\\\\-]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    DateExtractor5 = f'\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex}(\\.)?)\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    DateExtractor6 = f'(?<!([\\-\\.\\/]|all[e\']\\s*|l[e\']\\s*))\\b{MonthNumRegex}[\\-\\.\\/]{DayRegex}{BaseDateTime.CheckDecimalRegex}(?!(%|\\s*{{DescRegex}}))\\b'
    DateExtractor7 = f'(?<!\\b{DateYearRegex}\\s*[/\\\\\\-]\\s*)\\b{DayRegex}\\s*[\\/\\\\-]s*{MonthNumRegex}((\\s+|\\s*[\\/\\-\\\\,]\\s*){DateYearRegex})?\\b{BaseDateTime.CheckDecimalRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    DateExtractor8 = f'(?<!([\\-\\.\\/]|all[e\']\\s*|l[e\']\\s*))\\b{DayRegex}[\\/\\\\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!(%|\\s*{DescRegex}))\\b'
    DateExtractor9 = f'(?<!\\b{DateYearRegex}\\s*[/\\\\\\-]\\s*)\\b{DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*|\\s+del\\s+){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b'
    DateExtractorA = f'\\b({DateYearRegex}\\s*[/\\\\\\-]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-]\\s*{DayRegex}|{MonthRegex}\\s*[/.\\-]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/.\\-]\\s*{DayRegex}|{DayRegex}\\s*[/.\\-]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/.\\-]\\s*{MonthRegex})(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    OfMonth = f'(^\\s*(di\\s+)?){MonthRegex}'
    MonthEnd = f'{MonthRegex}\\s*,?\\s*(il)?\\s*$'
    WeekDayEnd = f'(quest[oa]\\s+)?{WeekDayRegex}\\s*,?\\s*$'
    WeekDayStart = f'^[\\.]'
    RangeUnitRegex = f'\\b(?<unit>l\'anno|ann[oi]?|mes[ei]|settiman[ae])\\b'
    HourNumRegex = f'\\b(?<hournum>zero|(?<=l\')una|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|ventuno|ventidue|ventitre|ventiquattro)\\b'
    FivesRegex = f'(?<tens>(quindici|venti(\\s*cinque)?|trenta(\\s*cinque)?|quaranta(\\s*cinque)?|cinquanta(\\s*cinque)?|dieci|cinque))\\b'
    HourRegex = f'\\b{BaseDateTime.HourRegex}'
    PeriodHourNumRegex = f'\\b(?<hour>ventuno|ventidue|ventitre|ventiquattro|zero|(?<=l\')una|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti)\\b'
    MinuteNumRegex = f'(?<minnum>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|trenta|quaranta|cinquanta)'
    DeltaMinuteNumRegex = f'\\b(?<deltaminnum>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|trenta|quaranta|cinquanta)\\b'
    OclockRegex = f'(?<oclock>in punto)'
    OclockPrefix = f'(?<oclock>ore)'
    PmRegex = f'\\b(?<pm>(((di|del|a(l(l\')?)?|nel|il|per|verso)\\s+(il\\s+)?)?(pomeriggio|ora di pranzo))|(((di|della|nella|a|alla|verso|la|per|in)\\s+)?(la\\s+)?(notte|serata|sera|mezzanotte)))\\b'
    RangePmRegex = f'\\b(?<pm>(((di|del|a(l(l\')?)?|nel|il|per|verso)\\s+(il\\s+)?)?(pomeriggio))|(((di|della|nella|a|alla|verso|la|per|in)\\s+)?(la\\s+)?(notte|serata|sera)))\\b'
    AmRegex = f'\\b(?<am>((((la|alla|verso|per|della|di|in)\\s+(la\\s+)?)?(mattinata|mattina))|(((il|al|verso|per|del|di)\\s+(il\\s+)?)?(mattino))))\\b'
    LunchRegex = f'\\b(ora di pranzo)\\b'
    NightRegex = f'\\b(mezzanotte|notte)\\b'
    LessThanOneHour = f'(?<lth>(un\\s+quarto|tre quarti?|mezz[oa]|mezz\'ora|{BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex}))'
    EngTimeRegex = f'(?<engtime>{HourNumRegex}\\s+e\\s+({MinuteNumRegex}|(?<tens>venti?|trenta?|quaranta?|cinquanta?){MinuteNumRegex}))'
    TimePrefix = f'(?<prefix>((e|meno)\\s+{LessThanOneHour}(\\s+(minut[oi]|min))?|{LessThanOneHour}\\s+(minut[oi]|min)\\s+all[e\']))'
    TimeSuffix = f'(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})'
    BasicTime = f'\\b(?<basictime>{EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})'
    MidnightRegex = f'(?<midnight>mezzanotte|mezza notte)'
    CommonDatePrefixRegex = f'^[\\.]'
    MorningRegex = f'(?<morning>mattin[oa]|mattinata)'
    AfternoonRegex = f'(?<afternoon>pomeriggio)'
    MidmorningRegex = f'(?<midmorning>metà\\s*{MorningRegex})'
    MiddayRegex = f'(?<midday>metà\\s*giornata|(12\\s)?mezzogiorno)'
    MidafternoonRegex = f'(?<midafternoon>metà\\s*{AfternoonRegex})'
    MidTimeRegex = f'(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))'
    PrepRegex = f'\\b((\\.|,)(?!\\d+)|!|\\?|$|circa|presso|vicino|sopra|sotto|lontano|dentro|fuori|di|del(l[\'oae])?|dei|degli|a|al(l[\'oae])?|ai|agli|da|dal(l[\'oae])?|dai|dagli|in|nel(l[\'oae])?|nei|negli|su|sul(l[\'oae])?|sui|sugli)\\b'
    AtRegex = f'\\b(((?<=\\b(a)\\s+){MidTimeRegex}|{MidTimeRegex}\\b)|((?<=\\ball[e\']\\s*){EngTimeRegex}\\b)|((?<=\\b\\d+\\s+all[e\']\\s*)({HourNumRegex}|{BaseDateTime.HourRegex})\\b(?=\\s*(e|{DescRegex}|{PrepRegex})\\b))|((?<=([^\\d\\s]|^)\\s*\\ball[e\']\\s*)({HourNumRegex}|{BaseDateTime.HourRegex})\\b(?![\\.,]\\d+)))'
    IshRegex = f'\\b(((poco\\s+(prima|dopo)(\\s+(di|dell[e\']))?)|circa(\\s+a(ll[\'e])?)?|più o meno(\\s+a(ll[\'e])?)?)\\s*(({BaseDateTime.HourRegex}|{PeriodHourNumRegex})(?!\\s*({DescRegex}|[:\\.,/e]\\s*\\d+))|mezzogiorno)|(({BaseDateTime.HourRegex}|{PeriodHourNumRegex})(?!\\s*({DescRegex}|[:\\.,/e]\\s*\\d+))(\\s+circa)|mezzogiorno(\\s+circa)|verso\\s+mezzogiorno))\\b'
    TimeUnitRegex = f'(\\b\\d+([\\.,]\\d*)?|\\b)(?<unit>or(a|(?<plural>e))|(minut|second)(o|(?<plural>i))|h|(hr|min|sec)(?<plural>s)?)\\b'
    RestrictedTimeUnitRegex = f'(?<unit>ore|minuti)\\b'
    ConnectNumRegex = f'{BaseDateTime.HourRegex}(?<min>00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59)\\s*{DescRegex}'
    AmbiguousRangeModifierPrefix = f'^[.]'
    NumberEndingPattern = f'^(\\s+(?<meeting>riunione|appuntamento|conferenza|chiamata|chiamata skype)\\s+all[\'e]\\s*(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\\.)?$|(\\.,|,|!|\\?)))'
    TimeRegex1 = f'(((((?<=\\b(da|al)?(le|l\'|ore)\\s*)({EngTimeRegex}))|((?<=\\b(da|al)?(le|l\'|ore)\\s*)({HourNumRegex}|{BaseDateTime.HourRegex})(?![\\.,]\\d+)(?=\\s*({PrepRegex}))))|(({TimePrefix}\\s+)({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}))|(({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\\s+{TimePrefix}))((\\s*{DescRegex})|\\b))'
    TimeRegex2 = f'(t)?({BaseDateTime.HourRegex})(\\s*)?:(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?((\\s*{DescRegex})|\\b)'
    TimeRegex3 = f'\\b{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})(\\s+{TimePrefix})?'
    TimeRegex4 = f'\\b({BasicTime}(\\s*{DescRegex})?(\\s+{TimePrefix})?(\\s*{DescRegex})?\\s+{TimeSuffix}|{OclockPrefix}\\s+{BasicTime}(\\s*{DescRegex})?(\\s+{TimePrefix})?(\\s*{DescRegex})?)\\b'
    TimeRegex5 = f'\\b(({BasicTime}\\s*{DescRegex}(\\s+{TimePrefix})?)|({BasicTime}(\\s+{TimePrefix})((\\s*{DescRegex})|\\b))|((?<=\\b(da|al)?(le|l\'|ore)\\s*)(\\b(?<basictime>{EngTimeRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?)|\\b(?<basictime>{HourNumRegex}|{BaseDateTime.HourRegex})(?![\\.,]\\d+)(?=\\s*({PrepRegex})\\b))))'
    TimeRegex6 = f'({BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}|{OclockPrefix}\\s+{BasicTime}(\\s*{DescRegex})?)\\b'
    TimeRegex7 = f'\\b{TimeSuffix}\\s+d?all[e\']\\s*{BasicTime}(\\s+{TimePrefix})?((\\s*{DescRegex})|\\b)'
    TimeRegex8 = f'\\b({TimeSuffix}|{OclockPrefix})\\s+{BasicTime}((\\s*{DescRegex})|\\b)'
    TimeRegex9 = f'\\b{PeriodHourNumRegex}(\\s+e)\\s+{FivesRegex}((\\s*{DescRegex})|\\b)'
    TimeRegex10 = f'(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?'
    TimeRegexWithDotConnector = f'({BaseDateTime.HourRegex}(\\s*\\.\\s*){BaseDateTime.MinuteRegex})'
    FirstTimeRegexInTimeRange = f'\\b{TimeRegexWithDotConnector}(\\s*{DescRegex})?'
    PeriodDescRegex = f'(?<desc>pm|am|p\\.m\\.|a\\.m\\.)'
    PeriodPmRegex = f'\\b(?<pm>(nel|questo)\\s+pomeriggio|(questa|di)\\s+sera|(durante\\s+la|in)\\s+serata|nella\\s+notte)\\b'
    PeriodAmRegex = f'\\b(?<am>al mattino|alla mattina|di mattina|in mattinata)\\b'
    PureNumFromTo = f'(((?<leftDesc>{PmRegex}|{AmRegex})\\s*da(ll[e\'])?\\s*({HourRegex}|{PeriodHourNumRegex})\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex}))|((?<!(dell[e\']|dal)\\s*)|da(ll[e\'])?\\s*)(({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?))'
    PureNumBetweenAnd = f'([tf]ra(\\s+l[e\'])?\\s*)({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?\\s*{RangeConnectorRegex}\\s*({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?'
    SpecificTimeFromTo = f'(da(ll[e\'])?\\s*)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{TillRegex}\\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))'
    SpecificTimeBetweenAnd = f'([tf]ra(\\s+l[e\'])?\\s*)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{RangeConnectorRegex}\\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))'
    PrepositionRegex = f'(?<prep>^(,\\s*)?(a(l(l[\'e])?)?|il|la|di|del(l[ae\'])?)$)'
    TimeOfDayRegex = f'\\b(?<timeOfDay>(((((il|la|in|a(l(la)?)?|nel(la)?|di)\\s+)?(((mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<early>\\s+presto)|(?<early>prim[ao]\\s+)(mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))|((mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<late>\\s+(tardi|inoltrat[oa]|fonda))|(?<late>tard[oa]\\s+)?(mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)))))|(in\\s+giornata|durante\\s+il\\s+giorno|(durante\\s+le|nelle)\\s+ore\\s+d[i\']\\s*ufficio)))\\b'
    SpecificTimeOfDayRegex = f'\\b(di\\s+)?(({RelativeRegex}\\s+{TimeOfDayRegex})|({TimeOfDayRegex}\\s*({NextSuffixRegex}|{PastSuffixRegex}))|(stamattina|stasera|stanotte))\\b'
    TimeFollowedUnit = f'^\\s*{TimeUnitRegex}'
    TimeNumberCombinedWithUnit = f'\\b(?<num>\\d+(\\.\\d*)?)\\s*{TimeUnitRegex}'
    NowRegex = f'\\b(?<now>(proprio\\s+)?(adesso|ora(?!\\s+(di|del(l[aeo\'])?|degli|\\d+|x))|in\\s+questo\\s+momento)|il prima possibile|asap|recentemente|precedentemente)\\b'
    SuffixRegex = f'^\\s*\\b((in|nel(la)?|al(la)?|di)\\s+)?(mattin[oa]|mattinata|pomeriggio|sera|serata|notte|nottata)\\b'
    DateTimeTimeOfDayRegex = f'\\b(?<timeOfDay>mattin[oa]|mattinata|pomeriggio|sera|serata|notte|nottata)\\b'
    DateTimeSpecificTimeOfDayRegex = f'\\b(di\\s+)?(({RelativeRegex}\\s+{DateTimeTimeOfDayRegex})|({DateTimeTimeOfDayRegex}\\s+({NextSuffixRegex}|{PastSuffixRegex}))|stamattina|stasera|stanotte)\\b'
    TimeOfTodayAfterRegex = f'^\\s*(,\\s*)?(in|nel(la)?|di|del(la)?\\s+)?{DateTimeSpecificTimeOfDayRegex}'
    TimeOfTodayBeforeRegex = f'({DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+((intorno\\s+)?(a(ll[e\'])?)|verso\\s+l[e\']))?\\s*$)'
    SimpleTimeOfTodayAfterRegex = f'({HourNumRegex}|{HourRegex})\\s*(,\\s*)?(in|nel(la)?|di|del(la)?\\s+)?{DateTimeSpecificTimeOfDayRegex}'
    SimpleTimeOfTodayBeforeRegex = f'({DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(all[\'e]|verso\\s+l[\'e]))?\\s*({HourNumRegex}|{BaseDateTime.HourRegex}))'
    SpecificEndOfRegex = f'(alla\\s+)?fine\\s+(di|del(l[\'a])?)\\s*$'
    UnspecificEndOfRegex = f'(\\b(a|((al)?la)\\s+))?((fine\\s+(della\\s+)?giornata))\\b'
    UnspecificEndOfRangeRegex = f'\\b(fine\\s*(dell\')?anno)\\b'
    PeriodTimeOfDayRegex = f'\\b(((il|la|in|a(l(la)?)?|nel(la)?|di)\\s+)?(((?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<early>\\s+presto)|(?<early>prim[ao]\\s+)(?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))|((?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<late>\\s+(tardi|inoltrat[oa]|fonda))|(?<late>tard[oa]\\s+)?(?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))))\\b'
    PeriodSpecificTimeOfDayRegex = f'\\b(di\\s+)?(({RelativeRegex}\\s+{PeriodTimeOfDayRegex})|sta(mattina|sera|notte))\\b'
    PeriodTimeOfDayWithDateRegex = f'\\b({TimeOfDayRegex}(\\s+(il|l\'|del(l\')?|di))?)\\b'
    LessThanRegex = f'\\b(meno\\s+di)\\b'
    MoreThanRegex = f'\\b(più\\s+di)\\b'
    DurationUnitRegex = f'(?<unit>{DateUnitRegex}|or[ae]|hrs?|h|minut[oi]|mins?|second[oi]|secs?)\\b'
    SuffixAndRegex = f'(?<suffix>\\s*e\\s+(un\\s+)?(?<suffix_num>mezzo|mezza|quarto))'
    PeriodicRegex = f'\\b(?<periodic>giornalier[oaei]|giornalmente|quotidian[oaei]|quotidianamente|mensil[ei]|mensilmente|settimanal[ei]|settimanalmente|bisettimanal[ei]|annual[ei]|annualmente)\\b'
    EachUnitRegex = f'(?<each>(ogni|tutte\\s+le|tutti\\s+(gl)?i|una\\s+volta\\s+(al(l\')?|l\'))(?<other>\\s+altro)?\\s*{DurationUnitRegex})'
    EachPrefixRegex = f'\\b(?<each>(ogni|tutte\\s+le|tutti\\s+(gl)?i|una\\s+volta\\s+(al(l\')?|l\'))\\s*$)'
    SetEachRegex = f'\\b(?<each>(ogni|tutte\\s+le|tutti\\s+(gl)?i|una\\s+volta\\s+(al(l\')?|l\'))\\s*)'
    SetLastRegex = f'(?<last>prossim[oaei]|seguent[ei]|in\\s+arrivo|quest[oaei]|ultim[oaei]|passat[oaei]|scors[oaei]|precedent[ei]|corrent[ei])'
    EachDayRegex = f'^\\s*(ogni|tutti\\s+i)\\s+giorn[oi]\\b'
    DurationFollowedUnit = f'(^\\s*{DurationUnitRegex}\\s+{SuffixAndRegex})|(^\\s*{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex})'
    NumberCombinedWithDurationUnit = f'\\b(?<num>\\d+([\\.,]\\d*)?)(-)?\\s*{DurationUnitRegex}'
    AnUnitRegex = f'(((?<half>mezz[oa]?|metà)[-\']?|un[oa\']?|un altro|un\'altra)\\s*{DurationUnitRegex})'
    DuringRegex = f'\\b(per|durante)\\s+(il|l[a\'])\\s+(?<unit>anno|mese|settimana|giorno)\\b'
    AllRegex = f'\\b(?<all>(tutt[oa](\\s+(il|l[a\']))?|inter[oa])(\\s*|-)(?<unit>anno|mese|settimana|giorno)|(?<unit>anno|mese|settimana|giorno)\\s+inter[oa])\\b'
    HalfRegex = f'\\b((?<half>(metà|mezz[oa])\\s+(?<unit>anno|mese|settimana|giorno|ora))|(?<half>(?<unit>semestr[ei])))\\b'
    ConjunctionRegex = f'\\b((e(\\s+per)?)|con)\\b'
    HolidayRegex1 = f'\\b(?<holiday>capodanno cinese|cenone di capodanno|veglione di capodanno|(la )?vigilia di capodanno|capodanno|mercoledì delle ceneri|le ceneri|martedì grasso|primo dell\'anno|festa del papà|pesce d\'aprile|vigilia di natale|la vigilia|giorno di natale|natale|halloween|domenica di pasqua|pasqua|lunedì dell\'angelo)(\\s+((del|di)\\s+)?({YearRegex}|{RelativeRegex}\\s*anno))?\\b'
    HolidayRegex2 = f'\\b(?<holiday>giorno dei morti|i morti|tutti i santi|i santi|giorno dell\'independenza|((giorno|festa) del)?la liberazione|festa della repubblica|festa del lavoro|festa dei lavoratori)(\\s+((del|di)\\s+)?({YearRegex}|{RelativeRegex}\\s*anno))?\\b'
    HolidayRegex3 = f'(?<holiday>(giorno\\s+((di|del(la)?)\\s+)?)?(pasqua|quaresima|memoria|ringraziamento|san patrizio|festa della mamma|festa delle donne|festa della donna|san valentino|ferragosto))(\\s+((del|di)\\s+)?({YearRegex}|{RelativeRegex}\\s*anno))?'
    DateTokenPrefix = 'il '
    TimeTokenPrefix = 'alle '
    TokenBeforeDate = 'il '
    TokenBeforeTime = 'alle '
    AMTimeRegex = f'(?<am>mattin[oa]|mattinata|notte|nottata)'
    PMTimeRegex = f'\\b(?<pm>pomeriggio|sera|serata)\\b'
    BeforeRegex = f'\\b(prima(\\s+(di|del(l[\'aoei])?|degli|dei))?|entro\\s*(l[\'aoe]|il?|gli|i)?|(non\\s+dopo\\s+(il?|l[oae\']|gli)|non\\s+più\\s+tardi\\s+(di|del(l[\'aoei])?|degli|dei)|termina(no)?(\\s+con)?(\\s+(il?|l[oae\']|gli))?|precedente\\s+a((l(l[\'aoe])?)|gli|i)?|fino\\s+a((l(l[\'aoe])?)|gli|i)?))\\b'
    BeforeRegex2 = f'\\b(entro\\s*(l[\'aoe]|il?|gli|i)?)\\b'
    AfterRegex = f'\\b((?<!non\\s+)dopo\\s+(il?|l[oae\']|gli|i)(?!\\s+o uguale a)|(?<!non\\s+)(dopo|più\\s+tardi)\\s+d(i|el(l[oae\'])?|ei|egli)|(?<!non\\s+)dopo(?!\\s+o uguale a))\\b'
    SinceRegex = f'\\b(a partire\\s+da(l(l[aoe\'])?|i|gli)?|dopo\\s+(il?|l[aoe\']|gli)|da(l(l[aoe\'])?|i|gli)?(?!(.+(\\s+(fino\\s+)?a(gli|i|l(l[aoe\'])?)?\\b)|\\s*\\d+\\s*\\-\\s*\\d+(?!(\\s*-))))|(dopo|successiv[oaei])\\s+o\\s+uguale\\s+a((l(l[\'aoe])?)|gli|i)?)\\b'
    AroundRegex = f'(\\b(intorno\\s+a(l(l[\'aoe])?|gli|i)?|verso\\s+(il|l[aoe\']|gli|i))\\s*\\b)'
    AgoPrefixRegex = f'\\b(di)\\b'
    LaterRegex = f'\\b(dopo|da\\s+adesso|da\\s+questo\\s+momento)\\b'
    AgoRegex = f'\\b(fa|prima|addietro)\\b'
    BeforeAfterRegex = f'^[.]'
    InConnectorRegex = f'\\b(in|tra|fra|a)\\b'
    SinceYearSuffixRegex = f'(^\\s*{SinceRegex}\\s*(ann[oi]\\s*)?({DateYearRegex}|{FullTextYearRegex}))'
    WithinNextPrefixRegex = f'\\b(entro(\\s+(?<next>{NextPrefixRegex}))?)\\b'
    TodayNowRegex = f'\\b(oggi|adesso)\\b'
    MorningStartEndRegex = f'(^(((di\\s+|questa\\s+|sta)?mattin[oa]|mattinata)|{AmDescRegex}))|((((di\\s+|questa\\s+|sta)?mattin[oa]|mattinata)|{AmDescRegex})$)'
    AfternoonStartEndRegex = f'(^((((di|al)\\s+|questo\\s+|sto)?pomeriggio)|{PmDescRegex}))|(((((di|il)\\s+|questo\\s+|sto)?pomeriggio)|{PmDescRegex})$)'
    EveningStartEndRegex = f'(^((di\\s+|questa\\s+|sta)?sera|serata))|(((di\\s+|questa\\s+|sta)?sera|serata)$)'
    NightStartEndRegex = f'(^((di\\s+|questa\\s+|sta)?notte|nottata))|(((di\\s+|questa\\s+|sta)?notte|nottata)$)'
    InexactNumberRegex = f'\\b(un\\s+po\'\\s+di|alcun[ei]|qualche|parecchie?|divers[ie]|molt[oaei]|poc[oa]|poch[ei])\\b'
    InexactNumberUnitRegex = f'\\b((({InexactNumberRegex}\\s+|(?<=(prossim[ei]|scors[ei]|ultim[ei])\\s+)){DurationUnitRegex})|({DurationUnitRegex}(?=\\s+(seguenti|successiv[ei]|passat[ei]|precedent[ei]))))\\b'
    InexactNumberUnitRegex2 = f'\\b({InexactNumberRegex}\\s+{DurationUnitRegex}|(?<unit>decenni|anni|mesi|settimane|giorni|ore|minuti|secondi))'
    RelativeTimeUnitRegex = f'(((({ThisPrefixRegex}|{NextPrefixRegex}|{PreviousPrefixRegex})\\s+{TimeUnitRegex})|({ThisPrefixRegex}\\s+)?{TimeUnitRegex}\\s+({NextSuffixRegex}|{PastSuffixRegex}))|\\b(le|i|miei?)\\s+({RestrictedTimeUnitRegex}))'
    RelativeDurationUnitRegex = f'(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+)({DurationUnitRegex}))|(({DurationUnitRegex})(?=\\s+({NextSuffixRegex}|{PastSuffixRegex}|{ThisPrefixRegex})))|((le|i|miei?))\\s+({RestrictedTimeUnitRegex}))'
    ReferenceDatePeriodRegex = f'\\b((quel(l[a\'])?)|((l[oa]\\s+)?stess[oa]))\\s+(?<duration>settimana|mese|anno|decennio|finesettimana|weekend)\\b'
    ConnectorRegex = f'^\\s*(-|,|t|per l[e\']|all[e\']|intorno all[e\']|verso l[e\'])\\s*$'
    ConnectorAndRegex = f'\\b(e(\\s+(il?|l[oae\']|gli))?)\\b.*'
    FromRegex = f'\\b(da(l(l[oae\'])?|i|gli)?)$'
    FromRegex2 = f'\\b(dopo(\\s*l[oae\']|il?)?)$'
    FromToRegex = f'\\b(da(l(l[oae\'])?|i|gli)?).+(a(l(l[oae\'])?|i|gli)?)\\b.+'
    SingleAmbiguousMonthRegex = f'(march)'
    SingleAmbiguousTermsRegex = f'(?<!l\')una\\b'
    UnspecificDatePeriodRegex = f'^(settimana|finesettimana|weekend|mese|anno)$'
    PrepositionSuffixRegex = f'\\b(il|al?|del|di|dal?|fino al?)$'
    FlexibleDayRegex = f'(?<DayOfMonth>({WrittenDayRegex}|{DayRegex}))'
    ForTheRegex = f'\\b((((?<=per\\s+il\\s+){FlexibleDayRegex})|((?<!(\\b{MonthRegex},?|\\bper)\\s+(il\\s+|l\'))(?<=(il\\s+|l\')){FlexibleDayRegex}))(?<end>\\s*(,|\\.|!|\\?|$)))'
    WeekDayAndDayOfMonthRegex = f'\\b{WeekDayRegex},?\\s+((il\\s+)?{FlexibleDayRegex})\\b(?!\\s+{MonthRegex}\\b)'
    WeekDayAndDayRegex = f'\\b{WeekDayRegex}\\s*,?\\s+(?!(il|l\')){DayRegex}(?!([-:]|(\\s+({AmDescRegex}|{{PmDescRegex|{OclockRegex}}}))))\\b'
    RestOfDateRegex = f'\\bresto\\s+((di|del(l[a\'])?)\\s*)?((quest[oa\']|corrente|mia)\\s*)?(?<duration>settimana|mese|anno|decennio)(\\s+corrente)?\\b'
    RestOfDateTimeRegex = f'\\bresto\\s+((di|del(la)?)\\s+)?((quest[oa]|corrente|mi[oa])\\s+)?(?<unit>giorn(o|ata))(\\s+corrente)?\\b'
    SuffixAfterRegex = f'\\b(((a)\\s)?(o|e)\\s+(sopra|dopo|più\\s+tardi|più\\s+grande)(?!\\s+di))\\b'
    LaterEarlyPeriodRegex = f'\\b((({PrefixPeriodRegex})(\\s+(di|del(l[ao\'])?))?)\\s*\\b\\s*(?<suffix>{OneWordPeriodRegex})|({UnspecificEndOfRangeRegex}))\\b'
    WeekWithWeekDayRangeRegex = f'\\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|questa)\\s+settimana)((\\s+[tf]ra\\s+{WeekDayRegex}\\s+e\\s+{WeekDayRegex})|(\\s+da\\s+{WeekDayRegex}\\s+a\\s+{WeekDayRegex})))\\b'
    GeneralEndingRegex = f'^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$'
    MiddlePauseRegex = f'\\s*(,)\\s*'
    DurationConnectorRegex = f'^\\s*(?<connector>\\s+|e|,)\\s*$'
    PrefixArticleRegex = f'\\b(il?|l[oae\']|gli)\\s*'
    OrRegex = f'\\s*(o|oppure)\\s*'
    YearPlusNumberRegex = f'\\b(anno\\s+((?<year>(\\d{{3,4}}))|{FullTextYearRegex}))\\b'
    NumberAsTimeRegex = f'\\b({EngTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\\b'
    TimeBeforeAfterRegex = f'\\b(((?<=\\b(prima (di|dell[e\'])|non prima (di|dell[e\'])|per(\\s+l[e\'])?|dopo(\\s+l[e\'])?)\\s*)({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b'
    DateNumberConnectorRegex = f'^\\s*(?<connector>(,)?\\s+(il|all[e\']|(verso|per) l[e\']|intorno all[e\']))\\s*$'
    DateAfterRegex = f'\\b((e|o)\\s+(dopo|passato|oltre))\\b'
    YearPeriodRegex = f'(((dal|durante|nel|[tf]ra)\\s+(il\\s+)?)?{YearRegex}\\s*{TillRegex}\\s*{YearRegex})'
    FutureSuffixRegex = f'\\b(((in|nel)\\s+)?(futuro|seguito))|(da\\s+questo\\s+momento)\\b'
    ModPrefixRegex = f'\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b'
    ModSuffixRegex = f'\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b'
    ComplexDatePeriodRegex = f'(((da(l(l[aeo\'])?|i)?|durante|in|nel(l[aeo\'])?|negli)\\s*)?(?<start>.+)\\s*({TillRegex})\\s*(?<end>.+)|(([tf]ra)\\s+)(?<start>.+)\\s*({RangeConnectorRegex})\\s*(?<end>.+))'
    AmbiguousPointRangeRegex = f'^(mar)$'
    UnitMap = dict([("decenni", "10Y"),
                    ("decennio", "10Y"),
                    ("anni", "Y"),
                    ("anno", "Y"),
                    ("semestre", "Y"),
                    ("semestri", "Y"),
                    ("mesi", "MON"),
                    ("mese", "MON"),
                    ("settimane", "W"),
                    ("settimana", "W"),
                    ("giorni", "D"),
                    ("giorno", "D"),
                    ("giornata", "D"),
                    ("ore", "H"),
                    ("ora", "H"),
                    ("hrs", "H"),
                    ("hr", "H"),
                    ("h", "H"),
                    ("minuti", "M"),
                    ("minuto", "M"),
                    ("mins", "M"),
                    ("min", "M"),
                    ("secondi", "S"),
                    ("secondo", "S"),
                    ("secs", "S"),
                    ("sec", "S")])
    UnitValueMap = dict([("decenni", 315360000),
                         ("decennio", 315360000),
                         ("anni", 31536000),
                         ("anno", 31536000),
                         ("semestre", 31536000),
                         ("mesi", 2592000),
                         ("mese", 2592000),
                         ("settimane", 604800),
                         ("settimana", 604800),
                         ("giorni", 86400),
                         ("giorno", 86400),
                         ("ore", 3600),
                         ("ora", 3600),
                         ("hrs", 3600),
                         ("hr", 3600),
                         ("h", 3600),
                         ("minuti", 60),
                         ("minuto", 60),
                         ("mins", 60),
                         ("min", 60),
                         ("secondi", 1),
                         ("secondo", 1),
                         ("secs", 1),
                         ("sec", 1)])
    SpecialYearPrefixesMap = dict([("fiscale", "FY"),
                                   ("scolastico", "SY")])
    SeasonMap = dict([("primavera", "SP"),
                      ("estate", "SU"),
                      ("autunno", "FA"),
                      ("inverno", "WI")])
    SeasonValueMap = dict([("SP", 3),
                           ("SU", 6),
                           ("FA", 9),
                           ("WI", 12)])
    CardinalMap = dict([("primo", 1),
                        ("prima", 1),
                        ("secondo", 2),
                        ("seconda", 2),
                        ("terzo", 3),
                        ("terza", 3),
                        ("quarto", 4),
                        ("quarta", 4),
                        ("quinto", 5),
                        ("quinta", 5)])
    DayOfWeek = dict([("lunedì", 1),
                      ("martedì", 2),
                      ("mercoledì", 3),
                      ("giovedì", 4),
                      ("venerdì", 5),
                      ("sabato", 6),
                      ("sabati", 6),
                      ("domenica", 0),
                      ("domeniche", 0),
                      ("lun", 1),
                      ("mar", 2),
                      ("mer", 3),
                      ("gio", 4),
                      ("ven", 5),
                      ("sab", 6),
                      ("dom", 0),
                      ("monday", 1),
                      ("tuesday", 2),
                      ("wednesday", 3),
                      ("thursday", 4),
                      ("friday", 5),
                      ("saturday", 6),
                      ("sunday", 0),
                      ("mon", 1),
                      ("tue", 2),
                      ("tues", 2),
                      ("wed", 3),
                      ("wedn", 3),
                      ("weds", 3),
                      ("thu", 4),
                      ("thur", 4),
                      ("thurs", 4),
                      ("fri", 5),
                      ("sat", 6),
                      ("sun", 0)])
    MonthOfYear = dict([("gennaio", 1),
                        ("febbraio", 2),
                        ("marzo", 3),
                        ("aprile", 4),
                        ("maggio", 5),
                        ("giugno", 6),
                        ("luglio", 7),
                        ("agosto", 8),
                        ("settembre", 9),
                        ("ottobre", 10),
                        ("novembre", 11),
                        ("dicembre", 12),
                        ("gen", 1),
                        ("feb", 2),
                        ("mar", 3),
                        ("apr", 4),
                        ("mag", 5),
                        ("giu", 6),
                        ("lug", 7),
                        ("ago", 8),
                        ("set", 9),
                        ("sett", 9),
                        ("ott", 10),
                        ("nov", 11),
                        ("dic", 12),
                        ("1", 1),
                        ("2", 2),
                        ("3", 3),
                        ("4", 4),
                        ("5", 5),
                        ("6", 6),
                        ("7", 7),
                        ("8", 8),
                        ("9", 9),
                        ("10", 10),
                        ("11", 11),
                        ("12", 12),
                        ("01", 1),
                        ("02", 2),
                        ("03", 3),
                        ("04", 4),
                        ("05", 5),
                        ("06", 6),
                        ("07", 7),
                        ("08", 8),
                        ("09", 9)])
    Numbers = dict([("zero", 0),
                    ("uno", 1),
                    ("un", 1),
                    ("una", 1),
                    ("due", 2),
                    ("tre", 3),
                    ("quattro", 4),
                    ("cinque", 5),
                    ("sei", 6),
                    ("sette", 7),
                    ("otto", 8),
                    ("nove", 9),
                    ("dieci", 10),
                    ("undici", 11),
                    ("dodici", 12),
                    ("tredici", 13),
                    ("quattordici", 14),
                    ("quindici", 15),
                    ("sedici", 16),
                    ("diciassette", 17),
                    ("diciotto", 18),
                    ("diciannove", 19),
                    ("venti", 20),
                    ("ventuno", 21),
                    ("ventidue", 22),
                    ("ventitre", 23),
                    ("ventiquattro", 24),
                    ("venticinque", 25),
                    ("ventisei", 26),
                    ("ventisette", 27),
                    ("ventotto", 28),
                    ("ventinove", 29),
                    ("trenta", 30),
                    ("trentuno", 31),
                    ("trentadue", 32),
                    ("trentatre", 33),
                    ("trentaquattro", 34),
                    ("trentacinque", 35),
                    ("trentasei", 36),
                    ("trentasette", 37),
                    ("trentotto", 38),
                    ("trentanove", 39),
                    ("quaranta", 40),
                    ("quarantuno", 41),
                    ("quarantadue", 42),
                    ("quarantatre", 43),
                    ("quarantaquattro", 44),
                    ("quarantacinque", 45),
                    ("quarantasei", 46),
                    ("quarantasette", 47),
                    ("quarantotto", 48),
                    ("quarantanove", 49),
                    ("cinquanta", 50),
                    ("cinquantuno", 51),
                    ("cinquantadue", 52),
                    ("cinquantatre", 53),
                    ("cinquantaquattro", 54),
                    ("cinquantacinque", 55),
                    ("cinquantasei", 56),
                    ("cinquantasette", 57),
                    ("cinquantotto", 58),
                    ("cinquantanove", 59),
                    ("sessanta", 60),
                    ("sessantuno", 61),
                    ("sessantadue", 62),
                    ("sessantatre", 63),
                    ("sessantaquattro", 64),
                    ("sessantacinque", 65),
                    ("sessantasei", 66),
                    ("sessantasette", 67),
                    ("sessantotto", 68),
                    ("sessantanove", 69),
                    ("settanta", 70),
                    ("settantuno", 71),
                    ("settantadue", 72),
                    ("settantatre", 73),
                    ("settantaquattro", 74),
                    ("settantacinque", 75),
                    ("settantasei", 76),
                    ("settantasette", 77),
                    ("settantotto", 78),
                    ("settantanove", 79),
                    ("ottanta", 80),
                    ("ottantuno", 81),
                    ("ottantadue", 82),
                    ("ottantatre", 83),
                    ("ottantaquattro", 84),
                    ("ottantacinque", 85),
                    ("ottantasei", 86),
                    ("ottantasette", 87),
                    ("ottantotto", 88),
                    ("ottantanove", 89),
                    ("novanta", 90),
                    ("novantuno", 91),
                    ("novantadue", 92),
                    ("novantatre", 93),
                    ("novantaquattro", 94),
                    ("novantacinque", 95),
                    ("novantasei", 96),
                    ("novantasette", 97),
                    ("novantotto", 98),
                    ("novantanove", 99),
                    ("cento", 100)])
    DayOfMonth = dict([("1", 1),
                       ("2", 2),
                       ("3", 3),
                       ("4", 4),
                       ("5", 5),
                       ("6", 6),
                       ("7", 7),
                       ("8", 8),
                       ("9", 9),
                       ("10", 10),
                       ("11", 11),
                       ("12", 12),
                       ("13", 13),
                       ("14", 14),
                       ("15", 15),
                       ("16", 16),
                       ("17", 17),
                       ("18", 18),
                       ("19", 19),
                       ("20", 20),
                       ("21", 21),
                       ("22", 22),
                       ("23", 23),
                       ("24", 24),
                       ("25", 25),
                       ("26", 26),
                       ("27", 27),
                       ("28", 28),
                       ("29", 29),
                       ("30", 30),
                       ("31", 31)])
    DoubleNumbers = dict([("mezzo", 0.5),
                          ("mezza", 0.5),
                          ("metà", 0.5),
                          ("quarto", 0.25),
                          ("quarti", 0.25)])
    HolidayNames = dict([("easterday", ["pasqua", "giornodipasqua", "domenicadipasqua"]),
                         ("eastermonday", ["lunedidell'angelo"]),
                         ("fathersday", ["festadelpap\u00e0"]),
                         ("mothersday", ["festadellamamma"]),
                         ("memorialday", ["giornodellamemoria"]),
                         ("mardigras", ["martedigrasso"]),
                         ("ashwednesday", ["mercoledidelleceneri", "leceneri"]),
                         ("allsaintsday", ["tuttiisanti", "isanti"]),
                         ("allsoulsday", ["giornodeimorti", "imorti"]),
                         ("femaleday", ["festadelladonna", "festadelledonne"]),
                         ("ferragosto", ["ferragosto"]),
                         ("christmas", ["giornodinatale", "natale"]),
                         ("christmaseve", ["vigiliadinatale", "lavigilia"]),
                         ("newyear", ["capodannocinese", "capodanno"]),
                         ("valentinesday", ["sanvalentino"]),
                         ("stpatrickday", ["giornodisanpatrizio"]),
                         ("aprilfools", ["pescedaprile"]),
                         ("labourday", ["festadeilavoratori", "festadellavoro"]),
                         ("independenceday", ["giornodell'indipendenza"]),
                         ("liberationday", ["giornodellaliberazione", "festadellaliberazione", "laliberazione"]),
                         ("republicday", ["festadellarepubblica"]),
                         ("halloweenday", ["halloween"]),
                         ("newyeareve", ["cenonedicapodoanno", "veglionedicapodanno", "lavigiliadicapodanno", "vigiliadicapodanno"]),
                         ("thanksgiving", ["giornodelringraziamento", "ringraziamento"])])
    WrittenDecades = dict([("dieci", 10),
                           ("venti", 20),
                           ("trenta", 30),
                           ("quaranta", 40),
                           ("cinquanta", 50),
                           ("sessanta", 60),
                           ("settanta", 70),
                           ("ottanta", 80),
                           ("novanta", 90)])
    SpecialDecadeCases = dict([("questo secolo", 2000),
                               ("duemila", 2000)])
    DefaultLanguageFallback = 'DMY'
    DurationDateRestrictions = []
    AmbiguityFiltersDict = dict([("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"),
                                 ("\\bgiorno|pomeriggio|sera|notte\\b", "\\b(buona?\\s*(giorno|pomeriggio|sera|notte))\\b"),
                                 ("^(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)$", "([$%£&!?@#])(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)|(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)([$%£&@#])"),
                                 ("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}"),
                                 ("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")])
    MorningTermList = [r'mattino', r'mattina', r'mattine', r'mattinata']
    AfternoonTermList = [r'pomeriggio', r'pomeriggi', r'dopo pranzo']
    EveningTermList = [r'sera', r'sere', r'serata']
    DaytimeTermList = [r'giorno', r'dì', r'giornata']
    NightTermList = [r'notte', r'notti', r'nottata']
    SameDayTerms = [r'oggi']
    PlusOneDayTerms = [r'domani', r'giorno dopo']
    MinusOneDayTerms = [r'ieri', r'giorno prima']
    PlusTwoDayTerms = [r'dopodomani', r'domani l\'altro']
    MinusTwoDayTerms = [r'l\'altroieri', r'altroieri']
    FutureStartTerms = [r'questo', r'questa', r'questi', r'queste', r'quest\'', r'prossimo', r'prossima', r'prossimi', r'prossime', r'prossim\'']
    FutureEndTerms = [r'prossimo', r'prossima', r'prossimi', r'prossime', r'prossim\'']
    LastCardinalTerms = [r'ultimo', r'ultima', r'ultimi', r'ultime', r'ultim\'', r'l\'ultimo', r'l\'ultima', r'l\'ultimi', r'l\'ultime', r'l\'ultim\'']
    MonthTerms = [r'mese', r'mesi']
    MonthToDateTerms = [r'dall\'inizio del mese']
    WeekendTerms = [r'finesettimana', r'weekend']
    WeekTerms = [r'settimana', r'settimane']
    YearTerms = [r'anno', r'anni', r'annata', r'annate']
    YearToDateTerms = [r'dall\'inizio dell\'anno', r'da inizio anno']
# pylint: enable=line-too-long
