# ------------------------------------------------------------------------------
# <auto-generated>
#     This code was generated by a tool.
#     Changes to this file may cause incorrect behavior and will be lost if
#     the code is regenerated.
# </auto-generated>
#
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# ------------------------------------------------------------------------------

from .base_date_time import BaseDateTime
# pylint: disable=line-too-long


class GermanDateTime:
    LangMarker = 'Ger'
    CheckBothBeforeAfter = False
    TillRegex = f'(?<till>zu|bis\\s*zum|zum|bis|bis\\s*hin(\\s*zum)?|--|-|—|——)'
    RangeConnectorRegex = f'(?<and>und|--|-|—|——)'
    RelativeRegex = f'\\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|vorletzte[snm]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?|de[rmsn]|das(?!\\s+tag)|am)'
    StrictRelativeRegex = f'\\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?)'
    UpcomingPrefixRegex = f'.^'
    NextPrefixRegex = f'\\b((über)?nächste[rmns]?|kommende[rns]?|{UpcomingPrefixRegex})\\b'
    AfterNextPrefixRegex = f'\\bübernächste[rmns]?\\b'
    PastPrefixRegex = f'.^'
    PreviousPrefixRegex = f'\\b(letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vor(ige[rns]?)?|{PastPrefixRegex})\\b'
    ThisPrefixRegex = f'\\b(diese[rnms]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?)\\b'
    RangePrefixRegex = f'(vo[nm]|zwischen)'
    PenultimatePrefixRegex = f'\\b(vorletzte[snm]?)\\b'
    WrittenOneToNineRegex = f'(eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun)'
    DayRegex = f'(de[rmsn]\\s*)?(?<day>(01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(\\.|\\b))'
    WrittenDayNumRegex = f'\\b(de[rmsn]\\s+)?(?<day>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zwölft|zwoelft|dreizehnt|vierzehnt|fünfzehnt|fuenfzehnt|sechzehnt|siebzehnt|achtzehnt|neunzehnt|({WrittenOneToNineRegex}und)?zwanzigst|(einund)?dreißigst)e[nr]\\b'
    MonthNumRegex = f'(?<month>(01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)(\\.|\\b))'
    WrittenMonthNumRegex = f'\\b(?<month>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zw(ö|oe)lft)e[nr]\\b'
    AmDescRegex = f'({BaseDateTime.BaseAmDescRegex})'
    PmDescRegex = f'({BaseDateTime.BasePmDescRegex})'
    AmPmDescRegex = f'({BaseDateTime.BaseAmPmDescRegex})'
    OclockRegex = f'(?<oclock>uhr)'
    DescRegex = f'({OclockRegex})'
    TwoDigitYearRegex = f'\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b'
    CenturyRegex = f'\\b(?<century>((ein|zwei)?tausend(und)?)?((ein|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf|zwölf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn)hundert))\\b'
    WrittenNumRegex = f'(zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig|elf|zehn|{WrittenOneToNineRegex})'
    FullTextYearRegex = f'\\b((?<firsttwoyearnum>{CenturyRegex})\\s+(?<lasttwoyearnum>((zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig)\\s+{WrittenNumRegex})|{WrittenNumRegex}))\\b|\\b(?<firsttwoyearnum>{CenturyRegex})\\b'
    YearRegex = f'({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})'
    WeekDayRegex = f'(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\\.|\\b))'
    SingleWeekDayRegex = f'\\b(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\\.|\\b))'
    RelativeMonthRegex = f'(?<relmonth>{RelativeRegex}\\s+monat(s)?)'
    WrittenMonthRegex = f'((monat\\s*)?(?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|j[äa]n(uar|ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.)))'
    MonthSuffixRegex = f'(?<msuf>(im\\s*|des\\s*)?({RelativeMonthRegex}|{WrittenMonthRegex}|{MonthNumRegex}))'
    DateUnitRegex = f'(?<unit>tg|woche(?<plural>n)?|(jahr|monat|tag)(?<plural>e)?)(s)?'
    HalfTokenRegex = f'^(halb)'
    QuarterToTokenRegex = f'^(viertel\\s+vor|dreiviertel)\\s*$'
    QuarterPastTokenRegex = f'^(viertel\\s+nach)\\s*$'
    ThreeQuarterToTokenRegex = f'^(viertel|dreiviertel\\s+vor)\\s*$'
    ThreeQuarterPastTokenRegex = f'^(dreiviertel\\s+nach)\\s*$'
    SimpleCasesRegex = f'((vom|zwischen)\\s+)?({DayRegex})(\\s*{MonthSuffixRegex})?\\s*{TillRegex}\\s*({DayRegex})(\\s*{MonthSuffixRegex})?((\\s+|\\s*,\\s*){YearRegex})?'
    MonthFrontSimpleCasesRegex = f'((vom|zwischen)\\s*)?{MonthSuffixRegex}\\s*((vom|zwischen)\\s*)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?'
    MonthFrontBetweenRegex = f'({MonthSuffixRegex}\\s+(zwischen\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?)'
    BetweenRegex = f'((zwischen\\s+)({DayRegex})(\\s+{MonthSuffixRegex})?\\s*{RangeConnectorRegex}\\s*({DayRegex})(\\s+{MonthSuffixRegex})((\\s+|\\s*,\\s*){YearRegex})?|(zwischen\\s+)({DayRegex})(\\s+{MonthSuffixRegex})?\\s*{RangeConnectorRegex}\\s*({DayRegex})(\\s+{MonthSuffixRegex})?((\\s+|\\s*,\\s*){YearRegex})?)'
    MonthWithYear = f'\\b((?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|januar|j[äa]n(ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.))(\\s*),?(\\s+des)?(\\s*)({YearRegex}|{TwoDigitYearRegex}|(?<order>nächste[mn]|letzte[mn]|diese(s|n))\\s+jahres))'
    OneWordPeriodRegex = f'\\b((((im\\s+)?monat\\s+)?({RelativeRegex}\\s*(jahr\\s*(im\\s*)?)?)?(?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|j[äa]n(uar|ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.)))|(?<business>unter\\s+der\\s+woche)|({RelativeRegex}\\s+)?((?<business>werktags|arbeitswoche)|woche(nende)?|monat(s)?|jahr|jahres)(?!(\\s+\\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\\s+bis\\s+heute)))\\b'
    MonthNumWithYear = f'({YearRegex}(\\s*)[/\\-\\.](\\s*){MonthNumRegex})|({MonthNumRegex}(\\s*)[/\\-\\.](\\s*){YearRegex})'
    WeekOfMonthRegex = f'(?<wom>((die|der)\\s+)(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+woche\\s+(des|diese(s|n)|im)\\s+({MonthSuffixRegex}|monat(s)?))'
    WeekOfYearRegex = f'(?<woy>((die|der)\\s+)?(?<cardinal>(erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+woche\\s+(im|diese(s|n)|\\s+des)?\\s+({YearRegex}|{RelativeRegex}\\s+jahr(en|es|e)?)))'
    OfYearRegex = f'\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b'
    FirstLastRegex = f'\\b(the\\s+)?((?<first>first)|(?<last>last))\\b'
    FollowedDateUnit = f'^\\s*{DateUnitRegex}'
    NumberCombinedWithDateUnit = f'\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}'
    QuarterRegex = f'((das|im|in dem|dem)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.)\\s+quartal(\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex})'
    QuarterRegexYearFront = f'(?!)#({YearRegex}|{RelativeRegex}\\s+year)\\s+(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)\\s+quarter'
    AllHalfYearRegex = f'((das|im|in dem|dem)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.)\\s+(halbjahr|hälfte)(\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex})'
    PrefixDayRegex = f'((?<EarlyPrefix>früh)|(?<MidPrefix>mitten|in der mitte)|(?<LatePrefix>spät(er)?))(\\s+am\\s+tag)?(\\s+des\\s+tages)?$'
    CenturySuffixRegex = f'(^jahrhundert)\\b'
    ReferencePrefixRegex = f'((gleich(e|en))|(selb(e|en)))\\b'
    SeasonRegex = f'\\b(?<season>({RelativeRegex}\\s+)?(?<seas>frühling|sommer|herbst|winter)((\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+jahr(e(s)?)?))?)\\b'
    WhichWeekRegex = f'\\b(week)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])\\b'
    WeekOfRegex = f'(die\\s+)?(woche)(\\s+des)'
    MonthOfRegex = f'(monat)(\\s*)(des)'
    MonthRegex = f'(?<month>apr((il)?\\b|\\.)|aug((ust)?\\b|\\.)|dez((ember)?\\b|\\.)|feb((ruar|ber)?\\b|\\.)|januar|j[äa]n((ner)?\\b|\\.)|jul((e?i|l)?\\b|l\\.)|jun([io]?\\b|\\.)|märz|mai|nov((ember)?\\b|\\.)|okt((ober)?\\b|\\.)|sept?((ember)?\\b|\\.))'
    DateYearRegex = f'(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})'
    OnRegex = f'(?<=\\bam\\s+)({DayRegex}s?)\\b'
    RelaxedOnRegex = f'(?<=\\b(am|an dem)\\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)([\\.]))'
    ThisRegex = f'(((diese((n|m)|(\\s*woche))(\\s*am)?\\s+){WeekDayRegex})|diese(n|r)?\\s*(sommer|winter|frühling|herbst))'
    LastDateRegex = f'({PreviousPrefixRegex}(\\s*(woche|monat|jahr)?(\\s*(am|im))?)?\\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\\s+)?{WeekDayRegex}(\\s+{PreviousPrefixRegex}\\s*woche))'
    NextDateRegex = f'({NextPrefixRegex}(\\s*(woche|monat|jahr)?(\\s*(am|im))?)?\\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\\s+)?{WeekDayRegex}(\\s+{NextPrefixRegex}\\s*woche))'
    SpecialDayRegex = f'\\b(vorgestern|übermorgen|((der\\s+)?{RelativeRegex}\\s+(tag(s|es)?|(?<!\\bam\\s+)morgen))|\\bgestern\\b|\\bmorgen\\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?))'
    SpecialDayWithNumRegex = f'\\b((?<number>{WrittenNumRegex})\\s+tage?\\s+(von|nach|ab)\\s+(?<day>\\bgestern\\b|\\bmorgen\\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?)))\\b'
    RelativeDayRegex = f'\\b((((de[rmns])\\s+)?{RelativeRegex}\\s+tag(e(s)?)?))'
    SetWeekDayRegex = f'\\b(?<prefix>(an|immer)\\s+)?(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend)(s|en)\\b'
    WeekDayOfMonthRegex = f'\\b(?<wom>((an( dem)?|de[rs]|am)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+{WeekDayRegex}\\s+{MonthSuffixRegex})\\b'
    RelativeWeekDayRegex = f'\\b({WrittenNumRegex}\\s+{WeekDayRegex}e\\s+(von\\s+jetzt|später))\\b'
    SpecialDate = f'(?=\\b(an( dem)?|am)\\s+){DayRegex}\\b'
    DateExtractor1 = f'\\b(({WeekDayRegex})(\\s+|\\s*,\\s*))?({DayRegex}\\s*[/\\\\.,\\- ]\\s*{MonthRegex}(\\s*[/\\\\.,\\- ]\\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\.,\\- ]\\s*{DayRegex}\\s*[/\\\\.,\\- ]\\s*{MonthRegex})\\b'
    DateExtractor2 = f'\\b({MonthRegex}\\s*[/\\\\.,\\- ]\\s*{DayRegex}(?!\\s*\\-\\s*\\d{{2}}\\b)(\\s*[/\\\\.,\\- ]\\s*{DateYearRegex})?)\\b'
    DateExtractor3 = f'\\b({DayRegex}{MonthRegex})'
    DateExtractor4 = f'\\b({DayRegex}\\s*{MonthNumRegex}\\s*{DateYearRegex})\\b'
    DateExtractor5 = f'\\b(({WeekDayRegex})(\\s+|\\s*,\\s*))?({DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex})\\b(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    DateExtractor6 = f'^[.]'
    DateExtractor7 = f'({DayRegex}\\s*[\\.]\\s*{MonthNumRegex}[\\.]){BaseDateTime.CheckDecimalRegex}'
    DateExtractor8 = f'(?<=\\b(am)\\s+){DayRegex}[/\\\\\\.]{MonthNumRegex}([/\\\\\\.]{DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b'
    DateExtractor9 = f'\\b({DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*){DateYearRegex})?){BaseDateTime.CheckDecimalRegex}\\b'
    DateExtractor10 = f'^[.]'
    DateExtractor11 = f'\\b(({WeekDayRegex})(\\s+|\\s*,\\s*)|(?<=\\bam\\s+))({DayRegex}\\.|{WrittenDayNumRegex})\\s*[/\\\\.\\- ]\\s*({MonthNumRegex}\\.|{WrittenMonthNumRegex})(\\s*[/\\\\.\\- ]\\s*{DateYearRegex})?'
    DateExtractorA = f'({DateYearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})(?!\\s*[/\\\\\\-\\.:]\\s*\\d+)'
    OfMonth = f'^(\\s*des\\s*|\\s*)?{MonthRegex}'
    MonthEnd = f'{MonthRegex}\\s*(de[rmn])?\\s*$'
    WeekDayEnd = f'{WeekDayRegex}\\s*,?\\s*$'
    WeekDayStart = f'^\\s+(am\\s+)?{WeekDayRegex}\\b'
    RangeUnitRegex = f'(?<unit>jahren?|jahr|monaten?|monat|wochen?|tagen?|tag)'
    HourNumRegex = f'\\b(?<hournum>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|\'null\'|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)\\b'
    MinuteNumRegex = f'(?<minnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)'
    DeltaMinuteNumRegex = f'(?<deltaminnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)'
    PmRegex = f'\\b((am|gegen|in der)\\s+)?(?<pm>(((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?|\\bmittags?|((in der )?nachts?)))'
    PmRegexFull = f'\\b((am|gegen|in der)\\s+)?(?<pm>(((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?|\\bmittags?|((in der )?nachts?)))'
    AmRegex = f'(?<am>(((früh|spät)\\s*)?morgens|((am|gegen)\\s+)?(früh|vormittags?)|(am|gegen)\\s+morgen))'
    LunchRegex = f'\\b(mittag(essen|s)?)\\b'
    NightRegex = f'\\b(mitternacht|(nachts?|primetime|abends?))\\b'
    AmPmPrefixRegex = f'\\b((((um|gegen)\\s*)?(?<suffix>(((?<am>am morgen)|((früh|spät)\\s*)?morgens|früh|(vor|nach)mittags?)|(?<pm>((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?))|(in der\\s*)?(?<pm>nachts?)))\\s*(um|gegen|von)\\s*)'
    CommonDatePrefixRegex = f'^[\\.]'
    LessThanOneHour = f'\\b(?<lth>(ein(er?)?\\s+)?((drei)?viertel|halb(en?)?)(\\s*stunden?)?)|{BaseDateTime.DeltaMinuteRegex}(\\s+(min(uten?)?))|{DeltaMinuteNumRegex}(\\s+(min(uten?)?))'
    WrittenTimeRegex = f'(um\\s*)?(?<writtentime>{HourNumRegex}(\\s*{OclockRegex}\\s*)({MinuteNumRegex}|{MinuteNumRegex}und(?<tens>zwanzig|dreißig|vierzig|fünfzig)))'
    TimePrefix = f'(?<prefix>({LessThanOneHour})(\\s*(vor(\\W)?|nach(\\W)?))?)'
    TimeSuffix = f'(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})'
    TimeSuffixFull = f'(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex}|\\b(?<pm>nachmittag(s)?|nacht(s)?|abend(s)?))'
    BasicTime = f'(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(:|\\s+uhr(\\s+und)?\\s+){BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|\\b{BaseDateTime.HourRegex}(?![%\\d]))'
    MidnightRegex = f'(?<midnight>mitte(r|n in der )nachts?)'
    MidmorningRegex = f'(?<midmorning>mitten am vormittag)'
    MidafternoonRegex = f'(?<midafternoon>mitten am nachmittag)'
    MiddayRegex = f'((?<midday>(am\\s+)?mittag(s(zeit)?)?)|(?<midday>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)(mittags?)))'
    MidTimeRegex = f'(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))'
    AtRegex = f'(((?<=\\b(um|gegen)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?![%\\d])|{MidTimeRegex}))|{MidTimeRegex})\\b'
    IshRegex = f'\\b(noonish)\\b'
    TimeUnitRegex = f'(?<unit>(stunde|minute|sekunde)(?<plural>n)?|std?|min|sek|h|s)\\b'
    RestrictedTimeUnitRegex = f'(?<unit>stunde|minute)\\b'
    FivesRegex = f'(?<tens>(fünfzehn|(fünfund)?(zwanzig?|dreißig|vierzig|fünfzig)|zehn|fünf))\\b'
    HourRegex = f'\\b{BaseDateTime.HourRegex}'
    PeriodHourNumRegex = f'(?<hour>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|\'null\'|eins?|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf)\\b'
    ConnectNumRegex = f'{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex}'
    TimeRegex1 = f'({TimePrefix}\\s+)?({WrittenTimeRegex}(\\s*{DescRegex})?|({HourNumRegex}|{BaseDateTime.HourRegex}\\b)\\s*{DescRegex})'
    TimeRegex2 = f'({TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?(:|\\s+uhr(\\s+und)?\\s+)(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?((\\s*{DescRegex})|\\b)'
    TimeRegex3 = f'({TimePrefix}\\s+)?{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})'
    TimeRegex4 = f'({TimePrefix}\\s*{BasicTime}(\\s*{DescRegex})?(\\s*{TimeSuffix})?)'
    TimeRegex5 = f'({TimePrefix}\\s*{BasicTime}((\\s*{DescRegex})))'
    TimeRegex6 = f'({BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix})'
    TimeRegex7 = f'(({AmPmPrefixRegex})({BasicTime})((\\s*{DescRegex}))?)'
    TimeRegex8 = f'({TimeSuffixFull}(\\s*(um|gegen)\\s*){BasicTime}((\\s*{DescRegex})?))'
    TimeRegex9 = f'({PeriodHourNumRegex}\\s+{FivesRegex}((\\s*{DescRegex})))'
    TimeRegex10 = f'({TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?'
    PureNumFromTo = f'(?<preDesc>({PmRegex}|{AmRegex})\\s+)?((von)\\s+)?({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex})){{0,2}}'
    PureNumBetweenAnd = f'\\b(?<preDesc>({PmRegex}|{AmRegex})\\s+)?(zwischen\\s+)({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{RangeConnectorRegex}\\s*({HourRegex}|{PeriodHourNumRegex})\\s*(?<rightDesc>\\s*{PmRegex}|{AmRegex}|{DescRegex}){{0,2}}\\b'
    SpecificTimeFromTo = f'((?<preDesc>({PmRegex}|{AmRegex})\\s+)?(von)\\s+)?(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\\s*{TillRegex}\\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))'
    SpecificTimeBetweenAnd = f'(?<preDesc>({PmRegex}|{AmRegex})\\s+)?(zwischen\\s+)(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\\s*{RangeConnectorRegex}\\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))'
    PrepositionRegex = f'(?<prep>^(um|am|in|zur)(\\s+(de[rmn]))?$)'
    TimeOfDayRegex = f'(?<timeOfDay>((((?<early>(früh(\\s+am|er)?|am frühen))|(?<late>(spät(\\s+am|er)?|am späten)))(\\s*|-))?((am\\s+)?morgens?(?! (früh|vor|nach|abend|(nacht|primetime)|morgen))|(vor|nach)mittags?|(?<!sonn)abends?|früh|(nachts?|primetime))))\\b'
    SpecificTimeOfDayRegex = f'\\b((({StrictRelativeRegex}|heute)\\s+{TimeOfDayRegex}))\\b'
    TimeFollowedUnit = f'^\\s*{TimeUnitRegex}$'
    TimeNumberCombinedWithUnit = f'(?<num>\\d+(\\,\\d*)?){TimeUnitRegex}'
    NowRegex = f'\\b(?<now>(genau\\s+)?jetzt|momentan|im moment|derzeit|in diesem moment|aktuelle?|gerade|so früh wie möglich|frühestmöglich|neulich|vorher)\\b'
    SuffixRegex = f'^\\s*((am|zur|in der)\\s+)?(am morgen|morgens|frühe?|(vor|nach)mittags?|abends?|(nacht|primetime)s?)\\b'
    DateTimeTimeOfDayRegex = f'\\b(?<timeOfDay>(vor|nach)?mittags?|abends?|(nachts?|primetime|morgen))\\b'
    DateTimeSpecificTimeOfDayRegex = f'\\b((({RelativeRegex}|heute)\\s+{DateTimeTimeOfDayRegex}))\\b'
    TimeOfTodayAfterRegex = f'^\\s*(,\\s*)?((zur|am|in der)\\s+)?{DateTimeSpecificTimeOfDayRegex}'
    TimeOfTodayBeforeRegex = f'{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(um|gegen|in|on))?\\s*$'
    SimpleTimeOfTodayAfterRegex = f'({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?(am\\s+)?{DateTimeSpecificTimeOfDayRegex}'
    SimpleTimeOfTodayBeforeRegex = f'{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+um)?\\s*({HourNumRegex}|{BaseDateTime.HourRegex})'
    SpecificEndOfRegex = f'((das|am|an( dem)?)\\s+)?\\bende(\\s+(de[mnsr])?)\\s*$'
    UnspecificEndOfRegex = f'^[.]'
    UnspecificEndOfRangeRegex = f'^[.]'
    PeriodTimeOfDayRegex = f'(((?<early>(früh( am|er)?|am frühen)(\\s*|-))|(?<late>(spät( am|er)|am späten)(\\s*|-)))?(?<timeOfDay>morgens?|früh|(vor|nach)mittags?|(nachts?|primetime)|abends?))'
    PeriodSpecificTimeOfDayRegex = f'(({StrictRelativeRegex}\\s+{PeriodTimeOfDayRegex})|heute)'
    PeriodTimeOfDayWithDateRegex = f'((((am|zur|von|in der)\\s+)?{TimeOfDayRegex}(\\s+am)?))|(?<timeOfDay>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)((vor|nach)?mittags?|abends?|(nachts?|primetime)|morgens?))\\b'
    LessThanRegex = f'\\b(weniger\\s+als)\\b'
    MoreThanRegex = f'\\b(mehr\\s+als)\\b'
    DurationUnitRegex = f'(?<unit>jahr(e(n|s)?)?|monat(en?|s)?|wochen?|tag(e(n|s)?)?|tg|stunden?|std?|h|min(uten?)?|sek(unden?)?)\\b'
    SpecialNumberUnitRegex = f'\\b(?<specialNum>beiden)\\b'
    SuffixAndRegex = f'(?<suffix>\\s*und\\s+(eine\\s+)?(?<suffix_num>halbe|viertel))'
    PeriodicRegex = f'(?<periodic>(all)?täglich(e(r|n|s)?)?|(all)?monatlich(e[rns]?)?|(all)?wöchentlich(e[rns]?)?|(all)?jährlich(e[rns]?)?)\\b'
    EachUnitRegex = f'(?<each>(jede(s|r|n|m)?|alle)(?<other>\\s+andere(n)?)?\\s*{DurationUnitRegex})'
    EachPrefixRegex = f'\\b(?<each>(jede(r|n|s|m)?|alle|immer)\\s*$)'
    SetEachRegex = f'\\b(?<each>(jede(r|n|s|m)?|alle|immer)\\s*)'
    SetLastRegex = f'(?<last>(über)?nächste[rmns]?|kommende[rns]?|diese[rnms]?|letzte[rmns]?|vorige[rns]?|vorherige[rns]?|jetzige[rns]?|derzeitige[rns]?)\\b'
    EachDayRegex = f'\\s*(jeden)\\s*tag\\s*\\b'
    BeforeEachDayRegex = f'(jeden)\\s*tag\\s*'
    DurationFollowedUnit = f'(^\\s*{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex})'
    NumberCombinedWithDurationUnit = f'\\b(?<num>\\d+(\\.\\d*)?)(-)?{DurationUnitRegex}'
    AnUnitRegex = f'\\b(((((ein(e[rsnm]?)?)(?<half>\\s+halb(e[srn]?))?))\\s+{DurationUnitRegex})|((ein(e[rsnm]?)?)\\s+((?<quarter>viertel)|(?<threequarter>dreiviertel))(?<unit>stunde)))'
    DuringRegex = f'\\b(während|im\\slaufe)\\s+(de[sr])\\s+(?<unit>jahres|monats|woche|tages)\\b'
    AllRegex = f'\\b(?<all>ganz(e[nsr]?)\\s+(?<unit>jahr|monat|woche|tag))\\b'
    HalfRegex = f'(((ein(e[nrs]?)?)\\s*)|\\b)(?<half>halb(e[nrs]?)?\\s+(?<unit>jahr(e[rs]?)?|monat[se]?|woch(en?)?|tag(e[nrs]?)?|stund(en?)?))\\b'
    ConjunctionRegex = f'\\b((und(\\s+für)?)|mit|für)\\b'
    HolidayRegex1 = f'\\b((dieses jahr)\\s*)?(?<holiday>reformations(tag|fest)|gedenktag der reformation|martinstag|st. martin|sankt martin|martinsfest|martini|nikolaustag|dreikönigstag|dreikönigsfest|walpurgisnacht|nationalfeiertag|mariä empfängnis|weihnachten|weihnachts(feier)?tag|erste(r|n)? weihnachtstag|1\\. weihnachtstag|erste(r|n)? weihnachtsfeiertag|1\\. weihnachtsfeiertag|zweite(r|n)? weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\\. weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\\. weihnachtsfeiertag|stefanitag|stafanstag|berchtoldstag|bechtelistag|bächtelistag|berchtelistag|bärzelistag|josefstag|joseftag|josefitag|pfingsten|ostermontag|ostersonntag|bundesfeiertag|bundesfeier|mariä himmelfahrt|tag der deutschen einheit|ostern|vatertag|muttertag|erntedank(fest)?|thanksgiving|martin luther king day|martin luther king jr day|washington\'s birthday|washington birthday|canberraday|tag der arbeit|columbus day|memorial day|yuandan|mao\'s birthday|teachersday|teacher day|single day|tag der jugend|kindertag|(Internationaler\\s+)?frauentag|treeplanting day|tag des baumes|girlsday|white lover day|loverday|weihnachten|weihnachtstag|xmas|neujahr|neujahrstag|neujahr|neujahrstag|neujahr|inauguration day|murmeltiertag|sommeranfang|winteranfang|frühlingsanfang|herbstanfang|valentinstag|st patrick day|erster april|april scherz|georgstag|mayday|maitag|maifeiertag|geburt johannes des täufers|us unabhängigkeitstag|unabhängigkeitstag|sturm auf die bastille|halloween|guy fawkes day|guy fawkes night|veterans day|heiligabend|silvester|pi-tag|pitag|pi (tag|day))(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?\\b'
    HolidayRegex2 = f'\\b((dieses jahr)\\s*)?(?<holiday>martin luther king|martin luther king jr|allerheiligen|tree planting day|white lover|st patrick|st george|independence|us independence|allerseelen|guy fawkes|silvester|weiberfastnacht|karneval|aschermittwoch|palm(en)?sonntag|karsamstag|fastnachtssamstag|fastnachtssonntag|heilige drei könige|barbaratag|reformationstag|weltkindertag|augsburger friedensfest|johannistag|peter und paul|karfreitag|christi himmelfahrt|pfingstsonntag|pfingstmontag|fronleichnam|rosenmontag|fastnacht|gründonnerstag|himmelfahrt|volkstrauertag|buß und bettag|buß- und bettag|buss- und bettag|buss und bettag|toten(sonntag|fest)|ewigkeitssonntag|erste(r|n)? advent|1\\. advent|zweite(r|n)? advent|2\\. advent|dritte(r|n)? advent|3\\. advent|vierte(r|n)? advent|4\\. advent|schweizer buss- und bettag|schweizer buss und bettag|schweizer buß und bettag|schweizer buß- und bettag)(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?\\b'
    HolidayRegex3 = f'((dieses jahr)\\s*)?(?<holiday>(canberra|columbus|thanks\\s*giving|groundhog|bastille|halloween|veterans|memorial|spring|lantern|qingming|dragon boat)\\s+(day))(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?'
    DateTokenPrefix = 'am '
    TimeTokenPrefix = 'um '
    TokenBeforeDate = 'am '
    TokenBeforeTime = 'um '
    FromRegex = f'\\b(vo[mn](\\s+de[rmsn])?)$'
    BetweenTokenRegex = f'\\b(zwischen(\\s+de[rmsn])?)$'
    AMTimeRegex = f'(?<am>morgens|vormittags?|früh)'
    PMTimeRegex = f'\\b(?<pm>nachmittags?|abends?|nachts?)'
    BeforeRegex = f'(vorher(ige(s|n|r)?)?|bevor|vor(\\W)?|vorige(s|n|r)?|bis)(\\s+de[rmsn]\\b)?'
    AfterRegex = f'(nach(\\W)?)(\\s+de[rmsn]\\b)?'
    SinceRegex = f'\\b(seit|ab)(\\s+de[rmsn])?\\b'
    AgoRegex = f'\\b(danach)\\b'
    AroundRegex = f'(\\b(ca\\.?|gegen|circa)\\s*\\b)'
    LaterRegex = f'\\b(später|von jetzt|(ab|nach) (?<day>morgen|heute))\\b'
    BeforeAfterRegex = f'^[.]'
    InConnectorRegex = f'\\b(in)\\b'
    SinceYearSuffixRegex = f'^[.]'
    WithinNextPrefixRegex = f'\\b(innerhalb|während(\\s+der|de(s|m))?(\\s+(?<next>{NextPrefixRegex}))?)\\b'
    TodayNowRegex = f'\\b(heute|jetzt)\\b'
    MorningStartEndRegex = f'(^(früh|vormittag(s)?)|(morgens?|früh|vormittags?)$)'
    AfternoonStartEndRegex = f'(^(nachmittags?)|(nachmittags?)$)'
    EveningStartEndRegex = f'(^(abends?)|(abends?)$)'
    NightStartEndRegex = f'(^(über nacht|in der nacht|nachts?|nächtens|primetime))|((über nacht|nachts?|nächtens|primetime)$)'
    InexactNumberRegex = f'\\b((ein )?paar|einige( wenige)?|wenige)\\b'
    InexactNumberUnitRegex = f'({InexactNumberRegex})\\s+({DurationUnitRegex})'
    RelativeTimeUnitRegex = f'((({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s*({TimeUnitRegex})))'
    RelativeDurationUnitRegex = f'(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s*)({DurationUnitRegex})))'
    ReferenceDatePeriodRegex = f'\\b{ReferencePrefixRegex}\\s+(?<duration>tag|monat|jahr(zehnt)?|wochen(ende|tag))\\b'
    ConnectorRegex = f'^(-|,|für|t|gegen)$'
    FromToRegex = f'\\b(vom|von).+(bis(\\s*zum)?)\\b.+'
    SingleAmbiguousMonthRegex = f'^(the\\s+)?(may|march)$'
    UnspecificDatePeriodRegex = f'^(woche(nende)?|monat|jahr)$'
    PrepositionSuffixRegex = f'\\b(am|in|um|gegen|vo[mn]|zu(m|r))$'
    FlexibleDayRegex = f'(?<DayOfMonth>([A-Za-z]+\\s)?[A-Za-z\\d]+)'
    ForTheRegex = f'\\b(für\\s+den\\s+{FlexibleDayRegex}(?<end>\\s*(,|\\.(?!(\\d|\\s?{WrittenMonthRegex}))|!|\\?|$)))'
    WeekDayAndDayOfMonthRegex = f'\\b{WeekDayRegex}(\\s*,)?\\s+((de(r|n))\\s+{FlexibleDayRegex})\\b'
    WeekDayAndDayRegex = f'\\b{WeekDayRegex}\\s+(?!de[nr]){DayRegex}(?!([-:]|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b'
    RestOfDateRegex = f'\\brest\\s+((de[rs]|dieser)\\s+)((aktuellen|jetzigen)\\s+)?(?<duration>woche|monats|jahres)\\b'
    RestOfDateTimeRegex = f'\\brest\\s+((des|diesen)\\s+)((aktuellen|heutigen)\\s+)?(?<unit>tages)\\b'
    MealTimeRegex = f'\\b((zu(m|r))\\s+)?(?<mealTime>(essenszeit|mittagessen|mittag))\\b'
    AmbiguousRangeModifierPrefix = f'^[.]'
    NumberEndingPattern = f'^(\\s+(?<meeting>meeting|termin|telefonkonferenz|conference|skype call|call)\\s+to\\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\\.)?$|(\\.,|,|!|\\?)))'
    OneOnOneRegex = f'\\b(1\\s*:\\s*1)|(one (on )?one|one\\s*-\\s*one|one\\s*:\\s*one)\\b'
    LaterEarlyPeriodRegex = f'\\b(((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?))\\s+(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))\\s+((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?)))\\b'
    WeekWithWeekDayRangeRegex = f'\\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|diese(r|n|m))\\s+woche)((\\s+zwischen\\s+{WeekDayRegex}\\s+und\\s+{WeekDayRegex})|(\\s+vo(n|m)\\s+{WeekDayRegex}\\s+(bis\\s+)?zum\\s+{WeekDayRegex})))\\b'
    GeneralEndingRegex = f'\\s*((\\.,)|\\.|,|!|\\?)?\\s*'
    MiddlePauseRegex = f'\\s*(,)\\s*'
    DurationConnectorRegex = f'^\\s*(?<connector>\\s+|und|für|,)\\s*$'
    PrefixArticleRegex = f'\\b(der|dem|des)?\\s+'
    OrRegex = f'\\s*((\\b|,\\s*)(oder|und)\\b|,)\\s*'
    YearPlusNumberRegex = f'\\b(jahr\\s+((?<year>(\\d{{2,4}}))|{FullTextYearRegex}))\\b'
    NumberAsTimeRegex = f'\\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\\b'
    TimeBeforeAfterRegex = f'\\b(((?<=\\b(vor|nach)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b'
    DateNumberConnectorRegex = f'\\s*(?<connector>am)\\s*'
    DecadeRegex = f'(?<decade>zwanziger|dreißiger|vierziger|fünfziger|sechziger|siebziger|achtziger|neunziger|zweitausender)(n)?'
    DecadeWithCenturyRegex = f'(die\\s+)?(((?<century>\\d|1\\d|2\\d)?(\')?(?<decade>\\d0)(\')?s)|(({CenturyRegex}(\\s+|-)(und\\s+)?)?{DecadeRegex})|({CenturyRegex}(\\s+|-)(und\\s+)?(?<decade>zehner|hunderter)))'
    RelativeDecadeRegex = f'\\b((das|die\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?jahrzehnte?)\\b'
    YearSuffix = f'(,?\\s*({DateYearRegex}|{FullTextYearRegex}))'
    SuffixAfterRegex = f'\\b(o\\s+(nach|in der Vergangenheit))\\b'
    YearPeriodRegex = f'((((von|während|zwischen)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((zwischen)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))'
    FutureSuffixRegex = f'\\b(in\\s+der\\s+)?(zukunft|zukünftig)\\b'
    PastSuffixRegex = f'^\\b$'
    ModPrefixRegex = f'\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b'
    ModSuffixRegex = f'\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b'
    ComplexDatePeriodRegex = f'(((von|während|in)\\s+)?(?<start>.+)\\s*({TillRegex})\\s*(?<end>.+)|((zwischen)\\s+)(?<start>.+)\\s*({RangeConnectorRegex})\\s*(?<end>.+))'
    UnitMap = dict([("jahren", "Y"),
                    ("jahres", "Y"),
                    ("jahre", "Y"),
                    ("jahr", "Y"),
                    ("monaten", "MON"),
                    ("monate", "MON"),
                    ("monat", "MON"),
                    ("monats", "MON"),
                    ("wochen", "W"),
                    ("woche", "W"),
                    ("tagen", "D"),
                    ("tages", "D"),
                    ("tage", "D"),
                    ("tag", "D"),
                    ("tg", "D"),
                    ("stunden", "H"),
                    ("stunde", "H"),
                    ("h", "H"),
                    ("minuten", "M"),
                    ("minute", "M"),
                    ("min", "M"),
                    ("sekunden", "S"),
                    ("sekunde", "S"),
                    ("sek", "S"),
                    ("H", "H")])
    UnitValueMap = dict([("jahren", 31536000),
                         ("jahre", 31536000),
                         ("jahr", 31536000),
                         ("monaten", 2592000),
                         ("monate", 2592000),
                         ("monat", 2592000),
                         ("wochen", 604800),
                         ("woche", 604800),
                         ("tagen", 86400),
                         ("tage", 86400),
                         ("tag", 86400),
                         ("tg", 86400),
                         ("stunden", 3600),
                         ("stunde", 3600),
                         ("std", 3600),
                         ("h", 3600),
                         ("minuten", 60),
                         ("minute", 60),
                         ("min", 60),
                         ("sekunden", 1),
                         ("sekunde", 1),
                         ("sek", 1)])
    SpecialYearPrefixesMap = dict([("", "")])
    SeasonMap = dict([("spring", "SP"),
                      ("summer", "SU"),
                      ("fall", "FA"),
                      ("autumn", "FA"),
                      ("winter", "WI")])
    SeasonValueMap = dict([("SP", 3),
                           ("SU", 6),
                           ("FA", 9),
                           ("WI", 12)])
    CardinalMap = dict([("erster", 1),
                        ("ersten", 1),
                        ("erstes", 1),
                        ("erste", 1),
                        ("1", 1),
                        ("zweiter", 2),
                        ("zweiten", 2),
                        ("zweites", 2),
                        ("zweite", 2),
                        ("zwoter", 2),
                        ("2", 2),
                        ("dritter", 3),
                        ("dritten", 3),
                        ("drittes", 3),
                        ("dritte", 3),
                        ("3", 3),
                        ("vierter", 4),
                        ("vierten", 4),
                        ("viertes", 4),
                        ("vierte", 4),
                        ("4", 4),
                        ("fünfter", 5),
                        ("fünften", 5),
                        ("fünftes", 5),
                        ("fünfte", 5),
                        ("5", 5)])
    DayOfWeek = dict([("montag", 1),
                      ("dienstag", 2),
                      ("mittwoch", 3),
                      ("donnerstag", 4),
                      ("freitag", 5),
                      ("samstag", 6),
                      ("sonnabend", 6),
                      ("sonntag", 0),
                      ("mo.", 1),
                      ("di.", 2),
                      ("mi.", 3),
                      ("do.", 4),
                      ("fr.", 5),
                      ("sa.", 6),
                      ("so.", 0)])
    MonthOfYear = dict([("januar", 1),
                        ("janner", 1),
                        ("jänner", 1),
                        ("februar", 2),
                        ("feber", 2),
                        ("märz", 3),
                        ("april", 4),
                        ("mai", 5),
                        ("juni", 6),
                        ("juno", 6),
                        ("juli", 7),
                        ("julei", 7),
                        ("august", 8),
                        ("september", 9),
                        ("oktober", 10),
                        ("november", 11),
                        ("dezember", 12),
                        ("jan", 1),
                        ("jän", 1),
                        ("feb", 2),
                        ("mar", 3),
                        ("apr", 4),
                        ("jun", 6),
                        ("jul", 7),
                        ("aug", 8),
                        ("sep", 9),
                        ("sept", 9),
                        ("okt", 10),
                        ("nov", 11),
                        ("dez", 12),
                        ("1.", 1),
                        ("2.", 2),
                        ("3.", 3),
                        ("4.", 4),
                        ("5.", 5),
                        ("6.", 6),
                        ("7.", 7),
                        ("8.", 8),
                        ("9.", 9),
                        ("10.", 10),
                        ("11.", 11),
                        ("12.", 12),
                        ("01.", 1),
                        ("02.", 2),
                        ("03.", 3),
                        ("04.", 4),
                        ("05.", 5),
                        ("06.", 6),
                        ("07.", 7),
                        ("08.", 8),
                        ("09.", 9),
                        ("1", 1),
                        ("2", 2),
                        ("3", 3),
                        ("4", 4),
                        ("5", 5),
                        ("6", 6),
                        ("7", 7),
                        ("8", 8),
                        ("9", 9),
                        ("10", 10),
                        ("11", 11),
                        ("12", 12),
                        ("01", 1),
                        ("02", 2),
                        ("03", 3),
                        ("04", 4),
                        ("05", 5),
                        ("06", 6),
                        ("07", 7),
                        ("08", 8),
                        ("09", 9),
                        ("erst", 1),
                        ("zweit", 2),
                        ("dritt", 3),
                        ("viert", 4),
                        ("fünft", 5),
                        ("fuenft", 5),
                        ("sechst", 6),
                        ("siebt", 7),
                        ("acht", 8),
                        ("neunt", 9),
                        ("zehnt", 10),
                        ("elft", 11),
                        ("zwölft", 12),
                        ("zwoelft", 12)])
    Numbers = dict([("null", 0),
                    ("eins", 1),
                    ("ein", 1),
                    ("eine", 1),
                    ("zween", 2),
                    ("zwei", 2),
                    ("zwo", 2),
                    ("drei", 3),
                    ("vier", 4),
                    ("fünf", 5),
                    ("fuenf", 5),
                    ("sechs", 6),
                    ("sieben", 7),
                    ("acht", 8),
                    ("neun", 9),
                    ("zehn", 10),
                    ("elf", 11),
                    ("zwölf", 12),
                    ("dreizehn", 13),
                    ("vierzehn", 14),
                    ("fünfzehn", 15),
                    ("sechzehn", 16),
                    ("siebzehn", 17),
                    ("achtzehn", 18),
                    ("neunzehn", 19),
                    ("zwanzig", 20),
                    ("einundzwanzig", 21),
                    ("zweiundzwanzig", 22),
                    ("dreiundzwanzig", 23),
                    ("vierundzwanzig", 24),
                    ("fünfundzwanzig", 25),
                    ("sechsundzwanzig", 26),
                    ("siebenundzwanzig", 27),
                    ("achtundzwanzig", 28),
                    ("neunundzwanzig", 29),
                    ("dreißig", 30),
                    ("einunddreißig", 31),
                    ("zweiunddreißig", 32),
                    ("dreiunddreißig", 33),
                    ("vierunddreißig", 34),
                    ("fünfunddreißig", 35),
                    ("sechsunddreißig", 36),
                    ("siebenunddreißig", 37),
                    ("achtunddreißig", 38),
                    ("neununddreißig", 39),
                    ("vierzig", 40),
                    ("einundvierzig", 41),
                    ("zweiundvierzig", 42),
                    ("dreiundvierzig", 43),
                    ("vierundvierzig", 44),
                    ("fünfundvierzig", 45),
                    ("sechsundvierzig", 46),
                    ("siebenundvierzig", 47),
                    ("achtundvierzig", 48),
                    ("neunundvierzig", 49),
                    ("fünfzig", 50),
                    ("einundfünfzig", 51),
                    ("zweiundfünfzig", 52),
                    ("dreiundfünfzig", 53),
                    ("vierundfünfzig", 54),
                    ("fünfundfünfzig", 55),
                    ("sechsundfünfzig", 56),
                    ("siebenundfünfzig", 57),
                    ("achtundfünfzig", 58),
                    ("neunundfünfzig", 59),
                    ("sechzig", 60),
                    ("einundsechzig", 61),
                    ("zweiundsechzig", 62),
                    ("dreiundsechzig", 63),
                    ("vierundsechzig", 64),
                    ("fünfundsechzig", 65),
                    ("sechsundsechzig", 66),
                    ("siebenundsechzig", 67),
                    ("achtundsechzig", 68),
                    ("neunundsechzig", 69),
                    ("siebzig", 70),
                    ("einundsiebzig", 71),
                    ("zweiundsiebzig", 72),
                    ("dreiundsiebzig", 73),
                    ("vierundsiebzig", 74),
                    ("fünfundsiebzig", 75),
                    ("sechsundsiebzig", 76),
                    ("siebenundsiebzig", 77),
                    ("achtundsiebzig", 78),
                    ("neunundsiebzig", 79),
                    ("achtzig", 80),
                    ("einundachtzig", 81),
                    ("zweiundachtzig", 82),
                    ("dreiundachtzig", 83),
                    ("vierundachtzig", 84),
                    ("fünfundachtzig", 85),
                    ("sechsundachtzig", 86),
                    ("siebenundachtzig", 87),
                    ("achtundachtzig", 88),
                    ("neunundachtzig", 89),
                    ("neunzig", 90),
                    ("einundneunzig", 91),
                    ("zweiundneunzig", 92),
                    ("dreiundneunzig", 93),
                    ("vierundneunzig", 94),
                    ("fünfundneunzig", 95),
                    ("sechsundneunzig", 96),
                    ("siebenundneunzig", 97),
                    ("achtundneunzig", 98),
                    ("neunundneunzig", 99),
                    ("einhundert", 100)])
    DayOfMonth = dict([("1.", 1),
                       ("2.", 2),
                       ("3.", 3),
                       ("4.", 4),
                       ("5.", 5),
                       ("6.", 6),
                       ("7.", 7),
                       ("8.", 8),
                       ("9.", 9),
                       ("10.", 10),
                       ("11.", 11),
                       ("12.", 12),
                       ("13.", 13),
                       ("14.", 14),
                       ("15.", 15),
                       ("16.", 16),
                       ("17.", 17),
                       ("18.", 18),
                       ("19.", 19),
                       ("20.", 20),
                       ("21.", 21),
                       ("22.", 22),
                       ("23.", 23),
                       ("24.", 24),
                       ("25.", 25),
                       ("26.", 26),
                       ("27.", 27),
                       ("28.", 28),
                       ("29.", 29),
                       ("30.", 30),
                       ("31.", 31),
                       ("1", 1),
                       ("2", 2),
                       ("3", 3),
                       ("4", 4),
                       ("5", 5),
                       ("6", 6),
                       ("7", 7),
                       ("8", 8),
                       ("9", 9),
                       ("10", 10),
                       ("11", 11),
                       ("12", 12),
                       ("13", 13),
                       ("14", 14),
                       ("15", 15),
                       ("16", 16),
                       ("17", 17),
                       ("18", 18),
                       ("19", 19),
                       ("20", 20),
                       ("21", 21),
                       ("22", 22),
                       ("23", 23),
                       ("24", 24),
                       ("25", 25),
                       ("26", 26),
                       ("27", 27),
                       ("28", 28),
                       ("29", 29),
                       ("30", 30),
                       ("31", 31),
                       ("erst", 1),
                       ("zweit", 2),
                       ("dritt", 3),
                       ("viert", 4),
                       ("fünft", 5),
                       ("fuenft", 5),
                       ("sechst", 6),
                       ("siebt", 7),
                       ("acht", 8),
                       ("neunt", 9),
                       ("zehnt", 10),
                       ("elft", 11),
                       ("zwölft", 12),
                       ("zwoelft", 12),
                       ("dreizehnt", 13),
                       ("vierzehnt", 14),
                       ("fünfzehnt", 15),
                       ("fuenfzehnt", 15),
                       ("sechzehnt", 16),
                       ("siebzehnt", 17),
                       ("achtzehnt", 18),
                       ("neunzehnt", 19),
                       ("zwanzigst", 20),
                       ("einundzwanzigst", 21),
                       ("zweiundzwanzigst", 22),
                       ("dreiundzwanzigst", 23),
                       ("vierundzwanzigst", 24),
                       ("fünfundzwanzigst", 25),
                       ("fuenfundzwanzigst", 25),
                       ("sechsundzwanzigst", 26),
                       ("siebenundzwanzigst", 27),
                       ("achtundzwanzigst", 28),
                       ("neunundzwanzigst", 29),
                       ("dreißigst", 30),
                       ("einunddreißigst", 31)])
    DoubleNumbers = dict([("halb", 0.5),
                          ("viertel", 0.25)])
    HolidayNames = dict([("reformationday", ["reformationstag", "reformationsfest", "gedenktagderreformation"]),
                         ("stmartinsday", ["martinstag", "st.martin", "sanktmartin", "martinsfest", "martini"]),
                         ("saintnicholasday", ["nikolaustag"]),
                         ("biblicalmagiday", ["dreik\u00f6nigstag", "dreik\u00f6nigsfest"]),
                         ("walpurgisnight", ["walpurgisnacht"]),
                         ("austriannationalday", ["nationalfeiertag"]),
                         ("immaculateconception", ["mari\u00e4empf\u00e4ngnis"]),
                         ("firstchristmasday", ["weihnachten", "weihnachtstag", "weihnachtsfeiertag", "erstenweihnachtstag", "erstenweihnachtsfeiertag", "ersterweihnachtstag", "ersterweihnachtsfeiertag", "erstenweihnachtstag", "erstenweihnachtsfeiertag", "1.weihnachtstag", "1.weihnachtsfeiertag"]),
                         ("secondchristmasday", ["zweiterweihnachtstag", "zweiterweihnachtsfeiertag", "zweiteweihnachtstag", "zweiteweihnachtsfeiertag", "zweitenweihnachtstag", "zweitenweihnachtsfeiertag", "2.weihnachtstag", "2.weihnachtsfeiertag", "stefanitag", "stafanstag"]),
                         ("berchtoldsday", ["berchtoldstag", "bechtelistag", "b\u00e4chtelistag", "berchtelistag", "b\u00e4rzelistag"]),
                         ("saintjosephsday", ["josefstag", "joseftag", "josefitag"]),
                         ("easterday", ["ostern"]),
                         ("eastermonday", ["ostermontag"]),
                         ("eastersunday", ["ostersonntag"]),
                         ("swissnationalday", ["bundesfeiertag", "bundesfeier"]),
                         ("assumptionofmary", ["mari\u00e4himmelfahrt"]),
                         ("germanunityday", ["tagderdeutscheneinheit"]),
                         ("fathers", ["vatertag", "m\u00e4nnertag"]),
                         ("mothers", ["muttertag"]),
                         ("thanksgiving", ["erntedankfest", "erntedank", "thanksgiving"]),
                         ("martinlutherking", ["martinlutherkingday", "martinlutherkingjrday"]),
                         ("washingtonsbirthday", ["washingtonsbirthday", "washingtonbirthday"]),
                         ("canberra", ["canberraday"]),
                         ("labour", ["tagderarbeit"]),
                         ("columbus", ["columbusday"]),
                         ("memorial", ["memorialday"]),
                         ("yuandan", ["yuandan"]),
                         ("maosbirthday", ["maosbirthday"]),
                         ("teachersday", ["teachersday", "teacherday"]),
                         ("singleday", ["singleday"]),
                         ("allsaintsday", ["allerheiligen"]),
                         ("youthday", ["tag der jugend"]),
                         ("childrenday", ["kindertag", "weltkindertag"]),
                         ("femaleday", ["frauentag"]),
                         ("treeplantingday", ["treeplantingday"]),
                         ("arborday", ["tag des baumes"]),
                         ("girlsday", ["girlsday"]),
                         ("whiteloverday", ["whiteloverday"]),
                         ("loverday", ["loverday"]),
                         ("xmas", ["xmas"]),
                         ("newyear", ["neujahr"]),
                         ("newyearday", ["neujahrstag", "neujahr"]),
                         ("newyearsday", ["neujahrstag", "neujahr"]),
                         ("inaugurationday", ["inaugurationday"]),
                         ("groundhougday", ["murmeltiertag"]),
                         ("valentinesday", ["valentinstag"]),
                         ("stpatrickday", ["stpatrickday"]),
                         ("aprilfools", ["erster april", "aprilscherz"]),
                         ("stgeorgeday", ["georgstag"]),
                         ("mayday", ["mayday", "maitag", "tagderarbeit", "maifeiertag"]),
                         ("laborday", ["mayday", "maitag", "tagderarbeit", "maifeiertag"]),
                         ("cincodemayoday", ["cincodemayo"]),
                         ("baptisteday", ["geburtjohannesdest\u00e4ufers"]),
                         ("usindependenceday", ["usunabh\u00e4ngigkeitstag"]),
                         ("independenceday", ["unabh\u00e4ngigkeitstag"]),
                         ("bastilleday", ["sturmaufdiebastille"]),
                         ("halloweenday", ["halloween"]),
                         ("allhallowday", ["allerheiligen"]),
                         ("allsoulsday", ["allerseelen"]),
                         ("guyfawkesday", ["guyfawkesday", "guyfawkesnight"]),
                         ("veteransday", ["veteransday"]),
                         ("piday", ["piday", "pitag", "pi-tag"]),
                         ("christmaseve", ["heiligabend"]),
                         ("newyeareve", ["silvester"]),
                         ("weiberfastnacht", ["weiberfastnacht"]),
                         ("carnival", ["karneval"]),
                         ("ashwednesday", ["aschermittwoch"]),
                         ("palmsunday", ["palmensonntag", "palmsonntag"]),
                         ("goodfriday", ["karfreitag"]),
                         ("ascensionofchrist", ["christihimmelfahrt"]),
                         ("whitesunday", ["pfingstsonntag", "pfingsten"]),
                         ("whitemonday", ["pfingstmontag"]),
                         ("corpuschristi", ["fronleichnam"]),
                         ("rosenmontag", ["rosenmontag"]),
                         ("fastnacht", ["fastnacht"]),
                         ("holythursday", ["gr\u00fcndonnerstag", "himmelfahrt"]),
                         ("memorialdaygermany", ["volkstrauertag"]),
                         ("dayofrepentance", ["bu\u00dfundbettag", "bu\u00df-undbettag", "bussundbettag"]),
                         ("totensonntag", ["totensonntag", "totenfest", "ewigkeitssonntag"]),
                         ("firstadvent", ["ersteadvent", "erstenadvent", "ersteradvent", "1.advent"]),
                         ("secondadvent", ["zweiteadvent", "zweitenadvent", "zweiteradvent", "2.advent"]),
                         ("thirdadvent", ["dritteadvent", "drittenadvent", "dritteradvent", "3.advent"]),
                         ("fourthadvent", ["vierteadvent", "viertenadvent", "vierteradvent", "4.advent"]),
                         ("chedayofrepentance", ["schweizerbu\u00dfundbettag", "schweizerbu\u00df-undbettag", "schweizerbussundbettag"]),
                         ("beginningofsummer", ["sommeranfang"]),
                         ("beginningofwinter", ["winteranfang"]),
                         ("beginningofspring", ["fr\u00fchlingsanfang"]),
                         ("beginningoffall", ["herbstanfang"]),
                         ("eastersaturday", ["karsamstag"]),
                         ("fastnachtssamstag", ["fastnachtssamstag"]),
                         ("fastnachtssonntag", ["fastnachtssonntag"]),
                         ("heiligedreikönige", ["heiligedreik\u00f6nige"]),
                         ("barbaratag", ["barbaratag"]),
                         ("augsburgerfriedensfest", ["augsburgerfriedensfest"]),
                         ("johannistag", ["johannistag"]),
                         ("peterundpaul", ["peterundpaul"])])
    WrittenDecades = dict([("hundert", 0),
                           ("zehn", 10),
                           ("zwanziger", 20),
                           ("dreißiger", 30),
                           ("vierziger", 40),
                           ("fünfziger", 50),
                           ("sechziger", 60),
                           ("siebziger", 70),
                           ("achtziger", 80),
                           ("neunziger", 90),
                           ("zwanzigern", 20),
                           ("dreißigern", 30),
                           ("vierzigern", 40),
                           ("fünfzigern", 50),
                           ("sechzigern", 60),
                           ("siebzigern", 70),
                           ("achtzigern", 80),
                           ("neunzigern", 90)])
    SpecialDecadeCases = dict([("zweitausender", 2000)])
    DefaultLanguageFallback = 'DMY'
    DurationDateRestrictions = [r'today', r'now']
    AmbiguityFiltersDict = dict([("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"),
                                 ("\\b(morgen|nachmittag|abend|nacht|tag)\\b", "\\b(gut(en?)?\\s+(morgen|nachmittag|abend|nacht|tag))\\b"),
                                 ("^(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)$", "([$%£&!?@#])(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)|(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)([$%£&@#])"),
                                 ("^(mo|di|mi|do|fr|sa|so)$", "\\b(mo|di|mi|do|fr|sa|so)\\b"),
                                 ("^((früh|spät)(\\s+am|er)?\\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)$", "((?<!(frü|spä))[a-z0-9])((früh|spät)(\\s+am|er)?\\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)\\b")])
    AmbiguousTimePeriodRegex = f'\\b((?<!{RelativeRegex}\\s+)morgen|früh(?!(\\s*morgens?)))\\b'
    MorningTermList = [r'morgen', r'vormittag', r'früh']
    AfternoonTermList = [r'nachmittag']
    EveningTermList = [r'abend']
    DaytimeTermList = [r'tag']
    NightTermList = [r'nacht', r'nachts', r'primetime']
    SameDayTerms = [r'heute', r'heutige datum', r'heutige tag', r'aktuelles datum', r'aktuelle datum', r'aktueller tag', r'aktuellen tag', r'aktuelle tag', r'dieser morgen', r'diesem morgen', r'diesen morgen', r'aktuelle morgen', r'aktuellen morgen', r'jetzige morgen', r'jetzigen morgen']
    PlusOneDayTerms = [r'morgen', r'morgiger tag', r'morgigen tag', r'morgigen tages']
    MinusOneDayTerms = [r'gestern', r'gestriger tag', r'gestrigen tag', r'gestrigen tages']
    PlusTwoDayTerms = [r'übermorgen']
    MinusTwoDayTerms = [r'vorgestern']
    FutureTerms = [r'dieser', r'diesen', r'dieses', r'diese', r'nächster', r'nächstes', r'nächsten', r'nächstem', r'nächste']
    LastCardinalTerms = [r'letzter', r'letztes', r'letzten', r'letztem']
    MonthTerms = [r'monat', r'monate', r'monaten', r'monats']
    MonthToDateTerms = [r'month to date']
    WeekendTerms = [r'wochenende', r'wochenendes']
    WeekTerms = [r'woche']
    YearTerms = [r'jahr', r'jahre', r'jahren', r'jahres']
    YearToDateTerms = [r'year to date']
# pylint: enable=line-too-long
