# ------------------------------------------------------------------------------
# <auto-generated>
#     This code was generated by a tool.
#     Changes to this file may cause incorrect behavior and will be lost if
#     the code is regenerated.
# </auto-generated>
#
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# ------------------------------------------------------------------------------

from .base_date_time import BaseDateTime
# pylint: disable=line-too-long


class DutchDateTime:
    LangMarker = 'Dut'
    CheckBothBeforeAfter = False
    TillRegex = f'(?<till>\\b(tot(dat|\\s+en\\s+met)?|en|gedurende|tijdens|ten tijde van)\\b|{BaseDateTime.RangeConnectorSymbolRegex})'
    RangeConnectorRegex = f'(?<and>\\b(en|t/m|tot(\\s+(aan|en\\s+met))?)\\b|{BaseDateTime.RangeConnectorSymbolRegex})'
    ArticleRegex = f'\\b(de|het|een)\\b'
    ApostrofRegex = f'(’|‘|\'|ʼ)'
    ApostrofsRegex = f'({ApostrofRegex}\\s*s)'
    RelativeRegex = f'\\b(?<order>((dit|deze|(erop)?volgende?|(aan)?komende?|aanstaande?|huidige?|vorige?|verleden|voorgaande?|laatste|afgelopen|(op\\s+)?de|het)\\b)|gister(en)?)'
    StrictRelativeRegex = f'\\b(?<order>((dit|deze|(erop)?volgende?|(aan)?komende?|aanstaande?|huidige?|vorige?|verleden|voorgaande?|laatste|afgelopen)\\b)|gister(en)?)'
    UpcomingPrefixRegex = f'((deze\\s+)?((aan)?komende?|aanstaande?))'
    NextPrefixRegex = f'\\b((erop)?volgende?|eerstvolgende|{UpcomingPrefixRegex})\\b'
    AfterNextSuffixRegex = f'\\b((na\\s+(afloop\\s+van\\s+)?((de|het)\\s+)?volgende?)|over)\\b'
    PastPrefixRegex = f'((deze\\s+)?(verleden|afgelopen))\\b'
    PreviousPrefixRegex = f'((voorgaand[e]|vorige?|verleden|laatste|{PastPrefixRegex})\\b|gister(en)?)'
    ThisPrefixRegex = f'(dit|deze|huidige?)\\b'
    RangePrefixRegex = f'(van|tussen)'
    CenturySuffixRegex = f'(^eeuw|^centennium)\\b'
    ReferencePrefixRegex = f'(dezelfde|hetzelfde|dat(zelfde)?|die|overeenkomstige)\\b'
    FutureSuffixRegex = f'\\b(((in\\s+de\\s+)?toekomst)|daarna|over|na)\\b'
    PastSuffixRegex = f'^\\b$'
    DayRegex = f'(de\\s*)?(?<!(\\d+:|\\$)\\s*)(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?:\\s*(ste|de|e))?(?=\\b|t)'
    WrittenOneToNineRegex = f'(één|een|twee|drie|vier|vijf|zes|zeven|acht|negen)'
    WrittenElevenToNineteenRegex = f'(elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien)'
    WrittenDayRegex = f'(?<day>({WrittenOneToNineRegex})|({WrittenElevenToNineteenRegex})|(({WrittenOneToNineRegex}(en|ën))?twintig)|(((één|een)(en|ën))?dertig))'
    WrittenCardinalDayRegex = f'(?<=((de\\s+)|\\b))(?<day>(éérste|eerste|tweede|derde|vierde|vijfde|zesde|zevende|achtste|negende|tiende|{WrittenElevenToNineteenRegex}de|({WrittenOneToNineRegex}(en|ën))?twintigste|((één|een)(en|ën))?dertigste))'
    ImplicitDayRegex = f'(de\\s*)?(?<day>(3[0-1]|[0-2]?\\d)(\\s*(ste|de|e)))\\b'
    MonthNumRegex = f'\\b(?<month>01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)\\b'
    WrittenTensRegex = f'(tien|twintig|dertig|veertig|vijftig|zestig|zeventig|tachtig|negentig)'
    WrittenNumRegex = f'({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\\s+{WrittenOneToNineRegex})?)'
    WrittenCenturyFullYearRegex = f'((twee)\\s*duizend(\\s+en)?(\\s*{WrittenOneToNineRegex}\\s*honderd)?)'
    WrittenCenturyOrdinalYearRegex = f'((ee|éé)nentwintig|tweeëntwintig|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|een|twee|drie|vier|vijf|zes|zeven|acht|negen)'
    CenturyRegex = f'\\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\\s*honderd)?(\\s+en)?)'
    LastTwoYearNumRegex = f'((zero|nul|en)\\s+{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|({WrittenOneToNineRegex}[eë]n)?{WrittenTensRegex})'
    FullTextYearRegex = f'\\b((?<firsttwoyearnum>{CenturyRegex})\\s*(?<lasttwoyearnum>{LastTwoYearNumRegex})\\b|\\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\\s+hundred(\\s+and)?))\\b'
    OclockRegex = f'(?<oclock>u(ur)?)\\b'
    SpecialDescRegex = f'((?<ipm>)p\\b)'
    AmDescRegex = f'(:?{BaseDateTime.BaseAmDescRegex})'
    PmDescRegex = f'(:?{BaseDateTime.BasePmDescRegex})'
    AmPmDescRegex = f'(:?{BaseDateTime.BaseAmPmDescRegex})'
    DescRegex = f'(:?(:?({OclockRegex}\\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex}))\\.?)|{OclockRegex})'
    PmRegex = f'(?<pm>({ApostrofsRegex}|des)\\s+(\\bmiddags|avonds|nachts)|((in|tegen|op|om|met)\\s+(de\\s+)?)(((na)?middag|avond|(midder)?nacht|lunchtijd))|\\s+dag)'
    PmRegexFull = f'(?<pm>(({ApostrofsRegex}|des)\\s+(\\bmiddags|avonds|nachts)|((in|tegen|op|om|met)\\s+(de\\s+)?)?(((na)?middag|(?<!kerst|oude?jaars)avond|(midder)?nacht|lunchtijd))))'
    AmRegex = f'(?<am>(({ApostrofsRegex}|des)\\s+(ochtends|morgens)|((in|tegen|op)\\s+de)(\\s+(ochtend|morgen))|(?<=gisteren|morgen|vandaag|(maan|dins|woens|donder|vrij|zater|zon)dag)(ochtend|morgen)|^?ochtend))'
    FullDescRegex = f'({DescRegex}|{AmRegex}|{PmRegexFull})'
    TwoDigitYearRegex = f'\\b(?<!\\$)(?<year>([0-24-9]\\d))(?!(\\s*(([:\\.]\\d)|keer|uurs?|{AmDescRegex}|{PmDescRegex})))\\b'
    YearRegex = f'({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})'
    WeekDayRegex = f'\\b(?<weekday>((ma|di(ns)?|wo(e(ns)?)?|do|vr(ij)?|zat?|zo)(\\.|\\b))|((?:maan|dins|woens|donder|vrij|zater|zon)(dag(en)?)?(middag)?)\\b)'
    SingleWeekDayRegex = f'\\b(?<weekday>(((ma|di(ns)?|wo(e(ns)?)?|do|vr|za)\\b(\\.)?)|(vrij|zat|zon?)\\.(?!$)|(((?<!in\\s+de\\s+)(maan|dins|woens|donder|zater)(dag(en)?)?|(?<=(op|voor)\\s+)(vrij|zon?|zat)|vrij(dag(en)?))\\b))|zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)'
    RelativeMonthRegex = f'(?<relmonth>((van\\s+)?(de\\s+)?)?{RelativeRegex}\\s+maand)\\b'
    WrittenMonthRegex = f'(((de\\s+)?maand\\s+)?(?<month>januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december|jan|feb|mar|mrt|apr|jun|jul|aug|sep|sept|oct|okt|nov|dec))'
    MonthSuffixRegex = f'(?<msuf>((in|van|tijdens|sinds|tot|op)\\s+)?({RelativeMonthRegex}|{WrittenMonthRegex}))'
    DateUnitRegex = f'(?<unit>(eeuw|maand|weekend)(?<plural>en)?|jaar|(?<plural>jaren|weken)|jr|decennia|mnd|week|(?<business>we[er]k)?dag(?<plural>en)?|dgn)\\b'
    DateTokenPrefix = 'op '
    TimeTokenPrefix = 'om '
    TokenBeforeDate = 'op '
    TokenBeforeTime = 'om '
    HalfTokenRegex = f'^(half)'
    QuarterTokenRegex = f'^(een\\s+kwart(\\s+jaar)?|kwart|een\\s+kwartier|kwartier)'
    ThreeQuarterTokenRegex = f'^(drie\\s+kwart|drie\\s+kwartier)'
    ToTokenRegex = f'\\b(voor)$'
    ToHalfTokenRegex = f'\\b(over\\s+half)$'
    ForHalfTokenRegex = f'\\b(voor\\s+half)$'
    FromRegex = f'\\b(van(af)?)$'
    BetweenTokenRegex = f'\\b(tussen)$'
    SimpleCasesRegex = f'\\b({RangePrefixRegex}\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex}(\\s*),?(\\s*){MonthSuffixRegex}|{MonthSuffixRegex}\\s+{DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    MonthFrontSimpleCasesRegex = f'\\b({RangePrefixRegex}\\s+)?(({MonthSuffixRegex}\\s+((van)\\s+)?({DayRegex})|({DayRegex})\\s+((van)\\s+)?{MonthSuffixRegex})\\s*{TillRegex}\\s*({DayRegex})|(op\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    MonthFrontBetweenRegex = f'\\b{MonthSuffixRegex}\\s+(tussen\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b'
    BetweenRegex = f'\\b(tussen\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b'
    RelativeYearRegex = f'({YearRegex}|(?<order>volgende?|komende?|aanstaande?|aankomende?|huidige?|vorige?|afgelopen|dit)\\s+jaar)'
    MonthWithYear = f'\\b(({WrittenMonthRegex}(\\.)?(\\s*)[/\\\\\\-\\.,]?(\\s+(van|over|in))?(\\s*){RelativeYearRegex})|({RelativeYearRegex}(\\s*),?(\\s*){WrittenMonthRegex}))\\b'
    OneWordPeriodRegex = f'\\b((((de\\s+)?maand\\s+(van\\s+)?)?({StrictRelativeRegex}\\s+)?(?<month>januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december|jan\\.?|feb\\.?|mar\\.?|mrt\\.?|apr\\.?|jun\\.?|jul\\.?|aug\\.?|sep\\.?|sept\\.?|oct\\.?|okt\\.?|nov\\.?|dec\\.?))|(maand|jaar)\\s+tot(\\s+op)?\\s+heden|(({RelativeRegex}\\s+)(mijn\\s+)?(weekend|(?<business>werkweek)|week|maand|jaar(?!\\s+hoger dan))|({RelativeRegex}\\s+)?(mijn\\s+)(weekend|(?<business>werkweek)|week|maand|jaar))(?!((\\s+van)?\\s+\\d+|\\s+tot(\\s+op)?\\s+heden|nu))(\\s+{AfterNextSuffixRegex})?)\\b'
    MonthNumWithYear = f'\\b(({BaseDateTime.FourDigitYearRegex}(\\s*)[/\\-\\.](\\s*){MonthNumRegex})|({MonthNumRegex}(\\s*)[/\\-](\\s*){BaseDateTime.FourDigitYearRegex}))\\b'
    WeekOfMonthRegex = f'\\b(?<wom>(de\\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\\s+week\\s+{MonthSuffixRegex}(\\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\\s+year)?)\\b'
    WeekOfYearRegex = f'(\\b(?<woy>(de\\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\\s+week(\\s+van)?\\s+({YearRegex}|{RelativeRegex}\\s+jaar))\\b)|(\\b({YearRegex}|{RelativeRegex}\\s+jaar)\\s(?<woy>(de\\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\\s+week)\\b)'
    OfYearRegex = f'\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b'
    FirstLastRegex = f'\\b(the\\s+)?((?<first>first)|(?<last>last))\\b'
    FollowedDateUnit = f'^\\s*{DateUnitRegex}'
    NumberCombinedWithDateUnit = f'\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}'
    QuarterTermRegex = f'\\b(((?<cardinal>eerste|1e|1ste|tweede|2e|2de|derde|3e|3de|vierde|4e|4de)[ -]+kwartaal)|(k(?<number>[1-4])))\\b'
    QuarterRegex = f'(het\\s+)?{QuarterTermRegex}((\\s+van|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+jaar))?'
    QuarterRegexYearFront = f'({YearRegex}|({RelativeRegex}\\s+jaar))({ApostrofsRegex})?\\s+((het|de)\\s+)?{QuarterTermRegex}'
    HalfYearTermRegex = f'(?<cardinal>eerste|1e|1ste|tweede|2e|2de)\\s+(helft)'
    HalfYearFrontRegex = f'(?<year>(de\\s+){HalfYearTermRegex}(\\s+helft van\\s+)((1[5-9]|2[0-1]])\\d{{2}}))'
    HalfYearBackRegex = f'(het\\s+)?(H(?<number>[1-2])|({HalfYearTermRegex}))(\\s+van|\\s*,\\s*)?\\s+({YearRegex})'
    HalfYearRelativeRegex = f'(het\\s+)?{HalfYearTermRegex}(\\s+van|\\s*,\\s*)?\\s+({RelativeRegex}\\s+jaar)'
    AllHalfYearRegex = f'({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})'
    EarlyPrefixRegex = f'\\b(?<EarlyPrefix>((?<RelEarly>eerder)|vroeg(er)?|((de|het)\\s+)?(begin(nend)?|start(end)?))(\\s+(in|op|van)(\\s+de)?)?)\\b'
    MidPrefixRegex = f'\\b(?<MidPrefix>(het\\s+)?(mid(den|-)?|halverwege|op\\s+de\\s+helft|half)(\\s+(in|op|van)(\\s+de)?)?)'
    LaterPrefixRegex = f'\\b(?<LatePrefix>(laat|(?<RelLate>later)|(aan\\s+)?het\\s+einde?(\\s+van(\\s+de)?)?|eind(e|igend)?|afsluitend)(\\s+(in|op|van)(\\s+de)?)?)\\b'
    PrefixPeriodRegex = f'({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})'
    PrefixDayRegex = f'\\b(((?<!{WeekDayRegex}\\s+)(?<EarlyPrefix>eerder|vroeg(er)?|begin|start)|(?<MidPrefix>midden|halverwege|op\\s+de\\s+helft)|(?<LatePrefix>laat|later))(\\s+(in|op|van))?(\\s+de\\s+dag)?$)|^\\s*(((?<!{WeekDayRegex}\\s+)(?<EarlyPrefix>eerder|vroeg(er)?|begin|start)|(?<MidPrefix>midden|halverwege|op\\s+de\\s+helft)|in\\s+de|(?<LatePrefix>laat|later))(\\s+(in|op|van))(\\s+de\\s+dag))\\b'
    SeasonDescRegex = f'(?<seas>lente|voorjaar|zomer|herfst|najaar|winter)'
    SeasonRegex = f'\\b(?<season>({PrefixPeriodRegex}(\\s+)?)?({ArticleRegex}\\s+)?({RelativeRegex}\\s+)?{SeasonDescRegex}((\\s+(in|van)|\\s*,\\s*)?\\s+({YearRegex}|({ArticleRegex}\\s+)?({RelativeRegex}\\s+)?jaar))?)\\b'
    WhichWeekRegex = f'\\b(week)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])\\b'
    WeekOfRegex = f'(de\\s+)?(week)\\s+(van(\\s+(de|het))?|(beginnend|die\\s+begint|startend|aanvangend)(\\s+op)?)'
    MonthOfRegex = f'(maand)(\\s*)(van)'
    MonthRegex = f'\\b(?<month>(januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december)\\b|(jan|feb|mar|mrt|apr|jun|jul|aug|sept|sep|oct|okt|nov|dec)(?:\\.|\\b))'
    DateYearRegex = f'(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})'
    YearSuffix = f'((,|\\s*van)?\\s*({DateYearRegex}|{FullTextYearRegex}))'
    OnRegex = f'(?<=\\bop\\s+)({DayRegex})\\b(?!(\\.|:)\\d+)'
    RelaxedOnRegex = f'\\b(?<=op\\s+)(?:de\\s+)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?:\\s*(ste|de|e))?\\b(?!(\\.|:)\\d+)'
    PrefixWeekDayRegex = f'(\\s*((,?\\s*op)|[-—–]))'
    ThisRegex = f'\\b((deze(\\s+week{PrefixWeekDayRegex}?)?\\s*){WeekDayRegex})|({WeekDayRegex}((\\s+van)?\\s*deze\\s+week))\\b'
    LastDateRegex = f'\\b({PreviousPrefixRegex}(\\s*week{PrefixWeekDayRegex}?)?\\s+{WeekDayRegex})|({WeekDayRegex}(\\s+van)?(\\s+vorige\\s+week))\\b'
    WeekDayForNextDateRegex = f'\\b(?<weekday>((ma|di(ns)?|wo(e(ns)?)?|do|vr(ij)?|za(t)?|zo)(\\.|\\b))|((?:maan(?!den)|dins|woens|donder|vrij|zater|zon)(dag)?))'
    NextDateRegex1 = f'\\b({NextPrefixRegex}(\\s*week{PrefixWeekDayRegex}?)?\\s+{WeekDayForNextDateRegex}|(op\\s+)?{WeekDayForNextDateRegex}\\s+((van\\s+)?(de\\s+)?{NextPrefixRegex})\\s*week|(op\\s+)?{NextPrefixRegex}\\s*week\\s+{WeekDayForNextDateRegex})'
    NextDateRegex2 = f'\\b({NextPrefixRegex}(\\s*week(\\s*,?\\s*op)?)?\\s+{WeekDayRegex}|(op\\s+)?{WeekDayRegex}\\s+((van\\s+)?(de\\s+)?{NextPrefixRegex})\\s*week|(op\\s+)?{NextPrefixRegex}\\s*week\\s+{WeekDayRegex})'
    NextDateRegex = f'({NextDateRegex1}|{NextDateRegex2})'
    SpecialDayRegex = f'\\b(eergisteren|overmorgen|(de\\s+)?dag\\s+na\\s+morgen|(de\\s+)?dag\\s+(ervoor|erna)|((de\\s+)?({StrictRelativeRegex}|mijn)\\s+dag)\\b|(de\\s+dag(?!\\s+van))|gisteren|(deze\\s+)?morgen|vandaag|morgen(middag))(?!s\\b)'
    SpecialDayWithNumRegex = f'\\b((?<number>{WrittenNumRegex})\\s+dag(en)?\\s+(gerekend\\s+)?(vanaf\\s+)(?<day>gisteren|morgen|vandaag))\\b'
    RelativeDayRegex = f'\\b(((de\\s+)?{RelativeRegex}\\s+dag))\\b'
    SetWeekDayRegex = f'\\b(?<prefix>op\\s+({{ArticleRegex}}\\s+)?)?(?<weekday>morgen|ochtend|middag|avond|nacht|zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)((?<suffix>e)n)\\b'
    WeekDayOfMonthRegex = f'(?<wom>((de\\s+|\\b))?(?<cardinal>eerste|tweede|derde|vierde|vijfde|zesde|tiende|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\\s+{WeekDayRegex}(\\s+{MonthSuffixRegex}))'
    RelativeWeekDayRegex = f'\\b({WrittenNumRegex}\\s+{WeekDayRegex}\\s+(vanaf\\s+nu|later))\\b'
    SpecialDate = f'(?=\\b(op\\s+)(de\\s+)?){DayRegex}\\b'
    DatePreposition = f'\\b(op(\\s+de)?)'
    DateExtractorYearTermRegex = f'(\\s+(van\\s+)?|\\s*[,./-]\\s*){DateYearRegex}'
    DateExtractor1 = f'\\b({WeekDayRegex}\\s*[,-]?\\s*)?(({MonthRegex}(\\.)?\\s*[/\\\\.,-]?\\s*{DayRegex}(?!\\s*({MonthRegex}|\\-\\s*\\d{{2}}\\b)))|(\\({MonthRegex}\\s*[-.]\\s*{DayRegex}\\))|({DayRegex}(\\.)?\\s*[/\\\\.,-]?\\s*{MonthRegex}))(\\s*\\(\\s*{WeekDayRegex}\\s*\\))?({DateExtractorYearTermRegex}(?!\\s*{MonthRegex})\\b)?'
    DateExtractor3 = f'\\b({WeekDayRegex}(\\s+|\\s*,\\s*)?(de\\s+)?)?(({DayRegex}(\\s*dag|\\.)?)((\\s+|\\s*[,/-]\\s*|\\s+van\\s+)?{MonthRegex})((\\.)?(\\s+|\\s*[,/-]\\s*|\\s+in\\s+)?{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\\s*[,./-]?\\s*(de\\s*)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?:\\s*(ste|de|e))?(\\s*dag|\\.)?\\s*[,./-]?\\s*{MonthRegex})\\b'
    DateExtractor4 = f'\\b{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}[\\.]?\\s*[/\\\\\\-]\\s*{ApostrofRegex}?{DateYearRegex}'
    DateExtractor5 = f'\\b{DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)'
    DateExtractor6 = f'(?<={DatePreposition}\\s+)({StrictRelativeRegex}\\s+)?({WeekDayRegex}\\s+)?{MonthNumRegex}[\\.]{DayRegex}(?!([%]|\\s*{FullDescRegex}))\\b|(?<={DatePreposition}\\s+){MonthNumRegex}[\\-\\.]{DayRegex}(?!([%]|\\s*{FullDescRegex}))\\b'
    DateExtractor7L = f'\\b({WeekDayRegex}\\s+)?{MonthNumRegex}\\s*/\\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])\\b'
    DateExtractor7S = f'\\b((?<=(^|{DatePreposition}\\s+)){WeekDayRegex}\\s+)?{MonthNumRegex}\\s*/\\s*{DayRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\\s*{FullDescRegex}))\\b'
    DateExtractor8 = f'\\b((?<=(^|{DatePreposition}\\s+)){WeekDayRegex}\\s+)?(?<!(morgen|ochtend|middag|avond|nacht)s?\\s+){DayRegex}[\\\\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\\s*{FullDescRegex}))\\b'
    DateExtractor9L = f'\\b({WeekDayRegex}\\s+)?{DayRegex}\\s*[-|\\/|.]\\s*{MonthNumRegex}((\\s+|\\s*,\\s*|\\s+in\\s+){DateYearRegex})(?![%])\\b'
    DateExtractor9S = f'\\b(?<!naar\\s+)({WeekDayRegex}\\s+)?{DayRegex}\\s*(\\/|\\.)\\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\\s*{FullDescRegex}))\\b'
    DateExtractorA = f'\\b({WeekDayRegex}\\s+)?({BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)|{MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*(de\\s*)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?:\\s*(ste|de|e))?|{DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})'
    OfMonth = f'(^\\s*((van|in)\\s+)?)({MonthRegex})'
    MonthEnd = f'{MonthRegex}(\\s+de\\s*)?$'
    WeekDayEnd = f'(deze\\s+)?{WeekDayRegex}\\s*,?\\s*$'
    WeekDayStart = f'^\\s+(op\\s+)?{WeekDayRegex}\\b'
    RangeUnitRegex = f'\\b(?<unit>ja(ren|ar)|maand(en)?|we(ken|ek)|dag(en)?)\\b'
    HourNumRegex = f'\\b(?<hournum>nul|een|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig)\\b'
    MinuteNumRegex = f'(?<minnum>nul|een(?=\\s+min(uut)?)|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig|vij[fv]entwintig|ze(s|ven)entwintig|achtentwintig|negenentwintig|dertig|eenendertig|tweeëndertig|drieëndertig|vierendertig|vijfendertig|ze(s|ven)endertig|achtendertig|negenendertig|veertig|eenenveertig|tweeënveertig|drieënveertig|vierenveertig|vijfenveertig|ze(s|ven)enveertig|achtenveertig|negenenveertig|eenenvijftig|vijftig|tweeënvijftig|drieënvijftig|vierenvijftig|vijfenvijftig|ze(s|ven)envijftig|achtenvijftig|negenenvijftig)'
    DeltaMinuteNumRegex = f'(?<deltaminnum>nul|een(?=\\s+min(uut)?)|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig|vijfentwintig|vijventwintig|zesentwintig|zevenentwintig|achtentwintig|negenentwintig|dertig|eenendertig|tweeëndertig|drieëndertig|vierendertig|vijfendertig|zesendertig|zevenendertig|achtendertig|negenendertig|veertig|eenenveertig|tweeënveertig|drieënveertig|vierenveertig|vijfenveertig|zesenveertig|zevenenveertig|achtenveertig|negenenveertig|eenenvijftig|vijftig|tweeënvijftig|drieënvijftig|vierenvijftig|vijfenvijftig|zesenvijftig|zevenenvijftig|achtenvijftig|negenenvijftig)(?=\\b)'
    LunchRegex = f'\\b(lunchtijd)\\b'
    NightRegex = f'\\b((({ApostrofsRegex}|des)\\s+)?nachts|(midder)?nacht)\\b'
    CommonDatePrefixRegex = f'^[\\.]'
    LessThanOneHour = f'(?<lth>((een\\s+)?((drie\\s+)?kwart(ier)?|half(uur)?))|{BaseDateTime.DeltaMinuteRegex}(\\s+(minuten|mins|min\\.?))?|({DeltaMinuteNumRegex}(\\s+(minuten|mins|min\\.?))?))'
    WrittenTimeRegex = f'(?<writtentime>({HourNumRegex}\\s+{MinuteNumRegex}|(?<prefix>half)\\s+({HourNumRegex})))'
    TimePrefix = f'(?<prefix>(half|{LessThanOneHour}\\s+(over|voor|na)(\\s+half)?)|(uur\\s+{LessThanOneHour}))'
    TimeSuffix = f'(?<suffix>(({OclockRegex}\\s+)?({AmRegex}|{PmRegex}))|{OclockRegex})'
    TimeSuffixFull = f'(?<suffix>(({OclockRegex}\\s+)?({AmRegex}|{PmRegexFull}))|{OclockRegex})'
    HourDTRegEx = f'({BaseDateTime.HourRegex})'
    MinuteDTRegEx = f'({BaseDateTime.MinuteRegex})'
    SecondDTRegEx = f'({BaseDateTime.SecondRegex})'
    BasicTime = f'\\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{HourDTRegEx}(:|\\.){MinuteDTRegEx}(:{SecondDTRegEx})?|((?<prefix>half)\\s+)?{HourDTRegEx}(?![.,:]?[%\\d]))'
    MidnightRegex = f'(?<midnight>mid\\s*(-\\s*)?nacht|middernacht|(in\\s+)?de nacht(\\s+van)?|({ApostrofsRegex}|des)\\s*nachts)'
    MidmorningRegex = f'(?<midmorning>mid\\s*(-\\s*)?(morgen|ochtend)|halverwege de ochtend|het midden van de ochtend)'
    MidafternoonRegex = f'(?<midafternoon>mid\\s*(-\\s*)?middag|halverwege de middag|het midden van de middag)'
    MiddayRegex = f'(?<midday>(?<!gisteren|morgen)(((rond\\s+)?(het|de)|{ApostrofsRegex})\\s+)?middag(uur|s|loos)?|namiddag|noen|lunchtijd)'
    MidTimeRegex = f'(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))'
    AtRegex = f'(((?<=\\bom\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\\.\\d)(\\s*((?<iam>a)|(?<ipm>p)))?|{MidTimeRegex}))|{MidTimeRegex})\\b'
    IshRegex = f'\\b(tegen\\s+{BaseDateTime.HourRegex}(-|——|\\s*{ApostrofRegex}\\s*)?en|middagloos)\\b'
    TimeUnitRegex = f'([^A-Za-z]{{1,}}|\\b)(?<unit>(min\\.|sec\\.)|(u(ur)?|minuut|seconde|(?<plural>uren|minuten|seconde[ns])|(min|sec)(?<plural>s)?)\\b)'
    RestrictedTimeUnitRegex = f'(?<unit>uur|minuut)\\b'
    FivesRegex = f'(?<tens>(vijf|tien|vijftien|twintig|vijfentwintig|vijventwintig|dertig|vijfendertig|veertig|vijfenveertig|vijftig|vijfenvijftig))\\b'
    HourRegex = f'\\b{BaseDateTime.HourRegex}'
    PeriodHourNumRegex = f'\\b(?<hour>nul|een|één|twee|drie|vier|vijf(en)?|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig)\\b?'
    ConnectNumRegex = f'\\b{BaseDateTime.HourRegex}(?<min>00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59)\\s*{DescRegex}'
    AroundRegex = f'(\\b(rond(om)?|ongeveer(\\s+om)?)\\s*\\b)'
    TimeRegexWithDotConnector = f'({BaseDateTime.HourRegex}(\\s*\\.\\s*){BaseDateTime.MinuteRegex}(\\s*:\\s*{BaseDateTime.SecondRegex})?(\\s*u\\s*)?)'
    TimeRegexFilter = f'\\b((iedere|elke|op)(\\s+andere)?\\s+)?(week|dag|{SingleWeekDayRegex}|vandaag)\\b'
    TimeRegex1 = f'\\b(({TimePrefix}|{AroundRegex})\\s+)?(({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\\s*{DescRegex})|(({AroundRegex})\\s+){HourNumRegex}(?!\\s+{SingleWeekDayRegex})\\b)'
    TimeRegex2 = f'(\\b{TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?(:|\\.)(\\s*)?(?<min>[0-5]\\d)(?!(\\d|\\s*(per|pro)\\s*cent|%))((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?(\\s*u)?((\\s*{DescRegex})|\\b)'
    TimeRegex3 = f'(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})'
    TimeRegex4 = f'\\b{TimePrefix}\\s+{BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}\\b'
    TimeRegex5 = f'\\b({TimePrefix}\\s+{BasicTime}|{BasicTime}\\s+{TimePrefix})((\\s*({DescRegex}|{TimeSuffix}))|\\b)'
    TimeRegex6 = f'{BasicTime}(\\s*u\\s*)?(\\s*{DescRegex})?\\s+{TimeSuffix}\\b'
    TimeRegex7 = f'({TimeSuffixFull}\\s+(om\\s+)?({TimePrefix}\\s+)?(?<!van(avond|nacht)\\s+){BasicTime})((\\s*{DescRegex})|\\b)|{BasicTime}(\\s*{DescRegex})(\\s*{TimeSuffixFull})'
    TimeRegex8 = f'.^'
    TimeRegex9 = f'\\b{PeriodHourNumRegex}\\s*{FivesRegex}((\\s*{DescRegex})|\\b)'
    TimeRegex10 = f'\\b({TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*(u\\b|h))(\\s*{BaseDateTime.MinuteRegex})?(\\s*{DescRegex})?'
    TimeRegex11 = f'\\b(?<!{TimeRegexFilter}\\s+)((?:({TimeTokenPrefix})?{TimeRegexWithDotConnector}(\\s*({DescRegex}|{TimeSuffix})))|(?:(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\\s*(per|pro)\\s*cent|%|\\s+{TimeRegexFilter})))'
    TimeRegex12 = f'({BaseDateTime.HourRegex}(?=\\s+(vandaag|morgen|op)))'
    FirstTimeRegexInTimeRange = f'\\b{TimeRegexWithDotConnector}(?!\\s*(per|pro)\\s*cent|%|\\s+{TimeRegexFilter})(\\s*{DescRegex})?'
    PureNumFromToPrefixExcluded = f'({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{TillRegex}\\s*({HourDTRegEx}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex}))?'
    PureNumFromToPrefix = f'(({PmRegexFull}|{AmRegex})\\s+)?({RangePrefixRegex}\\s+)({HourDTRegEx}|{PeriodHourNumRegex})(\\s+uur)?(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{RangeConnectorRegex}\\s*({HourDTRegEx}|{PeriodHourNumRegex})(\\s+uur)?(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex}))?'
    PureNumFromToWithDateBefore = f'({RangePrefixRegex}\\s+)({HourDTRegEx})(\\s+(vandaag|morgen)\\s+)?(\\s*{RangeConnectorRegex}\\s*)({HourDTRegEx})'
    PureNumFromToWithDateAfter = f'({RangePrefixRegex}\\s+)({HourDTRegEx})(\\s*{RangeConnectorRegex}\\s*)({HourDTRegEx}(\\s+(vandaag|morgen))?)'
    PureNumFromTo = f'({PureNumFromToPrefix}|{PureNumFromToPrefixExcluded})'
    TimeDateFromTo = f'({PureNumFromToWithDateAfter}|{PureNumFromToWithDateBefore})'
    PureNumBetweenAnd = f'(tussen\\s+)({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?\\s*{RangeConnectorRegex}\\s*({HourDTRegEx}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex}))?'
    SpecificTimeFromTo = f'(({PmRegexFull}|{AmRegex})\\s+)?({RangePrefixRegex}\\s+)?(?<time1>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{TillRegex}\\s*(?<time2>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))'
    SpecificTimeBetweenAnd = f'(({PmRegexFull}|{AmRegex})\\s+)?(tussen\\s+)(?<time1>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{RangeConnectorRegex}\\s*(?<time2>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?(\\s+{TimeSuffix})?))'
    PrepositionRegex = f'(?<prep>^(om|rond|tegen|op|van|deze)(\\s+de)?$)'
    MealTimeRegex = f'\\b((((tijdens\\s+)?de|het)\\s+)?(?<mealTime>ontbijt|lunch|avondeten)|((om|tegen|tijdens)\\s+)?(?<mealTime>lunchtijd))\\b'
    EarlyLateRegex = f'\\b(((?<early>vroege?|(in\\s+het\\s+)?(begin))|(?<late>laat|later|late|aan\\s+het\\s+einde?))((\\s+|-)(in\\s+de|op\\s+de|van\\s+de|deze|in|op|van|de))?)'
    TimeOfDayRegex = f'(?<timeOfDay>(({EarlyLateRegex}\\s+)(aanstaande\\s+)?(zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)\\s*(ochtend|morgen|(na)?middag|avond|nacht))|(((van\\s+deze\\s+)|\\b(in\\s+(de)?\\s+)|de\\s+)?({EarlyLateRegex}\\s+)?({ApostrofsRegex}\\s+)?(ochtend(en)?|morgen|middag(en)?|avond(en)?|nacht(\\s+van)?)s?((\\s+|-)({EarlyLateRegex}))?)|{MealTimeRegex}|((tijdens\\s+(de\\s+)?)?(kantoor|werk)uren))\\b'
    SpecificTimeOfDayRegex = f'\\b((({StrictRelativeRegex}\\s+{TimeOfDayRegex})\\b|\\bvan(ochtend|morgen|middag|avond|nacht)))s?\\b'
    TimeFollowedUnit = f'^\\s*{TimeUnitRegex}'
    TimeNumberCombinedWithUnit = f'\\b(?<num>\\d+(\\.\\d*)?){TimeUnitRegex}'
    BusinessHourSplitStrings = [r'werk', r'uren']
    BusinessHourSplitStrings2 = [r'kantoor', r'uren']
    NowRegex = f'(?<!vanaf\\s+)\\b(?<now>nu(\\s+meteen)?|zo snel mogelijk|zo spoedig mogelijk|asap|recent|onlangs|zojuist)\\b'
    SuffixRegex = f'^\\s*(in de\\s+)?(vroege\\s+|late\\s+)?(ochtend|(na)?middag|avond|nacht)\\b'
    DateTimeTimeOfDayRegex = f'\\b(?<timeOfDay>morgen|ochtend|(na)?middag|avond|nacht)\\b'
    DateTimeSpecificTimeOfDayRegex = f'\\b(({RelativeRegex}\\s+{DateTimeTimeOfDayRegex})|van(nacht|avond|middag|ochtend|morgen))\\b'
    TimeOfTodayAfterRegex = f'^\\s*(,\\s*)?((in\\s+de)|(op\\s+de))?{DateTimeSpecificTimeOfDayRegex}'
    TimeOfTodayBeforeRegex = f'{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(om|rond|tegen|op\\s+de|op))?\\s*$'
    NonTimeContextTokens = f'\\b(gebouw)'
    SimpleTimeOfTodayAfterRegex = f'(?<!{NonTimeContextTokens}\\s*)\\b({HourNumRegex}|{BaseDateTime.HourRegex})(\\s*({OclockRegex}|u))?\\s*(,\\s*)?((in|op)\\s+de\\s+)?{DateTimeSpecificTimeOfDayRegex}'
    SimpleTimeOfTodayBeforeRegex = f'\\b{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(om|rond|tegen|op(\\s+de)?))?\\s*(?<!van(avond|nacht)\\s+)({HourNumRegex}|{BaseDateTime.HourRegex})\\b'
    SpecificEndOfRegex = f'((\\baan\\s+)?((de|het)\\s+)?eind(e? van)?(\\s+(de|het))?\\s*$|^\\s*(het\\s+)?einde? van(\\s+de(\\s+dag)))'
    UnspecificEndOfRegex = f'\\b(((om|rond|tegen|op)\\s+)?het\\s+)?(einde?\\s+van\\s+(de\\s+)?dag)\\b'
    UnspecificEndOfRangeRegex = f'\\b(evj)\\b'
    MiddlePauseRegex = f'\\s*(,)\\s*'
    PeriodTimeOfDayRegex = f'((in\\s+(de)?\\s+)?({EarlyLateRegex}(\\s+|-))?(zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag|(eer)?gisteren|morgen)?(?<timeOfDay>ochtend|(na)?middag|avond|nacht))\\b'
    PeriodSpecificTimeOfDayRegex = f'\\b(({StrictRelativeRegex}(\\s+)?{PeriodTimeOfDayRegex})\\b|\\bvan(nacht|avond|(na)?middag|ochtend))\\b'
    PeriodTimeOfDayWithDateRegex = f'(({TimeOfDayRegex}(\\s+(om|rond|van|tegen|op(\\s+de)?))?))\\b'
    PeriodTimeOfDayWithDateRegexWithAnchors = f'((({TimeOfDayRegex}(\\s+(om|rond|van|tegen|op(\\s+de)?))?))(?=({MiddlePauseRegex})?\\s*$)|(?<=^\\s*({MiddlePauseRegex})?)(?!{MealTimeRegex}){TimeOfDayRegex})'
    LessThanRegex = f'\\b((binnen\\s+)?minder\\s+dan)\\b'
    MoreThanRegex = f'\\b((meer|langer)\\s+dan|ruim)\\b'
    DurationUnitRegex = f'(?<unit>{DateUnitRegex}|(min\\.|sec\\.)|((?<half>halfuur)|(?<quarter>kwartier\\s+uur)|(?<quarter>kwartier)|uur|uren|u|minuten|minuut|m(ins?)?|seconde[ns]?|s(ecs?)?|nacht(en)?)\\b)(\\s+lang\\b)?'
    SuffixAndRegex = f'(?<suffix>\\s(\\s*en|ën)(\\s*een)?\\s*(?<suffix_num>hal(f|ve)|kwart|kwartier)|(?<suffix_num>(een\\s+)?kwartier))'
    PeriodicRegex = f'\\b(?<periodic>dagelijkse?|(drie)?maandelijkse?|wekelijkse?|twee-?wekelijkse?|(half)?jaarlijkse?|kwartaal)\\b'
    EachUnitRegex = f'(?<each>((iedere?|elke?|eenmaal per)(?<other>\\s+andere)?\\s*({DurationUnitRegex}|(?<specialUnit>weekend(en)?))|({DurationUnitRegex}|{WeekDayRegex})\\s+om(\\s+de)?(?<other>\\s+andere)?\\s*(week|{DurationUnitRegex})))'
    EachPrefixRegex = f'\\b(?<each>(iedere|elke|eenmaal per)\\s*$)'
    SetEachRegex = f'\\b(?<each>(iedere|elke|om\\s+de)\\s*(?<other>\\s+andere)?\\s*(week\\s*(?={WeekDayRegex}))?)'
    SetLastRegex = f'(?<last>volgende?|komende|aankomende|aanstaande|deze|huidige|aanstaande|vorige?|verleden|laatste)'
    EachDayRegex = f'^\\s*(iedere|elke)\\s*dag\\b'
    BeforeEachDayRegex = f'(iedere|elke)\\s*dag\\s*'
    DurationFollowedUnit = f'^\\s*((?<suffix>(?<unit>(?<suffix_num>(een\\s+)?kwartier)))|{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex})'
    NumberCombinedWithDurationUnit = f'\\b(?<num>\\d+([.,:]\\d*)?)(-)?{DurationUnitRegex}'
    AnUnitRegex = f'\\b((((nog een|een|nog)\\s+(?<half>anderhalf|anderhalve|half|halve)?))|andere)\\s*{DurationUnitRegex}'
    DuringRegex = f'\\b(voor\\s+een|gedurende\\s+(het|de))\\s+(?<unit>jaar|maand|week|dag)\\b'
    AllRegex = f'\\b(?<all>((de|het|een)\\s+)?((ge)?hele|volledige|ganse|heel|volledig|volle)(\\s+|-)(?<unit>jaar|maand|week|dag))\\b'
    HalfRegex = f'(((een)\\s*)|\\b)(?<half>(half|halve)\\s+(?<unit>jaar|maand|week|dag|uur|halfuur)|(?<unit>halfuur))\\b'
    ConjunctionRegex = f'\\b((en(\\s+voor)?)|plus)\\b'
    HolidayList1 = f'(?<holiday>goede vrijdag|pasen|((eerste|tweede)\\s+)?paasdag|paas(zondag|maandag)|kerst(avond|mis)?|thanksgiving|halloween|(islamitisch\\s+)?nieuwjaar|oud en nieuw|oud & nieuw|pinksteren|oude?jaar|oude?jaarsavond|silvester|silvesteravond|sinterklaas|sinterklaasfeest|sinterklaasavond|pakjesavond|eid al(-|\\s+)fitr|eid al(-|\\s+)adha|juneteenth|vrijheidsdag|jubilee\\s+day)'
    HolidayList2 = f'(?<holiday>black friday|cyber monday|nationale dodenherdenking|nationale herdenking|dodenherdenking|dag\\s+van\\s+de\\s+(leraar|leerkracht(en)?|arbeid|aarde)|feest\\s+van\\s+de\\s+arbeid|yuandan|valentijn|sint-maartensfeest|sint-maarten|driekoningen|keti(\\s+|-)?koti|ramadan|suikerfeest|offerfeest|allerheiligen|allerheiligenavond|franse nationale feestdag|bestorming van de bastille)'
    HolidayList3 = f'(?<holiday>(martin luther king|mlk|dankzeggings|valentijns|nieuwjaars|(eerste|1e|tweede|2e)\\s+paas|prinsjes|konings|koninginne|bevrijdings|hemelvaarts|(eerste|1e|tweede|2e)\\s+kerst|vader|moeder|meisjes|(amerikaanse|us\\s+)?onafhankelijk(heid)?s|(nederlandse\\s+)?veteranen|boomplant|(nationale\\s+)?boomfeest)dag)'
    HolidayRegex = f'\\b(({StrictRelativeRegex}\\s+({HolidayList1}|{HolidayList2}|{HolidayList3}))|(({HolidayList1}|{HolidayList2}|{HolidayList3})(\\s+(van\\s+)?({YearRegex}|{RelativeRegex}\\s+jaar))?))\\b'
    AMTimeRegex = f'(?<am>{ApostrofsRegex}\\s*(morgens|ochtends)|in\\s+de\\s+(morgen|ochtend))'
    PMTimeRegex = f'(?<pm>{ApostrofsRegex}\\s*(middags|avonds|nachts)|(in\\s+de\\s+)?(deze\\s+)?((na)?middag|avond|nacht))\\b'
    MorningTimeRegex = f'(morgens?|ochtends?)'
    NightTimeRegex = f'(nacht)'
    NowTimeRegex = f'\\b(nu)\\b'
    RecentlyTimeRegex = f'\\b(kort\\s+geleden|eerder)\\b'
    AsapTimeRegex = f'\\b(zo\\s+snel\\s+mogelijk|zsm)\\b'
    InclusiveModPrepositions = f'(?<include>((in|tegen|tijdens|op|om)\\s+of\\s+)|(\\s+of\\s+(in|tegen|tijdens|op)))'
    AfterRegex = f'(\\b{InclusiveModPrepositions}?((na(\\s+afloop\\s+van)?|(?<!niet\\s+)later\\s+dan)|(jaar\\s+na)|(het\\s+)?jaar hoger dan)(?!\\s+of\\s+gelijk\\s+aan){InclusiveModPrepositions}?\\b\\s*)|(?<!\\w|<)((?<include>>=)|>)'
    BeforeRegex = f'(\\b(?<!afspraak\\s*){InclusiveModPrepositions}?(voor|vóór|vooraf(gaand?)?\\s+aan|(niet\\s+later|vroeger|eerder)\\s+dan|eindigend\\s+(op|met)|tegen|totdat|(?<!terug\\s+)tot|uiterlijk|(?<include>(al\\s+)?zo\\s+laat\\s+als)){InclusiveModPrepositions}?\\b\\s*)|(?<!\\w|>)((?<include><=)|<)'
    SinceRegex = f'(\\b(sinds|na\\s+of\\s+gelijk\\s+aan|(startend|beginnend)\\s+(vanaf|op|met)|(al\\s+)?zo\\s+vroeg\\s+als|(elk|ieder)\\s+moment\\s+vanaf|een\\s+tijdstip\\s+vanaf)\\b\\s*)|(?<!\\w|<)(>=)'
    AgoRegex = f'\\b(geleden|(voor|eerder\\s+dan)\\s+(?<day>gisteren|vandaag))\\b'
    LaterRegex = f'\\b(later|vanaf\\s+nu|(vanaf|na|sedert)\\s+(?<day>morgen|vandaag))\\b'
    BeforeAfterRegex = f'\\b(gerekend\\s+)?((?<before>voor(dat)?)|(?<after>van(af)?|na))\\b'
    ModPrefixRegex = f'\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b'
    ModSuffixRegex = f'\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b'
    InConnectorRegex = f'\\b(in|over|na)(\\s+de)?\\b'
    SinceYearSuffixRegex = f'(^\\s*{SinceRegex}((vanaf|sedert|sinds)\\s+(het\\s+)?jaar\\s+)?{YearSuffix})'
    WithinNextPrefixRegex = f'\\b((binnen)(\\s+de|het)?(\\s+(?<next>{NextPrefixRegex}))?)\\b'
    TodayNowRegex = f'\\b(vandaag|nu)\\b'
    MorningStartEndRegex = f'(^(({ApostrofsRegex}|des)\\s+(morgens|ochtends)|in\\s+de\\s+(na)?(morgen|ochtend)|deze\\s+(morgen|ochtend)|(morgen|ochtend)\\s+in\\s+het\\s+begin|aan\\s+het\\s+einde?(\\s+van(\\s+de)?)?\\s+(morgen|ochtend)|{AmDescRegex}|(morgen|ochtend)))|((({ApostrofsRegex}|des)\\s+(morgens|ochtends)|deze\\s+(morgen|ochtend)|in\\s+de\\s+(na)?(morgen|ochtend)|(morgen|ochtend)\\s+in\\s+het\\s+begin|(morgen|ochtend)\\s+aan\\s+het\\s+einde?|{AmDescRegex}|(morgen|ochtend))$)'
    AfternoonStartEndRegex = f'(^(({ApostrofsRegex}|des)\\s+middags|in\\s+de\\s+(na)?middag|deze\\s+middag|aan\\s+het\\s+einde?(\\s+van(\\s+de)?)?\\s+middag|{PmDescRegex}))|((({ApostrofsRegex}|des)?\\s+middags|in\\s+de\\s+(na)?middag|deze\\s+middag|middag\\s+in\\s+het\\s+begin|middag\\s+aan\\s+het\\s+einde?|{PmDescRegex}|middag)$)'
    EveningStartEndRegex = f'(^(({ApostrofsRegex}|des)\\s+avonds|in\\s+de\\s+(na)?avond|deze\\s+avond|avond\\s+in\\s+het\\s+begin|aan\\s+het\\s+einde?(\\s+van(\\s+de)?)?\\s+avond|{PmDescRegex}|avond))|((({ApostrofsRegex}|des)?\\s+avonds|deze\\s+avond|in\\s+de\\s+(na)?avond|avond\\s+in\\s+het\\s+begin|avond\\s+aan\\s+het\\s+einde?|{PmDescRegex}|avond)$)'
    NightStartEndRegex = f'(^(gedurende de nacht|vannacht|nacht|({ApostrofsRegex}|des)?\\s+nachts))|((gedurende\\s+de\\s+nacht|vannacht|({ApostrofsRegex}|des)?\\s+nachts|nacht\\s+in\\s+het\\s+begin|nacht)$)'
    InexactNumberRegex = f'\\b((een\\s+)?aantal|meerdere|enkele|verscheidene|wat|enige|(?<NumTwoTerm>(een\\s+)?paar))\\b'
    InexactNumberUnitRegex = f'({InexactNumberRegex})\\s+({DurationUnitRegex})'
    RelativeTimeUnitRegex = f'((({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+({TimeUnitRegex}))|((de|het|mijn))\\s+({RestrictedTimeUnitRegex}))'
    RelativeDurationUnitRegex = f'(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+)({DurationUnitRegex}))|((the|my))\\s+({RestrictedTimeUnitRegex}))'
    ReferenceDatePeriodRegex = f'\\b{ReferencePrefixRegex}\\s+(?<duration>week|maand|jaar|decennium|weekend)\\b'
    ConnectorRegex = f'^(-|,|voor|t|rond(om)?|@)$'
    FromToRegex = f'\\b(van(af)?).+(tot)\\b.+'
    SingleAmbiguousMonthRegex = f'^(de\\s+)?(mei)$'
    SingleAmbiguousTermsRegex = f'^(de\\s+)?(dag|week|maand|jaar)$'
    UnspecificDatePeriodRegex = f'^(week|weekend|maand|jaar)$'
    PrepositionSuffixRegex = f'\\b((op|in)(\\s+de)?|om|rond(om)?|van|tot)$'
    FlexibleDayRegex = f'(?<DayOfMonth>([A-Za-zë]+\\s+)?[A-Za-zë\\d]+?\\s*(ste|de|e))'
    ForTheRegex = f'\\b((((?<=voor\\s+)de\\s+{FlexibleDayRegex})|((?<=op\\s+)de\\s+{FlexibleDayRegex}(?<=(ste|de|e))))(?<end>(\\s+(tussen|binnen|terug|tegen|aan|uit|mee|bij|vol|uit|aan|op|in|na|af)\\s*)?(\\s+(ge\\w\\w\\w+|\\w\\w\\w+en)\\s*)?(,|\\.|!|\\?|$)))'
    WeekDayAndDayOfMonthRegex = f'\\b{WeekDayRegex}\\s+(de\\s+{FlexibleDayRegex})\\b'
    WeekDayAndDayRegex = f'\\b{WeekDayRegex}\\s+{DayRegex}(?!([-]|:\\d+|\\.\\d+|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b'
    RestOfDateRegex = f'\\brest\\s+(van\\s+)?((de|het|mijn|dit|deze|(de\\s+)?huidige)\\s+)?(?<duration>week|maand|jaar|decennium)\\b'
    RestOfDateTimeRegex = f'\\brest\\s+(van\\s+)?((de|het|mijn|dit|deze|(de\\s+)?huidige)\\s+)?(?<unit>vandaag|dag)\\b'
    AmbiguousRangeModifierPrefix = f'(voor)'
    PotentialAmbiguousRangeRegex = f'\\b{AmbiguousRangeModifierPrefix}(?!\\s+het\\s+(einde?|begin(nen)?))(.+\\b(boven|later|groter|erna|daarna|hoger|(?<!de\\s+)({DateUnitRegex}|uur|uren|minuten|minuut|mins|min|secondes|seconden|secs|sec|nacht(en)?)|van(af)?|beginnend|die\\s+begint|startend|aanvangend|tussen|tot(dat|\\s+en\\s+met)?|gedurende|tijdens|ten tijde van|(?<ambiguous>{BaseDateTime.RangeConnectorSymbolRegex}))\\b)'
    NumberEndingPattern = f'^(\\s+((?<meeting>vergadering|afspraak|conferentie|telefoontje|skype-gesprek)\\s+)?(om|naar)\\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\\.)?$|(\\.,|,|!|\\?)))'
    OneOnOneRegex = f'\\b(1\\s*:\\s*1)|(één\\s+(op\\s)één|één\\s*-\\s*één|één\\s*:\\s*één)\\b'
    LaterEarlyPeriodRegex = f'\\b({PrefixPeriodRegex})\\s*\\b\\s*(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))\\b'
    WeekWithWeekDayRangeRegex = f'\\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|deze)\\s+week)((\\s+tussen\\s+{WeekDayRegex}\\s+en\\s+{WeekDayRegex})|(\\s+van\\s+{WeekDayRegex}\\s+tot\\s+{WeekDayRegex})))\\b'
    GeneralEndingRegex = f'^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$'
    DurationConnectorRegex = f'^\\s*(?<connector>\\s+|en|,)\\s*$'
    PrefixArticleRegex = f'\\bde\\s+'
    OrRegex = f'\\s*((\\b|,\\s*)(of|en)\\b|,)\\s*'
    YearPlusNumberRegex = f'\\b(jaar\\s+((?<year>(\\d{{3,4}}))|{FullTextYearRegex}))\\b'
    NumberAsTimeRegex = f'\\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\\b'
    TimeBeforeAfterRegex = f'\\b(((?<=\\b(voor|niet later dan|na|door)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b'
    DateNumberConnectorRegex = f'^\\s*(?<connector>\\s+om)\\s*$'
    DecadeRegex = f'(?<decade>(nul|tien|twintig|dertig|veertig|vijftig|zestig|zeventig|tachtig|negentig)|(fifties|sixties|seventies|eighties|nineties|zeroes|tens|tweeduizend|(ee|éé)nentwintigste\\s+eeuw))'
    DecadeWithCenturyRegex = f'\\b(de\\s+)?(jaren\\s+)?((?<!\\$)((?<=\\b(de|jaren)\\s+)(?<century>1\\d|2\\d|\\d)?({ApostrofRegex})?(?<decade>\\d0)({ApostrofRegex})?s?)(?!%)\\b|(({CenturyRegex}(\\s+|-)?(en\\s+)?|(?<=\\b(de|jaren)\\s+)){DecadeRegex})|({CenturyRegex}(\\s+|-)?(en\\s+)?(?<decade>tien|honderd)))'
    RelativeDecadeRegex = f'\\b(((de|het)\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?decenni(a|um)?)\\b'
    SuffixAfterRegex = f'\\b(((bij)\\s)?(of|en)\\s+(boven|later|groter|erna|daarna|hoger)(?!\\s+dan))\\b'
    DateAfterRegex = f'\\b((of|en)\\s+(hoger|later|groter)(?!\\s+dan))\\b'
    YearPeriodRegex = f'((((van(af)?|tijdens|gedurende|in)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((tussen)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))'
    StartMiddleEndRegex = f'\\b((?<StartOf>(((de|het)\\s+)?(start|begin)\\s+van\\s+)?)(?<MiddleOf>((het\\s+)?midden\\s+van\\s+)?)(?<EndOf>((het\\s+)?einde?\\s+van\\s+)?))'
    ComplexDatePeriodRegex = f'(((van(af)?|tijdens|gedurende|in(\\s+de)?)\\s+)?{StartMiddleEndRegex}(?<start>.+)\\s*({TillRegex})\\s*{StartMiddleEndRegex}(?<end>.+)|((tussen)\\s+){StartMiddleEndRegex}(?<start>.+)\\s*({RangeConnectorRegex})\\s*{StartMiddleEndRegex}(?<end>.+)|(?<start>{WrittenMonthRegex})\\s+(?<end>{WrittenMonthRegex}(\\s+|\\s*,\\s*){YearRegex}))'
    ComplexTillRegex = f'({TillRegex}|{WrittenMonthRegex})'
    UnitMap = dict([("millennium", "1000Y"),
                    ("eeuw", "100Y"),
                    ("centennium", "100Y"),
                    ("decennium", "10Y"),
                    ("decennia", "10Y"),
                    ("jaren", "Y"),
                    ("jaar", "Y"),
                    ("jr", "Y"),
                    ("maanden", "MON"),
                    ("maand", "MON"),
                    ("mnd", "MON"),
                    ("weken", "W"),
                    ("week", "W"),
                    ("weekend", "WE"),
                    ("weekenden", "WE"),
                    ("dagen", "D"),
                    ("dag", "D"),
                    ("werkdagen", "D"),
                    ("werkdag", "D"),
                    ("weekdagen", "D"),
                    ("weekdag", "D"),
                    ("vandaag", "D"),
                    ("dgn", "D"),
                    ("nachten", "D"),
                    ("nacht", "D"),
                    ("uren", "H"),
                    ("uur", "H"),
                    ("u", "H"),
                    ("minuten", "M"),
                    ("minuut", "M"),
                    ("min", "M"),
                    ("min.", "M"),
                    ("secondes", "S"),
                    ("seconden", "S"),
                    ("seconde", "S"),
                    ("secs", "S"),
                    ("sec", "S"),
                    ("kwartier", "H"),
                    ("kwartier uur", "H"),
                    ("halfuur", "H")])
    UnitValueMap = dict([("decennium", 315360000),
                         ("decennia", 315360000),
                         ("decenniën", 315360000),
                         ("jaren", 31536000),
                         ("jaar", 31536000),
                         ("jr", 31536000),
                         ("maanden", 2592000),
                         ("maand", 2592000),
                         ("mnd", 2592000),
                         ("weken", 604800),
                         ("week", 604800),
                         ("weekenden", 172800),
                         ("weekend", 172800),
                         ("dagen", 86400),
                         ("dag", 86400),
                         ("vandaag", 86400),
                         ("dgn", 86400),
                         ("nachten", 86400),
                         ("nacht", 86400),
                         ("werkdagen", 86400),
                         ("werkdag", 86400),
                         ("weekdagen", 86400),
                         ("weekdag", 86400),
                         ("uren", 3600),
                         ("uur", 3600),
                         ("u", 3600),
                         ("minuten", 60),
                         ("minuut", 60),
                         ("min", 60),
                         ("min.", 60),
                         ("secondes", 1),
                         ("seconden", 1),
                         ("seconde", 1),
                         ("secs", 1),
                         ("sec", 1),
                         ("kwartier", 3600),
                         ("kwartier uur", 3600),
                         ("halfuur", 3600)])
    SpecialYearPrefixesMap = dict([("", "")])
    SeasonMap = dict([("lente", "SP"),
                      ("zomer", "SU"),
                      ("herfst", "FA"),
                      ("winter", "WI")])
    SeasonValueMap = dict([("SP", 3),
                           ("SU", 6),
                           ("FA", 9),
                           ("WI", 12)])
    CardinalMap = dict([("eerste", 1),
                        ("1e", 1),
                        ("1ste", 1),
                        ("tweede", 2),
                        ("2e", 2),
                        ("2de", 2),
                        ("derde", 3),
                        ("3e", 3),
                        ("3de", 3),
                        ("vierde", 4),
                        ("4e", 4),
                        ("4de", 4),
                        ("vijfde", 5),
                        ("5e", 5),
                        ("5de", 5)])
    DayOfWeek = dict([("maandag", 1),
                      ("dinsdag", 2),
                      ("woensdag", 3),
                      ("donderdag", 4),
                      ("vrijdag", 5),
                      ("zaterdag", 6),
                      ("zondag", 0),
                      ("zondagmiddag", 0),
                      ("maandagen", 1),
                      ("dinsdagen", 2),
                      ("woensdagen", 3),
                      ("donderdagen", 4),
                      ("vrijdagen", 5),
                      ("zaterdagen", 6),
                      ("zondagen", 0),
                      ("ma", 1),
                      ("ma.", 1),
                      ("dins", 2),
                      ("dins.", 2),
                      ("woens", 3),
                      ("woens.", 3),
                      ("di", 2),
                      ("di.", 2),
                      ("wo", 3),
                      ("wo.", 3),
                      ("woe", 3),
                      ("woe.", 3),
                      ("do", 4),
                      ("do.", 4),
                      ("vr", 5),
                      ("vr.", 5),
                      ("vrij", 5),
                      ("vrij.", 5),
                      ("za", 6),
                      ("za.", 6),
                      ("zat", 6),
                      ("zat.", 6),
                      ("zo", 0),
                      ("zo.", 0),
                      ("zon", 0),
                      ("zon.", 0),
                      ("monday", 1),
                      ("tuesday", 2),
                      ("wednesday", 3),
                      ("thursday", 4),
                      ("friday", 5),
                      ("saturday", 6),
                      ("sunday", 0),
                      ("mon", 1),
                      ("tue", 2),
                      ("tues", 2),
                      ("wed", 3),
                      ("wedn", 3),
                      ("weds", 3),
                      ("thu", 4),
                      ("thur", 4),
                      ("thurs", 4),
                      ("fri", 5),
                      ("sat", 6),
                      ("sun", 0)])
    MonthOfYear = dict([("januari", 1),
                        ("februari", 2),
                        ("maart", 3),
                        ("april", 4),
                        ("mei", 5),
                        ("juni", 6),
                        ("juli", 7),
                        ("augustus", 8),
                        ("september", 9),
                        ("oktober", 10),
                        ("november", 11),
                        ("december", 12),
                        ("jan", 1),
                        ("feb", 2),
                        ("mar", 3),
                        ("mrt", 3),
                        ("apr", 4),
                        ("jun", 6),
                        ("jul", 7),
                        ("aug", 8),
                        ("sep", 9),
                        ("sept", 9),
                        ("oct", 10),
                        ("okt", 10),
                        ("nov", 11),
                        ("dec", 12),
                        ("jan.", 1),
                        ("feb.", 2),
                        ("mar.", 3),
                        ("mrt.", 3),
                        ("apr.", 4),
                        ("jun.", 6),
                        ("jul.", 7),
                        ("aug.", 8),
                        ("sep.", 9),
                        ("sept.", 9),
                        ("oct.", 10),
                        ("okt.", 10),
                        ("nov.", 11),
                        ("dec.", 12),
                        ("1", 1),
                        ("2", 2),
                        ("3", 3),
                        ("4", 4),
                        ("5", 5),
                        ("6", 6),
                        ("7", 7),
                        ("8", 8),
                        ("9", 9),
                        ("10", 10),
                        ("11", 11),
                        ("12", 12),
                        ("01", 1),
                        ("02", 2),
                        ("03", 3),
                        ("04", 4),
                        ("05", 5),
                        ("06", 6),
                        ("07", 7),
                        ("08", 8),
                        ("09", 9)])
    Numbers = dict([("nul", 0),
                    ("een", 1),
                    ("één", 1),
                    ("twee", 2),
                    ("drie", 3),
                    ("vier", 4),
                    ("vijf", 5),
                    ("zes", 6),
                    ("zeven", 7),
                    ("acht", 8),
                    ("negen", 9),
                    ("tien", 10),
                    ("elf", 11),
                    ("elven", 11),
                    ("twaalf", 12),
                    ("dertien", 13),
                    ("veertien", 14),
                    ("vijftien", 15),
                    ("zestien", 16),
                    ("zeventien", 17),
                    ("achttien", 18),
                    ("negentien", 19),
                    ("twintig", 20),
                    ("eenentwintig", 21),
                    ("éénentwintig", 21),
                    ("tweeentwintig", 22),
                    ("tweeëntwintig", 22),
                    ("drieëntwintig", 23),
                    ("vierentwintig", 24),
                    ("vijfentwintig", 25),
                    ("vijventwintig", 25),
                    ("zesentwintig", 26),
                    ("zevenentwintig", 27),
                    ("achtentwintig", 28),
                    ("negenentwintig", 29),
                    ("dertig", 30),
                    ("eenendertig", 31),
                    ("tweeëndertig", 32),
                    ("drieëndertig", 33),
                    ("vierendertig", 34),
                    ("vijfendertig", 35),
                    ("zesendertig", 36),
                    ("zevenendertig", 37),
                    ("achtendertig", 38),
                    ("negenendertig", 39),
                    ("veertig", 40),
                    ("eenenveertig", 41),
                    ("tweeënveertig", 42),
                    ("drieënveertig", 43),
                    ("vierenveertig", 44),
                    ("vijfenveertig", 45),
                    ("zesenveertig", 46),
                    ("zevenenveertig", 47),
                    ("achtenveertig", 48),
                    ("negenenveertig", 49),
                    ("eenenvijftig", 50),
                    ("vijftig", 51),
                    ("tweeënvijftig", 52),
                    ("drieënvijftig", 53),
                    ("vierenvijftig", 54),
                    ("vijfenvijftig", 55),
                    ("zesenvijftig", 56),
                    ("zevenenvijftig", 57),
                    ("achtenvijftig", 58),
                    ("negenenvijftig", 59),
                    ("zestig", 60),
                    ("eenenzestig", 61),
                    ("tweeënzestig", 62),
                    ("drieënzestig", 63),
                    ("vierenzestig", 64),
                    ("vijfenzestig", 65),
                    ("zesenzestig", 66),
                    ("zevenenzestig", 67),
                    ("achtenzestig", 68),
                    ("negenenzestig", 69),
                    ("zeventig", 70),
                    ("eenenzeventig", 71),
                    ("tweeënzeventig", 72),
                    ("drieënzeventig", 73),
                    ("vierenzeventig", 74),
                    ("vijfenzeventig", 75),
                    ("zesenzeventig", 76),
                    ("zevenenzeventig", 77),
                    ("achtenzeventig", 78),
                    ("negenenzeventig", 79),
                    ("tachtig", 80),
                    ("eenentachtig", 81),
                    ("tweeëntachtig", 82),
                    ("drieëntachtig", 83),
                    ("vierentachtig", 84),
                    ("vijfentachtig", 85),
                    ("zesentachtig", 86),
                    ("zevenentachtig", 87),
                    ("achtentachtig", 88),
                    ("negenentachtig", 89),
                    ("negentig", 90),
                    ("eenennegentig", 91),
                    ("tweeënnegentig", 92),
                    ("drieënnegentig", 93),
                    ("vierennegentig", 94),
                    ("vijfennegentig", 95),
                    ("zesennegentig", 96),
                    ("zevenennegentig", 97),
                    ("achtennegentig", 98),
                    ("negenennegentig", 99),
                    ("honderd", 100)])
    DayOfMonth = dict([("1e", 1),
                       ("1ste", 1),
                       ("2e", 2),
                       ("2de", 2),
                       ("3e", 3),
                       ("3de", 3),
                       ("4e", 4),
                       ("4de", 4),
                       ("5e", 5),
                       ("5de", 5),
                       ("6e", 6),
                       ("6de", 6),
                       ("7e", 7),
                       ("7de", 7),
                       ("8e", 8),
                       ("8de", 8),
                       ("9e", 9),
                       ("9de", 9),
                       ("10e", 10),
                       ("10de", 10),
                       ("11e", 11),
                       ("11de", 11),
                       ("12e", 12),
                       ("12de", 12),
                       ("13e", 13),
                       ("13de", 13),
                       ("14e", 14),
                       ("14de", 14),
                       ("15e", 15),
                       ("15de", 15),
                       ("16e", 16),
                       ("16de", 16),
                       ("17e", 17),
                       ("17de", 17),
                       ("18e", 18),
                       ("19e", 19),
                       ("20e", 20),
                       ("21e", 21),
                       ("22e", 22),
                       ("23e", 23),
                       ("24e", 24),
                       ("25e", 25),
                       ("26e", 26),
                       ("27e", 27),
                       ("28e", 28),
                       ("29e", 29),
                       ("30e", 30),
                       ("31e", 31)])
    DoubleNumbers = dict([("half", 0.5),
                          ("anderhalf", 1.5),
                          ("anderhalve", 1.5),
                          ("halve", 0.5),
                          ("een kwartier", 0.25),
                          ("kwartier", 0.25),
                          ("kwart", 0.25),
                          ("driekwart", 0.75),
                          ("drie kwart", 0.75),
                          ("kwartaal", 0.25)])
    HolidayNames = dict([("kingsday", ["koningsdag"]),
                         ("queensday", ["koninginnedag"]),
                         ("prinsjesdag", ["prinsjesdag"]),
                         ("dodenherdenking", ["nationaledodenherdenking", "nationaleherdenking", "dodenherdenking"]),
                         ("bevrijdingsdag", ["bevrijdingsdag"]),
                         ("teachersday", ["dagvandeleraar", "dagvandeleerkracht", "dagvandeleerkrachten"]),
                         ("veteransday", ["nederlandseveteranendag", "veteranendag"]),
                         ("eerstekerstdag", ["eerstekerstdag", "1ekerstdag"]),
                         ("tweedekerstdag", ["tweedekerstdag", "2ekerstdag"]),
                         ("dagvandearbeid", ["dagvandearbeid", "feestvandearbeid"]),
                         ("treeplantingday", ["nationaleboomfeestdag", "boomfeestdag", "boomplantdag"]),
                         ("sinterklaas", ["sinterklaas", "sinterklaasavond", "sinterklaasfeest", "pakjesavond"]),
                         ("driekoningen", ["driekoningen"]),
                         ("ketikoti", ["ketikoti", "keti-koti"]),
                         ("stmartinsday", ["sint-maartensfeest", "sint-maarten"]),
                         ("ascensionday", ["hemelvaartsdag"]),
                         ("whitesunday", ["pinksteren"]),
                         ("christmas", ["kerstfeest", "kerstmis", "kerst", "xmas"]),
                         ("easterday", ["pasen", "eerstepaasdag", "paasdag", "paaszondag"]),
                         ("eastermonday", ["tweedepaasdag", "paasmaandag"]),
                         ("fathers", ["vaderdag"]),
                         ("goodfriday", ["goedevrijdag"]),
                         ("mothers", ["moederdag"]),
                         ("newyear", ["nieuwjaar"]),
                         ("newyearday", ["nieuwjaarsdag"]),
                         ("newyearsday", ["nieuwjaarsdag"]),
                         ("newyeareve", ["oudjaar", "oudejaar", "oudejaarsavond", "oudjaarsavond", "silvester", "silvesteravond", "oudennieuw", "oud&nieuw"]),
                         ("valentinesday", ["valentijnsdag", "valetijnsdag"]),
                         ("independenceday", ["onafhankelijkheidsdag", "onafhankelijksdag"]),
                         ("bastilleday", ["fransenationalefeestdag", "bestormingvandebastille"]),
                         ("halloweenday", ["halloween", "allerheiligenavond"]),
                         ("allhallowday", ["allerheiligen"]),
                         ("allsoulsday", ["allerzielen"]),
                         ("christmaseve", ["kerstavond"]),
                         ("yuandan", ["yuandan"]),
                         ("chinesenewyear", ["chineesnieuwjaar", "lentefestival", "lentefeest"]),
                         ("ramadan", ["ramadan"]),
                         ("eidalfitr", ["eidalfitr", "suikerfeest"]),
                         ("sacrifice", ["eidaladha", "offerfeest"]),
                         ("islamicnewyear", ["islamitischnieuwjaar"]),
                         ("thanksgiving", ["thanksgivingday", "thanksgiving", "dankzeggingsdag"]),
                         ("martinlutherking", ["martinlutherkingday", "martinlutherkingjrday", "martinlutherkingdag", "mlkdag"]),
                         ("usindependenceday", ["amerikaanseonafhankelijkheidsdag", "usonafhankelijkheidsdag"]),
                         ("blackfriday", ["blackfriday"]),
                         ("cybermonday", ["cybermonday"]),
                         ("earthday", ["dagvandeaarde"]),
                         ("juneteenth", ["jubileeday", "juneteenth", "vrijheidsdag"])])
    WrittenDecades = dict([("jaren 0", 0),
                           ("jaren nul", 0),
                           ("jaren 10", 10),
                           ("jaren tien", 10),
                           ("jaren 20", 20),
                           ("jaren twintig", 20),
                           ("twintiger jaren", 20),
                           ("jaren 30", 30),
                           ("jaren dertig", 30),
                           ("dertiger jaren", 30),
                           ("jaren 40", 40),
                           ("jaren veertig", 40),
                           ("veertiger jaren", 40),
                           ("jaren 50", 50),
                           ("jaren vijftig", 50),
                           ("vijftiger jaren", 50),
                           ("jaren 60", 60),
                           ("jaren zestig", 60),
                           ("zestiger jaren", 60),
                           ("jaren 70", 70),
                           ("jaren zeventig", 70),
                           ("zeventiger jaren", 70),
                           ("jaren 80", 80),
                           ("jaren tachtig", 80),
                           ("tachtiger jaren", 80),
                           ("jaren 90", 90),
                           ("jaren negentig", 90),
                           ("nul", 0),
                           ("tien", 10),
                           ("twintig", 20),
                           ("twintiger", 20),
                           ("dertig", 30),
                           ("dertiger", 30),
                           ("veertig", 40),
                           ("veertiger", 40),
                           ("vijftig", 50),
                           ("vijftiger", 50),
                           ("zestig", 60),
                           ("zestiger", 60),
                           ("zeventig", 70),
                           ("zeventiger", 70),
                           ("tachtig", 80),
                           ("tachtiger", 80),
                           ("negentig", 90),
                           ("negentiger", 90),
                           ("honderd", 0)])
    SpecialDecadeCases = dict([("21e eeuw", 2000),
                               ("eenentwintigste eeuw", 2000),
                               ("tweeduizend", 2000),
                               ("jaren nul", 0),
                               ("nul", 0)])
    DefaultLanguageFallback = 'DMY'
    SuperfluousWordList = [r'preferably', r'how about', r'maybe', r'say', r'like']
    DurationDateRestrictions = [r'vandaag', r'nu']
    AmbiguityFiltersDict = dict([("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"),
                                 ("\\b(ontbijt|lunch|avondeten)$", "(?<!\\b(op|om|voor|na(ar)?|rond)(\\s+(het|de))?\\s+)(ontbijt|lunch|avondeten)"),
                                 ("^(morgen|middag|avond|nacht|dag)\\b", "\\b(goe[di]en?\\s*(morgen|middag|avond|nacht|dag))\\b"),
                                 ("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}"),
                                 ("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")])
    AmbiguityTimeFiltersDict = dict([("^(\\d{1,2}|\\p{L}+)\\s+uur$", "(?<LB>(?<!\\b(om|is|vanaf|morgen|vandaag|gisteren|\\d+)(\\s+(\\d{1,2}|\\p{L}+)\\s+uur\\s+(of|en))?\\s+)\\b(\\d{1,2}|\\p{L}+)\\s+uur\\b)(?(LB)(?!\\s+(tot|morgen|vandaag|gisteren|\\d+)\\b))")])
    MorningTermList = [r'morgen', r'morgens', r'ochtend', r'ochtends']
    AfternoonTermList = [r'middag', r'namiddag', r'voormiddag']
    EveningTermList = [r'avond', r'avonden']
    MealtimeBreakfastTermList = [r'ontbijt']
    MealtimeLunchTermList = [r'lunch', r'lunchtijd']
    MealtimeDinnerTermList = [r'avondeten']
    DaytimeTermList = [r'dag', r'overdag']
    NightTermList = [r'nacht']
    SameDayTerms = [r'vandaag', r'huidige dag', r'huidige datum', r'actuele datum', r'actuele dag', r'deze morgen', r'actuele morgen', r'vanmorgen']
    PlusOneDayTerms = [r'morgen', r'dag na', r'dag erna', r'volgende dag', r'morgenochtend', r'morgenavond']
    MinusOneDayTerms = [r'gisteren', r'dag voor', r'dag ervoor', r'vorige dag', r'gisterenochtend', r'gisterenavond']
    PlusTwoDayTerms = [r'overmorgen', r'dag na morgen']
    MinusTwoDayTerms = [r'eergisteren']
    FutureTerms = [r'deze', r'volgend', r'volgende', r'eropvolgend', r'eropvolgende', r'dit', r'die']
    LastCardinalTerms = [r'vorige', r'laatste']
    MonthTerms = [r'maand', r'maanden']
    MonthToDateTerms = [r'maand tot heden', r'maand tot op heden', r'vanaf vorig maandeinde']
    WeekendTerms = [r'weekend', r'weekenden']
    WeekTerms = [r'week']
    YearTerms = [r'jaar', r'jaren']
    GenericYearTerms = [r'j']
    YearToDateTerms = [r'jaar tot heden', r'jaar tot op heden', r'vanaf vorig jaareinde']
    DayTypeRegex = f'^((we[er]k)?dag(en|elijkse?)?)$'
    WeekTypeRegex = f'^(wekelijkse?|week)$'
    WeekendTypeRegex = f'^(weekend(en)?)$'
    BiWeekTypeRegex = f'^(tweewekelijkse?)$'
    MonthTypeRegex = f'^(maand(elijkse?)?)$'
    QuarterTypeRegex = f'^(kwartaal|driemaandelijkse?)$'
    YearTypeRegex = f'^(elk\\s+jaar|jaar(lijkse?)?)$'
    SemiYearTypeRegex = f'^(halfjaar(lijkse?)?)$'
# pylint: enable=line-too-long
