// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

import { BaseDateTime } from "./baseDateTime";
export namespace SpanishDateTime {
    export const LangMarker = `Spa`;
    export const CheckBothBeforeAfter = false;
    export const TillRegex = `(?<till>\\b(hasta|hacia|al?)\\b(\\s+(el|la(s)?)\\b)?|${BaseDateTime.RangeConnectorSymbolRegex})`;
    export const StrictTillRegex = `(?<till>\\b(hasta|hacia|al?)(\\s+(el|la(s)?))?\\b|${BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*[qt][1-4](?!(\\s+de|\\s*,\\s*))))`;
    export const RangeConnectorRegex = `(?<and>\\b(y\\s*(el|(la(s)?)?))\\b|${BaseDateTime.RangeConnectorSymbolRegex})`;
    export const WrittenDayRegex = `(?<day>uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieciséis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintidós|veintitrés|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|treinta(\\s+y\\s+uno)?)`;
    export const DayRegex = `\\b(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(?:\\.[º°])?(?=\\b|t)`;
    export const MonthNumRegex = `(?<month>1[0-2]|(0)?[1-9])\\b`;
    export const OclockRegex = `(?<oclock>en\\s+punto)`;
    export const AmDescRegex = `(${BaseDateTime.BaseAmDescRegex})`;
    export const PmDescRegex = `(${BaseDateTime.BasePmDescRegex})`;
    export const AmPmDescRegex = `(${BaseDateTime.BaseAmPmDescRegex})`;
    export const DescRegex = `(?<desc>(${AmDescRegex}|${PmDescRegex}))`;
    export const OfPrepositionRegex = `(\\bd(o|al?|el?)\\b)`;
    export const AfterNextSuffixRegex = `\\b(despu[eé]s\\s+de\\s+la\\s+pr[oó]xima)\\b`;
    export const NextSuffixRegex = `\\b(que\\s+viene|pr[oó]xim[oa]|siguiente)\\b`;
    export const PreviousSuffixRegex = `\\b(pasad[ao]|anterior(?!\\s+(al?|del?)\\b))\\b`;
    export const RelativeSuffixRegex = `(${AfterNextSuffixRegex}|${NextSuffixRegex}|${PreviousSuffixRegex})`;
    export const RangePrefixRegex = `((de(l|sde)?|entre)(\\s+la(s)?)?)`;
    export const TwoDigitYearRegex = `\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|${AmDescRegex}|${PmDescRegex}|\\.\\d))|\\.?[º°ª])\\b`;
    export const RelativeRegex = `(?<order>est[ae]s?|pr[oó]xim[oa]s?|siguiente|(([uú]ltim|pasad)[ao]s?))\\b`;
    export const StrictRelativeRegex = `(?<order>est[ae]|pr[oó]xim[oa]|siguiente|(([uú]ltim|pasad)(o|as|os)))\\b`;
    export const WrittenOneToNineRegex = `(un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)`;
    export const WrittenOneHundredToNineHundredRegex = `(doscient[oa]s|trescient[oa]s|cuatrocient[ao]s|quinient[ao]s|seiscient[ao]s|setecient[ao]s|ochocient[ao]s|novecient[ao]s|cien(to)?)`;
    export const WrittenOneToNinetyNineRegex = `(((treinta|cuarenta|cincuenta|sesenta|setenta|ochenta|noventa)(\\s+y\\s+${WrittenOneToNineRegex})?)|diez|once|doce|trece|catorce|quince|dieciséis|dieciseis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintiún|veintiun|veintiuna|veintidós|veintidos|veintitrés|veintitres|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)`;
    export const FullTextYearRegex = `\\b(?<fullyear>((dos\\s+)?mil)(\\s+${WrittenOneHundredToNineHundredRegex})?(\\s+${WrittenOneToNinetyNineRegex})?)`;
    export const YearRegex = `(${BaseDateTime.FourDigitYearRegex}|${FullTextYearRegex})`;
    export const RelativeMonthRegex = `(?<relmonth>(de\\s+)?((este|pr[oó]ximo|([uú]ltim(o|as|os)))\\s+mes)|(del\\s+)?(mes\\s+((que\\s+viene)|pasado)))\\b`;
    export const MonthRegex = `\\b(?<month>abr(\\.|(il)?\\b)|ago(\\.|(sto)?\\b)|dic(\\.|(iembre)?\\b)|feb(\\.|(rero)?\\b)|ene(\\.|(ro)?\\b)|ju[ln](\\.|(io)?\\b)|mar(\\.|(zo)?\\b)|may(\\.|(o)?\\b)|nov(\\.|(iembre)?\\b)|oct(\\.|(ubre)?\\b)|sep?t(\\.|(iembre)?\\b)|sep(\\.|\\b))`;
    export const MonthSuffixRegex = `(?<msuf>((del?|la|el)\\s+)?(${RelativeMonthRegex}|${MonthRegex}))`;
    export const DateUnitRegex = `(?<unit>(año|(?<uoy>semana))(?<plural>s)?|(?<uoy>mes)(?<plural>es)?|(?<uoy>d[ií]a)(?<plural>s)?(?<business>\\s+(h[aá]biles|laborales))?)\\b`;
    export const PastRegex = `(?<past>\\b(pasad(a|o)(s)?|[uú]ltim[oa](s)?|anterior(es)?|previo(s)?)\\b)`;
    export const FutureRegex = `\\b(siguiente(s)?|pr[oó]xim[oa](s)?)\\b`;
    export const SimpleCasesRegex = `\\b((desde(\\s+el)?|entre|del?)\\s+)?(${DayRegex})\\s*${TillRegex}\\s*(${DayRegex})\\s+${MonthSuffixRegex}((\\s+|\\s*,\\s*)((en|del?)\\s+)?${YearRegex})?\\b`;
    export const MonthFrontSimpleCasesRegex = `\\b${MonthSuffixRegex}\\s+((desde(\\s+el)?|entre|del)\\s+)?(${DayRegex})\\s*${TillRegex}\\s*(${DayRegex})((\\s+|\\s*,\\s*)((en|del?)\\s+)?${YearRegex})?\\b`;
    export const MonthFrontBetweenRegex = `\\b${MonthSuffixRegex}\\s+((entre(\\s+el)?)\\s+)(${DayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex})((\\s+|\\s*,\\s*)((en|del?)\\s+)?${YearRegex})?\\b`;
    export const DayBetweenRegex = `\\b((entre(\\s+el)?)\\s+)(${DayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex})\\s+${MonthSuffixRegex}((\\s+|\\s*,\\s*)((en|del?)\\s+)?${YearRegex})?\\b`;
    export const SpecialYearPrefixes = `((del\\s+)?calend[aá]rio|(?<special>fiscal|escolar))`;
    export const OneWordPeriodRegex = `\\b(((((la|el)\\s+)?mes\\s+((${OfPrepositionRegex})\\s+)?)|((pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?)\\s+))?(${MonthRegex})|((el\\s+)?${RelativeRegex}\\s+)?((${SpecialYearPrefixes}\\s+)año|año\\s+${SpecialYearPrefixes})|(((la|el)\\s+)?(((${RelativeRegex}\\s+)(${DateUnitRegex}|(fin\\s+de\\s+)?semana|finde)(\\s+${RelativeSuffixRegex})?)|${DateUnitRegex}(\\s+${RelativeSuffixRegex}))|va\\s+de\\s+${DateUnitRegex}|((año|mes)(\\s+(a|hasta)\\s+la\\s+fecha)?|((el\\s+)?fin\\s+de\\s+)?semana|(el\\s+)?finde))\\b)`;
    export const MonthWithYearRegex = `\\b((((pr[oó]xim[oa](s)?|est?[ae]|[uú]ltim[oa]?)\\s+)?${MonthRegex}|((el\\s+)?(?<cardinal>primero?|1(er|ro)|segundo|2do|tercero?|3(er|ro)|uarto|4to|quinto|5to|sexto|6to|s[eé]ptimo|7mo|octavo|8vo|noveno|9no|d[eé]cimo|10mo|und[eé]cimo|11mo|duod[eé]cimo|12mo|[uú]ltimo)\\s+mes(?=\\s+(del?|en))))((\\s+|(\\s*[,-]\\s*))((de(l|\\s+la)?|en)\\s+)?(${YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+año)|\\s+(del?|en)\\s+${TwoDigitYearRegex}))\\b`;
    export const MonthNumWithYearRegex = `\\b((${YearRegex}(\\s*?)[/\\-\\.~](\\s*?)${MonthNumRegex})|(${MonthNumRegex}(\\s*?)[/\\-\\.~](\\s*?)${YearRegex}))\\b`;
    export const WeekOfMonthRegex = `(?<wom>(la\\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|([12345](\\.)?ª)|[uú]ltima)\\s+semana\\s+${MonthSuffixRegex}((\\s+de)?\\s+(${BaseDateTime.FourDigitYearRegex}|${RelativeRegex}\\s+año))?)\\b`;
    export const WeekOfYearRegex = `(?<woy>(la\\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|[uú]ltima?|([12345]ª))\\s+semana(\\s+(del?|en))?\\s+(${YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año))`;
    export const OfYearRegex = `\\b((del?)\\s+(${YearRegex}|${StrictRelativeRegex}\\s+año))\\b`;
    export const FirstLastRegex = `\\b((el|las?|los?)\\s+)?((?<first>primer([ao]s?)?)|(?<last>[uú]ltim[ao]s?))\\b`;
    export const FollowedDateUnit = `^\\s*${DateUnitRegex}`;
    export const NumberCombinedWithDateUnit = `\\b(?<num>\\d+(\\.\\d*)?)${DateUnitRegex}`;
    export const QuarterTermRegex = `\\b((?<cardinal>primer|1er|segundo|2do|tercer|3ro|4to|([1234](\\.)?º))\\s+(trimestre|cuarto)|[tq](?<number>[1-4]))\\b`;
    export const RelativeQuarterTermRegex = `\\b((?<orderQuarter>${StrictRelativeRegex})\\s+(trimestre|cuarto)|(trimestre|cuarto)\\s+(?<orderQuarter>(actual|pr[oó]ximo|siguiente|pasado|anterior)))\\b`;
    export const QuarterRegex = `(el\\s+)?${QuarterTermRegex}((\\s+(del?\\s+)?|\\s*[,-]\\s*)(${YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+a[ñn]o|a[ñn]o(\\s+${RelativeSuffixRegex}))|\\s+del\\s+a[ñn]o)?|${RelativeQuarterTermRegex}`;
    export const QuarterRegexYearFront = `(${YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+a[ñn]o)(?:\\s*-\\s*|\\s+(el\\s+)?)?${QuarterTermRegex}`;
    export const AllHalfYearRegex = `\\b(?<cardinal>primer|1er|segundo|2do|[12](\\.)?º)\\s+semestre(\\s+(de\\s+)?(${YearRegex}|${RelativeRegex}\\s+año))?\\b`;
    export const EarlyPrefixRegex = `\\b(?<EarlyPrefix>(?<RelEarly>m[aá]s\\s+temprano(\\s+(del?|en))?)|((comienzos?|inicios?|principios?|temprano)\\s+(${OfPrepositionRegex}(\\s+d[ií]a)?)))(\\s+(el|las?|los?))?\\b`;
    export const MidPrefixRegex = `\\b(?<MidPrefix>(media[dn]os\\s+(${OfPrepositionRegex})))(\\s+(el|las?|los?))?\\b`;
    export const LaterPrefixRegex = `\\b(?<LatePrefix>((fin(al)?(es)?|[uú]ltimos)\\s+(${OfPrepositionRegex}))|(?<RelLate>m[aá]s\\s+tarde(\\s+(del?|en))?))(\\s+(el|las?|los?))?\\b`;
    export const PrefixPeriodRegex = `(${EarlyPrefixRegex}|${MidPrefixRegex}|${LaterPrefixRegex})`;
    export const PrefixDayRegex = `\\b((?<EarlyPrefix>(comienzos?|inicios?|principios?|temprano))|(?<MidPrefix>mediados)|(?<LatePrefix>(fin((al)?es)?|m[aá]s\\s+tarde)))(\\s+(en|${OfPrepositionRegex}))?(\\s+([ae]l)(\\s+d[ií]a)?)?$`;
    export const CenturySuffixRegex = `(^siglo)\\b`;
    export const SeasonRegex = `\\b(?<season>(([uú]ltim[oa]|est[ea]|el|la|(pr[oó]xim[oa]s?|siguiente)|${PrefixPeriodRegex})\\s+)?(?<seas>primavera|verano|otoño|invierno)((\\s+(del?|en)|\\s*,\\s*)?\\s+(${YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año))?)\\b`;
    export const WhichWeekRegex = `\\b(semana)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+del?\\s+(${YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año|año\\s+(?<order>pasado)))?\\b`;
    export const WeekOfRegex = `((del?|el|la)\\s+)?(semana)(\\s*)(${OfPrepositionRegex}|que\\s+(inicia|comienza)\\s+el|(que\\s+va|a\\s+partir)\\s+del)`;
    export const MonthOfRegex = `(mes)(\\s+)(${OfPrepositionRegex})`;
    export const RangeUnitRegex = `\\b(?<unit>años?|mes(es)?|semanas?)\\b`;
    export const BeforeAfterRegex = `^[.]`;
    export const InConnectorRegex = `\\b(en)(?=\\s*$)\\b`;
    export const TodayNowRegex = `\\b(hoy|ahora|este entonces)\\b`;
    export const FromRegex = `((\\bde(sde)?)(\\s*la(s)?)?)$`;
    export const BetweenRegex = `(\\bentre\\s*(la(s)?)?)`;
    export const WeekDayRegex = `\\b(?<weekday>(domingos?|lunes|martes|mi[eé]rcoles|jueves|viernes|s[aá]bados?)\\b|(lun|mar|mi[eé]|jue|vie|s[aá]b|dom|lu|ma|mi|ju|vi|s[aá]|do)(\\.|\\b))(?!ñ)`;
    export const OnRegex = `((?<=\\b(e[ln])\\s+)|(\\be[ln]\\s+d[ií]a\\s+))(${DayRegex}s?)(?![.,]\\d)\\b`;
    export const RelaxedOnRegex = `(?<=\\b(en|d?el)\\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1st|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)s?)(?![.,]\\d)\\b`;
    export const SpecialDayRegex = `\\b((el\\s+)?(d[ií]a\\s+antes\\s+de\\s+ayer|anteayer)|((el\\s+)?d[ií]a\\s+(despu[eé]s\\s+)?de\\s+mañana|pasado\\s+mañana)|(el\\s)?d[ií]a\\s+(siguiente|anterior)|(el\\s)?pr[oó]ximo\\s+d[ií]a|(el\\s+)?[uú]ltimo\\s+d[ií]a|(d)?el\\s+d[ií]a(?!\\s+(de|internacional))|ayer|mañana|hoy)\\b`;
    export const SpecialDayWithNumRegex = `^[.]`;
    export const FlexibleDayRegex = `(?<DayOfMonth>([a-z]+\\s)?(${WrittenDayRegex}|${DayRegex}))`;
    export const ForTheRegex = `\\b((((?<=para\\s+el\\s+)${FlexibleDayRegex})|((?<!(\\b${MonthRegex},?|\\bpara)\\s+(el\\s+)|${WeekDayRegex}\\s+(el\\s+)?)((?<=(e[ln]\\s+))|(\\be[ln]\\s+d[ií]a\\s+))${FlexibleDayRegex}))(?<end>\\s*(,|\\.(?![º°ª])|!|\\?|-|$))(?!\\d))`;
    export const WeekDayAndDayOfMonthRegex = `\\b${WeekDayRegex}\\s+((el\\s+(d[ií]a\\s+)?)${FlexibleDayRegex})\\b`;
    export const WeekDayAndDayRegex = `\\b${WeekDayRegex}\\s+(${DayRegex}|${WrittenDayRegex})(?!([-:/]|\\.\\d|(\\s+(${AmDescRegex}|${PmDescRegex}|${OclockRegex}))))\\b`;
    export const WeekDayOfMonthRegex = `(?<wom>(el\\s+)?(?<cardinal>primera?|1era?|segund[ao]|2d[ao]|tercera?|3era?|cuart[ao]|4t[ao]|quint[ao]|5t[ao]|((1|2|3|4|5)(\\.)?[ºª])|[uú]ltim[ao])\\s+(semana\\s+${MonthSuffixRegex}\\s+el\\s+${WeekDayRegex}|${WeekDayRegex}\\s+${MonthSuffixRegex}))`;
    export const RelativeWeekDayRegex = `^[.]`;
    export const AmbiguousRangeModifierPrefix = `^[.]`;
    export const NumberEndingPattern = `^[.]`;
    export const DateTokenPrefix = `en `;
    export const TimeTokenPrefix = `a las `;
    export const TokenBeforeDate = `el `;
    export const TokenBeforeTime = `a las `;
    export const HalfTokenRegex = `^((y\\s+)?media)`;
    export const QuarterTokenRegex = `^((y\\s+)?cuarto|(?<neg>menos\\s+cuarto))`;
    export const PastTokenRegex = `\\b(pasad[ao]s(\\s+(de\\s+)?las)?)$`;
    export const ToTokenRegex = `\\b((para|antes)(\\s+(de\\s+)?las?)|(?<neg>^menos))$`;
    export const SpecialDateRegex = `(?<=\\b(en)\\s+el\\s+)${DayRegex}\\b`;
    export const OfMonthRegex = `^\\s*((d[ií]a\\s+)?d[eo]\\s+)?${MonthSuffixRegex}`;
    export const MonthEndRegex = `(${MonthRegex}\\s*(el)?\\s*$)`;
    export const WeekDayEnd = `${WeekDayRegex}\\s*,?\\s*$`;
    export const WeekDayStart = `^\\b$`;
    export const DateYearRegex = `(?<year>${YearRegex}|(?<!,\\s?)${TwoDigitYearRegex}|${TwoDigitYearRegex}(?=(\\.(?!\\d)|[?!;]|$)))`;
    export const DateExtractor1 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?(?<!\\d[.,])${DayRegex}((\\s*(d[eo])|[/\\\\\\.\\-])\\s*)?${MonthRegex}\\b`;
    export const DateExtractor2 = `\\b((el\\s+d[ií]a|${WeekDayRegex})(\\s+|\\s*,\\s*))?(?<!\\d[.,])((${DayRegex}((\\s+(d[eo]\\s+)?|\\s*[.,/-]\\s*)${MonthRegex}((\\s+(del?\\s+)?|\\s*[.,/-]\\s*)${DateYearRegex}\\b)?|\\s+(d[eo]\\s+)${MonthNumRegex}\\s+(del?\\s+${DateYearRegex}\\b)))|${BaseDateTime.FourDigitYearRegex}\\s*[.,/-]?\\s*(el\\s+d[ií]a\\s+)?${DayRegex}(\\s+(d[eo]\\s+)?|\\s*[.,/-]\\s*)${MonthRegex})`;
    export const DateExtractor3 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${MonthRegex}(\\s*[.,/-]?\\s*)(el\\s+d[ií]a\\s+)?${DayRegex}(?!\\s*\\-\\s*\\d{2}\\b)((\\s+(del?\\s+)?|\\s*[.,/-]\\s*)${DateYearRegex})?\\b`;
    export const DateExtractor4 = `\\b(?<!\\d[.,])${MonthNumRegex}\\s*[/\\\\\\-]\\s*${DayRegex}\\s*[/\\\\\\-]\\s*${DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)`;
    export const DateExtractor5 = `\\b(?<!\\d[.,])${DayRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DateYearRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)`;
    export const DateExtractor6 = `(?<=\\b(en|el)\\s+)${MonthNumRegex}[\\-\\.]${DayRegex}${BaseDateTime.CheckDecimalRegex}\\b(?!\\s*[/\\\\\\.]\\s*\\d+)`;
    export const DateExtractor7 = `\\b(?<!\\d[.,])${MonthNumRegex}\\s*/\\s*${DayRegex}((\\s+|\\s*,\\s*|\\s+d[eo]\\s+)${DateYearRegex})?\\b${BaseDateTime.CheckDecimalRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)`;
    export const DateExtractor8 = `(?<=\\b(en|el)\\s+)${DayRegex}[\\\\\\-]${MonthNumRegex}${BaseDateTime.CheckDecimalRegex}\\b(?!\\s*[/\\\\\\.]\\s*\\d+)`;
    export const DateExtractor9 = `\\b(${WeekDayRegex}\\s+)?(?<!\\d[.,])${DayRegex}\\s*/\\s*${MonthNumRegex}((\\s+|\\s*,\\s*|\\s+d[eo]\\s+)${DateYearRegex})?\\b${BaseDateTime.CheckDecimalRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)`;
    export const DateExtractor10 = `\\b(?<!\\d[.,])((${YearRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DayRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+))|(${MonthRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*${DayRegex})|(${DayRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*${MonthRegex}))`;
    export const HourRegex = `\\b(?<!\\d[,.])(?<hour>2[0-4]|[0-1]?\\d)`;
    export const HourNumRegex = `\\b(?<hournum>cero|una|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce)\\b`;
    export const MinuteNumRegex = `(?<minnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)`;
    export const DeltaMinuteNumRegex = `(?<deltaminnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)`;
    export const PmRegex = `(?<pm>((por|de|a|en)\\s+la)\\s+(tarde|noche))`;
    export const AmRegex = `(?<am>((por|de|a|en)\\s+la)\\s+(mañana|madrugada))`;
    export const AmTimeRegex = `(?<am>(esta|(por|de|a|en)\\s+la)\\s+(mañana|madrugada))`;
    export const PmTimeRegex = `(?<pm>(esta|(por|de|a|en)\\s+la)\\s+(tarde|noche))`;
    export const NightTimeRegex = `(noche)`;
    export const LastNightTimeRegex = `(anoche)`;
    export const NowTimeRegex = `(ahora|mismo|momento)`;
    export const RecentlyTimeRegex = `(mente)`;
    export const AsapTimeRegex = `(posible|pueda[ns]?|podamos)`;
    export const LessThanOneHour = `(?<lth>((\\s+y\\s+)?cuarto|(\\s*)menos cuarto|(\\s+y\\s+)media|${BaseDateTime.DeltaMinuteRegex}(\\s+(minutos?|mins?))|${DeltaMinuteNumRegex}(\\s+(minutos?|mins?))))`;
    export const TensTimeRegex = `(?<tens>diez|veint(i|e)|treinta|cuarenta|cincuenta)`;
    export const WrittenTimeRegex = `(?<writtentime>${HourNumRegex}\\s*((y|(?<prefix>menos))\\s+)?((${TensTimeRegex}(\\s*y\\s+)?)?${MinuteNumRegex}))`;
    export const TimePrefix = `(?<prefix>${LessThanOneHour}(\\s+(pasad[ao]s)\\s+(de\\s+las|las)?|\\s+(para|antes\\s+de)?\\s+(las?))?)`;
    export const TimeSuffix = `(?<suffix>(${LessThanOneHour}\\s+)?(${AmRegex}|${PmRegex}|${OclockRegex}))`;
    export const GeneralDescRegex = `(${DescRegex}|(?<suffix>${AmRegex}|${PmRegex}))`;
    export const BasicTime = `(?<basictime>${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}:${BaseDateTime.MinuteRegex}(:${BaseDateTime.SecondRegex})?|${BaseDateTime.HourRegex})`;
    export const MidTimeRegex = `(?<mid>((?<midnight>media\\s*noche)|(?<midearlymorning>media\\s*madrugada)|(?<midmorning>media\\s*mañana)|(?<midafternoon>media\\s*tarde)|(?<midday>medio\\s*d[ií]a)))`;
    export const AtRegex = `\\b((?<=\\b((a|de(sde)?)\\s+las?|al)\\s+)((${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex})\\b(\\s*\\bh\\b)?(DescRegex)?|${MidTimeRegex})|${MidTimeRegex})`;
    export const ConnectNumRegex = `(${BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*${DescRegex})`;
    export const TimeRegexWithDotConnector = `(${BaseDateTime.HourRegex}\\.${BaseDateTime.MinuteRegex})`;
    export const TimeRegex1 = `(\\b${TimePrefix}\\s+)?(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex})\\s*(${DescRegex}|\\s*\\bh\\b)`;
    export const TimeRegex2 = `(\\b${TimePrefix}\\s+)?(t)?${BaseDateTime.HourRegex}(\\s*)?:(\\s*)?${BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?${BaseDateTime.SecondRegex})?(\\s*(${DescRegex}|\\bh\\b)|\\b)`;
    export const TimeRegex3 = `\\b((${TimePrefix}\\s+)?${TimeRegexWithDotConnector}(\\s*(${DescRegex}|${TimeSuffix}|\\bh\\b))|((las\\s+${TimeRegexWithDotConnector})(?!\\s*(por\\s+cien(to)?|%))(\\s*(${DescRegex}|${TimeSuffix}|\\bh\\b)|\\b)))`;
    export const TimeRegex4 = `\\b((${DescRegex}?)|(${BasicTime}\\s*)?(${GeneralDescRegex}?))${TimePrefix}(\\s*(${HourNumRegex}|${BaseDateTime.HourRegex}))?(\\s+${TensTimeRegex}(\\s*(y\\s+)?${MinuteNumRegex})?)?(\\s*(${OclockRegex}|${DescRegex}|\\bh\\b)|\\b)`;
    export const TimeRegex5 = `\\b(${TimePrefix}|${BasicTime}${TimePrefix})\\s+(\\s*${DescRegex})?${BasicTime}?\\s*${TimeSuffix}\\b`;
    export const TimeRegex6 = `(${BasicTime}(\\s*${DescRegex})?\\s+${TimeSuffix}\\b)`;
    export const TimeRegex7 = `\\b${TimeSuffix}\\s+a\\s+las\\s+${BasicTime}((\\s*${DescRegex}|\\bh\\b)|\\b)`;
    export const TimeRegex8 = `\\b${TimeSuffix}\\s+${BasicTime}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex9 = `\\b(?<writtentime>${HourNumRegex}\\s+(${TensTimeRegex}\\s*)(y\\s+)?${MinuteNumRegex}?)\\b`;
    export const TimeRegex11 = `\\b(${WrittenTimeRegex})(\\s+${DescRegex})?\\b`;
    export const TimeRegex12 = `(\\b${TimePrefix}\\s+)?${BaseDateTime.HourRegex}(\\s*h\\s*)${BaseDateTime.MinuteRegex}(\\s*${DescRegex})?`;
    export const PrepositionRegex = `(?<prep>^(,\\s*)?(a(l)?|en|de(l)?)?(\\s*(la(s)?|el|los))?$)`;
    export const LaterEarlyRegex = `((?<early>temprano)|(?<late>fin(al)?(\\s+de)?|m[aá]s\\s+tarde))`;
    export const NowRegex = `\\b(?<now>(justo\\s+)?ahora(\\s+mismo)?|en\\s+este\\s+momento|tan\\s+pronto\\s+como\\s+sea\\s+posible|tan\\s+pronto\\s+como\\s+(pueda|puedas|podamos|puedan)|lo\\s+m[aá]s\\s+pronto\\s+posible|recientemente|previamente|este entonces)\\b`;
    export const SuffixRegex = `^\\s*(((y|a|en|por)\\s+la|al)\\s+)?(mañana|madrugada|medio\\s*d[ií]a|(?<!(m[áa]s\\s+))tarde|noche)\\b`;
    export const TimeOfDayRegex = `\\b((?<timeOfDay>((${LaterEarlyRegex}\\s+)((del?|en|por)(\\s+(el|los?|las?))?\\s+)?)?(mañana|madrugada|pasado\\s+(el\\s+)?medio\\s?d[ií]a|(?<!((m[áa]s|tan)\\s+))tarde|noche))|(en|por)\\s+las?\\s+mañana)\\b`;
    export const SpecificTimeOfDayRegex = `\\b(((((a\\s+)?la|esta|siguiente|pr[oó]xim[oa]|[uú]ltim[oa])\\s+)?${TimeOfDayRegex})|anoche)\\b`;
    export const TimeOfTodayAfterRegex = `^\\s*(,\\s*)?(en|de(l)?\\s+)?${SpecificTimeOfDayRegex}`;
    export const TimeOfTodayBeforeRegex = `(${SpecificTimeOfDayRegex}(\\s*,)?(\\s+(((cerca|alrededor)?\\s*(de|a)\\s+)la(s)?|para))?\\s*$)`;
    export const NonTimeContextTokens = `(edificio)`;
    export const SimpleTimeOfTodayAfterRegex = `(?<!${NonTimeContextTokens}\\s*)\\b(${HourNumRegex}|${BaseDateTime.HourRegex})\\s*(,\\s*)?((en|de(l)?)?\\s+)?${SpecificTimeOfDayRegex}\\b`;
    export const SimpleTimeOfTodayBeforeRegex = `(${SpecificTimeOfDayRegex}(\\s*,)?(\\s+(((cerca|alrededor)?\\s*(de|a)\\s+)la(s)?|para))?\\s*(${HourNumRegex}|${BaseDateTime.HourRegex}))\\b`;
    export const SpecificEndOfRegex = `((a|e)l\\s+)?fin(alizar|al)?(\\s+(el|de(l)?)(\\s+d[ií]a)?(\\s+de)?)?\\s*$`;
    export const UnspecificEndOfRegex = `\\b([ae]l\\s+)?(fin(al)?\\s+del?\\s+d[ií]a)\\b`;
    export const UnspecificEndOfRangeRegex = `^[.]`;
    export const DateTimeTimeOfDayRegex = `\\b(?<timeOfDay>mañana|madrugada|(?<pm>pasado\\s+(el\\s+)?medio\\s?d[ií]a|tarde|noche))\\b`;
    export const PeriodTimeOfDayRegex = `\\b((en\\s+(el|la|lo)?\\s+)?(${LaterEarlyRegex}\\s+)?(est[ae]\\s+)?${DateTimeTimeOfDayRegex})\\b`;
    export const PeriodSpecificTimeOfDayRegex = `\\b((${LaterEarlyRegex}\\s+)?est[ae]\\s+${DateTimeTimeOfDayRegex}|(${StrictRelativeRegex}\\s+${PeriodTimeOfDayRegex})|anoche)\\b`;
    export const UnitRegex = `(?<unit>años?|(bi|tri|cuatri|se)mestre|mes(es)?|semanas?|fin(es)?\\s+de\\s+semana|finde|d[ií]as?|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\\b`;
    export const ConnectorRegex = `^(,|t|(para|y|a|en|por) las?|(\\s*,\\s*)?((cerca|alrededor)\\s+)?(de\\s+las?|del))$`;
    export const TimeHourNumRegex = `(?<hour>veint(i(uno|dos|tres|cuatro)|e)|cero|uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieci(s([eé])is|siete|ocho|nueve))`;
    export const PureNumFromTo = `((\\b(desde|de)\\s+(la(s)?\\s+)?)?(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(?!\\s+al?\\b)(\\s*(?<leftDesc>${DescRegex}))?|(\\b(desde|de)\\s+(la(s)?\\s+)?)(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?)\\s*${TillRegex}\\s*(${BaseDateTime.HourRegex}|${TimeHourNumRegex})\\s*(?<rightDesc>${PmRegex}|${AmRegex}|${DescRegex})?`;
    export const PureNumBetweenAnd = `(\\bentre\\s+(la(s)?\\s+)?)((${BaseDateTime.TwoDigitHourRegex}${BaseDateTime.TwoDigitMinuteRegex})|${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?\\s*${RangeConnectorRegex}\\s*((${BaseDateTime.TwoDigitHourRegex}${BaseDateTime.TwoDigitMinuteRegex})|${BaseDateTime.HourRegex}|${TimeHourNumRegex})\\s*(?<rightDesc>${PmRegex}|${AmRegex}|${DescRegex})?`;
    export const SpecificTimeFromTo = `(${RangePrefixRegex}\\s+)?(?<time1>((${TimeRegex2}|${TimeRegexWithDotConnector}(\\s*${DescRegex})?)|(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?))\\s*${TillRegex}\\s*(?<time2>((${TimeRegex2}|${TimeRegexWithDotConnector}(\\s*${DescRegex})?)|(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<rightDesc>${DescRegex}))?))`;
    export const SpecificTimeBetweenAnd = `(${BetweenRegex}\\s+)(?<time1>((${TimeRegex1}|${TimeRegex2}|${TimeRegexWithDotConnector}(\\s*${DescRegex})?)|(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?))\\s*${RangeConnectorRegex}\\s*(?<time2>((${TimeRegex1}|${TimeRegex2}|${TimeRegexWithDotConnector}(\\s*${DescRegex})?)|(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<rightDesc>${DescRegex}))?))`;
    export const TimeUnitRegex = `([^A-Za-z]{1,}|\\b)(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\\b`;
    export const TimeFollowedUnit = `^\\s*${TimeUnitRegex}`;
    export const TimeNumberCombinedWithUnit = `\\b(?<num>\\d+(\\,\\d*)?)\\s*${TimeUnitRegex}`;
    export const DateTimePeriodNumberCombinedWithUnit = `\\b(?<num>\\d+(\\.\\d*)?)\\s*${TimeUnitRegex}`;
    export const PeriodTimeOfDayWithDateRegex = `\\b(((y|a|en|por)\\s+(la\\s+)?|al\\s+)?((((?<early>primeras\\s+horas\\s+)|(?<late>(últimas|altas)\\s+horas\\s+))(de\\s+la\\s+)?|${LaterEarlyRegex}\\s+(est[ae]\\s+)?)?(?<timeOfDay>(mañana|madrugada|pasado\\s+(el\\s+)?medio\\s?d[ií]a|(?<!(m[áa]s\\s+))tarde|noche|anoche))))(\\s+(del|de))?\\b`;
    export const RelativeTimeUnitRegex = `(${PastRegex}|${FutureRegex})\\s+${TimeUnitRegex}`;
    export const LessThanRegex = `\\b(dentro\\s+de\\s+menos\\s+de)\\b`;
    export const MoreThanRegex = `\\b(durante\\s+(m[áa]s\\s+)?de)\\b`;
    export const SuffixAndRegex = `(?<suffix>\\s*(y)\\s+((un[ao]?)\\s+)?(?<suffix_num>media|cuarto))`;
    export const FollowedUnit = `^\\s*${UnitRegex}`;
    export const DurationNumberCombinedWithUnit = `\\b(?<num>\\d+(\\,\\d*)?)${UnitRegex}`;
    export const AnUnitRegex = `\\b(una?|otr[ao])\\s+${UnitRegex}`;
    export const DuringRegex = `^[.]`;
    export const AllRegex = `\\b(?<all>tod[oa]?\\s+(el|la)\\s+(?<unit>año|mes|semana|d[ií]a)|((una?|el|la)\\s+)?(?<unit>año|mes|semana|d[ií]a)\\s+enter[ao])\\b`;
    export const HalfRegex = `\\b(?<half>medi[oa]\\s+(?<unit>ano|mes|semana|d[íi]a|hora))\\b`;
    export const ConjunctionRegex = `^[.]`;
    export const InexactNumberRegex = `\\b(pocos?|algo|vari[ao]s|algun[ao]s|un[ao]s)\\b`;
    export const InexactNumberUnitRegex = `(${InexactNumberRegex})\\s+${UnitRegex}`;
    export const HolidayRegex1 = `\\b(?<holiday>viernes\\s+(santo|negro)|mi[eé]rcoles de ceniza|martes de carnaval|d[ií]a (de|de los) presidentes?|clebraci[oó]n de mao|año nuevo chino|año nuevo|noche vieja|(festividad de )?los mayos|d[ií]a de los inocentes|navidad|noche buena|d[ií]a de acci[oó]n de gracias|acci[oó]n de gracias|yuandan|halloween|noches de brujas|pascuas)(\\s+(del?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b`;
    export const HolidayRegex2 = `\\b(?<holiday>(d[ií]a( del?( la)?)? )?(martin luther king|todos los santos|tierra|blanco|san patricio|san valent[ií]n|san jorge|cinco de mayo|independencia|raza|trabajador))(\\s+(del?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b`;
    export const HolidayRegex3 = `\\b(?<holiday>(d[ií]a( internacional)?( del?( l[ao]s?)?)? )(trabajador(es)?|madres?|padres?|[aá]rbol|mujer(es)?|solteros?|niños?|marmota|san valent[ií]n|maestro))(\\s+(del?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b`;
    export const BeforeRegex = `(\\b((ante(s|rior)|m[aá]s\\s+temprano|no\\s+m[aá]s\\s+tard(e|ar)|hasta|(?<include>tan\\s+tarde\\s+como))(\\s+(del?|a|que)(\\s+(el|las?|los?))?)?)|(?<!\\w|>)((?<include><\\s*=)|<))`;
    export const AfterRegex = `((\\b(despu[eé]s|(año\\s+)?posterior|m[aá]s\\s+tarde|a\\s+primeros)(\\s*(del?|en|a)(\\s+(el|las?|los?))?)?|(empi?en?zando|comenzando)(\\s+(el|las?|los?))?)\\b|(?<!\\w|<)((?<include>>\\s*=)|>))`;
    export const SinceRegex = `\\b(((cualquier\\s+tiempo\\s+)?(desde|a\\s+partir\\s+del?)|tan\\s+(temprano|pronto)\\s+como(\\s+(de|a))?)(\\s+(el|las?|los?))?)\\b`;
    export const SinceRegexExp = `(${SinceRegex}|\\bde\\b)`;
    export const AroundRegex = `(?:\\b(?:cerca|alrededor|aproximadamente)(\\s+(de\\s+(las?|el)|del?))?\\s*\\b)`;
    export const PeriodicRegex = `\\b(?<periodic>a\\s*diario|diaria(s|mente)|(bi|tri)?(semanal|quincenal|mensual|(se|tri)mestral|anual)(es|mente)?)\\b`;
    export const EachExpression = `\\b(cada|tod[oa]s\\s*(l[oa]s)?)\\b\\s*(?!\\s*l[oa]\\b)`;
    export const EachUnitRegex = `(?<each>(${EachExpression})\\s*(${UnitRegex}|(?<specialUnit>fin(es)?\\s+de\\s+semana|finde)\\b))`;
    export const EachPrefixRegex = `(?<each>(${EachExpression})\\s*$)`;
    export const EachDayRegex = `\\s*(${EachExpression})\\s*d[ií]as\\s*\\b`;
    export const BeforeEachDayRegex = `(${EachExpression})\\s*d[ií]as(\\s+a\\s+las?)?\\s*\\b`;
    export const SetEachRegex = `(?<each>(${EachExpression})\\s*)`;
    export const LaterEarlyPeriodRegex = `\\b((${PrefixPeriodRegex})\\s+(?<suffix>${OneWordPeriodRegex}|(?<FourDigitYear>${BaseDateTime.FourDigitYearRegex}))|(${UnspecificEndOfRangeRegex}))\\b`;
    export const RelativeWeekRegex = `(((la|el)\\s+)?(((est[ae]|pr[oó]xim[oa]|[uú]ltim(o|as|os))\\s+semanas?)|(semanas?\\s+(que\\s+viene|pasad[oa]))))`;
    export const WeekWithWeekDayRangeRegex = `\\b(((${RelativeWeekRegex})((\\s+entre\\s+${WeekDayRegex}\\s+y\\s+${WeekDayRegex})|(\\s+de\\s+${WeekDayRegex}\\s+a\\s+${WeekDayRegex})))|((entre\\s+${WeekDayRegex}\\s+y\\s+${WeekDayRegex})|(de\\s+${WeekDayRegex}\\s+a\\s+${WeekDayRegex}))${OfPrepositionRegex}\\s+${RelativeWeekRegex})\\b`;
    export const GeneralEndingRegex = `^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$`;
    export const MiddlePauseRegex = `^[.]`;
    export const PrefixArticleRegex = `\\b(e[ln]\\s+(d[ií]a\\s+)?)`;
    export const OrRegex = `^[.]`;
    export const SpecialYearTermsRegex = `\\b((${SpecialYearPrefixes}\\s+años?\\s+|años?\\s+(${SpecialYearPrefixes}\\s+)?)(de\\s+)?)`;
    export const YearPlusNumberRegex = `\\b(${SpecialYearTermsRegex}((?<year>(\\d{2,4}))|${FullTextYearRegex}))\\b`;
    export const NumberAsTimeRegex = `\\b(${WrittenTimeRegex}|${HourRegex}(?<desc>\\s*h(oras)?)?)\\b`;
    export const TimeBeforeAfterRegex = `\\b((?<=\\b(antes|no\\s+m[aá]s\\s+tard(e|ar)\\s+(de|a\\s+las?)|por| después)\\s+)(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}|${MidTimeRegex}))\\b`;
    export const DateNumberConnectorRegex = `^\\s*(?<connector>a\\s+las)\\s*$`;
    export const CenturyRegex = `^[.]`;
    export const DecadeRegex = `(?<decade>diez|veinte|treinta|cuarenta|cincuenta|se[st]enta|ochenta|noventa)`;
    export const DecadeWithCenturyRegex = `(los\\s+)?((((d[ée]cada(\\s+de)?)\\s+)(((?<century>\\d|1\\d|2\\d)?(?<decade>\\d0))))|a[ñn]os\\s+((((dos\\s+)?mil\\s+)?(${WrittenOneHundredToNineHundredRegex}\\s+)?${DecadeRegex})|((dos\\s+)?mil\\s+)?(${WrittenOneHundredToNineHundredRegex})(\\s+${DecadeRegex}?)|((dos\\s+)?mil)(\\s+${WrittenOneHundredToNineHundredRegex}\\s+)?${DecadeRegex}?))`;
    export const RelativeDecadeRegex = `\\b(((el|las?)\\s+)?${RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?(d[eé]cada|decenio)s?)\\b`;
    export const ComplexDatePeriodRegex = `(?:((de(sde)?)\\s+)?(?<start>.+)\\s*(${StrictTillRegex})\\s*(?<end>.+)|((entre)\\s+)(?<start>.+)\\s*(${RangeConnectorRegex})\\s*(?<end>.+))`;
    export const AmbiguousPointRangeRegex = `^(mar\\.?)$`;
    export const YearSuffix = `((,|\\sdel?)?\\s*(${YearRegex}|${FullTextYearRegex}))`;
    export const SinceYearSuffixRegex = `(^\\s*${SinceRegex}(\\s*(el\\s+)?año\\s*)?${YearSuffix})`;
    export const AgoRegex = `\\b(antes\\s+de\\s+(?<day>hoy|ayer|mañana)|antes|hace)\\b`;
    export const LaterRegex = `\\b(despu[eé]s(?!\\s+de\\b)|desde\\s+ahora|(a\\s+partir|despu[eé]s)\\s+de\\s+(ahora|(?<day>hoy|ayer|mañana)))\\b`;
    export const Tomorrow = `mañana`;
    export const UnitMap: ReadonlyMap<string, string> = new Map<string, string>([["años", "Y"],["año", "Y"],["meses", "MON"],["mes", "MON"],["trimestre", "3MON"],["trimestres", "3MON"],["cuatrimestre", "4MON"],["cuatrimestres", "4MON"],["semestre", "6MON"],["semestres", "6MON"],["bimestre", "2MON"],["bimestres", "2MON"],["semanas", "W"],["semana", "W"],["fin de semana", "WE"],["fines de semana", "WE"],["finde", "WE"],["dias", "D"],["dia", "D"],["días", "D"],["día", "D"],["jornada", "D"],["noche", "D"],["noches", "D"],["horas", "H"],["hora", "H"],["hrs", "H"],["hras", "H"],["hra", "H"],["hr", "H"],["h", "H"],["minutos", "M"],["minuto", "M"],["mins", "M"],["min", "M"],["segundos", "S"],["segundo", "S"],["segs", "S"],["seg", "S"]]);
    export const UnitValueMap: ReadonlyMap<string, number> = new Map<string, number>([["años", 31536000],["año", 31536000],["meses", 2592000],["mes", 2592000],["semanas", 604800],["semana", 604800],["fin de semana", 172800],["fines de semana", 172800],["finde", 172800],["dias", 86400],["dia", 86400],["días", 86400],["día", 86400],["noche", 86400],["noches", 86400],["horas", 3600],["hora", 3600],["hrs", 3600],["hras", 3600],["hra", 3600],["hr", 3600],["h", 3600],["minutos", 60],["minuto", 60],["mins", 60],["min", 60],["segundos", 1],["segundo", 1],["segs", 1],["seg", 1]]);
    export const SpecialYearPrefixesMap: ReadonlyMap<string, string> = new Map<string, string>([["fiscal", "FY"],["escolar", "SY"]]);
    export const SeasonMap: ReadonlyMap<string, string> = new Map<string, string>([["primavera", "SP"],["verano", "SU"],["otoño", "FA"],["invierno", "WI"]]);
    export const SeasonValueMap: ReadonlyMap<string, number> = new Map<string, number>([["SP", 3],["SU", 6],["FA", 9],["WI", 12]]);
    export const CardinalMap: ReadonlyMap<string, number> = new Map<string, number>([["primer", 1],["primero", 1],["primera", 1],["1er", 1],["1ro", 1],["1ra", 1],["1.º", 1],["1º", 1],["1ª", 1],["segundo", 2],["segunda", 2],["2do", 2],["2da", 2],["2.º", 2],["2º", 2],["2ª", 2],["tercer", 3],["tercero", 3],["tercera", 3],["3er", 3],["3ro", 3],["3ra", 3],["3.º", 3],["3º", 3],["3ª", 3],["cuarto", 4],["cuarta", 4],["4to", 4],["4ta", 4],["4.º", 4],["4º", 4],["4ª", 4],["quinto", 5],["quinta", 5],["5to", 5],["5ta", 5],["5.º", 5],["5º", 5],["5ª", 5],["sexto", 6],["sexta", 6],["6to", 6],["6ta", 6],["septimo", 7],["séptimo", 7],["septima", 7],["séptima", 7],["7mo", 7],["7ma", 7],["octavo", 8],["octava", 8],["8vo", 8],["8va", 8],["noveno", 9],["novena", 9],["9no", 9],["9na", 9],["decimo", 10],["décimo", 10],["decima", 10],["décima", 10],["10mo", 10],["10ma", 10],["undecimo", 11],["undécimo", 11],["undecima", 11],["undécima", 11],["11mo", 11],["11ma", 11],["duodecimo", 12],["duodécimo", 12],["duodecima", 12],["duodécima", 12],["12mo", 12],["12ma", 12]]);
    export const DayOfWeek: ReadonlyMap<string, number> = new Map<string, number>([["lunes", 1],["martes", 2],["miercoles", 3],["miércoles", 3],["jueves", 4],["viernes", 5],["sabado", 6],["sábado", 6],["domingo", 0],["dom", 0],["lun", 1],["mar", 2],["mie", 3],["mié", 3],["jue", 4],["vie", 5],["sab", 6],["sáb", 6],["dom.", 0],["lun.", 1],["mar.", 2],["mie.", 3],["mié.", 3],["jue.", 4],["vie.", 5],["sab.", 6],["sáb.", 6],["do", 0],["lu", 1],["ma", 2],["mi", 3],["ju", 4],["vi", 5],["sa", 6]]);
    export const MonthOfYear: ReadonlyMap<string, number> = new Map<string, number>([["1", 1],["2", 2],["3", 3],["4", 4],["5", 5],["6", 6],["7", 7],["8", 8],["9", 9],["10", 10],["11", 11],["12", 12],["enero", 1],["febrero", 2],["marzo", 3],["abril", 4],["mayo", 5],["junio", 6],["julio", 7],["agosto", 8],["septiembre", 9],["setiembre", 9],["octubre", 10],["noviembre", 11],["diciembre", 12],["ene", 1],["feb", 2],["mar", 3],["abr", 4],["may", 5],["jun", 6],["jul", 7],["ago", 8],["sept", 9],["sep", 9],["set", 9],["oct", 10],["nov", 11],["dic", 12],["ene.", 1],["feb.", 2],["mar.", 3],["abr.", 4],["may.", 5],["jun.", 6],["jul.", 7],["ago.", 8],["sept.", 9],["sep.", 9],["set.", 9],["oct.", 10],["nov.", 11],["dic.", 12],["01", 1],["02", 2],["03", 3],["04", 4],["05", 5],["06", 6],["07", 7],["08", 8],["09", 9]]);
    export const Numbers: ReadonlyMap<string, number> = new Map<string, number>([["cero", 0],["un", 1],["una", 1],["uno", 1],["dos", 2],["dós", 2],["tres", 3],["trés", 3],["cuatro", 4],["cinco", 5],["seis", 6],["séis", 6],["siete", 7],["ocho", 8],["nueve", 9],["diez", 10],["once", 11],["doce", 12],["docena", 12],["docenas", 12],["trece", 13],["catorce", 14],["quince", 15],["dieciseis", 16],["dieciséis", 16],["diecisiete", 17],["dieciocho", 18],["diecinueve", 19],["veinte", 20],["veinti", 20],["ventiuna", 21],["ventiuno", 21],["veintiun", 21],["veintiún", 21],["veintiuno", 21],["veintiuna", 21],["veintidos", 22],["veintidós", 22],["veintitres", 23],["veintitrés", 23],["veinticuatro", 24],["veinticinco", 25],["veintiseis", 26],["veintiséis", 26],["veintisiete", 27],["veintiocho", 28],["veintinueve", 29],["treinta", 30],["cuarenta", 40],["cincuenta", 50]]);
    export const HolidayNames: ReadonlyMap<string, string[]> = new Map<string, string[]>([["padres", ["diadelpadre"]],["madres", ["diadelamadre"]],["acciondegracias", ["diadegracias","diadeacciondegracias","acciondegracias"]],["trabajador", ["diadeltrabajador","diadelostrabajadores","diainternacionaldeltrabajador","diainternacionaldelostrabajadores"]],["delaraza", ["diadelaraza","diadeladiversidadcultural"]],["memoria", ["diadelamemoria"]],["pascuas", ["diadepascuas","pascuas"]],["navidad", ["navidad","diadenavidad"]],["nochebuena", ["diadenochebuena","nochebuena"]],["añonuevo", ["añonuevo","diadeañonuevo"]],["nochevieja", ["nochevieja","diadenochevieja"]],["yuandan", ["yuandan"]],["earthday", ["diadelatierra"]],["maestro", ["diadelmaestro"]],["todoslossantos", ["todoslossantos"]],["niño", ["diadelniño"]],["mujer", ["diadelamujer"]],["independencia", ["diadelaindependencia","diadeindependencia","independencia"]],["blackfriday", ["viernesnegro"]],["goodfriday", ["viernessanto"]],["stpatrickday", ["sanpatricio","diadesanpatricio"]],["valentinesday", ["sanvalentin","diadesanvalentin"]]]);
    export const VariableHolidaysTimexDictionary: ReadonlyMap<string, string> = new Map<string, string>([["padres", "-06-WXX-7-3"],["madres", "-05-WXX-7-2"],["acciondegracias", "-11-WXX-4-4"],["delaraza", "-10-WXX-1-2"],["memoria", "-03-WXX-2-4"]]);
    export const DoubleNumbers: ReadonlyMap<string, number> = new Map<string, number>([["mitad", 0.5],["cuarto", 0.25]]);
    export const UpcomingPrefixRegex = `((este\\s+))`;
    export const NextPrefixRegex = `\\b(${UpcomingPrefixRegex}?pr[oó]xim[oa]s?|siguiente|que\\s+viene)\\b`;
    export const PastPrefixRegex = `((este\\s+))`;
    export const PreviousPrefixRegex = `\\b(${PastPrefixRegex}?pasad[oa]s?(?!(\\s+el)?\\s+medio\\s*d[ií]a)|[uú]ltim[oa]s?|anterior)\\b`;
    export const ThisPrefixRegex = `(est?[ea]|actual)\\b`;
    export const PrefixWeekDayRegex = `(\\s*((,?\\s*el)|[-—–]))`;
    export const ThisRegex = `\\b((est[ae]\\s*)(semana${PrefixWeekDayRegex}?)?\\s*${WeekDayRegex})|(${WeekDayRegex}\\s*((de\\s+)?esta\\s+semana))\\b`;
    export const LastDateRegex = `\\b((${PreviousPrefixRegex}\\s+(semana${PrefixWeekDayRegex}?)?|(la\\s+)?semana\\s+${PreviousPrefixRegex}${PrefixWeekDayRegex})\\s*${WeekDayRegex})|(este\\s+)?(${WeekDayRegex}\\s+([uú]ltimo|pasado|anterior))|(${WeekDayRegex}(\\s+((de\\s+)?((esta|la)\\s+([uú]ltima\\s+)?semana)|(de\\s+)?(la\\s+)?semana\\s+(pasada|anterior))))\\b`;
    export const NextDateRegex = `\\b(((${NextPrefixRegex}\\s+)(semana${PrefixWeekDayRegex}?)?|(la\\s+)?semana\\s+${NextPrefixRegex}${PrefixWeekDayRegex})\\s*${WeekDayRegex})|(este\\s+)?(${WeekDayRegex}\\s+(pr[oó]ximo|siguiente|que\\s+viene))|(${WeekDayRegex}(\\s+(de\\s+)?(la\\s+)?((pr[oó]xima|siguiente)\\s+semana|semana\\s+(pr[oó]xima|siguiente))))\\b`;
    export const RelativeDayRegex = `(?<relday>((este|pr[oó]ximo|([uú]ltim(o|as|os)))\\s+días)|(días\\s+((que\\s+viene)|pasado)))\\b`;
    export const RestOfDateRegex = `\\bresto\\s+((del|de)\\s+)?((la|el|est?[ae])\\s+)?(?<duration>semana|mes|año|decada)(\\s+actual)?\\b`;
    export const WithinNextPrefixRegex = `\\b(dentro\\s+de((\\s+(el|l[ao]s?))?\\s+(?<next>${NextPrefixRegex}))?)(?=\\s*$)\\b`;
    export const DurationUnitRegex = `(?<unit>${DateUnitRegex}|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\\b`;
    export const DurationConnectorRegex = `^\\s*(?<connector>\\s+|y|,)\\s*$`;
    export const RelativeDurationUnitRegex = `(?:(?<=(${NextPrefixRegex}|${PreviousPrefixRegex}|${ThisPrefixRegex})\\s+)(${DurationUnitRegex}))`;
    export const ReferencePrefixRegex = `(mism[ao]|aquel|est?e)\\b`;
    export const ReferenceDatePeriodRegex = `\\b${ReferencePrefixRegex}\\s+(${DateUnitRegex}|fin\\s+de\\s+semana)\\b`;
    export const FromToRegex = `\\b(from).+(to)\\b.+`;
    export const SingleAmbiguousMonthRegex = `^(the\\s+)?(may|march)$`;
    export const UnspecificDatePeriodRegex = `^[\\.]`;
    export const PrepositionSuffixRegex = `\\b(en|el|la|cerca|alrededor|desde|durante|hasta|hacia)$`;
    export const RestOfDateTimeRegex = `\\bresto\\s+((del?)\\s+)?((la|el|est[ae])\\s+)?(?<unit>(día|jornada))(\\s+de\\s+hoy)?\\b`;
    export const SetWeekDayRegex = `^[\\.]`;
    export const NightRegex = `\\b(medionoche|noche)\\b`;
    export const CommonDatePrefixRegex = `^[\\.]`;
    export const SuffixAfterRegex = `\\b((a\\s+)?(o|y)\\s+(arriba|despu[eé]s|posterior|mayor|m[aá]s\\s+tarde)(?!\\s+(que|de)))\\b`;
    export const YearPeriodRegex = `((((de(sde)?|durante|en)\\s+)?${YearRegex}\\s*(${TillRegex})\\s*${YearRegex})|(((entre)\\s+)${YearRegex}\\s*(${RangeConnectorRegex})\\s*${YearRegex}))`;
    export const FutureSuffixRegex = `\\b(siguiente(s)?|pr[oó]xim[oa](s)?|(en\\s+el\\s+)?futuro)\\b`;
    export const PastSuffixRegex = `^\\b$`;
    export const ModPrefixRegex = `\\b(${RelativeRegex}|${AroundRegex}|${BeforeRegex}|${AfterRegex}|${SinceRegex})\\b`;
    export const ModSuffixRegex = `\\b(${AgoRegex}|${LaterRegex}|${BeforeAfterRegex}|${FutureSuffixRegex}|${PastSuffixRegex})\\b`;
    export const WrittenDecades: ReadonlyMap<string, number> = new Map<string, number>([["", 0]]);
    export const SpecialDecadeCases: ReadonlyMap<string, number> = new Map<string, number>([["", 0]]);
    export const DefaultLanguageFallback = `DMY`;
    export const DurationDateRestrictions = [ "hoy" ];
    export const AmbiguityFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"],["^(este\\s+)?mi(\\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\\s+viene))?$", "\\b(este\\s+)?mi(\\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\\s+viene))?\\b"],["^a[nñ]o$", "(?<!el\\s+)a[nñ]o"],["^semana$", "(?<!la\\s+)semana"],["^mes$", "(?<!el\\s+)mes"],["^(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)$", "([$%£&!?@#])(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)|(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)([$%£&@#])"],["^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}"],["^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}"]]);
    export const EarlyMorningStartEndRegex = `(^(madrugada)|(madrugada)$)`;
    export const MorningStartEndRegex = `(^((la\\s+)?mañana))|(((la\\s+)?mañana)$)`;
    export const AfternoonStartEndRegex = `(^(pasado\\s+(el\\s+)?medio\\s*dia))|((pasado\\s+(el\\s+)?medio\\s*dia)$)`;
    export const EveningStartEndRegex = `(^(tarde))|((tarde)$)`;
    export const NightStartEndRegex = `(^(noche)|(noche)$)`;
    export const EarlyMorningTermList = [ "madrugada" ];
    export const MorningTermList = [ "mañana","la mañana" ];
    export const AfternoonTermList = [ "pasado mediodia","pasado el mediodia","pasado mediodía","pasado el mediodía","pasado medio dia","pasado el medio dia","pasado medio día","pasado el medio día" ];
    export const EveningTermList = [ "tarde" ];
    export const NightTermList = [ "noche" ];
    export const SameDayTerms = [ "hoy","el dia" ];
    export const PlusOneDayTerms = [ "mañana","dia siguiente","el dia de mañana","proximo dia" ];
    export const MinusOneDayTerms = [ "ayer","ultimo dia","dia anterior" ];
    export const PlusTwoDayTerms = [ "pasado mañana","dia despues de mañana" ];
    export const MinusTwoDayTerms = [ "anteayer","dia antes de ayer" ];
    export const MonthTerms = [ "mes","meses" ];
    export const MonthToDateTerms = [ "mes a la fecha","mes hasta la fecha" ];
    export const WeekendTerms = [ "finde","fin de semana","fines de semana" ];
    export const WeekTerms = [ "semana" ];
    export const FortnightTerms = [ "quincena","la quincena" ];
    export const YearTerms = [ "año","años" ];
    export const YearToDateTerms = [ "año a la fecha","año hasta la fecha" ];
    export const SpecialCharactersEquivalent: ReadonlyMap<string, string> = new Map<string, string>([["á", "a"],["é", "e"],["í", "i"],["ó", "o"],["ú", "u"]]);
    export const DoubleMultiplierRegex = `^(bi)(-|\\s)?`;
    export const DayTypeRegex = `(d[ií]as?|diari(o|as|amente))$`;
    export const WeekTypeRegex = `(semanas?|semanalmente)$`;
    export const BiWeekTypeRegex = `(quincenalmente)$`;
    export const WeekendTypeRegex = `(fin(es)?\\s+de\\s+semana|finde)$`;
    export const MonthTypeRegex = `(mes(es)?|mensual(es|mente)?)$`;
    export const QuarterTypeRegex = `(trimestral(es|mente)?)$`;
    export const SemiAnnualTypeRegex = `(semestral(es|mente)?)$`;
    export const YearTypeRegex = `(años?|anual(mente)?)$`;
}
