// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

import { BaseDateTime } from "./baseDateTime";
export namespace PortugueseDateTime {
    export const LangMarker = `Por`;
    export const CheckBothBeforeAfter = false;
    export const TillRegex = `(?<till>\\b(at[eé]h?|[aà]s|ao?)\\b|--|-|—|——)(\\s+\\b(o|[aà](s)?)\\b)?`;
    export const RangeConnectorRegex = `(?<and>(e\\s*(([àa]s?)|o)?)|${BaseDateTime.RangeConnectorSymbolRegex})`;
    export const DayRegex = `(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?=\\b|t)`;
    export const WrittenDayRegex = `(?<day>(vinte\\s+e\\s+)?(um|dois|tr[eê]s|quatro|cinco|seis|sete|oito|nove)|dez|onze|doze|treze|(c|qu)atorze|quinze|dez[ae](s(seis|sete)|nove)|dezoito|vinte|trinta(\\s+e\\s+um)?)`;
    export const MonthNumRegex = `(?<month>1[0-2]|(0)?[1-9])\\b`;
    export const AmDescRegex = `(${BaseDateTime.BaseAmDescRegex})`;
    export const PmDescRegex = `(${BaseDateTime.BasePmDescRegex})`;
    export const AmPmDescRegex = `(${BaseDateTime.BaseAmPmDescRegex})`;
    export const OclockRegex = `(?<oclock>em\\s+ponto)`;
    export const DescRegex = `((horas\\s+)?(?<desc>${AmDescRegex}|${PmDescRegex})|${OclockRegex})`;
    export const OfPrepositionRegex = `(\\bd(o|a|e)s?\\b)`;
    export const AfterNextSuffixRegex = `\\b(que\\s+vem|passad[oa])\\b`;
    export const RangePrefixRegex = `((de(sde)?|das?|entre)\\s+(a(s)?\\s+)?)`;
    export const TwoDigitYearRegex = `\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|${AmDescRegex}|${PmDescRegex}|\\.\\d)))\\b`;
    export const RelativeRegex = `(?<order>((n?est[ae]s?|pr[oó]xim[oa]s?|([uú]ltim[ao]s?))(\\s+fina(l|is)\\s+d[eao])?)|(fina(l|is)\\s+d[eao]))\\b`;
    export const StrictRelativeRegex = `(?<order>((n?est[ae]|pr[oó]xim[oa]|([uú]ltim(o|as|os)))(\\s+fina(l|is)\\s+d[eao])?)|(fina(l|is)\\s+d[eao]))\\b`;
    export const WrittenOneToNineRegex = `(uma?|dois|duas|tr[eê]s|quatro|cinco|seis|sete|oito|nove)`;
    export const WrittenOneHundredToNineHundredRegex = `(duzent[oa]s|trezent[oa]s|[cq]uatrocent[ao]s|quinhent[ao]s|seiscent[ao]s|setecent[ao]s|oitocent[ao]s|novecent[ao]s|cem|(?<!por\\s+)(cento))`;
    export const WrittenOneToNinetyNineRegex = `(((vinte|trinta|[cq]uarenta|cinquenta|sessenta|setenta|oitenta|noventa)(\\s+e\\s+${WrittenOneToNineRegex})?)|d[eé]z|onze|doze|treze|(c|qu)atorze|quinze|dez[ea]sseis|dez[ea]ssete|dez[ea]nove|dezoito|uma?|d(oi|ua)s|tr[eê]s|quatro|cinco|seis|sete|oito|nove)`;
    export const FullTextYearRegex = `\\b(?<fullyear>((dois\\s+)?mil)((\\s+e)?\\s+${WrittenOneHundredToNineHundredRegex})?((\\s+e)?\\s+${WrittenOneToNinetyNineRegex})?)`;
    export const YearRegex = `(${BaseDateTime.FourDigitYearRegex}|${FullTextYearRegex})`;
    export const RelativeMonthRegex = `(?<relmonth>([nd]?es[st]e|pr[óo]ximo|passsado|[uú]ltimo)\\s+m[eê]s)\\b`;
    export const MonthRegex = `(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)`;
    export const MonthSuffixRegex = `(?<msuf>((em|no)\\s+|d[eo]\\s+)?(${RelativeMonthRegex}|${MonthRegex}))`;
    export const DateUnitRegex = `(?<unit>(?<uoy>m[êe]s)(?<plural>es)?|(ano|(?<uoy>semana|dia))(?<plural>s)?)\\b`;
    export const PastRegex = `(?<past>\\b(passad[ao](s)?|[uú]ltim[oa](s)?|anterior(es)?|h[aá]|pr[ée]vi[oa](s)?)\\b)`;
    export const FutureRegex = `(?<past>\\b(seguinte(s)?|pr[oó]xim[oa](s)?|daqui\\s+a)\\b)`;
    export const SimpleCasesRegex = `\\b((desde\\s+[oa]|desde|d[oa])\\s+)?(dia\\s+)?(${DayRegex})\\s*${TillRegex}\\s*(o dia\\s+)?(${DayRegex})\\s+${MonthSuffixRegex}((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const MonthFrontSimpleCasesRegex = `\\b${MonthSuffixRegex}\\s+((desde\\s+[oa]|desde|d[oa])\\s+)?(dia\\s+)?(${DayRegex})\\s*${TillRegex}\\s*(${DayRegex})((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const MonthFrontBetweenRegex = `\\b${MonthSuffixRegex}\\s+((entre|entre\\s+[oa]s?)\\s+)(dias?\\s+)?(${DayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex})((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const DayBetweenRegex = `\\b((entre|entre\\s+[oa]s?)\\s+)(dia\\s+)?(${DayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex})\\s+${MonthSuffixRegex}((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const SpecialYearPrefixes = `((do\\s+)?calend[aá]rio|civil|(?<special>fiscal|escolar|letivo))`;
    export const OneWordPeriodRegex = `\\b(((pr[oó]xim[oa]?|[nd]?es[st]e|aquel[ea]|[uú]ltim[oa]?|em)\\s+)?(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)|(${RelativeRegex}\\s+)?(ano\\s+${SpecialYearPrefixes}|${SpecialYearPrefixes}\\s+ano)|(?<=\\b(de|do|da|o|a)\\s+)?(pr[oó]xim[oa](s)?|[uú]ltim[oa]s?|est(e|a))\\s+(fim de semana|fins de semana|semana|m[êe]s|ano)|fim de semana|fins de semana|(m[êe]s|anos)? [àa] data)\\b`;
    export const MonthWithYearRegex = `\\b((((pr[oó]xim[oa](s)?|[nd]?es[st]e|aquele|[uú]ltim[oa]?|em)\\s+)?${MonthRegex}|((n?o\\s+)?(?<cardinal>primeiro|1o|segundo|2o|terceiro|3o|[cq]uarto|4o|quinto|5o|sexto|6o|s[eé]timo|7o|oitavo|8o|nono|9o|d[eé]cimo(\\s+(primeiro|segundo))?|10o|11o|12o|[uú]ltimo)\\s+m[eê]s(?=\\s+(d[aeo]|[ao]))))\\s+((d[aeo]|[ao])\\s+)?(${YearRegex}|${TwoDigitYearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano))\\b`;
    export const MonthNumWithYearRegex = `(${YearRegex}(\\s*?)[/\\-\\.](\\s*?)${MonthNumRegex})|(${MonthNumRegex}(\\s*?)[/\\-](\\s*?)${YearRegex})`;
    export const WeekOfMonthRegex = `(?<wom>(a|na\\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima)\\s+semana\\s+${MonthSuffixRegex})`;
    export const WeekOfYearRegex = `(?<woy>(a|na\\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima?)\\s+semana(\\s+d[oe]?)?\\s+(${YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano))`;
    export const OfYearRegex = `\\b((d[aeo]?|[ao])\\s*(${YearRegex}|${StrictRelativeRegex}\\s+ano))\\b`;
    export const FirstLastRegex = `\\b(n?[ao]s?\\s+)?((?<first>primeir[ao]s?)|(?<last>[uú]ltim[ao]s?))\\b`;
    export const FollowedDateUnit = `^\\s*${DateUnitRegex}`;
    export const NumberCombinedWithDateUnit = `\\b(?<num>\\d+(\\.\\d*)?)${DateUnitRegex}`;
    export const QuarterRegex = `(n?o\\s+)?(?<cardinal>primeiro|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\\s+trimestre(\\s+d[oe]|\\s*,\\s*)?\\s+(${YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano)`;
    export const QuarterRegexYearFront = `(${YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano)\\s+(n?o\\s+)?(?<cardinal>(primeiro)|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\\s+trimestre`;
    export const AllHalfYearRegex = `^[.]`;
    export const PrefixDayRegex = `^[.]`;
    export const SeasonRegex = `\\b(?<season>(([uú]ltim[oa]|[nd]?es[st][ea]|n?[oa]|(pr[oó]xim[oa]s?|seguinte))\\s+)?(?<seas>primavera|ver[ãa]o|outono|inverno)((\\s+)?(seguinte|((de\\s+|,)?\\s*${YearRegex})|((do\\s+)?(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano)))?)\\b`;
    export const WhichWeekRegex = `\\b(semana)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+(de|do)\\s+(${YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano|ano\\s+(?<order>passado)))?\\b`;
    export const WeekOfRegex = `(semana)(\\s*)((do|da|de))`;
    export const MonthOfRegex = `(mes)(\\s*)((do|da|de))`;
    export const RangeUnitRegex = `\\b(?<unit>anos?|meses|m[êe]s|semanas?)\\b`;
    export const BeforeAfterRegex = `^[.]`;
    export const UpcomingPrefixRegex = `.^`;
    export const NextPrefixRegex = `(pr[oó]xim[oa]s?|seguinte|${UpcomingPrefixRegex})\\b`;
    export const InConnectorRegex = `\\b(em)\\b`;
    export const SinceYearSuffixRegex = `^[.]`;
    export const WithinNextPrefixRegex = `\\b(dentro\\s+d(e|as)(\\s+(?<next>${NextPrefixRegex}))?)\\b`;
    export const TodayNowRegex = `\\b(hoje|agora)\\b`;
    export const CenturySuffixRegex = `^[.]`;
    export const FromRegex = `(de(sde)?(\\s*a(s)?)?)$`;
    export const BetweenRegex = `(entre\\s*([oa](s)?)?)`;
    export const WeekDayRegex = `\\b(?<weekday>(domingos?|(segunda|ter[çc]a|quarta|quinta|sexta)s?([-\\s+]feiras?)?|s[aá]bados?|(2|3|4|5|6)[aª])\\b|(dom|seg|ter[cç]|qua|qui|sex|sab)\\b(\\.?(?=\\s|,|;|$)))`;
    export const OnRegex = `(?<=\\b(em|no)\\s+)(${DayRegex}s?)\\b`;
    export const RelaxedOnRegex = `((?<=\\b(em|[nd][oa])\\s+)(dia\\s+)?(${DayRegex}s?)|dia\\s+${DayRegex}s?)\\b(?!\\s*[/\\\\\\-\\.,:\\s]\\s*(\\d|(de\\s+)?${MonthRegex}))`;
    export const ThisRegex = `\\b(([nd]?es[st][ea]\\s*)${WeekDayRegex})|(${WeekDayRegex}\\s*([nd]?es[st]a\\s+semana))\\b`;
    export const LastDateRegex = `\\b(([uú]ltim[ao])\\s*${WeekDayRegex})|(${WeekDayRegex}(\\s+(([nd]?es[st]a|[nd]a)\\s+([uú]ltima\\s+)?semana)))\\b`;
    export const NextDateRegex = `\\b(((pr[oó]xim[oa]|seguinte)\\s*)${WeekDayRegex})|(${WeekDayRegex}((\\s+(pr[oó]xim[oa]|seguinte))|(\\s+(da\\s+)?(semana\\s+seguinte|pr[oó]xima\\s+semana))))\\b`;
    export const SpecialDayRegex = `\\b((d?o\\s+)?(dia\\s+antes\\s+de\\s+ontem|antes\\s+de\\s+ontem|anteontem)|((d?o\\s+)?(dia\\s+|depois\\s+|dia\\s+depois\\s+)?de\\s+amanh[aã])|(o\\s)?dia\\s+seguinte|(o\\s)?pr[oó]ximo\\s+dia|(o\\s+)?[uú]ltimo\\s+dia|ontem|amanh[ãa]|hoje)|(do\\s+dia$)\\b`;
    export const SpecialDayWithNumRegex = `^[.]`;
    export const ForTheRegex = `.^`;
    export const FlexibleDayRegex = `(?<DayOfMonth>([a-z]+\\s)?(${WrittenDayRegex}|${DayRegex}))`;
    export const WeekDayAndDayOfMonthRegex = `\\b${WeekDayRegex}\\s+(dia\\s+${FlexibleDayRegex})\\b`;
    export const WeekDayAndDayRegex = `\\b${WeekDayRegex}\\s+(${DayRegex})(?!([-:/]|\\.\\d|(\\s+(${AmDescRegex}|${PmDescRegex}|${OclockRegex}))))\\b`;
    export const WeekDayOfMonthRegex = `(?<wom>(n?[ao]\\s+)?(?<cardinal>primeir[ao]|1[ao]|segund[ao]|2[ao]|terceir[ao]|3[ao]|[qc]uart[ao]|4[ao]|quint[ao]|5[ao]|[uú]ltim[ao])\\s+${WeekDayRegex}\\s+${MonthSuffixRegex})`;
    export const RelativeWeekDayRegex = `^[.]`;
    export const AmbiguousRangeModifierPrefix = `^[.]`;
    export const NumberEndingPattern = `^[.]`;
    export const SpecialDateRegex = `(?<=\\bno\\s+)${DayRegex}\\b`;
    export const OfMonthRegex = `^(\\s*de)?\\s*${MonthSuffixRegex}`;
    export const MonthEndRegex = `(${MonthRegex}\\s*(o)?\\s*$)`;
    export const WeekDayEnd = `${WeekDayRegex}\\s*,?\\s*$`;
    export const WeekDayStart = `^\\b$`;
    export const DateYearRegex = `(?<year>${YearRegex}|${TwoDigitYearRegex})`;
    export const DateExtractor1 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${DayRegex}((\\s*(de)|[/\\\\\\.\\- ])\\s*)?${MonthRegex}\\b`;
    export const DateExtractor2 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?(${DayRegex}(\\s*([/\\.\\-]|de)?\\s*${MonthRegex}|\\s+de\\s+${MonthNumRegex})(\\s*([,./-]|de|\\s+)\\s*)${DateYearRegex}|${BaseDateTime.FourDigitYearRegex}\\s*[/\\.\\- ]\\s*${DayRegex}\\s*[/\\.\\- ]\\s*${MonthRegex})\\b`;
    export const DateExtractor3 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${MonthRegex}(\\s*[/\\.\\- ]\\s*|\\s+de\\s+)${DayRegex}(?!\\s*\\-\\s*\\d{2}\\b)((\\s*[/\\.\\- ]\\s*|\\s+de\\s+)${DateYearRegex})?\\b`;
    export const DateExtractor4 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${MonthNumRegex}\\s*[/\\\\\\-]\\s*${DayRegex}\\s*[/\\\\\\-]\\s*${DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)`;
    export const DateExtractor5 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${DayRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)`;
    export const DateExtractor6 = `(?<=\\b(em|no|o)\\s+)${MonthNumRegex}[\\-\\.]${DayRegex}${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor7 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${MonthNumRegex}\\s*/\\s*${DayRegex}((\\s+|\\s*(,|de)\\s*)${DateYearRegex})?${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor8 = `(?<=\\b(em|no|o)\\s+)${DayRegex}[\\\\\\-]${MonthNumRegex}${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor9 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?${DayRegex}\\s*/\\s*${MonthNumRegex}((\\s+|\\s*(,|de)\\s*)${DateYearRegex})?${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor10 = `\\b(${WeekDayRegex}(\\s+|\\s*,\\s*))?(${YearRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DayRegex}|${MonthRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*${DayRegex}|${DayRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*${MonthRegex})(?!\\s*[/\\\\\\-\\.:]\\s*\\d+)`;
    export const DateExtractor11 = `(?<=\\b(dia)\\s+)${DayRegex}`;
    export const HourNumRegex = `\\b(?<hournum>zero|uma|duas|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze)\\b`;
    export const MinuteNumRegex = `(?<minnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)`;
    export const DeltaMinuteNumRegex = `(?<deltaminnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)`;
    export const PmRegex = `(horas\\s+)?(?<pm>((pela|de|da|\\b[àa]\\b|na)\\s+(tarde|noite)))|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio dia|meio-dia))`;
    export const AmRegex = `(horas\\s+)?(?<am>(pela|de|da|na)\\s+(manh[ãa]|madrugada))`;
    export const AmTimeRegex = `(?<am>([dn]?es[st]a|(pela|de|da|na))\\s+(manh[ãa]|madrugada))`;
    export const PmTimeRegex = `(?<pm>(([dn]?es[st]a|\\b[àa]\\b|(pela|de|da|na))\\s+(tarde|noite)))|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio dia|meio-dia))`;
    export const LessThanOneHour = `(?<lth>((\\s+e\\s+)?(quinze|(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?)|quinze|(\\s*)(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?|(\\s+e\\s+)(meia|trinta)|(${BaseDateTime.DeltaMinuteRegex}|${DeltaMinuteNumRegex})(\\s+(minuto|minutos|min|mins))?))`;
    export const LessThanOneHourSuffix = `(?<lth>((\\s+e\\s+)?(quinze|(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?)|quinze|(\\s*)(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?|(\\s+e\\s+)(meia|trinta)))`;
    export const TensTimeRegex = `(?<tens>dez|vinte|trinta|[qc]uarenta|cin[qc]uenta)`;
    export const WrittenTimeRegex = `(?<writtentime>(${HourNumRegex}\\s*((e|menos)\\s+)?((${TensTimeRegex}((\\s*e\\s+)?${MinuteNumRegex}))|${MinuteNumRegex}))|((${MinuteNumRegex}|(${TensTimeRegex}((\\s*e\\s+)?${MinuteNumRegex})?))\\s*((para as|pras|antes da|antes das)\\s+)?(${HourNumRegex}|${BaseDateTime.HourRegex})))`;
    export const TimePrefix = `(?<prefix>${LessThanOneHour}(\\s+(passad[ao]s)\\s+(as)?|\\s+depois\\s+(das?|do)|\\s+pras?|\\s+(para|antes)?\\s+([àa]s?)))`;
    export const TimeSuffix = `(?<suffix>(${LessThanOneHour}\\s+)?(${AmRegex}|${PmRegex}|${OclockRegex}))`;
    export const BasicTime = `(?<basictime>${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}:${BaseDateTime.MinuteRegex}(:${BaseDateTime.SecondRegex})?|${BaseDateTime.HourRegex})`;
    export const MidnightRegex = `(?<midnight>meia\\s*(-\\s*)?noite)`;
    export const MidmorningRegex = `(?<midmorning>meio\\s+da\\s+manhã)`;
    export const MidEarlyMorning = `(?<midearlymorning>meio\\s+da\\s+madrugada)`;
    export const MidafternoonRegex = `(?<midafternoon>meio\\s+da\\s+tarde)`;
    export const MiddayRegex = `(?<midday>meio\\s*(-\\s*)?dia)`;
    export const MidTimeRegex = `(?<mid>(${MidnightRegex}|${MidmorningRegex}|${MidEarlyMorning}|${MidafternoonRegex}|${MiddayRegex}))`;
    export const AtRegex = `\\b(((?<=\\b(d?[aà]s?)\\s+)(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}(\\s+e\\s+${BaseDateTime.MinuteRegex})?)(\\s+horas?|\\s*h\\b)?|(?<=\\b(s(er)?[aã]o|v[aã]o\\s+ser|^[eé]h?)\\s+|^\\s*)(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex})(\\s+horas?|\\s*h\\b))(\\s+${OclockRegex})?|${MidTimeRegex})\\b`;
    export const ConnectNumRegex = `(${BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*${DescRegex})`;
    export const TimeRegex1 = `(\\b${TimePrefix}\\s+)?(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex})\\s*(${DescRegex})`;
    export const TimeRegex2 = `(\\b${TimePrefix}\\s+)?(t)?${BaseDateTime.HourRegex}(\\s*)?:(\\s*)?${BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?${BaseDateTime.SecondRegex})?((\\s*${DescRegex})|\\b)`;
    export const TimeRegex3 = `(\\b${TimePrefix}\\s+)?${BaseDateTime.HourRegex}\\.${BaseDateTime.MinuteRegex}(\\s*${DescRegex})`;
    export const TimeRegex4 = `\\b((${DescRegex}\\s*)?((${TimePrefix}\\s*)(${HourNumRegex}|${BaseDateTime.HourRegex})|(${HourNumRegex}|${BaseDateTime.HourRegex})(\\s+${TensTimeRegex}(\\s+e\\s+)?${MinuteNumRegex}?)|${BasicTime}(\\s*${DescRegex})?(?<prefix>${LessThanOneHourSuffix}))(\\s*(${DescRegex}|${OclockRegex}))?)\\b`;
    export const TimeRegex5 = `\\b(${TimePrefix}|${BasicTime}(?<prefix>${LessThanOneHourSuffix}))\\s+(\\s*${DescRegex})?${BasicTime}?\\s*${TimeSuffix}\\b`;
    export const TimeRegex6 = `(${BasicTime}(\\s*${DescRegex})?\\s+${TimeSuffix}\\b)`;
    export const TimeRegex7 = `\\b${TimeSuffix}\\s+[àa]s?\\s+${BasicTime}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex8 = `\\b${TimeSuffix}\\s+${BasicTime}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex9 = `\\b(?<writtentime>${HourNumRegex}\\s+(${TensTimeRegex}\\s*)(e\\s+)?${MinuteNumRegex}?)\\b`;
    export const TimeRegex11 = `\\b(${WrittenTimeRegex})(\\s+${DescRegex})?\\b`;
    export const TimeRegex12 = `(\\b${TimePrefix}\\s+)?${BaseDateTime.HourRegex}(\\s*h\\s*)${BaseDateTime.MinuteRegex}(\\s*${DescRegex})?`;
    export const PrepositionRegex = `(?<prep>([àa]s?|em|por|pel[ao]|n[ao]|de|d[ao]?)?$)`;
    export const NowRegex = `\\b(?<now>((logo|exatamente)\\s+)?agora(\\s+mesmo)?|neste\\s+momento|(assim\\s+que|t[ãa]o\\s+cedo\\s+quanto)\\s+(poss[ií]vel|possas?|possamos)|o\\s+mais\\s+(cedo|r[aá]pido)\\s+poss[íi]vel|recentemente|previamente)\\b`;
    export const SuffixRegex = `^\\s*((e|a|em|por|pel[ao]|n[ao]|de)\\s+)?(manh[ãa]|madrugada|meio\\s*dia|tarde|noite)\\b`;
    export const TimeOfDayRegex = `\\b(?<timeOfDay>manh[ãa]|madrugada|tarde|noite|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio[ -]dia)))\\b`;
    export const SpecificTimeOfDayRegex = `\\b(((((a)?\\s+|[nd]?es[st]a|seguinte|pr[oó]xim[oa]|[uú]ltim[oa])\\s+)?${TimeOfDayRegex}))\\b`;
    export const TimeOfTodayAfterRegex = `^\\s*(,\\s*)?([àa]|em|por|pel[ao]|de|no|na?\\s+)?${SpecificTimeOfDayRegex}`;
    export const TimeOfTodayBeforeRegex = `(${SpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]s|para))?\\s*)`;
    export const SimpleTimeOfTodayAfterRegex = `(${HourNumRegex}|${BaseDateTime.HourRegex})\\s*(,\\s*)?${SpecificTimeOfDayRegex}`;
    export const SimpleTimeOfTodayBeforeRegex = `(${SpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]s|((cerca|perto|ao\\s+redor|por\\s+volta)\\s+(de|das))))?\\s*(${HourNumRegex}|${BaseDateTime.HourRegex}))`;
    export const SpecificEndOfRegex = `([na]o\\s+)?(fi(m|nal)|t[ée]rmin(o|ar))(\\s+d?o(\\s+dia)?(\\s+de)?)?\\s*$`;
    export const UnspecificEndOfRegex = `^[.]`;
    export const UnspecificEndOfRangeRegex = `^[.]`;
    export const UnitRegex = `(?<unit>anos?|meses|m[êe]s|semanas?|dias?|horas?|hrs?|hs?|minutos?|mins?|segundos?|segs?)\\b`;
    export const ConnectorRegex = `^(,|t|para [ao]|para as|pras|(cerca|perto|ao\\s+redor|por\\s+volta)\\s+(de|das)|quase)$`;
    export const TimeHourNumRegex = `(?<hour>vinte( e (um|dois|tr[êe]s|quatro))?|zero|uma?|dois|duas|tr[êe]s|quatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|quatorze|catorze|quinze|dez([ea]sseis|[ea]ssete|oito|[ea]nove))`;
    export const PureNumFromTo = `(((desde|de|da|das)\\s+(a(s)?\\s+)?)?(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}|horas))?\\s*${TillRegex}(?<![aà]s)|((desde|de|da|das)\\s+(a(s)?\\s+)?)(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}|horas))?\\s*${TillRegex})\\s*(${BaseDateTime.HourRegex}|${TimeHourNumRegex})\\s*(?<rightDesc>${PmRegex}|${AmRegex}|${DescRegex}|horas)?`;
    export const PureNumBetweenAnd = `(entre\\s+((a|as)?\\s+)?)(${BaseDateTime.HourRegex}|${TimeHourNumRegex})(\\s*(?<leftDesc>${DescRegex}|horas))?\\s*e\\s*(a(s)?\\s+)?(${BaseDateTime.HourRegex}|${TimeHourNumRegex})\\s*(?<rightDesc>${PmRegex}|${AmRegex}|${DescRegex}|horas)?`;
    export const SpecificTimeFromTo = `^[.]`;
    export const SpecificTimeBetweenAnd = `^[.]`;
    export const TimeUnitRegex = `(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\\b`;
    export const TimeFollowedUnit = `^\\s*${TimeUnitRegex}`;
    export const TimeNumberCombinedWithUnit = `\\b(?<num>\\d+(\\,\\d*)?)\\s*${TimeUnitRegex}`;
    export const DateTimePeriodNumberCombinedWithUnit = `\\b(?<num>\\d+(\\.\\d*)?)\\s*${TimeUnitRegex}`;
    export const PeriodTimeOfDayWithDateRegex = `\\b((e|[àa]|em|na|no|ao|pel[ao]|de)\\s+)?(?<timeOfDay>manh[ãa]|madrugada|(passado\\s+(o\\s+)?)?meio\\s+dia|tarde|noite)\\b`;
    export const RelativeTimeUnitRegex = `(${PastRegex}|${FutureRegex})\\s+${UnitRegex}|${UnitRegex}\\s+(${PastRegex}|${FutureRegex})`;
    export const SuffixAndRegex = `(?<suffix>\\s*(e)\\s+(?<suffix_num>meia|(um\\s+)?quarto))`;
    export const FollowedUnit = `^\\s*${UnitRegex}`;
    export const LessThanRegex = `^[.]`;
    export const MoreThanRegex = `^[.]`;
    export const DurationNumberCombinedWithUnit = `\\b(?<num>\\d+(\\,\\d*)?)${UnitRegex}`;
    export const AnUnitRegex = `\\b(um(a)?)\\s+${UnitRegex}`;
    export const DuringRegex = `^[.]`;
    export const AllRegex = `\\b(?<all>tod[oa]?\\s+(o|a)\\s+(?<unit>ano|m[êe]s|semana|dia))\\b`;
    export const HalfRegex = `\\b(?<half>mei[oa]\\s+(?<unit>ano|m[êe]s|semana|dia|hora))\\b`;
    export const ConjunctionRegex = `^[.]`;
    export const InexactNumberRegex = `\\b(poucos|pouco|algum|alguns|v[áa]rios)\\b`;
    export const InexactNumberUnitRegex = `\\b(poucos|pouco|algum|alguns|v[áa]rios)\\s+${UnitRegex}`;
    export const HolidayRegex1 = `\\b(?<holiday>sexta-feira santa|sexta-feira da paix[ãa]o|quarta-feira de cinzas|carnaval|dia dos? presidentes?|ano novo chin[eê]s|ano novo|v[ée]spera de ano novo|natal|v[ée]spera de natal|dia de a[cç][ãa]o de gra[çc]as|a[cç][ãa]o de gra[çc]as|yuandan|halloween|dia das bruxas|p[áa]scoa)(\\s+(d[eo]?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b`;
    export const HolidayRegex2 = `\\b(?<holiday>(dia\\s+(d[eoa]s?\\s+)?)?(martin luther king|todos os santos|s[ãa]o (patr[íi]cio|francisco|jorge|jo[ãa]o)|independ[êe]ncia))(\\s+(d[eo]?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b`;
    export const HolidayRegex3 = `\\b(?<holiday>(dia\\s+d[eoa]s?\\s+)(trabalh(o|ador(es)?)|m[ãa]es?|pais?|mulher(es)?|crian[çc]as?|marmota|professor(es)?))(\\s+(d[eo]?\\s+)?(${YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b`;
    export const BeforeRegex = `(antes(\\s+(d(e\\s+)?[aeo]s?)?)?|at[ée]h?(\\s+[oàa]s?\\b)?)`;
    export const AfterRegex = `((depois|ap[óo]s|a\\s+partir)(\\s*(de|d?[oa]s?)?)?)`;
    export const SinceRegex = `(desde(\\s+(as?|o))?)`;
    export const AroundRegex = `(?:\\b(?:cerca|perto|ao\\s+redor|por\\s+volta)\\s*?\\b)(\\s+(de|das))?`;
    export const PeriodicRegex = `\\b(?<periodic>di[áa]ri[ao]|(diaria|mensal|semanal|quinzenal|(bi|tri|se)mestral|anual)(mente)?)\\b`;
    export const EachExpression = `cada|tod[oa]s?\\s*([oa]s)?`;
    export const EachUnitRegex = `(?<each>(${EachExpression})\\s*${UnitRegex})`;
    export const EachPrefixRegex = `(?<each>(${EachExpression})\\s*$)`;
    export const EachDayRegex = `\\s*(${EachExpression})\\s*dias\\s*\\b`;
    export const BeforeEachDayRegex = `(${EachExpression})\\s*dias(\\s+a[so])?\\s*\\b`;
    export const SetEachRegex = `(?<each>(${EachExpression})\\s*)`;
    export const LaterEarlyPeriodRegex = `^[.]`;
    export const WeekWithWeekDayRangeRegex = `^[.]`;
    export const GeneralEndingRegex = `^[.]`;
    export const MiddlePauseRegex = `^[.]`;
    export const PrefixArticleRegex = `^[\\.]`;
    export const OrRegex = `^[.]`;
    export const SpecialYearTermsRegex = `\\b((${SpecialYearPrefixes}\\s+anos?\\s+|anos?\\s+(${SpecialYearPrefixes}\\s+)?)(d[oe]\\s+)?)`;
    export const YearPlusNumberRegex = `\\b(${SpecialYearTermsRegex}((?<year>(\\d{2,4}))|${FullTextYearRegex}))\\b`;
    export const NumberAsTimeRegex = `\\b(${WrittenTimeRegex}|(${TimeHourNumRegex}|${BaseDateTime.HourRegex})(?<desc>\\s*horas)?)\\b`;
    export const TimeBeforeAfterRegex = `^[.]`;
    export const DateNumberConnectorRegex = `^[.]`;
    export const ComplexDatePeriodRegex = `^[.]`;
    export const AgoRegex = `\\b(antes(\\s+d[eoa]s?\\s+(?<day>hoje|ontem|manhã))?|atr[áa]s|no passado)\\b`;
    export const LaterRegex = `\\b(depois(\\s+d[eoa]s?\\s+(agora|(?<day>hoje|ontem|manhã)))?|ap[óo]s (as)?|desde( (as|o))?|no futuro|mais tarde)\\b`;
    export const Tomorrow = `amanh[ãa]`;
    export const UnitMap: ReadonlyMap<string, string> = new Map<string, string>([["anos", "Y"],["ano", "Y"],["meses", "MON"],["mes", "MON"],["mês", "MON"],["semanas", "W"],["semana", "W"],["dias", "D"],["dia", "D"],["horas", "H"],["hora", "H"],["hrs", "H"],["hr", "H"],["h", "H"],["minutos", "M"],["minuto", "M"],["mins", "M"],["min", "M"],["segundos", "S"],["segundo", "S"],["segs", "S"],["seg", "S"]]);
    export const UnitValueMap: ReadonlyMap<string, number> = new Map<string, number>([["anos", 31536000],["ano", 31536000],["meses", 2592000],["mes", 2592000],["mês", 2592000],["semanas", 604800],["semana", 604800],["dias", 86400],["dia", 86400],["horas", 3600],["hora", 3600],["hrs", 3600],["hr", 3600],["h", 3600],["minutos", 60],["minuto", 60],["mins", 60],["min", 60],["segundos", 1],["segundo", 1],["segs", 1],["seg", 1]]);
    export const SpecialYearPrefixesMap: ReadonlyMap<string, string> = new Map<string, string>([["fiscal", "FY"],["escolar", "SY"],["letivo", "SY"]]);
    export const SeasonMap: ReadonlyMap<string, string> = new Map<string, string>([["primavera", "SP"],["verao", "SU"],["verão", "SU"],["outono", "FA"],["inverno", "WI"]]);
    export const SeasonValueMap: ReadonlyMap<string, number> = new Map<string, number>([["SP", 3],["SU", 6],["FA", 9],["WI", 12]]);
    export const CardinalMap: ReadonlyMap<string, number> = new Map<string, number>([["primeiro", 1],["primeira", 1],["1o", 1],["1a", 1],["segundo", 2],["segunda", 2],["2o", 2],["2a", 2],["terceiro", 3],["terceira", 3],["3o", 3],["3a", 3],["cuarto", 4],["quarto", 4],["cuarta", 4],["quarta", 4],["4o", 4],["4a", 4],["quinto", 5],["quinta", 5],["5o", 5],["5a", 5],["sexto", 6],["sexta", 6],["6o", 6],["6a", 6],["setimo", 7],["sétimo", 7],["setima", 7],["sétima", 7],["7o", 7],["7a", 7],["oitavo", 8],["oitava", 8],["8o", 8],["8a", 8],["nono", 9],["nona", 9],["9o", 9],["9a", 9],["decimo", 10],["décimo", 10],["decima", 10],["décima", 10],["10o", 10],["10a", 10],["decimo primeiro", 11],["décimo primeiro", 11],["decima primeira", 11],["décima primeira", 11],["11o", 11],["11a", 11],["decimo segundo", 12],["décimo segundo", 12],["decima segunda", 12],["décima segunda", 12],["12o", 12],["12a", 12]]);
    export const DayOfWeek: ReadonlyMap<string, number> = new Map<string, number>([["segunda-feira", 1],["segundas-feiras", 1],["segunda feira", 1],["segundas feiras", 1],["segunda", 1],["segundas", 1],["terça-feira", 2],["terças-feiras", 2],["terça feira", 2],["terças feiras", 2],["terça", 2],["terças", 2],["terca-feira", 2],["tercas-feiras", 2],["terca feira", 2],["tercas feiras", 2],["terca", 2],["tercas", 2],["quarta-feira", 3],["quartas-feiras", 3],["quarta feira", 3],["quartas feiras", 3],["quarta", 3],["quartas", 3],["quinta-feira", 4],["quintas-feiras", 4],["quinta feira", 4],["quintas feiras", 4],["quinta", 4],["quintas", 4],["sexta-feira", 5],["sextas-feiras", 5],["sexta feira", 5],["sextas feiras", 5],["sexta", 5],["sextas", 5],["sabado", 6],["sabados", 6],["sábado", 6],["sábados", 6],["domingo", 0],["domingos", 0],["seg", 1],["seg.", 1],["2a", 1],["ter", 2],["ter.", 2],["3a", 2],["qua", 3],["qua.", 3],["4a", 3],["qui", 4],["qui.", 4],["5a", 4],["sex", 5],["sex.", 5],["6a", 5],["sab", 6],["sab.", 6],["dom", 0],["dom.", 0]]);
    export const MonthOfYear: ReadonlyMap<string, number> = new Map<string, number>([["1", 1],["2", 2],["3", 3],["4", 4],["5", 5],["6", 6],["7", 7],["8", 8],["9", 9],["10", 10],["11", 11],["12", 12],["janeiro", 1],["fevereiro", 2],["março", 3],["marco", 3],["abril", 4],["maio", 5],["junho", 6],["julho", 7],["agosto", 8],["septembro", 9],["setembro", 9],["outubro", 10],["novembro", 11],["dezembro", 12],["jan", 1],["fev", 2],["mar", 3],["abr", 4],["mai", 5],["jun", 6],["jul", 7],["ago", 8],["sept", 9],["set", 9],["out", 10],["nov", 11],["dez", 12],["01", 1],["02", 2],["03", 3],["04", 4],["05", 5],["06", 6],["07", 7],["08", 8],["09", 9]]);
    export const Numbers: ReadonlyMap<string, number> = new Map<string, number>([["zero", 0],["um", 1],["uma", 1],["dois", 2],["tres", 3],["três", 3],["quatro", 4],["cinco", 5],["seis", 6],["sete", 7],["oito", 8],["nove", 9],["dez", 10],["onze", 11],["doze", 12],["dezena", 12],["dezenas", 12],["treze", 13],["catorze", 14],["quatorze", 14],["quinze", 15],["dezesseis", 16],["dezasseis", 16],["dezessete", 17],["dezassete", 17],["dezoito", 18],["dezenove", 19],["dezanove", 19],["vinte", 20],["vinte e um", 21],["vinte e uma", 21],["vinte e dois", 22],["vinte e duas", 22],["vinte e tres", 23],["vinte e três", 23],["vinte e quatro", 24],["vinte e cinco", 25],["vinte e seis", 26],["vinte e sete", 27],["vinte e oito", 28],["vinte e nove", 29],["trinta", 30],["trinta e um", 31],["quarenta", 40],["cinquenta", 50]]);
    export const HolidayNames: ReadonlyMap<string, string[]> = new Map<string, string[]>([["pai", ["diadopai","diadospais"]],["mae", ["diadamae","diadasmaes"]],["acaodegracas", ["diadegracas","diadeacaodegracas","acaodegracas"]],["trabalho", ["diadotrabalho","diadotrabalhador","diadostrabalhadores"]],["pascoa", ["diadepascoa","pascoa"]],["natal", ["natal","diadenatal"]],["vesperadenatal", ["vesperadenatal"]],["anonovo", ["anonovo","diadeanonovo","diadoanonovo"]],["vesperadeanonovo", ["vesperadeanonovo","vesperadoanonovo"]],["yuandan", ["yuandan"]],["todosossantos", ["todosossantos"]],["professor", ["diadoprofessor","diadosprofessores"]],["crianca", ["diadacrianca","diadascriancas"]],["mulher", ["diadamulher"]]]);
    export const VariableHolidaysTimexDictionary: ReadonlyMap<string, string> = new Map<string, string>([["pai", "-06-WXX-7-3"],["mae", "-05-WXX-7-2"],["acaodegracas", "-11-WXX-4-4"],["memoria", "-03-WXX-2-4"]]);
    export const DoubleNumbers: ReadonlyMap<string, number> = new Map<string, number>([["metade", 0.5],["quarto", 0.25]]);
    export const DateTokenPrefix = `em `;
    export const TimeTokenPrefix = `as `;
    export const TokenBeforeDate = `o `;
    export const TokenBeforeTime = `as `;
    export const PastPrefixRegex = `.^`;
    export const PreviousPrefixRegex = `([uú]ltim[oa]s?|passad[oa]s?|${PastPrefixRegex})\\b`;
    export const ThisPrefixRegex = `([nd]?es[st][ea])\\b`;
    export const RelativeDayRegex = `^[\\.]`;
    export const RestOfDateRegex = `^[\\.]`;
    export const DurationUnitRegex = `(?<unit>${DateUnitRegex}|${TimeUnitRegex}|noites?)\\b`;
    export const RelativeDurationUnitRegex = `(?:(?<=(${NextPrefixRegex}|${PreviousPrefixRegex}|${ThisPrefixRegex})\\s+)(${DurationUnitRegex}))`;
    export const ReferenceDatePeriodRegex = `^[.]`;
    export const FromToRegex = `\\b(from).+(to)\\b.+`;
    export const SingleAmbiguousMonthRegex = `^(the\\s+)?(may|march)$`;
    export const UnspecificDatePeriodRegex = `^[.]`;
    export const PrepositionSuffixRegex = `\\b(on|in|at|around|from|to)$`;
    export const RestOfDateTimeRegex = `^[\\.]`;
    export const SetWeekDayRegex = `^[\\.]`;
    export const NightRegex = `\\b(meia noite|noite|de noite)\\b`;
    export const CommonDatePrefixRegex = `\\b(dia)\\s+$`;
    export const DurationConnectorRegex = `^[.]`;
    export const CenturyRegex = `^[.]`;
    export const DecadeRegex = `^[.]`;
    export const DecadeWithCenturyRegex = `^[.]`;
    export const RelativeDecadeRegex = `\\b((n?as?\\s+)?${RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?(d[eé]cada)s?)\\b`;
    export const YearSuffix = `((,|\\sde)?\\s*(${YearRegex}|${FullTextYearRegex}))`;
    export const SuffixAfterRegex = `^\\b$`;
    export const YearPeriodRegex = `((((de(sde)?(\\s*a(s)?)?)\\s+)?${YearRegex}\\s*(${TillRegex})\\s*${YearRegex})|(((entre\\s*([oa](s)?)?)\\s+)${YearRegex}\\s*(${RangeConnectorRegex})\\s*${YearRegex}))`;
    export const FutureSuffixRegex = `\\b(seguinte(s)?|pr[oó]xim[oa](s)?|no\\s+futuro)\\b`;
    export const PastSuffixRegex = `^\\b$`;
    export const ModPrefixRegex = `\\b(${RelativeRegex}|${AroundRegex}|${BeforeRegex}|${AfterRegex}|${SinceRegex})\\b`;
    export const ModSuffixRegex = `\\b(${AgoRegex}|${LaterRegex}|${BeforeAfterRegex}|${FutureSuffixRegex}|${PastSuffixRegex})\\b`;
    export const WrittenDecades: ReadonlyMap<string, number> = new Map<string, number>([["", 0]]);
    export const SpecialDecadeCases: ReadonlyMap<string, number> = new Map<string, number>([["", 0]]);
    export const DefaultLanguageFallback = `DMY`;
    export const DurationDateRestrictions = [  ];
    export const AmbiguityFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"],["^(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)$", "([$%£&!?@#])(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)|(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)([$%£&@#])"],["^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}"],["^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}"]]);
    export const AmbiguityTimeFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["horas?$", "\\b((por|duração\\s+de|durante)\\s+(\\S+\\s+){1,2}horas?|horas?\\s+(\\S+\\s+){0,2}dur(ação|ou|a(rá|va)?))\\b"]]);
    export const EarlyMorningTermList = [ "madrugada" ];
    export const MorningTermList = [ "manha","manhã" ];
    export const AfternoonTermList = [ "passado o meio dia","depois do meio dia" ];
    export const EveningTermList = [ "tarde" ];
    export const NightTermList = [ "noite" ];
    export const SameDayTerms = [ "hoje","este dia","esse dia","o dia" ];
    export const PlusOneDayTerms = [ "amanha","de amanha","dia seguinte","o dia de amanha","proximo dia" ];
    export const MinusOneDayTerms = [ "ontem","ultimo dia" ];
    export const PlusTwoDayTerms = [ "depois de amanha","dia depois de amanha" ];
    export const MinusTwoDayTerms = [ "anteontem","dia antes de ontem" ];
    export const MonthTerms = [ "mes","meses" ];
    export const MonthToDateTerms = [ "mes ate agora","mes ate hoje","mes ate a data" ];
    export const WeekendTerms = [ "fim de semana" ];
    export const WeekTerms = [ "semana" ];
    export const FortnightTerms = [ "quinzena" ];
    export const YearTerms = [ "ano","anos" ];
    export const YearToDateTerms = [ "ano ate agora","ano ate hoje","ano ate a data","anos ate agora","anos ate hoje","anos ate a data" ];
    export const SpecialCharactersEquivalent: ReadonlyMap<string, string> = new Map<string, string>([["á", "a"],["é", "e"],["í", "i"],["ó", "o"],["ú", "u"],["ê", "e"],["ô", "o"],["ü", "u"],["ã", "a"],["õ", "o"],["ç", "c"]]);
    export const DayTypeRegex = `(diari([ao]|amente))$`;
    export const WeekTypeRegex = `(semanal(mente)?)$`;
    export const BiWeekTypeRegex = `(quinzenal(mente)?)$`;
    export const MonthTypeRegex = `(mensal(mente)?)$`;
    export const BiMonthTypeRegex = `(bimestral(mente)?)$`;
    export const QuarterTypeRegex = `(trimestral(mente)?)$`;
    export const SemiAnnualTypeRegex = `(semestral(mente)?)$`;
    export const YearTypeRegex = `(anual(mente)?)$`;
}
