// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

import { BaseDateTime } from "./baseDateTime";
export namespace EnglishDateTime {
    export const LangMarker = `Eng`;
    export const CheckBothBeforeAfter = false;
    export const TillRegex = `(?<till>\\b(to|(un)?till?|thru|through)\\b(\\s+the\\b)?|${BaseDateTime.RangeConnectorSymbolRegex})`;
    export const RangeConnectorRegex = `(?<and>\\b(and|through|to)\\b(\\s+the\\b)?|${BaseDateTime.RangeConnectorSymbolRegex})`;
    export const LastNegPrefix = `(?<!(w(ill|ould|on\\s*'\\s*t)|m(ay|ight|ust)|sh(all|ould(n\\s*'\\s*t)?)|c(an(\\s*'\\s*t|not)?|ould(n\\s*'\\s*t)?))(\\s+not)?\\s+)`;
    export const RelativeRegex = `\\b(?<order>following|next|(up)?coming|this|${LastNegPrefix}last|past|previous|current|the)\\b`;
    export const StrictRelativeRegex = `\\b(?<order>following|next|(up)?coming|this|${LastNegPrefix}last|past|previous|current)\\b`;
    export const UpcomingPrefixRegex = `((this\\s+)?((up)?coming))`;
    export const NextPrefixRegex = `\\b(following|next|${UpcomingPrefixRegex})\\b`;
    export const AfterNextSuffixRegex = `\\b(after\\s+(the\\s+)?next)\\b`;
    export const PastPrefixRegex = `((this\\s+)?past)\\b`;
    export const PreviousPrefixRegex = `(${LastNegPrefix}last|previous|${PastPrefixRegex})\\b`;
    export const ThisPrefixRegex = `(this|current)\\b`;
    export const RangePrefixRegex = `(from|between)`;
    export const CenturySuffixRegex = `(^century)\\b`;
    export const ReferencePrefixRegex = `(that|same)\\b`;
    export const FutureSuffixRegex = `\\b((in\\s+the\\s+)?future|hence)\\b`;
    export const PastSuffixRegex = `\\b((in\\s+the\\s+)past)\\b`;
    export const DayRegex = `(the\\s*)?(?<!(\\d:|\\$)\\s*|\\d)(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?)(?=\\b|t)`;
    export const ImplicitDayRegex = `(the\\s*)?(?<day>(?:3[0-1]|[0-2]?\\d)(?:th|nd|rd|st))\\b`;
    export const MonthNumRegex = `(?<month>1[0-2]|(0)?[1-9])\\b`;
    export const WrittenOneToNineRegex = `(?:one|two|three|four|five|six|seven|eight|nine)`;
    export const WrittenElevenToNineteenRegex = `(?:eleven|twelve|(?:thir|four|fif|six|seven|eigh|nine)teen)`;
    export const WrittenTensRegex = `(?:ten|twenty|thirty|fou?rty|fifty|sixty|seventy|eighty|ninety)`;
    export const WrittenNumRegex = `(?:${WrittenOneToNineRegex}|${WrittenElevenToNineteenRegex}|${WrittenTensRegex}(\\s+${WrittenOneToNineRegex})?)`;
    export const WrittenOneToNineOrdinalRegex = `(?:first|second|third|fourth|fifth|sixth|seventh|eighth|nine?th)`;
    export const WrittenTensOrdinalRegex = `(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth)`;
    export const WrittenOrdinalRegex = `(?:${WrittenOneToNineOrdinalRegex}|${WrittenTensOrdinalRegex}|${WrittenTensRegex}\\s+${WrittenOneToNineOrdinalRegex})`;
    export const WrittenOrdinalDayRegex = `\\b(the\\s+)?(?<day>(?<ordinal>${WrittenOneToNineOrdinalRegex}|(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth)|(?:ten|twenty)\\s+${WrittenOneToNineOrdinalRegex}|thirty\\s+first))\\b`;
    export const WrittenCenturyFullYearRegex = `(?:(one|two)\\s+thousand((\\s+and)?\\s+${WrittenOneToNineRegex}\\s+hundred)?)`;
    export const WrittenCenturyOrdinalYearRegex = `(?:twenty(\\s+(one|two))?|ten|eleven|twelve|thirteen|fifteen|eighteen|(?:four|six|seven|nine)(teen)?|one|two|three|five|eight)`;
    export const CenturyRegex = `\\b(?<century>${WrittenCenturyFullYearRegex}|${WrittenCenturyOrdinalYearRegex}(\\s+hundred)?)\\b`;
    export const LastTwoYearNumRegex = `(?:(zero\\s+)?${WrittenOneToNineRegex}|${WrittenElevenToNineteenRegex}|${WrittenTensRegex}(\\s+${WrittenOneToNineRegex})?)`;
    export const FullTextYearRegex = `\\b((?<firsttwoyearnum>${CenturyRegex})(\\s+and)?\\s+(?<lasttwoyearnum>${LastTwoYearNumRegex})\\b|\\b(?<firsttwoyearnum>${WrittenCenturyFullYearRegex}|${WrittenCenturyOrdinalYearRegex}\\s+hundred))\\b`;
    export const OclockRegex = `(?<oclock>o\\s*((’|‘|')\\s*)?clock|sharp)`;
    export const SpecialDescRegex = `((?<ipm>)p\\b)`;
    export const TasksModeSpecialDescRegex = `([0-9]+((?<ipm>)p\\b))`;
    export const AmDescRegex = `(?:${BaseDateTime.BaseAmDescRegex})`;
    export const PmDescRegex = `(:?${BaseDateTime.BasePmDescRegex})`;
    export const AmPmDescRegex = `(:?${BaseDateTime.BaseAmPmDescRegex})`;
    export const DescRegex = `(:?(:?(${OclockRegex}\\s+)?(?<desc>(${AmPmDescRegex}|${AmDescRegex}|${PmDescRegex}|${SpecialDescRegex})))|${OclockRegex})`;
    export const OfPrepositionRegex = `(\\bof\\b)`;
    export const TwoDigitYearRegex = `\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|${AmDescRegex}|${PmDescRegex}|\\.\\d)))\\b`;
    export const YearRegex = `(?:${BaseDateTime.FourDigitYearRegex}|${FullTextYearRegex})`;
    export const WeekDayRegex = `\\b(?<weekday>(?:sun|mon|tues?|thurs?|fri)(day)?|thu|wedn(esday)?|weds?|sat(urday)?)s?\\b`;
    export const SingleWeekDayRegex = `\\b(?<weekday>(?<!(easter|palm)\\s+)sunday|(?<!easter\\s+)saturday|(?<!(easter|cyber)\\s+)monday|mon|(?<!black\\s+)friday|fri|(?:tues?|thurs?)(day)?|thu|wedn(esday)?|weds?|((?<=on\\s+)(sat|sun)))\\b`;
    export const RelativeMonthRegex = `(?<relmonth>((day\\s+)?of\\s+)?${RelativeRegex}\\s+month)\\b`;
    export const MonthRegexNoWordBoundary = `(?<month>apr(il)?|aug(ust)?|dec(ember)?|feb(ruary)?|jan(uary)?|july?|june?|mar(ch)?|may|nov(ember)?|oct(ober)?|sept(ember)?|sep)(?!\\p{L})`;
    export const MonthRegex = `\\b${MonthRegexNoWordBoundary}`;
    export const WrittenMonthRegex = `(((the\\s+)?month of\\s+)?${MonthRegex})`;
    export const MonthSuffixRegex = `(?<msuf>(?:(in|of|on)\\s+)?(${RelativeMonthRegex}|${WrittenMonthRegex}))`;
    export const DateUnitRegex = `(?<unit>(decade|year|(?<uoy>month|week)|(?<business>(business\\s+|week\\s*))?(?<uoy>day)|fortnight|weekend)(?<plural>s)?|(?<=(^|\\s)\\d{1,4})[ymwd])\\b`;
    export const DateTokenPrefix = `on `;
    export const TimeTokenPrefix = `at `;
    export const TokenBeforeDate = `on `;
    export const TokenBeforeTime = `at `;
    export const HalfTokenRegex = `^(half)`;
    export const QuarterTokenRegex = `^((a\\s+)?quarter)`;
    export const ThreeQuarterTokenRegex = `^(three\\s+quarters?)`;
    export const ToTokenRegex = `\\b(to)$`;
    export const FromRegex = `\\b(from(\\s+the)?)$`;
    export const BetweenTokenRegex = `\\b(between(\\s+the)?)$`;
    export const SimpleCasesRegex = `\\b(${RangePrefixRegex}\\s+)?(${DayRegex}|${WrittenOrdinalDayRegex})\\s*${TillRegex}\\s*((${DayRegex}|${WrittenOrdinalDayRegex})\\s+${MonthSuffixRegex}|${MonthSuffixRegex}\\s+(${DayRegex}|${WrittenOrdinalDayRegex}))((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const MonthFrontSimpleCasesRegex = `\\b(${RangePrefixRegex}\\s+)?${MonthSuffixRegex}\\s+((from)\\s+)?(${DayRegex}|${WrittenOrdinalDayRegex})\\s*${TillRegex}\\s*(${DayRegex}|${WrittenOrdinalDayRegex})((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const MonthFrontBetweenRegex = `\\b${MonthSuffixRegex}\\s+(between\\s+)(${DayRegex}|${WrittenOrdinalDayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex}|${WrittenOrdinalDayRegex})((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const BetweenRegex = `\\b(between\\s+)(${DayRegex}|${WrittenOrdinalDayRegex})\\s*${RangeConnectorRegex}\\s*(${DayRegex}|${WrittenOrdinalDayRegex})\\s+${MonthSuffixRegex}((\\s+|\\s*,\\s*)${YearRegex})?\\b`;
    export const MonthWithYear = `\\b(((${WrittenMonthRegex}[\\.]?|((the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|sixth|6th|seventh|7th|eighth|8th|ninth|9th|tenth|10th|eleventh|11th|twelfth|12th|last)\\s+month(?=\\s+(of|in))))((\\s*)[/\\\\\\-\\.,]?(\\s+(of|in))?(\\s*)(${YearRegex}|(?<order>following|next|last|this)\\s+year)|\\s+(of|in)\\s+${TwoDigitYearRegex}))|((${YearRegex}|(?<order>following|next|last|this)\\s+year)(\\s*),?(\\s*)${WrittenMonthRegex}))\\b`;
    export const SpecialYearPrefixes = `(calendar|(?<special>fiscal|school))`;
    export const OneWordPeriodRegex = `\\b((((the\\s+)?month of\\s+)?(${StrictRelativeRegex}\\s+)?${MonthRegex})|(month|year) to date|(?<toDate>((un)?till?|to)\\s+date)|(${RelativeRegex}\\s+)?(my\\s+)?((?<business>working\\s+week|workweek)|week(end)?|month|fortnight|((${SpecialYearPrefixes}\\s+)?year))(?!((\\s+of)?\\s+\\d+(?!(${BaseDateTime.BaseAmDescRegex}|${BaseDateTime.BasePmDescRegex}))|\\s+to\\s+date))(\\s+${AfterNextSuffixRegex})?)\\b`;
    export const MonthNumWithYear = `\\b((${BaseDateTime.FourDigitYearRegex}(\\s*)[/\\-\\.](\\s*)${MonthNumRegex})|(${MonthNumRegex}(\\s*)[/\\-](\\s*)${BaseDateTime.FourDigitYearRegex}))\\b`;
    export const WeekOfMonthRegex = `\\b(?<wom>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+week\\s+${MonthSuffixRegex}(\\s+${BaseDateTime.FourDigitYearRegex}|${RelativeRegex}\\s+year)?)\\b`;
    export const WeekOfYearRegex = `\\b(?<woy>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+week(\\s+of)?\\s+(${YearRegex}|${RelativeRegex}\\s+year))\\b`;
    export const OfYearRegex = `\\b((of|in)\\s+(${YearRegex}|${StrictRelativeRegex}\\s+year))\\b`;
    export const FirstLastRegex = `\\b(the\\s+)?((?<first>first)|(?<last>last))\\b`;
    export const FollowedDateUnit = `^\\s*${DateUnitRegex}`;
    export const NumberCombinedWithDateUnit = `\\b(?<num>\\d+(\\.\\d*)?)${DateUnitRegex}`;
    export const QuarterTermRegex = `\\b(((?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)[ -]+quarter)|(q(?<number>[1-4])))\\b`;
    export const RelativeQuarterTermRegex = `\\b(?<orderQuarter>${StrictRelativeRegex})\\s+((?<num>[\\w,]+)\\s+)?quarters?\\b`;
    export const QuarterRegex = `((the\\s+)?${QuarterTermRegex}(?:((\\s+of)?\\s+|\\s*[,-]\\s*)(${YearRegex}|${RelativeRegex}\\s+year))?)|${RelativeQuarterTermRegex}`;
    export const QuarterRegexYearFront = `(?:${YearRegex}|${RelativeRegex}\\s+year)('s)?(?:\\s*-\\s*|\\s+(the\\s+)?)?${QuarterTermRegex}`;
    export const HalfYearTermRegex = `(?<cardinal>first|1st|second|2nd)\\s+half`;
    export const HalfYearFrontRegex = `(?<year>((1[5-9]|20)\\d{2})|2100)(\\s*-\\s*|\\s+(the\\s+)?)?h(?<number>[1-2])`;
    export const HalfYearBackRegex = `(the\\s+)?(h(?<number>[1-2])|(${HalfYearTermRegex}))(\\s+of|\\s*,\\s*)?\\s+(${YearRegex})`;
    export const HalfYearRelativeRegex = `(the\\s+)?${HalfYearTermRegex}(\\s+of|\\s*,\\s*)?\\s+(${RelativeRegex}\\s+year)`;
    export const AllHalfYearRegex = `(${HalfYearFrontRegex})|(${HalfYearBackRegex})|(${HalfYearRelativeRegex})`;
    export const EarlyPrefixRegex = `\\b(?<EarlyPrefix>early|beginning of|start of|(?<RelEarly>earlier(\\s+in)?))\\b`;
    export const MidPrefixRegex = `\\b(?<MidPrefix>mid-?|middle of)\\b`;
    export const LaterPrefixRegex = `\\b(?<LatePrefix>late|end of|(?<RelLate>later(\\s+in)?))\\b`;
    export const PrefixPeriodRegex = `(${EarlyPrefixRegex}|${MidPrefixRegex}|${LaterPrefixRegex})`;
    export const PrefixDayRegex = `\\b((?<EarlyPrefix>earl(y|ier))|(?<MidPrefix>mid(dle)?)|(?<LatePrefix>later?))(\\s+in)?(\\s+the\\s+day)?$`;
    export const SeasonDescRegex = `(?<seas>spring|summer|fall|autumn|winter)`;
    export const SeasonRegex = `\\b(?<season>(${PrefixPeriodRegex}\\s+)?(${RelativeRegex}\\s+)?${SeasonDescRegex}((\\s+of|\\s*,\\s*)?\\s+(${YearRegex}|${RelativeRegex}\\s+year))?)\\b`;
    export const WhichWeekRegex = `\\b(week)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+of\\s+(${YearRegex}|${RelativeRegex}\\s+year))?\\b`;
    export const WeekOfRegex = `(the\\s+)?((week)(\\s+(of|(commencing|starting|beginning)(\\s+on)?))|w/c)(\\s+the)?`;
    export const MonthOfRegex = `(month)(\\s*)(of)`;
    export const DateYearRegex = `(?<year>${BaseDateTime.FourDigitYearRegex}|(?<!,\\s?)${TwoDigitYearRegex}|${TwoDigitYearRegex}(?=(\\.(?!\\d)|[?!;]|$)))`;
    export const YearSuffix = `((,|\\sof)?\\s*(${DateYearRegex}|${FullTextYearRegex}))`;
    export const OnRegex = `(?<=\\bon\\s+)(${DayRegex}s?)\\b`;
    export const RelaxedOnRegex = `(?<=\\b(on|at|in)\\s+)((?<day>(3[0-1]|[0-2]?\\d)(?:th|nd|rd|st))s?)\\b`;
    export const PrefixWeekDayRegex = `(\\s*((,?\\s*on)|[-—–]))`;
    export const ThisRegex = `\\b(this(\\s*week${PrefixWeekDayRegex}?)?\\s*${WeekDayRegex})|(${WeekDayRegex}((\\s+of)?\\s+this\\s*week))\\b`;
    export const LastDateRegex = `\\b(${PreviousPrefixRegex}(\\s*week${PrefixWeekDayRegex}?)?\\s*${WeekDayRegex})|(${WeekDayRegex}(\\s+(of\\s+)?last\\s*week))\\b`;
    export const NextDateRegex = `\\b(${NextPrefixRegex}(\\s*week${PrefixWeekDayRegex}?)?\\s*${WeekDayRegex})|((on\\s+)?${WeekDayRegex}((\\s+of)?\\s+(the\\s+following|(the\\s+)?next)\\s*week))\\b`;
    export const SpecialDayRegex = `\\b((the\\s+)?day before yesterday|(the\\s+)?day after (tomorrow|tmrw?)|the\\s+day\\s+(before|after)(?!=\\s+day)|((the\\s+)?(${RelativeRegex}|my)\\s+day)|yesterday|tomorrow|tmrw?|today|otd|current date)\\b`;
    export const SpecialDayWithNumRegex = `\\b((?<number>${WrittenNumRegex})\\s+days?\\s+from\\s+(?<day>yesterday|tomorrow|tmrw?|today|current date))\\b`;
    export const RelativeDayRegex = `\\b(((the\\s+)?${RelativeRegex}\\s+day))\\b`;
    export const SetWeekDayRegex = `\\b(?<prefix>on\\s+)?(?<weekday>morning|afternoon|evening|night|(sun|mon|tues|wednes|thurs|fri|satur)day)s\\b`;
    export const WeekDayOfMonthRegex = `(?<wom>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+(week\\s+${MonthSuffixRegex}[\\.]?\\s+(on\\s+)?${WeekDayRegex}|${WeekDayRegex}\\s+${MonthSuffixRegex}))`;
    export const RelativeWeekDayRegex = `\\b(${WrittenNumRegex}\\s+${WeekDayRegex}\\s+(from\\s+now|later))\\b`;
    export const SpecialDate = `(?=\\b(on|at)\\s+the\\s+)${DayRegex}\\b`;
    export const DatePreposition = `\\b(on|in)`;
    export const DateExtractorYearTermRegex = `(\\s+|\\s*[/\\\\.,-]\\s*|\\s+of\\s+)${DateYearRegex}`;
    export const DayPrefix = `\\b(${WeekDayRegex}|${SpecialDayRegex})\\b`;
    export const DateExtractor1 = `\\b(${DayPrefix}\\s*[,-]?\\s*)?((${MonthRegex}[\\.]?\\s*[/\\\\.,-]?\\s*${DayRegex})|(\\(${MonthRegex}\\s*[-./]\\s*${DayRegex}\\)))(?!\\s*\\-\\s*\\d{2}\\b)(\\s*\\(\\s*${DayPrefix}\\s*\\))?(${DateExtractorYearTermRegex}\\b)?`;
    export const DateExtractor3 = `\\b(${DayPrefix}(\\s+|\\s*,\\s*))?(${DayRegex}?[\\.]?(\\s+|\\s*[-,/]\\s*|\\s+of\\s+|\\s*)(\\b)?${MonthRegexNoWordBoundary}[\\.]?((\\s+in)?${DateExtractorYearTermRegex})?|${BaseDateTime.FourDigitYearRegex}\\s*[-./]?\\s*(the\\s+)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?)[\\.]?(\\s+|\\s*[-,/]\\s*|\\s+of\\s+)${MonthRegex}[\\.]?)\\b`;
    export const DateExtractor4 = `\\b${MonthNumRegex}\\s*[/\\\\\\-]\\s*${DayRegex}[\\.]?\\s*[/\\\\\\-]\\s*${DateYearRegex}`;
    export const DateExtractor5 = `\\b(${DayPrefix}(\\s*,)?\\s+)?${DayRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)`;
    export const DateExtractor6 = `(?<=${DatePreposition}\\s+)(${StrictRelativeRegex}\\s+)?(${DayPrefix}\\s+)?${MonthNumRegex}[\\-\\.]${DayRegex}(?![%])${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor7L = `\\b(${DayPrefix}(\\s*,)?\\s+)?${MonthNumRegex}\\s*/\\s*${DayRegex}${DateExtractorYearTermRegex}(?![%])\\b`;
    export const DateExtractor7S = `\\b(${DayPrefix}(\\s*,)?\\s+)?${MonthNumRegex}\\s*/\\s*${DayRegex}(?![%])${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor8 = `(?<=${DatePreposition}\\s+)(${StrictRelativeRegex}\\s+)?(${DayPrefix}\\s+)?${DayRegex}[\\\\\\-]${MonthNumRegex}(?![%])${BaseDateTime.CheckDecimalRegex}\\b`;
    export const DateExtractor9L = `\\b(${DayPrefix}(\\s*,)?\\s+)?${DayRegex}\\s*/\\s*${MonthNumRegex}${DateExtractorYearTermRegex}(?![%])\\b`;
    export const DateExtractor9S = `\\b(${DayPrefix}(\\s*,)?\\s+)?${DayRegex}\\s*/\\s*${MonthNumRegex}${BaseDateTime.CheckDecimalRegex}(?![%])\\b`;
    export const DateExtractorNoSep = `\\b((?<![$])(?<year>((1\\d|20)\\d{2})|2100)(\\s+(?<month>1[0-2]|(0)?[1-9])\\s+(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))|(?<month>1[0-2]|(0)?[1-9])(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])))\\b)`;
    export const DateExtractorA = `\\b(${DayPrefix}(\\s*,)?\\s+)?((${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*(${MonthNumRegex}|${MonthRegex})\\s*[/\\\\\\-\\.]\\s*${DayRegex})|(${MonthRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*(the\\s+)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?))|(${DayRegex}\\s*[/\\\\\\-\\.]\\s*${BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*${MonthRegex})|${DateExtractorNoSep})`;
    export const OfMonth = `^(\\s*(day\\s+)?of)?\\s*${MonthRegex}`;
    export const MonthEnd = `${MonthRegex}\\s*(the)?\\s*$`;
    export const WeekDayEnd = `(this\\s+)?${WeekDayRegex}\\s*,?\\s*$`;
    export const WeekDayStart = `^\\s+(on\\s+)?${WeekDayRegex}\\b`;
    export const RangeUnitRegex = `\\b(?<unit>years?|months?|weeks?|fortnights?)\\b`;
    export const HourNumRegex = `\\b(?<hournum>zero|one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve)\\b`;
    export const MinuteNumRegex = `(((?<tens>twenty|thirty|fou?rty|fifty)(\\s*-?\\s*))?(?<minnum>one|two|three|four|five|six|seven|eight|nine)|(?<minnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))`;
    export const DeltaMinuteNumRegex = `(((?<tens>twenty|thirty|fou?rty|fifty)(\\s*-?\\s*))?(?<deltaminnum>one|two|three|four|five|six|seven|eight|nine)|(?<deltaminnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))`;
    export const PmRegex = `(?<pm>(((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?(((early|late)\\s+)?(afternoon|evening)|midnight|lunchtime))|((at|in|around|on|for)\\s+(the\\s+)?night))`;
    export const PmRegexFull = `(?<pm>((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?(((early|late)\\s+)?(afternoon|evening)|(mid)?night|lunchtime))`;
    export const AmRegex = `(?<am>((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?((early|late)\\s+)?(morning))`;
    export const LunchRegex = `\\blunchtime\\b`;
    export const NightRegex = `\\b(mid)?night\\b`;
    export const CommonDatePrefixRegex = `^[\\.]`;
    export const LessThanOneHour = `(?<lth>(a\\s+)?quarter|three quarter(s)?|half( an hour)?|${BaseDateTime.DeltaMinuteRegex}(\\s+(minutes?|mins?)|(?=\\s+past))|${DeltaMinuteNumRegex}(\\s+(minutes?|mins?)|(?=\\s+past)))`;
    export const WrittenTimeRegex = `(?<writtentime>${HourNumRegex}\\s+${MinuteNumRegex}(\\s+(minutes?|mins?))?)`;
    export const TimePrefix = `(?<prefix>${LessThanOneHour}\\s+(past|to))`;
    export const TimeSuffix = `(?<suffix>${AmRegex}|${PmRegex}|${OclockRegex})`;
    export const TimeSuffixFull = `(?<suffix>${AmRegex}|${PmRegexFull}|${OclockRegex})`;
    export const BasicTime = `\\b(?<basictime>${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}:${BaseDateTime.MinuteRegex}(:${BaseDateTime.SecondRegex})?|${BaseDateTime.HourRegex}(?![%\\d]))`;
    export const MidnightRegex = `(?<midnight>mid\\s*(-\\s*)?night)`;
    export const MidmorningRegex = `(?<midmorning>mid\\s*(-\\s*)?morning)`;
    export const MidafternoonRegex = `(?<midafternoon>mid\\s*(-\\s*)?afternoon)`;
    export const MiddayRegex = `(?<midday>mid\\s*(-\\s*)?day|((12\\s)?noon))`;
    export const MidTimeRegex = `(?<mid>(${MidnightRegex}|${MidmorningRegex}|${MidafternoonRegex}|${MiddayRegex}))`;
    export const AtRegex = `\\b(?:(?:(?<=\\b(at|(at)?\\s*around|circa)\\s+)(?:${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}(?!\\.\\d)(\\s*((?<iam>a)|(?<ipm>p)))?|${MidTimeRegex}))|${MidTimeRegex})\\b`;
    export const IshRegex = `\\b(${BaseDateTime.HourRegex}(-|——)?ish|noon(ish)?)\\b`;
    export const TimeUnitRegex = `([^a-z]{1,}|\\b)(?<unit>(h(ou)?r|min(ute)?|sec(ond)?)(?<plural>s)?|h)\\b`;
    export const RestrictedTimeUnitRegex = `(?<unit>hour|minute)\\b`;
    export const FivesRegex = `(?<tens>(?:fifteen|(?:twen|thir|fou?r|fif)ty(\\s*five)?|ten|five))\\b`;
    export const HourRegex = `\\b${BaseDateTime.HourRegex}`;
    export const PeriodHourNumRegex = `\\b(?<hour>twenty(\\s+(one|two|three|four))?|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|zero|one|two|three|five|eight|ten)\\b`;
    export const ConnectNumRegex = `\\b${BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*${DescRegex}`;
    export const TimeRegexWithDotConnector = `(${BaseDateTime.HourRegex}(\\s*\\.\\s*)${BaseDateTime.MinuteRegex})`;
    export const TimeRegex1 = `\\b(${TimePrefix}\\s+)?(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex})(\\s*|[.])${DescRegex}`;
    export const TimeRegex2 = `(\\b${TimePrefix}\\s+)?(t)?${BaseDateTime.HourRegex}(\\s*)?:(\\s*)?${BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?${BaseDateTime.SecondRegex})?(?<iam>a)?((\\s*${DescRegex})|\\b)`;
    export const TimeRegex3 = `(\\b${TimePrefix}\\s+)?${BaseDateTime.HourRegex}\\.${BaseDateTime.MinuteRegex}(\\s*${DescRegex})`;
    export const TimeRegex4 = `\\b${TimePrefix}\\s+${BasicTime}(\\s*${DescRegex})?\\s+${TimeSuffix}\\b`;
    export const TimeRegex5 = `\\b${TimePrefix}\\s+${BasicTime}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex6 = `(${BasicTime})(\\s*${DescRegex})?\\s+${TimeSuffix}\\b`;
    export const TimeRegex7 = `\\b${TimeSuffixFull}\\s+(at\\s+)?${BasicTime}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex8 = `.^`;
    export const TimeRegex9 = `\\b${PeriodHourNumRegex}(\\s+|-)${FivesRegex}((\\s*${DescRegex})|\\b)`;
    export const TimeRegex10 = `\\b(${TimePrefix}\\s+)?${BaseDateTime.HourRegex}(\\s*h\\s*)${BaseDateTime.MinuteRegex}(\\s*${DescRegex})?`;
    export const TimeRegex11 = `\\b((?:(${TimeTokenPrefix})?${TimeRegexWithDotConnector}(\\s*${DescRegex}))|(?:(?:${TimeTokenPrefix}${TimeRegexWithDotConnector})(?!\\s*per\\s*cent|%)))`;
    export const FirstTimeRegexInTimeRange = `\\b${TimeRegexWithDotConnector}(\\s*${DescRegex})?`;
    export const PureNumFromTo = `(${RangePrefixRegex}\\s+)?(${HourRegex}|${PeriodHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?\\s*${TillRegex}\\s*(${HourRegex}|${PeriodHourNumRegex})(?<rightDesc>\\s*(${PmRegex}|${AmRegex}|${DescRegex}))?`;
    export const PureNumBetweenAnd = `(between\\s+)((${BaseDateTime.TwoDigitHourRegex}${BaseDateTime.TwoDigitMinuteRegex})|${HourRegex}|${PeriodHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?\\s*${RangeConnectorRegex}\\s*((${BaseDateTime.TwoDigitHourRegex}${BaseDateTime.TwoDigitMinuteRegex})|${HourRegex}|${PeriodHourNumRegex})(?<rightDesc>\\s*(${PmRegex}|${AmRegex}|${DescRegex}))?`;
    export const SpecificTimeFromTo = `(${RangePrefixRegex}\\s+)?(?<time1>((${TimeRegex2}|${FirstTimeRegexInTimeRange})|(${HourRegex}|${PeriodHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?))\\s*${TillRegex}\\s*(?<time2>((${TimeRegex2}|${TimeRegexWithDotConnector}(?<rightDesc>\\s*${DescRegex}))|(${HourRegex}|${PeriodHourNumRegex})(\\s*(?<rightDesc>${DescRegex}))?))`;
    export const SpecificTimeBetweenAnd = `(between\\s+)(?<time1>((${TimeRegex2}|${FirstTimeRegexInTimeRange})|(${HourRegex}|${PeriodHourNumRegex})(\\s*(?<leftDesc>${DescRegex}))?))\\s*${RangeConnectorRegex}\\s*(?<time2>((${TimeRegex2}|${TimeRegexWithDotConnector}(?<rightDesc>\\s*${DescRegex}))|(${HourRegex}|${PeriodHourNumRegex})(\\s*(?<rightDesc>${DescRegex}))?))`;
    export const SuffixAfterRegex = `\\b(((at)\\s)?(or|and)\\s+(above|after|later|greater)(?!\\s+than))\\b`;
    export const PrepositionRegex = `(?<prep>^(,\\s*)?(at|on|of)(\\s+the)?$)`;
    export const LaterEarlyRegex = `((?<early>earl(y|ier)(\\s+|-))|(?<late>late(r?\\s+|-)))`;
    export const MealTimeRegex = `\\b(at\\s+)?(?<mealTime>breakfast|brunch|lunch(\\s*time)?|dinner(\\s*time)?|supper)\\b`;
    export const UnspecificTimePeriodRegex = `(${MealTimeRegex})`;
    export const TimeOfDayRegex = `\\b(?<timeOfDay>((((in\\s+the\\s+)${LaterEarlyRegex}?(morning|afternoon|night(-?time)?|evening)s)|((in\\s+the\\s+)?${LaterEarlyRegex}?(in(\\s+the)?\\s+)?(morning|afternoon|night(-?time)?|evening)))|${MealTimeRegex}|(((in\\s+(the)?\\s+)?)(daytime|business\\s+hours?))))\\b`;
    export const SpecificTimeOfDayRegex = `\\b((${StrictRelativeRegex}\\s+${TimeOfDayRegex})\\b|\\b(?<pm>toni(ght|te)))s?\\b`;
    export const TimeFollowedUnit = `^\\s*${TimeUnitRegex}`;
    export const TimeNumberCombinedWithUnit = `\\b(?<num>\\d+(\\.\\d*)?)${TimeUnitRegex}`;
    export const BusinessHourSplitStrings = [ "business","hour" ];
    export const NowRegex = `\\b(?<now>(right\\s+)?now|as\\s+soon\\s+as\\s+possible|asap|recently|previously|at\\s+(present|this\\s+time|th(e|is)\\s+minute|the\\s+(moment|present\\s+time)))\\b`;
    export const NowParseRegex = `\\b(${NowRegex}|^(date)$)\\b`;
    export const SuffixRegex = `^\\s*(in the\\s+)?(morning|afternoon|evening|night)\\b`;
    export const NonTimeContextTokens = `(building)`;
    export const DateTimeTimeOfDayRegex = `\\b(?<timeOfDay>morning|(?<pm>afternoon|night|evening))\\b`;
    export const DateTimeSpecificTimeOfDayRegex = `\\b((${RelativeRegex}\\s+${DateTimeTimeOfDayRegex})\\b|\\btoni(ght|te))\\b`;
    export const TimeOfTodayAfterRegex = `^\\s*(,\\s*)?(in\\s+)?${DateTimeSpecificTimeOfDayRegex}`;
    export const TimeOfTodayBeforeRegex = `${DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(at|around|circa|in|on))?\\s*$`;
    export const SimpleTimeOfTodayAfterRegex = `(?<!${NonTimeContextTokens}\\s*)\\b(${HourNumRegex}|${BaseDateTime.HourRegex})\\s*(,\\s*)?(in\\s+)?${DateTimeSpecificTimeOfDayRegex}\\b`;
    export const SimpleTimeOfTodayBeforeRegex = `\\b${DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(at|around|circa))?\\s*(${HourNumRegex}|${BaseDateTime.HourRegex})\\b`;
    export const SpecificEndOfRegex = `(the\\s+)?end of(\\s+the)?\\s*$`;
    export const UnspecificEndOfRegex = `\\b(the\\s+)?(eod|(end\\s+of\\s+day))\\b`;
    export const UnspecificEndOfRangeRegex = `\\b(eoy)\\b`;
    export const PeriodTimeOfDayRegex = `\\b((in\\s+(the\\s+)?)?${LaterEarlyRegex}?((this\\s+)?${DateTimeTimeOfDayRegex}|(?<timeOfDay>(?<pm>tonight))))\\b`;
    export const PeriodSpecificTimeOfDayRegex = `\\b(${LaterEarlyRegex}?this\\s+${DateTimeTimeOfDayRegex}|(${StrictRelativeRegex}\\s+${PeriodTimeOfDayRegex})\\b|\\b(?<pm>toni(ght|te)))\\b`;
    export const PeriodTimeOfDayWithDateRegex = `\\b((${PeriodTimeOfDayRegex}(\\s+(on|of))?))\\b`;
    export const TasksmodeMealTimeofDayRegex = `\\b((in\\s+(the)?\\s+)?((?<early>earl(y|ier)(\\s+|-))|(?<late>late(r?\\s+|-)))?((this\\s+)?\\b(?<timeOfDay>lunch(\\s*time)?|dinner(\\s*time)?|brunch|breakfast)\\b))\\b`;
    export const LessThanRegex = `\\b(less\\s+than)\\b`;
    export const MoreThanRegex = `\\b(more\\s+than)\\b`;
    export const DurationUnitRegex = `(?<unit>${DateUnitRegex}|h(ou)?rs?|h|min(ute)?s?|sec(ond)?s?|nights?)\\b`;
    export const SuffixAndRegex = `(?<suffix>\\s*(and)\\s+(an?\\s+)?(?<suffix_num>half|quarter))`;
    export const PeriodicRegex = `\\b(?<periodic>((?<multiplier>semi|bi|tri)(\\s*|-))?(daily|monthly|weekly|quarterly|yearly|annual(ly)?))\\b`;
    export const EachUnitRegex = `\\b(?<each>(every|(each|any|once an|one a|once a)\\s?)(?<other>\\s+(other|alternate|second))?\\s*(${DurationUnitRegex}|(?<specialUnit>quarters?|weekends?)|${WeekDayRegex})|(?<specialUnit>weekends))`;
    export const EachPrefixRegex = `\\b(?<each>(each|every|once an?)\\s*$)`;
    export const SetEachRegex = `\\b(?<each>(each|every)(?<other>\\s+(other|alternate))?\\s*)(?!the|that)\\b`;
    export const SetLastRegex = `(?<last>following|next|upcoming|this|${LastNegPrefix}last|past|previous|current)`;
    export const EachDayRegex = `^\\s*(each|every)\\s*day\\b`;
    export const DurationFollowedUnit = `(^\\s*${DurationUnitRegex}\\s+${SuffixAndRegex})|(^\\s*${SuffixAndRegex}?(\\s+|-)?${DurationUnitRegex})`;
    export const NumberCombinedWithDurationUnit = `\\b(?<num>\\d+(\\.\\d*)?)(-)?${DurationUnitRegex}`;
    export const AnUnitRegex = `(\\b((?<half>(half)\\s+)?an?|another)|(?<half>(1/2|½|half)))\\s+${DurationUnitRegex}`;
    export const DuringRegex = `\\b(for|during)\\s+the\\s+(?<unit>year|month|week|day|fortnight)\\b`;
    export const AllRegex = `\\b(?<all>(all|full|whole)(\\s+|-)(?<unit>year|month|week|day|fortnight))\\b`;
    export const HalfRegex = `((an?\\s*)|\\b)(?<half>half\\s+(?<unit>year|month|week|fortnight|day|hour))\\b`;
    export const ConjunctionRegex = `\\b((and(\\s+for)?)|with)\\b`;
    export const HolidayList1 = `(?<holiday>mardi gras|(washington|mao)'s birthday|juneteenth|(jubilee|freedom)(\\s+day)|chinese new year|(new\\s+(years'|year\\s*'s|years?)\\s+eve)|(new\\s+(years'|year\\s*'s|years?)(\\s+day)?)|may\\s*day|yuan dan|christmas eve|(christmas|xmas)(\\s+day)?|black friday|yuandan|easter(\\s+(sunday|saturday|monday))?|clean monday|ash wednesday|palm sunday|maundy thursday|good friday|white\\s+(sunday|monday)|trinity sunday|pentecost|corpus christi|cyber monday)`;
    export const HolidayList2 = `(?<holiday>(thanks\\s*giving|all saint's|white lover|s(?:ain)?t?(\\.)?\\s+(?:patrick|george)(?:')?(?:s)?|us independence|all hallow|all souls|guy fawkes|cinco de mayo|halloween|qingming|dragon boat|april fools|tomb\\s*sweeping)(\\s+day)?)`;
    export const HolidayList3 = `(?<holiday>(?:independence|presidents(?:')?|mlk|martin luther king( jr)?|canberra|ascension|columbus|tree( planting)?|arbor|labou?r|((international|int'?l)\\s+)?workers'?|mother'?s?|father'?s?|female|women('s)?|single|teacher'?s|youth|children|girls|lovers?|earth|inauguration|groundhog|valentine'?s|baptiste|bastille|veterans(?:')?|memorial|mid[ \\-]autumn|moon|spring|lantern)\\s+day)`;
    export const HolidayList4 = `(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\\s+)adha|eid al(-|\\s+)azha|eidul(-|\\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\\s+)fitr|festival of breaking the fast)`;
    export const HolidayRegex = `\\b((${StrictRelativeRegex}\\s+(${HolidayList1}|${HolidayList2}|${HolidayList3}|${HolidayList4}))|(?<holidayWeekend>((the\\s+)?weekend\\s+of\\s+)(${HolidayList1}|${HolidayList2}|${HolidayList3}|${HolidayList4})(\\s+((of\\s+)?(${YearRegex}|${RelativeRegex}\\s+year)))?)|((${HolidayList1}|${HolidayList2}|${HolidayList3}|${HolidayList4})((?<holidayWeekend>(\\s+weekend)(\\s+((of\\s+)?(${YearRegex}|${RelativeRegex}\\s+year)))?)|(\\s+(of\\s+)?(${YearRegex}|${RelativeRegex}\\s+year)(?<holidayWeekend>\\s+weekend)?))?))\\b`;
    export const TasksModeHolidayListSupression = `(?<holiday>(?:independence|teacher'?s|youth|children|girls)\\s+day)|(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\\s+)adha|eid al(-|\\s+)azha|eidul(-|\\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\\s+)fitr|festival of breaking the fast)\\b`;
    export const AMTimeRegex = `(?<am>morning)`;
    export const PMTimeRegex = `\\b(?<pm>afternoon|evening|night)\\b`;
    export const NightTimeRegex = `(night)`;
    export const NowTimeRegex = `(now|at\\s+(present|this\\s+time|th(e|is)\\s+minute|the\\s+(moment|(current|present)\\s+time)))`;
    export const RecentlyTimeRegex = `(recently|previously)`;
    export const AsapTimeRegex = `(as soon as possible|asap)`;
    export const InclusiveModPrepositions = `(?<include>((on|in|at)\\s+or\\s+)|(\\s+or\\s+(on|in|at)))`;
    export const AroundRegex = `(?:\\b(?:around|circa)\\s*?\\b)(\\s+the)?`;
    export const BeforeRegex = `((\\b${InclusiveModPrepositions}?(?:before|in\\s+advance\\s+of|prior\\s+to|(no\\s+later|earlier|sooner)\\s+than|ending\\s+(with|on)|by|(un)?till?|(?<include>as\\s+late\\s+as))${InclusiveModPrepositions}?\\b\\s*?)|(?<!\\w|>)((?<include><\\s*=)|<))(\\s+the)?`;
    export const AfterRegex = `((\\b${InclusiveModPrepositions}?((after(\\s+on)?(?!\\sfrom)|(?<!no\\s+)later\\s+than)|((year\\s+)?greater\\s+than))(?!\\s+or\\s+equal\\s+to)${InclusiveModPrepositions}?\\b\\s*?)|(?<!\\w|<)((?<include>>\\s*=)|>))(\\s+the)?`;
    export const SinceRegex = `(?:(?:\\b(?:since|after\\s+or\\s+equal\\s+to|(starting|beginning)(\\s)?(?:from|on|with)?|as\\s+early\\s+as|(any\\s+time\\s+)from)\\b\\s*?)|(?<!\\w|<)(>=))(\\s+the)?`;
    export const SinceRegexExp = `(${SinceRegex}|\\bfrom(\\s+the)?\\b)`;
    export const AgoRegex = `\\b(ago|earlier|before\\s+(?<day>yesterday|today))\\b`;
    export const LaterRegex = `\\b(?:later(?!((\\s+in)?\\s*${OneWordPeriodRegex})|(\\s+${TimeOfDayRegex})|\\s+than\\b)|from now|(from|after)\\s+(?<day>tomorrow|tmrw?|today))\\b`;
    export const BeforeAfterRegex = `\\b((?<before>before)|(?<after>from|after))\\b`;
    export const ModPrefixRegex = `\\b(${RelativeRegex}|${AroundRegex}|${BeforeRegex}|${AfterRegex}|${SinceRegex})\\b`;
    export const ModSuffixRegex = `\\b(${AgoRegex}|${LaterRegex}|${BeforeAfterRegex}|${FutureSuffixRegex}|${PastSuffixRegex})\\b`;
    export const InConnectorRegex = `\\b(in)\\b`;
    export const SinceYearSuffixRegex = `(^\\s*${SinceRegex}(\\s*(the\\s+)?year\\s*)?${YearSuffix})`;
    export const WithinNextPrefixRegex = `\\b(within(\\s+the)?(\\s+(?<next>${NextPrefixRegex}))?)\\b`;
    export const TodayNowRegex = `\\b(today|now|current (date|time))\\b`;
    export const MorningStartEndRegex = `(^(morning|${AmDescRegex}))|((morning|${AmDescRegex})$)`;
    export const AfternoonStartEndRegex = `(^(afternoon|${PmDescRegex}))|((afternoon|${PmDescRegex})$)`;
    export const EveningStartEndRegex = `(^(evening))|((evening)$)`;
    export const NightStartEndRegex = `(^(over|to)?ni(ght|te))|((over|to)?ni(ght|te)$)`;
    export const InexactNumberRegex = `\\b((a\\s+)?few|some|several|(?<NumTwoTerm>(a\\s+)?couple(\\s+of)?))\\b`;
    export const InexactNumberUnitRegex = `(${InexactNumberRegex})\\s+(${DurationUnitRegex})`;
    export const RelativeTimeUnitRegex = `(?:(?:(?:${NextPrefixRegex}|${PreviousPrefixRegex}|${ThisPrefixRegex})\\s+(${TimeUnitRegex}))|((the|my))\\s+(${RestrictedTimeUnitRegex}))`;
    export const RelativeDurationUnitRegex = `(?:(?:(?<=(${NextPrefixRegex}|${PreviousPrefixRegex}|${ThisPrefixRegex})\\s+)(${DurationUnitRegex}))|((the|my))\\s+(${RestrictedTimeUnitRegex}))`;
    export const ReferenceDatePeriodRegex = `\\b${ReferencePrefixRegex}\\s+(?<duration>week(end)?|fortnight|month|year|decade)\\b`;
    export const ConnectorRegex = `^(-|,|for|t|around|circa|@)$`;
    export const FromToRegex = `(\\b(from).+(to|and|or)\\b.+)`;
    export const SingleAmbiguousMonthRegex = `^(the\\s+)?(may|march)$`;
    export const SingleAmbiguousTermsRegex = `^(the\\s+)?(day|week|month|year)$`;
    export const UnspecificDatePeriodRegex = `^(week|fortnight|month|year)$`;
    export const PrepositionSuffixRegex = `\\b(on|in|at|around|circa|from|to)$`;
    export const FlexibleDayRegex = `(?<DayOfMonth>([A-Za-z]+\\s)?[A-Za-z\\d]+)`;
    export const ForTheRegex = `\\b((((?<=\\bfor\\s+)the\\s+${FlexibleDayRegex})|((?<=\\bon\\s+)(the\\s+)?${FlexibleDayRegex}(?<=(st|nd|rd|th))))(?<end>\\s*(,|\\.(?!\\d)|!|\\?|$)))`;
    export const WeekDayAndDayOfMonthRegex = `\\b${WeekDayRegex}\\s+(the\\s+${FlexibleDayRegex})\\b`;
    export const WeekDayAndDayRegex = `\\b${WeekDayRegex}\\s+(?!(the))${DayRegex}(?!([-:]|(\\s+(${AmDescRegex}|${PmDescRegex}|${OclockRegex}))))\\b`;
    export const RestOfDateRegex = `\\b(rest|remaining)\\s+(of\\s+)?((the|my|this|current)\\s+)?(?<duration>week|fortnight|month|year|decade)\\b`;
    export const RestOfDateTimeRegex = `\\b(rest|remaining)\\s+(of\\s+)?((the|my|this|current)\\s+)?(?<unit>day)\\b`;
    export const AmbiguousRangeModifierPrefix = `(from)`;
    export const NumberEndingPattern = `^(?:\\s+(?<meeting>meeting|appointment|conference|((skype|teams|zoom|facetime)\\s+)?call)\\s+to\\s+(?<newTime>${PeriodHourNumRegex}|${HourRegex})([\\.]?$|(\\.,|,|!|\\?)))`;
    export const OneOnOneRegex = `\\b(1\\s*:\\s*1(?!\\d))|(one (on )?one|one\\s*-\\s*one|one\\s*:\\s*one)\\b`;
    export const LaterEarlyPeriodRegex = `\\b((${PrefixPeriodRegex})\\s*\\b\\s*(?<suffix>${OneWordPeriodRegex}|(?<FourDigitYear>${BaseDateTime.FourDigitYearRegex}))|(${UnspecificEndOfRangeRegex}))\\b`;
    export const WeekWithWeekDayRangeRegex = `\\b((?<week>(${NextPrefixRegex}|${PreviousPrefixRegex}|this)\\s+week)((\\s+between\\s+${WeekDayRegex}\\s+and\\s+${WeekDayRegex})|(\\s+from\\s+${WeekDayRegex}\\s+to\\s+${WeekDayRegex})))\\b`;
    export const GeneralEndingRegex = `^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$`;
    export const MiddlePauseRegex = `\\s*(,)\\s*`;
    export const DurationConnectorRegex = `^\\s*(?<connector>\\s+|and|,)\\s*$`;
    export const PrefixArticleRegex = `\\bthe\\s+`;
    export const OrRegex = `\\s*((\\b|,\\s*)(or|and)\\b|,)\\s*`;
    export const SpecialYearTermsRegex = `\\b(((${SpecialYearPrefixes}\\s+)?year)|(cy|(?<special>fy|sy)))`;
    export const YearPlusNumberRegex = `\\b(${SpecialYearTermsRegex}\\s*((?<year>(\\d{2,4}))|${FullTextYearRegex}))\\b`;
    export const NumberAsTimeRegex = `\\b(${WrittenTimeRegex}|${PeriodHourNumRegex}|${BaseDateTime.HourRegex})\\b`;
    export const TimeBeforeAfterRegex = `\\b(((?<=\\b(before|no later than|by|after)\\s+)(${WrittenTimeRegex}|${HourNumRegex}|${BaseDateTime.HourRegex}|${MidTimeRegex}))|${MidTimeRegex})\\b`;
    export const DateNumberConnectorRegex = `^\\s*(?<connector>\\s+at)\\s*$`;
    export const DecadeRegex = `(?<decade>(?:nough|twen|thir|fou?r|fif|six|seven|eigh|nine)ties|two\\s+thousands)`;
    export const DecadeWithCenturyRegex = `(the\\s+)?(((?<century>\\d|1\\d|2\\d)?(')?(?<decade>\\d0)(')?(\\s)?s\\b)|((${CenturyRegex}(\\s+|-)(and\\s+)?)?${DecadeRegex})|(${CenturyRegex}(\\s+|-)(and\\s+)?(?<decade>tens|hundreds)))`;
    export const RelativeDecadeRegex = `\\b((the\\s+)?${RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?decades?)\\b`;
    export const YearPeriodRegex = `((((from|during|in)\\s+)?${YearRegex}\\s*(${TillRegex})\\s*${YearRegex})|(((between)\\s+)${YearRegex}\\s*(${RangeConnectorRegex})\\s*${YearRegex}))`;
    export const StrictTillRegex = `(?<till>\\b(to|(un)?till?|thru|through)\\b|${BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*(h[1-2]|q[1-4])(?!(\\s+of|\\s*,\\s*))))`;
    export const StrictRangeConnectorRegex = `(?<and>\\b(and|through|to)\\b|${BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*(h[1-2]|q[1-4])(?!(\\s+of|\\s*,\\s*))))`;
    export const StartMiddleEndRegex = `\\b((?<StartOf>((the\\s+)?(start|beginning)\\s+of\\s+)?)(?<MiddleOf>((the\\s+)?middle\\s+of\\s+)?)(?<EndOf>((the\\s+)?end\\s+of\\s+)?))`;
    export const ComplexDatePeriodRegex = `(?:((from|during|in)\\s+)?${StartMiddleEndRegex}(?<start>.+)\\s*(${StrictTillRegex})\\s*${StartMiddleEndRegex}(?<end>.+)|((between)\\s+)${StartMiddleEndRegex}(?<start>.+)\\s*(${StrictRangeConnectorRegex})\\s*${StartMiddleEndRegex}(?<end>.+))`;
    export const FailFastRegex = `${BaseDateTime.DeltaMinuteRegex}|\\b(?:${BaseDateTime.BaseAmDescRegex}|${BaseDateTime.BasePmDescRegex})|${BaseDateTime.BaseAmPmDescRegex}|\\b(?:zero|${WrittenOneToNineRegex}|${WrittenElevenToNineteenRegex}|${WrittenTensRegex}|${WrittenMonthRegex}|${SeasonDescRegex}|${DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\\d(-|——)?ish|((the\\s+\\w*)|\\d)(th|rd|nd|st)|(mid\\s*(-\\s*)?)?(night|morning|afternoon|day)s?|evenings?|noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|minutes?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\\b|${WeekDayRegex}|${SetWeekDayRegex}|${NowRegex}|${PeriodicRegex}|\\b(${DateUnitRegex}|${ImplicitDayRegex})`;
    export const TasksModeSupressionRegexes = `(${AmPmDescRegex}|${TasksModeSpecialDescRegex}|${TasksModeHolidayListSupression}|${DecadeRegex}|${DecadeWithCenturyRegex}|${QuarterRegex}|${QuarterRegexYearFront}|${AllHalfYearRegex}|${SeasonRegex})`;
    export const TasksModeNextPrefix = `(?<next>next\\s+)`;
    export const TasksModeDurationToDatePatterns = `\\b(${TasksModeNextPrefix}((?<week>week)|(?<month>month)|(?<year>year)))\\b`;
    export const UnitMap: ReadonlyMap<string, string> = new Map<string, string>([["decades", "10Y"],["decade", "10Y"],["years", "Y"],["year", "Y"],["y", "Y"],["months", "MON"],["month", "MON"],["m", "M"],["quarters", "3MON"],["quarter", "3MON"],["semesters", "6MON"],["semestres", "6MON"],["semester", "6MON"],["semestre", "6MON"],["weeks", "W"],["week", "W"],["w", "W"],["weekends", "WE"],["weekend", "WE"],["fortnights", "2W"],["fortnight", "2W"],["weekdays", "D"],["weekday", "D"],["days", "D"],["day", "D"],["d", "D"],["nights", "D"],["night", "D"],["hours", "H"],["hour", "H"],["hrs", "H"],["hr", "H"],["h", "H"],["minutes", "M"],["minute", "M"],["mins", "M"],["min", "M"],["seconds", "S"],["second", "S"],["secs", "S"],["sec", "S"]]);
    export const UnitValueMap: ReadonlyMap<string, number> = new Map<string, number>([["decades", 315360000],["decade", 315360000],["years", 31536000],["year", 31536000],["y", 31536000],["months", 2592000],["month", 2592000],["m", 2592000],["fortnights", 1209600],["fortnight", 1209600],["weekends", 172800],["weekend", 172800],["weeks", 604800],["week", 604800],["w", 604800],["days", 86400],["day", 86400],["d", 86400],["nights", 86400],["night", 86400],["hours", 3600],["hour", 3600],["hrs", 3600],["hr", 3600],["h", 3600],["minutes", 60],["minute", 60],["mins", 60],["min", 60],["seconds", 1],["second", 1],["secs", 1],["sec", 1]]);
    export const SpecialYearPrefixesMap: ReadonlyMap<string, string> = new Map<string, string>([["fiscal", "FY"],["school", "SY"],["fy", "FY"],["sy", "SY"]]);
    export const SeasonMap: ReadonlyMap<string, string> = new Map<string, string>([["spring", "SP"],["summer", "SU"],["fall", "FA"],["autumn", "FA"],["winter", "WI"]]);
    export const SeasonValueMap: ReadonlyMap<string, number> = new Map<string, number>([["SP", 3],["SU", 6],["FA", 9],["WI", 12]]);
    export const CardinalMap: ReadonlyMap<string, number> = new Map<string, number>([["first", 1],["1st", 1],["second", 2],["2nd", 2],["third", 3],["3rd", 3],["fourth", 4],["4th", 4],["fifth", 5],["5th", 5],["sixth", 6],["6th", 6],["seventh", 7],["7th", 7],["eighth", 8],["8th", 8],["ninth", 9],["9th", 9],["tenth", 10],["10th", 10],["eleventh", 11],["11th", 11],["twelfth", 12],["12th", 12]]);
    export const DayOfWeek: ReadonlyMap<string, number> = new Map<string, number>([["monday", 1],["tuesday", 2],["wednesday", 3],["thursday", 4],["friday", 5],["saturday", 6],["sunday", 0],["mon", 1],["tue", 2],["tues", 2],["wed", 3],["wedn", 3],["weds", 3],["thu", 4],["thur", 4],["thurs", 4],["fri", 5],["sat", 6],["sun", 0]]);
    export const MonthOfYear: ReadonlyMap<string, number> = new Map<string, number>([["1", 1],["2", 2],["3", 3],["4", 4],["5", 5],["6", 6],["7", 7],["8", 8],["9", 9],["10", 10],["11", 11],["12", 12],["january", 1],["february", 2],["march", 3],["april", 4],["may", 5],["june", 6],["july", 7],["august", 8],["september", 9],["october", 10],["november", 11],["december", 12],["jan", 1],["feb", 2],["mar", 3],["apr", 4],["jun", 6],["jul", 7],["aug", 8],["sep", 9],["sept", 9],["oct", 10],["nov", 11],["dec", 12],["01", 1],["02", 2],["03", 3],["04", 4],["05", 5],["06", 6],["07", 7],["08", 8],["09", 9]]);
    export const Numbers: ReadonlyMap<string, number> = new Map<string, number>([["zero", 0],["one", 1],["a", 1],["an", 1],["two", 2],["three", 3],["four", 4],["five", 5],["six", 6],["seven", 7],["eight", 8],["nine", 9],["ten", 10],["eleven", 11],["twelve", 12],["thirteen", 13],["fourteen", 14],["fifteen", 15],["sixteen", 16],["seventeen", 17],["eighteen", 18],["nineteen", 19],["twenty", 20],["twenty one", 21],["twenty two", 22],["twenty three", 23],["twenty four", 24],["twenty five", 25],["twenty six", 26],["twenty seven", 27],["twenty eight", 28],["twenty nine", 29],["thirty", 30],["thirty one", 31],["thirty two", 32],["thirty three", 33],["thirty four", 34],["thirty five", 35],["thirty six", 36],["thirty seven", 37],["thirty eight", 38],["thirty nine", 39],["forty", 40],["forty one", 41],["forty two", 42],["forty three", 43],["forty four", 44],["forty five", 45],["forty six", 46],["forty seven", 47],["forty eight", 48],["forty nine", 49],["fifty", 50],["fifty one", 51],["fifty two", 52],["fifty three", 53],["fifty four", 54],["fifty five", 55],["fifty six", 56],["fifty seven", 57],["fifty eight", 58],["fifty nine", 59],["sixty", 60],["sixty one", 61],["sixty two", 62],["sixty three", 63],["sixty four", 64],["sixty five", 65],["sixty six", 66],["sixty seven", 67],["sixty eight", 68],["sixty nine", 69],["seventy", 70],["seventy one", 71],["seventy two", 72],["seventy three", 73],["seventy four", 74],["seventy five", 75],["seventy six", 76],["seventy seven", 77],["seventy eight", 78],["seventy nine", 79],["eighty", 80],["eighty one", 81],["eighty two", 82],["eighty three", 83],["eighty four", 84],["eighty five", 85],["eighty six", 86],["eighty seven", 87],["eighty eight", 88],["eighty nine", 89],["ninety", 90],["ninety one", 91],["ninety two", 92],["ninety three", 93],["ninety four", 94],["ninety five", 95],["ninety six", 96],["ninety seven", 97],["ninety eight", 98],["ninety nine", 99],["one hundred", 100]]);
    export const DayOfMonth: ReadonlyMap<string, number> = new Map<string, number>([["1st", 1],["1th", 1],["2nd", 2],["2th", 2],["3rd", 3],["3th", 3],["4th", 4],["5th", 5],["6th", 6],["7th", 7],["8th", 8],["9th", 9],["10th", 10],["11th", 11],["11st", 11],["12th", 12],["12nd", 12],["13th", 13],["13rd", 13],["14th", 14],["15th", 15],["16th", 16],["17th", 17],["18th", 18],["19th", 19],["20th", 20],["21st", 21],["21th", 21],["22nd", 22],["22th", 22],["23rd", 23],["23th", 23],["24th", 24],["25th", 25],["26th", 26],["27th", 27],["28th", 28],["29th", 29],["30th", 30],["31st", 31],["01st", 1],["01th", 1],["02nd", 2],["02th", 2],["03rd", 3],["03th", 3],["04th", 4],["05th", 5],["06th", 6],["07th", 7],["08th", 8],["09th", 9]]);
    export const DoubleNumbers: ReadonlyMap<string, number> = new Map<string, number>([["half", 0.5],["quarter", 0.25]]);
    export const HolidayNames: ReadonlyMap<string, string[]> = new Map<string, string[]>([["easterday", ["easterday","easter","eastersunday"]],["ashwednesday", ["ashwednesday"]],["palmsunday", ["palmsunday"]],["maundythursday", ["maundythursday"]],["goodfriday", ["goodfriday"]],["eastersaturday", ["eastersaturday"]],["eastermonday", ["eastermonday"]],["ascensionday", ["ascensionday"]],["whitesunday", ["whitesunday","pentecost","pentecostday"]],["whitemonday", ["whitemonday"]],["trinitysunday", ["trinitysunday"]],["corpuschristi", ["corpuschristi"]],["earthday", ["earthday"]],["fathers", ["fatherday","fathersday"]],["mothers", ["motherday","mothersday"]],["thanksgiving", ["thanksgivingday","thanksgiving"]],["blackfriday", ["blackfriday"]],["cybermonday", ["cybermonday"]],["martinlutherking", ["mlkday","martinlutherkingday","martinlutherkingjrday"]],["washingtonsbirthday", ["washingtonsbirthday","washingtonbirthday","presidentsday"]],["canberra", ["canberraday"]],["labour", ["labourday","laborday"]],["columbus", ["columbusday"]],["memorial", ["memorialday"]],["yuandan", ["yuandan"]],["maosbirthday", ["maosbirthday"]],["teachersday", ["teachersday","teacherday"]],["singleday", ["singleday"]],["allsaintsday", ["allsaintsday"]],["youthday", ["youthday"]],["childrenday", ["childrenday","childday"]],["femaleday", ["femaleday"]],["treeplantingday", ["treeplantingday"]],["arborday", ["arborday"]],["girlsday", ["girlsday"]],["whiteloverday", ["whiteloverday"]],["loverday", ["loverday","loversday"]],["christmas", ["christmasday","christmas"]],["xmas", ["xmasday","xmas"]],["newyear", ["newyear"]],["newyearday", ["newyearday"]],["newyearsday", ["newyearsday"]],["inaugurationday", ["inaugurationday"]],["groundhougday", ["groundhougday"]],["valentinesday", ["valentinesday"]],["stpatrickday", ["stpatrickday","stpatricksday","stpatrick"]],["aprilfools", ["aprilfools"]],["stgeorgeday", ["stgeorgeday"]],["mayday", ["mayday","intlworkersday","internationalworkersday","workersday"]],["cincodemayoday", ["cincodemayoday"]],["baptisteday", ["baptisteday"]],["usindependenceday", ["usindependenceday"]],["independenceday", ["independenceday"]],["bastilleday", ["bastilleday"]],["halloweenday", ["halloweenday","halloween"]],["allhallowday", ["allhallowday"]],["allsoulsday", ["allsoulsday"]],["guyfawkesday", ["guyfawkesday"]],["veteransday", ["veteransday"]],["christmaseve", ["christmaseve"]],["newyeareve", ["newyearseve","newyeareve"]],["juneteenth", ["juneteenth","freedomday","jubileeday"]],["ramadan", ["ramadan","ramazan","ramzan","ramadhan","ramathan"]],["sacrifice", ["eidaladha","eidalazha","eidulazha","feastofthesacrifice"]],["islamicnewyear", ["islamicnewyear","hijrinewyear","arabicnewyear"]],["eidalfitr", ["eidalfitr","festivalofbreakingthefast"]]]);
    export const WrittenDecades: ReadonlyMap<string, number> = new Map<string, number>([["hundreds", 0],["tens", 10],["twenties", 20],["thirties", 30],["forties", 40],["fifties", 50],["sixties", 60],["seventies", 70],["eighties", 80],["nineties", 90]]);
    export const SpecialDecadeCases: ReadonlyMap<string, number> = new Map<string, number>([["noughties", 2000],["aughts", 2000],["two thousands", 2000]]);
    export const DefaultLanguageFallback = `MDY`;
    export const SuperfluousWordList = [ "preferably","how about","maybe","perhaps","say","like" ];
    export const DurationDateRestrictions = [ "today","now","current date" ];
    export const AmbiguityFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)"],["^(morning|afternoon|evening|night|day)\\b", "\\b(good\\s+(morning|afternoon|evening|night|day))|(nighty\\s+night)\\b"],["\\bnow\\b", "\\b(^now,)|\\b((is|are)\\s+now\\s+for|for\\s+now)\\b"],["\\bmay$", "\\b((((!|\\.|\\?|,|;|)\\s+|^)may i)|(i|you|he|she|we|they)\\s+may|(may\\s+((((also|not|(also not)|well)\\s+)?(be|ask|contain|constitute|e-?mail|take|have|result|involve|get|work|reply|differ))|(or may not)))|(?<!(in|during|through)\\s+)may,? at (its|h(is|er)|y?our|my))\\b"],["^(a|one) second$", "\\b(?<!an?\\s+)(a|one) second (round|time|wave|turn|chance|thought|opinion|cycle|take|meaning|life|job|home|hand|language|display|monitor|stimulus|dose|vaccination|shot|jab)\\b"],["\\b(breakfast|brunch|lunch(time)?|dinner(time)?|supper)$", "(?<!\\b(at|before|after|around|circa)\\b\\s)(breakfast|brunch|lunch|dinner|supper)(?!\\s*time)"],["^\\d+m$", "^\\d+m$"],["^(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)$", "([$%£&!?@#])(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)|(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)([$%£&@#])"],["^(to\\s+date)$", "\\b((equals?|up)\\s+to\\s+date)\\b"],["^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}"],["^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}"]]);
    export const AmbiguityTimeFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["^(\\p{L}+|\\d{1,2})(\\s+(morning|afternoon|evening|night))?$", "\\b(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|\\d{1,2})\\s+(morning|afternoon|evening|night)\\b"]]);
    export const AmbiguityDurationFiltersDict: ReadonlyMap<string, string> = new Map<string, string>([["night$", "\\bnight(\\s*|-)(club|light|market|shift|work(er)?)s?\\b"]]);
    export const MorningTermList = [ "morning" ];
    export const AfternoonTermList = [ "afternoon" ];
    export const EveningTermList = [ "evening" ];
    export const MealtimeBreakfastTermList = [ "breakfast" ];
    export const MealtimeBrunchTermList = [ "brunch" ];
    export const MealtimeLunchTermList = [ "lunch","lunchtime" ];
    export const MealtimeDinnerTermList = [ "dinner","dinnertime","supper" ];
    export const DaytimeTermList = [ "daytime" ];
    export const NightTermList = [ "night" ];
    export const NighttimeTermList = [ "nighttime","night-time" ];
    export const SameDayTerms = [ "today","current date","otd" ];
    export const PlusOneDayTerms = [ "tomorrow","tmr","tmrw","day after" ];
    export const MinusOneDayTerms = [ "yesterday","day before" ];
    export const PlusTwoDayTerms = [ "day after tomorrow","day after tmr","day after tmrw" ];
    export const MinusTwoDayTerms = [ "day before yesterday" ];
    export const FutureTerms = [ "this","next" ];
    export const LastCardinalTerms = [ "last" ];
    export const MonthTerms = [ "month" ];
    export const MonthToDateTerms = [ "month to date" ];
    export const WeekendTerms = [ "weekend" ];
    export const WeekTerms = [ "week" ];
    export const FortnightTerms = [ "fortnight","fourtenight" ];
    export const YearTerms = [ "year" ];
    export const GenericYearTerms = [ "y" ];
    export const YearToDateTerms = [ "year to date" ];
    export const DoubleMultiplierRegex = `^(bi)(-|\\s)?`;
    export const HalfMultiplierRegex = `^(semi)(-|\\s)?`;
    export const DayTypeRegex = `((week)?da(il)?ys?)$`;
    export const WeekTypeRegex = `(week(s|ly)?)$`;
    export const WeekendTypeRegex = `(weekends?)$`;
    export const MonthTypeRegex = `(month(s|ly)?)$`;
    export const QuarterTypeRegex = `(quarter(s|ly)?)$`;
    export const YearTypeRegex = `((years?|annual)(ly)?)$`;
}
