// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.recognizers.text.sequence;

public class Constants {
    public static final String SYS_PHONE_NUMBER = "builtin.phonenumber";

    public static final String SYS_IP = "builtin.ip";

    public static final String SYS_MENTION = "builtin.mention";

    public static final String SYS_HASHTAG = "builtin.hashtag";

    public static final String SYS_EMAIL = "builtin.email";

    public static final String SYS_URL = "builtin.url";

    public static final String SYS_GUID = "builtin.guid";

    // Model type name
    public static final String MODEL_PHONE_NUMBER = "phonenumber";

    public static final String MODEL_IP = "ip";

    public static final String MODEL_MENTION = "mention";

    public static final String MODEL_HASHTAG = "hashtag";

    public static final String MODEL_EMAIL = "email";

    public static final String MODEL_URL = "url";

    public static final String MODEL_GUID = "guid";

    public static final String IP_REGEX_IPV4 = "ipv4";

    public static final String IP_REGEX_IPV6 = "ipv6";

    public static final String IPV6_ELLIPSIS = "::";

    public static final String PHONE_NUMBER_REGEX_GENERAL = "GeneralPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_BR = "BRPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_UK = "UKPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_DE = "DEPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_US = "USPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_CN = "CNPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_DK = "DKPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_IT = "ITPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_NL = "NLPhoneNumber";

    public static final String PHONE_NUMBER_REGEX_SPECIAL = "SpecialPhoneNumber";

    public static final String MENTION_REGEX = "Mention";

    public static final String HASHTAG_REGEX = "Hashtag";

    public static final String EMAIL_REGEX = "Email";

    public static final String URL_REGEX = "Url";

    public static final String GUID_REGEX = "Guid";
}