// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.number.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class SpanishNumeric {

    public static final String LangMarker = "Spa";

    public static final Boolean CompoundNumberLanguage = false;

    public static final Boolean MultiDecimalSeparatorCulture = true;

    public static final List<String> NonStandardSeparatorVariants = Arrays.asList("es-mx", "es-do", "es-sv", "es-gt", "es-hn", "es-ni", "es-pa", "es-pr");

    public static final String HundredsNumberIntegerRegex = "(cuatrocient[ao]s|trescient[ao]s|seiscient[ao]s|setecient[ao]s|ochocient[ao]s|novecient[ao]s|doscient[ao]s|quinient[ao]s|(?<!por\\s+)(cien(to)?))";

    public static final String RoundNumberIntegerSingRegex = "(((mil\\s+)?mi|bi|cuatri|quinti|sexti|septi)ll[oó]n|mil)";

    public static final String RoundNumberIntegerRegex = "({RoundNumberIntegerSingRegex}(es)?)"
            .replace("{RoundNumberIntegerSingRegex}", RoundNumberIntegerSingRegex);

    public static final String ZeroToNineIntegerRegex = "(cuatro|cinco|siete|nueve|cero|tres|seis|ocho|dos|un[ao]?)";

    public static final String TwoToNineIntegerRegex = "(cuatro|cinco|siete|nueve|tres|seis|ocho|dos)";

    public static final String TenToNineteenIntegerRegex = "(diecisiete|diecinueve|diecis[eé]is|dieciocho|catorce|quince|trece|diez|once|doce)";

    public static final String TwentiesIntegerRegex = "(veinti(cuatro|cinco|siete|nueve|tr[eé]s|s[eé]is|ocho|d[oó]s|[uú]n[oa]?)|ventiun[ao]|veinte)";

    public static final String TensNumberIntegerRegex = "(cincuenta|cuarenta|treinta|se[st]enta|ochenta|noventa)";

    public static final String NegativeNumberTermsRegex = "(?<negTerm>(?<!(al|lo)\\s+)menos\\s+)";

    public static final String NegativeNumberSignRegex = "^{NegativeNumberTermsRegex}.*"
            .replace("{NegativeNumberTermsRegex}", NegativeNumberTermsRegex);

    public static final String DigitsNumberRegex = "\\d|\\d{1,3}(\\.\\d{3})";

    public static final String BelowHundredsRegex = "(({TenToNineteenIntegerRegex}|{TwentiesIntegerRegex}|({TensNumberIntegerRegex}(\\s+y\\s+{ZeroToNineIntegerRegex})?))|{ZeroToNineIntegerRegex})"
            .replace("{TenToNineteenIntegerRegex}", TenToNineteenIntegerRegex)
            .replace("{TwentiesIntegerRegex}", TwentiesIntegerRegex)
            .replace("{TensNumberIntegerRegex}", TensNumberIntegerRegex)
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex);

    public static final String BelowThousandsRegex = "({HundredsNumberIntegerRegex}(\\s+{BelowHundredsRegex})?|{BelowHundredsRegex})"
            .replace("{HundredsNumberIntegerRegex}", HundredsNumberIntegerRegex)
            .replace("{BelowHundredsRegex}", BelowHundredsRegex);

    public static final String SupportThousandsRegex = "(({BelowThousandsRegex}|{BelowHundredsRegex})\\s+{RoundNumberIntegerRegex}(\\s+{RoundNumberIntegerRegex})?)"
            .replace("{BelowThousandsRegex}", BelowThousandsRegex)
            .replace("{BelowHundredsRegex}", BelowHundredsRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String SeparaIntRegex = "({SupportThousandsRegex}(\\s+{SupportThousandsRegex})*(\\s+{BelowThousandsRegex})?|{BelowThousandsRegex})"
            .replace("{SupportThousandsRegex}", SupportThousandsRegex)
            .replace("{BelowThousandsRegex}", BelowThousandsRegex);

    public static final String AllIntRegex = "({SeparaIntRegex}|mil(\\s+{BelowThousandsRegex})?|{RoundNumberIntegerSingRegex})"
            .replace("{SeparaIntRegex}", SeparaIntRegex)
            .replace("{BelowThousandsRegex}", BelowThousandsRegex)
            .replace("{RoundNumberIntegerSingRegex}", RoundNumberIntegerSingRegex);

    public static final String PlaceHolderPureNumber = "\\b";

    public static final String PlaceHolderDefault = "\\D|\\b";

    public static String NumbersWithPlaceHolder(String placeholder) {
        return "(((?<!\\d+\\s*)-\\s*)|(?<=\\b))\\d+(?!([\\.,]\\d+[a-zA-Z]))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static final String NumbersWithSuffix = "(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)"
            .replace("{BaseNumbers.NumberMultiplierRegex}", BaseNumbers.NumberMultiplierRegex);

    public static final String RoundNumberIntegerRegexWithLocks = "(?<=\\b)({DigitsNumberRegex})+\\s+{RoundNumberIntegerRegex}(?=\\b)"
            .replace("{DigitsNumberRegex}", DigitsNumberRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String NumbersWithDozenSuffix = "(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s+(docena|dz|doz)s?(?=\\b)";

    public static final String AllIntRegexWithLocks = "((?<=\\b){AllIntRegex}(?=\\b))"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String AllIntRegexWithDozenSuffixLocks = "(?<=\\b)(((media\\s+)?\\s+docena)|({AllIntRegex}\\s+(y|con)\\s+)?({AllIntRegex}\\s+(docena|dz|doz)s?))(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String SimpleRoundOrdinalRegex = "(mil[eé]simo|millon[eé]sim[oa]|billon[eé]sim[oa]|trillon[eé]sim[oa]|cuatrillon[eé]sim[oa]|quintillon[eé]sim[oa]|sextillon[eé]sim[oa]|septillon[eé]sim[oa])";

    public static final String OneToNineOrdinalRegex = "(primer[oa]?|segund[oa]|tercer[oa]?|cuart[oa]|quint[oa]|sext[oa]|s[eé]ptim[oa]|octav[oa]|noven[oa])";

    public static final String TensOrdinalRegex = "(nonag[eé]sim[oa]|octog[eé]sim[oa]|septuag[eé]sim[oa]|sexag[eé]sim[oa]|quincuag[eé]sim[oa]|cuadrag[eé]sim[oa]|trig[eé]sim[oa]|vig[eé]sim[oa]|d[eé]cim[oa])";

    public static final String HundredOrdinalRegex = "(cent[eé]sim[oa]|ducent[eé]sim[oa]|tricent[eé]sim[oa]|cuadringent[eé]sim[oa]|quingent[eé]sim[oa]|sexcent[eé]sim[oa]|septingent[eé]sim[oa]|octingent[eé]sim[oa]|noningent[eé]sim[oa])";

    public static final String SpecialUnderHundredOrdinalRegex = "(und[eé]cim[oa]|duod[eé]cim[oa]|decimoctav[oa])";

    public static final String UnderHundredOrdinalRegex = "({SpecialUnderHundredOrdinalRegex}|(({TensOrdinalRegex}(\\s)?)?{OneToNineOrdinalRegex})|{TensOrdinalRegex})"
            .replace("{TensOrdinalRegex}", TensOrdinalRegex)
            .replace("{OneToNineOrdinalRegex}", OneToNineOrdinalRegex)
            .replace("{SpecialUnderHundredOrdinalRegex}", SpecialUnderHundredOrdinalRegex);

    public static final String UnderThousandOrdinalRegex = "((({HundredOrdinalRegex}(\\s)?)?{UnderHundredOrdinalRegex})|{HundredOrdinalRegex})"
            .replace("{HundredOrdinalRegex}", HundredOrdinalRegex)
            .replace("{UnderHundredOrdinalRegex}", UnderHundredOrdinalRegex);

    public static final String OverThousandOrdinalRegex = "(({AllIntRegex})([eé]sim[oa]))"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String RelativeOrdinalRegex = "(?<relativeOrdinal>(antes\\s+de|anterior\\s+a)(l|\\s+la)\\s+[uú]ltim[ao]|((ante)?pen)?[uú]ltim[ao]s?|pr[oó]xim[ao]s?|anterior(es)?|actual(es)?|siguientes?)";

    public static final String ComplexOrdinalRegex = "(({OverThousandOrdinalRegex}(\\s)?)?{UnderThousandOrdinalRegex}|{OverThousandOrdinalRegex})"
            .replace("{OverThousandOrdinalRegex}", OverThousandOrdinalRegex)
            .replace("{UnderThousandOrdinalRegex}", UnderThousandOrdinalRegex);

    public static final String SufixRoundOrdinalRegex = "(({AllIntRegex})({SimpleRoundOrdinalRegex}))"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{SimpleRoundOrdinalRegex}", SimpleRoundOrdinalRegex);

    public static final String ComplexRoundOrdinalRegex = "((({SufixRoundOrdinalRegex}(\\s)?)?{ComplexOrdinalRegex})|{SufixRoundOrdinalRegex})"
            .replace("{SufixRoundOrdinalRegex}", SufixRoundOrdinalRegex)
            .replace("{ComplexOrdinalRegex}", ComplexOrdinalRegex);

    public static final String AllOrdinalNumberRegex = "{ComplexOrdinalRegex}|{SimpleRoundOrdinalRegex}|{ComplexRoundOrdinalRegex}"
            .replace("{ComplexOrdinalRegex}", ComplexOrdinalRegex)
            .replace("{SimpleRoundOrdinalRegex}", SimpleRoundOrdinalRegex)
            .replace("{ComplexRoundOrdinalRegex}", ComplexRoundOrdinalRegex);

    public static final String AllOrdinalRegex = "(?:{AllOrdinalNumberRegex}s?|{RelativeOrdinalRegex})"
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{RelativeOrdinalRegex}", RelativeOrdinalRegex);

    public static final String OrdinalSuffixRegex = "(?<=\\b)(\\d*((1(er|r[oa])|2d[oa]|3r[oa]|4t[oa]|5t[oa]|6t[oa]|7m[oa]|8v[oa]|9n[oa]|0m[oa]|11[vm][oa]|12[vm][oa])|\\d\\.?[ºª]))(?=\\b)";

    public static final String OrdinalNounRegex = "(?<=\\b){AllOrdinalRegex}(?=\\b)"
            .replace("{AllOrdinalRegex}", AllOrdinalRegex);

    public static final String SpecialFractionInteger = "((({AllIntRegex})i?({ZeroToNineIntegerRegex})|({AllIntRegex}))a?v[oa]s?)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex);

    public static final String FractionNotationRegex = "{BaseNumbers.FractionNotationRegex}"
            .replace("{BaseNumbers.FractionNotationRegex}", BaseNumbers.FractionNotationRegex);

    public static final String FractionNotationWithSpacesRegex = "(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s+\\d+[/]\\d+(?=(\\b[^/]|$))";

    public static final String FractionMultiplierRegex = "(?<fracMultiplier>\\s+(y|con)\\s+(medio|(un|{TwoToNineIntegerRegex})\\s+(medio|terci[oa]?|cuart[oa]|quint[oa]|sext[oa]|s[eé]ptim[oa]|octav[oa]|noven[oa]|d[eé]cim[oa])s?))"
            .replace("{TwoToNineIntegerRegex}", TwoToNineIntegerRegex);

    public static final String RoundMultiplierWithFraction = "(?<multiplier>(?:(mil\\s+millones|mill[oó]n(es)?|bill[oó]n(es)?|trill[oó]n(es)?|cuatrill[oó]n(es)?|quintill[oó]n(es)?|sextill[oó]n(es)?|septill[oó]n(es)?)))(?={FractionMultiplierRegex}?$)"
            .replace("{FractionMultiplierRegex}", FractionMultiplierRegex);

    public static final String RoundMultiplierRegex = "\\b\\s*({RoundMultiplierWithFraction}|(?<multiplier>(mil))$)"
            .replace("{RoundMultiplierWithFraction}", RoundMultiplierWithFraction);

    public static final String FractionNounRegex = "(?<=\\b)({AllIntRegex}\\s+((y|con)\\s+)?)?({AllIntRegex}\\s+((({AllOrdinalNumberRegex}|{SufixRoundOrdinalRegex})s|{SpecialFractionInteger})|((y|con)\\s+)?(medi[oa]s?|tercios?))|(medio|un\\s+cuarto\\s+de)\\s+{RoundNumberIntegerRegex})(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{SpecialFractionInteger}", SpecialFractionInteger)
            .replace("{SufixRoundOrdinalRegex}", SufixRoundOrdinalRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String FractionNounWithArticleRegex = "(?<=\\b)(({AllIntRegex}|{RoundNumberIntegerRegexWithLocks})\\s+((y|con)\\s+)?)?((un|un[oa])(\\s+)(({AllOrdinalNumberRegex})|({SufixRoundOrdinalRegex}))|(un[ao]?\\s+)?medi[oa]s?|mitad)(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{SufixRoundOrdinalRegex}", SufixRoundOrdinalRegex)
            .replace("{RoundNumberIntegerRegexWithLocks}", RoundNumberIntegerRegexWithLocks);

    public static final String FractionPrepositionRegex = "(?<!{BaseNumbers.CommonCurrencySymbol}\\s*)(?<=\\b)(?<numerator>({AllIntRegex})|((?<!\\.)\\d+))\\s+sobre\\s+(?<denominator>({AllIntRegex})|((\\d+)(?!\\.)))(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{BaseNumbers.CommonCurrencySymbol}", BaseNumbers.CommonCurrencySymbol);

    public static final String AllPointRegex = "((\\s+{ZeroToNineIntegerRegex})+|(\\s+{AllIntRegex}))"
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex)
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String AllFloatRegex = "{AllIntRegex}(\\s+(coma|con)){AllPointRegex}"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllPointRegex}", AllPointRegex);

    public static String DoubleDecimalPointRegex(String placeholder) {
        return "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[\\.,])))\\d+[\\.,]\\d+(?!([\\.,]\\d+))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static String DoubleWithoutIntegralRegex(String placeholder) {
        return "(?<=\\s|^)(?<!(\\d+))[\\.,]\\d+(?!([\\.,]\\d+))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static final String DoubleWithMultiplierRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\[\\.,])))\\d+[\\.,]\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)"
            .replace("{BaseNumbers.NumberMultiplierRegex}", BaseNumbers.NumberMultiplierRegex);

    public static final String DoubleWithRoundNumber = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\[\\.,])))\\d+[\\.,]\\d+\\s+{RoundNumberIntegerRegex}(?=\\b)"
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String DoubleAllFloatRegex = "((?<=\\b){AllFloatRegex}(?=\\b))"
            .replace("{AllFloatRegex}", AllFloatRegex);

    public static final String DoubleExponentialNotationRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[\\.,])))(\\d+([\\.,]\\d+)?)e([+-]*[1-9]\\d*)(?=\\b)";

    public static final String DoubleCaretExponentialNotationRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[\\.,])))(\\d+([\\.,]\\d+)?)\\^([+-]*[1-9]\\d*)(?=\\b)";

    public static final String NumberWithPrefixPercentage = "(?<!%)({BaseNumbers.NumberReplaceToken})(\\s*)(%(?!{BaseNumbers.NumberReplaceToken})|por\\s+cien(to)?\\b)"
            .replace("{BaseNumbers.NumberReplaceToken}", BaseNumbers.NumberReplaceToken);

    public static final String TillRegex = "(\\ba\\b|hasta|--|-|—|——|~|–)";

    public static final String MoreRegex = "(más\\s+(alt[oa]s?|grandes)\\s+que|(m[áa]s|mayor(es)?|superior(es)?|por\\s+encima)\\b((\\s+(que|del?|al?))|(?=\\s+o\\b))|(?<!<|=)>)";

    public static final String LessRegex = "((meno(s|r(es)?)|inferior(es)?|por\\s+debajo)((\\s+(que|del?|al?)|(?=\\s+o\\b)))|más\\s+baj[oa]\\s+que|(?<!>|=)<)";

    public static final String EqualRegex = "((igual(es)?|equivalente(s)?|equivalen?)(\\s+(al?|que|del?))?|(?<!<|>)=)";

    public static final String MoreOrEqualPrefix = "((no\\s+{LessRegex})|(por\\s+lo\\s+menos|como\\s+m[íi]nimo|al\\s+menos))"
            .replace("{LessRegex}", LessRegex);

    public static final String MoreOrEqual = "(({MoreRegex}\\s+(o)?\\s+{EqualRegex})|({EqualRegex}\\s+(o|y)\\s+{MoreRegex})|{MoreOrEqualPrefix}(\\s+(o)\\s+{EqualRegex})?|({EqualRegex}\\s+(o)\\s+)?{MoreOrEqualPrefix}|>\\s*=)"
            .replace("{MoreRegex}", MoreRegex)
            .replace("{EqualRegex}", EqualRegex)
            .replace("{LessRegex}", LessRegex)
            .replace("{MoreOrEqualPrefix}", MoreOrEqualPrefix);

    public static final String MoreOrEqualSuffix = "((\\b(y|o)\\b\\s+(m[áa]s|mayor(es)?|superior(es)?)((?!\\s+(alt[oa]|baj[oa]|que|del?|al?))|(\\s+(que|del?|al?)(?!(\\s*\\d+)))))|como\\s+m[íi]nimo|por\\s+lo\\s+menos|al\\s+menos)\\b";

    public static final String LessOrEqualPrefix = "((no\\s+{MoreRegex})|(como\\s+(m[aá]ximo|mucho)))"
            .replace("{MoreRegex}", MoreRegex);

    public static final String LessOrEqual = "(({LessRegex}\\s+(o)?\\s+{EqualRegex})|({EqualRegex}\\s+(o)?\\s+{LessRegex})|{LessOrEqualPrefix}(\\s+(o)?\\s+{EqualRegex})?|({EqualRegex}\\s+(o)?\\s+)?{LessOrEqualPrefix}|<\\s*=)"
            .replace("{LessRegex}", LessRegex)
            .replace("{EqualRegex}", EqualRegex)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{LessOrEqualPrefix}", LessOrEqualPrefix);

    public static final String LessOrEqualSuffix = "((\\b(y|o)\\b\\s+(meno(s|r(es)?|inferior(es)?))((?!\\s+(alt[oa]|baj[oa]|que|del?|al?))|(\\s+(que|del?|al?)(?!(\\s*\\d+)))))|como\\s+m[áa]ximo)\\b";

    public static final String NumberSplitMark = "(?![,.](?!\\d+))(?!\\s*\\b(((y|e)\\s+)?({LessRegex}|{MoreRegex}|{EqualRegex}|no|de)|pero|o|a)\\b)"
            .replace("{LessRegex}", LessRegex)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{EqualRegex}", EqualRegex);

    public static final String MoreRegexNoNumberSucceed = "(\\b(m[áa]s|mayor(es)?|superior(es)?)((?!\\s+(que|del?|al?))|\\s+((que|del?)(?!(\\s*\\d+))))|(por encima)(?!(\\s*\\d+)))\\b";

    public static final String LessRegexNoNumberSucceed = "(\\b(meno(s|r(es)?)|inferior(es)?)((?!\\s+(que|del?|al?))|\\s+((que|del?|al?)(?!(\\s*\\d+))))|(por debajo)(?!(\\s*\\d+)))\\b";

    public static final String EqualRegexNoNumberSucceed = "(\\b(igual(es)?|equivalentes?|equivalen?)((?!\\s+(al?|que|del?))|(\\s+(al?|que|del?)(?!(\\s*\\d+)))))\\b";

    public static final String OneNumberRangeMoreRegex1 = "({MoreOrEqual}|{MoreRegex})\\s*((el|las?|los)\\s+)?(?<number1>({NumberSplitMark}.)+)"
            .replace("{MoreOrEqual}", MoreOrEqual)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeMoreRegex1LB = "(?<!no\\s+){OneNumberRangeMoreRegex1}"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1);

    public static final String OneNumberRangeMoreRegex2 = "(?<number1>({NumberSplitMark}.)+)\\s*{MoreOrEqualSuffix}"
            .replace("{MoreOrEqualSuffix}", MoreOrEqualSuffix)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeMoreSeparateRegex = "({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){MoreRegexNoNumberSucceed})|({MoreRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){EqualRegexNoNumberSucceed})"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{EqualRegexNoNumberSucceed}", EqualRegexNoNumberSucceed)
            .replace("{MoreRegexNoNumberSucceed}", MoreRegexNoNumberSucceed)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessRegex1 = "({LessOrEqual}|{LessRegex})\\s*((el|las?|los)\\s+)?(?<number2>({NumberSplitMark}.)+)"
            .replace("{LessOrEqual}", LessOrEqual)
            .replace("{LessRegex}", LessRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessRegex1LB = "(?<!no\\s+){OneNumberRangeLessRegex1}"
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1);

    public static final String OneNumberRangeLessRegex2 = "(?<number2>({NumberSplitMark}.)+)\\s*{LessOrEqualSuffix}"
            .replace("{LessOrEqualSuffix}", LessOrEqualSuffix)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessSeparateRegex = "({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){LessRegexNoNumberSucceed})|({LessRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+o\\s+){EqualRegexNoNumberSucceed})"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{LessRegex}", LessRegex)
            .replace("{EqualRegexNoNumberSucceed}", EqualRegexNoNumberSucceed)
            .replace("{LessRegexNoNumberSucceed}", LessRegexNoNumberSucceed)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeEqualRegex = "{EqualRegex}\\s*((el|las?|los)\\s+)?(?<number1>({NumberSplitMark}.)+)"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String TwoNumberRangeRegex1 = "\\bentre\\s*((el|las?|los)\\s+)?(?<number1>({NumberSplitMark}.)+)\\s*y\\s*((el|las?|los)\\s+)?(?<number2>({NumberSplitMark}.)+)"
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String TwoNumberRangeRegex2 = "({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})\\s*(\\by\\b|\\be\\b|pero|,)\\s*({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1)
            .replace("{OneNumberRangeMoreRegex2}", OneNumberRangeMoreRegex2)
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1)
            .replace("{OneNumberRangeLessRegex2}", OneNumberRangeLessRegex2);

    public static final String TwoNumberRangeRegex3 = "({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})\\s*(\\by\\b|\\be\\b|pero|,)\\s*({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1)
            .replace("{OneNumberRangeMoreRegex2}", OneNumberRangeMoreRegex2)
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1)
            .replace("{OneNumberRangeLessRegex2}", OneNumberRangeLessRegex2);

    public static final String TwoNumberRangeRegex4 = "(\\bde(sde)?\\s+)?(\\b(el|las?|los)\\s+)?\\b(?!\\s+)(?<number1>({NumberSplitMark}(?!\\b(entre|de(sde)?|es)\\b).)+)\\b\\s*{TillRegex}\\s*((el|las?|los)\\s+)?\\b(?!\\s+)(?<number2>({NumberSplitMark}.)+)\\b"
            .replace("{TillRegex}", TillRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String AmbiguousFractionConnectorsRegex = "(\\b(en|de)\\b)";

    public static final Character DecimalSeparatorChar = ',';

    public static final String FractionMarkerToken = "sobre";

    public static final Character NonDecimalSeparatorChar = '.';

    public static final String HalfADozenText = "seis";

    public static final String WordSeparatorToken = "y";

    public static final List<String> WrittenDecimalSeparatorTexts = Arrays.asList("coma", "con");

    public static final List<String> WrittenGroupSeparatorTexts = Arrays.asList("punto");

    public static final List<String> WrittenIntegerSeparatorTexts = Arrays.asList("y");

    public static final List<String> WrittenFractionSeparatorTexts = Arrays.asList("con");

    public static final List<String> OneHalfTokens = Arrays.asList("un", "medio");

    public static final String HalfADozenRegex = "media\\s+docena";

    public static final String DigitalNumberRegex = "((?<=\\b)(mil(l[oó]n(es)?)?|bill[oó]n(es)?|trill[oó]n(es)?|(docena|dz|doz)s?)(?=\\b))|((?<=(\\d|\\b)){BaseNumbers.MultiplierLookupRegex}(?=\\b))"
            .replace("{BaseNumbers.MultiplierLookupRegex}", BaseNumbers.MultiplierLookupRegex);

    public static final ImmutableMap<String, Long> CardinalNumberMap = ImmutableMap.<String, Long>builder()
        .put("cero", 0L)
        .put("un", 1L)
        .put("una", 1L)
        .put("uno", 1L)
        .put("dos", 2L)
        .put("tres", 3L)
        .put("cuatro", 4L)
        .put("cinco", 5L)
        .put("seis", 6L)
        .put("siete", 7L)
        .put("ocho", 8L)
        .put("nueve", 9L)
        .put("diez", 10L)
        .put("once", 11L)
        .put("doce", 12L)
        .put("docena", 12L)
        .put("docenas", 12L)
        .put("dz", 12L)
        .put("doz", 12L)
        .put("dzs", 12L)
        .put("dozs", 12L)
        .put("trece", 13L)
        .put("catorce", 14L)
        .put("quince", 15L)
        .put("dieciseis", 16L)
        .put("dieciséis", 16L)
        .put("diecisiete", 17L)
        .put("dieciocho", 18L)
        .put("diecinueve", 19L)
        .put("veinte", 20L)
        .put("ventiuna", 21L)
        .put("ventiuno", 21L)
        .put("veintiun", 21L)
        .put("veintiún", 21L)
        .put("veintiuno", 21L)
        .put("veintiuna", 21L)
        .put("veintidos", 22L)
        .put("veintidós", 22L)
        .put("veintitres", 23L)
        .put("veintitrés", 23L)
        .put("veinticuatro", 24L)
        .put("veinticinco", 25L)
        .put("veintiseis", 26L)
        .put("veintiséis", 26L)
        .put("veintisiete", 27L)
        .put("veintiocho", 28L)
        .put("veintinueve", 29L)
        .put("treinta", 30L)
        .put("cuarenta", 40L)
        .put("cincuenta", 50L)
        .put("sesenta", 60L)
        .put("setenta", 70L)
        .put("ochenta", 80L)
        .put("noventa", 90L)
        .put("cien", 100L)
        .put("ciento", 100L)
        .put("doscientas", 200L)
        .put("doscientos", 200L)
        .put("trescientas", 300L)
        .put("trescientos", 300L)
        .put("cuatrocientas", 400L)
        .put("cuatrocientos", 400L)
        .put("quinientas", 500L)
        .put("quinientos", 500L)
        .put("seiscientas", 600L)
        .put("seiscientos", 600L)
        .put("setecientas", 700L)
        .put("setecientos", 700L)
        .put("ochocientas", 800L)
        .put("ochocientos", 800L)
        .put("novecientas", 900L)
        .put("novecientos", 900L)
        .put("mil", 1000L)
        .put("millon", 1000000L)
        .put("millón", 1000000L)
        .put("millones", 1000000L)
        .put("billon", 1000000000000L)
        .put("billón", 1000000000000L)
        .put("billones", 1000000000000L)
        .put("trillon", 1000000000000000000L)
        .put("trillón", 1000000000000000000L)
        .put("trillones", 1000000000000000000L)
        .build();

    public static final ImmutableMap<String, Long> OrdinalNumberMap = ImmutableMap.<String, Long>builder()
        .put("primero", 1L)
        .put("primera", 1L)
        .put("primer", 1L)
        .put("segundo", 2L)
        .put("segunda", 2L)
        .put("medio", 2L)
        .put("media", 2L)
        .put("mitad", 2L)
        .put("tercero", 3L)
        .put("tercera", 3L)
        .put("tercer", 3L)
        .put("tercio", 3L)
        .put("cuarto", 4L)
        .put("cuarta", 4L)
        .put("quinto", 5L)
        .put("quinta", 5L)
        .put("sexto", 6L)
        .put("sexta", 6L)
        .put("septimo", 7L)
        .put("septima", 7L)
        .put("séptimo", 7L)
        .put("séptima", 7L)
        .put("octavo", 8L)
        .put("octava", 8L)
        .put("noveno", 9L)
        .put("novena", 9L)
        .put("decimo", 10L)
        .put("décimo", 10L)
        .put("decima", 10L)
        .put("décima", 10L)
        .put("undecimo", 11L)
        .put("undecima", 11L)
        .put("undécimo", 11L)
        .put("undécima", 11L)
        .put("duodecimo", 12L)
        .put("duodecima", 12L)
        .put("duodécimo", 12L)
        .put("duodécima", 12L)
        .put("decimotercero", 13L)
        .put("decimotercera", 13L)
        .put("decimocuarto", 14L)
        .put("decimocuarta", 14L)
        .put("decimoquinto", 15L)
        .put("decimoquinta", 15L)
        .put("decimosexto", 16L)
        .put("decimosexta", 16L)
        .put("decimoseptimo", 17L)
        .put("decimoseptima", 17L)
        .put("decimoctavo", 18L)
        .put("decimoctava", 18L)
        .put("decimonoveno", 19L)
        .put("decimonovena", 19L)
        .put("vigesimo", 20L)
        .put("vigesima", 20L)
        .put("vigésimo", 20L)
        .put("vigésima", 20L)
        .put("trigesimo", 30L)
        .put("trigesima", 30L)
        .put("trigésimo", 30L)
        .put("trigésima", 30L)
        .put("cuadragesimo", 40L)
        .put("cuadragesima", 40L)
        .put("cuadragésimo", 40L)
        .put("cuadragésima", 40L)
        .put("quincuagesimo", 50L)
        .put("quincuagesima", 50L)
        .put("quincuagésimo", 50L)
        .put("quincuagésima", 50L)
        .put("sexagesimo", 60L)
        .put("sexagesima", 60L)
        .put("sexagésimo", 60L)
        .put("sexagésima", 60L)
        .put("septuagesimo", 70L)
        .put("septuagesima", 70L)
        .put("septuagésimo", 70L)
        .put("septuagésima", 70L)
        .put("octogesimo", 80L)
        .put("octogesima", 80L)
        .put("octogésimo", 80L)
        .put("octogésima", 80L)
        .put("nonagesimo", 90L)
        .put("nonagesima", 90L)
        .put("nonagésimo", 90L)
        .put("nonagésima", 90L)
        .put("centesimo", 100L)
        .put("centesima", 100L)
        .put("centésimo", 100L)
        .put("centésima", 100L)
        .put("ducentesimo", 200L)
        .put("ducentesima", 200L)
        .put("ducentésimo", 200L)
        .put("ducentésima", 200L)
        .put("tricentesimo", 300L)
        .put("tricentesima", 300L)
        .put("tricentésimo", 300L)
        .put("tricentésima", 300L)
        .put("cuadringentesimo", 400L)
        .put("cuadringentesima", 400L)
        .put("cuadringentésimo", 400L)
        .put("cuadringentésima", 400L)
        .put("quingentesimo", 500L)
        .put("quingentesima", 500L)
        .put("quingentésimo", 500L)
        .put("quingentésima", 500L)
        .put("sexcentesimo", 600L)
        .put("sexcentesima", 600L)
        .put("sexcentésimo", 600L)
        .put("sexcentésima", 600L)
        .put("septingentesimo", 700L)
        .put("septingentesima", 700L)
        .put("septingentésimo", 700L)
        .put("septingentésima", 700L)
        .put("octingentesimo", 800L)
        .put("octingentesima", 800L)
        .put("octingentésimo", 800L)
        .put("octingentésima", 800L)
        .put("noningentesimo", 900L)
        .put("noningentesima", 900L)
        .put("noningentésimo", 900L)
        .put("noningentésima", 900L)
        .put("milesimo", 1000L)
        .put("milesima", 1000L)
        .put("milésimo", 1000L)
        .put("milésima", 1000L)
        .put("millonesimo", 1000000L)
        .put("millonesima", 1000000L)
        .put("millonésimo", 1000000L)
        .put("millonésima", 1000000L)
        .put("billonesimo", 1000000000000L)
        .put("billonesima", 1000000000000L)
        .put("billonésimo", 1000000000000L)
        .put("billonésima", 1000000000000L)
        .put("primeros", 1L)
        .put("primeras", 1L)
        .put("segundos", 2L)
        .put("segundas", 2L)
        .put("terceros", 3L)
        .put("terceras", 3L)
        .put("tercios", 3L)
        .put("cuartos", 4L)
        .put("cuartas", 4L)
        .put("quintos", 5L)
        .put("quintas", 5L)
        .put("sextos", 6L)
        .put("sextas", 6L)
        .put("septimos", 7L)
        .put("septimas", 7L)
        .put("séptimos", 7L)
        .put("séptimas", 7L)
        .put("octavos", 8L)
        .put("octavas", 8L)
        .put("novenos", 9L)
        .put("novenas", 9L)
        .put("decimos", 10L)
        .put("décimos", 10L)
        .put("decimas", 10L)
        .put("décimas", 10L)
        .put("undecimos", 11L)
        .put("undecimas", 11L)
        .put("undécimos", 11L)
        .put("undécimas", 11L)
        .put("duodecimos", 12L)
        .put("duodecimas", 12L)
        .put("duodécimos", 12L)
        .put("duodécimas", 12L)
        .put("decimoterceros", 13L)
        .put("decimoterceras", 13L)
        .put("decimocuartos", 14L)
        .put("decimocuartas", 14L)
        .put("decimoquintos", 15L)
        .put("decimoquintas", 15L)
        .put("decimosextos", 16L)
        .put("decimosextas", 16L)
        .put("decimoseptimos", 17L)
        .put("decimoseptimas", 17L)
        .put("decimoctavos", 18L)
        .put("decimoctavas", 18L)
        .put("decimonovenos", 19L)
        .put("decimonovenas", 19L)
        .put("vigesimos", 20L)
        .put("vigesimas", 20L)
        .put("vigésimos", 20L)
        .put("vigésimas", 20L)
        .put("trigesimos", 30L)
        .put("trigesimas", 30L)
        .put("trigésimos", 30L)
        .put("trigésimas", 30L)
        .put("cuadragesimos", 40L)
        .put("cuadragesimas", 40L)
        .put("cuadragésimos", 40L)
        .put("cuadragésimas", 40L)
        .put("quincuagesimos", 50L)
        .put("quincuagesimas", 50L)
        .put("quincuagésimos", 50L)
        .put("quincuagésimas", 50L)
        .put("sexagesimos", 60L)
        .put("sexagesimas", 60L)
        .put("sexagésimos", 60L)
        .put("sexagésimas", 60L)
        .put("septuagesimos", 70L)
        .put("septuagesimas", 70L)
        .put("septuagésimos", 70L)
        .put("septuagésimas", 70L)
        .put("octogesimos", 80L)
        .put("octogesimas", 80L)
        .put("octogésimos", 80L)
        .put("octogésimas", 80L)
        .put("nonagesimos", 90L)
        .put("nonagesimas", 90L)
        .put("nonagésimos", 90L)
        .put("nonagésimas", 90L)
        .put("centesimos", 100L)
        .put("centesimas", 100L)
        .put("centésimos", 100L)
        .put("centésimas", 100L)
        .put("ducentesimos", 200L)
        .put("ducentesimas", 200L)
        .put("ducentésimos", 200L)
        .put("ducentésimas", 200L)
        .put("tricentesimos", 300L)
        .put("tricentesimas", 300L)
        .put("tricentésimos", 300L)
        .put("tricentésimas", 300L)
        .put("cuadringentesimos", 400L)
        .put("cuadringentesimas", 400L)
        .put("cuadringentésimos", 400L)
        .put("cuadringentésimas", 400L)
        .put("quingentesimos", 500L)
        .put("quingentesimas", 500L)
        .put("quingentésimos", 500L)
        .put("quingentésimas", 500L)
        .put("sexcentesimos", 600L)
        .put("sexcentesimas", 600L)
        .put("sexcentésimos", 600L)
        .put("sexcentésimas", 600L)
        .put("septingentesimos", 700L)
        .put("septingentesimas", 700L)
        .put("septingentésimos", 700L)
        .put("septingentésimas", 700L)
        .put("octingentesimos", 800L)
        .put("octingentesimas", 800L)
        .put("octingentésimos", 800L)
        .put("octingentésimas", 800L)
        .put("noningentesimos", 900L)
        .put("noningentesimas", 900L)
        .put("noningentésimos", 900L)
        .put("noningentésimas", 900L)
        .put("milesimos", 1000L)
        .put("milesimas", 1000L)
        .put("milésimos", 1000L)
        .put("milésimas", 1000L)
        .put("millonesimos", 1000000L)
        .put("millonesimas", 1000000L)
        .put("millonésimos", 1000000L)
        .put("millonésimas", 1000000L)
        .put("billonesimos", 1000000000000L)
        .put("billonesimas", 1000000000000L)
        .put("billonésimos", 1000000000000L)
        .put("billonésimas", 1000000000000L)
        .build();

    public static final ImmutableMap<String, Long> PrefixCardinalMap = ImmutableMap.<String, Long>builder()
        .put("dos", 2L)
        .put("tres", 3L)
        .put("cuatro", 4L)
        .put("cinco", 5L)
        .put("seis", 6L)
        .put("siete", 7L)
        .put("ocho", 8L)
        .put("nueve", 9L)
        .put("diez", 10L)
        .put("once", 11L)
        .put("doce", 12L)
        .put("trece", 13L)
        .put("catorce", 14L)
        .put("quince", 15L)
        .put("dieciseis", 16L)
        .put("dieciséis", 16L)
        .put("diecisiete", 17L)
        .put("dieciocho", 18L)
        .put("diecinueve", 19L)
        .put("veinte", 20L)
        .put("ventiuna", 21L)
        .put("veintiun", 21L)
        .put("veintiún", 21L)
        .put("veintidos", 22L)
        .put("veintitres", 23L)
        .put("veinticuatro", 24L)
        .put("veinticinco", 25L)
        .put("veintiseis", 26L)
        .put("veintisiete", 27L)
        .put("veintiocho", 28L)
        .put("veintinueve", 29L)
        .put("treinta", 30L)
        .put("cuarenta", 40L)
        .put("cincuenta", 50L)
        .put("sesenta", 60L)
        .put("setenta", 70L)
        .put("ochenta", 80L)
        .put("noventa", 90L)
        .put("cien", 100L)
        .put("doscientos", 200L)
        .put("trescientos", 300L)
        .put("cuatrocientos", 400L)
        .put("quinientos", 500L)
        .put("seiscientos", 600L)
        .put("setecientos", 700L)
        .put("ochocientos", 800L)
        .put("novecientos", 900L)
        .build();

    public static final ImmutableMap<String, Long> SuffixOrdinalMap = ImmutableMap.<String, Long>builder()
        .put("milesimo", 1000L)
        .put("millonesimo", 1000000L)
        .put("billonesimo", 1000000000000L)
        .build();

    public static final ImmutableMap<String, Long> RoundNumberMap = ImmutableMap.<String, Long>builder()
        .put("mil", 1000L)
        .put("milesimo", 1000L)
        .put("millon", 1000000L)
        .put("millón", 1000000L)
        .put("millones", 1000000L)
        .put("millonesimo", 1000000L)
        .put("billon", 1000000000000L)
        .put("billón", 1000000000000L)
        .put("billones", 1000000000000L)
        .put("billonesimo", 1000000000000L)
        .put("trillon", 1000000000000000000L)
        .put("trillón", 1000000000000000000L)
        .put("trillones", 1000000000000000000L)
        .put("trillonesimo", 1000000000000000000L)
        .put("docena", 12L)
        .put("docenas", 12L)
        .put("dz", 12L)
        .put("doz", 12L)
        .put("dzs", 12L)
        .put("dozs", 12L)
        .put("k", 1000L)
        .put("m", 1000000L)
        .put("g", 1000000000L)
        .put("b", 1000000000L)
        .put("t", 1000000000000L)
        .build();

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "")
        .build();

    public static final ImmutableMap<String, String> RelativeReferenceOffsetMap = ImmutableMap.<String, String>builder()
        .put("proxima", "1")
        .put("proximo", "1")
        .put("proximas", "1")
        .put("proximos", "1")
        .put("próxima", "1")
        .put("próximo", "1")
        .put("próximas", "1")
        .put("próximos", "1")
        .put("anterior", "-1")
        .put("anteriores", "-1")
        .put("actual", "0")
        .put("actuales", "0")
        .put("siguiente", "1")
        .put("siguientes", "1")
        .put("ultima", "0")
        .put("ultimo", "0")
        .put("última", "0")
        .put("último", "0")
        .put("ultimas", "0")
        .put("ultimos", "0")
        .put("últimas", "0")
        .put("últimos", "0")
        .put("penultima", "-1")
        .put("penultimo", "-1")
        .put("penúltima", "-1")
        .put("penúltimo", "-1")
        .put("penultimas", "-1")
        .put("penultimos", "-1")
        .put("penúltimas", "-1")
        .put("penúltimos", "-1")
        .put("antepenultima", "-2")
        .put("antepenultimo", "-2")
        .put("antepenúltima", "-2")
        .put("antepenúltimo", "-2")
        .put("antepenultimas", "-2")
        .put("antepenultimos", "-2")
        .put("antepenúltimas", "-2")
        .put("antepenúltimos", "-2")
        .put("antes de la ultima", "-1")
        .put("antes del ultimo", "-1")
        .put("antes de la última", "-1")
        .put("antes del último", "-1")
        .put("anterior al ultimo", "-1")
        .put("anterior a la ultima", "-1")
        .put("anterior al último", "-1")
        .put("anterior a la última", "-1")
        .build();

    public static final ImmutableMap<String, String> RelativeReferenceRelativeToMap = ImmutableMap.<String, String>builder()
        .put("proxima", "current")
        .put("proximo", "current")
        .put("proximas", "current")
        .put("proximos", "current")
        .put("próxima", "current")
        .put("próximo", "current")
        .put("próximas", "current")
        .put("próximos", "current")
        .put("anterior", "current")
        .put("anteriores", "current")
        .put("actual", "current")
        .put("actuales", "current")
        .put("siguiente", "current")
        .put("siguientes", "current")
        .put("ultima", "end")
        .put("ultimo", "end")
        .put("última", "end")
        .put("último", "end")
        .put("ultimas", "end")
        .put("ultimos", "end")
        .put("últimas", "end")
        .put("últimos", "end")
        .put("penultima", "end")
        .put("penultimo", "end")
        .put("penúltima", "end")
        .put("penúltimo", "end")
        .put("penultimas", "end")
        .put("penultimos", "end")
        .put("penúltimas", "end")
        .put("penúltimos", "end")
        .put("antepenultima", "end")
        .put("antepenultimo", "end")
        .put("antepenúltima", "end")
        .put("antepenúltimo", "end")
        .put("antepenultimas", "end")
        .put("antepenultimos", "end")
        .put("antepenúltimas", "end")
        .put("antepenúltimos", "end")
        .put("antes de la ultima", "end")
        .put("antes del ultimo", "end")
        .put("antes de la última", "end")
        .put("antes del último", "end")
        .put("anterior al ultimo", "end")
        .put("anterior a la ultima", "end")
        .put("anterior al último", "end")
        .put("anterior a la última", "end")
        .build();
}
