// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.number.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class FrenchNumeric {

    public static final String LangMarker = "Fre";

    public static final Boolean CompoundNumberLanguage = false;

    public static final Boolean MultiDecimalSeparatorCulture = true;

    public static final String RoundNumberIntegerRegex = "(cent|mille|millions?|milliards?|billions?)";

    public static final String ZeroToNineIntegerRegex = "(une?|deux|trois|quatre|cinq|six|sept|huit|neuf|z[ée]ro)";

    public static final String TwoToNineIntegerRegex = "(deux|trois|quatre|cinq|six|sept|huit|neuf)";

    public static final String TenToNineteenIntegerRegex = "((seize|quinze|quatorze|treize|douze|onze)|dix(\\Wneuf|\\Whuit|\\Wsept)?)";

    public static final String TensNumberIntegerRegex = "(quatre\\Wvingt(s|\\Wdix)?|soixante(\\Wdix)?|vingt|trente|quarante|cinquante|septante|octante|huitante|nonante)";

    public static final String DigitsNumberRegex = "\\d|\\d{1,3}(\\.\\d{3})";

    public static final String NegativeNumberTermsRegex = "^[.]";

    public static final String NegativeNumberSignRegex = "^({NegativeNumberTermsRegex}\\s+).*"
            .replace("{NegativeNumberTermsRegex}", NegativeNumberTermsRegex);

    public static final String HundredsNumberIntegerRegex = "(({ZeroToNineIntegerRegex}(\\s+cent))|cent|((\\s+cent\\s)+{TensNumberIntegerRegex}))"
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex)
            .replace("{TensNumberIntegerRegex}", TensNumberIntegerRegex);

    public static final String BelowHundredsRegex = "(({TenToNineteenIntegerRegex}|({TensNumberIntegerRegex}((-|(\\s+et)?\\s+)({TenToNineteenIntegerRegex}|{ZeroToNineIntegerRegex}))?))|{ZeroToNineIntegerRegex})"
            .replace("{TenToNineteenIntegerRegex}", TenToNineteenIntegerRegex)
            .replace("{TensNumberIntegerRegex}", TensNumberIntegerRegex)
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex);

    public static final String BelowThousandsRegex = "(({HundredsNumberIntegerRegex}(\\s+{BelowHundredsRegex})?|{BelowHundredsRegex}|{TenToNineteenIntegerRegex})|cent\\s+{TenToNineteenIntegerRegex})"
            .replace("{HundredsNumberIntegerRegex}", HundredsNumberIntegerRegex)
            .replace("{BelowHundredsRegex}", BelowHundredsRegex)
            .replace("{TenToNineteenIntegerRegex}", TenToNineteenIntegerRegex);

    public static final String SupportThousandsRegex = "(({BelowThousandsRegex}|{BelowHundredsRegex})\\s+{RoundNumberIntegerRegex}(\\s+{RoundNumberIntegerRegex})?)"
            .replace("{BelowThousandsRegex}", BelowThousandsRegex)
            .replace("{BelowHundredsRegex}", BelowHundredsRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String SeparaIntRegex = "({SupportThousandsRegex}(\\s+{SupportThousandsRegex})*(\\s+{BelowThousandsRegex})?|{BelowThousandsRegex})"
            .replace("{SupportThousandsRegex}", SupportThousandsRegex)
            .replace("{BelowThousandsRegex}", BelowThousandsRegex);

    public static final String AllIntRegex = "({SeparaIntRegex}|mille(\\s+{BelowThousandsRegex})?)"
            .replace("{SeparaIntRegex}", SeparaIntRegex)
            .replace("{BelowThousandsRegex}", BelowThousandsRegex);

    public static String NumbersWithPlaceHolder(String placeholder) {
        return "(((?<!\\d+\\s*)-\\s*)|(?<=\\b))\\d+(?!([,\\.]\\d+[a-zA-Z]))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static final String NumbersWithSuffix = "(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)"
            .replace("{BaseNumbers.NumberMultiplierRegex}", BaseNumbers.NumberMultiplierRegex);

    public static final String RoundNumberIntegerRegexWithLocks = "(?<=\\b)({DigitsNumberRegex})+\\s+{RoundNumberIntegerRegex}(?=\\b)"
            .replace("{DigitsNumberRegex}", DigitsNumberRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String NumbersWithDozenSuffix = "(((?<!\\d+\\s*)-\\s*)|(?<=\\b))\\d+\\s+douzaine(s)?(?=\\b)";

    public static final String AllIntRegexWithLocks = "((?<=\\b){AllIntRegex}(?=\\b))"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String AllIntRegexWithDozenSuffixLocks = "(?<=\\b)(((demi\\s+)?\\s+douzaine)|({AllIntRegex}\\s+douzaines?))(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String SimpleRoundOrdinalRegex = "(centi|[bm]illioni|milli(ardi)?)[eè]me";

    public static final String OneToNineOrdinalRegex = "(premi[eè]re?|second[e]|tier(s|ce)|(deuxi|troisi|quatri|cinqui|sixi|septi|hui[tr]i|neuvi)[eè]me)";

    public static final String SpecialUnderHundredOrdinalRegex = "(di[xz]i|onzi|douzi|treizi|quatorzi|quinzi|seizi|dix[\\s-](septi|huiri|neuvi))[eè]me";

    public static final String TensOrdinalRegex = "(quatre-vingt-di[xz]i[eè]me|quatre-vingti[eè]me|huitanti[eè]me|octanti[eè]me|soixante-dixi[eè]me|septanti[eè]me|soixanti[eè]me|cinquanti[eè]me|quaranti[eè]me|trenti[eè]me|vingti[eè]me)";

    public static final String HundredOrdinalRegex = "({AllIntRegex}(\\s+(centi[eè]me)))"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String UnderHundredOrdinalRegex = "(((({AllIntRegex}|{TensNumberIntegerRegex})(\\W)?)?({OneToNineOrdinalRegex}|\\s+et\\s+uni[eè]me))|{SpecialUnderHundredOrdinalRegex}|{TensOrdinalRegex})"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{OneToNineOrdinalRegex}", OneToNineOrdinalRegex)
            .replace("{TensNumberIntegerRegex}", TensNumberIntegerRegex)
            .replace("{TensOrdinalRegex}", TensOrdinalRegex)
            .replace("{SpecialUnderHundredOrdinalRegex}", SpecialUnderHundredOrdinalRegex);

    public static final String UnderThousandOrdinalRegex = "((({HundredOrdinalRegex}(\\s|-)?)?{UnderHundredOrdinalRegex})|(({AllIntRegex}(\\W)?)?{SimpleRoundOrdinalRegex})|{HundredOrdinalRegex})"
            .replace("{HundredOrdinalRegex}", HundredOrdinalRegex)
            .replace("{UnderHundredOrdinalRegex}", UnderHundredOrdinalRegex)
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{SimpleRoundOrdinalRegex}", SimpleRoundOrdinalRegex);

    public static final String OverThousandOrdinalRegex = "(({AllIntRegex})(-i[eè]me))"
            .replace("{AllIntRegex}", AllIntRegex);

    public static final String RelativeOrdinalRegex = "(?<relativeOrdinal>prochain[es]?|pr[eé]c[eé]dent[es]?|(l[’'])?actuel(le)?(\\s+une?)?|(l[’'])?avant(\\s+|-)derniere?|(ant[eé])?p[eé]nulti[eè]me|derni[eè]r[es]?|suivant[es]?|courant[es]?|cel(le|ui)\\s+d['’]avant\\s+l[ae]\\s+derni[èe]re?)";

    public static final String ComplexOrdinalRegex = "(({OverThousandOrdinalRegex}(\\s)?)?{UnderThousandOrdinalRegex}|{OverThousandOrdinalRegex}|{UnderHundredOrdinalRegex})"
            .replace("{OverThousandOrdinalRegex}", OverThousandOrdinalRegex)
            .replace("{UnderThousandOrdinalRegex}", UnderThousandOrdinalRegex)
            .replace("{UnderHundredOrdinalRegex}", UnderHundredOrdinalRegex);

    public static final String SuffixOrdinalRegex = "(({AllIntRegex})({SimpleRoundOrdinalRegex}))"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{SimpleRoundOrdinalRegex}", SimpleRoundOrdinalRegex);

    public static final String ComplexRoundOrdinalRegex = "((({SuffixOrdinalRegex}(\\s)?)?{ComplexOrdinalRegex})|{SuffixOrdinalRegex})"
            .replace("{SuffixOrdinalRegex}", SuffixOrdinalRegex)
            .replace("{ComplexOrdinalRegex}", ComplexOrdinalRegex);

    public static final String AllOrdinalNumberRegex = "({ComplexOrdinalRegex}|{SimpleRoundOrdinalRegex}|{ComplexRoundOrdinalRegex})"
            .replace("{ComplexOrdinalRegex}", ComplexOrdinalRegex)
            .replace("{SimpleRoundOrdinalRegex}", SimpleRoundOrdinalRegex)
            .replace("{ComplexRoundOrdinalRegex}", ComplexRoundOrdinalRegex);

    public static final String AllOrdinalRegex = "(?:{AllOrdinalNumberRegex}|{RelativeOrdinalRegex})"
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{RelativeOrdinalRegex}", RelativeOrdinalRegex);

    public static final String PlaceHolderPureNumber = "\\b";

    public static final String PlaceHolderDefault = "\\D|\\b";

    public static final String OrdinalSuffixRegex = "(?<=\\b)((\\d*(11e(me)?|1[eè]re?|[02-9]e(me)?)))(?=\\b)";

    public static final String OrdinalFrenchRegex = "(?<=\\b){AllOrdinalRegex}(?=\\b)"
            .replace("{AllOrdinalRegex}", AllOrdinalRegex);

    public static final String FractionNotationWithSpacesRegex = "(((?<=\\W|^)-\\s*)|(?<=\\b))\\d+\\s+\\d+[/]\\d+(?=(\\b[^/]|$))";

    public static final String FractionNotationRegex = "{BaseNumbers.FractionNotationRegex}"
            .replace("{BaseNumbers.FractionNotationRegex}", BaseNumbers.FractionNotationRegex);

    public static final String FractionMultiplierRegex = "(?<fracMultiplier>\\s+et\\s+(demi[es]?|(une?|{TwoToNineIntegerRegex})\\s+(demie?|tier|quart|(cinqui|sixi|septi|hui[tr]i|neuvi|dixi)[eè]me)s?))"
            .replace("{TwoToNineIntegerRegex}", TwoToNineIntegerRegex);

    public static final String RoundMultiplierWithFraction = "(?<multiplier>(millions?|milliards?|billions?))(?={FractionMultiplierRegex}?$)"
            .replace("{FractionMultiplierRegex}", FractionMultiplierRegex);

    public static final String RoundMultiplierRegex = "\\b\\s*({RoundMultiplierWithFraction}|(?<multiplier>(cent|mille))$)"
            .replace("{RoundMultiplierWithFraction}", RoundMultiplierWithFraction);

    public static final String FractionNounRegex = "(?<=\\b)({AllIntRegex}\\s+((et)\\s+)?)?({AllIntRegex}(\\s+((et)\\s)?)(({AllOrdinalNumberRegex}s?|{SuffixOrdinalRegex}s?)|(demi[es]?|tiers?|quarts?))|(un\\s+)?(demi|tier|quart)(\\s+(de\\s+)?|\\s*-\\s*){RoundNumberIntegerRegex})(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{SuffixOrdinalRegex}", SuffixOrdinalRegex)
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String FractionNounWithArticleRegex = "(?<=\\b)(({AllIntRegex}|{RoundNumberIntegerRegexWithLocks})\\s+(et\\s+)?)?((une?)(\\s+)(({AllOrdinalNumberRegex})|({SuffixOrdinalRegex})|(et\\s+)?demi[es]?)|demi[es]?)(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllOrdinalNumberRegex}", AllOrdinalNumberRegex)
            .replace("{SuffixOrdinalRegex}", SuffixOrdinalRegex)
            .replace("{RoundNumberIntegerRegexWithLocks}", RoundNumberIntegerRegexWithLocks);

    public static final String FractionPrepositionRegex = "(?<!{BaseNumbers.CommonCurrencySymbol}\\s*)(?<=\\b)(?<numerator>({AllIntRegex})|((?<!\\.)\\d+))\\s+sur\\s+(?<denominator>({AllIntRegex})|((\\d+)(?!\\.)))(?=\\b)"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{BaseNumbers.CommonCurrencySymbol}", BaseNumbers.CommonCurrencySymbol);

    public static final String AllPointRegex = "((\\s+{ZeroToNineIntegerRegex})+|(\\s+{SeparaIntRegex}))"
            .replace("{ZeroToNineIntegerRegex}", ZeroToNineIntegerRegex)
            .replace("{SeparaIntRegex}", SeparaIntRegex);

    public static final String AllFloatRegex = "({AllIntRegex}(\\s+(virgule|point)){AllPointRegex})"
            .replace("{AllIntRegex}", AllIntRegex)
            .replace("{AllPointRegex}", AllPointRegex);

    public static String DoubleDecimalPointRegex(String placeholder) {
        return "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[,\\.])))\\d+[,\\.]\\d+(?!([,\\.]\\d+))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static String DoubleWithoutIntegralRegex(String placeholder) {
        return "(?<=\\s|^)(?<!(\\d+))[,\\.]\\d+(?!([,\\.]\\d+))(?={placeholder})"
            .replace("{placeholder}", placeholder);
    }

    public static final String DoubleWithMultiplierRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\[,\\.])))\\d+[,\\.]\\d+\\s*{BaseNumbers.NumberMultiplierRegex}(?=\\b)"
            .replace("{BaseNumbers.NumberMultiplierRegex}", BaseNumbers.NumberMultiplierRegex);

    public static final String DoubleWithRoundNumber = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+\\[,\\.])))\\d+[,\\.]\\d+\\s+{RoundNumberIntegerRegex}(?=\\b)"
            .replace("{RoundNumberIntegerRegex}", RoundNumberIntegerRegex);

    public static final String DoubleAllFloatRegex = "((?<=\\b){AllFloatRegex}(?=\\b))"
            .replace("{AllFloatRegex}", AllFloatRegex);

    public static final String DoubleExponentialNotationRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[,\\.])))(\\d+([,\\.]\\d+)?)e([+-]*[1-9]\\d*)(?=\\b)";

    public static final String DoubleCaretExponentialNotationRegex = "(((?<!\\d+\\s*)-\\s*)|((?<=\\b)(?<!\\d+[,\\.])))(\\d+([,\\.]\\d+)?)\\^([+-]*[1-9]\\d*)(?=\\b)";

    public static final String NumberWithSuffixPercentage = "(?<!%)({BaseNumbers.NumberReplaceToken})(\\s*)(%(?!{BaseNumbers.NumberReplaceToken})|(pourcent(s|ages?)?)\\b)"
            .replace("{BaseNumbers.NumberReplaceToken}", BaseNumbers.NumberReplaceToken);

    public static final String NumberWithPrefixPercentage = "((?<!{BaseNumbers.NumberReplaceToken})%|pourcent|pourcent des|pourcentage de)(\\s*)({BaseNumbers.NumberReplaceToken})(?=\\s|$)"
            .replace("{BaseNumbers.NumberReplaceToken}", BaseNumbers.NumberReplaceToken);

    public static final String TillRegex = "((?<!\\b[èe]ga(l(es)?|ux)\\s+)[àa]|--|-|—|——|~|–)";

    public static final String MoreRegex = "(?:(bigger|greater|more|plus(\\s+(haut|grand|âgée?))?|sup[ée]rieure?s?)(\\s+([àa]|que))?|dépassant|(au-dessus|(a\\s+)?plus|dépassant|au-delà)\\s+d[e'’]|exceed(ed|ing)?|(?<!<|=)>)";

    public static final String LessRegex = "(?:(less|plus\\s+(bas|petit|jeune)|moins|inf[ée]rieure?s?)(\\s+([àa]|d[e'’]|que))?|((en )?dessous)\\s+de|under|(?<!>|=)<)";

    public static final String EqualRegex = "(([ée]ga(l(es)?|ux)|au\\s+nombre)(\\s+([àa]|d[e'’]))?|(?<!<|>)=)";

    public static final String MoreOrEqualPrefix = "((pas\\s+{LessRegex})|(au\\s+moins|[àa] partir d[e'’]))"
            .replace("{LessRegex}", LessRegex);

    public static final String MoreOrEqual = "(?:({MoreRegex}\\s+(ou)?\\s+{EqualRegex})|({EqualRegex}\\s+(ou)?\\s+{MoreRegex})|{MoreOrEqualPrefix}(\\s+(ou)?\\s+{EqualRegex})?|({EqualRegex}\\s+(ou)?\\s+)?{MoreOrEqualPrefix}|>\\s*=|≥)"
            .replace("{MoreRegex}", MoreRegex)
            .replace("{EqualRegex}", EqualRegex)
            .replace("{LessRegex}", LessRegex)
            .replace("{MoreOrEqualPrefix}", MoreOrEqualPrefix);

    public static final String MoreOrEqualSuffix = "((et|ou)\\s+(((more|greater|higher|plus(\\s+grand)?|sup[ée]rieure?s?)((?!\\s+([àa]|que))|(\\s+([àa]|que)(?!((\\s+ou\\s+[èe]ga(l(es)?|ux)\\s+[àa])?\\s*\\d+)))))|((a plus|au-dessus)\\s+d[e'’](?!\\s+than))))";

    public static final String LessOrEqualPrefix = "((pas\\s+{MoreRegex})|(au\\s+plus)|(jusqu'[àa]))"
            .replace("{MoreRegex}", MoreRegex);

    public static final String LessOrEqual = "(({LessRegex}\\s+(ou)?\\s+{EqualRegex})|({EqualRegex}\\s+(ou)?\\s+{LessRegex})|{LessOrEqualPrefix}(\\s+(ou)?\\s+{EqualRegex})?|({EqualRegex}\\s+(ou)?\\s+)?{LessOrEqualPrefix}|<\\s*=|≤)"
            .replace("{LessRegex}", LessRegex)
            .replace("{EqualRegex}", EqualRegex)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{LessOrEqualPrefix}", LessOrEqualPrefix);

    public static final String LessOrEqualSuffix = "((et|ou)\\s+(less|lower|plus petit|moins|inf[ée]rieure?s?)((?!\\s+([àa]|de|que))|(\\s+([àa]|d[e'’]|que)(?!(\\s*\\d+)))))";

    public static final String NumberSplitMark = "(?![,.](?!\\d+))(?!\\s*\\b(et\\s+({LessRegex}|{MoreRegex})|mais|ou|to)\\b)"
            .replace("{MoreRegex}", MoreRegex)
            .replace("{LessRegex}", LessRegex);

    public static final String MoreRegexNoNumberSucceed = "((bigger|greater|more|plus(\\s+grand)?|sup[ée]rieure?s?)((?!\\s+([àa]|que))|\\s+(([àa]|que)(?!(\\s*\\d+))))|((au-dessus|a plus)\\s+d[e'’])(?!(\\s*\\d+)))";

    public static final String LessRegexNoNumberSucceed = "((less|lower|plus petit|moins|inf[ée]rieure?s?)((?!\\s+([àa]|d[e'’]|que))|\\s+(([àa]|d[e'’]|que)(?!(\\s*\\d+))))|(((en )?dessous)\\s+d[e'’]|under)(?!(\\s*\\d+)))";

    public static final String EqualRegexNoNumberSucceed = "([èe]ga(l(es)?|ux)((?!\\s+([àa]))|(\\s+([àa]|que)(?!(\\s*\\d+)))))";

    public static final String OneNumberRangeMoreRegex1 = "({MoreOrEqual}|{MoreRegex})\\s*(l[ae]\\s+)?(?<number1>({NumberSplitMark}.)+)"
            .replace("{MoreOrEqual}", MoreOrEqual)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeMoreRegex1LB = "(?<!pas\\s+){OneNumberRangeMoreRegex1}"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1);

    public static final String OneNumberRangeMoreRegex2 = "(?<number1>({NumberSplitMark}.)+)\\s*{MoreOrEqualSuffix}"
            .replace("{MoreOrEqualSuffix}", MoreOrEqualSuffix)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeMoreSeparateRegex = "({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+ou\\s+){MoreRegexNoNumberSucceed})|({MoreRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+ou\\s+){EqualRegexNoNumberSucceed})"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{MoreRegex}", MoreRegex)
            .replace("{EqualRegexNoNumberSucceed}", EqualRegexNoNumberSucceed)
            .replace("{MoreRegexNoNumberSucceed}", MoreRegexNoNumberSucceed)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessRegex1 = "({LessOrEqual}|{LessRegex})\\s*(l[ae]\\s+)?(?<number2>({NumberSplitMark}.)+)"
            .replace("{LessOrEqual}", LessOrEqual)
            .replace("{LessRegex}", LessRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessRegex1LB = "(?<!pas\\s+){OneNumberRangeLessRegex1}"
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1);

    public static final String OneNumberRangeLessRegex2 = "(?<number2>({NumberSplitMark}.)+)\\s*{LessOrEqualSuffix}"
            .replace("{LessOrEqualSuffix}", LessOrEqualSuffix)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeLessSeparateRegex = "({EqualRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+ou\\s+){LessRegexNoNumberSucceed})|({LessRegex}\\s+(?<number1>({NumberSplitMark}.)+)(\\s+ou\\s+){EqualRegexNoNumberSucceed})"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{LessRegex}", LessRegex)
            .replace("{EqualRegexNoNumberSucceed}", EqualRegexNoNumberSucceed)
            .replace("{LessRegexNoNumberSucceed}", LessRegexNoNumberSucceed)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String OneNumberRangeEqualRegex = "(?<!\\b([àa]|que)\\s+ou\\s+){EqualRegex}\\s*(l[ae]\\s+)?(?<number1>({NumberSplitMark}.)+)"
            .replace("{EqualRegex}", EqualRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String TwoNumberRangeRegex1 = "entre\\s*(l[ae]\\s+)?(?<number1>({NumberSplitMark}.)+)\\s*et\\s*(l[ae]\\s+)?(?<number2>({NumberSplitMark}.)+)"
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final String TwoNumberRangeRegex2 = "({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})\\s*(et|mais|,)\\s*({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1)
            .replace("{OneNumberRangeMoreRegex2}", OneNumberRangeMoreRegex2)
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1)
            .replace("{OneNumberRangeLessRegex2}", OneNumberRangeLessRegex2);

    public static final String TwoNumberRangeRegex3 = "({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})\\s*(et|mais|,)\\s*({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})"
            .replace("{OneNumberRangeMoreRegex1}", OneNumberRangeMoreRegex1)
            .replace("{OneNumberRangeMoreRegex2}", OneNumberRangeMoreRegex2)
            .replace("{OneNumberRangeLessRegex1}", OneNumberRangeLessRegex1)
            .replace("{OneNumberRangeLessRegex2}", OneNumberRangeLessRegex2);

    public static final String TwoNumberRangeRegex4 = "(de\\s+)?(?<number1>({NumberSplitMark}(?!\\bde\\b).)+)\\s*{TillRegex}\\s*(l[ae]\\s+)?(?<number2>({NumberSplitMark}.)+)"
            .replace("{TillRegex}", TillRegex)
            .replace("{NumberSplitMark}", NumberSplitMark);

    public static final Character DecimalSeparatorChar = ',';

    public static final String FractionMarkerToken = "sur";

    public static final Character NonDecimalSeparatorChar = '.';

    public static final String HalfADozenText = "six";

    public static final String WordSeparatorToken = "et";

    public static final List<String> WrittenDecimalSeparatorTexts = Arrays.asList("virgule");

    public static final List<String> WrittenGroupSeparatorTexts = Arrays.asList("point", "points");

    public static final List<String> WrittenIntegerSeparatorTexts = Arrays.asList("et", "-");

    public static final List<String> WrittenFractionSeparatorTexts = Arrays.asList("et", "sur");

    public static final List<String> OneHalfTokens = Arrays.asList("un", "demi");

    public static final String HalfADozenRegex = "(?<=\\b)demie?\\s+douzaine";

    public static final String DigitalNumberRegex = "((?<=\\b)(cent|mille|millions?|milliards?|billions?|douzaines?)(?=\\b))|((?<=(\\d|\\b)){BaseNumbers.MultiplierLookupRegex}(?=\\b))"
            .replace("{BaseNumbers.MultiplierLookupRegex}", BaseNumbers.MultiplierLookupRegex);

    public static final String AmbiguousFractionConnectorsRegex = "^[.]";

    public static final ImmutableMap<String, Long> CardinalNumberMap = ImmutableMap.<String, Long>builder()
        .put("zéro", 0L)
        .put("zero", 0L)
        .put("un", 1L)
        .put("une", 1L)
        .put("deux", 2L)
        .put("trois", 3L)
        .put("quatre", 4L)
        .put("cinq", 5L)
        .put("six", 6L)
        .put("sept", 7L)
        .put("huit", 8L)
        .put("neuf", 9L)
        .put("dix", 10L)
        .put("onze", 11L)
        .put("douze", 12L)
        .put("douzaine", 12L)
        .put("douzaines", 12L)
        .put("treize", 13L)
        .put("quatorze", 14L)
        .put("quinze", 15L)
        .put("seize", 16L)
        .put("dix-sept", 17L)
        .put("dix-huit", 18L)
        .put("dix-huir", 18L)
        .put("dix-neuf", 19L)
        .put("vingt", 20L)
        .put("trente", 30L)
        .put("quarante", 40L)
        .put("cinquante", 50L)
        .put("soixante", 60L)
        .put("soixante-dix", 70L)
        .put("septante", 70L)
        .put("quatre-vingts", 80L)
        .put("quatre-vingt", 80L)
        .put("quatre vingts", 80L)
        .put("quatre vingt", 80L)
        .put("quatre-vingt-dix", 90L)
        .put("quatre-vingt dix", 90L)
        .put("quatre vingt dix", 90L)
        .put("quatre-vingts-dix", 90L)
        .put("quatre-vingts-onze", 91L)
        .put("quatre-vingt-onze", 91L)
        .put("quatre-vingts-douze", 92L)
        .put("quatre-vingt-douze", 92L)
        .put("quatre-vingts-treize", 93L)
        .put("quatre-vingt-treize", 93L)
        .put("quatre-vingts-quatorze", 94L)
        .put("quatre-vingt-quatorze", 94L)
        .put("quatre-vingts-quinze", 95L)
        .put("quatre-vingt-quinze", 95L)
        .put("quatre-vingts-seize", 96L)
        .put("quatre-vingt-seize", 96L)
        .put("huitante", 80L)
        .put("octante", 80L)
        .put("nonante", 90L)
        .put("cent", 100L)
        .put("mille", 1000L)
        .put("un million", 1000000L)
        .put("million", 1000000L)
        .put("millions", 1000000L)
        .put("un milliard", 1000000000L)
        .put("milliard", 1000000000L)
        .put("milliards", 1000000000L)
        .put("un mille milliards", 1000000000000L)
        .put("un billion", 1000000000000L)
        .build();

    public static final ImmutableMap<String, Long> OrdinalNumberMap = ImmutableMap.<String, Long>builder()
        .put("premier", 1L)
        .put("première", 1L)
        .put("premiere", 1L)
        .put("unième", 1L)
        .put("unieme", 1L)
        .put("deuxième", 2L)
        .put("deuxieme", 2L)
        .put("second", 2L)
        .put("seconde", 2L)
        .put("troisième", 3L)
        .put("demi", 2L)
        .put("demie", 2L)
        .put("tiers", 3L)
        .put("tierce", 3L)
        .put("quart", 4L)
        .put("quarts", 4L)
        .put("troisieme", 3L)
        .put("quatrième", 4L)
        .put("quatrieme", 4L)
        .put("cinquième", 5L)
        .put("cinquieme", 5L)
        .put("sixième", 6L)
        .put("sixieme", 6L)
        .put("septième", 7L)
        .put("septieme", 7L)
        .put("huitième", 8L)
        .put("huitieme", 8L)
        .put("huirième", 8L)
        .put("huirieme", 8L)
        .put("neuvième", 9L)
        .put("neuvieme", 9L)
        .put("dixième", 10L)
        .put("dixieme", 10L)
        .put("dizième", 10L)
        .put("dizieme", 10L)
        .put("onzième", 11L)
        .put("onzieme", 11L)
        .put("douzième", 12L)
        .put("douzieme", 12L)
        .put("treizième", 13L)
        .put("treizieme", 13L)
        .put("quatorzième", 14L)
        .put("quatorzieme", 14L)
        .put("quinzième", 15L)
        .put("quinzieme", 15L)
        .put("seizième", 16L)
        .put("seizieme", 16L)
        .put("dix-septième", 17L)
        .put("dix-septieme", 17L)
        .put("dix-huitième", 18L)
        .put("dix-huitieme", 18L)
        .put("dix-huirième", 18L)
        .put("dix-huirieme", 18L)
        .put("dix-neuvième", 19L)
        .put("dix-neuvieme", 19L)
        .put("vingtième", 20L)
        .put("vingtieme", 20L)
        .put("trentième", 30L)
        .put("trentieme", 30L)
        .put("quarantième", 40L)
        .put("quarantieme", 40L)
        .put("cinquantième", 50L)
        .put("cinquantieme", 50L)
        .put("soixantième", 60L)
        .put("soixantieme", 60L)
        .put("soixante-dixième", 70L)
        .put("soixante-dixieme", 70L)
        .put("septantième", 70L)
        .put("septantieme", 70L)
        .put("quatre-vingtième", 80L)
        .put("quatre-vingtieme", 80L)
        .put("huitantième", 80L)
        .put("huitantieme", 80L)
        .put("octantième", 80L)
        .put("octantieme", 80L)
        .put("quatre-vingt-dixième", 90L)
        .put("quatre-vingt-dixieme", 90L)
        .put("nonantième", 90L)
        .put("nonantieme", 90L)
        .put("centième", 100L)
        .put("centieme", 100L)
        .put("millième", 1000L)
        .put("millieme", 1000L)
        .put("millionième", 1000000L)
        .put("millionieme", 1000000L)
        .put("milliardième", 1000000000L)
        .put("milliardieme", 1000000000L)
        .put("billionieme", 1000000000000L)
        .put("billionième", 1000000000000L)
        .put("trillionième", 1000000000000000000L)
        .put("trillionieme", 1000000000000000000L)
        .build();

    public static final ImmutableMap<String, Long> PrefixCardinalMap = ImmutableMap.<String, Long>builder()
        .put("deux", 2L)
        .put("trois", 3L)
        .put("quatre", 4L)
        .put("cinq", 5L)
        .put("six", 6L)
        .put("sept", 7L)
        .put("huit", 8L)
        .put("neuf", 9L)
        .put("dix", 10L)
        .put("onze", 11L)
        .put("douze", 12L)
        .put("treize", 13L)
        .put("quatorze", 14L)
        .put("quinze", 15L)
        .put("seize", 16L)
        .put("dix sept", 17L)
        .put("dix-sept", 17L)
        .put("dix-huit", 18L)
        .put("dix huit", 18L)
        .put("dix-neuf", 19L)
        .put("dix neuf", 19L)
        .put("vingt", 20L)
        .put("vingt-et-un", 21L)
        .put("vingt et un", 21L)
        .put("vingt-deux", 21L)
        .put("vingt deux", 22L)
        .put("vingt-trois", 23L)
        .put("vingt trois", 23L)
        .put("vingt-quatre", 24L)
        .put("vingt quatre", 24L)
        .put("vingt-cinq", 25L)
        .put("vingt cinq", 25L)
        .put("vingt-six", 26L)
        .put("vingt six", 26L)
        .put("vingt-sept", 27L)
        .put("vingt sept", 27L)
        .put("vingt-huit", 28L)
        .put("vingt huit", 28L)
        .put("vingt-neuf", 29L)
        .put("vingt neuf", 29L)
        .put("trente", 30L)
        .put("quarante", 40L)
        .put("cinquante", 50L)
        .put("soixante", 60L)
        .put("soixante-dix", 70L)
        .put("soixante dix", 70L)
        .put("septante", 70L)
        .put("quatre-vingt", 80L)
        .put("quatre vingt", 80L)
        .put("huitante", 80L)
        .put("octante", 80L)
        .put("nonante", 90L)
        .put("quatre vingt dix", 90L)
        .put("quatre-vingt-dix", 90L)
        .put("cent", 100L)
        .put("deux cent", 200L)
        .put("trois cents", 300L)
        .put("quatre cents", 400L)
        .put("cinq cent", 500L)
        .put("six cent", 600L)
        .put("sept cent", 700L)
        .put("huit cent", 800L)
        .put("neuf cent", 900L)
        .build();

    public static final ImmutableMap<String, Long> SuffixOrdinalMap = ImmutableMap.<String, Long>builder()
        .put("millième", 1000L)
        .put("million", 1000000L)
        .put("milliardième", 1000000000000L)
        .build();

    public static final ImmutableMap<String, Long> RoundNumberMap = ImmutableMap.<String, Long>builder()
        .put("cent", 100L)
        .put("mille", 1000L)
        .put("million", 1000000L)
        .put("millions", 1000000L)
        .put("milliard", 1000000000L)
        .put("milliards", 1000000000L)
        .put("billion", 1000000000000L)
        .put("billions", 1000000000000L)
        .put("centieme", 100L)
        .put("centième", 100L)
        .put("millieme", 1000L)
        .put("millième", 1000L)
        .put("millionième", 1000000L)
        .put("millionieme", 1000000L)
        .put("milliardième", 1000000000L)
        .put("milliardieme", 1000000000L)
        .put("billionième", 1000000000000L)
        .put("billionieme", 1000000000000L)
        .put("centiemes", 100L)
        .put("centièmes", 100L)
        .put("millièmes", 1000L)
        .put("milliemes", 1000L)
        .put("millionièmes", 1000000L)
        .put("millioniemes", 1000000L)
        .put("milliardièmes", 1000000000L)
        .put("milliardiemes", 1000000000L)
        .put("billionièmes", 1000000000000L)
        .put("billioniemes", 1000000000000L)
        .put("douzaine", 12L)
        .put("douzaines", 12L)
        .put("k", 1000L)
        .put("m", 1000000L)
        .put("g", 1000000000L)
        .put("b", 1000000000L)
        .put("t", 1000000000000L)
        .build();

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "")
        .build();

    public static final ImmutableMap<String, String> RelativeReferenceOffsetMap = ImmutableMap.<String, String>builder()
        .put("prochain", "1")
        .put("prochaine", "1")
        .put("prochains", "1")
        .put("precedent", "-1")
        .put("precedente", "-1")
        .put("precédent", "-1")
        .put("precédente", "-1")
        .put("précedent", "-1")
        .put("précedente", "-1")
        .put("précédent", "-1")
        .put("précédente", "-1")
        .put("actuel", "0")
        .put("actuelle", "0")
        .put("actuel un", "0")
        .put("actuelle une", "0")
        .put("l'actuel", "0")
        .put("l'actuelle", "0")
        .put("l’actuel", "0")
        .put("l’actuelle", "0")
        .put("l'actuel un", "0")
        .put("l'actuelle une", "0")
        .put("l’actuel un", "0")
        .put("l’actuelle une", "0")
        .put("avant dernier", "-1")
        .put("avant derniere", "-1")
        .put("avant-dernier", "-1")
        .put("avant-derniere", "-1")
        .put("l'avant dernier", "-1")
        .put("l'avant derniere", "-1")
        .put("l'avant-dernier", "-1")
        .put("l'avant-derniere", "-1")
        .put("l’avant dernier", "-1")
        .put("l’avant derniere", "-1")
        .put("l’avant-dernier", "-1")
        .put("l’avant-derniere", "-1")
        .put("celle d'avant la dernière", "-1")
        .put("celui d'avant le dernièr", "-1")
        .put("celle d'avant la derniere", "-1")
        .put("celui d'avant le dernier", "-1")
        .put("celle d’avant la dernière", "-1")
        .put("celui d’avant le dernièr", "-1")
        .put("celle d’avant la derniere", "-1")
        .put("celui d’avant le dernier", "-1")
        .put("penultieme", "-1")
        .put("penultième", "-1")
        .put("pénultieme", "-1")
        .put("pénultième", "-1")
        .put("antepenultieme", "-2")
        .put("antépenultieme", "-2")
        .put("antepenultième", "-2")
        .put("antépenultième", "-2")
        .put("antepénultieme", "-2")
        .put("antépénultieme", "-2")
        .put("antepénultième", "-2")
        .put("antépénultième", "-2")
        .put("dernier", "0")
        .put("dernièr", "0")
        .put("derniere", "0")
        .put("derniers", "0")
        .put("dernière", "0")
        .put("dernièrs", "0")
        .put("suivant", "1")
        .put("suivante", "1")
        .put("suivants", "1")
        .put("courant", "0")
        .put("courante", "0")
        .put("courants", "0")
        .build();

    public static final ImmutableMap<String, String> RelativeReferenceRelativeToMap = ImmutableMap.<String, String>builder()
        .put("prochain", "current")
        .put("prochaine", "current")
        .put("prochains", "current")
        .put("precedent", "current")
        .put("precedente", "current")
        .put("precédent", "current")
        .put("precédente", "current")
        .put("précedent", "current")
        .put("précedente", "current")
        .put("précédent", "current")
        .put("précédente", "current")
        .put("actuel", "current")
        .put("actuelle", "current")
        .put("actuel un", "current")
        .put("actuelle une", "current")
        .put("l'actuel", "current")
        .put("l'actuelle", "current")
        .put("l’actuel", "current")
        .put("l’actuelle", "current")
        .put("l'actuel un", "current")
        .put("l'actuelle une", "current")
        .put("l’actuel un", "current")
        .put("l’actuelle une", "current")
        .put("avant dernier", "end")
        .put("avant-dernier", "end")
        .put("avant derniere", "end")
        .put("avant-derniere", "end")
        .put("l'avant dernier", "end")
        .put("l'avant-dernier", "end")
        .put("l'avant derniere", "end")
        .put("l'avant-derniere", "end")
        .put("l’avant dernier", "end")
        .put("l’avant-dernier", "end")
        .put("l’avant derniere", "end")
        .put("l’avant-derniere", "end")
        .put("celle d'avant la dernière", "end")
        .put("celui d'avant le dernièr", "end")
        .put("celle d'avant la derniere", "end")
        .put("celui d'avant le dernier", "end")
        .put("celle d’avant la dernière", "end")
        .put("celui d’avant le dernièr", "end")
        .put("celle d’avant la derniere", "end")
        .put("celui d’avant le dernier", "end")
        .put("penultieme", "end")
        .put("penultième", "end")
        .put("pénultieme", "end")
        .put("pénultième", "end")
        .put("antepenultieme", "end")
        .put("antépenultieme", "end")
        .put("antepenultième", "end")
        .put("antépenultième", "end")
        .put("antepénultieme", "end")
        .put("antépénultieme", "end")
        .put("antepénultième", "end")
        .put("antépénultième", "end")
        .put("dernier", "end")
        .put("dernièr", "end")
        .put("derniere", "end")
        .put("derniers", "end")
        .put("dernière", "end")
        .put("dernièrs", "end")
        .put("suivant", "current")
        .put("suivante", "current")
        .put("suivants", "current")
        .put("courant", "current")
        .put("courante", "current")
        .put("courants", "current")
        .build();
}
