// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

package com.microsoft.recognizers.text.number;

public class Constants {
    public static final String SYS_NUM_CARDINAL = "builtin.num.cardinal";
    public static final String SYS_NUM_DOUBLE = "builtin.num.double";
    public static final String SYS_NUM_FRACTION = "builtin.num.fraction";
    public static final String SYS_NUM_INTEGER = "builtin.num.integer";
    public static final String SYS_NUM = "builtin.num";
    public static final String SYS_NUM_ORDINAL = "builtin.num.ordinal";
    public static final String SYS_NUM_PERCENTAGE = "builtin.num.percentage";
    public static final String SYS_NUMRANGE = "builtin.num.numberrange";

    // Model type name
    public static final String MODEL_NUMBER = "number";
    public static final String MODEL_NUMBERRANGE = "numberrange";
    public static final String MODEL_ORDINAL = "ordinal";
    public static final String MODEL_PERCENTAGE = "percentage";

    // NARROW NO-BREAK SPACE
    public static final char NO_BREAK_SPACE = '\u202f';

    // Ordinal.relative attribute values
    public static final String RELATIVE_START = "start";
    public static final String RELATIVE_END = "end";
    public static final String RELATIVE_CURRENT = "current";
}
