// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.numberwithunit.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class SpanishNumericWithUnit {

    public static final ImmutableMap<String, String> AgeSuffixList = ImmutableMap.<String, String>builder()
        .put("Año", "años|año")
        .put("Mes", "meses|mes")
        .put("Semana", "semanas|semana")
        .put("Día", "dias|días|día|dia")
        .build();

    public static final List<String> AmbiguousAgeUnitList = Arrays.asList("años", "año", "meses", "mes", "semanas", "semana", "dias", "días", "día", "dia");

    public static final ImmutableMap<String, String> AreaSuffixList = ImmutableMap.<String, String>builder()
        .put("Kilómetro cuadrado", "kilómetro cuadrado|kilómetros cuadrados|km2|km^2|km²")
        .put("Hectómetro cuadrado", "hectómetro cuadrado|hectómetros cuadrados|hm2|hm^2|hm²|hectárea|hectáreas")
        .put("Decámetro cuadrado", "decámetro cuadrado|decámetros cuadrados|dam2|dam^2|dam²|área|áreas")
        .put("Metro cuadrado", "metro cuadrado|metros cuadrados|m2|m^2|m²")
        .put("Decímetro cuadrado", "decímetro cuadrado|decímetros cuadrados|dm2|dm^2|dm²")
        .put("Centímetro cuadrado", "centímetro cuadrado|centímetros cuadrados|cm2|cm^2|cm²")
        .put("Milímetro cuadrado", "milímetro cuadrado|milímetros cuadrados|mm2|mm^2|mm²")
        .put("Pulgada cuadrado", "pulgada cuadrada|pulgadas cuadradas")
        .put("Pie cuadrado", "pie cuadrado|pies cuadrados|pie2|pie^2|pie²|ft2|ft^2|ft²")
        .put("Yarda cuadrado", "yarda cuadrada|yardas cuadradas|yd2|yd^2|yd²")
        .put("Acre", "acre|acres")
        .build();

    public static final List<String> AreaAmbiguousValues = Arrays.asList("área", "áreas");

    public static final ImmutableMap<String, String> CurrencySuffixList = ImmutableMap.<String, String>builder()
        .put("Dólar", "dólar|dólares|dolar|dolares")
        .put("Peso", "peso|pesos")
        .put("Rublo", "rublo|rublos")
        .put("Libra", "libra|libras")
        .put("Florín", "florín|florines")
        .put("Dinar", "dinar|dinares")
        .put("Franco", "franco|francos")
        .put("Rupia", "rupia|rupias")
        .put("Escudo", "escudo|escudos")
        .put("Chelín", "chelín|chelines")
        .put("Lira", "lira|liras")
        .put("Centavo", "centavo|centavos")
        .put("Céntimo", "céntimo|céntimos")
        .put("Centésimo", "centésimo|centésimos")
        .put("Penique", "penique|peniques")
        .put("Euro", "euro|euros|€|eur")
        .put("Céntimo de Euro", "céntimo de euro|céntimos de euros")
        .put("Dólar del Caribe Oriental", "dólar del caribe oriental|dólares del caribe oriental|ec$|xcd")
        .put("Centavo del Caribe Oriental", "centavo del caribe oriental|centavos del caribe oriental")
        .put("Franco CFA de África Occidental", "franco cfa de África occidental|francos cfa de África occidental|fcfa|xof")
        .put("Céntimo de CFA de África Occidental", "céntimo de cfa de África occidental|céntimos de cfa de África occidental")
        .put("Franco CFA de África Central", "franco cfa de África central|francos cfa de África central|xaf")
        .put("Céntimo de CFA de África Central", "céntimo de cfa de África central|céntimos de cfa de África central")
        .put("Apsar", "apsar|apsares")
        .put("Afgani afgano", "afgani afgano|؋|afn|afganis|afgani")
        .put("Pul", "pul|puls")
        .put("Lek albanés", "lek|lekë|lekes|lek albanés")
        .put("Qindarka", "qindarka|qindarkë|qindarkas")
        .put("Kwanza angoleño", "kwanza angoleño|kwanzas angoleños|kwanza angoleños|kwanzas angoleño|kwanzas|aoa|kz")
        .put("Cêntimo angoleño", "cêntimo angoleño|cêntimo|cêntimos")
        .put("Florín antillano neerlandés", "florín antillano neerlandés|florínes antillano neerlandés|ƒ antillano neerlandés|ang|naƒ")
        .put("Cent antillano neerlandés", "cent|centen")
        .put("Riyal saudí", "riyal saudí|riyales saudí|sar")
        .put("Halalá saudí", "halalá saudí|hallalah")
        .put("Dinar argelino", "dinar argelino|dinares argelinos|dzd")
        .put("Céntimo argelino", "centimo argelino|centimos argelinos")
        .put("Peso argentino", "peso argentino|pesos argentinos|ar$|ars")
        .put("Centavo argentino", "centavo argentino|centavos argentinos|ctvo.|ctvos.")
        .put("Dram armenio", "dram armenio|dram armenios|dram|դր.")
        .put("Luma armenio", "luma armenio|luma armenios")
        .put("Florín arubeño", "florín arubeño|florines arubeños|ƒ arubeños|aƒ|awg")
        .put("Yotin arubeño", "yotin arubeño|yotines arubeños")
        .put("Dólar australiano", "dólar australiano|dólares australianos|a$|aud")
        .put("Centavo australiano", "centavo australiano|centavos australianos")
        .put("Manat azerí", "manat azerí|man|azn")
        .put("Qəpik azerí", "qəpik azerí|qəpik")
        .put("Dólar bahameño", "dólar bahameño|dólares bahameños|b$|bsd")
        .put("Centavo bahameño", "centavo bahameño|centavos bahameños")
        .put("Dinar bahreiní", "dinar bahreiní|dinares bahreinies|bhd")
        .put("Fil bahreiní", "fil bahreiní|fils bahreinies")
        .put("Taka bangladeshí", "taka bangladeshí|takas bangladeshí|bdt")
        .put("Poisha bangladeshí", "poisha bangladeshí|poishas bangladeshí")
        .put("Dólar de Barbados", "dólar de barbados|dólares de barbados|bbd")
        .put("Centavo de Barbados", "centavo de barbados|centavos de barbados")
        .put("Dólar beliceño", "dólar beliceño|dólares beliceños|bz$|bzd")
        .put("Centavo beliceño", "centavo beliceño|centavos beliceños")
        .put("Dólar bermudeño", "dólar bermudeño|dólares bermudeños|bd$|bmd")
        .put("Centavo bermudeño", "centavo bermudeño|centavos bermudeños")
        .put("Rublo bielorruso", "rublo bielorruso|rublos bielorrusos|byr")
        .put("Kópek bielorruso", "kópek bielorruso|kópeks bielorrusos|kap")
        .put("Kyat birmano", "kyat birmano|kyats birmanos|mmk")
        .put("Pya birmano", "pya birmano|pyas birmanos")
        .put("Boliviano", "boliviano|bolivianos|bob|bs")
        .put("Centésimo Boliviano", "centésimo boliviano|centésimos bolivianos")
        .put("Marco bosnioherzegovino", "marco convertible|marco bosnioherzegovino|marcos convertibles|marcos bosnioherzegovinos|bam")
        .put("Feningas bosnioherzegovino", "feninga convertible|feninga bosnioherzegovina|feningas convertibles")
        .put("Pula", "pula|bwp")
        .put("Thebe", "thebe")
        .put("Real brasileño", "real brasileño|reales brasileños|r$|brl")
        .put("Centavo brasileño", "centavo brasileño|centavos brasileños")
        .put("Dólar de Brunéi", "dólar de brunei|dólares de brunéi|bnd")
        .put("Sen de Brunéi", "sen|sen de brunéi")
        .put("Lev búlgaro", "lev búlgaro|leva búlgaros|lv|bgn")
        .put("Stotinki búlgaro", "stotinka búlgaro|stotinki búlgaros")
        .put("Franco de Burundi", "franco de burundi|francos de burundi|fbu|fib")
        .put("Céntimo Burundi", "céntimo burundi|céntimos burundies")
        .put("Ngultrum butanés", "ngultrum butanés|ngultrum butaneses|btn")
        .put("Chetrum  butanés", "chetrum butanés|chetrum butaneses")
        .put("Escudo caboverdiano", "escudo caboverdiano|escudos caboverdianos|cve")
        .put("Riel camboyano", "riel camboyano|rieles camboyanos|khr")
        .put("Dólar canadiense", "dólar canadiense|dólares canadienses|c$|cad")
        .put("Centavo canadiense", "centavo canadiense|centavos canadienses")
        .put("Peso chileno", "peso chileno|pesos chilenos|cpl")
        .put("Yuan chino", "yuan chino|yuanes chinos|yuan|yuanes|renminbi|rmb|cny|￥")
        .put("Peso colombiano", "peso colombiano|pesos colombianos|cop|col$")
        .put("Centavo colombiano", "centavo colombiano|centavos colombianos")
        .put("Franco comorano", "franco comorano|francos comoranos|kmf|₣")
        .put("Franco congoleño", "franco congoleño|francos congoleños|cdf")
        .put("Céntimo congoleño", "céntimo congoleño|céntimos congoleños")
        .put("Won norcoreano", "won norcoreano|wŏn norcoreano|wŏn norcoreanos|kpw")
        .put("Chon norcoreano", "chon norcoreano|chŏn norcoreano|chŏn norcoreanos|chon norcoreanos")
        .put("Won surcoreano", "wŏn surcoreano|won surcoreano|wŏnes surcoreanos|wones surcoreanos|krw")
        .put("Chon surcoreano", "chon surcoreano|chŏn surcoreano|chŏn surcoreanos|chon surcoreanos")
        .put("Colón costarricense", "colón costarricense|colones costarricenses|crc")
        .put("Kuna croata", "kuna croata|kuna croatas|hrk")
        .put("Lipa croata", "lipa croata|lipa croatas")
        .put("Peso cubano", "peso cubano|pesos cubanos|cup")
        .put("Peso cubano convertible", "peso cubano convertible|pesos cubanos convertible|cuc")
        .put("Corona danesa", "corona danesa|coronas danesas|dkk")
        .put("Libra egipcia", "libra egipcia|libras egipcias|egp|l.e.")
        .put("Piastra egipcia", "piastra egipcia|piastras egipcias")
        .put("Colón salvadoreño", "colón salvadoreño|colones salvadoreños|svc")
        .put("Dirham de los Emiratos Árabes Unidos", "dirham|dirhams|dirham de los emiratos Árabes unidos|aed|dhs")
        .put("Nakfa", "nakfa|nfk|ern")
        .put("Céntimo de Nakfa", "céntimo de nakfa|céntimos de nakfa")
        .put("Peseta", "peseta|pesetas|pts.|ptas.|esp")
        .put("Dólar estadounidense", "dólar estadounidense|dólares estadounidenses|usd|u$d|us$")
        .put("Corona estonia", "corona estonia|coronas estonias|eek")
        .put("Senti estonia", "senti estonia|senti estonias")
        .put("Birr etíope", "birr etíope|birr etíopes|br|etb")
        .put("Santim etíope", "santim etíope|santim etíopes")
        .put("Peso filipino", "peso filipino|pesos filipinos|php")
        .put("Marco finlandés", "marco finlandés|marcos finlandeses")
        .put("Dólar fiyiano", "dólar fiyiano|dólares fiyianos|fj$|fjd")
        .put("Centavo fiyiano", "centavo fiyiano|centavos fiyianos")
        .put("Dalasi", "dalasi|gmd")
        .put("Bututs", "butut|bututs")
        .put("Lari georgiano", "lari georgiano|lari georgianos|gel")
        .put("Tetri georgiano", "tetri georgiano|tetri georgianos")
        .put("Cedi", "cedi|ghs|gh₵")
        .put("Pesewa", "pesewa")
        .put("Libra gibraltareña", "libra gibraltareña|libras gibraltareñas|gip")
        .put("Penique gibraltareña", "penique gibraltareña|peniques gibraltareñas")
        .put("Quetzal guatemalteco", "quetzal guatemalteco|quetzales guatemaltecos|quetzal|quetzales|gtq")
        .put("Centavo guatemalteco", "centavo guatemalteco|centavos guatemaltecos")
        .put("Libra de Guernsey", "libra de guernsey|libras de guernsey|ggp")
        .put("Penique de Guernsey", "penique de guernsey|peniques de guernsey")
        .put("Franco guineano", "franco guineano|francos guineanos|gnf|fg")
        .put("Céntimo guineano", "céntimo guineano|céntimos guineanos")
        .put("Dólar guyanés", "dólar guyanés|dólares guyaneses|gyd|gy")
        .put("Gourde haitiano", "gourde haitiano|gourde haitianos|htg")
        .put("Céntimo haitiano", "céntimo haitiano|céntimos haitianos")
        .put("Lempira hondureño", "lempira hondureño|lempira hondureños|hnl")
        .put("Centavo hondureño", "centavo hondureño|centavos hondureño")
        .put("Dólar de Hong Kong", "dólar de hong kong|dólares de hong kong|hk$|hkd")
        .put("Forinto húngaro", "forinto húngaro|forinto húngaros|huf")
        .put("Rupia india", "rupia india|rupias indias|inr")
        .put("Paisa india", "paisa india|paise indias")
        .put("Rupia indonesia", "rupia indonesia|rupias indonesias|idr")
        .put("Sen indonesia", "sen indonesia|sen indonesias")
        .put("Rial iraní", "rial iraní|rial iranies|irr")
        .put("Dinar iraquí", "dinar iraquí|dinares iraquies|iqd")
        .put("Fil iraquí", "fil iraquí|fils iraquies")
        .put("Libra manesa", "libra manesa|libras manesas|imp")
        .put("Penique manes", "penique manes|peniques maneses")
        .put("Corona islandesa", "corona islandesa|coronas islandesas|isk|íkr")
        .put("Aurar islandes", "aurar islandes|aurar islandeses")
        .put("Dólar de las Islas Caimán", "dólar de las islas caimán|dólares de las islas caimán|ci$|kyd")
        .put("Dólar de las Islas Cook", "dólar de las islas cook|dólares de las islas cook")
        .put("Corona feroesa", "corona feroesa|coronas feroesas|fkr")
        .put("Libra malvinense", "libra malvinense|libras malvinenses|fk£|fkp")
        .put("Dólar de las Islas Salomón", "dólar de las islas salomón|dólares de las islas salomón|sbd")
        .put("Nuevo shéquel", "nuevo shéquel|nuevos shéquel|ils")
        .put("Agorot", "agorot")
        .put("Dólar jamaiquino", "dólar jamaiquino|dólares jamaiquinos|j$|ja$|jmd")
        .put("Yen", "yen|yenes|jpy")
        .put("Libra de Jersey", "libra de jersey|libras de jersey|jep")
        .put("Dinar jordano", "dinar jordano|dinares jordanos|jd|jod")
        .put("Piastra jordano", "piastra jordano|piastras jordanos")
        .put("Tenge kazajo", "tenge|tenge kazajo|kzt")
        .put("Chelín keniano", "chelín keniano|chelines kenianos|ksh|kes")
        .put("Som kirguís", "som kirguís|kgs")
        .put("Tyiyn", "tyiyn")
        .put("Dólar de Kiribati", "dólar de kiribati|dólares de kiribati")
        .put("Dinar kuwaití", "dinar kuwaití|dinares kuwaití")
        .put("Kip laosiano", "kip|kip laosiano|kip laosianos|lak")
        .put("Att laosiano", "att|att laosiano|att laosianos")
        .put("Loti", "loti|maloti|lsl")
        .put("Sente", "sente|lisente")
        .put("Libra libanesa", "libra libanesa|libras libanesas|lbp")
        .put("Dólar liberiano", "dólar liberiano|dólares liberianos|l$|lrd")
        .put("Dinar libio", "dinar libio|dinares libios|ld|lyd")
        .put("Dirham libio", "dirham libio|dirhams libios")
        .put("Litas lituana", "litas lituana|litai lituanas|ltl")
        .put("Pataca macaense", "pataca macaense|patacas macaenses|mop$|mop")
        .put("Avo macaense", "avo macaense|avos macaenses")
        .put("Ho macaense", "ho macaense|ho macaenses")
        .put("Denar macedonio", "denar macedonio|denare macedonios|den|mkd")
        .put("Deni macedonio", "deni macedonio|deni macedonios")
        .put("Ariary malgache", "ariary malgache|ariary malgaches|mga")
        .put("Iraimbilanja malgache", "iraimbilanja malgache|iraimbilanja malgaches")
        .put("Ringgit malayo", "ringgit malayo|ringgit malayos|rm|myr")
        .put("Sen malayo", "sen malayo|sen malayos")
        .put("Kwacha malauí", "kwacha malauí|mk|mwk")
        .put("Támbala malauí", "támbala malauí")
        .put("Rupia de Maldivas", "rupia de maldivas|rupias de maldivas|mvr")
        .put("Dirham marroquí", "dirham marroquí|dirhams marroquies|mad")
        .put("Rupia de Mauricio", "rupia de Mauricio|rupias de Mauricio|mur")
        .put("Uguiya", "uguiya|uguiyas|mro")
        .put("Jum", "jum|jums")
        .put("Peso mexicano", "peso mexicano|pesos mexicanos|mxn|mxn$|mxn $|mex$")
        .put("Centavo mexicano", "centavo mexicano|centavos mexicanos")
        .put("Leu moldavo", "leu moldavo|lei moldavos|mdl")
        .put("Ban moldavo", "ban moldavo|bani moldavos")
        .put("Tugrik mongol", "tugrik mongol|tugrik|tugrik mongoles|tug|mnt")
        .put("Metical mozambiqueño", "metical|metical mozambiqueño|meticales|meticales mozambiqueños|mtn|mzn")
        .put("Dram de Nagorno Karabaj", "dram de nagorno karabaj|drams de nagorno karabaj")
        .put("Luma de Nagorno Karabaj", "luma de nagorno karabaj")
        .put("Dólar namibio", "dólar namibio|dólares namibios|n$|nad")
        .put("Centavo namibio", "centavo namibio|centavos namibios")
        .put("Rupia nepalí", "rupia nepalí|rupias nepalies|npr")
        .put("Paisa nepalí", "paisa nepalí|paisas nepalies")
        .put("Córdoba nicaragüense", "córdoba nicaragüense|córdobas nicaragüenses|nio")
        .put("Centavo nicaragüense", "centavo nicaragüense|centavos nicaragüenses")
        .put("Naira", "naira|ngn")
        .put("Kobo", "kobo")
        .put("Corona noruega", "corona noruega|coronas noruegas|nok")
        .put("Franco CFP", "franco cfp|francos cfp|xpf")
        .put("Dólar neozelandés", "dólar neozelandés|dólares neozelandeses|dólar de nueva zelanda|dólares de nueva zelanda|nz$|nzd")
        .put("Centavo neozelandés", "centavo neozelandés|centavo de nueva zelanda|centavos de nueva zelanda|centavos neozelandeses")
        .put("Rial omaní", "rial omaní|riales omanies|omr")
        .put("Baisa omaní", "baisa omaní|baisa omanies")
        .put("Florín neerlandés", "florín neerlandés|florines neerlandeses|nlg")
        .put("Rupia pakistaní", "rupia pakistaní|rupias pakistanies|pkr")
        .put("Paisa pakistaní", "paisa pakistaní|paisas pakistanies")
        .put("Balboa panameño", "balboa panameño|balboa panameños|pab")
        .put("Centésimo panameño", "centésimo panameño|centésimos panameños")
        .put("Kina", "kina|pkg|pgk")
        .put("Toea", "toea")
        .put("Guaraní", "guaraní|guaranies|gs|pyg")
        .put("Sol", "sol|soles|nuevo sol|pen|s#.")
        .put("Céntimo de sol", "céntimo de sol|céntimos de sol")
        .put("Złoty", "złoty|esloti|eslotis|zł|pln")
        .put("Groszy", "groszy")
        .put("Riyal qatarí", "riyal qatarí|riyal qataries|qr|qar")
        .put("Dirham qatarí", "dirham qatarí|dirhams qataries")
        .put("Libra esterlina", "libra esterlina|libras esterlinas|gbp")
        .put("Corona checa", "corona checa|coronas checas|kc|czk")
        .put("Peso dominicano", "peso dominicano|pesos dominicanos|rd$|dop")
        .put("Centavo dominicano", "centavo dominicano|centavos dominicanos")
        .put("Franco ruandés", "franco ruandés|francos ruandeses|rf|rwf")
        .put("Céntimo ruandés", "céntimo ruandés|céntimos ruandeses")
        .put("Leu rumano", "leu rumano|lei rumanos|ron")
        .put("Ban rumano", "ban rumano|bani rumanos")
        .put("Rublo ruso", "rublo ruso|rublos rusos|rub")
        .put("Kopek ruso", "kopek ruso|kopeks rusos")
        .put("Tala", "tala|tālā|ws$|sat|wst")
        .put("Sene", "sene")
        .put("Libra de Santa Helena", "libra de santa helena|libras de santa helena|shp")
        .put("Penique de Santa Helena", "penique de santa helena|peniques de santa helena")
        .put("Dobra", "dobra")
        .put("Dinar serbio", "dinar serbio|dinares serbios|rsd")
        .put("Para serbio", "para serbio|para serbios")
        .put("Rupia de Seychelles", "rupia de seychelles|rupias de seychelles|scr")
        .put("Centavo de Seychelles", "centavo de seychelles|centavos de seychelles")
        .put("Leone", "leone|le|sll")
        .put("Dólar de Singapur", "dólar de singapur|dólares de singapur|sgb")
        .put("Centavo de Singapur", "centavo de Singapur|centavos de Singapur")
        .put("Libra siria", "libra siria|libras sirias|s£|syp")
        .put("Piastra siria", "piastra siria|piastras sirias")
        .put("Chelín somalí", "chelín somalí|chelines somalies|sos")
        .put("Centavo somalí", "centavo somalí|centavos somalies")
        .put("Chelín somalilandés", "chelín somalilandés|chelines somalilandeses")
        .put("Centavo somalilandés", "centavo somalilandés|centavos somalilandeses")
        .put("Rupia de Sri Lanka", "rupia de Sri Lanka|rupias de Sri Lanka|lkr")
        .put("Céntimo de Sri Lanka", "céntimo de Sri Lanka|céntimos de Sri Lanka")
        .put("Lilangeni", "lilangeni|emalangeni|szl")
        .put("Rand sudafricano", "rand|rand sudafricano|zar")
        .put("Libra sudanesa", "libra sudanesa|libras sudanesas|sdg")
        .put("Piastra sudanesa", "piastra sudanesa|piastras sudanesas")
        .put("Libra sursudanesa", "libra sursudanesa|libras sursudanesa|ssp")
        .put("Piastra sursudanesa", "piastra sursudanesa|piastras sursudanesas")
        .put("Corona sueca", "corona sueca|coronas suecas|sek")
        .put("Franco suizo", "franco suizo|francos suizos|sfr|chf")
        .put("Rappen suizo", "rappen suizo|rappens suizos")
        .put("Dólar surinamés", "óolar surinamés|dólares surinameses|srd")
        .put("Centavo surinamés", "centavo surinamés|centavos surinamés")
        .put("Baht tailandés", "baht tailandés|baht tailandeses|thb")
        .put("Satang tailandés", "satang tailandés|satang tailandeses")
        .put("Nuevo dólar taiwanés", "nuevo dólar taiwanés|dólar taiwanés|dólares taiwaneses|twd")
        .put("Centavo taiwanés", "centavo taiwanés|centavos taiwaneses")
        .put("Chelín tanzano", "chelín tanzano|chelines tanzanos|tzs")
        .put("Centavo tanzano", "centavo tanzano|centavos tanzanos")
        .put("Somoni tayiko", "somoni tayiko|somoni|tjs")
        .put("Diram", "diram|dirams")
        .put("Paʻanga", "dólar tongano|dólares tonganos|paʻanga|pa'anga|top")
        .put("Seniti", "seniti")
        .put("Rublo de Transnistria", "rublo de transnistria|rublos de transnistria")
        .put("Kopek de Transnistria", "kopek de transnistria|kopeks de transnistria")
        .put("Dólar trinitense", "dólar trinitense|dólares trinitenses|ttd")
        .put("Centavo trinitense", "centavo trinitense|centavos trinitenses")
        .put("Dinar tunecino", "dinar tunecino|dinares tunecinos|tnd")
        .put("Millime tunecino", "millime tunecino|millimes tunecinos")
        .put("Lira turca", "lira turca|liras turcas|try")
        .put("Kuruş turca", "kuruş turca|kuruş turcas")
        .put("Manat turkmeno", "manat turkmeno|manat turkmenos|tmt")
        .put("Tennesi turkmeno", "tennesi turkmeno|tenge turkmeno")
        .put("Dólar tuvaluano", "dólar tuvaluano|dólares tuvaluanos")
        .put("Centavo tuvaluano", "centavo tuvaluano|centavos tuvaluanos")
        .put("Grivna", "grivna|grivnas|uah")
        .put("Kopiyka", "kopiyka|kópeks")
        .put("Chelín ugandés", "chelín ugandés|chelines ugandeses|ugx")
        .put("Centavo ugandés", "centavo ugandés|centavos ugandeses")
        .put("Peso uruguayo", "peso uruguayo|pesos uruguayos|uyu")
        .put("Centésimo uruguayo", "centésimo uruguayo|centésimos uruguayos")
        .put("Som uzbeko", "som uzbeko|som uzbekos|uzs")
        .put("Tiyin uzbeko", "tiyin uzbeko|tiyin uzbekos")
        .put("Vatu", "vatu|vuv")
        .put("Bolívar fuerte", "bolívar fuerte|bolívar|bolívares|vef")
        .put("Céntimo de bolívar", "céntimo de bolívar|céntimos de bolívar")
        .put("Đồng vietnamita", "Đồng vietnamita|dong vietnamita|dong vietnamitas|vnd")
        .put("Hào vietnamita", "Hào vietnamita|hao vietnamita|hao vietnamitas")
        .put("Rial yemení", "rial yemení|riales yemenies|yer")
        .put("Fils yemení", "fils yemení|fils yemenies")
        .put("Franco yibutiano", "franco yibutiano|francos yibutianos|djf")
        .put("Dinar yugoslavo", "dinar yugoslavo|dinares yugoslavos|yud")
        .put("Kwacha zambiano", "kwacha zambiano|kwacha zambianos|zmw")
        .put("Ngwee zambiano", "ngwee zambiano|ngwee zambianos")
        .put("Bitcoin", "bitcoin|bitcoins|btc|xbt|₿")
        .put("Millibitcoin", "millibitcoin|millibitcoins|milibitcoin|milibitcoins")
        .put("Satoshi", "satoshi|satoshis")
        .build();

    public static final ImmutableMap<String, String> CurrencyNameToIsoCodeMap = ImmutableMap.<String, String>builder()
        .put("Afgani afgano", "AFN")
        .put("Euro", "EUR")
        .put("Lek albanés", "ALL")
        .put("Kwanza angoleño", "AOA")
        .put("Dram armenio", "AMD")
        .put("Florín arubeño", "AWG")
        .put("Taka bangladeshí", "BDT")
        .put("Ngultrum butanés", "BTN")
        .put("Boliviano", "BOB")
        .put("Marco bosnioherzegovino", "BAM")
        .put("Pula", "BWP")
        .put("Real brasileño", "BRL")
        .put("Lev búlgaro", "BGN")
        .put("Riel camboyano", "KHR")
        .put("Escudo caboverdiano", "CVE")
        .put("Colón costarricense", "CRC")
        .put("Kuna croata", "HRK")
        .put("Corona checa", "CZK")
        .put("Nakfa", "ERN")
        .put("Birr etíope", "ETB")
        .put("Dalasi", "GMD")
        .put("Lari georgiano", "GEL")
        .put("Cedi", "GHS")
        .put("Quetzal guatemalteco", "GTQ")
        .put("Gourde haitiano", "HTG")
        .put("Lempira hondureño", "HNL")
        .put("Forinto húngaro", "HUF")
        .put("Rial iraní", "IRR")
        .put("Rial yemení", "YER")
        .put("Nuevo shéquel", "ILS")
        .put("Yen", "JPY")
        .put("Tenge kazajo", "KZT")
        .put("Chelín keniano", "KES")
        .put("Won norcoreano", "KPW")
        .put("Won surcoreano", "KRW")
        .put("Som kirguís", "KGS")
        .put("Kip laosiano", "LAK")
        .put("Loti", "LSL")
        .put("Rand sudafricano", "ZAR")
        .put("Pataca macaense", "MOP")
        .put("Denar macedonio", "MKD")
        .put("Ariary malgache", "MGA")
        .put("Kwacha malauí", "MWK")
        .put("Ringgit malayo", "MYR")
        .put("Uguiya", "MRO")
        .put("Tugrik mongol", "MNT")
        .put("Metical mozambiqueño", "MZN")
        .put("Kyat birmano", "MMK")
        .put("Córdoba nicaragüense", "NIO")
        .put("Naira", "NGN")
        .put("Lira turca", "TRY")
        .put("Rial omaní", "OMR")
        .put("Balboa panameño", "PAB")
        .put("Kina", "PGK")
        .put("Guaraní", "PYG")
        .put("Sol", "PEN")
        .put("Złoty", "PLN")
        .put("Riyal qatarí", "QAR")
        .put("Riyal saudí", "SAR")
        .put("Tala", "WST")
        .put("São Tomé and Príncipe dobra", "STN")
        .put("Leone", "SLL")
        .put("Lilangeni", "SZL")
        .put("Somoni tayiko", "TJS")
        .put("Baht tailandés", "THB")
        .put("Grivna", "UAH")
        .put("Vatu", "VUV")
        .put("Bolívar fuerte", "VEF")
        .put("Kwacha zambiano", "ZMW")
        .put("Dirham marroquí", "MAD")
        .put("Dirham de los Emiratos Árabes Unidos", "AED")
        .put("Manat azerí", "AZN")
        .put("Manat turkmeno", "TMT")
        .put("Chelín somalí", "SOS")
        .put("Chelín tanzano", "TZS")
        .put("Chelín ugandés", "UGX")
        .put("Leu rumano", "RON")
        .put("Leu moldavo", "MDL")
        .put("Rupia nepalí", "NPR")
        .put("Rupia pakistaní", "PKR")
        .put("Rupia india", "INR")
        .put("Rupia de Seychelles", "SCR")
        .put("Rupia de Mauricio", "MUR")
        .put("Rupia de Maldivas", "MVR")
        .put("Rupia de Sri Lanka", "LKR")
        .put("Rupia indonesia", "IDR")
        .put("Corona danesa", "DKK")
        .put("Corona noruega", "NOK")
        .put("Corona islandesa", "ISK")
        .put("Corona sueca", "SEK")
        .put("Franco CFA de África Occidental", "XOF")
        .put("Franco CFA de África Central", "XAF")
        .put("Franco comorano", "KMF")
        .put("Franco congoleño", "CDF")
        .put("Burundian franc", "BIF")
        .put("Franco yibutiano", "DJF")
        .put("Franco CFP", "XPF")
        .put("Franco guineano", "GNF")
        .put("Franco suizo", "CHF")
        .put("Franco ruandés", "RWF")
        .put("Rublo ruso", "RUB")
        .put("Transnistrian ruble", "PRB")
        .put("New Belarusian ruble", "BYN")
        .put("Dinar argelino", "DZD")
        .put("Dinar bahreiní", "BHD")
        .put("Dinar iraquí", "IQD")
        .put("Dinar jordano", "JOD")
        .put("Kuwaiti dinar", "KWD")
        .put("Dinar libio", "LYD")
        .put("Dinar serbio", "RSD")
        .put("Dinar tunecino", "TND")
        .put("Peso argentino", "ARS")
        .put("Chilean peso", "CLP")
        .put("Peso colombiano", "COP")
        .put("Peso cubano convertible", "CUC")
        .put("Peso cubano", "CUP")
        .put("Peso dominicano", "DOP")
        .put("Peso mexicano", "MXN")
        .put("Peso uruguayo", "UYU")
        .put("Libra esterlina", "GBP")
        .put("Libra de Santa Helena", "SHP")
        .put("Libra egipcia", "EGP")
        .put("Libra malvinense", "FKP")
        .put("Libra gibraltareña", "GIP")
        .put("Libra manesa", "IMP")
        .put("Libra de Jersey", "JEP")
        .put("Libra libanesa", "LBP")
        .put("Libra sursudanesa", "SSP")
        .put("Libra sudanesa", "SDG")
        .put("Libra siria", "SYP")
        .put("Dólar estadounidense", "USD")
        .put("Dólar australiano", "AUD")
        .put("Dólar bahameño", "BSD")
        .put("Dólar de Barbados", "BBD")
        .put("Dólar beliceño", "BZD")
        .put("Dólar bermudeño", "BMD")
        .put("Dólar de Brunéi", "BND")
        .put("Dólar de Singapur", "SGD")
        .put("Dólar canadiense", "CAD")
        .put("Dólar de las Islas Caimán", "KYD")
        .put("Dólar neozelandés", "NZD")
        .put("Dólar fiyiano", "FJD")
        .put("Dólar guyanés", "GYD")
        .put("Dólar de Hong Kong", "HKD")
        .put("Dólar jamaiquino", "JMD")
        .put("Dólar liberiano", "LRD")
        .put("Dólar namibio", "NAD")
        .put("Dólar de las Islas Salomón", "SBD")
        .put("Dólar surinamés", "SRD")
        .put("Nuevo dólar taiwanés", "TWD")
        .put("Dólar trinitense", "TTD")
        .put("Tuvaluan dollar", "TVD")
        .put("Yuan chino", "CNY")
        .put("Rial", "__RI")
        .put("Chelín", "__S")
        .put("Som", "__SO")
        .put("Dirham", "__DR")
        .put("Dinar", "_DN")
        .put("Dólar", "__D")
        .put("Manat", "__MA")
        .put("Rupia", "__R")
        .put("Corona", "__K")
        .put("Franco", "__F")
        .put("Marco", "__M")
        .put("Rublo", "__RB")
        .put("Peso", "__PE")
        .put("Libra", "__P")
        .put("Tristan da Cunha libra", "_TP")
        .put("South Georgia and the South Sandwich Islands libra", "_SP")
        .put("Somaliland chelín", "_SS")
        .put("Pitcairn Islands dólar", "_PND")
        .put("Palauan dólar", "_PD")
        .put("Niue dólar", "_NID")
        .put("Nauruan dólar", "_ND")
        .put("Micronesian dólar", "_MD")
        .put("Kiribati dólar", "_KID")
        .put("Guernsey libra", "_GGP")
        .put("Faroese corona", "_FOK")
        .put("Cook Islands dólar", "_CKD")
        .put("British Virgin Islands dólar", "_BD")
        .put("Ascension libra", "_AP")
        .put("Alderney libra", "_ALP")
        .put("Abkhazian apsar", "_AA")
        .put("Bitcoin", "_XBT")
        .build();

    public static final ImmutableMap<String, String> FractionalUnitNameToCodeMap = ImmutableMap.<String, String>builder()
        .put("Jiao", "JIAO")
        .put("Kópek", "KOPEK")
        .put("Kopek", "KOPEK")
        .put("Pul", "PUL")
        .put("Cent", "CENT")
        .put("Qindarka", "QINDARKE")
        .put("Penique", "PENNY")
        .put("Santeem", "SANTEEM")
        .put("Cêntimo", "CENT")
        .put("Centavo", "CENT")
        .put("Luma", "LUMA")
        .put("Qəpik", "QƏPIK")
        .put("Fils", "FILS")
        .put("Poisha", "POISHA")
        .put("Kapyeyka", "KAPYEYKA")
        .put("Kopyeyka", "KOPYEYKA")
        .put("Centime", "CENTIME")
        .put("Chetrum", "CHETRUM")
        .put("Paisa", "PAISA")
        .put("Feningas", "FENING")
        .put("Thebe", "THEBE")
        .put("Sen", "SEN")
        .put("Stotinka", "STOTINKA")
        .put("Fen", "FEN")
        .put("Céntimo", "CENT")
        .put("Lipa", "LIPA")
        .put("Haléř", "HALER")
        .put("Øre", "ØRE")
        .put("Piastre", "PIASTRE")
        .put("Santim", "SANTIM")
        .put("Oyra", "OYRA")
        .put("Butut", "BUTUT")
        .put("Tetri", "TETRI")
        .put("Pesewa", "PESEWA")
        .put("Fillér", "FILLER")
        .put("Eyrir", "EYRIR")
        .put("Dinar", "DINAR")
        .put("Agora", "AGORA")
        .put("Tïın", "TIIN")
        .put("Chon", "CHON")
        .put("Jeon", "JEON")
        .put("Tyiyn", "TYIYN")
        .put("Att", "ATT")
        .put("Sente", "SENTE")
        .put("Dirham", "DIRHAM")
        .put("Rappen", "RAPPEN")
        .put("Avo", "AVO")
        .put("Deni", "DENI")
        .put("Iraimbilanja", "IRAIMBILANJA")
        .put("Tambala", "TAMBALA")
        .put("Laari", "LAARI")
        .put("Khoums", "KHOUMS")
        .put("Ban", "BAN")
        .put("Möngö", "MONGO")
        .put("Pya", "PYA")
        .put("Kobo", "KOBO")
        .put("Kuruş", "KURUS")
        .put("Baisa", "BAISA")
        .put("Centésimo", "CENTESIMO")
        .put("Toea", "TOEA")
        .put("Sentimo", "SENTIMO")
        .put("Grosz", "GROSZ")
        .put("Sene", "SENE")
        .put("Halala", "HALALA")
        .put("Para", "PARA")
        .put("Öre", "ORE")
        .put("Diram", "DIRAM")
        .put("Satang", "SATANG")
        .put("Seniti", "SENITI")
        .put("Millime", "MILLIME")
        .put("Tennesi", "TENNESI")
        .put("Kopiyka", "KOPIYKA")
        .put("Tiyin", "TIYIN")
        .put("Hào", "HAO")
        .put("Ngwee", "NGWEE")
        .put("Millibitcoin", "MILLIBITCOIN")
        .put("Satoshi", "SATOSHI")
        .build();

    public static final String CompoundUnitConnectorRegex = "(?<spacer>y|con)";

    public static final String MultiplierRegex = "\\s*\\b(((mil\\s+)?mi|bi|cuatri|quinti|sexti|septi)ll[oó]n|mil)(es)?\\b";

    public static final ImmutableMap<String, String> CurrencyPrefixList = ImmutableMap.<String, String>builder()
        .put("Dobra", "db|std")
        .put("Dólar", "$|dólar|dólares|dolar|dolares")
        .put("Dólar estadounidense", "us$|u$d|usd")
        .put("Dólar del Caribe Oriental", "ec$|xcd")
        .put("Dólar australiano", "a$|aud")
        .put("Dólar bahameño", "b$|bsd")
        .put("Dólar de Barbados", "bds$|bbd")
        .put("Dólar beliceño", "bz$|bzd")
        .put("Dólar bermudeño", "bd$|bmd")
        .put("Dólar de Brunéi", "brunéi $|bnd")
        .put("Dólar de Singapur", "s$|sgd")
        .put("Dólar canadiense", "c$|can$|cad")
        .put("Dólar de las Islas Caimán", "ci$|kyd")
        .put("Dólar neozelandés", "nz$|nzd")
        .put("Dólar fiyiano", "fj$|fjd")
        .put("Dólar guyanés", "gy$|gyd")
        .put("Dólar de Hong Kong", "hk$|hkd")
        .put("Dólar jamaiquino", "j$|ja$|jmd")
        .put("Dólar liberiano", "l$|lrd")
        .put("Dólar namibio", "n$|nad")
        .put("Dólar de las Islas Salomón", "si$|sbd")
        .put("Nuevo dólar taiwanés", "nt$|twd")
        .put("Peso mexicano", "mxn|mxn$|mxn $|mex$")
        .put("Real brasileño", "r$|brl")
        .put("Guaraní", "₲|gs.|pyg")
        .put("Dólar trinitense", "tt$|ttd")
        .put("Yuan chino", "￥|cny|rmb")
        .put("Yen", "¥|jpy")
        .put("Euro", "€|eur")
        .put("Florín", "ƒ")
        .put("Libra", "£")
        .put("Colón costarricense", "₡")
        .put("Lira turca", "₺")
        .put("Bitcoin", "₿|btc|xbt")
        .build();

    public static final List<String> AmbiguousCurrencyUnitList = Arrays.asList("le", "db", "std");

    public static final ImmutableMap<String, String> InformationSuffixList = ImmutableMap.<String, String>builder()
        .put("bit", "bit|bits")
        .put("kilobit", "kilobit|kilobits|kb|kbit")
        .put("megabit", "megabit|megabits|Mb|Mbit")
        .put("gigabit", "gigabit|gigabits|Gb|Gbit")
        .put("terabit", "terabit|terabits|Tb|Tbit")
        .put("petabit", "petabit|petabits|Pb|Pbit")
        .put("kibibit", "kibibit|kibibits|kib|kibit")
        .put("mebibit", "mebibit|mebibits|Mib|Mibit")
        .put("gibibit", "gibibit|gibibits|Gib|Gibit")
        .put("tebibit", "tebibit|tebibits|Tib|Tibit")
        .put("pebibit", "pebibit|pebibits|Pib|Pibit")
        .put("byte", "byte|bytes")
        .put("kilobyte", "kilobyte|kilobytes|kB|kByte")
        .put("megabyte", "megabyte|megabytes|MB|MByte")
        .put("gigabyte", "gigabyte|gigabytes|GB|GByte")
        .put("terabyte", "terabyte|terabytes|TB|TByte")
        .put("petabyte", "petabyte|petabytes|PB|PByte")
        .put("kibibyte", "kibibyte|kibibytes|kiB|kiByte")
        .put("mebibyte", "mebibyte|mebibytes|MiB|MiByte")
        .put("gibibyte", "gibibyte|gibibytes|GiB|GiByte")
        .put("tebibyte", "tebibyte|tebibytes|TiB|TiByte")
        .put("pebibyte", "pebibyte|pebibytes|PiB|PiByte")
        .build();

    public static final List<String> AmbiguousDimensionUnitList = Arrays.asList("al", "mi", "área", "áreas", "pie", "pies", "\"");

    public static final ImmutableMap<String, String> LengthSuffixList = ImmutableMap.<String, String>builder()
        .put("Kilómetro", "km|kilometro|kilómetro|kilometros|kilómetros")
        .put("Hectómetro", "hm|hectometro|hectómetro|hectometros|hectómetros")
        .put("Decámetro", "decametro|decámetro|decametros|decámetros|dam")
        .put("Metro", "m|m.|metro|metros")
        .put("Decímetro", "dm|decimetro|decímetro|decimetros|decímetros")
        .put("Centímetro", "cm|centimetro|centímetro|centimetros|centimetros")
        .put("Milímetro", "mm|milimetro|milímetro|milimetros|milímetros")
        .put("Micrómetro", "µm|um|micrometro|micrómetro|micrometros|micrómetros|micrón|micrónes")
        .put("Nanómetro", "nm|nanometro|nanómetro|nanometros|nanómetros")
        .put("Picómetro", "pm|picometro|picómetro|picometros|picómetros")
        .put("Milla", "mi|milla|millas")
        .put("Yarda", "yd|yarda|yardas")
        .put("Pulgada", "pulgada|pulgadas|\"")
        .put("Pie", "pie|pies|ft")
        .put("Año luz", "año luz|años luz|al")
        .build();

    public static final List<String> AmbiguousLengthUnitList = Arrays.asList("mi", "área", "áreas", "\"");

    public static final String BuildPrefix = "(?<=(\\s|^|\\P{L}))";

    public static final String BuildSuffix = "(?=(\\s|\\P{L}|$))";

    public static final String ConnectorToken = "de";

    public static final ImmutableMap<String, String> SpeedSuffixList = ImmutableMap.<String, String>builder()
        .put("Metro por segundo", "metro/segundo|m/s|metro por segundo|metros por segundo|metros por segundos")
        .put("Kilómetro por hora", "km/h|kilómetro por hora|kilometro por hora|kilómetros por hora|kilometros por hora|kilómetro/hora|kilometro/hora|kilómetros/hora|kilometros/hora")
        .put("Kilómetro por minuto", "km/min|kilómetro por minuto|kilometro por minuto|kilómetros por minuto|kilometros por minuto|kilómetro/minuto|kilometro/minuto|kilómetros/minuto|kilometros/minuto")
        .put("Kilómetro por segundo", "km/seg|kilómetro por segundo|kilometro por segundo|kilómetros por segundo|kilometros por segundo|kilómetro/segundo|kilometro/segundo|kilómetros/segundo|kilometros/segundo")
        .put("Milla por hora", "mph|milla por hora|mi/h|milla/hora|millas/hora|millas por hora")
        .put("Nudo", "kt|nudo|nudos|kn")
        .put("Pie por segundo", "ft/s|pie/s|ft/seg|pie/seg|pie por segundo|pies por segundo")
        .put("Pie por minuto", "ft/min|pie/min|pie por minuto|pies por minuto")
        .put("Yarda por minuto", "yardas por minuto|yardas/minuto|yardas/min")
        .put("Yarda por segundo", "yardas por segundo|yardas/segundo|yardas/seg")
        .build();

    public static final List<String> AmbiguousSpeedUnitList = Arrays.asList("nudo", "nudos");

    public static final ImmutableMap<String, String> TemperatureSuffixList = ImmutableMap.<String, String>builder()
        .put("Kelvin", "k|K|kelvin")
        .put("Rankine", "r|rankine")
        .put("Grado Celsius", "°c|° c|ºc|º c|grado c|grados c|grado celsius|grados celsius|celsius|grado centígrado|grados centígrados|centígrado|centígrados")
        .put("Grado Fahrenheit", "°f|° f|ºf|º f|grado f|grados f|grado fahrenheit|grados fahrenheit|fahrenheit")
        .put("Grado Réaumur", "°r|°re|grados r|grado réaumur|grados réaumur|réaumur")
        .put("Grado Delisle", "°d|grados d|grado delisle|grados delisle|delisle")
        .put("Grado", "°|grados|grado")
        .build();

    public static final ImmutableMap<String, String> VolumeSuffixList = ImmutableMap.<String, String>builder()
        .put("Kilómetro cúbico", "kilómetro cúbico|kilómetros cúbico|km3|km^3|km³")
        .put("Hectómetro cúbico", "hectómetro cúbico|hectómetros cúbico|hm3|hm^3|hm³")
        .put("Decámetro cúbico", "decámetro cúbico|decámetros cúbico|dam3|dam^3|dam³")
        .put("Metro cúbico", "metro cúbico|metros cúbico|m3|m^3|m³")
        .put("Decímetro cúbico", "decímetro cúbico|decímetros cúbico|dm3|dm^3|dm³")
        .put("Centímetro cúbico", "centímetro cúbico|centímetros cúbico|cc|cm3|cm^3|cm³")
        .put("Milímetro cúbico", "milímetro cúbico|milímetros cúbico|mm3|mm^3|mm³")
        .put("Pulgada cúbica", "pulgada cúbica|pulgadas cúbicas")
        .put("Pie cúbico", "pie cúbico|pies cúbicos|pie3|pie^3|pie³|ft3|ft^3|ft³")
        .put("Yarda cúbica", "yarda cúbica|yardas cúbicas|yd3|yd^3|yd³")
        .put("Hectolitro", "hectolitro|hectolitros|hl")
        .put("Litro", "litro|litros|lts|l")
        .put("Mililitro", "mililitro|mililitros|ml")
        .put("Galón", "galón|galones")
        .put("Pinta", "pinta|pintas")
        .put("Barril", "barril|barriles|bbl")
        .put("Onza líquida", "onza líquida|onzas líquidas")
        .build();

    public static final ImmutableMap<String, String> WeightSuffixList = ImmutableMap.<String, String>builder()
        .put("Tonelada métrica", "tonelada métrica|toneladas métricas|t.métrica|t métrica|t. métrica|tonelada metrica|toneladas metricas|t.metrica|t metrica|t. metrica")
        .put("Tonelada", "ton|tonelada|toneladas|t")
        .put("Kilogramo", "kg|kilogramo|kilogramos")
        .put("Hectogramo", "hg|hectogramo|hectogramos")
        .put("Decagramo", "dag|decagramo|decagramos")
        .put("Gramo", "g|gr|gramo|gramos")
        .put("Decigramo", "dg|decigramo|decigramos")
        .put("Centigramo", "cg|centigramo|centigramos")
        .put("Miligramo", "mg|miligramo|miligramos")
        .put("Microgramo", "µg|ug|microgramo|microgramos")
        .put("Nanogramo", "ng|nanogramo|nanogramos")
        .put("Picogramo", "pg|picogramo|picogramos")
        .put("Libra", "lb|libra|libras")
        .put("Onza", "oz|onza|onzas")
        .put("Grano", "grano|granos")
        .put("Quilate", "ct|quilate|quilates")
        .build();

    public static final List<String> AmbiguousWeightUnitList = Arrays.asList("g", "t");

    public static final ImmutableMap<String, String> AngleSuffixList = ImmutableMap.<String, String>builder()
        .put("Degree", "grado|grados|°")
        .put("Radian", "radián|radian|radianes|rad")
        .put("Turn", "vuelta|vueltas")
        .build();

    public static final List<String> AmbiguousAngleUnitList = Arrays.asList("vuelta", "vueltas");

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("null", "null")
        .build();

    public static final ImmutableMap<String, String> TemperatureAmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("\\b(grados?|°)$", "\\b((grados?|°)\\s*(angolo|rotaci[oó]n)|(gira(r|do|torio)?|angolo|rotaci[oó]n)(\\s+(\\p{L}+|\\d+)){0,4}\\s*(grados?\\b|°))")
        .build();

    public static final ImmutableMap<String, String> DimensionAmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("\\b(grados?|°)$", "\\b((grados?|°)\\s*(c(elsius|entígrado)?|f(ah?renheit)?)|(temperatura)(\\s+(\\p{L}+|\\d+)){0,4}\\s*(grados?\\b|°))")
        .build();
}
