// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.numberwithunit.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class EnglishNumericWithUnit {

    public static final ImmutableMap<String, String> AgePrefixList = ImmutableMap.<String, String>builder()
        .put("Age", "Age|age")
        .build();

    public static final ImmutableMap<String, String> AgeSuffixList = ImmutableMap.<String, String>builder()
        .put("Year", "years old|year old|year-old|years-old|-year-old|-years-old|years of age|year of age|yo")
        .put("Month", "months old|month old|month-old|months-old|-month-old|-months-old|month of age|months of age|mo")
        .put("Week", "weeks old|week old|week-old|weeks-old|-week-old|-weeks-old|week of age|weeks of age")
        .put("Day", "days old|day old|day-old|days-old|-day-old|-days-old|day of age|days of age")
        .build();

    public static final List<String> AmbiguousAgeUnitList = Arrays.asList("yo", "mo");

    public static final ImmutableMap<String, String> AreaSuffixList = ImmutableMap.<String, String>builder()
        .put("Square kilometer", "sq km|sq kilometer|sq kilometre|sq kilometers|sq kilometres|square kilometer|square kilometre|square kilometers|square kilometres|km2|km^2|km²")
        .put("Square hectometer", "sq hm|sq hectometer|sq hectometre|sq hectometers|sq hectometres|square hectometer|square hectometre|square hectometers|square hectometres|hm2|hm^2|hm²|hectare|hectares")
        .put("Square decameter", "sq dam|sq decameter|sq decametre|sq decameters|sq decametres|square decameter|square decametre|square decameters|square decametres|sq dekameter|sq dekametre|sq dekameters|sq dekametres|square dekameter|square dekametre|square dekameters|square dekametres|dam2|dam^2|dam²")
        .put("Square meter", "sq m|sq meter|sq metre|sq meters|sq metres|sq metre|square meter|square meters|square metre|square metres|m2|m^2|m²")
        .put("Square decimeter", "sq dm|sq decimeter|sq decimetre|sq decimeters|sq decimetres|square decimeter|square decimetre|square decimeters|square decimetres|dm2|dm^2|dm²")
        .put("Square centimeter", "sq cm|sq centimeter|sq centimetre|sq centimeters|sq centimetres|square centimeter|square centimetre|square centimeters|square centimetres|cm2|cm^2|cm²")
        .put("Square millimeter", "sq mm|sq millimeter|sq millimetre|sq millimeters|sq millimetres|square millimeter|square millimetre|square millimeters|square millimetres|mm2|mm^2|mm²")
        .put("Square inch", "sq in|sq inch|square inch|square inches|in2|in^2|in²")
        .put("Square foot", "sqft|sq ft|sq foot|sq feet|square foot|square feet|feet2|feet^2|feet²|ft2|ft^2|ft²")
        .put("Square mile", "sq mi|sq mile|sqmiles|square mile|square miles|mi2|mi^2|mi²")
        .put("Square yard", "sq yd|sq yard|sq yards|square yard|square yards|yd2|yd^2|yd²")
        .put("Acre", "-acre|acre|acres")
        .build();

    public static final List<String> AmbiguousAreaUnitList = Arrays.asList("n/a");

    public static final ImmutableMap<String, String> CurrencySuffixList = ImmutableMap.<String, String>builder()
        .put("Abkhazian apsar", "abkhazian apsar|apsars")
        .put("Afghan afghani", "afghan afghani|؋|afn|afghanis|afghani")
        .put("Pul", "pul")
        .put("Euro", "euros|euro|€|eur")
        .put("Cent", "cents|cent|-cents|-cent")
        .put("Albanian lek", "albanian lek|leks|lek")
        .put("Qindarkë", "qindarkë|qindarkës|qindarke|qindarkes")
        .put("Angolan kwanza", "angolan kwanza|kz|aoa|kwanza|kwanzas|angolan kwanzas")
        .put("Armenian dram", "armenian drams|armenian dram")
        .put("Aruban florin", "aruban florin|ƒ|awg|aruban florins")
        .put("Bangladeshi taka", "bangladeshi taka|৳|bdt|taka|takas|bangladeshi takas")
        .put("Paisa", "poisha|paisa")
        .put("Bhutanese ngultrum", "bhutanese ngultrum|nu.|btn")
        .put("Chetrum", "chetrums|chetrum")
        .put("Bolivian boliviano", "bolivian boliviano|bob|bs.|bolivia boliviano|bolivia bolivianos|bolivian bolivianos")
        .put("Bosnia and Herzegovina convertible mark", "bosnia and herzegovina convertible mark|bam")
        .put("Fening", "fenings|fenings")
        .put("Botswana pula", "botswana pula|bwp|pula|pulas|botswana pulas")
        .put("Thebe", "thebe")
        .put("Brazilian real", "brazilian real|r$|brl|brazil real|brazil reals|brazilian reals")
        .put("Bulgarian lev", "bulgarian lev|bgn|лв|bulgaria lev|bulgaria levs|bulgarian levs")
        .put("Stotinka", "stotinki|stotinka")
        .put("Cambodian riel", "cambodian riel|khr|៛|cambodia riel|cambodia riels|cambodian riels")
        .put("Cape Verdean escudo", "cape verdean escudo|cve")
        .put("Costa Rican colón", "costa rican colón|costa rican colóns|crc|₡|costa rica colón|costa rica colóns|costa rican colon|costa rican colons|costa rica colon|costa rica colons")
        .put("Salvadoran colón", "svc|salvadoran colón|salvadoran colóns|salvador colón|salvador colóns|salvadoran colon|salvadoran colons|salvador colon|salvador colons")
        .put("Céntimo", "céntimo")
        .put("Croatian kuna", "croatian kuna|kn|hrk|croatia kuna|croatian kunas|croatian kuna kunas")
        .put("Lipa", "lipa")
        .put("Czech koruna", "czech koruna|czk|kč|czech korunas")
        .put("Haléř", "haléř")
        .put("Eritrean nakfa", "eritrean nakfa|nfk|ern|eritrean nakfas")
        .put("Ethiopian birr", "ethiopian birr|etb")
        .put("Gambian dalasi", "gmd")
        .put("Butut", "bututs|butut")
        .put("Georgian lari", "georgian lari|lari|gel|₾")
        .put("Tetri", "tetri")
        .put("Ghanaian cedi", "ghanaian cedi|ghs|₵|gh₵")
        .put("Pesewa", "pesewas|pesewa")
        .put("Guatemalan quetzal", "guatemalan quetzal|gtq|guatemala quetzal")
        .put("Haitian gourde", "haitian gourde|htg")
        .put("Honduran lempira", "honduran lempira|hnl")
        .put("Hungarian forint", "hungarian forint|huf|ft|hungary forint|hungary forints|hungarian forints")
        .put("Fillér", "fillér")
        .put("Iranian rial", "iranian rial|irr|iran rial|iran rials|iranian rials")
        .put("Yemeni rial", "yemeni rial|yer|yemeni rials")
        .put("Israeli new shekel", "₪|ils|agora")
        .put("Lithuanian litas", "ltl|lithuanian litas|lithuan litas|lithuanian lit|lithuan lit")
        .put("Japanese yen", "japanese yen|jpy|yen|-yen|¥|yens|japanese yens|japan yen|japan yens")
        .put("Kazakhstani tenge", "kazakhstani tenge|kazakh tenge|kazak tenge|kzt")
        .put("Kenyan shilling", "kenyan shilling|kes")
        .put("North Korean won", "north korean won|kpw|north korean wons")
        .put("South Korean won", "south korean won|krw|south korean wons")
        .put("Korean won", "korean won|₩|korean wons")
        .put("Kyrgyzstani som", "kyrgyzstani som|kgs")
        .put("Uzbekitan som", "uzbekitan som|uzs")
        .put("Lao kip", "lao kip|lak|₭n|₭")
        .put("Att", "att")
        .put("Lesotho loti", "lesotho loti|lsl|loti")
        .put("Sente", "sente|lisente")
        .put("South African rand", "south african rand|zar|south africa rand|south africa rands|south african rands")
        .put("Macanese pataca", "macanese pataca|mop$|mop")
        .put("Avo", "avos|avo")
        .put("Macedonian denar", "macedonian denar|mkd|ден")
        .put("Deni", "deni")
        .put("Malagasy ariary", "malagasy ariary|mga")
        .put("Iraimbilanja", "iraimbilanja")
        .put("Malawian kwacha", "malawian kwacha|mk|mwk")
        .put("Tambala", "tambala")
        .put("Malaysian ringgit", "malaysian ringgit|rm|myr|malaysia ringgit|malaysia ringgits|malaysian ringgits")
        .put("Mauritanian ouguiya", "mauritanian ouguiya|um|mro|mauritania ouguiya|mauritania ouguiyas|mauritanian ouguiyas")
        .put("Khoums", "khoums")
        .put("Mongolian tögrög", "mongolian tögrög|mnt|₮|mongolia tögrög|mongolia tögrögs|mongolian tögrögs|mongolian togrog|mongolian togrogs|mongolia togrog|mongolia togrogs")
        .put("Mozambican metical", "mozambican metical|mt|mzn|mozambica metical|mozambica meticals|mozambican meticals")
        .put("Burmese kyat", "burmese kyat|ks|mmk")
        .put("Pya", "pya")
        .put("Nicaraguan córdoba", "nicaraguan córdoba|nio")
        .put("Nigerian naira", "nigerian naira|naira|ngn|₦|nigeria naira|nigeria nairas|nigerian nairas")
        .put("Kobo", "kobo")
        .put("Turkish lira", "turkish lira|try|tl|turkey lira|turkey liras|turkish liras")
        .put("Kuruş", "kuruş")
        .put("Omani rial", "omani rial|omr|ر.ع.")
        .put("Panamanian balboa", "panamanian balboa|b/.|pab")
        .put("Centesimo", "centesimo")
        .put("Papua New Guinean kina", "papua new guinean kina|kina|pgk")
        .put("Toea", "toea")
        .put("Paraguayan guaraní", "paraguayan guaraní|₲|pyg")
        .put("Peruvian sol", "peruvian sol|soles|sol|peruvian nuevo sol")
        .put("Polish złoty", "złoty|polish złoty|zł|pln|zloty|polish zloty|poland zloty|poland złoty")
        .put("Grosz", "groszy|grosz|grosze")
        .put("Qatari riyal", "qatari riyal|qar|qatari riyals|qatar riyal|qatar riyals")
        .put("Saudi riyal", "saudi riyal|sar|saudi riyals")
        .put("Riyal", "riyal|riyals|rial|﷼")
        .put("Dirham", "dirham|dirhem|dirhm")
        .put("Halala", "halalas|halala")
        .put("Samoan tālā", "samoan tālā|tālā|tala|ws$|samoa|wst|samoan tala")
        .put("Sene", "sene")
        .put("São Tomé and Príncipe dobra", "são tomé and príncipe dobra|dobras|dobra")
        .put("Sierra Leonean leone", "sierra leonean leone|sll|leone|le")
        .put("Peseta", "pesetas|peseta")
        .put("Netherlands guilder", "florin|netherlands antillean guilder|ang|nederlandse gulden|guilders|guilder|gulden|-guilders|-guilder|dutch guilders|dutch guilder|fl")
        .put("Swazi lilangeni", "swazi lilangeni|lilangeni|szl|emalangeni")
        .put("Tajikistani somoni", "tajikistani somoni|tjs|somoni")
        .put("Diram", "dirams|diram")
        .put("Thai baht", "thai baht|฿|thb|baht")
        .put("Satang", "satang|satangs")
        .put("Tongan paʻanga", "tongan paʻanga|paʻanga|tongan pa'anga|pa'anga")
        .put("Seniti", "seniti")
        .put("Ukrainian hryvnia", "ukrainian hryvnia|hyrvnia|uah|₴|ukrain hryvnia|ukrain hryvnias|ukrainian hryvnias")
        .put("Vanuatu vatu", "vanuatu vatu|vatu|vuv")
        .put("Venezuelan bolívar", "venezuelan bolívar|venezuelan bolívars|bs.f.|vef|bolívar fuerte|venezuelan bolivar|venezuelan bolivars|venezuela bolivar|venezuela bolivarsvenezuelan bolivar|venezuelan bolivars")
        .put("Vietnamese dong", "vietnamese dong|vnd|đồng|vietnam dong|vietnamese dongs|vietnam dongs")
        .put("Zambian kwacha", "zambian kwacha|zk|zmw|zambia kwacha|kwachas|zambian kwachas")
        .put("Moroccan dirham", "moroccan dirham|mad|د.م.")
        .put("United Arab Emirates dirham", "united arab emirates dirham|د.إ|aed")
        .put("Azerbaijani manat", "azerbaijani manat|azn")
        .put("Turkmenistan manat", "turkmenistan manat|turkmenistan new manat|tmt")
        .put("Manat", "manats|manat")
        .put("Qəpik", "qəpik")
        .put("Somali shilling", "somali shillings|somali shilling|shilin soomaali|-shilin soomaali|scellino|shilin|sh.so.|sos")
        .put("Somaliland shilling", "somaliland shillings|somaliland shilling|soomaaliland shilin")
        .put("Tanzanian shilling", "tanzanian shilling|tanzanian shillings|tsh|tzs|tanzania shilling|tanzania shillings")
        .put("Ugandan shilling", "ugandan shilling|ugandan shillings|ugx|uganda shilling|uganda shillings")
        .put("Romanian leu", "romanian leu|lei|ron|romania leu")
        .put("Moldovan leu", "moldovan leu|mdl|moldova leu")
        .put("Leu", "leu")
        .put("Ban", "bani|-ban|ban")
        .put("Nepalese rupee", "nepalese rupees|nepalese rupee|npr")
        .put("Pakistani rupee", "pakistani rupees|pakistani rupee|pkr")
        .put("Indian rupee", "indian rupees|indian rupee|inr|₹|india rupees|india rupee")
        .put("Seychellois rupee", "seychellois rupees|seychellois rupee|scr|sr|sre")
        .put("Mauritian rupee", "mauritian rupees|mauritian rupee|mur")
        .put("Maldivian rufiyaa", "maldivian rufiyaas|maldivian rufiyaa|mvr|.ރ|maldive rufiyaas|maldive rufiyaa")
        .put("Sri Lankan rupee", "sri lankan rupees|sri lankan rupee|lkr|රු|ரூ")
        .put("Indonesian rupiah", "indonesian rupiah|rupiah|perak|rp|idr")
        .put("Rupee", "rupee|rupees|rs")
        .put("Danish krone", "danish krone|dkk|denmark krone|denmark krones|danish krones")
        .put("Norwegian krone", "norwegian krone|nok|norway krone|norway krones|norwegian krones")
        .put("Faroese króna", "faroese króna|faroese krona")
        .put("Icelandic króna", "icelandic króna|isk|icelandic krona|iceland króna|iceland krona")
        .put("Swedish krona", "swedish krona|sek|swedan krona")
        .put("Krone", "kronor|krona|króna|krone|krones|kr|-kr")
        .put("Øre", "Øre|oyra|eyrir")
        .put("West African CFA franc", "west african cfa franc|xof|west africa cfa franc|west africa franc|west african franc")
        .put("Central African CFA franc", "central african cfa franc|xaf|central africa cfa franc|central african franc|central africa franc")
        .put("Comorian franc", "comorian franc|kmf")
        .put("Congolese franc", "congolese franc|cdf")
        .put("Burundian franc", "burundian franc|bif")
        .put("Djiboutian franc", "djiboutian franc|djf")
        .put("CFP franc", "cfp franc|xpf")
        .put("Guinean franc", "guinean franc|gnf")
        .put("Swiss franc", "swiss francs|swiss franc|chf|sfr.")
        .put("Rwandan franc", "Rwandan franc|rwf|rf|r₣|frw")
        .put("Belgian franc", "belgian franc|bi.|b.fr.|bef|belgium franc")
        .put("Rappen", "rappen|-rappen")
        .put("Franc", "francs|franc|fr.|fs")
        .put("Centime", "centimes|centime|santim")
        .put("Russian ruble", "russian ruble|₽|rub|russia ruble|russia ₽|russian ₽|russian rubles|russia rubles")
        .put("New Belarusian ruble", "new belarusian ruble|byn|new belarus ruble|new belarus rubles|new belarusian rubles")
        .put("Old Belarusian ruble", "old belarusian ruble|byr|old belarus ruble|old belarus rubles|old belarusian rubles")
        .put("Transnistrian ruble", "transnistrian ruble|prb|р.")
        .put("Belarusian ruble", "belarusian ruble|belarus ruble|belarus rubles|belarusian rubles")
        .put("Kopek", "kopek|kopeks")
        .put("Kapyeyka", "kapyeyka")
        .put("Ruble", "rubles|ruble|br")
        .put("Algerian dinar", "algerian dinar|د.ج|dzd|algerian dinars|algeria dinar|algeria dinars")
        .put("Bahraini dinar", "bahraini dinars|bahraini dinar|bhd|.د.ب")
        .put("Santeem", "santeem|santeems")
        .put("Iraqi dinar", "iraqi dinars|iraqi dinar|iraq dinars|iraq dinar|iqd|ع.د")
        .put("Jordanian dinar", "jordanian dinars|jordanian dinar|د.ا|jod|jordan dinar|jordan dinars")
        .put("Kuwaiti dinar", "kuwaiti dinars|kuwaiti dinar|kwd|د.ك")
        .put("Libyan dinar", "libyan dinars|libyan dinar|libya dinars|libya dinar|lyd")
        .put("Serbian dinar", "serbian dinars|serbian dinar|din.|rsd|дин.|serbia dinars|serbia dinar")
        .put("Tunisian dinar", "tunisian dinars|tunisian dinar|tnd|tunisia dinars|tunisia dinar")
        .put("Yugoslav dinar", "yugoslav dinars|yugoslav dinar|yun")
        .put("Dinar", "dinars|dinar|denar|-dinars|-dinar")
        .put("Fils", "fils|fulūs|-fils|-fil")
        .put("Para", "para|napa")
        .put("Millime", "millimes|millime")
        .put("Argentine peso", "argentine peso|ars|argetina peso|argetina pesos|argentine pesos")
        .put("Chilean peso", "chilean pesos|chilean peso|clp|chile peso|chile peso")
        .put("Colombian peso", "colombian pesos|colombian peso|cop|colombia peso|colombia pesos")
        .put("Cuban convertible peso", "cuban convertible pesos|cuban convertible peso|cuc|cuba convertible pesos|cuba convertible peso")
        .put("Cuban peso", "cuban pesos|cuban peso|cup|cuba pesos|cuba peso")
        .put("Dominican peso", "dominican pesos|dominican peso|dop|dominica pesos|dominica peso")
        .put("Mexican peso", "mexican pesos|mexican peso|mxn|mexico pesos|mexico peso|mxn$|mxn $|mex$")
        .put("Philippine peso", "piso|philippine pesos|philippine peso|₱|php")
        .put("Uruguayan peso", "uruguayan pesos|uruguayan peso|uyu")
        .put("Peso", "pesos|peso")
        .put("Centavo", "centavos|centavo")
        .put("Alderney pound", "alderney pounds|alderney pound|alderney £")
        .put("British pound", "british pounds|british pound|british £|gbp|pound sterling|pound sterlings|sterling|pound scot|pound scots")
        .put("Guernsey pound", "guernsey pounds|guernsey £|ggp")
        .put("Ascension pound", "ascension pounds|ascension pound|ascension £")
        .put("Saint Helena pound", "saint helena pounds|saint helena pound|saint helena £|shp")
        .put("Egyptian pound", "egyptian pounds|egyptian pound|egyptian £|egp|ج.م|egypt pounds|egypt pound")
        .put("Falkland Islands pound", "falkland islands pounds|falkland islands pound|falkland islands £|fkp|falkland island pounds|falkland island pound|falkland island £")
        .put("Gibraltar pound", "gibraltar pounds|gibraltar pound|gibraltar £|gip")
        .put("Manx pound", "manx pounds|manx pound|manx £|imp")
        .put("Jersey pound", "jersey pounds|jersey pound|jersey £|jep")
        .put("Lebanese pound", "lebanese pounds|lebanese pound|lebanese £|lebanan pounds|lebanan pound|lebanan £|lbp|ل.ل")
        .put("South Georgia and the South Sandwich Islands pound", "south georgia and the south sandwich islands pounds|south georgia and the south sandwich islands pound|south georgia and the south sandwich islands £")
        .put("South Sudanese pound", "south sudanese pounds|south sudanese pound|south sudanese £|ssp|south sudan pounds|south sudan pound|south sudan £")
        .put("Sudanese pound", "sudanese pounds|sudanese pound|sudanese £|ج.س.|sdg|sudan pounds|sudan pound|sudan £")
        .put("Syrian pound", "syrian pounds|syrian pound|syrian £|ل.س|syp|syria pounds|syria pound|syria £")
        .put("Tristan da Cunha pound", "tristan da cunha pounds|tristan da cunha pound|tristan da cunha £")
        .put("Pound", "pounds|pound|-pounds|-pound|£")
        .put("Pence", "pence")
        .put("Shilling", "shillings|shilling|shilingi|sh")
        .put("Penny", "pennies|penny")
        .put("United States dollar", "united states dollars|united states dollar|united states $|u.s. dollars|u.s. dollar|u s dollar|u s dollars|usd|american dollars|american dollar|us$|us dollar|us dollars|u.s dollar|u.s dollars|usd$")
        .put("East Caribbean dollar", "east caribbean dollars|east caribbean dollar|east Caribbean $|xcd")
        .put("Australian dollar", "australian dollars|australian dollar|australian $|australian$|aud|australia dollars|australia dollar|australia $|australia$")
        .put("Bahamian dollar", "bahamian dollars|bahamian dollar|bahamian $|bahamian$|bsd|bahamia dollars|bahamia dollar|bahamia $|bahamia$")
        .put("Barbadian dollar", "barbadian dollars|barbadian dollar|barbadian $|bbd")
        .put("Belize dollar", "belize dollars|belize dollar|belize $|bzd")
        .put("Bermudian dollar", "bermudian dollars|bermudian dollar|bermudian $|bmd|bermudia dollars|bermudia dollar|bermudia $")
        .put("British Virgin Islands dollar", "british virgin islands dollars|british virgin islands dollar|british virgin islands $|bvi$|virgin islands dollars|virgin islands dolalr|virgin islands $|virgin island dollars|virgin island dollar|virgin island $")
        .put("Brunei dollar", "brunei dollar|brunei $|bnd")
        .put("Sen", "sen")
        .put("Singapore dollar", "singapore dollars|singapore dollar|singapore $|s$|sgd")
        .put("Canadian dollar", "canadian dollars|canadian dollar|canadian $|cad|can$|c$|canada dollars|canada dolllar|canada $")
        .put("Cayman Islands dollar", "cayman islands dollars|cayman islands dollar|cayman islands $|kyd|ci$|cayman island dollar|cayman island doolars|cayman island $")
        .put("New Zealand dollar", "new zealand dollars|new zealand dollar|new zealand $|nz$|nzd|kiwi")
        .put("Cook Islands dollar", "cook islands dollars|cook islands dollar|cook islands $|cook island dollars|cook island dollar|cook island $")
        .put("Fijian dollar", "fijian dollars|fijian dollar|fijian $|fjd|fiji dollars|fiji dollar|fiji $")
        .put("Guyanese dollar", "guyanese dollars|guyanese dollar|gyd|gy$")
        .put("Hong Kong dollar", "hong kong dollars|hong kong dollar|hong kong $|hk$|hkd|hk dollars|hk dollar|hk $|hongkong$")
        .put("Jamaican dollar", "jamaican dollars|jamaican dollar|jamaican $|j$|jamaica dollars|jamaica dollar|jamaica $|jmd")
        .put("Kiribati dollar", "kiribati dollars|kiribati dollar|kiribati $")
        .put("Liberian dollar", "liberian dollars|liberian dollar|liberian $|liberia dollars|liberia dollar|liberia $|lrd")
        .put("Micronesian dollar", "micronesian dollars|micronesian dollar|micronesian $")
        .put("Namibian dollar", "namibian dollars|namibian dollar|namibian $|nad|n$|namibia dollars|namibia dollar|namibia $")
        .put("Nauruan dollar", "nauruan dollars|nauruan dollar|nauruan $")
        .put("Niue dollar", "niue dollars|niue dollar|niue $")
        .put("Palauan dollar", "palauan dollars|palauan dollar|palauan $")
        .put("Pitcairn Islands dollar", "pitcairn islands dollars|pitcairn islands dollar|pitcairn islands $|pitcairn island dollars|pitcairn island dollar|pitcairn island $")
        .put("Solomon Islands dollar", "solomon islands dollars|solomon islands dollar|solomon islands $|si$|sbd|solomon island dollars|solomon island dollar|solomon island $")
        .put("Surinamese dollar", "surinamese dollars|surinamese dollar|surinamese $|srd")
        .put("New Taiwan dollar", "new taiwan dollars|new taiwan dollar|nt$|twd|ntd")
        .put("Trinidad and Tobago dollar", "trinidad and tobago dollars|trinidad and tobago dollar|trinidad and tobago $|trinidad $|trinidad dollar|trinidad dollars|trinidadian dollar|trinidadian dollars|trinidadian $|ttd")
        .put("Tuvaluan dollar", "tuvaluan dollars|tuvaluan dollar|tuvaluan $")
        .put("Dollar", "dollars|dollar|$")
        .put("Chinese yuan", "yuan|kuai|chinese yuan|renminbi|cny|rmb|￥|元")
        .put("Fen", "fen")
        .put("Jiao", "jiao|mao")
        .put("Finnish markka", "suomen markka|finnish markka|finsk mark|fim|markkaa|markka")
        .put("Penni", "penniä|penni")
        .put("Bitcoin", "bitcoin|bitcoins|btc|xbt|₿")
        .put("Millibitcoin", "millibitcoin|millibitcoins|milibitcoin|milibitcoins")
        .put("Satoshi", "satoshi|satoshis")
        .build();

    public static final ImmutableMap<String, String> CurrencyNameToIsoCodeMap = ImmutableMap.<String, String>builder()
        .put("Afghan afghani", "AFN")
        .put("Euro", "EUR")
        .put("Albanian lek", "ALL")
        .put("Angolan kwanza", "AOA")
        .put("Armenian dram", "AMD")
        .put("Aruban florin", "AWG")
        .put("Bangladeshi taka", "BDT")
        .put("Bhutanese ngultrum", "BTN")
        .put("Bolivian boliviano", "BOB")
        .put("Bosnia and Herzegovina convertible mark", "BAM")
        .put("Botswana pula", "BWP")
        .put("Brazilian real", "BRL")
        .put("Bulgarian lev", "BGN")
        .put("Cambodian riel", "KHR")
        .put("Cape Verdean escudo", "CVE")
        .put("Costa Rican colón", "CRC")
        .put("Croatian kuna", "HRK")
        .put("Czech koruna", "CZK")
        .put("Eritrean nakfa", "ERN")
        .put("Ethiopian birr", "ETB")
        .put("Gambian dalasi", "GMD")
        .put("Georgian lari", "GEL")
        .put("Ghanaian cedi", "GHS")
        .put("Guatemalan quetzal", "GTQ")
        .put("Haitian gourde", "HTG")
        .put("Honduran lempira", "HNL")
        .put("Hungarian forint", "HUF")
        .put("Iranian rial", "IRR")
        .put("Yemeni rial", "YER")
        .put("Israeli new shekel", "ILS")
        .put("Japanese yen", "JPY")
        .put("Kazakhstani tenge", "KZT")
        .put("Kenyan shilling", "KES")
        .put("North Korean won", "KPW")
        .put("South Korean won", "KRW")
        .put("Kyrgyzstani som", "KGS")
        .put("Lao kip", "LAK")
        .put("Lesotho loti", "LSL")
        .put("South African rand", "ZAR")
        .put("Macanese pataca", "MOP")
        .put("Macedonian denar", "MKD")
        .put("Malagasy ariary", "MGA")
        .put("Malawian kwacha", "MWK")
        .put("Malaysian ringgit", "MYR")
        .put("Mauritanian ouguiya", "MRO")
        .put("Mongolian tögrög", "MNT")
        .put("Mozambican metical", "MZN")
        .put("Burmese kyat", "MMK")
        .put("Nicaraguan córdoba", "NIO")
        .put("Nigerian naira", "NGN")
        .put("Turkish lira", "TRY")
        .put("Omani rial", "OMR")
        .put("Panamanian balboa", "PAB")
        .put("Papua New Guinean kina", "PGK")
        .put("Paraguayan guaraní", "PYG")
        .put("Peruvian sol", "PEN")
        .put("Polish złoty", "PLN")
        .put("Qatari riyal", "QAR")
        .put("Saudi riyal", "SAR")
        .put("Samoan tālā", "WST")
        .put("São Tomé and Príncipe dobra", "STN")
        .put("Sierra Leonean leone", "SLL")
        .put("Swazi lilangeni", "SZL")
        .put("Tajikistani somoni", "TJS")
        .put("Thai baht", "THB")
        .put("Ukrainian hryvnia", "UAH")
        .put("Vanuatu vatu", "VUV")
        .put("Venezuelan bolívar", "VEF")
        .put("Zambian kwacha", "ZMW")
        .put("Moroccan dirham", "MAD")
        .put("United Arab Emirates dirham", "AED")
        .put("Azerbaijani manat", "AZN")
        .put("Turkmenistan manat", "TMT")
        .put("Somali shilling", "SOS")
        .put("Tanzanian shilling", "TZS")
        .put("Ugandan shilling", "UGX")
        .put("Romanian leu", "RON")
        .put("Moldovan leu", "MDL")
        .put("Nepalese rupee", "NPR")
        .put("Pakistani rupee", "PKR")
        .put("Indian rupee", "INR")
        .put("Seychellois rupee", "SCR")
        .put("Mauritian rupee", "MUR")
        .put("Maldivian rufiyaa", "MVR")
        .put("Sri Lankan rupee", "LKR")
        .put("Indonesian rupiah", "IDR")
        .put("Danish krone", "DKK")
        .put("Norwegian krone", "NOK")
        .put("Icelandic króna", "ISK")
        .put("Swedish krona", "SEK")
        .put("West African CFA franc", "XOF")
        .put("Central African CFA franc", "XAF")
        .put("Comorian franc", "KMF")
        .put("Congolese franc", "CDF")
        .put("Burundian franc", "BIF")
        .put("Djiboutian franc", "DJF")
        .put("CFP franc", "XPF")
        .put("Guinean franc", "GNF")
        .put("Swiss franc", "CHF")
        .put("Rwandan franc", "RWF")
        .put("Russian ruble", "RUB")
        .put("Transnistrian ruble", "PRB")
        .put("New Belarusian ruble", "BYN")
        .put("Algerian dinar", "DZD")
        .put("Bahraini dinar", "BHD")
        .put("Iraqi dinar", "IQD")
        .put("Jordanian dinar", "JOD")
        .put("Kuwaiti dinar", "KWD")
        .put("Libyan dinar", "LYD")
        .put("Serbian dinar", "RSD")
        .put("Tunisian dinar", "TND")
        .put("Argentine peso", "ARS")
        .put("Chilean peso", "CLP")
        .put("Colombian peso", "COP")
        .put("Cuban convertible peso", "CUC")
        .put("Cuban peso", "CUP")
        .put("Dominican peso", "DOP")
        .put("Mexican peso", "MXN")
        .put("Uruguayan peso", "UYU")
        .put("British pound", "GBP")
        .put("Saint Helena pound", "SHP")
        .put("Egyptian pound", "EGP")
        .put("Falkland Islands pound", "FKP")
        .put("Gibraltar pound", "GIP")
        .put("Manx pound", "IMP")
        .put("Jersey pound", "JEP")
        .put("Lebanese pound", "LBP")
        .put("South Sudanese pound", "SSP")
        .put("Sudanese pound", "SDG")
        .put("Syrian pound", "SYP")
        .put("United States dollar", "USD")
        .put("Australian dollar", "AUD")
        .put("Bahamian dollar", "BSD")
        .put("Barbadian dollar", "BBD")
        .put("Belize dollar", "BZD")
        .put("Bermudian dollar", "BMD")
        .put("Brunei dollar", "BND")
        .put("Singapore dollar", "SGD")
        .put("Canadian dollar", "CAD")
        .put("Cayman Islands dollar", "KYD")
        .put("New Zealand dollar", "NZD")
        .put("Fijian dollar", "FJD")
        .put("Guyanese dollar", "GYD")
        .put("Hong Kong dollar", "HKD")
        .put("Jamaican dollar", "JMD")
        .put("Liberian dollar", "LRD")
        .put("Namibian dollar", "NAD")
        .put("Solomon Islands dollar", "SBD")
        .put("Surinamese dollar", "SRD")
        .put("New Taiwan dollar", "TWD")
        .put("Trinidad and Tobago dollar", "TTD")
        .put("Tuvaluan dollar", "TVD")
        .put("Chinese yuan", "CNY")
        .put("Rial", "__RI")
        .put("Shiling", "__S")
        .put("Som", "__SO")
        .put("Dirham", "__DR")
        .put("Dinar", "_DN")
        .put("Dollar", "__D")
        .put("Manat", "__MA")
        .put("Rupee", "__R")
        .put("Krone", "__K")
        .put("Krona", "__K")
        .put("Crown", "__K")
        .put("Frank", "__F")
        .put("Mark", "__M")
        .put("Ruble", "__RB")
        .put("Peso", "__PE")
        .put("Pound", "__P")
        .put("Tristan da Cunha pound", "_TP")
        .put("South Georgia and the South Sandwich Islands pound", "_SP")
        .put("Somaliland shilling", "_SS")
        .put("Pitcairn Islands dollar", "_PND")
        .put("Palauan dollar", "_PD")
        .put("Niue dollar", "_NID")
        .put("Nauruan dollar", "_ND")
        .put("Micronesian dollar", "_MD")
        .put("Kiribati dollar", "_KID")
        .put("Guernsey pound", "_GGP")
        .put("Faroese króna", "_FOK")
        .put("Cook Islands dollar", "_CKD")
        .put("British Virgin Islands dollar", "_BD")
        .put("Ascension pound", "_AP")
        .put("Alderney pound", "_ALP")
        .put("Abkhazian apsar", "_AA")
        .put("Bitcoin", "_XBT")
        .build();

    public static final ImmutableMap<String, String> FractionalUnitNameToCodeMap = ImmutableMap.<String, String>builder()
        .put("Jiao", "JIAO")
        .put("Kopek", "KOPEK")
        .put("Pul", "PUL")
        .put("Cent", "CENT")
        .put("Qindarkë", "QINDARKE")
        .put("Penny", "PENNY")
        .put("Santeem", "SANTEEM")
        .put("Cêntimo", "CENTIMO")
        .put("Centavo", "CENTAVO")
        .put("Luma", "LUMA")
        .put("Qəpik", "QƏPIK")
        .put("Fils", "FILS")
        .put("Poisha", "POISHA")
        .put("Kapyeyka", "KAPYEYKA")
        .put("Centime", "CENTIME")
        .put("Chetrum", "CHETRUM")
        .put("Paisa", "PAISA")
        .put("Fening", "FENING")
        .put("Thebe", "THEBE")
        .put("Sen", "SEN")
        .put("Stotinka", "STOTINKA")
        .put("Fen", "FEN")
        .put("Céntimo", "CENTIMO")
        .put("Lipa", "LIPA")
        .put("Haléř", "HALER")
        .put("Øre", "ØRE")
        .put("Piastre", "PIASTRE")
        .put("Santim", "SANTIM")
        .put("Oyra", "OYRA")
        .put("Butut", "BUTUT")
        .put("Tetri", "TETRI")
        .put("Pesewa", "PESEWA")
        .put("Fillér", "FILLER")
        .put("Eyrir", "EYRIR")
        .put("Dinar", "DINAR")
        .put("Agora", "AGORA")
        .put("Tïın", "TIIN")
        .put("Chon", "CHON")
        .put("Jeon", "JEON")
        .put("Tyiyn", "TYIYN")
        .put("Att", "ATT")
        .put("Sente", "SENTE")
        .put("Dirham", "DIRHAM")
        .put("Rappen", "RAPPEN")
        .put("Avo", "AVO")
        .put("Deni", "DENI")
        .put("Iraimbilanja", "IRAIMBILANJA")
        .put("Tambala", "TAMBALA")
        .put("Laari", "LAARI")
        .put("Khoums", "KHOUMS")
        .put("Ban", "BAN")
        .put("Möngö", "MONGO")
        .put("Pya", "PYA")
        .put("Kobo", "KOBO")
        .put("Kuruş", "KURUS")
        .put("Baisa", "BAISA")
        .put("Centésimo", "CENTESIMO")
        .put("Toea", "TOEA")
        .put("Sentimo", "SENTIMO")
        .put("Grosz", "GROSZ")
        .put("Sene", "SENE")
        .put("Halala", "HALALA")
        .put("Para", "PARA")
        .put("Öre", "ORE")
        .put("Diram", "DIRAM")
        .put("Satang", "SATANG")
        .put("Seniti", "SENITI")
        .put("Millime", "MILLIME")
        .put("Tennesi", "TENNESI")
        .put("Kopiyka", "KOPIYKA")
        .put("Tiyin", "TIYIN")
        .put("Hào", "HAO")
        .put("Ngwee", "NGWEE")
        .put("Millibitcoin", "MILLIBITCOIN")
        .put("Satoshi", "SATOSHI")
        .build();

    public static final String CompoundUnitConnectorRegex = "(?<spacer>and)";

    public static final String MultiplierRegex = "\\s*\\b(thousand|million|billion|trillion)s?\\b";

    public static final ImmutableMap<String, String> CurrencyPrefixList = ImmutableMap.<String, String>builder()
        .put("Dobra", "db|std")
        .put("Dollar", "$")
        .put("Brazilian Real", "R$")
        .put("United States dollar", "united states $|us$|us $|u.s. $|u.s $|usd$")
        .put("East Caribbean dollar", "east caribbean $")
        .put("Mexican peso", "mxn$|mxn $|mex$")
        .put("Australian dollar", "australian $|australia $")
        .put("Bahamian dollar", "bahamian $|bahamia $")
        .put("Barbadian dollar", "barbadian $|barbadin $")
        .put("Belize dollar", "belize $")
        .put("Bermudian dollar", "bermudian $")
        .put("British Virgin Islands dollar", "british virgin islands $|bvi$|virgin islands $|virgin island $|british virgin island $")
        .put("Brunei dollar", "brunei $|b$")
        .put("Sen", "sen")
        .put("Singapore dollar", "singapore $|s$")
        .put("Canadian dollar", "canadian $|can$|c$|c $|canada $")
        .put("Cayman Islands dollar", "cayman islands $|ci$|cayman island $")
        .put("New Zealand dollar", "new zealand $|nz$|nz $")
        .put("Cook Islands dollar", "cook islands $|cook island $")
        .put("Fijian dollar", "fijian $|fiji $")
        .put("Guyanese dollar", "gy$|gy $|g$|g $")
        .put("Hong Kong dollar", "hong kong $|hk$|hkd|hk $")
        .put("Indian rupee", "₹")
        .put("Jamaican dollar", "jamaican $|j$|jamaica $")
        .put("Kiribati dollar", "kiribati $")
        .put("Liberian dollar", "liberian $|liberia $")
        .put("Micronesian dollar", "micronesian $")
        .put("Namibian dollar", "namibian $|nad|n$|namibia $")
        .put("Nauruan dollar", "nauruan $")
        .put("Niue dollar", "niue $")
        .put("Palauan dollar", "palauan $")
        .put("Pitcairn Islands dollar", "pitcairn islands $|pitcairn island $")
        .put("Solomon Islands dollar", "solomon islands $|si$|si $|solomon island $")
        .put("Surinamese dollar", "surinamese $|surinam $")
        .put("New Taiwan dollar", "nt$|nt $")
        .put("Trinidad and Tobago dollar", "trinidad and tobago $|trinidad $|trinidadian $")
        .put("Tuvaluan dollar", "tuvaluan $")
        .put("Samoan tālā", "ws$")
        .put("Chinese yuan", "￥")
        .put("Japanese yen", "¥")
        .put("Euro", "€")
        .put("Pound", "£")
        .put("Costa Rican colón", "₡")
        .put("Turkish lira", "₺")
        .put("Bitcoin", "₿|btc|xbt")
        .build();

    public static final List<String> AmbiguousCurrencyUnitList = Arrays.asList("din.", "kiwi", "kina", "kobo", "lari", "lipa", "napa", "para", "sfr.", "taka", "tala", "toea", "vatu", "yuan", "all", "ang", "ban", "bob", "btn", "byr", "cad", "cop", "cup", "dop", "gip", "jod", "kgs", "lak", "lei", "mga", "mop", "nad", "omr", "pul", "sar", "sbd", "scr", "sdg", "sek", "sen", "sol", "sos", "std", "try", "yer", "yen", "db", "pen", "ron", "mad", "zar", "gel", "satoshi", "satoshis");

    public static final ImmutableMap<String, String> InformationSuffixList = ImmutableMap.<String, String>builder()
        .put("Bit", "-bit|bit|bits")
        .put("Kilobit", "kilobit|kilobits|kb|Kb|kbit")
        .put("Megabit", "megabit|megabits|mb|Mb|mbit")
        .put("Gigabit", "gigabit|gigabits|gb|Gb|gbit")
        .put("Terabit", "terabit|terabits|tb|Tb|tbit")
        .put("Petabit", "petabit|petabits|pb|Pb|pbit")
        .put("Byte", "-byte|byte|bytes")
        .put("Kilobyte", "-kilobyte|-kilobytes|kilobyte|kB|KB|kilobytes|kilo byte|kilo bytes|kbyte")
        .put("Megabyte", "-megabyte|-megabytes|megabyte|mB|MB|megabytes|mega byte|mega bytes|mbyte")
        .put("Gigabyte", "-gigabyte|-gigabytes|gigabyte|gB|GB|gigabytes|giga byte|giga bytes|gbyte")
        .put("Terabyte", "-terabyte|-terabytes|terabyte|tB|TB|terabytes|tera byte|tera bytes|tbyte")
        .put("Petabyte", "-petabyte|-petabytes|petabyte|pB|PB|petabytes|peta byte|peta bytes|pbyte")
        .build();

    public static final List<String> AmbiguousDimensionUnitList = Arrays.asList("barrel", "barrels", "grain", "grains", "pound", "stone", "stones", "yards", "yard", "cord", "cords", "dram", "drachm", "drachma", "feet", "foot", "gill", "knot", "knots", "peck", "pecks", "cup", "cups", "fps", "pts", "in", "dm", "\"", "pinch", "pinches");

    public static final String BuildPrefix = "(?<=(\\s|^))";

    public static final String BuildSuffix = "(?=(\\s|\\W|$))";

    public static final ImmutableMap<String, String> LengthSuffixList = ImmutableMap.<String, String>builder()
        .put("Kilometer", "km|kilometer|kilometre|kilometers|kilometres|kilo meter|kilo meters|kilo metres|kilo metre")
        .put("Hectometer", "hm|hectometer|hectometre|hectometers|hectometres|hecto meter|hecto meters|hecto metres|hecto metre")
        .put("Decameter", "dam|decameter|decametre|decameters|decametres|deca meter|deca meters|deca metres|deca metre")
        .put("Meter", "m|meter|metre|meters|metres")
        .put("Decimeter", "dm|decimeter|decimeters|decimetre|decimetres|deci meter|deci meters|deci metres|deci metre")
        .put("Centimeter", "cm|centimeter|centimeters|centimetre|centimetres|centi meter|centi meters|centi metres|centi metre")
        .put("Millimeter", "mm|millimeter|millimeters|millimetre|millimetres|milli meter|milli meters|milli metres|milli metre")
        .put("Micrometer", "μm|micrometer|micrometre|micrometers|micrometres|micro meter|micro meters|micro metres|micro metre")
        .put("Nanometer", "nm|nanometer|nanometre|nanometers|nanometres|nano meter|nano meters|nano metres|nano metre")
        .put("Picometer", "pm|picometer|picometre|picometers|picometres|pico meter|pico meters|pico metres|pico metre")
        .put("Mile", "-mile|mile|miles")
        .put("Yard", "yard|yards")
        .put("Inch", "-inch|inch|inches|in|\"")
        .put("Foot", "-foot|foot|feet|ft")
        .put("Light year", "light year|light-year|light years|light-years")
        .put("Pt", "pt|pts")
        .build();

    public static final List<String> AmbiguousLengthUnitList = Arrays.asList("m", "yard", "yards", "pm", "pt", "pts");

    public static final ImmutableMap<String, String> SpeedSuffixList = ImmutableMap.<String, String>builder()
        .put("Meter per second", "meter/second|meters/second|meters / second|m/s|meters per second|metres per second|meter per second|metre per second")
        .put("Kilometer per hour", "km/h|kilometres per hour|kilometers per hour|kilometer per hour|kilometre per hour|kph|kmph|km/hr")
        .put("Kilometer per minute", "km/min|kilometers per minute|kilometres per minute|kilometer per minute|kilometre per minute")
        .put("Kilometer per second", "km/s|kilometers per second|kilometres per second|kilometer per second|kilometre per second")
        .put("Mile per hour", "mph|mile per hour|miles per hour|mi/h|mile / hour|miles / hour|miles an hour|mi/hr")
        .put("Knot", "kt|knot|knots|kn")
        .put("Foot per second", "ft/s|foot/s|feet/s|foot per second|feet per second|fps")
        .put("Foot per minute", "ft/min|foot/min|feet/min|foot per minute|feet per minute")
        .put("Yard per minute", "yards per minute|yard per minute|yards / minute|yards/min|yard/min")
        .put("Yard per second", "yards per second|yard per second|yards / second|yards/s|yard/s")
        .put("Meter per millisecond", "meter/millisecond|meters/millisecond|meter / millisecond|meters / millisecond|meter per millisecond|meters per millisecond|m/ms")
        .put("Centimeter per millisecond", "centimeter/millisecond|centimeters/millisecond|centimeter / millisecond|centimeters / millisecond|centimeter per millisecond|centimeters per millisecond|cm/ms")
        .put("Kilometer per millisecond", "kilometer/millisecond|kilometers/millisecond|kilometer / millisecond|kilometers / millisecond|kilometer per millisecond|kilometers per millisecond|km/ms")
        .build();

    public static final List<String> AmbiguousSpeedUnitList = Arrays.asList("knot", "knots", "fps");

    public static final ImmutableMap<String, String> TemperatureSuffixList = ImmutableMap.<String, String>builder()
        .put("F", "degrees fahrenheit|degree fahrenheit|deg fahrenheit|degs fahrenheit|fahrenheit|°f|° f|degrees farenheit|degree farenheit|deg farenheit|degs farenheit|degrees f|degree f|deg f|degs f|farenheit|f")
        .put("K", "k|K|kelvin")
        .put("R", "rankine|°r")
        .put("D", "delisle|°de")
        .put("C", "degrees celsius|degree celsius|deg celsius|degs celsius|celsius|degrees celcius|degree celcius|celcius|deg celcius|degs celcius|degrees centigrade|degree centigrade|centigrade|degrees centigrate|degree centigrate|degs centigrate|deg centigrate|centigrate|degrees c|degree c|deg c|degs c|°c|° c|c")
        .put("Degree", "degree|degrees|deg.|deg|°")
        .build();

    public static final List<String> AmbiguousTemperatureUnitList = Arrays.asList("c", "f", "k");

    public static final ImmutableMap<String, String> VolumeSuffixList = ImmutableMap.<String, String>builder()
        .put("Cubic meter", "m3|cubic meter|cubic meters|cubic metre|cubic metres")
        .put("Cubic centimeter", "cubic centimeter|cubic centimetre|cubic centimeters|cubic centimetres")
        .put("Cubic millimiter", "cubic millimiter|cubic millimitre|cubic millimiters|cubic millimitres")
        .put("Hectoliter", "hectoliter|hectolitre|hectoliters|hectolitres")
        .put("Decaliter", "decaliter|decalitre|dekaliter|dekalitre|decaliters|decalitres|dekaliters|dekalitres")
        .put("Liter", "l|litre|liter|liters|litres")
        .put("Deciliter", "dl|deciliter|decilitre|deciliters|decilitres")
        .put("Centiliter", "cl|centiliter|centilitre|centiliters|centilitres")
        .put("Milliliter", "ml|mls|millilitre|milliliter|millilitres|milliliters|cc")
        .put("Cubic yard", "cubic yard|cubic yards")
        .put("Cubic inch", "cubic inch|cubic inches")
        .put("Cubic foot", "cubic foot|cubic feet")
        .put("Cubic mile", "cubic mile|cubic miles")
        .put("Fluid ounce", "fl oz|fluid ounce|fluid ounces")
        .put("Teaspoon", "teaspoon|teaspoons|teaspoonful|teaspoonfuls|tsp|tsp.|tspn|tspn.|tea spoon|tea spoons|t.|ts.")
        .put("Tablespoon", "tablespoon|tablespoons|tablespoonful|tablespoonfuls|tbl|tbl.|tbs|tbs.|tbsp|tbsp.|table spoon|table spoons|T.|Tb.|tbls.|tbls")
        .put("Pint", "pint|pints|fl pt| fluid pint")
        .put("Quart", "quart|quarts|fl qt")
        .put("Cup", "cup|cups")
        .put("Gill", "gill|gills")
        .put("Pinch", "pinch|pinches")
        .put("Fluid Dram", "fluid dram|fluid drachm|fluid drachma|fluidram|fluidrams")
        .put("Barrel", "barrel|bbl|barrels")
        .put("Minim", "minim")
        .put("Cord", "cord|cords")
        .put("Peck", "peck|pecks")
        .put("Bushel", "bushel")
        .put("Hogshead", "hogshead")
        .build();

    public static final List<String> AmbiguousVolumeUnitList = Arrays.asList("l", "ounce", "oz", "cup", "cups", "peck", "pecks", "cord", "cords", "gill", "gills", "barrel", "barrels", "tbl", "quart", "quarts", "pinch", "t.", "T.", "Tb.", "ts.");

    public static final ImmutableMap<String, String> WeightSuffixList = ImmutableMap.<String, String>builder()
        .put("Kilogram", "kg|kilogram|kilograms|kilo|kilos|kilogramme|kilogrammes")
        .put("Gram", "g|gram|grams|gm|gramme|grammes")
        .put("Milligram", "mg|milligram|milligrams|milligramme|milligrammes")
        .put("Microgram", "μg|microgram|micrograms|micro gram|micro grams|microgramme|microgrammes|mcg")
        .put("Gallon", "-gallon|gallons|gallon|gal")
        .put("Metric ton", "metric tons|metric ton")
        .put("Ton", "-ton|ton|tons|tonne|tonnes|t")
        .put("Pound", "pound|pounds|lb|lbs")
        .put("Ounce", "-ounce|ounce|oz|ounces")
        .put("Grain", "grain|grains|gr")
        .put("Pennyweight", "pennyweight")
        .put("Long ton (British)", "british long ton|long ton (british)")
        .put("Short ton (US)", "us short ton|short ton (us)")
        .put("Short hundredweight (US)", "us short hundredweight|short hundredweight (us)")
        .put("Stone", "stone")
        .put("Dram", "dram|drachm|drachma|roman drachma|greek drachma")
        .build();

    public static final List<String> AmbiguousWeightUnitList = Arrays.asList("g", "t", "gr", "oz", "stone", "dram", "lbs", "gal", "grain", "grains");

    public static final ImmutableMap<String, String> AngleSuffixList = ImmutableMap.<String, String>builder()
        .put("Degree", "degree|degrees|deg.|deg|°")
        .put("Radian", "radian|radians|rad")
        .put("Turn", "turn|turns")
        .build();

    public static final List<String> AmbiguousAngleUnitList = Arrays.asList("turn", "turns");

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("\\bm\\b", "((('|’)\\s*m)|(m\\s*('|’)))")
        .put("^\\d{5} [cf]$", "\\b([a-z]{2} \\d{5} [cf])\\b")
        .put("\\b\\d+\\s*\\p{L}+$", "((\\d+(\\s*\\p{L}+[-—–-]|\\p{L}+)\\d+)|(((\\p{L}|\\d)[-—–-]\\d+\\s*|\\p{L}\\d+)\\p{L}+))")
        .put("^(all|bob|pen|cad|cup|cop|sos|ron|mad|mop|zar|gel)", "(all|bob|pen|cad|cup|cop|sos|ron|mad|mop|zar|gel)\\s*(\\d|\\p{L})")
        .put("\\d\\s*pm\\b", "\\b(at|until|since|before|after)\\s\\d(\\d)?\\s*pm\\b")
        .put("\\bin\\b", "\\bin\\s*(\\d{4}|(jan|febr)uary|march|april|may|ju(ne|ly)|august|october|(sept|nov|dec)ember)")
        .put("\\b(13)?f\\b", "(\\bf-series\\b|\\b13f\\s(filings?|be fill?ed))")
        .put("\\d\\d\\df", "boeing\\s777f")
        .put("\\bc\\b", "\\bc\\.p\\.i(\\.)?")
        .put("\\d\\s*c\\b", "(dividend (of|by) (\\d\\.)?\\d(\\d)?\\s*c|(\\d\\.)?\\d(\\d)?\\s*c/? (a share|per security))")
        .build();

    public static final ImmutableMap<String, String> TemperatureAmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("\\b(deg(rees?)?|°)$", "\\b((deg(rees?)?|°)\\s*(angle|rotation)|(rotat(ion|e[ds]?|ing)|angle)(\\s+(\\p{L}+|\\d+)){0,4}\\s*(deg(rees?)?\\b|°))")
        .build();

    public static final ImmutableMap<String, String> DimensionAmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("\\b(deg(rees?)?|°)$", "\\b((deg(rees?)?|°)\\s*(c(elsius|entigrate)?|f(ah?renheit)?)|(temperature)(\\s+(\\p{L}+|\\d+)){0,4}\\s*(deg(rees?)?\\b|°))")
        .put("\\b\\d+\\s*\\p{L}+$", "((\\d+\\s*\\p{L}+\\d+)|(\\p{L}\\d+\\s*\\p{L}+))")
        .build();
}
