// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class SpanishDateTime {

    public static final String LangMarker = "Spa";

    public static final Boolean CheckBothBeforeAfter = false;

    public static final String TillRegex = "(?<till>\\b(hasta|hacia|al?)\\b(\\s+(el|la(s)?)\\b)?|{BaseDateTime.RangeConnectorSymbolRegex})"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String StrictTillRegex = "(?<till>\\b(hasta|hacia|al?)(\\s+(el|la(s)?))?\\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*[qt][1-4](?!(\\s+de|\\s*,\\s*))))"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String RangeConnectorRegex = "(?<and>\\b(y\\s*(el|(la(s)?)?))\\b|{BaseDateTime.RangeConnectorSymbolRegex})"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String WrittenDayRegex = "(?<day>uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieciséis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintidós|veintitrés|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|treinta(\\s+y\\s+uno)?)";

    public static final String DayRegex = "\\b(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(?:\\.[º°])?(?=\\b|t)";

    public static final String MonthNumRegex = "(?<month>1[0-2]|(0)?[1-9])\\b";

    public static final String OclockRegex = "(?<oclock>en\\s+punto)";

    public static final String AmDescRegex = "({BaseDateTime.BaseAmDescRegex})"
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex);

    public static final String PmDescRegex = "({BaseDateTime.BasePmDescRegex})"
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String AmPmDescRegex = "({BaseDateTime.BaseAmPmDescRegex})"
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex);

    public static final String DescRegex = "(?<desc>({AmDescRegex}|{PmDescRegex}))"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String OfPrepositionRegex = "(\\bd(o|al?|el?)\\b)";

    public static final String AfterNextSuffixRegex = "\\b(despu[eé]s\\s+de\\s+la\\s+pr[oó]xima)\\b";

    public static final String NextSuffixRegex = "\\b(que\\s+viene|pr[oó]xim[oa]|siguiente)\\b";

    public static final String PreviousSuffixRegex = "\\b(pasad[ao]|anterior(?!\\s+(al?|del?)\\b))\\b";

    public static final String RelativeSuffixRegex = "({AfterNextSuffixRegex}|{NextSuffixRegex}|{PreviousSuffixRegex})"
            .replace("{AfterNextSuffixRegex}", AfterNextSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex)
            .replace("{PreviousSuffixRegex}", PreviousSuffixRegex);

    public static final String RangePrefixRegex = "((de(l|sde)?|entre)(\\s+la(s)?)?)";

    public static final String TwoDigitYearRegex = "\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d))|\\.?[º°ª])\\b"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String RelativeRegex = "(?<order>est[ae]s?|pr[oó]xim[oa]s?|siguiente|(([uú]ltim|pasad)[ao]s?))\\b";

    public static final String StrictRelativeRegex = "(?<order>est[ae]|pr[oó]xim[oa]|siguiente|(([uú]ltim|pasad)(o|as|os)))\\b";

    public static final String WrittenOneToNineRegex = "(un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)";

    public static final String WrittenOneHundredToNineHundredRegex = "(doscient[oa]s|trescient[oa]s|cuatrocient[ao]s|quinient[ao]s|seiscient[ao]s|setecient[ao]s|ochocient[ao]s|novecient[ao]s|cien(to)?)";

    public static final String WrittenOneToNinetyNineRegex = "(((treinta|cuarenta|cincuenta|sesenta|setenta|ochenta|noventa)(\\s+y\\s+{WrittenOneToNineRegex})?)|diez|once|doce|trece|catorce|quince|dieciséis|dieciseis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintiún|veintiun|veintiuna|veintidós|veintidos|veintitrés|veintitres|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String FullTextYearRegex = "\\b(?<fullyear>((dos\\s+)?mil)(\\s+{WrittenOneHundredToNineHundredRegex})?(\\s+{WrittenOneToNinetyNineRegex})?)"
            .replace("{WrittenOneToNinetyNineRegex}", WrittenOneToNinetyNineRegex)
            .replace("{WrittenOneHundredToNineHundredRegex}", WrittenOneHundredToNineHundredRegex);

    public static final String YearRegex = "({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String RelativeMonthRegex = "(?<relmonth>(de\\s+)?((este|pr[oó]ximo|([uú]ltim(o|as|os)))\\s+mes)|(del\\s+)?(mes\\s+((que\\s+viene)|pasado)))\\b";

    public static final String MonthRegex = "\\b(?<month>abr(\\.|(il)?\\b)|ago(\\.|(sto)?\\b)|dic(\\.|(iembre)?\\b)|feb(\\.|(rero)?\\b)|ene(\\.|(ro)?\\b)|ju[ln](\\.|(io)?\\b)|mar(\\.|(zo)?\\b)|may(\\.|(o)?\\b)|nov(\\.|(iembre)?\\b)|oct(\\.|(ubre)?\\b)|sep?t(\\.|(iembre)?\\b)|sep(\\.|\\b))";

    public static final String MonthSuffixRegex = "(?<msuf>((del?|la|el)\\s+)?({RelativeMonthRegex}|{MonthRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String DateUnitRegex = "(?<unit>(año|(?<uoy>semana))(?<plural>s)?|(?<uoy>mes)(?<plural>es)?|(?<uoy>d[ií]a)(?<plural>s)?(?<business>\\s+(h[aá]biles|laborales))?)\\b";

    public static final String PastRegex = "(?<past>\\b(pasad(a|o)(s)?|[uú]ltim[oa](s)?|anterior(es)?|previo(s)?)\\b)";

    public static final String FutureRegex = "\\b(siguiente(s)?|pr[oó]xim[oa](s)?)\\b";

    public static final String SimpleCasesRegex = "\\b((desde(\\s+el)?|entre|del?)\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*)((en|del?)\\s+)?{YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontSimpleCasesRegex = "\\b{MonthSuffixRegex}\\s+((desde(\\s+el)?|entre|del)\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*)((en|del?)\\s+)?{YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontBetweenRegex = "\\b{MonthSuffixRegex}\\s+((entre(\\s+el)?)\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*)((en|del?)\\s+)?{YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String DayBetweenRegex = "\\b((entre(\\s+el)?)\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*)((en|del?)\\s+)?{YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String SpecialYearPrefixes = "((del\\s+)?calend[aá]rio|(?<special>fiscal|escolar))";

    public static final String OneWordPeriodRegex = "\\b(((((la|el)\\s+)?mes\\s+(({OfPrepositionRegex})\\s+)?)|((pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?)\\s+))?({MonthRegex})|((el\\s+)?{RelativeRegex}\\s+)?(({SpecialYearPrefixes}\\s+)año|año\\s+{SpecialYearPrefixes})|(((la|el)\\s+)?((({RelativeRegex}\\s+)({DateUnitRegex}|(fin\\s+de\\s+)?semana|finde)(\\s+{RelativeSuffixRegex})?)|{DateUnitRegex}(\\s+{RelativeSuffixRegex}))|va\\s+de\\s+{DateUnitRegex}|((año|mes)(\\s+(a|hasta)\\s+la\\s+fecha)?|((el\\s+)?fin\\s+de\\s+)?semana|(el\\s+)?finde))\\b)"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{OfPrepositionRegex}", OfPrepositionRegex)
            .replace("{RelativeSuffixRegex}", RelativeSuffixRegex)
            .replace("{DateUnitRegex}", DateUnitRegex)
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes);

    public static final String MonthWithYearRegex = "\\b((((pr[oó]xim[oa](s)?|est?[ae]|[uú]ltim[oa]?)\\s+)?{MonthRegex}|((el\\s+)?(?<cardinal>primero?|1(er|ro)|segundo|2do|tercero?|3(er|ro)|uarto|4to|quinto|5to|sexto|6to|s[eé]ptimo|7mo|octavo|8vo|noveno|9no|d[eé]cimo|10mo|und[eé]cimo|11mo|duod[eé]cimo|12mo|[uú]ltimo)\\s+mes(?=\\s+(del?|en))))((\\s+|(\\s*[,-]\\s*))((de(l|\\s+la)?|en)\\s+)?({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+año)|\\s+(del?|en)\\s+{TwoDigitYearRegex}))\\b"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String MonthNumWithYearRegex = "\\b(({YearRegex}(\\s*?)[/\\-\\.~](\\s*?){MonthNumRegex})|({MonthNumRegex}(\\s*?)[/\\-\\.~](\\s*?){YearRegex}))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String WeekOfMonthRegex = "(?<wom>(la\\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|([12345](\\.)?ª)|[uú]ltima)\\s+semana\\s+{MonthSuffixRegex}((\\s+de)?\\s+({BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\\s+año))?)\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WeekOfYearRegex = "(?<woy>(la\\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|[uú]ltima?|([12345]ª))\\s+semana(\\s+(del?|en))?\\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año))"
            .replace("{YearRegex}", YearRegex);

    public static final String OfYearRegex = "\\b((del?)\\s+({YearRegex}|{StrictRelativeRegex}\\s+año))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String FirstLastRegex = "\\b((el|las?|los?)\\s+)?((?<first>primer([ao]s?)?)|(?<last>[uú]ltim[ao]s?))\\b";

    public static final String FollowedDateUnit = "^\\s*{DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String NumberCombinedWithDateUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String QuarterTermRegex = "\\b((?<cardinal>primer|1er|segundo|2do|tercer|3ro|4to|([1234](\\.)?º))\\s+(trimestre|cuarto)|[tq](?<number>[1-4]))\\b";

    public static final String RelativeQuarterTermRegex = "\\b((?<orderQuarter>{StrictRelativeRegex})\\s+(trimestre|cuarto)|(trimestre|cuarto)\\s+(?<orderQuarter>(actual|pr[oó]ximo|siguiente|pasado|anterior)))\\b"
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String QuarterRegex = "(el\\s+)?{QuarterTermRegex}((\\s+(del?\\s+)?|\\s*[,-]\\s*)({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+a[ñn]o|a[ñn]o(\\s+{RelativeSuffixRegex}))|\\s+del\\s+a[ñn]o)?|{RelativeQuarterTermRegex}"
            .replace("{YearRegex}", YearRegex)
            .replace("{QuarterTermRegex}", QuarterTermRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{RelativeSuffixRegex}", RelativeSuffixRegex)
            .replace("{RelativeQuarterTermRegex}", RelativeQuarterTermRegex);

    public static final String QuarterRegexYearFront = "({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\\s+a[ñn]o)(?:\\s*-\\s*|\\s+(el\\s+)?)?{QuarterTermRegex}"
            .replace("{YearRegex}", YearRegex)
            .replace("{QuarterTermRegex}", QuarterTermRegex);

    public static final String AllHalfYearRegex = "\\b(?<cardinal>primer|1er|segundo|2do|[12](\\.)?º)\\s+semestre(\\s+(de\\s+)?({YearRegex}|{RelativeRegex}\\s+año))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String EarlyPrefixRegex = "\\b(?<EarlyPrefix>(?<RelEarly>m[aá]s\\s+temprano(\\s+(del?|en))?)|((comienzos?|inicios?|principios?|temprano)\\s+({OfPrepositionRegex}(\\s+d[ií]a)?)))(\\s+(el|las?|los?))?\\b"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String MidPrefixRegex = "\\b(?<MidPrefix>(media[dn]os\\s+({OfPrepositionRegex})))(\\s+(el|las?|los?))?\\b"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String LaterPrefixRegex = "\\b(?<LatePrefix>((fin(al)?(es)?|[uú]ltimos)\\s+({OfPrepositionRegex}))|(?<RelLate>m[aá]s\\s+tarde(\\s+(del?|en))?))(\\s+(el|las?|los?))?\\b"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String PrefixPeriodRegex = "({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})"
            .replace("{EarlyPrefixRegex}", EarlyPrefixRegex)
            .replace("{MidPrefixRegex}", MidPrefixRegex)
            .replace("{LaterPrefixRegex}", LaterPrefixRegex);

    public static final String PrefixDayRegex = "\\b((?<EarlyPrefix>(comienzos?|inicios?|principios?|temprano))|(?<MidPrefix>mediados)|(?<LatePrefix>(fin((al)?es)?|m[aá]s\\s+tarde)))(\\s+(en|{OfPrepositionRegex}))?(\\s+([ae]l)(\\s+d[ií]a)?)?$"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String CenturySuffixRegex = "(^siglo)\\b";

    public static final String SeasonRegex = "\\b(?<season>(([uú]ltim[oa]|est[ea]|el|la|(pr[oó]xim[oa]s?|siguiente)|{PrefixPeriodRegex})\\s+)?(?<seas>primavera|verano|otoño|invierno)((\\s+(del?|en)|\\s*,\\s*)?\\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año))?)\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{PrefixPeriodRegex}", PrefixPeriodRegex);

    public static final String WhichWeekRegex = "\\b(semana)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+del?\\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\\s+año|año\\s+(?<order>pasado)))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String WeekOfRegex = "((del?|el|la)\\s+)?(semana)(\\s*)({OfPrepositionRegex}|que\\s+(inicia|comienza)\\s+el|(que\\s+va|a\\s+partir)\\s+del)"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String MonthOfRegex = "(mes)(\\s+)({OfPrepositionRegex})"
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String RangeUnitRegex = "\\b(?<unit>años?|mes(es)?|semanas?)\\b";

    public static final String BeforeAfterRegex = "^[.]";

    public static final String InConnectorRegex = "\\b(en)(?=\\s*$)\\b";

    public static final String TodayNowRegex = "\\b(hoy|ahora|este entonces)\\b";

    public static final String FromRegex = "((\\bde(sde)?)(\\s*la(s)?)?)$";

    public static final String BetweenRegex = "(\\bentre\\s*(la(s)?)?)";

    public static final String WeekDayRegex = "\\b(?<weekday>(domingos?|lunes|martes|mi[eé]rcoles|jueves|viernes|s[aá]bados?)\\b|(lun|mar|mi[eé]|jue|vie|s[aá]b|dom|lu|ma|mi|ju|vi|s[aá]|do)(\\.|\\b))(?!ñ)";

    public static final String OnRegex = "((?<=\\b(e[ln])\\s+)|(\\be[ln]\\s+d[ií]a\\s+))({DayRegex}s?)(?![.,]\\d)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String RelaxedOnRegex = "(?<=\\b(en|d?el)\\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1st|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)s?)(?![.,]\\d)\\b";

    public static final String SpecialDayRegex = "\\b((el\\s+)?(d[ií]a\\s+antes\\s+de\\s+ayer|anteayer)|((el\\s+)?d[ií]a\\s+(despu[eé]s\\s+)?de\\s+mañana|pasado\\s+mañana)|(el\\s)?d[ií]a\\s+(siguiente|anterior)|(el\\s)?pr[oó]ximo\\s+d[ií]a|(el\\s+)?[uú]ltimo\\s+d[ií]a|(d)?el\\s+d[ií]a(?!\\s+(de|internacional))|ayer|mañana|hoy)\\b";

    public static final String SpecialDayWithNumRegex = "^[.]";

    public static final String FlexibleDayRegex = "(?<DayOfMonth>([a-z]+\\s)?({WrittenDayRegex}|{DayRegex}))"
            .replace("{WrittenDayRegex}", WrittenDayRegex)
            .replace("{DayRegex}", DayRegex);

    public static final String ForTheRegex = "\\b((((?<=para\\s+el\\s+){FlexibleDayRegex})|((?<!(\\b{MonthRegex},?|\\bpara)\\s+(el\\s+)|{WeekDayRegex}\\s+(el\\s+)?)((?<=(e[ln]\\s+))|(\\be[ln]\\s+d[ií]a\\s+)){FlexibleDayRegex}))(?<end>\\s*(,|\\.(?![º°ª])|!|\\?|-|$))(?!\\d))"
            .replace("{FlexibleDayRegex}", FlexibleDayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayAndDayOfMonthRegex = "\\b{WeekDayRegex}\\s+((el\\s+(d[ií]a\\s+)?){FlexibleDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayRegex = "\\b{WeekDayRegex}\\s+({DayRegex}|{WrittenDayRegex})(?!([-:/]|\\.\\d|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{WrittenDayRegex}", WrittenDayRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String WeekDayOfMonthRegex = "(?<wom>(el\\s+)?(?<cardinal>primera?|1era?|segund[ao]|2d[ao]|tercera?|3era?|cuart[ao]|4t[ao]|quint[ao]|5t[ao]|((1|2|3|4|5)(\\.)?[ºª])|[uú]ltim[ao])\\s+(semana\\s+{MonthSuffixRegex}\\s+el\\s+{WeekDayRegex}|{WeekDayRegex}\\s+{MonthSuffixRegex}))"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String RelativeWeekDayRegex = "^[.]";

    public static final String AmbiguousRangeModifierPrefix = "^[.]";

    public static final String NumberEndingPattern = "^[.]";

    public static final String DateTokenPrefix = "en ";

    public static final String TimeTokenPrefix = "a las ";

    public static final String TokenBeforeDate = "el ";

    public static final String TokenBeforeTime = "a las ";

    public static final String HalfTokenRegex = "^((y\\s+)?media)";

    public static final String QuarterTokenRegex = "^((y\\s+)?cuarto|(?<neg>menos\\s+cuarto))";

    public static final String PastTokenRegex = "\\b(pasad[ao]s(\\s+(de\\s+)?las)?)$";

    public static final String ToTokenRegex = "\\b((para|antes)(\\s+(de\\s+)?las?)|(?<neg>^menos))$";

    public static final String SpecialDateRegex = "(?<=\\b(en)\\s+el\\s+){DayRegex}\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String OfMonthRegex = "^\\s*((d[ií]a\\s+)?d[eo]\\s+)?{MonthSuffixRegex}"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String MonthEndRegex = "({MonthRegex}\\s*(el)?\\s*$)"
            .replace("{MonthRegex}", MonthRegex);

    public static final String WeekDayEnd = "{WeekDayRegex}\\s*,?\\s*$"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayStart = "^\\b$";

    public static final String DateYearRegex = "(?<year>{YearRegex}|(?<!,\\s?){TwoDigitYearRegex}|{TwoDigitYearRegex}(?=(\\.(?!\\d)|[?!;]|$)))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String DateExtractor1 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?(?<!\\d[.,]){DayRegex}((\\s*(d[eo])|[/\\\\\\.\\-])\\s*)?{MonthRegex}\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String DateExtractor2 = "\\b((el\\s+d[ií]a|{WeekDayRegex})(\\s+|\\s*,\\s*))?(?<!\\d[.,])(({DayRegex}((\\s+(d[eo]\\s+)?|\\s*[.,/-]\\s*){MonthRegex}((\\s+(del?\\s+)?|\\s*[.,/-]\\s*){DateYearRegex}\\b)?|\\s+(d[eo]\\s+){MonthNumRegex}\\s+(del?\\s+{DateYearRegex}\\b)))|{BaseDateTime.FourDigitYearRegex}\\s*[.,/-]?\\s*(el\\s+d[ií]a\\s+)?{DayRegex}(\\s+(d[eo]\\s+)?|\\s*[.,/-]\\s*){MonthRegex})"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String DateExtractor3 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{MonthRegex}(\\s*[.,/-]?\\s*)(el\\s+d[ií]a\\s+)?{DayRegex}(?!\\s*\\-\\s*\\d{2}\\b)((\\s+(del?\\s+)?|\\s*[.,/-]\\s*){DateYearRegex})?\\b"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor4 = "\\b(?<!\\d[.,]){MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}\\s*[/\\\\\\-]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor5 = "\\b(?<!\\d[.,]){DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor6 = "(?<=\\b(en|el)\\s+){MonthNumRegex}[\\-\\.]{DayRegex}{BaseDateTime.CheckDecimalRegex}\\b(?!\\s*[/\\\\\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor7 = "\\b(?<!\\d[.,]){MonthNumRegex}\\s*/\\s*{DayRegex}((\\s+|\\s*,\\s*|\\s+d[eo]\\s+){DateYearRegex})?\\b{BaseDateTime.CheckDecimalRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor8 = "(?<=\\b(en|el)\\s+){DayRegex}[\\\\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\\b(?!\\s*[/\\\\\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor9 = "\\b({WeekDayRegex}\\s+)?(?<!\\d[.,]){DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*|\\s+d[eo]\\s+){DateYearRegex})?\\b{BaseDateTime.CheckDecimalRegex}(?!\\s*[/\\\\\\.]\\s*\\d+)"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor10 = "\\b(?<!\\d[.,])(({YearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+))|({MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{DayRegex})|({DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String HourRegex = "\\b(?<!\\d[,.])(?<hour>2[0-4]|[0-1]?\\d)";

    public static final String HourNumRegex = "\\b(?<hournum>cero|una|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce)\\b";

    public static final String MinuteNumRegex = "(?<minnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)";

    public static final String DeltaMinuteNumRegex = "(?<deltaminnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)";

    public static final String PmRegex = "(?<pm>((por|de|a|en)\\s+la)\\s+(tarde|noche))";

    public static final String AmRegex = "(?<am>((por|de|a|en)\\s+la)\\s+(mañana|madrugada))";

    public static final String AmTimeRegex = "(?<am>(esta|(por|de|a|en)\\s+la)\\s+(mañana|madrugada))";

    public static final String PmTimeRegex = "(?<pm>(esta|(por|de|a|en)\\s+la)\\s+(tarde|noche))";

    public static final String NightTimeRegex = "(noche)";

    public static final String LastNightTimeRegex = "(anoche)";

    public static final String NowTimeRegex = "(ahora|mismo|momento)";

    public static final String RecentlyTimeRegex = "(mente)";

    public static final String AsapTimeRegex = "(posible|pueda[ns]?|podamos)";

    public static final String LessThanOneHour = "(?<lth>((\\s+y\\s+)?cuarto|(\\s*)menos cuarto|(\\s+y\\s+)media|{BaseDateTime.DeltaMinuteRegex}(\\s+(minutos?|mins?))|{DeltaMinuteNumRegex}(\\s+(minutos?|mins?))))"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{DeltaMinuteNumRegex}", DeltaMinuteNumRegex);

    public static final String TensTimeRegex = "(?<tens>diez|veint(i|e)|treinta|cuarenta|cincuenta)";

    public static final String WrittenTimeRegex = "(?<writtentime>{HourNumRegex}\\s*((y|(?<prefix>menos))\\s+)?(({TensTimeRegex}(\\s*y\\s+)?)?{MinuteNumRegex}))"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex)
            .replace("{TensTimeRegex}", TensTimeRegex);

    public static final String TimePrefix = "(?<prefix>{LessThanOneHour}(\\s+(pasad[ao]s)\\s+(de\\s+las|las)?|\\s+(para|antes\\s+de)?\\s+(las?))?)"
            .replace("{LessThanOneHour}", LessThanOneHour);

    public static final String TimeSuffix = "(?<suffix>({LessThanOneHour}\\s+)?({AmRegex}|{PmRegex}|{OclockRegex}))"
            .replace("{LessThanOneHour}", LessThanOneHour)
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String GeneralDescRegex = "({DescRegex}|(?<suffix>{AmRegex}|{PmRegex}))"
            .replace("{DescRegex}", DescRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex);

    public static final String BasicTime = "(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex);

    public static final String MidTimeRegex = "(?<mid>((?<midnight>media\\s*noche)|(?<midearlymorning>media\\s*madrugada)|(?<midmorning>media\\s*mañana)|(?<midafternoon>media\\s*tarde)|(?<midday>medio\\s*d[ií]a)))";

    public static final String AtRegex = "\\b((?<=\\b((a|de(sde)?)\\s+las?|al)\\s+)(({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\\b(\\s*\\bh\\b)?(DescRegex)?|{MidTimeRegex})|{MidTimeRegex})"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String ConnectNumRegex = "({BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex})"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegexWithDotConnector = "({BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex})"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex);

    public static final String TimeRegex1 = "(\\b{TimePrefix}\\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\\s*({DescRegex}|\\s*\\bh\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex2 = "(\\b{TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?:(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?(\\s*({DescRegex}|\\bh\\b)|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex3 = "\\b(({TimePrefix}\\s+)?{TimeRegexWithDotConnector}(\\s*({DescRegex}|{TimeSuffix}|\\bh\\b))|((las\\s+{TimeRegexWithDotConnector})(?!\\s*(por\\s+cien(to)?|%))(\\s*({DescRegex}|{TimeSuffix}|\\bh\\b)|\\b)))"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeTokenPrefix}", TimeTokenPrefix)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex4 = "\\b(({DescRegex}?)|({BasicTime}\\s*)?({GeneralDescRegex}?)){TimePrefix}(\\s*({HourNumRegex}|{BaseDateTime.HourRegex}))?(\\s+{TensTimeRegex}(\\s*(y\\s+)?{MinuteNumRegex})?)?(\\s*({OclockRegex}|{DescRegex}|\\bh\\b)|\\b)"
            .replace("{DescRegex}", DescRegex)
            .replace("{GeneralDescRegex}", GeneralDescRegex)
            .replace("{BasicTime}", BasicTime)
            .replace("{TimePrefix}", TimePrefix)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TensTimeRegex}", TensTimeRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String TimeRegex5 = "\\b({TimePrefix}|{BasicTime}{TimePrefix})\\s+(\\s*{DescRegex})?{BasicTime}?\\s*{TimeSuffix}\\b"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex6 = "({BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}\\b)"
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex7 = "\\b{TimeSuffix}\\s+a\\s+las\\s+{BasicTime}((\\s*{DescRegex}|\\bh\\b)|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex8 = "\\b{TimeSuffix}\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex9 = "\\b(?<writtentime>{HourNumRegex}\\s+({TensTimeRegex}\\s*)(y\\s+)?{MinuteNumRegex}?)\\b"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{TensTimeRegex}", TensTimeRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex);

    public static final String TimeRegex11 = "\\b({WrittenTimeRegex})(\\s+{DescRegex})?\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex12 = "(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String PrepositionRegex = "(?<prep>^(,\\s*)?(a(l)?|en|de(l)?)?(\\s*(la(s)?|el|los))?$)";

    public static final String LaterEarlyRegex = "((?<early>temprano)|(?<late>fin(al)?(\\s+de)?|m[aá]s\\s+tarde))";

    public static final String NowRegex = "\\b(?<now>(justo\\s+)?ahora(\\s+mismo)?|en\\s+este\\s+momento|tan\\s+pronto\\s+como\\s+sea\\s+posible|tan\\s+pronto\\s+como\\s+(pueda|puedas|podamos|puedan)|lo\\s+m[aá]s\\s+pronto\\s+posible|recientemente|previamente|este entonces)\\b";

    public static final String SuffixRegex = "^\\s*(((y|a|en|por)\\s+la|al)\\s+)?(mañana|madrugada|medio\\s*d[ií]a|(?<!(m[áa]s\\s+))tarde|noche)\\b";

    public static final String TimeOfDayRegex = "\\b((?<timeOfDay>(({LaterEarlyRegex}\\s+)((del?|en|por)(\\s+(el|los?|las?))?\\s+)?)?(mañana|madrugada|pasado\\s+(el\\s+)?medio\\s?d[ií]a|(?<!((m[áa]s|tan)\\s+))tarde|noche))|(en|por)\\s+las?\\s+mañana)\\b"
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String SpecificTimeOfDayRegex = "\\b(((((a\\s+)?la|esta|siguiente|pr[oó]xim[oa]|[uú]ltim[oa])\\s+)?{TimeOfDayRegex})|anoche)\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String TimeOfTodayAfterRegex = "^\\s*(,\\s*)?(en|de(l)?\\s+)?{SpecificTimeOfDayRegex}"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex);

    public static final String TimeOfTodayBeforeRegex = "({SpecificTimeOfDayRegex}(\\s*,)?(\\s+(((cerca|alrededor)?\\s*(de|a)\\s+)la(s)?|para))?\\s*$)"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex);

    public static final String NonTimeContextTokens = "(edificio)";

    public static final String SimpleTimeOfTodayAfterRegex = "(?<!{NonTimeContextTokens}\\s*)\\b({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?((en|de(l)?)?\\s+)?{SpecificTimeOfDayRegex}\\b"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex)
            .replace("{NonTimeContextTokens}", NonTimeContextTokens);

    public static final String SimpleTimeOfTodayBeforeRegex = "({SpecificTimeOfDayRegex}(\\s*,)?(\\s+(((cerca|alrededor)?\\s*(de|a)\\s+)la(s)?|para))?\\s*({HourNumRegex}|{BaseDateTime.HourRegex}))\\b"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String SpecificEndOfRegex = "((a|e)l\\s+)?fin(alizar|al)?(\\s+(el|de(l)?)(\\s+d[ií]a)?(\\s+de)?)?\\s*$";

    public static final String UnspecificEndOfRegex = "\\b([ae]l\\s+)?(fin(al)?\\s+del?\\s+d[ií]a)\\b";

    public static final String UnspecificEndOfRangeRegex = "^[.]";

    public static final String DateTimeTimeOfDayRegex = "\\b(?<timeOfDay>mañana|madrugada|(?<pm>pasado\\s+(el\\s+)?medio\\s?d[ií]a|tarde|noche))\\b";

    public static final String PeriodTimeOfDayRegex = "\\b((en\\s+(el|la|lo)?\\s+)?({LaterEarlyRegex}\\s+)?(est[ae]\\s+)?{DateTimeTimeOfDayRegex})\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String PeriodSpecificTimeOfDayRegex = "\\b(({LaterEarlyRegex}\\s+)?est[ae]\\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\\s+{PeriodTimeOfDayRegex})|anoche)\\b"
            .replace("{PeriodTimeOfDayRegex}", PeriodTimeOfDayRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex)
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String UnitRegex = "(?<unit>años?|(bi|tri|cuatri|se)mestre|mes(es)?|semanas?|fin(es)?\\s+de\\s+semana|finde|d[ií]as?|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\\b";

    public static final String ConnectorRegex = "^(,|t|(para|y|a|en|por) las?|(\\s*,\\s*)?((cerca|alrededor)\\s+)?(de\\s+las?|del))$";

    public static final String TimeHourNumRegex = "(?<hour>veint(i(uno|dos|tres|cuatro)|e)|cero|uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieci(s([eé])is|siete|ocho|nueve))";

    public static final String PureNumFromTo = "((\\b(desde|de)\\s+(la(s)?\\s+)?)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})(?!\\s+al?\\b)(\\s*(?<leftDesc>{DescRegex}))?|(\\b(desde|de)\\s+(la(s)?\\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?)\\s*{TillRegex}\\s*({BaseDateTime.HourRegex}|{TimeHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex})?"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String PureNumBetweenAnd = "(\\bentre\\s+(la(s)?\\s+)?)(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?\\s*{RangeConnectorRegex}\\s*(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{BaseDateTime.HourRegex}|{TimeHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex})?"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{BaseDateTime.TwoDigitHourRegex}", BaseDateTime.TwoDigitHourRegex)
            .replace("{BaseDateTime.TwoDigitMinuteRegex}", BaseDateTime.TwoDigitMinuteRegex);

    public static final String SpecificTimeFromTo = "({RangePrefixRegex}\\s+)?(?<time1>(({TimeRegex2}|{TimeRegexWithDotConnector}(\\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{TillRegex}\\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(\\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))"
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{TillRegex}", TillRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{RangePrefixRegex}", RangePrefixRegex);

    public static final String SpecificTimeBetweenAnd = "({BetweenRegex}\\s+)(?<time1>(({TimeRegex1}|{TimeRegex2}|{TimeRegexWithDotConnector}(\\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{RangeConnectorRegex}\\s*(?<time2>(({TimeRegex1}|{TimeRegex2}|{TimeRegexWithDotConnector}(\\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))"
            .replace("{BetweenRegex}", BetweenRegex)
            .replace("{TimeRegex1}", TimeRegex1)
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeUnitRegex = "([^A-Za-z]{1,}|\\b)(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\\b";

    public static final String TimeFollowedUnit = "^\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String TimeNumberCombinedWithUnit = "\\b(?<num>\\d+(\\,\\d*)?)\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String DateTimePeriodNumberCombinedWithUnit = "\\b(?<num>\\d+(\\.\\d*)?)\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String PeriodTimeOfDayWithDateRegex = "\\b(((y|a|en|por)\\s+(la\\s+)?|al\\s+)?((((?<early>primeras\\s+horas\\s+)|(?<late>(últimas|altas)\\s+horas\\s+))(de\\s+la\\s+)?|{LaterEarlyRegex}\\s+(est[ae]\\s+)?)?(?<timeOfDay>(mañana|madrugada|pasado\\s+(el\\s+)?medio\\s?d[ií]a|(?<!(m[áa]s\\s+))tarde|noche|anoche))))(\\s+(del|de))?\\b"
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String RelativeTimeUnitRegex = "({PastRegex}|{FutureRegex})\\s+{TimeUnitRegex}"
            .replace("{PastRegex}", PastRegex)
            .replace("{FutureRegex}", FutureRegex)
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String LessThanRegex = "\\b(dentro\\s+de\\s+menos\\s+de)\\b";

    public static final String MoreThanRegex = "\\b(durante\\s+(m[áa]s\\s+)?de)\\b";

    public static final String SuffixAndRegex = "(?<suffix>\\s*(y)\\s+((un[ao]?)\\s+)?(?<suffix_num>media|cuarto))";

    public static final String FollowedUnit = "^\\s*{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String DurationNumberCombinedWithUnit = "\\b(?<num>\\d+(\\,\\d*)?){UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String AnUnitRegex = "\\b(una?|otr[ao])\\s+{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String DuringRegex = "^[.]";

    public static final String AllRegex = "\\b(?<all>tod[oa]?\\s+(el|la)\\s+(?<unit>año|mes|semana|d[ií]a)|((una?|el|la)\\s+)?(?<unit>año|mes|semana|d[ií]a)\\s+enter[ao])\\b";

    public static final String HalfRegex = "\\b(?<half>medi[oa]\\s+(?<unit>ano|mes|semana|d[íi]a|hora))\\b";

    public static final String ConjunctionRegex = "^[.]";

    public static final String InexactNumberRegex = "\\b(pocos?|algo|vari[ao]s|algun[ao]s|un[ao]s)\\b";

    public static final String InexactNumberUnitRegex = "({InexactNumberRegex})\\s+{UnitRegex}"
            .replace("{InexactNumberRegex}", InexactNumberRegex)
            .replace("{UnitRegex}", UnitRegex);

    public static final String HolidayRegex1 = "\\b(?<holiday>viernes\\s+(santo|negro)|mi[eé]rcoles de ceniza|martes de carnaval|d[ií]a (de|de los) presidentes?|clebraci[oó]n de mao|año nuevo chino|año nuevo|noche vieja|(festividad de )?los mayos|d[ií]a de los inocentes|navidad|noche buena|d[ií]a de acci[oó]n de gracias|acci[oó]n de gracias|yuandan|halloween|noches de brujas|pascuas)(\\s+(del?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String HolidayRegex2 = "\\b(?<holiday>(d[ií]a( del?( la)?)? )?(martin luther king|todos los santos|tierra|blanco|san patricio|san valent[ií]n|san jorge|cinco de mayo|independencia|raza|trabajador))(\\s+(del?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String HolidayRegex3 = "\\b(?<holiday>(d[ií]a( internacional)?( del?( l[ao]s?)?)? )(trabajador(es)?|madres?|padres?|[aá]rbol|mujer(es)?|solteros?|niños?|marmota|san valent[ií]n|maestro))(\\s+(del?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\\s+año))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String BeforeRegex = "(\\b((ante(s|rior)|m[aá]s\\s+temprano|no\\s+m[aá]s\\s+tard(e|ar)|hasta|(?<include>tan\\s+tarde\\s+como))(\\s+(del?|a|que)(\\s+(el|las?|los?))?)?)|(?<!\\w|>)((?<include><\\s*=)|<))";

    public static final String AfterRegex = "((\\b(despu[eé]s|(año\\s+)?posterior|m[aá]s\\s+tarde|a\\s+primeros)(\\s*(del?|en|a)(\\s+(el|las?|los?))?)?|(empi?en?zando|comenzando)(\\s+(el|las?|los?))?)\\b|(?<!\\w|<)((?<include>>\\s*=)|>))";

    public static final String SinceRegex = "\\b(((cualquier\\s+tiempo\\s+)?(desde|a\\s+partir\\s+del?)|tan\\s+(temprano|pronto)\\s+como(\\s+(de|a))?)(\\s+(el|las?|los?))?)\\b";

    public static final String SinceRegexExp = "({SinceRegex}|\\bde\\b)"
            .replace("{SinceRegex}", SinceRegex);

    public static final String AroundRegex = "(?:\\b(?:cerca|alrededor|aproximadamente)(\\s+(de\\s+(las?|el)|del?))?\\s*\\b)";

    public static final String PeriodicRegex = "\\b(?<periodic>a\\s*diario|diaria(s|mente)|(bi|tri)?(semanal|quincenal|mensual|(se|tri)mestral|anual)(es|mente)?)\\b";

    public static final String EachExpression = "\\b(cada|tod[oa]s\\s*(l[oa]s)?)\\b\\s*(?!\\s*l[oa]\\b)";

    public static final String EachUnitRegex = "(?<each>({EachExpression})\\s*({UnitRegex}|(?<specialUnit>fin(es)?\\s+de\\s+semana|finde)\\b))"
            .replace("{EachExpression}", EachExpression)
            .replace("{UnitRegex}", UnitRegex);

    public static final String EachPrefixRegex = "(?<each>({EachExpression})\\s*$)"
            .replace("{EachExpression}", EachExpression);

    public static final String EachDayRegex = "\\s*({EachExpression})\\s*d[ií]as\\s*\\b"
            .replace("{EachExpression}", EachExpression);

    public static final String BeforeEachDayRegex = "({EachExpression})\\s*d[ií]as(\\s+a\\s+las?)?\\s*\\b"
            .replace("{EachExpression}", EachExpression);

    public static final String SetEachRegex = "(?<each>({EachExpression})\\s*)"
            .replace("{EachExpression}", EachExpression);

    public static final String LaterEarlyPeriodRegex = "\\b(({PrefixPeriodRegex})\\s+(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|({UnspecificEndOfRangeRegex}))\\b"
            .replace("{OneWordPeriodRegex}", OneWordPeriodRegex)
            .replace("{UnspecificEndOfRangeRegex}", UnspecificEndOfRangeRegex)
            .replace("{PrefixPeriodRegex}", PrefixPeriodRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String RelativeWeekRegex = "(((la|el)\\s+)?(((est[ae]|pr[oó]xim[oa]|[uú]ltim(o|as|os))\\s+semanas?)|(semanas?\\s+(que\\s+viene|pasad[oa]))))";

    public static final String WeekWithWeekDayRangeRegex = "\\b((({RelativeWeekRegex})((\\s+entre\\s+{WeekDayRegex}\\s+y\\s+{WeekDayRegex})|(\\s+de\\s+{WeekDayRegex}\\s+a\\s+{WeekDayRegex})))|((entre\\s+{WeekDayRegex}\\s+y\\s+{WeekDayRegex})|(de\\s+{WeekDayRegex}\\s+a\\s+{WeekDayRegex})){OfPrepositionRegex}\\s+{RelativeWeekRegex})\\b"
            .replace("{RelativeWeekRegex}", RelativeWeekRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{OfPrepositionRegex}", OfPrepositionRegex);

    public static final String GeneralEndingRegex = "^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$";

    public static final String MiddlePauseRegex = "^[.]";

    public static final String PrefixArticleRegex = "\\b(e[ln]\\s+(d[ií]a\\s+)?)";

    public static final String OrRegex = "^[.]";

    public static final String SpecialYearTermsRegex = "\\b(({SpecialYearPrefixes}\\s+años?\\s+|años?\\s+({SpecialYearPrefixes}\\s+)?)(de\\s+)?)"
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes);

    public static final String YearPlusNumberRegex = "\\b({SpecialYearTermsRegex}((?<year>(\\d{2,4}))|{FullTextYearRegex}))\\b"
            .replace("{FullTextYearRegex}", FullTextYearRegex)
            .replace("{SpecialYearTermsRegex}", SpecialYearTermsRegex);

    public static final String NumberAsTimeRegex = "\\b({WrittenTimeRegex}|{HourRegex}(?<desc>\\s*h(oras)?)?)\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourRegex}", HourRegex);

    public static final String TimeBeforeAfterRegex = "\\b((?<=\\b(antes|no\\s+m[aá]s\\s+tard(e|ar)\\s+(de|a\\s+las?)|por| después)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String DateNumberConnectorRegex = "^\\s*(?<connector>a\\s+las)\\s*$";

    public static final String CenturyRegex = "^[.]";

    public static final String DecadeRegex = "(?<decade>diez|veinte|treinta|cuarenta|cincuenta|se[st]enta|ochenta|noventa)";

    public static final String DecadeWithCenturyRegex = "(los\\s+)?((((d[ée]cada(\\s+de)?)\\s+)(((?<century>\\d|1\\d|2\\d)?(?<decade>\\d0))))|a[ñn]os\\s+((((dos\\s+)?mil\\s+)?({WrittenOneHundredToNineHundredRegex}\\s+)?{DecadeRegex})|((dos\\s+)?mil\\s+)?({WrittenOneHundredToNineHundredRegex})(\\s+{DecadeRegex}?)|((dos\\s+)?mil)(\\s+{WrittenOneHundredToNineHundredRegex}\\s+)?{DecadeRegex}?))"
            .replace("{WrittenOneHundredToNineHundredRegex}", WrittenOneHundredToNineHundredRegex)
            .replace("{DecadeRegex}", DecadeRegex);

    public static final String RelativeDecadeRegex = "\\b(((el|las?)\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?(d[eé]cada|decenio)s?)\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String ComplexDatePeriodRegex = "(?:((de(sde)?)\\s+)?(?<start>.+)\\s*({StrictTillRegex})\\s*(?<end>.+)|((entre)\\s+)(?<start>.+)\\s*({RangeConnectorRegex})\\s*(?<end>.+))"
            .replace("{StrictTillRegex}", StrictTillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String AmbiguousPointRangeRegex = "^(mar\\.?)$";

    public static final String YearSuffix = "((,|\\sdel?)?\\s*({YearRegex}|{FullTextYearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String SinceYearSuffixRegex = "(^\\s*{SinceRegex}(\\s*(el\\s+)?año\\s*)?{YearSuffix})"
            .replace("{SinceRegex}", SinceRegex)
            .replace("{YearSuffix}", YearSuffix);

    public static final String AgoRegex = "\\b(antes\\s+de\\s+(?<day>hoy|ayer|mañana)|antes|hace)\\b";

    public static final String LaterRegex = "\\b(despu[eé]s(?!\\s+de\\b)|desde\\s+ahora|(a\\s+partir|despu[eé]s)\\s+de\\s+(ahora|(?<day>hoy|ayer|mañana)))\\b";

    public static final String Tomorrow = "mañana";

    public static final ImmutableMap<String, String> UnitMap = ImmutableMap.<String, String>builder()
        .put("años", "Y")
        .put("año", "Y")
        .put("meses", "MON")
        .put("mes", "MON")
        .put("trimestre", "3MON")
        .put("trimestres", "3MON")
        .put("cuatrimestre", "4MON")
        .put("cuatrimestres", "4MON")
        .put("semestre", "6MON")
        .put("semestres", "6MON")
        .put("bimestre", "2MON")
        .put("bimestres", "2MON")
        .put("semanas", "W")
        .put("semana", "W")
        .put("fin de semana", "WE")
        .put("fines de semana", "WE")
        .put("finde", "WE")
        .put("dias", "D")
        .put("dia", "D")
        .put("días", "D")
        .put("día", "D")
        .put("jornada", "D")
        .put("noche", "D")
        .put("noches", "D")
        .put("horas", "H")
        .put("hora", "H")
        .put("hrs", "H")
        .put("hras", "H")
        .put("hra", "H")
        .put("hr", "H")
        .put("h", "H")
        .put("minutos", "M")
        .put("minuto", "M")
        .put("mins", "M")
        .put("min", "M")
        .put("segundos", "S")
        .put("segundo", "S")
        .put("segs", "S")
        .put("seg", "S")
        .build();

    public static final ImmutableMap<String, Long> UnitValueMap = ImmutableMap.<String, Long>builder()
        .put("años", 31536000L)
        .put("año", 31536000L)
        .put("meses", 2592000L)
        .put("mes", 2592000L)
        .put("semanas", 604800L)
        .put("semana", 604800L)
        .put("fin de semana", 172800L)
        .put("fines de semana", 172800L)
        .put("finde", 172800L)
        .put("dias", 86400L)
        .put("dia", 86400L)
        .put("días", 86400L)
        .put("día", 86400L)
        .put("noche", 86400L)
        .put("noches", 86400L)
        .put("horas", 3600L)
        .put("hora", 3600L)
        .put("hrs", 3600L)
        .put("hras", 3600L)
        .put("hra", 3600L)
        .put("hr", 3600L)
        .put("h", 3600L)
        .put("minutos", 60L)
        .put("minuto", 60L)
        .put("mins", 60L)
        .put("min", 60L)
        .put("segundos", 1L)
        .put("segundo", 1L)
        .put("segs", 1L)
        .put("seg", 1L)
        .build();

    public static final ImmutableMap<String, String> SpecialYearPrefixesMap = ImmutableMap.<String, String>builder()
        .put("fiscal", "FY")
        .put("escolar", "SY")
        .build();

    public static final ImmutableMap<String, String> SeasonMap = ImmutableMap.<String, String>builder()
        .put("primavera", "SP")
        .put("verano", "SU")
        .put("otoño", "FA")
        .put("invierno", "WI")
        .build();

    public static final ImmutableMap<String, Integer> SeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> CardinalMap = ImmutableMap.<String, Integer>builder()
        .put("primer", 1)
        .put("primero", 1)
        .put("primera", 1)
        .put("1er", 1)
        .put("1ro", 1)
        .put("1ra", 1)
        .put("1.º", 1)
        .put("1º", 1)
        .put("1ª", 1)
        .put("segundo", 2)
        .put("segunda", 2)
        .put("2do", 2)
        .put("2da", 2)
        .put("2.º", 2)
        .put("2º", 2)
        .put("2ª", 2)
        .put("tercer", 3)
        .put("tercero", 3)
        .put("tercera", 3)
        .put("3er", 3)
        .put("3ro", 3)
        .put("3ra", 3)
        .put("3.º", 3)
        .put("3º", 3)
        .put("3ª", 3)
        .put("cuarto", 4)
        .put("cuarta", 4)
        .put("4to", 4)
        .put("4ta", 4)
        .put("4.º", 4)
        .put("4º", 4)
        .put("4ª", 4)
        .put("quinto", 5)
        .put("quinta", 5)
        .put("5to", 5)
        .put("5ta", 5)
        .put("5.º", 5)
        .put("5º", 5)
        .put("5ª", 5)
        .put("sexto", 6)
        .put("sexta", 6)
        .put("6to", 6)
        .put("6ta", 6)
        .put("septimo", 7)
        .put("séptimo", 7)
        .put("septima", 7)
        .put("séptima", 7)
        .put("7mo", 7)
        .put("7ma", 7)
        .put("octavo", 8)
        .put("octava", 8)
        .put("8vo", 8)
        .put("8va", 8)
        .put("noveno", 9)
        .put("novena", 9)
        .put("9no", 9)
        .put("9na", 9)
        .put("decimo", 10)
        .put("décimo", 10)
        .put("decima", 10)
        .put("décima", 10)
        .put("10mo", 10)
        .put("10ma", 10)
        .put("undecimo", 11)
        .put("undécimo", 11)
        .put("undecima", 11)
        .put("undécima", 11)
        .put("11mo", 11)
        .put("11ma", 11)
        .put("duodecimo", 12)
        .put("duodécimo", 12)
        .put("duodecima", 12)
        .put("duodécima", 12)
        .put("12mo", 12)
        .put("12ma", 12)
        .build();

    public static final ImmutableMap<String, Integer> DayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("lunes", 1)
        .put("martes", 2)
        .put("miercoles", 3)
        .put("miércoles", 3)
        .put("jueves", 4)
        .put("viernes", 5)
        .put("sabado", 6)
        .put("sábado", 6)
        .put("domingo", 0)
        .put("dom", 0)
        .put("lun", 1)
        .put("mar", 2)
        .put("mie", 3)
        .put("mié", 3)
        .put("jue", 4)
        .put("vie", 5)
        .put("sab", 6)
        .put("sáb", 6)
        .put("dom.", 0)
        .put("lun.", 1)
        .put("mar.", 2)
        .put("mie.", 3)
        .put("mié.", 3)
        .put("jue.", 4)
        .put("vie.", 5)
        .put("sab.", 6)
        .put("sáb.", 6)
        .put("do", 0)
        .put("lu", 1)
        .put("ma", 2)
        .put("mi", 3)
        .put("ju", 4)
        .put("vi", 5)
        .put("sa", 6)
        .build();

    public static final ImmutableMap<String, Integer> MonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("enero", 1)
        .put("febrero", 2)
        .put("marzo", 3)
        .put("abril", 4)
        .put("mayo", 5)
        .put("junio", 6)
        .put("julio", 7)
        .put("agosto", 8)
        .put("septiembre", 9)
        .put("setiembre", 9)
        .put("octubre", 10)
        .put("noviembre", 11)
        .put("diciembre", 12)
        .put("ene", 1)
        .put("feb", 2)
        .put("mar", 3)
        .put("abr", 4)
        .put("may", 5)
        .put("jun", 6)
        .put("jul", 7)
        .put("ago", 8)
        .put("sept", 9)
        .put("sep", 9)
        .put("set", 9)
        .put("oct", 10)
        .put("nov", 11)
        .put("dic", 12)
        .put("ene.", 1)
        .put("feb.", 2)
        .put("mar.", 3)
        .put("abr.", 4)
        .put("may.", 5)
        .put("jun.", 6)
        .put("jul.", 7)
        .put("ago.", 8)
        .put("sept.", 9)
        .put("sep.", 9)
        .put("set.", 9)
        .put("oct.", 10)
        .put("nov.", 11)
        .put("dic.", 12)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .build();

    public static final ImmutableMap<String, Integer> Numbers = ImmutableMap.<String, Integer>builder()
        .put("cero", 0)
        .put("un", 1)
        .put("una", 1)
        .put("uno", 1)
        .put("dos", 2)
        .put("dós", 2)
        .put("tres", 3)
        .put("trés", 3)
        .put("cuatro", 4)
        .put("cinco", 5)
        .put("seis", 6)
        .put("séis", 6)
        .put("siete", 7)
        .put("ocho", 8)
        .put("nueve", 9)
        .put("diez", 10)
        .put("once", 11)
        .put("doce", 12)
        .put("docena", 12)
        .put("docenas", 12)
        .put("trece", 13)
        .put("catorce", 14)
        .put("quince", 15)
        .put("dieciseis", 16)
        .put("dieciséis", 16)
        .put("diecisiete", 17)
        .put("dieciocho", 18)
        .put("diecinueve", 19)
        .put("veinte", 20)
        .put("veinti", 20)
        .put("ventiuna", 21)
        .put("ventiuno", 21)
        .put("veintiun", 21)
        .put("veintiún", 21)
        .put("veintiuno", 21)
        .put("veintiuna", 21)
        .put("veintidos", 22)
        .put("veintidós", 22)
        .put("veintitres", 23)
        .put("veintitrés", 23)
        .put("veinticuatro", 24)
        .put("veinticinco", 25)
        .put("veintiseis", 26)
        .put("veintiséis", 26)
        .put("veintisiete", 27)
        .put("veintiocho", 28)
        .put("veintinueve", 29)
        .put("treinta", 30)
        .put("cuarenta", 40)
        .put("cincuenta", 50)
        .build();

    public static final ImmutableMap<String, String[]> HolidayNames = ImmutableMap.<String, String[]>builder()
        .put("padres", new String[]{"diadelpadre"})
        .put("madres", new String[]{"diadelamadre"})
        .put("acciondegracias", new String[]{"diadegracias", "diadeacciondegracias", "acciondegracias"})
        .put("trabajador", new String[]{"diadeltrabajador", "diadelostrabajadores", "diainternacionaldeltrabajador", "diainternacionaldelostrabajadores"})
        .put("delaraza", new String[]{"diadelaraza", "diadeladiversidadcultural"})
        .put("memoria", new String[]{"diadelamemoria"})
        .put("pascuas", new String[]{"diadepascuas", "pascuas"})
        .put("navidad", new String[]{"navidad", "diadenavidad"})
        .put("nochebuena", new String[]{"diadenochebuena", "nochebuena"})
        .put("añonuevo", new String[]{"añonuevo", "diadeañonuevo"})
        .put("nochevieja", new String[]{"nochevieja", "diadenochevieja"})
        .put("yuandan", new String[]{"yuandan"})
        .put("earthday", new String[]{"diadelatierra"})
        .put("maestro", new String[]{"diadelmaestro"})
        .put("todoslossantos", new String[]{"todoslossantos"})
        .put("niño", new String[]{"diadelniño"})
        .put("mujer", new String[]{"diadelamujer"})
        .put("independencia", new String[]{"diadelaindependencia", "diadeindependencia", "independencia"})
        .put("blackfriday", new String[]{"viernesnegro"})
        .put("goodfriday", new String[]{"viernessanto"})
        .put("stpatrickday", new String[]{"sanpatricio", "diadesanpatricio"})
        .put("valentinesday", new String[]{"sanvalentin", "diadesanvalentin"})
        .build();

    public static final ImmutableMap<String, String> VariableHolidaysTimexDictionary = ImmutableMap.<String, String>builder()
        .put("padres", "-06-WXX-7-3")
        .put("madres", "-05-WXX-7-2")
        .put("acciondegracias", "-11-WXX-4-4")
        .put("delaraza", "-10-WXX-1-2")
        .put("memoria", "-03-WXX-2-4")
        .build();

    public static final ImmutableMap<String, Double> DoubleNumbers = ImmutableMap.<String, Double>builder()
        .put("mitad", 0.5D)
        .put("cuarto", 0.25D)
        .build();

    public static final String UpcomingPrefixRegex = "((este\\s+))";

    public static final String NextPrefixRegex = "\\b({UpcomingPrefixRegex}?pr[oó]xim[oa]s?|siguiente|que\\s+viene)\\b"
            .replace("{UpcomingPrefixRegex}", UpcomingPrefixRegex);

    public static final String PastPrefixRegex = "((este\\s+))";

    public static final String PreviousPrefixRegex = "\\b({PastPrefixRegex}?pasad[oa]s?(?!(\\s+el)?\\s+medio\\s*d[ií]a)|[uú]ltim[oa]s?|anterior)\\b"
            .replace("{PastPrefixRegex}", PastPrefixRegex);

    public static final String ThisPrefixRegex = "(est?[ea]|actual)\\b";

    public static final String PrefixWeekDayRegex = "(\\s*((,?\\s*el)|[-—–]))";

    public static final String ThisRegex = "\\b((est[ae]\\s*)(semana{PrefixWeekDayRegex}?)?\\s*{WeekDayRegex})|({WeekDayRegex}\\s*((de\\s+)?esta\\s+semana))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String LastDateRegex = "\\b(({PreviousPrefixRegex}\\s+(semana{PrefixWeekDayRegex}?)?|(la\\s+)?semana\\s+{PreviousPrefixRegex}{PrefixWeekDayRegex})\\s*{WeekDayRegex})|(este\\s+)?({WeekDayRegex}\\s+([uú]ltimo|pasado|anterior))|({WeekDayRegex}(\\s+((de\\s+)?((esta|la)\\s+([uú]ltima\\s+)?semana)|(de\\s+)?(la\\s+)?semana\\s+(pasada|anterior))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String NextDateRegex = "\\b((({NextPrefixRegex}\\s+)(semana{PrefixWeekDayRegex}?)?|(la\\s+)?semana\\s+{NextPrefixRegex}{PrefixWeekDayRegex})\\s*{WeekDayRegex})|(este\\s+)?({WeekDayRegex}\\s+(pr[oó]ximo|siguiente|que\\s+viene))|({WeekDayRegex}(\\s+(de\\s+)?(la\\s+)?((pr[oó]xima|siguiente)\\s+semana|semana\\s+(pr[oó]xima|siguiente))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String RelativeDayRegex = "(?<relday>((este|pr[oó]ximo|([uú]ltim(o|as|os)))\\s+días)|(días\\s+((que\\s+viene)|pasado)))\\b";

    public static final String RestOfDateRegex = "\\bresto\\s+((del|de)\\s+)?((la|el|est?[ae])\\s+)?(?<duration>semana|mes|año|decada)(\\s+actual)?\\b";

    public static final String WithinNextPrefixRegex = "\\b(dentro\\s+de((\\s+(el|l[ao]s?))?\\s+(?<next>{NextPrefixRegex}))?)(?=\\s*$)\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex);

    public static final String DurationUnitRegex = "(?<unit>{DateUnitRegex}|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\\b"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String DurationConnectorRegex = "^\\s*(?<connector>\\s+|y|,)\\s*$";

    public static final String RelativeDurationUnitRegex = "(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+)({DurationUnitRegex}))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String ReferencePrefixRegex = "(mism[ao]|aquel|est?e)\\b";

    public static final String ReferenceDatePeriodRegex = "\\b{ReferencePrefixRegex}\\s+({DateUnitRegex}|fin\\s+de\\s+semana)\\b"
            .replace("{ReferencePrefixRegex}", ReferencePrefixRegex)
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String FromToRegex = "\\b(from).+(to)\\b.+";

    public static final String SingleAmbiguousMonthRegex = "^(the\\s+)?(may|march)$";

    public static final String UnspecificDatePeriodRegex = "^[\\.]";

    public static final String PrepositionSuffixRegex = "\\b(en|el|la|cerca|alrededor|desde|durante|hasta|hacia)$";

    public static final String RestOfDateTimeRegex = "\\bresto\\s+((del?)\\s+)?((la|el|est[ae])\\s+)?(?<unit>(día|jornada))(\\s+de\\s+hoy)?\\b";

    public static final String SetWeekDayRegex = "^[\\.]";

    public static final String NightRegex = "\\b(medionoche|noche)\\b";

    public static final String CommonDatePrefixRegex = "^[\\.]";

    public static final String SuffixAfterRegex = "\\b((a\\s+)?(o|y)\\s+(arriba|despu[eé]s|posterior|mayor|m[aá]s\\s+tarde)(?!\\s+(que|de)))\\b";

    public static final String YearPeriodRegex = "((((de(sde)?|durante|en)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((entre)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String FutureSuffixRegex = "\\b(siguiente(s)?|pr[oó]xim[oa](s)?|(en\\s+el\\s+)?futuro)\\b";

    public static final String PastSuffixRegex = "^\\b$";

    public static final String ModPrefixRegex = "\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AroundRegex}", AroundRegex)
            .replace("{BeforeRegex}", BeforeRegex)
            .replace("{AfterRegex}", AfterRegex)
            .replace("{SinceRegex}", SinceRegex);

    public static final String ModSuffixRegex = "\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b"
            .replace("{AgoRegex}", AgoRegex)
            .replace("{LaterRegex}", LaterRegex)
            .replace("{BeforeAfterRegex}", BeforeAfterRegex)
            .replace("{FutureSuffixRegex}", FutureSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final ImmutableMap<String, Integer> WrittenDecades = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final ImmutableMap<String, Integer> SpecialDecadeCases = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final String DefaultLanguageFallback = "DMY";

    public static final List<String> DurationDateRestrictions = Arrays.asList("hoy");

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)")
        .put("^(este\\s+)?mi(\\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\\s+viene))?$", "\\b(este\\s+)?mi(\\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\\s+viene))?\\b")
        .put("^a[nñ]o$", "(?<!el\\s+)a[nñ]o")
        .put("^semana$", "(?<!la\\s+)semana")
        .put("^mes$", "(?<!el\\s+)mes")
        .put("^(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)$", "([$%£&!?@#])(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)|(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)([$%£&@#])")
        .put("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}")
        .put("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")
        .build();

    public static final String EarlyMorningStartEndRegex = "(^(madrugada)|(madrugada)$)";

    public static final String MorningStartEndRegex = "(^((la\\s+)?mañana))|(((la\\s+)?mañana)$)";

    public static final String AfternoonStartEndRegex = "(^(pasado\\s+(el\\s+)?medio\\s*dia))|((pasado\\s+(el\\s+)?medio\\s*dia)$)";

    public static final String EveningStartEndRegex = "(^(tarde))|((tarde)$)";

    public static final String NightStartEndRegex = "(^(noche)|(noche)$)";

    public static final List<String> EarlyMorningTermList = Arrays.asList("madrugada");

    public static final List<String> MorningTermList = Arrays.asList("mañana", "la mañana");

    public static final List<String> AfternoonTermList = Arrays.asList("pasado mediodia", "pasado el mediodia", "pasado mediodía", "pasado el mediodía", "pasado medio dia", "pasado el medio dia", "pasado medio día", "pasado el medio día");

    public static final List<String> EveningTermList = Arrays.asList("tarde");

    public static final List<String> NightTermList = Arrays.asList("noche");

    public static final List<String> SameDayTerms = Arrays.asList("hoy", "el dia");

    public static final List<String> PlusOneDayTerms = Arrays.asList("mañana", "dia siguiente", "el dia de mañana", "proximo dia");

    public static final List<String> MinusOneDayTerms = Arrays.asList("ayer", "ultimo dia", "dia anterior");

    public static final List<String> PlusTwoDayTerms = Arrays.asList("pasado mañana", "dia despues de mañana");

    public static final List<String> MinusTwoDayTerms = Arrays.asList("anteayer", "dia antes de ayer");

    public static final List<String> MonthTerms = Arrays.asList("mes", "meses");

    public static final List<String> MonthToDateTerms = Arrays.asList("mes a la fecha", "mes hasta la fecha");

    public static final List<String> WeekendTerms = Arrays.asList("finde", "fin de semana", "fines de semana");

    public static final List<String> WeekTerms = Arrays.asList("semana");

    public static final List<String> FortnightTerms = Arrays.asList("quincena", "la quincena");

    public static final List<String> YearTerms = Arrays.asList("año", "años");

    public static final List<String> YearToDateTerms = Arrays.asList("año a la fecha", "año hasta la fecha");

    public static final ImmutableMap<Character, Character> SpecialCharactersEquivalent = ImmutableMap.<Character, Character>builder()
        .put('á', 'a')
        .put('é', 'e')
        .put('í', 'i')
        .put('ó', 'o')
        .put('ú', 'u')
        .build();

    public static final String DoubleMultiplierRegex = "^(bi)(-|\\s)?";

    public static final String DayTypeRegex = "(d[ií]as?|diari(o|as|amente))$";

    public static final String WeekTypeRegex = "(semanas?|semanalmente)$";

    public static final String BiWeekTypeRegex = "(quincenalmente)$";

    public static final String WeekendTypeRegex = "(fin(es)?\\s+de\\s+semana|finde)$";

    public static final String MonthTypeRegex = "(mes(es)?|mensual(es|mente)?)$";

    public static final String QuarterTypeRegex = "(trimestral(es|mente)?)$";

    public static final String SemiAnnualTypeRegex = "(semestral(es|mente)?)$";

    public static final String YearTypeRegex = "(años?|anual(mente)?)$";
}
