// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class PortugueseDateTime {

    public static final String LangMarker = "Por";

    public static final Boolean CheckBothBeforeAfter = false;

    public static final String TillRegex = "(?<till>\\b(at[eé]h?|[aà]s|ao?)\\b|--|-|—|——)(\\s+\\b(o|[aà](s)?)\\b)?";

    public static final String RangeConnectorRegex = "(?<and>(e\\s*(([àa]s?)|o)?)|{BaseDateTime.RangeConnectorSymbolRegex})"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String DayRegex = "(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))(?=\\b|t)";

    public static final String WrittenDayRegex = "(?<day>(vinte\\s+e\\s+)?(um|dois|tr[eê]s|quatro|cinco|seis|sete|oito|nove)|dez|onze|doze|treze|(c|qu)atorze|quinze|dez[ae](s(seis|sete)|nove)|dezoito|vinte|trinta(\\s+e\\s+um)?)";

    public static final String MonthNumRegex = "(?<month>1[0-2]|(0)?[1-9])\\b";

    public static final String AmDescRegex = "({BaseDateTime.BaseAmDescRegex})"
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex);

    public static final String PmDescRegex = "({BaseDateTime.BasePmDescRegex})"
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String AmPmDescRegex = "({BaseDateTime.BaseAmPmDescRegex})"
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex);

    public static final String OclockRegex = "(?<oclock>em\\s+ponto)";

    public static final String DescRegex = "((horas\\s+)?(?<desc>{AmDescRegex}|{PmDescRegex})|{OclockRegex})"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String OfPrepositionRegex = "(\\bd(o|a|e)s?\\b)";

    public static final String AfterNextSuffixRegex = "\\b(que\\s+vem|passad[oa])\\b";

    public static final String RangePrefixRegex = "((de(sde)?|das?|entre)\\s+(a(s)?\\s+)?)";

    public static final String TwoDigitYearRegex = "\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String RelativeRegex = "(?<order>((n?est[ae]s?|pr[oó]xim[oa]s?|([uú]ltim[ao]s?))(\\s+fina(l|is)\\s+d[eao])?)|(fina(l|is)\\s+d[eao]))\\b";

    public static final String StrictRelativeRegex = "(?<order>((n?est[ae]|pr[oó]xim[oa]|([uú]ltim(o|as|os)))(\\s+fina(l|is)\\s+d[eao])?)|(fina(l|is)\\s+d[eao]))\\b";

    public static final String WrittenOneToNineRegex = "(uma?|dois|duas|tr[eê]s|quatro|cinco|seis|sete|oito|nove)";

    public static final String WrittenOneHundredToNineHundredRegex = "(duzent[oa]s|trezent[oa]s|[cq]uatrocent[ao]s|quinhent[ao]s|seiscent[ao]s|setecent[ao]s|oitocent[ao]s|novecent[ao]s|cem|(?<!por\\s+)(cento))";

    public static final String WrittenOneToNinetyNineRegex = "(((vinte|trinta|[cq]uarenta|cinquenta|sessenta|setenta|oitenta|noventa)(\\s+e\\s+{WrittenOneToNineRegex})?)|d[eé]z|onze|doze|treze|(c|qu)atorze|quinze|dez[ea]sseis|dez[ea]ssete|dez[ea]nove|dezoito|uma?|d(oi|ua)s|tr[eê]s|quatro|cinco|seis|sete|oito|nove)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String FullTextYearRegex = "\\b(?<fullyear>((dois\\s+)?mil)((\\s+e)?\\s+{WrittenOneHundredToNineHundredRegex})?((\\s+e)?\\s+{WrittenOneToNinetyNineRegex})?)"
            .replace("{WrittenOneToNinetyNineRegex}", WrittenOneToNinetyNineRegex)
            .replace("{WrittenOneHundredToNineHundredRegex}", WrittenOneHundredToNineHundredRegex);

    public static final String YearRegex = "({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String RelativeMonthRegex = "(?<relmonth>([nd]?es[st]e|pr[óo]ximo|passsado|[uú]ltimo)\\s+m[eê]s)\\b";

    public static final String MonthRegex = "(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)";

    public static final String MonthSuffixRegex = "(?<msuf>((em|no)\\s+|d[eo]\\s+)?({RelativeMonthRegex}|{MonthRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String DateUnitRegex = "(?<unit>(?<uoy>m[êe]s)(?<plural>es)?|(ano|(?<uoy>semana|dia))(?<plural>s)?)\\b";

    public static final String PastRegex = "(?<past>\\b(passad[ao](s)?|[uú]ltim[oa](s)?|anterior(es)?|h[aá]|pr[ée]vi[oa](s)?)\\b)";

    public static final String FutureRegex = "(?<past>\\b(seguinte(s)?|pr[oó]xim[oa](s)?|daqui\\s+a)\\b)";

    public static final String SimpleCasesRegex = "\\b((desde\\s+[oa]|desde|d[oa])\\s+)?(dia\\s+)?({DayRegex})\\s*{TillRegex}\\s*(o dia\\s+)?({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontSimpleCasesRegex = "\\b{MonthSuffixRegex}\\s+((desde\\s+[oa]|desde|d[oa])\\s+)?(dia\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontBetweenRegex = "\\b{MonthSuffixRegex}\\s+((entre|entre\\s+[oa]s?)\\s+)(dias?\\s+)?({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String DayBetweenRegex = "\\b((entre|entre\\s+[oa]s?)\\s+)(dia\\s+)?({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String SpecialYearPrefixes = "((do\\s+)?calend[aá]rio|civil|(?<special>fiscal|escolar|letivo))";

    public static final String OneWordPeriodRegex = "\\b(((pr[oó]xim[oa]?|[nd]?es[st]e|aquel[ea]|[uú]ltim[oa]?|em)\\s+)?(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)|({RelativeRegex}\\s+)?(ano\\s+{SpecialYearPrefixes}|{SpecialYearPrefixes}\\s+ano)|(?<=\\b(de|do|da|o|a)\\s+)?(pr[oó]xim[oa](s)?|[uú]ltim[oa]s?|est(e|a))\\s+(fim de semana|fins de semana|semana|m[êe]s|ano)|fim de semana|fins de semana|(m[êe]s|anos)? [àa] data)\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes);

    public static final String MonthWithYearRegex = "\\b((((pr[oó]xim[oa](s)?|[nd]?es[st]e|aquele|[uú]ltim[oa]?|em)\\s+)?{MonthRegex}|((n?o\\s+)?(?<cardinal>primeiro|1o|segundo|2o|terceiro|3o|[cq]uarto|4o|quinto|5o|sexto|6o|s[eé]timo|7o|oitavo|8o|nono|9o|d[eé]cimo(\\s+(primeiro|segundo))?|10o|11o|12o|[uú]ltimo)\\s+m[eê]s(?=\\s+(d[aeo]|[ao]))))\\s+((d[aeo]|[ao])\\s+)?({YearRegex}|{TwoDigitYearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano))\\b"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String MonthNumWithYearRegex = "({YearRegex}(\\s*?)[/\\-\\.](\\s*?){MonthNumRegex})|({MonthNumRegex}(\\s*?)[/\\-](\\s*?){YearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String WeekOfMonthRegex = "(?<wom>(a|na\\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima)\\s+semana\\s+{MonthSuffixRegex})"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String WeekOfYearRegex = "(?<woy>(a|na\\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima?)\\s+semana(\\s+d[oe]?)?\\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano))"
            .replace("{YearRegex}", YearRegex);

    public static final String OfYearRegex = "\\b((d[aeo]?|[ao])\\s*({YearRegex}|{StrictRelativeRegex}\\s+ano))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String FirstLastRegex = "\\b(n?[ao]s?\\s+)?((?<first>primeir[ao]s?)|(?<last>[uú]ltim[ao]s?))\\b";

    public static final String FollowedDateUnit = "^\\s*{DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String NumberCombinedWithDateUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String QuarterRegex = "(n?o\\s+)?(?<cardinal>primeiro|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\\s+trimestre(\\s+d[oe]|\\s*,\\s*)?\\s+({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano)"
            .replace("{YearRegex}", YearRegex);

    public static final String QuarterRegexYearFront = "({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\\s+ano)\\s+(n?o\\s+)?(?<cardinal>(primeiro)|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\\s+trimestre"
            .replace("{YearRegex}", YearRegex);

    public static final String AllHalfYearRegex = "^[.]";

    public static final String PrefixDayRegex = "^[.]";

    public static final String SeasonRegex = "\\b(?<season>(([uú]ltim[oa]|[nd]?es[st][ea]|n?[oa]|(pr[oó]xim[oa]s?|seguinte))\\s+)?(?<seas>primavera|ver[ãa]o|outono|inverno)((\\s+)?(seguinte|((de\\s+|,)?\\s*{YearRegex})|((do\\s+)?(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano)))?)\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String WhichWeekRegex = "\\b(semana)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+(de|do)\\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\\s+ano|ano\\s+(?<order>passado)))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String WeekOfRegex = "(semana)(\\s*)((do|da|de))";

    public static final String MonthOfRegex = "(mes)(\\s*)((do|da|de))";

    public static final String RangeUnitRegex = "\\b(?<unit>anos?|meses|m[êe]s|semanas?)\\b";

    public static final String BeforeAfterRegex = "^[.]";

    public static final String UpcomingPrefixRegex = ".^";

    public static final String NextPrefixRegex = "(pr[oó]xim[oa]s?|seguinte|{UpcomingPrefixRegex})\\b"
            .replace("{UpcomingPrefixRegex}", UpcomingPrefixRegex);

    public static final String InConnectorRegex = "\\b(em)\\b";

    public static final String SinceYearSuffixRegex = "^[.]";

    public static final String WithinNextPrefixRegex = "\\b(dentro\\s+d(e|as)(\\s+(?<next>{NextPrefixRegex}))?)\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex);

    public static final String TodayNowRegex = "\\b(hoje|agora)\\b";

    public static final String CenturySuffixRegex = "^[.]";

    public static final String FromRegex = "(de(sde)?(\\s*a(s)?)?)$";

    public static final String BetweenRegex = "(entre\\s*([oa](s)?)?)";

    public static final String WeekDayRegex = "\\b(?<weekday>(domingos?|(segunda|ter[çc]a|quarta|quinta|sexta)s?([-\\s+]feiras?)?|s[aá]bados?|(2|3|4|5|6)[aª])\\b|(dom|seg|ter[cç]|qua|qui|sex|sab)\\b(\\.?(?=\\s|,|;|$)))";

    public static final String OnRegex = "(?<=\\b(em|no)\\s+)({DayRegex}s?)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String RelaxedOnRegex = "((?<=\\b(em|[nd][oa])\\s+)(dia\\s+)?({DayRegex}s?)|dia\\s+{DayRegex}s?)\\b(?!\\s*[/\\\\\\-\\.,:\\s]\\s*(\\d|(de\\s+)?{MonthRegex}))"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String ThisRegex = "\\b(([nd]?es[st][ea]\\s*){WeekDayRegex})|({WeekDayRegex}\\s*([nd]?es[st]a\\s+semana))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String LastDateRegex = "\\b(([uú]ltim[ao])\\s*{WeekDayRegex})|({WeekDayRegex}(\\s+(([nd]?es[st]a|[nd]a)\\s+([uú]ltima\\s+)?semana)))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String NextDateRegex = "\\b(((pr[oó]xim[oa]|seguinte)\\s*){WeekDayRegex})|({WeekDayRegex}((\\s+(pr[oó]xim[oa]|seguinte))|(\\s+(da\\s+)?(semana\\s+seguinte|pr[oó]xima\\s+semana))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String SpecialDayRegex = "\\b((d?o\\s+)?(dia\\s+antes\\s+de\\s+ontem|antes\\s+de\\s+ontem|anteontem)|((d?o\\s+)?(dia\\s+|depois\\s+|dia\\s+depois\\s+)?de\\s+amanh[aã])|(o\\s)?dia\\s+seguinte|(o\\s)?pr[oó]ximo\\s+dia|(o\\s+)?[uú]ltimo\\s+dia|ontem|amanh[ãa]|hoje)|(do\\s+dia$)\\b";

    public static final String SpecialDayWithNumRegex = "^[.]";

    public static final String ForTheRegex = ".^";

    public static final String FlexibleDayRegex = "(?<DayOfMonth>([a-z]+\\s)?({WrittenDayRegex}|{DayRegex}))"
            .replace("{WrittenDayRegex}", WrittenDayRegex)
            .replace("{DayRegex}", DayRegex);

    public static final String WeekDayAndDayOfMonthRegex = "\\b{WeekDayRegex}\\s+(dia\\s+{FlexibleDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayRegex = "\\b{WeekDayRegex}\\s+({DayRegex})(?!([-:/]|\\.\\d|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String WeekDayOfMonthRegex = "(?<wom>(n?[ao]\\s+)?(?<cardinal>primeir[ao]|1[ao]|segund[ao]|2[ao]|terceir[ao]|3[ao]|[qc]uart[ao]|4[ao]|quint[ao]|5[ao]|[uú]ltim[ao])\\s+{WeekDayRegex}\\s+{MonthSuffixRegex})"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String RelativeWeekDayRegex = "^[.]";

    public static final String AmbiguousRangeModifierPrefix = "^[.]";

    public static final String NumberEndingPattern = "^[.]";

    public static final String SpecialDateRegex = "(?<=\\bno\\s+){DayRegex}\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String OfMonthRegex = "^(\\s*de)?\\s*{MonthSuffixRegex}"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String MonthEndRegex = "({MonthRegex}\\s*(o)?\\s*$)"
            .replace("{MonthRegex}", MonthRegex);

    public static final String WeekDayEnd = "{WeekDayRegex}\\s*,?\\s*$"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayStart = "^\\b$";

    public static final String DateYearRegex = "(?<year>{YearRegex}|{TwoDigitYearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String DateExtractor1 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{DayRegex}((\\s*(de)|[/\\\\\\.\\- ])\\s*)?{MonthRegex}\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String DateExtractor2 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?({DayRegex}(\\s*([/\\.\\-]|de)?\\s*{MonthRegex}|\\s+de\\s+{MonthNumRegex})(\\s*([,./-]|de|\\s+)\\s*){DateYearRegex}|{BaseDateTime.FourDigitYearRegex}\\s*[/\\.\\- ]\\s*{DayRegex}\\s*[/\\.\\- ]\\s*{MonthRegex})\\b"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String DateExtractor3 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{MonthRegex}(\\s*[/\\.\\- ]\\s*|\\s+de\\s+){DayRegex}(?!\\s*\\-\\s*\\d{2}\\b)((\\s*[/\\.\\- ]\\s*|\\s+de\\s+){DateYearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor4 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}\\s*[/\\\\\\-]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor5 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor6 = "(?<=\\b(em|no|o)\\s+){MonthNumRegex}[\\-\\.]{DayRegex}{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor7 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{MonthNumRegex}\\s*/\\s*{DayRegex}((\\s+|\\s*(,|de)\\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor8 = "(?<=\\b(em|no|o)\\s+){DayRegex}[\\\\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor9 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*(,|de)\\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor10 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?({YearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})(?!\\s*[/\\\\\\-\\.:]\\s*\\d+)"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor11 = "(?<=\\b(dia)\\s+){DayRegex}"
            .replace("{DayRegex}", DayRegex);

    public static final String HourNumRegex = "\\b(?<hournum>zero|uma|duas|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze)\\b";

    public static final String MinuteNumRegex = "(?<minnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)";

    public static final String DeltaMinuteNumRegex = "(?<deltaminnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)";

    public static final String PmRegex = "(horas\\s+)?(?<pm>((pela|de|da|\\b[àa]\\b|na)\\s+(tarde|noite)))|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio dia|meio-dia))";

    public static final String AmRegex = "(horas\\s+)?(?<am>(pela|de|da|na)\\s+(manh[ãa]|madrugada))";

    public static final String AmTimeRegex = "(?<am>([dn]?es[st]a|(pela|de|da|na))\\s+(manh[ãa]|madrugada))";

    public static final String PmTimeRegex = "(?<pm>(([dn]?es[st]a|\\b[àa]\\b|(pela|de|da|na))\\s+(tarde|noite)))|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio dia|meio-dia))";

    public static final String LessThanOneHour = "(?<lth>((\\s+e\\s+)?(quinze|(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?)|quinze|(\\s*)(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?|(\\s+e\\s+)(meia|trinta)|({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex})(\\s+(minuto|minutos|min|mins))?))"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{DeltaMinuteNumRegex}", DeltaMinuteNumRegex);

    public static final String LessThanOneHourSuffix = "(?<lth>((\\s+e\\s+)?(quinze|(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?)|quinze|(\\s*)(um\\s+|dois\\s+|tr[êes]\\s+)?quartos?|(\\s+e\\s+)(meia|trinta)))";

    public static final String TensTimeRegex = "(?<tens>dez|vinte|trinta|[qc]uarenta|cin[qc]uenta)";

    public static final String WrittenTimeRegex = "(?<writtentime>({HourNumRegex}\\s*((e|menos)\\s+)?(({TensTimeRegex}((\\s*e\\s+)?{MinuteNumRegex}))|{MinuteNumRegex}))|(({MinuteNumRegex}|({TensTimeRegex}((\\s*e\\s+)?{MinuteNumRegex})?))\\s*((para as|pras|antes da|antes das)\\s+)?({HourNumRegex}|{BaseDateTime.HourRegex})))"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex)
            .replace("{TensTimeRegex}", TensTimeRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimePrefix = "(?<prefix>{LessThanOneHour}(\\s+(passad[ao]s)\\s+(as)?|\\s+depois\\s+(das?|do)|\\s+pras?|\\s+(para|antes)?\\s+([àa]s?)))"
            .replace("{LessThanOneHour}", LessThanOneHour);

    public static final String TimeSuffix = "(?<suffix>({LessThanOneHour}\\s+)?({AmRegex}|{PmRegex}|{OclockRegex}))"
            .replace("{LessThanOneHour}", LessThanOneHour)
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String BasicTime = "(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex);

    public static final String MidnightRegex = "(?<midnight>meia\\s*(-\\s*)?noite)";

    public static final String MidmorningRegex = "(?<midmorning>meio\\s+da\\s+manhã)";

    public static final String MidEarlyMorning = "(?<midearlymorning>meio\\s+da\\s+madrugada)";

    public static final String MidafternoonRegex = "(?<midafternoon>meio\\s+da\\s+tarde)";

    public static final String MiddayRegex = "(?<midday>meio\\s*(-\\s*)?dia)";

    public static final String MidTimeRegex = "(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidEarlyMorning}|{MidafternoonRegex}|{MiddayRegex}))"
            .replace("{MidnightRegex}", MidnightRegex)
            .replace("{MidmorningRegex}", MidmorningRegex)
            .replace("{MidafternoonRegex}", MidafternoonRegex)
            .replace("{MiddayRegex}", MiddayRegex)
            .replace("{MidEarlyMorning}", MidEarlyMorning);

    public static final String AtRegex = "\\b(((?<=\\b(d?[aà]s?)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(\\s+e\\s+{BaseDateTime.MinuteRegex})?)(\\s+horas?|\\s*h\\b)?|(?<=\\b(s(er)?[aã]o|v[aã]o\\s+ser|^[eé]h?)\\s+|^\\s*)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\\s+horas?|\\s*h\\b))(\\s+{OclockRegex})?|{MidTimeRegex})\\b"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{OclockRegex}", OclockRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String ConnectNumRegex = "({BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex})"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex1 = "(\\b{TimePrefix}\\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\\s*({DescRegex})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex2 = "(\\b{TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?:(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?((\\s*{DescRegex})|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex3 = "(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex4 = "\\b(({DescRegex}\\s*)?(({TimePrefix}\\s*)({HourNumRegex}|{BaseDateTime.HourRegex})|({HourNumRegex}|{BaseDateTime.HourRegex})(\\s+{TensTimeRegex}(\\s+e\\s+)?{MinuteNumRegex}?)|{BasicTime}(\\s*{DescRegex})?(?<prefix>{LessThanOneHourSuffix}))(\\s*({DescRegex}|{OclockRegex}))?)\\b"
            .replace("{DescRegex}", DescRegex)
            .replace("{BasicTime}", BasicTime)
            .replace("{TimePrefix}", TimePrefix)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TensTimeRegex}", TensTimeRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex)
            .replace("{OclockRegex}", OclockRegex)
            .replace("{LessThanOneHourSuffix}", LessThanOneHourSuffix);

    public static final String TimeRegex5 = "\\b({TimePrefix}|{BasicTime}(?<prefix>{LessThanOneHourSuffix}))\\s+(\\s*{DescRegex})?{BasicTime}?\\s*{TimeSuffix}\\b"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{LessThanOneHourSuffix}", LessThanOneHourSuffix);

    public static final String TimeRegex6 = "({BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}\\b)"
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex7 = "\\b{TimeSuffix}\\s+[àa]s?\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex8 = "\\b{TimeSuffix}\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex9 = "\\b(?<writtentime>{HourNumRegex}\\s+({TensTimeRegex}\\s*)(e\\s+)?{MinuteNumRegex}?)\\b"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{TensTimeRegex}", TensTimeRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex);

    public static final String TimeRegex11 = "\\b({WrittenTimeRegex})(\\s+{DescRegex})?\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex12 = "(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String PrepositionRegex = "(?<prep>([àa]s?|em|por|pel[ao]|n[ao]|de|d[ao]?)?$)";

    public static final String NowRegex = "\\b(?<now>((logo|exatamente)\\s+)?agora(\\s+mesmo)?|neste\\s+momento|(assim\\s+que|t[ãa]o\\s+cedo\\s+quanto)\\s+(poss[ií]vel|possas?|possamos)|o\\s+mais\\s+(cedo|r[aá]pido)\\s+poss[íi]vel|recentemente|previamente)\\b";

    public static final String SuffixRegex = "^\\s*((e|a|em|por|pel[ao]|n[ao]|de)\\s+)?(manh[ãa]|madrugada|meio\\s*dia|tarde|noite)\\b";

    public static final String TimeOfDayRegex = "\\b(?<timeOfDay>manh[ãa]|madrugada|tarde|noite|((depois\\s+do|ap[óo]s\\s+o)\\s+(almo[çc]o|meio[ -]dia)))\\b";

    public static final String SpecificTimeOfDayRegex = "\\b(((((a)?\\s+|[nd]?es[st]a|seguinte|pr[oó]xim[oa]|[uú]ltim[oa])\\s+)?{TimeOfDayRegex}))\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String TimeOfTodayAfterRegex = "^\\s*(,\\s*)?([àa]|em|por|pel[ao]|de|no|na?\\s+)?{SpecificTimeOfDayRegex}"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex);

    public static final String TimeOfTodayBeforeRegex = "({SpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]s|para))?\\s*)"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayAfterRegex = "({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?{SpecificTimeOfDayRegex}"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayBeforeRegex = "({SpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]s|((cerca|perto|ao\\s+redor|por\\s+volta)\\s+(de|das))))?\\s*({HourNumRegex}|{BaseDateTime.HourRegex}))"
            .replace("{SpecificTimeOfDayRegex}", SpecificTimeOfDayRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String SpecificEndOfRegex = "([na]o\\s+)?(fi(m|nal)|t[ée]rmin(o|ar))(\\s+d?o(\\s+dia)?(\\s+de)?)?\\s*$";

    public static final String UnspecificEndOfRegex = "^[.]";

    public static final String UnspecificEndOfRangeRegex = "^[.]";

    public static final String UnitRegex = "(?<unit>anos?|meses|m[êe]s|semanas?|dias?|horas?|hrs?|hs?|minutos?|mins?|segundos?|segs?)\\b";

    public static final String ConnectorRegex = "^(,|t|para [ao]|para as|pras|(cerca|perto|ao\\s+redor|por\\s+volta)\\s+(de|das)|quase)$";

    public static final String TimeHourNumRegex = "(?<hour>vinte( e (um|dois|tr[êe]s|quatro))?|zero|uma?|dois|duas|tr[êe]s|quatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|quatorze|catorze|quinze|dez([ea]sseis|[ea]ssete|oito|[ea]nove))";

    public static final String PureNumFromTo = "(((desde|de|da|das)\\s+(a(s)?\\s+)?)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}|horas))?\\s*{TillRegex}(?<![aà]s)|((desde|de|da|das)\\s+(a(s)?\\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}|horas))?\\s*{TillRegex})\\s*({BaseDateTime.HourRegex}|{TimeHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex}|horas)?"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String PureNumBetweenAnd = "(entre\\s+((a|as)?\\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\\s*(?<leftDesc>{DescRegex}|horas))?\\s*e\\s*(a(s)?\\s+)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex}|horas)?"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String SpecificTimeFromTo = "^[.]";

    public static final String SpecificTimeBetweenAnd = "^[.]";

    public static final String TimeUnitRegex = "(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\\b";

    public static final String TimeFollowedUnit = "^\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String TimeNumberCombinedWithUnit = "\\b(?<num>\\d+(\\,\\d*)?)\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String DateTimePeriodNumberCombinedWithUnit = "\\b(?<num>\\d+(\\.\\d*)?)\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String PeriodTimeOfDayWithDateRegex = "\\b((e|[àa]|em|na|no|ao|pel[ao]|de)\\s+)?(?<timeOfDay>manh[ãa]|madrugada|(passado\\s+(o\\s+)?)?meio\\s+dia|tarde|noite)\\b";

    public static final String RelativeTimeUnitRegex = "({PastRegex}|{FutureRegex})\\s+{UnitRegex}|{UnitRegex}\\s+({PastRegex}|{FutureRegex})"
            .replace("{PastRegex}", PastRegex)
            .replace("{FutureRegex}", FutureRegex)
            .replace("{UnitRegex}", UnitRegex);

    public static final String SuffixAndRegex = "(?<suffix>\\s*(e)\\s+(?<suffix_num>meia|(um\\s+)?quarto))";

    public static final String FollowedUnit = "^\\s*{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String LessThanRegex = "^[.]";

    public static final String MoreThanRegex = "^[.]";

    public static final String DurationNumberCombinedWithUnit = "\\b(?<num>\\d+(\\,\\d*)?){UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String AnUnitRegex = "\\b(um(a)?)\\s+{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String DuringRegex = "^[.]";

    public static final String AllRegex = "\\b(?<all>tod[oa]?\\s+(o|a)\\s+(?<unit>ano|m[êe]s|semana|dia))\\b";

    public static final String HalfRegex = "\\b(?<half>mei[oa]\\s+(?<unit>ano|m[êe]s|semana|dia|hora))\\b";

    public static final String ConjunctionRegex = "^[.]";

    public static final String InexactNumberRegex = "\\b(poucos|pouco|algum|alguns|v[áa]rios)\\b";

    public static final String InexactNumberUnitRegex = "\\b(poucos|pouco|algum|alguns|v[áa]rios)\\s+{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String HolidayRegex1 = "\\b(?<holiday>sexta-feira santa|sexta-feira da paix[ãa]o|quarta-feira de cinzas|carnaval|dia dos? presidentes?|ano novo chin[eê]s|ano novo|v[ée]spera de ano novo|natal|v[ée]spera de natal|dia de a[cç][ãa]o de gra[çc]as|a[cç][ãa]o de gra[çc]as|yuandan|halloween|dia das bruxas|p[áa]scoa)(\\s+(d[eo]?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String HolidayRegex2 = "\\b(?<holiday>(dia\\s+(d[eoa]s?\\s+)?)?(martin luther king|todos os santos|s[ãa]o (patr[íi]cio|francisco|jorge|jo[ãa]o)|independ[êe]ncia))(\\s+(d[eo]?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String HolidayRegex3 = "\\b(?<holiday>(dia\\s+d[eoa]s?\\s+)(trabalh(o|ador(es)?)|m[ãa]es?|pais?|mulher(es)?|crian[çc]as?|marmota|professor(es)?))(\\s+(d[eo]?\\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\\s+ano))?\\b"
            .replace("{YearRegex}", YearRegex);

    public static final String BeforeRegex = "(antes(\\s+(d(e\\s+)?[aeo]s?)?)?|at[ée]h?(\\s+[oàa]s?\\b)?)";

    public static final String AfterRegex = "((depois|ap[óo]s|a\\s+partir)(\\s*(de|d?[oa]s?)?)?)";

    public static final String SinceRegex = "(desde(\\s+(as?|o))?)";

    public static final String AroundRegex = "(?:\\b(?:cerca|perto|ao\\s+redor|por\\s+volta)\\s*?\\b)(\\s+(de|das))?";

    public static final String PeriodicRegex = "\\b(?<periodic>di[áa]ri[ao]|(diaria|mensal|semanal|quinzenal|(bi|tri|se)mestral|anual)(mente)?)\\b";

    public static final String EachExpression = "cada|tod[oa]s?\\s*([oa]s)?";

    public static final String EachUnitRegex = "(?<each>({EachExpression})\\s*{UnitRegex})"
            .replace("{EachExpression}", EachExpression)
            .replace("{UnitRegex}", UnitRegex);

    public static final String EachPrefixRegex = "(?<each>({EachExpression})\\s*$)"
            .replace("{EachExpression}", EachExpression);

    public static final String EachDayRegex = "\\s*({EachExpression})\\s*dias\\s*\\b"
            .replace("{EachExpression}", EachExpression);

    public static final String BeforeEachDayRegex = "({EachExpression})\\s*dias(\\s+a[so])?\\s*\\b"
            .replace("{EachExpression}", EachExpression);

    public static final String SetEachRegex = "(?<each>({EachExpression})\\s*)"
            .replace("{EachExpression}", EachExpression);

    public static final String LaterEarlyPeriodRegex = "^[.]";

    public static final String WeekWithWeekDayRangeRegex = "^[.]";

    public static final String GeneralEndingRegex = "^[.]";

    public static final String MiddlePauseRegex = "^[.]";

    public static final String PrefixArticleRegex = "^[\\.]";

    public static final String OrRegex = "^[.]";

    public static final String SpecialYearTermsRegex = "\\b(({SpecialYearPrefixes}\\s+anos?\\s+|anos?\\s+({SpecialYearPrefixes}\\s+)?)(d[oe]\\s+)?)"
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes);

    public static final String YearPlusNumberRegex = "\\b({SpecialYearTermsRegex}((?<year>(\\d{2,4}))|{FullTextYearRegex}))\\b"
            .replace("{FullTextYearRegex}", FullTextYearRegex)
            .replace("{SpecialYearTermsRegex}", SpecialYearTermsRegex);

    public static final String NumberAsTimeRegex = "\\b({WrittenTimeRegex}|({TimeHourNumRegex}|{BaseDateTime.HourRegex})(?<desc>\\s*horas)?)\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimeBeforeAfterRegex = "^[.]";

    public static final String DateNumberConnectorRegex = "^[.]";

    public static final String ComplexDatePeriodRegex = "^[.]";

    public static final String AgoRegex = "\\b(antes(\\s+d[eoa]s?\\s+(?<day>hoje|ontem|manhã))?|atr[áa]s|no passado)\\b";

    public static final String LaterRegex = "\\b(depois(\\s+d[eoa]s?\\s+(agora|(?<day>hoje|ontem|manhã)))?|ap[óo]s (as)?|desde( (as|o))?|no futuro|mais tarde)\\b";

    public static final String Tomorrow = "amanh[ãa]";

    public static final ImmutableMap<String, String> UnitMap = ImmutableMap.<String, String>builder()
        .put("anos", "Y")
        .put("ano", "Y")
        .put("meses", "MON")
        .put("mes", "MON")
        .put("mês", "MON")
        .put("semanas", "W")
        .put("semana", "W")
        .put("dias", "D")
        .put("dia", "D")
        .put("horas", "H")
        .put("hora", "H")
        .put("hrs", "H")
        .put("hr", "H")
        .put("h", "H")
        .put("minutos", "M")
        .put("minuto", "M")
        .put("mins", "M")
        .put("min", "M")
        .put("segundos", "S")
        .put("segundo", "S")
        .put("segs", "S")
        .put("seg", "S")
        .build();

    public static final ImmutableMap<String, Long> UnitValueMap = ImmutableMap.<String, Long>builder()
        .put("anos", 31536000L)
        .put("ano", 31536000L)
        .put("meses", 2592000L)
        .put("mes", 2592000L)
        .put("mês", 2592000L)
        .put("semanas", 604800L)
        .put("semana", 604800L)
        .put("dias", 86400L)
        .put("dia", 86400L)
        .put("horas", 3600L)
        .put("hora", 3600L)
        .put("hrs", 3600L)
        .put("hr", 3600L)
        .put("h", 3600L)
        .put("minutos", 60L)
        .put("minuto", 60L)
        .put("mins", 60L)
        .put("min", 60L)
        .put("segundos", 1L)
        .put("segundo", 1L)
        .put("segs", 1L)
        .put("seg", 1L)
        .build();

    public static final ImmutableMap<String, String> SpecialYearPrefixesMap = ImmutableMap.<String, String>builder()
        .put("fiscal", "FY")
        .put("escolar", "SY")
        .put("letivo", "SY")
        .build();

    public static final ImmutableMap<String, String> SeasonMap = ImmutableMap.<String, String>builder()
        .put("primavera", "SP")
        .put("verao", "SU")
        .put("verão", "SU")
        .put("outono", "FA")
        .put("inverno", "WI")
        .build();

    public static final ImmutableMap<String, Integer> SeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> CardinalMap = ImmutableMap.<String, Integer>builder()
        .put("primeiro", 1)
        .put("primeira", 1)
        .put("1o", 1)
        .put("1a", 1)
        .put("segundo", 2)
        .put("segunda", 2)
        .put("2o", 2)
        .put("2a", 2)
        .put("terceiro", 3)
        .put("terceira", 3)
        .put("3o", 3)
        .put("3a", 3)
        .put("cuarto", 4)
        .put("quarto", 4)
        .put("cuarta", 4)
        .put("quarta", 4)
        .put("4o", 4)
        .put("4a", 4)
        .put("quinto", 5)
        .put("quinta", 5)
        .put("5o", 5)
        .put("5a", 5)
        .put("sexto", 6)
        .put("sexta", 6)
        .put("6o", 6)
        .put("6a", 6)
        .put("setimo", 7)
        .put("sétimo", 7)
        .put("setima", 7)
        .put("sétima", 7)
        .put("7o", 7)
        .put("7a", 7)
        .put("oitavo", 8)
        .put("oitava", 8)
        .put("8o", 8)
        .put("8a", 8)
        .put("nono", 9)
        .put("nona", 9)
        .put("9o", 9)
        .put("9a", 9)
        .put("decimo", 10)
        .put("décimo", 10)
        .put("decima", 10)
        .put("décima", 10)
        .put("10o", 10)
        .put("10a", 10)
        .put("decimo primeiro", 11)
        .put("décimo primeiro", 11)
        .put("decima primeira", 11)
        .put("décima primeira", 11)
        .put("11o", 11)
        .put("11a", 11)
        .put("decimo segundo", 12)
        .put("décimo segundo", 12)
        .put("decima segunda", 12)
        .put("décima segunda", 12)
        .put("12o", 12)
        .put("12a", 12)
        .build();

    public static final ImmutableMap<String, Integer> DayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("segunda-feira", 1)
        .put("segundas-feiras", 1)
        .put("segunda feira", 1)
        .put("segundas feiras", 1)
        .put("segunda", 1)
        .put("segundas", 1)
        .put("terça-feira", 2)
        .put("terças-feiras", 2)
        .put("terça feira", 2)
        .put("terças feiras", 2)
        .put("terça", 2)
        .put("terças", 2)
        .put("terca-feira", 2)
        .put("tercas-feiras", 2)
        .put("terca feira", 2)
        .put("tercas feiras", 2)
        .put("terca", 2)
        .put("tercas", 2)
        .put("quarta-feira", 3)
        .put("quartas-feiras", 3)
        .put("quarta feira", 3)
        .put("quartas feiras", 3)
        .put("quarta", 3)
        .put("quartas", 3)
        .put("quinta-feira", 4)
        .put("quintas-feiras", 4)
        .put("quinta feira", 4)
        .put("quintas feiras", 4)
        .put("quinta", 4)
        .put("quintas", 4)
        .put("sexta-feira", 5)
        .put("sextas-feiras", 5)
        .put("sexta feira", 5)
        .put("sextas feiras", 5)
        .put("sexta", 5)
        .put("sextas", 5)
        .put("sabado", 6)
        .put("sabados", 6)
        .put("sábado", 6)
        .put("sábados", 6)
        .put("domingo", 0)
        .put("domingos", 0)
        .put("seg", 1)
        .put("seg.", 1)
        .put("2a", 1)
        .put("ter", 2)
        .put("ter.", 2)
        .put("3a", 2)
        .put("qua", 3)
        .put("qua.", 3)
        .put("4a", 3)
        .put("qui", 4)
        .put("qui.", 4)
        .put("5a", 4)
        .put("sex", 5)
        .put("sex.", 5)
        .put("6a", 5)
        .put("sab", 6)
        .put("sab.", 6)
        .put("dom", 0)
        .put("dom.", 0)
        .build();

    public static final ImmutableMap<String, Integer> MonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("janeiro", 1)
        .put("fevereiro", 2)
        .put("março", 3)
        .put("marco", 3)
        .put("abril", 4)
        .put("maio", 5)
        .put("junho", 6)
        .put("julho", 7)
        .put("agosto", 8)
        .put("septembro", 9)
        .put("setembro", 9)
        .put("outubro", 10)
        .put("novembro", 11)
        .put("dezembro", 12)
        .put("jan", 1)
        .put("fev", 2)
        .put("mar", 3)
        .put("abr", 4)
        .put("mai", 5)
        .put("jun", 6)
        .put("jul", 7)
        .put("ago", 8)
        .put("sept", 9)
        .put("set", 9)
        .put("out", 10)
        .put("nov", 11)
        .put("dez", 12)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .build();

    public static final ImmutableMap<String, Integer> Numbers = ImmutableMap.<String, Integer>builder()
        .put("zero", 0)
        .put("um", 1)
        .put("uma", 1)
        .put("dois", 2)
        .put("tres", 3)
        .put("três", 3)
        .put("quatro", 4)
        .put("cinco", 5)
        .put("seis", 6)
        .put("sete", 7)
        .put("oito", 8)
        .put("nove", 9)
        .put("dez", 10)
        .put("onze", 11)
        .put("doze", 12)
        .put("dezena", 12)
        .put("dezenas", 12)
        .put("treze", 13)
        .put("catorze", 14)
        .put("quatorze", 14)
        .put("quinze", 15)
        .put("dezesseis", 16)
        .put("dezasseis", 16)
        .put("dezessete", 17)
        .put("dezassete", 17)
        .put("dezoito", 18)
        .put("dezenove", 19)
        .put("dezanove", 19)
        .put("vinte", 20)
        .put("vinte e um", 21)
        .put("vinte e uma", 21)
        .put("vinte e dois", 22)
        .put("vinte e duas", 22)
        .put("vinte e tres", 23)
        .put("vinte e três", 23)
        .put("vinte e quatro", 24)
        .put("vinte e cinco", 25)
        .put("vinte e seis", 26)
        .put("vinte e sete", 27)
        .put("vinte e oito", 28)
        .put("vinte e nove", 29)
        .put("trinta", 30)
        .put("trinta e um", 31)
        .put("quarenta", 40)
        .put("cinquenta", 50)
        .build();

    public static final ImmutableMap<String, String[]> HolidayNames = ImmutableMap.<String, String[]>builder()
        .put("pai", new String[]{"diadopai", "diadospais"})
        .put("mae", new String[]{"diadamae", "diadasmaes"})
        .put("acaodegracas", new String[]{"diadegracas", "diadeacaodegracas", "acaodegracas"})
        .put("trabalho", new String[]{"diadotrabalho", "diadotrabalhador", "diadostrabalhadores"})
        .put("pascoa", new String[]{"diadepascoa", "pascoa"})
        .put("natal", new String[]{"natal", "diadenatal"})
        .put("vesperadenatal", new String[]{"vesperadenatal"})
        .put("anonovo", new String[]{"anonovo", "diadeanonovo", "diadoanonovo"})
        .put("vesperadeanonovo", new String[]{"vesperadeanonovo", "vesperadoanonovo"})
        .put("yuandan", new String[]{"yuandan"})
        .put("todosossantos", new String[]{"todosossantos"})
        .put("professor", new String[]{"diadoprofessor", "diadosprofessores"})
        .put("crianca", new String[]{"diadacrianca", "diadascriancas"})
        .put("mulher", new String[]{"diadamulher"})
        .build();

    public static final ImmutableMap<String, String> VariableHolidaysTimexDictionary = ImmutableMap.<String, String>builder()
        .put("pai", "-06-WXX-7-3")
        .put("mae", "-05-WXX-7-2")
        .put("acaodegracas", "-11-WXX-4-4")
        .put("memoria", "-03-WXX-2-4")
        .build();

    public static final ImmutableMap<String, Double> DoubleNumbers = ImmutableMap.<String, Double>builder()
        .put("metade", 0.5D)
        .put("quarto", 0.25D)
        .build();

    public static final String DateTokenPrefix = "em ";

    public static final String TimeTokenPrefix = "as ";

    public static final String TokenBeforeDate = "o ";

    public static final String TokenBeforeTime = "as ";

    public static final String PastPrefixRegex = ".^";

    public static final String PreviousPrefixRegex = "([uú]ltim[oa]s?|passad[oa]s?|{PastPrefixRegex})\\b"
            .replace("{PastPrefixRegex}", PastPrefixRegex);

    public static final String ThisPrefixRegex = "([nd]?es[st][ea])\\b";

    public static final String RelativeDayRegex = "^[\\.]";

    public static final String RestOfDateRegex = "^[\\.]";

    public static final String DurationUnitRegex = "(?<unit>{DateUnitRegex}|{TimeUnitRegex}|noites?)\\b"
            .replace("{DateUnitRegex}", DateUnitRegex)
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String RelativeDurationUnitRegex = "(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+)({DurationUnitRegex}))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String ReferenceDatePeriodRegex = "^[.]";

    public static final String FromToRegex = "\\b(from).+(to)\\b.+";

    public static final String SingleAmbiguousMonthRegex = "^(the\\s+)?(may|march)$";

    public static final String UnspecificDatePeriodRegex = "^[.]";

    public static final String PrepositionSuffixRegex = "\\b(on|in|at|around|from|to)$";

    public static final String RestOfDateTimeRegex = "^[\\.]";

    public static final String SetWeekDayRegex = "^[\\.]";

    public static final String NightRegex = "\\b(meia noite|noite|de noite)\\b";

    public static final String CommonDatePrefixRegex = "\\b(dia)\\s+$";

    public static final String DurationConnectorRegex = "^[.]";

    public static final String CenturyRegex = "^[.]";

    public static final String DecadeRegex = "^[.]";

    public static final String DecadeWithCenturyRegex = "^[.]";

    public static final String RelativeDecadeRegex = "\\b((n?as?\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?(d[eé]cada)s?)\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String YearSuffix = "((,|\\sde)?\\s*({YearRegex}|{FullTextYearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String SuffixAfterRegex = "^\\b$";

    public static final String YearPeriodRegex = "((((de(sde)?(\\s*a(s)?)?)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((entre\\s*([oa](s)?)?)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String FutureSuffixRegex = "\\b(seguinte(s)?|pr[oó]xim[oa](s)?|no\\s+futuro)\\b";

    public static final String PastSuffixRegex = "^\\b$";

    public static final String ModPrefixRegex = "\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AroundRegex}", AroundRegex)
            .replace("{BeforeRegex}", BeforeRegex)
            .replace("{AfterRegex}", AfterRegex)
            .replace("{SinceRegex}", SinceRegex);

    public static final String ModSuffixRegex = "\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b"
            .replace("{AgoRegex}", AgoRegex)
            .replace("{LaterRegex}", LaterRegex)
            .replace("{BeforeAfterRegex}", BeforeAfterRegex)
            .replace("{FutureSuffixRegex}", FutureSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final ImmutableMap<String, Integer> WrittenDecades = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final ImmutableMap<String, Integer> SpecialDecadeCases = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final String DefaultLanguageFallback = "DMY";

    public static final List<String> DurationDateRestrictions = Arrays.asList();

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)")
        .put("^(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)$", "([$%£&!?@#])(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)|(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)([$%£&@#])")
        .put("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}")
        .put("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")
        .build();

    public static final ImmutableMap<String, String> AmbiguityTimeFiltersDict = ImmutableMap.<String, String>builder()
        .put("horas?$", "\\b((por|duração\\s+de|durante)\\s+(\\S+\\s+){1,2}horas?|horas?\\s+(\\S+\\s+){0,2}dur(ação|ou|a(rá|va)?))\\b")
        .build();

    public static final List<String> EarlyMorningTermList = Arrays.asList("madrugada");

    public static final List<String> MorningTermList = Arrays.asList("manha", "manhã");

    public static final List<String> AfternoonTermList = Arrays.asList("passado o meio dia", "depois do meio dia");

    public static final List<String> EveningTermList = Arrays.asList("tarde");

    public static final List<String> NightTermList = Arrays.asList("noite");

    public static final List<String> SameDayTerms = Arrays.asList("hoje", "este dia", "esse dia", "o dia");

    public static final List<String> PlusOneDayTerms = Arrays.asList("amanha", "de amanha", "dia seguinte", "o dia de amanha", "proximo dia");

    public static final List<String> MinusOneDayTerms = Arrays.asList("ontem", "ultimo dia");

    public static final List<String> PlusTwoDayTerms = Arrays.asList("depois de amanha", "dia depois de amanha");

    public static final List<String> MinusTwoDayTerms = Arrays.asList("anteontem", "dia antes de ontem");

    public static final List<String> MonthTerms = Arrays.asList("mes", "meses");

    public static final List<String> MonthToDateTerms = Arrays.asList("mes ate agora", "mes ate hoje", "mes ate a data");

    public static final List<String> WeekendTerms = Arrays.asList("fim de semana");

    public static final List<String> WeekTerms = Arrays.asList("semana");

    public static final List<String> FortnightTerms = Arrays.asList("quinzena");

    public static final List<String> YearTerms = Arrays.asList("ano", "anos");

    public static final List<String> YearToDateTerms = Arrays.asList("ano ate agora", "ano ate hoje", "ano ate a data", "anos ate agora", "anos ate hoje", "anos ate a data");

    public static final ImmutableMap<Character, Character> SpecialCharactersEquivalent = ImmutableMap.<Character, Character>builder()
        .put('á', 'a')
        .put('é', 'e')
        .put('í', 'i')
        .put('ó', 'o')
        .put('ú', 'u')
        .put('ê', 'e')
        .put('ô', 'o')
        .put('ü', 'u')
        .put('ã', 'a')
        .put('õ', 'o')
        .put('ç', 'c')
        .build();

    public static final String DayTypeRegex = "(diari([ao]|amente))$";

    public static final String WeekTypeRegex = "(semanal(mente)?)$";

    public static final String BiWeekTypeRegex = "(quinzenal(mente)?)$";

    public static final String MonthTypeRegex = "(mensal(mente)?)$";

    public static final String BiMonthTypeRegex = "(bimestral(mente)?)$";

    public static final String QuarterTypeRegex = "(trimestral(mente)?)$";

    public static final String SemiAnnualTypeRegex = "(semestral(mente)?)$";

    public static final String YearTypeRegex = "(anual(mente)?)$";
}
