// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class GermanDateTime {

    public static final String LangMarker = "Ger";

    public static final Boolean CheckBothBeforeAfter = false;

    public static final String TillRegex = "(?<till>zu|bis\\s*zum|zum|bis|bis\\s*hin(\\s*zum)?|--|-|—|——)";

    public static final String RangeConnectorRegex = "(?<and>und|--|-|—|——)";

    public static final String RelativeRegex = "\\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|vorletzte[snm]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?|de[rmsn]|das(?!\\s+tag)|am)";

    public static final String StrictRelativeRegex = "\\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?)";

    public static final String UpcomingPrefixRegex = ".^";

    public static final String NextPrefixRegex = "\\b((über)?nächste[rmns]?|kommende[rns]?|{UpcomingPrefixRegex})\\b"
            .replace("{UpcomingPrefixRegex}", UpcomingPrefixRegex);

    public static final String AfterNextPrefixRegex = "\\bübernächste[rmns]?\\b";

    public static final String PastPrefixRegex = ".^";

    public static final String PreviousPrefixRegex = "\\b(letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vor(ige[rns]?)?|{PastPrefixRegex})\\b"
            .replace("{PastPrefixRegex}", PastPrefixRegex);

    public static final String ThisPrefixRegex = "\\b(diese[rnms]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?)\\b";

    public static final String RangePrefixRegex = "(vo[nm]|zwischen)";

    public static final String PenultimatePrefixRegex = "\\b(vorletzte[snm]?)\\b";

    public static final String WrittenOneToNineRegex = "(eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun)";

    public static final String DayRegex = "(de[rmsn]\\s*)?(?<day>(01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(\\.|\\b))";

    public static final String WrittenDayNumRegex = "\\b(de[rmsn]\\s+)?(?<day>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zwölft|zwoelft|dreizehnt|vierzehnt|fünfzehnt|fuenfzehnt|sechzehnt|siebzehnt|achtzehnt|neunzehnt|({WrittenOneToNineRegex}und)?zwanzigst|(einund)?dreißigst)e[nr]\\b"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String MonthNumRegex = "(?<month>(01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)(\\.|\\b))";

    public static final String WrittenMonthNumRegex = "\\b(?<month>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zw(ö|oe)lft)e[nr]\\b";

    public static final String AmDescRegex = "({BaseDateTime.BaseAmDescRegex})"
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex);

    public static final String PmDescRegex = "({BaseDateTime.BasePmDescRegex})"
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String AmPmDescRegex = "({BaseDateTime.BaseAmPmDescRegex})"
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex);

    public static final String OclockRegex = "(?<oclock>uhr)";

    public static final String DescRegex = "({OclockRegex})"
            .replace("{OclockRegex}", OclockRegex);

    public static final String TwoDigitYearRegex = "\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String CenturyRegex = "\\b(?<century>((ein|zwei)?tausend(und)?)?((ein|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf|zwölf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn)hundert))\\b";

    public static final String WrittenNumRegex = "(zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig|elf|zehn|{WrittenOneToNineRegex})"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String FullTextYearRegex = "\\b((?<firsttwoyearnum>{CenturyRegex})\\s+(?<lasttwoyearnum>((zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig)\\s+{WrittenNumRegex})|{WrittenNumRegex}))\\b|\\b(?<firsttwoyearnum>{CenturyRegex})\\b"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{WrittenNumRegex}", WrittenNumRegex);

    public static final String YearRegex = "({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String WeekDayRegex = "(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\\.|\\b))";

    public static final String SingleWeekDayRegex = "\\b(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\\.|\\b))";

    public static final String RelativeMonthRegex = "(?<relmonth>{RelativeRegex}\\s+monat(s)?)"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WrittenMonthRegex = "((monat\\s*)?(?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|j[äa]n(uar|ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.)))";

    public static final String MonthSuffixRegex = "(?<msuf>(im\\s*|des\\s*)?({RelativeMonthRegex}|{WrittenMonthRegex}|{MonthNumRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{WrittenMonthRegex}", WrittenMonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String DateUnitRegex = "(?<unit>tg|woche(?<plural>n)?|(jahr|monat|tag)(?<plural>e)?)(s)?";

    public static final String HalfTokenRegex = "^(halb)";

    public static final String QuarterToTokenRegex = "^(viertel\\s+vor|dreiviertel)\\s*$";

    public static final String QuarterPastTokenRegex = "^(viertel\\s+nach)\\s*$";

    public static final String ThreeQuarterToTokenRegex = "^(viertel|dreiviertel\\s+vor)\\s*$";

    public static final String ThreeQuarterPastTokenRegex = "^(dreiviertel\\s+nach)\\s*$";

    public static final String SimpleCasesRegex = "((vom|zwischen)\\s+)?({DayRegex})(\\s*{MonthSuffixRegex})?\\s*{TillRegex}\\s*({DayRegex})(\\s*{MonthSuffixRegex})?((\\s+|\\s*,\\s*){YearRegex})?"
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontSimpleCasesRegex = "((vom|zwischen)\\s*)?{MonthSuffixRegex}\\s*((vom|zwischen)\\s*)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontBetweenRegex = "({MonthSuffixRegex}\\s+(zwischen\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?)"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String BetweenRegex = "((zwischen\\s+)({DayRegex})(\\s+{MonthSuffixRegex})?\\s*{RangeConnectorRegex}\\s*({DayRegex})(\\s+{MonthSuffixRegex})((\\s+|\\s*,\\s*){YearRegex})?|(zwischen\\s+)({DayRegex})(\\s+{MonthSuffixRegex})?\\s*{RangeConnectorRegex}\\s*({DayRegex})(\\s+{MonthSuffixRegex})?((\\s+|\\s*,\\s*){YearRegex})?)"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthWithYear = "\\b((?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|januar|j[äa]n(ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.))(\\s*),?(\\s+des)?(\\s*)({YearRegex}|(?<order>nächste[mn]|letzte[mn]|diese(s|n))\\s+jahres))"
            .replace("{YearRegex}", YearRegex);

    public static final String OneWordPeriodRegex = "\\b((((im\\s+)?monat\\s+)?({RelativeRegex}\\s*(jahr\\s*(im\\s*)?)?)?(?<month>apr(il|\\.)|aug(ust|\\.)|dez(ember|\\.)|feb(ruar|ber|\\.)|j[äa]n(uar|ner|\\.)|jul(e?i|l\\.)|jun([io]|\\.)|märz|mai|nov(ember|\\.)|okt(ober|\\.)|sept?(ember|\\.)))|(?<business>unter\\s+der\\s+woche)|({RelativeRegex}\\s+)?((?<business>werktags|arbeitswoche)|woche(nende)?|monat(s)?|jahr|jahres)(?!(\\s+\\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\\s+bis\\s+heute)))\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex)
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String MonthNumWithYear = "({YearRegex}(\\s*)[/\\-\\.](\\s*){MonthNumRegex})|({MonthNumRegex}(\\s*)[/\\-\\.](\\s*){YearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String WeekOfMonthRegex = "(?<wom>((die|der)\\s+)(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+woche\\s+(des|diese(s|n)|im)\\s+({MonthSuffixRegex}|monat(s)?))"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String WeekOfYearRegex = "(?<woy>((die|der)\\s+)?(?<cardinal>(erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+woche\\s+(im|diese(s|n)|\\s+des)?\\s+({YearRegex}|{RelativeRegex}\\s+jahr(en|es|e)?)))"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String OfYearRegex = "\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String FirstLastRegex = "\\b(the\\s+)?((?<first>first)|(?<last>last))\\b";

    public static final String FollowedDateUnit = "^\\s*{DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String NumberCombinedWithDateUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String QuarterRegex = "((das|im|in dem|dem)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.)\\s+quartal(\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String QuarterRegexYearFront = "(?!)#({YearRegex}|{RelativeRegex}\\s+year)\\s+(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)\\s+quarter"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String AllHalfYearRegex = "((das|im|in dem|dem)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.)\\s+(halbjahr|hälfte)(\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String PrefixDayRegex = "((?<EarlyPrefix>früh)|(?<MidPrefix>mitten|in der mitte)|(?<LatePrefix>spät(er)?))(\\s+am\\s+tag)?(\\s+des\\s+tages)?$";

    public static final String CenturySuffixRegex = "(^jahrhundert)\\b";

    public static final String ReferencePrefixRegex = "((gleich(e|en))|(selb(e|en)))\\b";

    public static final String SeasonRegex = "\\b(?<season>({RelativeRegex}\\s+)?(?<seas>frühling|sommer|herbst|winter)((\\s+(von|des jahres)?|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+jahr(e(s)?)?))?)\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WhichWeekRegex = "\\b(week)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])\\b";

    public static final String WeekOfRegex = "(die\\s+)?(woche)(\\s+des)";

    public static final String MonthOfRegex = "(monat)(\\s*)(des)";

    public static final String MonthRegex = "(?<month>apr((il)?\\b|\\.)|aug((ust)?\\b|\\.)|dez((ember)?\\b|\\.)|feb((ruar|ber)?\\b|\\.)|januar|j[äa]n((ner)?\\b|\\.)|jul((e?i|l)?\\b|l\\.)|jun([io]?\\b|\\.)|märz|mai|nov((ember)?\\b|\\.)|okt((ober)?\\b|\\.)|sept?((ember)?\\b|\\.))";

    public static final String DateYearRegex = "(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String OnRegex = "(?<=\\bam\\s+)({DayRegex}s?)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String RelaxedOnRegex = "(?<=\\b(am|an dem)\\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)([\\.]))";

    public static final String ThisRegex = "(((diese((n|m)|(\\s*woche))(\\s*am)?\\s+){WeekDayRegex})|diese(n|r)?\\s*(sommer|winter|frühling|herbst))"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String LastDateRegex = "({PreviousPrefixRegex}(\\s*(woche|monat|jahr)?(\\s*(am|im))?)?\\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\\s+)?{WeekDayRegex}(\\s+{PreviousPrefixRegex}\\s*woche))"
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String NextDateRegex = "({NextPrefixRegex}(\\s*(woche|monat|jahr)?(\\s*(am|im))?)?\\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\\s+)?{WeekDayRegex}(\\s+{NextPrefixRegex}\\s*woche))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String SpecialDayRegex = "\\b(vorgestern|übermorgen|((der\\s+)?{RelativeRegex}\\s+(tag(s|es)?|(?<!\\bam\\s+)morgen))|\\bgestern\\b|\\bmorgen\\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?))"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String SpecialDayWithNumRegex = "\\b((?<number>{WrittenNumRegex})\\s+tage?\\s+(von|nach|ab)\\s+(?<day>\\bgestern\\b|\\bmorgen\\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?)))\\b"
            .replace("{WrittenNumRegex}", WrittenNumRegex);

    public static final String RelativeDayRegex = "\\b((((de[rmns])\\s+)?{RelativeRegex}\\s+tag(e(s)?)?))"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String SetWeekDayRegex = "\\b(?<prefix>(an|immer)\\s+)?(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend)(s|en)\\b";

    public static final String WeekDayOfMonthRegex = "\\b(?<wom>((an( dem)?|de[rs]|am)\\s+)?(?<cardinal>erste[rns]?|1\\.|zweite[rns]?|2\\.|dritte[rns]?|3\\.|vierte[rns]?|4\\.|fünfte[rns]?|5\\.|letzte[rmns]?)\\s+{WeekDayRegex}\\s+{MonthSuffixRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String RelativeWeekDayRegex = "\\b({WrittenNumRegex}\\s+{WeekDayRegex}e\\s+(von\\s+jetzt|später))\\b"
            .replace("{WrittenNumRegex}", WrittenNumRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String SpecialDate = "(?=\\b(an( dem)?|am)\\s+){DayRegex}\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String DateExtractor1 = "\\b(({WeekDayRegex})(\\s+|\\s*,\\s*))?({DayRegex}\\s*[/\\\\.,\\- ]\\s*{MonthRegex}(\\s*[/\\\\.,\\- ]\\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\.,\\- ]\\s*{DayRegex}\\s*[/\\\\.,\\- ]\\s*{MonthRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String DateExtractor2 = "\\b({MonthRegex}\\s*[/\\\\.,\\- ]\\s*{DayRegex}(?!\\s*\\-\\s*\\d{2}\\b)(\\s*[/\\\\.,\\- ]\\s*{DateYearRegex})?)\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor3 = "\\b({DayRegex}{MonthRegex})"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String DateExtractor4 = "\\b({DayRegex}\\s*{MonthNumRegex}\\s*{DateYearRegex})\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor5 = "\\b(({WeekDayRegex})(\\s+|\\s*,\\s*))?({DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex})\\b(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor6 = "^[.]"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateExtractor7 = "({DayRegex}\\s*[\\.]\\s*{MonthNumRegex}[\\.]){BaseDateTime.CheckDecimalRegex}"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor8 = "(?<=\\b(am)\\s+){DayRegex}[/\\\\\\.]{MonthNumRegex}([/\\\\\\.]{DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor9 = "\\b({DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*){DateYearRegex})?){BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor10 = "^[.]"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String DateExtractor11 = "\\b(({WeekDayRegex})(\\s+|\\s*,\\s*)|(?<=\\bam\\s+))({DayRegex}\\.|{WrittenDayNumRegex})\\s*[/\\\\.\\- ]\\s*({MonthNumRegex}\\.|{WrittenMonthNumRegex})(\\s*[/\\\\.\\- ]\\s*{DateYearRegex})?"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{WrittenMonthNumRegex}", WrittenMonthNumRegex)
            .replace("{WrittenDayNumRegex}", WrittenDayNumRegex);

    public static final String DateExtractorA = "({DateYearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})(?!\\s*[/\\\\\\-\\.:]\\s*\\d+)"
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String OfMonth = "^(\\s*des\\s*|\\s*)?{MonthRegex}"
            .replace("{MonthRegex}", MonthRegex);

    public static final String MonthEnd = "{MonthRegex}\\s*(de[rmn])?\\s*$"
            .replace("{MonthRegex}", MonthRegex);

    public static final String WeekDayEnd = "{WeekDayRegex}\\s*,?\\s*$"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayStart = "^\\s+(am\\s+)?{WeekDayRegex}\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String RangeUnitRegex = "(?<unit>jahren?|jahr|monaten?|monat|wochen?|tagen?|tag)";

    public static final String HourNumRegex = "\\b(?<hournum>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|'null'|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)\\b";

    public static final String MinuteNumRegex = "(?<minnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)";

    public static final String DeltaMinuteNumRegex = "(?<deltaminnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)";

    public static final String PmRegex = "\\b((am|gegen|in der)\\s+)?(?<pm>(((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?|\\bmittags?|((in der )?nachts?)))";

    public static final String PmRegexFull = "\\b((am|gegen|in der)\\s+)?(?<pm>(((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?|\\bmittags?|((in der )?nachts?)))";

    public static final String AmRegex = "(?<am>(((früh|spät)\\s*)?morgens|((am|gegen)\\s+)?(früh|vormittags?)|(am|gegen)\\s+morgen))";

    public static final String LunchRegex = "\\b(mittag(essen|s)?)\\b";

    public static final String NightRegex = "\\b(mitternacht|(nachts?|primetime|abends?))\\b";

    public static final String AmPmPrefixRegex = "\\b((((um|gegen)\\s*)?(?<suffix>(((?<am>am morgen)|((früh|spät)\\s*)?morgens|früh|(vor|nach)mittags?)|(?<pm>((früh|spät)\\s*)?(nachmittags?|abends?)|mitternachts?))|(in der\\s*)?(?<pm>nachts?)))\\s*(um|gegen|von)\\s*)";

    public static final String CommonDatePrefixRegex = "^[\\.]";

    public static final String LessThanOneHour = "\\b(?<lth>(ein(er?)?\\s+)?((drei)?viertel|halb(en?)?)(\\s*stunden?)?)|{BaseDateTime.DeltaMinuteRegex}(\\s+(min(uten?)?))|{DeltaMinuteNumRegex}(\\s+(min(uten?)?))"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{DeltaMinuteNumRegex}", DeltaMinuteNumRegex);

    public static final String WrittenTimeRegex = "(um\\s*)?(?<writtentime>{HourNumRegex}(\\s*{OclockRegex}\\s*)({MinuteNumRegex}|{MinuteNumRegex}und(?<tens>zwanzig|dreißig|vierzig|fünfzig)))"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String TimePrefix = "(?<prefix>({LessThanOneHour})(\\s*(vor(\\W)?|nach(\\W)?))?)"
            .replace("{LessThanOneHour}", LessThanOneHour);

    public static final String TimeSuffix = "(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})"
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String TimeSuffixFull = "(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex}|\\b(?<pm>nachmittag(s)?|nacht(s)?|abend(s)?))"
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String BasicTime = "(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(:|\\s+uhr(\\s+und)?\\s+){BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|\\b{BaseDateTime.HourRegex}(?![%\\d]))"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex);

    public static final String MidnightRegex = "(?<midnight>mitte(r|n in der )nachts?)";

    public static final String MidmorningRegex = "(?<midmorning>mitten am vormittag)";

    public static final String MidafternoonRegex = "(?<midafternoon>mitten am nachmittag)";

    public static final String MiddayRegex = "((?<midday>(am\\s+)?mittag(s(zeit)?)?)|(?<midday>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)(mittags?)))";

    public static final String MidTimeRegex = "(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))"
            .replace("{MidnightRegex}", MidnightRegex)
            .replace("{MidmorningRegex}", MidmorningRegex)
            .replace("{MidafternoonRegex}", MidafternoonRegex)
            .replace("{MiddayRegex}", MiddayRegex);

    public static final String AtRegex = "(((?<=\\b(um|gegen)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?![%\\d])|{MidTimeRegex}))|{MidTimeRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String IshRegex = "\\b(noonish)\\b"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimeUnitRegex = "(?<unit>(stunde|minute|sekunde)(?<plural>n)?|std?|min|sek|h|s)\\b";

    public static final String RestrictedTimeUnitRegex = "(?<unit>stunde|minute)\\b";

    public static final String FivesRegex = "(?<tens>(fünfzehn|(fünfund)?(zwanzig?|dreißig|vierzig|fünfzig)|zehn|fünf))\\b";

    public static final String HourRegex = "\\b{BaseDateTime.HourRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String PeriodHourNumRegex = "(?<hour>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|'null'|eins?|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf)\\b";

    public static final String ConnectNumRegex = "{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex1 = "({TimePrefix}\\s+)?({WrittenTimeRegex}(\\s*{DescRegex})?|({HourNumRegex}|{BaseDateTime.HourRegex}\\b)\\s*{DescRegex})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex2 = "({TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?(:|\\s+uhr(\\s+und)?\\s+)(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?((\\s*{DescRegex})|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex3 = "({TimePrefix}\\s+)?{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex4 = "({TimePrefix}\\s*{BasicTime}(\\s*{DescRegex})?(\\s*{TimeSuffix})?)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex5 = "({TimePrefix}\\s*{BasicTime}((\\s*{DescRegex})))"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex6 = "({BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix})"
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex7 = "(({AmPmPrefixRegex})({BasicTime})((\\s*{DescRegex}))?)"
            .replace("{TimeSuffixFull}", TimeSuffixFull)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{AmPmPrefixRegex}", AmPmPrefixRegex);

    public static final String TimeRegex8 = "({TimeSuffixFull}(\\s*(um|gegen)\\s*){BasicTime}((\\s*{DescRegex})?))"
            .replace("{TimeSuffixFull}", TimeSuffixFull)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex9 = "({PeriodHourNumRegex}\\s+{FivesRegex}((\\s*{DescRegex})))"
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{FivesRegex}", FivesRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex10 = "({TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String PureNumFromTo = "(?<preDesc>({PmRegex}|{AmRegex})\\s+)?((von)\\s+)?({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex})){0,2}"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String PureNumBetweenAnd = "\\b(?<preDesc>({PmRegex}|{AmRegex})\\s+)?(zwischen\\s+)({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\\s*{RangeConnectorRegex}\\s*({HourRegex}|{PeriodHourNumRegex})\\s*(?<rightDesc>\\s*{PmRegex}|{AmRegex}|{DescRegex}){0,2}\\b"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String SpecificTimeFromTo = "((?<preDesc>({PmRegex}|{AmRegex})\\s+)?(von)\\s+)?(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\\s*{TillRegex}\\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))"
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{TillRegex}", TillRegex)
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String SpecificTimeBetweenAnd = "(?<preDesc>({PmRegex}|{AmRegex})\\s+)?(zwischen\\s+)(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\\s*{RangeConnectorRegex}\\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))"
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String PrepositionRegex = "(?<prep>^(um|am|in|zur)(\\s+(de[rmn]))?$)";

    public static final String TimeOfDayRegex = "(?<timeOfDay>((((?<early>(früh(\\s+am|er)?|am frühen))|(?<late>(spät(\\s+am|er)?|am späten)))(\\s*|-))?((am\\s+)?morgens?(?! (früh|vor|nach|abend|(nacht|primetime)|morgen))|(vor|nach)mittags?|(?<!sonn)abends?|früh|(nachts?|primetime))))\\b";

    public static final String SpecificTimeOfDayRegex = "\\b((({StrictRelativeRegex}|heute)\\s+{TimeOfDayRegex}))\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String TimeFollowedUnit = "^\\s*{TimeUnitRegex}$"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String TimeNumberCombinedWithUnit = "(?<num>\\d+(\\,\\d*)?){TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String NowRegex = "\\b(?<now>(genau\\s+)?jetzt|momentan|im moment|derzeit|in diesem moment|aktuelle?|gerade|so früh wie möglich|frühestmöglich|neulich|vorher)\\b";

    public static final String SuffixRegex = "^\\s*((am|zur|in der)\\s+)?(am morgen|morgens|frühe?|(vor|nach)mittags?|abends?|(nacht|primetime)s?)\\b";

    public static final String DateTimeTimeOfDayRegex = "\\b(?<timeOfDay>(vor|nach)?mittags?|abends?|(nachts?|primetime|morgen))\\b";

    public static final String DateTimeSpecificTimeOfDayRegex = "\\b((({RelativeRegex}|heute)\\s+{DateTimeTimeOfDayRegex}))\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String TimeOfTodayAfterRegex = "^\\s*(,\\s*)?((zur|am|in der)\\s+)?{DateTimeSpecificTimeOfDayRegex}"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String TimeOfTodayBeforeRegex = "{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(um|gegen|in|on))?\\s*$"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayAfterRegex = "({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?(am\\s+)?{DateTimeSpecificTimeOfDayRegex}"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayBeforeRegex = "{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+um)?\\s*({HourNumRegex}|{BaseDateTime.HourRegex})"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String SpecificEndOfRegex = "((das|am|an( dem)?)\\s+)?\\bende(\\s+(de[mnsr])?)\\s*$";

    public static final String UnspecificEndOfRegex = "^[.]";

    public static final String UnspecificEndOfRangeRegex = "^[.]";

    public static final String PeriodTimeOfDayRegex = "(((?<early>(früh( am|er)?|am frühen)(\\s*|-))|(?<late>(spät( am|er)|am späten)(\\s*|-)))?(?<timeOfDay>morgens?|früh|(vor|nach)mittags?|(nachts?|primetime)|abends?))";

    public static final String PeriodSpecificTimeOfDayRegex = "(({StrictRelativeRegex}\\s+{PeriodTimeOfDayRegex})|heute)"
            .replace("{PeriodTimeOfDayRegex}", PeriodTimeOfDayRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String PeriodTimeOfDayWithDateRegex = "((((am|zur|von|in der)\\s+)?{TimeOfDayRegex}(\\s+am)?))|(?<timeOfDay>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)((vor|nach)?mittags?|abends?|(nachts?|primetime)|morgens?))\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String LessThanRegex = "\\b(weniger\\s+als)\\b";

    public static final String MoreThanRegex = "\\b(mehr\\s+als)\\b";

    public static final String DurationUnitRegex = "(?<unit>jahr(e(n|s)?)?|monat(en?|s)?|wochen?|tag(e(n|s)?)?|tg|stunden?|std?|h|min(uten?)?|sek(unden?)?)\\b";

    public static final String SpecialNumberUnitRegex = "\\b(?<specialNum>beiden)\\b";

    public static final String SuffixAndRegex = "(?<suffix>\\s*und\\s+(eine\\s+)?(?<suffix_num>halbe|viertel))";

    public static final String PeriodicRegex = "(?<periodic>(all)?täglich(e(r|n|s)?)?|(all)?monatlich(e[rns]?)?|(all)?wöchentlich(e[rns]?)?|(all)?jährlich(e[rns]?)?)\\b";

    public static final String EachUnitRegex = "(?<each>(jede(s|r|n|m)?|alle)(?<other>\\s+andere(n)?)?\\s*{DurationUnitRegex})"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String EachPrefixRegex = "\\b(?<each>(jede(r|n|s|m)?|alle|immer)\\s*$)";

    public static final String SetEachRegex = "\\b(?<each>(jede(r|n|s|m)?|alle|immer)\\s*)";

    public static final String SetLastRegex = "(?<last>(über)?nächste[rmns]?|kommende[rns]?|diese[rnms]?|letzte[rmns]?|vorige[rns]?|vorherige[rns]?|jetzige[rns]?|derzeitige[rns]?)\\b";

    public static final String EachDayRegex = "\\s*(jeden)\\s*tag\\s*\\b";

    public static final String BeforeEachDayRegex = "(jeden)\\s*tag\\s*";

    public static final String DurationFollowedUnit = "(^\\s*{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex})"
            .replace("{SuffixAndRegex}", SuffixAndRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String NumberCombinedWithDurationUnit = "\\b(?<num>\\d+(\\.\\d*)?)(-)?{DurationUnitRegex}"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String AnUnitRegex = "\\b(((((ein(e[rsnm]?)?)(?<half>\\s+halb(e[srn]?))?))\\s+{DurationUnitRegex})|((ein(e[rsnm]?)?)\\s+((?<quarter>viertel)|(?<threequarter>dreiviertel))(?<unit>stunde)))"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String DuringRegex = "\\b(während|im\\slaufe)\\s+(de[sr])\\s+(?<unit>jahres|monats|woche|tages)\\b";

    public static final String AllRegex = "\\b(?<all>ganz(e[nsr]?)\\s+(?<unit>jahr|monat|woche|tag))\\b";

    public static final String HalfRegex = "(((ein(e[nrs]?)?)\\s*)|\\b)(?<half>halb(e[nrs]?)?\\s+(?<unit>jahr(e[rs]?)?|monat[se]?|woch(en?)?|tag(e[nrs]?)?|stund(en?)?))\\b";

    public static final String ConjunctionRegex = "\\b((und(\\s+für)?)|mit|für)\\b";

    public static final String HolidayRegex1 = "\\b((dieses jahr)\\s*)?(?<holiday>reformations(tag|fest)|gedenktag der reformation|martinstag|st. martin|sankt martin|martinsfest|martini|nikolaustag|dreikönigstag|dreikönigsfest|walpurgisnacht|nationalfeiertag|mariä empfängnis|weihnachten|weihnachts(feier)?tag|erste(r|n)? weihnachtstag|1\\. weihnachtstag|erste(r|n)? weihnachtsfeiertag|1\\. weihnachtsfeiertag|zweite(r|n)? weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\\. weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\\. weihnachtsfeiertag|stefanitag|stafanstag|berchtoldstag|bechtelistag|bächtelistag|berchtelistag|bärzelistag|josefstag|joseftag|josefitag|pfingsten|ostermontag|ostersonntag|bundesfeiertag|bundesfeier|mariä himmelfahrt|tag der deutschen einheit|ostern|vatertag|muttertag|erntedank(fest)?|thanksgiving|martin luther king day|martin luther king jr day|washington's birthday|washington birthday|canberraday|tag der arbeit|columbus day|memorial day|yuandan|mao's birthday|teachersday|teacher day|single day|tag der jugend|kindertag|(Internationaler\\s+)?frauentag|treeplanting day|tag des baumes|girlsday|white lover day|loverday|weihnachten|weihnachtstag|xmas|neujahr|neujahrstag|neujahr|neujahrstag|neujahr|inauguration day|murmeltiertag|sommeranfang|winteranfang|frühlingsanfang|herbstanfang|valentinstag|st patrick day|erster april|april scherz|georgstag|mayday|maitag|maifeiertag|geburt johannes des täufers|us unabhängigkeitstag|unabhängigkeitstag|sturm auf die bastille|halloween|guy fawkes day|guy fawkes night|veterans day|heiligabend|silvester|pi-tag|pitag|pi (tag|day))(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String HolidayRegex2 = "\\b((dieses jahr)\\s*)?(?<holiday>martin luther king|martin luther king jr|allerheiligen|tree planting day|white lover|st patrick|st george|independence|us independence|allerseelen|guy fawkes|silvester|weiberfastnacht|karneval|aschermittwoch|palm(en)?sonntag|karsamstag|fastnachtssamstag|fastnachtssonntag|heilige drei könige|barbaratag|reformationstag|weltkindertag|augsburger friedensfest|johannistag|peter und paul|karfreitag|christi himmelfahrt|pfingstsonntag|pfingstmontag|fronleichnam|rosenmontag|fastnacht|gründonnerstag|himmelfahrt|volkstrauertag|buß und bettag|buß- und bettag|buss- und bettag|buss und bettag|toten(sonntag|fest)|ewigkeitssonntag|erste(r|n)? advent|1\\. advent|zweite(r|n)? advent|2\\. advent|dritte(r|n)? advent|3\\. advent|vierte(r|n)? advent|4\\. advent|schweizer buss- und bettag|schweizer buss und bettag|schweizer buß und bettag|schweizer buß- und bettag)(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String HolidayRegex3 = "((dieses jahr)\\s*)?(?<holiday>(canberra|columbus|thanks\\s*giving|groundhog|bastille|halloween|veterans|memorial|spring|lantern|qingming|dragon boat)\\s+(day))(\\s+((diesen)\\s+)?(im jahr {YearRegex}|{YearRegex}|(im\\s+)?{RelativeRegex}\\s+jahr(es)?))?"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String DateTokenPrefix = "am ";

    public static final String TimeTokenPrefix = "um ";

    public static final String TokenBeforeDate = "am ";

    public static final String TokenBeforeTime = "um ";

    public static final String FromRegex = "\\b(vo[mn](\\s+de[rmsn])?)$";

    public static final String BetweenTokenRegex = "\\b(zwischen(\\s+de[rmsn])?)$";

    public static final String AMTimeRegex = "(?<am>morgens|vormittags?|früh)";

    public static final String PMTimeRegex = "\\b(?<pm>nachmittags?|abends?|nachts?)";

    public static final String BeforeRegex = "(vorher(ige(s|n|r)?)?|bevor|vor(\\W)?|vorige(s|n|r)?|bis)(\\s+de[rmsn]\\b)?";

    public static final String AfterRegex = "(nach(\\W)?)(\\s+de[rmsn]\\b)?";

    public static final String SinceRegex = "\\b(seit|ab)(\\s+de[rmsn])?\\b";

    public static final String AgoRegex = "\\b(danach)\\b";

    public static final String AroundRegex = "(\\b(ca\\.?|gegen|circa)\\s*\\b)";

    public static final String LaterRegex = "\\b(später|von jetzt|(ab|nach) (?<day>morgen|heute))\\b";

    public static final String BeforeAfterRegex = "^[.]";

    public static final String InConnectorRegex = "\\b(in)\\b";

    public static final String SinceYearSuffixRegex = "^[.]";

    public static final String WithinNextPrefixRegex = "\\b(innerhalb|während(\\s+der|de(s|m))?(\\s+(?<next>{NextPrefixRegex}))?)\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex);

    public static final String TodayNowRegex = "\\b(heute|jetzt)\\b";

    public static final String MorningStartEndRegex = "(^(früh|vormittag(s)?)|(morgens?|früh|vormittags?)$)";

    public static final String AfternoonStartEndRegex = "(^(nachmittags?)|(nachmittags?)$)";

    public static final String EveningStartEndRegex = "(^(abends?)|(abends?)$)";

    public static final String NightStartEndRegex = "(^(über nacht|in der nacht|nachts?|nächtens|primetime))|((über nacht|nachts?|nächtens|primetime)$)";

    public static final String InexactNumberRegex = "\\b((ein )?paar|einige( wenige)?|wenige)\\b";

    public static final String InexactNumberUnitRegex = "({InexactNumberRegex})\\s+({DurationUnitRegex})"
            .replace("{InexactNumberRegex}", InexactNumberRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String RelativeTimeUnitRegex = "((({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s*({TimeUnitRegex})))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{TimeUnitRegex}", TimeUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String RelativeDurationUnitRegex = "(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s*)({DurationUnitRegex})))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String ReferenceDatePeriodRegex = "\\b{ReferencePrefixRegex}\\s+(?<duration>tag|monat|jahr(zehnt)?|wochen(ende|tag))\\b"
            .replace("{ReferencePrefixRegex}", ReferencePrefixRegex);

    public static final String ConnectorRegex = "^(-|,|für|t|gegen)$";

    public static final String FromToRegex = "\\b(vom|von).+(bis(\\s*zum)?)\\b.+";

    public static final String SingleAmbiguousMonthRegex = "^(the\\s+)?(may|march)$";

    public static final String UnspecificDatePeriodRegex = "^(woche(nende)?|monat|jahr)$";

    public static final String PrepositionSuffixRegex = "\\b(am|in|um|gegen|vo[mn]|zu(m|r))$";

    public static final String FlexibleDayRegex = "(?<DayOfMonth>([A-Za-z]+\\s)?[A-Za-z\\d]+)";

    public static final String ForTheRegex = "\\b(für\\s+den\\s+{FlexibleDayRegex}(?<end>\\s*(,|\\.(?!(\\d|\\s?{WrittenMonthRegex}))|!|\\?|$)))"
            .replace("{FlexibleDayRegex}", FlexibleDayRegex)
            .replace("{WrittenMonthRegex}", WrittenMonthRegex);

    public static final String WeekDayAndDayOfMonthRegex = "\\b{WeekDayRegex}(\\s*,)?\\s+((de(r|n))\\s+{FlexibleDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayRegex = "\\b{WeekDayRegex}\\s+(?!de[nr]){DayRegex}(?!([-:]|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String RestOfDateRegex = "\\brest\\s+((de[rs]|dieser)\\s+)((aktuellen|jetzigen)\\s+)?(?<duration>woche|monats|jahres)\\b";

    public static final String RestOfDateTimeRegex = "\\brest\\s+((des|diesen)\\s+)((aktuellen|heutigen)\\s+)?(?<unit>tages)\\b";

    public static final String MealTimeRegex = "\\b((zu(m|r))\\s+)?(?<mealTime>(essenszeit|mittagessen|mittag))\\b";

    public static final String AmbiguousRangeModifierPrefix = "^[.]";

    public static final String NumberEndingPattern = "^(\\s+(?<meeting>meeting|termin|telefonkonferenz|conference|skype call|call)\\s+to\\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\\.)?$|(\\.,|,|!|\\?)))"
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{HourRegex}", HourRegex);

    public static final String OneOnOneRegex = "\\b(1\\s*:\\s*1)|(one (on )?one|one\\s*-\\s*one|one\\s*:\\s*one)\\b";

    public static final String LaterEarlyPeriodRegex = "\\b(((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?))\\s+(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))\\s+((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?)))\\b"
            .replace("{OneWordPeriodRegex}", OneWordPeriodRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String WeekWithWeekDayRangeRegex = "\\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|diese(r|n|m))\\s+woche)((\\s+zwischen\\s+{WeekDayRegex}\\s+und\\s+{WeekDayRegex})|(\\s+vo(n|m)\\s+{WeekDayRegex}\\s+(bis\\s+)?zum\\s+{WeekDayRegex})))\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String GeneralEndingRegex = "\\s*((\\.,)|\\.|,|!|\\?)?\\s*";

    public static final String MiddlePauseRegex = "\\s*(,)\\s*";

    public static final String DurationConnectorRegex = "^\\s*(?<connector>\\s+|und|für|,)\\s*$";

    public static final String PrefixArticleRegex = "\\b(der|dem|des)?\\s+";

    public static final String OrRegex = "\\s*((\\b|,\\s*)(oder|und)\\b|,)\\s*";

    public static final String YearPlusNumberRegex = "\\b(jahr\\s+((?<year>(\\d{2,4}))|{FullTextYearRegex}))\\b"
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String NumberAsTimeRegex = "\\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimeBeforeAfterRegex = "\\b(((?<=\\b(vor|nach)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String DateNumberConnectorRegex = "\\s*(?<connector>am)\\s*";

    public static final String DecadeRegex = "(?<decade>zwanziger|dreißiger|vierziger|fünfziger|sechziger|siebziger|achtziger|neunziger|zweitausender)(n)?";

    public static final String DecadeWithCenturyRegex = "(die\\s+)?(((?<century>\\d|1\\d|2\\d)?(')?(?<decade>\\d0)(')?s)|(({CenturyRegex}(\\s+|-)(und\\s+)?)?{DecadeRegex})|({CenturyRegex}(\\s+|-)(und\\s+)?(?<decade>zehner|hunderter)))"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{DecadeRegex}", DecadeRegex);

    public static final String RelativeDecadeRegex = "\\b((das|die\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?jahrzehnte?)\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String YearSuffix = "(,?\\s*({DateYearRegex}|{FullTextYearRegex}))"
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String SuffixAfterRegex = "\\b(o\\s+(nach|in der Vergangenheit))\\b";

    public static final String YearPeriodRegex = "((((von|während|zwischen)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((zwischen)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String FutureSuffixRegex = "\\b(in\\s+der\\s+)?(zukunft|zukünftig)\\b";

    public static final String PastSuffixRegex = "^\\b$";

    public static final String ModPrefixRegex = "\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AroundRegex}", AroundRegex)
            .replace("{BeforeRegex}", BeforeRegex)
            .replace("{AfterRegex}", AfterRegex)
            .replace("{SinceRegex}", SinceRegex);

    public static final String ModSuffixRegex = "\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b"
            .replace("{AgoRegex}", AgoRegex)
            .replace("{LaterRegex}", LaterRegex)
            .replace("{BeforeAfterRegex}", BeforeAfterRegex)
            .replace("{FutureSuffixRegex}", FutureSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final String ComplexDatePeriodRegex = "(((von|während|in)\\s+)?(?<start>.+)\\s*({TillRegex})\\s*(?<end>.+)|((zwischen)\\s+)(?<start>.+)\\s*({RangeConnectorRegex})\\s*(?<end>.+))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final ImmutableMap<String, String> UnitMap = ImmutableMap.<String, String>builder()
        .put("jahren", "Y")
        .put("jahres", "Y")
        .put("jahre", "Y")
        .put("jahr", "Y")
        .put("monaten", "MON")
        .put("monate", "MON")
        .put("monat", "MON")
        .put("monats", "MON")
        .put("wochen", "W")
        .put("woche", "W")
        .put("tagen", "D")
        .put("tages", "D")
        .put("tage", "D")
        .put("tag", "D")
        .put("tg", "D")
        .put("stunden", "H")
        .put("stunde", "H")
        .put("h", "H")
        .put("minuten", "M")
        .put("minute", "M")
        .put("min", "M")
        .put("sekunden", "S")
        .put("sekunde", "S")
        .put("sek", "S")
        .put("H", "H")
        .build();

    public static final ImmutableMap<String, Long> UnitValueMap = ImmutableMap.<String, Long>builder()
        .put("jahren", 31536000L)
        .put("jahre", 31536000L)
        .put("jahr", 31536000L)
        .put("monaten", 2592000L)
        .put("monate", 2592000L)
        .put("monat", 2592000L)
        .put("wochen", 604800L)
        .put("woche", 604800L)
        .put("tagen", 86400L)
        .put("tage", 86400L)
        .put("tag", 86400L)
        .put("tg", 86400L)
        .put("stunden", 3600L)
        .put("stunde", 3600L)
        .put("std", 3600L)
        .put("h", 3600L)
        .put("minuten", 60L)
        .put("minute", 60L)
        .put("min", 60L)
        .put("sekunden", 1L)
        .put("sekunde", 1L)
        .put("sek", 1L)
        .build();

    public static final ImmutableMap<String, String> SpecialYearPrefixesMap = ImmutableMap.<String, String>builder()
        .put("", "")
        .build();

    public static final ImmutableMap<String, String> SeasonMap = ImmutableMap.<String, String>builder()
        .put("spring", "SP")
        .put("summer", "SU")
        .put("fall", "FA")
        .put("autumn", "FA")
        .put("winter", "WI")
        .build();

    public static final ImmutableMap<String, Integer> SeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> CardinalMap = ImmutableMap.<String, Integer>builder()
        .put("erster", 1)
        .put("ersten", 1)
        .put("erstes", 1)
        .put("erste", 1)
        .put("1", 1)
        .put("zweiter", 2)
        .put("zweiten", 2)
        .put("zweites", 2)
        .put("zweite", 2)
        .put("zwoter", 2)
        .put("2", 2)
        .put("dritter", 3)
        .put("dritten", 3)
        .put("drittes", 3)
        .put("dritte", 3)
        .put("3", 3)
        .put("vierter", 4)
        .put("vierten", 4)
        .put("viertes", 4)
        .put("vierte", 4)
        .put("4", 4)
        .put("fünfter", 5)
        .put("fünften", 5)
        .put("fünftes", 5)
        .put("fünfte", 5)
        .put("5", 5)
        .build();

    public static final ImmutableMap<String, Integer> DayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("montag", 1)
        .put("dienstag", 2)
        .put("mittwoch", 3)
        .put("donnerstag", 4)
        .put("freitag", 5)
        .put("samstag", 6)
        .put("sonnabend", 6)
        .put("sonntag", 0)
        .put("mo.", 1)
        .put("di.", 2)
        .put("mi.", 3)
        .put("do.", 4)
        .put("fr.", 5)
        .put("sa.", 6)
        .put("so.", 0)
        .build();

    public static final ImmutableMap<String, Integer> MonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("januar", 1)
        .put("janner", 1)
        .put("jänner", 1)
        .put("februar", 2)
        .put("feber", 2)
        .put("märz", 3)
        .put("april", 4)
        .put("mai", 5)
        .put("juni", 6)
        .put("juno", 6)
        .put("juli", 7)
        .put("julei", 7)
        .put("august", 8)
        .put("september", 9)
        .put("oktober", 10)
        .put("november", 11)
        .put("dezember", 12)
        .put("jan", 1)
        .put("jän", 1)
        .put("feb", 2)
        .put("mar", 3)
        .put("apr", 4)
        .put("jun", 6)
        .put("jul", 7)
        .put("aug", 8)
        .put("sep", 9)
        .put("sept", 9)
        .put("okt", 10)
        .put("nov", 11)
        .put("dez", 12)
        .put("1.", 1)
        .put("2.", 2)
        .put("3.", 3)
        .put("4.", 4)
        .put("5.", 5)
        .put("6.", 6)
        .put("7.", 7)
        .put("8.", 8)
        .put("9.", 9)
        .put("10.", 10)
        .put("11.", 11)
        .put("12.", 12)
        .put("01.", 1)
        .put("02.", 2)
        .put("03.", 3)
        .put("04.", 4)
        .put("05.", 5)
        .put("06.", 6)
        .put("07.", 7)
        .put("08.", 8)
        .put("09.", 9)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .put("erst", 1)
        .put("zweit", 2)
        .put("dritt", 3)
        .put("viert", 4)
        .put("fünft", 5)
        .put("fuenft", 5)
        .put("sechst", 6)
        .put("siebt", 7)
        .put("acht", 8)
        .put("neunt", 9)
        .put("zehnt", 10)
        .put("elft", 11)
        .put("zwölft", 12)
        .put("zwoelft", 12)
        .build();

    public static final ImmutableMap<String, Integer> Numbers = ImmutableMap.<String, Integer>builder()
        .put("null", 0)
        .put("eins", 1)
        .put("ein", 1)
        .put("eine", 1)
        .put("zween", 2)
        .put("zwei", 2)
        .put("zwo", 2)
        .put("drei", 3)
        .put("vier", 4)
        .put("fünf", 5)
        .put("fuenf", 5)
        .put("sechs", 6)
        .put("sieben", 7)
        .put("acht", 8)
        .put("neun", 9)
        .put("zehn", 10)
        .put("elf", 11)
        .put("zwölf", 12)
        .put("dreizehn", 13)
        .put("vierzehn", 14)
        .put("fünfzehn", 15)
        .put("sechzehn", 16)
        .put("siebzehn", 17)
        .put("achtzehn", 18)
        .put("neunzehn", 19)
        .put("zwanzig", 20)
        .put("einundzwanzig", 21)
        .put("zweiundzwanzig", 22)
        .put("dreiundzwanzig", 23)
        .put("vierundzwanzig", 24)
        .put("fünfundzwanzig", 25)
        .put("sechsundzwanzig", 26)
        .put("siebenundzwanzig", 27)
        .put("achtundzwanzig", 28)
        .put("neunundzwanzig", 29)
        .put("dreißig", 30)
        .put("einunddreißig", 31)
        .put("zweiunddreißig", 32)
        .put("dreiunddreißig", 33)
        .put("vierunddreißig", 34)
        .put("fünfunddreißig", 35)
        .put("sechsunddreißig", 36)
        .put("siebenunddreißig", 37)
        .put("achtunddreißig", 38)
        .put("neununddreißig", 39)
        .put("vierzig", 40)
        .put("einundvierzig", 41)
        .put("zweiundvierzig", 42)
        .put("dreiundvierzig", 43)
        .put("vierundvierzig", 44)
        .put("fünfundvierzig", 45)
        .put("sechsundvierzig", 46)
        .put("siebenundvierzig", 47)
        .put("achtundvierzig", 48)
        .put("neunundvierzig", 49)
        .put("fünfzig", 50)
        .put("einundfünfzig", 51)
        .put("zweiundfünfzig", 52)
        .put("dreiundfünfzig", 53)
        .put("vierundfünfzig", 54)
        .put("fünfundfünfzig", 55)
        .put("sechsundfünfzig", 56)
        .put("siebenundfünfzig", 57)
        .put("achtundfünfzig", 58)
        .put("neunundfünfzig", 59)
        .put("sechzig", 60)
        .put("einundsechzig", 61)
        .put("zweiundsechzig", 62)
        .put("dreiundsechzig", 63)
        .put("vierundsechzig", 64)
        .put("fünfundsechzig", 65)
        .put("sechsundsechzig", 66)
        .put("siebenundsechzig", 67)
        .put("achtundsechzig", 68)
        .put("neunundsechzig", 69)
        .put("siebzig", 70)
        .put("einundsiebzig", 71)
        .put("zweiundsiebzig", 72)
        .put("dreiundsiebzig", 73)
        .put("vierundsiebzig", 74)
        .put("fünfundsiebzig", 75)
        .put("sechsundsiebzig", 76)
        .put("siebenundsiebzig", 77)
        .put("achtundsiebzig", 78)
        .put("neunundsiebzig", 79)
        .put("achtzig", 80)
        .put("einundachtzig", 81)
        .put("zweiundachtzig", 82)
        .put("dreiundachtzig", 83)
        .put("vierundachtzig", 84)
        .put("fünfundachtzig", 85)
        .put("sechsundachtzig", 86)
        .put("siebenundachtzig", 87)
        .put("achtundachtzig", 88)
        .put("neunundachtzig", 89)
        .put("neunzig", 90)
        .put("einundneunzig", 91)
        .put("zweiundneunzig", 92)
        .put("dreiundneunzig", 93)
        .put("vierundneunzig", 94)
        .put("fünfundneunzig", 95)
        .put("sechsundneunzig", 96)
        .put("siebenundneunzig", 97)
        .put("achtundneunzig", 98)
        .put("neunundneunzig", 99)
        .put("einhundert", 100)
        .build();

    public static final ImmutableMap<String, Integer> DayOfMonth = ImmutableMap.<String, Integer>builder()
        .put("1.", 1)
        .put("2.", 2)
        .put("3.", 3)
        .put("4.", 4)
        .put("5.", 5)
        .put("6.", 6)
        .put("7.", 7)
        .put("8.", 8)
        .put("9.", 9)
        .put("10.", 10)
        .put("11.", 11)
        .put("12.", 12)
        .put("13.", 13)
        .put("14.", 14)
        .put("15.", 15)
        .put("16.", 16)
        .put("17.", 17)
        .put("18.", 18)
        .put("19.", 19)
        .put("20.", 20)
        .put("21.", 21)
        .put("22.", 22)
        .put("23.", 23)
        .put("24.", 24)
        .put("25.", 25)
        .put("26.", 26)
        .put("27.", 27)
        .put("28.", 28)
        .put("29.", 29)
        .put("30.", 30)
        .put("31.", 31)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("13", 13)
        .put("14", 14)
        .put("15", 15)
        .put("16", 16)
        .put("17", 17)
        .put("18", 18)
        .put("19", 19)
        .put("20", 20)
        .put("21", 21)
        .put("22", 22)
        .put("23", 23)
        .put("24", 24)
        .put("25", 25)
        .put("26", 26)
        .put("27", 27)
        .put("28", 28)
        .put("29", 29)
        .put("30", 30)
        .put("31", 31)
        .put("erst", 1)
        .put("zweit", 2)
        .put("dritt", 3)
        .put("viert", 4)
        .put("fünft", 5)
        .put("fuenft", 5)
        .put("sechst", 6)
        .put("siebt", 7)
        .put("acht", 8)
        .put("neunt", 9)
        .put("zehnt", 10)
        .put("elft", 11)
        .put("zwölft", 12)
        .put("zwoelft", 12)
        .put("dreizehnt", 13)
        .put("vierzehnt", 14)
        .put("fünfzehnt", 15)
        .put("fuenfzehnt", 15)
        .put("sechzehnt", 16)
        .put("siebzehnt", 17)
        .put("achtzehnt", 18)
        .put("neunzehnt", 19)
        .put("zwanzigst", 20)
        .put("einundzwanzigst", 21)
        .put("zweiundzwanzigst", 22)
        .put("dreiundzwanzigst", 23)
        .put("vierundzwanzigst", 24)
        .put("fünfundzwanzigst", 25)
        .put("fuenfundzwanzigst", 25)
        .put("sechsundzwanzigst", 26)
        .put("siebenundzwanzigst", 27)
        .put("achtundzwanzigst", 28)
        .put("neunundzwanzigst", 29)
        .put("dreißigst", 30)
        .put("einunddreißigst", 31)
        .build();

    public static final ImmutableMap<String, Double> DoubleNumbers = ImmutableMap.<String, Double>builder()
        .put("halb", 0.5D)
        .put("viertel", 0.25D)
        .build();

    public static final ImmutableMap<String, String[]> HolidayNames = ImmutableMap.<String, String[]>builder()
        .put("reformationday", new String[]{"reformationstag", "reformationsfest", "gedenktagderreformation"})
        .put("stmartinsday", new String[]{"martinstag", "st.martin", "sanktmartin", "martinsfest", "martini"})
        .put("saintnicholasday", new String[]{"nikolaustag"})
        .put("biblicalmagiday", new String[]{"dreikönigstag", "dreikönigsfest"})
        .put("walpurgisnight", new String[]{"walpurgisnacht"})
        .put("austriannationalday", new String[]{"nationalfeiertag"})
        .put("immaculateconception", new String[]{"mariäempfängnis"})
        .put("firstchristmasday", new String[]{"weihnachten", "weihnachtstag", "weihnachtsfeiertag", "erstenweihnachtstag", "erstenweihnachtsfeiertag", "ersterweihnachtstag", "ersterweihnachtsfeiertag", "erstenweihnachtstag", "erstenweihnachtsfeiertag", "1.weihnachtstag", "1.weihnachtsfeiertag"})
        .put("secondchristmasday", new String[]{"zweiterweihnachtstag", "zweiterweihnachtsfeiertag", "zweiteweihnachtstag", "zweiteweihnachtsfeiertag", "zweitenweihnachtstag", "zweitenweihnachtsfeiertag", "2.weihnachtstag", "2.weihnachtsfeiertag", "stefanitag", "stafanstag"})
        .put("berchtoldsday", new String[]{"berchtoldstag", "bechtelistag", "bächtelistag", "berchtelistag", "bärzelistag"})
        .put("saintjosephsday", new String[]{"josefstag", "joseftag", "josefitag"})
        .put("easterday", new String[]{"ostern"})
        .put("eastermonday", new String[]{"ostermontag"})
        .put("eastersunday", new String[]{"ostersonntag"})
        .put("swissnationalday", new String[]{"bundesfeiertag", "bundesfeier"})
        .put("assumptionofmary", new String[]{"mariähimmelfahrt"})
        .put("germanunityday", new String[]{"tagderdeutscheneinheit"})
        .put("fathers", new String[]{"vatertag", "männertag"})
        .put("mothers", new String[]{"muttertag"})
        .put("thanksgiving", new String[]{"erntedankfest", "erntedank", "thanksgiving"})
        .put("martinlutherking", new String[]{"martinlutherkingday", "martinlutherkingjrday"})
        .put("washingtonsbirthday", new String[]{"washingtonsbirthday", "washingtonbirthday"})
        .put("canberra", new String[]{"canberraday"})
        .put("labour", new String[]{"tagderarbeit"})
        .put("columbus", new String[]{"columbusday"})
        .put("memorial", new String[]{"memorialday"})
        .put("yuandan", new String[]{"yuandan"})
        .put("maosbirthday", new String[]{"maosbirthday"})
        .put("teachersday", new String[]{"teachersday", "teacherday"})
        .put("singleday", new String[]{"singleday"})
        .put("allsaintsday", new String[]{"allerheiligen"})
        .put("youthday", new String[]{"tag der jugend"})
        .put("childrenday", new String[]{"kindertag", "weltkindertag"})
        .put("femaleday", new String[]{"frauentag"})
        .put("treeplantingday", new String[]{"treeplantingday"})
        .put("arborday", new String[]{"tag des baumes"})
        .put("girlsday", new String[]{"girlsday"})
        .put("whiteloverday", new String[]{"whiteloverday"})
        .put("loverday", new String[]{"loverday"})
        .put("xmas", new String[]{"xmas"})
        .put("newyear", new String[]{"neujahr"})
        .put("newyearday", new String[]{"neujahrstag", "neujahr"})
        .put("newyearsday", new String[]{"neujahrstag", "neujahr"})
        .put("inaugurationday", new String[]{"inaugurationday"})
        .put("groundhougday", new String[]{"murmeltiertag"})
        .put("valentinesday", new String[]{"valentinstag"})
        .put("stpatrickday", new String[]{"stpatrickday"})
        .put("aprilfools", new String[]{"erster april", "aprilscherz"})
        .put("stgeorgeday", new String[]{"georgstag"})
        .put("mayday", new String[]{"mayday", "maitag", "tagderarbeit", "maifeiertag"})
        .put("laborday", new String[]{"mayday", "maitag", "tagderarbeit", "maifeiertag"})
        .put("cincodemayoday", new String[]{"cincodemayo"})
        .put("baptisteday", new String[]{"geburtjohannesdestäufers"})
        .put("usindependenceday", new String[]{"usunabhängigkeitstag"})
        .put("independenceday", new String[]{"unabhängigkeitstag"})
        .put("bastilleday", new String[]{"sturmaufdiebastille"})
        .put("halloweenday", new String[]{"halloween"})
        .put("allhallowday", new String[]{"allerheiligen"})
        .put("allsoulsday", new String[]{"allerseelen"})
        .put("guyfawkesday", new String[]{"guyfawkesday", "guyfawkesnight"})
        .put("veteransday", new String[]{"veteransday"})
        .put("piday", new String[]{"piday", "pitag", "pi-tag"})
        .put("christmaseve", new String[]{"heiligabend"})
        .put("newyeareve", new String[]{"silvester"})
        .put("weiberfastnacht", new String[]{"weiberfastnacht"})
        .put("carnival", new String[]{"karneval"})
        .put("ashwednesday", new String[]{"aschermittwoch"})
        .put("palmsunday", new String[]{"palmensonntag", "palmsonntag"})
        .put("goodfriday", new String[]{"karfreitag"})
        .put("ascensionofchrist", new String[]{"christihimmelfahrt"})
        .put("whitesunday", new String[]{"pfingstsonntag", "pfingsten"})
        .put("whitemonday", new String[]{"pfingstmontag"})
        .put("corpuschristi", new String[]{"fronleichnam"})
        .put("rosenmontag", new String[]{"rosenmontag"})
        .put("fastnacht", new String[]{"fastnacht"})
        .put("holythursday", new String[]{"gründonnerstag", "himmelfahrt"})
        .put("memorialdaygermany", new String[]{"volkstrauertag"})
        .put("dayofrepentance", new String[]{"bußundbettag", "buß-undbettag", "bussundbettag"})
        .put("totensonntag", new String[]{"totensonntag", "totenfest", "ewigkeitssonntag"})
        .put("firstadvent", new String[]{"ersteadvent", "erstenadvent", "ersteradvent", "1.advent"})
        .put("secondadvent", new String[]{"zweiteadvent", "zweitenadvent", "zweiteradvent", "2.advent"})
        .put("thirdadvent", new String[]{"dritteadvent", "drittenadvent", "dritteradvent", "3.advent"})
        .put("fourthadvent", new String[]{"vierteadvent", "viertenadvent", "vierteradvent", "4.advent"})
        .put("chedayofrepentance", new String[]{"schweizerbußundbettag", "schweizerbuß-undbettag", "schweizerbussundbettag"})
        .put("beginningofsummer", new String[]{"sommeranfang"})
        .put("beginningofwinter", new String[]{"winteranfang"})
        .put("beginningofspring", new String[]{"frühlingsanfang"})
        .put("beginningoffall", new String[]{"herbstanfang"})
        .put("eastersaturday", new String[]{"karsamstag"})
        .put("fastnachtssamstag", new String[]{"fastnachtssamstag"})
        .put("fastnachtssonntag", new String[]{"fastnachtssonntag"})
        .put("heiligedreikönige", new String[]{"heiligedreikönige"})
        .put("barbaratag", new String[]{"barbaratag"})
        .put("augsburgerfriedensfest", new String[]{"augsburgerfriedensfest"})
        .put("johannistag", new String[]{"johannistag"})
        .put("peterundpaul", new String[]{"peterundpaul"})
        .build();

    public static final ImmutableMap<String, Integer> WrittenDecades = ImmutableMap.<String, Integer>builder()
        .put("hundert", 0)
        .put("zehn", 10)
        .put("zwanziger", 20)
        .put("dreißiger", 30)
        .put("vierziger", 40)
        .put("fünfziger", 50)
        .put("sechziger", 60)
        .put("siebziger", 70)
        .put("achtziger", 80)
        .put("neunziger", 90)
        .put("zwanzigern", 20)
        .put("dreißigern", 30)
        .put("vierzigern", 40)
        .put("fünfzigern", 50)
        .put("sechzigern", 60)
        .put("siebzigern", 70)
        .put("achtzigern", 80)
        .put("neunzigern", 90)
        .build();

    public static final ImmutableMap<String, Integer> SpecialDecadeCases = ImmutableMap.<String, Integer>builder()
        .put("zweitausender", 2000)
        .build();

    public static final String DefaultLanguageFallback = "DMY";

    public static final List<String> DurationDateRestrictions = Arrays.asList("today", "now");

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)")
        .put("\\b(morgen|nachmittag|abend|nacht|tag)\\b", "\\b(gut(en?)?\\s+(morgen|nachmittag|abend|nacht|tag))\\b")
        .put("^(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)$", "([$%£&!?@#])(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)|(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)([$%£&@#])")
        .put("^(mo|di|mi|do|fr|sa|so)$", "\\b(mo|di|mi|do|fr|sa|so)\\b")
        .put("^((früh|spät)(\\s+am|er)?\\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)$", "((?<!(frü|spä))[a-z0-9])((früh|spät)(\\s+am|er)?\\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)\\b")
        .build();

    public static final String AmbiguousTimePeriodRegex = "\\b((?<!{RelativeRegex}\\s+)morgen|früh(?!(\\s*morgens?)))\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final List<String> MorningTermList = Arrays.asList("morgen", "vormittag", "früh");

    public static final List<String> AfternoonTermList = Arrays.asList("nachmittag");

    public static final List<String> EveningTermList = Arrays.asList("abend");

    public static final List<String> DaytimeTermList = Arrays.asList("tag");

    public static final List<String> NightTermList = Arrays.asList("nacht", "nachts", "primetime");

    public static final List<String> SameDayTerms = Arrays.asList("heute", "heutige datum", "heutige tag", "aktuelles datum", "aktuelle datum", "aktueller tag", "aktuellen tag", "aktuelle tag", "dieser morgen", "diesem morgen", "diesen morgen", "aktuelle morgen", "aktuellen morgen", "jetzige morgen", "jetzigen morgen");

    public static final List<String> PlusOneDayTerms = Arrays.asList("morgen", "morgiger tag", "morgigen tag", "morgigen tages");

    public static final List<String> MinusOneDayTerms = Arrays.asList("gestern", "gestriger tag", "gestrigen tag", "gestrigen tages");

    public static final List<String> PlusTwoDayTerms = Arrays.asList("übermorgen");

    public static final List<String> MinusTwoDayTerms = Arrays.asList("vorgestern");

    public static final List<String> FutureTerms = Arrays.asList("dieser", "diesen", "dieses", "diese", "nächster", "nächstes", "nächsten", "nächstem", "nächste");

    public static final List<String> LastCardinalTerms = Arrays.asList("letzter", "letztes", "letzten", "letztem");

    public static final List<String> MonthTerms = Arrays.asList("monat", "monate", "monaten", "monats");

    public static final List<String> MonthToDateTerms = Arrays.asList("month to date");

    public static final List<String> WeekendTerms = Arrays.asList("wochenende", "wochenendes");

    public static final List<String> WeekTerms = Arrays.asList("woche");

    public static final List<String> YearTerms = Arrays.asList("jahr", "jahre", "jahren", "jahres");

    public static final List<String> YearToDateTerms = Arrays.asList("year to date");
}
