// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class FrenchDateTime {

    public static final String LangMarker = "Fre";

    public static final Boolean CheckBothBeforeAfter = false;

    public static final String TillRegex = "(?<till>\\b(au|et|(jusqu')?a|avant)\\b|(jusqu')?à|--|-|—|——)";

    public static final String RangeConnectorRegex = "(?<and>\\b(de\\s+la|au|(jusqu')?a|et(\\s*la)?)\\b|(jusqu')?à|--|-|—|——)";

    public static final String RelativeRegex = "(?<order>prochaine?|de|du|ce(tte)?|l[ae]|derni[eè]re|hier|pr[eé]c[eé]dente|au\\s+cours+(de|du\\s*))";

    public static final String StrictRelativeRegex = "(?<order>prochaine?|derni[eè]re|hier|pr[eé]c[eé]dente|au\\s+cours+(de|du\\s*))";

    public static final String NextSuffixRegex = "(?<order>prochain(es?)?|suivante)\\b";

    public static final String PastSuffixRegex = "(?<order>derni[eè]r(es?)?|pr[eé]c[eé]dente)\\b";

    public static final String ThisPrefixRegex = "(?<order>ce(tte)?|au\\s+cours+(du|de))\\b";

    public static final String RangePrefixRegex = "(du|depuis|des?|entre)";

    public static final String DayRegex = "(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(e(r)?)?)(?=\\b|t)";

    public static final String WrittenDayRegex = "(?<day>((vingt|trente)(\\s*-\\s*|\\s+)et(\\s*-\\s*|\\s+))?un|(vingt(\\s*-\\s*|\\s+))?(deux|trois|quatre|cinq|six|sept|huit|neuf)|dix|onze|douze|treize|quatorze|quinze|seize|dix-(sept|huit|neuf)|vingt|trente)";

    public static final String MonthNumRegex = "(?<month>1[0-2]|(0)?[1-9])\\b";

    public static final String SpecialDescRegex = "(p\\b)";

    public static final String AmDescRegex = "(h\\b|{BaseDateTime.BaseAmDescRegex})"
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex);

    public static final String PmDescRegex = "(h\\b|{BaseDateTime.BasePmDescRegex})"
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String AmPmDescRegex = "(h\\b|{BaseDateTime.BaseAmPmDescRegex})"
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex);

    public static final String DescRegex = "(?<desc>{AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{AmPmDescRegex}", AmPmDescRegex)
            .replace("{SpecialDescRegex}", SpecialDescRegex);

    public static final String TwoDigitYearRegex = "\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String WrittenOneToNineRegex = "(?:une?|deux|trois|quatre|cinq|six|sept|huit|neuf)";

    public static final String WrittenElevenToNineteenRegex = "(?:(seize|quinze|quatorze|treize|douze|onze)|dix\\W(neuf|huit|sept))";

    public static final String WrittenTensRegex = "(?:quatre\\Wvingt(s|\\Wdix)?|soixante(\\Wdix)?|dix|vingt|trente|quarante|cinquante|septante|octante|huitante|nonante)";

    public static final String WrittenCenturyFullYearRegex = "(?:(deux\\s+)?mille((\\s+{WrittenOneToNineRegex})?\\s+cents?)?)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String WrittenCenturyOrdinalYearRegex = "({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|dix)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex)
            .replace("{WrittenElevenToNineteenRegex}", WrittenElevenToNineteenRegex);

    public static final String CenturyRegex = "\\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\\s+cents?)?)\\b"
            .replace("{WrittenCenturyFullYearRegex}", WrittenCenturyFullYearRegex)
            .replace("{WrittenCenturyOrdinalYearRegex}", WrittenCenturyOrdinalYearRegex);

    public static final String LastTwoYearNumRegex = "(({WrittenTensRegex}(\\s+|-))?({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex})|{WrittenTensRegex})"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex)
            .replace("{WrittenElevenToNineteenRegex}", WrittenElevenToNineteenRegex)
            .replace("{WrittenTensRegex}", WrittenTensRegex);

    public static final String FullTextYearRegex = "\\b(?<fullyear>(?<firsttwoyearnum>{CenturyRegex})\\s+(?<lasttwoyearnum>{LastTwoYearNumRegex})\\b|\\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\\s+cents))\\b"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{WrittenCenturyFullYearRegex}", WrittenCenturyFullYearRegex)
            .replace("{WrittenCenturyOrdinalYearRegex}", WrittenCenturyOrdinalYearRegex)
            .replace("{LastTwoYearNumRegex}", LastTwoYearNumRegex);

    public static final String YearRegex = "({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String WeekDayRegex = "(?<weekday>dimanche|lundi|mardi|mercredi|jeudi|vendredi|samedi|lun(\\.)?|mar(\\.)?|mer(\\.)?|jeu(\\.)?|ven(\\.)?|sam(\\.)?|dim(\\.)?)";

    public static final String RelativeMonthRegex = "(?<relmonth>({ThisPrefixRegex}\\s+mois)|(mois\\s+{PastSuffixRegex})|(mois\\s+{NextSuffixRegex}))\\b"
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String WrittenMonthRegex = "(?<month>avril|avr(\\.)?|ao[uû]t|d[eé]cembre|d[eé]c(\\.)?|f[eé]vrier|f[eé]vr?(\\.)?|janvier|janv?(\\.)?|juillet|jui?[ln](\\.)?|mars?(\\.)?|mai|novembre|nov(\\.)?|octobre|oct(\\.)?|septembre|sept?(\\.)?(?!\\s+heures))";

    public static final String MonthSuffixRegex = "(?<msuf>(en\\s*|le\\s*|de\\s*|dans\\s*)?({RelativeMonthRegex}|{WrittenMonthRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{WrittenMonthRegex}", WrittenMonthRegex);

    public static final String DateUnitRegex = "(?<unit>an|mois|((l')?ann[eé]e|semaine|journ[eé]e|jour)(?<plural>s)?)\\b";

    public static final String SimpleCasesRegex = "\\b((d[ue])|entre\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontSimpleCasesRegex = "\\b((d[ue]|entre)\\s+)?{MonthSuffixRegex}\\s+((d[ue]|entre)\\s+)?({DayRegex})\\s*{TillRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String MonthFrontBetweenRegex = "\\b{MonthSuffixRegex}\\s+(entre|d[ue]\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String BetweenRegex = "\\b(entre\\s+)({DayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex);

    public static final String YearWordRegex = "\\b(?<year>l'ann[ée]e)\\b";

    public static final String MonthWithYear = "\\b({WrittenMonthRegex}(\\s*),?(\\s+de)?(\\s*)({YearRegex}|{TwoDigitYearRegex}|(?<order>cette)\\s*{YearWordRegex})|{YearWordRegex}\\s*({PastSuffixRegex}|{NextSuffixRegex}))"
            .replace("{WrittenMonthRegex}", WrittenMonthRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex)
            .replace("{YearWordRegex}", YearWordRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String OneWordPeriodRegex = "\\b(({RelativeRegex}\\s+)?{WrittenMonthRegex}|(la\\s+)?(weekend|(fin de )?semaine|week-end|mois|ans?|l'année)\\s+{StrictRelativeRegex}|{RelativeRegex}\\s+(weekend|(fin de )?semaine|week-end|mois|ans?|l'année)|weekend|week-end|mois|l'année|an)\\b"
            .replace("{WrittenMonthRegex}", WrittenMonthRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String MonthNumWithYear = "({YearRegex}(\\s*)[/\\-\\.](\\s*){MonthNumRegex})|({MonthNumRegex}(\\s*)[/\\-](\\s*){YearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String WeekOfMonthRegex = "(?<wom>(le\\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\\s+semaine(\\s+de)?\\s+{MonthSuffixRegex})"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String WeekOfYearRegex = "(?<woy>(le\\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\\s+semaine(\\s+de)?\\s+({YearRegex}|{RelativeRegex}\\s+ann[ée]e))"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String OfYearRegex = "\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String FirstLastRegex = "\\b(the\\s+)?((?<first>first)|(?<last>last))\\b";

    public static final String FollowedDateUnit = "^\\s*{DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String NumberCombinedWithDateUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String QuarterRegex = "(le\\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4)\\s+quart(\\s+de|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+l'ann[eé]e)"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String QuarterRegexYearFront = "({YearRegex}|l'année\\s+({PastSuffixRegex}|{NextSuffixRegex})|{RelativeRegex}\\s+ann[eé]e)\\s+(le\\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4)\\s+quarts"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String AllHalfYearRegex = "^\\b$";

    public static final String PrefixDayRegex = "\\b((?<EarlyPrefix>t[ôo]t\\sdans)|(?<MidPrefix>au\\smilieu\\sde)|(?<LatePrefix>tard\\sdans))(\\s+la\\s+journ[ée]e)?$";

    public static final String CenturySuffixRegex = "^\\b$";

    public static final String SeasonRegex = "\\b((<seas>printemps|été|automne|hiver)+\\s*({NextSuffixRegex}|{PastSuffixRegex}))|(?<season>({RelativeRegex}\\s+)?(?<seas>printemps|[ée]t[ée]|automne|hiver)((\\s+de|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+l'ann[eé]e))?)\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final String WhichWeekRegex = "\\b(semaine)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])\\b";

    public static final String WeekOfRegex = "(semaine)(\\s*)(de)";

    public static final String MonthOfRegex = "(mois)(\\s*)(de)";

    public static final String MonthRegex = "(?<month>avril|avr(\\.)?|ao[uû]t|d[eé]cembre|d[eé]c(\\.)?|f[eé]vrier|f[eé]vr?(\\.)?|janvier|janv?(\\.)?|juillet|jui?[ln](\\.)?|mars?(\\.)?|mai|novembre|nov(\\.)?|octobre|oct(\\.)?|septembre|sept?(\\.)?(?!\\s+heures))";

    public static final String OnRegex = "(?<=\\b(en|sur\\s*l[ea]|sur)\\s+)({DayRegex}s?)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String RelaxedOnRegex = "(?<=\\b(en|le|dans|sur\\s*l[ea]|du|sur)\\s+)((?<day>10e|11e|12e|13e|14e|15e|16e|17e|18e|19e|1er|20e|21e|22e|23e|24e|25e|26e|27e|28e|29e|2e|30e|31e|3e|4e|5e|6e|7e|8e|9e)s?)\\b";

    public static final String ThisRegex = "\\b((cette(\\s*semaine)?\\s+){WeekDayRegex})|({WeekDayRegex}(\\s+cette\\s*semaine))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String LastDateRegex = "\\b(({WeekDayRegex}(\\s*(de)?\\s*la\\s*semaine\\s+{PastSuffixRegex}))|({WeekDayRegex}(\\s+{PastSuffixRegex})))\\b"
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String NextDateRegex = "\\b(({WeekDayRegex}(\\s+{NextSuffixRegex}))|({WeekDayRegex}(\\s*(de)?\\s*la\\s*semaine\\s+{NextSuffixRegex})))\\b"
            .replace("{NextSuffixRegex}", NextSuffixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String SpecialDayRegex = "\\b(avant[\\s|-]hier|apr[eè]s(-demain|\\s*demain)|(le\\s)?jour suivant|(le\\s+)?dernier jour|hier|lendemain|demain|(de\\s)?la journ[ée]e|aujourd'hui)\\b";

    public static final String SpecialDayWithNumRegex = "^\\b$";

    public static final String StrictWeekDay = "\\b(?<weekday>dim(anche)?|lun(di)?|mar(di)?|mer(credi)?|jeu(di)?|ven(dredi)?|sam(edi)?)s?\\b";

    public static final String SetWeekDayRegex = "\\b(?<prefix>le\\s+)?(?<weekday>matin([ée]e)?|apr[eè]s-midi|soir([ée]e)?|dimanche|lundi|mardi|mercredi|jeudi|vendredi|samedi)s\\b";

    public static final String WeekDayOfMonthRegex = "(?<wom>(le\\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\\s+{WeekDayRegex}\\s+{MonthSuffixRegex})"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String RelativeWeekDayRegex = "^\\b$";

    public static final String AmbiguousRangeModifierPrefix = "^\\b$";

    public static final String NumberEndingPattern = "^\\b$";

    public static final String SpecialDate = "(?<=\\b(au|le)\\s+){DayRegex}(?!:)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String DateYearRegex = "(?<year>{YearRegex}|{TwoDigitYearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String DateExtractor1 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{MonthRegex}\\s*[/\\\\\\.\\-]?\\s*{DayRegex}(\\s*([/\\\\\\.\\-]|\\bde\\b)?\\s*{BaseDateTime.FourDigitYearRegex})?\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String DateExtractor2 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?{DayRegex}(\\s+|\\s*,\\s*|\\s+){MonthRegex}\\s*([\\.\\-]|\\bde\\b)?\\s*{DateYearRegex}\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor3 = "\\b({WeekDayRegex}(\\s+|\\s*,\\s*))?((?<!\\d\\s)(?<!\\d){DayRegex}(\\s+|\\s*[.,/-])({MonthRegex}((\\s+|\\s*[.,/-]\\s*){DateYearRegex}(?!\\s*\\d))?|{MonthNumRegex}(\\s+|\\s*[.,/-]\\s*){DateYearRegex}(?!\\s*\\d))|{BaseDateTime.FourDigitYearRegex}\\s*[.,/-]?\\s*{DayRegex}\\s*[.,/-]?\\s*{MonthRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String DateExtractor4 = "\\b{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}\\s*[/\\\\\\-]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor5 = "\\b{DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor6 = "(?<=\\b(le|sur(\\sl[ae])?)\\s+){MonthNumRegex}[\\-\\.\\/]{DayRegex}{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor7 = "\\b{DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor8 = "(?<=\\b(le)\\s+){DayRegex}[\\\\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor9 = "\\b{DayRegex}\\s*/\\s*{MonthNumRegex}((\\s+|\\s*,\\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractorA = "\\b({DateYearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{DayRegex}|{DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})(?!\\s*[/\\\\\\-\\.:]\\s*\\d+)"
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex);

    public static final String OfMonth = "^(\\s*de)?\\s*{MonthRegex}\\b"
            .replace("{MonthRegex}", MonthRegex);

    public static final String MonthEnd = "{MonthRegex}\\s*(le)?\\s*$"
            .replace("{MonthRegex}", MonthRegex);

    public static final String WeekDayEnd = "{WeekDayRegex}\\s*,?\\s*$"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayStart = "^\\b$";

    public static final String RangeUnitRegex = "\\b(?<unit>(l')?ann[eé]e(s)?|mois|semaines?)\\b";

    public static final String HourNumRegex = "\\b(?<hournum>zero|une?(?=\\s+heure)|deux|trois|quatre|cinq|six|sept|huit|neuf|onze|douze|treize|quatorze|quinze|dix-six|seize|dix(-|\\s+)sept|dix(-|\\s+)huit|dix(-|\\s+)neuf|vingt|vingt(-|\\s+)et(-|\\s+)un|vingt(-|\\s+)deux|vingt(-|\\s+)trois|dix)\\b";

    public static final String MinuteNumRegex = "(?<minnum>((vingt|trente|quarante|cinquante)(\\s*(et|-)?\\s*))?(un|deux|trois|quatre|cinq|six|sept|huit|neuf)|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt|trente|quarante|cinquante|dix)";

    public static final String DeltaMinuteNumRegex = "(?<deltaminnum>((vingt|trente|quarante|cinquante)(\\s*(et|-)?\\s*))?(un|deux|trois|quatre|cinq|six|sept|huit|neuf)|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt|trente|quarante|cinquante|dix)";

    public static final String OclockRegex = "(?<oclock>heures?|h)";

    public static final String PmRegex = "(?<pm>(dans l'\\s*)?apr[eè]s(\\s*|-)midi|(du|ce|de|le)\\s*(soir([ée]e)?)|(dans l[ea]\\s+)?(nuit|soir[eé]e))";

    public static final String AmRegex = "(?<am>(du|de|ce|(du|de|dans)\\s*l[ea]|le)?\\s*matin[ée]e|(du|de|ce|dans l[ea]|le)?\\s*matin)";

    public static final String LessThanOneHour = "(?<lth>(une\\s+)?quart|trois quart(s)?|demie( heure)?|({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex})(\\s+(minutes?|mins?))|(?<=heures?\\s+((et|moins)\\s+)?)({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex}))"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{DeltaMinuteNumRegex}", DeltaMinuteNumRegex);

    public static final String WrittenTimeRegex = "(?<writtentime>{HourNumRegex}\\s+(heures\\s+)?(et\\s+)?{MinuteNumRegex}(?!\\s+heures)(\\s+(minutes?|mins?))?)"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex);

    public static final String TimePrefix = "(?<prefix>(heures?\\s+((et|moins)\\s+)?{LessThanOneHour}|(et|moins)\\s+{LessThanOneHour}|{LessThanOneHour}\\s+[àa]))"
            .replace("{LessThanOneHour}", LessThanOneHour);

    public static final String TimeSuffix = "(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})"
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String BasicTime = "(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(:|\\s*h\\s*){BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex);

    public static final String MidnightRegex = "(?<midnight>minuit)";

    public static final String CommonDatePrefixRegex = "^[\\.]";

    public static final String MorningRegex = "(?<morning>matin([ée]e)?)";

    public static final String AfternoonRegex = "(?<afternoon>(d'|l')?apr[eè]s(-|\\s*)midi)";

    public static final String MidmorningRegex = "(?<midmorning>milieu\\s*d[ue]\\s*{MorningRegex})"
            .replace("{MorningRegex}", MorningRegex);

    public static final String MiddayRegex = "(?<midday>milieu(\\s*|-)d[eu]\\s*(jour|midi)|apr[eè]s(-|\\s*)midi|(?<=\\bà\\s+)midi)";

    public static final String MidafternoonRegex = "(?<midafternoon>milieu\\s*d'+{AfternoonRegex})"
            .replace("{AfternoonRegex}", AfternoonRegex);

    public static final String MidTimeRegex = "(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))"
            .replace("{MidnightRegex}", MidnightRegex)
            .replace("{MidmorningRegex}", MidmorningRegex)
            .replace("{MidafternoonRegex}", MidafternoonRegex)
            .replace("{MiddayRegex}", MiddayRegex);

    public static final String AtRegex = "\\b(((?<=\\b[àa]\\s+)({WrittenTimeRegex}|{HourNumRegex}(\\s+heures)?|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String IshRegex = "\\b(peu\\s*pr[èe]s\\s*{BaseDateTime.HourRegex}|peu\\s*pr[èe]s\\s*{WrittenTimeRegex}|peu\\s*pr[èe]s\\s*[àa]\\s*{BaseDateTime.HourRegex}|peu pr[èe]s midi)\\b"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex);

    public static final String TimeUnitRegex = "(?<unit>h|(heure|hr|minute|min|seconde|sec)(?<plural>s)?)\\b";

    public static final String RestrictedTimeUnitRegex = "(?<unit>huere|minute)\\b";

    public static final String ConnectNumRegex = "{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String FivesRegex = "(?<tens>(quinze|vingt(\\s*|-*(cinq))?|trente(\\s*|-*(cinq))?|quarante(\\s*|-*(cinq))??|cinquante(\\s*|-*(cinq))?|dix|cinq))\\b";

    public static final String PeriodHourNumRegex = "(?<hour>vingt-et-un|vingt-deux|vingt-trois|vingt-quatre|zero|une|deux|trois|quatre|cinq|six|sept|huit|neuf|dix|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt)";

    public static final String TimeRegex1 = "\\b({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\\s*{DescRegex}(\\s+{TimePrefix})?\\b"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex2 = "(\\b{TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?:(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?((\\s*{DescRegex})|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex3 = "\\b{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})(\\s+{TimePrefix})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex4 = "\\b{BasicTime}(\\s*{DescRegex})?(\\s+{TimePrefix})?\\s+{TimeSuffix}\\b"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex5 = "\\b{BasicTime}((\\s*{DescRegex})(\\s+{TimePrefix})?|\\s+{TimePrefix})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex6 = "{BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}\\b"
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex7 = "\\b{TimeSuffix}\\s+[àa]\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex8 = "\\b{TimeSuffix}\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffix}", TimeSuffix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex9 = "\\b{PeriodHourNumRegex}\\s+{FivesRegex}((\\s*{DescRegex})|\\b)"
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{FivesRegex}", FivesRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex10 = "\\b{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?(\\s+{TimePrefix})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String HourRegex = "\\b{BaseDateTime.HourRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String PeriodDescRegex = "(?<desc>pm|am|p\\.m\\.|a\\.m\\.|p)";

    public static final String PeriodPmRegex = "(?<pm>dans l'apr[eè]s-midi|ce soir|d[eu] soir|dans l[ea] soir[eé]e|dans la nuit|d[eu] soir[ée]e)s?";

    public static final String PeriodAmRegex = "(?<am>d[eu] matin|matin([ée]e)s?";

    public static final String PureNumFromTo = "((du|depuis|des?)\\s+)?(?<!\\d[\\/.,:\\-])({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{PeriodDescRegex}))?\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{PeriodDescRegex}", PeriodDescRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String PureNumBetweenAnd = "(entre\\s+)({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{PeriodDescRegex}))?\\s*{RangeConnectorRegex}\\s*({HourRegex}|{PeriodHourNumRegex})\\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{PeriodDescRegex}", PeriodDescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String SpecificTimeFromTo = "^\\b$";

    public static final String SpecificTimeBetweenAnd = "^\\b$";

    public static final String PrepositionRegex = "(?<prep>^([aà](\\s+?la)?|en|sur(\\s*l[ea])?|de)$)";

    public static final String TimeOfDayRegex = "\\b(?<timeOfDay>((((dans\\s+(l[ea])?\\s+)?((?<early>d[eé]but(\\s+|-)|t[oô]t(\\s+|-)(l[ea]\\s*)?)|(?<late>fin\\s*|fin de(\\s+(la)?)|tard\\s*))?(matin([ée]e)?|((d|l)?'?)apr[eè]s[-|\\s*]midi|nuit|soir([eé]e)?)))|(((\\s+(l[ea])?\\s+)?)jour(n[eé]e)?))s?)\\b";

    public static final String SpecificTimeOfDayRegex = "\\b(({RelativeRegex}\\s+{TimeOfDayRegex})|({TimeOfDayRegex}\\s*({NextSuffixRegex}))\\b|\\b(du )?soir)s?\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String TimeFollowedUnit = "^\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String TimeNumberCombinedWithUnit = "\\b(?<num>\\d+(\\.\\d*)?){TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String NowRegex = "\\b(?<now>(ce\\s+)?moment|maintenant|(d[eè]s|aussit[oô]t) que possible|dqp|r[eé]cemment|auparavant|le plus tôt( que)? possible)\\b";

    public static final String SuffixRegex = "^\\s*((dans\\s+l[ea]\\s+)|(en\\s+)|(d(u|\\'))?(matin([eé]e)?|apr[eè]s-midi|soir[eé]e|nuit))\\b";

    public static final String DateTimeTimeOfDayRegex = "\\b(?<timeOfDay>matin([eé]e)?|apr[eè]s-midi|nuit|soir)\\b";

    public static final String DateTimeSpecificTimeOfDayRegex = "\\b(({RelativeRegex}\\s+{DateTimeTimeOfDayRegex})\\b|\\b(ce(tte)?\\s+)(soir|nuit))\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String TimeOfTodayAfterRegex = "^\\s*(,\\s*)?(en|dans|du\\s+)?{DateTimeSpecificTimeOfDayRegex}"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String TimeOfTodayBeforeRegex = "{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]|vers|pour))?\\s*$"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayAfterRegex = "({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?(en|[àa]\\s+)?{DateTimeSpecificTimeOfDayRegex}"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayBeforeRegex = "{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+([àa]|vers|pour))?\\s*({HourNumRegex}|{BaseDateTime.HourRegex})"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String SpecificEndOfRegex = "(la\\s+)?fin(\\s+de\\s*|\\s*de*l[ea])?\\s*$";

    public static final String UnspecificEndOfRegex = "^\\b$";

    public static final String UnspecificEndOfRangeRegex = "^\\b$";

    public static final String PeriodTimeOfDayRegex = "\\b((dans\\s+(le)?\\s+)?((?<early>d[eé]but(\\s+|-|d[ue]|de la)|t[oô]t)|(?<late>tard\\s*|fin(\\s+|-|d[eu])?))?(?<timeOfDay>matin|((d|l)?'?)apr[eè]s-midi|nuit|soir([eé]e)?))\\b";

    public static final String PeriodSpecificTimeOfDayRegex = "\\b(({RelativeRegex}\\s+{PeriodTimeOfDayRegex})\\b|\\b(ce(tte)?\\s+)(soir|nuit))\\b"
            .replace("{PeriodTimeOfDayRegex}", PeriodTimeOfDayRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String PeriodTimeOfDayWithDateRegex = "\\b(({TimeOfDayRegex}))\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String LessThanRegex = "^\\b$";

    public static final String MoreThanRegex = "^\\b$";

    public static final String DurationUnitRegex = "(?<unit>ann[eé]es?|ans?|mois|semaines?|jours?|heures?|hrs?|h|minutes?|mins?|secondes?|secs?|journ[eé]e)\\b";

    public static final String SuffixAndRegex = "(?<suffix>\\s*(et)\\s+(une?\\s+)?(?<suffix_num>demi|quart))";

    public static final String PeriodicRegex = "\\b(?<periodic>quotidien(ne)?|journellement|mensuel(le)?|jours?|hebdomadaire|bihebdomadaire|annuel(lement)?)\\b";

    public static final String EachUnitRegex = "(?<each>(chaque|toutes les|tous les)(?<other>\\s+autres)?\\s*{DurationUnitRegex})"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String EachPrefixRegex = "\\b(?<each>(chaque|tous les|(toutes les))\\s*$)";

    public static final String SetEachRegex = "\\b(?<each>(chaque|tous les|(toutes les))\\s*)";

    public static final String SetLastRegex = "(?<last>prochain|dernier|derni[eè]re|pass[ée]s|pr[eé]c[eé]dent|courant|en\\s*cours)";

    public static final String EachDayRegex = "^\\s*(chaque|tous les)\\s*(jour|jours)\\b";

    public static final String DurationFollowedUnit = "^\\s*{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex}"
            .replace("{SuffixAndRegex}", SuffixAndRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String NumberCombinedWithDurationUnit = "\\b(?<num>\\d+(\\.\\d*)?)(-)?{DurationUnitRegex}"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String AnUnitRegex = "\\b(((?<half>demi\\s+)?(-)\\s+{DurationUnitRegex}))"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String DuringRegex = "^\\b$";

    public static final String AllRegex = "\\b(?<all>toute\\s(l['ea])\\s?(?<unit>ann[eé]e|mois|semaines?|jours?|journ[eé]e))\\b";

    public static final String HalfRegex = "((une?\\s*)|\\b)(?<half>demi?(\\s*|-)+(?<unit>ann[eé]e|ans?|mois|semaine|jour|heure))\\b";

    public static final String ConjunctionRegex = "\\b((et(\\s+de|pour)?)|avec)\\b";

    public static final String HolidayRegex1 = "\\b(?<holiday>vendredi saint|mercredi des cendres|p[aâ]ques|l'action de gr[âa]ce|mardi gras|la saint-sylvestre|la saint sylvestre|la saint-valentin|la saint valentin|nouvel an chinois|nouvel an|r[eé]veillon de nouvel an|jour de l'an|premier-mai|ler-mai|1-mai|poisson d'avril|r[eé]veillon de no[eë]l|veille de no[eë]l|noël|noel|thanksgiving|halloween|yuandan)(\\s+((d[ue]\\s+|d'))?({YearRegex}|({ThisPrefixRegex}\\s+)ann[eé]e|ann[eé]e\\s+({PastSuffixRegex}|{NextSuffixRegex})))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String HolidayRegex2 = "\\b(?<holiday>martin luther king|martin luther king jr|toussaint|st patrick|st george|cinco de mayo|l'ind[eé]pendance(\\s+am[eé]ricaine)?|guy fawkes)(\\s+(de\\s+)?({YearRegex}|{ThisPrefixRegex}\\s+ann[eé]e|ann[eé]e\\s+({PastSuffixRegex}|{NextSuffixRegex})))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String HolidayRegex3 = "(?<holiday>(jour\\s*(d[eu]|des)\\s*(canberra|p[aâ]ques|colomb|bastille|la prise de la bastille|thanks\\s*giving|bapt[êe]me|nationale|d'armistice|inaugueration|marmotte|assomption|femme|comm[ée]moratif)))(\\s+(de\\s+)?({YearRegex}|{ThisPrefixRegex}\\s+ann[eé]e|ann[eé]e\\s+({PastSuffixRegex}|{NextSuffixRegex})))?"
            .replace("{YearRegex}", YearRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String HolidayRegex4 = "(?<holiday>(f[eê]te\\s*(d[eu]|des)\\s*)(travail|m[eè]res?|p[eè]res?))(\\s+(de\\s+)?({YearRegex}|{ThisPrefixRegex}\\s+ann[eé]e|ann[eé]e\\s+({PastSuffixRegex}|{NextSuffixRegex})))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{NextSuffixRegex}", NextSuffixRegex);

    public static final String DateTokenPrefix = "le ";

    public static final String TimeTokenPrefix = "à ";

    public static final String TokenBeforeDate = "le ";

    public static final String TokenBeforeTime = "à ";

    public static final String HalfTokenRegex = "\\b(demie)$";

    public static final String QuarterTokenRegex = "\\b((un\\s+)?quart)$";

    public static final String ThreeQuarterTokenRegex = "\\b(trois\\s+quarts)$";

    public static final String ToTokenRegex = "\\b(moins|[aà]$)\\b";

    public static final String AMTimeRegex = "(?<am>matin([ée]e)?)";

    public static final String PMTimeRegex = "\\b(?<pm>(d'|l')?apr[eè]s-midi|nuit|((\\s*ce|du)\\s+)?soir)\\b";

    public static final String AsapTimeRegex = "((d[eè]s|le plus t[oô]t|aussit[oô]t)( que)? possible|dqp)";

    public static final String BeforeRegex = "\\b(avant)\\b";

    public static final String BeforeRegex2 = "\\b(entre\\s*(le|la(s)?)?)\\b";

    public static final String AfterRegex = "\\b(apres)\\b";

    public static final String SinceRegex = "\\b(depuis)\\b";

    public static final String AroundRegex = "\\b(vers|à\\s+peu\\s+près|environ)\\b";

    public static final String AgoPrefixRegex = "\\b(y a)\\b";

    public static final String LaterRegex = "\\b(plus\\s+tard|à\\s+partir\\s+(de\\s+(maintenant|demain)|d'aujourd'hui)|après\\s+(aujourd'hui|demain))\\b";

    public static final String AgoRegex = "\\b((depuis|il\\s+y\\s*a)(\\s+{AroundRegex})?|auparavant|avant\\s+(?<day>hier|aujourd'hui))\\b"
            .replace("{AroundRegex}", AroundRegex);

    public static final String BeforeAfterRegex = "^\\b$";

    public static final String InConnectorRegex = "\\b(dans|en|sur)\\b";

    public static final String SinceYearSuffixRegex = "^\\b$";

    public static final String WithinNextPrefixRegex = "\\b(dans\\s+les)\\b";

    public static final String TodayNowRegex = "\\b(aujourd'hui|maintenant)\\b";

    public static final String MorningStartEndRegex = "(^(matin))|((matin)$)";

    public static final String AfternoonStartEndRegex = "(^((d'|l')?apr[eè]s-midi))|(((d'|l')?apr[eè]s-midi)$)";

    public static final String EveningStartEndRegex = "(^(soir[ée]e|soir))|((soir[ée]e|soir)$)";

    public static final String NightStartEndRegex = "(^(nuit))|((nuit)$)";

    public static final String InexactNumberRegex = "\\b(quel qu[ée]s|quelqu[ée]s?|plusieurs?|divers)\\b";

    public static final String InexactNumberUnitRegex = "({InexactNumberRegex})\\s+({DurationUnitRegex})"
            .replace("{InexactNumberRegex}", InexactNumberRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String RelativeTimeUnitRegex = "(((({ThisPrefixRegex})?)\\s+({TimeUnitRegex}(\\s*{NextSuffixRegex}|{PastSuffixRegex})?))|((le))\\s+({RestrictedTimeUnitRegex}))"
            .replace("{NextSuffixRegex}", NextSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{TimeUnitRegex}", TimeUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String RelativeDurationUnitRegex = "\\b(((?<=({NextSuffixRegex}|{PastSuffixRegex})\\s+)({DurationUnitRegex}))|(({DurationUnitRegex})(\\s+({NextSuffixRegex}|{PastSuffixRegex}))?)|((le|my))\\s+({RestrictedTimeUnitRegex}))\\b"
            .replace("{NextSuffixRegex}", NextSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String ReferenceDatePeriodRegex = "^\\b$";

    public static final String UpcomingPrefixRegex = ".^";

    public static final String NextPrefixRegex = ".^";

    public static final String PastPrefixRegex = ".^";

    public static final String PreviousPrefixRegex = ".^";

    public static final String RelativeDayRegex = "\\b(((la\\s+)?{RelativeRegex}\\s+journ[ée]e))\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String ConnectorRegex = "^(,|pour|t|vers|le)$";

    public static final String ConnectorAndRegex = "\\b(et\\s*(le|las?)?)\\b";

    public static final String FromRegex = "((de|du)?)$";

    public static final String FromRegex2 = "((depuis|de)(\\s*las?)?)$";

    public static final String FromToRegex = "\\b(du|depuis|des?).+(au|à|a)\\b.+";

    public static final String SingleAmbiguousMonthRegex = "^(le\\s+)?(may|march)$";

    public static final String UnspecificDatePeriodRegex = "^(semaine|mois|an(n[eé]e)?)$";

    public static final String PrepositionSuffixRegex = "\\b(du|de|[àa]|vers|dans)$";

    public static final String FlexibleDayRegex = "(?<DayOfMonth>([A-Za-z]+\\s)?[A-Za-z\\d]+)";

    public static final String ForTheRegex = "\\b(((pour le {FlexibleDayRegex})|(dans (le\\s+)?{FlexibleDayRegex}(?<=(st|nd|rd|th))))(?<end>\\s*(,|\\.|!|\\?|$)))"
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayOfMonthRegex = "\\b({WeekDayRegex}\\s+(le\\s+{FlexibleDayRegex})|le\\s+(?<DayOfMonth>{DayRegex}|{WrittenDayRegex})\\s+{WeekDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{FlexibleDayRegex}", FlexibleDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{WrittenDayRegex}", WrittenDayRegex);

    public static final String WeekDayAndDayRegex = "\\b{WeekDayRegex}\\s+(?!(the)){DayRegex}(?!([-:]|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String RestOfDateRegex = "\\b(reste|fin)\\s+(d[eu]\\s+)?((le|ce(tte)?)\\s+)?(?<duration>semaine|mois|l'ann[ée]e)\\b";

    public static final String RestOfDateTimeRegex = "\\b(reste|fin)\\s+(d[eu]\\s+)?((le|ce(tte)?)\\s+)?(?<unit>jour)\\b";

    public static final String LaterEarlyPeriodRegex = "^\\b$";

    public static final String WeekWithWeekDayRangeRegex = "^\\b$";

    public static final String GeneralEndingRegex = "^\\b$";

    public static final String MiddlePauseRegex = "^\\b$";

    public static final String DurationConnectorRegex = "^\\b$";

    public static final String PrefixArticleRegex = "^[\\.]";

    public static final String OrRegex = "^\\b$";

    public static final String YearPlusNumberRegex = "^\\b$";

    public static final String NumberAsTimeRegex = "^\\b$";

    public static final String TimeBeforeAfterRegex = "^\\b$";

    public static final String DateNumberConnectorRegex = "^\\s*(?<connector>\\s+[aà])\\s*$";

    public static final String DecadeRegex = "^\\b$";

    public static final String DecadeWithCenturyRegex = "^\\b$";

    public static final String RelativeDecadeRegex = "^\\b$";

    public static final String YearSuffix = "(,?(\\s*à)?\\s*({DateYearRegex}|{FullTextYearRegex}))"
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String SuffixAfterRegex = "^\\b$";

    public static final String YearPeriodRegex = "((((du|depuis|des?)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((entre)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String FutureSuffixRegex = "\\b(dans\\s+le\\s+futur)\\b";

    public static final String ModPrefixRegex = "\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AroundRegex}", AroundRegex)
            .replace("{BeforeRegex}", BeforeRegex)
            .replace("{AfterRegex}", AfterRegex)
            .replace("{SinceRegex}", SinceRegex);

    public static final String ModSuffixRegex = "\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b"
            .replace("{AgoRegex}", AgoRegex)
            .replace("{LaterRegex}", LaterRegex)
            .replace("{BeforeAfterRegex}", BeforeAfterRegex)
            .replace("{FutureSuffixRegex}", FutureSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final String ComplexDatePeriodRegex = "^\\b$";

    public static final String AmbiguousPointRangeRegex = "^(mar\\.?)$";

    public static final ImmutableMap<String, String> UnitMap = ImmutableMap.<String, String>builder()
        .put("annees", "Y")
        .put("annee", "Y")
        .put("an", "Y")
        .put("ans", "Y")
        .put("mois", "MON")
        .put("semaines", "W")
        .put("semaine", "W")
        .put("journees", "D")
        .put("journee", "D")
        .put("jour", "D")
        .put("jours", "D")
        .put("heures", "H")
        .put("heure", "H")
        .put("hrs", "H")
        .put("hr", "H")
        .put("h", "H")
        .put("minutes", "M")
        .put("minute", "M")
        .put("mins", "M")
        .put("min", "M")
        .put("secondes", "S")
        .put("seconde", "S")
        .put("secs", "S")
        .put("sec", "S")
        .build();

    public static final ImmutableMap<String, Long> UnitValueMap = ImmutableMap.<String, Long>builder()
        .put("annees", 31536000L)
        .put("annee", 31536000L)
        .put("l'annees", 31536000L)
        .put("l'annee", 31536000L)
        .put("an", 31536000L)
        .put("ans", 31536000L)
        .put("mois", 2592000L)
        .put("semaines", 604800L)
        .put("semaine", 604800L)
        .put("journees", 86400L)
        .put("journee", 86400L)
        .put("jour", 86400L)
        .put("jours", 86400L)
        .put("heures", 3600L)
        .put("heure", 3600L)
        .put("hrs", 3600L)
        .put("hr", 3600L)
        .put("h", 3600L)
        .put("minutes", 60L)
        .put("minute", 60L)
        .put("mins", 60L)
        .put("min", 60L)
        .put("secondes", 1L)
        .put("seconde", 1L)
        .put("secs", 1L)
        .put("sec", 1L)
        .build();

    public static final ImmutableMap<String, String> SpecialYearPrefixesMap = ImmutableMap.<String, String>builder()
        .put("", "")
        .build();

    public static final ImmutableMap<String, String> SeasonMap = ImmutableMap.<String, String>builder()
        .put("printemps", "SP")
        .put("été", "SU")
        .put("automne", "FA")
        .put("hiver", "WI")
        .build();

    public static final ImmutableMap<String, Integer> SeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> CardinalMap = ImmutableMap.<String, Integer>builder()
        .put("premier", 1)
        .put("1er", 1)
        .put("deuxième", 2)
        .put("2e", 2)
        .put("troisième", 3)
        .put("troisieme", 3)
        .put("3e", 3)
        .put("quatrième", 4)
        .put("4e", 4)
        .put("cinqième", 5)
        .put("5e", 5)
        .build();

    public static final ImmutableMap<String, Integer> DayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("lundi", 1)
        .put("mardi", 2)
        .put("mercredi", 3)
        .put("jeudi", 4)
        .put("vendredi", 5)
        .put("samedi", 6)
        .put("dimanche", 0)
        .put("lun", 1)
        .put("mar", 2)
        .put("mer", 3)
        .put("jeu", 4)
        .put("ven", 5)
        .put("sam", 6)
        .put("dim", 0)
        .put("lun.", 1)
        .put("mar.", 2)
        .put("mer.", 3)
        .put("jeu.", 4)
        .put("ven.", 5)
        .put("sam.", 6)
        .put("dim.", 0)
        .build();

    public static final ImmutableMap<String, Integer> MonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("janvier", 1)
        .put("fevrier", 2)
        .put("février", 2)
        .put("mars", 3)
        .put("mar", 3)
        .put("mar.", 3)
        .put("avril", 4)
        .put("avr", 4)
        .put("avr.", 4)
        .put("mai", 5)
        .put("juin", 6)
        .put("jun", 6)
        .put("jun.", 6)
        .put("juillet", 7)
        .put("aout", 8)
        .put("août", 8)
        .put("septembre", 9)
        .put("octobre", 10)
        .put("novembre", 11)
        .put("decembre", 12)
        .put("décembre", 12)
        .put("janv", 1)
        .put("janv.", 1)
        .put("jan", 1)
        .put("jan.", 1)
        .put("fevr", 2)
        .put("fevr.", 2)
        .put("févr.", 2)
        .put("févr", 2)
        .put("fev", 2)
        .put("fev.", 2)
        .put("juil", 7)
        .put("jul", 7)
        .put("jul.", 7)
        .put("sep", 9)
        .put("sep.", 9)
        .put("sept.", 9)
        .put("sept", 9)
        .put("oct", 10)
        .put("oct.", 10)
        .put("nov", 11)
        .put("nov.", 11)
        .put("dec", 12)
        .put("dec.", 12)
        .put("déc.", 12)
        .put("déc", 12)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .build();

    public static final ImmutableMap<String, Integer> Numbers = ImmutableMap.<String, Integer>builder()
        .put("zero", 0)
        .put("un", 1)
        .put("une", 1)
        .put("a", 1)
        .put("deux", 2)
        .put("trois", 3)
        .put("quatre", 4)
        .put("cinq", 5)
        .put("six", 6)
        .put("sept", 7)
        .put("huit", 8)
        .put("neuf", 9)
        .put("dix", 10)
        .put("onze", 11)
        .put("douze", 12)
        .put("treize", 13)
        .put("quatorze", 14)
        .put("quinze", 15)
        .put("seize", 16)
        .put("dix-sept", 17)
        .put("dix-huit", 18)
        .put("dix-neuf", 19)
        .put("vingt-et-un", 21)
        .put("vingt et un", 21)
        .put("vingt", 20)
        .put("vingt deux", 22)
        .put("vingt-deux", 22)
        .put("vingt trois", 23)
        .put("vingt-trois", 23)
        .put("vingt quatre", 24)
        .put("vingt-quatre", 24)
        .put("vingt cinq", 25)
        .put("vingt-cinq", 25)
        .put("vingt six", 26)
        .put("vingt-six", 26)
        .put("vingt sept", 27)
        .put("vingt-sept", 27)
        .put("vingt huit", 28)
        .put("vingt-huit", 28)
        .put("vingt neuf", 29)
        .put("vingt-neuf", 29)
        .put("trente", 30)
        .put("trente et un", 31)
        .put("trente-et-un", 31)
        .put("trente deux", 32)
        .put("trente-deux", 32)
        .put("trente trois", 33)
        .put("trente-trois", 33)
        .put("trente quatre", 34)
        .put("trente-quatre", 34)
        .put("trente cinq", 35)
        .put("trente-cinq", 35)
        .put("trente six", 36)
        .put("trente-six", 36)
        .put("trente sept", 37)
        .put("trente-sept", 37)
        .put("trente huit", 38)
        .put("trente-huit", 38)
        .put("trente neuf", 39)
        .put("trente-neuf", 39)
        .put("quarante", 40)
        .put("quarante et un", 41)
        .put("quarante-et-un", 41)
        .put("quarante deux", 42)
        .put("quarante-duex", 42)
        .put("quarante trois", 43)
        .put("quarante-trois", 43)
        .put("quarante quatre", 44)
        .put("quarante-quatre", 44)
        .put("quarante cinq", 45)
        .put("quarante-cinq", 45)
        .put("quarante six", 46)
        .put("quarante-six", 46)
        .put("quarante sept", 47)
        .put("quarante-sept", 47)
        .put("quarante huit", 48)
        .put("quarante-huit", 48)
        .put("quarante neuf", 49)
        .put("quarante-neuf", 49)
        .put("cinquante", 50)
        .put("cinquante et un", 51)
        .put("cinquante-et-un", 51)
        .put("cinquante deux", 52)
        .put("cinquante-deux", 52)
        .put("cinquante trois", 53)
        .put("cinquante-trois", 53)
        .put("cinquante quatre", 54)
        .put("cinquante-quatre", 54)
        .put("cinquante cinq", 55)
        .put("cinquante-cinq", 55)
        .put("cinquante six", 56)
        .put("cinquante-six", 56)
        .put("cinquante sept", 57)
        .put("cinquante-sept", 57)
        .put("cinquante huit", 58)
        .put("cinquante-huit", 58)
        .put("cinquante neuf", 59)
        .put("cinquante-neuf", 59)
        .put("soixante", 60)
        .put("soixante et un", 61)
        .put("soixante-et-un", 61)
        .put("soixante deux", 62)
        .put("soixante-deux", 62)
        .put("soixante trois", 63)
        .put("soixante-trois", 63)
        .put("soixante quatre", 64)
        .put("soixante-quatre", 64)
        .put("soixante cinq", 65)
        .put("soixante-cinq", 65)
        .put("soixante six", 66)
        .put("soixante-six", 66)
        .put("soixante sept", 67)
        .put("soixante-sept", 67)
        .put("soixante huit", 68)
        .put("soixante-huit", 68)
        .put("soixante neuf", 69)
        .put("soixante-neuf", 69)
        .put("soixante dix", 70)
        .put("soixante-dix", 70)
        .put("soixante et onze", 71)
        .put("soixante-et-onze", 71)
        .put("soixante douze", 72)
        .put("soixante-douze", 72)
        .put("soixante treize", 73)
        .put("soixante-treize", 73)
        .put("soixante quatorze", 74)
        .put("soixante-quatorze", 74)
        .put("soixante quinze", 75)
        .put("soixante-quinze", 75)
        .put("soixante seize", 76)
        .put("soixante-seize", 76)
        .put("soixante dix sept", 77)
        .put("soixante-dix-sept", 77)
        .put("soixante dix huit", 78)
        .put("soixante-dix-huit", 78)
        .put("soixante dix neuf", 79)
        .put("soixante-dix-neuf", 79)
        .put("quatre vingt", 80)
        .put("quatre-vingt", 80)
        .put("quatre vingt un", 81)
        .put("quatre-vingt-un", 81)
        .put("quatre vingt deux", 82)
        .put("quatre-vingt-duex", 82)
        .put("quatre vingt trois", 83)
        .put("quatre-vingt-trois", 83)
        .put("quatre vingt quatre", 84)
        .put("quatre-vingt-quatre", 84)
        .put("quatre vingt cinq", 85)
        .put("quatre-vingt-cinq", 85)
        .put("quatre vingt six", 86)
        .put("quatre-vingt-six", 86)
        .put("quatre vingt sept", 87)
        .put("quatre-vingt-sept", 87)
        .put("quatre vingt huit", 88)
        .put("quatre-vingt-huit", 88)
        .put("quatre vingt neuf", 89)
        .put("quatre-vingt-neuf", 89)
        .put("quatre vingt dix", 90)
        .put("quatre-vingt-dix", 90)
        .put("quatre vingt onze", 91)
        .put("quatre-vingt-onze", 91)
        .put("quatre vingt douze", 92)
        .put("quatre-vingt-douze", 92)
        .put("quatre vingt treize", 93)
        .put("quatre-vingt-treize", 93)
        .put("quatre vingt quatorze", 94)
        .put("quatre-vingt-quatorze", 94)
        .put("quatre vingt quinze", 95)
        .put("quatre-vingt-quinze", 95)
        .put("quatre vingt seize", 96)
        .put("quatre-vingt-seize", 96)
        .put("quatre vingt dix sept", 97)
        .put("quatre-vingt-dix-sept", 97)
        .put("quatre vingt dix huit", 98)
        .put("quatre-vingt-dix-huit", 98)
        .put("quatre vingt dix neuf", 99)
        .put("quatre-vingt-dix-neuf", 99)
        .put("cent", 100)
        .build();

    public static final ImmutableMap<String, Integer> DayOfMonth = ImmutableMap.<String, Integer>builder()
        .put("1er", 1)
        .put("2e", 2)
        .put("3e", 3)
        .put("4e", 4)
        .put("5e", 5)
        .put("6e", 6)
        .put("7e", 7)
        .put("8e", 8)
        .put("9e", 9)
        .put("10e", 10)
        .put("11e", 11)
        .put("12e", 12)
        .put("13e", 13)
        .put("14e", 14)
        .put("15e", 15)
        .put("16e", 16)
        .put("17e", 17)
        .put("18e", 18)
        .put("19e", 19)
        .put("20e", 20)
        .put("21e", 21)
        .put("22e", 22)
        .put("23e", 23)
        .put("24e", 24)
        .put("25e", 25)
        .put("26e", 26)
        .put("27e", 27)
        .put("28e", 28)
        .put("29e", 29)
        .put("30e", 30)
        .put("31e", 31)
        .build();

    public static final ImmutableMap<String, Double> DoubleNumbers = ImmutableMap.<String, Double>builder()
        .put("demi", 0.5D)
        .put("quart", 0.25D)
        .build();

    public static final ImmutableMap<String, String[]> HolidayNames = ImmutableMap.<String, String[]>builder()
        .put("fathers", new String[]{"peres", "pères", "fêtedespères", "fetedesperes"})
        .put("mothers", new String[]{"fêtedesmères", "fetedesmeres"})
        .put("thanksgiving", new String[]{"lactiondegrace", "lactiondegrâce", "jourdethanksgiving", "thanksgiving"})
        .put("martinlutherking", new String[]{"journeemartinlutherking", "martinlutherkingjr"})
        .put("washingtonsbirthday", new String[]{"washingtonsbirthday", "washingtonbirthday"})
        .put("canberra", new String[]{"canberraday"})
        .put("labour", new String[]{"fetedetravail", "travail", "fetedutravail"})
        .put("columbus", new String[]{"columbusday"})
        .put("memorial", new String[]{"jourcommémoratif", "jourcommemoratif"})
        .put("yuandan", new String[]{"yuandan", "nouvelanchinois"})
        .put("maosbirthday", new String[]{"maosbirthday"})
        .put("teachersday", new String[]{"teachersday", "teacherday"})
        .put("singleday", new String[]{"singleday"})
        .put("allsaintsday", new String[]{"allsaintsday"})
        .put("youthday", new String[]{"youthday"})
        .put("childrenday", new String[]{"childrenday", "childday"})
        .put("femaleday", new String[]{"femaleday"})
        .put("treeplantingday", new String[]{"treeplantingday"})
        .put("arborday", new String[]{"arborday"})
        .put("girlsday", new String[]{"girlsday"})
        .put("whiteloverday", new String[]{"whiteloverday"})
        .put("loverday", new String[]{"loverday"})
        .put("christmas", new String[]{"noel", "noël"})
        .put("xmas", new String[]{"xmas"})
        .put("newyear", new String[]{"nouvellesannees", "nouvelan"})
        .put("newyearday", new String[]{"jourdunouvelan"})
        .put("newyearsday", new String[]{"jourdel'an", "jourpremierdelannee", "jourpremierdelannée"})
        .put("inaugurationday", new String[]{"jourd'inaugueration", "inaugueration"})
        .put("groundhougday", new String[]{"marmotte"})
        .put("valentinesday", new String[]{"lasaint-valentin", "lasaintvalentin"})
        .put("stpatrickday", new String[]{"stpatrickday"})
        .put("aprilfools", new String[]{"poissond'avril"})
        .put("stgeorgeday", new String[]{"stgeorgeday"})
        .put("mayday", new String[]{"premier-mai", "ler-mai", "1-mai"})
        .put("cincodemayoday", new String[]{"cincodemayo"})
        .put("baptisteday", new String[]{"bapteme", "baptême"})
        .put("usindependenceday", new String[]{"l'independanceamericaine", "lindépendanceaméricaine"})
        .put("independenceday", new String[]{"l'indépendance", "lindependance"})
        .put("bastilleday", new String[]{"laprisedelabastille", "bastille"})
        .put("halloweenday", new String[]{"halloween"})
        .put("allhallowday", new String[]{"allhallowday"})
        .put("allsoulsday", new String[]{"allsoulsday"})
        .put("guyfawkesday", new String[]{"guyfawkesday"})
        .put("veteransday", new String[]{"veteransday"})
        .put("christmaseve", new String[]{"reveillondenoel", "réveillondenoël", "veilledenoel", "veilledenoël"})
        .put("newyeareve", new String[]{"réveillondenouvelan", "reveillondenouvelan", "lasaint-sylvestre", "lasaintsylvestre"})
        .build();

    public static final String NightRegex = "\\b(minuit|nuit)\\b";

    public static final ImmutableMap<String, Integer> WrittenDecades = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final ImmutableMap<String, Integer> SpecialDecadeCases = ImmutableMap.<String, Integer>builder()
        .put("", 0)
        .build();

    public static final String DefaultLanguageFallback = "DMY";

    public static final List<String> DurationDateRestrictions = Arrays.asList();

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)")
        .put("^([eé]t[eé])$", "(?<!((l\\s*['`]\\s*)|(cet(te)?|en)\\s+))[eé]t[eé]\\b")
        .put("^(mer)$", "(?<!((le|ce)\\s+))mer\\b")
        .put("^(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)$", "([$%£&!?@#])(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)|(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)([$%£&@#])")
        .put("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}")
        .put("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")
        .build();

    public static final ImmutableMap<String, String> AmbiguityTimeFiltersDict = ImmutableMap.<String, String>builder()
        .put("heures?$", "\\b(pour|durée\\s+de|pendant)\\s+(\\S+\\s+){1,2}heures?\\b")
        .build();

    public static final List<String> MorningTermList = Arrays.asList("matinee", "matin", "matinée");

    public static final List<String> AfternoonTermList = Arrays.asList("apres-midi", "apres midi", "après midi", "après-midi");

    public static final List<String> EveningTermList = Arrays.asList("soir", "soiree", "soirée");

    public static final List<String> DaytimeTermList = Arrays.asList("jour", "journee", "journée");

    public static final List<String> NightTermList = Arrays.asList("nuit");

    public static final List<String> SameDayTerms = Arrays.asList("aujourd'hui", "auj");

    public static final List<String> PlusOneDayTerms = Arrays.asList("demain", "a2m1", "lendemain", "jour suivant");

    public static final List<String> MinusOneDayTerms = Arrays.asList("hier", "dernier");

    public static final List<String> PlusTwoDayTerms = Arrays.asList("après demain", "après-demain", "apres-demain");

    public static final List<String> MinusTwoDayTerms = Arrays.asList("avant-hier", "avant hier");

    public static final List<String> FutureStartTerms = Arrays.asList("cette");

    public static final List<String> FutureEndTerms = Arrays.asList("prochaine", "prochain");

    public static final List<String> LastCardinalTerms = Arrays.asList("dernières", "dernière", "dernieres", "derniere", "dernier");

    public static final List<String> MonthTerms = Arrays.asList("mois");

    public static final List<String> MonthToDateTerms = Arrays.asList("mois à ce jour");

    public static final List<String> WeekendTerms = Arrays.asList("fin de semaine", "le weekend");

    public static final List<String> WeekTerms = Arrays.asList("semaine");

    public static final List<String> YearTerms = Arrays.asList("années", "ans", "an", "l'annees", "l'annee");

    public static final List<String> YearToDateTerms = Arrays.asList("année à ce jour", "an à ce jour");
}
