// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class EnglishDateTime {

    public static final String LangMarker = "Eng";

    public static final Boolean CheckBothBeforeAfter = false;

    public static final String TillRegex = "(?<till>\\b(to|(un)?till?|thru|through)\\b(\\s+the\\b)?|{BaseDateTime.RangeConnectorSymbolRegex})"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String RangeConnectorRegex = "(?<and>\\b(and|through|to)\\b(\\s+the\\b)?|{BaseDateTime.RangeConnectorSymbolRegex})"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String LastNegPrefix = "(?<!(w(ill|ould|on\\s*'\\s*t)|m(ay|ight|ust)|sh(all|ould(n\\s*'\\s*t)?)|c(an(\\s*'\\s*t|not)?|ould(n\\s*'\\s*t)?))(\\s+not)?\\s+)";

    public static final String RelativeRegex = "\\b(?<order>following|next|(up)?coming|this|{LastNegPrefix}last|past|previous|current|the)\\b"
            .replace("{LastNegPrefix}", LastNegPrefix);

    public static final String StrictRelativeRegex = "\\b(?<order>following|next|(up)?coming|this|{LastNegPrefix}last|past|previous|current)\\b"
            .replace("{LastNegPrefix}", LastNegPrefix);

    public static final String UpcomingPrefixRegex = "((this\\s+)?((up)?coming))";

    public static final String NextPrefixRegex = "\\b(following|next|{UpcomingPrefixRegex})\\b"
            .replace("{UpcomingPrefixRegex}", UpcomingPrefixRegex);

    public static final String AfterNextSuffixRegex = "\\b(after\\s+(the\\s+)?next)\\b";

    public static final String PastPrefixRegex = "((this\\s+)?past)\\b";

    public static final String PreviousPrefixRegex = "({LastNegPrefix}last|previous|{PastPrefixRegex})\\b"
            .replace("{LastNegPrefix}", LastNegPrefix)
            .replace("{PastPrefixRegex}", PastPrefixRegex);

    public static final String ThisPrefixRegex = "(this|current)\\b";

    public static final String RangePrefixRegex = "(from|between)";

    public static final String CenturySuffixRegex = "(^century)\\b";

    public static final String ReferencePrefixRegex = "(that|same)\\b";

    public static final String FutureSuffixRegex = "\\b((in\\s+the\\s+)?future|hence)\\b";

    public static final String PastSuffixRegex = "\\b((in\\s+the\\s+)past)\\b";

    public static final String DayRegex = "(the\\s*)?(?<!(\\d:|\\$)\\s*|\\d)(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?)(?=\\b|t)";

    public static final String ImplicitDayRegex = "(the\\s*)?(?<day>(?:3[0-1]|[0-2]?\\d)(?:th|nd|rd|st))\\b";

    public static final String MonthNumRegex = "(?<month>1[0-2]|(0)?[1-9])\\b";

    public static final String WrittenOneToNineRegex = "(?:one|two|three|four|five|six|seven|eight|nine)";

    public static final String WrittenElevenToNineteenRegex = "(?:eleven|twelve|(?:thir|four|fif|six|seven|eigh|nine)teen)";

    public static final String WrittenTensRegex = "(?:ten|twenty|thirty|fou?rty|fifty|sixty|seventy|eighty|ninety)";

    public static final String WrittenNumRegex = "(?:{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\\s+{WrittenOneToNineRegex})?)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex)
            .replace("{WrittenElevenToNineteenRegex}", WrittenElevenToNineteenRegex)
            .replace("{WrittenTensRegex}", WrittenTensRegex);

    public static final String WrittenOneToNineOrdinalRegex = "(?:first|second|third|fourth|fifth|sixth|seventh|eighth|nine?th)";

    public static final String WrittenTensOrdinalRegex = "(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth)";

    public static final String WrittenOrdinalRegex = "(?:{WrittenOneToNineOrdinalRegex}|{WrittenTensOrdinalRegex}|{WrittenTensRegex}\\s+{WrittenOneToNineOrdinalRegex})"
            .replace("{WrittenOneToNineOrdinalRegex}", WrittenOneToNineOrdinalRegex)
            .replace("{WrittenTensOrdinalRegex}", WrittenTensOrdinalRegex)
            .replace("{WrittenTensRegex}", WrittenTensRegex);

    public static final String WrittenOrdinalDayRegex = "\\b(the\\s+)?(?<day>(?<ordinal>{WrittenOneToNineOrdinalRegex}|(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth)|(?:ten|twenty)\\s+{WrittenOneToNineOrdinalRegex}|thirty\\s+first))\\b"
            .replace("{WrittenOneToNineOrdinalRegex}", WrittenOneToNineOrdinalRegex);

    public static final String WrittenCenturyFullYearRegex = "(?:(one|two)\\s+thousand((\\s+and)?\\s+{WrittenOneToNineRegex}\\s+hundred)?)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String WrittenCenturyOrdinalYearRegex = "(?:twenty(\\s+(one|two))?|ten|eleven|twelve|thirteen|fifteen|eighteen|(?:four|six|seven|nine)(teen)?|one|two|three|five|eight)";

    public static final String CenturyRegex = "\\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\\s+hundred)?)\\b"
            .replace("{WrittenCenturyFullYearRegex}", WrittenCenturyFullYearRegex)
            .replace("{WrittenCenturyOrdinalYearRegex}", WrittenCenturyOrdinalYearRegex);

    public static final String LastTwoYearNumRegex = "(?:(zero\\s+)?{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\\s+{WrittenOneToNineRegex})?)"
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex)
            .replace("{WrittenElevenToNineteenRegex}", WrittenElevenToNineteenRegex)
            .replace("{WrittenTensRegex}", WrittenTensRegex);

    public static final String FullTextYearRegex = "\\b((?<firsttwoyearnum>{CenturyRegex})(\\s+and)?\\s+(?<lasttwoyearnum>{LastTwoYearNumRegex})\\b|\\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\\s+hundred))\\b"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{WrittenCenturyFullYearRegex}", WrittenCenturyFullYearRegex)
            .replace("{WrittenCenturyOrdinalYearRegex}", WrittenCenturyOrdinalYearRegex)
            .replace("{LastTwoYearNumRegex}", LastTwoYearNumRegex);

    public static final String OclockRegex = "(?<oclock>o\\s*((’|‘|')\\s*)?clock|sharp)";

    public static final String SpecialDescRegex = "((?<ipm>)p\\b)";

    public static final String TasksModeSpecialDescRegex = "([0-9]+((?<ipm>)p\\b))";

    public static final String AmDescRegex = "(?:{BaseDateTime.BaseAmDescRegex})"
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex);

    public static final String PmDescRegex = "(:?{BaseDateTime.BasePmDescRegex})"
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex);

    public static final String AmPmDescRegex = "(:?{BaseDateTime.BaseAmPmDescRegex})"
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex);

    public static final String DescRegex = "(:?(:?({OclockRegex}\\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})))|{OclockRegex})"
            .replace("{OclockRegex}", OclockRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{AmPmDescRegex}", AmPmDescRegex)
            .replace("{SpecialDescRegex}", SpecialDescRegex);

    public static final String OfPrepositionRegex = "(\\bof\\b)";

    public static final String TwoDigitYearRegex = "\\b(?<![$])(?<year>([0-9]\\d))(?!(\\s*((\\:\\d)|{AmDescRegex}|{PmDescRegex}|\\.\\d)))\\b"
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String YearRegex = "(?:{BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String WeekDayRegex = "\\b(?<weekday>(?:sun|mon|tues?|thurs?|fri)(day)?|thu|wedn(esday)?|weds?|sat(urday)?)s?\\b";

    public static final String SingleWeekDayRegex = "\\b(?<weekday>(?<!(easter|palm)\\s+)sunday|(?<!easter\\s+)saturday|(?<!(easter|cyber)\\s+)monday|mon|(?<!black\\s+)friday|fri|(?:tues?|thurs?)(day)?|thu|wedn(esday)?|weds?|((?<=on\\s+)(sat|sun)))\\b";

    public static final String RelativeMonthRegex = "(?<relmonth>((day\\s+)?of\\s+)?{RelativeRegex}\\s+month)\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String MonthRegexNoWordBoundary = "(?<month>apr(il)?|aug(ust)?|dec(ember)?|feb(ruary)?|jan(uary)?|july?|june?|mar(ch)?|may|nov(ember)?|oct(ober)?|sept(ember)?|sep)(?!\\p{L})";

    public static final String MonthRegex = "\\b{MonthRegexNoWordBoundary}"
            .replace("{MonthRegexNoWordBoundary}", MonthRegexNoWordBoundary);

    public static final String WrittenMonthRegex = "(((the\\s+)?month of\\s+)?{MonthRegex})"
            .replace("{MonthRegex}", MonthRegex);

    public static final String MonthSuffixRegex = "(?<msuf>(?:(in|of|on)\\s+)?({RelativeMonthRegex}|{WrittenMonthRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{WrittenMonthRegex}", WrittenMonthRegex);

    public static final String DateUnitRegex = "(?<unit>(decade|year|(?<uoy>month|week)|(?<business>(business\\s+|week\\s*))?(?<uoy>day)|fortnight|weekend)(?<plural>s)?|(?<=(^|\\s)\\d{1,4})[ymwd])\\b";

    public static final String DateTokenPrefix = "on ";

    public static final String TimeTokenPrefix = "at ";

    public static final String TokenBeforeDate = "on ";

    public static final String TokenBeforeTime = "at ";

    public static final String HalfTokenRegex = "^(half)";

    public static final String QuarterTokenRegex = "^((a\\s+)?quarter)";

    public static final String ThreeQuarterTokenRegex = "^(three\\s+quarters?)";

    public static final String ToTokenRegex = "\\b(to)$";

    public static final String FromRegex = "\\b(from(\\s+the)?)$";

    public static final String BetweenTokenRegex = "\\b(between(\\s+the)?)$";

    public static final String SimpleCasesRegex = "\\b({RangePrefixRegex}\\s+)?({DayRegex}|{WrittenOrdinalDayRegex})\\s*{TillRegex}\\s*(({DayRegex}|{WrittenOrdinalDayRegex})\\s+{MonthSuffixRegex}|{MonthSuffixRegex}\\s+({DayRegex}|{WrittenOrdinalDayRegex}))((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{RangePrefixRegex}", RangePrefixRegex)
            .replace("{WrittenOrdinalDayRegex}", WrittenOrdinalDayRegex);

    public static final String MonthFrontSimpleCasesRegex = "\\b({RangePrefixRegex}\\s+)?{MonthSuffixRegex}\\s+((from)\\s+)?({DayRegex}|{WrittenOrdinalDayRegex})\\s*{TillRegex}\\s*({DayRegex}|{WrittenOrdinalDayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{RangePrefixRegex}", RangePrefixRegex)
            .replace("{WrittenOrdinalDayRegex}", WrittenOrdinalDayRegex);

    public static final String MonthFrontBetweenRegex = "\\b{MonthSuffixRegex}\\s+(between\\s+)({DayRegex}|{WrittenOrdinalDayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex}|{WrittenOrdinalDayRegex})((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{WrittenOrdinalDayRegex}", WrittenOrdinalDayRegex);

    public static final String BetweenRegex = "\\b(between\\s+)({DayRegex}|{WrittenOrdinalDayRegex})\\s*{RangeConnectorRegex}\\s*({DayRegex}|{WrittenOrdinalDayRegex})\\s+{MonthSuffixRegex}((\\s+|\\s*,\\s*){YearRegex})?\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{WrittenOrdinalDayRegex}", WrittenOrdinalDayRegex);

    public static final String MonthWithYear = "\\b((({WrittenMonthRegex}[\\.]?|((the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|sixth|6th|seventh|7th|eighth|8th|ninth|9th|tenth|10th|eleventh|11th|twelfth|12th|last)\\s+month(?=\\s+(of|in))))((\\s*)[/\\\\\\-\\.,]?(\\s+(of|in))?(\\s*)({YearRegex}|(?<order>following|next|last|this)\\s+year)|\\s+(of|in)\\s+{TwoDigitYearRegex}))|(({YearRegex}|(?<order>following|next|last|this)\\s+year)(\\s*),?(\\s*){WrittenMonthRegex}))\\b"
            .replace("{WrittenMonthRegex}", WrittenMonthRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String SpecialYearPrefixes = "(calendar|(?<special>fiscal|school))";

    public static final String OneWordPeriodRegex = "\\b((((the\\s+)?month of\\s+)?({StrictRelativeRegex}\\s+)?{MonthRegex})|(month|year) to date|(?<toDate>((un)?till?|to)\\s+date)|({RelativeRegex}\\s+)?(my\\s+)?((?<business>working\\s+week|workweek)|week(end)?|month|fortnight|(({SpecialYearPrefixes}\\s+)?year))(?!((\\s+of)?\\s+\\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\\s+to\\s+date))(\\s+{AfterNextSuffixRegex})?)\\b"
            .replace("{StrictRelativeRegex}", StrictRelativeRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AfterNextSuffixRegex}", AfterNextSuffixRegex)
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes)
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex)
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String MonthNumWithYear = "\\b(({BaseDateTime.FourDigitYearRegex}(\\s*)[/\\-\\.](\\s*){MonthNumRegex})|({MonthNumRegex}(\\s*)[/\\-](\\s*){BaseDateTime.FourDigitYearRegex}))\\b"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String WeekOfMonthRegex = "\\b(?<wom>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+week\\s+{MonthSuffixRegex}(\\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\\s+year)?)\\b"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WeekOfYearRegex = "\\b(?<woy>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+week(\\s+of)?\\s+({YearRegex}|{RelativeRegex}\\s+year))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String OfYearRegex = "\\b((of|in)\\s+({YearRegex}|{StrictRelativeRegex}\\s+year))\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String FirstLastRegex = "\\b(the\\s+)?((?<first>first)|(?<last>last))\\b";

    public static final String FollowedDateUnit = "^\\s*{DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String NumberCombinedWithDateUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateUnitRegex}"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String QuarterTermRegex = "\\b(((?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)[ -]+quarter)|(q(?<number>[1-4])))\\b";

    public static final String RelativeQuarterTermRegex = "\\b(?<orderQuarter>{StrictRelativeRegex})\\s+((?<num>[\\w,]+)\\s+)?quarters?\\b"
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String QuarterRegex = "((the\\s+)?{QuarterTermRegex}(?:((\\s+of)?\\s+|\\s*[,-]\\s*)({YearRegex}|{RelativeRegex}\\s+year))?)|{RelativeQuarterTermRegex}"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{QuarterTermRegex}", QuarterTermRegex)
            .replace("{RelativeQuarterTermRegex}", RelativeQuarterTermRegex);

    public static final String QuarterRegexYearFront = "(?:{YearRegex}|{RelativeRegex}\\s+year)('s)?(?:\\s*-\\s*|\\s+(the\\s+)?)?{QuarterTermRegex}"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{QuarterTermRegex}", QuarterTermRegex);

    public static final String HalfYearTermRegex = "(?<cardinal>first|1st|second|2nd)\\s+half";

    public static final String HalfYearFrontRegex = "(?<year>((1[5-9]|20)\\d{2})|2100)(\\s*-\\s*|\\s+(the\\s+)?)?h(?<number>[1-2])"
            .replace("{YearRegex}", YearRegex);

    public static final String HalfYearBackRegex = "(the\\s+)?(h(?<number>[1-2])|({HalfYearTermRegex}))(\\s+of|\\s*,\\s*)?\\s+({YearRegex})"
            .replace("{YearRegex}", YearRegex)
            .replace("{HalfYearTermRegex}", HalfYearTermRegex);

    public static final String HalfYearRelativeRegex = "(the\\s+)?{HalfYearTermRegex}(\\s+of|\\s*,\\s*)?\\s+({RelativeRegex}\\s+year)"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{HalfYearTermRegex}", HalfYearTermRegex);

    public static final String AllHalfYearRegex = "({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})"
            .replace("{HalfYearFrontRegex}", HalfYearFrontRegex)
            .replace("{HalfYearBackRegex}", HalfYearBackRegex)
            .replace("{HalfYearRelativeRegex}", HalfYearRelativeRegex);

    public static final String EarlyPrefixRegex = "\\b(?<EarlyPrefix>early|beginning of|start of|(?<RelEarly>earlier(\\s+in)?))\\b";

    public static final String MidPrefixRegex = "\\b(?<MidPrefix>mid-?|middle of)\\b";

    public static final String LaterPrefixRegex = "\\b(?<LatePrefix>late|end of|(?<RelLate>later(\\s+in)?))\\b";

    public static final String PrefixPeriodRegex = "({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})"
            .replace("{EarlyPrefixRegex}", EarlyPrefixRegex)
            .replace("{MidPrefixRegex}", MidPrefixRegex)
            .replace("{LaterPrefixRegex}", LaterPrefixRegex);

    public static final String PrefixDayRegex = "\\b((?<EarlyPrefix>earl(y|ier))|(?<MidPrefix>mid(dle)?)|(?<LatePrefix>later?))(\\s+in)?(\\s+the\\s+day)?$";

    public static final String SeasonDescRegex = "(?<seas>spring|summer|fall|autumn|winter)";

    public static final String SeasonRegex = "\\b(?<season>({PrefixPeriodRegex}\\s+)?({RelativeRegex}\\s+)?{SeasonDescRegex}((\\s+of|\\s*,\\s*)?\\s+({YearRegex}|{RelativeRegex}\\s+year))?)\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{SeasonDescRegex}", SeasonDescRegex)
            .replace("{PrefixPeriodRegex}", PrefixPeriodRegex);

    public static final String WhichWeekRegex = "\\b(week)(\\s*)(?<number>5[0-3]|[1-4]\\d|0?[1-9])(\\s+of\\s+({YearRegex}|{RelativeRegex}\\s+year))?\\b"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WeekOfRegex = "(the\\s+)?((week)(\\s+(of|(commencing|starting|beginning)(\\s+on)?))|w/c)(\\s+the)?";

    public static final String MonthOfRegex = "(month)(\\s*)(of)";

    public static final String DateYearRegex = "(?<year>{BaseDateTime.FourDigitYearRegex}|(?<!,\\s?){TwoDigitYearRegex}|{TwoDigitYearRegex}(?=(\\.(?!\\d)|[?!;]|$)))"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{TwoDigitYearRegex}", TwoDigitYearRegex);

    public static final String YearSuffix = "((,|\\sof)?\\s*({DateYearRegex}|{FullTextYearRegex}))"
            .replace("{DateYearRegex}", DateYearRegex)
            .replace("{FullTextYearRegex}", FullTextYearRegex);

    public static final String OnRegex = "(?<=\\bon\\s+)({DayRegex}s?)\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String RelaxedOnRegex = "(?<=\\b(on|at|in)\\s+)((?<day>(3[0-1]|[0-2]?\\d)(?:th|nd|rd|st))s?)\\b";

    public static final String PrefixWeekDayRegex = "(\\s*((,?\\s*on)|[-—–]))";

    public static final String ThisRegex = "\\b(this(\\s*week{PrefixWeekDayRegex}?)?\\s*{WeekDayRegex})|({WeekDayRegex}((\\s+of)?\\s+this\\s*week))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String LastDateRegex = "\\b({PreviousPrefixRegex}(\\s*week{PrefixWeekDayRegex}?)?\\s*{WeekDayRegex})|({WeekDayRegex}(\\s+(of\\s+)?last\\s*week))\\b"
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String NextDateRegex = "\\b({NextPrefixRegex}(\\s*week{PrefixWeekDayRegex}?)?\\s*{WeekDayRegex})|((on\\s+)?{WeekDayRegex}((\\s+of)?\\s+(the\\s+following|(the\\s+)?next)\\s*week))\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{PrefixWeekDayRegex}", PrefixWeekDayRegex);

    public static final String SpecialDayRegex = "\\b((the\\s+)?day before yesterday|(the\\s+)?day after (tomorrow|tmrw?)|the\\s+day\\s+(before|after)(?!=\\s+day)|((the\\s+)?({RelativeRegex}|my)\\s+day)|yesterday|tomorrow|tmrw?|today|otd|current date)\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String SpecialDayWithNumRegex = "\\b((?<number>{WrittenNumRegex})\\s+days?\\s+from\\s+(?<day>yesterday|tomorrow|tmrw?|today|current date))\\b"
            .replace("{WrittenNumRegex}", WrittenNumRegex);

    public static final String RelativeDayRegex = "\\b(((the\\s+)?{RelativeRegex}\\s+day))\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String SetWeekDayRegex = "\\b(?<prefix>on\\s+)?(?<weekday>morning|afternoon|evening|night|(sun|mon|tues|wednes|thurs|fri|satur)day)s\\b";

    public static final String WeekDayOfMonthRegex = "(?<wom>(the\\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\\s+(week\\s+{MonthSuffixRegex}[\\.]?\\s+(on\\s+)?{WeekDayRegex}|{WeekDayRegex}\\s+{MonthSuffixRegex}))"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String RelativeWeekDayRegex = "\\b({WrittenNumRegex}\\s+{WeekDayRegex}\\s+(from\\s+now|later))\\b"
            .replace("{WrittenNumRegex}", WrittenNumRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String SpecialDate = "(?=\\b(on|at)\\s+the\\s+){DayRegex}\\b"
            .replace("{DayRegex}", DayRegex);

    public static final String DatePreposition = "\\b(on|in)";

    public static final String DateExtractorYearTermRegex = "(\\s+|\\s*[/\\\\.,-]\\s*|\\s+of\\s+){DateYearRegex}"
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DayPrefix = "\\b({WeekDayRegex}|{SpecialDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{SpecialDayRegex}", SpecialDayRegex);

    public static final String DateExtractor1 = "\\b({DayPrefix}\\s*[,-]?\\s*)?(({MonthRegex}[\\.]?\\s*[/\\\\.,-]?\\s*{DayRegex})|(\\({MonthRegex}\\s*[-./]\\s*{DayRegex}\\)))(?!\\s*\\-\\s*\\d{2}\\b)(\\s*\\(\\s*{DayPrefix}\\s*\\))?({DateExtractorYearTermRegex}\\b)?"
            .replace("{DayPrefix}", DayPrefix)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateExtractorYearTermRegex}", DateExtractorYearTermRegex);

    public static final String DateExtractor3 = "\\b({DayPrefix}(\\s+|\\s*,\\s*))?({DayRegex}?[\\.]?(\\s+|\\s*[-,/]\\s*|\\s+of\\s+|\\s*)(\\b)?{MonthRegexNoWordBoundary}[\\.]?((\\s+in)?{DateExtractorYearTermRegex})?|{BaseDateTime.FourDigitYearRegex}\\s*[-./]?\\s*(the\\s+)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?)[\\.]?(\\s+|\\s*[-,/]\\s*|\\s+of\\s+){MonthRegex}[\\.]?)\\b"
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DateExtractorYearTermRegex}", DateExtractorYearTermRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{MonthRegexNoWordBoundary}", MonthRegexNoWordBoundary);

    public static final String DateExtractor4 = "\\b{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}[\\.]?\\s*[/\\\\\\-]\\s*{DateYearRegex}"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor5 = "\\b({DayPrefix}(\\s*,)?\\s+)?{DayRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DateYearRegex}(?!\\s*[/\\\\\\-\\.]\\s*\\d+)"
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DateYearRegex}", DateYearRegex);

    public static final String DateExtractor6 = "(?<={DatePreposition}\\s+)({StrictRelativeRegex}\\s+)?({DayPrefix}\\s+)?{MonthNumRegex}[\\-\\.]{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DatePreposition}", DatePreposition)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor7L = "\\b({DayPrefix}(\\s*,)?\\s+)?{MonthNumRegex}\\s*/\\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DateExtractorYearTermRegex}", DateExtractorYearTermRegex);

    public static final String DateExtractor7S = "\\b({DayPrefix}(\\s*,)?\\s+)?{MonthNumRegex}\\s*/\\s*{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor8 = "(?<={DatePreposition}\\s+)({StrictRelativeRegex}\\s+)?({DayPrefix}\\s+)?{DayRegex}[\\\\\\-]{MonthNumRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DatePreposition}", DatePreposition)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractor9L = "\\b({DayPrefix}(\\s*,)?\\s+)?{DayRegex}\\s*/\\s*{MonthNumRegex}{DateExtractorYearTermRegex}(?![%])\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DateExtractorYearTermRegex}", DateExtractorYearTermRegex);

    public static final String DateExtractor9S = "\\b({DayPrefix}(\\s*,)?\\s+)?{DayRegex}\\s*/\\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?![%])\\b"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{BaseDateTime.CheckDecimalRegex}", BaseDateTime.CheckDecimalRegex);

    public static final String DateExtractorNoSep = "\\b((?<![$])(?<year>((1\\d|20)\\d{2})|2100)(\\s+(?<month>1[0-2]|(0)?[1-9])\\s+(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9]))|(?<month>1[0-2]|(0)?[1-9])(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])))\\b)";

    public static final String DateExtractorA = "\\b({DayPrefix}(\\s*,)?\\s+)?(({BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*({MonthNumRegex}|{MonthRegex})\\s*[/\\\\\\-\\.]\\s*{DayRegex})|({MonthRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*(the\\s+)?(?<day>(?:3[0-1]|[1-2]\\d|0?[1-9])(?:th|nd|rd|st)?))|({DayRegex}\\s*[/\\\\\\-\\.]\\s*{BaseDateTime.FourDigitYearRegex}\\s*[/\\\\\\-\\.]\\s*{MonthRegex})|{DateExtractorNoSep})"
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{DayPrefix}", DayPrefix)
            .replace("{DateExtractorNoSep}", DateExtractorNoSep);

    public static final String OfMonth = "^(\\s*(day\\s+)?of)?\\s*{MonthRegex}"
            .replace("{MonthRegex}", MonthRegex);

    public static final String MonthEnd = "{MonthRegex}\\s*(the)?\\s*$"
            .replace("{MonthRegex}", MonthRegex);

    public static final String WeekDayEnd = "(this\\s+)?{WeekDayRegex}\\s*,?\\s*$"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayStart = "^\\s+(on\\s+)?{WeekDayRegex}\\b"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String RangeUnitRegex = "\\b(?<unit>years?|months?|weeks?|fortnights?)\\b";

    public static final String HourNumRegex = "\\b(?<hournum>zero|one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve)\\b";

    public static final String MinuteNumRegex = "(((?<tens>twenty|thirty|fou?rty|fifty)(\\s*-?\\s*))?(?<minnum>one|two|three|four|five|six|seven|eight|nine)|(?<minnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))";

    public static final String DeltaMinuteNumRegex = "(((?<tens>twenty|thirty|fou?rty|fifty)(\\s*-?\\s*))?(?<deltaminnum>one|two|three|four|five|six|seven|eight|nine)|(?<deltaminnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))";

    public static final String PmRegex = "(?<pm>(((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?(((early|late)\\s+)?(afternoon|evening)|midnight|lunchtime))|((at|in|around|on|for)\\s+(the\\s+)?night))";

    public static final String PmRegexFull = "(?<pm>((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?(((early|late)\\s+)?(afternoon|evening)|(mid)?night|lunchtime))";

    public static final String AmRegex = "(?<am>((?:at|in|around|circa|on|for)\\s+(the\\s+)?)?((early|late)\\s+)?(morning))";

    public static final String LunchRegex = "\\blunchtime\\b";

    public static final String NightRegex = "\\b(mid)?night\\b";

    public static final String CommonDatePrefixRegex = "^[\\.]";

    public static final String LessThanOneHour = "(?<lth>(a\\s+)?quarter|three quarter(s)?|half( an hour)?|{BaseDateTime.DeltaMinuteRegex}(\\s+(minutes?|mins?)|(?=\\s+past))|{DeltaMinuteNumRegex}(\\s+(minutes?|mins?)|(?=\\s+past)))"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{DeltaMinuteNumRegex}", DeltaMinuteNumRegex);

    public static final String WrittenTimeRegex = "(?<writtentime>{HourNumRegex}\\s+{MinuteNumRegex}(\\s+(minutes?|mins?))?)"
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{MinuteNumRegex}", MinuteNumRegex);

    public static final String TimePrefix = "(?<prefix>{LessThanOneHour}\\s+(past|to))"
            .replace("{LessThanOneHour}", LessThanOneHour);

    public static final String TimeSuffix = "(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})"
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String TimeSuffixFull = "(?<suffix>{AmRegex}|{PmRegexFull}|{OclockRegex})"
            .replace("{AmRegex}", AmRegex)
            .replace("{PmRegexFull}", PmRegexFull)
            .replace("{OclockRegex}", OclockRegex);

    public static final String BasicTime = "\\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex}(?![%\\d]))"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex);

    public static final String MidnightRegex = "(?<midnight>mid\\s*(-\\s*)?night)";

    public static final String MidmorningRegex = "(?<midmorning>mid\\s*(-\\s*)?morning)";

    public static final String MidafternoonRegex = "(?<midafternoon>mid\\s*(-\\s*)?afternoon)";

    public static final String MiddayRegex = "(?<midday>mid\\s*(-\\s*)?day|((12\\s)?noon))";

    public static final String MidTimeRegex = "(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))"
            .replace("{MidnightRegex}", MidnightRegex)
            .replace("{MidmorningRegex}", MidmorningRegex)
            .replace("{MidafternoonRegex}", MidafternoonRegex)
            .replace("{MiddayRegex}", MiddayRegex);

    public static final String AtRegex = "\\b(?:(?:(?<=\\b(at|(at)?\\s*around|circa)\\s+)(?:{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\\.\\d)(\\s*((?<iam>a)|(?<ipm>p)))?|{MidTimeRegex}))|{MidTimeRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String IshRegex = "\\b({BaseDateTime.HourRegex}(-|——)?ish|noon(ish)?)\\b"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimeUnitRegex = "([^a-z]{1,}|\\b)(?<unit>(h(ou)?r|min(ute)?|sec(ond)?)(?<plural>s)?|h)\\b";

    public static final String RestrictedTimeUnitRegex = "(?<unit>hour|minute)\\b";

    public static final String FivesRegex = "(?<tens>(?:fifteen|(?:twen|thir|fou?r|fif)ty(\\s*five)?|ten|five))\\b";

    public static final String HourRegex = "\\b{BaseDateTime.HourRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String PeriodHourNumRegex = "\\b(?<hour>twenty(\\s+(one|two|three|four))?|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|zero|one|two|three|five|eight|ten)\\b";

    public static final String ConnectNumRegex = "\\b{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\\s*{DescRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegexWithDotConnector = "({BaseDateTime.HourRegex}(\\s*\\.\\s*){BaseDateTime.MinuteRegex})"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex);

    public static final String TimeRegex1 = "\\b({TimePrefix}\\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\\s*|[.]){DescRegex}"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex2 = "(\\b{TimePrefix}\\s+)?(t)?{BaseDateTime.HourRegex}(\\s*)?:(\\s*)?{BaseDateTime.MinuteRegex}((\\s*)?:(\\s*)?{BaseDateTime.SecondRegex})?(?<iam>a)?((\\s*{DescRegex})|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{BaseDateTime.SecondRegex}", BaseDateTime.SecondRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex3 = "(\\b{TimePrefix}\\s+)?{BaseDateTime.HourRegex}\\.{BaseDateTime.MinuteRegex}(\\s*{DescRegex})"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex4 = "\\b{TimePrefix}\\s+{BasicTime}(\\s*{DescRegex})?\\s+{TimeSuffix}\\b"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex5 = "\\b{TimePrefix}\\s+{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex6 = "({BasicTime})(\\s*{DescRegex})?\\s+{TimeSuffix}\\b"
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex)
            .replace("{TimeSuffix}", TimeSuffix);

    public static final String TimeRegex7 = "\\b{TimeSuffixFull}\\s+(at\\s+)?{BasicTime}((\\s*{DescRegex})|\\b)"
            .replace("{TimeSuffixFull}", TimeSuffixFull)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex8 = ".^"
            .replace("{TimeSuffixFull}", TimeSuffixFull)
            .replace("{BasicTime}", BasicTime)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex9 = "\\b{PeriodHourNumRegex}(\\s+|-){FivesRegex}((\\s*{DescRegex})|\\b)"
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{FivesRegex}", FivesRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex10 = "\\b({TimePrefix}\\s+)?{BaseDateTime.HourRegex}(\\s*h\\s*){BaseDateTime.MinuteRegex}(\\s*{DescRegex})?"
            .replace("{TimePrefix}", TimePrefix)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{BaseDateTime.MinuteRegex}", BaseDateTime.MinuteRegex)
            .replace("{DescRegex}", DescRegex);

    public static final String TimeRegex11 = "\\b((?:({TimeTokenPrefix})?{TimeRegexWithDotConnector}(\\s*{DescRegex}))|(?:(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\\s*per\\s*cent|%)))"
            .replace("{TimeTokenPrefix}", TimeTokenPrefix)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{DescRegex}", DescRegex);

    public static final String FirstTimeRegexInTimeRange = "\\b{TimeRegexWithDotConnector}(\\s*{DescRegex})?"
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{DescRegex}", DescRegex);

    public static final String PureNumFromTo = "({RangePrefixRegex}\\s+)?({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?\\s*{TillRegex}\\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex}))?"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangePrefixRegex}", RangePrefixRegex);

    public static final String PureNumBetweenAnd = "(between\\s+)(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?\\s*{RangeConnectorRegex}\\s*(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\\s*({PmRegex}|{AmRegex}|{DescRegex}))?"
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{BaseDateTime.TwoDigitHourRegex}", BaseDateTime.TwoDigitHourRegex)
            .replace("{BaseDateTime.TwoDigitMinuteRegex}", BaseDateTime.TwoDigitMinuteRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String SpecificTimeFromTo = "({RangePrefixRegex}\\s+)?(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{TillRegex}\\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))"
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{FirstTimeRegexInTimeRange}", FirstTimeRegexInTimeRange)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{TillRegex}", TillRegex)
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex)
            .replace("{RangePrefixRegex}", RangePrefixRegex);

    public static final String SpecificTimeBetweenAnd = "(between\\s+)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<leftDesc>{DescRegex}))?))\\s*{RangeConnectorRegex}\\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\\s*(?<rightDesc>{DescRegex}))?))"
            .replace("{TimeRegex2}", TimeRegex2)
            .replace("{FirstTimeRegexInTimeRange}", FirstTimeRegexInTimeRange)
            .replace("{TimeRegexWithDotConnector}", TimeRegexWithDotConnector)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex)
            .replace("{HourRegex}", HourRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{DescRegex}", DescRegex)
            .replace("{PmRegex}", PmRegex)
            .replace("{AmRegex}", AmRegex);

    public static final String SuffixAfterRegex = "\\b(((at)\\s)?(or|and)\\s+(above|after|later|greater)(?!\\s+than))\\b";

    public static final String PrepositionRegex = "(?<prep>^(,\\s*)?(at|on|of)(\\s+the)?$)";

    public static final String LaterEarlyRegex = "((?<early>earl(y|ier)(\\s+|-))|(?<late>late(r?\\s+|-)))";

    public static final String MealTimeRegex = "\\b(at\\s+)?(?<mealTime>breakfast|brunch|lunch(\\s*time)?|dinner(\\s*time)?|supper)\\b";

    public static final String UnspecificTimePeriodRegex = "({MealTimeRegex})"
            .replace("{MealTimeRegex}", MealTimeRegex);

    public static final String TimeOfDayRegex = "\\b(?<timeOfDay>((((in\\s+the\\s+){LaterEarlyRegex}?(morning|afternoon|night(-?time)?|evening)s)|((in\\s+the\\s+)?{LaterEarlyRegex}?(in(\\s+the)?\\s+)?(morning|afternoon|night(-?time)?|evening)))|{MealTimeRegex}|(((in\\s+(the)?\\s+)?)(daytime|business\\s+hours?))))\\b"
            .replace("{LaterEarlyRegex}", LaterEarlyRegex)
            .replace("{MealTimeRegex}", MealTimeRegex);

    public static final String SpecificTimeOfDayRegex = "\\b(({StrictRelativeRegex}\\s+{TimeOfDayRegex})\\b|\\b(?<pm>toni(ght|te)))s?\\b"
            .replace("{TimeOfDayRegex}", TimeOfDayRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String TimeFollowedUnit = "^\\s*{TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final String TimeNumberCombinedWithUnit = "\\b(?<num>\\d+(\\.\\d*)?){TimeUnitRegex}"
            .replace("{TimeUnitRegex}", TimeUnitRegex);

    public static final List<String> BusinessHourSplitStrings = Arrays.asList("business", "hour");

    public static final String NowRegex = "\\b(?<now>(right\\s+)?now|as\\s+soon\\s+as\\s+possible|asap|recently|previously|at\\s+(present|this\\s+time|th(e|is)\\s+minute|the\\s+(moment|present\\s+time)))\\b";

    public static final String NowParseRegex = "\\b({NowRegex}|^(date)$)\\b"
            .replace("{NowRegex}", NowRegex);

    public static final String SuffixRegex = "^\\s*(in the\\s+)?(morning|afternoon|evening|night)\\b";

    public static final String NonTimeContextTokens = "(building)";

    public static final String DateTimeTimeOfDayRegex = "\\b(?<timeOfDay>morning|(?<pm>afternoon|night|evening))\\b";

    public static final String DateTimeSpecificTimeOfDayRegex = "\\b(({RelativeRegex}\\s+{DateTimeTimeOfDayRegex})\\b|\\btoni(ght|te))\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String TimeOfTodayAfterRegex = "^\\s*(,\\s*)?(in\\s+)?{DateTimeSpecificTimeOfDayRegex}"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String TimeOfTodayBeforeRegex = "{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(at|around|circa|in|on))?\\s*$"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayAfterRegex = "(?<!{NonTimeContextTokens}\\s*)\\b({HourNumRegex}|{BaseDateTime.HourRegex})\\s*(,\\s*)?(in\\s+)?{DateTimeSpecificTimeOfDayRegex}\\b"
            .replace("{NonTimeContextTokens}", NonTimeContextTokens)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex);

    public static final String SimpleTimeOfTodayBeforeRegex = "\\b{DateTimeSpecificTimeOfDayRegex}(\\s*,)?(\\s+(at|around|circa))?\\s*({HourNumRegex}|{BaseDateTime.HourRegex})\\b"
            .replace("{DateTimeSpecificTimeOfDayRegex}", DateTimeSpecificTimeOfDayRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String SpecificEndOfRegex = "(the\\s+)?end of(\\s+the)?\\s*$";

    public static final String UnspecificEndOfRegex = "\\b(the\\s+)?(eod|(end\\s+of\\s+day))\\b";

    public static final String UnspecificEndOfRangeRegex = "\\b(eoy)\\b";

    public static final String PeriodTimeOfDayRegex = "\\b((in\\s+(the\\s+)?)?{LaterEarlyRegex}?((this\\s+)?{DateTimeTimeOfDayRegex}|(?<timeOfDay>(?<pm>tonight))))\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String PeriodSpecificTimeOfDayRegex = "\\b({LaterEarlyRegex}?this\\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\\s+{PeriodTimeOfDayRegex})\\b|\\b(?<pm>toni(ght|te)))\\b"
            .replace("{PeriodTimeOfDayRegex}", PeriodTimeOfDayRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex)
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String PeriodTimeOfDayWithDateRegex = "\\b(({PeriodTimeOfDayRegex}(\\s+(on|of))?))\\b"
            .replace("{PeriodTimeOfDayRegex}", PeriodTimeOfDayRegex);

    public static final String TasksmodeMealTimeofDayRegex = "\\b((in\\s+(the)?\\s+)?((?<early>earl(y|ier)(\\s+|-))|(?<late>late(r?\\s+|-)))?((this\\s+)?\\b(?<timeOfDay>lunch(\\s*time)?|dinner(\\s*time)?|brunch|breakfast)\\b))\\b"
            .replace("{DateTimeTimeOfDayRegex}", DateTimeTimeOfDayRegex)
            .replace("{LaterEarlyRegex}", LaterEarlyRegex);

    public static final String LessThanRegex = "\\b(less\\s+than)\\b";

    public static final String MoreThanRegex = "\\b(more\\s+than)\\b";

    public static final String DurationUnitRegex = "(?<unit>{DateUnitRegex}|h(ou)?rs?|h|min(ute)?s?|sec(ond)?s?|nights?)\\b"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String SuffixAndRegex = "(?<suffix>\\s*(and)\\s+(an?\\s+)?(?<suffix_num>half|quarter))";

    public static final String PeriodicRegex = "\\b(?<periodic>((?<multiplier>semi|bi|tri)(\\s*|-))?(daily|monthly|weekly|quarterly|yearly|annual(ly)?))\\b";

    public static final String EachUnitRegex = "\\b(?<each>(every|(each|any|once an|one a|once a)\\s?)(?<other>\\s+(other|alternate|second))?\\s*({DurationUnitRegex}|(?<specialUnit>quarters?|weekends?)|{WeekDayRegex})|(?<specialUnit>weekends))"
            .replace("{DurationUnitRegex}", DurationUnitRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String EachPrefixRegex = "\\b(?<each>(each|every|once an?)\\s*$)";

    public static final String SetEachRegex = "\\b(?<each>(each|every)(?<other>\\s+(other|alternate))?\\s*)(?!the|that)\\b";

    public static final String SetLastRegex = "(?<last>following|next|upcoming|this|{LastNegPrefix}last|past|previous|current)"
            .replace("{LastNegPrefix}", LastNegPrefix);

    public static final String EachDayRegex = "^\\s*(each|every)\\s*day\\b";

    public static final String DurationFollowedUnit = "(^\\s*{DurationUnitRegex}\\s+{SuffixAndRegex})|(^\\s*{SuffixAndRegex}?(\\s+|-)?{DurationUnitRegex})"
            .replace("{SuffixAndRegex}", SuffixAndRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String NumberCombinedWithDurationUnit = "\\b(?<num>\\d+(\\.\\d*)?)(-)?{DurationUnitRegex}"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String AnUnitRegex = "(\\b((?<half>(half)\\s+)?an?|another)|(?<half>(1/2|½|half)))\\s+{DurationUnitRegex}"
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String DuringRegex = "\\b(for|during)\\s+the\\s+(?<unit>year|month|week|day|fortnight)\\b";

    public static final String AllRegex = "\\b(?<all>(all|full|whole)(\\s+|-)(?<unit>year|month|week|day|fortnight))\\b";

    public static final String HalfRegex = "((an?\\s*)|\\b)(?<half>half\\s+(?<unit>year|month|week|fortnight|day|hour))\\b";

    public static final String ConjunctionRegex = "\\b((and(\\s+for)?)|with)\\b";

    public static final String HolidayList1 = "(?<holiday>mardi gras|(washington|mao)'s birthday|juneteenth|(jubilee|freedom)(\\s+day)|chinese new year|(new\\s+(years'|year\\s*'s|years?)\\s+eve)|(new\\s+(years'|year\\s*'s|years?)(\\s+day)?)|may\\s*day|yuan dan|christmas eve|(christmas|xmas)(\\s+day)?|black friday|yuandan|easter(\\s+(sunday|saturday|monday))?|clean monday|ash wednesday|palm sunday|maundy thursday|good friday|white\\s+(sunday|monday)|trinity sunday|pentecost|corpus christi|cyber monday)";

    public static final String HolidayList2 = "(?<holiday>(thanks\\s*giving|all saint's|white lover|s(?:ain)?t?(\\.)?\\s+(?:patrick|george)(?:')?(?:s)?|us independence|all hallow|all souls|guy fawkes|cinco de mayo|halloween|qingming|dragon boat|april fools|tomb\\s*sweeping)(\\s+day)?)";

    public static final String HolidayList3 = "(?<holiday>(?:independence|presidents(?:')?|mlk|martin luther king( jr)?|canberra|ascension|columbus|tree( planting)?|arbor|labou?r|((international|int'?l)\\s+)?workers'?|mother'?s?|father'?s?|female|women('s)?|single|teacher'?s|youth|children|girls|lovers?|earth|inauguration|groundhog|valentine'?s|baptiste|bastille|veterans(?:')?|memorial|mid[ \\-]autumn|moon|spring|lantern)\\s+day)";

    public static final String HolidayList4 = "(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\\s+)adha|eid al(-|\\s+)azha|eidul(-|\\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\\s+)fitr|festival of breaking the fast)";

    public static final String HolidayRegex = "\\b(({StrictRelativeRegex}\\s+({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4}))|(?<holidayWeekend>((the\\s+)?weekend\\s+of\\s+)({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})(\\s+((of\\s+)?({YearRegex}|{RelativeRegex}\\s+year)))?)|(({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})((?<holidayWeekend>(\\s+weekend)(\\s+((of\\s+)?({YearRegex}|{RelativeRegex}\\s+year)))?)|(\\s+(of\\s+)?({YearRegex}|{RelativeRegex}\\s+year)(?<holidayWeekend>\\s+weekend)?))?))\\b"
            .replace("{HolidayList1}", HolidayList1)
            .replace("{HolidayList2}", HolidayList2)
            .replace("{HolidayList3}", HolidayList3)
            .replace("{HolidayList4}", HolidayList4)
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{StrictRelativeRegex}", StrictRelativeRegex);

    public static final String TasksModeHolidayListSupression = "(?<holiday>(?:independence|teacher'?s|youth|children|girls)\\s+day)|(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\\s+)adha|eid al(-|\\s+)azha|eidul(-|\\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\\s+)fitr|festival of breaking the fast)\\b"
            .replace("{HolidayList4}", HolidayList4);

    public static final String AMTimeRegex = "(?<am>morning)";

    public static final String PMTimeRegex = "\\b(?<pm>afternoon|evening|night)\\b";

    public static final String NightTimeRegex = "(night)";

    public static final String NowTimeRegex = "(now|at\\s+(present|this\\s+time|th(e|is)\\s+minute|the\\s+(moment|(current|present)\\s+time)))";

    public static final String RecentlyTimeRegex = "(recently|previously)";

    public static final String AsapTimeRegex = "(as soon as possible|asap)";

    public static final String InclusiveModPrepositions = "(?<include>((on|in|at)\\s+or\\s+)|(\\s+or\\s+(on|in|at)))";

    public static final String AroundRegex = "(?:\\b(?:around|circa)\\s*?\\b)(\\s+the)?";

    public static final String BeforeRegex = "((\\b{InclusiveModPrepositions}?(?:before|in\\s+advance\\s+of|prior\\s+to|(no\\s+later|earlier|sooner)\\s+than|ending\\s+(with|on)|by|(un)?till?|(?<include>as\\s+late\\s+as)){InclusiveModPrepositions}?\\b\\s*?)|(?<!\\w|>)((?<include><\\s*=)|<))(\\s+the)?"
            .replace("{InclusiveModPrepositions}", InclusiveModPrepositions);

    public static final String AfterRegex = "((\\b{InclusiveModPrepositions}?((after(\\s+on)?(?!\\sfrom)|(?<!no\\s+)later\\s+than)|((year\\s+)?greater\\s+than))(?!\\s+or\\s+equal\\s+to){InclusiveModPrepositions}?\\b\\s*?)|(?<!\\w|<)((?<include>>\\s*=)|>))(\\s+the)?"
            .replace("{InclusiveModPrepositions}", InclusiveModPrepositions);

    public static final String SinceRegex = "(?:(?:\\b(?:since|after\\s+or\\s+equal\\s+to|(starting|beginning)(\\s)?(?:from|on|with)?|as\\s+early\\s+as|(any\\s+time\\s+)from)\\b\\s*?)|(?<!\\w|<)(>=))(\\s+the)?";

    public static final String SinceRegexExp = "({SinceRegex}|\\bfrom(\\s+the)?\\b)"
            .replace("{SinceRegex}", SinceRegex);

    public static final String AgoRegex = "\\b(ago|earlier|before\\s+(?<day>yesterday|today))\\b";

    public static final String LaterRegex = "\\b(?:later(?!((\\s+in)?\\s*{OneWordPeriodRegex})|(\\s+{TimeOfDayRegex})|\\s+than\\b)|from now|(from|after)\\s+(?<day>tomorrow|tmrw?|today))\\b"
            .replace("{OneWordPeriodRegex}", OneWordPeriodRegex)
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String BeforeAfterRegex = "\\b((?<before>before)|(?<after>from|after))\\b";

    public static final String ModPrefixRegex = "\\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\\b"
            .replace("{RelativeRegex}", RelativeRegex)
            .replace("{AroundRegex}", AroundRegex)
            .replace("{BeforeRegex}", BeforeRegex)
            .replace("{AfterRegex}", AfterRegex)
            .replace("{SinceRegex}", SinceRegex);

    public static final String ModSuffixRegex = "\\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\\b"
            .replace("{AgoRegex}", AgoRegex)
            .replace("{LaterRegex}", LaterRegex)
            .replace("{BeforeAfterRegex}", BeforeAfterRegex)
            .replace("{FutureSuffixRegex}", FutureSuffixRegex)
            .replace("{PastSuffixRegex}", PastSuffixRegex);

    public static final String InConnectorRegex = "\\b(in)\\b";

    public static final String SinceYearSuffixRegex = "(^\\s*{SinceRegex}(\\s*(the\\s+)?year\\s*)?{YearSuffix})"
            .replace("{SinceRegex}", SinceRegex)
            .replace("{YearSuffix}", YearSuffix);

    public static final String WithinNextPrefixRegex = "\\b(within(\\s+the)?(\\s+(?<next>{NextPrefixRegex}))?)\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex);

    public static final String TodayNowRegex = "\\b(today|now|current (date|time))\\b";

    public static final String MorningStartEndRegex = "(^(morning|{AmDescRegex}))|((morning|{AmDescRegex})$)"
            .replace("{AmDescRegex}", AmDescRegex);

    public static final String AfternoonStartEndRegex = "(^(afternoon|{PmDescRegex}))|((afternoon|{PmDescRegex})$)"
            .replace("{PmDescRegex}", PmDescRegex);

    public static final String EveningStartEndRegex = "(^(evening))|((evening)$)";

    public static final String NightStartEndRegex = "(^(over|to)?ni(ght|te))|((over|to)?ni(ght|te)$)";

    public static final String InexactNumberRegex = "\\b((a\\s+)?few|some|several|(?<NumTwoTerm>(a\\s+)?couple(\\s+of)?))\\b";

    public static final String InexactNumberUnitRegex = "({InexactNumberRegex})\\s+({DurationUnitRegex})"
            .replace("{InexactNumberRegex}", InexactNumberRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex);

    public static final String RelativeTimeUnitRegex = "(?:(?:(?:{NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+({TimeUnitRegex}))|((the|my))\\s+({RestrictedTimeUnitRegex}))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{TimeUnitRegex}", TimeUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String RelativeDurationUnitRegex = "(?:(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\\s+)({DurationUnitRegex}))|((the|my))\\s+({RestrictedTimeUnitRegex}))"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{DurationUnitRegex}", DurationUnitRegex)
            .replace("{RestrictedTimeUnitRegex}", RestrictedTimeUnitRegex);

    public static final String ReferenceDatePeriodRegex = "\\b{ReferencePrefixRegex}\\s+(?<duration>week(end)?|fortnight|month|year|decade)\\b"
            .replace("{ReferencePrefixRegex}", ReferencePrefixRegex);

    public static final String ConnectorRegex = "^(-|,|for|t|around|circa|@)$";

    public static final String FromToRegex = "(\\b(from).+(to|and|or)\\b.+)";

    public static final String SingleAmbiguousMonthRegex = "^(the\\s+)?(may|march)$";

    public static final String SingleAmbiguousTermsRegex = "^(the\\s+)?(day|week|month|year)$";

    public static final String UnspecificDatePeriodRegex = "^(week|fortnight|month|year)$";

    public static final String PrepositionSuffixRegex = "\\b(on|in|at|around|circa|from|to)$";

    public static final String FlexibleDayRegex = "(?<DayOfMonth>([A-Za-z]+\\s)?[A-Za-z\\d]+)";

    public static final String ForTheRegex = "\\b((((?<=\\bfor\\s+)the\\s+{FlexibleDayRegex})|((?<=\\bon\\s+)(the\\s+)?{FlexibleDayRegex}(?<=(st|nd|rd|th))))(?<end>\\s*(,|\\.(?!\\d)|!|\\?|$)))"
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayOfMonthRegex = "\\b{WeekDayRegex}\\s+(the\\s+{FlexibleDayRegex})\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{FlexibleDayRegex}", FlexibleDayRegex);

    public static final String WeekDayAndDayRegex = "\\b{WeekDayRegex}\\s+(?!(the)){DayRegex}(?!([-:]|(\\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\\b"
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DayRegex}", DayRegex)
            .replace("{AmDescRegex}", AmDescRegex)
            .replace("{PmDescRegex}", PmDescRegex)
            .replace("{OclockRegex}", OclockRegex);

    public static final String RestOfDateRegex = "\\b(rest|remaining)\\s+(of\\s+)?((the|my|this|current)\\s+)?(?<duration>week|fortnight|month|year|decade)\\b";

    public static final String RestOfDateTimeRegex = "\\b(rest|remaining)\\s+(of\\s+)?((the|my|this|current)\\s+)?(?<unit>day)\\b";

    public static final String AmbiguousRangeModifierPrefix = "(from)";

    public static final String NumberEndingPattern = "^(?:\\s+(?<meeting>meeting|appointment|conference|((skype|teams|zoom|facetime)\\s+)?call)\\s+to\\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})([\\.]?$|(\\.,|,|!|\\?)))"
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{HourRegex}", HourRegex);

    public static final String OneOnOneRegex = "\\b(1\\s*:\\s*1(?!\\d))|(one (on )?one|one\\s*-\\s*one|one\\s*:\\s*one)\\b";

    public static final String LaterEarlyPeriodRegex = "\\b(({PrefixPeriodRegex})\\s*\\b\\s*(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|({UnspecificEndOfRangeRegex}))\\b"
            .replace("{PrefixPeriodRegex}", PrefixPeriodRegex)
            .replace("{OneWordPeriodRegex}", OneWordPeriodRegex)
            .replace("{BaseDateTime.FourDigitYearRegex}", BaseDateTime.FourDigitYearRegex)
            .replace("{UnspecificEndOfRangeRegex}", UnspecificEndOfRangeRegex);

    public static final String WeekWithWeekDayRangeRegex = "\\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|this)\\s+week)((\\s+between\\s+{WeekDayRegex}\\s+and\\s+{WeekDayRegex})|(\\s+from\\s+{WeekDayRegex}\\s+to\\s+{WeekDayRegex})))\\b"
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{PreviousPrefixRegex}", PreviousPrefixRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String GeneralEndingRegex = "^\\s*((\\.,)|\\.|,|!|\\?)?\\s*$";

    public static final String MiddlePauseRegex = "\\s*(,)\\s*";

    public static final String DurationConnectorRegex = "^\\s*(?<connector>\\s+|and|,)\\s*$";

    public static final String PrefixArticleRegex = "\\bthe\\s+";

    public static final String OrRegex = "\\s*((\\b|,\\s*)(or|and)\\b|,)\\s*";

    public static final String SpecialYearTermsRegex = "\\b((({SpecialYearPrefixes}\\s+)?year)|(cy|(?<special>fy|sy)))"
            .replace("{SpecialYearPrefixes}", SpecialYearPrefixes);

    public static final String YearPlusNumberRegex = "\\b({SpecialYearTermsRegex}\\s*((?<year>(\\d{2,4}))|{FullTextYearRegex}))\\b"
            .replace("{FullTextYearRegex}", FullTextYearRegex)
            .replace("{SpecialYearTermsRegex}", SpecialYearTermsRegex);

    public static final String NumberAsTimeRegex = "\\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{PeriodHourNumRegex}", PeriodHourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String TimeBeforeAfterRegex = "\\b(((?<=\\b(before|no later than|by|after)\\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\\b"
            .replace("{WrittenTimeRegex}", WrittenTimeRegex)
            .replace("{HourNumRegex}", HourNumRegex)
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex)
            .replace("{MidTimeRegex}", MidTimeRegex);

    public static final String DateNumberConnectorRegex = "^\\s*(?<connector>\\s+at)\\s*$";

    public static final String DecadeRegex = "(?<decade>(?:nough|twen|thir|fou?r|fif|six|seven|eigh|nine)ties|two\\s+thousands)";

    public static final String DecadeWithCenturyRegex = "(the\\s+)?(((?<century>\\d|1\\d|2\\d)?(')?(?<decade>\\d0)(')?(\\s)?s\\b)|(({CenturyRegex}(\\s+|-)(and\\s+)?)?{DecadeRegex})|({CenturyRegex}(\\s+|-)(and\\s+)?(?<decade>tens|hundreds)))"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{DecadeRegex}", DecadeRegex);

    public static final String RelativeDecadeRegex = "\\b((the\\s+)?{RelativeRegex}\\s+((?<number>[\\w,]+)\\s+)?decades?)\\b"
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String YearPeriodRegex = "((((from|during|in)\\s+)?{YearRegex}\\s*({TillRegex})\\s*{YearRegex})|(((between)\\s+){YearRegex}\\s*({RangeConnectorRegex})\\s*{YearRegex}))"
            .replace("{YearRegex}", YearRegex)
            .replace("{TillRegex}", TillRegex)
            .replace("{RangeConnectorRegex}", RangeConnectorRegex);

    public static final String StrictTillRegex = "(?<till>\\b(to|(un)?till?|thru|through)\\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*(h[1-2]|q[1-4])(?!(\\s+of|\\s*,\\s*))))"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String StrictRangeConnectorRegex = "(?<and>\\b(and|through|to)\\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\\s*(h[1-2]|q[1-4])(?!(\\s+of|\\s*,\\s*))))"
            .replace("{BaseDateTime.RangeConnectorSymbolRegex}", BaseDateTime.RangeConnectorSymbolRegex);

    public static final String StartMiddleEndRegex = "\\b((?<StartOf>((the\\s+)?(start|beginning)\\s+of\\s+)?)(?<MiddleOf>((the\\s+)?middle\\s+of\\s+)?)(?<EndOf>((the\\s+)?end\\s+of\\s+)?))";

    public static final String ComplexDatePeriodRegex = "(?:((from|during|in)\\s+)?{StartMiddleEndRegex}(?<start>.+)\\s*({StrictTillRegex})\\s*{StartMiddleEndRegex}(?<end>.+)|((between)\\s+){StartMiddleEndRegex}(?<start>.+)\\s*({StrictRangeConnectorRegex})\\s*{StartMiddleEndRegex}(?<end>.+))"
            .replace("{StrictTillRegex}", StrictTillRegex)
            .replace("{StrictRangeConnectorRegex}", StrictRangeConnectorRegex)
            .replace("{StartMiddleEndRegex}", StartMiddleEndRegex);

    public static final String FailFastRegex = "{BaseDateTime.DeltaMinuteRegex}|\\b(?:{BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex})|{BaseDateTime.BaseAmPmDescRegex}|\\b(?:zero|{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}|{WrittenMonthRegex}|{SeasonDescRegex}|{DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\\d(-|——)?ish|((the\\s+\\w*)|\\d)(th|rd|nd|st)|(mid\\s*(-\\s*)?)?(night|morning|afternoon|day)s?|evenings?|noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|minutes?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\\b|{WeekDayRegex}|{SetWeekDayRegex}|{NowRegex}|{PeriodicRegex}|\\b({DateUnitRegex}|{ImplicitDayRegex})"
            .replace("{BaseDateTime.DeltaMinuteRegex}", BaseDateTime.DeltaMinuteRegex)
            .replace("{BaseDateTime.BaseAmDescRegex}", BaseDateTime.BaseAmDescRegex)
            .replace("{BaseDateTime.BasePmDescRegex}", BaseDateTime.BasePmDescRegex)
            .replace("{BaseDateTime.BaseAmPmDescRegex}", BaseDateTime.BaseAmPmDescRegex)
            .replace("{ImplicitDayRegex}", ImplicitDayRegex)
            .replace("{DateUnitRegex}", DateUnitRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{SetWeekDayRegex}", SetWeekDayRegex)
            .replace("{NowRegex}", NowRegex)
            .replace("{PeriodicRegex}", PeriodicRegex)
            .replace("{DecadeRegex}", DecadeRegex)
            .replace("{SeasonDescRegex}", SeasonDescRegex)
            .replace("{WrittenMonthRegex}", WrittenMonthRegex)
            .replace("{WrittenTensRegex}", WrittenTensRegex)
            .replace("{WrittenElevenToNineteenRegex}", WrittenElevenToNineteenRegex)
            .replace("{WrittenOneToNineRegex}", WrittenOneToNineRegex);

    public static final String TasksModeSupressionRegexes = "({AmPmDescRegex}|{TasksModeSpecialDescRegex}|{TasksModeHolidayListSupression}|{DecadeRegex}|{DecadeWithCenturyRegex}|{QuarterRegex}|{QuarterRegexYearFront}|{AllHalfYearRegex}|{SeasonRegex})"
            .replace("{AmPmDescRegex}", AmPmDescRegex)
            .replace("{TasksModeSpecialDescRegex}", TasksModeSpecialDescRegex)
            .replace("{TasksModeHolidayListSupression}", TasksModeHolidayListSupression)
            .replace("{DecadeRegex}", DecadeRegex)
            .replace("{DecadeWithCenturyRegex}", DecadeWithCenturyRegex)
            .replace("{QuarterRegex}", QuarterRegex)
            .replace("{QuarterRegexYearFront}", QuarterRegexYearFront)
            .replace("{AllHalfYearRegex}", AllHalfYearRegex)
            .replace("{SeasonRegex}", SeasonRegex);

    public static final String TasksModeNextPrefix = "(?<next>next\\s+)";

    public static final String TasksModeDurationToDatePatterns = "\\b({TasksModeNextPrefix}((?<week>week)|(?<month>month)|(?<year>year)))\\b"
            .replace("{TasksModeNextPrefix}", TasksModeNextPrefix);

    public static final ImmutableMap<String, String> UnitMap = ImmutableMap.<String, String>builder()
        .put("decades", "10Y")
        .put("decade", "10Y")
        .put("years", "Y")
        .put("year", "Y")
        .put("y", "Y")
        .put("months", "MON")
        .put("month", "MON")
        .put("m", "M")
        .put("quarters", "3MON")
        .put("quarter", "3MON")
        .put("semesters", "6MON")
        .put("semestres", "6MON")
        .put("semester", "6MON")
        .put("semestre", "6MON")
        .put("weeks", "W")
        .put("week", "W")
        .put("w", "W")
        .put("weekends", "WE")
        .put("weekend", "WE")
        .put("fortnights", "2W")
        .put("fortnight", "2W")
        .put("weekdays", "D")
        .put("weekday", "D")
        .put("days", "D")
        .put("day", "D")
        .put("d", "D")
        .put("nights", "D")
        .put("night", "D")
        .put("hours", "H")
        .put("hour", "H")
        .put("hrs", "H")
        .put("hr", "H")
        .put("h", "H")
        .put("minutes", "M")
        .put("minute", "M")
        .put("mins", "M")
        .put("min", "M")
        .put("seconds", "S")
        .put("second", "S")
        .put("secs", "S")
        .put("sec", "S")
        .build();

    public static final ImmutableMap<String, Long> UnitValueMap = ImmutableMap.<String, Long>builder()
        .put("decades", 315360000L)
        .put("decade", 315360000L)
        .put("years", 31536000L)
        .put("year", 31536000L)
        .put("y", 31536000L)
        .put("months", 2592000L)
        .put("month", 2592000L)
        .put("m", 2592000L)
        .put("fortnights", 1209600L)
        .put("fortnight", 1209600L)
        .put("weekends", 172800L)
        .put("weekend", 172800L)
        .put("weeks", 604800L)
        .put("week", 604800L)
        .put("w", 604800L)
        .put("days", 86400L)
        .put("day", 86400L)
        .put("d", 86400L)
        .put("nights", 86400L)
        .put("night", 86400L)
        .put("hours", 3600L)
        .put("hour", 3600L)
        .put("hrs", 3600L)
        .put("hr", 3600L)
        .put("h", 3600L)
        .put("minutes", 60L)
        .put("minute", 60L)
        .put("mins", 60L)
        .put("min", 60L)
        .put("seconds", 1L)
        .put("second", 1L)
        .put("secs", 1L)
        .put("sec", 1L)
        .build();

    public static final ImmutableMap<String, String> SpecialYearPrefixesMap = ImmutableMap.<String, String>builder()
        .put("fiscal", "FY")
        .put("school", "SY")
        .put("fy", "FY")
        .put("sy", "SY")
        .build();

    public static final ImmutableMap<String, String> SeasonMap = ImmutableMap.<String, String>builder()
        .put("spring", "SP")
        .put("summer", "SU")
        .put("fall", "FA")
        .put("autumn", "FA")
        .put("winter", "WI")
        .build();

    public static final ImmutableMap<String, Integer> SeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> CardinalMap = ImmutableMap.<String, Integer>builder()
        .put("first", 1)
        .put("1st", 1)
        .put("second", 2)
        .put("2nd", 2)
        .put("third", 3)
        .put("3rd", 3)
        .put("fourth", 4)
        .put("4th", 4)
        .put("fifth", 5)
        .put("5th", 5)
        .put("sixth", 6)
        .put("6th", 6)
        .put("seventh", 7)
        .put("7th", 7)
        .put("eighth", 8)
        .put("8th", 8)
        .put("ninth", 9)
        .put("9th", 9)
        .put("tenth", 10)
        .put("10th", 10)
        .put("eleventh", 11)
        .put("11th", 11)
        .put("twelfth", 12)
        .put("12th", 12)
        .build();

    public static final ImmutableMap<String, Integer> DayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("monday", 1)
        .put("tuesday", 2)
        .put("wednesday", 3)
        .put("thursday", 4)
        .put("friday", 5)
        .put("saturday", 6)
        .put("sunday", 0)
        .put("mon", 1)
        .put("tue", 2)
        .put("tues", 2)
        .put("wed", 3)
        .put("wedn", 3)
        .put("weds", 3)
        .put("thu", 4)
        .put("thur", 4)
        .put("thurs", 4)
        .put("fri", 5)
        .put("sat", 6)
        .put("sun", 0)
        .build();

    public static final ImmutableMap<String, Integer> MonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("january", 1)
        .put("february", 2)
        .put("march", 3)
        .put("april", 4)
        .put("may", 5)
        .put("june", 6)
        .put("july", 7)
        .put("august", 8)
        .put("september", 9)
        .put("october", 10)
        .put("november", 11)
        .put("december", 12)
        .put("jan", 1)
        .put("feb", 2)
        .put("mar", 3)
        .put("apr", 4)
        .put("jun", 6)
        .put("jul", 7)
        .put("aug", 8)
        .put("sep", 9)
        .put("sept", 9)
        .put("oct", 10)
        .put("nov", 11)
        .put("dec", 12)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .build();

    public static final ImmutableMap<String, Integer> Numbers = ImmutableMap.<String, Integer>builder()
        .put("zero", 0)
        .put("one", 1)
        .put("a", 1)
        .put("an", 1)
        .put("two", 2)
        .put("three", 3)
        .put("four", 4)
        .put("five", 5)
        .put("six", 6)
        .put("seven", 7)
        .put("eight", 8)
        .put("nine", 9)
        .put("ten", 10)
        .put("eleven", 11)
        .put("twelve", 12)
        .put("thirteen", 13)
        .put("fourteen", 14)
        .put("fifteen", 15)
        .put("sixteen", 16)
        .put("seventeen", 17)
        .put("eighteen", 18)
        .put("nineteen", 19)
        .put("twenty", 20)
        .put("twenty one", 21)
        .put("twenty two", 22)
        .put("twenty three", 23)
        .put("twenty four", 24)
        .put("twenty five", 25)
        .put("twenty six", 26)
        .put("twenty seven", 27)
        .put("twenty eight", 28)
        .put("twenty nine", 29)
        .put("thirty", 30)
        .put("thirty one", 31)
        .put("thirty two", 32)
        .put("thirty three", 33)
        .put("thirty four", 34)
        .put("thirty five", 35)
        .put("thirty six", 36)
        .put("thirty seven", 37)
        .put("thirty eight", 38)
        .put("thirty nine", 39)
        .put("forty", 40)
        .put("forty one", 41)
        .put("forty two", 42)
        .put("forty three", 43)
        .put("forty four", 44)
        .put("forty five", 45)
        .put("forty six", 46)
        .put("forty seven", 47)
        .put("forty eight", 48)
        .put("forty nine", 49)
        .put("fifty", 50)
        .put("fifty one", 51)
        .put("fifty two", 52)
        .put("fifty three", 53)
        .put("fifty four", 54)
        .put("fifty five", 55)
        .put("fifty six", 56)
        .put("fifty seven", 57)
        .put("fifty eight", 58)
        .put("fifty nine", 59)
        .put("sixty", 60)
        .put("sixty one", 61)
        .put("sixty two", 62)
        .put("sixty three", 63)
        .put("sixty four", 64)
        .put("sixty five", 65)
        .put("sixty six", 66)
        .put("sixty seven", 67)
        .put("sixty eight", 68)
        .put("sixty nine", 69)
        .put("seventy", 70)
        .put("seventy one", 71)
        .put("seventy two", 72)
        .put("seventy three", 73)
        .put("seventy four", 74)
        .put("seventy five", 75)
        .put("seventy six", 76)
        .put("seventy seven", 77)
        .put("seventy eight", 78)
        .put("seventy nine", 79)
        .put("eighty", 80)
        .put("eighty one", 81)
        .put("eighty two", 82)
        .put("eighty three", 83)
        .put("eighty four", 84)
        .put("eighty five", 85)
        .put("eighty six", 86)
        .put("eighty seven", 87)
        .put("eighty eight", 88)
        .put("eighty nine", 89)
        .put("ninety", 90)
        .put("ninety one", 91)
        .put("ninety two", 92)
        .put("ninety three", 93)
        .put("ninety four", 94)
        .put("ninety five", 95)
        .put("ninety six", 96)
        .put("ninety seven", 97)
        .put("ninety eight", 98)
        .put("ninety nine", 99)
        .put("one hundred", 100)
        .build();

    public static final ImmutableMap<String, Integer> DayOfMonth = ImmutableMap.<String, Integer>builder()
        .put("1st", 1)
        .put("1th", 1)
        .put("2nd", 2)
        .put("2th", 2)
        .put("3rd", 3)
        .put("3th", 3)
        .put("4th", 4)
        .put("5th", 5)
        .put("6th", 6)
        .put("7th", 7)
        .put("8th", 8)
        .put("9th", 9)
        .put("10th", 10)
        .put("11th", 11)
        .put("11st", 11)
        .put("12th", 12)
        .put("12nd", 12)
        .put("13th", 13)
        .put("13rd", 13)
        .put("14th", 14)
        .put("15th", 15)
        .put("16th", 16)
        .put("17th", 17)
        .put("18th", 18)
        .put("19th", 19)
        .put("20th", 20)
        .put("21st", 21)
        .put("21th", 21)
        .put("22nd", 22)
        .put("22th", 22)
        .put("23rd", 23)
        .put("23th", 23)
        .put("24th", 24)
        .put("25th", 25)
        .put("26th", 26)
        .put("27th", 27)
        .put("28th", 28)
        .put("29th", 29)
        .put("30th", 30)
        .put("31st", 31)
        .put("01st", 1)
        .put("01th", 1)
        .put("02nd", 2)
        .put("02th", 2)
        .put("03rd", 3)
        .put("03th", 3)
        .put("04th", 4)
        .put("05th", 5)
        .put("06th", 6)
        .put("07th", 7)
        .put("08th", 8)
        .put("09th", 9)
        .build();

    public static final ImmutableMap<String, Double> DoubleNumbers = ImmutableMap.<String, Double>builder()
        .put("half", 0.5D)
        .put("quarter", 0.25D)
        .build();

    public static final ImmutableMap<String, String[]> HolidayNames = ImmutableMap.<String, String[]>builder()
        .put("easterday", new String[]{"easterday", "easter", "eastersunday"})
        .put("ashwednesday", new String[]{"ashwednesday"})
        .put("palmsunday", new String[]{"palmsunday"})
        .put("maundythursday", new String[]{"maundythursday"})
        .put("goodfriday", new String[]{"goodfriday"})
        .put("eastersaturday", new String[]{"eastersaturday"})
        .put("eastermonday", new String[]{"eastermonday"})
        .put("ascensionday", new String[]{"ascensionday"})
        .put("whitesunday", new String[]{"whitesunday", "pentecost", "pentecostday"})
        .put("whitemonday", new String[]{"whitemonday"})
        .put("trinitysunday", new String[]{"trinitysunday"})
        .put("corpuschristi", new String[]{"corpuschristi"})
        .put("earthday", new String[]{"earthday"})
        .put("fathers", new String[]{"fatherday", "fathersday"})
        .put("mothers", new String[]{"motherday", "mothersday"})
        .put("thanksgiving", new String[]{"thanksgivingday", "thanksgiving"})
        .put("blackfriday", new String[]{"blackfriday"})
        .put("cybermonday", new String[]{"cybermonday"})
        .put("martinlutherking", new String[]{"mlkday", "martinlutherkingday", "martinlutherkingjrday"})
        .put("washingtonsbirthday", new String[]{"washingtonsbirthday", "washingtonbirthday", "presidentsday"})
        .put("canberra", new String[]{"canberraday"})
        .put("labour", new String[]{"labourday", "laborday"})
        .put("columbus", new String[]{"columbusday"})
        .put("memorial", new String[]{"memorialday"})
        .put("yuandan", new String[]{"yuandan"})
        .put("maosbirthday", new String[]{"maosbirthday"})
        .put("teachersday", new String[]{"teachersday", "teacherday"})
        .put("singleday", new String[]{"singleday"})
        .put("allsaintsday", new String[]{"allsaintsday"})
        .put("youthday", new String[]{"youthday"})
        .put("childrenday", new String[]{"childrenday", "childday"})
        .put("femaleday", new String[]{"femaleday"})
        .put("treeplantingday", new String[]{"treeplantingday"})
        .put("arborday", new String[]{"arborday"})
        .put("girlsday", new String[]{"girlsday"})
        .put("whiteloverday", new String[]{"whiteloverday"})
        .put("loverday", new String[]{"loverday", "loversday"})
        .put("christmas", new String[]{"christmasday", "christmas"})
        .put("xmas", new String[]{"xmasday", "xmas"})
        .put("newyear", new String[]{"newyear"})
        .put("newyearday", new String[]{"newyearday"})
        .put("newyearsday", new String[]{"newyearsday"})
        .put("inaugurationday", new String[]{"inaugurationday"})
        .put("groundhougday", new String[]{"groundhougday"})
        .put("valentinesday", new String[]{"valentinesday"})
        .put("stpatrickday", new String[]{"stpatrickday", "stpatricksday", "stpatrick"})
        .put("aprilfools", new String[]{"aprilfools"})
        .put("stgeorgeday", new String[]{"stgeorgeday"})
        .put("mayday", new String[]{"mayday", "intlworkersday", "internationalworkersday", "workersday"})
        .put("cincodemayoday", new String[]{"cincodemayoday"})
        .put("baptisteday", new String[]{"baptisteday"})
        .put("usindependenceday", new String[]{"usindependenceday"})
        .put("independenceday", new String[]{"independenceday"})
        .put("bastilleday", new String[]{"bastilleday"})
        .put("halloweenday", new String[]{"halloweenday", "halloween"})
        .put("allhallowday", new String[]{"allhallowday"})
        .put("allsoulsday", new String[]{"allsoulsday"})
        .put("guyfawkesday", new String[]{"guyfawkesday"})
        .put("veteransday", new String[]{"veteransday"})
        .put("christmaseve", new String[]{"christmaseve"})
        .put("newyeareve", new String[]{"newyearseve", "newyeareve"})
        .put("juneteenth", new String[]{"juneteenth", "freedomday", "jubileeday"})
        .put("ramadan", new String[]{"ramadan", "ramazan", "ramzan", "ramadhan", "ramathan"})
        .put("sacrifice", new String[]{"eidaladha", "eidalazha", "eidulazha", "feastofthesacrifice"})
        .put("islamicnewyear", new String[]{"islamicnewyear", "hijrinewyear", "arabicnewyear"})
        .put("eidalfitr", new String[]{"eidalfitr", "festivalofbreakingthefast"})
        .build();

    public static final ImmutableMap<String, Integer> WrittenDecades = ImmutableMap.<String, Integer>builder()
        .put("hundreds", 0)
        .put("tens", 10)
        .put("twenties", 20)
        .put("thirties", 30)
        .put("forties", 40)
        .put("fifties", 50)
        .put("sixties", 60)
        .put("seventies", 70)
        .put("eighties", 80)
        .put("nineties", 90)
        .build();

    public static final ImmutableMap<String, Integer> SpecialDecadeCases = ImmutableMap.<String, Integer>builder()
        .put("noughties", 2000)
        .put("aughts", 2000)
        .put("two thousands", 2000)
        .build();

    public static final String DefaultLanguageFallback = "MDY";

    public static final List<String> SuperfluousWordList = Arrays.asList("preferably", "how about", "maybe", "perhaps", "say", "like");

    public static final List<String> DurationDateRestrictions = Arrays.asList("today", "now", "current date");

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("^\\d{4}$", "(\\d\\.\\d{4}|\\d{4}\\.\\d)")
        .put("^(morning|afternoon|evening|night|day)\\b", "\\b(good\\s+(morning|afternoon|evening|night|day))|(nighty\\s+night)\\b")
        .put("\\bnow\\b", "\\b(^now,)|\\b((is|are)\\s+now\\s+for|for\\s+now)\\b")
        .put("\\bmay$", "\\b((((!|\\.|\\?|,|;|)\\s+|^)may i)|(i|you|he|she|we|they)\\s+may|(may\\s+((((also|not|(also not)|well)\\s+)?(be|ask|contain|constitute|e-?mail|take|have|result|involve|get|work|reply|differ))|(or may not)))|(?<!(in|during|through)\\s+)may,? at (its|h(is|er)|y?our|my))\\b")
        .put("^(a|one) second$", "\\b(?<!an?\\s+)(a|one) second (round|time|wave|turn|chance|thought|opinion|cycle|take|meaning|life|job|home|hand|language|display|monitor|stimulus|dose|vaccination|shot|jab)\\b")
        .put("\\b(breakfast|brunch|lunch(time)?|dinner(time)?|supper)$", "(?<!\\b(at|before|after|around|circa)\\b\\s)(breakfast|brunch|lunch|dinner|supper)(?!\\s*time)")
        .put("^\\d+m$", "^\\d+m$")
        .put("^(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)$", "([$%£&!?@#])(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)|(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)([$%£&@#])")
        .put("^(to\\s+date)$", "\\b((equals?|up)\\s+to\\s+date)\\b")
        .put("^\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}")
        .put("^\\d{1,4}-\\d{1,4}-\\d{1,4}$", "\\d{1,4}-\\d{1,4}-\\d{1,4}-\\d|\\d-\\d{1,4}-\\d{1,4}-\\d{1,4}")
        .build();

    public static final ImmutableMap<String, String> AmbiguityTimeFiltersDict = ImmutableMap.<String, String>builder()
        .put("^(\\p{L}+|\\d{1,2})(\\s+(morning|afternoon|evening|night))?$", "\\b(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|\\d{1,2})\\s+(morning|afternoon|evening|night)\\b")
        .build();

    public static final ImmutableMap<String, String> AmbiguityDurationFiltersDict = ImmutableMap.<String, String>builder()
        .put("night$", "\\bnight(\\s*|-)(club|light|market|shift|work(er)?)s?\\b")
        .build();

    public static final List<String> MorningTermList = Arrays.asList("morning");

    public static final List<String> AfternoonTermList = Arrays.asList("afternoon");

    public static final List<String> EveningTermList = Arrays.asList("evening");

    public static final List<String> MealtimeBreakfastTermList = Arrays.asList("breakfast");

    public static final List<String> MealtimeBrunchTermList = Arrays.asList("brunch");

    public static final List<String> MealtimeLunchTermList = Arrays.asList("lunch", "lunchtime");

    public static final List<String> MealtimeDinnerTermList = Arrays.asList("dinner", "dinnertime", "supper");

    public static final List<String> DaytimeTermList = Arrays.asList("daytime");

    public static final List<String> NightTermList = Arrays.asList("night");

    public static final List<String> NighttimeTermList = Arrays.asList("nighttime", "night-time");

    public static final List<String> SameDayTerms = Arrays.asList("today", "current date", "otd");

    public static final List<String> PlusOneDayTerms = Arrays.asList("tomorrow", "tmr", "tmrw", "day after");

    public static final List<String> MinusOneDayTerms = Arrays.asList("yesterday", "day before");

    public static final List<String> PlusTwoDayTerms = Arrays.asList("day after tomorrow", "day after tmr", "day after tmrw");

    public static final List<String> MinusTwoDayTerms = Arrays.asList("day before yesterday");

    public static final List<String> FutureTerms = Arrays.asList("this", "next");

    public static final List<String> LastCardinalTerms = Arrays.asList("last");

    public static final List<String> MonthTerms = Arrays.asList("month");

    public static final List<String> MonthToDateTerms = Arrays.asList("month to date");

    public static final List<String> WeekendTerms = Arrays.asList("weekend");

    public static final List<String> WeekTerms = Arrays.asList("week");

    public static final List<String> FortnightTerms = Arrays.asList("fortnight", "fourtenight");

    public static final List<String> YearTerms = Arrays.asList("year");

    public static final List<String> GenericYearTerms = Arrays.asList("y");

    public static final List<String> YearToDateTerms = Arrays.asList("year to date");

    public static final String DoubleMultiplierRegex = "^(bi)(-|\\s)?";

    public static final String HalfMultiplierRegex = "^(semi)(-|\\s)?";

    public static final String DayTypeRegex = "((week)?da(il)?ys?)$";

    public static final String WeekTypeRegex = "(week(s|ly)?)$";

    public static final String WeekendTypeRegex = "(weekends?)$";

    public static final String MonthTypeRegex = "(month(s|ly)?)$";

    public static final String QuarterTypeRegex = "(quarter(s|ly)?)$";

    public static final String YearTypeRegex = "((years?|annual)(ly)?)$";
}
