// ------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

package com.microsoft.recognizers.text.datetime.resources;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import com.google.common.collect.ImmutableMap;

public class ChineseDateTime {

    public static final String LangMarker = "Chi";

    public static final String MonthRegex = "(?<month>正月|一月|二月|三月|四月|五月|六月|七月|八月|九月|十月|十一月|十二月|01月|02月|03月|04月|05月|06月|07月|08月|09月|10月|11月|12月|1月|2月|3月|4月|5月|6月|7月|8月|9月|大年(?!龄|纪|级))";

    public static final String DayRegex = "(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|1|2|3|4|5|6|7|8|9)";

    public static final String OneToNineIntegerRegex = "[一二三四五六七八九壹贰叁肆伍陆柒捌玖]";

    public static final String DateDayRegexInCJK = "(?<day>(([12][0-9]|3[01]|[1-9]|[三叁][十拾][一壹]?|[二贰貳]?[十拾]({OneToNineIntegerRegex})?|{OneToNineIntegerRegex})[日号]|初一|三十))"
            .replace("{OneToNineIntegerRegex}", OneToNineIntegerRegex);

    public static final String DayRegexNumInCJK = "(?<day>[12][0-9]|3[01]|[1-9]|[三叁][十拾][一壹]?|[二贰貳]?[十拾]({OneToNineIntegerRegex})?|{OneToNineIntegerRegex}|廿|卅)"
            .replace("{OneToNineIntegerRegex}", OneToNineIntegerRegex);

    public static final String MonthNumRegex = "(?<month>01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)";

    public static final String TwoNumYear = "50";

    public static final String YearNumRegex = "(?<year>((1[5-9]|20)\\d{2})|2100)";

    public static final String SimpleYearRegex = "(?<year>(\\d{2,4}))";

    public static final String ZeroToNineIntegerRegexCJK = "[一二三四五六七八九零壹贰叁肆伍陆柒捌玖〇两千俩倆仨]";

    public static final String DynastyStartYear = "元";

    public static final String RegionTitleRegex = "(贞观|开元|神龙|洪武|建文|永乐|景泰|天顺|成化|嘉靖|万历|崇祯|顺治|康熙|雍正|乾隆|嘉庆|道光|咸丰|同治|光绪|宣统|民国)";

    public static final String DynastyYearRegex = "(?<dynasty>{RegionTitleRegex})(?<biasYear>({DynastyStartYear}|\\d{1,3}|[十拾]?({ZeroToNineIntegerRegexCJK}[十百拾佰]?){0,3}))"
            .replace("{RegionTitleRegex}", RegionTitleRegex)
            .replace("{DynastyStartYear}", DynastyStartYear)
            .replace("{ZeroToNineIntegerRegexCJK}", ZeroToNineIntegerRegexCJK);

    public static final String DateYearInCJKRegex = "(?<yearCJK>({ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}|{ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}|{ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}{ZeroToNineIntegerRegexCJK}|{DynastyYearRegex}))"
            .replace("{ZeroToNineIntegerRegexCJK}", ZeroToNineIntegerRegexCJK)
            .replace("{DynastyYearRegex}", DynastyYearRegex);

    public static final String WeekDayRegex = "(?<weekday>周日|周天|周一|周二|周三|周四|周五|周六|星期一|星期二|星期三|星期四|星期五|星期六|星期日|星期天|礼拜一|礼拜二|礼拜三|礼拜四|礼拜五|礼拜六|礼拜日|礼拜天|禮拜一|禮拜二|禮拜三|禮拜四|禮拜五|禮拜六|禮拜日|禮拜天|週日|週天|週一|週二|週三|週四|週五|週六)";

    public static final String WeekDayStartEnd = "^[.]";

    public static final String LunarRegex = "(农历|初一|正月|大年(?!龄|纪|级))";

    public static final String DateThisRegex = "(这个|这一个|这|这一|本){WeekDayRegex}"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateLastRegex = "(上一个|上个|上一|上|最后一个|最后)(的)?{WeekDayRegex}"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateNextRegex = "(下一个|下个|下一|下)(的)?{WeekDayRegex}"
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekWithWeekDayRangeRegex = "^[.]";

    public static final String WoMLastRegex = "最后一";

    public static final String WoMPreviousRegex = "上个";

    public static final String WoMNextRegex = "下个";

    public static final String SpecialMonthRegex = "^[.]";

    public static final String SpecialYearRegex = "^[.]";

    public static final String MonthDayRange = "^[.]";

    public static final String SpecialDayRegex = "(最近|前天|后天|昨天|明天|今天|今日|明日|昨日|大后天|大前天|後天|大後天)";

    public static final String SpecialDayWithNumRegex = "^[.]";

    public static final String WeekDayOfMonthRegex = "((({MonthRegex}|{MonthNumRegex})的\\s*)(?<cardinal>第一个|第二个|第三个|第四个|第五个|最后一个)\\s*{WeekDayRegex})"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String WeekDayAndDayRegex = "^[.]";

    public static final String ThisPrefixRegex = "这个|这一个|这|这一|本|今";

    public static final String LastPrefixRegex = "上个|上一个|上|上一|去";

    public static final String NextPrefixRegex = "下个|下一个|下|下一|明";

    public static final String RelativeRegex = "(?<order>({ThisPrefixRegex}|{LastPrefixRegex}|{NextPrefixRegex}))"
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{LastPrefixRegex}", LastPrefixRegex)
            .replace("{NextPrefixRegex}", NextPrefixRegex);

    public static final String SpecialDate = "(?<thisyear>({ThisPrefixRegex}|{LastPrefixRegex}|{NextPrefixRegex})年)?(?<thismonth>({ThisPrefixRegex}|{LastPrefixRegex}|{NextPrefixRegex})月)?{DateDayRegexInCJK}"
            .replace("{ThisPrefixRegex}", ThisPrefixRegex)
            .replace("{LastPrefixRegex}", LastPrefixRegex)
            .replace("{NextPrefixRegex}", NextPrefixRegex)
            .replace("{DateDayRegexInCJK}", DateDayRegexInCJK);

    public static final String DateUnitRegex = "(?<unit>年|个月|周|週|日|天)";

    public static final String BeforeRegex = "以前|之前|前";

    public static final String AfterRegex = "以后|以後|之后|之後|后|後|还剩";

    public static final String TimePeriodLeftRegex = "还剩";

    public static final String DateRegexList1 = "({LunarRegex}(\\s*))?((({SimpleYearRegex}|{DateYearInCJKRegex})年)(\\s*))?{MonthRegex}(\\s*){DateDayRegexInCJK}((\\s*|,|，){WeekDayRegex})?"
            .replace("{LunarRegex}", LunarRegex)
            .replace("{SimpleYearRegex}", SimpleYearRegex)
            .replace("{DateYearInCJKRegex}", DateYearInCJKRegex)
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DateDayRegexInCJK}", DateDayRegexInCJK)
            .replace("{WeekDayRegex}", WeekDayRegex);

    public static final String DateRegexList2 = "((({SimpleYearRegex}|{DateYearInCJKRegex})年)(\\s*))?({LunarRegex}(\\s*))?{MonthRegex}(\\s*){DateDayRegexInCJK}((\\s*|,|，){WeekDayRegex})?"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DateDayRegexInCJK}", DateDayRegexInCJK)
            .replace("{SimpleYearRegex}", SimpleYearRegex)
            .replace("{LunarRegex}", LunarRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DateYearInCJKRegex}", DateYearInCJKRegex);

    public static final String DateRegexList3 = "((({SimpleYearRegex}|{DateYearInCJKRegex})年)(\\s*))?({LunarRegex}(\\s*))?{MonthRegex}(\\s*)({DayRegexNumInCJK}|{DayRegex})((\\s*|,|，){WeekDayRegex})?"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DayRegexNumInCJK}", DayRegexNumInCJK)
            .replace("{SimpleYearRegex}", SimpleYearRegex)
            .replace("{LunarRegex}", LunarRegex)
            .replace("{WeekDayRegex}", WeekDayRegex)
            .replace("{DateYearInCJKRegex}", DateYearInCJKRegex)
            .replace("{DayRegex}", DayRegex);

    public static final String DateRegexList4 = "{MonthNumRegex}\\s*/\\s*{DayRegex}"
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex);

    public static final String DateRegexList5 = "{DayRegex}\\s*/\\s*{MonthNumRegex}"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String DateRegexList6 = "{MonthNumRegex}\\s*[/\\\\\\-]\\s*{DayRegex}\\s*[/\\\\\\-]\\s*{SimpleYearRegex}"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{SimpleYearRegex}", SimpleYearRegex);

    public static final String DateRegexList7 = "{DayRegex}\\s*[/\\\\\\-\\.]\\s*{MonthNumRegex}\\s*[/\\\\\\-\\.]\\s*{SimpleYearRegex}"
            .replace("{DayRegex}", DayRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{SimpleYearRegex}", SimpleYearRegex);

    public static final String DateRegexList8 = "{SimpleYearRegex}\\s*[/\\\\\\-\\. ]\\s*{MonthNumRegex}\\s*[/\\\\\\-\\. ]\\s*{DayRegex}"
            .replace("{SimpleYearRegex}", SimpleYearRegex)
            .replace("{MonthNumRegex}", MonthNumRegex)
            .replace("{DayRegex}", DayRegex);

    public static final String DatePeriodTillRegex = "(?<till>到|至|--|-|—|——|~|–)";

    public static final String DatePeriodRangeSuffixRegex = "^\\b$";

    public static final String DatePeriodRangePrefixRegex = "从";

    public static final String DatePeriodTillSuffixRequiredRegex = "(?<till>与|和)";

    public static final String DatePeriodDayRegexInCJK = "(?<day>初一|三十|一日|十一日|二十一日|三十一日|二日|三日|四日|五日|六日|七日|八日|九日|十二日|十三日|十四日|十五日|十六日|十七日|十八日|十九日|二十二日|二十三日|二十四日|二十五日|二十六日|二十七日|二十八日|二十九日|一日|十一日|十日|二十一日|二十日|三十一日|三十日|二日|三日|四日|五日|六日|七日|八日|九日|十二日|十三日|十四日|十五日|十六日|十七日|十八日|十九日|二十二日|二十三日|二十四日|二十五日|二十六日|二十七日|二十八日|二十九日|十日|二十日|三十日|10日|11日|12日|13日|14日|15日|16日|17日|18日|19日|1日|20日|21日|22日|23日|24日|25日|26日|27日|28日|29日|2日|30日|31日|3日|4日|5日|6日|7日|8日|9日|一号|十一号|二十一号|三十一号|二号|三号|四号|五号|六号|七号|八号|九号|十二号|十三号|十四号|十五号|十六号|十七号|十八号|十九号|二十二号|二十三号|二十四号|二十五号|二十六号|二十七号|二十八号|二十九号|一号|十一号|十号|二十一号|二十号|三十一号|三十号|二号|三号|四号|五号|六号|七号|八号|九号|十二号|十三号|十四号|十五号|十六号|十七号|十八号|十九号|二十二号|二十三号|二十四号|二十五号|二十六号|二十七号|二十八号|二十九号|十号|二十号|三十号|10号|11号|12号|13号|14号|15号|16号|17号|18号|19号|1号|20号|21号|22号|23号|24号|25号|26号|27号|28号|29号|2号|30号|31号|3号|4号|5号|6号|7号|8号|9号|一|十一|二十一|三十一|二|三|四|五|六|七|八|九|十二|十三|十四|十五|十六|十七|十八|十九|二十二|二十三|二十四|二十五|二十六|二十七|二十八|二十九|一|十一|十|二十一|二十|三十一|三十|二|三|四|五|六|七|八|九|十二|十三|十四|十五|十六|十七|十八|十九|二十二|二十三|二十四|二十五|二十六|二十七|二十八|二十九|十|二十|三十|廿|卅)";

    public static final String DatePeriodThisRegex = "这个|这一个|这|这一|本";

    public static final String DatePeriodLastRegex = "上个|上一个|上|上一";

    public static final String DatePeriodNextRegex = "下个|下一个|下|下一";

    public static final String RelativeMonthRegex = "(?<relmonth>({DatePeriodThisRegex}|{DatePeriodLastRegex}|{DatePeriodNextRegex})\\s*月)"
            .replace("{DatePeriodThisRegex}", DatePeriodThisRegex)
            .replace("{DatePeriodLastRegex}", DatePeriodLastRegex)
            .replace("{DatePeriodNextRegex}", DatePeriodNextRegex);

    public static final String HalfYearRegex = "((?<firstHalf>(上|前)半年)|(?<secondHalf>(下|后)半年))";

    public static final String YearRegex = "(({YearNumRegex})(\\s*年)?|({SimpleYearRegex})\\s*年){HalfYearRegex}?"
            .replace("{YearNumRegex}", YearNumRegex)
            .replace("{SimpleYearRegex}", SimpleYearRegex)
            .replace("{HalfYearRegex}", HalfYearRegex);

    public static final String StrictYearRegex = "({YearRegex}(?=[\\u4E00-\\u9FFF]|\\s|$|\\W))"
            .replace("{YearRegex}", YearRegex);

    public static final String YearRegexInNumber = "(?<year>(\\d{4}))";

    public static final String DatePeriodYearInCJKRegex = "{DateYearInCJKRegex}年{HalfYearRegex}?"
            .replace("{DateYearInCJKRegex}", DateYearInCJKRegex)
            .replace("{HalfYearRegex}", HalfYearRegex);

    public static final String MonthSuffixRegex = "(?<msuf>({RelativeMonthRegex}|{MonthRegex}))"
            .replace("{RelativeMonthRegex}", RelativeMonthRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String SimpleCasesRegex = "((从)\\s*)?(({YearRegex}|{DatePeriodYearInCJKRegex})\\s*)?{MonthSuffixRegex}({DatePeriodDayRegexInCJK}|{DayRegex})\\s*{DatePeriodTillRegex}\\s*({DatePeriodDayRegexInCJK}|{DayRegex})((\\s+|\\s*,\\s*){YearRegex})?"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex)
            .replace("{MonthSuffixRegex}", MonthSuffixRegex)
            .replace("{DatePeriodDayRegexInCJK}", DatePeriodDayRegexInCJK)
            .replace("{DayRegex}", DayRegex)
            .replace("{DatePeriodTillRegex}", DatePeriodTillRegex);

    public static final String YearAndMonth = "({DatePeriodYearInCJKRegex}|{YearRegex}|(?<yearrel>明年|今年|去年))\\s*({MonthRegex}|的?(?<cardinal>第一|第二|第三|第四|第五|第六|第七|第八|第九|第十|第十一|第十二|最后一)\\s*个月\\s*)"
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{MonthRegex}", MonthRegex);

    public static final String SimpleYearAndMonth = "({YearNumRegex}[/\\\\\\-]{MonthNumRegex}\\b$)"
            .replace("{YearNumRegex}", YearNumRegex)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String PureNumYearAndMonth = "({YearRegexInNumber}\\s*[-\\.\\/]\\s*{MonthNumRegex})|({MonthNumRegex}\\s*\\/\\s*{YearRegexInNumber})"
            .replace("{YearRegexInNumber}", YearRegexInNumber)
            .replace("{MonthNumRegex}", MonthNumRegex);

    public static final String OneWordPeriodRegex = "(((?<yearrel>(明|今|去)年)\\s*)?{MonthRegex}|({DatePeriodThisRegex}|{DatePeriodLastRegex}|{DatePeriodNextRegex})(?<halfTag>半)?\\s*(周末|周|月|年)|周末|(今|明|去|前|后)年(\\s*{HalfYearRegex})?)"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DatePeriodThisRegex}", DatePeriodThisRegex)
            .replace("{DatePeriodLastRegex}", DatePeriodLastRegex)
            .replace("{DatePeriodNextRegex}", DatePeriodNextRegex)
            .replace("{HalfYearRegex}", HalfYearRegex);

    public static final String LaterEarlyPeriodRegex = "^[.]";

    public static final String DatePointWithAgoAndLater = "^[.]";

    public static final String WeekOfMonthRegex = "(?<wom>{MonthSuffixRegex}的(?<cardinal>第一|第二|第三|第四|第五|最后一)\\s*周\\s*)"
            .replace("{MonthSuffixRegex}", MonthSuffixRegex);

    public static final String WeekOfYearRegex = "(?<woy>({YearRegex}|{RelativeRegex}年)的(?<cardinal>第一|第二|第三|第四|第五|最后一)\\s*周\\s*)"
            .replace("{YearRegex}", YearRegex)
            .replace("{RelativeRegex}", RelativeRegex);

    public static final String WeekOfDateRegex = "^[.]";

    public static final String MonthOfDateRegex = "^[.]";

    public static final String RestOfDateRegex = "^[.]";

    public static final String UnitRegex = "(?<unit>年|(?<uoy>(个)?月|周|週|日|天))";

    public static final String FollowedUnit = "^\\s*{UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String NumberCombinedWithUnit = "(?<num>\\d+(\\.\\d*)?){UnitRegex}"
            .replace("{UnitRegex}", UnitRegex);

    public static final String DateRangePrepositions = "((从|在|自)\\s*)?";

    public static final String YearToYear = "({DateRangePrepositions})({DatePeriodYearInCJKRegex}|{YearRegex})\\s*({DatePeriodTillRegex}|后|後|之后|之後)\\s*({DatePeriodYearInCJKRegex}|{YearRegex})(\\s*((之间|之内|期间|中间|间)|前|之前))?"
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodTillRegex}", DatePeriodTillRegex)
            .replace("{DateRangePrepositions}", DateRangePrepositions);

    public static final String YearToYearSuffixRequired = "({DateRangePrepositions})({DatePeriodYearInCJKRegex}|{YearRegex})\\s*({DatePeriodTillSuffixRequiredRegex})\\s*({DatePeriodYearInCJKRegex}|{YearRegex})\\s*(之间|之内|期间|中间|间)"
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex)
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodTillSuffixRequiredRegex}", DatePeriodTillSuffixRequiredRegex)
            .replace("{DateRangePrepositions}", DateRangePrepositions);

    public static final String MonthToMonth = "({DateRangePrepositions})({MonthRegex}){DatePeriodTillRegex}({MonthRegex})"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DatePeriodTillRegex}", DatePeriodTillRegex)
            .replace("{DateRangePrepositions}", DateRangePrepositions);

    public static final String MonthToMonthSuffixRequired = "({DateRangePrepositions})({MonthRegex}){DatePeriodTillSuffixRequiredRegex}({MonthRegex})\\s*(之间|之内|期间|中间|间)"
            .replace("{MonthRegex}", MonthRegex)
            .replace("{DatePeriodTillSuffixRequiredRegex}", DatePeriodTillSuffixRequiredRegex)
            .replace("{DateRangePrepositions}", DateRangePrepositions);

    public static final String DayToDay = "^[.]";

    public static final String DayRegexForPeriod = "^[.]";

    public static final String FirstLastOfYearRegex = "(({DatePeriodYearInCJKRegex}|{YearRegex}|(?<yearrel>明年|今年|去年))的?)((?<first>前)|(?<last>(最后|最後)))"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex);

    public static final String ComplexDatePeriodRegex = "^[.]";

    public static final String PastRegex = "(?<past>(之前|前|上|近|过去))";

    public static final String FutureRegex = "(?<future>(之后|之後|后|後|(?<![一两几]\\s*)下|未来(的)?))";

    public static final String SeasonRegex = "(?<season>春|夏|秋|冬)(天|季)?";

    public static final String WhichWeekRegex = "^[.]";

    public static final String SeasonWithYear = "(({YearRegex}|{DatePeriodYearInCJKRegex}|(?<yearrel>明年|今年|去年))(的)?)?{SeasonRegex}"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex)
            .replace("{SeasonRegex}", SeasonRegex);

    public static final String QuarterRegex = "(({YearRegex}|{DatePeriodYearInCJKRegex}|(?<yearrel>明年|今年|去年))(的)?)?(第(?<cardinal>1|2|3|4|一|二|三|四)季度)"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex);

    public static final String CenturyNumRegex = "^[.]";

    public static final String CenturyRegex = "(?<century>\\d|1\\d|2\\d)世纪";

    public static final String CenturyRegexInCJK = "(?<century>一|二|三|四|五|六|七|八|九|十|十一|十二|十三|十四|十五|十六|十七|十八|十九|二十|二十一|二十二)世纪";

    public static final String RelativeCenturyRegex = "(?<relcentury>({DatePeriodLastRegex}|{DatePeriodThisRegex}|{DatePeriodNextRegex}))世纪"
            .replace("{DatePeriodLastRegex}", DatePeriodLastRegex)
            .replace("{DatePeriodThisRegex}", DatePeriodThisRegex)
            .replace("{DatePeriodNextRegex}", DatePeriodNextRegex);

    public static final String DecadeRegexInCJK = "(?<decade>十|一十|二十|三十|四十|五十|六十|七十|八十|九十)";

    public static final String DecadeRegex = "(?<centurysuf>({CenturyRegex}|{CenturyRegexInCJK}|{RelativeCenturyRegex}))?(?<decade>(\\d0|{DecadeRegexInCJK}))年代"
            .replace("{CenturyRegex}", CenturyRegex)
            .replace("{CenturyRegexInCJK}", CenturyRegexInCJK)
            .replace("{RelativeCenturyRegex}", RelativeCenturyRegex)
            .replace("{DecadeRegexInCJK}", DecadeRegexInCJK);

    public static final String PrepositionRegex = "(?<prep>^的|在$)";

    public static final String NowRegex = "(?<now>现在|马上|立刻|刚刚才|刚刚|刚才|这会儿|当下|此刻)";

    public static final String NightRegex = "(?<night>早|晚)";

    public static final String TimeOfSpecialDayRegex = "(今晚|今早|今晨|明晚|明早|明晨|昨晚)(的|在)?";

    public static final String DateTimePeriodTillRegex = "(?<till>到|直到|--|-|—|——)";

    public static final String DateTimePeriodPrepositionRegex = "(?<prep>^\\s*的|在\\s*$)";

    public static final String BeforeAfterRegex = "^\\b$";

    public static final String HourRegex = "\\b{BaseDateTime.HourRegex}"
            .replace("{BaseDateTime.HourRegex}", BaseDateTime.HourRegex);

    public static final String HourNumRegex = "(?<hour>[零〇一二两三四五六七八九]|二十[一二三四]?|十[一二三四五六七八九]?)";

    public static final String ZhijianRegex = "^\\s*(之间|之内|期间|中间|间)";

    public static final String DateTimePeriodThisRegex = "这个|这一个|这|这一";

    public static final String DateTimePeriodLastRegex = "上个|上一个|上|上一";

    public static final String DateTimePeriodNextRegex = "下个|下一个|下|下一";

    public static final String AmPmDescRegex = "(?<daydesc>(am|a\\.m\\.|a m|a\\. m\\.|a\\.m|a\\. m|a m|pm|p\\.m\\.|p m|p\\. m\\.|p\\.m|p\\. m|p m|上午|中午|下午|午后|晚上|夜里|夜晚|夜间|深夜|傍晚|晚|早间?))";

    public static final String TimeOfDayRegex = "(?<timeOfDay>凌晨|清晨|早上|早间|早|上午|中午|下午|午后|晚上|夜里|夜晚|半夜|夜间|深夜|傍晚|晚)";

    public static final String SpecificTimeOfDayRegex = "((({DateTimePeriodThisRegex}|{DateTimePeriodNextRegex}|{DateTimePeriodLastRegex})\\s+{TimeOfDayRegex})|(今晚|今早|今晨|明晚|明早|明晨|昨晚))"
            .replace("{DateTimePeriodThisRegex}", DateTimePeriodThisRegex)
            .replace("{DateTimePeriodNextRegex}", DateTimePeriodNextRegex)
            .replace("{DateTimePeriodLastRegex}", DateTimePeriodLastRegex)
            .replace("{TimeOfDayRegex}", TimeOfDayRegex);

    public static final String DateTimePeriodUnitRegex = "(个)?(?<unit>(小时|钟头|分钟|秒钟|时|分|秒))";

    public static final String DateTimePeriodFollowedUnit = "^\\s*{DateTimePeriodUnitRegex}"
            .replace("{DateTimePeriodUnitRegex}", DateTimePeriodUnitRegex);

    public static final String DateTimePeriodNumberCombinedWithUnit = "\\b(?<num>\\d+(\\.\\d*)?){DateTimePeriodUnitRegex}"
            .replace("{DateTimePeriodUnitRegex}", DateTimePeriodUnitRegex);

    public static final String DurationAllRegex = "^[.]";

    public static final String DurationHalfRegex = "^[.]";

    public static final String DurationRelativeDurationUnitRegex = "^[.]";

    public static final String AgoLaterRegex = "^[.]";

    public static final String DurationDuringRegex = "^[.]";

    public static final String DurationSomeRegex = "^[.]";

    public static final String DurationMoreOrLessRegex = "^[.]";

    public static final String DurationYearRegex = "((\\d{3,4})|0\\d|两千)\\s*年";

    public static final String DurationHalfSuffixRegex = "半";

    public static final ImmutableMap<String, String> DurationSuffixList = ImmutableMap.<String, String>builder()
        .put("M", "分钟")
        .put("S", "秒钟|秒")
        .put("H", "个小时|小时|个钟头|钟头|时")
        .put("D", "天")
        .put("W", "星期|个星期|周|週")
        .put("Mon", "个月")
        .put("Y", "年")
        .build();

    public static final List<String> DurationAmbiguousUnits = Arrays.asList("分钟", "秒钟", "秒", "个小时", "小时", "天", "星期", "个星期", "周", "週", "个月", "年", "时");

    public static final String DurationUnitRegex = "(?<unit>{DateUnitRegex}|分钟?|秒钟?|个?小时|时|个?钟头|天|个?星期|周|週|个?月|年)"
            .replace("{DateUnitRegex}", DateUnitRegex);

    public static final String AnUnitRegex = "^[.]";

    public static final String DurationConnectorRegex = "^\\s*(?<connector>[多又余零]?)\\s*$";

    public static final String ConnectorRegex = "^\\s*,\\s*$";

    public static final String LunarHolidayRegex = "(({YearRegex}|{DatePeriodYearInCJKRegex}|(?<yearrel>明年|今年|去年))(的)?)?(?<holiday>除夕|春节|中秋节|中秋|元宵节|端午节|端午|重阳节)"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex);

    public static final String HolidayRegexList1 = "(({YearRegex}|{DatePeriodYearInCJKRegex}|(?<yearrel>明年|今年|去年))(的)?)?(?<holiday>新年|五一|劳动节|元旦节|元旦|愚人节|平安夜|圣诞节|植树节|国庆节|情人节|教师节|儿童节|妇女节|青年节|建军节|女生节|光棍节|双十一|清明节|清明)"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex);

    public static final String HolidayRegexList2 = "(({YearRegex}|{DatePeriodYearInCJKRegex}|(?<yearrel>明年|今年|去年))(的)?)?(?<holiday>母亲节|父亲节|感恩节|万圣节)"
            .replace("{YearRegex}", YearRegex)
            .replace("{DatePeriodYearInCJKRegex}", DatePeriodYearInCJKRegex);

    public static final String SetUnitRegex = "(?<unit>年|月|周|星期|日|天|小时|时|分钟|分|秒钟|秒)";

    public static final String SetEachUnitRegex = "(?<each>(每个|每一|每)\\s*{SetUnitRegex})"
            .replace("{SetUnitRegex}", SetUnitRegex);

    public static final String SetEachPrefixRegex = "(?<each>(每)\\s*$)";

    public static final String SetEachSuffixRegex = "^[.]";

    public static final String SetLastRegex = "(?<last>last|this|next)";

    public static final String SetEachDayRegex = "(每|每一)(天|日)\\s*$";

    public static final String SetEachDateUnitRegex = "^[.]";

    public static final String TimeHourNumRegex = "(00|01|02|03|04|05|06|07|08|09|0|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|1|2|3|4|5|6|7|8|9)";

    public static final String TimeMinuteNumRegex = "(00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59|0|1|2|3|4|5|6|7|8|9)";

    public static final String TimeSecondNumRegex = "(00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59|0|1|2|3|4|5|6|7|8|9)";

    public static final String TimeHourCJKRegex = "([零〇一二两三四五六七八九]|二十[一二三四]?|十[一二三四五六七八九]?)";

    public static final String TimeMinuteCJKRegex = "([二三四五]?十[一二三四五六七八九]?|六十|[零〇一二三四五六七八九])";

    public static final String TimeSecondCJKRegex = "{TimeMinuteCJKRegex}"
            .replace("{TimeMinuteCJKRegex}", TimeMinuteCJKRegex);

    public static final String TimeClockDescRegex = "(点\\s*整|点\\s*钟|点|时)";

    public static final String TimeMinuteDescRegex = "(分钟|分|)";

    public static final String TimeSecondDescRegex = "(秒钟|秒)";

    public static final String TimeBanHourPrefixRegex = "(第)";

    public static final String TimeHourRegex = "(?<!{TimeBanHourPrefixRegex})(?<hour>{TimeHourCJKRegex}|{TimeHourNumRegex}){TimeClockDescRegex}"
            .replace("{TimeBanHourPrefixRegex}", TimeBanHourPrefixRegex)
            .replace("{TimeHourCJKRegex}", TimeHourCJKRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{TimeClockDescRegex}", TimeClockDescRegex);

    public static final String TimeMinuteRegex = "(?<min>{TimeMinuteCJKRegex}|{TimeMinuteNumRegex}){TimeMinuteDescRegex}"
            .replace("{TimeMinuteCJKRegex}", TimeMinuteCJKRegex)
            .replace("{TimeMinuteNumRegex}", TimeMinuteNumRegex)
            .replace("{TimeMinuteDescRegex}", TimeMinuteDescRegex);

    public static final String TimeSecondRegex = "(?<sec>{TimeSecondCJKRegex}|{TimeSecondNumRegex}){TimeSecondDescRegex}"
            .replace("{TimeSecondCJKRegex}", TimeSecondCJKRegex)
            .replace("{TimeSecondNumRegex}", TimeSecondNumRegex)
            .replace("{TimeSecondDescRegex}", TimeSecondDescRegex);

    public static final String TimeHalfRegex = "(?<half>过半|半)";

    public static final String TimeQuarterRegex = "(?<quarter>[一两二三四1-4])\\s*(刻钟|刻)";

    public static final String TimeCJKTimeRegex = "{TimeHourRegex}({TimeQuarterRegex}|{TimeHalfRegex}|((过|又)?{TimeMinuteRegex})({TimeSecondRegex})?)?"
            .replace("{TimeHourRegex}", TimeHourRegex)
            .replace("{TimeQuarterRegex}", TimeQuarterRegex)
            .replace("{TimeHalfRegex}", TimeHalfRegex)
            .replace("{TimeMinuteRegex}", TimeMinuteRegex)
            .replace("{TimeSecondRegex}", TimeSecondRegex);

    public static final String TimeDigitTimeRegex = "(?<hour>{TimeHourNumRegex}):(?<min>{TimeMinuteNumRegex})(:(?<sec>{TimeSecondNumRegex}))?"
            .replace("{TimeHourNumRegex}", TimeHourNumRegex)
            .replace("{TimeMinuteNumRegex}", TimeMinuteNumRegex)
            .replace("{TimeSecondNumRegex}", TimeSecondNumRegex);

    public static final String TimeDayDescRegex = "(?<daydesc>凌晨|清晨|早上|早间|早|上午|中午|下午|午后|晚上|夜里|夜晚|半夜|午夜|夜间|深夜|傍晚|晚)";

    public static final String TimeApproximateDescPreffixRegex = "(大[约概]|差不多|可能|也许|约|不超过|不多[于过]|最[多长少]|少于|[超短长多]过|几乎要|将近|差点|快要|接近|至少|起码|超出|不到)";

    public static final String TimeApproximateDescSuffixRegex = "(左右)";

    public static final String TimeRegexes1 = "{TimeApproximateDescPreffixRegex}?{TimeDayDescRegex}?{TimeCJKTimeRegex}{TimeApproximateDescSuffixRegex}?"
            .replace("{TimeApproximateDescPreffixRegex}", TimeApproximateDescPreffixRegex)
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeCJKTimeRegex}", TimeCJKTimeRegex)
            .replace("{TimeApproximateDescSuffixRegex}", TimeApproximateDescSuffixRegex);

    public static final String TimeRegexes2 = "{TimeApproximateDescPreffixRegex}?{TimeDayDescRegex}?{TimeDigitTimeRegex}{TimeApproximateDescSuffixRegex}?(\\s*{AmPmDescRegex}?)"
            .replace("{TimeApproximateDescPreffixRegex}", TimeApproximateDescPreffixRegex)
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeDigitTimeRegex}", TimeDigitTimeRegex)
            .replace("{TimeApproximateDescSuffixRegex}", TimeApproximateDescSuffixRegex)
            .replace("{AmPmDescRegex}", AmPmDescRegex);

    public static final String TimeRegexes3 = "差{TimeMinuteRegex}{TimeCJKTimeRegex}"
            .replace("{TimeMinuteRegex}", TimeMinuteRegex)
            .replace("{TimeCJKTimeRegex}", TimeCJKTimeRegex);

    public static final String TimePeriodTimePeriodConnectWords = "(起|至|到|–|-|—|~|～)";

    public static final String TimePeriodLeftCJKTimeRegex = "(从)?(?<left>{TimeDayDescRegex}?({TimeCJKTimeRegex}))"
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeCJKTimeRegex}", TimeCJKTimeRegex);

    public static final String TimePeriodRightCJKTimeRegex = "{TimePeriodTimePeriodConnectWords}(?<right>{TimeDayDescRegex}?{TimeCJKTimeRegex})(之间)?"
            .replace("{TimePeriodTimePeriodConnectWords}", TimePeriodTimePeriodConnectWords)
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeCJKTimeRegex}", TimeCJKTimeRegex);

    public static final String TimePeriodLeftDigitTimeRegex = "(从)?(?<left>{TimeDayDescRegex}?({TimeDigitTimeRegex}))"
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeDigitTimeRegex}", TimeDigitTimeRegex);

    public static final String TimePeriodRightDigitTimeRegex = "{TimePeriodTimePeriodConnectWords}(?<right>{TimeDayDescRegex}?{TimeDigitTimeRegex})(之间)?"
            .replace("{TimePeriodTimePeriodConnectWords}", TimePeriodTimePeriodConnectWords)
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeDigitTimeRegex}", TimeDigitTimeRegex);

    public static final String TimePeriodShortLeftCJKTimeRegex = "(从)?(?<left>{TimeDayDescRegex}?({TimeHourCJKRegex}))"
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeHourCJKRegex}", TimeHourCJKRegex);

    public static final String TimePeriodShortLeftDigitTimeRegex = "(从)?(?<left>{TimeDayDescRegex}?({TimeHourNumRegex}))"
            .replace("{TimeDayDescRegex}", TimeDayDescRegex)
            .replace("{TimeHourNumRegex}", TimeHourNumRegex);

    public static final String TimePeriodRegexes1 = "({TimePeriodLeftDigitTimeRegex}{TimePeriodRightDigitTimeRegex}|{TimePeriodLeftCJKTimeRegex}{TimePeriodRightCJKTimeRegex})"
            .replace("{TimePeriodLeftDigitTimeRegex}", TimePeriodLeftDigitTimeRegex)
            .replace("{TimePeriodRightDigitTimeRegex}", TimePeriodRightDigitTimeRegex)
            .replace("{TimePeriodLeftCJKTimeRegex}", TimePeriodLeftCJKTimeRegex)
            .replace("{TimePeriodRightCJKTimeRegex}", TimePeriodRightCJKTimeRegex);

    public static final String TimePeriodRegexes2 = "({TimePeriodShortLeftDigitTimeRegex}{TimePeriodRightDigitTimeRegex}|{TimePeriodShortLeftCJKTimeRegex}{TimePeriodRightCJKTimeRegex})"
            .replace("{TimePeriodShortLeftDigitTimeRegex}", TimePeriodShortLeftDigitTimeRegex)
            .replace("{TimePeriodRightDigitTimeRegex}", TimePeriodRightDigitTimeRegex)
            .replace("{TimePeriodShortLeftCJKTimeRegex}", TimePeriodShortLeftCJKTimeRegex)
            .replace("{TimePeriodRightCJKTimeRegex}", TimePeriodRightCJKTimeRegex);

    public static final String FromToRegex = "(从|自).+([至到]).+";

    public static final String AmbiguousRangeModifierPrefix = "(从|自)";

    public static final String ReferenceDatePeriodRegex = "^[.]";

    public static final String UnspecificDatePeriodRegex = "^[.]";

    public static final String ParserConfigurationBefore = "((?<include>和|或|及)?(之前|以前)|前)";

    public static final String ParserConfigurationAfter = "((?<include>和|或|及)?(之后|之後|以后|以後)|后|後)";

    public static final String ParserConfigurationUntil = "(直到|直至|截至|截止(到)?)";

    public static final String ParserConfigurationSincePrefix = "(自从|自|自打|打|从)";

    public static final String ParserConfigurationSinceSuffix = "(以来|开始|起)";

    public static final String ParserConfigurationAroundPrefix = "^[.]";

    public static final String ParserConfigurationAroundSuffix = "^[.]";

    public static final String ParserConfigurationLastWeekDayRegex = "最后一个";

    public static final String ParserConfigurationNextMonthRegex = "下一个";

    public static final String ParserConfigurationLastMonthRegex = "上一个";

    public static final String ParserConfigurationDatePrefix = " ";

    public static final ImmutableMap<String, String> ParserConfigurationUnitMap = ImmutableMap.<String, String>builder()
        .put("年", "Y")
        .put("月", "MON")
        .put("个月", "MON")
        .put("日", "D")
        .put("周", "W")
        .put("週", "W")
        .put("天", "D")
        .put("小时", "H")
        .put("个小时", "H")
        .put("时", "H")
        .put("分钟", "M")
        .put("分", "M")
        .put("秒钟", "S")
        .put("秒", "S")
        .put("星期", "W")
        .put("个星期", "W")
        .build();

    public static final ImmutableMap<String, Long> ParserConfigurationUnitValueMap = ImmutableMap.<String, Long>builder()
        .put("years", 31536000L)
        .put("year", 31536000L)
        .put("months", 2592000L)
        .put("month", 2592000L)
        .put("weeks", 604800L)
        .put("week", 604800L)
        .put("days", 86400L)
        .put("day", 86400L)
        .put("hours", 3600L)
        .put("hour", 3600L)
        .put("hrs", 3600L)
        .put("hr", 3600L)
        .put("h", 3600L)
        .put("minutes", 60L)
        .put("minute", 60L)
        .put("mins", 60L)
        .put("min", 60L)
        .put("seconds", 1L)
        .put("second", 1L)
        .put("secs", 1L)
        .put("sec", 1L)
        .build();

    public static final List<String> MonthTerms = Arrays.asList("月");

    public static final List<String> WeekendTerms = Arrays.asList("周末");

    public static final List<String> WeekTerms = Arrays.asList("周", "週", "星期");

    public static final List<String> YearTerms = Arrays.asList("年");

    public static final List<String> ThisYearTerms = Arrays.asList("今年");

    public static final List<String> YearToDateTerms = Arrays.asList("今年迄今");

    public static final List<String> LastYearTerms = Arrays.asList("去年");

    public static final List<String> NextYearTerms = Arrays.asList("明年");

    public static final List<String> YearAfterNextTerms = Arrays.asList("后年");

    public static final List<String> YearBeforeLastTerms = Arrays.asList("前年");

    public static final ImmutableMap<String, String> ParserConfigurationSeasonMap = ImmutableMap.<String, String>builder()
        .put("春", "SP")
        .put("夏", "SU")
        .put("秋", "FA")
        .put("冬", "WI")
        .build();

    public static final ImmutableMap<String, Integer> ParserConfigurationSeasonValueMap = ImmutableMap.<String, Integer>builder()
        .put("SP", 3)
        .put("SU", 6)
        .put("FA", 9)
        .put("WI", 12)
        .build();

    public static final ImmutableMap<String, Integer> ParserConfigurationCardinalMap = ImmutableMap.<String, Integer>builder()
        .put("一", 1)
        .put("二", 2)
        .put("三", 3)
        .put("四", 4)
        .put("五", 5)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("第一个", 1)
        .put("第二个", 2)
        .put("第三个", 3)
        .put("第四个", 4)
        .put("第五个", 5)
        .put("第一", 1)
        .put("第二", 2)
        .put("第三", 3)
        .put("第四", 4)
        .put("第五", 5)
        .put("第六", 6)
        .put("第七", 7)
        .put("第八", 8)
        .put("第九", 9)
        .put("第十", 10)
        .put("第十一", 11)
        .put("第十二", 12)
        .build();

    public static final ImmutableMap<String, Integer> ParserConfigurationDayOfMonth = ImmutableMap.<String, Integer>builder()
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("13", 13)
        .put("14", 14)
        .put("15", 15)
        .put("16", 16)
        .put("17", 17)
        .put("18", 18)
        .put("19", 19)
        .put("20", 20)
        .put("21", 21)
        .put("22", 22)
        .put("23", 23)
        .put("24", 24)
        .put("25", 25)
        .put("26", 26)
        .put("27", 27)
        .put("28", 28)
        .put("29", 29)
        .put("30", 30)
        .put("31", 31)
        .put("1日", 1)
        .put("2日", 2)
        .put("3日", 3)
        .put("4日", 4)
        .put("5日", 5)
        .put("6日", 6)
        .put("7日", 7)
        .put("8日", 8)
        .put("9日", 9)
        .put("10日", 10)
        .put("11日", 11)
        .put("12日", 12)
        .put("13日", 13)
        .put("14日", 14)
        .put("15日", 15)
        .put("16日", 16)
        .put("17日", 17)
        .put("18日", 18)
        .put("19日", 19)
        .put("20日", 20)
        .put("21日", 21)
        .put("22日", 22)
        .put("23日", 23)
        .put("24日", 24)
        .put("25日", 25)
        .put("26日", 26)
        .put("27日", 27)
        .put("28日", 28)
        .put("29日", 29)
        .put("30日", 30)
        .put("31日", 31)
        .put("一日", 1)
        .put("十一日", 11)
        .put("二十日", 20)
        .put("十日", 10)
        .put("二十一日", 21)
        .put("三十一日", 31)
        .put("二日", 2)
        .put("三日", 3)
        .put("四日", 4)
        .put("五日", 5)
        .put("六日", 6)
        .put("七日", 7)
        .put("八日", 8)
        .put("九日", 9)
        .put("十二日", 12)
        .put("十三日", 13)
        .put("十四日", 14)
        .put("十五日", 15)
        .put("十六日", 16)
        .put("十七日", 17)
        .put("十八日", 18)
        .put("十九日", 19)
        .put("二十二日", 22)
        .put("二十三日", 23)
        .put("二十四日", 24)
        .put("二十五日", 25)
        .put("二十六日", 26)
        .put("二十七日", 27)
        .put("二十八日", 28)
        .put("二十九日", 29)
        .put("三十日", 30)
        .put("1号", 1)
        .put("2号", 2)
        .put("3号", 3)
        .put("4号", 4)
        .put("5号", 5)
        .put("6号", 6)
        .put("7号", 7)
        .put("8号", 8)
        .put("9号", 9)
        .put("10号", 10)
        .put("11号", 11)
        .put("12号", 12)
        .put("13号", 13)
        .put("14号", 14)
        .put("15号", 15)
        .put("16号", 16)
        .put("17号", 17)
        .put("18号", 18)
        .put("19号", 19)
        .put("20号", 20)
        .put("21号", 21)
        .put("22号", 22)
        .put("23号", 23)
        .put("24号", 24)
        .put("25号", 25)
        .put("26号", 26)
        .put("27号", 27)
        .put("28号", 28)
        .put("29号", 29)
        .put("30号", 30)
        .put("31号", 31)
        .put("一号", 1)
        .put("十一号", 11)
        .put("二十号", 20)
        .put("十号", 10)
        .put("二十一号", 21)
        .put("三十一号", 31)
        .put("二号", 2)
        .put("三号", 3)
        .put("四号", 4)
        .put("五号", 5)
        .put("六号", 6)
        .put("七号", 7)
        .put("八号", 8)
        .put("九号", 9)
        .put("十二号", 12)
        .put("十三号", 13)
        .put("十四号", 14)
        .put("十五号", 15)
        .put("十六号", 16)
        .put("十七号", 17)
        .put("十八号", 18)
        .put("十九号", 19)
        .put("二十二号", 22)
        .put("二十三号", 23)
        .put("二十四号", 24)
        .put("二十五号", 25)
        .put("二十六号", 26)
        .put("二十七号", 27)
        .put("二十八号", 28)
        .put("二十九号", 29)
        .put("三十号", 30)
        .put("初一", 32)
        .put("三十", 30)
        .put("一", 1)
        .put("十一", 11)
        .put("二十", 20)
        .put("十", 10)
        .put("二十一", 21)
        .put("三十一", 31)
        .put("二", 2)
        .put("三", 3)
        .put("四", 4)
        .put("五", 5)
        .put("六", 6)
        .put("七", 7)
        .put("八", 8)
        .put("九", 9)
        .put("十二", 12)
        .put("十三", 13)
        .put("十四", 14)
        .put("十五", 15)
        .put("十六", 16)
        .put("十七", 17)
        .put("十八", 18)
        .put("十九", 19)
        .put("二十二", 22)
        .put("二十三", 23)
        .put("二十四", 24)
        .put("二十五", 25)
        .put("二十六", 26)
        .put("二十七", 27)
        .put("二十八", 28)
        .put("二十九", 29)
        .build();

    public static final ImmutableMap<String, Integer> ParserConfigurationDayOfWeek = ImmutableMap.<String, Integer>builder()
        .put("星期一", 1)
        .put("星期二", 2)
        .put("星期三", 3)
        .put("星期四", 4)
        .put("星期五", 5)
        .put("星期六", 6)
        .put("星期天", 0)
        .put("星期日", 0)
        .put("礼拜一", 1)
        .put("礼拜二", 2)
        .put("礼拜三", 3)
        .put("礼拜四", 4)
        .put("礼拜五", 5)
        .put("礼拜六", 6)
        .put("礼拜天", 0)
        .put("礼拜日", 0)
        .put("周一", 1)
        .put("周二", 2)
        .put("周三", 3)
        .put("周四", 4)
        .put("周五", 5)
        .put("周六", 6)
        .put("周日", 0)
        .put("周天", 0)
        .put("禮拜一", 1)
        .put("禮拜二", 2)
        .put("禮拜三", 3)
        .put("禮拜四", 4)
        .put("禮拜五", 5)
        .put("禮拜六", 6)
        .put("禮拜天", 0)
        .put("禮拜日", 0)
        .put("週一", 1)
        .put("週二", 2)
        .put("週三", 3)
        .put("週四", 4)
        .put("週五", 5)
        .put("週六", 6)
        .put("週日", 0)
        .put("週天", 0)
        .build();

    public static final ImmutableMap<String, Integer> ParserConfigurationMonthOfYear = ImmutableMap.<String, Integer>builder()
        .put("1", 1)
        .put("2", 2)
        .put("3", 3)
        .put("4", 4)
        .put("5", 5)
        .put("6", 6)
        .put("7", 7)
        .put("8", 8)
        .put("9", 9)
        .put("10", 10)
        .put("11", 11)
        .put("12", 12)
        .put("01", 1)
        .put("02", 2)
        .put("03", 3)
        .put("04", 4)
        .put("05", 5)
        .put("06", 6)
        .put("07", 7)
        .put("08", 8)
        .put("09", 9)
        .put("一月", 1)
        .put("二月", 2)
        .put("三月", 3)
        .put("四月", 4)
        .put("五月", 5)
        .put("六月", 6)
        .put("七月", 7)
        .put("八月", 8)
        .put("九月", 9)
        .put("十月", 10)
        .put("十一月", 11)
        .put("十二月", 12)
        .put("1月", 1)
        .put("2月", 2)
        .put("3月", 3)
        .put("4月", 4)
        .put("5月", 5)
        .put("6月", 6)
        .put("7月", 7)
        .put("8月", 8)
        .put("9月", 9)
        .put("10月", 10)
        .put("11月", 11)
        .put("12月", 12)
        .put("01月", 1)
        .put("02月", 2)
        .put("03月", 3)
        .put("04月", 4)
        .put("05月", 5)
        .put("06月", 6)
        .put("07月", 7)
        .put("08月", 8)
        .put("09月", 9)
        .put("正月", 13)
        .put("大年", 13)
        .build();

    public static final String DateTimeSimpleAmRegex = "(?<am>早|晨)";

    public static final String DateTimeSimplePmRegex = "(?<pm>晚)";

    public static final String DateTimePeriodMORegex = "(凌晨|清晨|早上|早间|早|上午)";

    public static final String DateTimePeriodMIRegex = "(中午)";

    public static final String DateTimePeriodAFRegex = "(下午|午后|傍晚)";

    public static final String DateTimePeriodEVRegex = "(晚上|夜里|夜晚|晚)";

    public static final String DateTimePeriodNIRegex = "(半夜|夜间|深夜)";

    public static final ImmutableMap<String, String> AmbiguityTimeFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "^[.]")
        .build();

    public static final ImmutableMap<String, String> AmbiguityTimePeriodFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "^[.]")
        .build();

    public static final ImmutableMap<String, String> AmbiguityDateFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "^[.]")
        .build();

    public static final ImmutableMap<String, String> AmbiguityDateTimeFiltersDict = ImmutableMap.<String, String>builder()
        .put("^[.]", "^[.]")
        .build();

    public static final ImmutableMap<String, String> AmbiguityFiltersDict = ImmutableMap.<String, String>builder()
        .put("早", "(?<!今|明|日|号)早(?!上)")
        .put("晚", "(?<!今|明|昨|傍|夜|日|号)晚(?!上)")
        .put("^\\d{1,2}号", "^\\d{1,2}号")
        .put("周", "周岁")
        .put("今日", "今日头条")
        .put("明日", "《明日之后》")
        .put("时", "时间")
        .build();

    public static final ImmutableMap<String, Long> DurationUnitValueMap = ImmutableMap.<String, Long>builder()
        .put("Y", 31536000L)
        .put("Mon", 2592000L)
        .put("W", 604800L)
        .put("D", 86400L)
        .put("H", 3600L)
        .put("M", 60L)
        .put("S", 1L)
        .build();

    public static final ImmutableMap<String, String> HolidayNoFixedTimex = ImmutableMap.<String, String>builder()
        .put("父亲节", "-06-WXX-6-3")
        .put("母亲节", "-05-WXX-7-2")
        .put("感恩节", "-11-WXX-4-4")
        .build();

    public static final String MergedBeforeRegex = "(前|之前)$";

    public static final String MergedAfterRegex = "(后|後|之后|之後)$";

    public static final ImmutableMap<Character, Integer> TimeNumberDictionary = ImmutableMap.<Character, Integer>builder()
        .put('零', 0)
        .put('一', 1)
        .put('二', 2)
        .put('三', 3)
        .put('四', 4)
        .put('五', 5)
        .put('六', 6)
        .put('七', 7)
        .put('八', 8)
        .put('九', 9)
        .put('〇', 0)
        .put('两', 2)
        .put('十', 10)
        .build();

    public static final ImmutableMap<String, Integer> TimeLowBoundDesc = ImmutableMap.<String, Integer>builder()
        .put("中午", 11)
        .put("下午", 12)
        .put("午后", 12)
        .put("晚上", 18)
        .put("夜里", 18)
        .put("夜晚", 18)
        .put("夜间", 18)
        .put("深夜", 18)
        .put("傍晚", 18)
        .put("晚", 18)
        .put("pm", 12)
        .build();

    public static final String DefaultLanguageFallback = "YMD";

    public static final List<String> MorningTermList = Arrays.asList("早", "上午", "早间", "早上", "清晨");

    public static final List<String> MidDayTermList = Arrays.asList("中午", "正午");

    public static final List<String> AfternoonTermList = Arrays.asList("下午", "午后");

    public static final List<String> EveningTermList = Arrays.asList("晚", "晚上", "夜里", "傍晚", "夜晚");

    public static final List<String> DaytimeTermList = Arrays.asList("白天", "日间");

    public static final List<String> NightTermList = Arrays.asList("深夜");

    public static final ImmutableMap<String, Integer> DynastyYearMap = ImmutableMap.<String, Integer>builder()
        .put("贞观", 627)
        .put("开元", 713)
        .put("神龙", 705)
        .put("洪武", 1368)
        .put("建文", 1399)
        .put("永乐", 1403)
        .put("景泰", 1450)
        .put("天顺", 1457)
        .put("成化", 1465)
        .put("嘉靖", 1522)
        .put("万历", 1573)
        .put("崇祯", 1628)
        .put("顺治", 1644)
        .put("康熙", 1662)
        .put("雍正", 1723)
        .put("乾隆", 1736)
        .put("嘉庆", 1796)
        .put("道光", 1821)
        .put("咸丰", 1851)
        .put("同治", 1862)
        .put("光绪", 1875)
        .put("宣统", 1909)
        .put("民国", 1912)
        .build();
}
