﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System;
using System.Reflection;
using System.Text.RegularExpressions;

namespace Microsoft.Recognizers.Text.Sequence
{
    public class QuotedTextConfiguration : ISequenceConfiguration
    {
        public QuotedTextConfiguration(SequenceOptions options = SequenceOptions.None)
        {
            Options = options;
        }

        public SequenceOptions Options { get; }

        public Regex QuotedTextRegex1 { get; set; }

        public Regex QuotedTextRegex2 { get; set; }

        public Regex QuotedTextRegex3 { get; set; }

        public Regex QuotedTextRegex4 { get; set; }

        public Regex QuotedTextRegex5 { get; set; }

        public Regex QuotedTextRegex6 { get; set; }

        public Regex QuotedTextRegex7 { get; set; }

        public Regex QuotedTextRegex8 { get; set; }

        public Regex QuotedTextRegex9 { get; set; }

        protected static TimeSpan RegexTimeOut => SequenceRecognizer.GetTimeout(MethodBase.GetCurrentMethod().DeclaringType);
    }
}
