﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Microsoft.Recognizers.Text.DateTime
{
    public interface ICJKDatePeriodExtractorConfiguration : IDateTimeOptionsConfiguration
    {
        IEnumerable<Regex> SimpleCasesRegexes { get; }

        Regex TillRegex { get; }

        Regex DateUnitRegex { get; }

        Regex RangePrefixRegex { get; }

        Regex RangeSuffixRegex { get; }

        Regex FutureRegex { get; }

        Regex PastRegex { get; }

        Regex FirstLastOfYearRegex { get; }

        Regex UnitRegex { get; }

        Regex NumberCombinedWithUnit { get; }

        Regex FollowedUnit { get; }

        IDateTimeExtractor DatePointExtractor { get; }

        IDateTimeExtractor DurationExtractor { get; }

        IExtractor IntegerExtractor { get; }

        Dictionary<Regex, Regex> AmbiguityFiltersDict { get; }

    }
}