﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Turkish\Turkish-DateTime.yaml
//     - Language: Turkish
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Turkish
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Tur";
      public const bool CheckBothBeforeAfter = true;
      public static readonly string TillRegex = $@"(?<till>\b(kadar|dek\b|değin)|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string TillConnectorRegex = $@"(?<till>('?tan|'?ten|'?den|'?dan|ile)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string RangeConnectorRegex = $@"(?<and>(ile|ila|yle|'l[ea]|(?<!\s+i)l[ea]|'?tan|'?ten|(günün|'|n)?den|'?dan|ve)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string RelativeRegex = @"(?<order>ertesi|(bir\s+)?(sonraki|dahaki)|gelecek|bu|geçen|geçmiş|son|geçtiğimiz|(?<!(tan|ten)\s+)(bir\s+)?önceki|evvelki|önümüzdeki|o(?=\s+gün))";
      public const string StrictRelativeRegex = @"(?<order>ertesi|(bir\s+)?(sonraki|dahaki)|gelecek|bu|son|geçen|geçmiş|geçtiğimiz|(bir\s+)?önceki|evvelki|önümüzdeki)";
      public const string UpcomingPrefixRegex = @"((bu\s+)?(yaklaşan))";
      public static readonly string NextPrefixRegex = $@"\b(((bir\s+)?(sonraki|dahaki)|(?<!öğleden\s+)sonra|gelecek|önümüzdeki|ertesi)(\s+gelecek)?|{UpcomingPrefixRegex}|sonunda)\b";
      public const string AfterNextSuffixRegex = @"\b((gelecek|önümüzdeki)\s+(<unit>günden|haftadan|hafta\s+sonundan|aydan|yıldan|seneden)\s+sonra((ki\s+(?<unit>hafta(\s+sonu|ya\s+ait|nın)?|gün|ay|yıl|sene))((?=daki\b)|\b)|\b))";
      public const string PastPrefixRegex = @"(son|geçen|geçtiğimiz|geçmiş)\b";
      public static readonly string PreviousPrefixRegex = $@"(geçen|bir\s+önceki|(?<!(tan|ten)\s+)önceki|evvelki|{PastPrefixRegex})\b";
      public const string ThisPrefixRegex = @"(bu|şimdiki)\b";
      public const string RangePrefixRegex = @"(arası(nda|na)?|'s[iı]n[ae](\s+(kadar|dek|değin))?|((gününe|'[ae]|y[ae]|n[ae])\s+)?(kadar|dek|değin)|'y[ae](\s+(kadar|dek|değin))?|'[ea]|(?<!'\p{L}+)[ea](\s+(kadar|dek|değin)\b))";
      public const string CenturySuffixRegex = @"(^yüzyıl)";
      public const string ReferencePrefixRegex = @"(o|şu|aynı)\b";
      public static readonly string FutureSuffixRegex = $@"\b({NextPrefixRegex}|ileride|gelecekte)\b";
      public const string PastSuffixRegex = @"^\b$";
      public const string DayRegex = @"((?<day>10|20|30|31|(1|2)[1-9]|0?[1-9])('i|'si|'sı|'ü|'u)?)";
      public const string ImplicitDayRegex = @"(?<day>(10|20|30|31|(1|2)[1-9])('i|'si|'sı|'ü|'u))(?=\b)";
      public const string DayFromSuffixRegex = @"(?<day>(1|5|8|11|15|18|21|25|28|31)'inden|(2|7|12|17|20|22|27)'sinden|(3|4|13|14|23|24)'ünden|(6|16|26)'sından|(9|10|19|29|30)'undan)";
      public const string DayToSuffixRegex = @"(?<day>(1|5|8|11|15|18|21|25|28|31)'ine|(2|7|12|17|20|22|27)'sine|(3|4|13|14|23|24)'üne|(6|16|26)'sına|(9|10|19|29|30)'una)";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])";
      public const string WrittenOneToNineRegex = @"(?:bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz)";
      public const string WrittenTwoToNineRegex = @"(?:iki|üç|dört|beş|altı|yedi|sekiz|dokuz)";
      public const string WrittenElevenToNineteenRegex = @"(?:on\s+(bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz))";
      public const string WrittenTensRegex = @"(?:on|yirmi|otuz|kırk|elli|altmış|yetmiş|seksen|doksan)";
      public static readonly string WrittenNumRegex = $@"(?:{WrittenOneToNineRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?)";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?:(iki\s*bin|bin)(\s+({WrittenTwoToNineRegex}\s+)?yüz)?)";
      public static readonly string WrittenCenturyOrdinalYearRegex = $@"(?:yirmi(\s+(bir|iki))|on|(on\s+)?{WrittenOneToNineRegex})";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex}|({WrittenTwoToNineRegex}\s+)?yüz)";
      public static readonly string LastTwoYearNumRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?)";
      public static readonly string FullTextYearRegex = $@"\b(((?<firsttwoyearnum>{CenturyRegex})\s*)(?<lasttwoyearnum>{LastTwoYearNumRegex})|(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|(iki\s*)?bin))";
      public static readonly string FullTextAtYearRegex = $@"\b((({WrittenCenturyFullYearRegex}|(iki\s+)?bin)\s+)?(((on|yirmi|otuz|kırk|elli|altmış|yetmiş|seksen|doksan)\s+)?(birde|ikide|üçte|dörtte|beşte|altıda|yedide|sekizde|dokuzda)|onda|yirmide|otuzda|kırkta|ellide|altmışta|yetmişte|seksende|doksanda)|{WrittenCenturyFullYearRegex}de|(iki\s)?binde)\b";
      public const string OclockRegex = @"(?<oclock>saat(\s+tam)?)";
      public const string SpecialDescRegex = @"((?<ipm>)p\b)";
      public static readonly string AmDescRegex = $@"({BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"({BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"({BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"((({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})))|{OclockRegex})";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}('a\b)?|{FullTextYearRegex})";
      public const string WeekDayRegex = @"\b(?<weekday>pazartesi(leri|si)?|salı(ları|sı)?|çarşamba(ları|sı)?|perşembe(leri|si)?|cuma(ları|sı)?|cumartesi(leri|si)?|pazar(ları|ı)?|pzt|sal|çrş|per|cum|cmt|paz)(\s+günü)?\b";
      public const string SingleWeekDayRegex = @"\b(?<weekday>pazartesi|salı|çarşamba|perşembe|cuma|cumartesi|pazar|pzt|sal|çrş|per|cum|cmt|paz)\b";
      public static readonly string MonthRegex = $@"\b(?<month>ocak|şubat|mart|nisan|mayıs|haziran|temmuz|ağustos|eylül|ekim|kasım|(?<!(arasındaki|kadarki)\s+)aralık(?!\s+{YearRegex}(den|dan))|(oca|şub|mar|nis|may|haz|eyl|eki|kas|(?<=\d\s+)ara(?=\s+\d))\b)";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>{RelativeRegex}\s+(ayın|ay))\b";
      public static readonly string WrittenMonthRegex = $@"(?<month>ocak|şubat|mart|nisan|mayıs|haziran|temmuz|ağustos|eylül|ekim|kasım|(?<!(arasındaki|kadarki)\s+)aralık(?!\s+{YearRegex}(den|dan))|(oca|şub|mar|nis|may|haz|eyl|eki|kas|(?<=\d\s+)ara(?=\s+\d))\b)(\s+ayı)?";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>((?<!\d+)((ocak|şubat|mart|mayıs|ağustos|aralık)(ta)|(nisan|haziran|temmuz|kasım)(da)|(eylül|ekim)(de))|{WrittenMonthRegex}(\sayında)|{RelativeRegex}\sayda))";
      public const string ProperMonthSuffixRegex = @"(?<msuf>(ocak|şubat|mart|mayıs|ağustos|aralık)('ta)|(nisan|haziran|temmuz|kasım)('da)|(eylül|ekim)('de))";
      public static readonly string MonthPossessiveSuffixRegex = $@"((?<month>(ocak|şubat|mart|nisan|mayıs|haziran|kasım|aralık)('ın)|(temmuz|ağustos)('un)|eylül'ün|ekim'in)|{MonthRegex}(\s+ayının)|(?<relmonth>{RelativeRegex}\s+(ayın))\b)";
      public const string MonthToSuffixRegex = @"(?<msuf>((ocak|şubat|mart|nisan|mayıs|haziran|temmuz|ağustos|kasım|aralık)'a|(eylül|ekim)'e))";
      public const string DateUnitRegex = @"\b(?<unit>(?<year>yıl|sene)|(?<month>ayın\b|ay(?=lığına|ı|da|\b))|(?<week>hafta)|(?<business>iş\s+)günü|(?<day>gün))(?!(den|dan)(?!\s+(az|fazla)))";
      public const string DateTokenPrefix = @"";
      public const string TimeTokenPrefix = @"";
      public const string TokenBeforeDate = @"";
      public const string TokenListBeforeDate = @"'de|'da|'te|'ta|nda|nde";
      public const string TokenBeforeTime = @"";
      public const string HalfTokenRegex = @"\b(buçuk|buçuğa)$";
      public const string QuarterTokenRegex = @"\b(çeyrek|çeyreği)\b";
      public const string ToTokenRegex = @"\b(var|kala)$";
      public static readonly string SimpleCasesRegex = $@"\b(({YearRegex}(\s+|\s*,\s*))?{DayRegex}\s+({WrittenMonthRegex}|{RelativeMonthRegex})\s*{RangeConnectorRegex}\s*{DayRegex}(\s*{RangePrefixRegex})?|({YearRegex}(\s+|\s*,\s*)){DayRegex}\s*{RangeConnectorRegex}\s*{DayRegex}\s+({WrittenMonthRegex}|{RelativeMonthRegex})(\s*{RangePrefixRegex})?|{DayRegex}\s*{RangeConnectorRegex}\s*{DayRegex}\s+({WrittenMonthRegex}|{RelativeMonthRegex})(\s+{YearRegex})?(\s+{RangePrefixRegex})?|({WrittenMonthRegex}|{RelativeMonthRegex})(\s+{YearRegex})?(\s+|\s*,\s*){DayRegex}\s*{RangeConnectorRegex}\s*{DayRegex}(\s*{RangePrefixRegex})?)\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"({YearRegex}\s+)?({MonthPossessiveSuffixRegex}\s+)({DayFromSuffixRegex})\s*({DayToSuffixRegex})(\s+{TillRegex})?";
      public static readonly string MonthFrontBetweenRegex = $@"\b({WrittenMonthRegex}\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?(\s*{RangePrefixRegex})?\b";
      public static readonly string BetweenRegex = $@"\b(({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+({WrittenMonthRegex}|{RelativeMonthRegex})((\s+|\s*,\s*){YearRegex})?(\s*{RangePrefixRegex})?|({MonthPossessiveSuffixRegex},?\s+)({YearRegex}\s+)?)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})(\s*{RangePrefixRegex})?\b";
      public static readonly string MonthWithYear = $@"\b(({WrittenMonthRegex}(\s+|,?\s*){YearRegex}('y?[ae])?(?!den|dan))|({RelativeRegex}\s+(yıl|sene)|({RelativeRegex}\s+)?{YearRegex}(in|nin|ün|nın|un)?|seneye)(\s*,)?\s+{WrittenMonthRegex}(\s+ayı(?=nda)|(?='(ta|da|de)\b)|\b))";
      public static readonly string OneWordPeriodRegex = $@"\b({AfterNextSuffixRegex}|({RelativeRegex}\s+)?{WrittenMonthRegex}(\s+ayı(?=nda)|\b)|({NextPrefixRegex}\s+)?{WrittenMonthRegex}|(ayın|sene)\s+başından\s+beri|((({RelativeRegex}\s+)(benim\s+)?|benim\s+|(?<!(\d+|büyük)\s+))(ay(ı[mn]|ki|a ait)?|yıl(ı[mn])?|hafta\s+sonum?|hafta(m|ki|ya ait)?|haftasında|haftanın)|hafta\s+sonum?|haftasında|haftaya)(\b|(?=ki))|(hafta|yıl|ay)(?=daki)|(bugüne|bu\s+zamana)\s+kadarki\s+(yıl|ay))(?!\s+içinde(?!\s+(daha\s+)?sonra))";
      public static readonly string MonthNumWithYear = $@"\b(({MonthNumRegex}(\s*)[/\-\.](\s*){BaseDateTime.FourDigitYearRegex})\b|({BaseDateTime.FourDigitYearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})\b|({BaseDateTime.FourDigitYearRegex}('(nın|in|ün|nın|ın|un))\s+(?<month>([1258]|10|11|12)('inci|\.)|[34]('üncü|\.)|6('ıncı|\.)|(7|12)('nci|\.)|(9|10)('uncu|\.))(\s+ayı|\b)))";
      public static readonly string WeekOfMonthRegex = $@"\b(?<wom>({MonthPossessiveSuffixRegex}|{WrittenMonthRegex}(\s+{BaseDateTime.FourDigitYearRegex}('(in|nin|ün|nın|un)))|({BaseDateTime.FourDigitYearRegex}\s+yılı\s+|{RelativeRegex}\s+yılın\s+)?{WrittenMonthRegex}\s+ayının)\s+(?<cardinal>ilk|birinci|1(.|'inci)|ikinci|2(.|'inci)|üçüncü|3(.|'üncü)|dördüncü|4(.|'üncü)|beşinci|5(.|'inci)|son)\s+haftası(na)?)\b";
      public static readonly string WeekOfYearRegex = $@"\b(?<woy>({YearRegex}(\s+yılının|'?(nin|in|ün|nın|ın|un))|{RelativeRegex}\s+yıl(ın)?)\s+(?<cardinal>((on|yirmi|otuz|kırk|elli)\s+)?(birinci|ilk|ikinci|üçüncü|dördüncü|beşinci|altıncı|yedinci|sekizinci|dokuzuncu|onuncu|yirminci|otuzuncu|kırkıncı|ellinci)|elli birinci|elli ikinci|(1|2|3|4|5)?1(.|'inci)|(1|2|3|4|5)?2(.|'inci)|(1|2|3|4)?3(.|'üncü)|(1|2|3|4)?4(.|'üncü)|(1|2|3|4)?5(.|'inci)|(1|2|3|4)?6(.|'ıncı)|(1|2|3|4)?7(.|'nci)|(1|2|3|4)?8(.|'inci)|(1|2|3|4)?9(.|'uncu)|son)\s+hafta(sı)?)";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.)?){DateUnitRegex}";
      public const string QuarterTermRegex = @"\b((?<cardinal>birinci|1'inci|1.|ilk|ikinci|2'nci|2.|üç|üçüncü|3'üncü|3.|dördüncü|4'üncü|4.|son)\s+(çeyreği|çeyrek))";
      public static readonly string QuarterRegex = $@"((({RelativeRegex}\s+)?yılın|{YearRegex}(\s+yılının|'nın|nin))\s+{QuarterTermRegex}|{QuarterTermRegex}(\s+boyunca)?)";
      public const string OneDigitSuffixRegex = @"(1'in|2'nin|3'ün|4'ün|5'in|6'nın|7'nin|8'in|9'un)";
      public const string TwoDigitsSuffixRegex = @"(10'un|20'nin|30'un|40'ın|50'nin|60'ın|70'in|80'in|90'ın|00'ün)";
      public const string ThreeDigitsSuffixRegex = @"(000'in)";
      public static readonly string QuarterRegexYearFront = $@"(\d{{3}}{OneDigitSuffixRegex}|\d{{2}}{TwoDigitsSuffixRegex}|\d{ThreeDigitsSuffixRegex}|{RelativeRegex}\s+yılın)\s+{QuarterTermRegex}";
      public const string HalfYearTermRegex = @"(?<cardinal>birinci|1'inci|1.|ilk|ikinci|2'nci|2.)\s+yarıyıl";
      public static readonly string HalfYearFrontRegex = $@"(?<year>((1[5-9]|20)\d{{2}})|2100)(\s*-\s*|\s+)?({HalfYearTermRegex})";
      public static readonly string HalfYearBackRegex = $@"({HalfYearTermRegex})(\s*,\s*)({YearRegex})";
      public static readonly string HalfYearRelativeRegex = $@"((({RelativeRegex}\s+)?yılın|{YearRegex}\s+yılının)\s+{HalfYearTermRegex})(ı)";
      public static readonly string AllHalfYearRegex = $@"({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})";
      public const string EarlyPrefixRegex = @"(?<EarlyPrefix>erken|başından|başına|(?<RelEarly>başlarında|başında|daha\s+erken|erkenden)|başı|başları|başlarına)";
      public const string MidPrefixRegex = @"(?<MidPrefix>(ortasına|ortasından?|ortası|ortaları|ortalarına|ortalarında))";
      public const string LaterPrefixRegex = @"(?<LatePrefix>sonundan|sonunda|sonuna(\s+doğru)?|(?<RelLate>daha\s+geç|(içinde\s+)?daha\s+sonra|içinde\s+sonra)|sonu|sonları|sonlarına|sonlarında)";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public static readonly string PrefixDayRegex = $@"\b((gün\s+)?{MidPrefixRegex}|(günün?\s+)?((?<EarlyPrefix>erken\s+saatler(in)?de)|(?<LatePrefix>(geç|ilerleyen)\s+saatler(in)?de)))";
      public const string SeasonDescRegex = @"(?<seas>(ilk)?baharı?|yaz(?!(dı|mış))(ın(?=(?!')\b)|ı(?=nda)?)?|(?<=((mevsim(lerden)?|bir)\s+))yaz(?=(dı|mış))|sonbaharı?|kış(ın(?=(?!')\b)|ı(?=nda)?)?)";
      public static readonly string SeasonRegex = $@"\b(?<season>({YearRegex}('nın)?\s+{SeasonDescRegex}(nın)?|({RelativeRegex}\s+)?{SeasonDescRegex}(ın)?)(\s+{PrefixPeriodRegex})?)";
      public const string WhichWeekRegex = @"\b((?<number>(?<cardinal>((on|yirmi|otuz|kırk|elli)\s+)?(birinci|ikinci|üçüncü|dördüncü|beşinci|altıncı|yedinci|sekizinci|dokuzuncu|onuncu|yirminci|otuzuncu|kırkıncı|ellinci)|elli birinci|elli ikinci))|((?<number>(?<cardinal>(1|2|3|4|5)?(1|2|5|8)))(.|'inci)|(?<number>(?<cardinal>(1|2|3|4|5)?(3|4)))(.|'üncü)|(?<number>(?<cardinal>(1|2|3|4|5)?6))(.|'ıncı)|(?<number>(?<cardinal>(1|2|3|4|5)?7))(.|'nci)|(?<number>(?<cardinal>(1|2|3|4|5)?9))(.|'uncu)))\s+hafta(ya)?";
      public const string WeekOfRegex = @"(haftası)";
      public const string MonthOfRegex = @"\b(ayı)\b";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})";
      public static readonly string YearSuffix = $@"(,?\s*({DateYearRegex}|{FullTextYearRegex})(\s+yılı)?)";
      public const string OnRegex = @"^[\*]";
      public const string RelaxedOnRegex = @"(?<day>(10|20|30|31|(1|2)[1-9])('i|'si|'sı|'ü|'u))(?=(nde|nda))\b";
      public const string PrefixWeekDayRegex = @"(\s*[-—–])";
      public static readonly string ThisRegex = $@"\b(bu(\s+hafta)?\s+{WeekDayRegex})\b";
      public static readonly string LastDateRegex = $@"\b({PreviousPrefixRegex}(\s+hafta)?\s+{WeekDayRegex})\b";
      public static readonly string NextDateRegex = $@"\b(({NextPrefixRegex}(\s+hafta(nın)?)?|haftaya)\s+{WeekDayRegex})\b";
      public static readonly string SpecialDayRegex = $@"\b((dünden\s+önceki|yarından\s+sonraki)\s+güne?|yarından\s+sonra(ki)?|(önceki|sonraki)\s+gün|{RelativeRegex}\s+gün|(benim\s+)?günüm|dün(den|kü)?|yarın(dan|a|ki)?|bugün(kü)?|^gün\b)";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<day>dünden|yarından|bugünden|şu\s+andan)\s+(itibaren\s+)?(?<number>{WrittenNumRegex}|\d+)\s+gün\s+(sonra|içinde))\b";
      public static readonly string RelativeDayRegex = $@"\b({RelativeRegex}\s+gün)\b";
      public const string SetWeekDayRegex = @"\b(?<weekday>sabah|öğlen|akşam|gece|pazartesi|salı|çarşamba|perşembe|cuma|cumartesi|pazar)(?<prefix>('|\s+gün)?l[ae]r)[ıi]\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>({MonthPossessiveSuffixRegex}|{WrittenMonthRegex}\s+ayının|{RelativeRegex}\s+ayın)\s+(?<cardinal>birinci|1'inci|1.|ilk|ikinci|2'nci|2.|üçüncü|3'üncü|3.|dördüncü|4'üncü|4.|beşinci|5'inci|5.|son)\s+{WeekDayRegex})";
      public static readonly string RelativeWeekDayRegex = $@"\b((şu\s+andan\s+itibaren\s+)?{WrittenNumRegex}\s+{WeekDayRegex}\s+(sonra))\b";
      public static readonly string SpecialDate = $@"\b{DayRegex}\s+günü\b";
      public const string DatePreposition = @"\b(tarihinde)";
      public static readonly string DateExtractorYearTermRegex = $@"(\s+|\s*[/\\.,\-]\s*){DateYearRegex}";
      public static readonly string DateExtractor1 = $@"\b(({DayRegex}\s*[/\\.,\-]?\s*{MonthRegex}(\s*[/\\.,\- ]\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[/\\.,\- ]\s*{DayRegex}\s*[/\\.,\- ]\s*{MonthRegex})((\s*\(\s*{SingleWeekDayRegex}\s*\))|\s*,?\s+{SingleWeekDayRegex}(\s+günü)?)?)";
      public static readonly string DateExtractor3 = $@"\b(({RelativeRegex}\s+ayın\s+)?({OnRegex})(\s*\(\s*{SingleWeekDayRegex}\s*\))?)\b";
      public static readonly string DateExtractor4 = $@"\b(({RelativeRegex}\s+)?({SingleWeekDayRegex}\s+(günü\s+)?)?(\({DayRegex}\s+{MonthRegex}(\s+{DateYearRegex})?\)|(\s*,\s*)?{DayRegex}\s+{MonthRegex}'(e|a)(?!\s+kadar)))\b";
      public static readonly string DateExtractor5 = $@"\b({DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex})((\s*\(\s*{SingleWeekDayRegex}\s*\))|\s*,?\s+{SingleWeekDayRegex}(\s+günü)?)?(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"({RelativeRegex}\s+)?({SingleWeekDayRegex}\s+)?(\({DayRegex}\s*[/\\.]\s*{MonthNumRegex}\s*[/\\.]\s*{DateYearRegex}\))\b(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor7 = $@"\b(({DayRegex})\s+{ProperMonthSuffixRegex})\b";
      public static readonly string DateExtractor8 = $@"\b({WeekDayRegex}\s*[,-]?\s*)?(({MonthRegex}[\.]?\s*[/\\.,-]?\s*{DayRegex})|(\({MonthRegex}\s*[-./]\s*{DayRegex}\)))(\s*\(\s*{WeekDayRegex}\s*\))?({DateExtractorYearTermRegex})?\b";
      public static readonly string DateExtractor9 = $@"\b({SingleWeekDayRegex}\s+{OnRegex})\b";
      public static readonly string DateExtractor7L = $@"\b({WeekDayRegex}\s+)?({DayRegex}\s*[/]\s*{MonthNumRegex})(,?\s+{BaseDateTime.FourDigitYearRegex})?{BaseDateTime.CheckDecimalRegex}";
      public static readonly string DateExtractor7S = $@"\b(({DayRegex}\s*[/\\.,\-]?\s*{MonthRegex})((\s*\(\s*{SingleWeekDayRegex}\s*\))|\s*,?\s+{SingleWeekDayRegex}(\s+günü)?)?)";
      public const string DateExtractor9L = @"^[\*]";
      public const string DateExtractor9S = @"^[\*]";
      public static readonly string DateExtractorA = $@"\b({WeekDayRegex}\s+)?(({BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex})|({MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex})|({DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex}))";
      public static readonly string OfMonth = $@"^\s*{MonthRegex}";
      public static readonly string MonthEnd = $@"{MonthPossessiveSuffixRegex}\s*$";
      public static readonly string WeekDayEnd = $@"(bu\s+)?{WeekDayRegex}\s*,?\s*$";
      public static readonly string WeekDayStart = $@"\s*,?\s*{WeekDayRegex}";
      public const string RangeUnitRegex = @"\b(?<unit>hafta|ay|yıl)\b";
      public const string HourNumRegex = @"\b(saat\s*)?(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|sıfır|bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz|on|yirmi)\b";
      public const string HourNumRegexNoSuffix = @"\b(saat\s*)?(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|sıfır|bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz|on|yirmi)(?=('?[dt]?[ae](ki)?|a|e|ya|ye|i|u|ü|yi|yı|ı)?\b)";
      public const string AtHourNumRegexNoSuffix = @"\b(saat\s*)?(?<!(on|yirmi)\s+)(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|sıfır|bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz|on|yirmi)(?='?[dty]?[ae](ki)?\b)";
      public const string AtHourNumRegex = @"\b(saat\s*)?(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|sıfır|bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz|on|yirmi)('?[dt][ae](ki)?\b)";
      public const string MinuteNumRegex = @"(?<minnum>((on|yirmi|otuz|kırk|elli)\s+)?(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|(on|yirmi|otuz|kırk|elli))(\s*dakika\b)?";
      public const string DeltaMinuteNumRegex = @"\b(?<deltaminnum>((on|yirmi|otuz|kırk|elli)\s)?(bir|iki|üç|dört|dörd|dörd|beş|altı|yedi|sekiz|dokuz)|(on|yirmi|otuz|kırk|elli))";
      public const string AtMinuteNumRegexNoSuffix = @"\b(?<minnum>((bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|((on|yirmi|otuz|kırk|elli)(\s*(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz))?))(?=[dt]?[ae]?\b))";
      public const string AtMinuteNumRegex = @"\b(?<minnum>((bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|((on|yirmi|otuz|kırk|elli)(\s*(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz))?)))([dt][ae]\b)";
      public const string AtMinuteRegexNoSuffix = @"(?<min>[0-5]\d)(?='[dt]?[ae]?\b)";
      public const string AtMinuteRegex = @"(?<min>[0-5]\d)('[dt][ae]\b)";
      public const string AtSecondRegex = @"(?<sec>[0-5]\d)('[dt][ae]\b)";
      public const string PmRegex = @"(?<pm>(öğle yemeği zamanı|öğle yemeği vakti|öğlen civarı|öğle saatlerinde|öğleden sonra|öğlen|öğle|akşamleyin|akşama doğru|akşam saatlerinde|akşamüstü|akşamı?|gece yarısı|gece yarısına doğru|geceleyin|gece boyunca|gece|ikindi|ikindi vakti))";
      public const string PmRegexFull = @"(?<pm>(öğle yemeği zamanı|öğle yemeği vakti|öğlen civarı|öğle saatlerinde|öğleden sonra|öğlen|öğle|akşamleyin|akşama doğru|akşam saatlerinde|akşamüstü|akşamı?|gece yarısı|gece yarısına doğru|geceleyin|gece boyunca|gece|ikindi|ikindi vakti))";
      public const string AmRegex = @"(?<am>(sabahleyin|sabahları|sabah\s+saatlerinde|sabahı?|öğleden\s+önce|kuşluk\s+vakti))";
      public const string LunchRegex = @"\b(öğle yemeği zamanı|öğle yemeği vakti|öğle saatlerinde|öğleden sonra|öğlen civarı|öğlen|öğle)";
      public const string NightRegex = @"\b(gece yarısı|gece)\b";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public static readonly string LessThanOneHour = $@"(?<lth>(çeyrek|{BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex}))";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s+{MinuteNumRegex})";
      public static readonly string WrittenTimeRegexTo = $@"(?<writtentime>{HourNumRegex}\s+{MinuteNumRegex})(a|e|ya|ye)\b";
      public static readonly string WrittenTimeRegexPast = $@"(?<writtentime>{HourNumRegex}\s+{MinuteNumRegex})(i|u|ü|yi|yı|ı)\b";
      public static readonly string AtWrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s+{AtMinuteNumRegex})";
      public static readonly string AtWrittenTimeRegexNoSuffix = $@"(?<writtentime>{HourNumRegex}\s+{AtMinuteNumRegexNoSuffix})";
      public const string HourNumPastSuffixRegex = @"\b(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz|on|yirmi)(i|u|ü|yi|yı)\b";
      public static readonly string HourPastSuffixRegex = $@"\b(?<hour>{HourRegex})('(i|u|ü|yi|yı))\b";
      public const string HourNumToSuffixRegex = @"\b(?<hournum>on\s+(bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz)|yirmi\s+(bir|iki|üç)|bir|iki|üç|dört|dörd|beş|altı|yedi|sekiz|dokuz|on|yirmi)(a|e|ya|ye)\b";
      public static readonly string HourToSuffixRegex = $@"\b(?<hour>{HourRegex})('(a|e|ya|ye))\b";
      public static readonly string TimePrefix = $@"(?<suffix>(?<prefix>{AmRegex}|{PmRegex}))";
      public static readonly string TimeSuffix = $@"(({HourPastSuffixRegex}|{HourNumPastSuffixRegex}|{WrittenTimeRegexPast})\s+(?<prefix>({LessThanOneHour}\s+((dakika\s+)?(geçe|geçiyor))))|({HourToSuffixRegex}|{HourNumToSuffixRegex}|{WrittenTimeRegexTo})\s+(?<prefix>({LessThanOneHour}\s+((dakika\s+)?(kala|var)))))";
      public static readonly string TimeSuffixFull = $@"(?<suffix>{AmRegex}|{PmRegexFull}|{OclockRegex})";
      public static readonly string TimeHalfRegex = $@"\b(({HourNumRegex}|{HourRegex})\s+(?<prefix>buçuk|buçuğa))(\b|(?=tan))";
      public static readonly string AtTimeHalfRegex = $@"\b(({HourNumRegex}|{HourRegex})\s+(?<prefix>buçuk)ta)\b";
      public static readonly string BasicTime = $@"\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{HourRegex})";
      public const string MidnightRegex = @"(?<midnight>gece yarısı)";
      public const string MidmorningRegex = @"(?<midmorning>kuşluk vakti|sabah ortası)";
      public const string MidafternoonRegex = @"(?<midafternoon>ikindi|ikindi vakti|öğlen ortası|öğle ortası)";
      public const string MiddayRegex = @"(?<midday>öğle yemeği vakti|öğlenleyin|öğle vakti|gün ortası|öğlen civarı|öğle civarı|öğlen)";
      public static readonly string MidTimeRegex = $@"(?<mid>{MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex})";
      public static readonly string AtHourRegexNoSuffix = $@"\b({HourRegex}(?=('([dt][ae]|dan|den|ten|[ae]|y[ae])\b|\s*{RangeConnectorRegex}\s*{HourRegex}))|(?<={HourRegex}\s*{RangeConnectorRegex}\s*){HourRegex})";
      public static readonly string AtRegex = $@"\b(({TimePrefix}\s*|{TimePrefix}\s+(saat)\s*)?({AtWrittenTimeRegexNoSuffix}|{AtHourNumRegexNoSuffix}|{AtHourRegexNoSuffix}|{HourRegex}:{AtMinuteRegexNoSuffix}|{MidTimeRegex})|(({TimePrefix}\s*|{TimePrefix}\s+(saat)\s*|saat\s*)({HourRegex}|{HourNumRegexNoSuffix})))(?!(\d|:|\s+saat))";
      public const string IshRegex = @"^[\*]";
      public const string AtHourWithZeroMinRegex = @"(?<hour>0?[1-9]|[0-5][0-9]|2[0-4])(:00)?('[dt][ae])";
      public const string TimeUnitRegex = @"([^A-Za-z]{1,}|\b)(?<unit>saat|sa\.|dakika|dk\.|saniye|sn\.)";
      public const string RestrictedTimeUnitRegex = @"(?<unit>saat|dakika|saniye)\b";
      public const string AtDateTimeUnitRegex = @"(?<unit>yıllarda|senelerde|aylarda|haftalarda|günlerde|saatlerde|dakikalarda|saniyelerde)\b";
      public const string FivesRegex = @"(?<tens>(beş|(((on|yirmi|otuz|kırk|elli)\s)?beş?)))\b";
      public const string HourRegex = @"\b(saat\s*)?(?<hour>2[0-4]|[0-1]?\d)";
      public const string AtHourRegex = @"\b(saat\s*)?(?<hour>2[0-4]|[0-1]?\d)('[dt][ae]|'(dan|den|ten|y?[ae]))\b";
      public const string HourNumFromRegex = @"\b((?<hour>00|06|09|0|10|16|19|6|9)'dan|(?<hour>01|02|07|08|11|12|17|18|20|21|22|1|2|7|8)'den|(?<hour>03|04|05|13|14|15|23|24|3|4|5)'ten)\b";
      public const string HourNumToRegex = @"\b((?<hour>00|09|0|10|19|9)'a|(?<hour>01|03|04|05|08|11|13|14|15|18|21|23|24|1|3|4|5|8)'e|(?<hour>02|07|12|17|22|2|7|20)'ye|(?<hour>06|16|6)'ya)\b";
      public const string MinuteFromRegex = @"((?<min>01|02|07|08|11|12|17|18|20|21|22|27|28|31|32|37|38|41|42|47|48|50|51|52|57|58|1|2|7|8)'den|(?<min>03|04|05|13|14|15|23|24|25|33|34|35|43|44|45|53|54|55|3|4|5)'ten|(?<min>06|09|10|16|19|26|29|30|36|39|46|49|56|59|6|9)'dan|(?<min>40)'tan|(?<min>00)'(dan|den|tan|ten))";
      public const string MinuteToRegex = @"((?<min>01|03|04|05|08|11|13|14|15|18|21|23|24|25|28|31|33|34|35|38|41|43|44|45|48|51|53|54|55|58|1|3|4|5|8)'e|(?<min>02|07|12|17|20|22|27|32|37|42|47|50|52|57|2|7)'ye|(?<min>06|16|26|36|46|56|6|9)'ya|(?<min>09|10|19|29|30|39|40|49|59)'a|(?<min>00)'(a|e|ya|ye))";
      public const string HourWithMinuteZeroFromRegex = @"\b(?<hour>2[0-4]|[0-1]?\d):00'(dan|den|tan|ten)\b";
      public const string HourWithMinuteZeroToRegex = @"\b(?<hour>(00|09|0|10|19|9):00'a|(01|03|04|05|08|11|13|14|15|18|21|23|24|1|3|4|5|8):00'e|(2|02|07|12|17|22|2|7|20):00'ye|(06|16|6):00'ye)\b";
      public const string PeriodHourNumRegex = @"\b(?<hour>sıfır|bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz|on|on\s+bir|on\s+iki|on\s+üç|on\s+dört|on\s+beş|on\s+altı|on\s+yedi|on\s+sekiz|on\s+dokuz|yirmi|yirmi\s+bir|yirmi\s+iki|yirmi\s+üç|yirmi\s+dört)\b";
      public const string PeriodAtHourNumRegex = @"\b((?<hour>sıfır|altı|dokuz|on|on\s+altı|on\s+dokuz)da|(?<hour>bir|iki|yedi|sekiz|on\s+bir|on\s+iki|on\s+yedi|on\s+sekiz|yirmi|yirmi\s+bir|yirmi\s+iki)de|(?<hour>üç|dört|beş|on\s+üç|on\s+dört|on\s+beş|yirmi\s+üç|yirmi\s+dört)te)\b";
      public const string PeriodHourNumFromRegex = @"\b((?<hour>sıfır|altı|dokuz|on|on\s+altı|on\s+dokuz)dan|(?<hour>bir|iki|yedi|sekiz|on\s+bir|on\s+iki|on\s+yedi|on\s+sekiz|yirmi|yirmi\s+bir|yirmi\s+iki)den|(?<hour>üç|dört|beş|on\s+üç|on\s+dört|on\s+beş|yirmi\s+üç|yirmi\s+dört)ten)\b";
      public const string PeriodHourNumToRegex = @"\b((?<hour>iki|yedi|on\s+iki|on\s+yedi|yirmi|yirmi\s+iki)ye|(?<hour>bir|üç|dörd|beş|sekiz|on\s+bir|on\s+üç|on\s+dörd|on\s+beş|on\s+sekiz|yirmi\s+bir|yirmi\s+üç|yirmi\s+dörd)e|(?<hour>altı|on\s+altı)ya|(?<hour>sıfır|dokuz|on|on\s+dokuz)a)\b";
      public static readonly string ConnectNumRegex = $@"\b({DescRegex}\s+){HourRegex}(?<min>00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59)(?!\d)";
      public static readonly string TimeRegexWithDotConnector = $@"({HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex1 = $@"\b(({TimePrefix}\s+)(saat\s)?({WrittenTimeRegex}|{HourNumRegex}|{AtHourNumRegex}|{HourRegex}))(?!(\s+saat|\d+))";
      public static readonly string TimeRegex2 = $@"\b({TimePrefix}\s+)?(saat\s)?(t)?({HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?)";
      public static readonly string TimeRegex3 = $@"\b({TimePrefix}\s+)?(saat\s)?({HourRegex}:{BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex4 = $@"\b({TimePrefix}\s+)?(saat\s)?{TimeSuffix}(?=(\b|dan))";
      public static readonly string TimeRegex5 = $@"\b({TimePrefix}\s+)?(saat\s)?(?<!:)({HourRegex}(:{BaseDateTime.MinuteRegex})?|{HourNumRegex})({AroundRegex})\b";
      public static readonly string TimeRegex6 = $@"\b({TimePrefix}\s+)?(saat\s+)?({TimeHalfRegex}|{AtTimeHalfRegex})";
      public static readonly string TimeRegex7 = $@"\b({TimePrefix}\s+(saat\s+)?)({AtHourNumRegex}|{HourRegex}:{AtMinuteRegexNoSuffix}|({HourNumRegex}\s+{AtMinuteNumRegex})|{HourRegex}:{BaseDateTime.MinuteRegex}:{AtSecondRegex})";
      public static readonly string TimeRegex8 = $@"\b({TimePrefix}\s+)?(saat\s)?({AtTimeHalfRegex})";
      public static readonly string TimeRegex9 = $@"\b{PeriodHourNumRegex}\s+{FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"\b({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string TimeRegex11 = $@"\b(({TimeRegexWithDotConnector})(?!\s*per\s*cent|%)|({TimeRegexWithDotConnector}(\s*{DescRegex})))";
      public static readonly string TimeRegex12 = $@"\b({TimePrefix}\s+)?(saat\s)?({AtWrittenTimeRegex}|{AtHourNumRegex}|{AtHourRegex})(\s+{TimePrefix})";
      public static readonly string TimeRegex13 = $@"\b({AtHourWithZeroMinRegex}|{AtHourNumRegex}|({HourNumRegex}\s+{AtMinuteNumRegex})|{HourRegex}:{BaseDateTime.MinuteRegex}:{AtMinuteRegex})\s+{TimePrefix}";
      public static readonly string PureNumFromTo = $@"(((?<leftDesc>{TimePrefix})\s*)?(?<desc>saat\s+)?({PeriodHourNumFromRegex}|{HourNumFromRegex})\s*((?<rightDesc>{TimePrefix})\s*)?({PeriodHourNumToRegex}|{HourNumToRegex})(\s+{TillRegex})?)";
      public static readonly string PureNumBetweenAnd = $@"((?<leftDesc>{TimePrefix})\s*)?({HourRegex}|{PeriodHourNumRegex}|({HourRegex}(\s*)?:(\s*)?{BaseDateTime.TwoDigitMinuteRegex}))\s*{RangeConnectorRegex}\s*((?<leftDesc>{TimePrefix})\s*)?({HourRegex}|{PeriodHourNumRegex}|({HourRegex}(\s*)?:(\s*)?{BaseDateTime.TwoDigitMinuteRegex}))(\s*{RangePrefixRegex}\b)?";
      public static readonly string SpecificTimeFromTo = $@"(((?<time1>((?<leftDesc>\b({AmRegex}|{PmRegex})\s+)({HourRegex}(\s*)?:(\s*)?{MinuteFromRegex}|{HourNumFromRegex}|{PeriodHourNumFromRegex})))\s*(?<time2>((?<rightDesc>\b({AmRegex}|{PmRegex})\s+)({HourRegex}(\s*)?:(\s*)?{MinuteToRegex}|{HourNumToRegex}|{PeriodHourNumToRegex})))\s*{TillRegex})|((?<time1>((?<leftDesc>\b{TimePrefix}\s+)?({HourRegex}(\s*)?:(\s*)?{MinuteFromRegex}|{HourNumFromRegex}|{PeriodHourNumFromRegex})))\s*(?<time2>((?<rightDesc>\b{TimePrefix}\s+)?({HourRegex}(\s*)?:(\s*)?{MinuteToRegex}|{HourNumToRegex}|{PeriodHourNumToRegex})))\s*{TillRegex}))\b";
      public static readonly string SpecificTimeBetweenAnd = $@"(?<time1>({TimeRegex2}|{HourRegex}|{PeriodHourNumRegex}))\s*{RangeConnectorRegex}\s*(?<time2>({TimeRegex2}|{HourRegex}|{PeriodHourNumRegex}))(\s*{RangePrefixRegex}\b)?";
      public const string SuffixAfterRegex = @"\b((veya|ve|ya da)(\s+daha)?\s+(sonrasında|sonrası|sonra))\b";
      public const string PrepositionRegex = @"(?<prep>^(günü|'d[ae]|'t[ae]|,)$)";
      public const string LaterEarlyRegex = @"((?<early>(erkenden|erken(\s+saatte)?))|(?<late>geç(\s+saatte)?))";
      public static readonly string TimeOfDayRegex = $@"\b(?<timeOfDay>((sabah|öğleden\s+sonra|öğle(?!\s+yemeği)|akşam|gece|gün|mesai)(ın?|in|nin|ün|leyin|ları|leri|lik|de|si)?\b(\s+{LaterEarlyRegex})?(\s+(saat(inde|te|lerinde|leri)|vaktinde|vakti|vakitlerinde))?|iş\s+(saat(inde|te|lerinde|leri)|vaktinde|vakti|vakitlerinde))(\s+(içinde|içi|dışında|dışı)\b)?)";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{TimeOfDayRegex})\b|\bbu\s(sabah|akşam|gece))\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public static readonly string[] BusinessHourSplitStrings = { @"iş", @"saat" };
      public const string NowRegex = @"\b(?<now>(hemen\s+)?şimdi|(mümkün\s+olan\s+)?en\s+kısa\s+(sürede|zamanda)|ilk\s+fırsatta|bir\s+an\s+(önce|evvel)|hemen|vakit\s+geçirmeden|(mümkün\s+olduğunca|olabildiğince)\s+çabuk|son\s+(dönemlerde|zamanlarda|günlerde)|geçenlerde|yakınlarda|(bu|şu)\s+sıralar|yakın\s+zamanda|(bu|şu)\s+günlerde|önceden|evvelce|bundan\s+önce|şu\s+an(da(ki)?)?)\b";
      public const string SuffixRegex = @"\b(sabahı?|sabahleyin|sabahtan|öğleden\s+sonra|akşamı?|akşamleyin|gece(si)?|geceleyin)\b";
      public const string ExcludeSuffixRegex = @"^'\p{L}*\s+(?<match>.+)$";
      public const string ExcludeSuffixDateTime = @"^'\p{L}*(?<match>.*)$";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>sabah|öğleden\s+sonra|akşam|gece)\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})\b|\b(bu\s+akşam|bu\s+gece))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?\s*$";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"\b{DateTimeSpecificTimeOfDayRegex}(\s*,)?\s*({HourNumRegex}|{BaseDateTime.HourRegex})(\s+(civarı(nda)?|dolaylarında|sularında))?\b";
      public const string SpecificEndOfRegex = @"(('?ın|gün)\s+)?sonu(nda)?\b";
      public const string UnspecificEndOfRegex = @"\b(günün\s+sonu(nd?a))\b";
      public const string UnspecificEndOfRangeRegex = @"^[\*]";
      public static readonly string PeriodTimeOfDayRegex = $@"\b(((?<timeOfDay>sabahın|öğlenin|akşamın|gecenin)\s+(erken|geç)\s+saatlerinde)\b|((?<timeOfDay>sabahı?(?=a?\b)|öğleden\s+sonra(?=(dan)?\b)|akşamı?\b|gece(si)?\b)(\s+{LaterEarlyRegex}\b)?)|(bu\s+)?{DateTimeTimeOfDayRegex}\b)";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{PeriodTimeOfDayRegex})\b|\b(bu akşam|bu gece))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"(^|\b)((\s+){PeriodTimeOfDayRegex})";
      public const string LessThanRegex = @"((den|dan|ten|tan|daha)\s+az|\baz)(\s+bir\s+süre(de)?\b)?";
      public const string MoreThanRegex = @"((den|dan|ten|tan|\bdaha)\s+fazla|\bfazla|daha\s+fazla\s+zaman)(\s+bir\s+süre(de)?\b)?";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|saat|saniye|dakika|sa\.?\b|dk\.?\b|sn\.?\b|s\.?\b)";
      public const string SuffixAndRegex = @"(?<suffix>\s*(ve\s+)?(?<suffix_num>buçuk|çeyrek))";
      public const string PeriodicRegex = @"\b(?<periodic>(?<daily>günlük)|(?<weekly>haftalık)|(?<biweekly>(iki\s+)?haftada\s+bir)|(?<monthly>aylık|ayda\s+bir)|(?<yearly>yıllık|senelik|yılda\s+bir|her\s+sene|senede\s+bir))\b";
      public static readonly string EachUnitRegex = $@"(?<each>(her)\s*(bir)?\s*{DurationUnitRegex})";
      public const string EachPrefixRegex = @"\b(?<each>(her)\s*$)";
      public const string SetEachRegex = @"\b(?<each>(her)\s*)";
      public const string SetLastRegex = @"(?<last>izleyen|(bir\s+)?sonraki|ertesi|gelecek|bu|geçen|geçmiş|geçtiğimiz|son|önceki|evvelsi|şimdiki)";
      public const string EachDayRegex = @"^\s*her\s*gün\b";
      public static readonly string DurationFollowedUnit = $@"(^\s*{DurationUnitRegex}\s+{SuffixAndRegex}(\s+{DurationUnitRegex})?)|(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"\b(bir((?<half>\s+buçuk)|\s+diğeri?)?|diğer)\s+{DurationUnitRegex}";
      public const string DuringRegex = @"\b(?<unit>gün|hafta|ay|yıl)\s+boyunca\b";
      public const string AllRegex = @"\b(?<all>(tüm|bütün)\s+(?<unit>gün(lüğüne)?|hafta(lığına)?|ay(lığına)?|yıl(lığına)?)|gün boyu)\b";
      public const string HalfRegex = @"(?<half>yarım\s+(?<unit>saat|gün|iş\s+günü|hafta|ay|yıl))";
      public const string ConjunctionRegex = @"\b(ve|ile)\b";
      public static readonly string HolidayRegex1 = $@"\b(({YearRegex}(\s+yılının)?|{RelativeRegex}\s+yıl(ın)?)\s+)?(?<holiday>mardi gras|((washington'ın|mao'nun) doğum günü)|çin yeni yılı|yılbaşı gecesi|yılbaşı|yuan dan|noel arifesi|noel günü|noel|kara cuma|yuandan|paskalya|temiz pazartesi|kül çarşambası|palm sunday|(kutsal (perşembe|cuma))|(beyaz (pazartesi|pazar))|trinity sunday|hamsin yortusu|corpus christi|siber pazartesi|(ramazan|şeker|kurban|(29 ekim )?cumhuriyet|(30 ağustos )?zafer|(23 nisan )?ulusal egemenlik ve çocuk|(19 mayıs )?atatürk'ü anma(\s*,\s*)? gençlik ve spor)\sbayramı|(15 temmuz )?demokrasi ve mill(î|i) birlik günü)\b";
      public static readonly string HolidayRegex2 = $@"\b(({YearRegex}(\s+yılının)?|{RelativeRegex}\s+yıl(ın)?)\s+)?(?<holiday>(şükran|tüm azizler|aziz patrick|amerikan bağımsızlık|azizler|bütün ruhlar|guy fawkes|cinco de mayo|1 nisan şaka|tomb\s*sweeping)\sgünü|white lover day|aya yorgi yortusu|cadılar bayramı|((qingming|dragon)\sfestivali))\b";
      public static readonly string HolidayRegex3 = $@"(({YearRegex}(\s+yılının)?|{RelativeRegex}\s+yıl(ın)?)\s+)?(?<holiday>(bağımsızlık|başkanlar|mlk|martin luther king( jr)?|canberra|(isa'nın (göğe yükselişi|miracı))|columbus|ağaç( dikme)?|ağaçlandırma|(1 mayıs )?emek ve dayanışma|anneler|babalar|(dünya)?\s(kadınlar|bekarlar)|öğretmenler|gençlik|kızlar|sevgililer|dünya|dağ sıçanı|bastille|gaziler|anma|ay|bahar|fener)\s+günü|((işçi|quebec ulusal) bayramı)|abd başkanı yemin töreni|ay festivali)";
      public const string AMTimeRegex = @"(?<am>sabah)";
      public const string NowTimeRegex = @"(şimdi|şu\s+an(da(ki)?)?)";
      public const string RecentlyTimeRegex = @"(son\s+(zamanlarda|günlerde|dönemlerde)|yakın\s+zamanda|önceden)";
      public const string AsapTimeRegex = @"((mümkün\s+olan\s+)?en\s+kısa\s+sürede)";
      public const string PMTimeRegex = @"\b(?<pm>öğleden sonra|öğle vakti|öğlenleyin|öğlen|öğle|akşam|gece)\b";
      public const string LastRegex = @"(son)";
      public const string InclusiveModPrepositions = @"(?<include>(('(ü|u|te|ta|da|de|inde|sinde|ünde|ında|unda|sında)\s+)?(ya\s+da|veya)\b))";
      public static readonly string BeforeRegex = $@"((({InclusiveModPrepositions}|(?<=günü)nden|'?(den?|tan?|ten?|y?[ea])|('|(?<!başın))dan?)\s+(önce(sind?e|ki)|daha\s+önce(sinde)?|önce(\b|(?=dır|dir))|evvel|(daha|en)\s+(erken)|kadar(?!\s+erken)|en\s+geç)|(öncesinde|öncesine|daha\s+önce|(daha|en)\s+(geç|erken)|kadar)\s+{InclusiveModPrepositions})|en\s+geç\s*?|önce\b|(?<include>kadar\s+geç)|kadar(?!\s+erken)|ile\s+biten|(?<!\w|>)((?<include><=)|<))";
      public static readonly string BeforeRegexWithAnchor = $@"((^({InclusiveModPrepositions}|nden|'?(den?|tan?|ten?|y?[ea])|('|(?<!başın))dan?)\s+(önce(sind?e|ki)|daha\s+önce(sinde)?|önce(\b|(?=dır|dir))|evvel|(daha|en)\s+(erken)|kadar(?!\s+erken)|en\s+geç)|(öncesinde|öncesine|daha\s+önce|(daha|en)\s+(geç|erken)|kadar)\s+{InclusiveModPrepositions})|en\s+geç\s*?|^önce\b|^(?<include>kadar\s+geç)|^kadar(?!\s+erken)|ile\s+biten|(?<!\w|>)((?<include><=)|<))";
      public static readonly string AfterRegex = $@"((({InclusiveModPrepositions}|(?<=günü)nden|'(dan?|den?|tan?|ten?|y?[ea]))\s+(sonrasında|daha\s+(sonra|geç|büyük\s+(bir\s+)?yıl(ın)?)|sonra)(?!\s+veya\s+aynı)|(sonrasında|daha\s+sonra|sonra)\s+{InclusiveModPrepositions}|sonra\b)|(?<!\w|<)((?<include>>=)|>))";
      public static readonly string AfterRegexWithAnchor = $@"((^({InclusiveModPrepositions}|nden|'(dan?|den?|tan?|ten?|y?[ea]))\s+(sonrasında|daha\s+(sonra|geç|büyük\s+(bir\s+)?yıl(ın)?)|sonra)(?!\s+veya\s+aynı)|(sonrasında|daha\s+sonra|sonra)\s+{InclusiveModPrepositions}|^sonra\b)|(?<!\w|<)((?<include>>=)|>))";
      public const string SinceRegex = @"((('|\b)(([dt][ae]n\s+)?beri|sonra\s+veya\s+aynı|((den|dan|ile)\s+)?(başlayarak|başlayan|(itibaren\s+)?herhangi\s+bir\s+zamanda)|(y[ae]\s+)?eşit\s+veya\s+sonraki|bu\s+yana|erkenden|kadar\s+erken|herhangi\s+bir\s+zamanda|((nın\s+)?başından\s+)itibaren)\b)|(?<!\w|<)(>=))";
      public const string SinceRegexWithAnchor = @"(((^'|\b)(([dt][ae]n\s+)?beri|sonra\s+veya\s+aynı|((den|dan|ile)\s+)?(başlayarak|başlayan|(itibaren\s+)?herhangi\s+bir\s+zamanda)|(y[ae]\s+)?eşit\s+veya\s+sonraki|bu\s+yana|erkenden|kadar\s+erken|herhangi\s+bir\s+zamanda|((nın\s+)?başından\s+)itibaren)\b)|(?<!\w|<)(>=))";
      public const string AroundRegex = @"(?:\b((?:takriben|yaklaşık)\s*|\s*(?:civarı(nd?a)?|dolaylarında|sularında))\b)";
      public const string AgoRegex = @"\b((?<day>bugünden|gün|dünden|dün)\s+)?(önce(ki)?|evvel)\b";
      public const string LaterRegex = @"\b((?<day>yarından|yarın|bugünden|gün)\s+(itibaren|sonra(ki)?)|sonra|şu\s+andan\s+itibaren)(\s+gelecek)?";
      public const string BeforeAfterRegex = @"^[.]";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string InConnectorRegex = @"\b(içinde)\b";
      public const string SinceNumSuffixRegex = @"\b^(?!0)(\d{0,3}((1|2|7|8)'den|(3|4|5)'ten|(6|9)'dan)|\d{0,2}(10'dan|20'den|30'dan|40'tan|50'den|60'tan|70'ten|80'den|90'dan|00'den)|\d000'den)\b";
      public static readonly string SinceYearSuffixRegex = $@"({YearSuffix}\s+(yılından beri)|{SinceNumSuffixRegex}\s+beri)";
      public static readonly string WithinNextPrefixRegex = $@"\b((?<next>{NextPrefixRegex}\s+)?(\d+\s+(saniye|dakika|saat|gün|hafta|ay|yıl)\s+)?içinde)\b";
      public const string TodayNowRegex = @"\b(bugün|şimdi)\b";
      public const string MorningStartEndRegex = @"(^sabahı?$)";
      public const string AfternoonStartEndRegex = @"(^öğle(den\s+sonra)?$)";
      public const string EveningStartEndRegex = @"(^akşamı?$)";
      public const string NightStartEndRegex = @"(^(geceleyin|bu gece|gece))|((geceleyin|bu gece|gece)$)";
      public const string InexactNumberRegex = @"\b(birkaç|(?<NumTwoTerm>iki))\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"(({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({TimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))(?!\s+\d+\s+{DurationUnitRegex})";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+(?<duration>hafta\s*sonu|hafta\s*sonları|(hafta|ay|yıl)(lar)?|sene(ler)?)\b";
      public const string ConnectorRegex = @"^(-|,|civarı|@)$";
      public const string FromRegex = @"(\bitibaren|'d[ae]n|'t[ae]n)$";
      public const string PluralTokenRegex = @"(ları|leri)$";
      public const string FromToRegex = @"\b.+('?(den|dan|ten|tan)).+('?y?(e|a))\b";
      public static readonly string RelativeAtDateTimeUnitRegex = $@"(({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({AtDateTimeUnitRegex}))";
      public const string SingleAmbiguousMonthRegex = @"^(ocak|mayıs|ekim|aralık|tem|ara)$";
      public const string SingleAmbiguousTermsRegex = @"^(gün|hafta|ay|yıl)$";
      public const string UnspecificDatePeriodRegex = @"^(hafta(\s*sonu)|ay)$";
      public const string PrepositionSuffixRegex = @"^[\*]";
      public const string WrittenDayRegex = @"(?<day>bir|iki|üç|dört|beş|altı|yedi|sekiz|dokuz|on|on\s+bir|on\s+iki|on\s+üç|on\s+dört|on\s+beş|on\s+altı|on\s+yedi|on\s+sekiz|on\s+dokuz|yirmi|yirmi\s+bir|yirmi\s+iki|yirmi\s+üç|yirmi\s+dört|yirmi\s+beş|yirmi\s+altı|yirmi\s+yedi|yirmi\s+sekiz|yirmi\s+dokuz|otuz|otuz\s+bir)";
      public static readonly string FlexibleDayRegex = $@"(?<DayOfMonth>({WrittenDayRegex}|{DayRegex}))";
      public static readonly string ForTheRegex = $@"\b(?<!{SingleWeekDayRegex}\s+)(?<DayOfMonth>{FlexibleDayRegex}((?='(ü|te|inde|sinde|ünde|ında|unda|sında))|(i|ü|si)(?=nde)|(?='(ı|u))|(ı|u|sı)(?=nda)))(?!'(inci|üncü|ıncı|nci|uncu)\s+hafta)";
      public static readonly string ForTheRegex1 = $@"\b(?<DayOfMonth>({FlexibleDayRegex})((?=('))|(i|ü|si)(?=nde)|(ı|u|sı)(?=nda|na)|(?=n[ae])|(?=(i|ü|ı|u|si|sı)\b)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b({SingleWeekDayRegex}(\s+günü)?\s+{ForTheRegex1}|(?<DayOfMonth>({FlexibleDayRegex}))\s+{SingleWeekDayRegex})";
      public static readonly string WeekDayAndDayRegex = $@"\b{SingleWeekDayRegex}(\s+günü)?\s+({DayRegex}|{FlexibleDayRegex})(?=(nde|nda|nden|ne)\b)";
      public const string RestOfDateRegex = @"\b((bu\s+)?(?<duration>haftanın|ayın|yılın|haftamın|ayımın|yılımın)\s+(geri\s+kalanı(?=nda)?))";
      public const string RestOfDateTimeRegex = @"\b((?<unit>günün|günümün|bugünün)\s+(geri\s+kalanı(?=nda)?))";
      public const string MealTimeRegex = @"\b(at\s+)?(?<mealTime>öğle yemeği zamanı|öğle yemeği vakti)\b";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public static readonly string NumberEndingPattern = $@"^(?<newTime>{PeriodAtHourNumRegex}|{HourRegex}((\.)?$|(\.,|,|!|\?)))\s+(?<meeting>toplantı|randevu|konferans|çağrı|skype\s(araması|görüşmesi))";
      public const string OneOnOneRegex = @"\b(1\s*:\s*1(?!\d))|(bire bir|bir\s*-\s*bir|bir\s*:\s*bir)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b((?<suffix>{OneWordPeriodRegex}|{MonthPossessiveSuffixRegex})\s*\b\s*({PrefixPeriodRegex}))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|bu)\s+hafta|haftaya)\s+(({WeekDayRegex}\s+(ile|ve)\s+{WeekDayRegex}\s+arası(nda)?)|({WeekDayRegex}\s+gününden\s+{WeekDayRegex}\s+gününe\s+{TillRegex})))\b";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|ile|ila|ve|,)\s*$";
      public const string PrefixArticleRegex = @"^[\*]";
      public const string OrRegex = @"\s*((\b|,\s*)(ve|veya|ya da)\b|,)\s*";
      public static readonly string SpecialYearTermsRegex = $@"\b(yılı)";
      public static readonly string YearPlusNumberRegex = $@"\b(((?<year>(\d{{3,4}}))|{FullTextYearRegex})\s+{SpecialYearTermsRegex})";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b({PeriodHourNumFromRegex}|{HourNumFromRegex}|{HourRegex}:{MinuteFromRegex})\s+(önce|sonra)\b";
      public const string DateNumberConnectorRegex = @"^[\*]";
      public const string DecadeRegex = @"(?<decade>yirmiler|otuzlar|kırklar|elliler|altmışlar|yetmişler|seksenler|doksanlar|iki binler|(yirmili|otuzlu|kırklı|ellili|altmışlı|yetmişli|seksenli|doksanlı|iki binli)\s+yıllar)";
      public static readonly string DecadeWithCenturyRegex = $@"(((?<century>\d|1\d|2\d)?(?<decade>\d0))((')?ler|(')?lar)|(({CenturyRegex}\s+)?{DecadeRegex})|({CenturyRegex}\s+(?<decade>onlar|yüzler)))";
      public static readonly string RelativeDecadeRegex = $@"\b({RelativeRegex}\s+((?<number>[\w,]+)\s+)?(yüzyıl?|on\s+yıl))";
      public static readonly string YearPeriodRegex = $@"(({YearRegex}\s+(yılından)\s+{YearRegex}\s+(yılına\s+kadar))|({YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}(\s+((yılları\s+)?arası(?=nda)?|yıllarında|yılları sırasında)))|(({YearRegex}\s*{TillConnectorRegex}\s*{YearRegex})(\s+{TillRegex})?))";
      public static readonly string StrictTillRegex = $@"(?<till>((e|a)(\s+kadar)?)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s*,\s*))))";
      public static readonly string StrictRangeConnectorRegex = $@"(?<and>\b(ile|ila)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s*,\s*))))";
      public const string FromNumSuffixRegex = @"((1|2|7|8)'den|(3|4|5)'ten|(6|9)'dan|10'dan|20'den|30'dan|40'tan|50'den|60'tan|70'ten|80'den|90'dan|00'den|000'den)\b";
      public const string ToNumSuffixRegex = @"((1|2|7|20|50)'ye|(3|4|5|8|70|80|00|000)'e|6'ya|(9|10|30|40|60|90)'a)\b";
      public static readonly string ComplexDatePeriodRegex = $@"((?<start>.*[^'])\s*({RangeConnectorRegex})\s*(?<end>.*[^'\s]{{2}})\s*{RangePrefixRegex}|(?<start>.+({FromNumSuffixRegex}|{DayFromSuffixRegex}))\s*(?<end>.+({ToNumSuffixRegex}|{DayToSuffixRegex}))\s*({TillRegex})|((?<start>.*[^'])\s*{TillConnectorRegex}\s*(?<end>.*[^'\s]{{2}})(\s*{TillRegex})?))";
      public static readonly string FailFastRegex = $@"{BaseDateTime.DeltaMinuteRegex}|\b({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex})|{BaseDateTime.BaseAmPmDescRegex}|\b(zero|{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}|{WrittenMonthRegex}|{SeasonDescRegex}|{DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\d(-|——)?ish|((the\s+\w*)|\d)(th|rd|nd|st)|(mid\s*(-\s*)?)?(night|morning|afternoon|day)s?|evenings?||noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|minutes?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\b|{WeekDayRegex}|{SetWeekDayRegex}|{NowRegex}|{PeriodicRegex}|\b({DateUnitRegex}|{ImplicitDayRegex})";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"yüzyıl", @"100Y" },
            { @"yüzyıllar", @"100Y" },
            { @"yıl", @"Y" },
            { @"yılı", @"Y" },
            { @"yıllar", @"Y" },
            { @"yılın", @"Y" },
            { @"yıllığına", @"Y" },
            { @"yılki", @"Y" },
            { @"yıla ait", @"Y" },
            { @"sene", @"Y" },
            { @"seneki", @"Y" },
            { @"seneye ait", @"Y" },
            { @"senesi", @"Y" },
            { @"senenin", @"Y" },
            { @"ay", @"MON" },
            { @"aylar", @"MON" },
            { @"ayın", @"MON" },
            { @"aylığına", @"MON" },
            { @"ayki", @"MON" },
            { @"aya ait", @"MON" },
            { @"hafta", @"W" },
            { @"haftaki", @"W" },
            { @"haftalar", @"W" },
            { @"haftam", @"W" },
            { @"haftanın", @"W" },
            { @"haftamın", @"W" },
            { @"haftası", @"W" },
            { @"haftalığına", @"W" },
            { @"haftaya ait", @"W" },
            { @"gün", @"D" },
            { @"günler", @"D" },
            { @"günün", @"D" },
            { @"bugünün", @"D" },
            { @"günkü", @"D" },
            { @"güne ait", @"D" },
            { @"günümün", @"D" },
            { @"günlüğüne", @"D" },
            { @"saat", @"H" },
            { @"saatler", @"H" },
            { @"dakika", @"M" },
            { @"dakikalar", @"M" },
            { @"dk.", @"M" },
            { @"saniye", @"S" },
            { @"saniyeler", @"S" },
            { @"sn.", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"yüzyıl", 3153600000 },
            { @"yüzyıllar", 3153600000 },
            { @"yy.", 3153600000 },
            { @"yıl", 31536000 },
            { @"yılı", 31536000 },
            { @"yıllar", 31536000 },
            { @"yılın", 31536000 },
            { @"yıllığına", 31536000 },
            { @"yıla ait", 31536000 },
            { @"sene", 31536000 },
            { @"seneki", 31536000 },
            { @"seneye ait", 31536000 },
            { @"senesi", 31536000 },
            { @"senenin", 31536000 },
            { @"ay", 2592000 },
            { @"aylar", 2592000 },
            { @"ayın", 2592000 },
            { @"aylığına", 2592000 },
            { @"ayki", 2592000 },
            { @"aya ait", 2592000 },
            { @"hafta", 604800 },
            { @"haftalar", 604800 },
            { @"haftam", 604800 },
            { @"haftanın", 604800 },
            { @"haftamın", 604800 },
            { @"haftası", 604800 },
            { @"haftalığına", 604800 },
            { @"haftaki", 604800 },
            { @"haftaya ait", 604800 },
            { @"gün", 86400 },
            { @"günler", 86400 },
            { @"günü", 86400 },
            { @"günlüğüne", 86400 },
            { @"güne ait", 86400 },
            { @"saat", 3600 },
            { @"saatler", 3600 },
            { @"sa.", 3600 },
            { @"dakika", 60 },
            { @"dakikalar", 60 },
            { @"dk.", 60 },
            { @"saniye", 1 },
            { @"saniyeler", 1 },
            { @"sn.", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscal", @"FY" },
            { @"school", @"SY" },
            { @"fy", @"FY" },
            { @"sy", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"ilkbahar", @"SP" },
            { @"ilkbaharı", @"SP" },
            { @"bahar", @"SP" },
            { @"baharı", @"SP" },
            { @"yaz", @"SU" },
            { @"yazı", @"SU" },
            { @"yazın", @"SU" },
            { @"sonbahar", @"FA" },
            { @"sonbaharı", @"FA" },
            { @"kış", @"WI" },
            { @"kışı", @"WI" },
            { @"kışın", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"ilk", 1 },
            { @"birinci", 1 },
            { @"1'inci", 1 },
            { @"1.", 1 },
            { @"ikinci", 2 },
            { @"2'inci", 2 },
            { @"2.", 2 },
            { @"üçüncü", 3 },
            { @"3'üncü", 3 },
            { @"3.", 3 },
            { @"dördüncü", 4 },
            { @"4'üncü", 4 },
            { @"4.", 4 },
            { @"beşinci", 5 },
            { @"5'inci", 5 },
            { @"5.", 5 },
            { @"son", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"pazartesi", 1 },
            { @"pazartesisi", 1 },
            { @"salı", 2 },
            { @"salısı", 2 },
            { @"çarşamba", 3 },
            { @"çarşambası", 3 },
            { @"perşembe", 4 },
            { @"perşembesi", 4 },
            { @"cuma", 5 },
            { @"cuması", 5 },
            { @"cumartesi", 6 },
            { @"cumartesisi", 6 },
            { @"pazar", 0 },
            { @"pazarı", 0 },
            { @"pzt", 1 },
            { @"sal", 2 },
            { @"çrş", 3 },
            { @"per", 4 },
            { @"cum", 5 },
            { @"cts", 6 },
            { @"paz", 0 },
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"ocak", 1 },
            { @"ocak'ın", 1 },
            { @"ocak'tan", 1 },
            { @"ocaktan", 1 },
            { @"ocak'dan", 1 },
            { @"ocakdan", 1 },
            { @"ocak'a", 1 },
            { @"ocaka", 1 },
            { @"ocağa", 1 },
            { @"şubat", 2 },
            { @"şubat'ın", 2 },
            { @"şubat'tan", 2 },
            { @"şubattan", 2 },
            { @"şubat'dan", 2 },
            { @"şubatdan", 2 },
            { @"şubat'a", 2 },
            { @"şubata", 2 },
            { @"mart", 3 },
            { @"mart'ın", 3 },
            { @"mart'tan", 3 },
            { @"marttan", 3 },
            { @"mart'dan", 3 },
            { @"martdan", 3 },
            { @"mart'a", 3 },
            { @"marta", 3 },
            { @"nisan", 4 },
            { @"nisan'ın", 4 },
            { @"nisan'dan", 4 },
            { @"nisandan", 4 },
            { @"nisan'a", 4 },
            { @"nisana", 4 },
            { @"mayıs", 5 },
            { @"mayıs'ın", 5 },
            { @"mayıs'tan", 5 },
            { @"mayıstan", 5 },
            { @"mayıs'dan", 5 },
            { @"mayısdan", 5 },
            { @"mayıs'a", 5 },
            { @"mayısa", 5 },
            { @"haziran", 6 },
            { @"haziran'ın", 6 },
            { @"haziran'dan", 6 },
            { @"hazirandan", 6 },
            { @"haziran'a", 6 },
            { @"hazirana", 6 },
            { @"temmuz", 7 },
            { @"temmuz'un", 7 },
            { @"temmuz'dan", 7 },
            { @"temmuzdan", 7 },
            { @"temmuz'a", 7 },
            { @"temmuza", 7 },
            { @"ağustos", 8 },
            { @"ağustos'un", 8 },
            { @"ağustos'tan", 8 },
            { @"ağustostan", 8 },
            { @"ağustos'dan", 8 },
            { @"ağustosdan", 8 },
            { @"ağustos'a", 8 },
            { @"ağustosa", 8 },
            { @"eylül", 9 },
            { @"eylül'ün", 9 },
            { @"eylül'den", 9 },
            { @"eylülden", 9 },
            { @"eylül'e", 9 },
            { @"eylüle", 9 },
            { @"ekim", 10 },
            { @"ekim'in", 10 },
            { @"ekim'den", 10 },
            { @"ekimden", 10 },
            { @"ekim'e", 10 },
            { @"ekime", 10 },
            { @"kasım", 11 },
            { @"kasım'ın", 11 },
            { @"kasım'dan", 11 },
            { @"kasımdan", 11 },
            { @"kasım'a", 11 },
            { @"kasıma", 11 },
            { @"aralık", 12 },
            { @"aralık'ın", 12 },
            { @"aralık'tan", 12 },
            { @"aralıktan", 12 },
            { @"aralık'dan", 12 },
            { @"aralıkdan", 12 },
            { @"aralık'a", 12 },
            { @"aralıka", 12 },
            { @"aralığa", 12 },
            { @"oca", 1 },
            { @"şub", 2 },
            { @"mar", 3 },
            { @"nis", 4 },
            { @"may", 5 },
            { @"haz", 6 },
            { @"tem", 7 },
            { @"ağu", 8 },
            { @"eyl", 9 },
            { @"eki", 10 },
            { @"kas", 11 },
            { @"ara", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 },
            { @"1. ayı", 1 },
            { @"2. ayı", 2 },
            { @"3. ayı", 3 },
            { @"4. ayı", 4 },
            { @"5. ayı", 5 },
            { @"6. ayı", 6 },
            { @"7. ayı", 7 },
            { @"8. ayı", 8 },
            { @"9. ayı", 9 },
            { @"10. ayı", 10 },
            { @"11. ayı", 11 },
            { @"12. ayı", 12 },
            { @"01. ayı", 1 },
            { @"02. ayı", 2 },
            { @"03. ayı", 3 },
            { @"04. ayı", 4 },
            { @"05. ayı", 5 },
            { @"06. ayı", 6 },
            { @"07. ayı", 7 },
            { @"08. ayı", 8 },
            { @"09. ayı", 9 },
            { @"1'inci", 1 },
            { @"2'inci", 2 },
            { @"3'üncü", 3 },
            { @"4'üncü", 4 },
            { @"5'inci", 5 },
            { @"6'ıncı", 6 },
            { @"7'nci", 7 },
            { @"8'inci", 8 },
            { @"9'uncu", 9 },
            { @"10'inci", 10 },
            { @"10'uncu", 10 },
            { @"11'inci", 11 },
            { @"12'inci", 12 },
            { @"12'nci", 12 },
            { @"1.", 1 },
            { @"2.", 2 },
            { @"3.", 3 },
            { @"4.", 4 },
            { @"5.", 5 },
            { @"6.", 6 },
            { @"7.", 7 },
            { @"8.", 8 },
            { @"9.", 9 },
            { @"10.", 10 },
            { @"11.", 11 },
            { @"12.", 12 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"sıfır", 0 },
            { @"bir", 1 },
            { @"iki", 2 },
            { @"üç", 3 },
            { @"dört", 4 },
            { @"dörd", 4 },
            { @"beş", 5 },
            { @"altı", 6 },
            { @"yedi", 7 },
            { @"sekiz", 8 },
            { @"dokuz", 9 },
            { @"on", 10 },
            { @"on bir", 11 },
            { @"on iki", 12 },
            { @"on üç", 13 },
            { @"on dört", 14 },
            { @"on dörd", 14 },
            { @"on beş", 15 },
            { @"on altı", 16 },
            { @"on yedi", 17 },
            { @"on sekiz", 18 },
            { @"on dokuz", 19 },
            { @"yirmi", 20 },
            { @"yirmi bir", 21 },
            { @"yirmi iki", 22 },
            { @"yirmi üç", 23 },
            { @"yirmi dört", 24 },
            { @"yirmi dörd", 24 },
            { @"yirmi beş", 25 },
            { @"yirmi altı", 26 },
            { @"yirmi yedi", 27 },
            { @"yirmi sekiz", 28 },
            { @"yirmi dokuz", 29 },
            { @"otuz", 30 },
            { @"otuz bir", 31 },
            { @"otuz iki", 32 },
            { @"otuz üç", 33 },
            { @"otuz dört", 34 },
            { @"otuz dörd", 34 },
            { @"otuz beş", 35 },
            { @"otuz altı", 36 },
            { @"otuz yedi", 37 },
            { @"otuz sekiz", 38 },
            { @"otuz dokuz", 39 },
            { @"kırk", 40 },
            { @"kırk bir", 41 },
            { @"kırk iki", 42 },
            { @"kırk üç", 43 },
            { @"kırk dört", 44 },
            { @"kırk dörd", 44 },
            { @"kırk beş", 45 },
            { @"kırk altı", 46 },
            { @"kırk yedi", 47 },
            { @"kırk sekiz", 48 },
            { @"kırk dokuz", 49 },
            { @"elli", 50 },
            { @"elli bir", 51 },
            { @"elli iki", 52 },
            { @"elli üç", 53 },
            { @"elli dört", 54 },
            { @"elli dörd", 54 },
            { @"elli beş", 55 },
            { @"elli altı", 56 },
            { @"elli yedi", 57 },
            { @"elli sekiz", 58 },
            { @"elli dokuz", 59 },
            { @"altmış", 60 },
            { @"altmış bir", 61 },
            { @"altmış iki", 62 },
            { @"altmış üç", 63 },
            { @"altmış dört", 64 },
            { @"altmış dörd", 64 },
            { @"altmış beş", 65 },
            { @"altmış altı", 66 },
            { @"altmış yedi", 67 },
            { @"altmış sekiz", 68 },
            { @"altmış dokuz", 69 },
            { @"yetmiş", 70 },
            { @"yetmiş bir", 71 },
            { @"yetmiş iki", 72 },
            { @"yetmiş üç", 73 },
            { @"yetmiş dört", 74 },
            { @"yetmiş dörd", 74 },
            { @"yetmiş beş", 75 },
            { @"yetmiş altı", 76 },
            { @"yetmiş yedi", 77 },
            { @"yetmiş sekiz", 78 },
            { @"yetmiş dokuz", 79 },
            { @"seksen", 80 },
            { @"seksen bir", 81 },
            { @"seksen iki", 82 },
            { @"seksen üç", 83 },
            { @"seksen dört", 84 },
            { @"seksen dörd", 84 },
            { @"seksen beş", 85 },
            { @"seksen altı", 86 },
            { @"seksen yedi", 87 },
            { @"seksen sekiz", 88 },
            { @"seksen dokuz", 89 },
            { @"doksan", 90 },
            { @"doksan bir", 91 },
            { @"doksan iki", 92 },
            { @"doksan üç", 93 },
            { @"doksan dört", 94 },
            { @"doksan dörd", 94 },
            { @"doksan beş", 95 },
            { @"doksan altı", 96 },
            { @"doksan yedi", 97 },
            { @"doksan sekiz", 98 },
            { @"doksan dokuz", 99 },
            { @"yüz", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"13", 13 },
            { @"14", 14 },
            { @"15", 15 },
            { @"16", 16 },
            { @"17", 17 },
            { @"18", 18 },
            { @"19", 19 },
            { @"20", 20 },
            { @"21", 21 },
            { @"22", 22 },
            { @"23", 23 },
            { @"24", 24 },
            { @"25", 25 },
            { @"26", 26 },
            { @"27", 27 },
            { @"28", 28 },
            { @"29", 29 },
            { @"30", 30 },
            { @"31", 31 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 },
            { @"1'i", 1 },
            { @"2'si", 2 },
            { @"3'ü", 3 },
            { @"4'ü", 4 },
            { @"5'i", 5 },
            { @"6'sı", 6 },
            { @"7'si", 7 },
            { @"8'i", 8 },
            { @"9'u", 9 },
            { @"10'u", 10 },
            { @"11'i", 11 },
            { @"12'si", 12 },
            { @"13'ü", 13 },
            { @"14'ü", 14 },
            { @"15'i", 15 },
            { @"16'sı", 16 },
            { @"17'si", 17 },
            { @"18'i", 18 },
            { @"19'u", 19 },
            { @"20'si", 20 },
            { @"21'i", 21 },
            { @"22'si", 22 },
            { @"23'ü", 23 },
            { @"24'ü", 24 },
            { @"25'i", 25 },
            { @"26'sı", 26 },
            { @"27'si", 27 },
            { @"28'i", 28 },
            { @"29'u", 29 },
            { @"30'u", 30 },
            { @"31'i", 31 },
            { @"01'i", 1 },
            { @"02'si", 2 },
            { @"03'ü", 3 },
            { @"04'ü", 4 },
            { @"05'i", 5 },
            { @"06'sı", 6 },
            { @"07'si", 7 },
            { @"08'i", 8 },
            { @"09'u", 9 },
            { @"1'inden", 1 },
            { @"2'sinden", 2 },
            { @"3'ünden", 3 },
            { @"4'ünden", 4 },
            { @"5'inden", 5 },
            { @"6'sından", 6 },
            { @"7'sinden", 7 },
            { @"8'inden", 8 },
            { @"9'undan", 9 },
            { @"10'undan", 10 },
            { @"11'inden", 11 },
            { @"12'sinden", 12 },
            { @"13'ünden", 13 },
            { @"14'ünden", 14 },
            { @"15'inden", 15 },
            { @"16'sından", 16 },
            { @"17'sinden", 17 },
            { @"18'inden", 18 },
            { @"19'undan", 19 },
            { @"20'sinden", 20 },
            { @"21'inden", 21 },
            { @"22'sinden", 22 },
            { @"23'ünden", 23 },
            { @"24'ünden", 24 },
            { @"25'inden", 25 },
            { @"26'sından", 26 },
            { @"27'sinden", 27 },
            { @"28'inden", 28 },
            { @"29'undan", 29 },
            { @"30'undan", 30 },
            { @"31'inden", 31 },
            { @"01'inden", 1 },
            { @"02'sinden", 2 },
            { @"03'ünden", 3 },
            { @"04'ünden", 4 },
            { @"05'inden", 5 },
            { @"06'sından", 6 },
            { @"07'sinden", 7 },
            { @"08'inden", 8 },
            { @"09'undan", 9 },
            { @"1'ine", 1 },
            { @"2'sine", 2 },
            { @"3'üne", 3 },
            { @"4'üne", 4 },
            { @"5'ine", 5 },
            { @"6'sına", 6 },
            { @"7'sine", 7 },
            { @"8'ine", 8 },
            { @"9'una", 9 },
            { @"10'una", 10 },
            { @"11'ine", 11 },
            { @"12'sine", 12 },
            { @"13'üne", 13 },
            { @"14'üne", 14 },
            { @"15'ine", 15 },
            { @"16'sına", 16 },
            { @"17'sine", 17 },
            { @"18'ine", 18 },
            { @"19'una", 19 },
            { @"20'sine", 20 },
            { @"21'ine", 21 },
            { @"22'sine", 22 },
            { @"23'üne", 23 },
            { @"24'üne", 24 },
            { @"25'ine", 25 },
            { @"26'sına", 26 },
            { @"27'sine", 27 },
            { @"28'ine", 28 },
            { @"29'una", 29 },
            { @"30'una", 30 },
            { @"31'ine", 31 },
            { @"01'ine", 1 },
            { @"02'sine", 2 },
            { @"03'üne", 3 },
            { @"04'üne", 4 },
            { @"05'ine", 5 },
            { @"06'sına", 6 },
            { @"07'sine", 7 },
            { @"08'ine", 8 },
            { @"09'una", 9 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"yarım", 0.5 },
            { @"buçuk", 0.5 },
            { @"buçuğa", 0.5 },
            { @"çeyrek", 0.25 },
            { @"çeyreği", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"easterday", new string[] { @"paskalya" } },
            { @"ashwednesday", new string[] { @"külçarşamba" } },
            { @"palmsunday", new string[] { @"palmsunday" } },
            { @"maundythursday", new string[] { @"kutsalperşembe" } },
            { @"goodfriday", new string[] { @"kutsalcuma" } },
            { @"eastersaturday", new string[] { @"eastersaturday" } },
            { @"eastermonday", new string[] { @"eastermonday" } },
            { @"ascensionday", new string[] { @"isanıngöğeyükselişi", @"isanınmiracı" } },
            { @"whitesunday", new string[] { @"beyazpazar" } },
            { @"whitemonday", new string[] { @"beyazpazartesi" } },
            { @"trinitysunday", new string[] { @"trinitysunday" } },
            { @"corpuschristi", new string[] { @"corpuschristi" } },
            { @"earthday", new string[] { @"dünyagünü" } },
            { @"fathers", new string[] { @"babalargünü" } },
            { @"mothers", new string[] { @"annelergünü" } },
            { @"thanksgiving", new string[] { @"şükrangünü" } },
            { @"blackfriday", new string[] { @"karacuma" } },
            { @"cybermonday", new string[] { @"siberpazartesi" } },
            { @"martinlutherking", new string[] { @"martinlutherkinggünü" } },
            { @"washingtonsbirthday", new string[] { @"washingtonındoğumgünü", @"başkanlargünü" } },
            { @"canberra", new string[] { @"canberragünü" } },
            { @"labour", new string[] { @"işçibayramı" } },
            { @"columbus", new string[] { @"columbusgünü" } },
            { @"memorial", new string[] { @"anmagünü" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"maosbirthday", new string[] { @"maonundoğumgünü" } },
            { @"teachersday", new string[] { @"öğretmenlergünü" } },
            { @"singleday", new string[] { @"dünyabekarlargünü", @"bekarlargünü" } },
            { @"allsaintsday", new string[] { @"tümazizlergünü" } },
            { @"youthday", new string[] { @"gençlikgünü" } },
            { @"childrenday", new string[] { @"dünyaçocukgünü" } },
            { @"femaleday", new string[] { @"kadınlargünü" } },
            { @"treeplantingday", new string[] { @"ağaçdikmegünü", @"ağaçgünü" } },
            { @"arborday", new string[] { @"ağaçlandırmagünü" } },
            { @"girlsday", new string[] { @"kızlargünü" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"sevgililergünü" } },
            { @"christmas", new string[] { @"noelgünü", @"noel" } },
            { @"xmas", new string[] { @"xmasday", @"xmas" } },
            { @"newyear", new string[] { @"yeniyıl" } },
            { @"newyearday", new string[] { @"yılbaşı" } },
            { @"newyearsday", new string[] { @"newyearsday" } },
            { @"inaugurationday", new string[] { @"abdbaşkanıyemintöreni" } },
            { @"groundhougday", new string[] { @"dağsıçanıgünü" } },
            { @"valentinesday", new string[] { @"sevgililergünü" } },
            { @"stpatrickday", new string[] { @"azizpatrickgünü" } },
            { @"aprilfools", new string[] { @"1nisanşakagünü" } },
            { @"stgeorgeday", new string[] { @"ayayorgiyortusu" } },
            { @"mayday", new string[] { @"1mayısemekvedayanışmagünü" } },
            { @"cincodemayoday", new string[] { @"cincodemayogünü" } },
            { @"baptisteday", new string[] { @"quebeculusalbayramı" } },
            { @"usindependenceday", new string[] { @"amerikabağımsızlıkgünü" } },
            { @"independenceday", new string[] { @"bağımsızlıkgünü" } },
            { @"bastilleday", new string[] { @"bastillegünü" } },
            { @"halloweenday", new string[] { @"cadılarbayramı" } },
            { @"allhallowday", new string[] { @"azizlergünü" } },
            { @"allsoulsday", new string[] { @"bütünruhlargünü" } },
            { @"guyfawkesday", new string[] { @"guyfawkesgünü" } },
            { @"veteransday", new string[] { @"gazilergünü" } },
            { @"christmaseve", new string[] { @"noelarifesi" } },
            { @"newyeareve", new string[] { @"yılbaşıgecesi" } },
            { @"ramadan", new string[] { @"ramazanbayramı", @"şekerbayramı" } },
            { @"sacrifice", new string[] { @"kurbanbayramı" } },
            { @"republic", new string[] { @"cumhuriyetbayramı", @"29ekimcumhuriyetbayramı" } },
            { @"victory", new string[] { @"zaferbayramı", @"30ağustoszaferbayramı" } },
            { @"children", new string[] { @"ulusalegemenlikveçocukbayramı", @"23nisanulusalegemenlikveçocukbayramı" } },
            { @"youth", new string[] { @"atatürküanmagençlikvesporbayramı", @"19mayısatatürküanmagençlikvesporbayramı" } },
            { @"democracy", new string[] { @"demokrasivemillibirlikgünü", @"demokrasivemillîbirlikgünü", @"15temmuzdemokrasivemillibirlikgünü", @"15temmuzdemokrasivemillîbirlikgünü" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"onlu yıllar", 10 },
            { @"onlar", 10 },
            { @"yirmili yıllar", 20 },
            { @"yirmiler", 20 },
            { @"otuzlu yıllar", 30 },
            { @"otuzlar", 30 },
            { @"kırklı yıllar", 40 },
            { @"kırklar", 40 },
            { @"ellili yıllar", 50 },
            { @"elliler", 50 },
            { @"altmışlı yıllar", 60 },
            { @"altmışlar", 60 },
            { @"yetmişli yıllar", 70 },
            { @"yetmişler", 70 },
            { @"seksenli yıllar", 80 },
            { @"seksenler", 80 },
            { @"doksanlı yıllar", 90 },
            { @"doksanlar", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"iki binler", 2000 },
            { @"iki binli yıllar", 2000 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly IList<string> SuperfluousWordList = new List<string>
        {
            @"tercihen",
            @"peki ya",
            @"belki",
            @"farzet",
            @"gibi"
        };
      public static readonly string[] DurationDateRestrictions = { @"bugün", @"şimdi", @"şu an" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"\bmart\b", @"\b(martin)\b" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"sabah",
            @"sabahı"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"öğle",
            @"öğlen",
            @"öğleden sonra"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"akşam",
            @"akşamı"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"gündüz"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"gece"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"bugün",
            @"bugünden",
            @"şu andan",
            @"aynı gün"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"yarın",
            @"yarına",
            @"yarından",
            @"ertesi",
            @"sonraki gün"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"dün",
            @"dünkü",
            @"dünden",
            @"önceki gün",
            @"son gün"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"yarından sonraki gün",
            @"yarından sonraki",
            @"yarından sonra"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"dünden önceki gün"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"bu",
            @"gelecek",
            @"önümüzdeki"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"geçen",
            @"son"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"ay",
            @"ayı",
            @"ayın",
            @"ayki",
            @"aya ait"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"ay başından beri",
            @"ayın başından beri",
            @"bu zamana kadarki ay"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"hafta sonu",
            @"hafta sonum",
            @"hafta sonundan",
            @"haftasonu",
            @"haftasonum",
            @"haftasonundan"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"hafta",
            @"haftam",
            @"haftanın",
            @"haftamın",
            @"haftası",
            @"haftaki",
            @"haftaya ait"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"yıl",
            @"yılın",
            @"sene",
            @"yıla ait",
            @"seneye ait"
        };
      public static readonly IList<string> GenericYearTerms = new List<string>
        {
            @"y"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"sene başından beri",
            @"bu zamana kadarki yıl"
        };
    }
}