﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Swedish\Swedish-DateTime.yaml
//     - Language: Swedish
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Swedish
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Swe";
      public const bool CheckBothBeforeAfter = false;
      public static readonly string TillRegex = $@"(?#TillRegex)(?<till>\b(till|tom)\b(\s+den\b)?|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string RangeConnectorRegex = $@"(?#RangeConnectorRegex)(?<and>\b(och|tom)\b(\s+den\b)?|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string LastNegPrefix = @"(?#LastNegPrefix)(?<!(w(ill|ould|on\s*'\s*t)|m(ay|ight|ust)|sh(all|ould(n\s*'\s*t)?)|c(an(\s*'\s*t|not)?|ould(n\s*'\s*t)?))(\s+not)?\s+)";
      public static readonly string RelativeRegex = $@"(?#RelativeRegex)\b(?<order>efter|nästa|kommande|de(nn|tt)a|de(n|t)\s+här|{LastNegPrefix}senaste|förra|tidigare|innevarande)\b";
      public static readonly string StrictRelativeRegex = $@"(?#StrictRelativeRegex)\b(?<order>efter|nästa|kommande|de(nn|tt)a|de(n|t)\s+här|{LastNegPrefix}senaste|förra|tidigare|innevarande)\b";
      public const string UpcomingPrefixRegex = @"(?#UpcomingPrefixRegex)((de(n|t)\s+)?(kommande|här))";
      public static readonly string NextPrefixRegex = $@"(?#NextPrefixRegex)\b(efter|nästa|{UpcomingPrefixRegex})\b";
      public const string AfterNextSuffixRegex = @"(?#AfterNextSuffixRegex)\b(efter\s+nästa)\b";
      public const string PastPrefixRegex = @"(?#PastPrefixRegex)((de(n|t)\s+)?förra)\b";
      public static readonly string PreviousPrefixRegex = $@"(?#PreviousPrefixRegex)({LastNegPrefix}förra|föregående|{PastPrefixRegex})\b";
      public const string ThisPrefixRegex = @"(?#ThisPrefixRegex)(innevarande|de(nn|tt)a|de(n|t)\s+här)\b";
      public const string RangePrefixRegex = @"(?#RangePrefixRegex)(från|mellan)";
      public const string CenturySuffixRegex = @"(?#CenturySuffixRegex)(^sekel)\b";
      public const string ReferencePrefixRegex = @"(?#ReferencePrefixRegex)(samma)\b";
      public const string FutureSuffixRegex = @"(?#FutureSuffixRegex)\b((i\s+)?framtiden)\b";
      public const string PastSuffixRegex = @"(?#PastSuffixRegex)\b((i\s+)dåtid(en)?)\b";
      public const string DayRegex = @"(?#DayRegex)(den\s*)?(?<!(\d+:?|\$)\s*)(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:\:(a|e))?)(?=\b|t)";
      public const string ImplicitDayRegex = @"(?#ImplicitDayRegex)(den\s*)?(?<day>(?:3[0-1]|[0-2]?\d)(?:\:(a|e)))\b";
      public const string MonthNumRegex = @"(?#MonthNumRegex)(?<month>1[0-2]|(0)?[1-9])\b";
      public const string WrittenOneToNineRegex = @"(?#WrittenOneToNineRegex)(?:e(n|tt)|två|tre|fyra|fem|sex|sju|åtta|nio)";
      public const string WrittenElevenToNineteenRegex = @"(?#WrittenElevenToNineteenRegex)(?:elva|tolv|(?:tret|fjor|fem|sex|sjut|ar|nit)ton)";
      public const string WrittenTensRegex = @"(?#WrittenTensRegex)(?:tio|tjugo|trettio|fyrtio|femtio|sextio|sjuttio|åttio|nittio)";
      public static readonly string WrittenNumRegex = $@"(?#WrittenNumRegex)(?:{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s*{WrittenOneToNineRegex})?)";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?#WrittenCenturyFullYearRegex)(?:(ett|två)\s+tusen(\s*{WrittenOneToNineRegex}\s*hundra)?)";
      public const string WrittenCenturyOrdinalYearRegex = @"(?#WrittenCenturyOrdinalYearRegex)(?:tjugo(\s+(ett|två))?|tio|elva|tolv|tretton|femton|arton|tjugo|(?:fjor|sex|sjut|nit)(ton)?|ett|två|tre|fyra|fem|sju|åtta|nio)";
      public static readonly string CenturyRegex = $@"(?#CenturyRegex)\b(?<century>{WrittenCenturyFullYearRegex}|(ett|två)tusen|{WrittenCenturyOrdinalYearRegex}(\s*hundra)?)";
      public static readonly string LastTwoYearNumRegex = $@"(?#LastTwoYearNumRegex)(?:(noll\s+)?{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s*{WrittenOneToNineRegex})?)";
      public static readonly string FullTextYearRegex = $@"(?#FullTextYearRegex)\b((?<firsttwoyearnum>{CenturyRegex})(\s+och)?\s*(?<lasttwoyearnum>{LastTwoYearNumRegex})\b|\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\s*hundra))\b";
      public const string OclockRegex = @"(?#OclockRegex)(?<oclock>o\s*((’|‘|')\s*)?clock|sharp|prick)";
      public const string SpecialDescRegex = @"(?#SpecialDescRegex)((?<ipm>)p\b)";
      public static readonly string AmDescRegex = $@"(?#AmDescRegex)(?:{BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"(?#PmDescRegex)(:?{BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"(?#AmPmDescRegex)(:?{BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(?#DescRegex)(:?(:?({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})))|{OclockRegex})";
      public const string OfPrepositionRegex = @"(?#OfPrepositionRegex)(\bi\b)";
      public static readonly string TwoDigitYearRegex = $@"(?#TwoDigitYearRegex)\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public static readonly string YearRegex = $@"(?#YearRegex)(?:{BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"(?#WeekDayRegex)\b(?<weekday>(?:sö(n)?|må(n)?|ti(s)?|on(s)?|to(rs)?|fr(e)?|lö(r)?))(d(ags?(en|ar)?)?)?\b";
      public const string SingleWeekDayRegex = @"(?#SingleWeekDayRegex)\b(?<weekday>(?<!(easter|palm)\s+)söndag|(?<!easter\s+)lördag|(?<!(easter|cyber)\s+)måndag|mån|(?<!black\s+)fredag|fri|fre|(?:ti(sd?)?|tors?)(dag)?|tor|on(sdag)?|ons?|((?<=på\s+)(lör|sön)))\b";
      public static readonly string RelativeMonthRegex = $@"(?#RelativeMonthRegex)(?<relmonth>((dag\s+)?i\s+)?{RelativeRegex}\s+månad(en)?)\b";
      public const string MonthRegex = @"(?#MonthRegex)\b(?<month>apr(il)?|aug(usti)?|dec(ember)?|feb(ruari)?|jan(uari)?|juli?|juni?|mar(s)?|maj|nov(ember)?|okt(ober)?|sept(ember)?|sep)(?!\p{L})";
      public static readonly string WrittenMonthRegex = $@"(?#WrittenMonthRegex)((i\s+)?{MonthRegex}(\s+månad)?)";
      public static readonly string MonthSuffixRegex = $@"(?#MonthSuffixRegex)(?<msuf>(?:(i|under)\s+)?({RelativeMonthRegex}|{WrittenMonthRegex}))";
      public const string DateUnitRegex = @"(?#DateUnitRegex)(?<unit>(decenni(um)?|år|(?<uoy>månad|vecka?)|(?<business>(arbets\s*|vecka?\s*))?(?<uoy>dag)|weekend|helg)(?<plural>(s|or|er|ar|e?n))?|(?<=\s+\d{1,4})[ymwd])\b";
      public const string DateTokenPrefix = @"den ";
      public const string TimeTokenPrefix = @"kl ";
      public const string TokenBeforeDate = @"den ";
      public const string TokenBeforeTime = @"kl ";
      public const string HalfTokenRegex = @"(?#HalfTokenRegex)^(halv)";
      public const string QuarterTokenRegex = @"(?#QuarterTokenRegex)^((en\s+)?kvart)";
      public const string ThreeQuarterTokenRegex = @"(?#ThreeQuarterTokenRegex)^(tre\s+kvart(ar)?)";
      public const string ToTokenRegex = @"(?#ToTokenRegex)\b(till)$";
      public const string FromRegex = @"(?#FromRegex)\b(från(\s+den)?)$";
      public const string BetweenTokenRegex = @"(?#BetweenTokenRegex)\b(mellan(\s+den)?)$";
      public static readonly string SimpleCasesRegex = $@"(?#SimpleCasesRegex)\b({RangePrefixRegex}\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex}\s+{MonthSuffixRegex}|{MonthSuffixRegex}\s+{DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"(?#MonthFrontSimpleCasesRegex)\b({RangePrefixRegex}\s+)?{MonthSuffixRegex}\s+((från)\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"(?#MonthFrontBetweenRegex)\b{MonthSuffixRegex}\s+(mellan\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string BetweenRegex = $@"(?#BetweenRegex)\b(mellan\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthWithYear = $@"(?#MonthWithYear)\b((({WrittenMonthRegex}[\.]?|((den\s+)?(?<cardinal>först(e|a)|1:(e|a)|andr(e|a)|2:(a|e)|tredje|3:e|fjärde|4:e|femte|5:e|sjätte|6:e|sjunde|7:e|åttonde|8:e|nionde|9:e|tionde|10:e|elfte|11:e|tolfte|12:e|senaste)\s+månaden(?=\s+(of|in))))((\s*)[/\\\-\.,]?(\s+(of|in))?(\s*)({YearRegex}|(?<order>kommande|nästa|senaste|detta)\s+år(et)?)|\s+(of|in)\s+{TwoDigitYearRegex}))|(({YearRegex}|(?<order>kommande|nästa|senaste|detta)\s+år(et)?)(\s*),?(\s*){WrittenMonthRegex}))\b";
      public const string SpecialYearPrefixes = @"(?#SpecialYearPrefixes)(kalender|(?<special>räkenskaps|skol|läs))";
      public static readonly string OneWordPeriodRegex = $@"(?#OneWordPeriodRegex)\b((((the\s+)?month of\s+)?({StrictRelativeRegex}\s+)?{MonthRegex})|(month|year) to date|(?<toDate>((un)?till?|to)\s+date)|({RelativeRegex}\s+)?(my\s+)?((?<business>working\s+week|workweek)|week(end)?|month|fortnight|(({SpecialYearPrefixes}\s+)?year))(?!((\s+of)?\s+\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\s+to\s+date))(\s+{AfterNextSuffixRegex})?)\b";
      public static readonly string MonthNumWithYear = $@"(?#MonthNumWithYear)\b(({BaseDateTime.FourDigitYearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-](\s*){BaseDateTime.FourDigitYearRegex}))\b";
      public static readonly string WeekOfMonthRegex = $@"(?#WeekOfMonthRegex)\b(?<wom>(den\s+)?(?<cardinal>första|1:a|andra|2:a|tredje|3:e|fjärde|4:e|femte|5:e|sista)\s+veckan\s+{MonthSuffixRegex}(\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s+år)?)\b";
      public static readonly string WeekOfYearRegex = $@"(?#WeekOfYearRegex)\b(?<woy>(den\s+)?(?<cardinal>första|1:a|andra|2:a|tredje|3:e|fjärde|4:e|femte|5:e|sista)\s+veckan(\s+i)?\s+({YearRegex}|{RelativeRegex}\s+år))\b";
      public static readonly string OfYearRegex = $@"(?#OfYearRegex)\b((i)\s+({YearRegex}|{StrictRelativeRegex}\s+år))\b";
      public const string FirstLastRegex = @"(?#FirstLastRegex)\b(den\s+)?((?<first>första)|(?<last>sista))\b";
      public static readonly string FollowedDateUnit = $@"(?#FollowedDateUnit)^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"(?#NumberCombinedWithDateUnit)\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public const string QuarterTermRegex = @"(?#QuarterTermRegex)\b(((?<cardinal>första|1:a|andra|2:a|tredje|3:e|fjärde|4:e)[ -]+kvartalet)|(q(?<number>[1-4])))\b";
      public static readonly string RelativeQuarterTermRegex = $@"(?#RelativeQuarterTermRegex)\b(?<orderQuarter>{StrictRelativeRegex})\s+kvartalet\b";
      public static readonly string QuarterRegex = $@"(?#QuarterRegex)((det\s+)?{QuarterTermRegex}(?:((\s+under)?\s+|\s*[,-]\s*)({YearRegex}|{RelativeRegex}\s+year))?)|{RelativeQuarterTermRegex}";
      public static readonly string QuarterRegexYearFront = $@"(?#QuarterRegexYearFront)(?:{YearRegex}|{RelativeRegex}\s+year)('s)?(?:\s*-\s*|\s+(det\s+)?)?{QuarterTermRegex}";
      public const string HalfYearTermRegex = @"(?#HalfYearTermRegex)(?<cardinal>första|1:a|andra|2:a)\s+halvåret";
      public static readonly string HalfYearFrontRegex = $@"(?#HalfYearFrontRegex)(?<year>((1[5-9]|20)\d{{2}})|2100)(\s*-\s*|\s+(det\s+)?)?h(?<number>[1-2])";
      public static readonly string HalfYearBackRegex = $@"(?#HalfYearBackRegex)(det\s+)?(h(?<number>[1-2])|({HalfYearTermRegex}))(\s+under|\s*,\s*)?\s+({YearRegex})";
      public static readonly string HalfYearRelativeRegex = $@"(?#HalfYearRelativeRegex)(det\s+)?{HalfYearTermRegex}(\s+under|\s*,\s*)?\s+({RelativeRegex}\s+år)";
      public static readonly string AllHalfYearRegex = $@"(?#AllHalfYearRegex)({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})";
      public const string EarlyPrefixRegex = @"(?#EarlyPrefixRegex)\b(?<EarlyPrefix>early|början av|början på|(?<RelEarly>tidigare(\s+under)?))\b";
      public const string MidPrefixRegex = @"(?#MidPrefixRegex)\b(?<MidPrefix>mitten av)\b";
      public const string LaterPrefixRegex = @"(?#LaterPrefixRegex)\b(?<LatePrefix>slutet på|slutet av|(?<RelLate>senare(\s+under)?))\b";
      public static readonly string PrefixPeriodRegex = $@"(?#PrefixPeriodRegex)({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public const string PrefixDayRegex = @"(?#PrefixDayRegex)\b((?<EarlyPrefix>tidig(t|are))|(?<MidPrefix>mitt på)|(?<LatePrefix>senare?))(\s+på)?(\s+dagen)?$";
      public const string SeasonDescRegex = @"(?#SeasonDescRegex)(?<seas>våren|sommaren|hösten|vintern)";
      public static readonly string SeasonRegex = $@"(?#SeasonRegex)\b(?<season>({PrefixPeriodRegex}\s+)?({RelativeRegex}\s+)?{SeasonDescRegex}((\s+|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+året))?)\b";
      public const string WhichWeekRegex = @"(?#WhichWeekRegex)\b(vecka)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b";
      public const string WeekOfRegex = @"(?#WeekOfRegex)((veckan)(\s+(som|(börjar|startar|inleds)(\s+den)?))|w/c)(\s+den)?";
      public const string MonthOfRegex = @"(?#MonthOfRegex)(månaden)(\s*)(i)";
      public static readonly string DateYearRegex = $@"(?#DateYearRegex)(?<year>{BaseDateTime.FourDigitYearRegex}|(?<!,\s?){TwoDigitYearRegex}|{TwoDigitYearRegex}(?=(\.(?!\d)|[?!;]|$)))";
      public static readonly string YearSuffix = $@"(?#YearSuffix)((,|\si)?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public static readonly string OnRegex = $@"(?#OnRegex)(?<=\bden\s+)({DayRegex}s?)\b";
      public const string RelaxedOnRegex = @"(?#RelaxedOnRegex)(?<=\b(den|om|på)\s+)((?<day>(3[0-1]|[0-2]?\d)(?:(a|e)))s?)\b";
      public const string PrefixWeekDayRegex = @"(?#PrefixWeekDayRegex)(\s*((,?\s*på)|[-—–]))";
      public static readonly string ThisRegex = $@"(?#ThisRegex)\b(denna(\s*vecka{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}((\s+i)?\s+(denna|den\s+här)\s*veckan?))\b|(på\s+){WeekDayRegex}$";
      public static readonly string LastDateRegex = $@"(?#LastDateRegex)\b({PreviousPrefixRegex}(\s*vecka{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}(\s+(den\s+)?senaste\s*veckan))\b|({WeekDayRegex}\s+(i\s+)?{PreviousPrefixRegex}\s*veckan)\b|(i\s+{WeekDayRegex})\b";
      public static readonly string NextDateRegex1 = $@"(?#NextDateRegex1)\b({NextPrefixRegex}(\s*vecka{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})";
      public static readonly string NextDateRegex2 = $@"(?#NextDateRegex2)\b((på\s+)?{WeekDayRegex}((\s+i)?\s+(den\s+kommande|nästa)\s*vecka))\b";
      public static readonly string NextDateRegex = $@"(?#NextDateRegex)({NextDateRegex2}|{NextDateRegex1})";
      public static readonly string SpecialDayRegex = $@"(?#SpecialDayRegex)\b(i förrgår|i övermorgon|dagen\s+(före|efter)(?!=\s+dag)|((den\s+)?({RelativeRegex}|min)\s+dag)|igår|imorgon|idag)\b";
      public static readonly string SpecialDayWithNumRegex = $@"(?#SpecialDayWithNumRegex)\b((?<number>{WrittenNumRegex})\s+dag(ar)?\s+från\s+(?<day>igår|imorgon|idag))\b";
      public static readonly string RelativeDayRegex = $@"(?#RelativeDayRegex)\b(((den\s+)?{RelativeRegex}\s+dag(en)?))\b";
      public const string SetWeekDayRegex = @"(?#SetWeekDayRegex)\b(?<prefix>på\s+)?(?<weekday>morgonen|eftermiddagen|kvällen|natten|(sön|mån|tis|ons|tors|fre|lör)dag(en)?)\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?#WeekDayOfMonthRegex)(?<wom>(den\s+)?(?<cardinal>första|1:a|andra|2:a|tredje|3:e|fjärde|4:e|femte|5:e|sista)\s+(veckan\s+{MonthSuffixRegex}[\.]?\s+(på\s+)?{WeekDayRegex}|{WeekDayRegex}\s+{MonthSuffixRegex}))";
      public static readonly string RelativeWeekDayRegex = $@"(?#RelativeWeekDayRegex)\b({WrittenNumRegex}\s+{WeekDayRegex}\s+(från\s+nu|senare))\b";
      public static readonly string SpecialDate = $@"(?#SpecialDate)(?=\b(den)s+){DayRegex}\b";
      public const string DatePreposition = @"(?#DatePreposition)\b(den|i)";
      public static readonly string DateExtractorYearTermRegex = $@"(?#DateExtractorYearTermRegex)(\s+|\s*[/\\.,-]\s*|\s+under\s+){DateYearRegex}";
      public static readonly string DayPrefix = $@"(?#DayPrefix)\b({WeekDayRegex}|{SpecialDayRegex})\b";
      public static readonly string DateExtractor1 = $@"(?#DateExtractor1)\b({DayPrefix}\s*[,-]?\s*)?(({DayRegex}[\.]?\s*[/\\.,-]?\s*{MonthRegex})|(\({DayRegex}\s*[-./ ]\s*{MonthRegex}\)))(\s*\(\s*{DayPrefix}\s*\))?({DateExtractorYearTermRegex}\b)?";
      public static readonly string DateExtractor3 = $@"(?#DateExtractor3)\b({DayPrefix}(\s+|\s*,\s*))?({DayRegex}[\.]?(\s+|\s*[-,/]\s*|\s+i\s+){MonthRegex}[\.]?((\s+i)?{DateExtractorYearTermRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[-./]?\s*(den\s+)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:(a|e))?)[\.]?(\s+|\s*[-,/]\s*|\s+i\s+){MonthRegex}[\.]?)\b";
      public static readonly string DateExtractor4 = $@"(?#DateExtractor4)\b{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}[\.]?\s*[/\\\-]\s*{DateYearRegex}";
      public static readonly string DateExtractor5 = $@"(?#DateExtractor5)\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?#DateExtractor6)(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({DayPrefix}\s+)?{MonthNumRegex}[\-\.]{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor7L = $@"(?#DateExtractor7L)\b({DayPrefix}(\s*,)?\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])\b";
      public static readonly string DateExtractor7S = $@"(?#DateExtractor7S)\b({DayPrefix}(\s*,)?\s+)?{MonthNumRegex}\s*/\s*{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor8 = $@"(?#DateExtractor8)(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({DayPrefix}\s+)?{DayRegex}[\\\-]{MonthNumRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor9L = $@"(?#DateExtractor9L)\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{DateExtractorYearTermRegex}(?![%])\b";
      public static readonly string DateExtractor9S = $@"(?#DateExtractor9S)\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?![%])\b";
      public const string DateExtractorNoSep = @"(?#DateExtractorNoSep)\b((?<![$])(?<year>((1\d|20)\d{2})|2100)(\s+(?<month>1[0-2]|(0)?[1-9])\s+(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))|(?<month>1[0-2]|(0)?[1-9])(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])))\b)";
      public static readonly string DateExtractorA = $@"(?#DateExtractorA)\b({DayPrefix}(\s*,)?\s+)?(({BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex})|({MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*(the\s+)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:th|nd|rd|st)?))|({DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})|{DateExtractorNoSep})";
      public static readonly string OfMonth = $@"(?#OfMonth)^(\s*(dagen\s+)?i)?\s*{MonthRegex}";
      public static readonly string MonthEnd = $@"(?#MonthEnd)'{MonthRegex}\s*(den)?\s*$'";
      public static readonly string WeekDayEnd = $@"(?#WeekDayEnd)(den\s+här\s+)?{WeekDayRegex}\s*,?(\bden\b)?\s*$";
      public static readonly string WeekDayStart = $@"(?#WeekDayStart)^\s+(på\s+)?{WeekDayRegex}(\s+den)?\b";
      public const string RangeUnitRegex = @"(?#RangeUnitRegex)\b(?<unit>år|månad(er)?|veck(a|or)?)\b";
      public const string HourNumRegex = @"(?#HourNumRegex)\b(?<hournum>noll|ett|två|tre|fyra|fem|sex|sju|åtta|nio|tio|elva|tolv)\b";
      public const string MinuteNumRegex = @"(?#MinuteNumRegex)(((?<tens>tjugo|trettio|fyrtio|femtio)(\s*-?\s*))?(?<minnum>ett|två|tre|fyra|fem|sex|sju|åtta|nio)|(?<minnum>tio|elva|tolv|tretton|femton|årton|(fjor|sex|sjut|nit)(ton)|tjugo|trettio|fyrtio|femtio))";
      public const string DeltaMinuteNumRegex = @"(?#DeltaMinuteNumRegex)(((?<tens>tjugo|trettio|fyrtio|femtio)(\s*-?\s*))?(?<deltaminnum>ett|två|tre|fyra|fem|sex|sju|åtta|nio)|(?<deltaminnum>tio|elva|tolv|tretton|femton|arton|(fjor|sex|sjut|nit)(ton)|tjugo|trettio|fyrtio|femtio))";
      public const string PmRegex = @"(?#PmRegex)(?<pm>(((?:kl|runt|circa|kring)\s+(den\s+)?)?(((tidig|sen)\s+)?(eftermiddag|kväll)|midnatt|middag|lunch))|((kl|runt|circa|kring|till)\s+natt(en)?))";
      public const string PmRegexFull = @"(?#PmRegexFull)(?<pm>((?:kl|om|runt|circa)\s+(the\s+)?)?(((tidig|sen)\s+)?(eftermiddag|kväll)|(mid)?natt|middag|lunch))";
      public const string AmRegex = @"(?#AmRegex)(?<am>((?:kl|om|runt|circa)\s+(the\s+)?)?((tidig|sen)\s+)?(morgon))";
      public const string LunchRegex = @"(?#LunchRegex)\blunch\b";
      public const string NightRegex = @"(?#NightRegex)\b(mid)?natt\b";
      public const string CommonDatePrefixRegex = @"(?#CommonDatePrefixRegex)^[\.]";
      public static readonly string LessThanOneHour = $@"(?#LessThanOneHour)(?<lth>(en\s+)?kvart|tre kvart|halvtimme?|{BaseDateTime.DeltaMinuteRegex}(\s+(minut(er)?|mins?))|{DeltaMinuteNumRegex}(\s+(minut(er)?|mins?)))";
      public static readonly string WrittenTimeRegex = $@"(?#WrittenTimeRegex)(?<writtentime>{HourNumRegex}\s+{MinuteNumRegex}(\s+(minut(er)?|mins?))?)";
      public static readonly string TimePrefix = $@"(?#TimePrefix)(?<prefix>{LessThanOneHour}\s+(över|i))";
      public static readonly string TimeSuffix = $@"(?#TimeSuffix)(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string TimeSuffixFull = $@"(?#TimeSuffixFull)(?<suffix>{AmRegex}|{PmRegexFull}|{OclockRegex})";
      public static readonly string BasicTime = $@"(?#BasicTime)\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex}(?![%\d]))";
      public const string MidnightRegex = @"(?#MidnightRegex)(?<midnight>mid\s*(-\s*)?natt)";
      public const string MidmorningRegex = @"(?#MidmorningRegex)(?<midmorning>tidig\s+förmiddag)";
      public const string MidafternoonRegex = @"(?#MidafternoonRegex)(?<midafternoon>mid\s*(-\s*)?eftermiddag)";
      public const string MiddayRegex = @"(?#MiddayRegex)(?<midday>middag|mitt\s+på\s+dagen|((12\s)?lunch(tid)?))";
      public static readonly string MidTimeRegex = $@"(?#MidTimeRegex)(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"(?#AtRegex)\b(?:(?:(?<=\b(at|(at)?\s*runt|vid)\s+)(?:{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\.\d)(\s*((?<iam>a)|(?<ipm>p)))?|{MidTimeRegex}))|{MidTimeRegex})\b";
      public static readonly string IshRegex = $@"(?#IshRegex)'\b({BaseDateTime.HourRegex}(-|——)?tid|lunch(tid)?|middag(stid)?)\b'";
      public const string TimeUnitRegex = @"(?#TimeUnitRegex)([^a-z]{1,}|\b)(?<unit>(tim(me)?|min(ut)?|s(ek(und)?)?)(?<plural>mar|er)?|h)\b";
      public const string RestrictedTimeUnitRegex = @"(?#RestrictedTimeUnitRegex)(?<unit>timme|minut)\b";
      public const string FivesRegex = @"(?#FivesRegex)(?<tens>(?:femton|(?:tjugo|trettio|fyrtio|femtio)(\s*fem)?|tio|fem))\b";
      public static readonly string HourRegex = $@"(?#HourRegex)\b{BaseDateTime.HourRegex}";
      public const string PeriodHourNumRegex = @"(?#PeriodHourNumRegex)\b(?<hour>tjugo(\s+(en|ett|två|tre|fyra))?|elva|tolv|tretton|femton|arton|(fjor|sex|sjut|nit)(ton)?|noll|ett|en|två|tre|fem|åtta|tio)\b";
      public static readonly string ConnectNumRegex = $@"(?#ConnectNumRegex)'\b{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex}'";
      public static readonly string TimeRegexWithDotConnector = $@"(?#TimeRegexWithDotConnector)({BaseDateTime.HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex1 = $@"(?#TimeRegex1)\b({TimePrefix}\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\s*|[.]){DescRegex}";
      public static readonly string TimeRegex2 = $@"(?#TimeRegex2)(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?(?<iam>a)?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"(?#TimeRegex3)(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"(?#TimeRegex4)\b{TimePrefix}\s+{BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex5 = $@"(?#TimeRegex5)\b{TimePrefix}\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex6 = $@"(?#TimeRegex6)({BasicTime})(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex7 = $@"(?#TimeRegex7)\b{TimeSuffixFull}\s+(kl\s+)?{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@"(?#TimeRegex8).^";
      public static readonly string TimeRegex9 = $@"(?#TimeRegex9)\b{PeriodHourNumRegex}(\s+|-){FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"(?#TimeRegex10)\b({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h|t\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string TimeRegex11 = $@"(?#TimeRegex11)\b((?:({TimeTokenPrefix})?{TimeRegexWithDotConnector}(\s*{DescRegex}))|(?:(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\s*procent|%)))";
      public static readonly string FirstTimeRegexInTimeRange = $@"(?#FirstTimeRegexInTimeRange)\b{TimeRegexWithDotConnector}(\s*{DescRegex})?";
      public static readonly string PureNumFromTo = $@"(?#PureNumFromTo)({RangePrefixRegex}\s+)?({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string PureNumBetweenAnd = $@"(?#PureNumBetweenAnd)(mellan\s+)(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{RangeConnectorRegex}\s*(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string SpecificTimeFromTo = $@"(?#SpecificTimeFromTo)({RangePrefixRegex}\s+)?(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{TillRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"(?#SpecificTimeBetweenAnd)(mellan\s+)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{RangeConnectorRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public const string SuffixAfterRegex = @"(?#SuffixAfterRegex)\b(((kl)\s)?(eller|och)\s+(över|efter|senare|större)(?!\s+än))\b";
      public const string PrepositionRegex = @"(?#PrepositionRegex)(?<prep>^(,\s*)?(kl|på)(\s+den)?$)";
      public const string LaterEarlyRegex = @"(?#LaterEarlyRegex)((?<early>tidig(are)(\s+|-))|(?<late>efte(r?\s+|-)))";
      public const string MealTimeRegex = @"(?#MealTimeRegex)\b(at\s+)?(?<mealTime>breakfast|brunch|lunch(\s*tid)?|middags(\s*tid)?|kvällsmat)\b";
      public static readonly string UnspecificTimePeriodRegex = $@"(?#UnspecificTimePeriodRegex)({MealTimeRegex})";
      public static readonly string TimeOfDayRegex = $@"(?#TimeOfDayRegex)\b(?<timeOfDay>((((in\s+the\s+)?{LaterEarlyRegex}?(in(\s+the)?\s+)?(morgon(en)?|eftermiddag(en)?|natt(en)?|kväll(en)?)))|{MealTimeRegex}|(((in\s+(the)?\s+)?)(dagtid|kontorstid)))s?)\b";
      public static readonly string SpecificTimeOfDayRegex = $@"(?#SpecificTimeOfDayRegex)\b(({StrictRelativeRegex}\s+{TimeOfDayRegex})\b|\bikväll)s?\b";
      public static readonly string TimeFollowedUnit = $@"(?#TimeFollowedUnit)^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"(?#TimeNumberCombinedWithUnit)\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public static readonly string[] BusinessHourSplitStrings = { @"arbets", @"tid" };
      public const string NowRegex = @"(?#NowRegex)\b(?<now>(just\s+)?nu|så\s+snart\s+som\s+möjligt|asap|nyligen|tidigare|i\s+(present|denna\s+stund|denna\s+minut|detta\s+(ögonblick|present\s+time)))\b";
      public static readonly string NowParseRegex = $@"(?#NowParseRegex)\b({NowRegex}|^(date)$)\b";
      public const string SuffixRegex = @"(?#SuffixRegex)^\s*(på\s+)?(morgonen|eftermiddagen|kvällen|natten)\b";
      public const string NonTimeContextTokens = @"(?#NonTimeContextTokens)(building)";
      public const string DateTimeTimeOfDayRegex = @"(?#DateTimeTimeOfDayRegex)\b(?<timeOfDay>morning|(?<pm>eftermiddag(en)?|natt(en)?|kväll(en)?))\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"(?#DateTimeSpecificTimeOfDayRegex)\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})\b|\bikväll)\b";
      public static readonly string TimeOfTodayAfterRegex = $@"(?#TimeOfTodayAfterRegex)^\s*(,\s*)?(på\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"(?#TimeOfTodayBeforeRegex)'{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(på|runt|omkring|vid))?\s*$'";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"(?#SimpleTimeOfTodayAfterRegex)(?<!{NonTimeContextTokens}\s*)\b({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?((på|den)\s+)?{DateTimeSpecificTimeOfDayRegex}\b";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"(?#SimpleTimeOfTodayBeforeRegex)'\b{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(på|runt|omkring|vid))?\s*({HourNumRegex}|{BaseDateTime.HourRegex})\b'";
      public const string SpecificEndOfRegex = @"(?#SpecificEndOfRegex)(the\s+)?slutet av\s*$";
      public const string UnspecificEndOfRegex = @"(?#UnspecificEndOfRegex)\b(the\s+)?(eod|(slutet\s+(av|på)\s+dagen))\b";
      public const string UnspecificEndOfRangeRegex = @"(?#UnspecificEndOfRangeRegex)\b(eoy)\b";
      public static readonly string PeriodTimeOfDayRegex = $@"(?#PeriodTimeOfDayRegex)\b((in\s+(the)?\s+)?{LaterEarlyRegex}?(this\s+)?{DateTimeTimeOfDayRegex})\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"(?#PeriodSpecificTimeOfDayRegex)\b({LaterEarlyRegex}?denna\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\s+{PeriodTimeOfDayRegex})\b|\bikväll)\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"(?#PeriodTimeOfDayWithDateRegex)\b(({PeriodTimeOfDayRegex}(\s+(den))?))\b";
      public const string LessThanRegex = @"(?#LessThanRegex)\b(mindre\s+än)\b";
      public const string MoreThanRegex = @"(?#MoreThanRegex)\b(mer\s+än)\b";
      public static readonly string DurationUnitRegex = $@"(?#DurationUnitRegex)(?<unit>{DateUnitRegex}|tim(me|mar)?|h|min(ut(er)?)?|sek(und(er)?)?|nätter)\b";
      public const string SuffixAndRegex = @"(?#SuffixAndRegex)(?<suffix>\s*(och)\s+(en?\s+)?(?<suffix_num>halv|kvart))";
      public const string PeriodicRegex = @"(?#PeriodicRegex)\b(?<periodic>((?<multiplier>semi|varannan|tri)(\s*|-))?(dagligen|månatligen|veckovis|kvartalsvis|årlig(en)?))\b";
      public static readonly string EachUnitRegex = $@"(?#EachUnitRegex)\b(?<each>(varje|(varje|var|en gång\s+(i|per|varje|var)?)\s?)(?<other>\s+(annan|alternate|second))?\s*({DurationUnitRegex}|(?<specialUnit>kvartal|weekends?|veckoslut|helg)|{WeekDayRegex})|(?<specialUnit>weekends))";
      public const string EachPrefixRegex = @"(?#EachPrefixRegex)\b(?<each>(varje|var|en gång\s+(i|per|varje|var)?)\s*$)";
      public const string SetEachRegex = @"(?#SetEachRegex)\b(?<each>(varje|var)(?<other>\s+(annan|alternate))?\s*)(?!den|det)\b";
      public static readonly string SetLastRegex = $@"(?#SetLastRegex)(?<last>följande|nästa|kommande|den\s+här|{LastNegPrefix}senaste|förra|tidigare|nuvarande)";
      public const string EachDayRegex = @"(?#EachDayRegex)^\s*(var|varje)\s*dag\b";
      public static readonly string DurationFollowedUnit = $@"(?#DurationFollowedUnit)(^\s*{DurationUnitRegex}\s+{SuffixAndRegex})|(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"(?#NumberCombinedWithDurationUnit)\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"(?#AnUnitRegex)(\b((?<half>(en)\s+)?halv|another)|(?<half>(1/2|½|en halv)))\s+{DurationUnitRegex}";
      public const string DuringRegex = @"(?#DuringRegex)\b(under|i)\s+(?<unit>år(et)?|månad(en)?|veckan?|dag(en)?)\b";
      public const string AllRegex = @"(?#AllRegex)\b(?<all>(hela)(\s+|-)(?<unit>år(et)?|månad(en)?|veckan?|dag(en)?))\b";
      public const string HalfRegex = @"(?#HalfRegex)((e(n|tt)\s*)|\b)(?<half>halvt?\s+(?<unit>år|månad|vecka|dag|timm(e|a)))\b";
      public const string ConjunctionRegex = @"(?#ConjunctionRegex)\b((och(\s+under)?)|med)\b";
      public const string HolidayList1 = @"(?#HolidayList1)(?<holiday>första maj|nyårsdagen|nyårsafton|trettondedag(en|\s+jul)|julafton|juldagen|annandag\s+jul|skärtorsdag(en)?|långfredag(en)?|påskafton|påskdagen|annandag\s+påsk|mardi gras|(washington|mao)'s birthday|juneteenth|(jubilee|freedom)(\s+day)|chinese new year|(new\s+(years'|year\s*'s|years?)\s+eve)|(new\s+(years'|year\s*'s|years?)(\s+day)?)|may\s*day|yuan dan|christmas eve|(christmas|xmas)(\s+day)?|black friday|yuandan|easter(\s+(sunday|saturday|monday))?|clean monday|ash wednesday|palm sunday|maundy thursday|good friday|white\s+(sunday|monday)|trinity sunday|pentecost|corpus christi|cyber monday)";
      public const string HolidayList2 = @"(?#HolidayList2)(?<holiday>(valborg(smässoafton)?|kristi himmelsfärdsdag|pingst(afton|dagen)|midsommar(afton|dagen)|allahelgonaafton|alla helgons dag|thanks\s*giving|all saint's|white lover|s(?:ain)?t?(\.)?\s+(?:patrick|george)(?:')?(?:s)?|us independence|all hallow|all souls|guy fawkes|cinco de mayo|halloween|qingming|dragon boat|april fools|tomb\s*sweeping)(\s+day)?)";
      public const string HolidayList3 = @"(?#HolidayList3)(?<holiday>(nationaldagen|sveriges nationaldag|mlk|martin luther king( jr)?|canberra|ascension|columbus|tree( planting)?|arbor|labou?r|((international|int'?l)\s+)?workers'?|mother'?s?|father'?s?|female|women('s)?|single|teacher'?s|youth|children|girls|lovers?|earth|inauguration|groundhog|valentine'?s|baptiste|bastille|veterans(?:')?|memorial|mid[ \-]autumn|moon|spring|lantern)\s+day)";
      public const string HolidayList4 = @"(?#HolidayList4)(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\s+)adha|eid al(-|\s+)azha|eidul(-|\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\s+)fitr|festival of breaking the fast)";
      public static readonly string HolidayRegex = $@"(?#HolidayRegex)\b(({StrictRelativeRegex}\s+({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4}))|(?<holidayWeekend>((the\s+)?weekend\s+of\s+)({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})(\s+((of\s+)?({YearRegex}|{RelativeRegex}\s+year)))?)|(({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})((?<holidayWeekend>(\s+weekend)(\s+((of\s+)?({YearRegex}|{RelativeRegex}\s+year)))?)|(\s+(of\s+)?({YearRegex}|{RelativeRegex}\s+year)(?<holidayWeekend>\s+weekend)?))?))\b";
      public const string AMTimeRegex = @"(?#AMTimeRegex)(?<am>morgon(en)?|förmiddag(en)?)";
      public const string PMTimeRegex = @"(?#PMTimeRegex)\b(?<pm>eftermiddag(en)?|kväll(en)?|natt(en)?)\b";
      public const string NightTimeRegex = @"(?#NightTimeRegex)(natten)";
      public const string NowTimeRegex = @"(?#NowTimeRegex)(nu|vid\s+(denna tidpunkt|denna\s+minut|(ögonblick(et)?|(aktuell|nuvarande)\s+tidpunkt)))";
      public const string RecentlyTimeRegex = @"(?#RecentlyTimeRegex)(senaste|tidigare)";
      public const string AsapTimeRegex = @"(?#AsapTimeRegex)(så\s+snart\s+(som|(som)?det\s+är)\s+möjligt|asap|snarast)";
      public const string InclusiveModPrepositions = @"(?#InclusiveModPrepositions)(?<include>((den|kl|vid)\s+eller\s+)|(\s+eller\s+(den|kl|vid)))";
      public const string AroundRegex = @"(?#AroundRegex)(?:\b(?:runt|cirka|omkring)\s*?\b)(\s+den)?";
      public static readonly string BeforeRegex = $@"(?#BeforeRegex)((\b{InclusiveModPrepositions}?(?:före|innan|(ej\s+senare\s+än|tidigare)\s+än|slutar\s+(med|den)|by|tom|till|(?<include>så\s+sent\s+som)){InclusiveModPrepositions}?\b\s*?)|(?<!\w|>)((?<include><\s*=)|<))(\s+den)?";
      public static readonly string AfterRegex = $@"(?#AfterRegex)((\b{InclusiveModPrepositions}?((efter|(\s+med)?(start|början)(?!\sfrån)|(?<!ej\s+)senare än)|(år större än))(?!\s+lika med){InclusiveModPrepositions}?\b\s*?)|(?<!\w|<)((?<include>>\s*=)|>))(\s+den)?";
      public const string SinceRegex = @"(?#SinceRegex)(?:(?:\b(?:sedan|senare\s+än\s+eller\s+lika\s+med|((med|som)\s+börja(n|r)|(som)?\s+startar)\s+(?:från|den|med)|så\s+tidigt\s+som|(any\s+time\s+)from)\b\s*?)|(?<!\w|<)(>=))(\s+den)?";
      public static readonly string SinceRegexExp = $@"(?#SinceRegexExp)({SinceRegex}|\bfrån(\s+den)?\b)";
      public const string AgoRegex = @"(?#AgoRegex)\b(sedan|tidigare|före\s+(?<day>igår|idag))\b";
      public static readonly string LaterRegex = $@"(?#LaterRegex)\b(?:senare(?!((\s+under)?\s*{OneWordPeriodRegex})|(\s+{TimeOfDayRegex})|\s+än\b)|från nu|(från|efter)\s+(?<day>imorgon|idag))\b";
      public const string BeforeAfterRegex = @"(?#BeforeAfterRegex)\b((?<before>före)|(?<after>från|efter))\b";
      public static readonly string ModPrefixRegex = $@"(?#ModPrefixRegex)\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"(?#ModSuffixRegex)\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string InConnectorRegex = @"(?#InConnectorRegex)\b(om)\b";
      public static readonly string SinceYearSuffixRegex = $@"(?#SinceYearSuffixRegex)(^\s*{SinceRegex}(\s*år(et)?\s*)?{YearSuffix})";
      public static readonly string WithinNextPrefixRegex = $@"(?#WithinNextPrefixRegex)\b(inom(\s+de(n|t))?(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string TodayNowRegex = @"(?#TodayNowRegex)\b(idag|nu|nuvarande (datum|tid))\b";
      public static readonly string MorningStartEndRegex = $@"(?#MorningStartEndRegex)(^(morgon|{AmDescRegex}))|((morgon|{AmDescRegex})$)";
      public static readonly string AfternoonStartEndRegex = $@"(?#AfternoonStartEndRegex)(^(afternoon|{PmDescRegex}))|((afternoon|{PmDescRegex})$)";
      public const string EveningStartEndRegex = @"(?#EveningStartEndRegex)(^(evening))|((evening)$)";
      public const string NightStartEndRegex = @"(?#NightStartEndRegex)(^(over|to)?ni(ght|te))|((over|to)?ni(ght|te)$)";
      public const string InexactNumberRegex = @"(?#InexactNumberRegex)\b((för\s+)?några|flera|(?<NumTwoTerm>(ett\s+)?(par|antal)))\b";
      public static readonly string InexactNumberUnitRegex = $@"(?#InexactNumberUnitRegex)({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"(?#RelativeTimeUnitRegex)(?:(?:(?:{NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({TimeUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"(?#RelativeDurationUnitRegex)(?:(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string ReferenceDatePeriodRegex = $@"(?#ReferenceDatePeriodRegex)\b{ReferencePrefixRegex}\s+(?<duration>week(end)?|fortnight|month|year|decade)\b";
      public const string ConnectorRegex = @"(?#ConnectorRegex)^(-|,|for|t|runt|cirka|@)$";
      public const string FromToRegex = @"(?#FromToRegex)(\b(från).+(till|och|eller)\b.+)";
      public const string SingleAmbiguousMonthRegex = @"(?#SingleAmbiguousMonthRegex)^(the\s+)?(may|march)$";
      public const string SingleAmbiguousTermsRegex = @"(?#SingleAmbiguousTermsRegex)^(the\s+)?(dag|vecka|månad|år)$";
      public const string UnspecificDatePeriodRegex = @"(?#UnspecificDatePeriodRegex)^(vecka|fortnight|månad|år)$";
      public const string PrepositionSuffixRegex = @"(?#PrepositionSuffixRegex)\b(on|in|at|around|circa|from|to)$";
      public const string FlexibleDayRegex = @"(?#FlexibleDayRegex)(?<DayOfMonth>([A-Öa-ö]+\s)?[A-Öa-ö\d]+)";
      public static readonly string ForTheRegex = $@"(?#ForTheRegex)\b((((?<=\btill\s+)den\s+{FlexibleDayRegex})|((?<!{WeekDayRegex}\s+)den\s+{FlexibleDayRegex}(?<=(ta|te|ra|re|de))))(?<end>\s*(,|\.(?!\d)|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"(?#WeekDayAndDayOfMonthRegex)\b{WeekDayRegex}\s+(den\s+{FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"(?#WeekDayAndDayRegex)\b{WeekDayRegex}\s+(?!(den)){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"(?#RestOfDateRegex)\b(rest|remaining)\s+(of\s+)?((the|my|this|current)\s+)?(?<duration>vecka|fortnight|månad|år|decennium)\b";
      public const string RestOfDateTimeRegex = @"\b(rest|remaining)\s+(av\s+)?((den|min|denna|nuvarande)\s+)?(?<unit>dag)\b";
      public const string AmbiguousRangeModifierPrefix = @"(?#AmbiguousRangeModifierPrefix)(från)";
      public static readonly string NumberEndingPattern = $@"(?#NumberEndingPattern)^(?:\s+(?<meeting>möte|avtalad tid|konferens|sammanträde|((skype|teams|zoom|facetime)\s+)?samtal)\s+till\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})([\.]?$|(\.,|,|!|\?)))";
      public const string OneOnOneRegex = @"(?#OneOnOneRegex)\b(1\s*:\s*1(?!\d))|(one (on )?one|one\s*-\s*one|one\s*:\s*one)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"(?#LaterEarlyPeriodRegex)\b(({PrefixPeriodRegex})\s*\b\s*(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|({UnspecificEndOfRangeRegex}))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"(?#WeekWithWeekDayRangeRegex)\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|this)\s+week)((\s+mellan\s+{WeekDayRegex}\s+och\s+{WeekDayRegex})|(\s+från\s+{WeekDayRegex}\s+till\s+{WeekDayRegex})))\b";
      public const string GeneralEndingRegex = @"(?#GeneralEndingRegex)^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"(?#MiddlePauseRegex)\s*(,)\s*";
      public const string DurationConnectorRegex = @"(?#DurationConnectorRegex)^\s*(?<connector>\s+|och|,)\s*$";
      public const string PrefixArticleRegex = @"(?#PrefixArticleRegex)\bthe\s+";
      public const string OrRegex = @"(?#OrRegex)\s*((\b|,\s*)(eller|och)\b|,)\s*";
      public static readonly string SpecialYearTermsRegex = $@"(?#SpecialYearTermsRegex)\b((({SpecialYearPrefixes}\s+)?year)|(cy|(?<special>fy|sy)))";
      public static readonly string YearPlusNumberRegex = $@"(?#YearPlusNumberRegex)\b({SpecialYearTermsRegex}\s*((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"(?#NumberAsTimeRegex)\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"(?#TimeBeforeAfterRegex)\b(((?<=\b(before|no later than|by|after)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"(?#DateNumberConnectorRegex)^\s*(?<connector>\s+at)\s*$";
      public const string DecadeRegex = @"(?#DecadeRegex)(?<decade>(?:nough|twen|thir|fou?r|fif|six|seven|eigh|nine)ties|two\s+thousands)";
      public static readonly string DecadeWithCenturyRegex = $@"(?#DecadeWithCenturyRegex)(the\s+)?(((?<century>\d|1\d|2\d)?(')?(?<decade>\d0)(')?(\s)?s\b)|(({CenturyRegex}(\s+|-)(and\s+)?)?{DecadeRegex})|({CenturyRegex}(\s+|-)(and\s+)?(?<decade>tens|hundreds)))";
      public static readonly string RelativeDecadeRegex = $@"(?#RelativeDecadeRegex)\b((the\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?decades?)\b";
      public static readonly string YearPeriodRegex = $@"(?#YearPeriodRegex)((((from|during|in)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((between)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public static readonly string StrictTillRegex = $@"(?#StrictTillRegex)(?<till>\b(to|(un)?till?|thru|through)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public static readonly string StrictRangeConnectorRegex = $@"(?#StrictRangeConnectorRegex)(?<and>\b(and|through|to)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public const string StartMiddleEndRegex = @"(?#StartMiddleEndRegex)\b((?<StartOf>((the\s+)?(start|beginning)\s+of\s+)?)(?<MiddleOf>((the\s+)?middle\s+of\s+)?)(?<EndOf>((the\s+)?end\s+of\s+)?))";
      public static readonly string ComplexDatePeriodRegex = $@"(?#ComplexDatePeriodRegex)(?:((from|during|in)\s+)?{StartMiddleEndRegex}(?<start>.+)\s*({StrictTillRegex})\s*{StartMiddleEndRegex}(?<end>.+)|((between)\s+){StartMiddleEndRegex}(?<start>.+)\s*({StrictRangeConnectorRegex})\s*{StartMiddleEndRegex}(?<end>.+))";
      public static readonly string FailFastRegex = $@"(?#FailFastRegex)'{BaseDateTime.DeltaMinuteRegex}|\b(?:{BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex})|{BaseDateTime.BaseAmPmDescRegex}|\b(?:zero|{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}|{WrittenMonthRegex}|{SeasonDescRegex}|{DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\d(-|——)?ish|((the\s+\w*)|\d)(th|rd|nd|st)|(mid\s*(-\s*)?)?(night|morning|afternoon|day)s?|evenings?|noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|minutes?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\b|{WeekDayRegex}|{SetWeekDayRegex}|{NowRegex}|{PeriodicRegex}|\b({DateUnitRegex}|{ImplicitDayRegex})'";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"decennium", @"10Y" },
            { @"decennier", @"10Y" },
            { @"decenniet", @"10Y" },
            { @"år", @"Y" },
            { @"åren", @"Y" },
            { @"månad", @"MON" },
            { @"månader", @"MOM" },
            { @"kvartal", @"3MON" },
            { @"termin", @"6MON" },
            { @"terminer", @"6MON" },
            { @"vecka", @"W" },
            { @"veckor", @"W" },
            { @"helg", @"WE" },
            { @"helger", @"WE" },
            { @"veckoslut", @"WE" },
            { @"dag", @"D" },
            { @"dagar", @"D" },
            { @"arbetsdag", @"D" },
            { @"arbetsdagar", @"D" },
            { @"veckodag", @"D" },
            { @"veckodagar", @"D" },
            { @"natt", @"D" },
            { @"nätter", @"D" },
            { @"timme", @"H" },
            { @"timmar", @"H" },
            { @"tim", @"H" },
            { @"t", @"H" },
            { @"minut", @"M" },
            { @"minuter", @"M" },
            { @"m", @"M" },
            { @"sekund", @"S" },
            { @"sekunder", @"S" },
            { @"sek", @"S" },
            { @"s", @"S" },
            { @"decades", @"10Y" },
            { @"decade", @"10Y" },
            { @"years", @"Y" },
            { @"year", @"Y" },
            { @"months", @"MON" },
            { @"month", @"MON" },
            { @"quarters", @"3MON" },
            { @"quarter", @"3MON" },
            { @"semesters", @"6MON" },
            { @"semestres", @"6MON" },
            { @"semester", @"6MON" },
            { @"semestre", @"6MON" },
            { @"weeks", @"W" },
            { @"week", @"W" },
            { @"weekends", @"WE" },
            { @"weekend", @"WE" },
            { @"fortnights", @"2W" },
            { @"fortnight", @"2W" },
            { @"weekdays", @"D" },
            { @"weekday", @"D" },
            { @"days", @"D" },
            { @"day", @"D" },
            { @"nights", @"D" },
            { @"night", @"D" },
            { @"hours", @"H" },
            { @"hour", @"H" },
            { @"hrs", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minutes", @"M" },
            { @"minute", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"seconds", @"S" },
            { @"second", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"decennier", 315360000 },
            { @"decennium", 315360000 },
            { @"år", 31536000 },
            { @"månad", 2592000 },
            { @"månader", 2592000 },
            { @"helg", 172800 },
            { @"helger", 172800 },
            { @"veckoslut", 172800 },
            { @"vecka", 604800 },
            { @"veckor", 604800 },
            { @"arbetsdag", 86400 },
            { @"arbetsdagar", 86400 },
            { @"dag", 86400 },
            { @"dagar", 86400 },
            { @"natt", 86400 },
            { @"nätter", 86400 },
            { @"timme", 3600 },
            { @"timmar", 3600 },
            { @"tim", 3600 },
            { @"t", 3600 },
            { @"minut", 60 },
            { @"minuter", 60 },
            { @"m", 60 },
            { @"sekund", 1 },
            { @"sekunder", 1 },
            { @"sek", 1 },
            { @"s", 1 },
            { @"decades", 315360000 },
            { @"decade", 315360000 },
            { @"years", 31536000 },
            { @"year", 31536000 },
            { @"months", 2592000 },
            { @"month", 2592000 },
            { @"fortnights", 1209600 },
            { @"fortnight", 1209600 },
            { @"weekends", 172800 },
            { @"weekend", 172800 },
            { @"weeks", 604800 },
            { @"week", 604800 },
            { @"days", 86400 },
            { @"day", 86400 },
            { @"nights", 86400 },
            { @"night", 86400 },
            { @"hours", 3600 },
            { @"hour", 3600 },
            { @"hrs", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minutes", 60 },
            { @"minute", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"seconds", 1 },
            { @"second", 1 },
            { @"secs", 1 },
            { @"sec", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"skol", @"SY" },
            { @"räkenskaps", @"FY" },
            { @"fiscal", @"FY" },
            { @"school", @"SY" },
            { @"fy", @"FY" },
            { @"sy", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"vår", @"SP" },
            { @"sommar", @"SU" },
            { @"höst", @"FA" },
            { @"vinter", @"WI" },
            { @"spring", @"SP" },
            { @"summer", @"SU" },
            { @"fall", @"FA" },
            { @"autumn", @"FA" },
            { @"winter", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"första", 1 },
            { @"förste", 1 },
            { @"andra", 2 },
            { @"andre", 2 },
            { @"tredje", 3 },
            { @"fjärde", 4 },
            { @"femte", 5 },
            { @"sjätte", 6 },
            { @"sjunde", 7 },
            { @"åttonde", 8 },
            { @"nionde", 9 },
            { @"tionde", 10 },
            { @"elfte", 11 },
            { @"tolfte", 12 },
            { @"first", 1 },
            { @"1st", 1 },
            { @"second", 2 },
            { @"2nd", 2 },
            { @"third", 3 },
            { @"3rd", 3 },
            { @"fourth", 4 },
            { @"4th", 4 },
            { @"fifth", 5 },
            { @"5th", 5 },
            { @"sixth", 6 },
            { @"6th", 6 },
            { @"seventh", 7 },
            { @"7th", 7 },
            { @"eighth", 8 },
            { @"8th", 8 },
            { @"ninth", 9 },
            { @"9th", 9 },
            { @"tenth", 10 },
            { @"10th", 10 },
            { @"eleventh", 11 },
            { @"11th", 11 },
            { @"twelfth", 12 },
            { @"12th", 12 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"måndagen", 1 },
            { @"måndag", 1 },
            { @"månd", 1 },
            { @"mån", 1 },
            { @"må", 1 },
            { @"tisdagen", 2 },
            { @"tisdag", 2 },
            { @"tisd", 2 },
            { @"tis", 2 },
            { @"ti", 2 },
            { @"onsdagen", 3 },
            { @"onsdag", 3 },
            { @"onsd", 3 },
            { @"ons", 3 },
            { @"on", 3 },
            { @"torsdagen", 4 },
            { @"torsdag", 4 },
            { @"torsd", 4 },
            { @"tors", 4 },
            { @"tor", 4 },
            { @"to", 4 },
            { @"fredagen", 5 },
            { @"fredag", 5 },
            { @"fred", 5 },
            { @"fre", 5 },
            { @"fr", 5 },
            { @"lördagen", 6 },
            { @"lördag", 6 },
            { @"lörd", 6 },
            { @"lör", 6 },
            { @"lö", 6 },
            { @"söndagen", 0 },
            { @"söndag", 0 },
            { @"sönd", 0 },
            { @"sön", 0 },
            { @"sö", 0 },
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"januari", 1 },
            { @"februari", 2 },
            { @"mars", 3 },
            { @"april", 4 },
            { @"maj", 5 },
            { @"juni", 6 },
            { @"juli", 7 },
            { @"augusti", 8 },
            { @"september", 9 },
            { @"oktober", 10 },
            { @"november", 11 },
            { @"december", 12 },
            { @"january", 1 },
            { @"february", 2 },
            { @"march", 3 },
            { @"may", 5 },
            { @"june", 6 },
            { @"july", 7 },
            { @"august", 8 },
            { @"october", 10 },
            { @"jan", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"apr", 4 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"aug", 8 },
            { @"sep", 9 },
            { @"sept", 9 },
            { @"okt", 10 },
            { @"oct", 10 },
            { @"nov", 11 },
            { @"dec", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"noll", 0 },
            { @"ett", 1 },
            { @"en", 1 },
            { @"två", 2 },
            { @"tre", 3 },
            { @"fyra", 4 },
            { @"fem", 5 },
            { @"sex", 6 },
            { @"sju", 7 },
            { @"åtta", 8 },
            { @"nio", 9 },
            { @"tio", 10 },
            { @"elva", 11 },
            { @"tolv", 12 },
            { @"tretton", 13 },
            { @"fjorton", 14 },
            { @"femton", 15 },
            { @"sexton", 16 },
            { @"sjutton", 17 },
            { @"arton", 18 },
            { @"nitton", 19 },
            { @"tjugo", 20 },
            { @"tjugoett", 21 },
            { @"tjugoen", 21 },
            { @"tjugotvå", 22 },
            { @"tjugofyra", 24 },
            { @"tjugofem", 25 },
            { @"tjugosex", 26 },
            { @"tjugosju", 27 },
            { @"tjugoåtta", 28 },
            { @"tjugonio", 29 },
            { @"trettio", 30 },
            { @"trettioett", 31 },
            { @"trettioen", 31 },
            { @"trettiotvå", 32 },
            { @"trettiotre", 33 },
            { @"trettiofyra", 33 },
            { @"trettiofem", 35 },
            { @"trettiosex", 36 },
            { @"trettiosju", 37 },
            { @"trettioåtta", 38 },
            { @"trettionio", 39 },
            { @"fyrtio", 40 },
            { @"fyrtioett", 41 },
            { @"fyrtioen", 41 },
            { @"fyrtiotvå", 42 },
            { @"fyrtiotre", 43 },
            { @"fyrtiofyra", 44 },
            { @"fyrtiofem", 45 },
            { @"fyrtiosex", 46 },
            { @"fyrtiosju", 47 },
            { @"fyrtioåtta", 48 },
            { @"fyrtionio", 49 },
            { @"femtio", 50 },
            { @"femtioett", 51 },
            { @"femtioen", 51 },
            { @"femtiotvå", 52 },
            { @"femtiotre", 53 },
            { @"femtiofyra", 54 },
            { @"femtiofem", 55 },
            { @"femtiosex", 56 },
            { @"femtiosju", 57 },
            { @"femtioåtta", 58 },
            { @"femtionio", 59 },
            { @"sextio", 60 },
            { @"sextioett", 61 },
            { @"sextioen", 61 },
            { @"sextiotvå", 62 },
            { @"sextiotre", 63 },
            { @"sextiofyra", 64 },
            { @"sextiofem", 65 },
            { @"sextiosex", 66 },
            { @"sextiosju", 67 },
            { @"sextioåtta", 68 },
            { @"sextionio", 69 },
            { @"sjuttio", 70 },
            { @"sjuttioett", 71 },
            { @"sjuttioen", 71 },
            { @"sjuttiotvå", 72 },
            { @"sjuttiotre", 73 },
            { @"sjuttiofyra", 74 },
            { @"sjuttiofem", 75 },
            { @"sjuttiosex", 76 },
            { @"sjuttiosju", 77 },
            { @"sjuttioåtta", 78 },
            { @"sjuttionio", 79 },
            { @"åttio", 80 },
            { @"åttioett", 81 },
            { @"åttioen", 81 },
            { @"åttiotvå", 82 },
            { @"åttiotre", 83 },
            { @"åttiofyra", 84 },
            { @"åttiofem", 85 },
            { @"åttiosex", 86 },
            { @"åttiosju", 87 },
            { @"åttioåtta", 88 },
            { @"åttionio", 89 },
            { @"nittio", 90 },
            { @"nittioett", 91 },
            { @"nittioen", 91 },
            { @"nittiotvå", 92 },
            { @"nittiotre", 93 },
            { @"nittiofyra", 94 },
            { @"nittiofem", 95 },
            { @"nittiosex", 96 },
            { @"nittiosju", 97 },
            { @"nittioåtta", 98 },
            { @"nittionio", 99 },
            { @"etthundra", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"13", 13 },
            { @"14", 14 },
            { @"15", 15 },
            { @"16", 16 },
            { @"17", 17 },
            { @"18", 18 },
            { @"19", 19 },
            { @"20", 20 },
            { @"21", 21 },
            { @"22", 22 },
            { @"23", 23 },
            { @"24", 24 },
            { @"25", 25 },
            { @"26", 26 },
            { @"27", 27 },
            { @"28", 28 },
            { @"29", 29 },
            { @"30", 30 },
            { @"31", 31 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 },
            { @"1:e", 1 },
            { @"1:a", 1 },
            { @"2:e", 2 },
            { @"2:a", 2 },
            { @"3:e", 3 },
            { @"4:e", 4 },
            { @"5:e", 5 },
            { @"6:e", 6 },
            { @"7:e", 7 },
            { @"8:e", 8 },
            { @"9:e", 9 },
            { @"10:e", 10 },
            { @"11:e", 11 },
            { @"12:e", 12 },
            { @"13:e", 13 },
            { @"14:e", 14 },
            { @"15:e", 15 },
            { @"16:e", 16 },
            { @"17:e", 17 },
            { @"18:e", 18 },
            { @"19:e", 19 },
            { @"20:e", 20 },
            { @"21:e", 21 },
            { @"21:a", 21 },
            { @"22:e", 22 },
            { @"22:a", 22 },
            { @"23:e", 23 },
            { @"24:e", 24 },
            { @"25:e", 25 },
            { @"26:e", 26 },
            { @"27:e", 27 },
            { @"28:e", 28 },
            { @"29:e", 29 },
            { @"30:e", 30 },
            { @"31:e", 31 },
            { @"31:a", 31 },
            { @"01:e", 1 },
            { @"01:a", 1 },
            { @"02:e", 2 },
            { @"02:a", 2 },
            { @"03:e", 3 },
            { @"04:e", 4 },
            { @"05:e", 5 },
            { @"06:e", 6 },
            { @"07:e", 7 },
            { @"08:e", 8 },
            { @"09:e", 9 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"half", 0.5 },
            { @"quarter", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"easterday", new string[] { @"easterday", @"easter", @"eastersunday" } },
            { @"ashwednesday", new string[] { @"ashwednesday" } },
            { @"palmsunday", new string[] { @"palmsunday" } },
            { @"maundythursday", new string[] { @"maundythursday" } },
            { @"goodfriday", new string[] { @"goodfriday" } },
            { @"eastersaturday", new string[] { @"eastersaturday" } },
            { @"eastermonday", new string[] { @"eastermonday" } },
            { @"ascensionday", new string[] { @"ascensionday" } },
            { @"whitesunday", new string[] { @"whitesunday", @"pentecost", @"pentecostday" } },
            { @"whitemonday", new string[] { @"whitemonday" } },
            { @"trinitysunday", new string[] { @"trinitysunday" } },
            { @"corpuschristi", new string[] { @"corpuschristi" } },
            { @"earthday", new string[] { @"earthday" } },
            { @"fathers", new string[] { @"fatherday", @"fathersday" } },
            { @"mothers", new string[] { @"motherday", @"mothersday" } },
            { @"thanksgiving", new string[] { @"thanksgivingday", @"thanksgiving" } },
            { @"blackfriday", new string[] { @"blackfriday" } },
            { @"cybermonday", new string[] { @"cybermonday" } },
            { @"martinlutherking", new string[] { @"mlkday", @"martinlutherkingday", @"martinlutherkingjrday" } },
            { @"washingtonsbirthday", new string[] { @"washingtonsbirthday", @"washingtonbirthday", @"presidentsday" } },
            { @"canberra", new string[] { @"canberraday" } },
            { @"labour", new string[] { @"labourday", @"laborday" } },
            { @"columbus", new string[] { @"columbusday" } },
            { @"memorial", new string[] { @"memorialday" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"maosbirthday", new string[] { @"maosbirthday" } },
            { @"teachersday", new string[] { @"teachersday", @"teacherday" } },
            { @"singleday", new string[] { @"singleday" } },
            { @"allsaintsday", new string[] { @"allsaintsday" } },
            { @"youthday", new string[] { @"youthday" } },
            { @"childrenday", new string[] { @"childrenday", @"childday" } },
            { @"femaleday", new string[] { @"femaleday" } },
            { @"treeplantingday", new string[] { @"treeplantingday" } },
            { @"arborday", new string[] { @"arborday" } },
            { @"girlsday", new string[] { @"girlsday" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"loverday", @"loversday" } },
            { @"christmas", new string[] { @"christmasday", @"christmas" } },
            { @"xmas", new string[] { @"xmasday", @"xmas" } },
            { @"newyear", new string[] { @"newyear" } },
            { @"newyearday", new string[] { @"newyearday" } },
            { @"newyearsday", new string[] { @"newyearsday" } },
            { @"inaugurationday", new string[] { @"inaugurationday" } },
            { @"groundhougday", new string[] { @"groundhougday" } },
            { @"valentinesday", new string[] { @"valentinesday" } },
            { @"stpatrickday", new string[] { @"stpatrickday", @"stpatricksday", @"stpatrick" } },
            { @"aprilfools", new string[] { @"aprilfools" } },
            { @"stgeorgeday", new string[] { @"stgeorgeday" } },
            { @"mayday", new string[] { @"mayday", @"intlworkersday", @"internationalworkersday", @"workersday" } },
            { @"cincodemayoday", new string[] { @"cincodemayoday" } },
            { @"baptisteday", new string[] { @"baptisteday" } },
            { @"usindependenceday", new string[] { @"usindependenceday" } },
            { @"independenceday", new string[] { @"independenceday" } },
            { @"bastilleday", new string[] { @"bastilleday" } },
            { @"halloweenday", new string[] { @"halloweenday", @"halloween" } },
            { @"allhallowday", new string[] { @"allhallowday" } },
            { @"allsoulsday", new string[] { @"allsoulsday" } },
            { @"guyfawkesday", new string[] { @"guyfawkesday" } },
            { @"veteransday", new string[] { @"veteransday" } },
            { @"christmaseve", new string[] { @"christmaseve" } },
            { @"newyeareve", new string[] { @"newyearseve", @"newyeareve" } },
            { @"juneteenth", new string[] { @"juneteenth", @"freedomday", @"jubileeday" } },
            { @"ramadan", new string[] { @"ramadan", @"ramazan", @"ramzan", @"ramadhan", @"ramathan" } },
            { @"sacrifice", new string[] { @"eidaladha", @"eidalazha", @"eidulazha", @"feastofthesacrifice" } },
            { @"islamicnewyear", new string[] { @"islamicnewyear", @"hijrinewyear", @"arabicnewyear" } },
            { @"eidalfitr", new string[] { @"eidalfitr", @"festivalofbreakingthefast" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"hundratalet", 0 },
            { @"10-talet", 10 },
            { @"10-tal", 10 },
            { @"tiotalet", 10 },
            { @"tiotal", 10 },
            { @"20-talet", 20 },
            { @"20-tal", 20 },
            { @"tjugotalet", 20 },
            { @"tjugotal", 20 },
            { @"30-talet", 30 },
            { @"30-tal", 30 },
            { @"trettiotalet", 30 },
            { @"trettiotal", 30 },
            { @"40-talet", 40 },
            { @"40-tal", 40 },
            { @"fyrtiotalet", 40 },
            { @"fyrtiotal", 40 },
            { @"50-talet", 50 },
            { @"50-tal", 50 },
            { @"femtiotalet", 50 },
            { @"femtiotal", 50 },
            { @"60-talet", 60 },
            { @"60-tal", 60 },
            { @"sextiotalet", 60 },
            { @"sextiotal", 60 },
            { @"70-talet", 70 },
            { @"70-tal", 70 },
            { @"sjuttiotalet", 70 },
            { @"sjuttiotal", 70 },
            { @"80-talet", 80 },
            { @"80-tal", 80 },
            { @"åttiotalet", 80 },
            { @"åttiotal", 80 },
            { @"90-talet", 90 },
            { @"90-tal", 90 },
            { @"nittiotalet", 90 },
            { @"nittiotal", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"00-talet", 2000 },
            { @"2000-talet", 2000 },
            { @"2000-tal", 2000 },
            { @"tvåtusentalet", 2000 },
            { @"tvåtusental", 2000 },
            { @"tjugohundratalet", 2000 },
            { @"tjugohundratal", 2000 }
        };
      public const string DefaultLanguageFallback = @"MDY";
      public static readonly IList<string> SuperfluousWordList = new List<string>
        {
            @"preferably",
            @"how about",
            @"maybe",
            @"perhaps",
            @"say",
            @"like"
        };
      public static readonly string[] DurationDateRestrictions = { @"today", @"now", @"current date" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"^(morning|afternoon|evening|night|day)\b", @"\b(good\s+(morning|afternoon|evening|night|day))|(nighty\s+night)\b" },
            { @"\bnow\b", @"\b(^now,)|\b((is|are)\s+now\s+for|for\s+now)\b" },
            { @"\bmay$", @"\b((((!|\.|\?|,|;|)\s+|^)may i)|(i|you|he|she|we|they)\s+may|(may\s+((((also|not|(also not)|well)\s+)?(be|ask|contain|constitute|e-?mail|take|have|result|involve|get|work|reply|differ))|(or may not)))|(?<!(in|during|through)\s+)may,? at (its|h(is|er)|y?our|my))\b" },
            { @"^(a|one) second$", @"\b(?<!an?\s+)(a|one) second (round|time|wave|turn|chance|thought|opinion|cycle|take|meaning|life|job|home|hand|language|display|monitor|stimulus|dose|vaccination|shot|jab)\b" },
            { @"\b(breakfast|brunch|lunch(time)?|dinner(time)?|supper)$", @"(?<!\b(at|before|after|around|circa)\b\s)(breakfast|brunch|lunch|dinner|supper)(?!\s*time)" },
            { @"^\d+m$", @"^\d+m$" },
            { @"^(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)$", @"([$%£&!?@#])(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)|(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)([$%£&@#])" },
            { @"^(to\s+date)$", @"\b((equals?|up)\s+to\s+date)\b" }
        };
      public static readonly Dictionary<string, string> AmbiguityTimeFiltersDict = new Dictionary<string, string>
        {
            { @"^(\p{L}+|\d{1,2})(\s+(morning|afternoon|evening|night))?$", @"\b(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|\d{1,2})\s+(morning|afternoon|evening|night)\b" }
        };
      public static readonly Dictionary<string, string> AmbiguityDurationFiltersDict = new Dictionary<string, string>
        {
            { @"night$", @"\bnight(\s*|-)(club|light|market|shift|work(er)?)s?\b" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"morgon",
            @"morgonen",
            @"morning"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"afternoon",
            @"eftermiddag",
            @"eftermiddagen"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"evening",
            @"kväll",
            @"kvällen"
        };
      public static readonly IList<string> MealtimeBreakfastTermList = new List<string>
        {
            @"breakfast",
            @"frukost",
            @"frukosten"
        };
      public static readonly IList<string> MealtimeBrunchTermList = new List<string>
        {
            @"brunch",
            @"brunchen"
        };
      public static readonly IList<string> MealtimeLunchTermList = new List<string>
        {
            @"lunch",
            @"lunchtime",
            @"lunchen"
        };
      public static readonly IList<string> MealtimeDinnerTermList = new List<string>
        {
            @"dinner",
            @"dinnertime",
            @"supper",
            @"kvällsmat",
            @"kvällsmaten"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"daytime",
            @"dagtid"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"night",
            @"natt",
            @"natten"
        };
      public static readonly IList<string> NighttimeTermList = new List<string>
        {
            @"nighttime",
            @"night-time"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"today",
            @"current date",
            @"otd",
            @"idag",
            @"i dag"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"tomorrow",
            @"tmr",
            @"day after",
            @"imorgon",
            @"i morgon"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"yesterday",
            @"day before",
            @"igår",
            @"i går",
            @"dagen innan",
            @"dagen före",
            @"dag innan",
            @"dag före"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"day after tomorrow",
            @"day after tmr",
            @"övermorgon",
            @"i övermorgon"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"day before yesterday",
            @"förrgår",
            @"i förrgår"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"this",
            @"next",
            @"kommande",
            @"denna",
            @"nästa"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"last",
            @"förra",
            @"senaste"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"month",
            @"månad"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"month to date"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"weekend",
            @"helg",
            @"veckoslut"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"week",
            @"vecka"
        };
      public static readonly IList<string> FortnightTerms = new List<string>
        {
            @"fortnight",
            @"fourtenight",
            @"fjorton dagar"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"year",
            @"år"
        };
      public static readonly IList<string> GenericYearTerms = new List<string>
        {
            @"y"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"year to date"
        };
      public const string DoubleMultiplierRegex = @"^(bi)(-|\s)?";
      public const string HalfMultiplierRegex = @"^(semi)(-|\s)?";
      public const string DayTypeRegex = @"((week)?da(il)?ys?)$";
      public const string WeekTypeRegex = @"(week(s|ly)?)$";
      public const string WeekendTypeRegex = @"(weekends?)$";
      public const string MonthTypeRegex = @"(month(s|ly)?)$";
      public const string QuarterTypeRegex = @"(quarter(s|ly)?)$";
      public const string YearTypeRegex = @"((years?|annual)(ly)?)$";
    }
}