﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Spanish\Spanish-DateTime.yaml
//     - Language: Spanish
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Spanish
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Spa";
      public const bool CheckBothBeforeAfter = false;
      public static readonly string TillRegex = $@"(?<till>\b(hasta|hacia|al?)\b(\s+(el|la(s)?)\b)?|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string StrictTillRegex = $@"(?<till>\b(hasta|hacia|al?)(\s+(el|la(s)?))?\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*[qt][1-4](?!(\s+de|\s*,\s*))))";
      public static readonly string RangeConnectorRegex = $@"(?<and>\b(y\s*(el|(la(s)?)?))\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string WrittenDayRegex = @"(?<day>uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieciséis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintidós|veintitrés|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|treinta(\s+y\s+uno)?)";
      public const string DayRegex = @"\b(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(?:\.[º°])?(?=\b|t)";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])\b";
      public const string OclockRegex = @"(?<oclock>en\s+punto)";
      public static readonly string AmDescRegex = $@"({BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"({BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"({BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(?<desc>({AmDescRegex}|{PmDescRegex}))";
      public const string OfPrepositionRegex = @"(\bd(o|al?|el?)\b)";
      public const string AfterNextSuffixRegex = @"\b(despu[eé]s\s+de\s+la\s+pr[oó]xima)\b";
      public const string NextSuffixRegex = @"\b(que\s+viene|pr[oó]xim[oa]|siguiente)\b";
      public const string PreviousSuffixRegex = @"\b(pasad[ao]|anterior(?!\s+(al?|del?)\b))\b";
      public static readonly string RelativeSuffixRegex = $@"({AfterNextSuffixRegex}|{NextSuffixRegex}|{PreviousSuffixRegex})";
      public const string RangePrefixRegex = @"((de(l|sde)?|entre)(\s+la(s)?)?)";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d))|\.?[º°ª])\b";
      public const string RelativeRegex = @"(?<order>est[ae]s?|pr[oó]xim[oa]s?|siguiente|(([uú]ltim|pasad)[ao]s?))\b";
      public const string StrictRelativeRegex = @"(?<order>est[ae]|pr[oó]xim[oa]|siguiente|(([uú]ltim|pasad)(o|as|os)))\b";
      public const string WrittenOneToNineRegex = @"(un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)";
      public const string WrittenOneHundredToNineHundredRegex = @"(doscient[oa]s|trescient[oa]s|cuatrocient[ao]s|quinient[ao]s|seiscient[ao]s|setecient[ao]s|ochocient[ao]s|novecient[ao]s|cien(to)?)";
      public static readonly string WrittenOneToNinetyNineRegex = $@"(((treinta|cuarenta|cincuenta|sesenta|setenta|ochenta|noventa)(\s+y\s+{WrittenOneToNineRegex})?)|diez|once|doce|trece|catorce|quince|dieciséis|dieciseis|diecisiete|dieciocho|diecinueve|veinte|veintiuno|veintiún|veintiun|veintiuna|veintidós|veintidos|veintitrés|veintitres|veinticuatro|veinticinco|veintiséis|veintisiete|veintiocho|veintinueve|un[ao]?|dos|tres|cuatro|cinco|seis|siete|ocho|nueve)";
      public static readonly string FullTextYearRegex = $@"\b(?<fullyear>((dos\s+)?mil)(\s+{WrittenOneHundredToNineHundredRegex})?(\s+{WrittenOneToNinetyNineRegex})?)";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string RelativeMonthRegex = @"(?<relmonth>(de\s+)?((este|pr[oó]ximo|([uú]ltim(o|as|os)))\s+mes)|(del\s+)?(mes\s+((que\s+viene)|pasado)))\b";
      public const string MonthRegex = @"\b(?<month>abr(\.|(il)?\b)|ago(\.|(sto)?\b)|dic(\.|(iembre)?\b)|feb(\.|(rero)?\b)|ene(\.|(ro)?\b)|ju[ln](\.|(io)?\b)|mar(\.|(zo)?\b)|may(\.|(o)?\b)|nov(\.|(iembre)?\b)|oct(\.|(ubre)?\b)|sep?t(\.|(iembre)?\b)|sep(\.|\b))";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>((del?|la|el)\s+)?({RelativeMonthRegex}|{MonthRegex}))";
      public const string DateUnitRegex = @"(?<unit>(a[nñ]o|(?<uoy>semana))(?<plural>s)?|(?<uoy>mes)(?<plural>es)?|(?<uoy>d[ií]a)(?<plural>s)?(?<business>\s+(h[aá]biles|laborales))?)\b";
      public const string PastRegex = @"(?<past>\b(pasad(a|o)(s)?|[uú]ltim[oa](s)?|anterior(es)?|previo(s)?)\b)";
      public const string FutureRegex = @"\b(siguiente(s)?|pr[oó]xim[oa](s)?)\b";
      public static readonly string SimpleCasesRegex = $@"\b((desde(\s+el)?|entre|del?)\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*)((en|del?)\s+)?{YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b{MonthSuffixRegex}\s+((desde(\s+el)?|entre|del)\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*)((en|del?)\s+)?{YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+((entre(\s+el)?)\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*)((en|del?)\s+)?{YearRegex})?\b";
      public static readonly string DayBetweenRegex = $@"\b((entre(\s+el)?)\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*)((en|del?)\s+)?{YearRegex})?\b";
      public const string SpecialYearPrefixes = @"((del\s+)?calend[aá]rio|(?<special>fiscal|escolar))";
      public static readonly string OneWordPeriodRegex = $@"\b(((((la|el)\s+)?mes\s+(({OfPrepositionRegex})\s+)?)|((pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?)\s+))?({MonthRegex})|((el\s+)?{RelativeRegex}\s+)?(({SpecialYearPrefixes}\s+)año|año\s+{SpecialYearPrefixes})|(((la|el)\s+)?((({RelativeRegex}\s+)({DateUnitRegex}|(fin\s+de\s+)?semana|finde)(\s+{RelativeSuffixRegex})?)|{DateUnitRegex}(\s+{RelativeSuffixRegex}))|va\s+de\s+{DateUnitRegex}|((año|mes)(\s+(a|hasta)\s+la\s+fecha)?|((el\s+)?fin\s+de\s+)?semana|(el\s+)?finde))\b)";
      public static readonly string MonthWithYearRegex = $@"\b((((pr[oó]xim[oa](s)?|est?[ae]|[uú]ltim[oa]?)\s+)?{MonthRegex}|((el\s+)?(?<cardinal>primero?|1(er|ro)|segundo|2do|tercero?|3(er|ro)|uarto|4to|quinto|5to|sexto|6to|s[eé]ptimo|7mo|octavo|8vo|noveno|9no|d[eé]cimo|10mo|und[eé]cimo|11mo|duod[eé]cimo|12mo|[uú]ltimo)\s+mes(?=\s+(del?|en))))((\s+|(\s*[,-]\s*))((de(l|\s+la)?|en)\s+)?({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\s+año)|\s+(del?|en)\s+{TwoDigitYearRegex}))\b";
      public static readonly string MonthNumWithYearRegex = $@"\b(({YearRegex}(\s*?)[/\-\.~](\s*?){MonthNumRegex})|({MonthNumRegex}(\s*?)[/\-\.~](\s*?){YearRegex}))\b";
      public static readonly string WeekOfMonthRegex = $@"(?<wom>(la\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|([12345](\.)?ª)|[uú]ltima)\s+semana\s+{MonthSuffixRegex}((\s+de)?\s+({BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s+año))?)\b";
      public static readonly string WeekOfYearRegex = $@"(?<woy>(la\s+)?(?<cardinal>primera?|1ra|segunda|2da|tercera?|3ra|cuarta|4ta|quinta|5ta|[uú]ltima?|([12345]ª))\s+semana(\s+(del?|en))?\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\s+año))";
      public static readonly string OfYearRegex = $@"\b((del?)\s+({YearRegex}|{StrictRelativeRegex}\s+año))\b";
      public const string FirstLastRegex = @"\b((el|las?|los?)\s+)?((?<first>primer([ao]s?)?)|(?<last>[uú]ltim[ao]s?))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public const string QuarterTermRegex = @"\b((?<cardinal>primer|1er|segundo|2do|tercer|3ro|4to|([1234](\.)?º))\s+(trimestre|cuarto)|[tq](?<number>[1-4]))\b";
      public static readonly string RelativeQuarterTermRegex = $@"\b((?<orderQuarter>{StrictRelativeRegex})\s+(trimestre|cuarto)|(trimestre|cuarto)\s+(?<orderQuarter>(actual|pr[oó]ximo|siguiente|pasado|anterior)))\b";
      public static readonly string QuarterRegex = $@"(el\s+)?{QuarterTermRegex}((\s+(del?\s+)?|\s*[,-]\s*)({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\s+a[ñn]o|a[ñn]o(\s+{RelativeSuffixRegex}))|\s+del\s+a[ñn]o)?|{RelativeQuarterTermRegex}";
      public static readonly string QuarterRegexYearFront = $@"({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|este)\s+a[ñn]o)(?:\s*-\s*|\s+(el\s+)?)?{QuarterTermRegex}";
      public static readonly string AllHalfYearRegex = $@"\b(?<cardinal>primer|1er|segundo|2do|[12](\.)?º)\s+semestre(\s+(de\s+)?({YearRegex}|{RelativeRegex}\s+año))?\b";
      public static readonly string EarlyPrefixRegex = $@"\b(?<EarlyPrefix>(?<RelEarly>m[aá]s\s+temprano(\s+(del?|en))?)|((comienzos?|inicios?|principios?|temprano)\s+({OfPrepositionRegex}(\s+d[ií]a)?)))(\s+(el|las?|los?))?\b";
      public static readonly string MidPrefixRegex = $@"\b(?<MidPrefix>(media[dn]os\s+({OfPrepositionRegex})))(\s+(el|las?|los?))?\b";
      public static readonly string LaterPrefixRegex = $@"\b(?<LatePrefix>((fin(al)?(es)?|[uú]ltimos)\s+({OfPrepositionRegex}))|(?<RelLate>m[aá]s\s+tarde(\s+(del?|en))?))(\s+(el|las?|los?))?\b";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public static readonly string PrefixDayRegex = $@"\b((?<EarlyPrefix>(comienzos?|inicios?|principios?|temprano))|(?<MidPrefix>mediados)|(?<LatePrefix>(fin((al)?es)?|m[aá]s\s+tarde)))(\s+(en|{OfPrepositionRegex}))?(\s+([ae]l)(\s+d[ií]a)?)?$";
      public const string CenturySuffixRegex = @"(^siglo)\b";
      public static readonly string SeasonRegex = $@"\b(?<season>(([uú]ltim[oa]|est[ea]|el|la|(pr[oó]xim[oa]s?|siguiente)|{PrefixPeriodRegex})\s+)?(?<seas>primavera|verano|otoño|invierno)((\s+(del?|en)|\s*,\s*)?\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\s+año))?)\b";
      public static readonly string WhichWeekRegex = $@"\b(semana)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])(\s+del?\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|este)\s+año|año\s+(?<order>pasado)))?\b";
      public static readonly string WeekOfRegex = $@"((del?|el|la)\s+)?(semana)(\s*)({OfPrepositionRegex}|que\s+(inicia|comienza)\s+el|(que\s+va|a\s+partir)\s+del)";
      public static readonly string MonthOfRegex = $@"(mes)(\s+)({OfPrepositionRegex})";
      public const string RangeUnitRegex = @"\b(?<unit>a[nñ]os?|mes(es)?|semanas?)\b";
      public const string BeforeAfterRegex = @"^[.]";
      public const string InConnectorRegex = @"\b(en)(?=\s*$)\b";
      public const string TodayNowRegex = @"\b(hoy|ahora|este entonces)\b";
      public const string FromRegex = @"((\bde(sde)?)(\s*la(s)?)?)$";
      public const string BetweenRegex = @"(\bentre\s*(la(s)?)?)";
      public const string WeekDayRegex = @"\b(?<weekday>(domingos?|lunes|martes|mi[eé]rcoles|jueves|viernes|s[aá]bados?)\b|(lun|mar|mi[eé]|jue|vie|s[aá]b|dom|lu|ma|mi|ju|vi|s[aá]|do)(\.|\b))(?!ñ)";
      public static readonly string OnRegex = $@"((?<=\b(e[ln])\s+)|(\be[ln]\s+d[ií]a\s+))({DayRegex}s?)(?![.,]\d)\b";
      public const string RelaxedOnRegex = @"(?<=\b(en|d?el)\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1st|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)s?)(?![.,]\d)\b";
      public const string SpecialDayRegex = @"\b((el\s+)?(d[ií]a\s+antes\s+de\s+ayer|anteayer)|((el\s+)?d[ií]a\s+(despu[eé]s\s+)?de\s+mañana|pasado\s+mañana)|(el\s)?d[ií]a\s+(siguiente|anterior)|(el\s)?pr[oó]ximo\s+d[ií]a|(el\s+)?[uú]ltimo\s+d[ií]a|(d)?el\s+d[ií]a(?!\s+(de|internacional))|ayer|mañana|hoy)\b";
      public const string SpecialDayWithNumRegex = @"^[.]";
      public static readonly string FlexibleDayRegex = $@"(?<DayOfMonth>([a-z]+\s)?({WrittenDayRegex}|{DayRegex}))";
      public static readonly string ForTheRegex = $@"\b((((?<=para\s+el\s+){FlexibleDayRegex})|((?<!(\b{MonthRegex},?|\bpara)\s+(el\s+)|{WeekDayRegex}\s+(el\s+)?)((?<=(e[ln]\s+))|(\be[ln]\s+d[ií]a\s+)){FlexibleDayRegex}))(?<end>\s*(,|\.(?![º°ª])|!|\?|-|$))(?!\d))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex}\s+((el\s+(d[ií]a\s+)?){FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+({DayRegex}|{WrittenDayRegex})(?!([-:/]|\.\d|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>(el\s+)?(?<cardinal>primera?|1era?|segund[ao]|2d[ao]|tercera?|3era?|cuart[ao]|4t[ao]|quint[ao]|5t[ao]|((1|2|3|4|5)(\.)?[ºª])|[uú]ltim[ao])\s+(semana\s+{MonthSuffixRegex}\s+el\s+{WeekDayRegex}|{WeekDayRegex}\s+{MonthSuffixRegex}))";
      public const string RelativeWeekDayRegex = @"^[.]";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public const string NumberEndingPattern = @"^[.]";
      public const string DateTokenPrefix = @"en ";
      public const string TimeTokenPrefix = @"a las ";
      public const string TokenBeforeDate = @"el ";
      public const string TokenBeforeTime = @"a las ";
      public const string HalfTokenRegex = @"^((y\s+)?media)";
      public const string QuarterTokenRegex = @"^((y\s+)?cuarto|(?<neg>menos\s+cuarto))";
      public const string PastTokenRegex = @"\b(pasad[ao]s(\s+(de\s+)?las)?)$";
      public const string ToTokenRegex = @"\b((para|antes)(\s+(de\s+)?las?)|(?<neg>^menos))$";
      public static readonly string SpecialDateRegex = $@"(?<=\b(en)\s+el\s+){DayRegex}\b";
      public static readonly string OfMonthRegex = $@"^\s*((d[ií]a\s+)?d[eo]\s+)?{MonthSuffixRegex}";
      public static readonly string MonthEndRegex = $@"({MonthRegex}\s*(el)?\s*$)";
      public static readonly string WeekDayEnd = $@"{WeekDayRegex}\s*,?\s*$";
      public const string WeekDayStart = @"^\b$";
      public static readonly string DateYearRegex = $@"(?<year>{YearRegex}|(?<!,\s?){TwoDigitYearRegex}|{TwoDigitYearRegex}(?=(\.(?!\d)|[?!;]|$)))";
      public static readonly string DateExtractor1 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?(?<!\d[.,]){DayRegex}((\s*(d[eo])|[/\\\.\-])\s*)?{MonthRegex}\b";
      public static readonly string DateExtractor2 = $@"\b((el\s+d[ií]a|{WeekDayRegex})(\s+|\s*,\s*))?(?<!\d[.,])(({DayRegex}((\s+(d[eo]\s+)?|\s*[.,/-]\s*){MonthRegex}((\s+(del?\s+)?|\s*[.,/-]\s*){DateYearRegex}\b)?|\s+(d[eo]\s+){MonthNumRegex}\s+(del?\s+{DateYearRegex}\b)))|{BaseDateTime.FourDigitYearRegex}\s*[.,/-]?\s*(el\s+d[ií]a\s+)?{DayRegex}(\s+(d[eo]\s+)?|\s*[.,/-]\s*){MonthRegex})";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{MonthRegex}(\s*[.,/-]?\s*)(el\s+d[ií]a\s+)?{DayRegex}(?!\s*\-\s*\d{{2}}\b)((\s+(del?\s+)?|\s*[.,/-]\s*){DateYearRegex})?\b";
      public static readonly string DateExtractor4 = $@"\b(?<!\d[.,]){MonthNumRegex}\s*[/\\\-]\s*{DayRegex}\s*[/\\\-]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor5 = $@"\b(?<!\d[.,]){DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<=\b(en|el)\s+){MonthNumRegex}[\-\.]{DayRegex}{BaseDateTime.CheckDecimalRegex}\b(?!\s*[/\\\.]\s*\d+)";
      public static readonly string DateExtractor7 = $@"\b(?<!\d[.,]){MonthNumRegex}\s*/\s*{DayRegex}((\s+|\s*,\s*|\s+d[eo]\s+){DateYearRegex})?\b{BaseDateTime.CheckDecimalRegex}(?!\s*[/\\\.]\s*\d+)";
      public static readonly string DateExtractor8 = $@"(?<=\b(en|el)\s+){DayRegex}[\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\b(?!\s*[/\\\.]\s*\d+)";
      public static readonly string DateExtractor9 = $@"\b({WeekDayRegex}\s+)?(?<!\d[.,]){DayRegex}\s*(/|\bdel\b)\s*{MonthNumRegex}((\s+|\s*,\s*|\s+d[eo]\s+){DateYearRegex})?\b{BaseDateTime.CheckDecimalRegex}(?!\s*[/\\\.]\s*\d+)";
      public static readonly string DateExtractor10 = $@"\b(?<!\d[.,])(({YearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}(?!\s*[/\\\-\.]\s*\d+))|({MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex})|({DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex}))";
      public const string HourRegex = @"\b(?<!\d[,.])(?<hour>2[0-4]|[0-1]?\d)";
      public const string HourNumRegex = @"\b(?<hournum>cero|una|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce)\b";
      public const string MinuteNumRegex = @"(?<minnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>uno?|d[óo]s|tr[eé]s|cuatro|cinco|s[eé]is|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|diecis[eé]is|diecisiete|dieciocho|diecinueve|veinte|treinta|cuarenta|cincuenta)";
      public const string PmRegex = @"(?<pm>((por|de|a|en)\s+la)\s+(tarde|noche))";
      public const string AmRegex = @"(?<am>((por|de|a|en)\s+la)\s+(mañana|madrugada))";
      public const string AmTimeRegex = @"(?<am>(esta|(por|de|a|en)\s+la)\s+(mañana|madrugada))";
      public const string PmTimeRegex = @"(?<pm>(esta|(por|de|a|en)\s+la)\s+(tarde|noche))";
      public const string NightTimeRegex = @"(noche)";
      public const string LastNightTimeRegex = @"(anoche)";
      public const string NowTimeRegex = @"(ahora|mismo|momento)";
      public const string RecentlyTimeRegex = @"(mente)";
      public const string AsapTimeRegex = @"(posible|pueda[ns]?|podamos)";
      public static readonly string LessThanOneHour = $@"(?<lth>((\s+y\s+)?cuarto|(\s*)menos cuarto|(\s+y\s+)media|{BaseDateTime.DeltaMinuteRegex}(\s+(minutos?|mins?))|{DeltaMinuteNumRegex}(\s+(minutos?|mins?))))";
      public const string TensTimeRegex = @"(?<tens>diez|veint(i|e)|treinta|cuarenta|cincuenta)";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s*((y|(?<prefix>menos))\s+)?(({TensTimeRegex}(\s*y\s+)?)?{MinuteNumRegex}))";
      public static readonly string TimePrefix = $@"(?<prefix>{LessThanOneHour}(\s+(pasad[ao]s)\s+(de\s+las|las)?|\s+(para|antes\s+de)?\s+(las?))?)";
      public static readonly string TimeSuffix = $@"(?<suffix>({LessThanOneHour}\s+)?({AmRegex}|{PmRegex}|{OclockRegex}))";
      public static readonly string GeneralDescRegex = $@"({DescRegex}|(?<suffix>{AmRegex}|{PmRegex}))";
      public static readonly string BasicTime = $@"(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})";
      public const string MidTimeRegex = @"(?<mid>((?<midnight>media\s*noche)|(?<midearlymorning>media\s*madrugada)|(?<midmorning>media\s*mañana)|(?<midafternoon>media\s*tarde)|(?<midday>medio\s*d[ií]a)))";
      public static readonly string AtRegex = $@"\b((?<=\b((a|de(sde)?)\s+las?|al)\s+)(({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\b(\s*\bh\b)?(DescRegex)?|{MidTimeRegex})|{MidTimeRegex})";
      public static readonly string ConnectNumRegex = $@"({BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex})";
      public static readonly string TimeRegexWithDotConnector = $@"({BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex1 = $@"(\b{TimePrefix}\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\s*({DescRegex}|\s*\bh\b)";
      public static readonly string TimeRegex2 = $@"(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?(\s*({DescRegex}|\bh\b)|\b)";
      public static readonly string TimeRegex3 = $@"\b(({TimePrefix}\s+)?{TimeRegexWithDotConnector}(\s*({DescRegex}|{TimeSuffix}|\bh\b))|((las\s+{TimeRegexWithDotConnector})(?!\s*(por\s+cien(to)?|%))(\s*({DescRegex}|{TimeSuffix}|\bh\b)|\b)))";
      public static readonly string TimeRegex4 = $@"\b(({DescRegex}?)|({BasicTime}\s*)?({GeneralDescRegex}?)){TimePrefix}(\s*({HourNumRegex}|{BaseDateTime.HourRegex}))?(\s+{TensTimeRegex}(\s*(y\s+)?{MinuteNumRegex})?)?(\s*({OclockRegex}|{DescRegex}|\bh\b)|\b)";
      public static readonly string TimeRegex5 = $@"\b({TimePrefix}|{BasicTime}{TimePrefix})\s+(\s*{DescRegex})?{BasicTime}?\s*{TimeSuffix}\b";
      public static readonly string TimeRegex6 = $@"({BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b)";
      public static readonly string TimeRegex7 = $@"\b{TimeSuffix}\s+a\s+las\s+{BasicTime}((\s*{DescRegex}|\bh\b)|\b)";
      public static readonly string TimeRegex8 = $@"\b{TimeSuffix}\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex9 = $@"\b(?<writtentime>{HourNumRegex}\s+({TensTimeRegex}\s*)(y\s+)?{MinuteNumRegex}?)\b";
      public static readonly string TimeRegex11 = $@"\b({WrittenTimeRegex})(\s+{DescRegex})?\b";
      public static readonly string TimeRegex12 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public const string PrepositionRegex = @"(?<prep>^(,\s*)?(a(l)?|en|de(l)?)?(\s*(la(s)?|el|los))?$)";
      public const string LaterEarlyRegex = @"((?<early>temprano)|(?<late>fin(al)?(\s+de)?|m[aá]s\s+tarde))";
      public const string NowRegex = @"\b(?<now>(justo\s+)?ahora(\s+mismo)?|en\s+este\s+momento|tan\s+pronto\s+como\s+sea\s+posible|tan\s+pronto\s+como\s+(pueda|puedas|podamos|puedan)|lo\s+m[aá]s\s+pronto\s+posible|recientemente|previamente|este entonces)\b";
      public const string SuffixRegex = @"^\s*(((y|a|en|por)\s+la|al)\s+)?(mañana|madrugada|medio\s*d[ií]a|(?<!(m[áa]s\s+))tarde|noche)\b";
      public static readonly string TimeOfDayRegex = $@"\b((?<timeOfDay>(({LaterEarlyRegex}\s+)((del?|en|por)(\s+(el|los?|las?))?\s+)?)?(mañana|madrugada|pasado\s+(el\s+)?medio\s?d[ií]a|(?<!((m[áa]s|tan)\s+))tarde|noche))|(en|por)\s+las?\s+mañana)\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(((((a\s+)?la|esta|siguiente|pr[oó]xim[oa]|[uú]ltim[oa])\s+)?{TimeOfDayRegex})|anoche)\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?(en|de(l)?\s+)?{SpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"({SpecificTimeOfDayRegex}(\s*,)?(\s+(((cerca|alrededor)?\s*(de|a)\s+)la(s)?|para))?\s*$)";
      public const string NonTimeContextTokens = @"(edificio)";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"(?<!{NonTimeContextTokens}\s*)\b({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?((en|de(l)?)?\s+)?{SpecificTimeOfDayRegex}\b";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"({SpecificTimeOfDayRegex}(\s*,)?(\s+(((cerca|alrededor)?\s*(de|a)\s+)la(s)?|para))?\s*({HourNumRegex}|{BaseDateTime.HourRegex}))\b";
      public const string SpecificEndOfRegex = @"((a|e)l\s+)?fin(alizar|al)?(\s+(el|de(l)?)(\s+d[ií]a)?(\s+de)?)?\s*$";
      public const string UnspecificEndOfRegex = @"\b([ae]l\s+)?(fin(al)?\s+del?\s+d[ií]a)\b";
      public const string UnspecificEndOfRangeRegex = @"^[.]";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>mañana|madrugada|(?<pm>pasado\s+(el\s+)?medio\s?d[ií]a|tarde|noche))\b";
      public static readonly string PeriodTimeOfDayRegex = $@"\b((en\s+(el|la|lo)?\s+)?({LaterEarlyRegex}\s+)?(est[ae]\s+)?{DateTimeTimeOfDayRegex})\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b(({LaterEarlyRegex}\s+)?est[ae]\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\s+{PeriodTimeOfDayRegex})|anoche)\b";
      public const string UnitRegex = @"(?<unit>a[nñ]os?|(bi|tri|cuatri|se)mestre|mes(es)?|semanas?|fin(es)?\s+de\s+semana|finde|d[ií]as?|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\b";
      public const string ConnectorRegex = @"^(,|t|(para|y|a|en|por) las?|(\s*,\s*)?((cerca|alrededor)\s+)?(de\s+las?|del))$";
      public const string TimeHourNumRegex = @"(?<hour>veint(i(uno|dos|tres|cuatro)|e)|cero|uno|dos|tres|cuatro|cinco|seis|siete|ocho|nueve|diez|once|doce|trece|catorce|quince|dieci(s([eé])is|siete|ocho|nueve))";
      public static readonly string PureNumFromTo = $@"((\b(desde|de)\s+(la(s)?\s+)?)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})(?!\s+al?\b)(\s*(?<leftDesc>{DescRegex}))?|(\b(desde|de)\s+(la(s)?\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?)\s*{TillRegex}\s*({BaseDateTime.HourRegex}|{TimeHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex})?";
      public static readonly string PureNumBetweenAnd = $@"(\bentre\s+(la(s)?\s+)?)(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{RangeConnectorRegex}\s*(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{BaseDateTime.HourRegex}|{TimeHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex})?";
      public static readonly string SpecificTimeFromTo = $@"({RangePrefixRegex}\s+)?(?<time1>(({TimeRegex2}|{TimeRegexWithDotConnector}(\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{TillRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"({BetweenRegex}\s+)(?<time1>(({TimeRegex1}|{TimeRegex2}|{TimeRegexWithDotConnector}(\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{RangeConnectorRegex}\s*(?<time2>(({TimeRegex1}|{TimeRegex2}|{TimeRegexWithDotConnector}(\s*{DescRegex})?)|({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public const string TimeUnitRegex = @"([^A-Za-z]{1,}|\b)(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\,\d*)?)\s*{TimeUnitRegex}";
      public static readonly string DateTimePeriodNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?)\s*{TimeUnitRegex}";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"\b(((y|a|en|por)\s+(la\s+)?|al\s+)?((((?<early>primeras\s+horas\s+)|(?<late>(últimas|altas)\s+horas\s+))(de\s+la\s+)?|{LaterEarlyRegex}\s+(est[ae]\s+)?)?(?<timeOfDay>(mañana|madrugada|pasado\s+(el\s+)?medio\s?d[ií]a|(?<!(m[áa]s\s+))tarde|noche|anoche))))(\s+(del|de))?\b";
      public static readonly string RelativeTimeUnitRegex = $@"({PastRegex}|{FutureRegex})\s+{TimeUnitRegex}";
      public const string LessThanRegex = @"\b(dentro\s+de\s+menos\s+de)\b";
      public const string MoreThanRegex = @"\b(durante\s+(m[áa]s\s+)?de)\b";
      public const string SuffixAndRegex = @"(?<suffix>\s*(y)\s+((un[ao]?)\s+)?(?<suffix_num>media|cuarto))";
      public static readonly string FollowedUnit = $@"^\s*{UnitRegex}";
      public static readonly string DurationNumberCombinedWithUnit = $@"\b(?<num>\d+(\,\d*)?){UnitRegex}";
      public static readonly string AnUnitRegex = $@"\b(una?|otr[ao])\s+{UnitRegex}";
      public const string DuringRegex = @"^[.]";
      public const string AllRegex = @"\b(?<all>tod[oa]?\s+(el|la)\s+(?<unit>año|mes|semana|d[ií]a)|((una?|el|la)\s+)?(?<unit>año|mes|semana|d[ií]a)\s+enter[ao])\b";
      public const string HalfRegex = @"\b(?<half>medi[oa]\s+(?<unit>ano|mes|semana|d[íi]a|hora))\b";
      public const string ConjunctionRegex = @"^[.]";
      public const string InexactNumberRegex = @"\b(pocos?|algo|vari[ao]s|algun[ao]s|un[ao]s)\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+{UnitRegex}";
      public static readonly string HolidayRegex1 = $@"\b(?<holiday>viernes\s+(santo|negro)|mi[eé]rcoles de ceniza|martes de carnaval|d[ií]a (de|de los) presidentes?|clebraci[oó]n de mao|año nuevo chino|año nuevo|noche vieja|(festividad de )?los mayos|d[ií]a de los inocentes|navidad|noche buena|d[ií]a de acci[oó]n de gracias|acci[oó]n de gracias|yuandan|halloween|noches de brujas|pascuas)(\s+(del?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\s+año))?\b";
      public static readonly string HolidayRegex2 = $@"\b(?<holiday>(d[ií]a( del?( la)?)? )?(martin luther king|todos los santos|tierra|blanco|san patricio|san valent[ií]n|san jorge|cinco de mayo|independencia|raza|trabajador))(\s+(del?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\s+año))?\b";
      public static readonly string HolidayRegex3 = $@"\b(?<holiday>(d[ií]a( internacional)?( del?( l[ao]s?)?)? )(trabajador(es)?|madres?|padres?|[aá]rbol|mujer(es)?|solteros?|niños?|marmota|san valent[ií]n|maestro))(\s+(del?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|est[ea]|[uú]ltim[oa]?|en))\s+año))?\b";
      public const string BeforeRegex = @"(\b((ante(s|rior)|m[aá]s\s+temprano|no\s+m[aá]s\s+tard(e|ar)|hasta|(?<include>tan\s+tarde\s+como))(\s+(del?|a|que)(\s+(el|las?|los?))?)?)|(?<!\w|>)((?<include><\s*=)|<))";
      public const string AfterRegex = @"((\b(despu[eé]s|(año\s+)?posterior|m[aá]s\s+tarde|a\s+primeros)(\s*(del?|en|a)(\s+(el|las?|los?))?)?|(empi?en?zando|comenzando)(\s+(el|las?|los?))?)\b|(?<!\w|<)((?<include>>\s*=)|>))";
      public const string SinceRegex = @"\b(((cualquier\s+tiempo\s+)?(desde|a\s+partir\s+del?)|tan\s+(temprano|pronto)\s+como(\s+(de|a))?)(\s+(el|las?|los?))?)\b";
      public static readonly string SinceRegexExp = $@"({SinceRegex}|\bde\b)";
      public const string AroundRegex = @"(?:\b(?:cerca|alrededor|aproximadamente)(\s+(de\s+(las?|el)|del?))?\s*\b)";
      public const string PeriodicRegex = @"\b(?<periodic>a\s*diario|diaria(s|mente)|(bi|tri)?(semanal|quincenal|mensual|(se|tri)mestral|anual)(es|mente)?)\b";
      public const string EachExpression = @"\b(cada|tod[oa]s\s*(l[oa]s)?)\b\s*(?!\s*l[oa]\b)";
      public static readonly string EachUnitRegex = $@"(?<each>({EachExpression})\s*({UnitRegex}|(?<specialUnit>fin(es)?\s+de\s+semana|finde)\b))";
      public static readonly string EachPrefixRegex = $@"(?<each>({EachExpression})\s*$)";
      public static readonly string EachDayRegex = $@"\s*({EachExpression})\s*d[ií]as\s*\b";
      public static readonly string BeforeEachDayRegex = $@"({EachExpression})\s*d[ií]as(\s+a\s+las?)?\s*\b";
      public static readonly string SetEachRegex = $@"(?<each>({EachExpression})\s*)";
      public static readonly string LaterEarlyPeriodRegex = $@"\b(({PrefixPeriodRegex})\s+(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|({UnspecificEndOfRangeRegex}))\b";
      public const string RelativeWeekRegex = @"(((la|el)\s+)?(((est[ae]|pr[oó]xim[oa]|[uú]ltim(o|as|os))\s+semanas?)|(semanas?\s+(que\s+viene|pasad[oa]))))";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((({RelativeWeekRegex})((\s+entre\s+{WeekDayRegex}\s+y\s+{WeekDayRegex})|(\s+de\s+{WeekDayRegex}\s+a\s+{WeekDayRegex})))|((entre\s+{WeekDayRegex}\s+y\s+{WeekDayRegex})|(de\s+{WeekDayRegex}\s+a\s+{WeekDayRegex})){OfPrepositionRegex}\s+{RelativeWeekRegex})\b";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"^[.]";
      public const string PrefixArticleRegex = @"\b(e[ln]\s+(d[ií]a\s+)?)";
      public const string OrRegex = @"^[.]";
      public static readonly string SpecialYearTermsRegex = $@"\b(({SpecialYearPrefixes}\s+a[nñ]os?\s+|a[nñ]os?\s+({SpecialYearPrefixes}\s+)?)(de\s+)?)";
      public static readonly string YearPlusNumberRegex = $@"\b({SpecialYearTermsRegex}((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{HourRegex}(?<desc>\s*h(oras)?)?)\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b((?<=\b(antes|no\s+m[aá]s\s+tard(e|ar)\s+(de|a\s+las?)|por| después)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))\b";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>a\s+las)\s*$";
      public const string CenturyRegex = @"^[.]";
      public const string DecadeRegex = @"(?<decade>diez|veinte|treinta|cuarenta|cincuenta|se[st]enta|ochenta|noventa)";
      public static readonly string DecadeWithCenturyRegex = $@"(los\s+)?((((d[ée]cada(\s+de)?)\s+)(((?<century>\d|1\d|2\d)?(?<decade>\d0))))|a[ñn]os\s+((?<century>\d|1\d|2\d)?(?<decade>\d0)\b)|a[ñn]os\s+(((?<century>((dos\s+)?mil\s+)?({WrittenOneHundredToNineHundredRegex}\s+)?)?{DecadeRegex})|(?<century>((dos\s+)?mil\s+)?({WrittenOneHundredToNineHundredRegex}))(\s+{DecadeRegex}?)|(?<century>((dos\s+)?mil)(\s+{WrittenOneHundredToNineHundredRegex}\s+)?){DecadeRegex}?))";
      public static readonly string RelativeDecadeRegex = $@"\b(((el|las?)\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?(d[eé]cada|decenio)s?)\b";
      public static readonly string ComplexDatePeriodRegex = $@"(?:((de(sde)?)\s+)?(?<start>.+)\s*({StrictTillRegex})\s*(?<end>.+)|((entre)\s+)(?<start>.+)\s*({RangeConnectorRegex})\s*(?<end>.+))";
      public const string AmbiguousPointRangeRegex = @"^(mar\.?)$";
      public static readonly string YearSuffix = $@"((,|\sdel?)?\s*({YearRegex}|{FullTextYearRegex}))";
      public static readonly string SinceYearSuffixRegex = $@"(^\s*{SinceRegex}(\s*(el\s+)?año\s*)?{YearSuffix})";
      public const string AgoRegex = @"\b(antes\s+de\s+(?<day>hoy|ayer|mañana)|antes|hace)\b";
      public const string LaterRegex = @"\b(despu[eé]s(?!\s+de\b)|desde\s+ahora|(a\s+partir|despu[eé]s)\s+de\s+(ahora|(?<day>hoy|ayer|mañana)))\b";
      public const string Tomorrow = @"mañana";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"años", @"Y" },
            { @"año", @"Y" },
            { @"anos", @"Y" },
            { @"ano", @"Y" },
            { @"meses", @"MON" },
            { @"mes", @"MON" },
            { @"trimestre", @"3MON" },
            { @"trimestres", @"3MON" },
            { @"cuatrimestre", @"4MON" },
            { @"cuatrimestres", @"4MON" },
            { @"semestre", @"6MON" },
            { @"semestres", @"6MON" },
            { @"bimestre", @"2MON" },
            { @"bimestres", @"2MON" },
            { @"semanas", @"W" },
            { @"semana", @"W" },
            { @"fin de semana", @"WE" },
            { @"fines de semana", @"WE" },
            { @"finde", @"WE" },
            { @"dias", @"D" },
            { @"dia", @"D" },
            { @"días", @"D" },
            { @"día", @"D" },
            { @"jornada", @"D" },
            { @"noche", @"D" },
            { @"noches", @"D" },
            { @"horas", @"H" },
            { @"hora", @"H" },
            { @"hrs", @"H" },
            { @"hras", @"H" },
            { @"hra", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minutos", @"M" },
            { @"minuto", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"segundos", @"S" },
            { @"segundo", @"S" },
            { @"segs", @"S" },
            { @"seg", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"años", 31536000 },
            { @"año", 31536000 },
            { @"anos", 31536000 },
            { @"ano", 31536000 },
            { @"meses", 2592000 },
            { @"mes", 2592000 },
            { @"semanas", 604800 },
            { @"semana", 604800 },
            { @"fin de semana", 172800 },
            { @"fines de semana", 172800 },
            { @"finde", 172800 },
            { @"dias", 86400 },
            { @"dia", 86400 },
            { @"días", 86400 },
            { @"día", 86400 },
            { @"noche", 86400 },
            { @"noches", 86400 },
            { @"horas", 3600 },
            { @"hora", 3600 },
            { @"hrs", 3600 },
            { @"hras", 3600 },
            { @"hra", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minutos", 60 },
            { @"minuto", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"segundos", 1 },
            { @"segundo", 1 },
            { @"segs", 1 },
            { @"seg", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscal", @"FY" },
            { @"escolar", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"primavera", @"SP" },
            { @"verano", @"SU" },
            { @"otoño", @"FA" },
            { @"invierno", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"primer", 1 },
            { @"primero", 1 },
            { @"primera", 1 },
            { @"1er", 1 },
            { @"1ro", 1 },
            { @"1ra", 1 },
            { @"1.º", 1 },
            { @"1º", 1 },
            { @"1ª", 1 },
            { @"segundo", 2 },
            { @"segunda", 2 },
            { @"2do", 2 },
            { @"2da", 2 },
            { @"2.º", 2 },
            { @"2º", 2 },
            { @"2ª", 2 },
            { @"tercer", 3 },
            { @"tercero", 3 },
            { @"tercera", 3 },
            { @"3er", 3 },
            { @"3ro", 3 },
            { @"3ra", 3 },
            { @"3.º", 3 },
            { @"3º", 3 },
            { @"3ª", 3 },
            { @"cuarto", 4 },
            { @"cuarta", 4 },
            { @"4to", 4 },
            { @"4ta", 4 },
            { @"4.º", 4 },
            { @"4º", 4 },
            { @"4ª", 4 },
            { @"quinto", 5 },
            { @"quinta", 5 },
            { @"5to", 5 },
            { @"5ta", 5 },
            { @"5.º", 5 },
            { @"5º", 5 },
            { @"5ª", 5 },
            { @"sexto", 6 },
            { @"sexta", 6 },
            { @"6to", 6 },
            { @"6ta", 6 },
            { @"septimo", 7 },
            { @"séptimo", 7 },
            { @"septima", 7 },
            { @"séptima", 7 },
            { @"7mo", 7 },
            { @"7ma", 7 },
            { @"octavo", 8 },
            { @"octava", 8 },
            { @"8vo", 8 },
            { @"8va", 8 },
            { @"noveno", 9 },
            { @"novena", 9 },
            { @"9no", 9 },
            { @"9na", 9 },
            { @"decimo", 10 },
            { @"décimo", 10 },
            { @"decima", 10 },
            { @"décima", 10 },
            { @"10mo", 10 },
            { @"10ma", 10 },
            { @"undecimo", 11 },
            { @"undécimo", 11 },
            { @"undecima", 11 },
            { @"undécima", 11 },
            { @"11mo", 11 },
            { @"11ma", 11 },
            { @"duodecimo", 12 },
            { @"duodécimo", 12 },
            { @"duodecima", 12 },
            { @"duodécima", 12 },
            { @"12mo", 12 },
            { @"12ma", 12 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"lunes", 1 },
            { @"martes", 2 },
            { @"miercoles", 3 },
            { @"miércoles", 3 },
            { @"jueves", 4 },
            { @"viernes", 5 },
            { @"sabado", 6 },
            { @"sábado", 6 },
            { @"domingo", 0 },
            { @"dom", 0 },
            { @"lun", 1 },
            { @"mar", 2 },
            { @"mie", 3 },
            { @"mié", 3 },
            { @"jue", 4 },
            { @"vie", 5 },
            { @"sab", 6 },
            { @"sáb", 6 },
            { @"dom.", 0 },
            { @"lun.", 1 },
            { @"mar.", 2 },
            { @"mie.", 3 },
            { @"mié.", 3 },
            { @"jue.", 4 },
            { @"vie.", 5 },
            { @"sab.", 6 },
            { @"sáb.", 6 },
            { @"do", 0 },
            { @"lu", 1 },
            { @"ma", 2 },
            { @"mi", 3 },
            { @"ju", 4 },
            { @"vi", 5 },
            { @"sa", 6 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"enero", 1 },
            { @"febrero", 2 },
            { @"marzo", 3 },
            { @"abril", 4 },
            { @"mayo", 5 },
            { @"junio", 6 },
            { @"julio", 7 },
            { @"agosto", 8 },
            { @"septiembre", 9 },
            { @"setiembre", 9 },
            { @"octubre", 10 },
            { @"noviembre", 11 },
            { @"diciembre", 12 },
            { @"ene", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"abr", 4 },
            { @"may", 5 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"ago", 8 },
            { @"sept", 9 },
            { @"sep", 9 },
            { @"set", 9 },
            { @"oct", 10 },
            { @"nov", 11 },
            { @"dic", 12 },
            { @"ene.", 1 },
            { @"feb.", 2 },
            { @"mar.", 3 },
            { @"abr.", 4 },
            { @"may.", 5 },
            { @"jun.", 6 },
            { @"jul.", 7 },
            { @"ago.", 8 },
            { @"sept.", 9 },
            { @"sep.", 9 },
            { @"set.", 9 },
            { @"oct.", 10 },
            { @"nov.", 11 },
            { @"dic.", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"cero", 0 },
            { @"un", 1 },
            { @"una", 1 },
            { @"uno", 1 },
            { @"dos", 2 },
            { @"dós", 2 },
            { @"tres", 3 },
            { @"trés", 3 },
            { @"cuatro", 4 },
            { @"cinco", 5 },
            { @"seis", 6 },
            { @"séis", 6 },
            { @"siete", 7 },
            { @"ocho", 8 },
            { @"nueve", 9 },
            { @"diez", 10 },
            { @"once", 11 },
            { @"doce", 12 },
            { @"docena", 12 },
            { @"docenas", 12 },
            { @"trece", 13 },
            { @"catorce", 14 },
            { @"quince", 15 },
            { @"dieciseis", 16 },
            { @"dieciséis", 16 },
            { @"diecisiete", 17 },
            { @"dieciocho", 18 },
            { @"diecinueve", 19 },
            { @"veinte", 20 },
            { @"veinti", 20 },
            { @"ventiuna", 21 },
            { @"ventiuno", 21 },
            { @"veintiun", 21 },
            { @"veintiún", 21 },
            { @"veintiuno", 21 },
            { @"veintiuna", 21 },
            { @"veintidos", 22 },
            { @"veintidós", 22 },
            { @"veintitres", 23 },
            { @"veintitrés", 23 },
            { @"veinticuatro", 24 },
            { @"veinticinco", 25 },
            { @"veintiseis", 26 },
            { @"veintiséis", 26 },
            { @"veintisiete", 27 },
            { @"veintiocho", 28 },
            { @"veintinueve", 29 },
            { @"treinta", 30 },
            { @"cuarenta", 40 },
            { @"cincuenta", 50 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"padres", new string[] { @"diadelpadre" } },
            { @"madres", new string[] { @"diadelamadre" } },
            { @"acciondegracias", new string[] { @"diadegracias", @"diadeacciondegracias", @"acciondegracias" } },
            { @"trabajador", new string[] { @"diadeltrabajador", @"diadelostrabajadores", @"diainternacionaldeltrabajador", @"diainternacionaldelostrabajadores" } },
            { @"delaraza", new string[] { @"diadelaraza", @"diadeladiversidadcultural" } },
            { @"memoria", new string[] { @"diadelamemoria" } },
            { @"pascuas", new string[] { @"diadepascuas", @"pascuas" } },
            { @"navidad", new string[] { @"navidad", @"diadenavidad" } },
            { @"nochebuena", new string[] { @"diadenochebuena", @"nochebuena" } },
            { @"añonuevo", new string[] { @"añonuevo", @"diadeañonuevo" } },
            { @"nochevieja", new string[] { @"nochevieja", @"diadenochevieja" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"earthday", new string[] { @"diadelatierra" } },
            { @"maestro", new string[] { @"diadelmaestro" } },
            { @"todoslossantos", new string[] { @"todoslossantos" } },
            { @"niño", new string[] { @"diadelniño" } },
            { @"mujer", new string[] { @"diadelamujer" } },
            { @"independencia", new string[] { @"diadelaindependencia", @"diadeindependencia", @"independencia" } },
            { @"blackfriday", new string[] { @"viernesnegro" } },
            { @"goodfriday", new string[] { @"viernessanto" } },
            { @"stpatrickday", new string[] { @"sanpatricio", @"diadesanpatricio" } },
            { @"valentinesday", new string[] { @"sanvalentin", @"diadesanvalentin" } }
        };
      public static readonly Dictionary<string, string> VariableHolidaysTimexDictionary = new Dictionary<string, string>
        {
            { @"padres", @"-06-WXX-7-3" },
            { @"madres", @"-05-WXX-7-2" },
            { @"acciondegracias", @"-11-WXX-4-4" },
            { @"delaraza", @"-10-WXX-1-2" },
            { @"memoria", @"-03-WXX-2-4" }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"mitad", 0.5 },
            { @"cuarto", 0.25 }
        };
      public const string UpcomingPrefixRegex = @"((este\s+))";
      public static readonly string NextPrefixRegex = $@"\b({UpcomingPrefixRegex}?pr[oó]xim[oa]s?|siguiente|que\s+viene)\b";
      public const string PastPrefixRegex = @"((este\s+))";
      public static readonly string PreviousPrefixRegex = $@"\b({PastPrefixRegex}?pasad[oa]s?(?!(\s+el)?\s+medio\s*d[ií]a)|[uú]ltim[oa]s?|anterior)\b";
      public const string ThisPrefixRegex = @"(est?[ea]|actual)\b";
      public const string PrefixWeekDayRegex = @"(\s*((,?\s*el)|[-—–]))";
      public static readonly string ThisRegex = $@"\b((est[ae]\s*)(semana{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}\s*((de\s+)?esta\s+semana))\b";
      public static readonly string LastDateRegex = $@"\b(({PreviousPrefixRegex}\s+(semana{PrefixWeekDayRegex}?)?|(la\s+)?semana\s+{PreviousPrefixRegex}{PrefixWeekDayRegex})\s*{WeekDayRegex})|(este\s+)?({WeekDayRegex}\s+([uú]ltimo|pasado|anterior))|({WeekDayRegex}(\s+((de\s+)?((esta|la)\s+([uú]ltima\s+)?semana)|(de\s+)?(la\s+)?semana\s+(pasada|anterior))))\b";
      public static readonly string NextDateRegex = $@"\b((({NextPrefixRegex}\s+)(semana{PrefixWeekDayRegex}?)?|(la\s+)?semana\s+{NextPrefixRegex}{PrefixWeekDayRegex})\s*{WeekDayRegex})|(este\s+)?({WeekDayRegex}\s+(pr[oó]ximo|siguiente|que\s+viene))|({WeekDayRegex}(\s+(de\s+)?(la\s+)?((pr[oó]xima|siguiente)\s+semana|semana\s+(pr[oó]xima|siguiente))))\b";
      public const string RelativeDayRegex = @"(?<relday>((este|pr[oó]ximo|([uú]ltim(o|as|os)))\s+días)|(días\s+((que\s+viene)|pasado)))\b";
      public const string RestOfDateRegex = @"\bresto\s+((del|de)\s+)?((la|el|est?[ae])\s+)?(?<duration>semana|mes|año|decada)(\s+actual)?\b";
      public static readonly string WithinNextPrefixRegex = $@"\b(dentro\s+de((\s+(el|l[ao]s?))?\s+(?<next>{NextPrefixRegex}))?)(?=\s*$)\b";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|horas?|hra?s?|hs?|minutos?|mins?|segundos?|segs?|noches?)\b";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|y|,)\s*$";
      public static readonly string RelativeDurationUnitRegex = $@"(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))";
      public const string ReferencePrefixRegex = @"(mism[ao]|aquel|est?e)\b";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+({DateUnitRegex}|fin\s+de\s+semana)\b";
      public const string FromToRegex = @"\b(from).+(to)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(the\s+)?(may|march)$";
      public const string UnspecificDatePeriodRegex = @"^[\.]";
      public const string PrepositionSuffixRegex = @"\b(en|el|la|cerca|alrededor|desde|durante|hasta|hacia)$";
      public const string RestOfDateTimeRegex = @"\bresto\s+((del?)\s+)?((la|el|est[ae])\s+)?(?<unit>(día|jornada))(\s+de\s+hoy)?\b";
      public const string SetWeekDayRegex = @"^[\.]";
      public const string NightRegex = @"\b(medionoche|noche)\b";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public const string SuffixAfterRegex = @"\b((a\s+)?(o|y)\s+(arriba|despu[eé]s|posterior|mayor|m[aá]s\s+tarde)(?!\s+(que|de)))\b";
      public static readonly string YearPeriodRegex = $@"((((de(sde)?|durante|en)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((entre)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public const string FutureSuffixRegex = @"\b(siguiente(s)?|pr[oó]xim[oa](s)?|(en\s+el\s+)?futuro)\b";
      public const string PastSuffixRegex = @"^\b$";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"diez", 10 },
            { @"veinte", 20 },
            { @"treinta", 30 },
            { @"cuarenta", 40 },
            { @"cincuenta", 50 },
            { @"sesenta", 60 },
            { @"setenta", 70 },
            { @"ochenta", 80 },
            { @"noventa", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"", 0 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly string[] DurationDateRestrictions = { @"hoy" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"^(este\s+)?mi(\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\s+viene))?$", @"\b(este\s+)?mi(\s+([uú]ltimo|pasado|anterior|pr[oó]ximo|siguiente|que\s+viene))?\b" },
            { @"^a[nñ]o$", @"(?<!el\s+)a[nñ]o" },
            { @"^semana$", @"(?<!la\s+)semana" },
            { @"^mes$", @"(?<!el\s+)mes" },
            { @"^(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)$", @"([$%£&!?@#])(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)|(abr|ago|dic|feb|ene|ju[ln]|mar|may|nov|oct|sep?t|sep)([$%£&@#])" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public const string EarlyMorningStartEndRegex = @"(^(madrugada)|(madrugada)$)";
      public const string MorningStartEndRegex = @"(^((la\s+)?mañana))|(((la\s+)?mañana)$)";
      public const string AfternoonStartEndRegex = @"(^(pasado\s+(el\s+)?medio\s*dia))|((pasado\s+(el\s+)?medio\s*dia)$)";
      public const string EveningStartEndRegex = @"(^(tarde))|((tarde)$)";
      public const string NightStartEndRegex = @"(^(noche)|(noche)$)";
      public static readonly IList<string> EarlyMorningTermList = new List<string>
        {
            @"madrugada"
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"mañana",
            @"la mañana"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"pasado mediodia",
            @"pasado el mediodia",
            @"pasado mediodía",
            @"pasado el mediodía",
            @"pasado medio dia",
            @"pasado el medio dia",
            @"pasado medio día",
            @"pasado el medio día"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"tarde"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"noche"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"hoy",
            @"el dia"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"mañana",
            @"dia siguiente",
            @"el dia de mañana",
            @"proximo dia"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"ayer",
            @"ultimo dia",
            @"dia anterior"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"pasado mañana",
            @"dia despues de mañana"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"anteayer",
            @"dia antes de ayer"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"mes",
            @"meses"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"mes a la fecha",
            @"mes hasta la fecha"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"finde",
            @"fin de semana",
            @"fines de semana"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"semana"
        };
      public static readonly IList<string> FortnightTerms = new List<string>
        {
            @"quincena",
            @"la quincena"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"año",
            @"años",
            @"ano",
            @"anos"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"año a la fecha",
            @"año hasta la fecha"
        };
      public static readonly Dictionary<char, char> SpecialCharactersEquivalent = new Dictionary<char, char>
        {
            { 'á', 'a' },
            { 'é', 'e' },
            { 'í', 'i' },
            { 'ó', 'o' },
            { 'ú', 'u' }
        };
      public const string DoubleMultiplierRegex = @"^(bi)(-|\s)?";
      public const string DayTypeRegex = @"(d[ií]as?|diari(o|as|amente))$";
      public const string WeekTypeRegex = @"(semanas?|semanalmente)$";
      public const string BiWeekTypeRegex = @"(quincenalmente)$";
      public const string WeekendTypeRegex = @"(fin(es)?\s+de\s+semana|finde)$";
      public const string MonthTypeRegex = @"(mes(es)?|mensual(es|mente)?)$";
      public const string QuarterTypeRegex = @"(trimestral(es|mente)?)$";
      public const string SemiAnnualTypeRegex = @"(semestral(es|mente)?)$";
      public const string YearTypeRegex = @"(a[nñ]os?|anual(mente)?)$";
      public static readonly IList<string> ThisTerms = new List<string>
        {
            @"esta"
        };
    }
}