﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Portuguese\Portuguese-DateTime.yaml
//     - Language: Portuguese
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Portuguese
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Por";
      public const bool CheckBothBeforeAfter = false;
      public const string TillRegex = @"(?<till>\b(at[eé]h?|[aà]s|ao?)\b|--|-|—|——)(\s+\b(o|[aà](s)?)\b)?";
      public static readonly string RangeConnectorRegex = $@"(?<and>(e\s*(([àa]s?)|o)?)|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string DayRegex = @"(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?=\b|t)";
      public const string WrittenDayRegex = @"(?<day>(vinte\s+e\s+)?(um|dois|tr[eê]s|quatro|cinco|seis|sete|oito|nove)|dez|onze|doze|treze|(c|qu)atorze|quinze|dez[ae](s(seis|sete)|nove)|dezoito|vinte|trinta(\s+e\s+um)?)";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])\b";
      public static readonly string AmDescRegex = $@"({BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"({BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"({BaseDateTime.BaseAmPmDescRegex})";
      public const string OclockRegex = @"(?<oclock>em\s+ponto)";
      public static readonly string DescRegex = $@"((horas\s+)?(?<desc>{AmDescRegex}|{PmDescRegex})|{OclockRegex})";
      public const string OfPrepositionRegex = @"(\bd(o|a|e)s?\b)";
      public const string AfterNextSuffixRegex = @"\b(que\s+vem|passad[oa])\b";
      public const string RangePrefixRegex = @"((de(sde)?|das?|entre)\s+(a(s)?\s+)?)";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public const string RelativeRegex = @"(?<order>((n?est[ae]s?|pr[oó]xim[oa]s?|([uú]ltim[ao]s?))(\s+fina(l|is)\s+d[eao])?)|(fina(l|is)\s+d[eao]))\b";
      public const string StrictRelativeRegex = @"(?<order>((n?est[ae]|pr[oó]xim[oa]|([uú]ltim(o|as|os)))(\s+fina(l|is)\s+d[eao])?)|(fina(l|is)\s+d[eao]))\b";
      public const string WrittenOneToNineRegex = @"(uma?|dois|duas|tr[eê]s|quatro|cinco|seis|sete|oito|nove)";
      public const string WrittenOneHundredToNineHundredRegex = @"(duzent[oa]s|trezent[oa]s|[cq]uatrocent[ao]s|quinhent[ao]s|seiscent[ao]s|setecent[ao]s|oitocent[ao]s|novecent[ao]s|cem|(?<!por\s+)(cento))";
      public static readonly string WrittenOneToNinetyNineRegex = $@"(((vinte|trinta|[cq]uarenta|cinquenta|sessenta|setenta|oitenta|noventa)(\s+e\s+{WrittenOneToNineRegex})?)|d[eé]z|onze|doze|treze|(c|qu)atorze|quinze|dez[ea]sseis|dez[ea]ssete|dez[ea]nove|dezoito|uma?|d(oi|ua)s|tr[eê]s|quatro|cinco|seis|sete|oito|nove)";
      public static readonly string FullTextYearRegex = $@"\b(?<fullyear>((dois\s+)?mil)((\s+e)?\s+{WrittenOneHundredToNineHundredRegex})?((\s+e)?\s+{WrittenOneToNinetyNineRegex})?)";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string RelativeMonthRegex = @"(?<relmonth>([nd]?es[st]e|pr[óo]ximo|passsado|[uú]ltimo)\s+m[eê]s)\b";
      public const string MonthRegex = @"(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>((em|no)\s+|d[eo]\s+)?({RelativeMonthRegex}|{MonthRegex}))";
      public const string DateUnitRegex = @"(?<unit>(?<uoy>m[êe]s)(?<plural>es)?|(ano|(?<uoy>semana|dia))(?<plural>s)?)\b";
      public const string PastRegex = @"(?<past>\b(passad[ao](s)?|[uú]ltim[oa](s)?|anterior(es)?|h[aá]|pr[ée]vi[oa](s)?)\b)";
      public const string FutureRegex = @"(?<past>\b(seguinte(s)?|pr[oó]xim[oa](s)?|daqui\s+a)\b)";
      public static readonly string SimpleCasesRegex = $@"\b((desde\s+[oa]|desde|d[oa])\s+)?(dia\s+)?({DayRegex})\s*{TillRegex}\s*(o dia\s+)?({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b{MonthSuffixRegex}\s+((desde\s+[oa]|desde|d[oa])\s+)?(dia\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+((entre|entre\s+[oa]s?)\s+)(dias?\s+)?({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string DayBetweenRegex = $@"\b((entre|entre\s+[oa]s?)\s+)(dia\s+)?({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public const string SpecialYearPrefixes = @"((do\s+)?calend[aá]rio|civil|(?<special>fiscal|escolar|letivo))";
      public static readonly string OneWordPeriodRegex = $@"\b(((pr[oó]xim[oa]?|[nd]?es[st]e|aquel[ea]|[uú]ltim[oa]?|em)\s+)?(?<month>abr(il)?|ago(sto)?|dez(embro)?|fev(ereiro)?|jan(eiro)?|ju[ln](ho)?|mar([çc]o)?|maio?|nov(embro)?|out(ubro)?|sep?t(embro)?)|({RelativeRegex}\s+)?(ano\s+{SpecialYearPrefixes}|{SpecialYearPrefixes}\s+ano)|(?<=\b(de|do|da|o|a)\s+)?(pr[oó]xim[oa](s)?|[uú]ltim[oa]s?|est(e|a))\s+(fim de semana|fins de semana|semana|m[êe]s|ano)|fim de semana|fins de semana|(m[êe]s|anos)? [àa] data)\b";
      public static readonly string MonthWithYearRegex = $@"\b((((pr[oó]xim[oa](s)?|[nd]?es[st]e|aquele|[uú]ltim[oa]?|em)\s+)?{MonthRegex}|((n?o\s+)?(?<cardinal>primeiro|1o|segundo|2o|terceiro|3o|[cq]uarto|4o|quinto|5o|sexto|6o|s[eé]timo|7o|oitavo|8o|nono|9o|d[eé]cimo(\s+(primeiro|segundo))?|10o|11o|12o|[uú]ltimo)\s+m[eê]s(?=\s+(d[aeo]|[ao]))))\s+((d[aeo]|[ao])\s+)?({YearRegex}|{TwoDigitYearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\s+ano))\b";
      public static readonly string MonthNumWithYearRegex = $@"({YearRegex}(\s*?)[/\-\.](\s*?){MonthNumRegex})|({MonthNumRegex}(\s*?)[/\-](\s*?){YearRegex})";
      public static readonly string WeekOfMonthRegex = $@"(?<wom>(a|na\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima)\s+semana\s+{MonthSuffixRegex})";
      public static readonly string WeekOfYearRegex = $@"(?<woy>(a|na\s+)?(?<cardinal>primeira?|1a|segunda|2a|terceira|3a|[qc]uarta|4a|quinta|5a|[uú]ltima?)\s+semana(\s+d[oe]?)?\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\s+ano))";
      public static readonly string OfYearRegex = $@"\b((d[aeo]?|[ao])\s*({YearRegex}|{StrictRelativeRegex}\s+ano))\b";
      public const string FirstLastRegex = @"\b(n?[ao]s?\s+)?((?<first>primeir[ao]s?)|(?<last>[uú]ltim[ao]s?))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public static readonly string QuarterRegex = $@"(n?o\s+)?(?<cardinal>primeiro|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\s+trimestre(\s+d[oe]|\s*,\s*)?\s+({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\s+ano)";
      public static readonly string QuarterRegexYearFront = $@"({YearRegex}|(?<order>pr[oó]ximo(s)?|[uú]ltimo?|[nd]?es[st]e)\s+ano)\s+(n?o\s+)?(?<cardinal>(primeiro)|1[oº]|segundo|2[oº]|terceiro|3[oº]|[qc]uarto|4[oº])\s+trimestre";
      public const string AllHalfYearRegex = @"^[.]";
      public const string PrefixDayRegex = @"^[.]";
      public static readonly string SeasonRegex = $@"\b(?<season>(([uú]ltim[oa]|[nd]?es[st][ea]|n?[oa]|(pr[oó]xim[oa]s?|seguinte))\s+)?(?<seas>primavera|ver[ãa]o|outono|inverno)((\s+)?(seguinte|((de\s+|,)?\s*{YearRegex})|((do\s+)?(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\s+ano)))?)\b";
      public static readonly string WhichWeekRegex = $@"\b(semana)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])(\s+(de|do)\s+({YearRegex}|(?<order>pr[oó]ximo|[uú]ltimo|[nd]?es[st]e)\s+ano|ano\s+(?<order>passado)))?\b";
      public const string WeekOfRegex = @"(semana)(\s*)((do|da|de))";
      public const string MonthOfRegex = @"(mes)(\s*)((do|da|de))";
      public const string RangeUnitRegex = @"\b(?<unit>anos?|meses|m[êe]s|semanas?)\b";
      public const string BeforeAfterRegex = @"^[.]";
      public const string UpcomingPrefixRegex = @".^";
      public static readonly string NextPrefixRegex = $@"(pr[oó]xim[oa]s?|seguinte|{UpcomingPrefixRegex})\b";
      public const string InConnectorRegex = @"\b(em)\b";
      public const string SinceYearSuffixRegex = @"^[.]";
      public static readonly string WithinNextPrefixRegex = $@"\b(dentro\s+d(e|as)(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string TodayNowRegex = @"\b(hoje|agora)\b";
      public const string CenturySuffixRegex = @"^[.]";
      public const string FromRegex = @"(de(sde)?(\s*a(s)?)?)$";
      public const string BetweenRegex = @"(entre\s*([oa](s)?)?)";
      public const string WeekDayRegex = @"\b(?<weekday>(domingos?|(segunda|ter[çc]a|quarta|quinta|sexta)s?([-\s+]feiras?)?|s[aá]bados?|(2|3|4|5|6)[aª])\b|(dom|seg|ter[cç]|qua|qui|sex|sab)\b(\.?(?=\s|,|;|$)))";
      public static readonly string OnRegex = $@"(?<=\b(em|no)\s+)({DayRegex}s?)\b";
      public static readonly string RelaxedOnRegex = $@"((?<=\b(em|[nd][oa])\s+)(dia\s+)?({DayRegex}s?)|dia\s+{DayRegex}s?)\b(?!\s*[/\\\-\.,:\s]\s*(\d|(de\s+)?{MonthRegex}))";
      public static readonly string ThisRegex = $@"\b(([nd]?es[st][ea]\s*){WeekDayRegex})|({WeekDayRegex}\s*([nd]?es[st]a\s+semana))\b";
      public static readonly string LastDateRegex = $@"\b(([uú]ltim[ao])\s*{WeekDayRegex})|({WeekDayRegex}(\s+(([nd]?es[st]a|[nd]a)\s+([uú]ltima\s+)?semana)))\b";
      public static readonly string NextDateRegex = $@"\b(((pr[oó]xim[oa]|seguinte)\s*){WeekDayRegex})|({WeekDayRegex}((\s+(pr[oó]xim[oa]|seguinte))|(\s+(da\s+)?(semana\s+seguinte|pr[oó]xima\s+semana))))\b";
      public const string SpecialDayRegex = @"\b((d?o\s+)?(dia\s+antes\s+de\s+ontem|antes\s+de\s+ontem|anteontem)|((d?o\s+)?(dia\s+|depois\s+|dia\s+depois\s+)?de\s+amanh[aã])|(o\s)?dia\s+seguinte|(o\s)?pr[oó]ximo\s+dia|(o\s+)?[uú]ltimo\s+dia|ontem|amanh[ãa]|hoje)|(do\s+dia$)\b";
      public const string SpecialDayWithNumRegex = @"^[.]";
      public const string ForTheRegex = @".^";
      public static readonly string FlexibleDayRegex = $@"(?<DayOfMonth>([a-z]+\s)?({WrittenDayRegex}|{DayRegex}))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex}\s+(dia\s+{FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+({DayRegex})(?!([-:/]|\.\d|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>(n?[ao]\s+)?(?<cardinal>primeir[ao]|1[ao]|segund[ao]|2[ao]|terceir[ao]|3[ao]|[qc]uart[ao]|4[ao]|quint[ao]|5[ao]|[uú]ltim[ao])\s+{WeekDayRegex}\s+{MonthSuffixRegex})";
      public const string RelativeWeekDayRegex = @"^[.]";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public const string NumberEndingPattern = @"^[.]";
      public static readonly string SpecialDateRegex = $@"(?<=\bno\s+){DayRegex}\b";
      public static readonly string OfMonthRegex = $@"^(\s*de)?\s*{MonthSuffixRegex}";
      public static readonly string MonthEndRegex = $@"({MonthRegex}\s*(o)?\s*$)";
      public static readonly string WeekDayEnd = $@"{WeekDayRegex}\s*,?\s*$";
      public const string WeekDayStart = @"^\b$";
      public static readonly string DateYearRegex = $@"(?<year>{YearRegex}|{TwoDigitYearRegex})";
      public static readonly string DateExtractor1 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{DayRegex}((\s*(de)|[/\\\.\- ])\s*)?{MonthRegex}\b";
      public static readonly string DateExtractor2 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?({DayRegex}(\s*([/\.\-]|de)?\s*{MonthRegex}|\s+de\s+{MonthNumRegex})(\s*([,./-]|de|\s+)\s*){DateYearRegex}|{BaseDateTime.FourDigitYearRegex}\s*[/\.\- ]\s*{DayRegex}\s*[/\.\- ]\s*{MonthRegex})\b";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{MonthRegex}(\s*[/\.\- ]\s*|\s+de\s+){DayRegex}(?!\s*\-\s*\d{{2}}\b)((\s*[/\.\- ]\s*|\s+de\s+){DateYearRegex})?\b";
      public static readonly string DateExtractor4 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}\s*[/\\\-]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor5 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<=\b(em|no|o)\s+){MonthNumRegex}[\-\.]{DayRegex}{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor7 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{MonthNumRegex}\s*/\s*{DayRegex}((\s+|\s*(,|de)\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor8 = $@"(?<=\b(em|no|o)\s+){DayRegex}[\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor9 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{DayRegex}\s*/\s*{MonthNumRegex}((\s+|\s*(,|de)\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor10 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?({YearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}|{MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex}|{DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})(?!\s*[/\\\-\.:]\s*\d+)";
      public static readonly string DateExtractor11 = $@"(?<=\b(dia)\s+){DayRegex}";
      public const string HourNumRegex = @"\b(?<hournum>zero|uma|duas|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze)\b";
      public const string MinuteNumRegex = @"(?<minnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>um|dois|tr[êe]s|[qc]uatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|catorze|quatorze|quinze|dez[ea]sseis|dez[ea]sete|dezoito|dez[ea]nove|vinte|trinta|[qc]uarenta|cin[qc]uenta)";
      public const string PmRegex = @"(horas\s+)?(?<pm>((pela|de|da|\b[àa]\b|na)\s+(tarde|noite)))|((depois\s+do|ap[óo]s\s+o)\s+(almo[çc]o|meio dia|meio-dia))";
      public const string AmRegex = @"(horas\s+)?(?<am>(pela|de|da|na)\s+(manh[ãa]|madrugada))";
      public const string AmTimeRegex = @"(?<am>([dn]?es[st]a|(pela|de|da|na))\s+(manh[ãa]|madrugada))";
      public const string PmTimeRegex = @"(?<pm>(([dn]?es[st]a|\b[àa]\b|(pela|de|da|na))\s+(tarde|noite)))|((depois\s+do|ap[óo]s\s+o)\s+(almo[çc]o|meio dia|meio-dia))";
      public static readonly string LessThanOneHour = $@"(?<lth>((\s+e\s+)?(quinze|(um\s+|dois\s+|tr[êes]\s+)?quartos?)|quinze|(\s*)(um\s+|dois\s+|tr[êes]\s+)?quartos?|(\s+e\s+)(meia|trinta)|({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex})(\s+(minuto|minutos|min|mins))?))";
      public const string LessThanOneHourSuffix = @"(?<lth>((\s+e\s+)?(quinze|(um\s+|dois\s+|tr[êes]\s+)?quartos?)|quinze|(\s*)(um\s+|dois\s+|tr[êes]\s+)?quartos?|(\s+e\s+)(meia|trinta)))";
      public const string TensTimeRegex = @"(?<tens>dez|vinte|trinta|[qc]uarenta|cin[qc]uenta)";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>({HourNumRegex}\s*((e|menos)\s+)?(({TensTimeRegex}((\s*e\s+)?{MinuteNumRegex}))|{MinuteNumRegex}))|(({MinuteNumRegex}|({TensTimeRegex}((\s*e\s+)?{MinuteNumRegex})?))\s*((para as|pras|antes da|antes das)\s+)?({HourNumRegex}|{BaseDateTime.HourRegex})))";
      public static readonly string TimePrefix = $@"(?<prefix>{LessThanOneHour}(\s+(passad[ao]s)\s+(as)?|\s+depois\s+(das?|do)|\s+pras?|\s+(para|antes)?\s+([àa]s?)))";
      public static readonly string TimeSuffix = $@"(?<suffix>({LessThanOneHour}\s+)?({AmRegex}|{PmRegex}|{OclockRegex}))";
      public static readonly string BasicTime = $@"(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})";
      public const string MidnightRegex = @"(?<midnight>meia\s*(-\s*)?noite)";
      public const string MidmorningRegex = @"(?<midmorning>meio\s+da\s+manhã)";
      public const string MidEarlyMorning = @"(?<midearlymorning>meio\s+da\s+madrugada)";
      public const string MidafternoonRegex = @"(?<midafternoon>meio\s+da\s+tarde)";
      public const string MiddayRegex = @"(?<midday>meio\s*(-\s*)?dia)";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidEarlyMorning}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"\b(((?<=\b(d?[aà]s?)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(\s+e\s+{BaseDateTime.MinuteRegex})?)(\s+horas?|\s*h\b)?|(?<=\b(s(er)?[aã]o|v[aã]o\s+ser|^[eé]h?)\s+|^\s*)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\s+horas?|\s*h\b))(\s+{OclockRegex})?|{MidTimeRegex})\b";
      public static readonly string ConnectNumRegex = $@"({BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex})";
      public static readonly string TimeRegex1 = $@"(\b{TimePrefix}\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\s*({DescRegex})";
      public static readonly string TimeRegex2 = $@"(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"\b(({DescRegex}\s*)?(({TimePrefix}\s*)({HourNumRegex}|{BaseDateTime.HourRegex})|({HourNumRegex}|{BaseDateTime.HourRegex})(\s+{TensTimeRegex}(\s+e\s+)?{MinuteNumRegex}?)|{BasicTime}(\s*{DescRegex})?(?<prefix>{LessThanOneHourSuffix}))(\s*({DescRegex}|{OclockRegex}))?)\b";
      public static readonly string TimeRegex5 = $@"\b({TimePrefix}|{BasicTime}(?<prefix>{LessThanOneHourSuffix}))\s+(\s*{DescRegex})?{BasicTime}?\s*{TimeSuffix}\b";
      public static readonly string TimeRegex6 = $@"({BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b)";
      public static readonly string TimeRegex7 = $@"\b{TimeSuffix}\s+[àa]s?\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@"\b{TimeSuffix}\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex9 = $@"\b(?<writtentime>{HourNumRegex}\s+({TensTimeRegex}\s*)(e\s+)?{MinuteNumRegex}?)\b";
      public static readonly string TimeRegex11 = $@"\b({WrittenTimeRegex})(\s+{DescRegex})?\b";
      public static readonly string TimeRegex12 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public const string PrepositionRegex = @"(?<prep>([àa]s?|em|por|pel[ao]|n[ao]|de|d[ao]?)?$)";
      public const string NowRegex = @"\b(?<now>((logo|exatamente)\s+)?agora(\s+mesmo)?|neste\s+momento|(assim\s+que|t[ãa]o\s+cedo\s+quanto)\s+(poss[ií]vel|possas?|possamos)|o\s+mais\s+(cedo|r[aá]pido)\s+poss[íi]vel|recentemente|previamente)\b";
      public const string SuffixRegex = @"^\s*((e|a|em|por|pel[ao]|n[ao]|de)\s+)?(manh[ãa]|madrugada|meio\s*dia|tarde|noite)\b";
      public const string TimeOfDayRegex = @"\b(?<timeOfDay>manh[ãa]|madrugada|tarde|noite|((depois\s+do|ap[óo]s\s+o)\s+(almo[çc]o|meio[ -]dia)))\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(((((a)?\s+|[nd]?es[st]a|seguinte|pr[oó]xim[oa]|[uú]ltim[oa])\s+)?{TimeOfDayRegex}))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?([àa]|em|por|pel[ao]|de|no|na?\s+)?{SpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"({SpecificTimeOfDayRegex}(\s*,)?(\s+([àa]s|para))?\s*)";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?{SpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"({SpecificTimeOfDayRegex}(\s*,)?(\s+([àa]s|((cerca|perto|ao\s+redor|por\s+volta)\s+(de|das))))?\s*({HourNumRegex}|{BaseDateTime.HourRegex}))";
      public const string SpecificEndOfRegex = @"([na]o\s+)?(fi(m|nal)|t[ée]rmin(o|ar))(\s+d?o(\s+dia)?(\s+de)?)?\s*$";
      public const string UnspecificEndOfRegex = @"^[.]";
      public const string UnspecificEndOfRangeRegex = @"^[.]";
      public const string UnitRegex = @"(?<unit>anos?|meses|m[êe]s|semanas?|dias?|horas?|hrs?|hs?|minutos?|mins?|segundos?|segs?)\b";
      public const string ConnectorRegex = @"^(,|t|para [ao]|para as|pras|(cerca|perto|ao\s+redor|por\s+volta)\s+(de|das)|quase)$";
      public const string TimeHourNumRegex = @"(?<hour>vinte( e (um|dois|tr[êe]s|quatro))?|zero|uma?|dois|duas|tr[êe]s|quatro|cinco|seis|sete|oito|nove|dez|onze|doze|treze|quatorze|catorze|quinze|dez([ea]sseis|[ea]ssete|oito|[ea]nove))";
      public static readonly string PureNumFromTo = $@"(((desde|de|da|das)\s+(a(s)?\s+)?)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}|horas))?\s*{TillRegex}(?<![aà]s)|((desde|de|da|das)\s+(a(s)?\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}|horas))?\s*{TillRegex})\s*({BaseDateTime.HourRegex}|{TimeHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex}|horas)?";
      public static readonly string PureNumBetweenAnd = $@"(entre\s+((a|as)?\s+)?)({BaseDateTime.HourRegex}|{TimeHourNumRegex})(\s*(?<leftDesc>{DescRegex}|horas))?\s*e\s*(a(s)?\s+)?({BaseDateTime.HourRegex}|{TimeHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{DescRegex}|horas)?";
      public const string SpecificTimeFromTo = @"^[.]";
      public const string SpecificTimeBetweenAnd = @"^[.]";
      public const string TimeUnitRegex = @"(?<unit>(hora|minuto|min|segundo|se[cg])(?<plural>s)?|h)\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\,\d*)?)\s*{TimeUnitRegex}";
      public static readonly string DateTimePeriodNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?)\s*{TimeUnitRegex}";
      public const string PeriodTimeOfDayWithDateRegex = @"\b((e|[àa]|em|na|no|ao|pel[ao]|de)\s+)?(?<timeOfDay>manh[ãa]|madrugada|(passado\s+(o\s+)?)?meio\s+dia|tarde|noite)\b";
      public static readonly string RelativeTimeUnitRegex = $@"({PastRegex}|{FutureRegex})\s+{UnitRegex}|{UnitRegex}\s+({PastRegex}|{FutureRegex})";
      public const string SuffixAndRegex = @"(?<suffix>\s*(e)\s+(?<suffix_num>meia|(um\s+)?quarto))";
      public static readonly string FollowedUnit = $@"^\s*{UnitRegex}";
      public const string LessThanRegex = @"^[.]";
      public const string MoreThanRegex = @"^[.]";
      public static readonly string DurationNumberCombinedWithUnit = $@"\b(?<num>\d+(\,\d*)?){UnitRegex}";
      public static readonly string AnUnitRegex = $@"\b(um(a)?)\s+{UnitRegex}";
      public const string DuringRegex = @"^[.]";
      public const string AllRegex = @"\b(?<all>tod[oa]?\s+(o|a)\s+(?<unit>ano|m[êe]s|semana|dia))\b";
      public const string HalfRegex = @"\b(?<half>mei[oa]\s+(?<unit>ano|m[êe]s|semana|dia|hora))\b";
      public const string ConjunctionRegex = @"^[.]";
      public const string InexactNumberRegex = @"\b(poucos|pouco|algum|alguns|v[áa]rios)\b";
      public static readonly string InexactNumberUnitRegex = $@"\b(poucos|pouco|algum|alguns|v[áa]rios)\s+{UnitRegex}";
      public static readonly string HolidayRegex1 = $@"\b(?<holiday>sexta-feira santa|sexta-feira da paix[ãa]o|quarta-feira de cinzas|carnaval|dia dos? presidentes?|ano novo chin[eê]s|ano novo|v[ée]spera de ano novo|natal|v[ée]spera de natal|dia de a[cç][ãa]o de gra[çc]as|a[cç][ãa]o de gra[çc]as|yuandan|halloween|dia das bruxas|p[áa]scoa)(\s+(d[eo]?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\s+ano))?\b";
      public static readonly string HolidayRegex2 = $@"\b(?<holiday>(dia\s+(d[eoa]s?\s+)?)?(martin luther king|todos os santos|s[ãa]o (patr[íi]cio|francisco|jorge|jo[ãa]o)|independ[êe]ncia))(\s+(d[eo]?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\s+ano))?\b";
      public static readonly string HolidayRegex3 = $@"\b(?<holiday>(dia\s+d[eoa]s?\s+)(trabalh(o|ador(es)?)|m[ãa]es?|pais?|mulher(es)?|crian[çc]as?|marmota|professor(es)?))(\s+(d[eo]?\s+)?({YearRegex}|(?<order>(pr[oó]xim[oa]?|[nd]?es[st][ea]|[uú]ltim[oa]?|em))\s+ano))?\b";
      public const string BeforeRegex = @"(antes(\s+(d(e\s+)?[aeo]s?)?)?|at[ée]h?(\s+[oàa]s?\b)?)";
      public const string AfterRegex = @"((depois|ap[óo]s|a\s+partir)(\s*(de|d?[oa]s?)?)?)";
      public const string SinceRegex = @"(desde(\s+(as?|o))?)";
      public const string AroundRegex = @"(?:\b(?:cerca|perto|ao\s+redor|por\s+volta)\s*?\b)(\s+(de|das))?";
      public const string PeriodicRegex = @"\b(?<periodic>di[áa]ri[ao]|(diaria|mensal|semanal|quinzenal|(bi|tri|se)mestral|anual)(mente)?)\b";
      public const string EachExpression = @"cada|tod[oa]s?\s*([oa]s)?";
      public static readonly string EachUnitRegex = $@"(?<each>({EachExpression})\s*{UnitRegex})";
      public static readonly string EachPrefixRegex = $@"(?<each>({EachExpression})\s*$)";
      public static readonly string EachDayRegex = $@"\s*({EachExpression})\s*dias\s*\b";
      public static readonly string BeforeEachDayRegex = $@"({EachExpression})\s*dias(\s+a[so])?\s*\b";
      public static readonly string SetEachRegex = $@"(?<each>({EachExpression})\s*)";
      public const string LaterEarlyPeriodRegex = @"^[.]";
      public const string WeekWithWeekDayRangeRegex = @"^[.]";
      public const string GeneralEndingRegex = @"^[.]";
      public const string MiddlePauseRegex = @"^[.]";
      public const string PrefixArticleRegex = @"^[\.]";
      public const string OrRegex = @"^[.]";
      public static readonly string SpecialYearTermsRegex = $@"\b(({SpecialYearPrefixes}\s+anos?\s+|anos?\s+({SpecialYearPrefixes}\s+)?)(d[oe]\s+)?)";
      public static readonly string YearPlusNumberRegex = $@"\b({SpecialYearTermsRegex}((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|({TimeHourNumRegex}|{BaseDateTime.HourRegex})(?<desc>\s*horas)?)\b";
      public const string TimeBeforeAfterRegex = @"^[.]";
      public const string DateNumberConnectorRegex = @"^[.]";
      public const string ComplexDatePeriodRegex = @"^[.]";
      public const string AgoRegex = @"\b(antes(\s+d[eoa]s?\s+(?<day>hoje|ontem|manhã))?|atr[áa]s|no passado)\b";
      public const string LaterRegex = @"\b(depois(\s+d[eoa]s?\s+(agora|(?<day>hoje|ontem|manhã)))?|ap[óo]s (as)?|desde( (as|o))?|no futuro|mais tarde)\b";
      public const string Tomorrow = @"amanh[ãa]";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"anos", @"Y" },
            { @"ano", @"Y" },
            { @"meses", @"MON" },
            { @"mes", @"MON" },
            { @"mês", @"MON" },
            { @"semanas", @"W" },
            { @"semana", @"W" },
            { @"dias", @"D" },
            { @"dia", @"D" },
            { @"horas", @"H" },
            { @"hora", @"H" },
            { @"hrs", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minutos", @"M" },
            { @"minuto", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"segundos", @"S" },
            { @"segundo", @"S" },
            { @"segs", @"S" },
            { @"seg", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"anos", 31536000 },
            { @"ano", 31536000 },
            { @"meses", 2592000 },
            { @"mes", 2592000 },
            { @"mês", 2592000 },
            { @"semanas", 604800 },
            { @"semana", 604800 },
            { @"dias", 86400 },
            { @"dia", 86400 },
            { @"horas", 3600 },
            { @"hora", 3600 },
            { @"hrs", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minutos", 60 },
            { @"minuto", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"segundos", 1 },
            { @"segundo", 1 },
            { @"segs", 1 },
            { @"seg", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscal", @"FY" },
            { @"escolar", @"SY" },
            { @"letivo", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"primavera", @"SP" },
            { @"verao", @"SU" },
            { @"verão", @"SU" },
            { @"outono", @"FA" },
            { @"inverno", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"primeiro", 1 },
            { @"primeira", 1 },
            { @"1o", 1 },
            { @"1a", 1 },
            { @"segundo", 2 },
            { @"segunda", 2 },
            { @"2o", 2 },
            { @"2a", 2 },
            { @"terceiro", 3 },
            { @"terceira", 3 },
            { @"3o", 3 },
            { @"3a", 3 },
            { @"cuarto", 4 },
            { @"quarto", 4 },
            { @"cuarta", 4 },
            { @"quarta", 4 },
            { @"4o", 4 },
            { @"4a", 4 },
            { @"quinto", 5 },
            { @"quinta", 5 },
            { @"5o", 5 },
            { @"5a", 5 },
            { @"sexto", 6 },
            { @"sexta", 6 },
            { @"6o", 6 },
            { @"6a", 6 },
            { @"setimo", 7 },
            { @"sétimo", 7 },
            { @"setima", 7 },
            { @"sétima", 7 },
            { @"7o", 7 },
            { @"7a", 7 },
            { @"oitavo", 8 },
            { @"oitava", 8 },
            { @"8o", 8 },
            { @"8a", 8 },
            { @"nono", 9 },
            { @"nona", 9 },
            { @"9o", 9 },
            { @"9a", 9 },
            { @"decimo", 10 },
            { @"décimo", 10 },
            { @"decima", 10 },
            { @"décima", 10 },
            { @"10o", 10 },
            { @"10a", 10 },
            { @"decimo primeiro", 11 },
            { @"décimo primeiro", 11 },
            { @"decima primeira", 11 },
            { @"décima primeira", 11 },
            { @"11o", 11 },
            { @"11a", 11 },
            { @"decimo segundo", 12 },
            { @"décimo segundo", 12 },
            { @"decima segunda", 12 },
            { @"décima segunda", 12 },
            { @"12o", 12 },
            { @"12a", 12 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"segunda-feira", 1 },
            { @"segundas-feiras", 1 },
            { @"segunda feira", 1 },
            { @"segundas feiras", 1 },
            { @"segunda", 1 },
            { @"segundas", 1 },
            { @"terça-feira", 2 },
            { @"terças-feiras", 2 },
            { @"terça feira", 2 },
            { @"terças feiras", 2 },
            { @"terça", 2 },
            { @"terças", 2 },
            { @"terca-feira", 2 },
            { @"tercas-feiras", 2 },
            { @"terca feira", 2 },
            { @"tercas feiras", 2 },
            { @"terca", 2 },
            { @"tercas", 2 },
            { @"quarta-feira", 3 },
            { @"quartas-feiras", 3 },
            { @"quarta feira", 3 },
            { @"quartas feiras", 3 },
            { @"quarta", 3 },
            { @"quartas", 3 },
            { @"quinta-feira", 4 },
            { @"quintas-feiras", 4 },
            { @"quinta feira", 4 },
            { @"quintas feiras", 4 },
            { @"quinta", 4 },
            { @"quintas", 4 },
            { @"sexta-feira", 5 },
            { @"sextas-feiras", 5 },
            { @"sexta feira", 5 },
            { @"sextas feiras", 5 },
            { @"sexta", 5 },
            { @"sextas", 5 },
            { @"sabado", 6 },
            { @"sabados", 6 },
            { @"sábado", 6 },
            { @"sábados", 6 },
            { @"domingo", 0 },
            { @"domingos", 0 },
            { @"seg", 1 },
            { @"seg.", 1 },
            { @"2a", 1 },
            { @"ter", 2 },
            { @"ter.", 2 },
            { @"3a", 2 },
            { @"qua", 3 },
            { @"qua.", 3 },
            { @"4a", 3 },
            { @"qui", 4 },
            { @"qui.", 4 },
            { @"5a", 4 },
            { @"sex", 5 },
            { @"sex.", 5 },
            { @"6a", 5 },
            { @"sab", 6 },
            { @"sab.", 6 },
            { @"dom", 0 },
            { @"dom.", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"janeiro", 1 },
            { @"fevereiro", 2 },
            { @"março", 3 },
            { @"marco", 3 },
            { @"abril", 4 },
            { @"maio", 5 },
            { @"junho", 6 },
            { @"julho", 7 },
            { @"agosto", 8 },
            { @"septembro", 9 },
            { @"setembro", 9 },
            { @"outubro", 10 },
            { @"novembro", 11 },
            { @"dezembro", 12 },
            { @"jan", 1 },
            { @"fev", 2 },
            { @"mar", 3 },
            { @"abr", 4 },
            { @"mai", 5 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"ago", 8 },
            { @"sept", 9 },
            { @"set", 9 },
            { @"out", 10 },
            { @"nov", 11 },
            { @"dez", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"zero", 0 },
            { @"um", 1 },
            { @"uma", 1 },
            { @"dois", 2 },
            { @"tres", 3 },
            { @"três", 3 },
            { @"quatro", 4 },
            { @"cinco", 5 },
            { @"seis", 6 },
            { @"sete", 7 },
            { @"oito", 8 },
            { @"nove", 9 },
            { @"dez", 10 },
            { @"onze", 11 },
            { @"doze", 12 },
            { @"dezena", 12 },
            { @"dezenas", 12 },
            { @"treze", 13 },
            { @"catorze", 14 },
            { @"quatorze", 14 },
            { @"quinze", 15 },
            { @"dezesseis", 16 },
            { @"dezasseis", 16 },
            { @"dezessete", 17 },
            { @"dezassete", 17 },
            { @"dezoito", 18 },
            { @"dezenove", 19 },
            { @"dezanove", 19 },
            { @"vinte", 20 },
            { @"vinte e um", 21 },
            { @"vinte e uma", 21 },
            { @"vinte e dois", 22 },
            { @"vinte e duas", 22 },
            { @"vinte e tres", 23 },
            { @"vinte e três", 23 },
            { @"vinte e quatro", 24 },
            { @"vinte e cinco", 25 },
            { @"vinte e seis", 26 },
            { @"vinte e sete", 27 },
            { @"vinte e oito", 28 },
            { @"vinte e nove", 29 },
            { @"trinta", 30 },
            { @"trinta e um", 31 },
            { @"quarenta", 40 },
            { @"cinquenta", 50 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"pai", new string[] { @"diadopai", @"diadospais" } },
            { @"mae", new string[] { @"diadamae", @"diadasmaes" } },
            { @"acaodegracas", new string[] { @"diadegracas", @"diadeacaodegracas", @"acaodegracas" } },
            { @"trabalho", new string[] { @"diadotrabalho", @"diadotrabalhador", @"diadostrabalhadores" } },
            { @"pascoa", new string[] { @"diadepascoa", @"pascoa" } },
            { @"natal", new string[] { @"natal", @"diadenatal" } },
            { @"vesperadenatal", new string[] { @"vesperadenatal" } },
            { @"anonovo", new string[] { @"anonovo", @"diadeanonovo", @"diadoanonovo" } },
            { @"vesperadeanonovo", new string[] { @"vesperadeanonovo", @"vesperadoanonovo" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"todosossantos", new string[] { @"todosossantos" } },
            { @"professor", new string[] { @"diadoprofessor", @"diadosprofessores" } },
            { @"crianca", new string[] { @"diadacrianca", @"diadascriancas" } },
            { @"mulher", new string[] { @"diadamulher" } }
        };
      public static readonly Dictionary<string, string> VariableHolidaysTimexDictionary = new Dictionary<string, string>
        {
            { @"pai", @"-06-WXX-7-3" },
            { @"mae", @"-05-WXX-7-2" },
            { @"acaodegracas", @"-11-WXX-4-4" },
            { @"memoria", @"-03-WXX-2-4" }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"metade", 0.5 },
            { @"quarto", 0.25 }
        };
      public const string DateTokenPrefix = @"em ";
      public const string TimeTokenPrefix = @"as ";
      public const string TokenBeforeDate = @"o ";
      public const string TokenBeforeTime = @"as ";
      public const string PastPrefixRegex = @".^";
      public static readonly string PreviousPrefixRegex = $@"([uú]ltim[oa]s?|passad[oa]s?|{PastPrefixRegex})\b";
      public const string ThisPrefixRegex = @"([nd]?es[st][ea])\b";
      public const string RelativeDayRegex = @"^[\.]";
      public const string RestOfDateRegex = @"^[\.]";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|{TimeUnitRegex}|noites?)\b";
      public static readonly string RelativeDurationUnitRegex = $@"(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))";
      public const string ReferenceDatePeriodRegex = @"^[.]";
      public const string FromToRegex = @"\b(from).+(to)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(the\s+)?(may|march)$";
      public const string UnspecificDatePeriodRegex = @"^[.]";
      public const string PrepositionSuffixRegex = @"\b(on|in|at|around|from|to)$";
      public const string RestOfDateTimeRegex = @"^[\.]";
      public const string SetWeekDayRegex = @"^[\.]";
      public const string NightRegex = @"\b(meia noite|noite|de noite)\b";
      public const string CommonDatePrefixRegex = @"\b(dia)\s+$";
      public const string DurationConnectorRegex = @"^[.]";
      public const string CenturyRegex = @"^[.]";
      public const string DecadeRegex = @"^[.]";
      public const string DecadeWithCenturyRegex = @"^[.]";
      public static readonly string RelativeDecadeRegex = $@"\b((n?as?\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?(d[eé]cada)s?)\b";
      public static readonly string YearSuffix = $@"((,|\sde)?\s*({YearRegex}|{FullTextYearRegex}))";
      public const string SuffixAfterRegex = @"^\b$";
      public static readonly string YearPeriodRegex = $@"((((de(sde)?(\s*a(s)?)?)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((entre\s*([oa](s)?)?)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public const string FutureSuffixRegex = @"\b(seguinte(s)?|pr[oó]xim[oa](s)?|no\s+futuro)\b";
      public const string PastSuffixRegex = @"^\b$";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"", 0 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"", 0 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly string[] DurationDateRestrictions = {  };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"^(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)$", @"([$%£&!?@#])(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)|(abr|ago|dez|fev|jan|ju[ln]|mar|maio?|nov|out|sep?t)([$%£&@#])" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly Dictionary<string, string> AmbiguityTimeFiltersDict = new Dictionary<string, string>
        {
            { @"horas?$", @"\b((por|duração\s+de|durante)\s+(\S+\s+){1,2}horas?|horas?\s+(\S+\s+){0,2}dur(ação|ou|a(rá|va)?))\b" }
        };
      public static readonly IList<string> EarlyMorningTermList = new List<string>
        {
            @"madrugada"
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"manha",
            @"manhã"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"passado o meio dia",
            @"depois do meio dia"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"tarde"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"noite"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"hoje",
            @"este dia",
            @"esse dia",
            @"o dia"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"amanha",
            @"de amanha",
            @"dia seguinte",
            @"o dia de amanha",
            @"proximo dia"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"ontem",
            @"ultimo dia"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"depois de amanha",
            @"dia depois de amanha"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"anteontem",
            @"dia antes de ontem"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"mes",
            @"meses"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"mes ate agora",
            @"mes ate hoje",
            @"mes ate a data"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"fim de semana"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"semana"
        };
      public static readonly IList<string> FortnightTerms = new List<string>
        {
            @"quinzena"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"ano",
            @"anos"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"ano ate agora",
            @"ano ate hoje",
            @"ano ate a data",
            @"anos ate agora",
            @"anos ate hoje",
            @"anos ate a data"
        };
      public static readonly Dictionary<char, char> SpecialCharactersEquivalent = new Dictionary<char, char>
        {
            { 'á', 'a' },
            { 'é', 'e' },
            { 'í', 'i' },
            { 'ó', 'o' },
            { 'ú', 'u' },
            { 'ê', 'e' },
            { 'ô', 'o' },
            { 'ü', 'u' },
            { 'ã', 'a' },
            { 'õ', 'o' },
            { 'ç', 'c' }
        };
      public const string DayTypeRegex = @"(diari([ao]|amente))$";
      public const string WeekTypeRegex = @"(semanal(mente)?)$";
      public const string BiWeekTypeRegex = @"(quinzenal(mente)?)$";
      public const string MonthTypeRegex = @"(mensal(mente)?)$";
      public const string BiMonthTypeRegex = @"(bimestral(mente)?)$";
      public const string QuarterTypeRegex = @"(trimestral(mente)?)$";
      public const string SemiAnnualTypeRegex = @"(semestral(mente)?)$";
      public const string YearTypeRegex = @"(anual(mente)?)$";
      public static readonly IList<string> ThisTerms = new List<string>
        {
            @"esse",
            @"essa",
            @"este",
            @"esta"
        };
    }
}