﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Italian\Italian-DateTime.yaml
//     - Language: Italian
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Italian
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Ita";
      public const bool CheckBothBeforeAfter = false;
      public const string TillRegex = @"(?<till>\b(fino\s+a(l(l[aoe'])?|gli|i|d)?|a(l(l[aoe'])?|gli|i|d)?|e\s+(il?|l[aoe']|gli))\b|--|-|—|——|~)";
      public const string RestrictedTillRegex = @"(?<till>\b(fino\s+a(l(l[aoe'])?|gli|i|d)?)\b|--|-|—|——|~)";
      public static readonly string RangeConnectorRegex = $@"(?<and>\b(e(\s+l[aoe']|gli|i|d)?|a(l(l[aoe'])?|gli|i|d)?)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string RelativeRegex = @"\b(?<order>((il?|l[ae])\s+)?prossim['oaie]|((il?|l[ae])\s+)?seguent[ei]|((il?|l[ae])\s+)?successiv[oaei]|in\s+arrivo|quest['oaie]|(l'|gli\s+|le\s+)?ultim['oaie]|((il?|l[ae])\s+)?passat[oaie]|((il?|l[ae])\s+)?precedent[ei]|((lo|l[ae]|gli)\s+)?scors[oaie]|((il?|l[ae])\s+)?corrent[ei]|quest['oaei]|il?|l[oae']|gli)";
      public const string StrictRelativeRegex = @"(?<order>prossim['oaie]|seguent[ei]|successiv[oaei]|in\s+arrivo|quest['oaie]|ultim['oaie]|passat[oaie]|precedent[ei]|scors[oaie]|corrent[ei]|quest['oaei])";
      public const string NextSuffixRegex = @"(?<order>prossim[oaei]|seguent[ei]|successiv[oaei]|imminent[ei]|in\s+arrivo)\b";
      public const string PastSuffixRegex = @"(?<order>precedent[ei]|scors[oaei]|passat[oaei]|ultim['oaie])\b";
      public const string ThisPrefixRegex = @"(quest['oa]|corrente)";
      public const string UpcomingPrefixRegex = @"((quest[aoei]\s+)?(stess[oaei]|imminent[ei])|in\s+arrivo)";
      public static readonly string NextPrefixRegex = $@"\b(((il?|l[ae])\s+)?successiv[oaei]|((il?|l[ae])\s+)?seguent[ei]|((il?|l[ae])\s+)?prossim[oaei]|{UpcomingPrefixRegex})\b";
      public const string AfterNextSuffixRegex = @"\b(dopo\s+(il|la)\s+prossim[oa])\b";
      public const string PastPrefixRegex = @"\b(((lo|l[ae]|gli)\s+)?scors[oaei])\b";
      public static readonly string PreviousPrefixRegex = $@"\b(((il?|l[ae])\s+)?passat[oaei]|((il?|l[ae])\s+)?precedent[ei]|(l'|gli\s+|le\s+)?ultim[oaei]|{PastPrefixRegex})\b";
      public const string RangePrefixRegex = @"\b(da(l(l[oae'])?|i|gli)?|tra|fra|entro)(\s+(il|l[aeo']|gli|i))?\b";
      public const string WrittenOneToNineRegex = @"(uno|due|tre|quattro|cinque|sei|sette|otto|nove)";
      public const string WrittenElevenToNineteenRegex = @"(undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove)";
      public const string WrittenTensRegex = @"(dieci|venti?|trenta?|quaranta?|cinquanta?|sessanta?|settanta?|o?ttanta?|novanta?)";
      public static readonly string WrittenNumRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|({WrittenTensRegex}{WrittenOneToNineRegex}?))";
      public const string FirstDayRegex = @"(primo(?=\s+(aprile|apr|agosto|ago|dicembre|dic|febbraio|feb|gennaio|gen|luglio|lug|giugno|giu|marzo|mar|maggio|mag|novembre|nov|ottobre|ott|settembre|set|sett)\b))";
      public static readonly string WrittenDayRegex = $@"(?<day>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|ventuno|ventidue|ventitre|ventiquattro|venticinque|ventisei|ventisette|ventotto|ventinove|trenta|trentuno|{FirstDayRegex})";
      public const string DayRegex = @"\b((il|l')\s*)?(?<!\d)(?<day>01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(?!°)(?=\b|t)";
      public const string MonthNumRegex = @"(?<month>01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)\b";
      public const string WeekDayRegex = @"\b(?<weekday>domenica|lunedì|martedì|mercoledì|giovedì|venerdì|sabato|lun|mar|mer|gio|ven|sab|dom)\b";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>((di|del|dell[o'])\s+)?(({ThisPrefixRegex}\s+mese)|(mese\s+({PastSuffixRegex}|{NextSuffixRegex}))|(({PastSuffixRegex}|{NextSuffixRegex})\s+mese)))\b";
      public const string MonthRegex = @"(?<month>apr(ile)?|ago(sto)?|dic(embre)?|feb(braio)?|gen(naio)?|lug(lio)?|giu(gno)?|mar(zo)?|mag(gio)?|nov(embre)?|ott(obre)?|set(tembre|t)?)\b";
      public static readonly string EngMonthRegex = $@"(((il\s+)?mese di\s+)?{MonthRegex})";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>(in\s+|nel(l['o])?\s*|di\s+|del(l['o])?\s*|a([ld]|ll['o])?\s*|(il|l[o'])\s*)?({RelativeMonthRegex}|{EngMonthRegex}))";
      public const string SpecialDescRegex = @"((?<ipm>)p\b)";
      public static readonly string AmDescRegex = $@"({BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"({BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"({BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(?<desc>in punto|{AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})";
      public const string WrittenCenturyCardinalYearRegex = @"(cento|duecento|trecento|quattrocento|cinquecento|seicento|settecento|ottocento|novecento)";
      public const string WrittenCenturyOrdinalYearRegex = @"(ventunesimo|ventiduesimo|primo|secondo|terzo|quarto|quinto|sesto|settimo|ottavo|nono|decimo|undicesimo|ventesimo|tredicesimo|quattordicesimo|quindicesimo|sedicesimo|diciassettesimo|diciottesimo|diciannovesimo|ventesimo)(\s+secolo)?";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?<century>(mille|duemila)({WrittenCenturyCardinalYearRegex})?|{WrittenCenturyCardinalYearRegex})";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex})\b";
      public const string DecadeRegex = @"(?<decade>dieci|venti|trenta|quaranta|cinquanta|sessanta|settanta|o?ttanta|novanta|due mila)";
      public static readonly string DecadeWithCenturyRegex = $@"\b((gli\s+)?anni\s+)(((?<century>\d|1\d|2\d)?(')?(?<decade>\d0)(')?)|(({CenturyRegex})?{DecadeRegex})|{WrittenCenturyFullYearRegex}({DecadeRegex})?)\b";
      public static readonly string RelativeDecadeRegex = $@"\b((((il?|l'|gli)\s*)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?decennio?)|(((il?|l'|gli)\s*)?((?<number>[\w,]+)\s+)?decennio?\s+{RelativeRegex}))\b";
      public static readonly string LastTwoYearNumRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}({WrittenOneToNineRegex})?)";
      public static readonly string FullTextYearRegex = $@"\b((?<firsttwoyearnum>{WrittenCenturyFullYearRegex})(?<lasttwoyearnum>{LastTwoYearNumRegex})?)\b";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})";
      public static readonly string YearSuffix = $@"(,?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string DateUnitRegex = @"\b(?<unit>decennio|mese|settimana|(ann|giorn)(o|(?<plural>i))|(?<plural>decenni|mesi|settimane))\b";
      public static readonly string SimpleCasesRegex = $@"\b((dal?|[tf]ra)\s+)?({DayRegex})(\s+{MonthSuffixRegex})?\s*{TillRegex}\s*({DayRegex}\s+{MonthSuffixRegex}|{MonthSuffixRegex}\s+{DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b((dal?|[tf]ra)\s+)?{MonthSuffixRegex}\s+((dal?|[tf]ra)\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+([tf]ra\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string BetweenRegex = $@"\b([tf]ra\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public const string YearWordRegex = @"\b(?<year>l'anno)\b";
      public static readonly string MonthWithYear = $@"\b({MonthRegex}(\.)?(\s*)[/\\\-\.,]?(((\s+del)?\s+{YearRegex}|{TwoDigitYearRegex})|((\s+(del|di|il))?\s+(?<order>prossim['o]|passato|quest['o])\s*anno)|((\s+(del)?l')anno\s+(?<order>prossimo|passato))))";
      public const string SpecialYearPrefixes = @"(?<special>fiscale|scolastico)";
      public static readonly string OneWordPeriodRegex = $@"\b((((il|l[o'])\s*)?((mese di\s+)|({RelativeRegex}\s*))?{MonthRegex}(\s+{RelativeRegex})?)|dall'inizio\s+del(l')\s*(mese|anno)|({RelativeRegex}\s*)?(mi[ao]\s+)?(weekend|finesettimana|settimana|mese|anno)(\s+{RelativeRegex})?(?!((\s+di|del)?\s+\d+))(\s+{AfterNextSuffixRegex})?)\b";
      public static readonly string MonthNumWithYear = $@"({YearRegex}[/\-\.]{MonthNumRegex})|({MonthNumRegex}[/\-]{YearRegex})";
      public static readonly string WeekOfMonthRegex = $@"\b(?<wom>(l[a']\s*)?(?<cardinal>prima|seconda|terza|quarta|quinta|ultima)\s+settimana\s+{MonthSuffixRegex}(\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s+year)?)\b";
      public static readonly string WeekOfYearRegex = $@"\b(?<woy>(l[a']\s*)?(?<cardinal>prima|seconda|terza|quarta|quinta|ultima)\s+settimana(\s+(di|del(l[o'])?))?\s*({YearRegex}|({RelativeRegex}\s*anno)|(anno\s+(({NextSuffixRegex})|({PastSuffixRegex})))))";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+([\.,]\d*)?)\s*{DateUnitRegex}";
      public static readonly string QuarterRegex = $@"\b((il|l')\s*)?(?<cardinal>primo|secondo|terzo|quarto|ultimo)\s+trimestre((\s+(di|del(l[o'])?)|\s*,\s*)?\s*({YearRegex}|({RelativeRegex}\s*anno)|(anno\s+(({NextSuffixRegex})|({PastSuffixRegex})))))?";
      public static readonly string QuarterRegexYearFront = $@"({YearRegex}|l'anno\s+({PastSuffixRegex}|{NextSuffixRegex})|{RelativeRegex}\s+anno)\s+((per\s+)?il\s+)?(?<cardinal>primo|secondo|terzo|quarto)\s+trimestre";
      public static readonly string AllHalfYearRegex = $@"((la\s+)?((prima|seconda)\s+metà)(\s+(di|del(l[o'])?)|\s*,\s*)\s*({RelativeRegex}?\s*anno)|(il\s+)?((primo|secondo)\s+semestre)((\s+(di|del(l[o'])?)|\s*,\s*)\s*({RelativeRegex}?\s*anno))?)";
      public const string EarlyPrefixRegex = @"\b(?<EarlyPrefix>prima|a\s+partire\s+da(l(l[aoe'])?)?|inizio(\s+(di|del(l[ao'])?))?)\b";
      public const string MidPrefixRegex = @"\b(?<MidPrefix>metà(\s+(di|del(l[ao'])?))?)\b";
      public const string LaterPrefixRegex = @"\b(?<LatePrefix>fine(\s+(di|del(l[ao'])?))?|(?<RelLate>più\s+tardi(\s+(in|a))?))\b";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public const string PrefixDayRegex = @"\b(((inizio|metà|fine)((\s+(della\s+)?giornata)|(\s+del\s+giorno)))|((prima|(più\s+tardi))\s+quel\s+giorno))$";
      public const string CenturySuffixRegex = @"(^secolo)\b";
      public static readonly string SeasonRegex = $@"\b(l[a']|{PrefixPeriodRegex}\s*)?(((<seas>primavera|estate|autunno|inverno)\s*({NextSuffixRegex}|{PastSuffixRegex}))|(?<season>({RelativeRegex}\s*)?(?<seas>primavera|estate|autunno|inverno)((\s+(di|del(l[o'])?)|\s*,\s*)?\s*({YearRegex}|{RelativeRegex}\s*anno))?))\b";
      public const string WhichWeekRegex = @"\b(settimana)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b";
      public const string WeekOfRegex = @"(la\s+)?(settimana)(\s*)(d[i']|del(l[aeo'])?|degli)";
      public const string MonthOfRegex = @"(il\s+)?(mese)(\s*)(d[i']|del(l[aeo'])?|degli)";
      public static readonly string OnRegex = $@"(?<=\b(il|l')\s*)({DayRegex})\b";
      public const string RelaxedOnRegex = @"(?<=\b(il|l'|del(l')?|di|al(l')?|a)\s*)((?<day>10|11|12|13|14|15|16|17|18|19|1°?|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9))(?!°)\b";
      public const string PrefixWeekDayRegex = @"(\s*((,?\s*(di|il))|[,-—–]))";
      public static readonly string ThisRegex = $@"\b(quest[oa](\s+settimana{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}((\s+di)?\s+questa\s+settimana))\b";
      public static readonly string LastDateRegex = $@"\b({WeekDayRegex}\s+(del)?la\s+(settimana\s+{PastSuffixRegex}|{PastSuffixRegex}\s+settimana))|(({PastSuffixRegex}\s+settimana|settimana\s+{PastSuffixRegex})(\s*{PrefixWeekDayRegex}?\s*{WeekDayRegex}))|({WeekDayRegex}(\s+(mattina|pomeriggio|sera|notte))?\s+{PastSuffixRegex})|({PastSuffixRegex}\s+{WeekDayRegex})\b";
      public static readonly string NextDateRegex = $@"\b({WeekDayRegex}\s+(del)?la\s+(settimana\s+{NextSuffixRegex}|{NextSuffixRegex}\s+settimana))|(({NextSuffixRegex}\s+settimana|settimana\s+{NextSuffixRegex})({PrefixWeekDayRegex}?\s*{WeekDayRegex})?)|({WeekDayRegex}(\s+(mattina|pomeriggio|sera|notte))?\s+{NextSuffixRegex})|({NextSuffixRegex}\s+{WeekDayRegex})\b";
      public static readonly string SpecialDayRegex = $@"\b((avant'?ieri)|(l'altro\s*ieri)|(ieri\s+l'altro)|(dopo\s*domani)|(il\s+giorno\s+(dopo|seguente|passato|precedente|prima))|ieri|((l')?in)?domani|(quest')?oggi|in\s+giornata|((il|la|l')\s*)?({RelativeRegex}|mi[oa])\s*(giorno|giornata))\b";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<number>{WrittenNumRegex})\s+giorni\s+da\s+(?<day>ieri|domani|oggi))\b";
      public const string StrictWeekDay = @"\b(?<weekday>domenica|lunedì|martedì|mercoledì|giovedì|venerdì|sabato|lun|mar|mer|gio|ven|sab|dom)\b";
      public static readonly string RelativeDayRegex = $@"\b(((il|l')\s*)?{RelativeRegex}\s+giorno)\b";
      public const string SetWeekDayRegex = @"\b(?<prefix>(tutt[ei]\s+)?(le|i)\s+)(?<weekday>(?<g0>mattin|ser)|(?<g1>pomerigg)|(?<g2>nott)|(?<g3>luned|marted|mercoled|gioved|venerd)|(?<g4>domenic)|(?<g5>sabat))(e|i|ì|he)\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>((la|il)\s+)?(?<cardinal>prim[ao]|second[ao]|terz[ao]|quart[ao]|quint[ao]|ultim[ao])\s+{WeekDayRegex}\s+{MonthSuffixRegex})";
      public static readonly string RelativeWeekDayRegex = $@"\b({WrittenNumRegex}\s+{WeekDayRegex}\s+(da\s+ora|dopo))\b";
      public static readonly string SpecialDate = $@"(?<=\b(il|l'|al(l')?)\s*){DayRegex}\b";
      public static readonly string DateExtractor1 = $@"\b((quest[oa]\s+)?{WeekDayRegex}\s*[,-]?\s*)?(({MonthRegex}(\.)?\s*[/\\.,-]?\s*{DayRegex}(?!\s*\-\s*\d{{2}}\b))|(\({MonthRegex}\s*[-.]\s*{DayRegex}\))|({DayRegex}\s*[/\\.,-]?\s*{MonthRegex}(\.)?))(\s*\(\s*{WeekDayRegex}\s*\))?";
      public static readonly string DateExtractor2 = $@"({DateExtractor1}(\s+|\s*[\-/,.]\s*|\s+del\s+)({DateYearRegex}))\b";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?({DayRegex}(\.)?(\s*[/,.\- ]\s*|\s+di\s+){MonthRegex}(\.)?(\s*[/,.\- ]\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[/,.\- ]\s*{DayRegex}\s*[/,.\- ]\s*{MonthRegex})\b";
      public static readonly string DateExtractor4 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?((il|l')\s*)?{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}(\.)?\s*[/\\\-]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor5 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex}(\.)?)\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<!([\-\.\/]|all[e']\s*|l[e']\s*))\b{MonthNumRegex}[\-\.\/]{DayRegex}{BaseDateTime.CheckDecimalRegex}(?!(%|\s*{{DescRegex}}))\b";
      public static readonly string DateExtractor7 = $@"(?<!\b{DateYearRegex}\s*[/\\\-]\s*)\b{DayRegex}\s*[\/\\-]s*{MonthNumRegex}((\s+|\s*[\/\-\\,]\s*){DateYearRegex})?\b{BaseDateTime.CheckDecimalRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor8 = $@"(?<!([\-\.\/]|all[e']\s*|l[e']\s*))\b{DayRegex}[\/\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!(%|\s*{DescRegex}))\b";
      public static readonly string DateExtractor9 = $@"(?<!\b{DateYearRegex}\s*[/\\\-]\s*)\b{DayRegex}\s*/\s*{MonthNumRegex}((\s+|\s*,\s*|\s+del\s+){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractorA = $@"\b({DateYearRegex}\s*[/\\\-]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-]\s*{DayRegex}|{MonthRegex}\s*[/.\-]\s*{BaseDateTime.FourDigitYearRegex}\s*[/.\-]\s*{DayRegex}|{DayRegex}\s*[/.\-]\s*{BaseDateTime.FourDigitYearRegex}\s*[/.\-]\s*{MonthRegex})(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string OfMonth = $@"(^\s*(di\s+)?){MonthRegex}";
      public static readonly string MonthEnd = $@"{MonthRegex}\s*,?\s*(il)?\s*$";
      public static readonly string WeekDayEnd = $@"(quest[oa]\s+)?{WeekDayRegex}\s*,?\s*$";
      public const string WeekDayStart = @"^[\.]";
      public const string RangeUnitRegex = @"\b(?<unit>l'anno|ann[oi]?|mes[ei]|settiman[ae])\b";
      public const string HourNumRegex = @"\b(?<hournum>zero|(?<=l')una|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|ventuno|ventidue|ventitre|ventiquattro)\b";
      public const string FivesRegex = @"(?<tens>(quindici|venti(\s*cinque)?|trenta(\s*cinque)?|quaranta(\s*cinque)?|cinquanta(\s*cinque)?|dieci|cinque))\b";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string PeriodHourNumRegex = @"\b(?<hour>ventuno|ventidue|ventitre|ventiquattro|zero|(?<=l')una|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti)\b";
      public const string MinuteNumRegex = @"(?<minnum>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|trenta|quaranta|cinquanta)";
      public const string DeltaMinuteNumRegex = @"\b(?<deltaminnum>uno|due|tre|quattro|cinque|sei|sette|otto|nove|dieci|undici|dodici|tredici|quattordici|quindici|sedici|diciassette|diciotto|diciannove|venti|trenta|quaranta|cinquanta)\b";
      public const string OclockRegex = @"(?<oclock>in punto)";
      public const string OclockPrefix = @"(?<oclock>ore)";
      public const string PmRegex = @"\b(?<pm>(((di|del|a(l(l')?)?|nel|il|per|verso)\s+(il\s+)?)?(pomeriggio|ora di pranzo))|(((di|della|nella|a|alla|verso|la|per|in)\s+)?(la\s+)?(notte|serata|sera|mezzanotte)))\b";
      public const string RangePmRegex = @"\b(?<pm>(((di|del|a(l(l')?)?|nel|il|per|verso)\s+(il\s+)?)?(pomeriggio))|(((di|della|nella|a|alla|verso|la|per|in)\s+)?(la\s+)?(notte|serata|sera)))\b";
      public const string AmRegex = @"\b(?<am>((((la|alla|verso|per|della|di|in)\s+(la\s+)?)?(mattinata|mattina))|(((il|al|verso|per|del|di)\s+(il\s+)?)?(mattino))))\b";
      public const string LunchRegex = @"\b(ora di pranzo)\b";
      public const string NightRegex = @"\b(mezzanotte|notte)\b";
      public static readonly string LessThanOneHour = $@"(?<lth>(un\s+quarto|tre quarti?|mezz[oa]|mezz'ora|{BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex}))";
      public static readonly string EngTimeRegex = $@"(?<engtime>{HourNumRegex}\s+e\s+({MinuteNumRegex}|(?<tens>venti?|trenta?|quaranta?|cinquanta?){MinuteNumRegex}))";
      public static readonly string TimePrefix = $@"(?<prefix>((e|meno)\s+{LessThanOneHour}(\s+(minut[oi]|min))?|{LessThanOneHour}\s+(minut[oi]|min)\s+all[e']))";
      public static readonly string TimeSuffix = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string BasicTime = $@"\b(?<basictime>{EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})";
      public const string MidnightRegex = @"(?<midnight>mezzanotte|mezza notte)";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public const string MorningRegex = @"(?<morning>mattin[oa]|mattinata)";
      public const string AfternoonRegex = @"(?<afternoon>pomeriggio)";
      public static readonly string MidmorningRegex = $@"(?<midmorning>metà\s*{MorningRegex})";
      public const string MiddayRegex = @"(?<midday>metà\s*giornata|(12\s)?mezzogiorno)";
      public static readonly string MidafternoonRegex = $@"(?<midafternoon>metà\s*{AfternoonRegex})";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public const string PrepRegex = @"\b((\.|,)(?!\d+)|!|\?|$|circa|presso|vicino|sopra|sotto|lontano|dentro|fuori|di|del(l['oae])?|dei|degli|a|al(l['oae])?|ai|agli|da|dal(l['oae])?|dai|dagli|in|nel(l['oae])?|nei|negli|su|sul(l['oae])?|sui|sugli)\b";
      public static readonly string AtRegex = $@"\b(((?<=\b(a)\s+){MidTimeRegex}|{MidTimeRegex}\b)|((?<=\ball[e']\s*){EngTimeRegex}\b)|((?<=\b\d+\s+all[e']\s*)({HourNumRegex}|{BaseDateTime.HourRegex})\b(?=\s*(e|{DescRegex}|{PrepRegex})\b))|((?<=([^\d\s]|^)\s*\ball[e']\s*)({HourNumRegex}|{BaseDateTime.HourRegex})\b(?![\.,]\d+)))";
      public static readonly string IshRegex = $@"\b(((poco\s+(prima|dopo)(\s+(di|dell[e']))?)|circa(\s+a(ll['e])?)?|più o meno(\s+a(ll['e])?)?)\s*(({BaseDateTime.HourRegex}|{PeriodHourNumRegex})(?!\s*({DescRegex}|[:\.,/e]\s*\d+))|mezzogiorno)|(({BaseDateTime.HourRegex}|{PeriodHourNumRegex})(?!\s*({DescRegex}|[:\.,/e]\s*\d+))(\s+circa)|mezzogiorno(\s+circa)|verso\s+mezzogiorno))\b";
      public const string TimeUnitRegex = @"(\b\d+([\.,]\d*)?|\b)(?<unit>or(a|(?<plural>e))|(minut|second)(o|(?<plural>i))|h|(hr|min|sec)(?<plural>s)?)\b";
      public const string RestrictedTimeUnitRegex = @"(?<unit>ore|minuti)\b";
      public static readonly string ConnectNumRegex = $@"{BaseDateTime.HourRegex}(?<min>00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59)\s*{DescRegex}";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public static readonly string NumberEndingPattern = $@"^(\s+(?<meeting>riunione|appuntamento|conferenza|chiamata|chiamata skype)\s+all['e]\s*(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\.)?$|(\.,|,|!|\?)))";
      public static readonly string TimeRegex1 = $@"(((((?<=\b(da|al)?(le|l'|ore)\s*)({EngTimeRegex}))|((?<=\b(da|al)?(le|l'|ore)\s*)({HourNumRegex}|{BaseDateTime.HourRegex})(?![\.,]\d+)(?=\s*({PrepRegex}))))|(({TimePrefix}\s+)({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}))|(({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\s+{TimePrefix}))((\s*{DescRegex})|\b))";
      public static readonly string TimeRegex2 = $@"(t)?({BaseDateTime.HourRegex})(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"\b{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})(\s+{TimePrefix})?";
      public static readonly string TimeRegex4 = $@"\b({BasicTime}(\s*{DescRegex})?(\s+{TimePrefix})?(\s*{DescRegex})?\s+{TimeSuffix}|{OclockPrefix}\s+{BasicTime}(\s*{DescRegex})?(\s+{TimePrefix})?(\s*{DescRegex})?)\b";
      public static readonly string TimeRegex5 = $@"\b(({BasicTime}\s*{DescRegex}(\s+{TimePrefix})?)|({BasicTime}(\s+{TimePrefix})((\s*{DescRegex})|\b))|((?<=\b(da|al)?(le|l'|ore)\s*)(\b(?<basictime>{EngTimeRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?)|\b(?<basictime>{HourNumRegex}|{BaseDateTime.HourRegex})(?![\.,]\d+)(?=\s*({PrepRegex})\b))))";
      public static readonly string TimeRegex6 = $@"({BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}|{OclockPrefix}\s+{BasicTime}(\s*{DescRegex})?)\b";
      public static readonly string TimeRegex7 = $@"\b{TimeSuffix}\s+d?all[e']\s*{BasicTime}(\s+{TimePrefix})?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@"\b({TimeSuffix}|{OclockPrefix})\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex9 = $@"\b{PeriodHourNumRegex}(\s+e)\s+{FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string TimeRegexWithDotConnector = $@"({BaseDateTime.HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex})";
      public static readonly string FirstTimeRegexInTimeRange = $@"\b{TimeRegexWithDotConnector}(\s*{DescRegex})?";
      public const string PeriodDescRegex = @"(?<desc>pm|am|p\.m\.|a\.m\.)";
      public const string PeriodPmRegex = @"\b(?<pm>(nel|questo)\s+pomeriggio|(questa|di)\s+sera|(durante\s+la|in)\s+serata|nella\s+notte)\b";
      public const string PeriodAmRegex = @"\b(?<am>al mattino|alla mattina|di mattina|in mattinata)\b";
      public static readonly string PureNumFromTo = $@"(((?<leftDesc>{PmRegex}|{AmRegex})\s*da(ll[e'])?\s*({HourRegex}|{PeriodHourNumRegex})\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex}))|((?<!(dell[e']|dal)\s*)|da(ll[e'])?\s*)(({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?))";
      public static readonly string PureNumBetweenAnd = $@"([tf]ra(\s+l[e'])?\s*)({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?\s*{RangeConnectorRegex}\s*({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex}))?";
      public static readonly string SpecificTimeFromTo = $@"(da(ll[e'])?\s*)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{TillRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"([tf]ra(\s+l[e'])?\s*)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{RangeConnectorRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public const string PrepositionRegex = @"(?<prep>^(,\s*)?(a(l(l['e])?)?|il|la|di|del(l[ae'])?)$)";
      public const string TimeOfDayRegex = @"\b(?<timeOfDay>(((((il|la|in|a(l(la)?)?|nel(la)?|di)\s+)?(((mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<early>\s+presto)|(?<early>prim[ao]\s+)(mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))|((mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<late>\s+(tardi|inoltrat[oa]|fonda))|(?<late>tard[oa]\s+)?(mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)))))|(in\s+giornata|durante\s+il\s+giorno|(durante\s+le|nelle)\s+ore\s+d[i']\s*ufficio)))\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(di\s+)?(({RelativeRegex}\s+{TimeOfDayRegex})|({TimeOfDayRegex}\s*({NextSuffixRegex}|{PastSuffixRegex}))|(stamattina|stasera|stanotte))\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?)\s*{TimeUnitRegex}";
      public const string NowRegex = @"\b(?<now>(proprio\s+)?(adesso|ora(?!\s+(di|del(l[aeo'])?|degli|\d+|x))|in\s+questo\s+momento)|il prima possibile|asap|recentemente|precedentemente)\b";
      public const string SuffixRegex = @"^\s*\b((in|nel(la)?|al(la)?|di)\s+)?(mattin[oa]|mattinata|pomeriggio|sera|serata|notte|nottata)\b";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>mattin[oa]|mattinata|pomeriggio|sera|serata|notte|nottata)\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(di\s+)?(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})|({DateTimeTimeOfDayRegex}\s+({NextSuffixRegex}|{PastSuffixRegex}))|stamattina|stasera|stanotte)\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?(in|nel(la)?|di|del(la)?\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"({DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+((intorno\s+)?(a(ll[e'])?)|verso\s+l[e']))?\s*$)";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"({HourNumRegex}|{HourRegex})\s*(,\s*)?(in|nel(la)?|di|del(la)?\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"({DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(all['e]|verso\s+l['e]))?\s*({HourNumRegex}|{BaseDateTime.HourRegex}))";
      public const string SpecificEndOfRegex = @"(alla\s+)?fine\s+(di|del(l['a])?)\s*$";
      public const string UnspecificEndOfRegex = @"(\b(a|((al)?la)\s+))?((fine\s+(della\s+)?giornata))\b";
      public const string UnspecificEndOfRangeRegex = @"\b(fine\s*(dell')?anno)\b";
      public const string PeriodTimeOfDayRegex = @"\b(((il|la|in|a(l(la)?)?|nel(la)?|di)\s+)?(((?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<early>\s+presto)|(?<early>prim[ao]\s+)(?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))|((?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata)(?<late>\s+(tardi|inoltrat[oa]|fonda))|(?<late>tard[oa]\s+)?(?<timeOfDay>mattin[ao]|mattinata|pomeriggio|sera|serata|notte|nottata))))\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b(di\s+)?(({RelativeRegex}\s+{PeriodTimeOfDayRegex})|sta(mattina|sera|notte))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"\b({TimeOfDayRegex}(\s+(il|l'|del(l')?|di))?)\b";
      public const string LessThanRegex = @"\b(meno\s+di)\b";
      public const string MoreThanRegex = @"\b(più\s+di)\b";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|or[ae]|hrs?|h|minut[oi]|mins?|second[oi]|secs?)\b";
      public const string SuffixAndRegex = @"(?<suffix>\s*e\s+(un\s+)?(?<suffix_num>mezzo|mezza|quarto))";
      public const string PeriodicRegex = @"\b(?<periodic>giornalier[oaei]|giornalmente|quotidian[oaei]|quotidianamente|mensil[ei]|mensilmente|settimanal[ei]|settimanalmente|bisettimanal[ei]|annual[ei]|annualmente)\b";
      public static readonly string EachUnitRegex = $@"(?<each>(ogni|tutte\s+le|tutti\s+(gl)?i|una\s+volta\s+(al(l')?|l'))(?<other>\s+altro)?\s*{DurationUnitRegex})";
      public const string EachPrefixRegex = @"\b(?<each>(ogni|tutte\s+le|tutti\s+(gl)?i|una\s+volta\s+(al(l')?|l'))\s*$)";
      public const string SetEachRegex = @"\b(?<each>(ogni|tutte\s+le|tutti\s+(gl)?i|una\s+volta\s+(al(l')?|l'))\s*)";
      public const string SetLastRegex = @"(?<last>prossim[oaei]|seguent[ei]|in\s+arrivo|quest[oaei]|ultim[oaei]|passat[oaei]|scors[oaei]|precedent[ei]|corrent[ei])";
      public const string EachDayRegex = @"^\s*(ogni|tutti\s+i)\s+giorn[oi]\b";
      public static readonly string DurationFollowedUnit = $@"(^\s*{DurationUnitRegex}\s+{SuffixAndRegex})|(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+([\.,]\d*)?)(-)?\s*{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"(((?<half>mezz[oa]?|metà)[-']?|un[oa']?|un altro|un'altra)\s*{DurationUnitRegex})";
      public const string DuringRegex = @"\b(per|durante)\s+(il|l[a'])\s+(?<unit>anno|mese|settimana|giorno)\b";
      public const string AllRegex = @"\b(?<all>(tutt[oa](\s+(il|l[a']))?|inter[oa])(\s*|-)(?<unit>anno|mese|settimana|giorno)|(?<unit>anno|mese|settimana|giorno)\s+inter[oa])\b";
      public const string HalfRegex = @"\b((?<half>(metà|mezz[oa])\s+(?<unit>anno|mese|settimana|giorno|ora))|(?<half>(?<unit>semestr[ei])))\b";
      public const string ConjunctionRegex = @"\b((e(\s+per)?)|con)\b";
      public static readonly string HolidayRegex1 = $@"\b(?<holiday>capodanno cinese|cenone di capodanno|veglione di capodanno|(la )?vigilia di capodanno|capodanno|mercoledì delle ceneri|le ceneri|martedì grasso|primo dell'anno|festa del papà|pesce d'aprile|vigilia di natale|la vigilia|giorno di natale|natale|halloween|domenica di pasqua|pasqua|lunedì dell'angelo)(\s+((del|di)\s+)?({YearRegex}|{RelativeRegex}\s*anno))?\b";
      public static readonly string HolidayRegex2 = $@"\b(?<holiday>giorno dei morti|i morti|tutti i santi|i santi|giorno dell'independenza|((giorno|festa) del)?la liberazione|festa della repubblica|festa del lavoro|festa dei lavoratori)(\s+((del|di)\s+)?({YearRegex}|{RelativeRegex}\s*anno))?\b";
      public static readonly string HolidayRegex3 = $@"(?<holiday>(giorno\s+((di|del(la)?)\s+)?)?(pasqua|quaresima|memoria|ringraziamento|san patrizio|festa della mamma|festa delle donne|festa della donna|san valentino|ferragosto))(\s+((del|di)\s+)?({YearRegex}|{RelativeRegex}\s*anno))?";
      public const string DateTokenPrefix = @"il ";
      public const string TimeTokenPrefix = @"alle ";
      public const string TokenBeforeDate = @"il ";
      public const string TokenBeforeTime = @"alle ";
      public const string AMTimeRegex = @"(?<am>mattin[oa]|mattinata|notte|nottata)";
      public const string PMTimeRegex = @"\b(?<pm>pomeriggio|sera|serata)\b";
      public const string BeforeRegex = @"\b(prima(\s+(di|del(l['aoei])?|degli|dei))?|entro\s*(l['aoe]|il?|gli|i)?|(non\s+dopo\s+(il?|l[oae']|gli)|non\s+più\s+tardi\s+(di|del(l['aoei])?|degli|dei)|termina(no)?(\s+con)?(\s+(il?|l[oae']|gli))?|precedente\s+a((l(l['aoe])?)|gli|i)?|fino\s+a((l(l['aoe])?)|gli|i)?))\b";
      public const string BeforeRegex2 = @"\b(entro\s*(l['aoe]|il?|gli|i)?)\b";
      public const string AfterRegex = @"\b((?<!non\s+)dopo\s+(il?|l[oae']|gli|i)(?!\s+o uguale a)|(?<!non\s+)(dopo|più\s+tardi)\s+d(i|el(l[oae'])?|ei|egli)|(?<!non\s+)dopo(?!\s+o uguale a))\b";
      public const string SinceRegex = @"\b(a partire\s+da(l(l[aoe'])?|i|gli)?|dopo\s+(il?|l[aoe']|gli)|da(l(l[aoe'])?|i|gli)?(?!(.+(\s+(fino\s+)?a(gli|i|l(l[aoe'])?)?\b)|\s*\d+\s*\-\s*\d+(?!(\s*-))))|(dopo|successiv[oaei])\s+o\s+uguale\s+a((l(l['aoe])?)|gli|i)?)\b";
      public const string AroundRegex = @"(\b(intorno\s+a(l(l['aoe])?|gli|i)?|verso\s+(il|l[aoe']|gli|i))\s*\b)";
      public const string AgoPrefixRegex = @"\b(di)\b";
      public const string LaterRegex = @"\b(dopo|da\s+adesso|da\s+questo\s+momento)\b";
      public const string AgoRegex = @"\b(fa|prima|addietro)\b";
      public const string BeforeAfterRegex = @"^[.]";
      public const string InConnectorRegex = @"\b(in|tra|fra|a)\b";
      public static readonly string SinceYearSuffixRegex = $@"(^\s*{SinceRegex}\s*(ann[oi]\s*)?({DateYearRegex}|{FullTextYearRegex}))";
      public static readonly string WithinNextPrefixRegex = $@"\b(entro(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string TodayNowRegex = @"\b(oggi|adesso)\b";
      public static readonly string MorningStartEndRegex = $@"(^(((di\s+|questa\s+|sta)?mattin[oa]|mattinata)|{AmDescRegex}))|((((di\s+|questa\s+|sta)?mattin[oa]|mattinata)|{AmDescRegex})$)";
      public static readonly string AfternoonStartEndRegex = $@"(^((((di|al)\s+|questo\s+|sto)?pomeriggio)|{PmDescRegex}))|(((((di|il)\s+|questo\s+|sto)?pomeriggio)|{PmDescRegex})$)";
      public const string EveningStartEndRegex = @"(^((di\s+|questa\s+|sta)?sera|serata))|(((di\s+|questa\s+|sta)?sera|serata)$)";
      public const string NightStartEndRegex = @"(^((di\s+|questa\s+|sta)?notte|nottata))|(((di\s+|questa\s+|sta)?notte|nottata)$)";
      public const string InexactNumberRegex = @"\b(un\s+po'\s+di|alcun[ei]|qualche|parecchie?|divers[ie]|molt[oaei]|poc[oa]|poch[ei])\b";
      public static readonly string InexactNumberUnitRegex = $@"\b((({InexactNumberRegex}\s+|(?<=(prossim[ei]|scors[ei]|ultim[ei])\s+)){DurationUnitRegex})|({DurationUnitRegex}(?=\s+(seguenti|successiv[ei]|passat[ei]|precedent[ei]))))\b";
      public static readonly string InexactNumberUnitRegex2 = $@"\b({InexactNumberRegex}\s+{DurationUnitRegex}|(?<unit>decenni|anni|mesi|settimane|giorni|ore|minuti|secondi))";
      public static readonly string RelativeTimeUnitRegex = $@"(((({ThisPrefixRegex}|{NextPrefixRegex}|{PreviousPrefixRegex})\s+{TimeUnitRegex})|({ThisPrefixRegex}\s+)?{TimeUnitRegex}\s+({NextSuffixRegex}|{PastSuffixRegex}))|\b(le|i|miei?)\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))|(({DurationUnitRegex})(?=\s+({NextSuffixRegex}|{PastSuffixRegex}|{ThisPrefixRegex})))|((le|i|miei?))\s+({RestrictedTimeUnitRegex}))";
      public const string ReferenceDatePeriodRegex = @"\b((quel(l[a'])?)|((l[oa]\s+)?stess[oa]))\s+(?<duration>settimana|mese|anno|decennio|finesettimana|weekend)\b";
      public const string ConnectorRegex = @"^\s*(-|,|t|per l[e']|all[e']|intorno all[e']|verso l[e'])\s*$";
      public const string ConnectorAndRegex = @"\b(e(\s+(il?|l[oae']|gli))?)\b.*";
      public const string FromRegex = @"\b(da(l(l[oae'])?|i|gli)?)$";
      public const string FromRegex2 = @"\b(dopo(\s*l[oae']|il?)?)$";
      public const string FromToRegex = @"\b(da(l(l[oae'])?|i|gli)?).+(a(l(l[oae'])?|i|gli)?)\b.+";
      public const string SingleAmbiguousMonthRegex = @"(march)";
      public const string SingleAmbiguousTermsRegex = @"(?<!l')una\b";
      public const string UnspecificDatePeriodRegex = @"^(settimana|finesettimana|weekend|mese|anno)$";
      public const string PrepositionSuffixRegex = @"\b(il|al?|del|di|dal?|fino al?)$";
      public static readonly string FlexibleDayRegex = $@"(?<DayOfMonth>({WrittenDayRegex}|{DayRegex}))";
      public static readonly string ForTheRegex = $@"\b((((?<=per\s+il\s+){FlexibleDayRegex})|((?<!(\b{MonthRegex},?|\bper)\s+(il\s+|l'))(?<=(il\s+|l')){FlexibleDayRegex}))(?<end>\s*(,|\.|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex},?\s+((il\s+)?{FlexibleDayRegex})\b(?!\s+{MonthRegex}\b)";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s*,?\s+(?!(il|l')){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{{PmDescRegex|{OclockRegex}}}))))\b";
      public const string RestOfDateRegex = @"\bresto\s+((di|del(l[a'])?)\s*)?((quest[oa']|corrente|mia)\s*)?(?<duration>settimana|mese|anno|decennio)(\s+corrente)?\b";
      public const string RestOfDateTimeRegex = @"\bresto\s+((di|del(la)?)\s+)?((quest[oa]|corrente|mi[oa])\s+)?(?<unit>giorn(o|ata))(\s+corrente)?\b";
      public const string SuffixAfterRegex = @"\b(((a)\s)?(o|e)\s+(sopra|dopo|più\s+tardi|più\s+grande)(?!\s+di))\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b((({PrefixPeriodRegex})(\s+(di|del(l[ao'])?))?)\s*\b\s*(?<suffix>{OneWordPeriodRegex})|({UnspecificEndOfRangeRegex}))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|questa)\s+settimana)((\s+[tf]ra\s+{WeekDayRegex}\s+e\s+{WeekDayRegex})|(\s+da\s+{WeekDayRegex}\s+a\s+{WeekDayRegex})))\b";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|e|,)\s*$";
      public const string PrefixArticleRegex = @"\b(il?|l[oae']|gli)\s*";
      public const string OrRegex = @"\s*(o|oppure)\s*";
      public static readonly string YearPlusNumberRegex = $@"\b(anno\s+((?<year>(\d{{3,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({EngTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b(((?<=\b(prima (di|dell[e'])|non prima (di|dell[e'])|per(\s+l[e'])?|dopo(\s+l[e'])?)\s*)({EngTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>(,)?\s+(il|all[e']|(verso|per) l[e']|intorno all[e']))\s*$";
      public const string DateAfterRegex = @"\b((e|o)\s+(dopo|passato|oltre))\b";
      public static readonly string YearPeriodRegex = $@"(((dal|durante|nel|[tf]ra)\s+(il\s+)?)?{YearRegex}\s*{TillRegex}\s*{YearRegex})";
      public const string FutureSuffixRegex = @"\b(((in|nel)\s+)?(futuro|seguito))|(da\s+questo\s+momento)\b";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public static readonly string ComplexDatePeriodRegex = $@"(((da(l(l[aeo'])?|i)?|durante|in|nel(l[aeo'])?|negli)\s*)?(?<start>.+)\s*({TillRegex})\s*(?<end>.+)|(([tf]ra)\s+)(?<start>.+)\s*({RangeConnectorRegex})\s*(?<end>.+))";
      public const string AmbiguousPointRangeRegex = @"^(mar)$";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"decenni", @"10Y" },
            { @"decennio", @"10Y" },
            { @"anni", @"Y" },
            { @"anno", @"Y" },
            { @"semestre", @"Y" },
            { @"semestri", @"Y" },
            { @"mesi", @"MON" },
            { @"mese", @"MON" },
            { @"settimane", @"W" },
            { @"settimana", @"W" },
            { @"giorni", @"D" },
            { @"giorno", @"D" },
            { @"giornata", @"D" },
            { @"ore", @"H" },
            { @"ora", @"H" },
            { @"hrs", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minuti", @"M" },
            { @"minuto", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"secondi", @"S" },
            { @"secondo", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"decenni", 315360000 },
            { @"decennio", 315360000 },
            { @"anni", 31536000 },
            { @"anno", 31536000 },
            { @"semestre", 31536000 },
            { @"mesi", 2592000 },
            { @"mese", 2592000 },
            { @"settimane", 604800 },
            { @"settimana", 604800 },
            { @"giorni", 86400 },
            { @"giorno", 86400 },
            { @"ore", 3600 },
            { @"ora", 3600 },
            { @"hrs", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minuti", 60 },
            { @"minuto", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"secondi", 1 },
            { @"secondo", 1 },
            { @"secs", 1 },
            { @"sec", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscale", @"FY" },
            { @"scolastico", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"primavera", @"SP" },
            { @"estate", @"SU" },
            { @"autunno", @"FA" },
            { @"inverno", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"primo", 1 },
            { @"prima", 1 },
            { @"secondo", 2 },
            { @"seconda", 2 },
            { @"terzo", 3 },
            { @"terza", 3 },
            { @"quarto", 4 },
            { @"quarta", 4 },
            { @"quinto", 5 },
            { @"quinta", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"lunedì", 1 },
            { @"martedì", 2 },
            { @"mercoledì", 3 },
            { @"giovedì", 4 },
            { @"venerdì", 5 },
            { @"sabato", 6 },
            { @"sabati", 6 },
            { @"domenica", 0 },
            { @"domeniche", 0 },
            { @"lun", 1 },
            { @"mar", 2 },
            { @"mer", 3 },
            { @"gio", 4 },
            { @"ven", 5 },
            { @"sab", 6 },
            { @"dom", 0 },
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"gennaio", 1 },
            { @"febbraio", 2 },
            { @"marzo", 3 },
            { @"aprile", 4 },
            { @"maggio", 5 },
            { @"giugno", 6 },
            { @"luglio", 7 },
            { @"agosto", 8 },
            { @"settembre", 9 },
            { @"ottobre", 10 },
            { @"novembre", 11 },
            { @"dicembre", 12 },
            { @"gen", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"apr", 4 },
            { @"mag", 5 },
            { @"giu", 6 },
            { @"lug", 7 },
            { @"ago", 8 },
            { @"set", 9 },
            { @"sett", 9 },
            { @"ott", 10 },
            { @"nov", 11 },
            { @"dic", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"zero", 0 },
            { @"uno", 1 },
            { @"un", 1 },
            { @"una", 1 },
            { @"due", 2 },
            { @"tre", 3 },
            { @"quattro", 4 },
            { @"cinque", 5 },
            { @"sei", 6 },
            { @"sette", 7 },
            { @"otto", 8 },
            { @"nove", 9 },
            { @"dieci", 10 },
            { @"undici", 11 },
            { @"dodici", 12 },
            { @"tredici", 13 },
            { @"quattordici", 14 },
            { @"quindici", 15 },
            { @"sedici", 16 },
            { @"diciassette", 17 },
            { @"diciotto", 18 },
            { @"diciannove", 19 },
            { @"venti", 20 },
            { @"ventuno", 21 },
            { @"ventidue", 22 },
            { @"ventitre", 23 },
            { @"ventiquattro", 24 },
            { @"venticinque", 25 },
            { @"ventisei", 26 },
            { @"ventisette", 27 },
            { @"ventotto", 28 },
            { @"ventinove", 29 },
            { @"trenta", 30 },
            { @"trentuno", 31 },
            { @"trentadue", 32 },
            { @"trentatre", 33 },
            { @"trentaquattro", 34 },
            { @"trentacinque", 35 },
            { @"trentasei", 36 },
            { @"trentasette", 37 },
            { @"trentotto", 38 },
            { @"trentanove", 39 },
            { @"quaranta", 40 },
            { @"quarantuno", 41 },
            { @"quarantadue", 42 },
            { @"quarantatre", 43 },
            { @"quarantaquattro", 44 },
            { @"quarantacinque", 45 },
            { @"quarantasei", 46 },
            { @"quarantasette", 47 },
            { @"quarantotto", 48 },
            { @"quarantanove", 49 },
            { @"cinquanta", 50 },
            { @"cinquantuno", 51 },
            { @"cinquantadue", 52 },
            { @"cinquantatre", 53 },
            { @"cinquantaquattro", 54 },
            { @"cinquantacinque", 55 },
            { @"cinquantasei", 56 },
            { @"cinquantasette", 57 },
            { @"cinquantotto", 58 },
            { @"cinquantanove", 59 },
            { @"sessanta", 60 },
            { @"sessantuno", 61 },
            { @"sessantadue", 62 },
            { @"sessantatre", 63 },
            { @"sessantaquattro", 64 },
            { @"sessantacinque", 65 },
            { @"sessantasei", 66 },
            { @"sessantasette", 67 },
            { @"sessantotto", 68 },
            { @"sessantanove", 69 },
            { @"settanta", 70 },
            { @"settantuno", 71 },
            { @"settantadue", 72 },
            { @"settantatre", 73 },
            { @"settantaquattro", 74 },
            { @"settantacinque", 75 },
            { @"settantasei", 76 },
            { @"settantasette", 77 },
            { @"settantotto", 78 },
            { @"settantanove", 79 },
            { @"ottanta", 80 },
            { @"ottantuno", 81 },
            { @"ottantadue", 82 },
            { @"ottantatre", 83 },
            { @"ottantaquattro", 84 },
            { @"ottantacinque", 85 },
            { @"ottantasei", 86 },
            { @"ottantasette", 87 },
            { @"ottantotto", 88 },
            { @"ottantanove", 89 },
            { @"novanta", 90 },
            { @"novantuno", 91 },
            { @"novantadue", 92 },
            { @"novantatre", 93 },
            { @"novantaquattro", 94 },
            { @"novantacinque", 95 },
            { @"novantasei", 96 },
            { @"novantasette", 97 },
            { @"novantotto", 98 },
            { @"novantanove", 99 },
            { @"cento", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"13", 13 },
            { @"14", 14 },
            { @"15", 15 },
            { @"16", 16 },
            { @"17", 17 },
            { @"18", 18 },
            { @"19", 19 },
            { @"20", 20 },
            { @"21", 21 },
            { @"22", 22 },
            { @"23", 23 },
            { @"24", 24 },
            { @"25", 25 },
            { @"26", 26 },
            { @"27", 27 },
            { @"28", 28 },
            { @"29", 29 },
            { @"30", 30 },
            { @"31", 31 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"mezzo", 0.5 },
            { @"mezza", 0.5 },
            { @"metà", 0.5 },
            { @"quarto", 0.25 },
            { @"quarti", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"easterday", new string[] { @"pasqua", @"giornodipasqua", @"domenicadipasqua" } },
            { @"eastermonday", new string[] { @"lunedidell'angelo" } },
            { @"fathersday", new string[] { @"festadelpapà" } },
            { @"mothersday", new string[] { @"festadellamamma" } },
            { @"memorialday", new string[] { @"giornodellamemoria" } },
            { @"mardigras", new string[] { @"martedigrasso" } },
            { @"ashwednesday", new string[] { @"mercoledidelleceneri", @"leceneri" } },
            { @"allsaintsday", new string[] { @"tuttiisanti", @"isanti" } },
            { @"allsoulsday", new string[] { @"giornodeimorti", @"imorti" } },
            { @"femaleday", new string[] { @"festadelladonna", @"festadelledonne" } },
            { @"ferragosto", new string[] { @"ferragosto" } },
            { @"christmas", new string[] { @"giornodinatale", @"natale" } },
            { @"christmaseve", new string[] { @"vigiliadinatale", @"lavigilia" } },
            { @"newyear", new string[] { @"capodannocinese", @"capodanno" } },
            { @"valentinesday", new string[] { @"sanvalentino" } },
            { @"stpatrickday", new string[] { @"giornodisanpatrizio" } },
            { @"aprilfools", new string[] { @"pescedaprile" } },
            { @"labourday", new string[] { @"festadeilavoratori", @"festadellavoro" } },
            { @"independenceday", new string[] { @"giornodell'indipendenza" } },
            { @"liberationday", new string[] { @"giornodellaliberazione", @"festadellaliberazione", @"laliberazione" } },
            { @"republicday", new string[] { @"festadellarepubblica" } },
            { @"halloweenday", new string[] { @"halloween" } },
            { @"newyeareve", new string[] { @"cenonedicapodoanno", @"veglionedicapodanno", @"lavigiliadicapodanno", @"vigiliadicapodanno" } },
            { @"thanksgiving", new string[] { @"giornodelringraziamento", @"ringraziamento" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"dieci", 10 },
            { @"venti", 20 },
            { @"trenta", 30 },
            { @"quaranta", 40 },
            { @"cinquanta", 50 },
            { @"sessanta", 60 },
            { @"settanta", 70 },
            { @"ottanta", 80 },
            { @"novanta", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"questo secolo", 2000 },
            { @"duemila", 2000 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly string[] DurationDateRestrictions = {  };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"\bgiorno|pomeriggio|sera|notte\b", @"\b(buona?\s*(giorno|pomeriggio|sera|notte))\b" },
            { @"^(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)$", @"([$%£&!?@#])(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)|(apr|ago|dic|feb|gen|lug|giu|mar|mag|nov|ott|sett?)([$%£&@#])" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"mattino",
            @"mattina",
            @"mattine",
            @"mattinata"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"pomeriggio",
            @"pomeriggi",
            @"dopo pranzo"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"sera",
            @"sere",
            @"serata"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"giorno",
            @"dì",
            @"giornata"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"notte",
            @"notti",
            @"nottata"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"oggi"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"domani",
            @"giorno dopo"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"ieri",
            @"giorno prima"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"dopodomani",
            @"domani l'altro"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"l'altroieri",
            @"altroieri"
        };
      public static readonly IList<string> FutureStartTerms = new List<string>
        {
            @"questo",
            @"questa",
            @"questi",
            @"queste",
            @"quest'",
            @"prossimo",
            @"prossima",
            @"prossimi",
            @"prossime",
            @"prossim'"
        };
      public static readonly IList<string> FutureEndTerms = new List<string>
        {
            @"prossimo",
            @"prossima",
            @"prossimi",
            @"prossime",
            @"prossim'"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"ultimo",
            @"ultima",
            @"ultimi",
            @"ultime",
            @"ultim'",
            @"l'ultimo",
            @"l'ultima",
            @"l'ultimi",
            @"l'ultime",
            @"l'ultim'"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"mese",
            @"mesi"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"dall'inizio del mese"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"finesettimana",
            @"weekend"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"settimana",
            @"settimane"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"anno",
            @"anni",
            @"annata",
            @"annate"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"dall'inizio dell'anno",
            @"da inizio anno"
        };
    }
}