//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Hindi\Hindi-Numbers.yaml
//     - Language: Hindi
//     - ClassName: NumbersDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Hindi
{
    using System;
    using System.Collections.Generic;

    public static class NumbersDefinitions
    {
      public const string LangMarker = @"Hin";
      public const bool CompoundNumberLanguage = true;
      public const bool MultiDecimalSeparatorCulture = false;
      public const string RoundNumberIntegerRegex = @"(सौ|हजार|हज़ार|लाख|करोड़|अरब|खरब)";
      public const string ZeroToNineIntegerRegex = @"(सात|आठ|फ़ोर|चार|पांच|पाँच|शून्य|नौ|दो|छह|एक(सठ)?|तीन|०|१|२|३|४|५|६|७|८|९)";
      public const string TwoToNineIntegerRegex = @"(तीन|सात|आठ|फ़ोर|चार|पाँच|पांच|नौ|दो|छह)";
      public const string NegativeNumberTermsRegex = @"(?<negTerm>(माइनस|निगेटिव)\s+)";
      public static readonly string NegativeNumberSignRegex = $@"^{NegativeNumberTermsRegex}.*";
      public const string AnIntRegex = @"(एक|1|१)(?=\s)";
      public const string TenToNineteenIntegerRegex = @"(सत्रह|तेरह|चौदह|अठारह|उन्नीस|पंद्रह|सोलह|ग्यारह|बारह|दस)";
      public const string TwentyToTwentyNineIntegerRegex = @"(सत्ताईस|तेईस|चौबीस|अट्ठाईस|अट्ठाइस|उनतीस|पच्चीस|छब्बीस|इक्कीस|बाईस|बीस)";
      public const string ThirtyToThirtyNineIntegerRegex = @"(सैंतीस|तैंतीस|चौंतीस|अड़तीस|उनतालीस|पैंतीस|छ्त्तीस|इकतीस|इकत्तीस|बत्तीस|तीस)";
      public const string FourtyToFourtyNineIntegerRegex = @"(सैंतालीस|तैंतालीस|चौंतालीस|अड़तालीस|उनचास|पैंतालीस|छियालीस|इकतालीस|बयालीस|चालीस)";
      public const string FiftyToFiftyNineIntegerRegex = @"(सत्तावन|तिरेपन|चौबन|अट्ठावन|उनसठ|पचपन|छप्पन|इक्याबन|बावन|पचास)";
      public const string SixtyToSixtyNineIntegerRegex = @"((सड़|सड़|तिर|चौं|अड़|उनहत्तर|पैं|छिया|इक|बा|साठ|एक)(सठ))";
      public const string SeventyToSeventyNineIntegerRegex = @"(?:सतहत्तर|तिहत्तर|चौहत्तर|अठहत्तर|उनासी|पचहत्तर|छिहत्तर|इकहत्तर|अठत्तर|बहत्तर|सत्तर)";
      public const string EightyToEightyNineIntegerRegex = @"(सतासी|तिरासी|चौरासी|अठासी|नवासी|पचासी|छियासी|इक्यासी|बयासी|अस्सी)";
      public const string NinetyToNinetyNineIntegerRegex = @"(सत्तानवे|तिरानवे|चौरानवे|अट्ठानवे|निन्यानवे|पचानवे|पंचानबे|छियानवे|इक्यानबे|बानवे|नब्बे)";
      public const string TensNumberIntegerRegex = @"(सत्तर|बीस|तीस|अस्सी|नब्बे|चालीस|पचास|साठ)";
      public const string DigitsNumberRegex = @"\d|\d{1,3}(\.\d{3})";
      public static readonly string AllNumericalIntRegex = $@"({ZeroToNineIntegerRegex}|{TenToNineteenIntegerRegex}|{TwentyToTwentyNineIntegerRegex}|{ThirtyToThirtyNineIntegerRegex}|{FourtyToFourtyNineIntegerRegex}|{FiftyToFiftyNineIntegerRegex}|{SixtyToSixtyNineIntegerRegex}|{SeventyToSeventyNineIntegerRegex}|{EightyToEightyNineIntegerRegex}|{NinetyToNinetyNineIntegerRegex})";
      public static readonly string SeparaIntRegex = $@"(?:((({AllNumericalIntRegex}|({TensNumberIntegerRegex}(\s+(और\s+)?){ZeroToNineIntegerRegex})|{TensNumberIntegerRegex})(\s+({RoundNumberIntegerRegex}|{RoundNumberHinglishIntegerRegex}))*)|(({AnIntRegex}?(\s+({RoundNumberIntegerRegex}))+))|({RoundNumberIntegerRegex})|({AllNumericalIntRegex})))";
      public static readonly string AllIntRegex = $@"(?:((({AllNumericalIntRegex}|({TensNumberIntegerRegex}(\s+(और\s+)?){ZeroToNineIntegerRegex})|{TensNumberIntegerRegex}|{AnIntRegex})(\s+({RoundNumberIntegerRegex}|{RoundNumberHinglishIntegerRegex}))+)\s+(और\s+)?)*({SeparaIntRegex}))";
      public const string PlaceHolderPureNumber = @"\b";
      public const string PlaceHolderDefault = @"\D|\b";
      public static readonly Func<string, string> NumbersWithPlaceHolder = (placeholder) => $@"(((?<!\d+\s*)-\s*)|(?<=\b))\d+(?!([\.,]\d+[ऀ-ॿ]))(?={placeholder})";
      public const string IndianNumberingSystemRegex = @"(?<=\b)((?:\d+|\d{1,2},(?:\d{2},)*\d{3})(?:\.\d{2})?(?=\s|$))";
      public static readonly string NumbersWithSuffix = $@"(((?<!\d+\s*)-\s*)|(?<=\b))\d+\s*{BaseNumbers.NumberMultiplierRegex}(?=\b)";
      public static readonly string RoundNumberIntegerRegexWithLocks = $@"(?<=\b)\d+\s+({RoundNumberIntegerRegex}|{RoundNumberHinglishIntegerRegex})";
      public const string NumbersWithDozenSuffix = @"\d+\s+दर्जन(नों)?";
      public const string AdditionTermsRegex = @"(?<=\s)(और|व|तथा|एवं|प्लस|plus|जमा)(?=\s)";
      public static readonly string AllIntRegexWithLocks = $@"(?<=\b){AllIntRegex}";
      public const string RoundNumberHinglishIntegerRegex = @"(?:हंड्रेड|थाउजेंड|मिलियन|बिलियन|ट्रिलियन)";
      public const string OnetoNineHinglishIntegerRegex = @"(?:वन|टू|थ्री|फोर|फ़ाइव|सिक्स|सेवन|एइट|नाइन)";
      public const string ElevenToNineteenHinglishIntegerRegex = @"(?:इलेवन|ट्वेल्व|थर्टीन|फ़ोर्टीन|फ़िफ़्टीन|सिक्सटीन|सेवेनटीन|एइटीन|नाइनटीन)";
      public const string TensHinglishIntegerRegex = @"(?:टेन|ट्वेन्टी|ट्वेंटी|थर्टी|फ़ोर्टी|फ़िफ़्टी|सिक्सटी|सेवेंटी|एइट्टी|नाइनटी)";
      public static readonly string HinglishIntegerRegex = $@"(({TensHinglishIntegerRegex}\s+{OnetoNineHinglishIntegerRegex})|{OnetoNineHinglishIntegerRegex}|{ElevenToNineteenHinglishIntegerRegex}|{TensHinglishIntegerRegex})";
      public static readonly string CompoundHindiNumberRegex = $@"((({HinglishIntegerRegex}\s+)?({RoundNumberHinglishIntegerRegex}\s+)?(अंड\s+)?)+({HinglishIntegerRegex}|{RoundNumberHinglishIntegerRegex})|{HinglishIntegerRegex}|{RoundNumberHinglishIntegerRegex})";
      public static readonly string NegativeHinglishRegex = $@"(({NegativeNumberTermsRegex})?{CompoundHindiNumberRegex})";
      public static readonly string AllIntRegexWithDozenSuffixLocks = $@"(?<=\b)(((आधा\s+|एक\s+)दर्जन)|({AllIntRegex}\s+दर्जन(नों)?)|({CompoundHindiNumberRegex}\s+डज़न))";
      public const string RoundNumberEnglishIntegerRegex = @"(?:hundred|thousand|million|billion|trillion)";
      public const string ZeroToNineEnglishIntegerRegex = @"(?:three|seven|eight|four|five|zero|nine|one|two|six)";
      public const string TenToNineteenEnglishIntegerRegex = @"(?:seventeen|thirteen|fourteen|eighteen|nineteen|fifteen|sixteen|eleven|twelve|ten)";
      public const string TensNumberEnglishIntegerRegex = @"(?:seventy|twenty|thirty|eighty|ninety|forty|fifty|sixty)";
      public static readonly string EnglishIntegerRegex = $@"(({TensNumberEnglishIntegerRegex}\s+{ZeroToNineEnglishIntegerRegex})|{ZeroToNineEnglishIntegerRegex}|{TenToNineteenEnglishIntegerRegex}|{TensNumberEnglishIntegerRegex})";
      public static readonly string CompoundEnglishNumberRegex = $@"((({EnglishIntegerRegex}\s+)?({RoundNumberEnglishIntegerRegex}\s+)?(and\s+)?)+({EnglishIntegerRegex}|{RoundNumberEnglishIntegerRegex})|({EnglishIntegerRegex}\s+{RoundNumberEnglishIntegerRegex})|{EnglishIntegerRegex}|{RoundNumberEnglishIntegerRegex})";
      public const string DecimalUnitsRegex = @"(?:डेढ़|डेढ़|डेढ|ढाई|सवा|सावा)";
      public static readonly string DecimalUnitsWithRoundNumberRegex = $@"({DecimalUnitsRegex}\s+({{AllNumericalIntRegex}}\s+)?{RoundNumberIntegerRegex}|{DecimalUnitsRegex})";
      public const string RoundNumberOrdinalRegex = @"(?:(सौ|हजार|हज़ार|लाख|करोड़|अरब|खरब)(वां|वीं|वें|वाँ))";
      public const string OneToNineOrdinalRegex = @"(?:पहला|(?<!से\s*)पहले|पहली|तीसरे|प्रथम|दूसरा|दूसरी|दूसरे|तिहाई|चौथाई|((पांच|पाँच|छठ|सात|आठ|नौ)(वां|वीं|वें|वाँ|वा)))";
      public const string TenToNineteenOrdinalRegex = @"(?:(दस|ग्यारह|बारह|तेरह|चौदह|पंद्रह|सोलह|सत्रह|अठारह|उन्नीस)(वां|वीं|वें|वाँ))";
      public const string TwentyToTwentyNineOrdinalRegex = @"(?:(बीस|इक्कीस|बाईस|बाइस|तेईस|तेइस|चौबीस|पच्चीस|छब्बीस|सत्ताईस|सत्ताइस|अट्ठाईस|अट्ठाइस|उनतीस)(वां|वीं|वें|वाँ))";
      public const string ThirtyToThirtyNineOrdinalRegex = @"(?:(तीस|इकतीस|इकत्तीस|बत्तीस|तैंतीस|चौंतीस|पैंतीस|छ्त्तीस|सैंतीस|अड़तीस|उनतालीस)(वां|वीं|वें|वाँ))";
      public const string FourtyToFourtyNineOrdinalRegex = @"(?:(चालीस|इकतालीस|बयालीस|तैंतालीस|चौंतालीस|पैंतालीस|छियालीस|सैंतालीस|अड़तालीस|उनचास)(वां|वीं|वें|वाँ))";
      public const string FiftyToFiftyNineOrdinalRegex = @"(?:(पचास|इक्याबन|बावन|तिरेपन|चौबन|पचपन|छप्पन|सत्तावन|अट्ठावन|उनसठ)(वां|वीं|वें|वाँ))";
      public const string SixtyToSixtyNineOrdinalRegex = @"(?:(साठ|इकसठ|बासठ|तिरसठ|चौंसठ|पैंसठ|छियासठ|सड़सठ|सड़सठ|अड़सठ|उनहत्तर)(वां|वीं|वें|वाँ))";
      public const string SeventyToSeventyNineOrdinalRegex = @"(?:(सत्तर|इकहत्तर|बहत्तर|तिहत्तर|चौहत्तर|पचहत्तर|छिहत्तर|सतहत्तर|अठहत्तर|अठत्तर|उनासी)(वां|वीं|वें|वाँ))";
      public const string EightyToEightyNineOrdinalRegex = @"(?:(अस्सी|इक्यासी|बयासी|तिरासी|चौरासी|पचासी|छियासी|सतासी|अठासी|नवासी)(वां|वीं|वें|वाँ))";
      public const string NinetyToNinetyNineOrdinalRegex = @"(?:(नब्बे|इक्यानबे|बानवे|तिरानवे|चौरानवे|पचानवे|छियानवे|सत्तानवे|अट्ठानवे|निन्यानवे)(वां|वीं|वें|वाँ))";
      public static readonly string NumberOrdinalRegex = $@"({OneToNineOrdinalRegex}|{TenToNineteenOrdinalRegex}|{TwentyToTwentyNineOrdinalRegex}|{ThirtyToThirtyNineOrdinalRegex}|{FourtyToFourtyNineOrdinalRegex}|{FiftyToFiftyNineOrdinalRegex}|{SixtyToSixtyNineOrdinalRegex}|{SeventyToSeventyNineOrdinalRegex}|{EightyToEightyNineOrdinalRegex}|{NinetyToNinetyNineOrdinalRegex})";
      public static readonly string CompoundNumberOrdinals = $@"((({AllNumericalIntRegex}\s+)?({RoundNumberIntegerRegex}\s+)?(और\s+)?)+({NumberOrdinalRegex}|{RoundNumberOrdinalRegex})|{NumberOrdinalRegex}|{RoundNumberOrdinalRegex})";
      public const string CompoundFiveWordRelativeOrdinalRegex = @"(?<relativeOrdinal>((अंतिम वाले|आखिरी वाले)\s+(से पहले वाला|का पिछला(\s+वाला)?))|((आखिरी|अंतिम)\s+(से पहले का|के बगल वाला))|((पिछला|पिछले|पिछली)\s+पर केवल एक))";
      public const string CompoundThreeWordRelativeOrdinalRegex = @"(?<relativeOrdinal>((आखिरी से|आखिरी का|आखिरी के|आखिरी की|अंतिम से|अंतिम का|अंतिम के|अंतिम की)\s+(पहला|पहले|पहली|दूसरा|दूसरे|दूसरी)))";
      public const string CompoundTwoWordRelativeOrdinalRegex = @"(?<relativeOrdinal>((पिछला|पिछले|पिछली|अगला|अगले|अगली|अंतिम|आखिरी|अभी)\s+(वाला|वाले|वाली))|((अगला|अगले|अगली)\s+चीज)|((आखिरी|अंतिम)\s+(का|के|की)))";
      public const string SimpleRelativeOrdinalRegex = @"(?<relativeOrdinal>अंतिम|आखिरी|अगला|अगले|अगली|पिछला|पिछले|पिछली|वर्तमान|लास्ट|प्रीवियस|नेक्स्ट|करेंट|last|previous|next|current)";
      public static readonly string RelativeOrdinalRegex = $@"({CompoundFiveWordRelativeOrdinalRegex}|{CompoundThreeWordRelativeOrdinalRegex}|{CompoundTwoWordRelativeOrdinalRegex}|{SimpleRelativeOrdinalRegex})";
      public const string RoundNumberHinglishOrdinalRegex = @"(?:हंड्रेडथ|थाउजेंडथ|मिलियनथ|बिलियनथ|ट्रिलियनथ)";
      public const string OnetoNineHinglishOrdinalRegex = @"(?:फ़र्स्ट|सेकेंड|थर्ड|फोर्थ|फिफ्थ|सिक्स्थ|सेवंथ|एइथ|नाइन्थ)";
      public const string ElevenToNineteenHinglishOrdinalRegex = @"(?:इलेवेन्थ|ट्वेल्फ्थ|थरटीन्थ|फोर्टीन्थ|फिफ्टीन्थ|सिक्सटीन्थ|सेवेंटीन्थ|एइटीन्थ|नाइटीन्थ)";
      public const string TensHinglishOrdinalRegex = @"(?:टेन्थ|ट्वेन्टीएथ|ट्वेंटीएथ|थरटिएथ|फ़ोर्टीएथ|फ़िफ़्टीएथ|सिक्सटिएथ|सेवेंटिएथ|एइटिएथ|नाइन्टीएथ)";
      public const string TensHinglishNumberRegex = @"(?:ट्वेन्टी|ट्वेंटी|थर्टी|फोर्टी|फिफ्टी|फ़िफ़्टी|सिक्सटी|सेवेंटी|एइट्टी|नाइनटी)";
      public static readonly string HinglishOrdinalRegex = $@"(({TensHinglishNumberRegex}\s+{OnetoNineHinglishOrdinalRegex})|{OnetoNineHinglishOrdinalRegex}|{ElevenToNineteenHinglishOrdinalRegex}|{TensHinglishOrdinalRegex})";
      public static readonly string CompoundHindiOrdinalRegex = $@"((({HinglishOrdinalRegex}\s+)?({RoundNumberHinglishOrdinalRegex}\s+)?(अंड\s+)?)+({HinglishOrdinalRegex}|{RoundNumberHinglishOrdinalRegex})|{HinglishOrdinalRegex}|{RoundNumberHinglishOrdinalRegex})";
      public const string RoundNumberEnglishOrdinalRegex = @"(?:hundredth|thousandth|millionth|billionth|trillionth)";
      public const string OnetoNineEnglishOrdinalRegex = @"(?:first|second|third|fourth|fifth|sixth|seventh|eighth|ninth)";
      public const string ElevenToNineteenEnglishOrdinalRegex = @"(?:eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth)";
      public const string TensEnglishOrdinalRegex = @"(?:tenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth)";
      public static readonly string EnglishOrdinalRegex = $@"(({TensNumberEnglishIntegerRegex}\s+{OnetoNineEnglishOrdinalRegex})|{OnetoNineEnglishOrdinalRegex}|{ElevenToNineteenEnglishOrdinalRegex}|{TensEnglishOrdinalRegex})";
      public static readonly string CompoundEnglishOrdinalRegex = $@"((({EnglishIntegerRegex}\s+)?({RoundNumberEnglishIntegerRegex}\s+)?(and\s+)?)+({EnglishOrdinalRegex}|{RoundNumberEnglishOrdinalRegex})|({EnglishIntegerRegex}\s+{RoundNumberEnglishOrdinalRegex})|{EnglishOrdinalRegex})";
      public static readonly string BasicOrdinalRegex = $@"({NumberOrdinalRegex}|{RelativeOrdinalRegex})";
      public static readonly string SuffixBasicOrdinalRegex = $@"(?:((({AllNumericalIntRegex}|{TensNumberIntegerRegex})(\s+({RoundNumberIntegerRegex})(\s+))+)(({NumberOrdinalRegex}))))";
      public static readonly string SuffixRoundNumberOrdinalRegex = $@"(?:({AllIntRegex}\s+){RoundNumberOrdinalRegex})";
      public static readonly string AllOrdinalRegex = $@"(?:{CompoundNumberOrdinals}|{SuffixRoundNumberOrdinalRegex})";
      public const string OrdinalSuffixRegex = @"(?<=\b)(?:(\d*(1(ला|ली)|[2-3]रा|4था|[0-9](वां|वीं|वें|वाँ|वा)))|([०-९]*(१(ला|ली)|[२-३]रा|४था|[०-९](वां|वीं|वें|वाँ|वा))))";
      public const string FractionNotationWithSpacesRegex = @"(((?<=\W|^)-\s*)|(?<=\b))\d+\s+\d+[/]\d+(?=(\b[^/]|$))";
      public static readonly string FractionNotationRegex = $@"{BaseNumbers.FractionNotationRegex}";
      public static readonly string FractionNounRegex = $@"(?<=\b)(((({AllNumericalIntRegex})(\s?)((({RoundNumberIntegerRegex})|({RoundNumberOrdinalRegex}))\s?)?)((और\s)?))+((आधा|आधे|चौथाई|तिहाई)))(?=\b)";
      public static readonly string FractionNounWithArticleRegex = $@"(?<=\b)((({AllIntRegex}\s+(और\s+)?)?(एक)(\s+|\s*-\s*)(?!\bफ़र्स्ट)(({AllOrdinalRegex})|({RoundNumberOrdinalRegex})|(आधा|आधे|चौथाई|तिहाई)))|(आधा|आधे))";
      public static readonly string FractionPrepositionRegex = $@"(?<numerator>(({AllIntRegex}\s+)|((?<![\.,])\d+)(\s|\s+)|({RoundNumberOrdinalRegex})))(((बटा|बटे)\s*)|((का|की|के|कें|में)\s*))(?<denominator>(({AllOrdinalRegex})|({CompoundNumberOrdinals})|(\d+)|({AllIntRegex})|({AllNumericalIntRegex})))";
      public static readonly string FractionPrepositionInverseRegex = $@"(?<denominator>(({AllIntRegex}\s+)|((?<![\.,])\d+)(\s|\s+)|({RoundNumberOrdinalRegex})))((में(\s+से)?)\s*)(?<numerator>(({AllOrdinalRegex})|({CompoundNumberOrdinals})|(\d+)|({AllIntRegex})|({AllNumericalIntRegex})))";
      public static readonly string FractionPrepositionWithinPercentModeRegex = $@"(?<=\b)(?<numerator>({AllIntRegex})|((?<![\.,])\d+))\s+का\s+(?<denominator>({AllIntRegex})|(\d+)(?![\.,]))(?=\b)";
      public static readonly string NegativeCompoundNumberOrdinals = $@"({NegativeNumberTermsRegex}(?<numerator>({AllNumericalIntRegex}\s+)?({RoundNumberIntegerRegex}\s+)?(और\s+)?)+((का|के|की)(\s+))?(?<denominator>({NumberOrdinalRegex}|{RoundNumberOrdinalRegex})))";
      public static readonly string NegativeFractionRegex = $@"({NegativeNumberTermsRegex}{FractionNounWithArticleRegex}|{NegativeNumberTermsRegex}{FractionPrepositionRegex})";
      public static readonly string FractionRegex = $@"((?<=\b)?(({AllIntRegex}\s+)(और\s+)?({FractionPrepositionRegex}))|(?<=\b)?({FractionPrepositionRegex}))";
      public static readonly string AllPointRegex = $@"((\s+{AllNumericalIntRegex})+|(\s+{SeparaIntRegex}))";
      public static readonly string AllFloatRegex = $@"{AllIntRegex}(\s+(पॉइंट|दशमलव)){AllPointRegex}";
      public static readonly string DoubleWithMultiplierRegex = $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+[\.,])))\d+[\.,]\d+\s*{BaseNumbers.NumberMultiplierRegex}(?=\b)";
      public const string DoubleExponentialNotationRegex = @"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+[\.,])))(\d+([\.,]\d+)?)e([+-]*[1-9]\d*)(?=\b)";
      public const string DoubleCaretExponentialNotationRegex = @"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+[\.,])))(\d+([\.,]\d+)?)\^([+-]*[1-9]\d*)(?=\b)";
      public static readonly Func<string, string> DoubleDecimalPointRegex = (placeholder) => $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+[\.,])))\d+[\.,]\d+(?!([\.,]\d+))(?={placeholder})";
      public static readonly Func<string, string> DoubleWithoutIntegralRegex = (placeholder) => $@"(?<=\s|^)(?<!(\d+))[\.,]\d+(?!([\.,]\d+))(?={placeholder})";
      public static readonly string DoubleWithRoundNumber = $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+[\.,])))\d+[\.,]\d+\s+({RoundNumberIntegerRegex}|{RoundNumberHinglishIntegerRegex})";
      public static readonly string DoubleAllFloatRegex = $@"((?<=\b){AllFloatRegex})";
      public const string ConnectorRegex = @"(?<spacer>और)";
      public static readonly string NumberWithSuffixPercentage = $@"(?<!%)({BaseNumbers.NumberReplaceToken})(\s*)(%(?!{BaseNumbers.NumberReplaceToken})|(परसेंट|प्रतिशत)\b)";
      public static readonly string FractionNumberWithSuffixPercentage = $@"(({BaseNumbers.FractionNumberReplaceToken})\s+का)";
      public static readonly string NumberWithPrefixPercentage = $@"({BaseNumbers.NumberReplaceToken})(\s*)(का\s+(परसेंट|प्रतिशत))";
      public static readonly string NumberWithPrepositionPercentage = $@"({BaseNumbers.NumberReplaceToken})\s*(in|out\s+of)\s*({BaseNumbers.NumberReplaceToken})";
      public const string TillRegex = @"(के|से|--|-|—|——|~|–)";
      public const string MoreRegex = @"(?:((उससे|(?<!ज़्यादा\s*)से|के)\s*)(ज़्यादा(\s*बड़ी)?|बड़ी|अधिक|ऊपर|पार)|(?<!<|=)>)";
      public const string LessRegex = @"(?:((उससे|उसके|(?<!कम\s*)से|के)\s*)(कम|छोटी|नीचे)|(?<!>|=)<)";
      public const string EqualRegex = @"((उसके|इसके|के)\s*(समान|बराबर)|(?<!<|>)=)";
      public static readonly string MoreOrEqualPrefix = $@"(({LessRegex}\s*नहीं)|(कम\s+से\s+कम))";
      public static readonly string MoreOrEqual = $@"(?:{MoreOrEqualPrefix}|({MoreRegex}\s+(या)?\s+{EqualRegex})|({EqualRegex}\s+(या)?\s+{MoreRegex})|({MoreOrEqualPrefix}\s+(या)?\s+{EqualRegex})|({EqualRegex}\s+(या)?\s+{MoreOrEqualPrefix})|>\s*=)";
      public static readonly string MoreOrEqualNew = $@"(?:({MoreOrEqualPrefix}(\s+(या)?\s+{EqualRegex})?)|(({EqualRegex}\s+(या)?\s+)?{MoreOrEqualPrefix})|>\s*=)";
      public const string MoreOrEqualSuffix = @"((और|या)\s+((((?!(उससे|से)\s+)|((?!(\d+\s*))(उससे|से)))(ज़्यादा\s*बड़ी|ज़्यादा(?!\s+से\s+ज़्यादा)|बड़ी|अधिक))|((?!(उससे|से|के)\s+)(ऊपर|पार))))";
      public static readonly string LessOrEqualPrefix = $@"(({MoreRegex}\s*नहीं)|(ज़्यादा\s+से\s+ज़्यादा)|तक)";
      public static readonly string LessOrEqual = $@"({LessOrEqualPrefix}|({LessRegex}\s+(या)?\s+{EqualRegex})|({EqualRegex}\s+(या)?\s+{LessRegex})|({LessOrEqualPrefix}\s+(या)?\s+{EqualRegex})|({EqualRegex}\s+(या)?\s+{LessOrEqualPrefix})|<\s*=)";
      public static readonly string LessOrEqualNew = $@"(({LessOrEqualPrefix}(\s+(या)?\s+{EqualRegex})?)|(({EqualRegex}\s+(या)?\s+)?{LessOrEqualPrefix})|<\s*=)";
      public const string LessOrEqualSuffix = @"((और|या)\s+((?!(उससे|उसके|से|के)\s+)|((?!(\d+\s*))(उससे|उसके|से|के)\s+))(कम(?!\s+से\s+कम)|छोटी|नीचे))";
      public const string NumberSplitMark = @"(?![,.](?!\d+))";
      public const string MoreRegexNoNumberSucceed = @"(((?!(उससे|से)\s+)|((?!(\d+\s*))(उससे|से))\s+)(ज़्यादा(\s*बड़ी)?|बड़ी|अधिक)|(?!(\d+\s*))(ऊपर|पार))";
      public const string LessRegexNoNumberSucceed = @"(((?!(उससे|उसके|से|के)\s+)|((?!(\d+\s*))(उससे|उसके|से|के))\s+)(कम|छोटी|नीचे)|(?!(\d+\s*))(कम|नीचे))";
      public const string EqualRegexNoNumberSucceed = @"(((?!(उसके|इसके|के)\s+)|((?!(\d+\s*))(उसके|इसके|के)\s+))(समान|बराबर))";
      public static readonly string NumberGroupCondition1 = $@"(((-|माइनस|निगेटिव)\s*)?(\b(?<![/-])(\d+\,?)+(?![/-])\b|{FractionNotationRegex}|{FractionNounWithArticleRegex}|{AllIntRegex}))";
      public static readonly string NumberGroupCondition2 = $@"({NumberGroupCondition1}\s+में\s+से\s+{NumberGroupCondition1}|{NumberGroupCondition1})";
      public static readonly string OneNumberRangeMoreRegex0 = $@"({MoreOrEqualNew}|{MoreRegex})\s*(?<number1>({NumberSplitMark}.)+)(\s+(या)?\s+{EqualRegex})|({MoreOrEqualNew}|{MoreRegex})\s*(?<number1>({NumberSplitMark}.)+)";
      public static readonly string OneNumberRangeMoreRegex1 = $@"(?<number1>({NumberSplitMark}.)+)\s*साल\s*({MoreRegex}|{MoreOrEqualNew})|(?<number1>{NumberGroupCondition2})\s*({MoreRegex}|{MoreOrEqualNew})";
      public static readonly string OneNumberRangeMoreRegex2 = $@"(?<number1>({NumberSplitMark}.)+)\s*{MoreOrEqualSuffix}";
      public static readonly string OneNumberRangeMoreSeparateRegex = $@"((?<number1>({NumberSplitMark}.)+)\s+{EqualRegex}(\s+या\s+){MoreRegexNoNumberSucceed})|((?<number1>({NumberSplitMark}.)+)\s+{MoreRegex}(\s+या\s+){EqualRegexNoNumberSucceed})";
      public static readonly string OneNumberRangeLessRegex0 = $@"({LessOrEqualNew}|{LessRegex})\s*(?<number2>({NumberSplitMark}.)+)(\s+(या)?\s+{EqualRegex})|({LessOrEqualNew}|{LessRegex})\s*(?<number2>({NumberSplitMark}.)+)";
      public static readonly string OneNumberRangeLessRegex1 = $@"(?<number2>({NumberSplitMark}.)+)\s*साल\s*({LessRegex}|{LessOrEqualNew})|(?<number2>{NumberGroupCondition2})\s*({LessRegex}|{LessOrEqualNew})";
      public static readonly string OneNumberRangeLessRegex2 = $@"(?<number2>({NumberSplitMark}.)+)\s*{LessOrEqualSuffix}";
      public static readonly string OneNumberRangeLessSeparateRegex = $@"((?<number2>({NumberSplitMark}.)+)\s*{EqualRegex}(\s+या\s+){LessRegexNoNumberSucceed})|((?<number2>({NumberSplitMark}.)+)\s*{LessRegex}(\s+या\s+){EqualRegexNoNumberSucceed})";
      public static readonly string OneNumberRangeEqualRegex = $@"(?<number1>({NumberSplitMark}.)+)\s*साल\s*{EqualRegex}|(?<number1>{NumberGroupCondition2})\s*{EqualRegex}";
      public static readonly string TwoNumberRangeRegex1 = $@"(?<number1>({NumberSplitMark}.)+)\s*और\s*(?<number2>({NumberSplitMark}.)+)\s*के\s*बीच";
      public static readonly string TwoNumberRangeRegex2 = $@"({OneNumberRangeMoreSeparateRegex}|{OneNumberRangeMoreRegex0}|{OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})\s*(है\s*)?(और|पर|,)\s*({OneNumberRangeLessSeparateRegex}|{OneNumberRangeLessRegex0}|{OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})";
      public static readonly string TwoNumberRangeRegex3 = $@"({OneNumberRangeLessSeparateRegex}|{OneNumberRangeLessRegex0}|{OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})\s*(है\s*)?(और|पर|,)\s*({OneNumberRangeMoreSeparateRegex}|{OneNumberRangeMoreRegex0}|{OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})";
      public static readonly string TwoNumberRangeRegex4 = $@"(?<number1>({NumberSplitMark}(?!\b\s+से\b).)+)\s*{TillRegex}\s*(हरेक|लेकर)?\s*(?<number2>({NumberSplitMark}.)+)";
      public const string AmbiguousFractionConnectorsRegex = @"(\bमें(?![\u0900-\u097f]))";
      public const char DecimalSeparatorChar = '.';
      public const string FractionMarkerToken = @"भाग";
      public const char NonDecimalSeparatorChar = ',';
      public const string HalfADozenText = @"छह";
      public const string WordSeparatorToken = @"और";
      public static readonly string[] WrittenDecimalSeparatorTexts = { @"पॉइंट", @"दशमलव" };
      public static readonly string[] WrittenGroupSeparatorTexts = { @"कोमा" };
      public static readonly string[] WrittenIntegerSeparatorTexts = { @"और" };
      public static readonly string[] WrittenFractionSeparatorTexts = { @"और" };
      public const string HalfADozenRegex = @"(आधा\s+)दर्जन";
      public static readonly string DigitalNumberRegex = $@"((?<=\b)(सौ|हजार|हज़ार|लाख|करोड़|अरब|खरब|दर्जन|हंड्रेड|थाउजेंड|मिलियन|बिलियन|ट्रिलियन|hundred|thousand|million|billion|trillion))|((?<=(\d|\b)){BaseNumbers.MultiplierLookupRegex}(?=\b))";
      public static readonly Dictionary<string, long> CardinalNumberMap = new Dictionary<string, long>
        {
            { @"शून्य", 0 },
            { @"एक", 1 },
            { @"दो", 2 },
            { @"तीन", 3 },
            { @"फ़ोर", 4 },
            { @"चार", 4 },
            { @"पाँच", 5 },
            { @"पांच", 5 },
            { @"छह", 6 },
            { @"सात", 7 },
            { @"आठ", 8 },
            { @"नौ", 9 },
            { @"दस", 10 },
            { @"ग्यारह", 11 },
            { @"बारह", 12 },
            { @"दर्जन", 12 },
            { @"दर्जनों", 12 },
            { @"डज़न", 12 },
            { @"तेरह", 13 },
            { @"चौदह", 14 },
            { @"पंद्रह", 15 },
            { @"सोलह", 16 },
            { @"सत्रह", 17 },
            { @"अठारह", 18 },
            { @"उन्नीस", 19 },
            { @"बीस", 20 },
            { @"इक्कीस", 21 },
            { @"बाईस", 22 },
            { @"बाइस", 22 },
            { @"तेईस", 23 },
            { @"तेइस", 23 },
            { @"चौबीस", 24 },
            { @"पच्चीस", 25 },
            { @"छब्बीस", 26 },
            { @"सत्ताईस", 27 },
            { @"सत्ताइस", 27 },
            { @"अट्ठाईस", 28 },
            { @"अट्ठाइस", 28 },
            { @"उनतीस", 29 },
            { @"तीस", 30 },
            { @"इकतीस", 31 },
            { @"इकत्तीस", 31 },
            { @"बत्तीस", 32 },
            { @"तैंतीस", 33 },
            { @"चौंतीस", 34 },
            { @"पैंतीस", 35 },
            { @"पैंतीसवां", 35 },
            { @"छ्त्तीस", 36 },
            { @"सैंतीस", 37 },
            { @"अड़तीस", 38 },
            { @"उनतालीस", 39 },
            { @"चालीस", 40 },
            { @"इकतालीस", 41 },
            { @"बयालीस", 42 },
            { @"तैंतालीस", 43 },
            { @"चौंतालीस", 44 },
            { @"पैंतालीस", 45 },
            { @"छियालीस", 46 },
            { @"सैंतालीस", 47 },
            { @"अड़तालीस", 48 },
            { @"उनचास", 49 },
            { @"पचास", 50 },
            { @"इक्याबन", 51 },
            { @"बावन", 52 },
            { @"तिरेपन", 53 },
            { @"चौबन", 54 },
            { @"पचपन", 55 },
            { @"छप्पन", 56 },
            { @"सत्तावन", 57 },
            { @"अट्ठावन", 58 },
            { @"उनसठ", 59 },
            { @"साठ", 60 },
            { @"एकसठ", 61 },
            { @"इकसठ", 61 },
            { @"बासठ", 62 },
            { @"तिरसठ", 63 },
            { @"चौंसठ", 64 },
            { @"पैंसठ", 65 },
            { @"छियासठ", 66 },
            { @"सड़सठ", 67 },
            { @"सड़सठ", 67 },
            { @"अड़सठ", 68 },
            { @"उनहत्तर", 69 },
            { @"सत्तर", 70 },
            { @"इकहत्तर", 71 },
            { @"बहत्तर", 72 },
            { @"तिहत्तर", 73 },
            { @"चौहत्तर", 74 },
            { @"पचहत्तर", 75 },
            { @"छिहत्तर", 76 },
            { @"सतहत्तर", 77 },
            { @"अठहत्तर", 78 },
            { @"अठत्तर", 78 },
            { @"उनासी", 79 },
            { @"अस्सी", 80 },
            { @"इक्यासी", 81 },
            { @"बयासी", 82 },
            { @"तिरासी", 83 },
            { @"चौरासी", 84 },
            { @"पचासी", 85 },
            { @"छियासी", 86 },
            { @"सतासी", 87 },
            { @"अठासी", 88 },
            { @"नवासी", 89 },
            { @"नब्बे", 90 },
            { @"इक्यानबे", 91 },
            { @"बानवे", 92 },
            { @"तिरानवे", 93 },
            { @"चौरानवे", 94 },
            { @"पचानवे", 95 },
            { @"पंचानबे", 95 },
            { @"छियानवे", 96 },
            { @"सत्तानवे", 97 },
            { @"अट्ठानवे", 98 },
            { @"निन्यानवे", 99 },
            { @"सौ", 100 },
            { @"हजार", 1000 },
            { @"हज़ार", 1000 },
            { @"लाख", 100000 },
            { @"करोड़", 10000000 },
            { @"अरब", 1000000000 },
            { @"खरब", 100000000000 },
            { @"हंड्रेड", 100 },
            { @"थाउजेंड", 1000 },
            { @"मिलियन", 1000000 },
            { @"बिलियन", 1000000000 },
            { @"ट्रिलियन", 1000000000000 },
            { @"hundred", 100 },
            { @"thousand", 1000 },
            { @"million", 1000000 },
            { @"billion", 1000000000 },
            { @"trillion", 1000000000000 },
            { @"one", 1 },
            { @"two", 2 },
            { @"three", 3 },
            { @"four", 4 },
            { @"five", 5 },
            { @"six", 6 },
            { @"seven", 7 },
            { @"eight", 8 },
            { @"nine", 9 },
            { @"ten", 10 },
            { @"eleven", 11 },
            { @"twelve", 12 },
            { @"thirteen", 13 },
            { @"fourteen", 14 },
            { @"fifteen", 15 },
            { @"sixteen", 16 },
            { @"seventeen", 17 },
            { @"eighteen", 18 },
            { @"nineteen", 19 },
            { @"twenty", 20 },
            { @"thirty", 30 },
            { @"forty", 40 },
            { @"fifty", 50 },
            { @"sixty", 60 },
            { @"seventy", 70 },
            { @"eighty", 80 },
            { @"ninety", 90 },
            { @"वन", 1 },
            { @"टू", 2 },
            { @"थ्री", 3 },
            { @"फोर", 4 },
            { @"फ़ाइव", 5 },
            { @"सिक्स", 6 },
            { @"सेवन", 7 },
            { @"एइट", 8 },
            { @"नैन", 9 },
            { @"टेन", 10 },
            { @"इलेवन", 11 },
            { @"ट्वेल्व", 12 },
            { @"थर्टीन", 13 },
            { @"फ़ोर्टीन", 14 },
            { @"फ़िफ़्टीन", 15 },
            { @"सिक्सटीन", 16 },
            { @"सेवेनटीन", 17 },
            { @"एइटीन", 18 },
            { @"नईनटीन", 19 },
            { @"ट्वेन्टी", 20 },
            { @"ट्वेंटी", 20 },
            { @"थर्टी", 30 },
            { @"फ़ोर्टी", 40 },
            { @"फ़िफ़्टी", 50 },
            { @"सिक्सटी", 60 },
            { @"सेवेंटी", 70 },
            { @"एइट्टी", 80 },
            { @"नैनटी", 90 }
        };
      public static readonly Dictionary<string, long> OrdinalNumberMap = new Dictionary<string, long>
        {
            { @"प्रथम", 1 },
            { @"पहला", 1 },
            { @"पहले", 1 },
            { @"पहली", 1 },
            { @"दूसरा", 2 },
            { @"दूसरे", 2 },
            { @"दूसरी", 2 },
            { @"आधा", 2 },
            { @"आधे", 2 },
            { @"तीसरा", 3 },
            { @"तीसरी", 3 },
            { @"तिहाई", 3 },
            { @"तीसरे", 3 },
            { @"चौथा", 4 },
            { @"चौथी", 4 },
            { @"चौथाई", 4 },
            { @"छठवा", 6 },
            { @"साँतवा", 7 },
            { @"आँठवा", 8 },
            { @"इकत्तीसवां", 31 },
            { @"फ़र्स्ट", 1 },
            { @"सेकेंड", 2 },
            { @"थर्ड", 3 },
            { @"फोर्थ", 4 },
            { @"फिफ्थ", 5 },
            { @"पाँचवाँ", 5 },
            { @"पांचवां", 5 },
            { @"सिक्स्थ", 6 },
            { @"सेवंथ", 7 },
            { @"एइथ", 8 },
            { @"नाइन्थ", 9 },
            { @"इलेवेन्थ", 11 },
            { @"ट्वेल्फ्थ", 12 },
            { @"थरटीन्थ", 13 },
            { @"फोर्टीन्थ", 14 },
            { @"फिफ्टीन्थ", 15 },
            { @"सिक्सटीन्थ", 16 },
            { @"सेवेंटीन्थ", 17 },
            { @"एइटीन्थ", 18 },
            { @"नाइटीन्थ", 19 },
            { @"टेन्थ", 10 },
            { @"ट्वेन्टीएथ", 20 },
            { @"ट्वेंटीएथ", 20 },
            { @"थरटिएथ", 30 },
            { @"फ़ोर्टीएथ", 40 },
            { @"फ़िफ़्टीएथ", 50 },
            { @"सिक्सटिएथ", 60 },
            { @"सेवेंटिएथ", 70 },
            { @"एइटिएथ", 80 },
            { @"नैनटिएथ", 90 },
            { @"हंड्रेडथ", 100 },
            { @"थाउजेंडथ", 1000 },
            { @"मिलियनथ", 1000000 },
            { @"बिलियनथ", 1000000000 },
            { @"ट्रिलियनथ", 1000000000000 },
            { @"first", 1 },
            { @"second", 2 },
            { @"third", 3 },
            { @"fifth", 5 },
            { @"ninth", 9 },
            { @"twelfth", 12 },
            { @"twentieth", 20 },
            { @"thirtieth", 30 },
            { @"fortieth", 40 },
            { @"fiftieth", 50 },
            { @"sixtieth", 60 },
            { @"seventieth", 70 },
            { @"eightieth", 80 },
            { @"ninetieth", 90 }
        };
      public static readonly Dictionary<string, long> RoundNumberMap = new Dictionary<string, long>
        {
            { @"सौ", 100 },
            { @"सैकड़ा", 100 },
            { @"हजार", 1000 },
            { @"हज़ार", 1000 },
            { @"लाख", 100000 },
            { @"करोड़", 10000000 },
            { @"अरब", 1000000000 },
            { @"खरब", 100000000000 },
            { @"हंड्रेड", 100 },
            { @"थाउजेंड", 1000 },
            { @"मिलियन", 1000000 },
            { @"बिलियन", 1000000000 },
            { @"ट्रिलियन", 1000000000000 },
            { @"hundred", 100 },
            { @"thousand", 1000 },
            { @"million", 1000000 },
            { @"billion", 1000000000 },
            { @"trillion", 1000000000000 },
            { @"दर्जन", 12 },
            { @"दर्जनों", 12 },
            { @"डज़न", 12 },
            { @"k", 1000 }
        };
      public static readonly Dictionary<string, double> DecimalUnitsMap = new Dictionary<string, double>
        {
            { @"डेढ", 1.5 },
            { @"डेढ़", 1.5 },
            { @"डेढ़", 1.5 },
            { @"सवा", 1.25 },
            { @"सावा", 1.25 },
            { @"ढाई", 2.5 }
        };
      public static readonly Dictionary<char, long> ZeroToNineMap = new Dictionary<char, long>
        {
            { '०', 0 },
            { '१', 1 },
            { '२', 2 },
            { '३', 3 },
            { '४', 4 },
            { '५', 5 },
            { '६', 6 },
            { '७', 7 },
            { '८', 8 },
            { '९', 9 }
        };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"\bone\b", @"\b(the|this|that|which)\s+(one)\b" }
        };
      public static readonly Dictionary<string, string> RelativeReferenceOffsetMap = new Dictionary<string, string>
        {
            { @"अंतिम", @"0" },
            { @"आखिरी", @"0" },
            { @"अगला", @"1" },
            { @"अगले", @"1" },
            { @"अगली", @"1" },
            { @"पिछला", @"-1" },
            { @"पिछले", @"-1" },
            { @"पिछली", @"-1" },
            { @"वर्तमान", @"0" },
            { @"पिछला वाला", @"-1" },
            { @"पिछले वाले", @"-1" },
            { @"पिछली वाली", @"-1" },
            { @"अगला वाला", @"1" },
            { @"अगले वाले", @"1" },
            { @"अगली वाली", @"1" },
            { @"अंतिम वाला", @"0" },
            { @"अंतिम वाले", @"0" },
            { @"अंतिम वाली", @"0" },
            { @"आखिरी वाला", @"0" },
            { @"आखिरी वाले", @"0" },
            { @"आखिरी वाली", @"0" },
            { @"अभी वाला", @"0" },
            { @"आखिरी से पहला", @"-1" },
            { @"आखिरी से पहले", @"-1" },
            { @"आखिरी से पहली", @"-1" },
            { @"आखिरी से दूसरा", @"-2" },
            { @"आखिरी से दूसरे", @"-2" },
            { @"आखिरी से दूसरी", @"-2" },
            { @"आखिरी का पहला", @"0" },
            { @"आखिरी के पहले", @"0" },
            { @"आखिरी की पहली", @"0" },
            { @"आखिरी का दूसरा", @"-1" },
            { @"आखिरी के दूसरे", @"-1" },
            { @"आखिरी की दूसरी", @"-1" },
            { @"अंतिम से दूसरा", @"-1" },
            { @"अंतिम से दूसरे", @"-1" },
            { @"अंतिम से दूसरी", @"-1" },
            { @"अंतिम का पहला", @"0" },
            { @"अंतिम के पहले", @"0" },
            { @"अंतिम की पहली", @"0" },
            { @"अंतिम का दूसरा", @"-1" },
            { @"अंतिम के दूसरे", @"-1" },
            { @"अंतिम की दूसरी", @"-1" },
            { @"आखिरी का", @"0" },
            { @"आखिरी के", @"0" },
            { @"आखिरी की", @"0" },
            { @"अंतिम का", @"0" },
            { @"अंतिम के", @"0" },
            { @"अंतिम की", @"0" },
            { @"आखिरी से पहले का", @"-1" },
            { @"अंतिम से पहले का", @"-1" },
            { @"आखिरी के बगल वाला", @"-1" },
            { @"अंतिम के बगल वाला", @"-1" },
            { @"आखिरी वाले का पिछला वाला", @"-1" },
            { @"अंतिम वाले का पिछला वाला", @"-1" },
            { @"आखिरी वाले का पिछला", @"-1" },
            { @"अंतिम वाले का पिछला", @"-1" },
            { @"आखिरी वाले से पहले वाला", @"-1" },
            { @"अंतिम वाले से पहले वाला", @"-1" },
            { @"अगली चीज", @"1" },
            { @"पिछला पर केवल एक", @"-1" },
            { @"लास्ट", @"0" },
            { @"प्रीवियस", @"-1" },
            { @"नेक्स्ट", @"1" },
            { @"करेंट", @"0" },
            { @"last", @"0" },
            { @"previous", @"-1" },
            { @"next", @"1" },
            { @"current", @"0" }
        };
      public static readonly Dictionary<string, string> RelativeReferenceRelativeToMap = new Dictionary<string, string>
        {
            { @"अंतिम", @"end" },
            { @"आखिरी", @"end" },
            { @"अगला", @"current" },
            { @"अगली", @"current" },
            { @"अगले", @"current" },
            { @"पिछला", @"current" },
            { @"पिछले", @"current" },
            { @"पिछली", @"current" },
            { @"वर्तमान", @"current" },
            { @"पिछला वाला", @"current" },
            { @"पिछले वाले", @"current" },
            { @"पिछली वाली", @"current" },
            { @"अगला वाला", @"current" },
            { @"अगले वाले", @"current" },
            { @"अगली वाली", @"current" },
            { @"अभी वाला", @"current" },
            { @"अंतिम वाला", @"end" },
            { @"अंतिम वाले", @"end" },
            { @"अंतिम वाली", @"end" },
            { @"आखिरी वाला", @"end" },
            { @"आखिरी वाले", @"end" },
            { @"आखिरी वाली", @"end" },
            { @"आखिरी से पहला", @"end" },
            { @"आखिरी से पहले", @"end" },
            { @"आखिरी से पहली", @"end" },
            { @"आखिरी से दूसरा", @"end" },
            { @"आखिरी से दूसरे", @"end" },
            { @"आखिरी से दूसरी", @"end" },
            { @"आखिरी का पहला", @"end" },
            { @"आखिरी के पहले", @"end" },
            { @"आखिरी की पहली", @"end" },
            { @"आखिरी का दूसरा", @"end" },
            { @"आखिरी के दूसरे", @"end" },
            { @"आखिरी की दूसरी", @"end" },
            { @"अंतिम से पहला", @"end" },
            { @"अंतिम से पहले", @"end" },
            { @"अंतिम से पहली", @"end" },
            { @"अंतिम से दूसरा", @"end" },
            { @"अंतिम से दूसरे", @"end" },
            { @"अंतिम से दूसरी", @"end" },
            { @"अंतिम का पहला", @"end" },
            { @"अंतिम के पहले", @"end" },
            { @"अंतिम की पहली", @"end" },
            { @"अंतिम का दूसरा", @"end" },
            { @"अंतिम के दूसरे", @"end" },
            { @"अंतिम की दूसरी", @"end" },
            { @"आखिरी का", @"end" },
            { @"आखिरी के", @"end" },
            { @"आखिरी की", @"end" },
            { @"अंतिम का", @"end" },
            { @"अंतिम के", @"end" },
            { @"अंतिम की", @"end" },
            { @"आखिरी से पहले का", @"end" },
            { @"अंतिम से पहले का", @"end" },
            { @"आखिरी के बगल वाला", @"end" },
            { @"अंतिम के बगल वाला", @"end" },
            { @"आखिरी वाले का पिछला वाला", @"end" },
            { @"अंतिम वाले का पिछला वाला", @"end" },
            { @"आखिरी वाले का पिछला", @"end" },
            { @"अंतिम वाले का पिछला", @"end" },
            { @"आखिरी वाले से पहले वाला", @"end" },
            { @"अंतिम वाले से पहले वाला", @"end" },
            { @"अगली चीज", @"current" },
            { @"पिछला पर केवल एक", @"end" },
            { @"लास्ट", @"end" },
            { @"प्रीवियस", @"current" },
            { @"नेक्स्ट", @"current" },
            { @"करेंट", @"current" },
            { @"last", @"end" },
            { @"previous", @"current" },
            { @"next", @"current" },
            { @"current", @"current" }
        };
    }
}