﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Hindi\Hindi-DateTime.yaml
//     - Language: Hindi
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Hindi
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Hin";
      public const bool CheckBothBeforeAfter = true;
      public static readonly string TillRegex = $@"(?<till>\b(तक|द्वारा|से\s+लेकर|(तारीख\s+)?से|to)|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string RangeConnectorRegex = $@"(?<and>\b(और|and|through|to|से\s+लेकर)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string RelativeRegex = @"\b(?<order>परसों\s+वापस\s+गय\s+था|अगला|अगले|अगली|दूसरे|आने\s+वा(ले|ला)|आगामी|पिछला|पिछले|पिछली|आखिरी|अंतिम|यह|इसी|इस|वर्तमान|अभी\s+(के|वाला)|इस|उस|चालू)";
      public const string StrictRelativeRegex = @"\b(?<order>अगला|अगले|अगली|दूसरे|आने\s+वा(ले|ला)|आगामी|पिछला|पिछली|पिछले|आखिरी|अंतिम|वर्तमान|अभी\s+(के|वाला)|इसी|इस|उस)";
      public const string UpcomingPrefixRegex = @"(((इस|इसी)\s+)?(आने\s+(वाले|वाला)|आगामी))";
      public static readonly string NextPrefixRegex = $@"\b(अगला|अगले|अगली|{UpcomingPrefixRegex}|{FutureSuffixRegex})";
      public static readonly string NextPrefixRegexNoWeek = $@"\b(अगला|अगले|अगली|{UpcomingPrefixRegex}|{FutureSuffixRegex})(?!\s+(सप्ताह|हफ्ते|हफ़्ते))";
      public const string AfterNextSuffixRegex = @"(के\s+बाद)";
      public const string PastPrefixRegex = @"(((इस|इसी)\s+)?पिछला|पिछले|पिछली|के बाद)";
      public static readonly string PreviousPrefixRegex = $@"(आखिरी|अंतिम|पिछला|पिछले|पिछली|{PastPrefixRegex})";
      public const string ThisPrefixRegex = @"((इस|इसी)|यह|वर्तमान|अभी\s+(के|वाला))";
      public const string RangePrefixRegex = @"(से\s+लेकर|से|(तक\s+)?के\s+बीच|(?<=के\s+)बीच|तक)";
      public const string CenturySuffixRegex = @"^(सन|सदी|शताब्दी)";
      public const string ReferencePrefixRegex = @"(उस|उसी)";
      public const string FutureSuffixRegex = @"\b((आने\s+वा(ले|ला)\s+)?(भविष्य|बाद)(\s+(में|मे))?|आज\s+से)";
      public const string PastSuffixRegex = @"^\b$";
      public const string DayRegex = @"(उस\s*)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?!\d+)(?:ला|ली|रा|था|वां|वीं|वें|वाँ|वा|ठा|th|nd|rd|st)?(?=तारीख|दिन)?";
      public const string ImplicitDayRegex = @"(उस\s*)?(?<day>(?:3[0-1]|[0-2]?\d))(?:ला|ली|रा|था|वां|वीं|वें|वाँ|वा|ठा)(?=\b|\s*(तारीख|दिन))?";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])\b";
      public const string WrittenOneToNineRegex = @"(?:सात|आठ|फ़ोर|चार|पांच|पाँच|नौ|दो|छह|एक|तीन)";
      public const string WrittenElevenToNineteenRegex = @"(?:सत्रह|तेरह|चौदह|अठारह|उन्नीस|पंद्रह|सोलह|ग्यारह|बारह)";
      public const string WrittenTwentyOneToTwentyNineIntegerRegex = @"(सत्ताईस|तेईस|चौबीस|अट्ठाईस|अट्ठाइस|उनतीस|पच्चीस|छब्बीस|इक्कीस|बाईस)";
      public const string WrittenThirtyOneToThirtyNineIntegerRegex = @"(सैंतीस|तैंतीस|चौंतीस|अड़तीस|उनतालीस|पैंतीस|छ्त्तीस|इकतीस|इकत्तीस|बत्तीस)";
      public const string WrittenFourtyOneToFourtyNineIntegerRegex = @"(सैंतालीस|तैंतालीस|चौंतालीस|अड़तालीस|उनचास|पैंतालीस|छियालीस|इकतालीस|बयालीस)";
      public const string WrittenFiftyOneToFiftyNineIntegerRegex = @"(सत्तावन|तिरेपन|चौबन|अट्ठावन|उनसठ|पचपन|छप्पन|इक्याबन|बावन)";
      public const string WrittenSixtyOneToSixtyNineIntegerRegex = @"((सड़|सड़|तिर|चौं|अड़|उनहत्तर|पैं|छिया|इक|बा|एक)(सठ))";
      public const string WrittenSeventyOneToSeventyNineIntegerRegex = @"(?:सतहत्तर|तिहत्तर|अठहत्तर|चौहत्तर|उनासी|पचहत्तर|छिहत्तर|इकहत्तर|अठत्तर|बहत्तर)";
      public const string WrittenEightyOneToEightyNineIntegerRegex = @"(सतासी|तिरासी|चौरासी|अठासी|नवासी|पचासी|छियासी|इक्यासी|बयासी)";
      public const string WrittenNinetyOneToNinetyNineIntegerRegex = @"(सत्तानवे|तिरानवे|चौरानवे|अट्ठानवे|निन्यानवे|पचानवे|पंचानबे|छियानवे|इक्यानबे|बानवे)";
      public const string WrittenTensRegex = @"(?:सत्तर|बीस|तीस|अस्सी|नब्बे|चालीस|पचास|साठ|दस)";
      public static readonly string AllWrittenNumericalRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTwentyOneToTwentyNineIntegerRegex}|{WrittenThirtyOneToThirtyNineIntegerRegex}|{WrittenFourtyOneToFourtyNineIntegerRegex}|{WrittenFiftyOneToFiftyNineIntegerRegex}|{WrittenSixtyOneToSixtyNineIntegerRegex}|{WrittenSeventyOneToSeventyNineIntegerRegex}|{WrittenEightyOneToEightyNineIntegerRegex}|{WrittenNinetyOneToNinetyNineIntegerRegex}|{WrittenTensRegex})";
      public static readonly string WrittenNumRegex = $@"(?:{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?|WrittenTwentyToTwentyNineIntegerRegex)";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?:(एक|दो)\s+(हजार|हज़ार)(\s+और)?(\s+{WrittenOneToNineRegex}(\s+सौ)?(\s+और)?)?)";
      public const string WrittenCenturyOrdinalYearRegex = @"(?:(बीस|इक्कीस|बाईस)(वां|वीं|वें|वाँ)?|(?:सत्रह|तेरह|चौदह|अठारह|उन्नीस|पंद्रह|सोलह|ग्यारह|बारह|दस)(वां|वीं|वें|वाँ)?|(सात|आठ|फ़ोर|चार|पांच|पाँच|नौ|दो|छह|एक|तीन)(वां|वीं|वें|वाँ)?)";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\s+सौ)?(\s+और)?)";
      public static readonly string LastTwoYearNumRegex = $@"(?:(शून्य\s+)?{AllWrittenNumericalRegex}|{WrittenTensRegex}(\s+(और\s+)?){WrittenOneToNineRegex})";
      public static readonly string FullTextYearRegex = $@"\b((?<firsttwoyearnum>{CenturyRegex})\s+(?<lasttwoyearnum>{LastTwoYearNumRegex})|\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\s+सौ(\s+और)?))";
      public const string OclockRegex = @"(?<oclock>अराउंड|लगभग|बजे|ओक्लॉक|o\s*((’|‘|')\s*)?clock)";
      public static readonly string AmDescRegex = $@"(?:{BaseDateTime.BaseAmDescRegex}|पू\.|सुबह|पूर्वाहन|ए\.एम\.|एएम)";
      public static readonly string PmDescRegex = $@"(:?{BaseDateTime.BasePmDescRegex}|अप\.|पीएम|पी\.एम\.|अपराह्न|अपराहन)";
      public static readonly string AmPmDescRegex = $@"(?:{BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(?:(?:({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex})))|{OclockRegex})";
      public static readonly string DescRegexA = $@"(?:(?:({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|(?:{BaseDateTime.BaseAmDescRegex})|(?:{BaseDateTime.BasePmDescRegex}))))|{OclockRegex})";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|{OclockRegex}|\.\d)))";
      public static readonly string YearRegex = $@"(?:{BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"\b(?<weekday>(?:रवि|इत|एत|सोम|मंगल|म्गल|गुरु|((बृ|वृ)हस्पति)|वीर|शुक्र)(वार)?|बुध(वार)?|बीफ़े|शनि(वार)?|संडे|मंडे)";
      public const string SingleWeekDayRegex = @"\b(?<weekday>रविवार|इतवार|एतवार|शनिवार|संडे|मंडे|(?:सोम|मंगल|म्गल|गुरु|((बृ|वृ)हस्पति)|वीर|शुक्र)(वार)?|बुध(वार)?|बीफ़े|((शनि|रवि)(?<=को\s+)))\b";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>{RelativeRegex}\s+(माह|महि(ने|ना)|महीनों|महीने)(\s+(का|की|के))?)";
      public static readonly string WrittenMonthRegex = $@"\b({MonthRegex}(\s+(का|के(?!\s+बीच)|की)(\s+(माह|महि(ने|ना)))?)?)";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>({RelativeMonthRegex}|{WrittenMonthRegex})(\s*(का|के|की))?)";
      public const string DateUnitRegex = @"(?<unit>(?<decade>decade|(?<plural>दशकों)|दशक|decades)|(?<year>साल|(?<plural>वर्षों)|वर्ष?)|(?<month>माह|(?<plural>महीनों|महीना)|महीने?)|(?<week>(?<plural>हफ़्तों|हफ्तों)|हफ़्ते|हफ्ता|(?!सप्ताहांत)सप्ताह?|हफ्ते)|(?<business>(व्यावसायिक|कार्य|व्यापारिक|व्यापार\s+के)\s?)?(?<day>(दिवस|(?<plural>दिनों)|दिन)|(?<=रो)ज|^ज$)|(?<fortnight>(?<plural>fortnights)fortnight|पखवाड़े|पखवाड़ा|पखवाड़े))";
      public const string DateTokenPrefix = @"को ";
      public const string TimeTokenPrefix = @"at ";
      public const string TokenBeforeDate = @"को|की";
      public const string TokenBeforeTime = @"at ";
      public const string HalfTokenRegex = @"^(साढ़े|साढ़े)";
      public const string QuarterTokenRegex = @"^(सव|पौने)";
      public const string ThreeQuarterTokenRegex = @"^(पैंतालीस)";
      public const string ToTokenRegex = @"\b(बाकी|पौने)$";
      public static readonly string SimpleCasesRegex = $@"\b((({YearRegex}(\s+|\s*,\s*))(में\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex}\s+{MonthSuffixRegex}|{MonthSuffixRegex}\s+{DayRegex})(?!\d+)(\s+{RangePrefixRegex})?)|(({DayRegex})\s*{TillRegex}\s*({DayRegex}\s+{MonthSuffixRegex}|{MonthSuffixRegex}\s+{DayRegex})(?!\d+)(\s+{RangePrefixRegex})?((\s+|\s*,\s*){YearRegex})?)|((?<!\d+[/\\\-\.]?)({YearRegex}(\s+|\s*,\s*)(के\s+)?{MonthSuffixRegex}\s+)?(में\s+)?({DayRegex})\s*{TillRegex}\s*{DayRegex}(?![/\\\-\.]?\d+)(\s+{RangePrefixRegex})?))";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b{MonthSuffixRegex}\s+({DayRegex})\s*{TillRegex}\s*({MonthSuffixRegex}\s+)?({DayRegex})(\s+{RangePrefixRegex})?((\s+|\s*,\s*){YearRegex})?";
      public const string NumberBeforeWeekRegex = @"(\d+ तारीख वाली सप्ताह)";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?(से|के बीच|बीच में|के बीच में)";
      public static readonly string BetweenRegex = $@"\b({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?(\s+(से|के बीच|बीच में|के बीच में))";
      public static readonly string MonthWithYear = $@"\b(({WrittenMonthRegex}[\.]?(\s*)[/\\\-\.,]?(\s+(का|में|मे))?(\s*)({YearRegex}|(?<order>अगला|अगले|अगली|आने\s+वा(ले|ला)|आगामी|इस|आखिरी|अंतिम)\s+साल))|(({YearRegex}|(?<order>अगला|अगले|अगली|आने\s+वा(ले|ला)|आगामी|इस|आखिरी|अंतिम)\s+साल)(\s+के)?(\s*),?(\s*){WrittenMonthRegex}))";
      public const string SpecialYearPrefixes = @"(calendar|(?<special>fiscal|school))";
      public static readonly string OneWordPeriodRegex = $@"\b(?<![\u0900-\u097f])((इस\s+)?((माह|महि(ने|ना))|साल) (दिन|आज) तक|({RelativeRegex}\s+)?(मेरा\s+)?(हफ़्ता|सप्ताहांत|वर्ष|हफ्ता|(?<!({AllWrittenNumericalRegex}|\d+)\s*)(सप्ताह|हफ्ते|हफ़्ते)|(माह|(?<!\d+\s+)((महि|मही)(ने|ना)))|(({SpecialYearPrefixes}\s+)?(?<!\d+\s+)साल))(?!((\s+(का|की|के))?\s+\d+(?!\s*({AmDescRegex}|{PmDescRegex}))|\s+(से|तक)\s+(तारीख|दिनांक|दिन|समय|तिथि)))(\s+{AfterNextSuffixRegex})?|(((इस|इसी)\s+)?({StrictRelativeRegex}\s+)?((?<month>अप्रील|अप्रैल|अप्र|अगस्त|अग|दिसम्बर|दिसंबर|दिसं|दिस|फरवरी|फ़रवरी|फर|फ़र|फ़ेब|फेब्रू|जनवरी|जन|जुलाई|जु|जुल|जून|जू|मार्च|मा|मई|नवंबर|नवम्बर|नवं|अक्तूबर|अक्टूबर|आक्ट|अक्टू|सितंबर|सितम्बर|सितं|सित)(\.|(?=[/\\.,-])|(?![\u0900-\u097f])))(\s+(का|की|के)\s+(माह|((महि|मही)(ने|ना))))?))";
      public static readonly string MonthNumWithYear = $@"\b(({BaseDateTime.FourDigitYearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-](\s*){BaseDateTime.FourDigitYearRegex}))";
      public static readonly string WeekOfMonthRegex = $@"\b(?<wom>{MonthSuffixRegex}(\s+({BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s*साल)\s*)?(\s*(का|के|की)\s*)?(?<cardinal>पहला|पहली|पहले|1st|दूसरा|दूसरे|दूसरी|2nd|तीसरा|तीसरे|तीसरी|3rd|चौथा|चौथी|4th|पाँचवाँ|पांचवां|5th|आखिरी|अंतिम)\s+(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह))(\s+में)?";
      public static readonly string WeekOfYearRegex = $@"\b(?<woy>({YearRegex}|{RelativeRegex}\s+(साल|वर्ष)))(\s+(का|की|के))?\s+(?<cardinal>पहला|पहली|पहले|1st|दूसरा|दूसरे|दूसरी|2nd|तीसरा|तीसरे|तीसरी|3rd|चौथा|चौथी|4th|पाँचवाँ|पांचवां|5th|आखिरी|अंतिम)\s+(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह)";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public static readonly string QuarterTermRegex = $@"\b(((?<cardinal>पहला|पहली|पहले|1st|दूसरा|दूसरे|दूसरी|2nd|तीसरा|तीसरे|तीसरी|3rd|चौथा|चौथी|4th)[ -]+तिमाही)(\s*{BaseDateTime.FourDigitYearRegex})?)";
      public static readonly string RelativeQuarterTermRegex = $@"\b(?<orderQuarter>{StrictRelativeRegex})\s+तिमाही\b";
      public static readonly string QuarterRegex = $@"((?:({YearRegex}|{RelativeRegex}\s*(साल|वर्ष)\s*)(\s*(का|की|के)|\s*,\s*)?\s+)?{QuarterTermRegex})|{RelativeQuarterTermRegex}";
      public static readonly string QuarterRegexYearFront = $@"(?:{YearRegex}|{RelativeRegex}\s+साल)(?:\s*-\s*|\s+(इस\s+)?)?{QuarterTermRegex}";
      public const string HalfYearTermRegex = @"(?<cardinal>पहली|1st|second|2nd)\s+half";
      public static readonly string HalfYearFrontRegex = $@"(?<year>((1[5-9]|20)\d{{2}})|2100)(\s*-\s*|\s+(the\s+)?)?h(?<number>[1-2])";
      public static readonly string HalfYearBackRegex = $@"(the\s+)?(h(?<number>[1-2])|({HalfYearTermRegex}))(\s+of|\s*,\s*)?\s+({YearRegex})";
      public static readonly string HalfYearRelativeRegex = $@"(the\s+)?{HalfYearTermRegex}(\s+of|\s*,\s*)?\s+({RelativeRegex}\s+साल)";
      public static readonly string AllHalfYearRegex = $@"({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})";
      public const string EarlyPrefixRegex = @"\b(?<EarlyPrefix>(?<RelEarly>पूर्व|(इससे|उससे) पहले)|((के|की)\s+)शुरुआत(?=\s+(में|के|मे))?|सवेरे|प्रारंभिक|early|beginning of|start of)";
      public const string MidPrefixRegex = @"\b(?<MidPrefix>के बीच|बीच के|बीच में|mid-?|बीच|के दौरान)";
      public const string LaterPrefixRegex = @"\b(?<LatePrefix>देर से|देरी से|के अंत|के खत्म|के बाद|(?<RelLate>बाद(?=\s+(में|के|मे))?))";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public const string PrefixDayRegex = @"\b(\s+the\s+day)(\s+in)??((?<EarlyPrefix>early)|(?<MidPrefix>mid(dle)?)|(?<LatePrefix>later?))$";
      public const string SeasonDescRegex = @"(?<seas>वसंत|spring|गर्मी|गर्मियों|fall|autumn|शरद\s+ऋतु|winter|सर्दियों)";
      public static readonly string SeasonRegex = $@"\b(?<season>({RelativeRegex}\s+)?(({YearRegex}|{RelativeRegex}\s+साल)(\s+(के|की)|\s*,\s*)?\s+)?{SeasonDescRegex})(\s+{PrefixPeriodRegex})?";
      public const string WhichWeekRegex = @"(\b(सप्ताह)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b)|(\b(?<number>5[0-3]|[1-4]\d|0?[1-9])(\s*(वें)?\s*)(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह(?!\s+में)))";
      public const string WeekOfRegex = @"(\s*(के|का|वाले|तारीख वाली)\s+)(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह)";
      public const string MonthOfRegex = @"(\s*(का|की|के)\s+)?((महि|मही(ने|ना))|माह)";
      public const string MonthRegex = @"\b(?<![\u0900-\u097f])(?<month>अप्रील|अप्रैल|अगस्त|मई|दिसम्बर|दिसंबर|फरवरी|जनवरी|जुलाई|जून|मार्च|नवंबर|नवम्बर|अक्तूबर|अक्टूबर|आक्ट|सितंबर|सितम्बर|(अप्र|अग|दिस|फर|फ़ेब|फेब्रू|फ़र|जन|जु|जू|मा|नवं|नव|अक्टू|सितं|सित)(\.|(?=[/\\.,-])|(?![\u0900-\u097f]))|(?<=(3[0-1]|[0-2]?\d)(ली)?\s+)(अप्र|अग|दिस|फर|फ़ेब|फेब्रू|फ़र|जन|जु|जू|मा|नवं|नव|अक्टू|सितं|सित))";
      public const string AmbiguousMonthP0Regex = @"\b((((!|\.|\?|,|;|)\s+|^)मे आई)|(आई|you|he|she|we|they)\s+मे|(मे\s+((((also|not|(also not)|well)\s+)?(be|ask|contain|constitute|e-?mail|take|have|result|involve|get|work|reply|differ))|(or मे नहीं))))";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})";
      public static readonly string YearSuffix = $@"(^(\s*तारीख)?,?\s*(सन\s+)?({DateYearRegex}|{FullTextYearRegex})|({DateYearRegex}|{FullTextYearRegex}),?\s*$)";
      public static readonly string OnRegex = $@"({DayRegex})(?=\b\s+को)";
      public const string RelaxedOnRegex = @"(?<day>(3[0-1]|[0-2]?\d)(?:ला|रा|था|वां|वीं|वें|वाँ|वा|ठा))(?=\s+(दिन\sको|तक|के|दिन|को))";
      public const string PrefixWeekDayRegex = @"(\s*([-—–]|(,?\s*(पर|में|के|को))))";
      public static readonly string ThisRegex = $@"\b(इस(\s*(हफ्ते|हफ़्ते|(?!सप्ताहांत)सप्ताह){PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}((\s+(का|की|के))?\s+इस\s*(हफ्ते|हफ़्ते)))";
      public static readonly string LastDateRegex = $@"\b({PreviousPrefixRegex}(\s*(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह){PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}(\s+((का|की|के)\s+)?(आखिरी|अंतिम)\s*(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह)))";
      public static readonly string NextDateRegex = $@"\b({NextPrefixRegex}(\s*(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह){PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}((\s+(का|की|के|को))?\s+(अगला|अगले|अगली|आने\s+वाले|आने\s+वाला)\s*(हफ़्ते|हफ्ते|(?!सप्ताहांत)सप्ताह)))";
      public static readonly string SpecialDayRegex = $@"(?<!([\u0900-\u097f]))(परसों\s+वापस\s+गया\s+था|कल\s+वापस\s+गया\s+था|परसों के\s+पहले|कल\s+के\s+बाद|(?<!\d+\s+)दिन\s+(पहले|बाद)(?!=\s+दिन)|((यह\s+)?({RelativeRegex}|मेरा)\s+दिन)|परसों|कल\b|आज(?!\s+आधी\s+रात)|उस\s+दिन)";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<day>परसों|\bकल\b|आज)\s+से\s+(?<number>{AllWrittenNumericalRegex})\s+दिन(\s+(बाद)?))";
      public static readonly string RelativeDayRegex = $@"\b(((the\s+)?{RelativeRegex}\s+दिन))";
      public const string SetWeekDayRegex = @"\b(?<prefix>को\s+)?(?<weekday>morning|afternoon|evening|night|रात|(sun|mon|tues|wednes|thurs|fri|satur)day)s\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>(the\s+)?({MonthSuffixRegex}\s+)(?<cardinal>पहला|पहली|पहले|1st|दूसरा|दूसरे|दूसरी|2nd|तीसरा|तीसरे|तीसरी|3rd|चौथा|चौथी|4th|पाँचवाँ|पांचवां|5th|आखिरी|अंतिम)\s+(तारीख|{WeekDayRegex}))";
      public static readonly string RelativeWeekDayRegex = $@"\b((अभी\s+से\s+अगले|अब\s+से|बाद|अगले)\s+{AllWrittenNumericalRegex}\s+{WeekDayRegex}(\s+के\s+बाद)?)";
      public static readonly string SpecialDate = $@"({DayRegex}(?=\s*(को|पर)))";
      public const string DatePreposition = @"\b(को|में)";
      public static readonly string DateExtractorYearTermRegex = $@"(\s+|\s*[/\\.,-]\s*|\s+(का|की|के|को)\s+){DateYearRegex}";
      public static readonly string DateExtractor1 = $@"((({DateYearRegex}(\s+|\s*,\s*|\s+(का|की|के|को)\s+))({MonthRegex}[\.]?\s*[/\\.,-]?\s*{DayRegex}(?!(\:)?\d+)))|(\b({WeekDayRegex}\s*[\(,-]?\s*)?(({MonthRegex}[\.]?\s*[/\\.,-]?\s*{DayRegex})|(\({MonthRegex}\s*[-.]\s*{DayRegex}\)))(\s*\))?(\s*\(\s*{WeekDayRegex}\s*\))?({DateExtractorYearTermRegex}\b)?))";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?({DayRegex}[\.]?(\s+|\s*[/\\.,-]\s*|\s+(का|की|के|को)\s+){MonthRegex}[\.]?((\s+|\s*[/\\.,-]\s*|\s+में\s+){DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[/\\.,\- ]\s*{DayRegex}(\s+|\s*[/\\.,-]\s*|\s+(का|की|के|को)\s+){MonthRegex}[\.]?)";
      public static readonly string DateExtractor4 = $@"\b{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}[\.]?\s*[/\\\-]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor5 = $@"\b{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"({StrictRelativeRegex}\s+)?({WeekDayRegex}\s+)?{MonthNumRegex}[\-\.]{DayRegex}(?![%])(?=\s+{DatePreposition})";
      public static readonly string DateExtractor7L = $@"\b({WeekDayRegex}\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])";
      public static readonly string DateExtractor7S = $@"\b({WeekDayRegex}\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{BaseDateTime.CheckDecimalRegex}(?![%])";
      public static readonly string DateExtractor8 = $@"(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({WeekDayRegex}\s+)?{DayRegex}[\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?![%])";
      public static readonly string DateExtractor9L = $@"\b({WeekDayRegex}\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{DateExtractorYearTermRegex}(?![%])";
      public static readonly string DateExtractor9S = $@"\b({WeekDayRegex}\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?![%])";
      public static readonly string DateExtractorA = $@"\b({WeekDayRegex}\s+)?({BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}|{MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex}|{DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string OfMonth = $@"^\s*{MonthRegex}(?=\s*(को|की)?)";
      public static readonly string MonthEnd = $@"({MonthRegex}(\s+की)?|{RelativeMonthRegex})\s*$";
      public static readonly string WeekDayEnd = $@"(इस\s+)?{WeekDayRegex}\s*,?\s*$";
      public const string WeekDayStart = @"^[\.]";
      public const string RangeUnitRegex = @"\b(?<unit>वर्षों|सालों|महीनों|(?!सप्ताहांत)सप्ताह|हफ़्ते)\b";
      public const string HourNumRegex = @"(?<hournum>शून्य|एक|दो|तीन|फ़ोर|चार|पांच|पाँच|छह|सात|आठ|नौ|दस|ग्यारह|बारह|तेरह|चौदह|पंद्रह|सोलह|सत्रह|अठारह|उन्नीस|बीस|इक्कीस|बाईस|तेईस|चौबीस|zero|one|two|three|five|eight|ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|twenty|वन|टू|थ्री|फोर|फ़ाइव|सिक्स|सेवन|एइट|नाइन|टेन|इलेवन|ट्वेल्व|थर्टीन|फ़ोर्टीन|फ़िफ़्टीन|सिक्सटीन|सेवेनटीन|एइटीन|नाइनटीन|ट्वेन्टी|ट्वेंटी)(?![\u0900-\u097f])";
      public const string MinuteNumRegex = @"(?<minnum>शून्य|एक|दो|तीन|फ़ोर|चार|पांच|पाँच|छह|सात|आठ|नौ|दस|ग्यारह|बारह|तेरह|चौदह|पंद्रह|सोलह|सत्रह|अठारह|उन्नीस|बीस|इक्कीस|बाईस|तेईस|चौबीस|पच्चीस|छब्बीस|सत्ताईस|अट्ठाईस|अट्ठाइस|उनतीस|तीस|इकतीस|इकत्तीस|बत्तीस|तैंतीस|चौंतीस|पैंतीस|छ्त्तीस|सैंतीस|अड़तीस|उनतालीस|चालीस|इकतालीस|बयालीस|तैंतालीस|चौंतालीस|पैंतालीस|पैंतालिस|पेंतालिस|छियालीस|सैंतालीस|अड़तालीस|उनचास|पचास|इक्याबन|बावन|तिरेपन|चौबन|पचपन|छप्पन|सत्तावन|अट्ठावन|उनसठ|ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|twenty|thirty|forty|fifty|one|two|three|five|eight|टेन|इलेवन|ट्वेल्व|थर्टीन|फ़ोर्टीन|फ़िफ़्टीन|सिक्सटीन|सेवेनटीन|एइटीन|नाइनटीन|ट्वेन्टी|ट्वेंटी|वन|टू|थ्री|फोर|फ़ाइव|सिक्स|सेवन|एइट|नाइन|थर्टी|फ़ोर्टी|फ़िफ़्टी)(?![\u0900-\u097f])";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>शून्य|एक|दो|तीन|फ़ोर|चार|पांच|पाँच|छह|सात|आठ|नौ|दस|ग्यारह|बारह|तेरह|चौदह|पंद्रह|सोलह|सत्रह|अठारह|उन्नीस|बीस|इक्कीस|बाईस|तेईस|चौबीस|पच्चीस|छब्बीस|सत्ताईस|अट्ठाईस|अट्ठाइस|उनतीस|तीस|इकतीस|इकत्तीस|बत्तीस|तैंतीस|चौंतीस|पैंतीस|छ्त्तीस|सैंतीस|अड़तीस|उनतालीस|चालीस|इकतालीस|बयालीस|तैंतालीस|चौंतालीस|पैंतालीस|पैंतालिस|पेंतालिस|छियालीस|सैंतालीस|अड़तालीस|उनचास|पचास|इक्याबन|बावन|तिरेपन|चौबन|पचपन|छप्पन|सत्तावन|अट्ठावन|उनसठ|ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|twenty|thirty|forty|fifty|one|two|three|five|eight|टेन|इलेवन|ट्वेल्व|थर्टीन|फ़ोर्टीन|फ़िफ़्टीन|सिक्सटीन|सेवेनटीन|एइटीन|नाइनटीन|ट्वेन्टी|ट्वेंटी|वन|टू|थ्री|फोर|फ़ाइव|सिक्स|सेवन|एइट|नाइन|थर्टी|फ़ोर्टी|फ़िफ़्टी)";
      public const string PmRegex = @"(?<pm>(दोपहर\s+)?खाने\s+के\s+वक़्त\s+तक|(दोपहर|सायं|शामों|शाम|संध्या|सायंकाल|evening|((आधी|अर्ध)\s+)?रात)(\s+((के(?!\s+लिए)|को|में|की)(?!\s+दौरान)|(?=(\s+(के|को|में|की)\s+दौरान))))?|आधी\s*(-\s*)?रात|अर्ध\s*(-\s*)?रात्रि|लंचटाइम|लंच\s+के\s+समय|दोपहर\s+खाने\s+के\s+समय)";
      public const string RangePmRegex = @"(?<pm>(दोपहर\s+)?खाने\s+के\s+वक़्त\s+तक|(दोपहर|सायं|शामों|शाम|संध्या|सायंकाल|evening|(अर्ध\s+)?रात)(\s+((के(?!\s+लिए)|को|में|की)(?!\s+दौरान)|(?=(\s+(के|को|में|की)\s+दौरान))))?|अर्ध\s*(-\s*)?रात्रि|लंचटाइम|लंच\s+के\s+समय|दोपहर\s+खाने\s+के\s+समय)";
      public const string PmRegexFull = @"(?<pm>(दोपहर\s+)?खाने\s+के\s+वक़्त\s+तक|(दोपहर|सायं|शामों|शाम|संध्या|सायंकाल|अपराह्न|अपराहन|evening|((आधी|अर्ध)\s+)?रात)(\s+((के(?!\s+लिए)|को|में|की)(?!\s+दौरान)|(?=(\s+(के|को|में|की)\s+दौरान))))?|आधी\s*(-\s*)?रात|अर्ध\s*(-\s*)?रात्रि|लंचटाइम|लंच\s+के\s+समय)";
      public const string AmRegex = @"(?<am>सवेरे|पूर्वाह्न|(सुबह(?!\s+(के\s+दौरान))|morning|दिन(?!\s+हैं)|पूर्वाहन|प्रातः)(\s*(-सुबह|(?:के|को|में|की)))?)";
      public const string LunchRegex = @"(खाने\s+के\s+वक़्त\s+तक|लंचटाइम|लंच\s+के\s+समय)";
      public const string NightRegex = @"((आधी\s*(-\s*)?)?रात|अर्ध\s*(-\s*)?रात्रि)";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public static readonly string LessThanOneHour = $@"(?<lth>सवा|पौने|साढ़े|साढ़े|{BaseDateTime.DeltaMinuteRegex}(\s+(मिनट?|मि\.?|घण्टे))|{DeltaMinuteNumRegex}(\s+(मिनट?|मि\.?|घण्टे)))";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s+({MinuteNumRegex}|(?<tens>बीस|तीस|चालीस|पचास|twenty|thirty|fou?rty|fifty)\s+{MinuteNumRegex}))";
      public static readonly string TimePrefix = $@"(?<prefix>((बजकर|बजने\s+(में|से))\s+)?{LessThanOneHour}(\s+(बाकी|पहले|होने के\s+{MinuteNumRegex}\s+मिनट\s+बाद))?)";
      public static readonly string TimeSuffix = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string TimeSuffixFull = $@"(?<suffix>{AmRegex}|{PmRegexFull}|{OclockRegex})";
      public static readonly string BasicTime = $@"\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex}(?![%\d]))";
      public const string MidnightRegex = @"(?<midnight>आधी\s*(-\s*)?रात|अर्ध\s*(-\s*)?रात्रि|मध्य\s*रात्रि)";
      public const string MidmorningRegex = @"(?<midmorning>(मध्य|बीच)\s*(-\s*)?सुबह|दिन\s+चढ़ने\s+से\s+पूर्व)";
      public const string MidafternoonRegex = @"(?<midafternoon>देर\s*दोपहर|दोपहर(\s*(देर|के\s*आसपास))|भरी\s*दुपहरी)";
      public const string MiddayRegex = @"(?<midday>दिन\s*के\s*मध्य|दिन\s*के\s*बीच|दोपहर\s+में|दोपहर(\s+के\s+खाने\s+के\s+वक़्त)?(\s*(12|बारह)\s*बजे)?|मध्याह्न|दिन\s+(के\s+)?चढ़ते\s+ही|दिन\s+चढ़ने\s+पर)";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidafternoonRegex}|{MiddayRegex}|{MidnightRegex}|{MidmorningRegex}))";
      public static readonly string AtRegex = $@"\b(?:(?<=\bकी\s+)(?:{MidTimeRegex}|{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\.\d))|{MidTimeRegex})";
      public static readonly string IshRegex = $@"\b({BaseDateTime.HourRegex}((-|——)?ish|दोपहर(\s*((के\s*आसपास)|देर))?|(\s+बजे)?\s+के\s+आसपास)|लगभग\s+लंच\s+के\s+समय)";
      public const string TimeUnitRegex = @"([\u0900-\u097f]{1,}|\b)(?<unit>h(ou)?r|h|(?<plural>घंटों|घंटे|घंटा|आर्स|सेकंड्स|घण्टों|मिनटों|seconds|hours)|मिनट|सेकंड|sec(ond)?)";
      public const string RestrictedTimeUnitRegex = @"(?<unit>hour|घंटे|घंटा|घंटों|घण्टे|घण्टों|मिनट|आर्स|minute|मि|घण्टे)";
      public const string FivesRegex = @"(?<tens>पाँच|पांच|दस|पंद्रह|बीस|पच्चीस|तीस|पैंतीस|चालीस|पैंतालीस|पचास|पचपन)";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string HindiHourRegex = @"(?<hour>२[०-४]|[०-१]?[०-९])(h)?";
      public const string HindiMinRegex = @"(?<minnum>[०-५]?[०-९])(?!\d)";
      public const string HindiSecRegex = @"(?<secnum>[०-५]?[०-९])";
      public const string PeriodHourNumRegex = @"\b(?<hour>एक|दो|तीन|फ़ोर|चार|पांच|पाँच|छह|सात|आठ|नौ|दस|ग्यारह|बारह|तेरह|चौदह|पंद्रह|सोलह|सत्रह|अठारह|उन्नीस|बीस|इक्कीस|बाईस|तेईस|चौबीस|twenty(\s+(one|two|three|four))?|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|zero|one|two|three|five|eight|ten|वन|टू|थ्री|फोर|फ़ाइव|सिक्स|सेवन|एइट|नाइन|टेन|इलेवन|ट्वेल्व|थर्टीन|फ़ोर्टीन|फ़िफ़्टीन|सिक्सटीन|सेवेनटीन|एइटीन|नाइनटीन|ट्वेन्टी|ट्वेंटी)(?![\u0900-\u097f])";
      public static readonly string ConnectNumRegex = $@"\b(({DescRegex}\s+)?(({TimePrefix}|{TimeSuffix})\s+)?{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex}|{DescRegex}\s+{BaseDateTime.HourRegex}(?<min>[0-5][0-9]))";
      public static readonly string TimeRegexWithDotConnector = $@"(({DescRegex}\s+)?{BaseDateTime.HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex1 = $@"\b({DescRegex}\s+)?(({TimePrefix}|{TimeSuffix})\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\s*|[.])({DescRegex}|{MinuteNumRegex})";
      public static readonly string TimeRegex2 = $@"\b({DescRegex}\s+)?(({TimePrefix}|{TimeSuffix})\s+)?(t)?({BaseDateTime.HourRegex}|{HindiHourRegex})(\s*)?:(\s*)?({BaseDateTime.MinuteRegex}|{HindiMinRegex})((\s*)?:(\s*)?({BaseDateTime.SecondRegex}|{HindiSecRegex}))?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex2A = $@"\b({DescRegexA}\s+)?({BaseDateTime.HourRegex}|{HindiHourRegex})(\s*)?:(\s*)?({BaseDateTime.MinuteRegex}|{HindiMinRegex})((\s*)?:(\s*)?({BaseDateTime.SecondRegex}|{HindiSecRegex}))?((\s*{DescRegexA})|\b)";
      public static readonly string TimeRegex3 = $@"\b({DescRegex}\s+)?({TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"\b({DescRegex}\s+)?({TimeSuffix}\s+)?{TimePrefix}\s+{BasicTime}(\s*{DescRegex})?(\s+{TimeSuffix})?";
      public static readonly string TimeRegex5 = $@"\b({DescRegex}\s+)?{TimePrefix}\s+{BasicTime}((\s*{DescRegex})|\s+{TimePrefix}|\b)|({TimeSuffix}\s+)?({LessThanOneHour}\s+)?{BasicTime}\s+{TimePrefix}";
      public static readonly string TimeRegex6 = $@"((({DescRegex}\s+)?({TimeSuffix}\s+){BasicTime}(\s*{DescRegex})?(\s+{TimeSuffix})?)|(({DescRegex}\s+)?({TimeSuffix}\s+)?{BasicTime}(\s*{DescRegex})?(\s+{TimeSuffix})))";
      public static readonly string TimeRegex7 = $@"\b({DescRegex}\s+)?{TimeSuffixFull}(\s+{TimePrefix}\s+)?\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@"((?<![/\\\-\.\d]){BasicTime}(?=\s*({TillRegex}|{RangeConnectorRegex}|कर\s+देता)(?!\d+[/\\\-\.])))|((?<=(?<!([/\\\-\.]\d+|\d{{4}}))({TillRegex}|{RangeConnectorRegex})\s*){BasicTime}(?![/\\\-\.\d]))";
      public static readonly string TimeRegex9 = $@"\b(({DescRegex}\s+)?{PeriodHourNumRegex}(\s+|-){FivesRegex}|{FivesRegex}\s+(बजकर|बजने\s+(में|से))\s+{PeriodHourNumRegex})((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"\b({DescRegex}\s+)?({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string TimeRegex11 = $@"\b(?:({DescRegex}\s+)?(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\s*per\s*cent|%)|(?:{TimeRegexWithDotConnector}(\s*{DescRegex})))";
      public static readonly string FirstTimeRegexInTimeRange = $@"\b{TimeRegexWithDotConnector}(\s*{DescRegex})?";
      public static readonly string PureNumFromTo = $@"(?<![/\\\-\.\d])((?<leftDesc>{DescRegex})\s*)?({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{TillRegex}\s*(?<rightDesc>{DescRegex}\s*)?({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*{DescRegex})?(?![/\\\-\.\d])(\s+{RangePrefixRegex})?";
      public static readonly string PureNumBetweenAnd = $@"(?<![/\\\-\.\d])((?<leftDesc>{DescRegex})\s*)?(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{RangeConnectorRegex}\s*(?<rightDesc>{DescRegex}\s*)?(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*{DescRegex})?(?![/\\\-\.\d])(\s+{RangePrefixRegex})?";
      public static readonly string SpecificTimeFromTo = $@"(?<![/\\\-\.\d])((?<leftDesc>{DescRegexA})\s*)?(?<time1>(({TimeRegex2A}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegexA}))?))\s*{TillRegex}\s*(?<rightDesc>{DescRegexA}\s*)?(?<time2>(({TimeRegex2A}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegexA}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegexA}))?))(?![/\\\-\.\d])(\s+{{RangePrefixRegex}})?";
      public static readonly string SpecificTimeBetweenAnd = $@"(?<![/\\\-\.\d])((?<leftDesc>{DescRegexA})\s*)?(?<time1>(({TimeRegex2A}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegexA}))?))\s*{RangeConnectorRegex}\s*(?<rightDesc>{DescRegexA}\s*)?(?<time2>(({TimeRegex2A}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegexA}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegexA}))?))(?![/\\\-\.\d])(\s+{RangePrefixRegex})?";
      public const string SuffixAfterRegex = @"\b(((को|तक)\s+)?(या|और)\s+(above|after|(उसके\s+)?बाद|greater)?(?!\s+than)?)\b";
      public const string PrepositionRegex = @"(?<prep>^(at|(को|के),?|on|of)?(\s+the)?$)";
      public const string LaterEarlyRegex = @"((?<early>((को|की)\s+)?(जल्दी|तड़के|सुबह(?!\s+देर))(\s+से)?-?)|(?<late>((को|की)\s+)?(प्रहर\s+)?देर(\s+से)?-?))";
      public const string MealTimeRegex = @"\b(?<mealTime>खाने\s+के\s+वक़्त\s+तक|लंचटाइम|लंच\s+के\s+समय)";
      public static readonly string UnspecificTimePeriodRegex = $@"({MealTimeRegex})";
      public static readonly string TimeOfDayRegex = $@"\b(?<timeOfDay>(रोज\s+)?{LaterEarlyRegex}\s*(सुबह|दोपहर|शाम|{AmRegex}|{RangePmRegex})(?:\s+(को|में))?|(रोज\s+)?(सुबह|दोपहर|{AmRegex}|{RangePmRegex}|संध्या\s+प्रहर)(\s+{LaterEarlyRegex})?(?:\s+(को|में))?|शाम|(काम|व्यापार)\s+के\s+(समय|घंटों)(\s+में)?)";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(({StrictRelativeRegex}\s+{TimeOfDayRegex})|\b(tonight|आज(\s+रात)?))s?";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public static readonly string[] BusinessHourSplitStrings = { @"business", @"hour", @"व्यापारिक", @"घण्टे", @"व्यापार", @"काम" };
      public const string NowRegex = @"\b(?<now>अभी|अब|ज़ल्दी\s+से\s+ज़ल्दी|जल्द\s+से\s+जल्द|जितनी\s+जल्दी\s+हो\s+सके|यथाशीघ्र|हाल\s+ही\s+में|पहले से)";
      public const string SuffixRegex = @"^\s*(in the\s+)?(morning|सुबह|afternoon|दोपहर|दिन|evening|संध्या|शाम|सायं|सायंकाल|night|रात)\b";
      public const string NonTimeContextTokens = @"(building)";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>morning|सुबह|afternoon|दोपहर|night|रात|evening|संध्या|शाम|सायं|सायंकाल)(?![\u0900-\u097f])";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})\b|\bआज(\s+रात)?((\s+(आधी|अर्ध))?\s*रात)?)";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?(in\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(at|around|लगभग|in|on))?\s*$";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"(?<!{NonTimeContextTokens}\s*)\b({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?(in\s+)?{DateTimeSpecificTimeOfDayRegex}\b";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"\b{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(at|around|करीब|लगभग))?\s*({HourNumRegex}|{BaseDateTime.HourRegex})\b";
      public const string SpecificEndOfRegex = @"^\s*(((दिन\s+)?(यह\s+)?के\s+(अंत|खत्म)(\s+में)?)|(देर\s+शाम\s+को))(?![\u0900-\u097f])";
      public static readonly string UnspecificEndOfRegex = $@"\b(यह\s+)?(eod|दिन\s+के\s+खत्म|((?<!{WeekDayRegex}\s+)(दिन)\s+के\s+अंत\s+में))";
      public const string UnspecificEndOfRangeRegex = @"\b(eoy)\b";
      public static readonly string PeriodTimeOfDayRegex = $@"\b((इस\s+)?({LaterEarlyRegex}\s*)?(इस\s+)?{DateTimeTimeOfDayRegex}(\s*{LaterEarlyRegex})?)(?![\u0900-\u097f])";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b({LaterEarlyRegex}?इस\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\s+{PeriodTimeOfDayRegex})|\b(tonight|आज(\s+रात)?))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"\b(((को|की)\s+)?{PeriodTimeOfDayRegex}(\s+(को|की))?)(?![\u0900-\u097f])";
      public const string LessThanRegex = @"\b(से\s+(भी\s+)?कम(\s+समय)?)";
      public const string MoreThanRegex = @"\b(से\s+(ज़्यादा|ज्यादा)(\s+पहले)?)";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|((घं|मि)(\.|(?=[/\\.,-])))|घण्टों|घण्टे(\sऔर)?|कार्य\s?दिवस(\sऔर)?|घंटों|घंटे|घंटा|घं|आर्स|h|मिनटों|मिनट|मिन\.|min\.|min(ute)?s?|सेकंड्स|सेकंड|सेकेंड|sec(ond)?s?)";
      public const string SuffixAndRegex = @"(?<suffix>\s*(और)\s+((एक)?\s+)?(?<suffix_num>आधे|साढ़े|तिमाही)|(?<suffix_num>साढ़े|आधे|तिमाही))";
      public const string PeriodicRegex = @"\b(?<periodic>(?<daily>दैनिक|रोज़)|(?<monthly>मासिक)|(?<weekly>साप्ताहिक)|(?<yearly>वार्षिक|ऐनुअली\s+एक\s+बार|सालाना|सालान|साल\s+में\s+एक\s+बार)|(?<biweekly>हफ्ते\s+में\s+दो\s+बार))";
      public static readonly string EachUnitRegex = $@"(?<each>(प्रत्येक\s+से|हरेक|हर\s+तीसरे|हर(\s+एक)?|प्रति|रो(?=ज))(?<other>\s+other)?\s*(?!दिन\s+(सुबह|दोपहर|संध्या|रात)){DurationUnitRegex})";
      public const string EachPrefixRegex = @"\b(?<each>(से\s+प्रत्येक|रोजाना|रोज|डेली|हरेक|हर\s+तीसरे|हर(\s+(एक|रोज|दिन))?)\s*$)";
      public const string SetEachRegex = @"\b(?<each>((से\s+)?प्रत्येक|प्रतिदिन|रोजाना|रोज|डेली|हरेक|हर(\s+(एक|रोज|दिन))?)\s*)";
      public const string SetLastRegex = @"(?<last>निम्नलिखित|अगले|आगामी|इस|पिछले|पिछले|पिछले|वर्तमान)";
      public const string EachDayRegex = @"\s*(हर दिन|रोज़|रोज|प्रतिदिन)\b";
      public const string EachDayRegexPrefix = @"\b(हर दिन|रोज़|प्रतिदिन)\s*$";
      public static readonly string DurationFollowedUnit = $@"(^\s*{DurationUnitRegex}\s+{SuffixAndRegex})|(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"\b((?<half>आधे|आधा)|एक(\sऔर)?)\s+{DurationUnitRegex}";
      public const string DuringRegex = @"\b(?<unit>साल|महीनों|महीना|(?!सप्ताहांत)सप्ताह|हफ़्ते|हफ्ते|दिन|घंटे|घंटा|आर्स)\s+(के लिए|के लिये|दौरान)";
      public const string AllRegex = @"\b((?<all>(all|full|whole|पूरे|पूरा|सारा|सारे)(\s+|-))(?<unit>year|वर्ष|साल|month|माह|महीनों|महीना|महीने|week|सप्ताह|हफ्ते|हफ़्ते|हफ्ता|day|दिन)(\s+भर)?|(?<unit>year|वर्ष|साल|month|माह|महीनों|महीना|महीने|week|सप्ताह|हफ्ते|हफ़्ते|हफ्ता|day|दिन)(?<all>\s+भर))";
      public const string HalfRegex = @"((an?\s*)|\b)(?<half>(साढ़े|आधे|आधा)\s+(?<unit>year|वर्ष|साल|month|महीनों|महीने|week|(?!सप्ताहांत)सप्ताह|हफ़्ते|हफ्ते|day|दिनों|दिन|hour|घंटे|घण्टे|घंटा|आर्स))";
      public const string ConjunctionRegex = @"\b((and(\s+for)?)|with)\b";
      public static readonly string HolidayRegex1 = $@"\b(({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?))\s+((की|के)\s+)?)?(?<holiday>mardi gras|(washington|mao)'s birthday|chinese new year|(new\s+(years'|year\s*'s|years?)\s+eve)|(new\s+(years'|year\s*'s|years?)(\s+day)?)|नया\s+साल|नए\s+साल\s+की\s+शाम|नववर्ष\s+की\s+पूर्वसंध्या|न्यू\s+इयर\s+ईव|may\s*day|yuan dan|christmas eve|((christmas|xmas|क्रिसमस)(\s+के)?(\s+वाले)?(\s+(day|दिन))?)|गांधी\s+जयंती(\sके\s?दिन)?|black friday|ब्लैक\s+फ़्राइड|yuandan|ईस्टर(\s+(संडे|रवि|सोम|शनि)(वार)?)?|clean monday|ash wednesday|palm sunday|maundy thursday|good friday|white\s+(sunday|monday)|trinity sunday|pentecost|corpus christi|cyber monday|सायबर\s+मंडे)(\s+(of\s+)?({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?)))?";
      public static readonly string HolidayRegex2 = $@"\b(({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?))\s+((की|के)\s+)?)?(?<holiday>(thanks\s*giving|रक्षा(\s)?बंधन(\sके)?|होली|नवरा(त्रों|त्र)(\sके\s+पहले)?|वैशाखी|बैसाखी(\sहर\sसाल)?|दिवाली|all saint's|white lover|s(?:ain)?t?. (?:patrick|george)(?:')?(?:s)?|सेंट\s+पैट्रिक्स|us independence|all hallow|all souls|guy fawkes|cinco de mayo|halloween|हैलोवीन|qingming|dragon boat|april fools|tomb\s*sweeping)(\s+(day|दिन|डे))?|थैंक्स\s+गिविंग\s+के\s+दिन|थैंक्स\s*गिविंग)(\s+(of\s+)?({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?)))?";
      public static readonly string HolidayRegex3 = $@"\b(({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?))\s+((की|के)\s+)?)?(?<holiday>(?:independence|स्वतंत्रता|स्वतंत्रता|गणतंत्र|योग|presidents(?:')?|प्रेसिडेंट्स|mlk|martin luther king( jr)?|मार्टिन\s+लूथर\s+किंग|एम\.\s+एल\.\s+के\.|canberra|ascension|columbus|tree( planting)?|arbor|labou?r|मजदूर|(अंतर्राष्ट्रीय|अंतरराष्ट्रीय)\s+मजदूर?|(international|int'l)\s+workers'?|श्रमिक|मई|mother's|mothers?|father's|फादर्स|fathers?|female|women('s)?|single|teacher'?s|youth|children|girls|lovers?|earth|पृथ्वी|inauguration|groundhog|valentine'?s|baptiste|bastille|veterans(?:')?|memorial|mid[ \-]autumn|moon|spring|lantern)\s+(day|दिवस|डे))(\s+(of\s+)?({YearRegex}|{RelativeRegex}\s+(year|साल|वर्ष?)))?";
      public const string AMTimeRegex = @"(?<am>morning|सुबह)";
      public const string PMTimeRegex = @"\b(?<pm>afternoon|evening|night|दोपहर|शाम|रात)\b";
      public const string NowTimeRegex = @"(now|अब)";
      public const string RecentlyTimeRegex = @"(recently|previously|हाल\s+ही(\s+में)?|पहले(\s+से)?)";
      public const string AsapTimeRegex = @"(as\s+soon\s+as\s+possible|asap|ज़ल्दी\s+से\s+ज़ल्दी|जितनी\s+जल्दी\s+हो\s+सके|जल्द\s+से\s+जल्द)";
      public const string InclusiveModPrepositions = @"(?<include>((को|में|बीच में|in|से|पर|at)\s+(अथवा|या)\s+)|(\s+(अथवा|या)\s+(को|में|बीच में|in|से|पर))|या)";
      public static readonly string BeforeRegex = $@"((({InclusiveModPrepositions}\s*)?\s*(?:(((से|के|उससे)\s+)?पहले(\s+नहीं(?!\sजा))?)|तक(?!\sया)|पहले\s+से|(उससे|के|से)\s+पूर्व|(बाद में नही|पूर्व)\s+से|ending\s+(with|on)|by|(un)?till?|(?<include>as\s+late\s+as))(\s*{InclusiveModPrepositions})?\b)|(?<!\w|>)((?<include><\s*=)|<))(\s+the)?";
      public static readonly string AfterRegex = $@"((({InclusiveModPrepositions}\s*)?(((\s+)?के बाद|(starting|beginning)(\s+on)?(?!\sfrom)|(?<!no\s+)later than)|(year greater than))(?!\s+or equal to)(\s*{InclusiveModPrepositions})?\b)|(?<!\w|<)((?<include>>\s*=)|>))(\s+the)?";
      public const string SinceRegex = @"(?:(?:\b(?:(से|के) बाद\s+(अथवा|या)\s+के बराबर|से|starting\s+(?:from|on|with)|as\s+early\s+as|(any\s+time\s+)?from)\b)|(?<!\w|<)(>=))";
      public const string AroundRegex = @"(?:\b(?:around|circa|लगभग|(के\s+)?आसपास))";
      public const string AgoRegex = @"((?<day>(कल से पहले)|कल|आज)(\s+(से|के)\s*पहले)?|पहले)";
      public static readonly string LaterRegex = $@"\b(?:(?<day>(कल|अब|आज)\s+से)\s+बाद|बाद(?!((\s+में)?\s*{OneWordPeriodRegex})|(\s+{TimeOfDayRegex}))|(?<day>कल|आज) (से|बाद)|अब\s+से|के\s+बाद)";
      public const string BeforeAfterRegex = @"^[.]";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string InConnectorRegex = @"\b(में|को)";
      public static readonly string SinceYearSuffixRegex = $@"(^\s*{SinceRegex}(\s*(the\s+)?year\s*)?{YearSuffix})";
      public static readonly string WithinNextPrefixRegex = $@"\b(((?<next>{NextPrefixRegex}?के)\s+)?(अंदर|भीतर))";
      public const string TodayNowRegex = @"\b(आज|अभी)(?![\u0900-\u097f])";
      public static readonly string MorningStartEndRegex = $@"(^(सुबह|{AmDescRegex}))|((सुबह|{AmDescRegex})$)";
      public static readonly string AfternoonStartEndRegex = $@"(^(दोपहर|{PmDescRegex}))|((दोपहर|{PmDescRegex})$)";
      public const string EveningStartEndRegex = @"(^(शाम))|((शाम)$)";
      public const string NightStartEndRegex = @"(^(रातों|आज)?\s*रात)|((over|to)?रात$)";
      public const string InexactNumberRegex = @"\b(कुछ|कई|कुछ ही|कुछेक|(?<NumTwoTerm>(का\s+)?(एक\s+)?जोड़ा))";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"(?:(?:(?:{NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({TimeUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"(?:(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+(?<duration>सप्ताहांत|सप्ताह|हफ्ते|हफ़्ते|month|महीने|year|साल|दशक|weekend|वीकेंड)";
      public const string ConnectorRegex = @"^(-|,|के\s+(लिए|लिये)\s+|t|लगभग|तारीख\s+को|around|@)$";
      public const string FromTokenRegex = @"\bसे\b";
      public const string BetweenTokenRegex = @"\bबीच$";
      public const string PluralTokenRegex = @"रोज";
      public const string FromToRegex = @"\b(से|अब से).+(से|to)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(यह\s+)?(मे|मार्च)$";
      public const string SingleAmbiguousTermsRegex = @"^(यह\s+)?(day|(?!सप्ताहांत)सप्ताह|हफ्ते|हफ़्ते|month|year)$";
      public const string UnspecificDatePeriodRegex = @"^(सप्ताहांत|सप्ताह|हफ्ते|हफ़्ते|month|year)$";
      public const string PrepositionSuffixRegex = @"\b(on|in|at|around|से|अब से|to|लगभग)$";
      public const string WrittenDayRegex = @"(?<day>सात|दूसरी|आठ|फ़ोर|चार|पांच|पाँच|नौ|दो|छह|एक(सठ)?|तीन|सत्रह|तेरह|चौदह|अठारह|उन्नीस|पंद्रह|सोलह|ग्यारह|बारह|दस|सत्ताईस|तेईस|चौबीस|अट्ठाईस|अट्ठाइस|उनतीस|पच्चीस|छब्बीस|इक्कीस|बाईस|बीस|तीस|इकत्तीस|इकतीस)(?![\u0900-\u097f])";
      public static readonly string FlexibleDayRegex = $@"(?<DayOfMonth>({WeekDayRegex}+\s+)?({WrittenDayRegex}|(उस\s*)?(?<!:)(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))))(?:ला|ली|रा|था|वां|वीं|वें|वाँ|वा|ठा|th|nd|rd|st)?";
      public static readonly string ForTheRegex = $@"\b(((उस\s+)?{FlexibleDayRegex}(?=\s+(तारीख\s+)?(के|को))|((यह\s+)?{FlexibleDayRegex}(?<=(?:ला|रा|था|वां|वीं|वें|वाँ|वा|ठा))(?<=\s+को\s+)))(?<end>\s*(,|\.|!|\?|$))?)";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b({WeekDayRegex}\s+(से\s+)?({FlexibleDayRegex})|{FlexibleDayRegex}(\s+तारीख)?\s+{WeekDayRegex})";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+(से\s+)?(?!(the)){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"\b(बाकी\s+(के\s+)?(?<duration>(?!सप्ताहांत)(?<!\d+\s+)सप्ताह|(?<!\d+\s+)हफ़्ते|(?<!\d+\s+)हफ्ते|(?<!\d+\s+)महीने|(?<!\d+\s+)साल|दशक))|((उस|इस|अपने|this|चालू|मेरे)\s+)?(?<duration>(?!सप्ताहांत)(?<!\d+\s+)सप्ताह|(?<!\d+\s+)हफ़्ते|(?<!\d+\s+)हफ्ते|(?<!\d+\s+)महीने|(?<!\d+\s+)साल|दशक)(\s+(के|में))?(\s+बाकी\s+(के\s+)?(दिन|समय))";
      public const string RestOfDateTimeRegex = @"\b((इस|उस|the|my|this|चालू|आज|मेरे)\s+)?(बाकी\s+(के\s+)?|((बाकी\s+)?(के\s+बचे\s+)))(?<unit>(दिन|तारीख|समय))(\s+आज)?|\b((इस|उस|the|my|this|चालू|आज)\s+)?(?<unit>(दिन|तारीख|समय))((\s+)?(के\s+बाकी\s+बचे\sभाग))";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public static readonly string NumberEndingPattern = $@"^(?:\s+((वाले|वाला)\s+)?(?<meeting>meeting|appointment|अपॉइंटमेंट|conference|call|skype call)\s+(को|से)\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})([\.]?$|(\.,|,|!|\?)|\s*में\s*बदल\s*देती\s*हूँ\s*))";
      public const string OneOnOneRegex = @"\b(1\s*:\s*1(?!\d))|(one (on )?one|one\s*-\s*one|one\s*:\s*one)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b((?<suffix>{OneWordPeriodRegex})|({UnspecificEndOfRangeRegex}))\s*({PrefixPeriodRegex})";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b(((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|इस)\s+((?!सप्ताहांत)सप्ताह|हफ़्ते|हफ्ते))((\s+between\s+{WeekDayRegex}\s+and\s+{WeekDayRegex})|(\s+{WeekDayRegex}\s+और\s+{WeekDayRegex}\s+के\s+बीच)|(\s+{WeekDayRegex}\s+से\s+{WeekDayRegex})))|(((between\s+{WeekDayRegex}\s+and\s+{WeekDayRegex})|({WeekDayRegex}\s+(और|से)\s+{WeekDayRegex}\s+(के\s+बीच|तक))|(from\s+{WeekDayRegex}\s+to\s+{WeekDayRegex}))\s+(?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|this)\s+((?!सप्ताहांत)सप्ताह|हफ़्ते|हफ्ते))))";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|and|और|,)\s*$";
      public const string PrefixArticleRegex = @"\bthe\s+";
      public const string OrRegex = @"\s*((\b|,\s*)(or|and)\b|,)\s*";
      public static readonly string SpecialYearTermsRegex = $@"\b((({SpecialYearPrefixes}\s+)?(year|साल))|(cy|(?<special>fy|sy)))";
      public static readonly string YearPlusNumberRegex = $@"\b({SpecialYearTermsRegex}\s*((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b(((?<=\b(before|no later than|by|after)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>\s+(at|को))\s*$";
      public const string DecadeRegex = @"(?<decade>((?:दस|बीस|तीस|चालीस|पचास|साठ|सत्तर|अस्सी|नब्बे)|(दो\s+हजार)?)(\s+के\s+दशक)|इस\s+सदी\s+के\s+पहले\s+दशक|20वीं\s+सदी\s+के\s+पहले\s+दशक)";
      public static readonly string DecadeWithCenturyRegex = $@"(((?<century>\d|1\d|2\d)?(?<decade>\d0)(\s+के दशक))|(({CenturyRegex}(\s+|-)(और\s+)?)?{DecadeRegex})|({CenturyRegex}(\s+|-)(और\s+)?(?<decade>दसवें|सौवां)))";
      public static readonly string RelativeDecadeRegex = $@"\b({RelativeRegex}\s+((?<number>[\w,\u0900-\u097f]+)\s+)?(\s+के\s+)?(दशकों?|दशक))";
      public static readonly string YearPeriodRegex = $@"((((from|during|in)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((between)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public static readonly string StrictTillRegex = $@"(?<till>\b(से)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public static readonly string StrictRangeConnectorRegex = $@"(?<and>\b(और|से)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public static readonly string ComplexDatePeriodRegex = $@"(?:(?<start>.+)\s*({StrictTillRegex})\s*(?<end>.+)(\s+(तक))|(?<start>.+)\s*({StrictRangeConnectorRegex})\s*(?<end>.+)(\s+(के बीच)))";
      public static readonly string FailFastRegex = $@"{BaseDateTime.DeltaMinuteRegex}|\b(?:{BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex})|{BaseDateTime.BaseAmPmDescRegex}|\b(?:zero|{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}|{WrittenMonthRegex}|{SeasonDescRegex}|{DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\d(-|——)?ish|((the\s+\w*)|\d)(th|rd|nd|st)|(mid\s*(-\s*)?)?(night|morning|afternoon|day)s?|evenings?||noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|घण्टे?|minutes?|मि\.?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\b|{WeekDayRegex}|{SetWeekDayRegex}|{NowRegex}|{PeriodicRegex}|\b({DateUnitRegex}|{ImplicitDayRegex})";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"दशकों", @"10Y" },
            { @"दशक", @"10Y" },
            { @"साल", @"Y" },
            { @"वर्षों", @"Y" },
            { @"वर्ष", @"Y" },
            { @"महीनों", @"MON" },
            { @"महीना", @"MON" },
            { @"महीने", @"MON" },
            { @"माह", @"MON" },
            { @"पखवाड़ा", @"2W" },
            { @"पखवाड़े", @"2W" },
            { @"पखवाड़े", @"2W" },
            { @"हफ़्तों", @"W" },
            { @"सप्ताह", @"W" },
            { @"हफ़्ते", @"W" },
            { @"हफ्ते", @"W" },
            { @"हफ्ता", @"W" },
            { @"हफ़्ता", @"W" },
            { @"हफ्तों", @"W" },
            { @"दिन", @"D" },
            { @"दिनों", @"D" },
            { @"ज", @"D" },
            { @"hours", @"H" },
            { @"घंटे", @"H" },
            { @"घंटा", @"H" },
            { @"hour", @"H" },
            { @"घण्टे", @"H" },
            { @"घण्टों", @"H" },
            { @"घंटों", @"H" },
            { @"hrs", @"H" },
            { @"आर्स", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"घं", @"H" },
            { @"घं.", @"H" },
            { @"minutes", @"M" },
            { @"मिनटों", @"M" },
            { @"minute", @"M" },
            { @"मिनट", @"M" },
            { @"मि", @"M" },
            { @"मि.", @"M" },
            { @"मिन", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"seconds", @"S" },
            { @"second", @"S" },
            { @"सेकंड", @"S" },
            { @"सेकेंड", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" },
            { @"सेकंड्स", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"दशकों", 315360000 },
            { @"दशक", 315360000 },
            { @"साल", 31536000 },
            { @"वर्षों", 31536000 },
            { @"वर्ष", 31536000 },
            { @"महीना", 2592000 },
            { @"महीने", 2592000 },
            { @"महीनों", 2592000 },
            { @"माह", 2592000 },
            { @"पखवाड़ा", 1209600 },
            { @"पखवाड़े", 1209600 },
            { @"पखवाड़े", 1209600 },
            { @"हफ़्तों", 604800 },
            { @"सप्ताह", 604800 },
            { @"हफ्ते", 604800 },
            { @"हफ़्ते", 604800 },
            { @"हफ्ता", 604800 },
            { @"हफ़्ता", 604800 },
            { @"हफ्तों", 604800 },
            { @"दिन", 86400 },
            { @"दिनों", 86400 },
            { @"दिवस", 86400 },
            { @"ज", 86400 },
            { @"hours", 3600 },
            { @"घंटे", 3600 },
            { @"घंटा", 3600 },
            { @"hour", 3600 },
            { @"घण्टे", 3600 },
            { @"घण्टों", 3600 },
            { @"घंटों", 3600 },
            { @"hrs", 3600 },
            { @"आर्स", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"घं", 3600 },
            { @"घं.", 3600 },
            { @"minutes", 60 },
            { @"मिनटों", 60 },
            { @"minute", 60 },
            { @"मिनट", 60 },
            { @"मि", 60 },
            { @"मि.", 60 },
            { @"मिन", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"seconds", 1 },
            { @"second", 1 },
            { @"सेकंड", 1 },
            { @"सेकेंड", 1 },
            { @"सेकंड्स", 1 },
            { @"secs", 1 },
            { @"sec", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscal", @"FY" },
            { @"school", @"SY" },
            { @"fy", @"FY" },
            { @"sy", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"spring", @"SP" },
            { @"वसंत", @"SP" },
            { @"summer", @"SU" },
            { @"गर्मी", @"SU" },
            { @"गर्मियों", @"SU" },
            { @"fall", @"FA" },
            { @"autumn", @"FA" },
            { @"शरद\s+ऋतु", @"FA" },
            { @"winter", @"WI" },
            { @"सर्दियों", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"पहला", 1 },
            { @"पहली", 1 },
            { @"पहले", 1 },
            { @"1st", 1 },
            { @"दूसरा", 2 },
            { @"दूसरे", 2 },
            { @"दूसरी", 2 },
            { @"2nd", 2 },
            { @"तीसरा", 3 },
            { @"तीसरे", 3 },
            { @"तीसरी", 3 },
            { @"3rd", 3 },
            { @"चौथा", 4 },
            { @"चौथी", 4 },
            { @"4th", 4 },
            { @"पाँचवाँ", 5 },
            { @"पांचवां", 5 },
            { @"5th", 5 },
            { @"first", 1 },
            { @"second", 2 },
            { @"third", 3 },
            { @"fourth", 4 },
            { @"fifth", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"सोमवार", 1 },
            { @"मंगलवार", 2 },
            { @"म्गलवार", 2 },
            { @"बुधवार", 3 },
            { @"गुरुवार", 4 },
            { @"वृहस्पतिवार", 4 },
            { @"बृहस्पतिवार", 4 },
            { @"वीरवार", 4 },
            { @"शुक्रवार", 5 },
            { @"शनिवार", 6 },
            { @"रविवार", 0 },
            { @"इतवार", 0 },
            { @"एतवार", 0 },
            { @"सोम", 1 },
            { @"मंडे", 1 },
            { @"मंगल", 2 },
            { @"म्गल", 2 },
            { @"बुध", 3 },
            { @"गुरु", 4 },
            { @"बीफ़े", 4 },
            { @"शुक्र", 5 },
            { @"शनि", 6 },
            { @"रवि", 0 },
            { @"संडे", 0 },
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"जनवरी", 1 },
            { @"फ़रवरी", 2 },
            { @"फरवरी", 2 },
            { @"फेब्रूवरी", 2 },
            { @"मार्च", 3 },
            { @"अप्रैल", 4 },
            { @"अप्रील", 4 },
            { @"मई", 5 },
            { @"जून", 6 },
            { @"जुलाई", 7 },
            { @"अगस्त", 8 },
            { @"सितम्बर", 9 },
            { @"सितंबर", 9 },
            { @"अक्तूबर", 10 },
            { @"अक्टूबर", 10 },
            { @"अक्टू", 10 },
            { @"नवंबर", 11 },
            { @"दिसंबर", 12 },
            { @"दिसम्बर", 12 },
            { @"जन", 1 },
            { @"जन.", 1 },
            { @"फ़ेब", 2 },
            { @"फ़ेब.", 2 },
            { @"फेब", 2 },
            { @"फेब.", 2 },
            { @"फ़र", 2 },
            { @"फ़र.", 2 },
            { @"फर", 2 },
            { @"फर.", 2 },
            { @"मा.", 3 },
            { @"मा", 3 },
            { @"अप्र.", 4 },
            { @"अप्र", 4 },
            { @"जू.", 6 },
            { @"जु.", 7 },
            { @"जुल", 7 },
            { @"जुल.", 7 },
            { @"अग", 8 },
            { @"अग.", 8 },
            { @"सित", 9 },
            { @"सित.", 9 },
            { @"सेप्ट", 9 },
            { @"सेप्ट.", 9 },
            { @"सितं", 9 },
            { @"सितं.", 9 },
            { @"आक्ट.", 10 },
            { @"आक्ट", 10 },
            { @"अक्टू.", 10 },
            { @"नवं", 11 },
            { @"नवं.", 11 },
            { @"नव", 11 },
            { @"नव.", 11 },
            { @"दिस", 12 },
            { @"दिस.", 12 },
            { @"january", 1 },
            { @"february", 2 },
            { @"march", 3 },
            { @"april", 4 },
            { @"may", 5 },
            { @"june", 6 },
            { @"july", 7 },
            { @"august", 8 },
            { @"september", 9 },
            { @"october", 10 },
            { @"november", 11 },
            { @"december", 12 },
            { @"jan", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"apr", 4 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"aug", 8 },
            { @"sep", 9 },
            { @"sept", 9 },
            { @"oct", 10 },
            { @"nov", 11 },
            { @"dec", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"शून्य", 0 },
            { @"एक", 1 },
            { @"दो", 2 },
            { @"तीन", 3 },
            { @"फ़ोर", 4 },
            { @"चार", 4 },
            { @"पाँच", 5 },
            { @"पांच", 5 },
            { @"छह", 6 },
            { @"सात", 7 },
            { @"आठ", 8 },
            { @"नौ", 9 },
            { @"दस", 10 },
            { @"ग्यारह", 11 },
            { @"बारह", 12 },
            { @"दर्जन", 12 },
            { @"दर्जनों", 12 },
            { @"डज़न", 12 },
            { @"तेरह", 13 },
            { @"चौदह", 14 },
            { @"पंद्रह", 15 },
            { @"सोलह", 16 },
            { @"सत्रह", 17 },
            { @"अठारह", 18 },
            { @"उन्नीस", 19 },
            { @"बीस", 20 },
            { @"इक्कीस", 21 },
            { @"बाईस", 22 },
            { @"बाइस", 22 },
            { @"तेईस", 23 },
            { @"तेइस", 23 },
            { @"चौबीस", 24 },
            { @"पच्चीस", 25 },
            { @"छब्बीस", 26 },
            { @"सत्ताईस", 27 },
            { @"सत्ताइस", 27 },
            { @"अट्ठाईस", 28 },
            { @"अट्ठाइस", 28 },
            { @"उनतीस", 29 },
            { @"तीस", 30 },
            { @"इकतीस", 31 },
            { @"इकत्तीस", 31 },
            { @"बत्तीस", 32 },
            { @"तैंतीस", 33 },
            { @"चौंतीस", 34 },
            { @"पैंतीस", 35 },
            { @"पैंतीसवां", 35 },
            { @"छ्त्तीस", 36 },
            { @"सैंतीस", 37 },
            { @"अड़तीस", 38 },
            { @"उनतालीस", 39 },
            { @"चालीस", 40 },
            { @"इकतालीस", 41 },
            { @"बयालीस", 42 },
            { @"तैंतालीस", 43 },
            { @"चौंतालीस", 44 },
            { @"पैंतालीस", 45 },
            { @"पैंतालिस", 45 },
            { @"पेंतालिस", 45 },
            { @"छियालीस", 46 },
            { @"सैंतालीस", 47 },
            { @"अड़तालीस", 48 },
            { @"उनचास", 49 },
            { @"पचास", 50 },
            { @"इक्याबन", 51 },
            { @"बावन", 52 },
            { @"तिरेपन", 53 },
            { @"चौबन", 54 },
            { @"पचपन", 55 },
            { @"छप्पन", 56 },
            { @"सत्तावन", 57 },
            { @"अट्ठावन", 58 },
            { @"उनसठ", 59 },
            { @"साठ", 60 },
            { @"एकसठ", 61 },
            { @"इकसठ", 61 },
            { @"बासठ", 62 },
            { @"तिरसठ", 63 },
            { @"चौंसठ", 64 },
            { @"पैंसठ", 65 },
            { @"छियासठ", 66 },
            { @"सड़सठ", 67 },
            { @"सड़सठ", 67 },
            { @"अड़सठ", 68 },
            { @"उनहत्तर", 69 },
            { @"सत्तर", 70 },
            { @"इकहत्तर", 71 },
            { @"बहत्तर", 72 },
            { @"तिहत्तर", 73 },
            { @"चौहत्तर", 74 },
            { @"पचहत्तर", 75 },
            { @"छिहत्तर", 76 },
            { @"सतहत्तर", 77 },
            { @"अठहत्तर", 78 },
            { @"उनासी", 79 },
            { @"अस्सी", 80 },
            { @"इक्यासी", 81 },
            { @"बयासी", 82 },
            { @"तिरासी", 83 },
            { @"चौरासी", 84 },
            { @"पचासी", 85 },
            { @"छियासी", 86 },
            { @"सतासी", 87 },
            { @"अठासी", 88 },
            { @"नवासी", 89 },
            { @"नब्बे", 90 },
            { @"इक्यानबे", 91 },
            { @"बानवे", 92 },
            { @"तिरानवे", 93 },
            { @"चौरानवे", 94 },
            { @"पचानवे", 95 },
            { @"पंचानबे", 95 },
            { @"छियानवे", 96 },
            { @"सत्तानवे", 97 },
            { @"अट्ठानवे", 98 },
            { @"निन्यानवे", 99 },
            { @"सौ", 100 },
            { @"वन", 1 },
            { @"टू", 2 },
            { @"थ्री", 3 },
            { @"फोर", 4 },
            { @"फ़ाइव", 5 },
            { @"सिक्स", 6 },
            { @"सेवन", 7 },
            { @"एइट", 8 },
            { @"नैन", 9 },
            { @"टेन", 10 },
            { @"इलेवन", 11 },
            { @"ट्वेल्व", 12 },
            { @"थर्टीन", 13 },
            { @"फ़ोर्टीन", 14 },
            { @"फ़िफ़्टीन", 15 },
            { @"सिक्सटीन", 16 },
            { @"सेवेनटीन", 17 },
            { @"एइटीन", 18 },
            { @"नईनटीन", 19 },
            { @"ट्वेन्टी", 20 },
            { @"ट्वेंटी", 20 },
            { @"थर्टी", 30 },
            { @"फ़ोर्टी", 40 },
            { @"फ़िफ़्टी", 50 },
            { @"सिक्सटी", 60 },
            { @"सेवेंटी", 70 },
            { @"एइट्टी", 80 },
            { @"नैनटी", 90 },
            { @"०", 0 },
            { @"१", 1 },
            { @"२", 2 },
            { @"३", 3 },
            { @"४", 4 },
            { @"५", 5 },
            { @"६", 6 },
            { @"७", 7 },
            { @"८", 8 },
            { @"९", 9 },
            { @"००", 0 },
            { @"०१", 1 },
            { @"०२", 2 },
            { @"०३", 3 },
            { @"०४", 4 },
            { @"०५", 5 },
            { @"०६", 6 },
            { @"०७", 7 },
            { @"०८", 8 },
            { @"०९", 9 },
            { @"१०", 10 },
            { @"११", 11 },
            { @"१२", 12 },
            { @"१३", 13 },
            { @"१४", 14 },
            { @"१५", 15 },
            { @"१६", 16 },
            { @"१७", 17 },
            { @"१८", 18 },
            { @"१९", 19 },
            { @"२०", 20 },
            { @"२१", 21 },
            { @"२२", 22 },
            { @"२३", 23 },
            { @"२४", 24 },
            { @"२५", 25 },
            { @"२६", 26 },
            { @"२७", 27 },
            { @"२८", 28 },
            { @"२९", 29 },
            { @"३०", 30 },
            { @"३१", 31 },
            { @"३२", 32 },
            { @"३३", 33 },
            { @"३४", 34 },
            { @"३५", 35 },
            { @"३६", 36 },
            { @"३७", 37 },
            { @"३८", 38 },
            { @"३९", 39 },
            { @"४०", 40 },
            { @"४१", 41 },
            { @"४२", 42 },
            { @"४३", 43 },
            { @"४४", 44 },
            { @"४५", 45 },
            { @"४६", 46 },
            { @"४७", 47 },
            { @"४८", 48 },
            { @"४९", 49 },
            { @"५०", 50 },
            { @"५१", 51 },
            { @"५२", 52 },
            { @"५३", 53 },
            { @"५४", 54 },
            { @"५५", 55 },
            { @"५६", 56 },
            { @"५७", 57 },
            { @"५८", 58 },
            { @"५९", 59 },
            { @"६०", 60 },
            { @"६१", 61 },
            { @"६२", 62 },
            { @"६३", 63 },
            { @"६४", 64 },
            { @"६५", 65 },
            { @"६६", 66 },
            { @"६७", 67 },
            { @"६८", 68 },
            { @"६९", 69 },
            { @"७०", 70 },
            { @"७१", 71 },
            { @"७२", 72 },
            { @"७३", 73 },
            { @"७४", 74 },
            { @"७५", 75 },
            { @"७६", 76 },
            { @"७७", 77 },
            { @"७८", 78 },
            { @"७९", 79 },
            { @"८०", 80 },
            { @"८१", 81 },
            { @"८२", 82 },
            { @"८३", 83 },
            { @"८४", 84 },
            { @"८५", 85 },
            { @"८६", 86 },
            { @"८७", 87 },
            { @"८८", 88 },
            { @"८९", 89 },
            { @"९०", 90 },
            { @"९१", 91 },
            { @"९२", 92 },
            { @"९३", 93 },
            { @"९४", 94 },
            { @"९५", 95 },
            { @"९६", 96 },
            { @"९७", 97 },
            { @"९८", 98 },
            { @"९९", 99 },
            { @"१००", 100 },
            { @"zero", 0 },
            { @"one", 1 },
            { @"a", 1 },
            { @"an", 1 },
            { @"two", 2 },
            { @"three", 3 },
            { @"four", 4 },
            { @"five", 5 },
            { @"six", 6 },
            { @"seven", 7 },
            { @"eight", 8 },
            { @"nine", 9 },
            { @"ten", 10 },
            { @"eleven", 11 },
            { @"twelve", 12 },
            { @"thirteen", 13 },
            { @"fourteen", 14 },
            { @"fifteen", 15 },
            { @"sixteen", 16 },
            { @"seventeen", 17 },
            { @"eighteen", 18 },
            { @"nineteen", 19 },
            { @"twenty", 20 },
            { @"twenty one", 21 },
            { @"twenty two", 22 },
            { @"twenty three", 23 },
            { @"twenty four", 24 },
            { @"twenty five", 25 },
            { @"twenty six", 26 },
            { @"twenty seven", 27 },
            { @"twenty eight", 28 },
            { @"twenty nine", 29 },
            { @"thirty", 30 },
            { @"thirty one", 31 },
            { @"thirty two", 32 },
            { @"thirty three", 33 },
            { @"thirty four", 34 },
            { @"thirty five", 35 },
            { @"thirty six", 36 },
            { @"thirty seven", 37 },
            { @"thirty eight", 38 },
            { @"thirty nine", 39 },
            { @"forty", 40 },
            { @"forty one", 41 },
            { @"forty two", 42 },
            { @"forty three", 43 },
            { @"forty four", 44 },
            { @"forty five", 45 },
            { @"forty six", 46 },
            { @"forty seven", 47 },
            { @"forty eight", 48 },
            { @"forty nine", 49 },
            { @"fifty", 50 },
            { @"fifty one", 51 },
            { @"fifty two", 52 },
            { @"fifty three", 53 },
            { @"fifty four", 54 },
            { @"fifty five", 55 },
            { @"fifty six", 56 },
            { @"fifty seven", 57 },
            { @"fifty eight", 58 },
            { @"fifty nine", 59 },
            { @"sixty", 60 },
            { @"sixty one", 61 },
            { @"sixty two", 62 },
            { @"sixty three", 63 },
            { @"sixty four", 64 },
            { @"sixty five", 65 },
            { @"sixty six", 66 },
            { @"sixty seven", 67 },
            { @"sixty eight", 68 },
            { @"sixty nine", 69 },
            { @"seventy", 70 },
            { @"seventy one", 71 },
            { @"seventy two", 72 },
            { @"seventy three", 73 },
            { @"seventy four", 74 },
            { @"seventy five", 75 },
            { @"seventy six", 76 },
            { @"seventy seven", 77 },
            { @"seventy eight", 78 },
            { @"seventy nine", 79 },
            { @"eighty", 80 },
            { @"eighty one", 81 },
            { @"eighty two", 82 },
            { @"eighty three", 83 },
            { @"eighty four", 84 },
            { @"eighty five", 85 },
            { @"eighty six", 86 },
            { @"eighty seven", 87 },
            { @"eighty eight", 88 },
            { @"eighty nine", 89 },
            { @"ninety", 90 },
            { @"ninety one", 91 },
            { @"ninety two", 92 },
            { @"ninety three", 93 },
            { @"ninety four", 94 },
            { @"ninety five", 95 },
            { @"ninety six", 96 },
            { @"ninety seven", 97 },
            { @"ninety eight", 98 },
            { @"ninety nine", 99 },
            { @"one hundred", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1st", 1 },
            { @"2nd", 2 },
            { @"3rd", 3 },
            { @"4th", 4 },
            { @"5th", 5 },
            { @"6th", 6 },
            { @"7th", 7 },
            { @"8th", 8 },
            { @"9th", 9 },
            { @"10th", 10 },
            { @"11th", 11 },
            { @"11st", 11 },
            { @"12th", 12 },
            { @"12nd", 12 },
            { @"13th", 13 },
            { @"13rd", 13 },
            { @"14th", 14 },
            { @"15th", 15 },
            { @"16th", 16 },
            { @"17th", 17 },
            { @"18th", 18 },
            { @"19th", 19 },
            { @"20th", 20 },
            { @"21st", 21 },
            { @"21th", 21 },
            { @"22nd", 22 },
            { @"22th", 22 },
            { @"23rd", 23 },
            { @"23th", 23 },
            { @"24th", 24 },
            { @"25th", 25 },
            { @"26th", 26 },
            { @"27th", 27 },
            { @"28th", 28 },
            { @"29th", 29 },
            { @"30th", 30 },
            { @"31st", 31 },
            { @"01st", 1 },
            { @"02nd", 2 },
            { @"03rd", 3 },
            { @"04th", 4 },
            { @"05th", 5 },
            { @"06th", 6 },
            { @"07th", 7 },
            { @"08th", 8 },
            { @"09th", 9 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"half", 0.5 },
            { @"साढ़े", 0.5 },
            { @"साढ़े", 0.5 },
            { @"quarter", 0.25 },
            { @"तिमाही", 0.25 },
            { @"ढाई", 2.5 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"indianindependence", new string[] { @"स्वतंत्रतादिवस", @"स्वतंत्रता", @"आजादी" } },
            { @"republicday", new string[] { @"गणतंत्रदिवस", @"गणतंत्र", @"गणतंत्रता" } },
            { @"yogaday", new string[] { @"योगदिवस", @"योग" } },
            { @"holi", new string[] { @"होली" } },
            { @"diwali", new string[] { @"दिवाली" } },
            { @"gandhijayanti", new string[] { @"गांधीजयंती", @"गांधीजयंतीकेदिन" } },
            { @"easterday", new string[] { @"easterday", @"easter", @"eastersunday", @"ईस्टरसंडे" } },
            { @"ashwednesday", new string[] { @"ashwednesday" } },
            { @"palmsunday", new string[] { @"palmsunday" } },
            { @"maundythursday", new string[] { @"maundythursday" } },
            { @"goodfriday", new string[] { @"goodfriday" } },
            { @"eastersaturday", new string[] { @"eastersaturday" } },
            { @"eastermonday", new string[] { @"eastermonday" } },
            { @"ascensionday", new string[] { @"ascensionday" } },
            { @"whitesunday", new string[] { @"whitesunday", @"pentecost", @"pentecostday" } },
            { @"whitemonday", new string[] { @"whitemonday" } },
            { @"trinitysunday", new string[] { @"trinitysunday" } },
            { @"corpuschristi", new string[] { @"corpuschristi" } },
            { @"earthday", new string[] { @"earthday", @"पृथ्वीदिवस" } },
            { @"fathers", new string[] { @"fatherday", @"fathersday", @"फादर्सडे" } },
            { @"mothers", new string[] { @"motherday", @"mothersday" } },
            { @"thanksgiving", new string[] { @"thanksgivingday", @"thanksgiving", @"थैंक्सगिविंगकेदिन", @"थैंक्सगिविंग" } },
            { @"blackfriday", new string[] { @"blackfriday", @"ब्लैकफ़्राइड" } },
            { @"cybermonday", new string[] { @"cybermonday", @"सायबरमंडे" } },
            { @"martinlutherking", new string[] { @"mlkday", @"martinlutherkingday", @"martinlutherkingjrday", @"मार्टिनलूथरकिंगदिवस", @"एमएलकेदिवस" } },
            { @"washingtonsbirthday", new string[] { @"washingtonsbirthday", @"washingtonbirthday", @"presidentsday", @"प्रेसिडेंट्सडे" } },
            { @"canberra", new string[] { @"canberraday" } },
            { @"labour", new string[] { @"labourday", @"laborday" } },
            { @"columbus", new string[] { @"columbusday" } },
            { @"memorial", new string[] { @"memorialday" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"maosbirthday", new string[] { @"maosbirthday" } },
            { @"teachersday", new string[] { @"teachersday", @"teacherday" } },
            { @"singleday", new string[] { @"singleday" } },
            { @"allsaintsday", new string[] { @"allsaintsday" } },
            { @"youthday", new string[] { @"youthday" } },
            { @"childrenday", new string[] { @"childrenday", @"childday" } },
            { @"femaleday", new string[] { @"femaleday" } },
            { @"treeplantingday", new string[] { @"treeplantingday" } },
            { @"arborday", new string[] { @"arborday" } },
            { @"girlsday", new string[] { @"girlsday" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"loverday" } },
            { @"christmas", new string[] { @"christmasday", @"christmas", @"क्रिसमस", @"क्रिसमसकेदिन", @"क्रिसमसकेवालेदिन" } },
            { @"xmas", new string[] { @"xmasday", @"xmas" } },
            { @"newyear", new string[] { @"newyear", @"नयासाल" } },
            { @"newyearday", new string[] { @"newyearday" } },
            { @"newyearsday", new string[] { @"newyearsday" } },
            { @"inaugurationday", new string[] { @"inaugurationday" } },
            { @"groundhougday", new string[] { @"groundhougday" } },
            { @"valentinesday", new string[] { @"valentinesday" } },
            { @"stpatrickday", new string[] { @"stpatrickday", @"stpatricksday", @"stpatrick", @"सेंटपैट्रिक्सडे", @"सेंटपैट्रिक्स" } },
            { @"aprilfools", new string[] { @"aprilfools" } },
            { @"stgeorgeday", new string[] { @"stgeorgeday" } },
            { @"mayday", new string[] { @"mayday", @"intlworkersday", @"internationalworkersday", @"मजदूरदिवस", @"श्रमिकदिवस", @"अंतर्राष्ट्रीयमजदूरदिवस", @"मईदिवस" } },
            { @"cincodemayoday", new string[] { @"cincodemayoday" } },
            { @"baptisteday", new string[] { @"baptisteday" } },
            { @"usindependenceday", new string[] { @"usindependenceday" } },
            { @"independenceday", new string[] { @"independenceday" } },
            { @"bastilleday", new string[] { @"bastilleday" } },
            { @"halloweenday", new string[] { @"halloweenday", @"halloween", @"हैलोवीन" } },
            { @"allhallowday", new string[] { @"allhallowday" } },
            { @"allsoulsday", new string[] { @"allsoulsday" } },
            { @"guyfawkesday", new string[] { @"guyfawkesday" } },
            { @"veteransday", new string[] { @"veteransday" } },
            { @"christmaseve", new string[] { @"christmaseve" } },
            { @"newyeareve", new string[] { @"newyearseve", @"newyeareve", @"नएसालकीशाम", @"नववर्षकीपूर्वसंध्या", @"न्यूइयरईव" } },
            { @"rakshabandhan", new string[] { @"रक्षाबंधनकेदिन", @"रक्षाबंधन" } },
            { @"vaishakhi", new string[] { @"बैसाखीहरसाल", @"बैसाखी", @"वैशाखी" } }
        };
      public static readonly Dictionary<int, IEnumerable<int>> HoliDiwaliRakshabandhanBaisakhiDates = new Dictionary<int, IEnumerable<int>>
        {
            { 1900, new int[] { 3, 16, 10, 23, 8, 10, 4, 13 } },
            { 1901, new int[] { 3, 05, 11, 11, 8, 29, 4, 13 } },
            { 1902, new int[] { 3, 24, 10, 31, 8, 19, 4, 13 } },
            { 1903, new int[] { 3, 13, 10, 20, 8, 08, 4, 13 } },
            { 1904, new int[] { 3, 02, 11, 07, 8, 25, 4, 13 } },
            { 1905, new int[] { 3, 21, 10, 28, 8, 15, 4, 13 } },
            { 1906, new int[] { 3, 10, 10, 17, 8, 04, 4, 13 } },
            { 1907, new int[] { 3, 29, 11, 05, 8, 23, 4, 13 } },
            { 1908, new int[] { 3, 18, 10, 25, 8, 12, 4, 13 } },
            { 1909, new int[] { 3, 07, 11, 13, 8, 31, 4, 13 } },
            { 1910, new int[] { 3, 25, 11, 02, 8, 20, 4, 13 } },
            { 1911, new int[] { 3, 14, 10, 22, 8, 09, 4, 13 } },
            { 1912, new int[] { 3, 03, 11, 09, 8, 27, 4, 13 } },
            { 1913, new int[] { 3, 22, 10, 29, 8, 16, 4, 13 } },
            { 1914, new int[] { 3, 12, 10, 19, 8, 05, 4, 13 } },
            { 1915, new int[] { 3, 01, 11, 07, 8, 24, 4, 13 } },
            { 1916, new int[] { 3, 19, 10, 26, 8, 13, 4, 13 } },
            { 1917, new int[] { 3, 08, 11, 14, 8, 03, 4, 13 } },
            { 1918, new int[] { 3, 27, 11, 03, 8, 22, 4, 13 } },
            { 1919, new int[] { 3, 16, 10, 23, 8, 11, 4, 13 } },
            { 1920, new int[] { 3, 04, 11, 10, 8, 29, 4, 13 } },
            { 1921, new int[] { 3, 23, 10, 30, 8, 18, 4, 13 } },
            { 1922, new int[] { 3, 13, 10, 20, 8, 07, 4, 13 } },
            { 1923, new int[] { 3, 03, 11, 08, 8, 26, 4, 13 } },
            { 1924, new int[] { 3, 21, 10, 28, 8, 14, 4, 13 } },
            { 1925, new int[] { 3, 10, 10, 17, 8, 04, 4, 13 } },
            { 1926, new int[] { 3, 29, 11, 05, 8, 23, 4, 13 } },
            { 1927, new int[] { 3, 18, 10, 25, 8, 13, 4, 14 } },
            { 1928, new int[] { 3, 06, 11, 12, 8, 30, 4, 13 } },
            { 1929, new int[] { 3, 25, 11, 01, 8, 20, 4, 13 } },
            { 1930, new int[] { 3, 14, 10, 21, 8, 09, 4, 13 } },
            { 1931, new int[] { 3, 04, 11, 09, 8, 28, 4, 14 } },
            { 1932, new int[] { 3, 22, 10, 29, 8, 16, 4, 13 } },
            { 1933, new int[] { 3, 12, 10, 19, 8, 05, 4, 13 } },
            { 1934, new int[] { 3, 01, 11, 07, 8, 24, 4, 13 } },
            { 1935, new int[] { 3, 20, 10, 27, 8, 14, 4, 14 } },
            { 1936, new int[] { 3, 08, 11, 14, 8, 03, 4, 13 } },
            { 1937, new int[] { 3, 26, 11, 03, 8, 21, 4, 13 } },
            { 1938, new int[] { 3, 16, 10, 23, 8, 11, 4, 13 } },
            { 1939, new int[] { 3, 05, 11, 11, 8, 29, 4, 14 } },
            { 1940, new int[] { 3, 23, 10, 30, 8, 17, 4, 13 } },
            { 1941, new int[] { 3, 13, 10, 20, 8, 07, 4, 13 } },
            { 1942, new int[] { 3, 03, 11, 08, 8, 26, 4, 13 } },
            { 1943, new int[] { 3, 21, 10, 29, 8, 15, 4, 14 } },
            { 1944, new int[] { 3, 10, 10, 17, 8, 04, 4, 13 } },
            { 1945, new int[] { 2, 26, 11, 04, 8, 23, 4, 13 } },
            { 1946, new int[] { 3, 17, 10, 24, 8, 12, 4, 13 } },
            { 1947, new int[] { 3, 07, 11, 12, 8, 31, 4, 14 } },
            { 1948, new int[] { 3, 25, 11, 01, 8, 19, 4, 13 } },
            { 1949, new int[] { 3, 14, 10, 21, 8, 08, 4, 13 } },
            { 1950, new int[] { 3, 04, 11, 09, 8, 27, 4, 13 } },
            { 1951, new int[] { 3, 23, 10, 30, 8, 17, 4, 14 } },
            { 1952, new int[] { 3, 11, 10, 18, 8, 05, 4, 13 } },
            { 1953, new int[] { 2, 28, 11, 06, 8, 24, 4, 13 } },
            { 1954, new int[] { 3, 19, 10, 26, 8, 14, 4, 13 } },
            { 1955, new int[] { 3, 08, 11, 14, 8, 03, 4, 14 } },
            { 1956, new int[] { 3, 26, 11, 02, 8, 21, 4, 13 } },
            { 1957, new int[] { 3, 16, 10, 23, 8, 10, 4, 13 } },
            { 1958, new int[] { 3, 05, 11, 11, 8, 29, 4, 13 } },
            { 1959, new int[] { 3, 24, 10, 31, 8, 18, 4, 14 } },
            { 1960, new int[] { 3, 13, 10, 20, 8, 06, 4, 13 } },
            { 1961, new int[] { 3, 02, 11, 08, 8, 26, 4, 13 } },
            { 1962, new int[] { 3, 21, 10, 28, 8, 15, 4, 13 } },
            { 1963, new int[] { 3, 10, 10, 17, 8, 05, 4, 14 } },
            { 1964, new int[] { 3, 28, 11, 04, 8, 23, 4, 13 } },
            { 1965, new int[] { 3, 17, 10, 24, 8, 12, 4, 13 } },
            { 1966, new int[] { 3, 07, 11, 12, 8, 30, 4, 14 } },
            { 1967, new int[] { 3, 26, 11, 02, 8, 19, 4, 14 } },
            { 1968, new int[] { 3, 14, 10, 21, 8, 08, 4, 13 } },
            { 1969, new int[] { 3, 04, 11, 09, 8, 27, 4, 13 } },
            { 1970, new int[] { 3, 23, 10, 30, 8, 17, 4, 14 } },
            { 1971, new int[] { 3, 12, 10, 19, 8, 06, 4, 14 } },
            { 1972, new int[] { 2, 29, 11, 06, 8, 24, 4, 13 } },
            { 1973, new int[] { 3, 18, 10, 26, 8, 13, 4, 13 } },
            { 1974, new int[] { 3, 08, 11, 14, 8, 03, 4, 14 } },
            { 1975, new int[] { 3, 27, 11, 03, 8, 21, 4, 14 } },
            { 1976, new int[] { 3, 16, 10, 23, 8, 09, 4, 13 } },
            { 1977, new int[] { 3, 05, 11, 11, 8, 28, 4, 13 } },
            { 1978, new int[] { 3, 24, 10, 31, 8, 18, 4, 14 } },
            { 1979, new int[] { 3, 13, 10, 21, 8, 08, 4, 14 } },
            { 1980, new int[] { 3, 01, 11, 07, 8, 26, 4, 13 } },
            { 1981, new int[] { 3, 20, 10, 27, 8, 15, 4, 13 } },
            { 1982, new int[] { 3, 09, 11, 15, 8, 04, 4, 14 } },
            { 1983, new int[] { 3, 28, 11, 04, 8, 23, 4, 14 } },
            { 1984, new int[] { 3, 17, 10, 24, 8, 11, 4, 13 } },
            { 1985, new int[] { 3, 07, 11, 12, 8, 30, 4, 13 } },
            { 1986, new int[] { 3, 26, 11, 02, 8, 19, 4, 14 } },
            { 1987, new int[] { 3, 15, 10, 22, 8, 09, 4, 14 } },
            { 1988, new int[] { 3, 03, 11, 09, 8, 27, 4, 13 } },
            { 1989, new int[] { 3, 22, 10, 29, 8, 17, 4, 13 } },
            { 1990, new int[] { 3, 11, 10, 18, 8, 06, 4, 14 } },
            { 1991, new int[] { 2, 28, 11, 06, 8, 25, 4, 14 } },
            { 1992, new int[] { 3, 18, 10, 25, 8, 13, 4, 13 } },
            { 1993, new int[] { 3, 08, 11, 13, 8, 02, 4, 13 } },
            { 1994, new int[] { 3, 27, 11, 03, 8, 21, 4, 14 } },
            { 1995, new int[] { 3, 17, 10, 24, 8, 10, 4, 14 } },
            { 1996, new int[] { 3, 05, 11, 11, 8, 28, 4, 13 } },
            { 1997, new int[] { 3, 24, 10, 31, 8, 18, 4, 13 } },
            { 1998, new int[] { 3, 13, 10, 20, 8, 07, 4, 14 } },
            { 1999, new int[] { 3, 02, 11, 08, 8, 26, 4, 14 } },
            { 2000, new int[] { 3, 20, 10, 27, 8, 15, 4, 13 } },
            { 2001, new int[] { 3, 09, 11, 15, 8, 04, 4, 13 } },
            { 2002, new int[] { 3, 28, 11, 04, 8, 22, 4, 14 } },
            { 2003, new int[] { 3, 18, 10, 25, 8, 12, 4, 14 } },
            { 2004, new int[] { 3, 06, 11, 12, 8, 29, 4, 13 } },
            { 2005, new int[] { 3, 25, 11, 02, 8, 19, 4, 14 } },
            { 2006, new int[] { 3, 14, 10, 22, 8, 09, 4, 14 } },
            { 2007, new int[] { 3, 03, 11, 09, 8, 28, 4, 14 } },
            { 2008, new int[] { 3, 21, 10, 28, 8, 16, 4, 13 } },
            { 2009, new int[] { 3, 11, 10, 18, 8, 05, 4, 14 } },
            { 2010, new int[] { 2, 28, 11, 06, 8, 24, 4, 14 } },
            { 2011, new int[] { 3, 19, 10, 26, 8, 13, 4, 14 } },
            { 2012, new int[] { 3, 08, 11, 13, 8, 02, 4, 13 } },
            { 2013, new int[] { 3, 27, 11, 03, 8, 20, 4, 14 } },
            { 2014, new int[] { 3, 16, 10, 23, 8, 10, 4, 14 } },
            { 2015, new int[] { 3, 05, 11, 11, 8, 29, 4, 14 } },
            { 2016, new int[] { 3, 23, 10, 30, 8, 18, 4, 13 } },
            { 2017, new int[] { 3, 12, 10, 19, 8, 07, 4, 14 } },
            { 2018, new int[] { 3, 02, 11, 07, 8, 26, 4, 14 } },
            { 2019, new int[] { 3, 21, 10, 28, 8, 15, 4, 14 } },
            { 2020, new int[] { 3, 09, 11, 15, 8, 03, 4, 13 } },
            { 2021, new int[] { 3, 28, 11, 04, 8, 22, 4, 14 } },
            { 2022, new int[] { 3, 18, 10, 25, 8, 11, 4, 14 } },
            { 2023, new int[] { 3, 07, 11, 13, 8, 30, 4, 14 } },
            { 2024, new int[] { 3, 25, 11, 01, 8, 19, 4, 13 } },
            { 2025, new int[] { 3, 14, 10, 21, 8, 09, 4, 14 } },
            { 2026, new int[] { 3, 03, 11, 09, 8, 28, 4, 14 } },
            { 2027, new int[] { 3, 22, 10, 29, 8, 17, 4, 14 } },
            { 2028, new int[] { 3, 11, 10, 18, 8, 05, 4, 13 } },
            { 2029, new int[] { 2, 28, 11, 06, 8, 23, 4, 14 } },
            { 2030, new int[] { 3, 19, 10, 26, 8, 13, 4, 14 } },
            { 2031, new int[] { 3, 09, 11, 14, 8, 02, 4, 14 } },
            { 2032, new int[] { 3, 27, 11, 03, 8, 20, 4, 13 } },
            { 2033, new int[] { 3, 16, 10, 23, 8, 10, 4, 14 } },
            { 2034, new int[] { 3, 05, 11, 11, 8, 29, 4, 14 } },
            { 2035, new int[] { 3, 23, 10, 31, 8, 18, 4, 14 } },
            { 2036, new int[] { 3, 12, 10, 19, 8, 06, 4, 13 } },
            { 2037, new int[] { 3, 01, 11, 07, 8, 25, 4, 14 } },
            { 2038, new int[] { 3, 21, 10, 28, 8, 14, 4, 14 } },
            { 2039, new int[] { 3, 10, 11, 16, 8, 04, 4, 14 } },
            { 2040, new int[] { 3, 28, 11, 04, 8, 22, 4, 13 } },
            { 2041, new int[] { 3, 17, 10, 25, 8, 11, 4, 14 } },
            { 2042, new int[] { 3, 06, 11, 12, 8, 30, 4, 14 } },
            { 2043, new int[] { 3, 25, 11, 01, 8, 20, 4, 14 } },
            { 2044, new int[] { 3, 13, 10, 20, 8, 08, 4, 13 } },
            { 2045, new int[] { 3, 03, 11, 08, 8, 27, 4, 14 } },
            { 2046, new int[] { 3, 22, 10, 29, 8, 16, 4, 14 } },
            { 2047, new int[] { 3, 12, 10, 19, 8, 05, 4, 14 } },
            { 2048, new int[] { 2, 29, 11, 06, 8, 23, 4, 14 } },
            { 2049, new int[] { 3, 19, 10, 26, 8, 13, 4, 14 } },
            { 2050, new int[] { 3, 08, 11, 14, 8, 02, 4, 14 } },
            { 2051, new int[] { 3, 27, 11, 03, 8, 21, 4, 14 } },
            { 2052, new int[] { 3, 15, 10, 22, 8, 10, 4, 14 } },
            { 2053, new int[] { 3, 04, 11, 10, 8, 29, 4, 14 } },
            { 2054, new int[] { 3, 23, 10, 30, 8, 18, 4, 14 } },
            { 2055, new int[] { 3, 13, 10, 20, 8, 07, 4, 14 } },
            { 2056, new int[] { 3, 02, 11, 07, 8, 25, 4, 14 } },
            { 2057, new int[] { 3, 21, 10, 28, 8, 14, 4, 14 } },
            { 2058, new int[] { 3, 10, 11, 16, 8, 04, 4, 14 } },
            { 2059, new int[] { 3, 29, 11, 05, 8, 23, 4, 14 } },
            { 2060, new int[] { 3, 17, 10, 24, 8, 11, 4, 14 } },
            { 2061, new int[] { 3, 06, 11, 12, 8, 30, 4, 14 } },
            { 2062, new int[] { 3, 25, 11, 01, 8, 20, 4, 14 } },
            { 2063, new int[] { 3, 14, 10, 21, 8, 09, 4, 14 } },
            { 2064, new int[] { 3, 03, 11, 08, 8, 26, 4, 14 } },
            { 2065, new int[] { 3, 22, 10, 29, 8, 16, 4, 14 } },
            { 2066, new int[] { 3, 11, 10, 19, 8, 05, 4, 14 } },
            { 2067, new int[] { 3, 01, 11, 06, 8, 24, 4, 14 } },
            { 2068, new int[] { 3, 18, 10, 26, 8, 13, 4, 14 } },
            { 2069, new int[] { 3, 07, 11, 13, 9, 01, 4, 14 } },
            { 2070, new int[] { 3, 26, 11, 02, 8, 21, 4, 14 } },
            { 2071, new int[] { 3, 16, 10, 23, 8, 10, 4, 14 } },
            { 2072, new int[] { 3, 04, 11, 10, 8, 28, 4, 14 } },
            { 2073, new int[] { 3, 23, 10, 30, 8, 17, 4, 14 } },
            { 2074, new int[] { 3, 13, 10, 20, 8, 06, 4, 14 } },
            { 2075, new int[] { 3, 02, 11, 08, 8, 25, 4, 14 } },
            { 2076, new int[] { 3, 20, 10, 27, 8, 14, 4, 14 } },
            { 2077, new int[] { 3, 09, 11, 15, 8, 04, 4, 14 } },
            { 2078, new int[] { 3, 28, 11, 04, 8, 23, 4, 14 } },
            { 2079, new int[] { 3, 17, 10, 24, 8, 12, 4, 14 } },
            { 2080, new int[] { 3, 05, 11, 11, 8, 30, 4, 14 } },
            { 2081, new int[] { 3, 25, 11, 01, 8, 19, 4, 14 } },
            { 2082, new int[] { 3, 14, 10, 21, 8, 08, 4, 14 } },
            { 2083, new int[] { 3, 04, 11, 09, 8, 27, 4, 14 } },
            { 2084, new int[] { 3, 22, 10, 29, 8, 15, 4, 14 } },
            { 2085, new int[] { 3, 11, 10, 18, 8, 05, 4, 14 } },
            { 2086, new int[] { 2, 28, 11, 06, 8, 24, 4, 14 } },
            { 2087, new int[] { 3, 19, 10, 26, 8, 14, 4, 15 } },
            { 2088, new int[] { 3, 07, 11, 13, 8, 31, 4, 14 } },
            { 2089, new int[] { 3, 26, 11, 02, 8, 21, 4, 14 } },
            { 2090, new int[] { 3, 15, 10, 23, 8, 10, 4, 14 } },
            { 2091, new int[] { 3, 05, 11, 11, 8, 28, 4, 15 } },
            { 2092, new int[] { 3, 23, 10, 30, 8, 17, 4, 14 } },
            { 2093, new int[] { 3, 13, 10, 20, 8, 06, 4, 14 } },
            { 2094, new int[] { 3, 02, 11, 08, 8, 25, 4, 14 } },
            { 2095, new int[] { 3, 21, 10, 28, 8, 15, 4, 15 } },
            { 2096, new int[] { 3, 09, 11, 14, 8, 04, 4, 14 } },
            { 2097, new int[] { 3, 27, 11, 04, 8, 22, 4, 14 } },
            { 2098, new int[] { 3, 17, 10, 24, 8, 11, 4, 14 } },
            { 2099, new int[] { 3, 06, 11, 12, 8, 30, 4, 15 } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"सौ", 100 },
            { @"सत्तर", 70 },
            { @"बीस", 20 },
            { @"तीस", 30 },
            { @"अस्सी", 80 },
            { @"नब्बे", 90 },
            { @"चालीस", 40 },
            { @"पचास", 50 },
            { @"साठ", 60 },
            { @"दस", 10 },
            { @"सौ के दशक", 100 },
            { @"सत्तर के दशक", 70 },
            { @"बीस के दशक", 20 },
            { @"तीस के दशक", 30 },
            { @"अस्सी के दशक", 80 },
            { @"नब्बे के दशक", 90 },
            { @"चालीस के दशक", 40 },
            { @"पचास के दशक", 50 },
            { @"साठ के दशक", 60 },
            { @"दस के दशक", 10 },
            { @"hundreds", 0 },
            { @"tens", 10 },
            { @"twenties", 20 },
            { @"thirties", 30 },
            { @"forties", 40 },
            { @"fifties", 50 },
            { @"sixties", 60 },
            { @"seventies", 70 },
            { @"eighties", 80 },
            { @"nineties", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"noughties", 2000 },
            { @"aughts", 2000 },
            { @"two thousands", 2000 },
            { @"दो हजार", 2000 },
            { @"दो हजार के दशक", 2000 },
            { @"इस सदी के पहले दशक", 2000 },
            { @"20वीं सदी के पहले दशक", 2000 }
        };
      public const string DefaultLanguageFallback = @"MDY";
      public static readonly IList<string> SuperfluousWordList = new List<string>
        {
            @"preferably",
            @"how about",
            @"maybe",
            @"say",
            @"like"
        };
      public static readonly string[] DurationDateRestrictions = { @"आज", @"today", @"now" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"\bदिन\b", @"\bदिन-ब-दिन\b" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"सुबह"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"दोपहर",
            @"दोपहर"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"सायं",
            @"शाम",
            @"संध्या",
            @"सायंकाल"
        };
      public static readonly IList<string> MealtimeBreakfastTermList = new List<string>
        {
            @"नाश्ता",
            @"जलपान",
            @"ब्रेकफ़ास्ट",
            @"ब्रेकफास्ट",
            @"breakfast"
        };
      public static readonly IList<string> MealtimeBrunchTermList = new List<string>
        {
            @"brunch",
            @"ब्रंच"
        };
      public static readonly IList<string> MealtimeLunchTermList = new List<string>
        {
            @"lunch",
            @"lunchtime",
            @"लंच",
            @"लंच टाइम",
            @"लंचटाइम",
            @"दोपहर का भोजन",
            @"कलेवा"
        };
      public static readonly IList<string> MealtimeDinnerTermList = new List<string>
        {
            @"dinner",
            @"dinnertime",
            @"supper",
            @"रात्रिभोजन",
            @"डिनर",
            @"सपर",
            @"डिनरटाइम"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"दिन"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"रात"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"आज"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"tomorrow",
            @"tmr",
            @"day after",
            @"कल",
            @"कल से"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"yesterday",
            @"day before",
            @"कल",
            @"कल वापस गया था",
            @"कल से पहले"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"day after tomorrow",
            @"day after tmr",
            @"परसों"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"day before yesterday",
            @"परसों वापस गया था"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"इस",
            @"अगला",
            @"अगले",
            @"अगली",
            @"दूसरे"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"पिछले",
            @"पिछला",
            @"पिछले",
            @"पिछली",
            @"आखिरी",
            @"अंतिम"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"महीना",
            @"महीने",
            @"महीनों",
            @"माह"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"month to date"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"सप्ताहांत",
            @"वीकेंड"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"week",
            @"हफ़्ते",
            @"हफ्ते",
            @"सप्ताह"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"साल",
            @"वर्षों",
            @"वर्ष"
        };
      public static readonly IList<string> GenericYearTerms = new List<string>
        {
            @"y"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"year to date"
        };
    }
}