//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\German\German-NumbersWithUnit.yaml
//     - Language: German
//     - ClassName: NumbersWithUnitDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.German
{
    using System;
    using System.Collections.Generic;

    public static class NumbersWithUnitDefinitions
    {
      public static readonly Dictionary<string, string> AgeSuffixList = new Dictionary<string, string>
        {
            { @"Year", @"jahr alt|jahre alt|jahren|jahre|lebensjahr" },
            { @"Month", @"monat alt|monate alt|monaten|monate" },
            { @"Week", @"woche alt|wochen alt|wochen|woche" },
            { @"Day", @"tag alt|tage alt|tagen|tage" }
        };
      public static readonly IList<string> AmbiguousAgeUnitList = new List<string>
        {
            @"jahren",
            @"jahre",
            @"monaten",
            @"monate",
            @"wochen",
            @"woche",
            @"tagen",
            @"tage"
        };
      public static readonly Dictionary<string, string> AreaSuffixList = new Dictionary<string, string>
        {
            { @"Square kilometer", @"qkm|quadratkilometer|km^2|km²" },
            { @"Square hectometer", @"qhm|quadrathektometer|hm^2|hm²|hektar" },
            { @"Square decameter", @"quadratdekameter|dam^2|dam²" },
            { @"Square meter", @"qm|quadratmeter|m^2|m²" },
            { @"Square decimeter", @"qdm|quadratdezimeter|dm^2|dm²" },
            { @"Square centimeter", @"qcm|quadratzentimeter|cm^2|cm²" },
            { @"Square millimeter", @"qmm|quadratmillimeter|mm^2|mm²" },
            { @"Square inch", @"sqin|quadratzoll|in^2|in²" },
            { @"Square foot", @"sqft|quadratfuß|fuß^2|fuß²|ft2|ft^2|ft²" },
            { @"Square mile", @"sqmi|quadratmeile|mi^2|mi²" },
            { @"Square yard", @"sqyd|quadratyard|yd^2|yd²" },
            { @"Acre", @"-acre|acre|acres" }
        };
      public static readonly Dictionary<string, string> CurrencySuffixList = new Dictionary<string, string>
        {
            { @"Abkhazian apsar", @"abkhazian apsar|apsars" },
            { @"Afghan afghani", @"afghanischer afghani|afghanische afghani|afghanischen afghani|؋|afn|afghani" },
            { @"Pul", @"pul" },
            { @"Euro", @"euro|€|eur" },
            { @"Cent", @"cent|-cent" },
            { @"Albanian lek", @"albaninischer Lek|albanische Lek|albanischen Lek" },
            { @"Qindarkë", @"qindarkë|qindarkës|qindarke|qindarkes" },
            { @"Angolan kwanza", @"angolanischer kwanza|angolanische kwanza|angolanischen kwanza|kz|aoa|kwanza|kwanzas" },
            { @"Armenian dram", @"armeninischer dram|armeninische dram|armeninischen dram" },
            { @"Aruban florin", @"Aruba-Florin|ƒ|awg" },
            { @"Bangladeshi taka", @"bangladesischer taka|bengalischer taka|bangladesische taka|bengalische taka|bangladesischen taka|bengalischen taka|৳|bdt|taka" },
            { @"Paisa", @"poisha|paisa" },
            { @"Bhutanese ngultrum", @"bhutanischer ngultrum|bhutanische ngultrum|bhutanischen ngultrum|nu.|btn" },
            { @"Chetrum", @"chetrum" },
            { @"Bolivian boliviano", @"bolivianischer boliviano|bolivianische boliviano|bolivianischen boliviano|bob|bs.|boliviano" },
            { @"Bosnia and Herzegovina convertible mark", @"bosnischer konvertible mark|bosnisch-herzegowinischer konvertible mark|bosnische konvertible mark|bosnisch-herzegowinische konvertible mark|bosnischen konvertible mark|bosnisch-herzegowinischen konvertible mark|konvertible mark|bam" },
            { @"Fening", @"Fening" },
            { @"Botswana pula", @"botswanischer pula|botswanische pula|botswanischen pula|bwp|pula" },
            { @"Thebe", @"thebe" },
            { @"Brazilian real", @"brazilianischer real|brazilianische real|brazilianischen real|r$|brl|real" },
            { @"Bulgarian lev", @"bulgarischer lew|bulgarische lew|bulgarischen lew|bgn|лв|lew" },
            { @"Stotinka", @"stotinki|stotinka" },
            { @"Cambodian riel", @"kambodschanischer riel|kambodschanische riel|kambodschanischen riel|khr|៛|riel" },
            { @"Cape Verdean escudo", @"kap-verde-escudo|cve" },
            { @"Costa Rican colón", @"costa-rica-colón|costa-rica-colon|crc|₡" },
            { @"Salvadoran colón", @"svc|el-salvador-colón|el-salvador-colon" },
            { @"Céntimo", @"céntimo" },
            { @"Croatian kuna", @"kroatischer kuna|kroatische kuna|kroatischen kuna|kn|hrk|kuna" },
            { @"Lipa", @"lipa" },
            { @"Czech koruna", @"tschechische krone|tschechischen kronen|tschechischer kronen|czk|kč" },
            { @"Haléř", @"haléř" },
            { @"Eritrean nakfa", @"eritreischer nakfa|eritreische nakfa|eritreischen nakfa|nfk|ern|nakfa" },
            { @"Ethiopian birr", @"äthiopischer birr|äthiopische birr|äthiopischen birr|etb" },
            { @"Gambian dalasi", @"gambischer dalasi|gambische dalasi|gambischen dalasi|gmd" },
            { @"Butut", @"bututs|butut" },
            { @"Georgian lari", @"georgischer lari|georgische lari|georgischen lari|lari|gel|₾" },
            { @"Tetri", @"tetri" },
            { @"Ghanaian cedi", @"ghanaischer cedi|ghanaische cedi|ghanaischen cedi|Ghana cedi|ghs|₵|gh₵" },
            { @"Pesewa", @"pesewas|pesewa" },
            { @"Guatemalan quetzal", @"guatemaltekischer quetzal|guatemaltekische quetzal|guatemaltekischen quetzal|gtq|quetzal" },
            { @"Haitian gourde", @"haitianischer gourde|haitianische gourde|haitianischen gourde|htg" },
            { @"Honduran lempira", @"honduranischer lempira|honduranische lempira|honduranischen lempira|hnl" },
            { @"Hungarian forint", @"ungarischer forint|ungarische forint|ungarischen forint|huf|ft|forint" },
            { @"Fillér", @"fillér" },
            { @"Iranian rial", @"iranischer rial|iranische rial|iranischen rial|irr" },
            { @"Yemeni rial", @"jemen-rial|yer" },
            { @"Israeli new shekel", @"₪|ils|agora" },
            { @"Lithuanian litas", @"ltl|litauischer litas|litauische litas|litauischen litas" },
            { @"Japanese yen", @"japaneser yen|japanese yen|japanesen yen|jpy|yen|¥" },
            { @"Kazakhstani tenge", @"kasachischer tenge|kasachische tenge|kasachischen tenge|kzt" },
            { @"Kenyan shilling", @"kenia-schilling|kes" },
            { @"North Korean won", @"nordkoreanischer won|nordkoreanische won|nordkoreanischen won|kpw" },
            { @"South Korean won", @"südkoreanischer won|südkoreanische won|südkoreanischen won|krw" },
            { @"Korean won", @"koreanischer won|koreanische won|koreanischen won|₩" },
            { @"Kyrgyzstani som", @"kirgisischer som|kirgisische som|kirgisischen som|kgs" },
            { @"Uzbekitan som", @"usbekischer som|usbekische som|usbekischen som|usbekischer sum|usbekische sum|usbekischen sum|usbekischer so'm|usbekische so'm|usbekischen so'm|usbekischer soum|usbekische soum|usbekischen soum|uzs" },
            { @"Lao kip", @"laotischer kip|laotische kip|laotischen kip|lak|₭n|₭" },
            { @"Att", @"att" },
            { @"Lesotho loti", @"lesothischer loti|lesothische loti|lesothischen loti|lsl|loti" },
            { @"Sente", @"sente|lisente" },
            { @"South African rand", @"südafrikanischer rand|südafrikanische rand|südafrikanischen rand|zar" },
            { @"Macanese pataca", @"macao-pataca|mop$|mop" },
            { @"Avo", @"avos|avo" },
            { @"Macedonian denar", @"mazedonischer denar|mazedonische denar|mazedonischen denar|mkd|ден" },
            { @"Deni", @"deni" },
            { @"Malagasy ariary", @"madagassischer ariary|madagassische ariary|madagassischen ariary|ariary|mga" },
            { @"Iraimbilanja", @"iraimbilanja" },
            { @"Malawian kwacha", @"malawi-kwacha|mk|mwk" },
            { @"Tambala", @"tambala" },
            { @"Malaysian ringgit", @"malaysischer ringgit|malaysische ringgit|malaysischen ringgit|rm|myr" },
            { @"Mauritanian ouguiya", @"mauretanischer ouguiya|mauretanische ouguiya|mauretanischen ouguiya|mro" },
            { @"Khoums", @"khoums" },
            { @"Mongolian tögrög", @"mongolischer tögrög|mongolische tögrög|mongolischen tögrög|mongolischer tugrik|mongolische tugrik|mongolischen tugrik|mnt|₮" },
            { @"Mozambican metical", @"mosambik-metical|mosambik metical|mt|mzn" },
            { @"Burmese kyat", @"myanmar-kyat|myanmar kyat|ks|mmk" },
            { @"Pya", @"pya" },
            { @"Nicaraguan córdoba", @"nicaraguanischer córdoba oro|nicaraguanische córdoba oro|nicaraguanischen córdoba oro|nicaraguanischer córdoba|nicaraguanische córdoba|nicaraguanischen córdoba|nio|córdoba|córdoba oro" },
            { @"Nigerian naira", @"nigerianischer naira|nigerianische naira|nigerianischen naira|naira|ngn|₦|nigeria naira" },
            { @"Kobo", @"kobo" },
            { @"Turkish lira", @"türkischer lira|türkische lira|türkischen lira|tuerkischer lira|tuerkische lira|tuerkischen lira|try|tl" },
            { @"Kuruş", @"kuruş" },
            { @"Omani rial", @"omanischer rial|omanische rial|omanischen rial|omr|ر.ع." },
            { @"Panamanian balboa", @"panamaischer balboa|panamaische balboa|panamaischen balboa|b/.|pab" },
            { @"Centesimo", @"centesimo" },
            { @"Papua New Guinean kina", @"papua-neuguinea-kina|kina|pgk" },
            { @"Toea", @"toea" },
            { @"Paraguayan guaraní", @"paraguayischer guaraní|paraguayische guaraní|paraguayischen guaraní|guaraní|₲|pyg" },
            { @"Peruvian sol", @"peruanischer sol|peruanische sol|peruanischen sol|soles|sol" },
            { @"Polish złoty", @"polnischer złoty|polnische złoty|polnischen złoty|polnischer zloty|polnische zloty|polnischen zloty|zł|pln|złoty|zloty" },
            { @"Grosz", @"groszy|grosz|grosze" },
            { @"Qatari riyal", @"katar-riyal|katar riyal|qatari riyal|qar" },
            { @"Saudi riyal", @"saudi-riyal|sar" },
            { @"Riyal", @"riyal|﷼" },
            { @"Dirham", @"dirham|dirhem|dirhm" },
            { @"Halala", @"halalas|halala" },
            { @"Samoan tālā", @"samoanischer tala|samoanische tala|samoanischen tala|samoanischer tālā|samoanische tālā|samoanischen tālā|tālā|tala|ws$|samoa|wst|samoa-tālā|samoa-tala" },
            { @"Sene", @"sene" },
            { @"São Tomé and Príncipe dobra", @"são-toméischer dobra|são-toméische dobra|são-toméischen dobra|dobra|std" },
            { @"Sierra Leonean leone", @"sierra-leonischer leone|sierra-leonische leone|sierra-leonischen leone|sll|leone|le" },
            { @"Peseta", @"pesetas|peseta" },
            { @"Netherlands guilder", @"florin|antillen-gulden|niederländische-antillen-gulden|antillen gulden|ang|niederländischer gulden|niederländische gulden|niederländischen gulden|gulden|fl" },
            { @"Swazi lilangeni", @"swazi-lilangeni|swazi lilangeni|lilangeni|szl|swazi-emalangeni|swazi emalangeni" },
            { @"Tajikistani somoni", @"tadschikischer somoni|tadschikische somoni|tadschikischen somoni|tadschikistan-somoni|tadschikistan somoni|tajikischer somoni|tajikische somoni|tajikischen somoni|tajikistan-somoni|tajikistan somoni|tjs" },
            { @"Diram", @"dirams|diram" },
            { @"Thai baht", @"thailändischer baht|thailändische baht|thailändischen baht|thailaendischer baht|thailaendische baht|thailaendischen baht|thai baht|thai-baht|฿|thb" },
            { @"Satang", @"satang|satangs" },
            { @"Tongan paʻanga", @"tongaischer paʻanga|tongaische paʻanga|tongaischen paʻanga|paʻanga|tonga paʻanga|tongaischer pa'anga|tongaische pa'anga|tongaischen pa'anga|pa'anga|tonga pa'anga" },
            { @"Seniti", @"seniti" },
            { @"Ukrainian hryvnia", @"ukrainischer hrywnja|ukrainische hrywnja|ukrainischen hrywnja|hrywnja|uah|₴" },
            { @"Vanuatu vatu", @"vanuatu-vatu|vanuatu vatu|vatu|vuv" },
            { @"Venezuelan bolívar", @"venezolanischer bolívar|venezolanische bolívar|venezolanischen bolívar|bs.f.|vef" },
            { @"Vietnamese dong", @"vietnamesischer đồng|vietnamesische đồng|vietnamesischen đồng|vietnamesischer dong|vietnamesische dong|vietnamesischen dong|vnd|đồng" },
            { @"Zambian kwacha", @"sambischer kwacha|sambische kwacha|sambischen kwacha|zk|zmw" },
            { @"Moroccan dirham", @"marokkanischer dirham|marokkanische dirham|marokkanischen dirham|mad|د.م." },
            { @"United Arab Emirates dirham", @"vae dirham|vae-dirham|dirham der vereinigten arabischen emirate|د.إ|aed" },
            { @"Azerbaijani manat", @"aserbaidschan-manat|azn" },
            { @"Turkmenistan manat", @"turkmenistan-manat|tmt" },
            { @"Manat", @"manat|manats" },
            { @"Qəpik", @"qəpik" },
            { @"Somali shilling", @"somalia-schilling|sh.so.|sos" },
            { @"Somaliland shilling", @"somaliland-schilling" },
            { @"Tanzanian shilling", @"tansania-schilling|tsh|tzs" },
            { @"Ugandan shilling", @"uganda-schilling|ugx" },
            { @"Romanian leu", @"rumänischer leu|rumänische leu|rumänischen leu|rumaenischer leu|rumaenische leu|rumaenischen leu|lei|ron" },
            { @"Moldovan leu", @"moldauischer leu|moldauische leu|moldauischen leu|mdl|moldau leu" },
            { @"Leu", @"leu" },
            { @"Ban", @"bani|ban" },
            { @"Nepalese rupee", @"nepalesischer rupie|nepalesische rupie|nepalesischen rupie|nepalesische rupien|nepalesischer rupien|nepalesischen rupien|npr" },
            { @"Pakistani rupee", @"pakistanischer rupie|pakistanische rupie|pakistanischen rupie|pakistanischer rupien|pakistanische rupien|pakistanischen rupien|pkr" },
            { @"Indian rupee", @"indischer rupie|indische rupie|indischen rupie|indischer rupien|indische rupien|indischen rupien|inr|₹" },
            { @"Seychellois rupee", @"seychellen-rupie|seychellen-rupien|scr|sr|sre" },
            { @"Mauritian rupee", @"mauritius-rupie|mauritius-rupien|mur" },
            { @"Maldivian rufiyaa", @"maledivischer rufiyaa|maledivische rufiyaa|maledivischen rufiyaa|mvr|.ރ" },
            { @"Sri Lankan rupee", @"sri-lanka-rupie|sri-lanka-rupien|lkr|රු|ரூ" },
            { @"Indonesian rupiah", @"indonesischer rupiah|indonesische rupiah|indonesischen rupiah|rupiah|perak|rp|idr" },
            { @"Rupee", @"rupie|rupien|rs" },
            { @"Danish krone", @"dänische krone|dänischen krone|dänischer kronen|dänische kronen|dänischen kronen|daenische krone|daenischen krone|daenischer kronen|daenische kronen|daenischen kronen|dkk" },
            { @"Norwegian krone", @"norwegische krone|norwegischen krone|norwegischer kronen|norwegische kronen|norwegischen kronen|nok" },
            { @"Faroese króna", @"färöische króna|färöische krone|färöischen krone|färöischer kronen|färöische kronen|färöischen kronen" },
            { @"Icelandic króna", @"isländische krone|isländischen krone|isländischer kronen|isländische kronen|isländischen kronen|isk" },
            { @"Swedish krona", @"schwedische krone|schwedischen krone|schwedischer kronen|schwedische kronen|schwedischen kronen|sek" },
            { @"Krone", @"krone|kronen|kr|-kr" },
            { @"Øre", @"Øre|oyra|eyrir" },
            { @"West African CFA franc", @"west african cfa franc|xof|westafrikanische cfa franc|westafrikanische-cfa-franc" },
            { @"Central African CFA franc", @"central african cfa franc|xaf|zentralafrikanische cfa franc|zentralafrikanische-cfa-franc" },
            { @"Comorian franc", @"komoren-franc|kmf" },
            { @"Congolese franc", @"kongo-franc|cdf" },
            { @"Burundian franc", @"burundi-franc|bif" },
            { @"Djiboutian franc", @"dschibuti-franc|djf" },
            { @"CFP franc", @"cfp-franc|xpf" },
            { @"Guinean franc", @"franc guinéen|franc-guinéen|gnf" },
            { @"Swiss franc", @"schweizer franken|schweizer-franken|chf|sfr." },
            { @"Rwandan franc", @"ruanda-franc|rwf|rf|r₣|frw" },
            { @"Belgian franc", @"belgischer franken|belgische franken|belgischen franken|bi.|b.fr.|bef" },
            { @"Rappen", @"rappen|-rappen" },
            { @"Franc", @"franc|französischer franc|französische franc|französischen franc|französischer franken|französische franken|französischen franken|franken|fr.|fs" },
            { @"Centime", @"centimes|centime|santim" },
            { @"Russian ruble", @"russischer rubel|russische rubel|russischen rubel|₽|rub" },
            { @"New Belarusian ruble", @"neuer weißrussischer rubel|neue weißrussische rubel|neuen weißrussischen rubel|neuem weißrussischen rubel" },
            { @"Old Belarusian ruble", @"alter weißrussischer rubel|alte weißrussische rubel|alten weißrussischen rubel|altem weißrussischen rubel" },
            { @"Transnistrian ruble", @"transnistrischer rubel|transnistrische rubel|transnistrischen rubel|prb|р." },
            { @"Belarusian ruble", @"weißrussischer rubel|weißrussische rubel|weißrussischen rubel" },
            { @"Kopek", @"kopek|kopeks" },
            { @"Kapyeyka", @"kapyeyka" },
            { @"Ruble", @"rubel|br" },
            { @"Algerian dinar", @"algerischer dinar|algerische dinar|algerischen dinar|د.ج|dzd" },
            { @"Bahraini dinar", @"bahrain-dinar|bhd|.د.ب" },
            { @"Santeem", @"santeem|santeeme" },
            { @"Iraqi dinar", @"irakischer dinar|irakische dinar|irakischen dinar|iqd|ع.د" },
            { @"Jordanian dinar", @"jordanischer dinar|jordanische dinar|jordanischen dinar|د.ا|jod" },
            { @"Kuwaiti dinar", @"kuwait-dinar|kwd|د.ك" },
            { @"Libyan dinar", @"libyscher dinar|libysche dinar|libyschen dinar|lyd" },
            { @"Serbian dinar", @"serbischer dinar|serbische dinar|serbischen dinar|din.|rsd|дин." },
            { @"Tunisian dinar", @"tunesischer dinar|tunesische dinar|tunesischen dinar|tnd" },
            { @"Yugoslav dinar", @"jugoslawischer dinar|jugoslawische dinar|jugoslawischen dinar|yun" },
            { @"Dinar", @"dinar|denar" },
            { @"Fils", @"fils|fulūs" },
            { @"Para", @"para|napa" },
            { @"Millime", @"millime" },
            { @"Argentine peso", @"argentinischer peso|argentinische peso|argentinischen peso|ars" },
            { @"Chilean peso", @"chilenischer peso|chilenische peso|chilenischen peso|clp" },
            { @"Colombian peso", @"kolumbianischer peso|kolumbianische peso|kolumbianischen peso|cop" },
            { @"Cuban convertible peso", @"kubanischer peso convertible|kubanische peso convertible|kubanischen peso convertible|peso convertible|cuc" },
            { @"Cuban peso", @"kubanischer peso|kubanische peso|kubanischen peso|cup" },
            { @"Dominican peso", @"dominican pesos|dominican peso|dop|dominica pesos|dominica peso" },
            { @"Mexican peso", @"mexikanischer peso|mexikanische peso|mexikanischen peso|mxn" },
            { @"Philippine peso", @"piso|philippinischer peso|philippinische peso|philippinischen peso|₱|php" },
            { @"Uruguayan peso", @"uruguayischer peso|uruguayische peso|uruguayischen peso|uyu" },
            { @"Peso", @"peso|pesos" },
            { @"Centavo", @"centavos|centavo" },
            { @"Alderney pound", @"alderney pfund|alderney £" },
            { @"British pound", @"britischer pfund|britische pfund|britischen pfund|british £|gbp|pfund sterling" },
            { @"Guernsey pound", @"guernsey-pfund|guernsey £|ggp" },
            { @"Ascension pound", @"ascension-pfund|ascension pound|ascension £" },
            { @"Saint Helena pound", @"st.-helena-pfund|saint helena £|shp" },
            { @"Egyptian pound", @"ägyptisches pfund|ägyptische pfund|ägyptischen pfund|ägyptisches £|egp|ج.م" },
            { @"Falkland Islands pound", @"falkland-pfund|falkland £|fkp|falkland-£" },
            { @"Gibraltar pound", @"gibraltar-pfund|gibraltar £|gibraltar-£|gip" },
            { @"Manx pound", @"isle-of-man-pfund|isle-of-man-£|imp" },
            { @"Jersey pound", @"jersey-pfund|jersey-£|jep" },
            { @"Lebanese pound", @"libanesisches pfund|libanesische pfund|libanesischen pfund|libanesisches-£|lbp|ل.ل" },
            { @"South Georgia and the South Sandwich Islands pound", @"süd-georgien & die südlichen sandwichinseln pfund|süd-georgien & die südlichen sandwichinseln £" },
            { @"South Sudanese pound", @"südsudanesisches pfund|südsudanesische pfund|südsudanesischen pfund|südsudanesisches £|ssp|südsudanesische £" },
            { @"Sudanese pound", @"sudanesisches pfund|sudanesische pfund|sudanesischen pfund|sudanesisches £|ج.س.|sdg|sudanesische £" },
            { @"Syrian pound", @"syrisches pfund|syrische pfund|syrischen pfund|syrisches £|ل.س|syp|syrische £" },
            { @"Tristan da Cunha pound", @"tristan-da-cunha-pfund|tristan-da-cunha-£" },
            { @"Pound", @"pfund|£" },
            { @"Pence", @"pence" },
            { @"Shilling", @"shillings|shilling|shilingi|sh" },
            { @"Penny", @"pennies|penny" },
            { @"United States dollar", @"us-dollar|us$|usd|amerikanischer dollar|amerikanische dollar|amerikanischen dollar" },
            { @"East Caribbean dollar", @"ostkaribischer dollar|ostkaribische dollar|ostkaribischen dollar|ostkaribische $|xcd" },
            { @"Australian dollar", @"australischer dollar|australische dollar|australischen dollar|australische $|aud" },
            { @"Bahamian dollar", @"bahama-dollar|bahama-$|bsd" },
            { @"Barbadian dollar", @"barbados-dollar|barbados-$|bbd" },
            { @"Belize dollar", @"belize-dollar|belize-$|bzd" },
            { @"Bermudian dollar", @"bermuda-dollar|bermuda-$|bmd" },
            { @"British Virgin Islands dollar", @"british virgin islands dollars|british virgin islands dollar|british virgin islands $|bvi$|virgin islands dollars|virgin islands dolalr|virgin islands $|virgin island dollars|virgin island dollar|virgin island $" },
            { @"Brunei dollar", @"brunei-dollar|brunei $|bnd" },
            { @"Sen", @"sen" },
            { @"Singapore dollar", @"singapur-dollar|singapur-$|s$|sgd" },
            { @"Canadian dollar", @"kanadischer dollar|kanadische dollar|kanadischen dollar|cad|can$|c$" },
            { @"Cayman Islands dollar", @"kaiman-dollar|kaiman-$|kyd|ci$" },
            { @"New Zealand dollar", @"neuseeland-dollar|neuseeland-$|nz$|nzd|kiwi" },
            { @"Cook Islands dollar", @"cookinseln-dollar|cookinseln-$" },
            { @"Fijian dollar", @"fidschi-dollar|fidschi-$|fjd" },
            { @"Guyanese dollar", @"guyana-dollar|gyd|gy$" },
            { @"Hong Kong dollar", @"hongkong-dollar|hong kong $|hk$|hkd|hk dollars|hk dollar|hk $|hongkong$" },
            { @"Jamaican dollar", @"jamaika-dollar|jamaika-$|j$" },
            { @"Kiribati dollar", @"kiribati-dollar|kiribati-$" },
            { @"Liberian dollar", @"liberianischer dollar|liberianische dollar|liberianischen dollar|liberianische $|lrd" },
            { @"Micronesian dollar", @"mikronesischer dollar|mikronesische dollar|mikronesischen dollar|mikronesische $" },
            { @"Namibian dollar", @"namibia-dollar|namibia-$|nad|n$" },
            { @"Nauruan dollar", @"nauru-dollar|nauru-$" },
            { @"Niue dollar", @"niue-dollar|niue-$" },
            { @"Palauan dollar", @"palau-dollar|palau-$" },
            { @"Pitcairn Islands dollar", @"pitcairninseln-dollar|pitcairninseln-$" },
            { @"Solomon Islands dollar", @"salomonen-dollar|salomonen-$|si$|sbd" },
            { @"Surinamese dollar", @"suriname-dollar|suriname-$|srd" },
            { @"New Taiwan dollar", @"neuer taiwan-dollar|neue taiwan-dollar|neuen taiwan-dollar|nt$|twd|ntd" },
            { @"Trinidad and Tobago dollar", @"trinidad-und-tobago-dollar|trinidad-und-tobago-$|ttd" },
            { @"Tuvaluan dollar", @"tuvaluischer dollar|tuvaluische dollar|tuvaluischen dollar|tuvaluische $" },
            { @"Dollar", @"dollar|$" },
            { @"Chinese yuan", @"yuan|chinesischer yuan|chinesische yuan|chinesischen yuan|renminbi|cny|rmb|￥" },
            { @"Fen", @"fen" },
            { @"Jiao", @"jiao" },
            { @"Finnish markka", @"suomen markka|finnish markka|finsk mark|fim|markkaa|markka|finnische mark|finnischen mark" },
            { @"Penni", @"penniä|penni" },
            { @"Bitcoin", @"bitcoin|bitcoins|btc|xbt|₿" },
            { @"Millibitcoin", @"millibitcoin|millibitcoins|milibitcoin|milibitcoins" }
        };
      public static readonly Dictionary<string, string> CurrencyNameToIsoCodeMap = new Dictionary<string, string>
        {
            { @"Afghan afghani", @"AFN" },
            { @"Euro", @"EUR" },
            { @"Albanian lek", @"ALL" },
            { @"Angolan kwanza", @"AOA" },
            { @"Armenian dram", @"AMD" },
            { @"Aruban florin", @"AWG" },
            { @"Bangladeshi taka", @"BDT" },
            { @"Bhutanese ngultrum", @"BTN" },
            { @"Bolivian boliviano", @"BOB" },
            { @"Bosnia and Herzegovina convertible mark", @"BAM" },
            { @"Botswana pula", @"BWP" },
            { @"Brazilian real", @"BRL" },
            { @"Bulgarian lev", @"BGN" },
            { @"Cambodian riel", @"KHR" },
            { @"Cape Verdean escudo", @"CVE" },
            { @"Costa Rican colón", @"CRC" },
            { @"Croatian kuna", @"HRK" },
            { @"Czech koruna", @"CZK" },
            { @"Eritrean nakfa", @"ERN" },
            { @"Ethiopian birr", @"ETB" },
            { @"Gambian dalasi", @"GMD" },
            { @"Georgian lari", @"GEL" },
            { @"Ghanaian cedi", @"GHS" },
            { @"Guatemalan quetzal", @"GTQ" },
            { @"Haitian gourde", @"HTG" },
            { @"Honduran lempira", @"HNL" },
            { @"Hungarian forint", @"HUF" },
            { @"Iranian rial", @"IRR" },
            { @"Yemeni rial", @"YER" },
            { @"Israeli new shekel", @"ILS" },
            { @"Japanese yen", @"JPY" },
            { @"Kazakhstani tenge", @"KZT" },
            { @"Kenyan shilling", @"KES" },
            { @"North Korean won", @"KPW" },
            { @"South Korean won", @"KRW" },
            { @"Kyrgyzstani som", @"KGS" },
            { @"Lao kip", @"LAK" },
            { @"Lesotho loti", @"LSL" },
            { @"South African rand", @"ZAR" },
            { @"Macanese pataca", @"MOP" },
            { @"Macedonian denar", @"MKD" },
            { @"Malagasy ariary", @"MGA" },
            { @"Malawian kwacha", @"MWK" },
            { @"Malaysian ringgit", @"MYR" },
            { @"Mauritanian ouguiya", @"MRO" },
            { @"Mongolian tögrög", @"MNT" },
            { @"Mozambican metical", @"MZN" },
            { @"Burmese kyat", @"MMK" },
            { @"Nicaraguan córdoba", @"NIO" },
            { @"Nigerian naira", @"NGN" },
            { @"Turkish lira", @"TRY" },
            { @"Omani rial", @"OMR" },
            { @"Panamanian balboa", @"PAB" },
            { @"Papua New Guinean kina", @"PGK" },
            { @"Paraguayan guaraní", @"PYG" },
            { @"Peruvian sol", @"PEN" },
            { @"Polish złoty", @"PLN" },
            { @"Qatari riyal", @"QAR" },
            { @"Saudi riyal", @"SAR" },
            { @"Samoan tālā", @"WST" },
            { @"São Tomé and Príncipe dobra", @"STN" },
            { @"Sierra Leonean leone", @"SLL" },
            { @"Swazi lilangeni", @"SZL" },
            { @"Tajikistani somoni", @"TJS" },
            { @"Thai baht", @"THB" },
            { @"Ukrainian hryvnia", @"UAH" },
            { @"Vanuatu vatu", @"VUV" },
            { @"Venezuelan bolívar", @"VEF" },
            { @"Zambian kwacha", @"ZMW" },
            { @"Moroccan dirham", @"MAD" },
            { @"United Arab Emirates dirham", @"AED" },
            { @"Azerbaijani manat", @"AZN" },
            { @"Turkmenistan manat", @"TMT" },
            { @"Somali shilling", @"SOS" },
            { @"Tanzanian shilling", @"TZS" },
            { @"Ugandan shilling", @"UGX" },
            { @"Romanian leu", @"RON" },
            { @"Moldovan leu", @"MDL" },
            { @"Nepalese rupee", @"NPR" },
            { @"Pakistani rupee", @"PKR" },
            { @"Indian rupee", @"INR" },
            { @"Seychellois rupee", @"SCR" },
            { @"Mauritian rupee", @"MUR" },
            { @"Maldivian rufiyaa", @"MVR" },
            { @"Sri Lankan rupee", @"LKR" },
            { @"Indonesian rupiah", @"IDR" },
            { @"Danish krone", @"DKK" },
            { @"Norwegian krone", @"NOK" },
            { @"Icelandic króna", @"ISK" },
            { @"Swedish krona", @"SEK" },
            { @"West African CFA franc", @"XOF" },
            { @"Central African CFA franc", @"XAF" },
            { @"Comorian franc", @"KMF" },
            { @"Congolese franc", @"CDF" },
            { @"Burundian franc", @"BIF" },
            { @"Djiboutian franc", @"DJF" },
            { @"CFP franc", @"XPF" },
            { @"Guinean franc", @"GNF" },
            { @"Swiss franc", @"CHF" },
            { @"Rwandan franc", @"RWF" },
            { @"Russian ruble", @"RUB" },
            { @"Transnistrian ruble", @"PRB" },
            { @"New Belarusian ruble", @"BYN" },
            { @"Algerian dinar", @"DZD" },
            { @"Bahraini dinar", @"BHD" },
            { @"Iraqi dinar", @"IQD" },
            { @"Jordanian dinar", @"JOD" },
            { @"Kuwaiti dinar", @"KWD" },
            { @"Libyan dinar", @"LYD" },
            { @"Serbian dinar", @"RSD" },
            { @"Tunisian dinar", @"TND" },
            { @"Argentine peso", @"ARS" },
            { @"Chilean peso", @"CLP" },
            { @"Colombian peso", @"COP" },
            { @"Cuban convertible peso", @"CUC" },
            { @"Cuban peso", @"CUP" },
            { @"Dominican peso", @"DOP" },
            { @"Mexican peso", @"MXN" },
            { @"Uruguayan peso", @"UYU" },
            { @"British pound", @"GBP" },
            { @"Saint Helena pound", @"SHP" },
            { @"Egyptian pound", @"EGP" },
            { @"Falkland Islands pound", @"FKP" },
            { @"Gibraltar pound", @"GIP" },
            { @"Manx pound", @"IMP" },
            { @"Jersey pound", @"JEP" },
            { @"Lebanese pound", @"LBP" },
            { @"South Sudanese pound", @"SSP" },
            { @"Sudanese pound", @"SDG" },
            { @"Syrian pound", @"SYP" },
            { @"United States dollar", @"USD" },
            { @"Australian dollar", @"AUD" },
            { @"Bahamian dollar", @"BSD" },
            { @"Barbadian dollar", @"BBD" },
            { @"Belize dollar", @"BZD" },
            { @"Bermudian dollar", @"BMD" },
            { @"Brunei dollar", @"BND" },
            { @"Singapore dollar", @"SGD" },
            { @"Canadian dollar", @"CAD" },
            { @"Cayman Islands dollar", @"KYD" },
            { @"New Zealand dollar", @"NZD" },
            { @"Fijian dollar", @"FJD" },
            { @"Guyanese dollar", @"GYD" },
            { @"Hong Kong dollar", @"HKD" },
            { @"Jamaican dollar", @"JMD" },
            { @"Liberian dollar", @"LRD" },
            { @"Namibian dollar", @"NAD" },
            { @"Solomon Islands dollar", @"SBD" },
            { @"Surinamese dollar", @"SRD" },
            { @"New Taiwan dollar", @"TWD" },
            { @"Trinidad and Tobago dollar", @"TTD" },
            { @"Tuvaluan dollar", @"TVD" },
            { @"Chinese yuan", @"CNY" },
            { @"Rial", @"__RI" },
            { @"Shiling", @"__S" },
            { @"Som", @"__SO" },
            { @"Dirham", @"__DR" },
            { @"Dinar", @"_DN" },
            { @"Dollar", @"__D" },
            { @"Manat", @"__MA" },
            { @"Rupee", @"__R" },
            { @"Krone", @"__K" },
            { @"Krona", @"__K" },
            { @"Crown", @"__K" },
            { @"Frank", @"__F" },
            { @"Mark", @"__M" },
            { @"Ruble", @"__RB" },
            { @"Peso", @"__PE" },
            { @"Pound", @"__P" },
            { @"Tristan da Cunha pound", @"_TP" },
            { @"South Georgia and the South Sandwich Islands pound", @"_SP" },
            { @"Somaliland shilling", @"_SS" },
            { @"Pitcairn Islands dollar", @"_PND" },
            { @"Palauan dollar", @"_PD" },
            { @"Niue dollar", @"_NID" },
            { @"Nauruan dollar", @"_ND" },
            { @"Micronesian dollar", @"_MD" },
            { @"Kiribati dollar", @"_KID" },
            { @"Guernsey pound", @"_GGP" },
            { @"Faroese króna", @"_FOK" },
            { @"Cook Islands dollar", @"_CKD" },
            { @"British Virgin Islands dollar", @"_BD" },
            { @"Ascension pound", @"_AP" },
            { @"Alderney pound", @"_ALP" },
            { @"Abkhazian apsar", @"_AA" },
            { @"Bitcoin", @"_XBT" }
        };
      public static readonly Dictionary<string, string> FractionalUnitNameToCodeMap = new Dictionary<string, string>
        {
            { @"Jiao", @"JIAO" },
            { @"Kopek", @"KOPEK" },
            { @"Pul", @"PUL" },
            { @"Cent", @"CENT" },
            { @"Qindarkë", @"QINDARKE" },
            { @"Penny", @"PENNY" },
            { @"Santeem", @"SANTEEM" },
            { @"Cêntimo", @"CENTIMO" },
            { @"Centavo", @"CENTAVO" },
            { @"Luma", @"LUMA" },
            { @"Qəpik", @"QƏPIK" },
            { @"Fils", @"FILS" },
            { @"Poisha", @"POISHA" },
            { @"Kapyeyka", @"KAPYEYKA" },
            { @"Centime", @"CENTIME" },
            { @"Chetrum", @"CHETRUM" },
            { @"Paisa", @"PAISA" },
            { @"Fening", @"FENING" },
            { @"Thebe", @"THEBE" },
            { @"Sen", @"SEN" },
            { @"Stotinka", @"STOTINKA" },
            { @"Fen", @"FEN" },
            { @"Céntimo", @"CENTIMO" },
            { @"Lipa", @"LIPA" },
            { @"Haléř", @"HALER" },
            { @"Øre", @"ØRE" },
            { @"Piastre", @"PIASTRE" },
            { @"Santim", @"SANTIM" },
            { @"Oyra", @"OYRA" },
            { @"Butut", @"BUTUT" },
            { @"Tetri", @"TETRI" },
            { @"Pesewa", @"PESEWA" },
            { @"Fillér", @"FILLER" },
            { @"Eyrir", @"EYRIR" },
            { @"Dinar", @"DINAR" },
            { @"Agora", @"AGORA" },
            { @"Tïın", @"TIIN" },
            { @"Chon", @"CHON" },
            { @"Jeon", @"JEON" },
            { @"Tyiyn", @"TYIYN" },
            { @"Att", @"ATT" },
            { @"Sente", @"SENTE" },
            { @"Dirham", @"DIRHAM" },
            { @"Rappen", @"RAPPEN" },
            { @"Avo", @"AVO" },
            { @"Deni", @"DENI" },
            { @"Iraimbilanja", @"IRAIMBILANJA" },
            { @"Tambala", @"TAMBALA" },
            { @"Laari", @"LAARI" },
            { @"Khoums", @"KHOUMS" },
            { @"Ban", @"BAN" },
            { @"Möngö", @"MONGO" },
            { @"Pya", @"PYA" },
            { @"Kobo", @"KOBO" },
            { @"Kuruş", @"KURUS" },
            { @"Baisa", @"BAISA" },
            { @"Centésimo", @"CENTESIMO" },
            { @"Toea", @"TOEA" },
            { @"Sentimo", @"SENTIMO" },
            { @"Grosz", @"GROSZ" },
            { @"Sene", @"SENE" },
            { @"Halala", @"HALALA" },
            { @"Para", @"PARA" },
            { @"Öre", @"ORE" },
            { @"Diram", @"DIRAM" },
            { @"Satang", @"SATANG" },
            { @"Seniti", @"SENITI" },
            { @"Millime", @"MILLIME" },
            { @"Tennesi", @"TENNESI" },
            { @"Kopiyka", @"KOPIYKA" },
            { @"Tiyin", @"TIYIN" },
            { @"Hào", @"HAO" },
            { @"Ngwee", @"NGWEE" },
            { @"Millibitcoin", @"MILLIBITCOIN" },
            { @"Satoshi", @"SATOSHI" }
        };
      public const string CompoundUnitConnectorRegex = @"(?<spacer>und)";
      public static readonly Dictionary<string, string> CurrencyPrefixList = new Dictionary<string, string>
        {
            { @"Dollar", @"$" },
            { @"United States dollar", @"united states $|us$|us $|u.s. $|u.s $" },
            { @"East Caribbean dollar", @"east caribbean $" },
            { @"Australian dollar", @"australian $|australia $" },
            { @"Bahamian dollar", @"bahamian $|bahamia $" },
            { @"Barbadian dollar", @"barbadian $|barbadin $" },
            { @"Belize dollar", @"belize $" },
            { @"Bermudian dollar", @"bermudian $" },
            { @"British Virgin Islands dollar", @"british virgin islands $|bvi$|virgin islands $|virgin island $|british virgin island $" },
            { @"Brunei dollar", @"brunei $|b$" },
            { @"Sen", @"sen" },
            { @"Singapore dollar", @"singapore $|s$" },
            { @"Canadian dollar", @"canadian $|can$|c$|c $|canada $" },
            { @"Cayman Islands dollar", @"cayman islands $|ci$|cayman island $" },
            { @"New Zealand dollar", @"new zealand $|nz$|nz $" },
            { @"Cook Islands dollar", @"cook islands $|cook island $" },
            { @"Fijian dollar", @"fijian $|fiji $" },
            { @"Guyanese dollar", @"gy$|gy $|g$|g $" },
            { @"Hong Kong dollar", @"hong kong $|hk$|hkd|hk $" },
            { @"Jamaican dollar", @"jamaican $|j$|jamaica $" },
            { @"Kiribati dollar", @"kiribati $" },
            { @"Liberian dollar", @"liberian $|liberia $" },
            { @"Micronesian dollar", @"micronesian $" },
            { @"Namibian dollar", @"namibian $|nad|n$|namibia $" },
            { @"Nauruan dollar", @"nauruan $" },
            { @"Niue dollar", @"niue $" },
            { @"Palauan dollar", @"palauan $" },
            { @"Pitcairn Islands dollar", @"pitcairn islands $|pitcairn island $" },
            { @"Solomon Islands dollar", @"solomon islands $|si$|si $|solomon island $" },
            { @"Surinamese dollar", @"surinamese $|surinam $" },
            { @"New Taiwan dollar", @"nt$|nt $" },
            { @"Trinidad and Tobago dollar", @"trinidad and tobago $|trinidad $|trinidadian $" },
            { @"Tuvaluan dollar", @"tuvaluan $" },
            { @"Samoan tālā", @"ws$" },
            { @"Chinese yuan", @"￥" },
            { @"Japanese yen", @"¥" },
            { @"Euro", @"€" },
            { @"Pound", @"£" },
            { @"Costa Rican colón", @"₡" },
            { @"Turkish lira", @"₺" },
            { @"Bitcoin", @"₿|btc|xbt" }
        };
      public static readonly IList<string> AmbiguousCurrencyUnitList = new List<string>
        {
            @"din.",
            @"kiwi",
            @"kina",
            @"kobo",
            @"lari",
            @"lipa",
            @"napa",
            @"para",
            @"sfr.",
            @"taka",
            @"tala",
            @"toea",
            @"vatu",
            @"yuan",
            @"ang",
            @"ban",
            @"bob",
            @"btn",
            @"byr",
            @"cad",
            @"cop",
            @"cup",
            @"dop",
            @"gip",
            @"jod",
            @"kgs",
            @"lak",
            @"lei",
            @"mga",
            @"mop",
            @"nad",
            @"omr",
            @"pul",
            @"sar",
            @"sbd",
            @"scr",
            @"sdg",
            @"sek",
            @"sen",
            @"sol",
            @"sos",
            @"std",
            @"try",
            @"yer",
            @"yen"
        };
      public static readonly Dictionary<string, string> InformationSuffixList = new Dictionary<string, string>
        {
            { @"Bit", @"-bit|bit|bits" },
            { @"Kilobit", @"kilobit|kilobits|kb|kbit" },
            { @"Megabit", @"megabit|megabits|Mb|Mbit" },
            { @"Gigabit", @"gigabit|gigabits|Gb|Gbit" },
            { @"Terabit", @"terabit|terabits|Tb|Tbit" },
            { @"Petabit", @"petabit|petabits|Pb|Pbit" },
            { @"Byte", @"byte|bytes" },
            { @"Kilobyte", @"kilobyte|kB|kilobytes|kilo byte|kilo bytes|kByte" },
            { @"Megabyte", @"megabyte|mB|megabytes|mega byte|mega bytes|MByte" },
            { @"Gigabyte", @"gigabyte|gB|gigabytes|giga byte|giga bytes|GByte" },
            { @"Terabyte", @"terabyte|tB|terabytes|tera byte|tera bytes|TByte" },
            { @"Petabyte", @"petabyte|pB|petabytes|peta byte|peta bytes|PByte" }
        };
      public static readonly IList<string> AmbiguousDimensionUnitList = new List<string>
        {
            @"barrel",
            @"grain",
            @"gran",
            @"grän",
            @"korn",
            @"pfund",
            @"stone",
            @"yard",
            @"cord",
            @"dram",
            @"fuß",
            @"gill",
            @"knoten",
            @"peck",
            @"cup",
            @"fps",
            @"pts",
            @"in",
            @""""
        };
      public const string BuildPrefix = @"(?<=(\s|^))";
      public const string BuildSuffix = @"(?=(\s|\W|$))";
      public const string ConnectorToken = @"-";
      public static readonly Dictionary<string, string> LengthSuffixList = new Dictionary<string, string>
        {
            { @"Kilometer", @"km|kilometer|kilometern" },
            { @"Hectometer", @"hm|hektometer|hektometern" },
            { @"Decameter", @"dam|dekameter|dekametern" },
            { @"Meter", @"m|meter|metern" },
            { @"Decimeter", @"dm|dezimeter|dezimetern" },
            { @"Centimeter", @"cm|zentimeter|centimeter|zentimetern|centimetern" },
            { @"Millimeter", @"mm|millimeter|millimetern" },
            { @"Micrometer", @"μm|mikrometer|mikrometern" },
            { @"Nanometer", @"nm|nanometer|nanometern" },
            { @"Picometer", @"pm|pikometer|picometer|pikometern|picometern" },
            { @"Mile", @"meile|meilen" },
            { @"Yard", @"yard|yards" },
            { @"Inch", @"zoll|inch|in|""" },
            { @"Foot", @"fuß|ft" },
            { @"Light year", @"lichtjahr|lichtjahre|lichtjahren" },
            { @"Pt", @"pt|pts" }
        };
      public static readonly IList<string> AmbiguousLengthUnitList = new List<string>
        {
            @"m",
            @"yard",
            @"yards",
            @"pm",
            @"pt",
            @"pts"
        };
      public static readonly Dictionary<string, string> SpeedSuffixList = new Dictionary<string, string>
        {
            { @"Meter per second", @"meter/sekunde|m/s|meter pro sekunde|metern pro sekunde" },
            { @"Kilometer per hour", @"km/h|kilometer/stunde|kilometer pro stunde|kilometern pro stunde" },
            { @"Kilometer per minute", @"km/min|kilometer pro minute|kilometern pro minute" },
            { @"Kilometer per second", @"km/s|kilometer pro sekunde|kilometern pro sekunde" },
            { @"Mile per hour", @"mph|mi/h|meilen pro stunde|meilen/stunde|meile pro stunde" },
            { @"Knot", @"kt|knoten|kn" },
            { @"Foot per second", @"ft/s|fuß/sekunde|fuß pro sekunde|fps" },
            { @"Foot per minute", @"ft/min|fuß/minute|fuß pro minute" },
            { @"Yard per minute", @"yard pro minute|yard/minute|yard/min" },
            { @"Yard per second", @"yard pro sekunde|yard/sekunde|yard/s" }
        };
      public static readonly Dictionary<string, string> TemperatureSuffixList = new Dictionary<string, string>
        {
            { @"F", @"grad fahrenheit|°fahrenheit|°f|fahrenheit" },
            { @"K", @"k|K|kelvin|grad kelvin|°kelvin|°k|°K" },
            { @"R", @"rankine|°r" },
            { @"D", @"delisle|°de" },
            { @"C", @"grad celsius|°celsius|°c|celsius" },
            { @"Degree", @"grad|°" }
        };
      public static readonly IList<string> AmbiguousTemperatureUnitList = new List<string>
        {
            @"c",
            @"f",
            @"k"
        };
      public static readonly Dictionary<string, string> VolumeSuffixList = new Dictionary<string, string>
        {
            { @"Cubic meter", @"m3|kubikmeter|m³" },
            { @"Cubic centimeter", @"kubikzentimeter|cm³" },
            { @"Cubic millimiter", @"kubikmillimeter|mm³" },
            { @"Hectoliter", @"hektoliter" },
            { @"Decaliter", @"dekaliter" },
            { @"Liter", @"l|liter" },
            { @"Deciliter", @"dl|deziliter" },
            { @"Centiliter", @"cl|zentiliter" },
            { @"Milliliter", @"ml|mls|milliliter" },
            { @"Cubic yard", @"kubikyard" },
            { @"Cubic inch", @"kubikzoll" },
            { @"Cubic foot", @"kubikfuß" },
            { @"Cubic mile", @"kubikmeile" },
            { @"Fluid ounce", @"fl oz|flüssigunze|fluessigunze" },
            { @"Teaspoon", @"teelöffel|teeloeffel" },
            { @"Tablespoon", @"esslöffel|essloeffel" },
            { @"Pint", @"pinte" },
            { @"Volume unit", @"fluid dram|fluid drachm|flüssigdrachme|gill|quart|minim|cord|peck|beck|scheffel|hogshead|oxhoft" }
        };
      public static readonly IList<string> AmbiguousVolumeUnitList = new List<string>
        {
            @"l",
            @"unze",
            @"oz",
            @"cup",
            @"peck",
            @"cord",
            @"gill"
        };
      public static readonly Dictionary<string, string> WeightSuffixList = new Dictionary<string, string>
        {
            { @"Kilogram", @"kg|kilogramm|kilo" },
            { @"Gram", @"g|gramm" },
            { @"Milligram", @"mg|milligramm" },
            { @"Microgram", @"μg|mikrogramm" },
            { @"Barrel", @"barrel" },
            { @"Gallon", @"gallone|gallonen" },
            { @"Metric ton", @"metrische tonne|metrische tonnen" },
            { @"Ton", @"tonne|tonnen" },
            { @"Pound", @"pfund|lb" },
            { @"Ounce", @"unze|unzen|oz|ounces" },
            { @"Weight unit", @"pennyweight|grain|british long ton|US short hundredweight|stone|dram" }
        };
      public static readonly IList<string> AmbiguousWeightUnitList = new List<string>
        {
            @"g",
            @"oz",
            @"stone",
            @"dram"
        };
      public static readonly Dictionary<string, string> AngleSuffixList = new Dictionary<string, string>
        {
            { @"Degree", @"grad|°" },
            { @"Radian", @"radiant|rad" },
            { @"Turn", @"turn" }
        };
      public static readonly IList<string> AmbiguousAngleUnitList = new List<string>
        {
            @"turn"
        };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"null", @"null" }
        };
      public static readonly Dictionary<string, string> TemperatureAmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"\b(grad|°)$", @"\b((grad|°)\s*(winkel|dreh(ung|en|t)|gedreht)|(dreh(ung|en|t)|gedreht|winkel)(\s+(\p{L}+|\d+)){0,4}\s*(grad\b|°))" }
        };
      public static readonly Dictionary<string, string> DimensionAmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"\b(grad|°)$", @"\b((grad|°)\s*(c(elsius|entigrate)?|f(ah?renheit)?)|(temperatur)(\s+(\p{L}+|\d+)){0,4}\s*(grad\b|°))" }
        };
    }
}