﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\German\German-DateTime.yaml
//     - Language: German
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.German
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Ger";
      public const bool CheckBothBeforeAfter = false;
      public const string TillRegex = @"(?<till>zu|bis\s*zum|zum|bis|bis\s*hin(\s*zum)?|--|-|—|——)";
      public const string RangeConnectorRegex = @"(?<and>und|--|-|—|——)";
      public const string RelativeRegex = @"\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|vorletzte[snm]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?|de[rmsn]|das(?!\s+tag)|am)";
      public const string StrictRelativeRegex = @"\b(?<order>(über)?nächste[rmns]?|kommende[rns]?|diese[rmns]?|letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vorige[rns]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?|gestrige[rns]?|morgige[rns]?)";
      public const string UpcomingPrefixRegex = @".^";
      public static readonly string NextPrefixRegex = $@"\b((über)?nächste[rmns]?|kommende[rns]?|{UpcomingPrefixRegex})\b";
      public const string AfterNextPrefixRegex = @"\bübernächste[rmns]?\b";
      public const string PastPrefixRegex = @".^";
      public static readonly string PreviousPrefixRegex = $@"\b(letzte[rmns]?|vergangene[rns]?|vorherige[rns]?|vor(ige[rns]?)?|{PastPrefixRegex})\b";
      public const string ThisPrefixRegex = @"\b(diese[rnms]?|jetzige[rns]?|heutige[rns]?|aktuelle[rns]?)\b";
      public const string RangePrefixRegex = @"(vo[nm]|zwischen)";
      public const string PenultimatePrefixRegex = @"\b(vorletzte[snm]?)\b";
      public const string WrittenOneToNineRegex = @"(eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun)";
      public const string DayRegex = @"(de[rmsn]\s*)?(?<day>(01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)(\.|\b))";
      public static readonly string WrittenDayNumRegex = $@"\b(de[rmsn]\s+)?(?<day>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zwölft|zwoelft|dreizehnt|vierzehnt|fünfzehnt|fuenfzehnt|sechzehnt|siebzehnt|achtzehnt|neunzehnt|({WrittenOneToNineRegex}und)?zwanzigst|(einund)?dreißigst)e[nr]\b";
      public const string MonthNumRegex = @"(?<month>(01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)(\.|\b))";
      public const string WrittenMonthNumRegex = @"\b(?<month>erst|zweit|dritt|viert|fünft|fuenft|sechst|siebt|acht|neunt|zehnt|elft|zw(ö|oe)lft)e[nr]\b";
      public static readonly string AmDescRegex = $@"({BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"({BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"({BaseDateTime.BaseAmPmDescRegex})";
      public const string OclockRegex = @"(?<oclock>uhr)";
      public static readonly string DescRegex = $@"({OclockRegex})";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public const string CenturyRegex = @"\b(?<century>((ein|zwei)?tausend(und)?)?((ein|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf|zwölf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn)hundert))\b";
      public static readonly string WrittenNumRegex = $@"(zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig|elf|zehn|{WrittenOneToNineRegex})";
      public static readonly string FullTextYearRegex = $@"\b((?<firsttwoyearnum>{CenturyRegex})\s+(?<lasttwoyearnum>((zwanzig|dreißig|vierzig|fünfzig|sechzig|siebzig|achtzig|neunzig)\s+{WrittenNumRegex})|{WrittenNumRegex}))\b|\b(?<firsttwoyearnum>{CenturyRegex})\b";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\.|\b))";
      public const string SingleWeekDayRegex = @"\b(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|(mo|di|mi|do|fr|sa|so)(\.|\b))";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>{RelativeRegex}\s+monat(s)?)";
      public const string WrittenMonthRegex = @"((monat\s*)?(?<month>apr(il|\.)|aug(ust|\.)|dez(ember|\.)|feb(ruar|ber|\.)|j[äa]n(uar|ner|\.)|jul(e?i|l\.)|jun([io]|\.)|märz|mai|nov(ember|\.)|okt(ober|\.)|sept?(ember|\.)))";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>(im\s*|des\s*)?({RelativeMonthRegex}|{WrittenMonthRegex}|{MonthNumRegex}))";
      public const string DateUnitRegex = @"(?<unit>tg|woche(?<plural>n)?|(jahr|monat|tag)(?<plural>e)?)(s)?";
      public const string HalfTokenRegex = @"^(halb)";
      public const string QuarterToTokenRegex = @"^(viertel\s+vor|dreiviertel)\s*$";
      public const string QuarterPastTokenRegex = @"^(viertel\s+nach)\s*$";
      public const string ThreeQuarterToTokenRegex = @"^(viertel|dreiviertel\s+vor)\s*$";
      public const string ThreeQuarterPastTokenRegex = @"^(dreiviertel\s+nach)\s*$";
      public static readonly string SimpleCasesRegex = $@"((vom|zwischen)\s+)?({DayRegex})(\s*{MonthSuffixRegex})?\s*{TillRegex}\s*({DayRegex})(\s*{MonthSuffixRegex})?((\s+|\s*,\s*){YearRegex})?";
      public static readonly string MonthFrontSimpleCasesRegex = $@"((vom|zwischen)\s*)?{MonthSuffixRegex}\s*((vom|zwischen)\s*)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?";
      public static readonly string MonthFrontBetweenRegex = $@"({MonthSuffixRegex}\s+(zwischen\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?)";
      public static readonly string BetweenRegex = $@"((zwischen\s+)({DayRegex})(\s+{MonthSuffixRegex})?\s*{RangeConnectorRegex}\s*({DayRegex})(\s+{MonthSuffixRegex})((\s+|\s*,\s*){YearRegex})?|(zwischen\s+)({DayRegex})(\s+{MonthSuffixRegex})?\s*{RangeConnectorRegex}\s*({DayRegex})(\s+{MonthSuffixRegex})?((\s+|\s*,\s*){YearRegex})?)";
      public static readonly string MonthWithYear = $@"\b((?<month>apr(il|\.)|aug(ust|\.)|dez(ember|\.)|feb(ruar|ber|\.)|januar|j[äa]n(ner|\.)|jul(e?i|l\.)|jun([io]|\.)|märz|mai|nov(ember|\.)|okt(ober|\.)|sept?(ember|\.))(\s*),?(\s+des)?(\s*)({YearRegex}|{TwoDigitYearRegex}|(?<order>nächste[mn]|letzte[mn]|diese(s|n))\s+jahres))";
      public static readonly string OneWordPeriodRegex = $@"\b((((im\s+)?monat\s+)?({RelativeRegex}\s*(jahr\s*(im\s*)?)?)?(?<month>apr(il|\.)|aug(ust|\.)|dez(ember|\.)|feb(ruar|ber|\.)|j[äa]n(uar|ner|\.)|jul(e?i|l\.)|jun([io]|\.)|märz|mai|nov(ember|\.)|okt(ober|\.)|sept?(ember|\.)))|(?<business>unter\s+der\s+woche)|({RelativeRegex}\s+)?((?<business>werktags|arbeitswoche)|woche(nende)?|monat(s)?|jahr|jahres)(?!(\s+\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\s+bis\s+heute)))\b";
      public static readonly string MonthNumWithYear = $@"({YearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-\.](\s*){YearRegex})";
      public static readonly string WeekOfMonthRegex = $@"(?<wom>((die|der)\s+)(?<cardinal>erste[rns]?|1\.|zweite[rns]?|2\.|dritte[rns]?|3\.|vierte[rns]?|4\.|fünfte[rns]?|5\.|letzte[rmns]?)\s+woche\s+(des|diese(s|n)|im)\s+({MonthSuffixRegex}|monat(s)?))";
      public static readonly string WeekOfYearRegex = $@"(?<woy>((die|der)\s+)?(?<cardinal>(erste[rns]?|1\.|zweite[rns]?|2\.|dritte[rns]?|3\.|vierte[rns]?|4\.|fünfte[rns]?|5\.|letzte[rmns]?)\s+woche\s+(im|diese(s|n)|\s+des)?\s+({YearRegex}|{RelativeRegex}\s+jahr(en|es|e)?)))";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public static readonly string QuarterRegex = $@"((das|im|in dem|dem)\s+)?(?<cardinal>erste[rns]?|1\.|zweite[rns]?|2\.|dritte[rns]?|3\.|vierte[rns]?|4\.)\s+quartal(\s+(von|des jahres)?|\s*,\s*)?\s+({YearRegex}|{RelativeRegex})";
      public static readonly string QuarterRegexYearFront = $@"(?!)#({YearRegex}|{RelativeRegex}\s+year)\s+(the\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)\s+quarter";
      public static readonly string AllHalfYearRegex = $@"((das|im|in dem|dem)\s+)?(?<cardinal>erste[rns]?|1\.|zweite[rns]?|2\.)\s+(halbjahr|hälfte)(\s+(von|des jahres)?|\s*,\s*)?\s+({YearRegex}|{RelativeRegex})";
      public const string PrefixDayRegex = @"((?<EarlyPrefix>früh)|(?<MidPrefix>mitten|in der mitte)|(?<LatePrefix>spät(er)?))(\s+am\s+tag)?(\s+des\s+tages)?$";
      public const string CenturySuffixRegex = @"(^jahrhundert)\b";
      public const string ReferencePrefixRegex = @"((gleich(e|en))|(selb(e|en)))\b";
      public static readonly string SeasonRegex = $@"\b(?<season>({RelativeRegex}\s+)?(?<seas>frühling|sommer|herbst|winter)((\s+(von|des jahres)?|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+jahr(e(s)?)?))?)\b";
      public const string WhichWeekRegex = @"\b(week)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b";
      public const string WeekOfRegex = @"(die\s+)?(woche)(\s+des)";
      public const string MonthOfRegex = @"(monat)(\s*)(des)";
      public const string MonthRegex = @"(?<month>apr((il)?\b|\.)|aug((ust)?\b|\.)|dez((ember)?\b|\.)|feb((ruar|ber)?\b|\.)|januar|j[äa]n((ner)?\b|\.)|jul((e?i|l)?\b|l\.)|jun([io]?\b|\.)|märz|mai|nov((ember)?\b|\.)|okt((ober)?\b|\.)|sept?((ember)?\b|\.))";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})";
      public static readonly string OnRegex = $@"(?<=\bam\s+)({DayRegex}s?)\b";
      public const string RelaxedOnRegex = @"(?<=\b(am|an dem)\s+)((?<day>10|11|12|13|14|15|16|17|18|19|1|20|21|22|23|24|25|26|27|28|29|2|30|31|3|4|5|6|7|8|9)([\.]))";
      public static readonly string ThisRegex = $@"(((diese((n|m)|(\s*woche))(\s*am)?\s+){WeekDayRegex})|diese(n|r)?\s*(sommer|winter|frühling|herbst))";
      public static readonly string LastDateRegex = $@"({PreviousPrefixRegex}(\s*(woche|monat|jahr)?(\s*(am|im))?)?\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\s+)?{WeekDayRegex}(\s+{PreviousPrefixRegex}\s*woche))";
      public static readonly string NextDateRegex = $@"({NextPrefixRegex}(\s*(woche|monat|jahr)?(\s*(am|im))?)?\s+({WeekDayRegex}|sommer|winter|frühling|herbst))|((am\s+)?{WeekDayRegex}(\s+{NextPrefixRegex}\s*woche))";
      public static readonly string SpecialDayRegex = $@"\b(vorgestern|übermorgen|((der\s+)?{RelativeRegex}\s+(tag(s|es)?|(?<!\bam\s+)morgen))|\bgestern\b|\bmorgen\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?))";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<number>{WrittenNumRegex})\s+tage?\s+(von|nach|ab)\s+(?<day>\bgestern\b|\bmorgen\b|heute|(heutige[rns]?|aktuelle[rns]?) (datum|tag(s|es)?)))\b";
      public static readonly string RelativeDayRegex = $@"\b((((de[rmns])\s+)?{RelativeRegex}\s+tag(e(s)?)?))";
      public const string SetWeekDayRegex = @"\b(?<prefix>(an|immer)\s+)?(?<weekday>sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend)(s|en)\b";
      public static readonly string WeekDayOfMonthRegex = $@"\b(?<wom>((an( dem)?|de[rs]|am)\s+)?(?<cardinal>erste[rns]?|1\.|zweite[rns]?|2\.|dritte[rns]?|3\.|vierte[rns]?|4\.|fünfte[rns]?|5\.|letzte[rmns]?)\s+{WeekDayRegex}\s+{MonthSuffixRegex})\b";
      public static readonly string RelativeWeekDayRegex = $@"\b({WrittenNumRegex}\s+{WeekDayRegex}e\s+(von\s+jetzt|später))\b";
      public static readonly string SpecialDate = $@"(?=\b(an( dem)?|am)\s+){DayRegex}\b";
      public static readonly string DateExtractor1 = $@"\b(({WeekDayRegex})(\s+|\s*,\s*))?({DayRegex}\s*[/\\.,\- ]\s*{MonthRegex}(\s*[/\\.,\- ]\s*{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[/\\.,\- ]\s*{DayRegex}\s*[/\\.,\- ]\s*{MonthRegex})\b";
      public static readonly string DateExtractor2 = $@"\b({MonthRegex}\s*[/\\.,\- ]\s*{DayRegex}(?!\s*\-\s*\d{{2}}\b)(\s*[/\\.,\- ]\s*{DateYearRegex})?)\b";
      public static readonly string DateExtractor3 = $@"\b({DayRegex}{MonthRegex})";
      public static readonly string DateExtractor4 = $@"\b({DayRegex}\s*{MonthNumRegex}\s*{DateYearRegex})\b";
      public static readonly string DateExtractor5 = $@"\b(({WeekDayRegex})(\s+|\s*,\s*))?({DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex})\b(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"^[.]";
      public static readonly string DateExtractor7 = $@"({DayRegex}\s*[\.]\s*{MonthNumRegex}[\.]){BaseDateTime.CheckDecimalRegex}";
      public static readonly string DateExtractor8 = $@"(?<=\b(am)\s+){DayRegex}[/\\\.]{MonthNumRegex}([/\\\.]{DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor9 = $@"\b({DayRegex}\s*/\s*{MonthNumRegex}((\s+|\s*,\s*){DateYearRegex})?){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor10 = $@"^[.]";
      public static readonly string DateExtractor11 = $@"\b(({WeekDayRegex})(\s+|\s*,\s*)|(?<=\bam\s+))({DayRegex}\.|{WrittenDayNumRegex})\s*[/\\.\- ]\s*({MonthNumRegex}\.|{WrittenMonthNumRegex})(\s*[/\\.\- ]\s*{DateYearRegex})?";
      public static readonly string DateExtractorA = $@"({DateYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}|{MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex}|{DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})(?!\s*[/\\\-\.:]\s*\d+)";
      public static readonly string OfMonth = $@"^(\s*des\s*|\s*)?{MonthRegex}";
      public static readonly string MonthEnd = $@"{MonthRegex}\s*(de[rmn])?\s*$";
      public static readonly string WeekDayEnd = $@"{WeekDayRegex}\s*,?\s*$";
      public static readonly string WeekDayStart = $@"^\s+(am\s+)?{WeekDayRegex}\b";
      public const string RangeUnitRegex = @"(?<unit>jahren?|jahr|monaten?|monat|wochen?|tagen?|tag)";
      public const string HourNumRegex = @"\b(?<hournum>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|'null'|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)\b";
      public const string MinuteNumRegex = @"(?<minnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>zwanzig|dreißig|vierzig|fünfzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|fuenfzehn|sechzehn|siebzehn|achtzehn|neunzehn|eins?|zw(een|ei|o)|drei|vier|fünf|fuenf|sechs|sieben|acht|neun|zehn|elf)";
      public const string PmRegex = @"\b((am|gegen|in der)\s+)?(?<pm>(((früh|spät)\s*)?(nachmittags?|abends?)|mitternachts?|\bmittags?|((in der )?nachts?)))";
      public const string PmRegexFull = @"\b((am|gegen|in der)\s+)?(?<pm>(((früh|spät)\s*)?(nachmittags?|abends?)|mitternachts?|\bmittags?|((in der )?nachts?)))";
      public const string AmRegex = @"(?<am>(((früh|spät)\s*)?morgens|((am|gegen)\s+)?(früh|vormittags?)|(am|gegen)\s+morgen))";
      public const string LunchRegex = @"\b(mittag(essen|s)?)\b";
      public const string NightRegex = @"\b(mitternacht|(nachts?|primetime|abends?))\b";
      public const string AmPmPrefixRegex = @"\b((((um|gegen)\s*)?(?<suffix>(((?<am>am morgen)|((früh|spät)\s*)?morgens|früh|(vor|nach)mittags?)|(?<pm>((früh|spät)\s*)?(nachmittags?|abends?)|mitternachts?))|(in der\s*)?(?<pm>nachts?)))\s*(um|gegen|von)\s*)";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public static readonly string LessThanOneHour = $@"\b(?<lth>(ein(er?)?\s+)?((drei)?viertel|halb(en?)?)(\s*stunden?)?)|{BaseDateTime.DeltaMinuteRegex}(\s+(min(uten?)?))|{DeltaMinuteNumRegex}(\s+(min(uten?)?))";
      public static readonly string WrittenTimeRegex = $@"(um\s*)?(?<writtentime>{HourNumRegex}(\s*{OclockRegex}\s*)({MinuteNumRegex}|{MinuteNumRegex}und(?<tens>zwanzig|dreißig|vierzig|fünfzig)))";
      public static readonly string TimePrefix = $@"(?<prefix>({LessThanOneHour})(\s*(vor(\W)?|nach(\W)?))?)";
      public static readonly string TimeSuffix = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string TimeSuffixFull = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex}|\b(?<pm>nachmittag(s)?|nacht(s)?|abend(s)?))";
      public static readonly string BasicTime = $@"(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(:|\s+uhr(\s+und)?\s+){BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|\b{BaseDateTime.HourRegex}(?![%\d]))";
      public const string MidnightRegex = @"(?<midnight>mitte(r|n in der )nachts?)";
      public const string MidmorningRegex = @"(?<midmorning>mitten am vormittag)";
      public const string MidafternoonRegex = @"(?<midafternoon>mitten am nachmittag)";
      public const string MiddayRegex = @"((?<midday>(am\s+)?mittag(s(zeit)?)?)|(?<midday>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)(mittags?)))";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"(((?<=\b(um|gegen)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?![%\d])|{MidTimeRegex}))|{MidTimeRegex})\b";
      public static readonly string IshRegex = $@"\b(noonish)\b";
      public const string TimeUnitRegex = @"(?<unit>(stunde|minute|sekunde)(?<plural>n)?|std?|min|sek|h|s)\b";
      public const string RestrictedTimeUnitRegex = @"(?<unit>stunde|minute)\b";
      public const string FivesRegex = @"(?<tens>(fünfzehn|(fünfund)?(zwanzig?|dreißig|vierzig|fünfzig)|zehn|fünf))\b";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string PeriodHourNumRegex = @"(?<hour>einundzwanzig|zweiundzwanzig|dreiundzwanzig|vierundzwanzig|zw(ö|oe)lf|dreizehn|vierzehn|fünfzehn|sechzehn|siebzehn|achtzehn|neunzehn|zwanzig|'null'|eins?|zwei|drei|vier|fünf|sechs|sieben|acht|neun|zehn|elf)\b";
      public static readonly string ConnectNumRegex = $@"{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex}";
      public static readonly string TimeRegex1 = $@"({TimePrefix}\s+)?({WrittenTimeRegex}(\s*{DescRegex})?|({HourNumRegex}|{BaseDateTime.HourRegex}\b)\s*{DescRegex})";
      public static readonly string TimeRegex2 = $@"({TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?(:|\s+uhr(\s+und)?\s+)(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"({TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"({TimePrefix}\s*{BasicTime}(\s*{DescRegex})?(\s*{TimeSuffix})?)";
      public static readonly string TimeRegex5 = $@"({TimePrefix}\s*{BasicTime}((\s*{DescRegex})))";
      public static readonly string TimeRegex6 = $@"({BasicTime}(\s*{DescRegex})?\s+{TimeSuffix})";
      public static readonly string TimeRegex7 = $@"(({AmPmPrefixRegex})({BasicTime})((\s*{DescRegex}))?)";
      public static readonly string TimeRegex8 = $@"({TimeSuffixFull}(\s*(um|gegen)\s*){BasicTime}((\s*{DescRegex})?))";
      public static readonly string TimeRegex9 = $@"({PeriodHourNumRegex}\s+{FivesRegex}((\s*{DescRegex})))";
      public static readonly string TimeRegex10 = $@"({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string PureNumFromTo = $@"(?<preDesc>({PmRegex}|{AmRegex})\s+)?((von)\s+)?({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex})){{0,2}}";
      public static readonly string PureNumBetweenAnd = $@"\b(?<preDesc>({PmRegex}|{AmRegex})\s+)?(zwischen\s+)({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\s*{RangeConnectorRegex}\s*({HourRegex}|{PeriodHourNumRegex})\s*(?<rightDesc>\s*{PmRegex}|{AmRegex}|{DescRegex}){{0,2}}\b";
      public static readonly string SpecificTimeFromTo = $@"((?<preDesc>({PmRegex}|{AmRegex})\s+)?(von)\s+)?(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\s*{TillRegex}\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"(?<preDesc>({PmRegex}|{AmRegex})\s+)?(zwischen\s+)(?<time1>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))\s*{RangeConnectorRegex}\s*(?<time2>({TimeRegex2}|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>({PmRegex}|{AmRegex}|{DescRegex})))?))";
      public const string PrepositionRegex = @"(?<prep>^(um|am|in|zur)(\s+(de[rmn]))?$)";
      public const string TimeOfDayRegex = @"(?<timeOfDay>((((?<early>(früh(\s+am|er)?|am frühen))|(?<late>(spät(\s+am|er)?|am späten)))(\s*|-))?((am\s+)?morgens?(?! (früh|vor|nach|abend|(nacht|primetime)|morgen))|(vor|nach)mittags?|(?<!sonn)abends?|früh|(nachts?|primetime))))\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b((({StrictRelativeRegex}|heute)\s+{TimeOfDayRegex}))\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}$";
      public static readonly string TimeNumberCombinedWithUnit = $@"(?<num>\d+(\,\d*)?){TimeUnitRegex}";
      public const string NowRegex = @"\b(?<now>(genau\s+)?jetzt|momentan|im moment|derzeit|in diesem moment|aktuelle?|gerade|so früh wie möglich|frühestmöglich|neulich|vorher)\b";
      public const string SuffixRegex = @"^\s*((am|zur|in der)\s+)?(am morgen|morgens|frühe?|(vor|nach)mittags?|abends?|(nacht|primetime)s?)\b";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>(vor|nach)?mittags?|abends?|(nachts?|primetime|morgen))\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b((({RelativeRegex}|heute)\s+{DateTimeTimeOfDayRegex}))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?((zur|am|in der)\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(um|gegen|in|on))?\s*$";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?(am\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+um)?\s*({HourNumRegex}|{BaseDateTime.HourRegex})";
      public const string SpecificEndOfRegex = @"((das|am|an( dem)?)\s+)?\bende(\s+(de[mnsr])?)\s*$";
      public const string UnspecificEndOfRegex = @"^[.]";
      public const string UnspecificEndOfRangeRegex = @"^[.]";
      public const string PeriodTimeOfDayRegex = @"(((?<early>(früh( am|er)?|am frühen)(\s*|-))|(?<late>(spät( am|er)|am späten)(\s*|-)))?(?<timeOfDay>morgens?|früh|(vor|nach)mittags?|(nachts?|primetime)|abends?))";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"(({StrictRelativeRegex}\s+{PeriodTimeOfDayRegex})|heute)";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"((((am|zur|von|in der)\s+)?{TimeOfDayRegex}(\s+am)?))|(?<timeOfDay>(?<=montag|dienstag|mittwoch|donnerstag|freitag|samstag|sonnabend|sonntag)((vor|nach)?mittags?|abends?|(nachts?|primetime)|morgens?))\b";
      public const string LessThanRegex = @"\b(weniger\s+als)\b";
      public const string MoreThanRegex = @"\b(mehr\s+als)\b";
      public const string DurationUnitRegex = @"(?<unit>jahr(e(n|s)?)?|monat(en?|s)?|wochen?|tag(e(n|s)?)?|tg|stunden?|std?|h|min(uten?)?|sek(unden?)?)\b";
      public const string SpecialNumberUnitRegex = @"\b(?<specialNum>beiden)\b";
      public const string SuffixAndRegex = @"(?<suffix>\s*und\s+(eine\s+)?(?<suffix_num>halbe|viertel))";
      public const string PeriodicRegex = @"(?<periodic>(all)?täglich(e(r|n|s)?)?|(all)?monatlich(e[rns]?)?|(all)?wöchentlich(e[rns]?)?|(all)?jährlich(e[rns]?)?)\b";
      public static readonly string EachUnitRegex = $@"(?<each>(jede(s|r|n|m)?|alle)(?<other>\s+andere(n)?)?\s*{DurationUnitRegex})";
      public const string EachPrefixRegex = @"\b(?<each>(jede(r|n|s|m)?|alle|immer)\s*$)";
      public const string SetEachRegex = @"\b(?<each>(jede(r|n|s|m)?|alle|immer)\s*)";
      public const string SetLastRegex = @"(?<last>(über)?nächste[rmns]?|kommende[rns]?|diese[rnms]?|letzte[rmns]?|vorige[rns]?|vorherige[rns]?|jetzige[rns]?|derzeitige[rns]?)\b";
      public const string EachDayRegex = @"\s*(jeden)\s*tag\s*\b";
      public const string BeforeEachDayRegex = @"(jeden)\s*tag\s*";
      public static readonly string DurationFollowedUnit = $@"(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"\b(((((ein(e[rsnm]?)?)(?<half>\s+halb(e[srn]?))?))\s+{DurationUnitRegex})|((ein(e[rsnm]?)?)\s+((?<quarter>viertel)|(?<threequarter>dreiviertel))(?<unit>stunde)))";
      public const string DuringRegex = @"\b(während|im\slaufe)\s+(de[sr])\s+(?<unit>jahres|monats|woche|tages)\b";
      public const string AllRegex = @"\b(?<all>ganz(e[nsr]?)\s+(?<unit>jahr|monat|woche|tag))\b";
      public const string HalfRegex = @"(((ein(e[nrs]?)?)\s*)|\b)(?<half>halb(e[nrs]?)?\s+(?<unit>jahr(e[rs]?)?|monat[se]?|woch(en?)?|tag(e[nrs]?)?|stund(en?)?))\b";
      public const string ConjunctionRegex = @"\b((und(\s+für)?)|mit|für)\b";
      public static readonly string HolidayRegex1 = $@"\b((dieses jahr)\s*)?(?<holiday>reformations(tag|fest)|gedenktag der reformation|martinstag|st. martin|sankt martin|martinsfest|martini|nikolaustag|dreikönigstag|dreikönigsfest|walpurgisnacht|nationalfeiertag|mariä empfängnis|weihnachten|weihnachts(feier)?tag|erste(r|n)? weihnachtstag|1\. weihnachtstag|erste(r|n)? weihnachtsfeiertag|1\. weihnachtsfeiertag|zweite(r|n)? weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\. weihnachtstag|zweite(r|n)? weihnachtsfeiertag|2\. weihnachtsfeiertag|stefanitag|stafanstag|berchtoldstag|bechtelistag|bächtelistag|berchtelistag|bärzelistag|josefstag|joseftag|josefitag|pfingsten|ostermontag|ostersonntag|bundesfeiertag|bundesfeier|mariä himmelfahrt|tag der deutschen einheit|ostern|vatertag|muttertag|erntedank(fest)?|thanksgiving|martin luther king day|martin luther king jr day|washington's birthday|washington birthday|canberraday|tag der arbeit|columbus day|memorial day|yuandan|mao's birthday|teachersday|teacher day|single day|tag der jugend|kindertag|(Internationaler\s+)?frauentag|treeplanting day|tag des baumes|girlsday|white lover day|loverday|weihnachten|weihnachtstag|xmas|neujahr|neujahrstag|neujahr|neujahrstag|neujahr|inauguration day|murmeltiertag|sommeranfang|winteranfang|frühlingsanfang|herbstanfang|valentinstag|st patrick day|erster april|april scherz|georgstag|mayday|maitag|maifeiertag|geburt johannes des täufers|us unabhängigkeitstag|unabhängigkeitstag|sturm auf die bastille|halloween|guy fawkes day|guy fawkes night|veterans day|heiligabend|silvester|pi-tag|pitag|pi (tag|day))(\s+((diesen)\s+)?(im jahr {YearRegex}|{YearRegex}|(im\s+)?{RelativeRegex}\s+jahr(es)?))?\b";
      public static readonly string HolidayRegex2 = $@"\b((dieses jahr)\s*)?(?<holiday>martin luther king|martin luther king jr|allerheiligen|tree planting day|white lover|st patrick|st george|independence|us independence|allerseelen|guy fawkes|silvester|weiberfastnacht|karneval|aschermittwoch|palm(en)?sonntag|karsamstag|fastnachtssamstag|fastnachtssonntag|heilige drei könige|barbaratag|reformationstag|weltkindertag|augsburger friedensfest|johannistag|peter und paul|karfreitag|christi himmelfahrt|pfingstsonntag|pfingstmontag|fronleichnam|rosenmontag|fastnacht|gründonnerstag|himmelfahrt|volkstrauertag|buß und bettag|buß- und bettag|buss- und bettag|buss und bettag|toten(sonntag|fest)|ewigkeitssonntag|erste(r|n)? advent|1\. advent|zweite(r|n)? advent|2\. advent|dritte(r|n)? advent|3\. advent|vierte(r|n)? advent|4\. advent|schweizer buss- und bettag|schweizer buss und bettag|schweizer buß und bettag|schweizer buß- und bettag)(\s+((diesen)\s+)?(im jahr {YearRegex}|{YearRegex}|(im\s+)?{RelativeRegex}\s+jahr(es)?))?\b";
      public static readonly string HolidayRegex3 = $@"((dieses jahr)\s*)?(?<holiday>(canberra|columbus|thanks\s*giving|groundhog|bastille|halloween|veterans|memorial|spring|lantern|qingming|dragon boat)\s+(day))(\s+((diesen)\s+)?(im jahr {YearRegex}|{YearRegex}|(im\s+)?{RelativeRegex}\s+jahr(es)?))?";
      public const string DateTokenPrefix = @"am ";
      public const string TimeTokenPrefix = @"um ";
      public const string TokenBeforeDate = @"am ";
      public const string TokenBeforeTime = @"um ";
      public const string FromRegex = @"\b(vo[mn](\s+de[rmsn])?)$";
      public const string BetweenTokenRegex = @"\b(zwischen(\s+de[rmsn])?)$";
      public const string AMTimeRegex = @"(?<am>morgens|vormittags?|früh)";
      public const string PMTimeRegex = @"\b(?<pm>nachmittags?|abends?|nachts?)";
      public const string BeforeRegex = @"(vorher(ige(s|n|r)?)?|bevor|vor(\W)?|vorige(s|n|r)?|bis)(\s+de[rmsn]\b)?";
      public const string AfterRegex = @"(nach(\W)?)(\s+de[rmsn]\b)?";
      public const string SinceRegex = @"\b(seit|ab)(\s+de[rmsn])?\b";
      public const string AgoRegex = @"\b(danach)\b";
      public const string AroundRegex = @"(\b(ca\.?|gegen|circa)\s*\b)";
      public const string LaterRegex = @"\b(später|von jetzt|(ab|nach) (?<day>morgen|heute))\b";
      public const string BeforeAfterRegex = @"^[.]";
      public const string InConnectorRegex = @"\b(in)\b";
      public const string SinceYearSuffixRegex = @"^[.]";
      public static readonly string WithinNextPrefixRegex = $@"\b(innerhalb|während(\s+der|de(s|m))?(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string TodayNowRegex = @"\b(heute|jetzt)\b";
      public const string MorningStartEndRegex = @"(^(früh|vormittag(s)?)|(morgens?|früh|vormittags?)$)";
      public const string AfternoonStartEndRegex = @"(^(nachmittags?)|(nachmittags?)$)";
      public const string EveningStartEndRegex = @"(^(abends?)|(abends?)$)";
      public const string NightStartEndRegex = @"(^(über nacht|in der nacht|nachts?|nächtens|primetime))|((über nacht|nachts?|nächtens|primetime)$)";
      public const string InexactNumberRegex = @"\b((ein )?paar|einige( wenige)?|wenige)\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"((({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s*({TimeUnitRegex})))";
      public static readonly string RelativeDurationUnitRegex = $@"(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s*)({DurationUnitRegex})))";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+(?<duration>tag|monat|jahr(zehnt)?|wochen(ende|tag))\b";
      public const string ConnectorRegex = @"^(-|,|für|t|gegen)$";
      public const string FromToRegex = @"\b(vom|von).+(bis(\s*zum)?)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(the\s+)?(may|march)$";
      public const string UnspecificDatePeriodRegex = @"^(woche(nende)?|monat|jahr)$";
      public const string PrepositionSuffixRegex = @"\b(am|in|um|gegen|vo[mn]|zu(m|r))$";
      public const string FlexibleDayRegex = @"(?<DayOfMonth>([A-Za-z]+\s)?[A-Za-z\d]+)";
      public static readonly string ForTheRegex = $@"\b(für\s+den\s+{FlexibleDayRegex}(?<end>\s*(,|\.(?!(\d|\s?{WrittenMonthRegex}))|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex}(\s*,)?\s+((de(r|n))\s+{FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+(?!de[nr]){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"\brest\s+((de[rs]|dieser)\s+)((aktuellen|jetzigen)\s+)?(?<duration>woche|monats|jahres)\b";
      public const string RestOfDateTimeRegex = @"\brest\s+((des|diesen)\s+)((aktuellen|heutigen)\s+)?(?<unit>tages)\b";
      public const string MealTimeRegex = @"\b((zu(m|r))\s+)?(?<mealTime>(essenszeit|mittagessen|mittag))\b";
      public const string AmbiguousRangeModifierPrefix = @"^[.]";
      public static readonly string NumberEndingPattern = $@"^(\s+(?<meeting>meeting|termin|telefonkonferenz|conference|skype call|call)\s+to\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\.)?$|(\.,|,|!|\?)))";
      public const string OneOnOneRegex = @"\b(1\s*:\s*1)|(one (on )?one|one\s*-\s*one|one\s*:\s*one)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b(((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?))\s+(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))\s+((?<LatePrefix>ende|spät(e(r|n)?)?)|(?<EarlyPrefix>früh(e(r|n)?)?)))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|diese(r|n|m))\s+woche)((\s+zwischen\s+{WeekDayRegex}\s+und\s+{WeekDayRegex})|(\s+vo(n|m)\s+{WeekDayRegex}\s+(bis\s+)?zum\s+{WeekDayRegex})))\b";
      public const string GeneralEndingRegex = @"\s*((\.,)|\.|,|!|\?)?\s*";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|und|für|,)\s*$";
      public const string PrefixArticleRegex = @"\b(der|dem|des)?\s+";
      public const string OrRegex = @"\s*((\b|,\s*)(oder|und)\b|,)\s*";
      public static readonly string YearPlusNumberRegex = $@"\b(jahr\s+((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b(((?<=\b(vor|nach)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"\s*(?<connector>am)\s*";
      public const string DecadeRegex = @"(?<decade>zwanziger|dreißiger|vierziger|fünfziger|sechziger|siebziger|achtziger|neunziger|zweitausender)(n)?";
      public static readonly string DecadeWithCenturyRegex = $@"(die\s+)?(((?<century>\d|1\d|2\d)?(')?(?<decade>\d0)(')?s)|(({CenturyRegex}(\s+|-)(und\s+)?)?{DecadeRegex})|({CenturyRegex}(\s+|-)(und\s+)?(?<decade>zehner|hunderter)))";
      public static readonly string RelativeDecadeRegex = $@"\b((das|die\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?jahrzehnte?)\b";
      public static readonly string YearSuffix = $@"(,?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public const string SuffixAfterRegex = @"\b(o\s+(nach|in der Vergangenheit))\b";
      public static readonly string YearPeriodRegex = $@"((((von|während|zwischen)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((zwischen)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public const string FutureSuffixRegex = @"\b(in\s+der\s+)?(zukunft|zukünftig)\b";
      public const string PastSuffixRegex = @"^\b$";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public static readonly string ComplexDatePeriodRegex = $@"(((von|während|in)\s+)?(?<start>.+)\s*({TillRegex})\s*(?<end>.+)|((zwischen)\s+)(?<start>.+)\s*({RangeConnectorRegex})\s*(?<end>.+))";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"jahren", @"Y" },
            { @"jahres", @"Y" },
            { @"jahre", @"Y" },
            { @"jahr", @"Y" },
            { @"monaten", @"MON" },
            { @"monate", @"MON" },
            { @"monat", @"MON" },
            { @"monats", @"MON" },
            { @"wochen", @"W" },
            { @"woche", @"W" },
            { @"tagen", @"D" },
            { @"tages", @"D" },
            { @"tage", @"D" },
            { @"tag", @"D" },
            { @"tg", @"D" },
            { @"stunden", @"H" },
            { @"stunde", @"H" },
            { @"h", @"H" },
            { @"minuten", @"M" },
            { @"minute", @"M" },
            { @"min", @"M" },
            { @"sekunden", @"S" },
            { @"sekunde", @"S" },
            { @"sek", @"S" },
            { @"H", @"H" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"jahren", 31536000 },
            { @"jahre", 31536000 },
            { @"jahr", 31536000 },
            { @"monaten", 2592000 },
            { @"monate", 2592000 },
            { @"monat", 2592000 },
            { @"wochen", 604800 },
            { @"woche", 604800 },
            { @"tagen", 86400 },
            { @"tage", 86400 },
            { @"tag", 86400 },
            { @"tg", 86400 },
            { @"stunden", 3600 },
            { @"stunde", 3600 },
            { @"std", 3600 },
            { @"h", 3600 },
            { @"minuten", 60 },
            { @"minute", 60 },
            { @"min", 60 },
            { @"sekunden", 1 },
            { @"sekunde", 1 },
            { @"sek", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"", @"" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"spring", @"SP" },
            { @"summer", @"SU" },
            { @"fall", @"FA" },
            { @"autumn", @"FA" },
            { @"winter", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"erster", 1 },
            { @"ersten", 1 },
            { @"erstes", 1 },
            { @"erste", 1 },
            { @"1", 1 },
            { @"zweiter", 2 },
            { @"zweiten", 2 },
            { @"zweites", 2 },
            { @"zweite", 2 },
            { @"zwoter", 2 },
            { @"2", 2 },
            { @"dritter", 3 },
            { @"dritten", 3 },
            { @"drittes", 3 },
            { @"dritte", 3 },
            { @"3", 3 },
            { @"vierter", 4 },
            { @"vierten", 4 },
            { @"viertes", 4 },
            { @"vierte", 4 },
            { @"4", 4 },
            { @"fünfter", 5 },
            { @"fünften", 5 },
            { @"fünftes", 5 },
            { @"fünfte", 5 },
            { @"5", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"montag", 1 },
            { @"dienstag", 2 },
            { @"mittwoch", 3 },
            { @"donnerstag", 4 },
            { @"freitag", 5 },
            { @"samstag", 6 },
            { @"sonnabend", 6 },
            { @"sonntag", 0 },
            { @"mo.", 1 },
            { @"di.", 2 },
            { @"mi.", 3 },
            { @"do.", 4 },
            { @"fr.", 5 },
            { @"sa.", 6 },
            { @"so.", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"januar", 1 },
            { @"janner", 1 },
            { @"jänner", 1 },
            { @"februar", 2 },
            { @"feber", 2 },
            { @"märz", 3 },
            { @"april", 4 },
            { @"mai", 5 },
            { @"juni", 6 },
            { @"juno", 6 },
            { @"juli", 7 },
            { @"julei", 7 },
            { @"august", 8 },
            { @"september", 9 },
            { @"oktober", 10 },
            { @"november", 11 },
            { @"dezember", 12 },
            { @"jan", 1 },
            { @"jän", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"apr", 4 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"aug", 8 },
            { @"sep", 9 },
            { @"sept", 9 },
            { @"okt", 10 },
            { @"nov", 11 },
            { @"dez", 12 },
            { @"1.", 1 },
            { @"2.", 2 },
            { @"3.", 3 },
            { @"4.", 4 },
            { @"5.", 5 },
            { @"6.", 6 },
            { @"7.", 7 },
            { @"8.", 8 },
            { @"9.", 9 },
            { @"10.", 10 },
            { @"11.", 11 },
            { @"12.", 12 },
            { @"01.", 1 },
            { @"02.", 2 },
            { @"03.", 3 },
            { @"04.", 4 },
            { @"05.", 5 },
            { @"06.", 6 },
            { @"07.", 7 },
            { @"08.", 8 },
            { @"09.", 9 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 },
            { @"erst", 1 },
            { @"zweit", 2 },
            { @"dritt", 3 },
            { @"viert", 4 },
            { @"fünft", 5 },
            { @"fuenft", 5 },
            { @"sechst", 6 },
            { @"siebt", 7 },
            { @"acht", 8 },
            { @"neunt", 9 },
            { @"zehnt", 10 },
            { @"elft", 11 },
            { @"zwölft", 12 },
            { @"zwoelft", 12 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"null", 0 },
            { @"eins", 1 },
            { @"ein", 1 },
            { @"eine", 1 },
            { @"zween", 2 },
            { @"zwei", 2 },
            { @"zwo", 2 },
            { @"drei", 3 },
            { @"vier", 4 },
            { @"fünf", 5 },
            { @"fuenf", 5 },
            { @"sechs", 6 },
            { @"sieben", 7 },
            { @"acht", 8 },
            { @"neun", 9 },
            { @"zehn", 10 },
            { @"elf", 11 },
            { @"zwölf", 12 },
            { @"dreizehn", 13 },
            { @"vierzehn", 14 },
            { @"fünfzehn", 15 },
            { @"sechzehn", 16 },
            { @"siebzehn", 17 },
            { @"achtzehn", 18 },
            { @"neunzehn", 19 },
            { @"zwanzig", 20 },
            { @"einundzwanzig", 21 },
            { @"zweiundzwanzig", 22 },
            { @"dreiundzwanzig", 23 },
            { @"vierundzwanzig", 24 },
            { @"fünfundzwanzig", 25 },
            { @"sechsundzwanzig", 26 },
            { @"siebenundzwanzig", 27 },
            { @"achtundzwanzig", 28 },
            { @"neunundzwanzig", 29 },
            { @"dreißig", 30 },
            { @"einunddreißig", 31 },
            { @"zweiunddreißig", 32 },
            { @"dreiunddreißig", 33 },
            { @"vierunddreißig", 34 },
            { @"fünfunddreißig", 35 },
            { @"sechsunddreißig", 36 },
            { @"siebenunddreißig", 37 },
            { @"achtunddreißig", 38 },
            { @"neununddreißig", 39 },
            { @"vierzig", 40 },
            { @"einundvierzig", 41 },
            { @"zweiundvierzig", 42 },
            { @"dreiundvierzig", 43 },
            { @"vierundvierzig", 44 },
            { @"fünfundvierzig", 45 },
            { @"sechsundvierzig", 46 },
            { @"siebenundvierzig", 47 },
            { @"achtundvierzig", 48 },
            { @"neunundvierzig", 49 },
            { @"fünfzig", 50 },
            { @"einundfünfzig", 51 },
            { @"zweiundfünfzig", 52 },
            { @"dreiundfünfzig", 53 },
            { @"vierundfünfzig", 54 },
            { @"fünfundfünfzig", 55 },
            { @"sechsundfünfzig", 56 },
            { @"siebenundfünfzig", 57 },
            { @"achtundfünfzig", 58 },
            { @"neunundfünfzig", 59 },
            { @"sechzig", 60 },
            { @"einundsechzig", 61 },
            { @"zweiundsechzig", 62 },
            { @"dreiundsechzig", 63 },
            { @"vierundsechzig", 64 },
            { @"fünfundsechzig", 65 },
            { @"sechsundsechzig", 66 },
            { @"siebenundsechzig", 67 },
            { @"achtundsechzig", 68 },
            { @"neunundsechzig", 69 },
            { @"siebzig", 70 },
            { @"einundsiebzig", 71 },
            { @"zweiundsiebzig", 72 },
            { @"dreiundsiebzig", 73 },
            { @"vierundsiebzig", 74 },
            { @"fünfundsiebzig", 75 },
            { @"sechsundsiebzig", 76 },
            { @"siebenundsiebzig", 77 },
            { @"achtundsiebzig", 78 },
            { @"neunundsiebzig", 79 },
            { @"achtzig", 80 },
            { @"einundachtzig", 81 },
            { @"zweiundachtzig", 82 },
            { @"dreiundachtzig", 83 },
            { @"vierundachtzig", 84 },
            { @"fünfundachtzig", 85 },
            { @"sechsundachtzig", 86 },
            { @"siebenundachtzig", 87 },
            { @"achtundachtzig", 88 },
            { @"neunundachtzig", 89 },
            { @"neunzig", 90 },
            { @"einundneunzig", 91 },
            { @"zweiundneunzig", 92 },
            { @"dreiundneunzig", 93 },
            { @"vierundneunzig", 94 },
            { @"fünfundneunzig", 95 },
            { @"sechsundneunzig", 96 },
            { @"siebenundneunzig", 97 },
            { @"achtundneunzig", 98 },
            { @"neunundneunzig", 99 },
            { @"einhundert", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1.", 1 },
            { @"2.", 2 },
            { @"3.", 3 },
            { @"4.", 4 },
            { @"5.", 5 },
            { @"6.", 6 },
            { @"7.", 7 },
            { @"8.", 8 },
            { @"9.", 9 },
            { @"10.", 10 },
            { @"11.", 11 },
            { @"12.", 12 },
            { @"13.", 13 },
            { @"14.", 14 },
            { @"15.", 15 },
            { @"16.", 16 },
            { @"17.", 17 },
            { @"18.", 18 },
            { @"19.", 19 },
            { @"20.", 20 },
            { @"21.", 21 },
            { @"22.", 22 },
            { @"23.", 23 },
            { @"24.", 24 },
            { @"25.", 25 },
            { @"26.", 26 },
            { @"27.", 27 },
            { @"28.", 28 },
            { @"29.", 29 },
            { @"30.", 30 },
            { @"31.", 31 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"13", 13 },
            { @"14", 14 },
            { @"15", 15 },
            { @"16", 16 },
            { @"17", 17 },
            { @"18", 18 },
            { @"19", 19 },
            { @"20", 20 },
            { @"21", 21 },
            { @"22", 22 },
            { @"23", 23 },
            { @"24", 24 },
            { @"25", 25 },
            { @"26", 26 },
            { @"27", 27 },
            { @"28", 28 },
            { @"29", 29 },
            { @"30", 30 },
            { @"31", 31 },
            { @"erst", 1 },
            { @"zweit", 2 },
            { @"dritt", 3 },
            { @"viert", 4 },
            { @"fünft", 5 },
            { @"fuenft", 5 },
            { @"sechst", 6 },
            { @"siebt", 7 },
            { @"acht", 8 },
            { @"neunt", 9 },
            { @"zehnt", 10 },
            { @"elft", 11 },
            { @"zwölft", 12 },
            { @"zwoelft", 12 },
            { @"dreizehnt", 13 },
            { @"vierzehnt", 14 },
            { @"fünfzehnt", 15 },
            { @"fuenfzehnt", 15 },
            { @"sechzehnt", 16 },
            { @"siebzehnt", 17 },
            { @"achtzehnt", 18 },
            { @"neunzehnt", 19 },
            { @"zwanzigst", 20 },
            { @"einundzwanzigst", 21 },
            { @"zweiundzwanzigst", 22 },
            { @"dreiundzwanzigst", 23 },
            { @"vierundzwanzigst", 24 },
            { @"fünfundzwanzigst", 25 },
            { @"fuenfundzwanzigst", 25 },
            { @"sechsundzwanzigst", 26 },
            { @"siebenundzwanzigst", 27 },
            { @"achtundzwanzigst", 28 },
            { @"neunundzwanzigst", 29 },
            { @"dreißigst", 30 },
            { @"einunddreißigst", 31 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"halb", 0.5 },
            { @"viertel", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"reformationday", new string[] { @"reformationstag", @"reformationsfest", @"gedenktagderreformation" } },
            { @"stmartinsday", new string[] { @"martinstag", @"st.martin", @"sanktmartin", @"martinsfest", @"martini" } },
            { @"saintnicholasday", new string[] { @"nikolaustag" } },
            { @"biblicalmagiday", new string[] { @"dreikönigstag", @"dreikönigsfest" } },
            { @"walpurgisnight", new string[] { @"walpurgisnacht" } },
            { @"austriannationalday", new string[] { @"nationalfeiertag" } },
            { @"immaculateconception", new string[] { @"mariäempfängnis" } },
            { @"firstchristmasday", new string[] { @"weihnachten", @"weihnachtstag", @"weihnachtsfeiertag", @"erstenweihnachtstag", @"erstenweihnachtsfeiertag", @"ersterweihnachtstag", @"ersterweihnachtsfeiertag", @"erstenweihnachtstag", @"erstenweihnachtsfeiertag", @"1.weihnachtstag", @"1.weihnachtsfeiertag" } },
            { @"secondchristmasday", new string[] { @"zweiterweihnachtstag", @"zweiterweihnachtsfeiertag", @"zweiteweihnachtstag", @"zweiteweihnachtsfeiertag", @"zweitenweihnachtstag", @"zweitenweihnachtsfeiertag", @"2.weihnachtstag", @"2.weihnachtsfeiertag", @"stefanitag", @"stafanstag" } },
            { @"berchtoldsday", new string[] { @"berchtoldstag", @"bechtelistag", @"bächtelistag", @"berchtelistag", @"bärzelistag" } },
            { @"saintjosephsday", new string[] { @"josefstag", @"joseftag", @"josefitag" } },
            { @"easterday", new string[] { @"ostern" } },
            { @"eastermonday", new string[] { @"ostermontag" } },
            { @"eastersunday", new string[] { @"ostersonntag" } },
            { @"swissnationalday", new string[] { @"bundesfeiertag", @"bundesfeier" } },
            { @"assumptionofmary", new string[] { @"mariähimmelfahrt" } },
            { @"germanunityday", new string[] { @"tagderdeutscheneinheit" } },
            { @"fathers", new string[] { @"vatertag", @"männertag" } },
            { @"mothers", new string[] { @"muttertag" } },
            { @"thanksgiving", new string[] { @"erntedankfest", @"erntedank", @"thanksgiving" } },
            { @"martinlutherking", new string[] { @"martinlutherkingday", @"martinlutherkingjrday" } },
            { @"washingtonsbirthday", new string[] { @"washingtonsbirthday", @"washingtonbirthday" } },
            { @"canberra", new string[] { @"canberraday" } },
            { @"labour", new string[] { @"tagderarbeit" } },
            { @"columbus", new string[] { @"columbusday" } },
            { @"memorial", new string[] { @"memorialday" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"maosbirthday", new string[] { @"maosbirthday" } },
            { @"teachersday", new string[] { @"teachersday", @"teacherday" } },
            { @"singleday", new string[] { @"singleday" } },
            { @"allsaintsday", new string[] { @"allerheiligen" } },
            { @"youthday", new string[] { @"tag der jugend" } },
            { @"childrenday", new string[] { @"kindertag", @"weltkindertag" } },
            { @"femaleday", new string[] { @"frauentag" } },
            { @"treeplantingday", new string[] { @"treeplantingday" } },
            { @"arborday", new string[] { @"tag des baumes" } },
            { @"girlsday", new string[] { @"girlsday" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"loverday" } },
            { @"xmas", new string[] { @"xmas" } },
            { @"newyear", new string[] { @"neujahr" } },
            { @"newyearday", new string[] { @"neujahrstag", @"neujahr" } },
            { @"newyearsday", new string[] { @"neujahrstag", @"neujahr" } },
            { @"inaugurationday", new string[] { @"inaugurationday" } },
            { @"groundhougday", new string[] { @"murmeltiertag" } },
            { @"valentinesday", new string[] { @"valentinstag" } },
            { @"stpatrickday", new string[] { @"stpatrickday" } },
            { @"aprilfools", new string[] { @"erster april", @"aprilscherz" } },
            { @"stgeorgeday", new string[] { @"georgstag" } },
            { @"mayday", new string[] { @"mayday", @"maitag", @"tagderarbeit", @"maifeiertag" } },
            { @"laborday", new string[] { @"mayday", @"maitag", @"tagderarbeit", @"maifeiertag" } },
            { @"cincodemayoday", new string[] { @"cincodemayo" } },
            { @"baptisteday", new string[] { @"geburtjohannesdestäufers" } },
            { @"usindependenceday", new string[] { @"usunabhängigkeitstag" } },
            { @"independenceday", new string[] { @"unabhängigkeitstag" } },
            { @"bastilleday", new string[] { @"sturmaufdiebastille" } },
            { @"halloweenday", new string[] { @"halloween" } },
            { @"allhallowday", new string[] { @"allerheiligen" } },
            { @"allsoulsday", new string[] { @"allerseelen" } },
            { @"guyfawkesday", new string[] { @"guyfawkesday", @"guyfawkesnight" } },
            { @"veteransday", new string[] { @"veteransday" } },
            { @"piday", new string[] { @"piday", @"pitag", @"pi-tag" } },
            { @"christmaseve", new string[] { @"heiligabend" } },
            { @"newyeareve", new string[] { @"silvester" } },
            { @"weiberfastnacht", new string[] { @"weiberfastnacht" } },
            { @"carnival", new string[] { @"karneval" } },
            { @"ashwednesday", new string[] { @"aschermittwoch" } },
            { @"palmsunday", new string[] { @"palmensonntag", @"palmsonntag" } },
            { @"goodfriday", new string[] { @"karfreitag" } },
            { @"ascensionofchrist", new string[] { @"christihimmelfahrt" } },
            { @"whitesunday", new string[] { @"pfingstsonntag", @"pfingsten" } },
            { @"whitemonday", new string[] { @"pfingstmontag" } },
            { @"corpuschristi", new string[] { @"fronleichnam" } },
            { @"rosenmontag", new string[] { @"rosenmontag" } },
            { @"fastnacht", new string[] { @"fastnacht" } },
            { @"holythursday", new string[] { @"gründonnerstag", @"himmelfahrt" } },
            { @"memorialdaygermany", new string[] { @"volkstrauertag" } },
            { @"dayofrepentance", new string[] { @"bußundbettag", @"buß-undbettag", @"bussundbettag" } },
            { @"totensonntag", new string[] { @"totensonntag", @"totenfest", @"ewigkeitssonntag" } },
            { @"firstadvent", new string[] { @"ersteadvent", @"erstenadvent", @"ersteradvent", @"1.advent" } },
            { @"secondadvent", new string[] { @"zweiteadvent", @"zweitenadvent", @"zweiteradvent", @"2.advent" } },
            { @"thirdadvent", new string[] { @"dritteadvent", @"drittenadvent", @"dritteradvent", @"3.advent" } },
            { @"fourthadvent", new string[] { @"vierteadvent", @"viertenadvent", @"vierteradvent", @"4.advent" } },
            { @"chedayofrepentance", new string[] { @"schweizerbußundbettag", @"schweizerbuß-undbettag", @"schweizerbussundbettag" } },
            { @"beginningofsummer", new string[] { @"sommeranfang" } },
            { @"beginningofwinter", new string[] { @"winteranfang" } },
            { @"beginningofspring", new string[] { @"frühlingsanfang" } },
            { @"beginningoffall", new string[] { @"herbstanfang" } },
            { @"eastersaturday", new string[] { @"karsamstag" } },
            { @"fastnachtssamstag", new string[] { @"fastnachtssamstag" } },
            { @"fastnachtssonntag", new string[] { @"fastnachtssonntag" } },
            { @"heiligedreikönige", new string[] { @"heiligedreikönige" } },
            { @"barbaratag", new string[] { @"barbaratag" } },
            { @"augsburgerfriedensfest", new string[] { @"augsburgerfriedensfest" } },
            { @"johannistag", new string[] { @"johannistag" } },
            { @"peterundpaul", new string[] { @"peterundpaul" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"hundert", 0 },
            { @"zehn", 10 },
            { @"zwanziger", 20 },
            { @"dreißiger", 30 },
            { @"vierziger", 40 },
            { @"fünfziger", 50 },
            { @"sechziger", 60 },
            { @"siebziger", 70 },
            { @"achtziger", 80 },
            { @"neunziger", 90 },
            { @"zwanzigern", 20 },
            { @"dreißigern", 30 },
            { @"vierzigern", 40 },
            { @"fünfzigern", 50 },
            { @"sechzigern", 60 },
            { @"siebzigern", 70 },
            { @"achtzigern", 80 },
            { @"neunzigern", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"zweitausender", 2000 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly string[] DurationDateRestrictions = { @"today", @"now" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"\b(morgen|nachmittag|abend|nacht|tag)\b", @"\b(gut(en?)?\s+(morgen|nachmittag|abend|nacht|tag))\b" },
            { @"^(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)$", @"([$%£&!?@#])(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)|(apr|aug|dez|feb|j[äa]n|jul|jun|märz|mai|nov|okt|sept?)([$%£&@#])" },
            { @"^(mo|di|mi|do|fr|sa|so)$", @"\b(mo|di|mi|do|fr|sa|so)\b" },
            { @"^((früh|spät)(\s+am|er)?\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)$", @"((?<!(frü|spä))[a-z0-9])((früh|spät)(\s+am|er)?\s*)?(abends?|morgens?|nachts?|(vor|nach)mittags?|früh|primetime)\b" }
        };
      public static readonly string AmbiguousTimePeriodRegex = $@"\b((?<!{RelativeRegex}\s+)morgen|früh(?!(\s*morgens?)))\b";
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"morgen",
            @"vormittag",
            @"früh"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"nachmittag"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"abend"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"tag"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"nacht",
            @"nachts",
            @"primetime"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"heute",
            @"heutige datum",
            @"heutige tag",
            @"aktuelles datum",
            @"aktuelle datum",
            @"aktueller tag",
            @"aktuellen tag",
            @"aktuelle tag",
            @"dieser morgen",
            @"diesem morgen",
            @"diesen morgen",
            @"aktuelle morgen",
            @"aktuellen morgen",
            @"jetzige morgen",
            @"jetzigen morgen"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"morgen",
            @"morgiger tag",
            @"morgigen tag",
            @"morgigen tages"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"gestern",
            @"gestriger tag",
            @"gestrigen tag",
            @"gestrigen tages"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"übermorgen"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"vorgestern"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"dieser",
            @"diesen",
            @"dieses",
            @"diese",
            @"nächster",
            @"nächstes",
            @"nächsten",
            @"nächstem",
            @"nächste"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"letzter",
            @"letztes",
            @"letzten",
            @"letztem"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"monat",
            @"monate",
            @"monaten",
            @"monats"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"month to date"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"wochenende",
            @"wochenendes"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"woche"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"jahr",
            @"jahre",
            @"jahren",
            @"jahres"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"year to date"
        };
    }
}