﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\French\French-DateTime.yaml
//     - Language: French
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.French
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Fre";
      public const bool CheckBothBeforeAfter = false;
      public const string TillRegex = @"(?<till>\b(au|et|(jusqu')?a|avant)\b|(jusqu')?à|--|-|—|——)";
      public const string RangeConnectorRegex = @"(?<and>\b(de\s+la|au|(jusqu')?a|et(\s*la)?)\b|(jusqu')?à|--|-|—|——)";
      public const string RelativeRegex = @"(?<order>prochaine?|de|du|ce(tte)?|l[ae]|derni[eè]re?s?|hier|pr[eé]c[eé]dente|au\s+cours+(de|du\s*))";
      public const string StrictRelativeRegex = @"(?<order>prochaine?|derni[eè]re?s?|hier|pr[eé]c[eé]dente|au\s+cours+(de|du\s*))";
      public const string NextSuffixRegex = @"(?<order>prochain(es?)?|suivante)\b";
      public const string PastSuffixRegex = @"(?<order>derni[eè]re?s?|pr[eé]c[eé]dente)\b";
      public const string ThisPrefixRegex = @"(?<order>ce(tte)?|au\s+cours+(du|de))\b";
      public const string RangePrefixRegex = @"(du|depuis|des?|entre)";
      public const string DayRegex = @"(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(e(r)?)?)(?=\b|t)";
      public const string WrittenDayRegex = @"(?<day>((vingt|trente)(\s*-\s*|\s+)et(\s*-\s*|\s+))?un|(vingt(\s*-\s*|\s+))?(deux|trois|quatre|cinq|six|sept|huit|neuf)|dix|onze|douze|treize|quatorze|quinze|seize|dix-(sept|huit|neuf)|vingt|trente)";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])\b";
      public const string SpecialDescRegex = @"(p\b)";
      public static readonly string AmDescRegex = $@"(h\b|{BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"(h\b|{BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"(h\b|{BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(?<desc>{AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public const string WrittenOneToNineRegex = @"(?:une?|deux|trois|quatre|cinq|six|sept|huit|neuf)";
      public const string WrittenElevenToNineteenRegex = @"(?:(seize|quinze|quatorze|treize|douze|onze)|dix\W(neuf|huit|sept))";
      public const string WrittenTensRegex = @"(?:quatre\Wvingt(s|\Wdix)?|soixante(\Wdix)?|dix|vingt|trente|quarante|cinquante|septante|octante|huitante|nonante)";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?:(deux\s+)?mille((\s+{WrittenOneToNineRegex})?\s+cents?)?)";
      public static readonly string WrittenCenturyOrdinalYearRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|dix)";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\s+cents?)?)\b";
      public static readonly string LastTwoYearNumRegex = $@"(({WrittenTensRegex}(\s+|-))?({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex})|{WrittenTensRegex})";
      public static readonly string FullTextYearRegex = $@"\b(?<fullyear>(?<firsttwoyearnum>{CenturyRegex})\s+(?<lasttwoyearnum>{LastTwoYearNumRegex})\b|\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\s+cents))\b";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"(?<weekday>dimanche|lundi|mardi|mercredi|jeudi|vendredi|samedi|lun(\.)?|mar(\.)?|mer(\.)?|jeu(\.)?|ven(\.)?|sam(\.)?|dim(\.)?)";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>({ThisPrefixRegex}\s+mois)|(mois\s+{PastSuffixRegex})|(mois\s+{NextSuffixRegex}))\b";
      public const string WrittenMonthRegex = @"(?<month>avril|avr(\.)?|ao[uû]t|d[eé]cembre|d[eé]c(\.)?|f[eé]vrier|f[eé]vr?(\.)?|janvier|janv?(\.)?|juillet|jui?[ln](\.)?|mars?(\.)?|mai|novembre|nov(\.)?|octobre|oct(\.)?|septembre|sept?(\.)?(?!\s+heures))";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>(en\s*|le\s*|de\s*|dans\s*)?({RelativeMonthRegex}|{WrittenMonthRegex}))";
      public const string DateUnitRegex = @"(?<unit>an(?<plural>s)?|(?<plural>mois)|((l')?ann[eé]e|semaine|journ[eé]e|jour)(?<plural>s)?)\b";
      public static readonly string SimpleCasesRegex = $@"\b((d[ue])|entre\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b((d[ue]|entre)\s+)?{MonthSuffixRegex}\s+((d[ue]|entre)\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+(entre|d[ue]\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string BetweenRegex = $@"\b(entre\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public const string YearWordRegex = @"\b(?<year>l'ann[ée]e)\b";
      public static readonly string MonthWithYear = $@"\b({WrittenMonthRegex}(\s*),?(\s+de)?(\s*)({YearRegex}|{TwoDigitYearRegex}|(?<order>cette)\s*{YearWordRegex})|{YearWordRegex}\s*({PastSuffixRegex}|{NextSuffixRegex}))";
      public static readonly string OneWordPeriodRegex = $@"\b(({RelativeRegex}\s+)?{WrittenMonthRegex}|(la\s+)?(weekend|(fin de )?semaine|week-end|mois|ans?|l'année)\s+{StrictRelativeRegex}|{RelativeRegex}\s+(weekend|(fin de )?semaine|week-end|mois|ans?|l'année)|weekend|week-end|mois|l'année|an)\b";
      public static readonly string MonthNumWithYear = $@"({YearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-](\s*){YearRegex})";
      public static readonly string WeekOfMonthRegex = $@"(?<wom>(le\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\s+semaine(\s+de)?\s+{MonthSuffixRegex})";
      public static readonly string WeekOfYearRegex = $@"(?<woy>(le\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\s+semaine(\s+de)?\s+({YearRegex}|{RelativeRegex}\s+ann[ée]e))";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public static readonly string QuarterRegex = $@"(le\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4)\s+quart(\s+de|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+l'ann[eé]e)";
      public static readonly string QuarterRegexYearFront = $@"({YearRegex}|l'année\s+({PastSuffixRegex}|{NextSuffixRegex})|{RelativeRegex}\s+ann[eé]e)\s+(le\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4)\s+quarts";
      public const string AllHalfYearRegex = @"^\b$";
      public const string PrefixDayRegex = @"\b((?<EarlyPrefix>t[ôo]t\sdans)|(?<MidPrefix>au\smilieu\sde)|(?<LatePrefix>tard\sdans))(\s+la\s+journ[ée]e)?$";
      public const string CenturySuffixRegex = @"^\b$";
      public static readonly string SeasonRegex = $@"\b((<seas>printemps|été|automne|hiver)+\s*({NextSuffixRegex}|{PastSuffixRegex}))|(?<season>({RelativeRegex}\s+)?(?<seas>printemps|[ée]t[ée]|automne|hiver)((\s+de|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+l'ann[eé]e))?)\b";
      public const string WhichWeekRegex = @"\b(semaine)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b";
      public const string WeekOfRegex = @"(semaine)(\s*)(de)";
      public const string MonthOfRegex = @"(mois)(\s*)(de)";
      public const string MonthRegex = @"(?<month>avril|avr(\.)?|ao[uû]t|d[eé]cembre|d[eé]c(\.)?|f[eé]vrier|f[eé]vr?(\.)?|janvier|janv?(\.)?|juillet|jui?[ln](\.)?|mars?(\.)?|mai|novembre|nov(\.)?|octobre|oct(\.)?|septembre|sept?(\.)?(?!\s+heures))";
      public static readonly string OnRegex = $@"(?<=\b(en|sur\s*l[ea]|sur)\s+)({DayRegex}s?)\b";
      public const string RelaxedOnRegex = @"(?<=\b(en|le|dans|sur\s*l[ea]|du|sur)\s+)((?<day>10e|11e|12e|13e|14e|15e|16e|17e|18e|19e|1er|20e|21e|22e|23e|24e|25e|26e|27e|28e|29e|2e|30e|31e|3e|4e|5e|6e|7e|8e|9e)s?)\b";
      public static readonly string ThisRegex = $@"\b((cette(\s*semaine)?\s+){WeekDayRegex})|({WeekDayRegex}(\s+cette\s*semaine))\b";
      public static readonly string LastDateRegex = $@"\b(({WeekDayRegex}(\s*(de)?\s*la\s*semaine\s+{PastSuffixRegex}))|({WeekDayRegex}(\s+{PastSuffixRegex})))\b";
      public static readonly string NextDateRegex = $@"\b(({WeekDayRegex}(\s+{NextSuffixRegex}))|({WeekDayRegex}(\s*(de)?\s*la\s*semaine\s+{NextSuffixRegex})))\b";
      public const string SpecialDayRegex = @"\b(avant[\s|-]hier|apr[eè]s(-demain|\s*demain)|(le\s)?jour suivant|(le\s+)?derni[eè]re?s? jour|hier|lendemain|demain|(de\s)?la journ[ée]e|aujourd'hui)\b";
      public const string SpecialDayWithNumRegex = @"^\b$";
      public const string StrictWeekDay = @"\b(?<weekday>dim(anche)?|lun(di)?|mar(di)?|mer(credi)?|jeu(di)?|ven(dredi)?|sam(edi)?)s?\b";
      public const string SetWeekDayRegex = @"\b(?<prefix>le\s+)?(?<weekday>matin([ée]e)?|apr[eè]s-midi|soir([ée]e)?|dimanche|lundi|mardi|mercredi|jeudi|vendredi|samedi)s\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>(le\s+)?(?<cardinal>premier|1er|duexi[èe]me|2|troisi[èe]me|3|quatri[èe]me|4|cinqi[èe]me|5)\s+{WeekDayRegex}\s+{MonthSuffixRegex})";
      public const string RelativeWeekDayRegex = @"^\b$";
      public const string AmbiguousRangeModifierPrefix = @"^\b$";
      public const string NumberEndingPattern = @"^\b$";
      public static readonly string SpecialDate = $@"(?<=\b(au|le)\s+){DayRegex}(?!:)\b";
      public static readonly string DateYearRegex = $@"(?<year>{YearRegex}|{TwoDigitYearRegex})";
      public static readonly string DateExtractor1 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{MonthRegex}\s*[/\\\.\-]?\s*{DayRegex}(\s*([/\\\.\-]|\bde\b)?\s*{BaseDateTime.FourDigitYearRegex})?\b";
      public static readonly string DateExtractor2 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?{DayRegex}(\s+|\s*,\s*|\s+){MonthRegex}\s*([\.\-]|\bde\b)?\s*{DateYearRegex}\b";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*))?((?<!\d\s)(?<!\d){DayRegex}(\s+|\s*[.,/-])({MonthRegex}((\s+|\s*[.,/-]\s*){DateYearRegex}(?!\s*\d))?|{MonthNumRegex}(\s+|\s*[.,/-]\s*){DateYearRegex}(?!\s*\d))|{BaseDateTime.FourDigitYearRegex}\s*[.,/-]?\s*{DayRegex}\s*[.,/-]?\s*{MonthRegex})\b";
      public static readonly string DateExtractor4 = $@"\b{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}\s*[/\\\-]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor5 = $@"\b{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<=\b(le|sur(\sl[ae])?)\s+){MonthNumRegex}[\-\.\/]{DayRegex}{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor7 = $@"\b{DayRegex}\s*/\s*{MonthNumRegex}((\s+|\s*,\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor8 = $@"(?<=\b(le)\s+){DayRegex}[\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor9 = $@"\b{DayRegex}\s*/\s*{MonthNumRegex}((\s+|\s*,\s*){DateYearRegex})?{BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractorA = $@"\b({DateYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}|{MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{DayRegex}|{DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})(?!\s*[/\\\-\.:]\s*\d+)";
      public static readonly string OfMonth = $@"^(\s*de)?\s*{MonthRegex}\b";
      public static readonly string MonthEnd = $@"{MonthRegex}\s*(le)?\s*$";
      public static readonly string WeekDayEnd = $@"{WeekDayRegex}\s*,?\s*$";
      public const string WeekDayStart = @"^\b$";
      public const string RangeUnitRegex = @"\b(?<unit>(l')?ann[eé]e(s)?|mois|semaines?)\b";
      public const string HourNumRegex = @"\b(?<hournum>zero|une?(?=\s+heure)|deux|trois|quatre|cinq|six|sept|huit|neuf|onze|douze|treize|quatorze|quinze|dix-six|seize|dix(-|\s+)sept|dix(-|\s+)huit|dix(-|\s+)neuf|vingt|vingt(-|\s+)et(-|\s+)un|vingt(-|\s+)deux|vingt(-|\s+)trois|dix)\b";
      public const string MinuteNumRegex = @"(?<minnum>((vingt|trente|quarante|cinquante)(\s*(et|-)?\s*))?(un|deux|trois|quatre|cinq|six|sept|huit|neuf)|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt|trente|quarante|cinquante|dix)";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>((vingt|trente|quarante|cinquante)(\s*(et|-)?\s*))?(un|deux|trois|quatre|cinq|six|sept|huit|neuf)|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt|trente|quarante|cinquante|dix)";
      public const string OclockRegex = @"(?<oclock>heures?|h)";
      public const string PmRegex = @"(?<pm>(dans l'\s*)?apr[eè]s(\s*|-)midi|(du|ce|de|le)\s*(soir([ée]e)?)|(dans l[ea]\s+)?(nuit|soir[eé]e))";
      public const string AmRegex = @"(?<am>(du|de|ce|(du|de|dans)\s*l[ea]|le)?\s*matin[ée]e|(du|de|ce|dans l[ea]|le)?\s*matin)";
      public static readonly string LessThanOneHour = $@"(?<lth>(une\s+)?quart|trois quart(s)?|demie( heure)?|({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex})(\s+(minutes?|mins?))|(?<=heures?\s+((et|moins)\s+)?)({BaseDateTime.DeltaMinuteRegex}|{DeltaMinuteNumRegex}))";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s+(heures\s+)?(et\s+)?{MinuteNumRegex}(?!\s+heures)(\s+(minutes?|mins?))?)";
      public static readonly string TimePrefix = $@"(?<prefix>(heures?\s+((et|moins)\s+)?{LessThanOneHour}|(et|moins)\s+{LessThanOneHour}|{LessThanOneHour}\s+[àa]))";
      public static readonly string TimeSuffix = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string BasicTime = $@"(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(:|\s*h\s*){BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex})";
      public const string MidnightRegex = @"(?<midnight>minuit)";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public const string MorningRegex = @"(?<morning>matin([ée]e)?)";
      public const string AfternoonRegex = @"(?<afternoon>(d'|l')?apr[eè]s(-|\s*)midi)";
      public static readonly string MidmorningRegex = $@"(?<midmorning>milieu\s*d[ue]\s*{MorningRegex})";
      public const string MiddayRegex = @"(?<midday>milieu(\s*|-)d[eu]\s*(jour|midi)|apr[eè]s(-|\s*)midi|(?<=à\s+)midi)";
      public static readonly string MidafternoonRegex = $@"(?<midafternoon>milieu\s*d'+{AfternoonRegex})";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"\b(((?<=\b[àa]\s+)({WrittenTimeRegex}|{HourNumRegex}(\s+heures)?|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public static readonly string IshRegex = $@"\b(peu\s*pr[èe]s\s*{BaseDateTime.HourRegex}|peu\s*pr[èe]s\s*{WrittenTimeRegex}|peu\s*pr[èe]s\s*[àa]\s*{BaseDateTime.HourRegex}|peu pr[èe]s midi)\b";
      public const string TimeUnitRegex = @"(?<unit>h|(heure|hr|minute|min|seconde|sec)(?<plural>s)?)\b";
      public const string RestrictedTimeUnitRegex = @"(?<unit>huere|minute)\b";
      public static readonly string ConnectNumRegex = $@"{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex}";
      public const string FivesRegex = @"(?<tens>(quinze|vingt(\s*|-*(cinq))?|trente(\s*|-*(cinq))?|quarante(\s*|-*(cinq))??|cinquante(\s*|-*(cinq))?|dix|cinq))\b";
      public const string PeriodHourNumRegex = @"(?<hour>vingt-et-un|vingt-deux|vingt-trois|vingt-quatre|zero|une|deux|trois|quatre|cinq|six|sept|huit|neuf|dix|onze|douze|treize|quatorze|quinze|seize|dix-sept|dix-huit|dix-neuf|vingt)";
      public static readonly string TimeRegex1 = $@"\b({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})\s*{DescRegex}(\s+{TimePrefix})?\b";
      public static readonly string TimeRegex2 = $@"(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"\b{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})(\s+{TimePrefix})?";
      public static readonly string TimeRegex4 = $@"\b{BasicTime}(\s*{DescRegex})?(\s+{TimePrefix})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex5 = $@"\b{BasicTime}((\s*{DescRegex})(\s+{TimePrefix})?|\s+{TimePrefix})";
      public static readonly string TimeRegex6 = $@"{BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex7 = $@"\b{TimeSuffix}\s+[àa]\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@"\b{TimeSuffix}\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex9 = $@"\b{PeriodHourNumRegex}\s+{FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"\b{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?(\s+{TimePrefix})?";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string PeriodDescRegex = @"(?<desc>pm|am|p\.m\.|a\.m\.|p)";
      public const string PeriodPmRegex = @"(?<pm>dans l'apr[eè]s-midi|ce soir|d[eu] soir|dans l[ea] soir[eé]e|dans la nuit|d[eu] soir[ée]e)s?";
      public const string PeriodAmRegex = @"(?<am>d[eu] matin|matin([ée]e)s?";
      public static readonly string PureNumFromTo = $@"((du|depuis|des?)\s+)?(?<!\d[\/.,:\-])({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{PeriodDescRegex}))?\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?";
      public static readonly string PureNumBetweenAnd = $@"(entre\s+)({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{PeriodDescRegex}))?\s*{RangeConnectorRegex}\s*({HourRegex}|{PeriodHourNumRegex})\s*(?<rightDesc>{PmRegex}|{AmRegex}|{PeriodDescRegex})?";
      public const string SpecificTimeFromTo = @"^\b$";
      public const string SpecificTimeBetweenAnd = @"^\b$";
      public const string PrepositionRegex = @"(?<prep>^([aà](\s+?la)?|en|sur(\s*l[ea])?|de)$)";
      public const string TimeOfDayRegex = @"\b(?<timeOfDay>((((dans\s+(l[ea])?\s+)?((?<early>d[eé]but(\s+|-)|t[oô]t(\s+|-)(l[ea]\s*)?)|(?<late>fin\s*|fin de(\s+(la)?)|tard\s*))?(matin([ée]e)?|((d|l)?'?)apr[eè]s[-|\s*]midi|nuit|soir([eé]e)?)))|(((\s+(l[ea])?\s+)?)jour(n[eé]e)?))s?)\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{TimeOfDayRegex})|({TimeOfDayRegex}\s*({NextSuffixRegex}))\b|\b(du )?soir)s?\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public const string NowRegex = @"\b(?<now>(ce\s+)?moment|maintenant|(d[eè]s|aussit[oô]t) que possible|dqp|r[eé]cemment|auparavant|le plus tôt( que)? possible)\b";
      public const string SuffixRegex = @"^\s*((dans\s+l[ea]\s+)|(en\s+)|(d(u|\'))?(matin([eé]e)?|apr[eè]s-midi|soir[eé]e|nuit))\b";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>matin([eé]e)?|apr[eè]s-midi|nuit|soir)\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})\b|\b(ce(tte)?\s+)(soir|nuit))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?(en|dans|du\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+([àa]|vers|pour))?\s*$";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?(en|[àa]\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+([àa]|vers|pour))?\s*({HourNumRegex}|{BaseDateTime.HourRegex})";
      public const string SpecificEndOfRegex = @"(la\s+)?fin(\s+de\s*|\s*de*l[ea])?\s*$";
      public const string UnspecificEndOfRegex = @"^\b$";
      public const string UnspecificEndOfRangeRegex = @"^\b$";
      public const string PeriodTimeOfDayRegex = @"\b((dans\s+(le)?\s+)?((?<early>d[eé]but(\s+|-|d[ue]|de la)|t[oô]t)|(?<late>tard\s*|fin(\s+|-|d[eu])?))?(?<timeOfDay>matin|((d|l)?'?)apr[eè]s-midi|nuit|soir([eé]e)?))\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{PeriodTimeOfDayRegex})\b|\b(ce(tte)?\s+)(soir|nuit))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"\b(({TimeOfDayRegex}))\b";
      public const string LessThanRegex = @"^\b$";
      public const string MoreThanRegex = @"^\b$";
      public const string DecadeRegex = @"(?<decade>(?:dix|vingt|trente|quarante|cinquante|soixante-dix|soixante|quatre-vingt-dix|quatre-vingts|deux\s+mille))";
      public static readonly string DecadeWithCenturyInnerRegex = $@"(((?<century>\d|1\d|2\d)?((?<decade>\d0)\b)|(?<decade>\d0)(?=s))|(({CenturyRegex}(\s+)(et\s+)?)?{DecadeRegex})|({CenturyRegex}(\s+)(et\s+)?(?<decade>dix|centaines)))";
      public static readonly string DurationUnitRegex = $@"(?<unit>\bann[eé]es?(?!\s+{DecadeWithCenturyInnerRegex})\b|ans?|mois|semaines?|jours?|heures?|hrs?|h|minutes?|mins?|secondes?|secs?|journ[eé]e)\b";
      public const string SuffixAndRegex = @"(?<suffix>\s*(et)\s+(une?\s+)?(?<suffix_num>demi|quart))";
      public const string PeriodicRegex = @"\b(?<periodic>quotidien(ne)?|journellement|mensuel(le)?|jours?|hebdomadaire|bihebdomadaire|annuel(lement)?)\b";
      public static readonly string EachUnitRegex = $@"(?<each>(chaque|toutes les|tous les)(?<other>\s+autres)?\s*{DurationUnitRegex})";
      public const string EachPrefixRegex = @"\b(?<each>(chaque|tous les|(toutes les))\s*$)";
      public const string SetEachRegex = @"\b(?<each>(chaque|tous les|(toutes les))\s*)";
      public const string SetLastRegex = @"(?<last>prochain|derni[eè]re?s?|pass[ée]s|pr[eé]c[eé]dent|courant|en\s*cours)";
      public const string EachDayRegex = @"\s*(chaque|tous les)\s*(jour|jours)\b";
      public static readonly string DurationFollowedUnit = $@"^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex}";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"\b(((?<half>demi\s+)?(-)\s+{DurationUnitRegex}))";
      public const string DuringRegex = @"^\b$";
      public const string AllRegex = @"\b(?<all>toute\s(l['ea])\s?(?<unit>ann[eé]e|mois|semaines?|jours?|journ[eé]e))\b";
      public const string HalfRegex = @"((une?\s*)|\b)(?<half>demi?(\s*|-)+(?<unit>ann[eé]e|ans?|mois|semaine|jour|heure))\b";
      public const string ConjunctionRegex = @"\b((et(\s+de|pour)?)|avec)\b";
      public static readonly string HolidayRegex1 = $@"\b(?<holiday>vendredi saint|mercredi des cendres|p[aâ]ques|l'action de gr[âa]ce|mardi gras|la saint-sylvestre|la saint sylvestre|la saint-valentin|la saint valentin|nouvel an chinois|nouvel an|r[eé]veillon de nouvel an|jour de l'an|premier-mai|ler-mai|1-mai|poisson d'avril|r[eé]veillon de no[eë]l|veille de no[eë]l|noël|noel|thanksgiving|halloween|yuandan)(\s+((d[ue]\s+|d'))?({YearRegex}|({ThisPrefixRegex}\s+)ann[eé]e|ann[eé]e\s+({PastSuffixRegex}|{NextSuffixRegex})))?\b";
      public static readonly string HolidayRegex2 = $@"\b(?<holiday>martin luther king|martin luther king jr|toussaint|st patrick|st george|cinco de mayo|l'ind[eé]pendance(\s+am[eé]ricaine)?|guy fawkes)(\s+(de\s+)?({YearRegex}|{ThisPrefixRegex}\s+ann[eé]e|ann[eé]e\s+({PastSuffixRegex}|{NextSuffixRegex})))?\b";
      public static readonly string HolidayRegex3 = $@"(?<holiday>(jour\s*(d[eu]|des)\s*(canberra|p[aâ]ques|colomb|bastille|la prise de la bastille|thanks\s*giving|bapt[êe]me|nationale|d'armistice|inaugueration|marmotte|assomption|femme|comm[ée]moratif)))(\s+(de\s+)?({YearRegex}|{ThisPrefixRegex}\s+ann[eé]e|ann[eé]e\s+({PastSuffixRegex}|{NextSuffixRegex})))?";
      public static readonly string HolidayRegex4 = $@"(?<holiday>(f[eê]te\s*(d[eu]|des)\s*)(travail|m[eè]res?|p[eè]res?))(\s+(de\s+)?({YearRegex}|{ThisPrefixRegex}\s+ann[eé]e|ann[eé]e\s+({PastSuffixRegex}|{NextSuffixRegex})))?\b";
      public const string DateTokenPrefix = @"le ";
      public const string TimeTokenPrefix = @"à ";
      public const string TokenBeforeDate = @"le ";
      public const string TokenBeforeTime = @"à ";
      public const string HalfTokenRegex = @"\b(demie)$";
      public const string QuarterTokenRegex = @"\b((un\s+)?quart)$";
      public const string ThreeQuarterTokenRegex = @"\b(trois\s+quarts)$";
      public const string ToTokenRegex = @"\b(moins|[aà]$)\b";
      public const string AMTimeRegex = @"(?<am>matin([ée]e)?)";
      public const string PMTimeRegex = @"\b(?<pm>(d'|l')?apr[eè]s-midi|nuit|((\s*ce|du)\s+)?soir)\b";
      public const string AsapTimeRegex = @"((d[eè]s|le plus t[oô]t|aussit[oô]t)( que)? possible|dqp)";
      public const string BeforeRegex = @"\b(avant)\b";
      public const string BeforeRegex2 = @"\b(entre\s*(le|la(s)?)?)\b";
      public const string AfterRegex = @"\b(apres)\b";
      public const string SinceRegex = @"\b(depuis)\b";
      public const string AroundRegex = @"\b(vers|à\s+peu\s+près|environ)\b";
      public const string AgoPrefixRegex = @"\b(y a)\b";
      public const string LaterRegex = @"\b(plus\s+tard|à\s+partir\s+(de\s+(maintenant|demain)|d'aujourd'hui)|après\s+(aujourd'hui|demain))\b";
      public static readonly string AgoRegex = $@"\b((il\s+y\s*a)(\s+{AroundRegex})?|auparavant|avant\s+(?<day>hier|aujourd'hui))\b";
      public const string BeforeAfterRegex = @"^\b$";
      public const string InConnectorRegex = @"\b(dans|en)\b";
      public const string SinceYearSuffixRegex = @"^\b$";
      public const string WithinNextPrefixRegex = @"\b(dans\s+les)\b";
      public const string TodayNowRegex = @"\b(aujourd'hui|maintenant)\b";
      public const string MorningStartEndRegex = @"(^(matin))|((matin)$)";
      public const string AfternoonStartEndRegex = @"(^((d'|l')?apr[eè]s-midi))|(((d'|l')?apr[eè]s-midi)$)";
      public const string EveningStartEndRegex = @"(^(soir[ée]e|soir))|((soir[ée]e|soir)$)";
      public const string NightStartEndRegex = @"(^(nuit))|((nuit)$)";
      public const string InexactNumberRegex = @"\b(quel qu[ée]s|quelqu[ée]s?|plusieurs?|divers)\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"(((({ThisPrefixRegex})?)\s+({TimeUnitRegex}(\s*{NextSuffixRegex}|{PastSuffixRegex})?))|((le))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"\b(((?<=({NextSuffixRegex}|{PastSuffixRegex})\s+)({DurationUnitRegex}))|(({DurationUnitRegex})(\s+({NextSuffixRegex}|{PastSuffixRegex}))?)|((le|my))\s+({RestrictedTimeUnitRegex}))\b";
      public const string ReferenceDatePeriodRegex = @"^\b$";
      public const string UpcomingPrefixRegex = @".^";
      public const string NextPrefixRegex = @".^";
      public const string PastPrefixRegex = @".^";
      public const string PreviousPrefixRegex = @".^";
      public static readonly string RelativeDayRegex = $@"\b(((la\s+)?{RelativeRegex}\s+journ[ée]e))\b";
      public const string ConnectorRegex = @"^(,|pour|t|vers|le)$";
      public const string ConnectorAndRegex = @"\b(et\s*(le|las?)?)\b";
      public const string FromRegex = @"((de|du)?)$";
      public const string FromRegex2 = @"((depuis|de)(\s*las?)?)$";
      public const string FromToRegex = @"\b(du|depuis|des?).+(au|à|a)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(le\s+)?(may|march)$";
      public const string UnspecificDatePeriodRegex = @"^(semaine|mois|an(n[eé]e)?)$";
      public const string PrepositionSuffixRegex = @"\b(du|de|[àa]|vers|dans)$";
      public const string FlexibleDayRegex = @"(?<DayOfMonth>([A-Za-z]+\s)?[A-Za-z\d]+)";
      public static readonly string ForTheRegex = $@"\b(((pour le {FlexibleDayRegex})|(dans (le\s+)?{FlexibleDayRegex}(?<=(st|nd|rd|th))))(?<end>\s*(,|\.|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b({WeekDayRegex}\s+(le\s+{FlexibleDayRegex})|le\s+(?<DayOfMonth>{DayRegex}|{WrittenDayRegex})\s+{WeekDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+(?!(the)){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"\b(reste|fin)\s+(d[eu]\s+)?((le|ce(tte)?)\s+)?(?<duration>semaine|mois|l'ann[ée]e)\b";
      public const string RestOfDateTimeRegex = @"\b(reste|fin)\s+(d[eu]\s+)?((le|ce(tte)?)\s+)?(?<unit>jour)\b";
      public const string LaterEarlyPeriodRegex = @"^\b$";
      public const string WeekWithWeekDayRangeRegex = @"^\b$";
      public const string GeneralEndingRegex = @"^\b$";
      public const string MiddlePauseRegex = @"^\b$";
      public const string DurationConnectorRegex = @"^\b$";
      public const string PrefixArticleRegex = @"^[\.]";
      public const string OrRegex = @"^\b$";
      public const string YearPlusNumberRegex = @"^\b$";
      public const string NumberAsTimeRegex = @"^\b$";
      public const string TimeBeforeAfterRegex = @"^\b$";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>\s+[aà])\s*$";
      public static readonly string DecadeWithCenturyRegex = $@"(les\s+)?(années)\s+{DecadeWithCenturyInnerRegex}";
      public const string RelativeDecadeRegex = @"^\b$";
      public static readonly string YearSuffix = $@"(,?(\s*à)?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public const string SuffixAfterRegex = @"^\b$";
      public static readonly string YearPeriodRegex = $@"((((du|depuis|des?)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((entre)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public const string FutureSuffixRegex = @"\b(dans\s+le\s+futur)\b";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string ComplexDatePeriodRegex = @"^\b$";
      public const string AmbiguousPointRangeRegex = @"^(mar\.?)$";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"annees", @"Y" },
            { @"annee", @"Y" },
            { @"an", @"Y" },
            { @"ans", @"Y" },
            { @"mois", @"MON" },
            { @"semaines", @"W" },
            { @"semaine", @"W" },
            { @"journees", @"D" },
            { @"journee", @"D" },
            { @"jour", @"D" },
            { @"jours", @"D" },
            { @"heures", @"H" },
            { @"heure", @"H" },
            { @"hrs", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minutes", @"M" },
            { @"minute", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"secondes", @"S" },
            { @"seconde", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"annees", 31536000 },
            { @"annee", 31536000 },
            { @"l'annees", 31536000 },
            { @"l'annee", 31536000 },
            { @"an", 31536000 },
            { @"ans", 31536000 },
            { @"mois", 2592000 },
            { @"semaines", 604800 },
            { @"semaine", 604800 },
            { @"journees", 86400 },
            { @"journee", 86400 },
            { @"jour", 86400 },
            { @"jours", 86400 },
            { @"heures", 3600 },
            { @"heure", 3600 },
            { @"hrs", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minutes", 60 },
            { @"minute", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"secondes", 1 },
            { @"seconde", 1 },
            { @"secs", 1 },
            { @"sec", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"", @"" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"printemps", @"SP" },
            { @"été", @"SU" },
            { @"automne", @"FA" },
            { @"hiver", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"premier", 1 },
            { @"1er", 1 },
            { @"deuxième", 2 },
            { @"2e", 2 },
            { @"troisième", 3 },
            { @"troisieme", 3 },
            { @"3e", 3 },
            { @"quatrième", 4 },
            { @"4e", 4 },
            { @"cinqième", 5 },
            { @"5e", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"lundi", 1 },
            { @"mardi", 2 },
            { @"mercredi", 3 },
            { @"jeudi", 4 },
            { @"vendredi", 5 },
            { @"samedi", 6 },
            { @"dimanche", 0 },
            { @"lun", 1 },
            { @"mar", 2 },
            { @"mer", 3 },
            { @"jeu", 4 },
            { @"ven", 5 },
            { @"sam", 6 },
            { @"dim", 0 },
            { @"lun.", 1 },
            { @"mar.", 2 },
            { @"mer.", 3 },
            { @"jeu.", 4 },
            { @"ven.", 5 },
            { @"sam.", 6 },
            { @"dim.", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"janvier", 1 },
            { @"fevrier", 2 },
            { @"février", 2 },
            { @"mars", 3 },
            { @"mar", 3 },
            { @"mar.", 3 },
            { @"avril", 4 },
            { @"avr", 4 },
            { @"avr.", 4 },
            { @"mai", 5 },
            { @"juin", 6 },
            { @"jun", 6 },
            { @"jun.", 6 },
            { @"juillet", 7 },
            { @"aout", 8 },
            { @"août", 8 },
            { @"septembre", 9 },
            { @"octobre", 10 },
            { @"novembre", 11 },
            { @"decembre", 12 },
            { @"décembre", 12 },
            { @"janv", 1 },
            { @"janv.", 1 },
            { @"jan", 1 },
            { @"jan.", 1 },
            { @"fevr", 2 },
            { @"fevr.", 2 },
            { @"févr.", 2 },
            { @"févr", 2 },
            { @"fev", 2 },
            { @"fev.", 2 },
            { @"juil", 7 },
            { @"jul", 7 },
            { @"jul.", 7 },
            { @"sep", 9 },
            { @"sep.", 9 },
            { @"sept.", 9 },
            { @"sept", 9 },
            { @"oct", 10 },
            { @"oct.", 10 },
            { @"nov", 11 },
            { @"nov.", 11 },
            { @"dec", 12 },
            { @"dec.", 12 },
            { @"déc.", 12 },
            { @"déc", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"zero", 0 },
            { @"un", 1 },
            { @"une", 1 },
            { @"a", 1 },
            { @"deux", 2 },
            { @"trois", 3 },
            { @"quatre", 4 },
            { @"cinq", 5 },
            { @"six", 6 },
            { @"sept", 7 },
            { @"huit", 8 },
            { @"neuf", 9 },
            { @"dix", 10 },
            { @"onze", 11 },
            { @"douze", 12 },
            { @"treize", 13 },
            { @"quatorze", 14 },
            { @"quinze", 15 },
            { @"seize", 16 },
            { @"dix-sept", 17 },
            { @"dix-huit", 18 },
            { @"dix-neuf", 19 },
            { @"vingt-et-un", 21 },
            { @"vingt et un", 21 },
            { @"vingt", 20 },
            { @"vingt deux", 22 },
            { @"vingt-deux", 22 },
            { @"vingt trois", 23 },
            { @"vingt-trois", 23 },
            { @"vingt quatre", 24 },
            { @"vingt-quatre", 24 },
            { @"vingt cinq", 25 },
            { @"vingt-cinq", 25 },
            { @"vingt six", 26 },
            { @"vingt-six", 26 },
            { @"vingt sept", 27 },
            { @"vingt-sept", 27 },
            { @"vingt huit", 28 },
            { @"vingt-huit", 28 },
            { @"vingt neuf", 29 },
            { @"vingt-neuf", 29 },
            { @"trente", 30 },
            { @"trente et un", 31 },
            { @"trente-et-un", 31 },
            { @"trente deux", 32 },
            { @"trente-deux", 32 },
            { @"trente trois", 33 },
            { @"trente-trois", 33 },
            { @"trente quatre", 34 },
            { @"trente-quatre", 34 },
            { @"trente cinq", 35 },
            { @"trente-cinq", 35 },
            { @"trente six", 36 },
            { @"trente-six", 36 },
            { @"trente sept", 37 },
            { @"trente-sept", 37 },
            { @"trente huit", 38 },
            { @"trente-huit", 38 },
            { @"trente neuf", 39 },
            { @"trente-neuf", 39 },
            { @"quarante", 40 },
            { @"quarante et un", 41 },
            { @"quarante-et-un", 41 },
            { @"quarante deux", 42 },
            { @"quarante-duex", 42 },
            { @"quarante trois", 43 },
            { @"quarante-trois", 43 },
            { @"quarante quatre", 44 },
            { @"quarante-quatre", 44 },
            { @"quarante cinq", 45 },
            { @"quarante-cinq", 45 },
            { @"quarante six", 46 },
            { @"quarante-six", 46 },
            { @"quarante sept", 47 },
            { @"quarante-sept", 47 },
            { @"quarante huit", 48 },
            { @"quarante-huit", 48 },
            { @"quarante neuf", 49 },
            { @"quarante-neuf", 49 },
            { @"cinquante", 50 },
            { @"cinquante et un", 51 },
            { @"cinquante-et-un", 51 },
            { @"cinquante deux", 52 },
            { @"cinquante-deux", 52 },
            { @"cinquante trois", 53 },
            { @"cinquante-trois", 53 },
            { @"cinquante quatre", 54 },
            { @"cinquante-quatre", 54 },
            { @"cinquante cinq", 55 },
            { @"cinquante-cinq", 55 },
            { @"cinquante six", 56 },
            { @"cinquante-six", 56 },
            { @"cinquante sept", 57 },
            { @"cinquante-sept", 57 },
            { @"cinquante huit", 58 },
            { @"cinquante-huit", 58 },
            { @"cinquante neuf", 59 },
            { @"cinquante-neuf", 59 },
            { @"soixante", 60 },
            { @"soixante et un", 61 },
            { @"soixante-et-un", 61 },
            { @"soixante deux", 62 },
            { @"soixante-deux", 62 },
            { @"soixante trois", 63 },
            { @"soixante-trois", 63 },
            { @"soixante quatre", 64 },
            { @"soixante-quatre", 64 },
            { @"soixante cinq", 65 },
            { @"soixante-cinq", 65 },
            { @"soixante six", 66 },
            { @"soixante-six", 66 },
            { @"soixante sept", 67 },
            { @"soixante-sept", 67 },
            { @"soixante huit", 68 },
            { @"soixante-huit", 68 },
            { @"soixante neuf", 69 },
            { @"soixante-neuf", 69 },
            { @"soixante dix", 70 },
            { @"soixante-dix", 70 },
            { @"soixante et onze", 71 },
            { @"soixante-et-onze", 71 },
            { @"soixante douze", 72 },
            { @"soixante-douze", 72 },
            { @"soixante treize", 73 },
            { @"soixante-treize", 73 },
            { @"soixante quatorze", 74 },
            { @"soixante-quatorze", 74 },
            { @"soixante quinze", 75 },
            { @"soixante-quinze", 75 },
            { @"soixante seize", 76 },
            { @"soixante-seize", 76 },
            { @"soixante dix sept", 77 },
            { @"soixante-dix-sept", 77 },
            { @"soixante dix huit", 78 },
            { @"soixante-dix-huit", 78 },
            { @"soixante dix neuf", 79 },
            { @"soixante-dix-neuf", 79 },
            { @"quatre vingt", 80 },
            { @"quatre-vingt", 80 },
            { @"quatre vingt un", 81 },
            { @"quatre-vingt-un", 81 },
            { @"quatre vingt deux", 82 },
            { @"quatre-vingt-duex", 82 },
            { @"quatre vingt trois", 83 },
            { @"quatre-vingt-trois", 83 },
            { @"quatre vingt quatre", 84 },
            { @"quatre-vingt-quatre", 84 },
            { @"quatre vingt cinq", 85 },
            { @"quatre-vingt-cinq", 85 },
            { @"quatre vingt six", 86 },
            { @"quatre-vingt-six", 86 },
            { @"quatre vingt sept", 87 },
            { @"quatre-vingt-sept", 87 },
            { @"quatre vingt huit", 88 },
            { @"quatre-vingt-huit", 88 },
            { @"quatre vingt neuf", 89 },
            { @"quatre-vingt-neuf", 89 },
            { @"quatre vingt dix", 90 },
            { @"quatre-vingt-dix", 90 },
            { @"quatre vingt onze", 91 },
            { @"quatre-vingt-onze", 91 },
            { @"quatre vingt douze", 92 },
            { @"quatre-vingt-douze", 92 },
            { @"quatre vingt treize", 93 },
            { @"quatre-vingt-treize", 93 },
            { @"quatre vingt quatorze", 94 },
            { @"quatre-vingt-quatorze", 94 },
            { @"quatre vingt quinze", 95 },
            { @"quatre-vingt-quinze", 95 },
            { @"quatre vingt seize", 96 },
            { @"quatre-vingt-seize", 96 },
            { @"quatre vingt dix sept", 97 },
            { @"quatre-vingt-dix-sept", 97 },
            { @"quatre vingt dix huit", 98 },
            { @"quatre-vingt-dix-huit", 98 },
            { @"quatre vingt dix neuf", 99 },
            { @"quatre-vingt-dix-neuf", 99 },
            { @"cent", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1er", 1 },
            { @"2e", 2 },
            { @"3e", 3 },
            { @"4e", 4 },
            { @"5e", 5 },
            { @"6e", 6 },
            { @"7e", 7 },
            { @"8e", 8 },
            { @"9e", 9 },
            { @"10e", 10 },
            { @"11e", 11 },
            { @"12e", 12 },
            { @"13e", 13 },
            { @"14e", 14 },
            { @"15e", 15 },
            { @"16e", 16 },
            { @"17e", 17 },
            { @"18e", 18 },
            { @"19e", 19 },
            { @"20e", 20 },
            { @"21e", 21 },
            { @"22e", 22 },
            { @"23e", 23 },
            { @"24e", 24 },
            { @"25e", 25 },
            { @"26e", 26 },
            { @"27e", 27 },
            { @"28e", 28 },
            { @"29e", 29 },
            { @"30e", 30 },
            { @"31e", 31 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"demi", 0.5 },
            { @"quart", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"fathers", new string[] { @"peres", @"pères", @"fêtedespères", @"fetedesperes" } },
            { @"mothers", new string[] { @"fêtedesmères", @"fetedesmeres" } },
            { @"thanksgiving", new string[] { @"lactiondegrace", @"lactiondegrâce", @"jourdethanksgiving", @"thanksgiving" } },
            { @"martinlutherking", new string[] { @"journeemartinlutherking", @"martinlutherkingjr" } },
            { @"washingtonsbirthday", new string[] { @"washingtonsbirthday", @"washingtonbirthday" } },
            { @"canberra", new string[] { @"canberraday" } },
            { @"labour", new string[] { @"fetedetravail", @"travail", @"fetedutravail" } },
            { @"columbus", new string[] { @"columbusday" } },
            { @"memorial", new string[] { @"jourcommémoratif", @"jourcommemoratif" } },
            { @"yuandan", new string[] { @"yuandan", @"nouvelanchinois" } },
            { @"maosbirthday", new string[] { @"maosbirthday" } },
            { @"teachersday", new string[] { @"teachersday", @"teacherday" } },
            { @"singleday", new string[] { @"singleday" } },
            { @"allsaintsday", new string[] { @"allsaintsday" } },
            { @"youthday", new string[] { @"youthday" } },
            { @"childrenday", new string[] { @"childrenday", @"childday" } },
            { @"femaleday", new string[] { @"femaleday" } },
            { @"treeplantingday", new string[] { @"treeplantingday" } },
            { @"arborday", new string[] { @"arborday" } },
            { @"girlsday", new string[] { @"girlsday" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"loverday" } },
            { @"christmas", new string[] { @"noel", @"noël" } },
            { @"xmas", new string[] { @"xmas" } },
            { @"newyear", new string[] { @"nouvellesannees", @"nouvelan" } },
            { @"newyearday", new string[] { @"jourdunouvelan" } },
            { @"newyearsday", new string[] { @"jourdel'an", @"jourpremierdelannee", @"jourpremierdelannée" } },
            { @"inaugurationday", new string[] { @"jourd'inaugueration", @"inaugueration" } },
            { @"groundhougday", new string[] { @"marmotte" } },
            { @"valentinesday", new string[] { @"lasaint-valentin", @"lasaintvalentin" } },
            { @"stpatrickday", new string[] { @"stpatrickday" } },
            { @"aprilfools", new string[] { @"poissond'avril" } },
            { @"stgeorgeday", new string[] { @"stgeorgeday" } },
            { @"mayday", new string[] { @"premier-mai", @"ler-mai", @"1-mai" } },
            { @"cincodemayoday", new string[] { @"cincodemayo" } },
            { @"baptisteday", new string[] { @"bapteme", @"baptême" } },
            { @"usindependenceday", new string[] { @"l'independanceamericaine", @"lindépendanceaméricaine" } },
            { @"independenceday", new string[] { @"l'indépendance", @"lindependance" } },
            { @"bastilleday", new string[] { @"laprisedelabastille", @"bastille" } },
            { @"halloweenday", new string[] { @"halloween" } },
            { @"allhallowday", new string[] { @"allhallowday" } },
            { @"allsoulsday", new string[] { @"allsoulsday" } },
            { @"guyfawkesday", new string[] { @"guyfawkesday" } },
            { @"veteransday", new string[] { @"veteransday" } },
            { @"christmaseve", new string[] { @"reveillondenoel", @"réveillondenoël", @"veilledenoel", @"veilledenoël" } },
            { @"newyeareve", new string[] { @"réveillondenouvelan", @"reveillondenouvelan", @"lasaint-sylvestre", @"lasaintsylvestre" } }
        };
      public const string NightRegex = @"\b(minuit|nuit)\b";
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"dix", 10 },
            { @"vingt", 20 },
            { @"trente", 30 },
            { @"quarante", 40 },
            { @"cinquante", 50 },
            { @"soixante", 60 },
            { @"soixante-dix", 70 },
            { @"quatre-vingt", 80 },
            { @"quatre-vingt-dix", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"deux mille", 2000 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly string[] DurationDateRestrictions = {  };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"^([eé]t[eé])$", @"(?<!((l\s*['`]\s*)|(cet(te)?|en)\s+))[eé]t[eé]\b" },
            { @"^(mer)$", @"(?<!((le|ce)\s+))mer\b" },
            { @"^(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)$", @"([$%£&!?@#])(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)|(avr|ao[uû]t|d[eé]c|f[eé]vr?|janv?|jui?[ln]|mars?|mai|nov|oct|sept?)([$%£&@#])" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly Dictionary<string, string> AmbiguityTimeFiltersDict = new Dictionary<string, string>
        {
            { @"heures?$", @"\b(pour|durée\s+de|pendant)\s+(\S+\s+){1,2}heures?\b" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"matinee",
            @"matin",
            @"matinée"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"apres-midi",
            @"apres midi",
            @"après midi",
            @"après-midi"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"soir",
            @"soiree",
            @"soirée"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"jour",
            @"journee",
            @"journée"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"nuit"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"aujourd'hui",
            @"auj"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"demain",
            @"a2m1",
            @"lendemain",
            @"jour suivant"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"hier",
            @"dernier"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"après demain",
            @"après-demain",
            @"apres-demain"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"avant-hier",
            @"avant hier"
        };
      public static readonly IList<string> FutureStartTerms = new List<string>
        {
            @"cette"
        };
      public static readonly IList<string> FutureEndTerms = new List<string>
        {
            @"prochaine",
            @"prochain"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"dernières",
            @"dernière",
            @"dernieres",
            @"derniere",
            @"dernier"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"mois"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"mois à ce jour"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"fin de semaine",
            @"le weekend"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"semaine"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"années",
            @"ans",
            @"an",
            @"l'annees",
            @"l'annee"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"année à ce jour",
            @"an à ce jour"
        };
    }
}