﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\English\English-DateTime.yaml
//     - Language: English
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.English
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Eng";
      public const bool CheckBothBeforeAfter = false;
      public static readonly string TillRegex = $@"(?<till>\b(to|(un)?till?|thru|through)\b(\s+the\b)?|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string RangeConnectorRegex = $@"(?<and>\b(and|through|to)\b(\s+the\b)?|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string LastNegPrefix = @"(?<!(w(ill|ould|on\s*'\s*t)|m(ay|ight|ust)|sh(all|ould(n\s*'\s*t)?)|c(an(\s*'\s*t|not)?|ould(n\s*'\s*t)?))(\s+not)?\s+)";
      public static readonly string RelativeRegex = $@"\b(?<order>following|next|(up)?coming|this|{LastNegPrefix}last|past|previous|current|the)\b";
      public static readonly string StrictRelativeRegex = $@"\b(?<order>following|next|(up)?coming|this|{LastNegPrefix}last|past|previous|current)\b";
      public const string UpcomingPrefixRegex = @"((this\s+)?((up)?coming))";
      public static readonly string NextPrefixRegex = $@"\b(following|next|{UpcomingPrefixRegex})\b";
      public const string AfterNextSuffixRegex = @"\b(after\s+(the\s+)?next)\b";
      public const string PastPrefixRegex = @"((this\s+)?past)\b";
      public static readonly string PreviousPrefixRegex = $@"({LastNegPrefix}last|previous|{PastPrefixRegex})\b";
      public const string ThisPrefixRegex = @"(this|current)\b";
      public const string RangePrefixRegex = @"(from|between)";
      public const string CenturySuffixRegex = @"(^century)\b";
      public const string ReferencePrefixRegex = @"(that|same)\b";
      public const string FutureSuffixRegex = @"\b((in\s+the\s+)?future|hence)\b";
      public const string PastSuffixRegex = @"\b((in\s+the\s+)past)\b";
      public const string DayRegex = @"(the\s*)?(?<!(\d:|\$)\s*|\d)(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:th|nd|rd|st)?)(?=\b|t)";
      public const string ImplicitDayRegex = @"(the\s*)?(?<day>(?:3[0-1]|[0-2]?\d)(?:th|nd|rd|st))\b";
      public const string MonthNumRegex = @"(?<month>1[0-2]|(0)?[1-9])\b";
      public const string WrittenOneToNineRegex = @"(?:one|two|three|four|five|six|seven|eight|nine)";
      public const string WrittenElevenToNineteenRegex = @"(?:eleven|twelve|(?:thir|four|fif|six|seven|eigh|nine)teen)";
      public const string WrittenTensRegex = @"(?:ten|twenty|thirty|fou?rty|fifty|sixty|seventy|eighty|ninety)";
      public static readonly string WrittenNumRegex = $@"(?:{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?)";
      public const string WrittenOneToNineOrdinalRegex = @"(?:first|second|third|fourth|fifth|sixth|seventh|eighth|nine?th)";
      public const string WrittenTensOrdinalRegex = @"(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth|fortieth|fiftieth|sixtieth|seventieth|eightieth|ninetieth)";
      public static readonly string WrittenOrdinalRegex = $@"(?:{WrittenOneToNineOrdinalRegex}|{WrittenTensOrdinalRegex}|{WrittenTensRegex}\s+{WrittenOneToNineOrdinalRegex})";
      public static readonly string WrittenOrdinalDayRegex = $@"\b(the\s+)?(?<day>(?<ordinal>{WrittenOneToNineOrdinalRegex}|(?:tenth|eleventh|twelfth|thirteenth|fourteenth|fifteenth|sixteenth|seventeenth|eighteenth|nineteenth|twentieth|thirtieth)|(?:ten|twenty)\s+{WrittenOneToNineOrdinalRegex}|thirty\s+first))\b";
      public static readonly string WrittenCenturyFullYearRegex = $@"(?:(one|two)\s+thousand((\s+and)?\s+{WrittenOneToNineRegex}\s+hundred)?)";
      public const string WrittenCenturyOrdinalYearRegex = @"(?:twenty(\s+(one|two))?|ten|eleven|twelve|thirteen|fifteen|eighteen|(?:four|six|seven|nine)(teen)?|one|two|three|five|eight)";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\s+hundred)?)\b";
      public static readonly string LastTwoYearNumRegex = $@"(?:(zero\s+)?{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?)";
      public static readonly string FullTextYearRegex = $@"\b((?<firsttwoyearnum>{CenturyRegex})(\s+and)?\s+(?<lasttwoyearnum>{LastTwoYearNumRegex})\b|\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\s+hundred))\b";
      public const string OclockRegex = @"(?<oclock>o\s*((’|‘|')\s*)?clock|sharp)";
      public const string SpecialDescRegex = @"((?<ipm>)p\b)";
      public const string TasksModeSpecialDescRegex = @"([0-9]+((?<ipm>)p\b))";
      public static readonly string AmDescRegex = $@"(?:{BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"(:?{BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"(:?{BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(:?(:?({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex})))|{OclockRegex})";
      public const string OfPrepositionRegex = @"(\bof\b)";
      public static readonly string TwoDigitYearRegex = $@"\b(?<![$])(?<year>([0-9]\d))(?!(\s*((\:\d)|{AmDescRegex}|{PmDescRegex}|\.\d)))\b";
      public static readonly string YearRegex = $@"(?:{BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"\b(?<weekday>(?:sun|mon|tues?|thurs?|fri)(day)?|thu|wedn(esday)?|weds?|sat(urday)?)s?\b";
      public const string SingleWeekDayRegex = @"\b(?<weekday>(?<!(easter|palm)\s+)sunday|(?<!easter\s+)saturday|(?<!(easter|cyber)\s+)monday|mon|(?<!black\s+)friday|fri|(?:tues?|thurs?)(day)?|thu|wedn(esday)?|weds?|((?<=on\s+)(sat|sun)))\b";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>((day\s+)?of\s+)?{RelativeRegex}\s+month)\b";
      public const string MonthRegexNoWordBoundary = @"(?<month>apr(il)?|aug(ust)?|dec(ember)?|feb(ruary)?|jan(uary)?|july?|june?|mar(ch)?|may|nov(ember)?|oct(ober)?|sept(ember)?|sep)(?!\p{L})";
      public static readonly string MonthRegex = $@"\b{MonthRegexNoWordBoundary}";
      public static readonly string WrittenMonthRegex = $@"(((the\s+)?month of\s+)?{MonthRegex})";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>(?:(in|of|on)\s+)?({RelativeMonthRegex}|{WrittenMonthRegex}))";
      public const string DateUnitRegex = @"(?<unit>(decade|year|(?<uoy>month|week|fortnight)|(?<business>(business\s+|week\s*))?(?<uoy>day)|fortnight|weekend)(?<plural>s)?|(?<=(^|\s)\d{1,4})[ymwd])\b";
      public const string DateTokenPrefix = @"on ";
      public const string TimeTokenPrefix = @"at ";
      public const string TokenBeforeDate = @"on ";
      public const string TokenBeforeTime = @"at ";
      public const string HalfTokenRegex = @"^(half)";
      public const string QuarterTokenRegex = @"^((a\s+)?quarter)";
      public const string ThreeQuarterTokenRegex = @"^(three\s+quarters?)";
      public const string ToTokenRegex = @"\b(to)$";
      public const string FromRegex = @"\b(from(\s+the)?)$";
      public const string BetweenTokenRegex = @"\b(between(\s+the)?)$";
      public static readonly string SimpleCasesRegex = $@"\b({RangePrefixRegex}\s+)?({DayRegex}|{WrittenOrdinalDayRegex})\s*{TillRegex}\s*(({DayRegex}|{WrittenOrdinalDayRegex})\s+{MonthSuffixRegex}|{MonthSuffixRegex}\s+({DayRegex}|{WrittenOrdinalDayRegex}))((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b({RangePrefixRegex}\s+)?{MonthSuffixRegex}\s+((from)\s+)?({DayRegex}|{WrittenOrdinalDayRegex})\s*{TillRegex}\s*({DayRegex}|{WrittenOrdinalDayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+(between\s+)({DayRegex}|{WrittenOrdinalDayRegex})\s*{RangeConnectorRegex}\s*({DayRegex}|{WrittenOrdinalDayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string BetweenRegex = $@"\b(between\s+)({DayRegex}|{WrittenOrdinalDayRegex})\s*{RangeConnectorRegex}\s*({DayRegex}|{WrittenOrdinalDayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthWithYear = $@"\b((({WrittenMonthRegex}[\.]?|((the\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|sixth|6th|seventh|7th|eighth|8th|ninth|9th|tenth|10th|eleventh|11th|twelfth|12th|last)\s+month(?=\s+(of|in))))((\s*)[/\\\-\.,]?(\s+(of|in))?(\s*)({YearRegex}|{TwoDigitYearRegex}|(?<order>following|next|last|this)\s+year)|\s+(of|in)\s+{TwoDigitYearRegex}))|(({YearRegex}|(?<order>following|next|last|this)\s+year)(\s*),?(\s*){WrittenMonthRegex}))\b";
      public const string SpecialYearPrefixes = @"(calendar|(?<special>fiscal|school))";
      public static readonly string OneWordPeriodRegex = $@"\b((((the\s+)?month of\s+)?({StrictRelativeRegex}\s+)?{MonthRegex})|(month|year) to date|(?<toDate>((un)?till?|to)\s+date)|({RelativeRegex}\s+)?(my\s+)?((?<business>working\s+week|workweek)|week(end)?|month|fortnight|(({SpecialYearPrefixes}\s+)?year))(?!((\s+of)?\s+\d+(?!({BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex}))|\s+to\s+date))(\s+{AfterNextSuffixRegex})?)\b";
      public static readonly string MonthNumWithYear = $@"\b(({BaseDateTime.FourDigitYearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-](\s*){BaseDateTime.FourDigitYearRegex}))\b";
      public static readonly string WeekOfMonthRegex = $@"\b(?<wom>(the\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\s+week\s+{MonthSuffixRegex}(\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s+year)?)\b";
      public static readonly string WeekOfYearRegex = $@"\b(?<woy>(the\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\s+week(\s+of)?\s+({YearRegex}|{RelativeRegex}\s+year))\b";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public const string QuarterTermRegex = @"\b(((?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th)[ -]+quarter)|(q(?<number>[1-4])))\b";
      public static readonly string RelativeQuarterTermRegex = $@"\b(?<orderQuarter>{StrictRelativeRegex})\s+((?<num>[\w,]+)\s+)?quarters?\b";
      public static readonly string QuarterRegex = $@"((the\s+)?{QuarterTermRegex}(?:((\s+of)?\s+|\s*[,-]\s*)({YearRegex}|{RelativeRegex}\s+year))?)|{RelativeQuarterTermRegex}";
      public static readonly string QuarterRegexYearFront = $@"(?:{YearRegex}|{RelativeRegex}\s+year)('s)?(?:\s*-\s*|\s+(the\s+)?)?{QuarterTermRegex}";
      public const string HalfYearTermRegex = @"(?<cardinal>first|1st|second|2nd)\s+half";
      public static readonly string HalfYearFrontRegex = $@"(?<year>((1[5-9]|20)\d{{2}})|2100)(\s*-\s*|\s+(the\s+)?)?h(?<number>[1-2])";
      public static readonly string HalfYearBackRegex = $@"(the\s+)?(h(?<number>[1-2])|({HalfYearTermRegex}))(\s+of|\s*,\s*)?\s+({YearRegex})";
      public static readonly string HalfYearRelativeRegex = $@"(the\s+)?{HalfYearTermRegex}(\s+of|\s*,\s*)?\s+({RelativeRegex}\s+year)";
      public static readonly string AllHalfYearRegex = $@"({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})";
      public const string EarlyPrefixRegex = @"\b(?<EarlyPrefix>early|beginning of|start of|(?<RelEarly>earlier(\s+in)?))\b";
      public const string MidPrefixRegex = @"\b(?<MidPrefix>mid-?|middle of)\b";
      public const string LaterPrefixRegex = @"\b(?<LatePrefix>late|end of|(?<RelLate>later(\s+in)?))\b";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public const string PrefixDayRegex = @"\b((?<EarlyPrefix>earl(y|ier))|(?<MidPrefix>mid(dle)?)|(?<LatePrefix>later?))(\s+in)?(\s+the\s+day)?$";
      public const string SeasonDescRegex = @"(?<seas>spring|summer|fall|autumn|winter)";
      public static readonly string SeasonRegex = $@"\b(?<season>({PrefixPeriodRegex}\s+)?({RelativeRegex}\s+)?{SeasonDescRegex}((\s+of|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+year))?)\b";
      public static readonly string WhichWeekRegex = $@"\b(week)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])(\s+of\s+({YearRegex}|{RelativeRegex}\s+year))?\b";
      public const string WeekOfRegex = @"(the\s+)?((week)(\s+(of|(commencing|starting|beginning)(\s+on)?))|w/c)(\s+the)?";
      public const string MonthOfRegex = @"(month)(\s*)(of)";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|(?<!,\s?){TwoDigitYearRegex}|{TwoDigitYearRegex}(?=(\.(?!\d)|[?!;]|$)))";
      public static readonly string YearSuffix = $@"((,|\sof)?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public static readonly string OnRegex = $@"(?<=\bon\s+)({DayRegex}s?)\b";
      public const string RelaxedOnRegex = @"(?<=\b(on|at|in)\s+)((?<day>(3[0-1]|[0-2]?\d)(?:th|nd|rd|st))s?)\b";
      public const string PrefixWeekDayRegex = @"(\s*((,?\s*on)|[-—–]))";
      public static readonly string ThisRegex = $@"\b(this(\s*week{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}((\s+of)?\s+this\s*week))\b";
      public static readonly string LastDateRegex = $@"\b({PreviousPrefixRegex}(\s*week{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|({WeekDayRegex}(\s+(of\s+)?last\s*week))\b";
      public static readonly string NextDateRegex = $@"\b({NextPrefixRegex}(\s*week{PrefixWeekDayRegex}?)?\s*{WeekDayRegex})|((on\s+)?{WeekDayRegex}((\s+of)?\s+(the\s+following|(the\s+)?next)\s*week))\b";
      public static readonly string SpecialDayRegex = $@"\b((the\s+)?day before yesterday|(the\s+)?day after (tomorrow|tmrw?)|the\s+day\s+(before|after)(?!=\s+day)|((the\s+)?({RelativeRegex}|my)\s+day)|yesterday|tomorrow|tmrw?|today|otd|current date)\b";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<number>{WrittenNumRegex})\s+days?\s+from\s+(?<day>yesterday|tomorrow|tmrw?|today|current date))\b";
      public static readonly string RelativeDayRegex = $@"\b(((the\s+)?{RelativeRegex}\s+day))\b";
      public const string SetWeekDayRegex = @"\b(?<prefix>on\s+)?(?<weekday>morning|afternoon|evening|night|(sun|mon|tues|wednes|thurs|fri|satur)day)s\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>(the\s+)?(?<cardinal>first|1st|second|2nd|third|3rd|fourth|4th|fifth|5th|last)\s+(week\s+{MonthSuffixRegex}[\.]?\s+(on\s+)?{WeekDayRegex}|{WeekDayRegex}\s+{MonthSuffixRegex}))";
      public static readonly string RelativeWeekDayRegex = $@"\b({WrittenNumRegex}\s+{WeekDayRegex}\s+(from\s+now|later))\b";
      public static readonly string SpecialDate = $@"(?=\b(on|at)\s+the\s+){DayRegex}\b";
      public const string DatePreposition = @"\b(on|in)";
      public static readonly string DateExtractorYearTermRegex = $@"(\s+|\s*[/\\.,-]\s*|\s+of\s+){DateYearRegex}";
      public static readonly string DayPrefix = $@"\b({WeekDayRegex}|{SpecialDayRegex})\b";
      public static readonly string DateExtractor1 = $@"\b({DayPrefix}\s*[,-]?\s*)?(({MonthRegex}[\.]?\s*[/\\.,-]?\s*{DayRegex})|(\({MonthRegex}\s*[-./]\s*{DayRegex}\)))(?!\s*\-\s*\d{{2}}\b)(\s*\(\s*{DayPrefix}\s*\))?({DateExtractorYearTermRegex}\b)?";
      public static readonly string DateExtractor3 = $@"\b({DayPrefix}(\s+|\s*,\s*))?({DayRegex}?[\.]?(\s+|\s*[-,/]\s*|\s+of\s+|\s*)(\b)?{MonthRegexNoWordBoundary}[\.]?((\s+in)?{DateExtractorYearTermRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[-./]?\s*(the\s+)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:th|nd|rd|st)?)[\.]?(\s+|\s*[-,/]\s*|\s+of\s+){MonthRegex}[\.]?)\b";
      public static readonly string DateExtractor4 = $@"\b{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}[\.]?\s*[/\\\-]\s*{DateYearRegex}";
      public static readonly string DateExtractor5 = $@"\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({DayPrefix}\s+)?{MonthNumRegex}[\-\.]{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor7L = $@"\b({DayPrefix}(\s*,)?\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])\b";
      public static readonly string DateExtractor7S = $@"\b({DayPrefix}(\s*,)?\s+)?{MonthNumRegex}\s*/\s*{DayRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor8 = $@"(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({DayPrefix}\s+)?{DayRegex}[\\\-]{MonthNumRegex}(?![%]){BaseDateTime.CheckDecimalRegex}\b";
      public static readonly string DateExtractor9L = $@"\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{DateExtractorYearTermRegex}(?![%])\b";
      public static readonly string DateExtractor9S = $@"\b({DayPrefix}(\s*,)?\s+)?{DayRegex}\s*/\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?![%])\b";
      public const string DateExtractorNoSep = @"\b((?<![$])(?<year>((1\d|20)\d{2})|2100)(\s+(?<month>1[0-2]|(0)?[1-9])\s+(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))|(?<month>1[0-2]|(0)?[1-9])(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])))\b)";
      public static readonly string DateExtractorA = $@"\b({DayPrefix}(\s*,)?\s+)?(({BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex})|({MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*(the\s+)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9])(?:th|nd|rd|st)?))|({DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})|{DateExtractorNoSep})";
      public static readonly string OfMonth = $@"^(\s*(day\s+)?of)?\s*{MonthRegex}";
      public static readonly string MonthEnd = $@"{MonthRegex}\s*(the)?\s*$";
      public static readonly string WeekDayEnd = $@"(this\s+)?{WeekDayRegex}\s*,?\s*$";
      public static readonly string WeekDayStart = $@"^\s+(on\s+)?{WeekDayRegex}\b";
      public const string RangeUnitRegex = @"\b(?<unit>years?|months?|weeks?|fortnights?)\b";
      public const string HourNumRegex = @"\b(?<hournum>zero|one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve)\b";
      public const string MinuteNumRegex = @"(((?<tens>twenty|thirty|fou?rty|fifty)(\s*-?\s*))?(?<minnum>one|two|three|four|five|six|seven|eight|nine)|(?<minnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))";
      public const string DeltaMinuteNumRegex = @"(((?<tens>twenty|thirty|fou?rty|fifty)(\s*-?\s*))?(?<deltaminnum>one|two|three|four|five|six|seven|eight|nine)|(?<deltaminnum>ten|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)|twenty|thirty|forty|fifty))";
      public const string PmRegex = @"(?<pm>(((?:at|in|around|circa|on|for)\s+(the\s+)?)?(((early|late)\s+)?(afternoon|evening)|midnight|lunchtime))|((at|in|around|on|for)\s+(the\s+)?night))";
      public const string PmRegexFull = @"(?<pm>((?:at|in|around|circa|on|for)\s+(the\s+)?)?(((early|late)\s+)?(afternoon|evening)|(mid)?night|lunchtime))";
      public const string AmRegex = @"(?<am>((?:at|in|around|circa|on|for)\s+(the\s+)?)?((early|late)\s+)?(morning))";
      public const string LunchRegex = @"\blunchtime\b";
      public const string NightRegex = @"\b(mid)?night\b";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public static readonly string LessThanOneHour = $@"(?<lth>(a\s+)?quarter|three quarter(s)?|half( an hour)?|{BaseDateTime.DeltaMinuteRegex}(\s+(minutes?|mins?)|(?=\s+past))|{DeltaMinuteNumRegex}(\s+(minutes?|mins?)|(?=\s+past)))";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>{HourNumRegex}\s+{MinuteNumRegex}(\s+(minutes?|mins?))?)";
      public static readonly string TimePrefix = $@"(?<prefix>{LessThanOneHour}\s+(past|to))";
      public static readonly string TimeSuffix = $@"(?<suffix>{AmRegex}|{PmRegex}|{OclockRegex})";
      public static readonly string TimeSuffixFull = $@"(?<suffix>{AmRegex}|{PmRegexFull}|{OclockRegex})";
      public static readonly string BasicTime = $@"\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}:{BaseDateTime.MinuteRegex}(:{BaseDateTime.SecondRegex})?|{BaseDateTime.HourRegex}(?![%\d]))";
      public const string MidnightRegex = @"(?<midnight>mid\s*(-\s*)?night)";
      public const string MidmorningRegex = @"(?<midmorning>mid\s*(-\s*)?morning)";
      public const string MidafternoonRegex = @"(?<midafternoon>mid\s*(-\s*)?afternoon)";
      public const string MiddayRegex = @"(?<midday>mid\s*(-\s*)?day|((12\s)?noon))";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"\b(?:(?:(?<=\b(at|(at)?\s*around|circa)\s+)(?:{WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\.\d)(\s*((?<iam>a)|(?<ipm>p)))?|{MidTimeRegex}))|{MidTimeRegex})\b";
      public static readonly string IshRegex = $@"\b({BaseDateTime.HourRegex}(-|——)?ish|noon(ish)?)\b";
      public const string TimeUnitRegex = @"([^a-z]{1,}|\b)(?<unit>(h(ou)?r|min(ute)?|sec(ond)?)(?<plural>s)?|h)\b";
      public const string RestrictedTimeUnitRegex = @"(?<unit>hour|minute)\b";
      public const string FivesRegex = @"(?<tens>(?:fifteen|(?:twen|thir|fou?r|fif)ty(\s*five)?|ten|five))\b";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string PeriodHourNumRegex = @"\b(?<hour>twenty(\s+(one|two|three|four))?|eleven|twelve|thirteen|fifteen|eighteen|(four|six|seven|nine)(teen)?|zero|one|two|three|five|eight|ten)\b";
      public static readonly string ConnectNumRegex = $@"\b{BaseDateTime.HourRegex}(?<min>[0-5][0-9])\s*{DescRegex}";
      public static readonly string TimeRegexWithDotConnector = $@"({BaseDateTime.HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex})";
      public static readonly string TimeRegex1 = $@"\b({TimePrefix}\s+)?({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\s*|[.]){DescRegex}";
      public static readonly string TimeRegex2 = $@"(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?:(\s*)?{BaseDateTime.MinuteRegex}((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?(?<iam>a)?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"\b{TimePrefix}\s+{BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex5 = $@"\b{TimePrefix}\s+{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex6 = $@"({BasicTime})(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex7 = $@"\b{TimeSuffixFull}\s+(at\s+)?{BasicTime}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex8 = $@".^";
      public static readonly string TimeRegex9 = $@"\b{PeriodHourNumRegex}(\s+|-){FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"\b({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*h\s*){BaseDateTime.MinuteRegex}(\s*{DescRegex})?";
      public static readonly string TimeRegex11 = $@"\b((?:({TimeTokenPrefix})?{TimeRegexWithDotConnector}(\s*{DescRegex}))|(?:(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\s*per\s*cent|%)))";
      public static readonly string FirstTimeRegexInTimeRange = $@"\b{TimeRegexWithDotConnector}(\s*{DescRegex})?";
      public static readonly string PureNumFromTo = $@"({RangePrefixRegex}\s+)?({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{TillRegex}\s*({HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string PureNumBetweenAnd = $@"(between\s+)(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{RangeConnectorRegex}\s*(({BaseDateTime.TwoDigitHourRegex}{BaseDateTime.TwoDigitMinuteRegex})|{HourRegex}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string SpecificTimeFromTo = $@"({RangePrefixRegex}\s+)?(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{TillRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"(between\s+)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{RangeConnectorRegex}\s*(?<time2>(({TimeRegex2}|{TimeRegexWithDotConnector}(?<rightDesc>\s*{DescRegex}))|({HourRegex}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public const string SuffixAfterRegex = @"\b(((at)\s)?(or|and)\s+(above|after|later|greater)(?!\s+than))\b";
      public const string PrepositionRegex = @"(?<prep>^(,\s*)?(at|on|of)(\s+the)?$)";
      public const string LaterEarlyRegex = @"((?<early>earl(y|ier)(\s+|-))|(?<late>late(r?\s+|-)))";
      public const string MealTimeRegex = @"\b(at\s+)?(?<mealTime>breakfast|brunch|lunch(\s*time)?|dinner(\s*time)?|supper)\b";
      public static readonly string UnspecificTimePeriodRegex = $@"({MealTimeRegex})";
      public static readonly string TimeOfDayRegex = $@"\b(?<timeOfDay>((((in\s+the\s+){LaterEarlyRegex}?(morning|afternoon|night(-?time)?|evening)s)|((in\s+the\s+)?{LaterEarlyRegex}?(in(\s+the)?\s+)?(morning|afternoon|night(-?time)?|evening)))|{MealTimeRegex}|(((in\s+(the)?\s+)?)(daytime|business\s+hours?))))\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b(({StrictRelativeRegex}\s+{TimeOfDayRegex})\b|\b(?<pm>toni(ght|te)))s?\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public static readonly string[] BusinessHourSplitStrings = { @"business", @"hour" };
      public const string NowRegex = @"\b(?<now>(right\s+)?now|as\s+soon\s+as\s+possible|asap|recently|previously|at\s+(present|this\s+time|th(e|is)\s+minute|the\s+(moment|present\s+time)))\b";
      public static readonly string NowParseRegex = $@"\b({NowRegex}|^(date)$)\b";
      public const string SuffixRegex = @"^\s*(in the\s+)?(morning|afternoon|evening|night)\b";
      public const string NonTimeContextTokens = @"(building)";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>morning|(?<pm>afternoon|night|evening))\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})\b|\btoni(ght|te))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?(in\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(at|around|circa|in|on))?\s*$";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"(?<!{NonTimeContextTokens}\s*)\b({HourNumRegex}|{BaseDateTime.HourRegex})\s*(,\s*)?(in\s+)?{DateTimeSpecificTimeOfDayRegex}\b";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"\b{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(at|around|circa))?\s*({HourNumRegex}|{BaseDateTime.HourRegex})\b";
      public const string SpecificEndOfRegex = @"(the\s+)?end of(\s+the)?\s*$";
      public const string UnspecificEndOfRegex = @"\b(the\s+)?(eod|(end\s+of\s+day))\b";
      public const string UnspecificEndOfRangeRegex = @"\b(eoy)\b";
      public static readonly string PeriodTimeOfDayRegex = $@"\b((in\s+(the\s+)?)?{LaterEarlyRegex}?((this\s+)?{DateTimeTimeOfDayRegex}|(?<timeOfDay>(?<pm>tonight))))\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b({LaterEarlyRegex}?this\s+{DateTimeTimeOfDayRegex}|({StrictRelativeRegex}\s+{PeriodTimeOfDayRegex})\b|\b(?<pm>toni(ght|te)))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"\b(({PeriodTimeOfDayRegex}(\s+(on|of))?))\b";
      public static readonly string TasksmodeMealTimeofDayRegex = $@"\b((in\s+(the)?\s+)?((?<early>earl(y|ier)(\s+|-))|(?<late>late(r?\s+|-)))?((this\s+)?\b(?<timeOfDay>lunch(\s*time)?|dinner(\s*time)?|brunch|breakfast)\b))\b";
      public const string LessThanRegex = @"\b(less\s+than)\b";
      public const string MoreThanRegex = @"\b(more\s+than)\b";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|h(ou)?rs?|h|min(ute)?s?|sec(ond)?s?|nights?)\b";
      public const string SuffixAndRegex = @"(?<suffix>\s*(and)\s+(an?\s+)?(?<suffix_num>half|quarter))";
      public const string PeriodicRegex = @"\b(?<periodic>((?<multiplier>semi|bi|tri)(\s*|-))?(daily|monthly|weekly|quarterly|yearly|annual(ly)?))\b";
      public static readonly string EachUnitRegex = $@"\b(?<each>(every|(each|any|once an|one a|once a)\s?)(?<other>\s+(other|alternate|second))?\s*({DurationUnitRegex}|(?<specialUnit>quarters?|weekends?)|{WeekDayRegex})|(?<specialUnit>weekends))";
      public const string EachPrefixRegex = @"\b(?<each>(each|every|once an?)\s*$)";
      public const string SetEachRegex = @"\b(?<each>(each|every)(?<other>\s+(other|alternate))?\s*)(?!the|that)\b";
      public static readonly string SetLastRegex = $@"(?<last>following|next|upcoming|this|{LastNegPrefix}last|past|previous|current)";
      public const string EachDayRegex = @"\s*((each|every)\s*day)|daily\b";
      public static readonly string DurationFollowedUnit = $@"(^\s*{DurationUnitRegex}\s+{SuffixAndRegex})|(^\s*{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+(\.\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"(\b((?<half>(half)\s+)?an?|another)|(?<half>(1/2|½|half)))\s+{DurationUnitRegex}";
      public const string DuringRegex = @"\b(for|during)\s+the\s+(?<unit>year|month|week|day|fortnight)\b";
      public const string AllRegex = @"\b(?<all>(all|full|whole)(\s+|-)(?<unit>year|month|week|day|fortnight))\b";
      public const string HalfRegex = @"((an?\s*)|\b)(?<half>half\s+(?<unit>year|month|week|fortnight|day|hour))\b";
      public const string ConjunctionRegex = @"\b((and(\s+for)?)|with)\b";
      public const string HolidayList1 = @"(?<holiday>mardi gras|(washington|mao)'s birthday|juneteenth|(jubilee|freedom)(\s+day)|chinese new year|(new\s+(years'|year\s*'s|years?)\s+eve)|(new\s+(years'|year\s*'s|years?)(\s+day)?)|may\s*day|yuan dan|christmas eve|(christmas|xmas)(\s+day)?|black friday|yuandan|easter(\s+(sunday|saturday|monday))?|clean monday|ash wednesday|palm sunday|maundy thursday|good friday|white\s+(sunday|monday)|trinity sunday|pentecost|corpus christi|cyber monday)";
      public const string HolidayList2 = @"(?<holiday>(thanks\s*giving|all saint's|white lover|s(?:ain)?t?(\.)?\s+(?:patrick|george)(?:')?(?:s)?|us independence|all hallow|all souls|guy fawkes|cinco de mayo|halloween|qingming|dragon boat|april fools|tomb\s*sweeping)(\s+day)?)";
      public const string HolidayList3 = @"(?<holiday>(?:independence|presidents(?:')?|mlk|martin luther king( jr)?|canberra|ascension|columbus|tree( planting)?|arbor|labou?r|((international|int'?l)\s+)?workers'?|mother'?s?|father'?s?|female|women('s)?|single|teacher'?s|youth|children|girls|lovers?|earth|inauguration|groundhog|valentine'?s|baptiste|bastille|veterans(?:')?|memorial|mid[ \-]autumn|moon|spring|lantern)\s+day)";
      public const string HolidayList4 = @"(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\s+)adha|eid al(-|\s+)azha|eidul(-|\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\s+)fitr|festival of breaking the fast)";
      public static readonly string HolidayRegex = $@"\b(({StrictRelativeRegex}\s+({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4}))|(?<holidayWeekend>((the\s+)?weekend\s+of\s+)({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})(\s+((of\s+)?({YearRegex}|{RelativeRegex}\s+year)))?)|(({HolidayList1}|{HolidayList2}|{HolidayList3}|{HolidayList4})((?<holidayWeekend>(\s+weekend)(\s+((of\s+)?({YearRegex}|{RelativeRegex}\s+year)))?)|(\s+(of\s+)?({YearRegex}|{RelativeRegex}\s+year)(?<holidayWeekend>\s+weekend)?))?))\b";
      public static readonly string TasksModeHolidayListSupression = $@"(?<holiday>(?:independence|teacher'?s|youth|children|girls)\s+day)|(?<holiday>ramad(h)?an|ram(a)?zan|ramathan|eid al(-|\s+)adha|eid al(-|\s+)azha|eidul(-|\s+)azha|feast of the sacrifice|(islamic|arabic|hijri) new year|eid al(-|\s+)fitr|festival of breaking the fast)\b";
      public const string AMTimeRegex = @"(?<am>morning)";
      public const string PMTimeRegex = @"\b(?<pm>afternoon|evening|night)\b";
      public const string NightTimeRegex = @"(night)";
      public const string NowTimeRegex = @"(now|at\s+(present|this\s+time|th(e|is)\s+minute|the\s+(moment|(current|present)\s+time)))";
      public const string RecentlyTimeRegex = @"(recently|previously)";
      public const string AsapTimeRegex = @"(as soon as possible|asap)";
      public const string InclusiveModPrepositions = @"(?<include>((on|in|at)\s+or\s+)|(\s+or\s+(on|in|at)))";
      public const string AroundRegex = @"(?:\b(?:around|circa)\s*?\b)(\s+the)?";
      public static readonly string BeforeRegex = $@"((\b{InclusiveModPrepositions}?(?:before|in\s+advance\s+of|prior\s+to|(no\s+later|earlier|sooner)\s+than|ending\s+(with|on)|by|(un)?till?|(?<include>as\s+late\s+as)){InclusiveModPrepositions}?\b\s*?)|(?<!\w|>)((?<include><\s*=)|<))(\s+the)?";
      public static readonly string AfterRegex = $@"((\b{InclusiveModPrepositions}?((after(\s+on)?(?!\sfrom)|(?<!no\s+)later\s+than)|((year\s+)?greater\s+than))(?!\s+or\s+equal\s+to){InclusiveModPrepositions}?\b\s*?)|(?<!\w|<)((?<include>>\s*=)|>))(\s+the)?";
      public const string StartingRegex = @"(starting|beginning)(\s+)?(?:from|on|with)?";
      public const string SinceRegex = @"(?:(?:\b(?:since|after\s+or\s+equal\s+to|(starting|beginning)(\s)?(?:from|on|with)?|as\s+early\s+as|(any\s+time\s+)from)\b\s*?)|(?<!\w|<)(>=))(\s+the)?";
      public static readonly string SinceRegexExp = $@"({SinceRegex}|\bfrom(\s+the)?\b)";
      public const string AgoRegex = @"\b(ago|earlier|before\s+(?<day>yesterday|today))\b";
      public static readonly string LaterRegex = $@"\b(?:later(?!((\s+in)?\s*{OneWordPeriodRegex})|(\s+{TimeOfDayRegex})|\s+than\b)|from now|(from|after)\s+(?<day>tomorrow|tmrw?|today))\b";
      public const string BeforeAfterRegex = @"(,?\s*)\b((?<before>before)|(?<after>from|after))\b";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string InConnectorRegex = @"\b(in)\b";
      public static readonly string SinceYearSuffixRegex = $@"(^\s*{SinceRegex}(\s*(the\s+)?year\s*)?{YearSuffix})";
      public static readonly string WithinNextPrefixRegex = $@"\b(within(\s+the)?(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string ForPrefixRegex = @"((?<forfrom>for.*from.*)|(?<from>\bfrom\b)|(?<for>\bfor\b))";
      public const string TodayNowRegex = @"\b(today|now|current (date|time))\b";
      public static readonly string MorningStartEndRegex = $@"(^(morning|{AmDescRegex}))|((morning|{AmDescRegex})$)";
      public static readonly string AfternoonStartEndRegex = $@"(^(afternoon|{PmDescRegex}))|((afternoon|{PmDescRegex})$)";
      public const string EveningStartEndRegex = @"(^(evening))|((evening)$)";
      public const string NightStartEndRegex = @"(^(over|to)?ni(ght|te))|((over|to)?ni(ght|te)$)";
      public const string InexactNumberRegex = @"\b((a\s+)?few|some|several|(?<NumTwoTerm>(a\s+)?couple(\s+of)?))\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"(?:(?:(?:{NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({TimeUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"(?:(?:(?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+(?<duration>week(end)?|fortnight|month|year|decade)\b";
      public const string ConnectorRegex = @"^(-|,|for|t|around|circa|@)$";
      public const string FromToRegex = @"(\b(from).+(to|and|or)\b.+)";
      public const string SingleAmbiguousMonthRegex = @"^(the\s+)?(may|march)$";
      public const string SingleAmbiguousTermsRegex = @"^(the\s+)?(day|week|month|year)$";
      public const string UnspecificDatePeriodRegex = @"^(week|fortnight|month|year)$";
      public const string PrepositionSuffixRegex = @"\b(on|in|at|around|circa|from|to)$";
      public const string FlexibleDayRegex = @"(?<DayOfMonth>([A-Za-z]+\s)?[A-Za-z\d]+)";
      public static readonly string ForTheRegex = $@"\b((((?<=\bfor\s+)the\s+{FlexibleDayRegex})|((?<=\bon\s+)(the\s+)?{FlexibleDayRegex}(?<=(st|nd|rd|th))))(?<end>\s*(,|\.(?!\d)|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex}\s+(the\s+{FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+(?!(the)){DayRegex}(?!([-:]|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"\b(rest|remaining)\s+(of\s+)?((the|my|this|current)\s+)?(?<duration>week|fortnight|month|year|decade)\b";
      public const string RestOfDateTimeRegex = @"\b(rest|remaining)\s+(of\s+)?((the|my|this|current)\s+)?(?<unit>day)\b";
      public const string AmbiguousRangeModifierPrefix = @"(from)";
      public static readonly string NumberEndingPattern = $@"^(?:\s+(?<meeting>meeting|appointment|conference|((skype|teams|zoom|facetime)\s+)?call)\s+to\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})([\.]?$|(\.,|,|!|\?)))";
      public const string OneOnOneRegex = @"\b(1\s*:\s*1(?!\d))|(one (on )?one|one\s*-\s*one|one\s*:\s*one)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b(({PrefixPeriodRegex})\s*\b\s*(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))|({UnspecificEndOfRangeRegex}))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|this)\s+week)((\s+between\s+{WeekDayRegex}\s+and\s+{WeekDayRegex})|(\s+from\s+{WeekDayRegex}\s+to\s+{WeekDayRegex})))\b";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|and|,)\s*$";
      public const string PrefixArticleRegex = @"\bthe\s+";
      public const string OrRegex = @"\s*((\b|,\s*)(or|and)\b|,)\s*";
      public static readonly string SpecialYearTermsRegex = $@"\b((({SpecialYearPrefixes}\s+)?year)|(cy|(?<special>fy|sy)))";
      public static readonly string YearPlusNumberRegex = $@"\b({SpecialYearTermsRegex}\s*((?<year>(\d{{2,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b(((?<=\b(before|no later than|by|after)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>\s+at)\s*$";
      public const string DecadeRegex = @"(?<decade>(?:nough|twen|thir|fou?r|fif|six|seven|eigh|nine)ties|two\s+thousands)";
      public static readonly string DecadeWithCenturyRegex = $@"(the\s+)?(((?<century>\d|1\d|2\d)?(')?(?<decade>\d0)(')?(\s)?s\b)|(({CenturyRegex}(\s+|-)(and\s+)?)?{DecadeRegex})|({CenturyRegex}(\s+|-)(and\s+)?(?<decade>tens|hundreds)))";
      public static readonly string RelativeDecadeRegex = $@"\b((the\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?decades?)\b";
      public static readonly string YearPeriodRegex = $@"((((from|during|in)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((between)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public static readonly string StrictTillRegex = $@"(?<till>\b(to|(un)?till?|thru|through)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public static readonly string StrictRangeConnectorRegex = $@"(?<and>\b(and|through|to)\b|{BaseDateTime.RangeConnectorSymbolRegex}(?!\s*(h[1-2]|q[1-4])(?!(\s+of|\s*,\s*))))";
      public const string StartMiddleEndRegex = @"\b((?<StartOf>((the\s+)?(start|beginning)\s+of\s+)?)(?<MiddleOf>((the\s+)?middle\s+of\s+)?)(?<EndOf>((the\s+)?end\s+of\s+)?))";
      public static readonly string ComplexDatePeriodRegex = $@"(?:((from|during|in)\s+)?{StartMiddleEndRegex}(?<start>.+)\s*({StrictTillRegex})\s*{StartMiddleEndRegex}(?<end>.+)|((between)\s+){StartMiddleEndRegex}(?<start>.+)\s*({StrictRangeConnectorRegex})\s*{StartMiddleEndRegex}(?<end>.+))";
      public static readonly string FailFastRegex = $@"{BaseDateTime.DeltaMinuteRegex}|\b(?:{BaseDateTime.BaseAmDescRegex}|{BaseDateTime.BasePmDescRegex})|{BaseDateTime.BaseAmPmDescRegex}|\b(?:zero|{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}|{WrittenMonthRegex}|{SeasonDescRegex}|{DecadeRegex}|centur(y|ies)|weekends?|quarters?|hal(f|ves)|yesterday|to(morrow|day|night)|tmr|noonish|\d(-|——)?ish|((the\s+\w*)|\d)(th|rd|nd|st)|(mid\s*(-\s*)?)?(night|morning|afternoon|day)s?|evenings?|noon|lunch(time)?|dinner(time)?|(day|night)time|overnight|dawn|dusk|sunset|hours?|hrs?|h|minutes?|mins?|seconds?|secs?|eo[dmy]|mardi[ -]?gras|birthday|eve|christmas|xmas|thanksgiving|halloween|yuandan|easter|yuan dan|april fools|cinco de mayo|all (hallow|souls)|guy fawkes|(st )?patrick|hundreds?|noughties|aughts|thousands?)\b|{WeekDayRegex}|{SetWeekDayRegex}|{NowRegex}|{PeriodicRegex}|\b({DateUnitRegex}|{ImplicitDayRegex})";
      public static readonly string TasksModeSupressionRegexes = $@"({AmPmDescRegex}|{TasksModeSpecialDescRegex}|{TasksModeHolidayListSupression}|{DecadeRegex}|{DecadeWithCenturyRegex}|{QuarterRegex}|{QuarterRegexYearFront}|{AllHalfYearRegex}|{SeasonRegex})";
      public const string TasksModeNextPrefix = @"(?<next>next\s+)";
      public static readonly string TasksModeDurationToDatePatterns = $@"\b({TasksModeNextPrefix}((?<week>week)|(?<month>month)|(?<year>year)))\b";
      public static readonly string TimePeriodFromForRegex = $@"(from\s+)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*for\s+(.*?)\s+({DurationUnitRegex})(\s+(.*?)\s+({DurationUnitRegex}))?";
      public static readonly string TimePeriodForFromRegex = $@"for\s+(.*?)\s+({DurationUnitRegex})(\s+(.*?)\s+({DurationUnitRegex}))?\s+(from\s+)(?<time1>(({TimeRegex2}|{FirstTimeRegexInTimeRange})|({HourRegex}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))";
      public static readonly string TimePeriodWithDurationRegex = $@"({TimePeriodFromForRegex}|{TimePeriodForFromRegex})";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"decades", @"10Y" },
            { @"decade", @"10Y" },
            { @"years", @"Y" },
            { @"year", @"Y" },
            { @"y", @"Y" },
            { @"months", @"MON" },
            { @"month", @"MON" },
            { @"m", @"M" },
            { @"quarters", @"3MON" },
            { @"quarter", @"3MON" },
            { @"semesters", @"6MON" },
            { @"semestres", @"6MON" },
            { @"semester", @"6MON" },
            { @"semestre", @"6MON" },
            { @"weeks", @"W" },
            { @"week", @"W" },
            { @"w", @"W" },
            { @"weekends", @"WE" },
            { @"weekend", @"WE" },
            { @"fortnights", @"2W" },
            { @"fortnight", @"2W" },
            { @"weekdays", @"WD" },
            { @"weekday", @"WD" },
            { @"days", @"D" },
            { @"day", @"D" },
            { @"d", @"D" },
            { @"nights", @"D" },
            { @"night", @"D" },
            { @"hours", @"H" },
            { @"hour", @"H" },
            { @"hrs", @"H" },
            { @"hr", @"H" },
            { @"h", @"H" },
            { @"minutes", @"M" },
            { @"minute", @"M" },
            { @"mins", @"M" },
            { @"min", @"M" },
            { @"seconds", @"S" },
            { @"second", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"decades", 315360000 },
            { @"decade", 315360000 },
            { @"years", 31536000 },
            { @"year", 31536000 },
            { @"y", 31536000 },
            { @"months", 2592000 },
            { @"month", 2592000 },
            { @"m", 2592000 },
            { @"fortnights", 1209600 },
            { @"fortnight", 1209600 },
            { @"weekends", 172800 },
            { @"weekend", 172800 },
            { @"weeks", 604800 },
            { @"week", 604800 },
            { @"w", 604800 },
            { @"days", 86400 },
            { @"day", 86400 },
            { @"d", 86400 },
            { @"nights", 86400 },
            { @"night", 86400 },
            { @"hours", 3600 },
            { @"hour", 3600 },
            { @"hrs", 3600 },
            { @"hr", 3600 },
            { @"h", 3600 },
            { @"minutes", 60 },
            { @"minute", 60 },
            { @"mins", 60 },
            { @"min", 60 },
            { @"seconds", 1 },
            { @"second", 1 },
            { @"secs", 1 },
            { @"sec", 1 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"fiscal", @"FY" },
            { @"school", @"SY" },
            { @"fy", @"FY" },
            { @"sy", @"SY" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"spring", @"SP" },
            { @"summer", @"SU" },
            { @"fall", @"FA" },
            { @"autumn", @"FA" },
            { @"winter", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"first", 1 },
            { @"1st", 1 },
            { @"second", 2 },
            { @"2nd", 2 },
            { @"third", 3 },
            { @"3rd", 3 },
            { @"fourth", 4 },
            { @"4th", 4 },
            { @"fifth", 5 },
            { @"5th", 5 },
            { @"sixth", 6 },
            { @"6th", 6 },
            { @"seventh", 7 },
            { @"7th", 7 },
            { @"eighth", 8 },
            { @"8th", 8 },
            { @"ninth", 9 },
            { @"9th", 9 },
            { @"tenth", 10 },
            { @"10th", 10 },
            { @"eleventh", 11 },
            { @"11th", 11 },
            { @"twelfth", 12 },
            { @"12th", 12 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"january", 1 },
            { @"february", 2 },
            { @"march", 3 },
            { @"april", 4 },
            { @"may", 5 },
            { @"june", 6 },
            { @"july", 7 },
            { @"august", 8 },
            { @"september", 9 },
            { @"october", 10 },
            { @"november", 11 },
            { @"december", 12 },
            { @"jan", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"apr", 4 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"aug", 8 },
            { @"sep", 9 },
            { @"sept", 9 },
            { @"oct", 10 },
            { @"nov", 11 },
            { @"dec", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"zero", 0 },
            { @"one", 1 },
            { @"a", 1 },
            { @"an", 1 },
            { @"two", 2 },
            { @"three", 3 },
            { @"four", 4 },
            { @"five", 5 },
            { @"six", 6 },
            { @"seven", 7 },
            { @"eight", 8 },
            { @"nine", 9 },
            { @"ten", 10 },
            { @"eleven", 11 },
            { @"twelve", 12 },
            { @"thirteen", 13 },
            { @"fourteen", 14 },
            { @"fifteen", 15 },
            { @"sixteen", 16 },
            { @"seventeen", 17 },
            { @"eighteen", 18 },
            { @"nineteen", 19 },
            { @"twenty", 20 },
            { @"twenty one", 21 },
            { @"twenty two", 22 },
            { @"twenty three", 23 },
            { @"twenty four", 24 },
            { @"twenty five", 25 },
            { @"twenty six", 26 },
            { @"twenty seven", 27 },
            { @"twenty eight", 28 },
            { @"twenty nine", 29 },
            { @"thirty", 30 },
            { @"thirty one", 31 },
            { @"thirty two", 32 },
            { @"thirty three", 33 },
            { @"thirty four", 34 },
            { @"thirty five", 35 },
            { @"thirty six", 36 },
            { @"thirty seven", 37 },
            { @"thirty eight", 38 },
            { @"thirty nine", 39 },
            { @"forty", 40 },
            { @"forty one", 41 },
            { @"forty two", 42 },
            { @"forty three", 43 },
            { @"forty four", 44 },
            { @"forty five", 45 },
            { @"forty six", 46 },
            { @"forty seven", 47 },
            { @"forty eight", 48 },
            { @"forty nine", 49 },
            { @"fifty", 50 },
            { @"fifty one", 51 },
            { @"fifty two", 52 },
            { @"fifty three", 53 },
            { @"fifty four", 54 },
            { @"fifty five", 55 },
            { @"fifty six", 56 },
            { @"fifty seven", 57 },
            { @"fifty eight", 58 },
            { @"fifty nine", 59 },
            { @"sixty", 60 },
            { @"sixty one", 61 },
            { @"sixty two", 62 },
            { @"sixty three", 63 },
            { @"sixty four", 64 },
            { @"sixty five", 65 },
            { @"sixty six", 66 },
            { @"sixty seven", 67 },
            { @"sixty eight", 68 },
            { @"sixty nine", 69 },
            { @"seventy", 70 },
            { @"seventy one", 71 },
            { @"seventy two", 72 },
            { @"seventy three", 73 },
            { @"seventy four", 74 },
            { @"seventy five", 75 },
            { @"seventy six", 76 },
            { @"seventy seven", 77 },
            { @"seventy eight", 78 },
            { @"seventy nine", 79 },
            { @"eighty", 80 },
            { @"eighty one", 81 },
            { @"eighty two", 82 },
            { @"eighty three", 83 },
            { @"eighty four", 84 },
            { @"eighty five", 85 },
            { @"eighty six", 86 },
            { @"eighty seven", 87 },
            { @"eighty eight", 88 },
            { @"eighty nine", 89 },
            { @"ninety", 90 },
            { @"ninety one", 91 },
            { @"ninety two", 92 },
            { @"ninety three", 93 },
            { @"ninety four", 94 },
            { @"ninety five", 95 },
            { @"ninety six", 96 },
            { @"ninety seven", 97 },
            { @"ninety eight", 98 },
            { @"ninety nine", 99 },
            { @"one hundred", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1st", 1 },
            { @"1th", 1 },
            { @"2nd", 2 },
            { @"2th", 2 },
            { @"3rd", 3 },
            { @"3th", 3 },
            { @"4th", 4 },
            { @"5th", 5 },
            { @"6th", 6 },
            { @"7th", 7 },
            { @"8th", 8 },
            { @"9th", 9 },
            { @"10th", 10 },
            { @"11th", 11 },
            { @"11st", 11 },
            { @"12th", 12 },
            { @"12nd", 12 },
            { @"13th", 13 },
            { @"13rd", 13 },
            { @"14th", 14 },
            { @"15th", 15 },
            { @"16th", 16 },
            { @"17th", 17 },
            { @"18th", 18 },
            { @"19th", 19 },
            { @"20th", 20 },
            { @"21st", 21 },
            { @"21th", 21 },
            { @"22nd", 22 },
            { @"22th", 22 },
            { @"23rd", 23 },
            { @"23th", 23 },
            { @"24th", 24 },
            { @"25th", 25 },
            { @"26th", 26 },
            { @"27th", 27 },
            { @"28th", 28 },
            { @"29th", 29 },
            { @"30th", 30 },
            { @"31st", 31 },
            { @"01st", 1 },
            { @"01th", 1 },
            { @"02nd", 2 },
            { @"02th", 2 },
            { @"03rd", 3 },
            { @"03th", 3 },
            { @"04th", 4 },
            { @"05th", 5 },
            { @"06th", 6 },
            { @"07th", 7 },
            { @"08th", 8 },
            { @"09th", 9 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"half", 0.5 },
            { @"quarter", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"easterday", new string[] { @"easterday", @"easter", @"eastersunday" } },
            { @"ashwednesday", new string[] { @"ashwednesday" } },
            { @"palmsunday", new string[] { @"palmsunday" } },
            { @"maundythursday", new string[] { @"maundythursday" } },
            { @"goodfriday", new string[] { @"goodfriday" } },
            { @"eastersaturday", new string[] { @"eastersaturday" } },
            { @"eastermonday", new string[] { @"eastermonday" } },
            { @"ascensionday", new string[] { @"ascensionday" } },
            { @"whitesunday", new string[] { @"whitesunday", @"pentecost", @"pentecostday" } },
            { @"whitemonday", new string[] { @"whitemonday" } },
            { @"trinitysunday", new string[] { @"trinitysunday" } },
            { @"corpuschristi", new string[] { @"corpuschristi" } },
            { @"earthday", new string[] { @"earthday" } },
            { @"fathers", new string[] { @"fatherday", @"fathersday" } },
            { @"mothers", new string[] { @"motherday", @"mothersday" } },
            { @"thanksgiving", new string[] { @"thanksgivingday", @"thanksgiving" } },
            { @"blackfriday", new string[] { @"blackfriday" } },
            { @"cybermonday", new string[] { @"cybermonday" } },
            { @"martinlutherking", new string[] { @"mlkday", @"martinlutherkingday", @"martinlutherkingjrday" } },
            { @"washingtonsbirthday", new string[] { @"washingtonsbirthday", @"washingtonbirthday", @"presidentsday" } },
            { @"canberra", new string[] { @"canberraday" } },
            { @"labour", new string[] { @"labourday", @"laborday" } },
            { @"columbus", new string[] { @"columbusday" } },
            { @"memorial", new string[] { @"memorialday" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"maosbirthday", new string[] { @"maosbirthday" } },
            { @"teachersday", new string[] { @"teachersday", @"teacherday" } },
            { @"singleday", new string[] { @"singleday" } },
            { @"allsaintsday", new string[] { @"allsaintsday" } },
            { @"youthday", new string[] { @"youthday" } },
            { @"childrenday", new string[] { @"childrenday", @"childday" } },
            { @"femaleday", new string[] { @"femaleday" } },
            { @"treeplantingday", new string[] { @"treeplantingday" } },
            { @"arborday", new string[] { @"arborday" } },
            { @"girlsday", new string[] { @"girlsday" } },
            { @"whiteloverday", new string[] { @"whiteloverday" } },
            { @"loverday", new string[] { @"loverday", @"loversday" } },
            { @"christmas", new string[] { @"christmasday", @"christmas" } },
            { @"xmas", new string[] { @"xmasday", @"xmas" } },
            { @"newyear", new string[] { @"newyear" } },
            { @"newyearday", new string[] { @"newyearday" } },
            { @"newyearsday", new string[] { @"newyearsday" } },
            { @"inaugurationday", new string[] { @"inaugurationday" } },
            { @"groundhougday", new string[] { @"groundhougday" } },
            { @"valentinesday", new string[] { @"valentinesday" } },
            { @"stpatrickday", new string[] { @"stpatrickday", @"stpatricksday", @"stpatrick" } },
            { @"aprilfools", new string[] { @"aprilfools" } },
            { @"stgeorgeday", new string[] { @"stgeorgeday" } },
            { @"mayday", new string[] { @"mayday", @"intlworkersday", @"internationalworkersday", @"workersday" } },
            { @"cincodemayoday", new string[] { @"cincodemayoday" } },
            { @"baptisteday", new string[] { @"baptisteday" } },
            { @"usindependenceday", new string[] { @"usindependenceday" } },
            { @"independenceday", new string[] { @"independenceday" } },
            { @"bastilleday", new string[] { @"bastilleday" } },
            { @"halloweenday", new string[] { @"halloweenday", @"halloween" } },
            { @"allhallowday", new string[] { @"allhallowday" } },
            { @"allsoulsday", new string[] { @"allsoulsday" } },
            { @"guyfawkesday", new string[] { @"guyfawkesday" } },
            { @"veteransday", new string[] { @"veteransday" } },
            { @"christmaseve", new string[] { @"christmaseve" } },
            { @"newyeareve", new string[] { @"newyearseve", @"newyeareve" } },
            { @"juneteenth", new string[] { @"juneteenth", @"freedomday", @"jubileeday" } },
            { @"ramadan", new string[] { @"ramadan", @"ramazan", @"ramzan", @"ramadhan", @"ramathan" } },
            { @"sacrifice", new string[] { @"eidaladha", @"eidalazha", @"eidulazha", @"feastofthesacrifice" } },
            { @"islamicnewyear", new string[] { @"islamicnewyear", @"hijrinewyear", @"arabicnewyear" } },
            { @"eidalfitr", new string[] { @"eidalfitr", @"festivalofbreakingthefast" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"hundreds", 0 },
            { @"tens", 10 },
            { @"twenties", 20 },
            { @"thirties", 30 },
            { @"forties", 40 },
            { @"fifties", 50 },
            { @"sixties", 60 },
            { @"seventies", 70 },
            { @"eighties", 80 },
            { @"nineties", 90 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"noughties", 2000 },
            { @"aughts", 2000 },
            { @"two thousands", 2000 }
        };
      public const string DefaultLanguageFallback = @"MDY";
      public static readonly IList<string> SuperfluousWordList = new List<string>
        {
            @"preferably",
            @"how about",
            @"maybe",
            @"perhaps",
            @"say",
            @"like"
        };
      public static readonly string[] DurationDateRestrictions = { @"today", @"now", @"current date" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"^(morning|afternoon|evening|night|day)\b", @"\b(good\s+(morning|afternoon|evening|night|day))|(nighty\s+night)\b" },
            { @"\bnow\b", @"\b(^now,)|\b((is|are)\s+now\s+for|for\s+now)\b" },
            { @"\bmay$", @"\b((((!|\.|\?|,|;|)\s+|^)may i)|(i|you|he|she|we|they)\s+may|(may\s+((((also|not|(also not)|well)\s+)?(be|ask|contain|constitute|e-?mail|take|have|result|involve|get|work|reply|differ))|(or may not)))|(?<!(in|during|through)\s+)may,? at (its|h(is|er)|y?our|my))\b" },
            { @"^(a|one) second$", @"\b(?<!an?\s+)(a|one) second (round|time|wave|turn|chance|thought|opinion|cycle|take|meaning|life|job|home|hand|language|display|monitor|stimulus|dose|vaccination|shot|jab)\b" },
            { @"\b(breakfast|brunch|lunch(time)?|dinner(time)?|supper)$", @"(?<!\b(at|before|after|around|circa)\b\s)(breakfast|brunch|lunch|dinner|supper)(?!\s*time)" },
            { @"^\d+m$", @"^\d+m$" },
            { @"^(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)$", @"([$%£&!?@#])(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)|(apr|aug|dec|feb|jan|jul|jun|mar|may|nov|oct|sept?)([$%£&@#])" },
            { @"^(to\s+date)$", @"\b((equals?|up)\s+to\s+date)\b" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly Dictionary<string, string> AmbiguityTimeFiltersDict = new Dictionary<string, string>
        {
            { @"^(\p{L}+|\d{1,2})(\s+(morning|afternoon|evening|night))?$", @"\b(one|two|three|four|five|six|seven|eight|nine|ten|eleven|twelve|\d{1,2})\s+(morning|afternoon|evening|night)\b" }
        };
      public static readonly Dictionary<string, string> AmbiguityDurationFiltersDict = new Dictionary<string, string>
        {
            { @"night$", @"\bnight(\s*|-)(club|light|market|shift|work(er)?)s?\b" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"morning"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"afternoon"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"evening"
        };
      public static readonly IList<string> MealtimeBreakfastTermList = new List<string>
        {
            @"breakfast"
        };
      public static readonly IList<string> MealtimeBrunchTermList = new List<string>
        {
            @"brunch"
        };
      public static readonly IList<string> MealtimeLunchTermList = new List<string>
        {
            @"lunch",
            @"lunchtime"
        };
      public static readonly IList<string> MealtimeDinnerTermList = new List<string>
        {
            @"dinner",
            @"dinnertime",
            @"supper"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"daytime"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"night"
        };
      public static readonly IList<string> NighttimeTermList = new List<string>
        {
            @"nighttime",
            @"night-time"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"today",
            @"current date",
            @"otd"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"tomorrow",
            @"tmr",
            @"tmrw",
            @"day after"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"yesterday",
            @"day before"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"day after tomorrow",
            @"day after tmr",
            @"day after tmrw"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"day before yesterday"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"this",
            @"next"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"last"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"month"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"month to date"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"weekend"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"week"
        };
      public static readonly IList<string> FortnightTerms = new List<string>
        {
            @"fortnight",
            @"fourtenight"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"year"
        };
      public static readonly IList<string> GenericYearTerms = new List<string>
        {
            @"y"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"year to date"
        };
      public const string DoubleMultiplierRegex = @"^(bi)(-|\s)?";
      public const string HalfMultiplierRegex = @"^(semi)(-|\s)?";
      public const string DayTypeRegex = @"((week)?da(il)?ys?)$";
      public const string WeekDayTypeRegex = @"(weekday?)$";
      public const string FortNightRegex = @"(fortnight?)$";
      public const string WeekTypeRegex = @"(week(s|ly)?)$";
      public const string WeekendTypeRegex = @"(weekends?)$";
      public const string MonthTypeRegex = @"(month(s|ly)?)$";
      public const string QuarterTypeRegex = @"(quarter(s|ly)?)$";
      public const string YearTypeRegex = @"((years?|annual)(ly)?)$";
    }
}