//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Dutch\Dutch-Numbers.yaml
//     - Language: Dutch
//     - ClassName: NumbersDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Dutch
{
    using System;
    using System.Collections.Generic;

    public static class NumbersDefinitions
    {
      public const string LangMarker = @"Dut";
      public const bool CompoundNumberLanguage = true;
      public const bool MultiDecimalSeparatorCulture = false;
      public const string DigitsNumberRegex = @"-?(\d+|\d{1,3}(\.\d{3})*)";
      public const string RoundNumberIntegerRegex = @"(honderd|duizend|miljoen|miljard|biljoen)";
      public const string ZeroToNineIntegerRegex = @"(((een)(?!\s+((honderdste|duizendste|miljoenste|miljardste|biljoenste)|(nulde|eende|eerste|tweede|derde|vierde|vijfd(e|en)|zesde|zevende|achtst(e|en)|negende|tiend(e|en)|elfde|twaalfde|dertiende|veertiende|vijftiende|zestiende|zeventiende|achttiende|negentiende|twintigste|dertigste|veertigste|vijftigste|zestigste|zeventigste|tachtigste|negentigste))))|(één|drie|zeven|acht|vier|vijf|nul|negen|twee|zes))";
      public const string TwoToNineIntegerRegex = @"(drie|zeven|acht|vier|vijf|negen|twee|zes)";
      public const string NegativeNumberTermsRegex = @"(?<negTerm>(min|negatief)\s+)";
      public static readonly string NegativeNumberSignRegex = $@"^{NegativeNumberTermsRegex}.*";
      public const string AnIntRegex = @"(een|één)(?=\s)";
      public const string TenToNineteenIntegerRegex = @"(zeventien|dertien|veertien|achttien|negentien|vijftien|zestien|elf|twaalf|tien)";
      public const string TensNumberIntegerRegex = @"(zeventig|twintig|dertig|tachtig|negentig|veertig|vijftig|zestig)";
      public static readonly string SeparaIntRegex = $@"((({TenToNineteenIntegerRegex}|({ZeroToNineIntegerRegex}(en|ën){TensNumberIntegerRegex})|{TensNumberIntegerRegex}|{ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})(\s*{RoundNumberIntegerRegex})*))|{RoundNumberIntegerRegex}|(({AnIntRegex}(\s*{RoundNumberIntegerRegex})+))";
      public static readonly string AllIntRegex = $@"(((({TenToNineteenIntegerRegex}|({ZeroToNineIntegerRegex}(en|ën){TensNumberIntegerRegex})|{TensNumberIntegerRegex}|({ZeroToNineIntegerRegex}|{AnIntRegex}))?(\s*{RoundNumberIntegerRegex}))\s*((en|ën)\s*)?)*{SeparaIntRegex})";
      public const string PlaceHolderPureNumber = @"\b";
      public const string PlaceHolderDefault = @"\D|\b";
      public static readonly Func<string, string> NumbersWithPlaceHolder = (placeholder) => $@"(((?<!\d+\s*)-\s*)|(?<=\b))\d+(?!(\,\d+[a-zA-Z]))(?={placeholder})";
      public static readonly string NumbersWithSuffix = $@"(((?<!\d+\s*)-\s*)|(?<=\b))\d+\s*{BaseNumbers.NumberMultiplierRegex}(?=\b)";
      public static readonly string RoundNumberIntegerRegexWithLocks = $@"(?<=\b)\d+\s*{RoundNumberIntegerRegex}(?=\b)";
      public const string NumbersWithDozenSuffix = @"(((?<!\d+\s*)-\s*)|(?<=\b))\d+\s+dozijn(en)?(?=\b)";
      public static readonly string AllIntRegexWithLocks = $@"((?<=\b){AllIntRegex}(?=\b))";
      public static readonly string AllIntRegexWithDozenSuffixLocks = $@"(?<=\b)(((een\s+)?half\s+dozijn)|({AllIntRegex}\s+dozijn(en)?)|{GrossRegex})(?=\b)";
      public const string RoundNumberOrdinalRegex = @"(honderdste|duizendste|miljoenste|miljardste|biljoenste)";
      public const string BasicOrdinalRegex = @"(nulde|eende|eerste|tweede|derde|vierde|vijfd(e|en)|zesde|zevende|achtst(e|en)|negende|tiend(e|en)|elfde|twaalfde|dertiende|veertiende|vijftiende|zestiende|zeventiende|achttiende|negentiende|twintigste|vijfentwintigste|vijventwintigste|dertigste|veertigste|vijftigste|zestigste|zeventigste|tachtigste|negentigste)";
      public const string RelativeOrdinalRegex = @"(?<relativeOrdinal>volgende|vorige?|huidige|laatste?|(de\s+op\s+één\s+na\s+|de\s+een\s+voor\s+de\s+|die\s+voor\s+de\s+|twee\s+na\s+|voor)laatste)";
      public static readonly string SuffixBasicOrdinalRegex = $@"(((({ZeroToNineIntegerRegex}{RoundNumberIntegerRegex})|({RoundNumberIntegerRegex}{ZeroToNineIntegerRegex})|{TensNumberIntegerRegex}|{ZeroToNineIntegerRegex}|{RoundNumberIntegerRegex})\s*)*((en|ën)\s*)*{BasicOrdinalRegex})";
      public static readonly string SuffixRoundNumberOrdinalRegex = $@"(({AllIntRegex}\s*){RoundNumberOrdinalRegex})";
      public static readonly string AllOrdinalNumberRegex = $@"(?:{SuffixBasicOrdinalRegex}|{SuffixRoundNumberOrdinalRegex})";
      public static readonly string AllOrdinalRegex = $@"(?:{AllOrdinalNumberRegex}|{RelativeOrdinalRegex})";
      public const string OrdinalSuffixRegex = @"(?<=\b)((\d+\s*e)|[18]\s*ste|[092-7]\s*de|([0-9]*1[0-9]\s*de)|([0-9]*[2-9][0-9]\s*ste)|([0-9]*[0]([18]\s*ste|[092-7]\s*de)))(?=\b)";
      public const string OrdinalNumericRegex = @"(?<=\b)(\d{1,3}(\s*.\s*\d{3})*\s*e)(?=\b)";
      public static readonly string OrdinalRoundNumberRegex = $@"(?<!(één|een)\s+){RoundNumberOrdinalRegex}";
      public static readonly string OrdinalDutchRegex = $@"(?<=\b){AllOrdinalRegex}(?=\b)";
      public const string FractionNotationWithSpacesRegex = @"(((?<=\W|^)-\s*)|(?<=\b))\d+\s+\d+[/]\d+(?=(\b[^/]|$))";
      public static readonly string FractionNotationRegex = $@"{BaseNumbers.FractionNotationRegex}";
      public const string FractionUnitsRegex = @"((?<onehalf>anderhalve|anderhalf)|(?<quarter>driekwart)|half|halve|helft|kwart)";
      public const string FractionHalfRegex = @"([eë]nhalf|[eë]nhalve|ëneenhal(f|ve))$";
      public static readonly string[] OneHalfTokens = { @"een", @"half" };
      public static readonly string FractionMultiplierRegex = $@"(?<fracMultiplier>((\s+en\s+)?(anderhalve|anderhalf|driekwart)|\s+en\s+(een|{TwoToNineIntegerRegex})\s+(half|derde|kwart|vierde|vijfd(e|en)|zesde|zevende|achtst(e|en)|negende|tiend(e|en))))";
      public static readonly string RoundMultiplierWithFraction = $@"(?<=(?<!{RoundNumberIntegerRegex}){FractionMultiplierRegex}\s+)?(?<multiplier>(miljoen|miljard|biljoen))(?={FractionMultiplierRegex}?$)";
      public static readonly string RoundMultiplierRegex = $@"\b\s*(van\s+)?({RoundMultiplierWithFraction}|(?<multiplier>(honderd|duizend))$)";
      public static readonly string FractionNounRegex = $@"(?<=\b)(({AllIntRegex}\s+(en\s+)?)?(({AllIntRegex})(\s+|\s*-\s*|\s*/\s*)((({AllOrdinalNumberRegex})|({RoundNumberOrdinalRegex}))n?|halven|vierdes|kwart)|(een\s+(half|kwart)\s+){RoundNumberIntegerRegex}|{FractionUnitsRegex}(\s+{RoundNumberIntegerRegex})?))(?=\b)";
      public static readonly string FractionNounWithArticleRegex = $@"(?<=\b)((({AllIntRegex}|{RoundNumberIntegerRegexWithLocks})\s+(en\s)?)?(een)(\s+|\s*-\s*|\s*/\s*)(({AllOrdinalNumberRegex})|({RoundNumberOrdinalRegex})|({FractionUnitsRegex}))|{AllIntRegex}[eë]n(eenhalf|half|halve|helft|kwart))(?=\b)";
      public static readonly string FractionPrepositionRegex = $@"(?<!{BaseNumbers.CommonCurrencySymbol}\s*)(?<=\b)(?<numerator>({AllIntRegex})|((?<!,)\d+))\s+(op|op\s+de|van\s+de|uit|uit\s+de)\s+(?<denominator>({AllIntRegex})|(\d+)(?!,))(?=\b)";
      public static readonly string FractionPrepositionWithinPercentModeRegex = $@"(?<!{BaseNumbers.CommonCurrencySymbol}\s*)(?<=\b)(?<numerator>({AllIntRegex})|((?<!,)\d+))\s+over\s+(?<denominator>({AllIntRegex})|(\d+)(?!,))(?=\b)";
      public static readonly string AllPointRegex = $@"((\s+{ZeroToNineIntegerRegex})+|(\s+{SeparaIntRegex}))";
      public static readonly string AllFloatRegex = $@"{AllIntRegex}(\s+komma){AllPointRegex}";
      public static readonly string DoubleWithMultiplierRegex = $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+,)))\d+,\d+\s*{BaseNumbers.NumberMultiplierRegex}(?=\b)";
      public const string DoubleExponentialNotationRegex = @"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+,)))(\d+(,\d+)?)e([+-]*[1-9]\d*)(?=\b)";
      public const string DoubleCaretExponentialNotationRegex = @"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+,)))(\d+(,\d+)?)\^([+-]*[1-9]\d*)(?=\b)";
      public static readonly Func<string, string> DoubleDecimalPointRegex = (placeholder) => $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+,)))\d+,\d+(?!(,\d+))(?={placeholder})";
      public static readonly Func<string, string> DoubleWithoutIntegralRegex = (placeholder) => $@"(?<=\s|^)(?<!(\d+)),\d+(?!(,\d+))(?={placeholder})";
      public static readonly string DoubleWithRoundNumber = $@"(((?<!\d+\s*)-\s*)|((?<=\b)(?<!\d+,)))\d+,\d+\s+{RoundNumberIntegerRegex}(?=\b)";
      public static readonly string DoubleAllFloatRegex = $@"((?<=\b){AllFloatRegex}(?=\b))";
      public static readonly string NumberWithSuffixPercentage = $@"(?<!%)({BaseNumbers.NumberReplaceToken})(\s*)(%(?!{BaseNumbers.NumberReplaceToken})|(procent|percentage|percent)\b)";
      public static readonly string FractionNumberWithSuffixPercentage = $@"(({BaseNumbers.FractionNumberReplaceToken})\s+van)";
      public static readonly string NumberWithPrefixPercentage = $@"(percentage van)(\s*)({BaseNumbers.NumberReplaceToken})";
      public static readonly string NumberWithPrepositionPercentage = $@"({BaseNumbers.NumberReplaceToken})\s*(uit|in|van|van\s+de)\s*({BaseNumbers.NumberReplaceToken})";
      public const string TillRegex = @"(tot|--|-|—|——|~)";
      public const string IncludeTillRegex = @"(tot en met)";
      public const string MoreRegex = @"((groter|hoger|meer)((\s+is)?(\s+dan|\s+als))?|boven|over|>)";
      public const string LessRegex = @"((minder|lager|kleiner)(\s+dan|\s+als)?|beneden|onder|<)";
      public const string EqualRegex = @"(gelijk(\s+(aan|tot|als|dan))?|(?<!<|>)=)";
      public static readonly string MoreOrEqualPrefix = $@"((niet\s+{LessRegex})|(tenminste|op zijn minst|minstens))";
      public static readonly string MoreOrEqual = $@"(({MoreRegex}\s+of\s+{EqualRegex})|({EqualRegex}\s+of\s+{MoreRegex})|{MoreOrEqualPrefix}(\s+(of)?\s+{EqualRegex})?|niet\s+{LessRegex}|>\s*=)";
      public const string MoreOrEqualSuffix = @"((en|of)\s+(meer|groter|hoger|grotere)((?!\s+(dan|als))|(\s+(dan|als)(?!(\s*\d+)))))";
      public static readonly string LessOrEqualPrefix = $@"((niet\s+{MoreRegex})|(hooguit|op zijn hoogst|op zijn meest))";
      public static readonly string LessOrEqual = $@"(({LessRegex}\s+of\s+{EqualRegex})|({EqualRegex}\s+of\s+{LessRegex})|maximum|niet\s+{MoreRegex}|<\s*=)";
      public const string LessOrEqualSuffix = @"((en|of)\s+(minder|lager|kleiner)((?!\s+(dan|als))|(\s+(dan|als)(?!(\s*\d+)))))";
      public const string NumberSplitMark = @"(?![,.](?!\d+))";
      public const string MoreRegexNoNumberSucceed = @"((groter|hoger|meer)((?!\s+dan)|\s+(dan(?!(\s*\d+))))|(boven|over)(?!(\s*\d+)))";
      public const string LessRegexNoNumberSucceed = @"((minder|lager|kleiner)((?!\s+dan)|\s+(dan(?!(\s*\d+))))|(beneden|onder)(?!(\s*\d+)))";
      public const string EqualRegexNoNumberSucceed = @"(gelijk((?!\s+(aan|tot))|(\s+(aan|tot)(?!(\s*\d+))))|evenveel(?!(\s*\d+)))";
      public static readonly string OneNumberRangeMoreRegex1 = $@"({MoreOrEqual}|{MoreRegex})\s*(de\s+)?(?<number1>({NumberSplitMark}.)+)";
      public static readonly string OneNumberRangeMoreRegex2 = $@"(?<number1>({NumberSplitMark}.)+)\s*{MoreOrEqualSuffix}";
      public static readonly string OneNumberRangeMoreSeparateRegex = $@"({EqualRegex}\s+(?<number1>({NumberSplitMark}.)+)(\s+of\s+){MoreRegexNoNumberSucceed})|({MoreRegex}\s+(?<number1>({NumberSplitMark}.)+)(\s+of\s+){EqualRegexNoNumberSucceed})";
      public static readonly string OneNumberRangeLessRegex1 = $@"({LessOrEqual}|{LessRegex})\s*(de\s+)?(?<number2>({NumberSplitMark}.)+)";
      public static readonly string OneNumberRangeLessRegex2 = $@"(?<number2>({NumberSplitMark}.)+)\s*{LessOrEqualSuffix}";
      public static readonly string OneNumberRangeLessSeparateRegex = $@"({EqualRegex}\s+(?<number1>({NumberSplitMark}.)+)(\s+of\s+){LessRegexNoNumberSucceed})|({LessRegex}\s+(?<number1>({NumberSplitMark}.)+)(\s+of\s+){EqualRegexNoNumberSucceed})";
      public static readonly string OneNumberRangeEqualRegex = $@"{EqualRegex}\s*(de\s+)?(?<number1>({NumberSplitMark}.)+)";
      public static readonly string TwoNumberRangeRegex1 = $@"tussen\s*(de\s+)?(?<number1>({NumberSplitMark}.)+)\s+en\s+(de\s+)?(?<number2>({NumberSplitMark}.)+)";
      public static readonly string TwoNumberRangeRegex2 = $@"({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})\s*(en|(,\s*)?maar|,)\s*({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})";
      public static readonly string TwoNumberRangeRegex3 = $@"({OneNumberRangeLessRegex1}|{OneNumberRangeLessRegex2})\s*(en|maar|,)\s*({OneNumberRangeMoreRegex1}|{OneNumberRangeMoreRegex2})";
      public static readonly string TwoNumberRangeRegex4 = $@"(van\s+)?(?<number1>({AllIntRegex}|{AllFloatRegex}|{AllOrdinalRegex}|{DigitsNumberRegex}))\s*{TillRegex}\s*(de\s+)?(?<number2>({AllIntRegex}|{AllFloatRegex}|{AllOrdinalRegex}|{DigitsNumberRegex}))";
      public static readonly string TwoNumberRangeRegex5 = $@"(van\s+)?(?<number1>({AllIntRegex}|{AllFloatRegex}|{AllOrdinalRegex}|{DigitsNumberRegex}))\s*{IncludeTillRegex}\s*(de\s+)?(?<number2>({AllIntRegex}|{AllFloatRegex}|{AllOrdinalRegex}|{DigitsNumberRegex}))";
      public const string AmbiguousFractionConnectorsRegex = @"^[.]";
      public const char DecimalSeparatorChar = ',';
      public const string FractionMarkerToken = @"van de";
      public const char NonDecimalSeparatorChar = '.';
      public const string HalfADozenText = @"zes";
      public const string WordSeparatorToken = @"en";
      public static readonly string[] WrittenDecimalSeparatorTexts = { @"komma" };
      public static readonly string[] WrittenGroupSeparatorTexts = { @"punt" };
      public static readonly string[] WrittenIntegerSeparatorTexts = { @"en", @"ën" };
      public static readonly string[] WrittenFractionSeparatorTexts = { @"uit", @"van de", @"op de", @"en" };
      public const string HalfADozenRegex = @"(een\s+)?half\s+dozijn";
      public const string GrossRegex = @"(een\s+)?gros";
      public static readonly string DigitalNumberRegex = $@"((?<=\b)(honderd|duizend|miljoen|miljard|biljoen|dozijn?)(?=\b))|((?<=(\d|\b)){BaseNumbers.MultiplierLookupRegex}(?=\b))";
      public static readonly Dictionary<string, long> CardinalNumberMap = new Dictionary<string, long>
        {
            { @"nul", 0 },
            { @"een", 1 },
            { @"één", 1 },
            { @"twee", 2 },
            { @"drie", 3 },
            { @"vier", 4 },
            { @"vijf", 5 },
            { @"zes", 6 },
            { @"zeven", 7 },
            { @"acht", 8 },
            { @"negen", 9 },
            { @"tien", 10 },
            { @"elf", 11 },
            { @"twaalf", 12 },
            { @"dozijn", 12 },
            { @"dertien", 13 },
            { @"veertien", 14 },
            { @"vijftien", 15 },
            { @"zestien", 16 },
            { @"zeventien", 17 },
            { @"achttien", 18 },
            { @"negentien", 19 },
            { @"twintig", 20 },
            { @"dertig", 30 },
            { @"veertig", 40 },
            { @"vijftig", 50 },
            { @"zestig", 60 },
            { @"zeventig", 70 },
            { @"tachtig", 80 },
            { @"negentig", 90 },
            { @"honderd", 100 },
            { @"gros", 144 },
            { @"duizend", 1000 },
            { @"miljoen", 1000000 },
            { @"miljard", 1000000000 },
            { @"biljoen", 1000000000000 }
        };
      public static readonly Dictionary<string, long> OrdinalNumberMap = new Dictionary<string, long>
        {
            { @"nulde", 0 },
            { @"eerste", 1 },
            { @"eende", 1 },
            { @"tweede", 2 },
            { @"secundair", 2 },
            { @"half", 2 },
            { @"halve", 2 },
            { @"helft", 2 },
            { @"derde", 3 },
            { @"vierde", 4 },
            { @"kwart", 4 },
            { @"vijfde", 5 },
            { @"vijfden", 5 },
            { @"zesde", 6 },
            { @"zevende", 7 },
            { @"achtste", 8 },
            { @"achtsten", 8 },
            { @"negende", 9 },
            { @"tiende", 10 },
            { @"tienden", 10 },
            { @"elfde", 11 },
            { @"twaalfde", 12 },
            { @"dertiende", 13 },
            { @"veertiende", 14 },
            { @"vijftiende", 15 },
            { @"zestiende", 16 },
            { @"zeventiende", 17 },
            { @"achttiende", 18 },
            { @"negentiende", 19 },
            { @"twintigste", 20 },
            { @"eenentwintigste", 21 },
            { @"vijfentwintigste", 25 },
            { @"vijventwintigste", 25 },
            { @"dertigste", 30 },
            { @"vijfendertigste", 35 },
            { @"veertigste", 40 },
            { @"vijfenveertigste", 45 },
            { @"vijftigste", 50 },
            { @"vijfenvijftigste", 55 },
            { @"zestigste", 60 },
            { @"vijfenzestigste", 65 },
            { @"zeventigste", 70 },
            { @"vijfenzeventigste", 75 },
            { @"tachtigste", 80 },
            { @"vijfentachtigste", 85 },
            { @"negentigste", 90 },
            { @"vijfennegentigste", 95 },
            { @"honderdste", 100 },
            { @"duizendste", 1000 },
            { @"miljoenste", 1000000 },
            { @"miljardste", 1000000000 },
            { @"biljoenste", 1000000000000 },
            { @"biljardste", 1000000000000000 },
            { @"triljoenste", 1000000000000000000 }
        };
      public static readonly Dictionary<string, long> RoundNumberMap = new Dictionary<string, long>
        {
            { @"honderd", 100 },
            { @"duizend", 1000 },
            { @"miljoen", 1000000 },
            { @"miljard", 1000000000 },
            { @"biljoen", 1000000000000 },
            { @"biljard", 1000000000000000 },
            { @"triljard", 1000000000000000000 },
            { @"honderdste", 100 },
            { @"duizendste", 1000 },
            { @"miljoenste", 1000000 },
            { @"miljardste", 1000000000 },
            { @"biljoenste", 1000000000000 },
            { @"biljardste", 1000000000000000 },
            { @"triljoenste", 1000000000000000000 },
            { @"honderdsten", 100 },
            { @"duizendsten", 1000 },
            { @"miljoensten", 1000000 },
            { @"miljardsten", 1000000000 },
            { @"biljoensten", 1000000000000 },
            { @"dozijn", 12 },
            { @"gros", 144 },
            { @"k", 1000 },
            { @"m", 1000000 },
            { @"g", 1000000000 },
            { @"b", 1000000000 },
            { @"t", 1000000000000 }
        };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^[.]", @"" }
        };
      public static readonly Dictionary<string, string> RelativeReferenceOffsetMap = new Dictionary<string, string>
        {
            { @"laatst", @"0" },
            { @"laatste", @"0" },
            { @"volgende", @"1" },
            { @"huidige", @"0" },
            { @"vorige", @"-1" },
            { @"vorig", @"-1" },
            { @"de op één na laatste", @"-1" },
            { @"de een voor de laatste", @"-1" },
            { @"die voor de laatste", @"-1" },
            { @"voorlaatste", @"-1" },
            { @"twee na laatste", @"-2" }
        };
      public static readonly Dictionary<string, string> RelativeReferenceRelativeToMap = new Dictionary<string, string>
        {
            { @"laatst", @"end" },
            { @"laatste", @"end" },
            { @"volgende", @"current" },
            { @"huidige", @"current" },
            { @"vorige", @"current" },
            { @"vorig", @"current" },
            { @"de op één na laatste", @"end" },
            { @"de een voor de laatste", @"end" },
            { @"die voor de laatste", @"end" },
            { @"voorlaatste", @"end" },
            { @"twee na laatste", @"end" }
        };
    }
}