﻿//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
//
//     Generation parameters:
//     - DataFilename: Patterns\Dutch\Dutch-DateTime.yaml
//     - Language: Dutch
//     - ClassName: DateTimeDefinitions
// </auto-generated>
//
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// ------------------------------------------------------------------------------

namespace Microsoft.Recognizers.Definitions.Dutch
{
    using System;
    using System.Collections.Generic;

    public static class DateTimeDefinitions
    {
      public const string LangMarker = @"Dut";
      public const bool CheckBothBeforeAfter = false;
      public static readonly string TillRegex = $@"(?<till>\b(tot(dat|\s+en\s+met)?|gedurende|tijdens|ten tijde van)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public static readonly string RangeConnectorRegex = $@"(?<and>\b(en|t/m|tot(\s+(aan|en\s+met))?)\b|{BaseDateTime.RangeConnectorSymbolRegex})";
      public const string ArticleRegex = @"\b(de|het|een)\b";
      public const string ApostrofRegex = @"(’|‘|'|ʼ)";
      public static readonly string ApostrofsRegex = $@"({ApostrofRegex}\s*s)";
      public const string RelativeRegex = @"\b(?<order>((dit|deze|(erop)?volgende?|(aan)?komende?|aanstaande?|huidige?|vorige?|verleden|voorgaande?|laatste|afgelopen|(op\s+)?de|het)\b)|gister(en)?)";
      public const string StrictRelativeRegex = @"\b(?<order>((dit|deze|(erop)?volgende?|(aan)?komende?|aanstaande?|huidige?|vorige?|verleden|voorgaande?|laatste|afgelopen)\b)|gister(en)?)";
      public const string UpcomingPrefixRegex = @"((deze\s+)?((aan)?komende?|aanstaande?))";
      public static readonly string NextPrefixRegex = $@"\b((erop)?volgende?|eerstvolgende|{UpcomingPrefixRegex})\b";
      public const string AfterNextSuffixRegex = @"\b((na\s+(afloop\s+van\s+)?((de|het)\s+)?volgende?)|over)\b";
      public const string PastPrefixRegex = @"((deze\s+)?(verleden|afgelopen))\b";
      public static readonly string PreviousPrefixRegex = $@"((voorgaand[e]|vorige?|verleden|laatste|{PastPrefixRegex})\b|gister(en)?)";
      public const string ThisPrefixRegex = @"(dit|deze|huidige?)\b";
      public const string RangePrefixRegex = @"(van|tussen)";
      public const string CenturySuffixRegex = @"(^eeuw|^centennium)\b";
      public const string ReferencePrefixRegex = @"(dezelfde|hetzelfde|dat(zelfde)?|die|overeenkomstige)\b";
      public const string FutureSuffixRegex = @"\b(((in\s+de\s+)?toekomst)|daarna|over|na)\b";
      public const string PastSuffixRegex = @"^\b$";
      public const string DayRegex = @"(de\s*)?(?<!(\d+:|\$)\s*)(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?:\s*(ste|de|e))?(?=\b|t)";
      public static readonly string WrittenDayRegex = $@"(?<day>({WrittenOneToNineRegex})|({WrittenElevenToNineteenRegex})|(({WrittenOneToNineRegex}(en|ën))?twintig)|(((één|een)(en|ën))?dertig))";
      public static readonly string WrittenCardinalDayRegex = $@"(?<=((de\s+)|\b))(?<day>(éérste|eerste|tweede|derde|vierde|vijfde|zesde|zevende|achtste|negende|tiende|{WrittenElevenToNineteenRegex}de|({WrittenOneToNineRegex}(en|ën))?twintigste|((één|een)(en|ën))?dertigste))";
      public const string ImplicitDayRegex = @"(de\s*)?(?<day>(3[0-1]|[0-2]?\d)(\s*(ste|de|e)))\b";
      public const string MonthNumRegex = @"\b(?<month>01|02|03|04|05|06|07|08|09|10|11|12|1|2|3|4|5|6|7|8|9)\b";
      public const string WrittenOneToNineRegex = @"(één|een|twee|drie|vier|vijf|zes|zeven|acht|negen)";
      public const string WrittenElevenToNineteenRegex = @"(elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien)";
      public const string WrittenTensRegex = @"(tien|twintig|dertig|veertig|vijftig|zestig|zeventig|tachtig|negentig)";
      public static readonly string WrittenNumRegex = $@"({WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|{WrittenTensRegex}(\s+{WrittenOneToNineRegex})?)";
      public static readonly string WrittenCenturyFullYearRegex = $@"((twee)\s*duizend(\s+en)?(\s*{WrittenOneToNineRegex}\s*honderd)?)";
      public const string WrittenCenturyOrdinalYearRegex = @"((ee|éé)nentwintig|tweeëntwintig|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|een|twee|drie|vier|vijf|zes|zeven|acht|negen)";
      public static readonly string CenturyRegex = $@"\b(?<century>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}(\s*honderd)?(\s+en)?)";
      public static readonly string LastTwoYearNumRegex = $@"((zero|nul|en)\s+{WrittenOneToNineRegex}|{WrittenElevenToNineteenRegex}|({WrittenOneToNineRegex}[eë]n)?{WrittenTensRegex})";
      public static readonly string FullTextYearRegex = $@"\b((?<firsttwoyearnum>{CenturyRegex})\s*(?<lasttwoyearnum>{LastTwoYearNumRegex})\b|\b(?<firsttwoyearnum>{WrittenCenturyFullYearRegex}|{WrittenCenturyOrdinalYearRegex}\s+hundred(\s+and)?))\b";
      public const string OclockRegex = @"(?<oclock>u(ur)?)\b";
      public const string SpecialDescRegex = @"((?<ipm>)p\b)";
      public static readonly string AmDescRegex = $@"(:?{BaseDateTime.BaseAmDescRegex})";
      public static readonly string PmDescRegex = $@"(:?{BaseDateTime.BasePmDescRegex})";
      public static readonly string AmPmDescRegex = $@"(:?{BaseDateTime.BaseAmPmDescRegex})";
      public static readonly string DescRegex = $@"(:?(:?({OclockRegex}\s+)?(?<desc>({AmPmDescRegex}|{AmDescRegex}|{PmDescRegex}|{SpecialDescRegex}))\.?)|{OclockRegex})";
      public static readonly string PmRegex = $@"(?<pm>({ApostrofsRegex}|des)\s+(\bmiddags|avonds|nachts)|((in|tegen|op|om|met)\s+(de\s+)?)(((na)?middag|avond|(midder)?nacht|lunchtijd))|dag)";
      public static readonly string PmRegexFull = $@"(?<pm>(({ApostrofsRegex}|des)\s+(\bmiddags|avonds|nachts)|((in|tegen|op|om|met)\s+(de\s+)?)?(((na)?middag|(?<!kerst|oude?jaars)avond|(midder)?nacht|lunchtijd))))";
      public static readonly string AmRegex = $@"(?<am>(({ApostrofsRegex}|des)\s+(ochtends|morgens)|((in|tegen|op)\s+de)(\s+(ochtend|morgen))|(?<=gisteren|morgen|vandaag|(maan|dins|woens|donder|vrij|zater|zon)dag)(ochtend|morgen)|^?ochtend))";
      public static readonly string FullDescRegex = $@"({DescRegex}|{AmRegex}|{PmRegexFull})";
      public static readonly string TwoDigitYearRegex = $@"\b(?<!\$)(?<year>([0-24-9]\d))(?!(\s*(([:\.]\d)|keer|uurs?|{AmDescRegex}|{PmDescRegex})))\b";
      public static readonly string YearRegex = $@"({BaseDateTime.FourDigitYearRegex}|{FullTextYearRegex})";
      public const string WeekDayRegex = @"\b(?<weekday>((ma|di(ns)?|wo(e(ns)?)?|do|vr(ij)?|zat?|zo)(\.|\b))|((?:maan|dins|woens|donder|vrij|zater|zon)(dag(en)?)?(middag)?)\b)";
      public const string SingleWeekDayRegex = @"\b(?<weekday>(((ma|di(ns)?|wo(e(ns)?)?|do|vr|za)\b(\.)?)|(vrij|zat|zon?)\.(?!$)|(((?<!in\s+de\s+)(maan|dins|woens|donder|zater)(dag(en)?)?|(?<=(op|voor)\s+)(vrij|zon?|zat)|vrij(dag(en)?))\b))|zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)";
      public static readonly string RelativeMonthRegex = $@"(?<relmonth>((van\s+)?(de\s+)?)?{RelativeRegex}\s+maand)\b";
      public const string WrittenMonthRegex = @"(((de\s+)?maand\s+)?(?<month>januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december|jan|feb|mar|mrt|apr|jun|jul|aug|sep|sept|oct|okt|nov|dec))";
      public static readonly string MonthSuffixRegex = $@"(?<msuf>((in|van|tijdens|sinds|tot|op)\s+)?({RelativeMonthRegex}|{WrittenMonthRegex}))";
      public const string DateUnitRegex = @"(?<unit>(eeuw|maand|weekend)(?<plural>en)?|jaar|(?<plural>jaren|weken)|jr|decennia|mnd|week|(?<business>we[er]k)?dag(?<plural>en)?|dgn)\b";
      public const string DateTokenPrefix = @"op ";
      public const string TimeTokenPrefix = @"om ";
      public const string TokenBeforeDate = @"op ";
      public const string TokenBeforeTime = @"om ";
      public const string HalfTokenRegex = @"^(half)";
      public const string QuarterTokenRegex = @"^(een\s+kwart(\s+jaar)?|kwart|een\s+kwartier|kwartier)";
      public const string ThreeQuarterTokenRegex = @"^(drie\s+kwart|drie\s+kwartier)";
      public const string ToTokenRegex = @"\b(voor)$";
      public const string ToHalfTokenRegex = @"\b(over\s+half)$";
      public const string ForHalfTokenRegex = @"\b(voor\s+half)$";
      public const string FromRegex = @"\b(van(af)?)$";
      public const string BetweenTokenRegex = @"\b(tussen)$";
      public static readonly string SimpleCasesRegex = $@"\b({RangePrefixRegex}\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex}(\s*),?(\s*){MonthSuffixRegex}|{MonthSuffixRegex}\s+{DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontSimpleCasesRegex = $@"\b({RangePrefixRegex}\s+)?(({MonthSuffixRegex}\s+((van)\s+)?({DayRegex})|({DayRegex})\s+((van)\s+)?{MonthSuffixRegex})\s*{TillRegex}\s*({DayRegex})|(op\s+)?({DayRegex})\s*{TillRegex}\s*({DayRegex})\s+{MonthSuffixRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string MonthFrontBetweenRegex = $@"\b{MonthSuffixRegex}\s+(tussen\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string BetweenRegex = $@"\b(tussen\s+)({DayRegex})\s*{RangeConnectorRegex}\s*({DayRegex})\s+{MonthSuffixRegex}((\s+|\s*,\s*){YearRegex})?\b";
      public static readonly string RelativeYearRegex = $@"({YearRegex}|{TwoDigitYearRegex}|(?<order>volgende?|komende?|aanstaande?|aankomende?|huidige?|vorige?|afgelopen|dit)\s+jaar)";
      public static readonly string MonthWithYear = $@"\b(({WrittenMonthRegex}(\.)?(\s*)[/\\\-\.,]?(\s+(van|over|in))?(\s*){RelativeYearRegex})|({RelativeYearRegex}(\s*),?(\s*){WrittenMonthRegex}))\b";
      public static readonly string OneWordPeriodRegex = $@"\b((((de\s+)?maand\s+(van\s+)?)?({StrictRelativeRegex}\s+)?(?<month>januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december|jan\.?|feb\.?|mar\.?|mrt\.?|apr\.?|jun\.?|jul\.?|aug\.?|sep\.?|sept\.?|oct\.?|okt\.?|nov\.?|dec\.?))|(maand|jaar)\s+tot(\s+op)?\s+heden|(({RelativeRegex}\s+)(mijn\s+)?(weekend|(?<business>werkweek)|week|maand|jaar(?!\s+hoger dan))|({RelativeRegex}\s+)?(mijn\s+)(weekend|(?<business>werkweek)|week|maand|jaar))(?!((\s+van)?\s+\d+|\s+tot(\s+op)?\s+heden|nu))(\s+{AfterNextSuffixRegex})?)\b";
      public static readonly string MonthNumWithYear = $@"\b(({BaseDateTime.FourDigitYearRegex}(\s*)[/\-\.](\s*){MonthNumRegex})|({MonthNumRegex}(\s*)[/\-](\s*){BaseDateTime.FourDigitYearRegex}))\b";
      public static readonly string WeekOfMonthRegex = $@"\b(?<wom>(de\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\s+week\s+{MonthSuffixRegex}(\s+{BaseDateTime.FourDigitYearRegex}|{RelativeRegex}\s+year)?)\b";
      public static readonly string WeekOfYearRegex = $@"(\b(?<woy>(de\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\s+week(\s+van)?\s+({YearRegex}|{RelativeRegex}\s+jaar))\b)|(\b({YearRegex}|{RelativeRegex}\s+jaar)\s(?<woy>(de\s+)?(?<cardinal>eerste|tweede|derde|vierde|vijfde|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\s+week)\b)";
      public static readonly string OfYearRegex = $@"\b((of|in)\s+({YearRegex}|{StrictRelativeRegex}\s+year))\b";
      public const string FirstLastRegex = @"\b(the\s+)?((?<first>first)|(?<last>last))\b";
      public static readonly string FollowedDateUnit = $@"^\s*{DateUnitRegex}";
      public static readonly string NumberCombinedWithDateUnit = $@"\b(?<num>\d+(\.\d*)?){DateUnitRegex}";
      public const string QuarterTermRegex = @"\b(((?<cardinal>eerste|1e|1ste|tweede|2e|2de|derde|3e|3de|vierde|4e|4de)[ -]+kwartaal)|(k(?<number>[1-4])))\b";
      public static readonly string QuarterRegex = $@"(het\s+)?{QuarterTermRegex}((\s+van|\s*,\s*)?\s+({YearRegex}|{RelativeRegex}\s+jaar))?";
      public static readonly string QuarterRegexYearFront = $@"({YearRegex}|({RelativeRegex}\s+jaar))({ApostrofsRegex})?\s+((het|de)\s+)?{QuarterTermRegex}";
      public const string HalfYearTermRegex = @"(?<cardinal>eerste|1e|1ste|tweede|2e|2de)\s+(helft)";
      public static readonly string HalfYearFrontRegex = $@"(?<year>(de\s+){HalfYearTermRegex}(\s+helft van\s+)((1[5-9]|2[0-1]])\d{{2}}))";
      public static readonly string HalfYearBackRegex = $@"(het\s+)?(H(?<number>[1-2])|({HalfYearTermRegex}))(\s+van|\s*,\s*)?\s+({YearRegex})";
      public static readonly string HalfYearRelativeRegex = $@"(het\s+)?{HalfYearTermRegex}(\s+van|\s*,\s*)?\s+({RelativeRegex}\s+jaar)";
      public static readonly string AllHalfYearRegex = $@"({HalfYearFrontRegex})|({HalfYearBackRegex})|({HalfYearRelativeRegex})";
      public const string EarlyPrefixRegex = @"\b(?<EarlyPrefix>((?<RelEarly>eerder)|vroeg(er)?|((de|het)\s+)?(begin(nend)?|start(end)?))(\s+(in|op|van)(\s+de)?)?)\b";
      public const string MidPrefixRegex = @"\b(?<MidPrefix>(het\s+)?(mid(den|-)?|halverwege|op\s+de\s+helft|half)(\s+(in|op|van)(\s+de)?)?)";
      public const string LaterPrefixRegex = @"\b(?<LatePrefix>(laat|(?<RelLate>later)|(aan\s+)?het\s+einde?(\s+van(\s+de)?)?|eind(e|igend)?|afsluitend)(\s+(in|op|van)(\s+de)?)?)\b";
      public static readonly string PrefixPeriodRegex = $@"({EarlyPrefixRegex}|{MidPrefixRegex}|{LaterPrefixRegex})";
      public static readonly string PrefixDayRegex = $@"\b(((?<!{WeekDayRegex}\s+)(?<EarlyPrefix>eerder|vroeg(er)?|begin|start)|(?<MidPrefix>midden|halverwege|op\s+de\s+helft)|(?<LatePrefix>laat|later))(\s+(in|op|van))?(\s+de\s+dag)?$)|^\s*(((?<!{WeekDayRegex}\s+)(?<EarlyPrefix>eerder|vroeg(er)?|begin|start)|(?<MidPrefix>midden|halverwege|op\s+de\s+helft)|in\s+de|(?<LatePrefix>laat|later))(\s+(in|op|van))(\s+de\s+dag))\b";
      public const string SeasonDescRegex = @"(?<seas>lente|voorjaar|zomer|herfst|najaar|winter)";
      public static readonly string SeasonRegex = $@"\b(?<season>({PrefixPeriodRegex}(\s+)?)?({ArticleRegex}\s+)?({RelativeRegex}\s+)?{SeasonDescRegex}((\s+(in|van)|\s*,\s*)?\s+({YearRegex}|({ArticleRegex}\s+)?({RelativeRegex}\s+)?jaar))?)\b";
      public const string WhichWeekRegex = @"\b(week)(\s*)(?<number>5[0-3]|[1-4]\d|0?[1-9])\b";
      public const string WeekOfRegex = @"(de\s+)?(week)\s+(van(\s+(de|het))?|(beginnend|die\s+begint|startend|aanvangend)(\s+op)?)";
      public const string MonthOfRegex = @"(maand)(\s*)(van)";
      public const string MonthRegex = @"\b(?<month>(januari|februari|maart|april|mei|juni|juli|augustus|september|oktober|november|december)\b|(jan|feb|mar|mrt|apr|jun|jul|aug|sept|sep|oct|okt|nov|dec)(?:\.|\b))";
      public static readonly string DateYearRegex = $@"(?<year>{BaseDateTime.FourDigitYearRegex}|{TwoDigitYearRegex})";
      public static readonly string YearSuffix = $@"((,|\s*van)?\s*({DateYearRegex}|{FullTextYearRegex}))";
      public static readonly string OnRegex = $@"(?<=\bop\s+)({DayRegex})\b(?!(\.|:)\d+)";
      public const string RelaxedOnRegex = @"\b(?<=op\s+)(?:de\s+)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?:\s*(ste|de|e))?\b(?!(\.|:)\d+)";
      public const string PrefixWeekDayRegex = @"(\s*((,?\s*op)|[-—–]))";
      public static readonly string ThisRegex = $@"\b((deze(\s+week{PrefixWeekDayRegex}?)?\s*){WeekDayRegex})|({WeekDayRegex}((\s+van)?\s*deze\s+week))\b";
      public static readonly string LastDateRegex = $@"\b({PreviousPrefixRegex}(\s*week{PrefixWeekDayRegex}?)?\s+{WeekDayRegex})|({WeekDayRegex}(\s+van)?(\s+vorige\s+week))\b";
      public const string WeekDayForNextDateRegex = @"\b(?<weekday>((ma|di(ns)?|wo(e(ns)?)?|do|vr(ij)?|za(t)?|zo)(\.|\b))|((?:maan(?!den)|dins|woens|donder|vrij|zater|zon)(dag)?))";
      public static readonly string NextDateRegex1 = $@"\b({NextPrefixRegex}(\s*week{PrefixWeekDayRegex}?)?\s+{WeekDayForNextDateRegex}|(op\s+)?{WeekDayForNextDateRegex}\s+((van\s+)?(de\s+)?{NextPrefixRegex})\s*week|(op\s+)?{NextPrefixRegex}\s*week\s+{WeekDayForNextDateRegex})";
      public static readonly string NextDateRegex2 = $@"\b({NextPrefixRegex}(\s*week(\s*,?\s*op)?)?\s+{WeekDayRegex}|(op\s+)?{WeekDayRegex}\s+((van\s+)?(de\s+)?{NextPrefixRegex})\s*week|(op\s+)?{NextPrefixRegex}\s*week\s+{WeekDayRegex})";
      public static readonly string NextDateRegex = $@"({NextDateRegex1}|{NextDateRegex2})";
      public static readonly string SpecialDayRegex = $@"\b(eergisteren|overmorgen|(de\s+)?dag\s+na\s+morgen|(de\s+)?dag\s+(ervoor|erna)|((de\s+)?({StrictRelativeRegex}|mijn)\s+dag)\b|(de\s+dag(?!\s+van))|gisteren|(deze\s+)?morgen|vandaag|morgen(middag))(?!s\b)";
      public static readonly string SpecialDayWithNumRegex = $@"\b((?<number>{WrittenNumRegex})\s+dag(en)?\s+(gerekend\s+)?(vanaf\s+)(?<day>gisteren|morgen|vandaag))\b";
      public static readonly string RelativeDayRegex = $@"\b(((de\s+)?{RelativeRegex}\s+dag))\b";
      public const string SetWeekDayRegex = @"\b(?<prefix>op\s+({ArticleRegex}\s+)?)?(?<weekday>morgen|ochtend|middag|avond|nacht|zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)((?<suffix>e)n)\b";
      public static readonly string WeekDayOfMonthRegex = $@"(?<wom>((de\s+|\b))?(?<cardinal>eerste|tweede|derde|vierde|vijfde|zesde|tiende|1e|1ste|2e|2de|3e|3de|4e|4de|5e|5de|laatste)\s+{WeekDayRegex}(\s+{MonthSuffixRegex}))";
      public static readonly string RelativeWeekDayRegex = $@"\b({WrittenNumRegex}\s+{WeekDayRegex}\s+(vanaf\s+nu|later))\b";
      public static readonly string SpecialDate = $@"(?=\b(op\s+)(de\s+)?){DayRegex}\b";
      public const string DatePreposition = @"\b(op(\s+de)?)";
      public static readonly string DateExtractorYearTermRegex = $@"(\s+(van\s+)?|\s*[,./-]\s*){DateYearRegex}";
      public static readonly string DateExtractor1 = $@"\b({WeekDayRegex}\s*[,-]?\s*)?(({MonthRegex}(\.)?\s*[/\\.,-]?\s*{DayRegex}(?!\s*({MonthRegex}|\-\s*\d{{2}}\b)))|(\({MonthRegex}\s*[-.]\s*{DayRegex}\))|({DayRegex}(\.)?\s*[/\\.,-]?\s*{MonthRegex}))(\s*\(\s*{WeekDayRegex}\s*\))?({DateExtractorYearTermRegex}(?!\s*{MonthRegex})\b)?";
      public static readonly string DateExtractor3 = $@"\b({WeekDayRegex}(\s+|\s*,\s*)?(de\s+)?)?(({DayRegex}(\s*dag|\.)?)((\s+|\s*[,/-]\s*|\s+van\s+)?{MonthRegex})((\.)?(\s+|\s*[,/-]\s*|\s+in\s+)?{DateYearRegex})?|{BaseDateTime.FourDigitYearRegex}\s*[,./-]?\s*(de\s*)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?:\s*(ste|de|e))?(\s*dag|\.)?\s*[,./-]?\s*{MonthRegex})\b";
      public static readonly string DateExtractor4 = $@"\b{MonthNumRegex}\s*[/\\\-]\s*{DayRegex}[\.]?\s*[/\\\-]\s*{ApostrofRegex}?{DateYearRegex}";
      public static readonly string DateExtractor5 = $@"\b{DayRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DateYearRegex}(?!\s*[/\\\-\.]\s*\d+)";
      public static readonly string DateExtractor6 = $@"(?<={DatePreposition}\s+)({StrictRelativeRegex}\s+)?({WeekDayRegex}\s+)?{MonthNumRegex}[\.]{DayRegex}(?!([%]|\s*{FullDescRegex}))\b|(?<={DatePreposition}\s+){MonthNumRegex}[\-\.]{DayRegex}(?!([%]|\s*{FullDescRegex}))\b";
      public static readonly string DateExtractor7L = $@"\b({WeekDayRegex}\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{DateExtractorYearTermRegex}(?![%])\b";
      public static readonly string DateExtractor7S = $@"\b((?<=(^|{DatePreposition}\s+)){WeekDayRegex}\s+)?{MonthNumRegex}\s*/\s*{DayRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\s*{FullDescRegex}))\b";
      public static readonly string DateExtractor8 = $@"\b((?<=(^|{DatePreposition}\s+)){WeekDayRegex}\s+)?(?<!(morgen|ochtend|middag|avond|nacht)s?\s+){DayRegex}[\\\-]{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\s*{FullDescRegex}))\b";
      public static readonly string DateExtractor9L = $@"\b({WeekDayRegex}\s+)?{DayRegex}\s*[-|\/|.]\s*{MonthNumRegex}((\s+|\s*,\s*|\s+in\s+){DateYearRegex})(?![%])\b";
      public static readonly string DateExtractor9S = $@"\b(?<!naar\s+)({WeekDayRegex}\s+)?{DayRegex}\s*(\/|\.)\s*{MonthNumRegex}{BaseDateTime.CheckDecimalRegex}(?!([%]|\s*{FullDescRegex}))\b";
      public static readonly string DateExtractorA = $@"\b({WeekDayRegex}\s+)?({BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*({MonthNumRegex}|{MonthRegex})\s*[/\\\-\.]\s*{DayRegex}(?!\s*[/\\\-\.]\s*\d+)|{MonthRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*(de\s*)?(?<day>(?:3[0-1]|[1-2]\d|0?[1-9]))(?:\s*(ste|de|e))?|{DayRegex}\s*[/\\\-\.]\s*{BaseDateTime.FourDigitYearRegex}\s*[/\\\-\.]\s*{MonthRegex})";
      public static readonly string OfMonth = $@"(^\s*((van|in)\s+)?)({MonthRegex})";
      public static readonly string MonthEnd = $@"{MonthRegex}(\s+de\s*)?$";
      public static readonly string WeekDayEnd = $@"(deze\s+)?{WeekDayRegex}\s*,?\s*$";
      public static readonly string WeekDayStart = $@"^\s+(op\s+)?{WeekDayRegex}\b";
      public const string RangeUnitRegex = @"\b(?<unit>ja(ren|ar)|maand(en)?|we(ken|ek)|dag(en)?)\b";
      public const string HourNumRegex = @"\b(?<hournum>nul|een|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig)\b";
      public const string MinuteNumRegex = @"(?<minnum>nul|een(?=\s+min(uut)?)|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig|vij[fv]entwintig|ze(s|ven)entwintig|achtentwintig|negenentwintig|dertig|eenendertig|tweeëndertig|drieëndertig|vierendertig|vijfendertig|ze(s|ven)endertig|achtendertig|negenendertig|veertig|eenenveertig|tweeënveertig|drieënveertig|vierenveertig|vijfenveertig|ze(s|ven)enveertig|achtenveertig|negenenveertig|eenenvijftig|vijftig|tweeënvijftig|drieënvijftig|vierenvijftig|vijfenvijftig|ze(s|ven)envijftig|achtenvijftig|negenenvijftig)";
      public const string DeltaMinuteNumRegex = @"(?<deltaminnum>nul|een(?=\s+min(uut)?)|één|twee|drie|vier|vijf|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig|vijfentwintig|vijventwintig|zesentwintig|zevenentwintig|achtentwintig|negenentwintig|dertig|eenendertig|tweeëndertig|drieëndertig|vierendertig|vijfendertig|zesendertig|zevenendertig|achtendertig|negenendertig|veertig|eenenveertig|tweeënveertig|drieënveertig|vierenveertig|vijfenveertig|zesenveertig|zevenenveertig|achtenveertig|negenenveertig|eenenvijftig|vijftig|tweeënvijftig|drieënvijftig|vierenvijftig|vijfenvijftig|zesenvijftig|zevenenvijftig|achtenvijftig|negenenvijftig)(?=\b)";
      public const string LunchRegex = @"\b(lunchtijd)\b";
      public static readonly string NightRegex = $@"\b((({ApostrofsRegex}|des)\s+)?nachts|(midder)?nacht)\b";
      public const string CommonDatePrefixRegex = @"^[\.]";
      public static readonly string LessThanOneHour = $@"(?<lth>((een\s+)?((drie\s+)?kwart(ier)?|half(uur)?))|{BaseDateTime.DeltaMinuteRegex}(\s+(minuten|mins|min\.?))?|({DeltaMinuteNumRegex}(\s+(minuten|mins|min\.?))?))";
      public static readonly string WrittenTimeRegex = $@"(?<writtentime>({HourNumRegex}\s+{MinuteNumRegex}|(?<prefix>half)\s+({HourNumRegex})))";
      public static readonly string TimePrefix = $@"(?<prefix>(half|{LessThanOneHour}\s+(over|voor|na)(\s+half)?)|(uur\s+{LessThanOneHour}))";
      public static readonly string TimeSuffix = $@"(?<suffix>(({OclockRegex}\s+)?({AmRegex}|{PmRegex}))|{OclockRegex})";
      public static readonly string TimeSuffixFull = $@"(?<suffix>(({OclockRegex}\s+)?({AmRegex}|{PmRegexFull}))|{OclockRegex})";
      public static readonly string HourDTRegEx = $@"({BaseDateTime.HourRegex})";
      public static readonly string MinuteDTRegEx = $@"({BaseDateTime.MinuteRegex})";
      public static readonly string SecondDTRegEx = $@"({BaseDateTime.SecondRegex})";
      public static readonly string BasicTime = $@"\b(?<basictime>{WrittenTimeRegex}|{HourNumRegex}|{HourDTRegEx}(:|\.){MinuteDTRegEx}(:{SecondDTRegEx})?|((?<prefix>half)\s+)?{HourDTRegEx}(?![.,:]?[%\d]))";
      public static readonly string MidnightRegex = $@"(?<midnight>mid\s*(-\s*)?nacht|middernacht|(in\s+)?de nacht(\s+van)?|({ApostrofsRegex}|des)\s*nachts)";
      public const string MidmorningRegex = @"(?<midmorning>mid\s*(-\s*)?(morgen|ochtend)|halverwege de ochtend|het midden van de ochtend)";
      public const string MidafternoonRegex = @"(?<midafternoon>mid\s*(-\s*)?middag|halverwege de middag|het midden van de middag)";
      public static readonly string MiddayRegex = $@"(?<midday>(?<!gisteren|morgen)(((rond\s+)?(het|de)|{ApostrofsRegex})\s+)?middag(uur|s|loos)?|namiddag|noen|lunchtijd)";
      public static readonly string MidTimeRegex = $@"(?<mid>({MidnightRegex}|{MidmorningRegex}|{MidafternoonRegex}|{MiddayRegex}))";
      public static readonly string AtRegex = $@"(((?<=\bom\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}(?!\.\d)(\s*((?<iam>a)|(?<ipm>p)))?|{MidTimeRegex}))|{MidTimeRegex})\b";
      public static readonly string IshRegex = $@"\b(tegen\s+{BaseDateTime.HourRegex}(-|——|\s*{ApostrofRegex}\s*)?en|middagloos)\b";
      public const string TimeUnitRegex = @"([^A-Za-z]{1,}|\b)(?<unit>(min\.|sec\.)|(u(ur)?|minuut|seconde|(?<plural>uren|minuten|seconde[ns])|(min|sec)(?<plural>s)?)\b)";
      public const string RestrictedTimeUnitRegex = @"(?<unit>uur|minuut)\b";
      public const string FivesRegex = @"(?<tens>(vijf|tien|vijftien|twintig|vijfentwintig|vijventwintig|dertig|vijfendertig|veertig|vijfenveertig|vijftig|vijfenvijftig))\b";
      public static readonly string HourRegex = $@"\b{BaseDateTime.HourRegex}";
      public const string PeriodHourNumRegex = @"\b(?<hour>nul|een|één|twee|drie|vier|vijf(en)?|zes|zeven|acht|negen|tien|elf|elven|twaalf|dertien|veertien|vijftien|zestien|zeventien|achttien|negentien|twintig|eenentwintig|éénentwintig|tweeentwintig|tweeëntwintig|drieëntwintig|vierentwintig)\b?";
      public static readonly string ConnectNumRegex = $@"\b{BaseDateTime.HourRegex}(?<min>00|01|02|03|04|05|06|07|08|09|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59)\s*{DescRegex}";
      public static readonly string TimeRegexWithDotConnector = $@"({BaseDateTime.HourRegex}(\s*\.\s*){BaseDateTime.MinuteRegex}(\s*:\s*{BaseDateTime.SecondRegex})?(\s*u\s*)?)";
      public static readonly string TimeRegexFilter = $@"\b((iedere|elke|op)(\s+andere)?\s+)?(week|dag|{SingleWeekDayRegex}|vandaag)\b";
      public static readonly string TimeRegex1 = $@"\b(({TimePrefix}|{AroundRegex})\s+)?(({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex})(\s*{DescRegex})|(({AroundRegex})\s+){HourNumRegex}(?!\s+{SingleWeekDayRegex})\b)";
      public static readonly string TimeRegex2 = $@"(\b{TimePrefix}\s+)?(t)?{BaseDateTime.HourRegex}(\s*)?(:|\.)(\s*)?(?<min>[0-5]\d)(?!(\d|\s*(per|pro)\s*cent|%))((\s*)?:(\s*)?{BaseDateTime.SecondRegex})?(\s*u)?((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex3 = $@"(\b{TimePrefix}\s+)?{BaseDateTime.HourRegex}\.{BaseDateTime.MinuteRegex}(\s*{DescRegex})";
      public static readonly string TimeRegex4 = $@"\b{TimePrefix}\s+{BasicTime}(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex5 = $@"\b({TimePrefix}\s+{BasicTime}|{BasicTime}\s+{TimePrefix})((\s*({DescRegex}|{TimeSuffix}))|\b)";
      public static readonly string TimeRegex6 = $@"{BasicTime}(\s*u\s*)?(\s*{DescRegex})?\s+{TimeSuffix}\b";
      public static readonly string TimeRegex7 = $@"({TimeSuffixFull}\s+(om\s+)?({TimePrefix}\s+)?(?<!van(avond|nacht)\s+){BasicTime})((\s*{DescRegex})|\b)|{BasicTime}(\s*{DescRegex})(\s*{TimeSuffixFull})";
      public static readonly string TimeRegex8 = $@".^";
      public static readonly string TimeRegex9 = $@"\b{PeriodHourNumRegex}\s*{FivesRegex}((\s*{DescRegex})|\b)";
      public static readonly string TimeRegex10 = $@"\b({TimePrefix}\s+)?{BaseDateTime.HourRegex}(\s*(u\b|h))(\s*{BaseDateTime.MinuteRegex})?(\s*{DescRegex})?";
      public static readonly string TimeRegex11 = $@"\b(?<!{TimeRegexFilter}\s+)((?:({TimeTokenPrefix})?{TimeRegexWithDotConnector}(\s*({DescRegex}|{TimeSuffix})))|(?:(?:{TimeTokenPrefix}{TimeRegexWithDotConnector})(?!\s*(per|pro)\s*cent|%|\s+{TimeRegexFilter})))";
      public static readonly string TimeRegex12 = $@"({BaseDateTime.HourRegex}(?=\s+(vandaag|morgen|op)))";
      public static readonly string FirstTimeRegexInTimeRange = $@"\b{TimeRegexWithDotConnector}(?!\s*(per|pro)\s*cent|%|\s+{TimeRegexFilter})(\s*{DescRegex})?";
      public static readonly string PureNumFromToPrefixExcluded = $@"({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\s*{TillRegex}\s*({HourDTRegEx}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string PureNumFromToPrefix = $@"(({PmRegexFull}|{AmRegex})\s+)?({RangePrefixRegex}\s+)({HourDTRegEx}|{PeriodHourNumRegex})(\s+uur)?(\s*(?<leftDesc>({PmRegex}|{AmRegex}|{DescRegex})))?\s*{RangeConnectorRegex}\s*({HourDTRegEx}|{PeriodHourNumRegex})(\s+uur)?(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string PureNumFromToWithDateBefore = $@"({RangePrefixRegex}\s+)({HourDTRegEx})(\s+(vandaag|morgen)\s+)?(\s*{RangeConnectorRegex}\s*)({HourDTRegEx})";
      public static readonly string PureNumFromToWithDateAfter = $@"({RangePrefixRegex}\s+)({HourDTRegEx})(\s*{RangeConnectorRegex}\s*)({HourDTRegEx}(\s+(vandaag|morgen))?)";
      public static readonly string PureNumFromTo = $@"({PureNumFromToPrefix}|{PureNumFromToPrefixExcluded})";
      public static readonly string TimeDateFromTo = $@"({PureNumFromToWithDateAfter}|{PureNumFromToWithDateBefore})";
      public static readonly string PureNumBetweenAnd = $@"(tussen\s+)({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?\s*{RangeConnectorRegex}\s*({HourDTRegEx}|{PeriodHourNumRegex})(?<rightDesc>\s*({PmRegex}|{AmRegex}|{DescRegex}))?";
      public static readonly string SpecificTimeFromTo = $@"(({PmRegexFull}|{AmRegex})\s+)?({RangePrefixRegex}\s+)?(?<time1>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{TillRegex}\s*(?<time2>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?))";
      public static readonly string SpecificTimeBetweenAnd = $@"(({PmRegexFull}|{AmRegex})\s+)?(tussen\s+)(?<time1>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<leftDesc>{DescRegex}))?))\s*{RangeConnectorRegex}\s*(?<time2>({TimeRegex2}|({HourDTRegEx}|{PeriodHourNumRegex})(\s*(?<rightDesc>{DescRegex}))?(\s+{TimeSuffix})?))";
      public const string PrepositionRegex = @"(?<prep>^(om|rond|tegen|op|van|deze)(\s+de)?$)";
      public const string EarlyLateRegex = @"\b(((?<early>vroege?|(in\s+het\s+)?(begin))|(?<late>laat|later|late|aan\s+het\s+einde?))((\s+|-)(in\s+de|op\s+de|van\s+de|deze|in|op|van|de))?)";
      public static readonly string TimeOfDayRegex = $@"(?<timeOfDay>(({EarlyLateRegex}\s+)(aanstaande\s+)?(zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag)\s*(ochtend|morgen|(na)?middag|avond|nacht))|(((van\s+deze\s+)|\b(in\s+(de)?\s+)|de\s+)?({EarlyLateRegex}\s+)?({ApostrofsRegex}\s+)?(ochtend(en)?|morgen|middag(en)?|avond(en)?|nacht(\s+van)?)s?((\s+|-)({EarlyLateRegex}))?)|{MealTimeRegex}|((tijdens\s+(de\s+)?)?(kantoor|werk)uren))\b";
      public static readonly string SpecificTimeOfDayRegex = $@"\b((({StrictRelativeRegex}\s+{TimeOfDayRegex})\b|\bvan(ochtend|morgen|middag|avond|nacht)))s?\b";
      public static readonly string TimeFollowedUnit = $@"^\s*{TimeUnitRegex}";
      public static readonly string TimeNumberCombinedWithUnit = $@"\b(?<num>\d+(\.\d*)?){TimeUnitRegex}";
      public static readonly string[] BusinessHourSplitStrings = { @"werk", @"uren" };
      public static readonly string[] BusinessHourSplitStrings2 = { @"kantoor", @"uren" };
      public const string NowRegex = @"(?<!vanaf\s+)\b(?<now>nu(\s+meteen)?|zo snel mogelijk|zo spoedig mogelijk|asap|recent|onlangs|zojuist)\b";
      public const string SuffixRegex = @"^\s*(in de\s+)?(vroege\s+|late\s+)?(ochtend|(na)?middag|avond|nacht)\b";
      public const string DateTimeTimeOfDayRegex = @"\b(?<timeOfDay>morgen|ochtend|(na)?middag|avond|nacht)\b";
      public static readonly string DateTimeSpecificTimeOfDayRegex = $@"\b(({RelativeRegex}\s+{DateTimeTimeOfDayRegex})|van(nacht|avond|middag|ochtend|morgen))\b";
      public static readonly string TimeOfTodayAfterRegex = $@"^\s*(,\s*)?((in\s+de)|(op\s+de))?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string TimeOfTodayBeforeRegex = $@"{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(om|rond|tegen|op\s+de|op))?\s*$";
      public const string NonTimeContextTokens = @"\b(gebouw)";
      public static readonly string SimpleTimeOfTodayAfterRegex = $@"(?<!{NonTimeContextTokens}\s*)\b({HourNumRegex}|{BaseDateTime.HourRegex})(\s*({OclockRegex}|u))?\s*(,\s*)?((in|op)\s+de\s+)?{DateTimeSpecificTimeOfDayRegex}";
      public static readonly string SimpleTimeOfTodayBeforeRegex = $@"\b{DateTimeSpecificTimeOfDayRegex}(\s*,)?(\s+(om|rond|tegen|op(\s+de)?))?\s*(?<!van(avond|nacht)\s+)({HourNumRegex}|{BaseDateTime.HourRegex})\b";
      public const string SpecificEndOfRegex = @"((\baan\s+)?((de|het)\s+)?eind(e? van)?(\s+(de|het))?\s*$|^\s*(het\s+)?einde? van(\s+de(\s+dag)))";
      public const string UnspecificEndOfRegex = @"\b(((om|rond|tegen|op)\s+)?het\s+)?(einde?\s+van\s+(de\s+)?dag)\b";
      public const string UnspecificEndOfRangeRegex = @"\b(evj)\b";
      public static readonly string PeriodTimeOfDayRegex = $@"((in\s+(de)?\s+)?({EarlyLateRegex}(\s+|-))?(zondag|maandag|dinsdag|woensdag|donderdag|vrijdag|zaterdag|(eer)?gisteren|morgen)?(?<timeOfDay>ochtend|(na)?middag|avond|nacht))\b";
      public static readonly string PeriodSpecificTimeOfDayRegex = $@"\b(({StrictRelativeRegex}(\s+)?{PeriodTimeOfDayRegex})\b|\bvan(nacht|avond|(na)?middag|ochtend))\b";
      public static readonly string PeriodTimeOfDayWithDateRegex = $@"(({TimeOfDayRegex}(\s+(om|rond|van|tegen|op(\s+de)?))?))\b";
      public static readonly string PeriodTimeOfDayWithDateRegexWithAnchors = $@"((({TimeOfDayRegex}(\s+(om|rond|van|tegen|op(\s+de)?))?))(?=({MiddlePauseRegex})?\s*$)|(?<=^\s*({MiddlePauseRegex})?)(?!{MealTimeRegex}){TimeOfDayRegex})";
      public const string LessThanRegex = @"\b((binnen\s+)?minder\s+dan)\b";
      public const string MoreThanRegex = @"\b((meer|langer)\s+dan|ruim)\b";
      public static readonly string DurationUnitRegex = $@"(?<unit>{DateUnitRegex}|(min\.|sec\.)|((?<half>halfuur)|(?<quarter>kwartier\s+uur)|(?<quarter>kwartier)|uur|uren|u|minuten|minuut|m(ins?)?|seconde[ns]?|s(ecs?)?|nacht(en)?)\b)(\s+lang\b)?";
      public const string SuffixAndRegex = @"(?<suffix>\s*(en|ën)(\s*een)?\s*(?<suffix_num>hal(f|ve)|kwart|kwartier)|(?<suffix_num>(een\s+)?kwartier))";
      public const string PeriodicRegex = @"\b(?<periodic>dagelijkse?|(drie)?maandelijkse?|wekelijkse?|twee-?wekelijkse?|(half)?jaarlijkse?|kwartaal)\b";
      public static readonly string EachUnitRegex = $@"(?<each>((iedere?|elke?|eenmaal per)(?<other>\s+andere)?\s*({DurationUnitRegex}|(?<specialUnit>weekend(en)?))|({DurationUnitRegex}|{WeekDayRegex})\s+om(\s+de)?(?<other>\s+andere)?\s*(week|{DurationUnitRegex})))";
      public const string EachPrefixRegex = @"\b(?<each>(iedere|elke|eenmaal per)\s*$)";
      public static readonly string SetEachRegex = $@"\b(?<each>(iedere|elke|om\s+de)\s*(?<other>\s+andere)?\s*(week\s*(?={WeekDayRegex}))?)";
      public const string SetLastRegex = @"(?<last>volgende?|komende|aankomende|aanstaande|deze|huidige|aanstaande|vorige?|verleden|laatste)";
      public const string EachDayRegex = @"\s*(iedere|elke)\s*dag\b";
      public const string BeforeEachDayRegex = @"(iedere|elke)\s*dag\s*";
      public static readonly string DurationFollowedUnit = $@"^\s*((?<suffix>(?<unit>(?<suffix_num>(een\s+)?kwartier)))|{SuffixAndRegex}?(\s+|-)?{DurationUnitRegex})";
      public static readonly string NumberCombinedWithDurationUnit = $@"\b(?<num>\d+([.,:]\d*)?)(-)?{DurationUnitRegex}";
      public static readonly string AnUnitRegex = $@"\b((((nog een|een|nog)\s+(?<half>anderhalf|anderhalve|half|halve)?))|andere)\s*{DurationUnitRegex}";
      public const string DuringRegex = @"\b(voor\s+een|gedurende\s+(het|de))\s+(?<unit>jaar|maand|week|dag)\b";
      public const string AllRegex = @"\b(?<all>((de|het|een)\s+)?((ge)?hele|volledige|ganse|heel|volledig|volle)(\s+|-)(?<unit>jaar|maand|week|dag))\b";
      public const string HalfRegex = @"(((een)\s*)|\b)(?<half>(half|halve)\s+(?<unit>jaar|maand|week|dag|uur|halfuur)|(?<unit>halfuur))\b";
      public const string ConjunctionRegex = @"\b((en(\s+voor)?)|plus)\b";
      public static readonly string HolidayList1 = $@"(?<holiday>goede vrijdag|pasen|((eerste|tweede)\s+)?paasdag|paas(zondag|maandag)|kerst(avond|mis)?|thanksgiving|halloween|(islamitisch\s+)?nieuwjaar|oud en nieuw|oud & nieuw|pinksteren|oude?jaar|oude?jaarsavond|silvester|silvesteravond|sinterklaas|sinterklaasfeest|sinterklaasavond|pakjesavond|eid al(-|\s+)fitr|eid al(-|\s+)adha|juneteenth|vrijheidsdag|jubilee\s+day)";
      public static readonly string HolidayList2 = $@"(?<holiday>black friday|cyber monday|nationale dodenherdenking|nationale herdenking|dodenherdenking|dag\s+van\s+de\s+(leraar|leerkracht(en)?|arbeid|aarde)|feest\s+van\s+de\s+arbeid|yuandan|valentijn|sint-maartensfeest|sint-maarten|driekoningen|keti(\s+|-)?koti|ramadan|suikerfeest|offerfeest|allerheiligen|allerheiligenavond|franse nationale feestdag|bestorming van de bastille)";
      public static readonly string HolidayList3 = $@"(?<holiday>(martin luther king|mlk|dankzeggings|valentijns|nieuwjaars|(eerste|1e|tweede|2e)\s+paas|prinsjes|konings|koninginne|bevrijdings|hemelvaarts|(eerste|1e|tweede|2e)\s+kerst|vader|moeder|meisjes|(amerikaanse|us\s+)?onafhankelijk(heid)?s|(nederlandse\s+)?veteranen|boomplant|(nationale\s+)?boomfeest)dag)";
      public static readonly string HolidayRegex = $@"\b(({StrictRelativeRegex}\s+({HolidayList1}|{HolidayList2}|{HolidayList3}))|(({HolidayList1}|{HolidayList2}|{HolidayList3})(\s+(van\s+)?({YearRegex}|{RelativeRegex}\s+jaar))?))\b";
      public static readonly string AMTimeRegex = $@"(?<am>{ApostrofsRegex}\s*(morgens|ochtends)|in\s+de\s+(morgen|ochtend))";
      public static readonly string PMTimeRegex = $@"(?<pm>{ApostrofsRegex}\s*(middags|avonds|nachts)|(in\s+de\s+)?(deze\s+)?((na)?middag|avond|nacht))\b";
      public const string MorningTimeRegex = @"(morgens?|ochtends?)";
      public const string NightTimeRegex = @"(nacht)";
      public const string NowTimeRegex = @"\b(nu)\b";
      public const string RecentlyTimeRegex = @"\b(kort\s+geleden|eerder)\b";
      public const string AsapTimeRegex = @"\b(zo\s+snel\s+mogelijk|zsm)\b";
      public const string InclusiveModPrepositions = @"(?<include>((in|tegen|tijdens|op|om)\s+of\s+)|(\s+of\s+(in|tegen|tijdens|op)))";
      public static readonly string AfterRegex = $@"(\b{InclusiveModPrepositions}?((na(\s+afloop\s+van)?|(?<!niet\s+)later\s+dan)|(jaar\s+na)|(het\s+)?jaar hoger dan)(?!\s+of\s+gelijk\s+aan){InclusiveModPrepositions}?\b\s*)|(?<!\w|<)((?<include>>=)|>)";
      public static readonly string BeforeRegex = $@"(\b(?<!afspraak\s*){InclusiveModPrepositions}?(voor|vóór|vooraf(gaand?)?\s+aan|(niet\s+later|vroeger|eerder)\s+dan|eindigend\s+(op|met)|tegen|totdat|(?<!terug\s+)tot|uiterlijk|(?<include>(al\s+)?zo\s+laat\s+als)){InclusiveModPrepositions}?\b\s*)|(?<!\w|>)((?<include><=)|<)";
      public const string SinceRegex = @"(\b(sinds|na\s+of\s+gelijk\s+aan|(startend|beginnend)\s+(vanaf|op|met)|(al\s+)?zo\s+vroeg\s+als|(elk|ieder)\s+moment\s+vanaf|een\s+tijdstip\s+vanaf)\b\s*)|(?<!\w|<)(>=)";
      public const string AroundRegex = @"(\b(rond(om)?|ongeveer(\s+om)?)\s*\b)";
      public const string AgoRegex = @"\b(geleden|(voor|eerder\s+dan)\s+(?<day>gisteren|vandaag))\b";
      public const string LaterRegex = @"\b(later|vanaf\s+nu|(vanaf|na|sedert)\s+(?<day>morgen|vandaag))\b";
      public const string BeforeAfterRegex = @"\b(gerekend\s+)?((?<before>voor(dat)?)|(?<after>van(af)?|na))\b";
      public static readonly string ModPrefixRegex = $@"\b({RelativeRegex}|{AroundRegex}|{BeforeRegex}|{AfterRegex}|{SinceRegex})\b";
      public static readonly string ModSuffixRegex = $@"\b({AgoRegex}|{LaterRegex}|{BeforeAfterRegex}|{FutureSuffixRegex}|{PastSuffixRegex})\b";
      public const string InConnectorRegex = @"\b(in|over|na)(\s+de)?\b";
      public static readonly string SinceYearSuffixRegex = $@"(^\s*{SinceRegex}((vanaf|sedert|sinds)\s+(het\s+)?jaar\s+)?{YearSuffix})";
      public static readonly string WithinNextPrefixRegex = $@"\b((binnen)(\s+de|het)?(\s+(?<next>{NextPrefixRegex}))?)\b";
      public const string TodayNowRegex = @"\b(vandaag|nu)\b";
      public static readonly string MorningStartEndRegex = $@"(^(({ApostrofsRegex}|des)\s+(morgens|ochtends)|in\s+de\s+(na)?(morgen|ochtend)|deze\s+(morgen|ochtend)|(morgen|ochtend)\s+in\s+het\s+begin|aan\s+het\s+einde?(\s+van(\s+de)?)?\s+(morgen|ochtend)|{AmDescRegex}|(morgen|ochtend)))|((({ApostrofsRegex}|des)\s+(morgens|ochtends)|deze\s+(morgen|ochtend)|in\s+de\s+(na)?(morgen|ochtend)|(morgen|ochtend)\s+in\s+het\s+begin|(morgen|ochtend)\s+aan\s+het\s+einde?|{AmDescRegex}|(morgen|ochtend))$)";
      public static readonly string AfternoonStartEndRegex = $@"(^(({ApostrofsRegex}|des)\s+middags|in\s+de\s+(na)?middag|deze\s+middag|aan\s+het\s+einde?(\s+van(\s+de)?)?\s+middag|{PmDescRegex}))|((({ApostrofsRegex}|des)?\s+middags|in\s+de\s+(na)?middag|deze\s+middag|middag\s+in\s+het\s+begin|middag\s+aan\s+het\s+einde?|{PmDescRegex}|middag)$)";
      public static readonly string EveningStartEndRegex = $@"(^(({ApostrofsRegex}|des)\s+avonds|in\s+de\s+(na)?avond|deze\s+avond|avond\s+in\s+het\s+begin|aan\s+het\s+einde?(\s+van(\s+de)?)?\s+avond|{PmDescRegex}|avond))|((({ApostrofsRegex}|des)?\s+avonds|deze\s+avond|in\s+de\s+(na)?avond|avond\s+in\s+het\s+begin|avond\s+aan\s+het\s+einde?|{PmDescRegex}|avond)$)";
      public static readonly string NightStartEndRegex = $@"(^(gedurende de nacht|vannacht|nacht|({ApostrofsRegex}|des)?\s+nachts))|((gedurende\s+de\s+nacht|vannacht|({ApostrofsRegex}|des)?\s+nachts|nacht\s+in\s+het\s+begin|nacht)$)";
      public const string InexactNumberRegex = @"\b((een\s+)?aantal|meerdere|enkele|verscheidene|wat|enige|(?<NumTwoTerm>(een\s+)?paar))\b";
      public static readonly string InexactNumberUnitRegex = $@"({InexactNumberRegex})\s+({DurationUnitRegex})";
      public static readonly string RelativeTimeUnitRegex = $@"((({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+({TimeUnitRegex}))|((de|het|mijn))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string RelativeDurationUnitRegex = $@"(((?<=({NextPrefixRegex}|{PreviousPrefixRegex}|{ThisPrefixRegex})\s+)({DurationUnitRegex}))|((the|my))\s+({RestrictedTimeUnitRegex}))";
      public static readonly string ReferenceDatePeriodRegex = $@"\b{ReferencePrefixRegex}\s+(?<duration>week|maand|jaar|decennium|weekend)\b";
      public const string ConnectorRegex = @"^(-|,|voor|t|rond(om)?|@)$";
      public const string FromToRegex = @"\b(van(af)?).+(tot)\b.+";
      public const string SingleAmbiguousMonthRegex = @"^(de\s+)?(mei)$";
      public const string SingleAmbiguousTermsRegex = @"^(de\s+)?(dag|week|maand|jaar)$";
      public const string UnspecificDatePeriodRegex = @"^(week|weekend|maand|jaar)$";
      public const string PrepositionSuffixRegex = @"\b((op|in)(\s+de)?|om|rond(om)?|van|tot)$";
      public const string FlexibleDayRegex = @"(?<DayOfMonth>([A-Za-zë]+\s+)?[A-Za-zë\d]+?\s*(ste|de|e))";
      public static readonly string ForTheRegex = $@"\b((((?<=voor\s+)de\s+{FlexibleDayRegex})|((?<=op\s+)de\s+{FlexibleDayRegex}(?<=(ste|de|e))))(?<end>(\s+(tussen|binnen|terug|tegen|aan|uit|mee|bij|vol|uit|aan|op|in|na|af)\s*)?(\s+(ge\w\w\w+|\w\w\w+en)\s*)?(,|\.|!|\?|$)))";
      public static readonly string WeekDayAndDayOfMonthRegex = $@"\b{WeekDayRegex}\s+(de\s+{FlexibleDayRegex})\b";
      public static readonly string WeekDayAndDayRegex = $@"\b{WeekDayRegex}\s+{DayRegex}(?!([-]|:\d+|\.\d+|(\s+({AmDescRegex}|{PmDescRegex}|{OclockRegex}))))\b";
      public const string RestOfDateRegex = @"\brest\s+(van\s+)?((de|het|mijn|dit|deze|(de\s+)?huidige)\s+)?(?<duration>week|maand|jaar|decennium)\b";
      public const string RestOfDateTimeRegex = @"\brest\s+(van\s+)?((de|het|mijn|dit|deze|(de\s+)?huidige)\s+)?(?<unit>vandaag|dag)\b";
      public const string MealTimeRegex = @"\b((((tijdens\s+)?de|het)\s+)?(?<mealTime>ontbijt|lunch|avondeten)|((om|tegen|tijdens)\s+)?(?<mealTime>lunchtijd))\b";
      public const string AmbiguousRangeModifierPrefix = @"(voor)";
      public static readonly string PotentialAmbiguousRangeRegex = $@"\b{AmbiguousRangeModifierPrefix}(?!\s+het\s+(einde?|begin(nen)?))(.+\b(boven|later|groter|erna|daarna|hoger|(?<!de\s+)({DateUnitRegex}|uur|uren|minuten|minuut|mins|min|secondes|seconden|secs|sec|nacht(en)?)|van(af)?|beginnend|die\s+begint|startend|aanvangend|tussen|tot(dat|\s+en\s+met)?|gedurende|tijdens|ten tijde van|(?<ambiguous>{BaseDateTime.RangeConnectorSymbolRegex}))\b)";
      public static readonly string NumberEndingPattern = $@"^(\s+((?<meeting>vergadering|afspraak|conferentie|telefoontje|skype-gesprek)\s+)?(om|naar)\s+(?<newTime>{PeriodHourNumRegex}|{HourRegex})((\.)?$|(\.,|,|!|\?)))";
      public const string OneOnOneRegex = @"\b(1\s*:\s*1)|(één\s+(op\s)één|één\s*-\s*één|één\s*:\s*één)\b";
      public static readonly string LaterEarlyPeriodRegex = $@"\b({PrefixPeriodRegex})\s*\b\s*(?<suffix>{OneWordPeriodRegex}|(?<FourDigitYear>{BaseDateTime.FourDigitYearRegex}))\b";
      public static readonly string WeekWithWeekDayRangeRegex = $@"\b((?<week>({NextPrefixRegex}|{PreviousPrefixRegex}|deze)\s+week)((\s+tussen\s+{WeekDayRegex}\s+en\s+{WeekDayRegex})|(\s+van\s+{WeekDayRegex}\s+tot\s+{WeekDayRegex})))\b";
      public const string GeneralEndingRegex = @"^\s*((\.,)|\.|,|!|\?)?\s*$";
      public const string MiddlePauseRegex = @"\s*(,)\s*";
      public const string DurationConnectorRegex = @"^\s*(?<connector>\s+|en|,)\s*$";
      public const string PrefixArticleRegex = @"\bde\s+";
      public const string OrRegex = @"\s*((\b|,\s*)(of|en)\b|,)\s*";
      public static readonly string YearPlusNumberRegex = $@"\b(jaar\s+((?<year>(\d{{3,4}}))|{FullTextYearRegex}))\b";
      public static readonly string NumberAsTimeRegex = $@"\b({WrittenTimeRegex}|{PeriodHourNumRegex}|{BaseDateTime.HourRegex})\b";
      public static readonly string TimeBeforeAfterRegex = $@"\b(((?<=\b(voor|niet later dan|na|door)\s+)({WrittenTimeRegex}|{HourNumRegex}|{BaseDateTime.HourRegex}|{MidTimeRegex}))|{MidTimeRegex})\b";
      public const string DateNumberConnectorRegex = @"^\s*(?<connector>\s+om)\s*$";
      public const string DecadeRegex = @"(?<decade>(nul|tien|twintig|dertig|veertig|vijftig|zestig|zeventig|tachtig|negentig)|(fifties|sixties|seventies|eighties|nineties|zeroes|tens|tweeduizend|(ee|éé)nentwintigste\s+eeuw))";
      public static readonly string DecadeWithCenturyRegex = $@"\b(de\s+)?(jaren\s+)?((?<!\$)((?<=\b(de|jaren)\s+)(?<century>1\d|2\d|\d)?({ApostrofRegex})?(?<decade>\d0)({ApostrofRegex})?s?)(?!%)\b|(({CenturyRegex}(\s+|-)?(en\s+)?|(?<=\b(de|jaren)\s+)){DecadeRegex})|({CenturyRegex}(\s+|-)?(en\s+)?(?<decade>tien|honderd)))";
      public static readonly string RelativeDecadeRegex = $@"\b(((de|het)\s+)?{RelativeRegex}\s+((?<number>[\w,]+)\s+)?decenni(a|um)?)\b";
      public const string SuffixAfterRegex = @"\b(((bij)\s)?(of|en)\s+(boven|later|groter|erna|daarna|hoger)(?!\s+dan))\b";
      public const string DateAfterRegex = @"\b((of|en)\s+(hoger|later|groter)(?!\s+dan))\b";
      public static readonly string YearPeriodRegex = $@"((((van(af)?|tijdens|gedurende|in)\s+)?{YearRegex}\s*({TillRegex})\s*{YearRegex})|(((tussen)\s+){YearRegex}\s*({RangeConnectorRegex})\s*{YearRegex}))";
      public const string StartMiddleEndRegex = @"\b((?<StartOf>(((de|het)\s+)?(start|begin)\s+van\s+)?)(?<MiddleOf>((het\s+)?midden\s+van\s+)?)(?<EndOf>((het\s+)?einde?\s+van\s+)?))";
      public static readonly string ComplexDatePeriodRegex = $@"(((van(af)?|tijdens|gedurende|in(\s+de)?)\s+)?{StartMiddleEndRegex}(?<start>.+)\s*({TillRegex})\s*{StartMiddleEndRegex}(?<end>.+)|((tussen)\s+){StartMiddleEndRegex}(?<start>.+)\s*({RangeConnectorRegex})\s*{StartMiddleEndRegex}(?<end>.+)|(?<start>{WrittenMonthRegex})\s+(?<end>{WrittenMonthRegex}(\s+|\s*,\s*){YearRegex}))";
      public static readonly string ComplexTillRegex = $@"({TillRegex}|{WrittenMonthRegex})";
      public static readonly Dictionary<string, string> UnitMap = new Dictionary<string, string>
        {
            { @"millennium", @"1000Y" },
            { @"eeuw", @"100Y" },
            { @"centennium", @"100Y" },
            { @"decennium", @"10Y" },
            { @"decennia", @"10Y" },
            { @"jaren", @"Y" },
            { @"jaar", @"Y" },
            { @"jr", @"Y" },
            { @"maanden", @"MON" },
            { @"maand", @"MON" },
            { @"mnd", @"MON" },
            { @"weken", @"W" },
            { @"week", @"W" },
            { @"weekend", @"WE" },
            { @"weekenden", @"WE" },
            { @"dagen", @"D" },
            { @"dag", @"D" },
            { @"werkdagen", @"D" },
            { @"werkdag", @"D" },
            { @"weekdagen", @"D" },
            { @"weekdag", @"D" },
            { @"vandaag", @"D" },
            { @"dgn", @"D" },
            { @"nachten", @"D" },
            { @"nacht", @"D" },
            { @"uren", @"H" },
            { @"uur", @"H" },
            { @"u", @"H" },
            { @"minuten", @"M" },
            { @"minuut", @"M" },
            { @"min", @"M" },
            { @"min.", @"M" },
            { @"secondes", @"S" },
            { @"seconden", @"S" },
            { @"seconde", @"S" },
            { @"secs", @"S" },
            { @"sec", @"S" },
            { @"kwartier", @"H" },
            { @"kwartier uur", @"H" },
            { @"halfuur", @"H" }
        };
      public static readonly Dictionary<string, long> UnitValueMap = new Dictionary<string, long>
        {
            { @"decennium", 315360000 },
            { @"decennia", 315360000 },
            { @"decenniën", 315360000 },
            { @"jaren", 31536000 },
            { @"jaar", 31536000 },
            { @"jr", 31536000 },
            { @"maanden", 2592000 },
            { @"maand", 2592000 },
            { @"mnd", 2592000 },
            { @"weken", 604800 },
            { @"week", 604800 },
            { @"weekenden", 172800 },
            { @"weekend", 172800 },
            { @"dagen", 86400 },
            { @"dag", 86400 },
            { @"vandaag", 86400 },
            { @"dgn", 86400 },
            { @"nachten", 86400 },
            { @"nacht", 86400 },
            { @"werkdagen", 86400 },
            { @"werkdag", 86400 },
            { @"weekdagen", 86400 },
            { @"weekdag", 86400 },
            { @"uren", 3600 },
            { @"uur", 3600 },
            { @"u", 3600 },
            { @"minuten", 60 },
            { @"minuut", 60 },
            { @"min", 60 },
            { @"min.", 60 },
            { @"secondes", 1 },
            { @"seconden", 1 },
            { @"seconde", 1 },
            { @"secs", 1 },
            { @"sec", 1 },
            { @"kwartier", 3600 },
            { @"kwartier uur", 3600 },
            { @"halfuur", 3600 }
        };
      public static readonly Dictionary<string, string> SpecialYearPrefixesMap = new Dictionary<string, string>
        {
            { @"", @"" }
        };
      public static readonly Dictionary<string, string> SeasonMap = new Dictionary<string, string>
        {
            { @"lente", @"SP" },
            { @"zomer", @"SU" },
            { @"herfst", @"FA" },
            { @"winter", @"WI" }
        };
      public static readonly Dictionary<string, int> SeasonValueMap = new Dictionary<string, int>
        {
            { @"SP", 3 },
            { @"SU", 6 },
            { @"FA", 9 },
            { @"WI", 12 }
        };
      public static readonly Dictionary<string, int> CardinalMap = new Dictionary<string, int>
        {
            { @"eerste", 1 },
            { @"1e", 1 },
            { @"1ste", 1 },
            { @"tweede", 2 },
            { @"2e", 2 },
            { @"2de", 2 },
            { @"derde", 3 },
            { @"3e", 3 },
            { @"3de", 3 },
            { @"vierde", 4 },
            { @"4e", 4 },
            { @"4de", 4 },
            { @"vijfde", 5 },
            { @"5e", 5 },
            { @"5de", 5 }
        };
      public static readonly Dictionary<string, int> DayOfWeek = new Dictionary<string, int>
        {
            { @"maandag", 1 },
            { @"dinsdag", 2 },
            { @"woensdag", 3 },
            { @"donderdag", 4 },
            { @"vrijdag", 5 },
            { @"zaterdag", 6 },
            { @"zondag", 0 },
            { @"zondagmiddag", 0 },
            { @"maandagen", 1 },
            { @"dinsdagen", 2 },
            { @"woensdagen", 3 },
            { @"donderdagen", 4 },
            { @"vrijdagen", 5 },
            { @"zaterdagen", 6 },
            { @"zondagen", 0 },
            { @"ma", 1 },
            { @"ma.", 1 },
            { @"dins", 2 },
            { @"dins.", 2 },
            { @"woens", 3 },
            { @"woens.", 3 },
            { @"di", 2 },
            { @"di.", 2 },
            { @"wo", 3 },
            { @"wo.", 3 },
            { @"woe", 3 },
            { @"woe.", 3 },
            { @"do", 4 },
            { @"do.", 4 },
            { @"vr", 5 },
            { @"vr.", 5 },
            { @"vrij", 5 },
            { @"vrij.", 5 },
            { @"za", 6 },
            { @"za.", 6 },
            { @"zat", 6 },
            { @"zat.", 6 },
            { @"zo", 0 },
            { @"zo.", 0 },
            { @"zon", 0 },
            { @"zon.", 0 },
            { @"monday", 1 },
            { @"tuesday", 2 },
            { @"wednesday", 3 },
            { @"thursday", 4 },
            { @"friday", 5 },
            { @"saturday", 6 },
            { @"sunday", 0 },
            { @"mon", 1 },
            { @"tue", 2 },
            { @"tues", 2 },
            { @"wed", 3 },
            { @"wedn", 3 },
            { @"weds", 3 },
            { @"thu", 4 },
            { @"thur", 4 },
            { @"thurs", 4 },
            { @"fri", 5 },
            { @"sat", 6 },
            { @"sun", 0 }
        };
      public static readonly Dictionary<string, int> MonthOfYear = new Dictionary<string, int>
        {
            { @"januari", 1 },
            { @"februari", 2 },
            { @"maart", 3 },
            { @"april", 4 },
            { @"mei", 5 },
            { @"juni", 6 },
            { @"juli", 7 },
            { @"augustus", 8 },
            { @"september", 9 },
            { @"oktober", 10 },
            { @"november", 11 },
            { @"december", 12 },
            { @"jan", 1 },
            { @"feb", 2 },
            { @"mar", 3 },
            { @"mrt", 3 },
            { @"apr", 4 },
            { @"jun", 6 },
            { @"jul", 7 },
            { @"aug", 8 },
            { @"sep", 9 },
            { @"sept", 9 },
            { @"oct", 10 },
            { @"okt", 10 },
            { @"nov", 11 },
            { @"dec", 12 },
            { @"jan.", 1 },
            { @"feb.", 2 },
            { @"mar.", 3 },
            { @"mrt.", 3 },
            { @"apr.", 4 },
            { @"jun.", 6 },
            { @"jul.", 7 },
            { @"aug.", 8 },
            { @"sep.", 9 },
            { @"sept.", 9 },
            { @"oct.", 10 },
            { @"okt.", 10 },
            { @"nov.", 11 },
            { @"dec.", 12 },
            { @"1", 1 },
            { @"2", 2 },
            { @"3", 3 },
            { @"4", 4 },
            { @"5", 5 },
            { @"6", 6 },
            { @"7", 7 },
            { @"8", 8 },
            { @"9", 9 },
            { @"10", 10 },
            { @"11", 11 },
            { @"12", 12 },
            { @"01", 1 },
            { @"02", 2 },
            { @"03", 3 },
            { @"04", 4 },
            { @"05", 5 },
            { @"06", 6 },
            { @"07", 7 },
            { @"08", 8 },
            { @"09", 9 }
        };
      public static readonly Dictionary<string, int> Numbers = new Dictionary<string, int>
        {
            { @"nul", 0 },
            { @"een", 1 },
            { @"één", 1 },
            { @"twee", 2 },
            { @"drie", 3 },
            { @"vier", 4 },
            { @"vijf", 5 },
            { @"zes", 6 },
            { @"zeven", 7 },
            { @"acht", 8 },
            { @"negen", 9 },
            { @"tien", 10 },
            { @"elf", 11 },
            { @"elven", 11 },
            { @"twaalf", 12 },
            { @"dertien", 13 },
            { @"veertien", 14 },
            { @"vijftien", 15 },
            { @"zestien", 16 },
            { @"zeventien", 17 },
            { @"achttien", 18 },
            { @"negentien", 19 },
            { @"twintig", 20 },
            { @"eenentwintig", 21 },
            { @"éénentwintig", 21 },
            { @"tweeentwintig", 22 },
            { @"tweeëntwintig", 22 },
            { @"drieëntwintig", 23 },
            { @"vierentwintig", 24 },
            { @"vijfentwintig", 25 },
            { @"vijventwintig", 25 },
            { @"zesentwintig", 26 },
            { @"zevenentwintig", 27 },
            { @"achtentwintig", 28 },
            { @"negenentwintig", 29 },
            { @"dertig", 30 },
            { @"eenendertig", 31 },
            { @"tweeëndertig", 32 },
            { @"drieëndertig", 33 },
            { @"vierendertig", 34 },
            { @"vijfendertig", 35 },
            { @"zesendertig", 36 },
            { @"zevenendertig", 37 },
            { @"achtendertig", 38 },
            { @"negenendertig", 39 },
            { @"veertig", 40 },
            { @"eenenveertig", 41 },
            { @"tweeënveertig", 42 },
            { @"drieënveertig", 43 },
            { @"vierenveertig", 44 },
            { @"vijfenveertig", 45 },
            { @"zesenveertig", 46 },
            { @"zevenenveertig", 47 },
            { @"achtenveertig", 48 },
            { @"negenenveertig", 49 },
            { @"eenenvijftig", 50 },
            { @"vijftig", 51 },
            { @"tweeënvijftig", 52 },
            { @"drieënvijftig", 53 },
            { @"vierenvijftig", 54 },
            { @"vijfenvijftig", 55 },
            { @"zesenvijftig", 56 },
            { @"zevenenvijftig", 57 },
            { @"achtenvijftig", 58 },
            { @"negenenvijftig", 59 },
            { @"zestig", 60 },
            { @"eenenzestig", 61 },
            { @"tweeënzestig", 62 },
            { @"drieënzestig", 63 },
            { @"vierenzestig", 64 },
            { @"vijfenzestig", 65 },
            { @"zesenzestig", 66 },
            { @"zevenenzestig", 67 },
            { @"achtenzestig", 68 },
            { @"negenenzestig", 69 },
            { @"zeventig", 70 },
            { @"eenenzeventig", 71 },
            { @"tweeënzeventig", 72 },
            { @"drieënzeventig", 73 },
            { @"vierenzeventig", 74 },
            { @"vijfenzeventig", 75 },
            { @"zesenzeventig", 76 },
            { @"zevenenzeventig", 77 },
            { @"achtenzeventig", 78 },
            { @"negenenzeventig", 79 },
            { @"tachtig", 80 },
            { @"eenentachtig", 81 },
            { @"tweeëntachtig", 82 },
            { @"drieëntachtig", 83 },
            { @"vierentachtig", 84 },
            { @"vijfentachtig", 85 },
            { @"zesentachtig", 86 },
            { @"zevenentachtig", 87 },
            { @"achtentachtig", 88 },
            { @"negenentachtig", 89 },
            { @"negentig", 90 },
            { @"eenennegentig", 91 },
            { @"tweeënnegentig", 92 },
            { @"drieënnegentig", 93 },
            { @"vierennegentig", 94 },
            { @"vijfennegentig", 95 },
            { @"zesennegentig", 96 },
            { @"zevenennegentig", 97 },
            { @"achtennegentig", 98 },
            { @"negenennegentig", 99 },
            { @"honderd", 100 }
        };
      public static readonly Dictionary<string, int> DayOfMonth = new Dictionary<string, int>
        {
            { @"1e", 1 },
            { @"1ste", 1 },
            { @"2e", 2 },
            { @"2de", 2 },
            { @"3e", 3 },
            { @"3de", 3 },
            { @"4e", 4 },
            { @"4de", 4 },
            { @"5e", 5 },
            { @"5de", 5 },
            { @"6e", 6 },
            { @"6de", 6 },
            { @"7e", 7 },
            { @"7de", 7 },
            { @"8e", 8 },
            { @"8de", 8 },
            { @"9e", 9 },
            { @"9de", 9 },
            { @"10e", 10 },
            { @"10de", 10 },
            { @"11e", 11 },
            { @"11de", 11 },
            { @"12e", 12 },
            { @"12de", 12 },
            { @"13e", 13 },
            { @"13de", 13 },
            { @"14e", 14 },
            { @"14de", 14 },
            { @"15e", 15 },
            { @"15de", 15 },
            { @"16e", 16 },
            { @"16de", 16 },
            { @"17e", 17 },
            { @"17de", 17 },
            { @"18e", 18 },
            { @"19e", 19 },
            { @"20e", 20 },
            { @"21e", 21 },
            { @"22e", 22 },
            { @"23e", 23 },
            { @"24e", 24 },
            { @"25e", 25 },
            { @"26e", 26 },
            { @"27e", 27 },
            { @"28e", 28 },
            { @"29e", 29 },
            { @"30e", 30 },
            { @"31e", 31 }
        };
      public static readonly Dictionary<string, double> DoubleNumbers = new Dictionary<string, double>
        {
            { @"half", 0.5 },
            { @"anderhalf", 1.5 },
            { @"anderhalve", 1.5 },
            { @"halve", 0.5 },
            { @"een kwartier", 0.25 },
            { @"kwartier", 0.25 },
            { @"kwart", 0.25 },
            { @"driekwart", 0.75 },
            { @"drie kwart", 0.75 },
            { @"kwartaal", 0.25 }
        };
      public static readonly Dictionary<string, IEnumerable<string>> HolidayNames = new Dictionary<string, IEnumerable<string>>
        {
            { @"kingsday", new string[] { @"koningsdag" } },
            { @"queensday", new string[] { @"koninginnedag" } },
            { @"prinsjesdag", new string[] { @"prinsjesdag" } },
            { @"dodenherdenking", new string[] { @"nationaledodenherdenking", @"nationaleherdenking", @"dodenherdenking" } },
            { @"bevrijdingsdag", new string[] { @"bevrijdingsdag" } },
            { @"teachersday", new string[] { @"dagvandeleraar", @"dagvandeleerkracht", @"dagvandeleerkrachten" } },
            { @"veteransday", new string[] { @"nederlandseveteranendag", @"veteranendag" } },
            { @"eerstekerstdag", new string[] { @"eerstekerstdag", @"1ekerstdag" } },
            { @"tweedekerstdag", new string[] { @"tweedekerstdag", @"2ekerstdag" } },
            { @"dagvandearbeid", new string[] { @"dagvandearbeid", @"feestvandearbeid" } },
            { @"treeplantingday", new string[] { @"nationaleboomfeestdag", @"boomfeestdag", @"boomplantdag" } },
            { @"sinterklaas", new string[] { @"sinterklaas", @"sinterklaasavond", @"sinterklaasfeest", @"pakjesavond" } },
            { @"driekoningen", new string[] { @"driekoningen" } },
            { @"ketikoti", new string[] { @"ketikoti", @"keti-koti" } },
            { @"stmartinsday", new string[] { @"sint-maartensfeest", @"sint-maarten" } },
            { @"ascensionday", new string[] { @"hemelvaartsdag" } },
            { @"whitesunday", new string[] { @"pinksteren" } },
            { @"christmas", new string[] { @"kerstfeest", @"kerstmis", @"kerst", @"xmas" } },
            { @"easterday", new string[] { @"pasen", @"eerstepaasdag", @"paasdag", @"paaszondag" } },
            { @"eastermonday", new string[] { @"tweedepaasdag", @"paasmaandag" } },
            { @"fathers", new string[] { @"vaderdag" } },
            { @"goodfriday", new string[] { @"goedevrijdag" } },
            { @"mothers", new string[] { @"moederdag" } },
            { @"newyear", new string[] { @"nieuwjaar" } },
            { @"newyearday", new string[] { @"nieuwjaarsdag" } },
            { @"newyearsday", new string[] { @"nieuwjaarsdag" } },
            { @"newyeareve", new string[] { @"oudjaar", @"oudejaar", @"oudejaarsavond", @"oudjaarsavond", @"silvester", @"silvesteravond", @"oudennieuw", @"oud&nieuw" } },
            { @"valentinesday", new string[] { @"valentijnsdag", @"valetijnsdag" } },
            { @"independenceday", new string[] { @"onafhankelijkheidsdag", @"onafhankelijksdag" } },
            { @"bastilleday", new string[] { @"fransenationalefeestdag", @"bestormingvandebastille" } },
            { @"halloweenday", new string[] { @"halloween", @"allerheiligenavond" } },
            { @"allhallowday", new string[] { @"allerheiligen" } },
            { @"allsoulsday", new string[] { @"allerzielen" } },
            { @"christmaseve", new string[] { @"kerstavond" } },
            { @"yuandan", new string[] { @"yuandan" } },
            { @"chinesenewyear", new string[] { @"chineesnieuwjaar", @"lentefestival", @"lentefeest" } },
            { @"ramadan", new string[] { @"ramadan" } },
            { @"eidalfitr", new string[] { @"eidalfitr", @"suikerfeest" } },
            { @"sacrifice", new string[] { @"eidaladha", @"offerfeest" } },
            { @"islamicnewyear", new string[] { @"islamitischnieuwjaar" } },
            { @"thanksgiving", new string[] { @"thanksgivingday", @"thanksgiving", @"dankzeggingsdag" } },
            { @"martinlutherking", new string[] { @"martinlutherkingday", @"martinlutherkingjrday", @"martinlutherkingdag", @"mlkdag" } },
            { @"usindependenceday", new string[] { @"amerikaanseonafhankelijkheidsdag", @"usonafhankelijkheidsdag" } },
            { @"blackfriday", new string[] { @"blackfriday" } },
            { @"cybermonday", new string[] { @"cybermonday" } },
            { @"earthday", new string[] { @"dagvandeaarde" } },
            { @"juneteenth", new string[] { @"jubileeday", @"juneteenth", @"vrijheidsdag" } }
        };
      public static readonly Dictionary<string, int> WrittenDecades = new Dictionary<string, int>
        {
            { @"jaren 0", 0 },
            { @"jaren nul", 0 },
            { @"jaren 10", 10 },
            { @"jaren tien", 10 },
            { @"jaren 20", 20 },
            { @"jaren twintig", 20 },
            { @"twintiger jaren", 20 },
            { @"jaren 30", 30 },
            { @"jaren dertig", 30 },
            { @"dertiger jaren", 30 },
            { @"jaren 40", 40 },
            { @"jaren veertig", 40 },
            { @"veertiger jaren", 40 },
            { @"jaren 50", 50 },
            { @"jaren vijftig", 50 },
            { @"vijftiger jaren", 50 },
            { @"jaren 60", 60 },
            { @"jaren zestig", 60 },
            { @"zestiger jaren", 60 },
            { @"jaren 70", 70 },
            { @"jaren zeventig", 70 },
            { @"zeventiger jaren", 70 },
            { @"jaren 80", 80 },
            { @"jaren tachtig", 80 },
            { @"tachtiger jaren", 80 },
            { @"jaren 90", 90 },
            { @"jaren negentig", 90 },
            { @"nul", 0 },
            { @"tien", 10 },
            { @"twintig", 20 },
            { @"twintiger", 20 },
            { @"dertig", 30 },
            { @"dertiger", 30 },
            { @"veertig", 40 },
            { @"veertiger", 40 },
            { @"vijftig", 50 },
            { @"vijftiger", 50 },
            { @"zestig", 60 },
            { @"zestiger", 60 },
            { @"zeventig", 70 },
            { @"zeventiger", 70 },
            { @"tachtig", 80 },
            { @"tachtiger", 80 },
            { @"negentig", 90 },
            { @"negentiger", 90 },
            { @"honderd", 0 }
        };
      public static readonly Dictionary<string, int> SpecialDecadeCases = new Dictionary<string, int>
        {
            { @"21e eeuw", 2000 },
            { @"eenentwintigste eeuw", 2000 },
            { @"tweeduizend", 2000 },
            { @"jaren nul", 0 },
            { @"nul", 0 }
        };
      public const string DefaultLanguageFallback = @"DMY";
      public static readonly IList<string> SuperfluousWordList = new List<string>
        {
            @"preferably",
            @"how about",
            @"maybe",
            @"say",
            @"like"
        };
      public static readonly string[] DurationDateRestrictions = { @"vandaag", @"nu" };
      public static readonly Dictionary<string, string> AmbiguityFiltersDict = new Dictionary<string, string>
        {
            { @"^\d{4}$", @"(\d\.\d{4}|\d{4}\.\d)" },
            { @"\b(ontbijt|lunch|avondeten)$", @"(?<!\b(op|om|voor|na(ar)?|rond)(\s+(het|de))?\s+)(ontbijt|lunch|avondeten)" },
            { @"^(morgen|middag|avond|nacht|dag)\b", @"\b(goe[di]en?\s*(morgen|middag|avond|nacht|dag))\b" },
            { @"^\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}" },
            { @"^\d{1,4}-\d{1,4}-\d{1,4}$", @"\d{1,4}-\d{1,4}-\d{1,4}-\d|\d-\d{1,4}-\d{1,4}-\d{1,4}" }
        };
      public static readonly Dictionary<string, string> AmbiguityTimeFiltersDict = new Dictionary<string, string>
        {
            { @"^(\d{1,2}|\p{L}+)\s+uur$", @"(?<LB>(?<!\b(om|is|vanaf|morgen|vandaag|gisteren|\d+)(\s+(\d{1,2}|\p{L}+)\s+uur\s+(of|en))?\s+)\b(\d{1,2}|\p{L}+)\s+uur\b)(?(LB)(?!\s+(tot|morgen|vandaag|gisteren|\d+)\b))" }
        };
      public static readonly IList<string> MorningTermList = new List<string>
        {
            @"morgen",
            @"morgens",
            @"ochtend",
            @"ochtends"
        };
      public static readonly IList<string> AfternoonTermList = new List<string>
        {
            @"middag",
            @"namiddag",
            @"voormiddag"
        };
      public static readonly IList<string> EveningTermList = new List<string>
        {
            @"avond",
            @"avonden"
        };
      public static readonly IList<string> MealtimeBreakfastTermList = new List<string>
        {
            @"ontbijt"
        };
      public static readonly IList<string> MealtimeLunchTermList = new List<string>
        {
            @"lunch",
            @"lunchtijd"
        };
      public static readonly IList<string> MealtimeDinnerTermList = new List<string>
        {
            @"avondeten"
        };
      public static readonly IList<string> DaytimeTermList = new List<string>
        {
            @"dag",
            @"overdag"
        };
      public static readonly IList<string> NightTermList = new List<string>
        {
            @"nacht"
        };
      public static readonly IList<string> SameDayTerms = new List<string>
        {
            @"vandaag",
            @"huidige dag",
            @"huidige datum",
            @"actuele datum",
            @"actuele dag",
            @"deze morgen",
            @"actuele morgen",
            @"vanmorgen"
        };
      public static readonly IList<string> PlusOneDayTerms = new List<string>
        {
            @"morgen",
            @"dag na",
            @"dag erna",
            @"volgende dag",
            @"morgenochtend",
            @"morgenavond"
        };
      public static readonly IList<string> MinusOneDayTerms = new List<string>
        {
            @"gisteren",
            @"dag voor",
            @"dag ervoor",
            @"vorige dag",
            @"gisterenochtend",
            @"gisterenavond"
        };
      public static readonly IList<string> PlusTwoDayTerms = new List<string>
        {
            @"overmorgen",
            @"dag na morgen"
        };
      public static readonly IList<string> MinusTwoDayTerms = new List<string>
        {
            @"eergisteren"
        };
      public static readonly IList<string> FutureTerms = new List<string>
        {
            @"deze",
            @"volgend",
            @"volgende",
            @"eropvolgend",
            @"eropvolgende",
            @"dit",
            @"die"
        };
      public static readonly IList<string> LastCardinalTerms = new List<string>
        {
            @"vorige",
            @"laatste"
        };
      public static readonly IList<string> MonthTerms = new List<string>
        {
            @"maand",
            @"maanden"
        };
      public static readonly IList<string> MonthToDateTerms = new List<string>
        {
            @"maand tot heden",
            @"maand tot op heden",
            @"vanaf vorig maandeinde"
        };
      public static readonly IList<string> WeekendTerms = new List<string>
        {
            @"weekend",
            @"weekenden"
        };
      public static readonly IList<string> WeekTerms = new List<string>
        {
            @"week"
        };
      public static readonly IList<string> YearTerms = new List<string>
        {
            @"jaar",
            @"jaren"
        };
      public static readonly IList<string> GenericYearTerms = new List<string>
        {
            @"j"
        };
      public static readonly IList<string> YearToDateTerms = new List<string>
        {
            @"jaar tot heden",
            @"jaar tot op heden",
            @"vanaf vorig jaareinde"
        };
      public const string DayTypeRegex = @"^((we[er]k)?dag(en|elijkse?)?)$";
      public const string WeekTypeRegex = @"^(wekelijkse?|week)$";
      public const string WeekendTypeRegex = @"^(weekend(en)?)$";
      public const string BiWeekTypeRegex = @"^(tweewekelijkse?)$";
      public const string MonthTypeRegex = @"^(maand(elijkse?)?)$";
      public const string QuarterTypeRegex = @"^(kwartaal|driemaandelijkse?)$";
      public const string YearTypeRegex = @"^(elk\s+jaar|jaar(lijkse?)?)$";
      public const string SemiYearTypeRegex = @"^(halfjaar(lijkse?)?)$";
    }
}