# Introduction

This is a collection of pre-trained models in different deep learning frameworks.

You can download the model you want by simply click the download link.

With the download model, you can convert them to different frameworks.

Next session show an example to show you how to convert pre-trained model between frameworks.

## Steps to Convert Model

**Example: Convert vgg19 model from Tensorflow to CNTK**

1. Install the stable version of MMdnn
    ```bash
    pip install mmdnn
    ```
2. Download Tensorflow pre-trained model
    - [x] **Method 1:** Directly download from below model collection
    - [x] **Method 2:** Use command line
    ```bash
        $ mmdownload -f tensorflow -n vgg19

        Downloading file [./vgg_19_2016_08_28.tar.gz] from [http://download.tensorflow.org/models/vgg_19_2016_08_28.tar.gz]
        progress: 520592.0 KB downloaded, 100%
        Model saved in file: ./imagenet_vgg19.ckpt
    ```
    **NOTICE:** _the model name after the **'-n'** argument must be the models appearence in the below model collection._

3. Convert model architecture(*.ckpt.meta) and weights(.ckpt) from Tensorflow to IR
    ```bash
    $ mmtoir -f tensorflow -d vgg19 -n imagenet_vgg19.ckpt.meta -w imagenet_vgg19.ckpt  --dstNodeName MMdnn_Output

    Parse file [imagenet_vgg19.ckpt.meta] with binary format successfully.
    Tensorflow model file [imagenet_vgg19.ckpt.meta] loaded successfully.
    Tensorflow checkpoint file [imagenet_vgg19.ckpt] loaded successfully. [38] variables loaded.
    IR network structure is saved as [vgg19.json].
    IR network structure is saved as [vgg19.pb].
    IR weights are saved as [vgg19.npy].
    ```
4. Convert models from IR to PyTorch code snippet and weights
    ```bash
    $ mmtocode -f pytorch -n vgg19.pb --IRWeightPath vgg19.npy --dstModelPath pytorch_vgg19.py -dw pytorch_vgg19.npy

    Parse file [vgg19.pb] with binary format successfully.
    Target network code snippet is saved as [pytorch_vgg19.py].
    Target weights are saved as [pytorch_vgg19.npy].
    ```
5. Generate PyTorch model from code snippet file and weight file
    ```bash
    $ mmtomodel -f pytorch -in pytorch_vgg19.py -iw pytorch_vgg19.npy --o pytorch_vgg19.pth

    PyTorch model file is saved as [pytorch_vgg19.pth], generated by [pytorch_vgg19.py] and [pytorch_vgg19.npy].
    Notice that you may need [pytorch_vgg19.py] to load the model back.
    ```


# Model Collection

## Image Classification

### imagenet

| | | |
|-|-|-|
|<b>alexnet</b><br />Framework: caffe<br />Download: [prototxt](https://raw.githubusercontent.com/BVLC/caffe/master/models/bvlc_alexnet/deploy.prototxt) [caffemodel](http://dl.caffe.berkeleyvision.org/bvlc_alexnet.caffemodel) <br />Source: [Link](https://github.com/BVLC/caffe/tree/master/models/bvlc_alexnet)<br />|<b>inception_v1</b><br />Framework: caffe<br />Download: [prototxt](https://raw.githubusercontent.com/BVLC/caffe/master/models/bvlc_googlenet/deploy.prototxt) [caffemodel](http://dl.caffe.berkeleyvision.org/bvlc_googlenet.caffemodel) <br />Source: [Link](https://github.com/BVLC/caffe/tree/master/models/bvlc_googlenet)<br />|<b>vgg16</b><br />Framework: caffe<br />Download: [prototxt](https://gist.githubusercontent.com/ksimonyan/211839e770f7b538e2d8/raw/c3ba00e272d9f48594acef1f67e5fd12aff7a806/VGG_ILSVRC_16_layers_deploy.prototxt) [caffemodel](http://data.mxnet.io/models/imagenet/test/caffe/VGG_ILSVRC_16_layers.caffemodel) <br />Source: [Link](https://gist.github.com/ksimonyan/211839e770f7b538e2d8/)<br />
|<b>vgg19</b><br />Framework: caffe<br />Download: [prototxt](https://gist.githubusercontent.com/ksimonyan/3785162f95cd2d5fee77/raw/bb2b4fe0a9bb0669211cf3d0bc949dfdda173e9e/VGG_ILSVRC_19_layers_deploy.prototxt) [caffemodel](http://data.mxnet.io/models/imagenet/test/caffe/VGG_ILSVRC_19_layers.caffemodel) <br />Source: [Link](https://gist.github.com/ksimonyan/3785162f95cd2d5fee77)<br />|<b>resnet50</b><br />Framework: caffe<br />Download: [prototxt](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-50-deploy.prototxt) [caffemodel](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-50-model.caffemodel) <br />Source: [Link](http://data.mxnet.io/models/imagenet/test/caffe/)<br />|<b>resnet101</b><br />Framework: caffe<br />Download: [prototxt](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-101-deploy.prototxt) [caffemodel](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-101-model.caffemodel) <br />Source: [Link](http://data.mxnet.io/models/imagenet/test/caffe/)<br />
|<b>resnet152</b><br />Framework: caffe<br />Download: [prototxt](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-152-deploy.prototxt) [caffemodel](http://data.mxnet.io/models/imagenet/test/caffe/ResNet-152-model.caffemodel) <br />Source: [Link](http://data.mxnet.io/models/imagenet/test/caffe/)<br />|<b>squeezenet</b><br />Framework: caffe<br />Download: [prototxt](https://raw.githubusercontent.com/DeepScale/SqueezeNet/master/SqueezeNet_v1.1/deploy.prototxt) [caffemodel](https://github.com/DeepScale/SqueezeNet/raw/master/SqueezeNet_v1.1/squeezenet_v1.1.caffemodel) <br />Source: [Link](https://github.com/DeepScale/SqueezeNet/tree/master/SqueezeNet_v1.1)<br />|<b>xception</b><br />Framework: caffe<br />Download: [prototxt](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/xception_deploy.prototxt) [caffemodel](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/xception.caffemodel) <br />Source: <br />
|<b>inception_v4</b><br />Framework: caffe<br />Download: [prototxt](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/inception-v4_deploy.prototxt) [caffemodel](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/inception-v4.caffemodel) <br />Source: <br />|<b>alexnet</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/AlexNet_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />|<b>inception_v3</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/InceptionV3_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />
|<b>resnet18</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/ResNet18_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />|<b>resnet50</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/ResNet50_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />|<b>resnet101</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/ResNet101_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />
|<b>resnet152</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/CNTK_Pretrained/ResNet152_ImageNet_CNTK.model) <br />Source: [Link](https://github.com/Microsoft/CNTK/blob/master/PretrainedModels/Image.md#alexnet)<br />|<b>inception_v3</b><br />Framework: coreml<br />Download: [mlmodel](https://docs-assets.developer.apple.com/coreml/models/Inceptionv3.mlmodel) <br />Source: <br />|<b>vgg16</b><br />Framework: coreml<br />Download: [mlmodel](https://docs-assets.developer.apple.com/coreml/models/VGG16.mlmodel) <br />Source: [Link](https://developer.apple.com/machine-learning/build-run-models/)<br />
|<b>resnet50</b><br />Framework: coreml<br />Download: [mlmodel](https://docs-assets.developer.apple.com/coreml/models/Resnet50.mlmodel) <br />Source: [Link](https://developer.apple.com/machine-learning/build-run-models/)<br />|<b>mobilenet</b><br />Framework: coreml<br />Download: [mlmodel](https://docs-assets.developer.apple.com/coreml/models/MobileNet.mlmodel) <br />Source: [Link](https://developer.apple.com/machine-learning/build-run-models/)<br />|<b>imagenet1k-inception-bn</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/inception-bn/Inception-BN-symbol.json) [params](http://data.mxnet.io/models/imagenet/inception-bn/Inception-BN-0126.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />
|<b>imagenet1k-resnet-18</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnet/18-layers/resnet-18-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnet/18-layers/resnet-18-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet1k-resnet-34</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnet/34-layers/resnet-34-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnet/34-layers/resnet-34-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet1k-resnet-50</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnet/50-layers/resnet-50-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnet/50-layers/resnet-50-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />
|<b>imagenet1k-resnet-101</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnet/101-layers/resnet-101-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnet/101-layers/resnet-101-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet1k-resnet-152</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnet/152-layers/resnet-152-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnet/152-layers/resnet-152-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet1k-resnext-50</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnext/50-layers/resnext-50-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnext/50-layers/resnext-50-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />
|<b>imagenet1k-resnext-101</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnext/101-layers/resnext-101-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnext/101-layers/resnext-101-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet1k-resnext-101-64x4d</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/resnext/101-layers/resnext-101-64x4d-symbol.json) [params](http://data.mxnet.io/models/imagenet/resnext/101-layers/resnext-101-64x4d-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>vgg19</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/vgg/vgg19-symbol.json) [params](http://data.mxnet.io/models/imagenet/vgg/vgg19-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />
|<b>vgg16</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/vgg/vgg16-symbol.json) [params](http://data.mxnet.io/models/imagenet/vgg/vgg16-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>squeezenet_v1.0</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/squeezenet/squeezenet_v1.0-symbol.json) [params](http://data.mxnet.io/models/imagenet/squeezenet/squeezenet_v1.0-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>squeezenet_v1.1</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet/squeezenet/squeezenet_v1.1-symbol.json) [params](http://data.mxnet.io/models/imagenet/squeezenet/squeezenet_v1.1-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />
|<b>alexnet</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/alexnet-owt-4df8aa71.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/alexnet.html)<br />|<b>densenet121</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/densenet121-a639ec97.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/densenet.html)<br />|<b>densenet169</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/densenet169-b2777c0a.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/densenet.html)<br />
|<b>densenet201</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/densenet201-c1103571.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/densenet.html)<br />|<b>densenet161</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/densenet161-8d451a50.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/densenet.html)<br />|<b>inception_v3</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/inception_v3_google-1a9a5a14.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/inception.html)<br />
|<b>resnet18</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/resnet18-5c106cde.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/resnet.html)<br />|<b>resnet34</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/resnet34-333f7ec4.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/resnet.html)<br />|<b>resnet50</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/resnet50-19c8e357.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/resnet.html)<br />
|<b>resnet101</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/resnet101-5d3b4d8f.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/resnet.html)<br />|<b>resnet152</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/resnet152-b121ed2d.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/resnet.html)<br />|<b>squeezenet1_0</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/squeezenet1_0-a815701f.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/squeezenet.html)<br />
|<b>squeezenet1_1</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/squeezenet1_1-f364aa15.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/squeezenet.html)<br />|<b>vgg11</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg11-bbd30ac9.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />|<b>vgg13</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg13-c768596a.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />
|<b>vgg16</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg16-397923af.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />|<b>vgg19</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg19-dcbb9e9d.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />|<b>vgg11_bn</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg11_bn-6002323d.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />
|<b>vgg13_bn</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg13_bn-abd245e5.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />|<b>vgg16_bn</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg16_bn-6c64b313.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />|<b>vgg19_bn</b><br />Framework: pytorch<br />Download: [pth](https://download.pytorch.org/models/vgg19_bn-c79401a0.pth) <br />Source: [Link](https://pytorch.org/docs/stable/_modules/torchvision/models/vgg.html)<br />
|<b>vgg16</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/vgg_16_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>vgg19</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/vgg_19_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>inception_v1</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/inception_v1_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
|<b>inception_v1_frozen</b><br />Framework: tensorflow<br />Download: [tgz](https://storage.googleapis.com/download.tensorflow.org/models/inception_v1_2016_08_28_frozen.pb.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>inception_v3</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/inception_v3_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>inception_v3_frozen</b><br />Framework: tensorflow<br />Download: [tgz](https://storage.googleapis.com/download.tensorflow.org/models/inception_v3_2016_08_28_frozen.pb.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
|<b>resnet_v1_50</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/resnet_v1_50_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>resnet_v1_152</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/resnet_v1_152_2016_08_28.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>resnet_v2_50</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/resnet_v2_50_2017_04_14.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
|<b>resnet_v2_152</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/resnet_v2_152_2017_04_14.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>resnet_v2_200</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/resnet_v2_200_2017_04_14.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>mobilenet_v1_1.0</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/mobilenet_v1_1.0_224_2017_06_14.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
|<b>mobilenet_v1_1.0_frozen</b><br />Framework: tensorflow<br />Download: [tgz](https://storage.googleapis.com/download.tensorflow.org/models/mobilenet_v1_1.0_224_frozen.tgz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>mobilenet_v2_1.0_224</b><br />Framework: tensorflow<br />Download: [tgz](https://storage.googleapis.com/mobilenet_v2/checkpoints/mobilenet_v2_1.0_224.tgz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />|<b>inception_resnet_v2</b><br />Framework: tensorflow<br />Download: [tgz](http://download.tensorflow.org/models/inception_resnet_v2_2016_08_30.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
|<b>nasnet-a_large</b><br />Framework: tensorflow<br />Download: [tgz](https://storage.googleapis.com/download.tensorflow.org/models/nasnet-a_large_04_10_2017.tar.gz) <br />Source: [Link](https://github.com/tensorflow/models/tree/master/research/slim#Pretrained)<br />
### imagenet11k

| | | |
|-|-|-|
|<b>imagenet11k-resnet-152</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet-11k/resnet-152/resnet-152-symbol.json) [params](http://data.mxnet.io/models/imagenet-11k/resnet-152/resnet-152-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet11k-place365ch-resnet-152</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet-11k-place365-ch/resnet-152-symbol.json) [params](http://data.mxnet.io/models/imagenet-11k-place365-ch/resnet-152-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />|<b>imagenet11k-place365ch-resnet-50</b><br />Framework: mxnet<br />Download: [json](http://data.mxnet.io/models/imagenet-11k-place365-ch/resnet-50-symbol.json) [params](http://data.mxnet.io/models/imagenet-11k-place365-ch/resnet-50-0000.params) <br />Source: [Link](http://data.mxnet.io/models/imagenet/)<br />

## Object Detection

### Pascal VOC

| | | |
|-|-|-|
|<b>voc-fcn8s</b><br />Framework: caffe<br />Download: [prototxt](https://raw.githubusercontent.com/shelhamer/fcn.berkeleyvision.org/master/voc-fcn8s/deploy.prototxt) [caffemodel](http://dl.caffe.berkeleyvision.org/fcn8s-heavy-pascal.caffemodel) <br />Source: [Link](https://github.com/shelhamer/fcn.berkeleyvision.org)<br />|<b>voc-fcn16s</b><br />Framework: caffe<br />Download: [prototxt](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/voc-fcn16s_deploy.prototxt) [caffemodel](http://dl.caffe.berkeleyvision.org/fcn16s-heavy-pascal.caffemodel) <br />Source: [Link](https://github.com/shelhamer/fcn.berkeleyvision.org)<br />|<b>voc-fcn32s</b><br />Framework: caffe<br />Download: [prototxt](http://mmdnn.eastasia.cloudapp.azure.com:89/models/caffe/voc-fcn32s_deploy.prototxt) [caffemodel](http://dl.caffe.berkeleyvision.org/fcn32s-heavy-pascal.caffemodel) <br />Source: [Link](https://github.com/shelhamer/fcn.berkeleyvision.org)<br />
|<b>Fast-RCNN_Pascal</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/FRCN_Pascal/Fast-RCNN.model) <br />Source: [Link](https://docs.microsoft.com/en-us/cognitive-toolkit/object-detection-using-fast-r-cnn#train-on-pascal-voc)<br />|<b>tinyyolo</b><br />Framework: coreml<br />Download: [mlmodel](https://s3-us-west-2.amazonaws.com/coreml-models/TinyYOLO.mlmodel) <br />Source: [Link](https://coreml.store/tinyyolo)<br />|<b>yolov3</b><br />Framework: darknet<br />Download: [cfg](https://raw.githubusercontent.com/pjreddie/darknet/master/cfg/yolov3.cfg) [weights](https://pjreddie.com/media/files/yolov3.weights) <br />Source: [Link](https://pjreddie.com/darknet/yolo/)<br />
|<b>yolov2</b><br />Framework: darknet<br />Download: [cfg](https://raw.githubusercontent.com/pjreddie/darknet/master/cfg/yolov2.cfg) [weights](https://pjreddie.com/media/files/yolov2.weights) <br />Source: [Link](https://pjreddie.com/darknet/yolo/)<br />
### grocery100

| | | |
|-|-|-|
|<b>Fast-RCNN_grocery100</b><br />Framework: cntk<br />Download: [model](https://www.cntk.ai/Models/FRCN_Grocery/Fast-RCNN_grocery100.model) <br />Source: [Link](https://docs.microsoft.com/en-us/cognitive-toolkit/object-detection-using-fast-r-cnn)<br />

