# ONNX README

## Usage

Currently we only implemented the IR -> ONNX part.

We'll take Keras DenseNet121 -> ONNX as an example.

### Pre-request

#### Install TensorFlow

TensorFlow runs as the backend of both Keras and ONNX.

```bash
pip3 install tensorflow
```

See [here](https://www.tensorflow.org/install/) for more infomation.

#### Install Keras

```bash
pip3 install keras
```

See [here](https://keras.io/#installation) for more infomation.

#### Install ONNX frontend and backend

Here we use [ONNX-TensorFlow](https://github.com/onnx/onnx-tensorflow) to install ONNX and its TensorFlow backend.

```bash
pip install onnx-tf
```

#### Install latest MMdnn

As the IR -> ONNX part is not included in the lastest version of MMdnn, we need to install MMdnn master branch:

```bash
git clone https://github.com/Microsoft/MMdnn.git
pip3 install -e MMdnn/
```

#### Install some utilities

```bash
pip3 install pillow
```

### Prepare Keras DenseNet121 model

The code below creates the DenseNet121 model (saved as `densenet121.keras`), and predicts the elephant picture (as below) with the model.

```python
from keras.applications.densenet import DenseNet121
from keras.preprocessing import image
from keras.applications.densenet import preprocess_input, decode_predictions
import numpy as np

model = DenseNet121(include_top=True, weights='imagenet', input_tensor=None,
                    input_shape=None, pooling=None, classes=1000)

model.save('densenet121.keras')

img = image.load_img('elephant.jpg', target_size=(224, 224))
x = image.img_to_array(img)
x = np.expand_dims(x, axis=0)
x = preprocess_input(x)

preds = model.predict(x)

print('Predicted:', decode_predictions(preds, top=3)[0])
```

![Elephant](elephant.jpg)

Here is the output:

```
Predicted: [('n02504458', 'African_elephant', 0.7482961), ('n01871265', 'tusker', 0.17631474), ('n02504013', 'Indian_elephant', 0.0753157)]
```

### Convert DenseNet121 model from Keras to ONNX

Just run the one-step command below:

```bash
mmconvert -sf keras -iw densenet121.keras -df onnx -om densenet121.onnx
```

Here is the output:

```
IR network structure is saved as [77a4c18fc6254078ba4daca924eac3ab.json].
IR network structure is saved as [77a4c18fc6254078ba4daca924eac3ab.pb].
IR weights are saved as [77a4c18fc6254078ba4daca924eac3ab.npy].
Parse file [77a4c18fc6254078ba4daca924eac3ab.pb] with binary format successfully.
Target network code snippet is saved as [77a4c18fc6254078ba4daca924eac3ab.py].
ONNX model file is saved as [densenet121.onnx], generated by [77a4c18fc6254078ba4daca924eac3ab.py] and [77a4c18fc6254078ba4daca924eac3ab.npy].
```

Now you'll find the onnx model file `densenet121.onnx` in your current directory.

### Load and run ONNX DenseNet121 model

```python
import numpy as np
import onnx
from keras.preprocessing import image
from keras.applications.densenet import preprocess_input, decode_predictions
from onnx_tf.backend import prepare


model = onnx.load('densenet121.onnx')
tf_rep = prepare(model)

img = image.load_img('elephant.jpg', target_size=(224, 224))
x = image.img_to_array(img)
x = np.expand_dims(x, axis=0)
x = preprocess_input(x)

predictions = tf_rep.run(x)
preds = predictions[0].reshape((1,1000))

print('Predicted:', decode_predictions(preds, top=3)[0])
```

Here is the output:

```
Predicted: [('n02504458', 'African_elephant', 0.7482961), ('n01871265', 'tusker', 0.17631474), ('n02504013', 'Indian_elephant', 0.0753157)]
```

Is that the same with Keras output?

## Develop version

Ubuntu 16.04 with

- Keras 2.1.6
- onnx-tf 1.1.2
- ONNX 1.2.1

@ 2018/06/09