# Keras README


## Keras pre-trained model

We tested some Keras pre-trained models to others, get more detail from [this file](https://github.com/Microsoft/MMdnn/blob/master/mmdnn/conversion/examples/keras/extractor.py)

|    Models    | Caffe | Keras | Tensorflow | CNTK | MXNet | PyTorch | CoreML | ONNX |
| :----------: | :---: | :---: | :--------: | :--: | :---: | :-----: | :----: | :--: |
|     Vgg16    |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|     Vgg19    |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
| inception_v3 |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|   resnet50   |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|   densenet   |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|   xception   |       |   √   |      √     |      |       |         |    √   |      |
|   mobilenet  |       |   √   |      √     |      |       |         |    √   |   √  |
|    nasnet    |       |   √   |      √     |      |       |         |    √   |      |
|     yolo2    |       |   √   |            |      |       |         |        |   √  |

**√** - Correctness tested

**o** - Some difference after conversion

**space** - not tested

---

# Usage

## Download Keras pre-trained model

```bash
$ mmdownload -f keras

Supported models: set(['resnet50', 'mobilenet', 'vgg19', 'vgg16', 'inception_v3', 'nasnet', 'inception_resnet_v2', 'xception', 'yolo2', 'densenet'])

$ mmdownload -f keras -n resnet50 -o ./

Keras model resnet50 is saved in [./imagenet_resnet50.h5]

```
---

## One-step conversion

Above MMdnn@0.1.4, we provide one command to achieve the conversion

```bash
$ mmconvert -sf keras -iw imagenet_resnet50.h5 -df cntk -om keras_resnet50.dnn
.
.
.
CNTK model file is saved as [keras_resnet50.dnn], generated by [8275ad5170f6441caa0b96a94d467b8e.py] and [8275ad5170f6441caa0b96a94d467b8e.npy].
```

Then you get the CNTK original model *keras_resnet50.dnn* converted from Caffe. Temporal files are removed automatically.

---

## Step-by-step conversion (for debugging)

### Convert architecture from Keras to IR

You can use following bash command to convert the network architecture [*imagenet_inceptionv3.json*] to IR architecture file [*inception_v3.pb*], [*inception_v3.json*]. You can convert only network structure to IR for visualization or training in other frameworks.

```bash
$ mmtoir -f keras -d inception_v3 -n imagenet_inceptionv3.json

Using TensorFlow backend.
IR network structure is saved as [inception_v3.json].
IR network structure is saved as [inception_v3.pb].
Warning: weights are not loaded.
```



### Convert model (including architecture and weights) from Keras to IR

You can use following bash command to convert the network architecture [*imagenet_inceptionv3.json*] with weights [*imagenet_inceptionv3.h5*] to IR architecture file [*inception_v3.pb*], [*inception_v3.json*] and IR weights file [*inception_v3.npy*]

```bash
$ mmtoir -f keras -d inception_v3 -n imagenet_inceptionv3.json -w imagenet_inceptionv3.h5

Using TensorFlow backend.
.
.
.
Network file [imagenet_inceptionv3.json] is loaded successfully.
IR network structure is saved as [inception_v3.json].
IR network structure is saved as [inception_v3.pb].
IR weights are saved as [inception_v3.npy].
```

### Convert models from IR to Keras code snippet

Since the generated Keras model code snippet can restore weights from IR weights file directly, you don't need to convert weights in this step.You can use following bash command to convert the IR architecture file [*inception_v3.pb*] to Keras Python code file[*keras_inception_v3.py*]

```bash
$ mmtocode -f keras --IRModelPath inception_v3.pb --IRWeightPath inception_v3.npy --dstModelPath keras_inception_v3.py

Parse file [inception_v3.pb] with binary format successfully.
Target network code snippet is saved as [keras_inception_v3.py].
```

### Generate Keras model from code snippet file and weight file

After generating the keras code snippet, you can convert the Keras code snippet [*keras_inception_v3.py*] and IR weights file [*inception_v3.npy*] to Keras original model for further usage.

```bash
$ python -m mmdnn.conversion.examples.keras.imagenet_test -n keras_inception_v3.py -w inception_v3.npy --dump keras_inception_v3.h5

Using TensorFlow backend.
.
.
.
Keras model file is saved as [keras_inception_v3.h5], generated by [keras_inception_v3.py] and [inception_v3.npy].
```

## Support Operators

- Add
- Concat
- Relu
- Softmax
- Tanh
- Sigmoid
- Softplus
- Softsign
- HardSigmoid
- Elu

## Develop version

Ubuntu 16.04 with

- Keras 2.1.3

- Tensorflow GPU 1.4.0

@ 11/21/2017

## Limitation

- Lambda layer no support

  - *inception_resnet_v2* pre-trained model no support

- Currently no RNN related operations support

- Model in model is not supported yet. We can implement it if needed.
