# darknet README

## Darknet pre-trained model

We tested some darknet pre-trained models to others, get more detail from [this file](https://github.com/Microsoft/MMdnn/blob/master/mmdnn/conversion/examples/darknet/extractor.py)

Models                   |       Keras       |      CNTK       |
:-----------------------:|:-----------------:|:---------------:|
yolov2                   |   √(final conv)   |  √(final conv)  |
yolov3                   |   √(boxed image)  |                 |
---

##Download darknet pre-trained model

```bash
$ mmdownload -f darknet

Supported models: ['yolov3', 'yolov2']

$ mmdownload -f darknet -n yolov3 -o ./

Downloading file [./yolov3.cfg] from [https://github.com/pjreddie/darknet/blob/master/cfg/yolov3.cfg]
progress: 200.0 KB downloaded, 100%
Downloading file [./yolov3.weights] from [https://pjreddie.com/media/files/yolov3.weights]
progress: 242200.0 KB downloaded, 100%
Darknet Model yolov3 saved as [./yolov3.cfg] and [./yolov3.weights].
```

---

## Step-by-step conversion (for debugging)

### Convert model from darknet to IR (darknet -> IR)

You can use following bash command to convert the network architecture [*./yolov3.cfg*] with weights [*./yolov3.weights*] to IR architecture file [*darknet_yolov3.pb*], [*darknet_yolov3.json*] and IR weights file [*darknet_yolov3.npy*]

'darknetStart' is to decide the start buf offsize to parse the darknet weight file.

```bash
$ mmtoir -f darknet -n yolov3.cfg -w yolov3.weights -o darknet_yolov3 --darknetStart 0
.
.
.
weights buf size: 62001758
Warning: Graph Construct a self-loop node data. Ignored.
loaded weights buf size: 62001758
IR network structure is saved as [darknet_yolov3.json].
IR network structure is saved as [darknet_yolov3.pb].
IR weights are saved as [darknet_yolov3.npy].

```

### Convert model from IR to Keras/CNTK code (IR -> Keras/CNTK)

You can use following bash command to convert the IR architecture file [*darknet_yolov3.pb*] and weights file [*darknet_yolov3.npy*] to Keras Python code file[*keras_yolov3_converted.py*]

```bash
$ mmtocode -f keras -n darknet_yolov3.pb -w darknet_yolov3.npy -d keras_yolov3_converted.py

Parse file [darknet_yolov3.pb] with binary format successfully.
Target network code snippet is saved as [keras_yolov3_converted.py].
```

### Using Keras code to generate the final result image

You can use following bash command to generate the final result image [*yolov3_detect.jpg*] using Keras Python code file[*keras_yolov3_converted.py*]

```bash
$ python -m mmdnn.conversion.examples.keras.imagenet_test -n keras_yolov3_converted.py -w darknet_yolov3.npy -i mmdnn/conversion/examples/data/dog.jpg -s darknet -p yolov3 --detect test

Found 3 boxes for img
('dog 1.00', (68, 164), (175, 393))
('truck 0.86', (255, 68), (377, 126))
('bicycle 0.99', (62, 87), (311, 316))
Keras yolo model result file is saved as [test.jpg], generated by [keras_yolov3_converted.py] and [darknet_yolov3.npy].

```
![](https://github.com/Microsoft/MMdnn/blob/master/docs/darkent_keras_yolov3_converted.jpg)

### Using Keras/CNTK code to get the 3 final convolution layer output file
52,26,13

The order of output conv layer is [(1, 52, 52, 256), (1, 26, 26, 256), (1, 13, 13, 256)]. You can use following bash command to generate the final convolution layer output file [*finalconv_52.npy, finalconv_26.npy, finalconv_13.npy*] using CNTK Python code file[*cntk_yolov3_converted.py*]

```bash
$ python -m mmdnn.conversion.examples.cntk.imagenet_test -n cntk_yolov3_converted.py -w darknet_yolov3.npy -i mmdnn/conversion/examples/data/dog.jpg -s darknet -p yolov3 --detect test

Found 3 outputs

The output of CNTK model file is saved as [finalconv_52.npy].
The output of CNTK model file is saved as [finalconv_26.npy].
The output of CNTK model file is saved as [finalconv_13.npy].
generated by [cntk_yolov3_converted.py], [darknet_yolov3.npy] and [mmdnn/conversion/examples/data/dog.jpg].


```

## Limitation

- Currently no image classification support caused by the different architecture

---

## Acknowledgement

Thanks to [pytorch-caffe-darknet-convert](https://github.com/marvis/pytorch-caffe-darknet-convert) the code of parsing the config file, [keras-yolo3](https://github.com/qqwweee/keras-yolo3) the code of generating detection result image from final conv.

