# Caffe README

## Caffe pre-trained model

We tested some Caffe pre-trained models to others, get more detail from [this file](https://github.com/Microsoft/MMdnn/blob/master/mmdnn/conversion/examples/caffe/extractor.py)

|          Models         | Caffe | Keras | Tensorflow | CNTK | MXNet | PyTorch | CoreML | ONNX |
| :---------------------: | :---: | :---: | :--------: | :--: | :---: | :-----: | :----: | :--: |
|          Vgg19          |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|         AlexNet         |   √   |       |      √     |   √  |   √   |    √    |    √   |   √  |
|       Inception_v1      |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|       Inception_v4      |       |   √   |      √     |   o  |       |    √    |    √   |   √  |
|        ResNet 152       |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|        SqueezeNet       |   √   |   √   |      √     |   √  |   √   |    √    |    √   |   √  |
|         Xception        |       |       |      √     |   √  |   √   |    √    |    √   |   √  |
| voc-FCN8s/FCN16s/FCN32s |       |       |      √     |      |       |         |    √   |      |

**√** - Correctness tested

**o** - Some difference after conversion

**space** - not tested

---

# Usage

## Download Caffe pre-trained model

```bash
$ mmdownload -f caffe

Supported models: ['resnet50', 'resnet101', 'voc-fcn8s', 'inception_v4', 'voc-fcn16s', 'squeezenet', 'alexnet', 'inception_v1', 'resnet152', 'xception', 'vgg16', 'vgg19', 'voc-fcn32s']

$ mmdownload -f caffe -n resnet152 -o ./

Downloading file [./resnet152-deploy.prototxt] from [http://data.mxnet.io/models/imagenet/test/caffe/ResNet-152-deploy.prototxt]
100% [..............................................................................] 98034 / 98034
Downloading file [./resnet152.caffemodel] from [http://data.mxnet.io/models/imagenet/test/caffe/ResNet-152-model.caffemodel]
100% [......................................................................] 241444171 / 241444171
Caffe Model resnet152 saved as [./resnet152-deploy.prototxt] and [./resnet152.caffemodel].
```

---

## One-step conversion

Above MMdnn@0.1.4, we provide one command to achieve the conversion

```bash
$ mmconvert -sf caffe -in resnet152-deploy.prototxt -iw resnet152.caffemodel -df cntk -om caffe_resnet152.dnn
.
.
.
CNTK model file is saved as [caffe_resnet152.dnn], generated by [069867aa7f674b73aebaf9de34cf2507.py] and [069867aa7f674b73aebaf9de34cf2507.npy].
```

Then you get the CNTK original model *caffe_resnet152.dnn* converted from Caffe. Temporal files are removed automatically.

If you want to assume a fixed inputshape, you can use "--inputShape 224,224,3"
---

## Step-by-step conversion (for debugging)

### Convert models from Caffe to IR (Caffe -> IR)

You can use following bash command to convert the network architecture [*resnet152-deploy.prototxt*] with weights [*resnet152.caffemodel*] to IR architecture file [*caffe_resnet_IR.pb*], [*caffe_resnet_IR.json*] and IR weights file [*caffe_resnet_IR.npy*]

```bash
$ mmtoir -f caffe -n resnet152-deploy.prototxt -w resnet152.caffemodel -o caffe_resnet_IR
.
.
.
IR network structure is saved as [caffe_resnet_IR.json].
IR network structure is saved as [caffe_resnet_IR.pb].
IR weights are saved as [caffe_resnet_IR.npy].
```

### Convert models from IR to Caffe code (IR -> Caffe)

You can use following bash command to convert the IR architecture file [*caffe_resnet_IR.pb*] and weights file [*caffe_resnet_IR.npy*] to Caffe Python code file[*caffe_converted.py*] and IR weights file suit for caffe model[*caffe_converted.npy*]

```bash
$ mmtocode -f caffe -n caffe_resnet_IR.pb -w caffe_resnet_IR.npy -d caffe_converted.py -dw caffe_converted.npy

Parse file [caffe_resnet_IR.pb] with binary format successfully.
Target network code snippet is saved as [caffe_converted.py].
Target weights are saved as [caffe_converted.npy].
```

### Generate Caffe model from code snippet file and weight file

You can use following bash command to generate caffe architecture file [*caffe_target.prototxt*] and weights file [*caffe_target.caffemodel*] from python code [*caffe_converted.py*] and weights file [*caffe_converted.npy*] for further usage.

```bash
$ mmtomodel -f caffe -in caffe_converted.py -iw caffe_converted.npy -o caffe_target

Caffe model files are saved as [caffe_target.prototxt] and [caffe_target.caffemodel], generated by [caffe_converted.py] and [caffe_converted.npy].
```

Then you can use Caffe to load the *caffe_target.prototxt* and *caffe_target.caffemodel* files for future use.

## Develop version

Ubuntu 16.04 with

- Caffe 1.0.0

@ 05/03/2018

## Limitation

- Currently no RNN related operations support

---

## Acknowledgement

Thanks to [Saumitro Dasgupta](https://github.com/ethereon), the initial code of *caffe-to-tensorflow* references to his project [caffe-tensorflow](https://github.com/ethereon/caffe-tensorflow).
