# Web Chat hosted samples

Here you can find all hosted samples of [Web Chat](https://github.com/microsoft/BotFramework-WebChat). The source code repository can be found on [GitHub](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples).

> These samples are connected to MockBot, a bot for testing various features of Web Chat. The source code of MockBot can be found on [GitHub](https://github.com/compulim/BotFramework-MockBot).

# Samples list

| Sample Name                                                                                                                                                                                                      | Description                                                                                                                                                                                                                         | Link                                                                                                                                                                                                                                                                                  |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Migration**                                                                                                                                                                                                    |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`00.migration/a.v3-to-v4`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/00.migration/a.v3-to-v4)                                                                                         | Demonstrates how to migrate from your Web Chat v3 bot to v4.                                                                                                                                                                        | [Migration Demo](https://microsoft.github.io/BotFramework-WebChat/00.migration/a.v3-to-v4)                                                                                                                                                                                            |
| **Getting started**                                                                                                                                                                                              |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`01.getting-started/a.full-bundle`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/a.full-bundle)                                                                       | Introduces Web Chat embed from a CDN, and demonstrates a simple, full-featured Web Chat. This includes Adaptive Cards, Cognitive Services, and Markdown-It dependencies.                                                            | [Full Bundle Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/a.full-bundle)                                                                                                                                                                                 |
| [`01.getting-started/b.minimal-bundle`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/b.minimal-bundle)                                                                 | Introduces the minimized CDN with only basic dependencies. This does NOT include Adaptive Cards, Cognitive Services dependencies, or Markdown-It dependencies.                                                                      | [Minimal Bundle Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/b.minimal-bundle)                                                                                                                                                                           |
| [`01.getting-started/c.es5-bundle`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/c.es5-bundle)                                                                         | Introduces full-featured Web Chat embed with backwards compatibility for ES5 browsers using Web Chat's ES5 ponyfill.                                                                                                                | [ES5 Bundle Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/c.es5-bundle)                                                                                                                                                                                   |
| [`01.getting-started/d.es5-direct-line-speech`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/d.es5-direct-line-speech)                                                 | Demonstrates how to use Direct Line Speech with ES5 bundle.                                                                                                                                                                         | [ES5 Direct Line Speech Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/d.es5-direct-line-speech)                                                                                                                                                           |
| [`01.getting-started/e.host-with-react`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/e.host-with-react)                                                               | Demonstrates how to create a React component that hosts the full-featured Web Chat.                                                                                                                                                 | [Host with React Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/e.host-with-react)                                                                                                                                                                         |
| [`01.getting-started/f.host-with-angular`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/f.host-with-angular)                                                           | Demonstrates how to create an Angular component that hosts the full-featured Web Chat.                                                                                                                                              | [Host with Angular Demo](https://stackblitz.com/github/omarsourour/ng-webchat-example)                                                                                                                                                                                                |
| [`01.getting-started/h.minimal-markdown`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/h.minimal-markdown)                                                             | Demonstrates how to add the CDN for Markdown-It dependency on top of the minimal bundle.                                                                                                                                            | [Minimal with Markdown Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/h.minimal-markdown)                                                                                                                                                                  |
| [`01.getting-started/i.protocol-direct-line-app-service-extension`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/i.protocol-direct-line-app-service-extension)         | Demonstrates how to use Direct Line App Service Extension chat adapter                                                                                                                                                              | [Direct Line App Service Extension Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/i.protocol-direct-line-app-service-extension)                                                                                                                            |
| [`01.getting-started/j.bundle-with-content-security-policy`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/j.bundle-with-content-security-policy)                       | Demonstrates how to embed on a host with Content Security Policy configured.                                                                                                                                                        | [Content Security Policy Demo](https://microsoft.github.io/BotFramework-WebChat/01.getting-started/j.bundle-with-content-security-policy)                                                                                                                                             |
| [`01.getting-started/k.direct-line-token`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/k.direct-line-token)                                                           | Demonstrates how to use a Direct Line token instead of exposing the Direct Line secret.                                                                                                                                             |                                                                                                                                                                                                                                                                                       |
| [`01.getting-started/l.sharepoint-web-part`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/01.getting-started/l.sharepoint-web-part)                                                       | Demonstrates how to host Web Chat as a SharePoint web part.                                                                                                                                                                         |                                                                                                                                                                                                                                                                                       |
| **Branding, styling, and customization**                                                                                                                                                                         |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`02.branding-styling-and-customization/a.branding-web-chat`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/a.branding-web-chat)                     | Introduces the ability to style Web Chat to match your brand. This method of custom styling will not break upon Web Chat updates.                                                                                                   | [Branding Web Chat Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/a.branding-web-chat)                                                                                                                                                  |
| [`02.branding-styling-and-customization/b.idiosyncratic-manual-styles`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/b.idiosyncratic-manual-styles) | Demonstrates how to make manual style changes, and is a more complicated and time-consuming way to customize styling of Web Chat. Manual styles may be broken upon Web Chat updates.                                                | [Idiosyncratic Styling Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/b.idiosyncratic-manual-styles)                                                                                                                                    |
| [`02.branding-styling-and-customization/c.display-sender-initials`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/c.display-sender-initials)         | Demonstrates how to display initials for both Web Chat participants.                                                                                                                                                                | [Bot initials Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/c.display-sender-initials/)                                                                                                                                                |
| [`02.branding-styling-and-customization/d.display-sender-images`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/d.display-sender-images)             | Demonstrates how to display images and initials for both Web Chat participants.                                                                                                                                                     | [User images Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/d.display-sender-images)                                                                                                                                                    |
| [`02.branding-styling-and-customization/e.presentation-mode`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/e.presentation-mode)                     | Demonstrates how to set up Presentation Mode, which displays chat history but does not show the send box, and disables the interactivity of Adaptive Cards.                                                                         | [Presentation Mode Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/e.presentation-mode)                                                                                                                                                  |
| [`02.branding-styling-and-customization/f.hide-upload-button`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/f.hide-upload-button)                   | Demonstrates how to hide file upload button via styling.                                                                                                                                                                            | [Hide Upload Button Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/f.hide-upload-button)                                                                                                                                                |
| [`02.branding-styling-and-customization/g.change-locale`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/g.change-locale)                             | Demonstrates how to change locale when an activity is received from the bot.                                                                                                                                                        | [Change Locale Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/g.change-locale)                                                                                                                                                          |
| [`02.branding-styling-and-customization/h.send-timeout`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/h.send-timeout)                               | Demonstrates how to change timeout for outgoing messages.                                                                                                                                                                           | [Send Timeout Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/h.send-timeout)                                                                                                                                                            |
| [`02.branding-styling-and-customization/i.change-locale-and-direction`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/i.change-locale-and-direction) | Demonstrates how to change locale and direction of the UI (RTL).                                                                                                                                                                    | [Change Direction Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/i.change-locale-and-direction)                                                                                                                                         |
| [`02.branding-styling-and-customization/j.activity-grouping`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/j.activity-grouping)                     | Demonstrates how to customize activity grouping behavior.                                                                                                                                                                           | [Activity Grouping Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/j.activity-grouping) [(Comprehensive)](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/j.activity-grouping/comprehensive.html) |
| [`02.branding-styling-and-customization/k.enable-emoji`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/02.branding-styling-and-customization/k.enable-emoji)                               | Demonstrates how to enable emoji autocorrect in the send box.                                                                                                                                                                       | [Enable Emoji Demo](https://microsoft.github.io/BotFramework-WebChat/02.branding-styling-and-customization/k.enable-emoji)                                                                                                                                                            |
| **Speech**                                                                                                                                                                                                       |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`03.speech/a.direct-line-speech`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/a.direct-line-speech)                                                                           | Demonstrates how to use Direct Line Speech channel in Web Chat.                                                                                                                                                                     | [Direct Line Speech Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/a.direct-line-speech)                                                                                                                                                                            |
| [`03.speech/b.cognitive-speech-services-js`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/b.cognitive-speech-services-js)                                                       | Introduces speech-to-text and text-to-speech ability using Cognitive Services Speech Services API.                                                                                                                                  | [Speech Services with JS Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/b.cognitive-speech-services-js)                                                                                                                                                             |
| [`03.speech/c.cognitive-speech-services-with-lexical-result`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/c.cognitive-speech-services-with-lexical-result)                     | Demonstrates how to use lexical result from Cognitive Services Speech Services API.                                                                                                                                                 | [Lexical Result Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/c.cognitive-speech-services-with-lexical-result)                                                                                                                                                     |
| [`03.speech/d.cognitive-speech-services-speech-recognition-only`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/d.cognitive-speech-services-speech-recognition-only)             | Implement Cognitive Speech Services with only Speech Recognition.                                                                                                                                                                   | [Cognitive Speech: Speech Recognition](https://microsoft.github.io/BotFramework-WebChat/03.speech/d.cognitive-speech-services-speech-recognition-only)                                                                                                                                |
| [`03.speech/e.select-voice`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/e.select-voice)                                                                                       | Demonstrates how to select speech synthesis voice based on activity.                                                                                                                                                                | [Select Voice Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/e.select-voice)                                                                                                                                                                                        |
| [`03.speech/f.web-browser-speech`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/f.web-browser-speech)                                                                           | Demonstrates how to implement text-to-speech using Web Chat's browser-based Web Speech API. (link to W3C standard in the sample)                                                                                                    | [Web Speech API Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/f.web-browser-speech)                                                                                                                                                                                |
| [`03.speech/g.hybrid-speech`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/g.hybrid-speech)                                                                                     | Demonstrates how to use both browser-based Web Speech API for speech-to-text, and Cognitive Services Speech Services API for text-to-speech.                                                                                        | [Hybrid Speech Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/g.hybrid-speech)                                                                                                                                                                                      |
| [`03.speech/h.select-audio-input-device`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/03.speech/h.select-audio-input-device)                                                             | Demonstrates how to select an audio input device.                                                                                                                                                                                   | [Select Audio Input Device Demo](https://microsoft.github.io/BotFramework-WebChat/03.speech/h.select-audio-input-device) [(Comprehensive)](https://microsoft.github.io/BotFramework-WebChat/03.speech/h.select-audio-input-device/comprehensive.html)                                 |
| **API**                                                                                                                                                                                                          |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`04.api/a.welcome-event`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/a.welcome-event)                                                                                           | Advanced tutorial: Demonstrates how to send welcome event with client capabilities such as browser language.                                                                                                                        | [Welcome Event Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/a.welcome-event)                                                                                                                                                                                         |
| [`04.api/b.piggyback-on-outgoing-activities`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/b.piggyback-on-outgoing-activities)                                                     | Advanced tutorial: Demonstrates how to add custom data to every outgoing activities.                                                                                                                                                | [Backchannel Piggybacking Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/b.piggyback-on-outgoing-activities)                                                                                                                                                           |
| [`04.api/c.incoming-activity-event`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/c.incoming-activity-event)                                                                       | Advanced tutorial: Demonstrates how to forward all incoming activities to a JavaScript event for further processing.                                                                                                                | [Incoming Activity Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/c.incoming-activity-event)                                                                                                                                                                           |
| [`04.api/d.post-activity-event`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/d.post-activity-event)                                                                               | Advanced tutorial: Demonstrates how to send a message programmatically.                                                                                                                                                             | [Programmatic Posting Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/d.post-activity-event)                                                                                                                                                                            |
| [`04.api/e.piping-to-redux`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/e.piping-to-redux)                                                                                       | Advanced tutorial: Demonstrates how to pipe bot activities to your own Redux store and use your bot to control your page through bot activities and Redux.                                                                          | [Piping to Redux Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/e.piping-to-redux)                                                                                                                                                                                     |
| [`04.api/f.selectable-activity`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/f.selectable-activity)                                                                               | Advanced tutorial: Demonstrates how to add custom click behavior to each activity.                                                                                                                                                  | [Selectable Activity Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/f.selectable-activity)                                                                                                                                                                             |
| [`04.api/g.chat-send-history`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/g.chat-send-history)                                                                                   | Advanced tutorial: Demonstrates the ability to save user input and allow the user to step back through previous sent messages.                                                                                                      | [Chat Send History Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/g.chat-send-history)                                                                                                                                                                                 |
| [`04.api/h.clear-after-idle`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/h.clear-after-idle)                                                                                     | Advanced tutorial: Demonstrates how to customize the open URL behavior.                                                                                                                                                             | [Clear After Idle Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/h.clear-after-idle)                                                                                                                                                                                   |
| [`04.api/i.open-url`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/i.open-url)                                                                                                     | Advanced tutorial: Demonstrates how to customize the open URL behavior.                                                                                                                                                             | [Customize Open URL Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/i.open-url)                                                                                                                                                                                         |
| [`04.api/j.redux-actions`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/j.redux-actions)                                                                                           | Advanced tutorial: Demonstrates how to incorporate redux middleware into your Web Chat app by sending redux actions through the bot. This example demonstrates manual styling based on activities between bot and user.             | [Redux Actions Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/j.redux-actions)                                                                                                                                                                                         |
| [`04.api/k.telemetry-application-insights`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/k.telemetry-application-insights)                                                         | Advanced tutorial: Demonstrates how to collect telemetry measurement using Azure Application Insights.                                                                                                                              | [Telemetry using Application Insights Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/k.telemetry-application-insights)                                                                                                                                                 |
| [`04.api/l.telemetry-google-analytics`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/l.telemetry-google-analytics)                                                                 | Advanced tutorial: Demonstrates how to collect telemetry measurement using Google Analytics.                                                                                                                                        | [Telemetry using Google Analytics Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/l.telemetry-google-analytics)                                                                                                                                                         |
| [`04.api/m.enable-composition-mode`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/m.enable-composition-mode)                                                                       | Advanced tutorial: Demonstrates how to enable composition mode.                                                                                                                                                                     | [Telemetry using Google Analytics Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/m.enable-composition-mode)                                                                                                                                                            |
| [`04.api/n.save-restore-scroll-position`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/04.api/n.save-restore-scroll-position)                                                             | Advanced tutorial: Demonstrates how to save and restore scroll position.                                                                                                                                                            | [Save and Restore Scroll Position Demo](https://microsoft.github.io/BotFramework-WebChat/04.api/n.save-restore-scroll-position)                                                                                                                                                       |
| **Custom components**                                                                                                                                                                                            |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`05.custom-components/a.timestamp-grouping`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/a.timestamp-grouping)                                                     | Demonstrates how to customize timestamps by showing or hiding timestamps and changing the grouping of messages by time.                                                                                                             | [Timestamp Grouping Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/a.timestamp-grouping)                                                                                                                                                                 |
| [`05.custom-components/b.send-typing-indicator`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/b.send-typing-indicator)                                               | Demonstrates how to send typing activity when the user start typing on the send box.                                                                                                                                                | [User Typing Indicator Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/b.send-typing-indicator)                                                                                                                                                           |
| [`05.custom-components/c.user-highlighting`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/c.user-highlighting)                                                       | Demonstrates how to customize the styling of activities based whether the message is from the user or the bot.                                                                                                                      | [User Highlighting Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/c.user-highlighting)                                                                                                                                                                   |
| [`05.custom-components/d.reaction-buttons`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/d.reaction-buttons/)                                                        | Introduces the ability to create custom components for Web Chat that are unique to your bot's needs. This tutorial demonstrates the ability to add reaction emoji such as :thumbsup: and :thumbsdown: to conversational activities. | [Reaction Buttons Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/d.reaction-buttons)                                                                                                                                                                     |
| [`05.custom-components/e.card-components`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/e.card-components)                                                           | Demonstrates how to create custom activity card attachments, in this case GitHub repository cards.                                                                                                                                  | [Card Components Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/e.card-components)                                                                                                                                                                       |
| [`05.custom-components/f.password-input`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/f.password-input)                                                             | Demonstrates how to create custom activity for password input.                                                                                                                                                                      | [Password Input Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/f.password-input)                                                                                                                                                                         |
| [`05.custom-components/g.activity-status`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/g.activity-status/)                                                          | Demonstrates how to customize the activity status by including sender's name.                                                                                                                                                       | [Customize Activity Status Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/g.activity-status)                                                                                                                                                             |
| [`05.custom-components/i.notification`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/i.notification/)                                                                | Demonstrates how to use notification and customize the toast UI.                                                                                                                                                                    | [Notification Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/i.notification)                                                                                                                                                                             |
| [`05.custom-components/j.typing-indicator`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/j.typing-indicator/)                                                        | Demonstrates how to customize the typing indicator.                                                                                                                                                                                 | [Customize Typing Indicator Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/j.typing-indicator)                                                                                                                                                           |
| [`05.custom-components/k.per-message-avatar`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/05.custom-components/k.per-message-avatar/)                                                    | Demonstrates how to customize the avatar on a per-message basis.                                                                                                                                                                    | [Customize Avatar Demo](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/k.per-message-avatar) [(Comprehensive)](https://microsoft.github.io/BotFramework-WebChat/05.custom-components/k.per-message-avatar/comprehensive.html)                                  |
| **Recomposing UI**                                                                                                                                                                                               |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`06.recomposing-ui/a.minimizable-web-chat`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/06.recomposing-ui/a.minimizable-web-chat)                                                       | Advanced tutorial: Demonstrates how to add the Web Chat interface to your website as a minimizable show/hide chat box.                                                                                                              | [Minimizable Web Chat Demo](https://microsoft.github.io/BotFramework-WebChat/06.recomposing-ui/a.minimizable-web-chat)                                                                                                                                                                |
| [`06.recomposing-ui/b.speech-ui`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/06.recomposing-ui/b.speech-ui)                                                                             | Advanced tutorial: Demonstrates how to fully customize key components of your bot, in this case speech, which entirely replaces the text-based transcript UI and instead shows a simple speech button with the bot's response.      | [Speech UI Demo](https://microsoft.github.io/BotFramework-WebChat/06.recomposing-ui/b.speech-ui)                                                                                                                                                                                      |
| [`06.recomposing-ui/c.smart-display`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/06.recomposing-ui/c.smart-display)                                                                     | Demonstrates how to compose Web Chat UI into a Smart Display                                                                                                                                                                        | [Smart Display Demo](https://microsoft.github.io/BotFramework-WebChat/06.recomposing-ui/c.smart-display)                                                                                                                                                                              |
| [`06.recomposing-ui/d.plain-ui`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/06.recomposing-ui/d.plain-ui)                                                                               | Advanced tutorial: Demonstrates how to customize the Web Chat UI by building from ground up instead of needing to rewrite entire Web Chat components.                                                                               | [Plain UI Demo](https://microsoft.github.io/BotFramework-WebChat/06.recomposing-ui/d.plain-ui)                                                                                                                                                                                        |
| [`06.recomposing-ui/e.extending-ui`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/06.recomposing-ui/e.extending-ui)                                                                       | Advanced tutorial: Demonstrates how to customize the Web Chat UI by extending the default UI.                                                                                                                                       | [Extending UI Demo](https://microsoft.github.io/BotFramework-WebChat/06.recomposing-ui/e.extending-ui)                                                                                                                                                                                |
| **Advanced Web Chat apps**                                                                                                                                                                                       |                                                                                                                                                                                                                                     |                                                                                                                                                                                                                                                                                       |
| [`07.advanced-web-chat-apps/a.upload-to-azure-storage`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/07.advanced-web-chat-apps/a.upload-to-azure-storage)                                 | Demonstrates how to use upload attachments directly to Azure Storage                                                                                                                                                                |                                                                                                                                                                                                                                                                                       |
| [`07.advanced-web-chat-apps/b.sso-for-enterprise`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/07.advanced-web-chat-apps/b.sso-for-enterprise)                                           | Demonstrates how to use single sign-on for enterprise single-page applications using OAuth                                                                                                                                          |                                                                                                                                                                                                                                                                                       |
| [`07.advanced-web-chat-apps/c.sso-for-intranet`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/07.advanced-web-chat-apps/c.sso-for-intranet)                                               | Demonstrates how to use single sign-on for Intranet apps using Azure Active Directory                                                                                                                                               |                                                                                                                                                                                                                                                                                       |
| [`07.advanced-web-chat-apps/d.sso-for-teams`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/07.advanced-web-chat-apps/d.sso-for-teams)                                                     | Demonstrates how to use single sign-on for Microsoft Teams apps using Azure Active Directory                                                                                                                                        |                                                                                                                                                                                                                                                                                       |
| [`07.advanced-web-chat-apps/e.sso-on-behalf-of-authentication`](https://github.com/microsoft/BotFramework-WebChat/tree/main/samples/07.advanced-web-chat-apps/e.sso-on-behalf-of-authentications)                | Demonstrates how to use on-behalf-of authentication in an enterprise application                                                                                                                                                    |                                                                                                                                                                                                                                                                                       |
