import PropTypes from 'prop-types';
import React from 'react';

const CheckMarkIcon = ({ 'aria-label': ariaLabel, className }) => (
  <svg
    aria-label={ariaLabel}
    className={(className || '') + ''}
    fill="none"
    height="20"
    viewBox="0 0 20 20"
    width="20"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M14.5605 5.81055L15.4395 6.68945L8.125 14.0039L4.56055 10.4395L5.43945 9.56055L8.125 12.2461L14.5605 5.81055ZM10 0C10.918 0 11.8034 0.120443 12.6562 0.361328C13.5091 0.595703 14.3066 0.93099 15.0488 1.36719C15.791 1.79688 16.4648 2.31771 17.0703 2.92969C17.6823 3.53516 18.2031 4.20898 18.6328 4.95117C19.069 5.69336 19.4043 6.49089 19.6387 7.34375C19.8796 8.19661 20 9.08203 20 10C20 10.918 19.8796 11.8034 19.6387 12.6562C19.4043 13.5091 19.069 14.3066 18.6328 15.0488C18.2031 15.791 17.6823 16.4681 17.0703 17.0801C16.4648 17.6855 15.791 18.2064 15.0488 18.6426C14.3066 19.0723 13.5091 19.4076 12.6562 19.6484C11.8034 19.8828 10.918 20 10 20C9.08203 20 8.19661 19.8828 7.34375 19.6484C6.49089 19.4076 5.69336 19.0723 4.95117 18.6426C4.20898 18.2064 3.5319 17.6855 2.91992 17.0801C2.31445 16.4681 1.79362 15.791 1.35742 15.0488C0.927734 14.3066 0.592448 13.5124 0.351562 12.666C0.117188 11.8132 0 10.9245 0 10C0 9.08203 0.117188 8.19661 0.351562 7.34375C0.592448 6.49089 0.927734 5.69336 1.35742 4.95117C1.79362 4.20898 2.31445 3.53516 2.91992 2.92969C3.5319 2.31771 4.20898 1.79688 4.95117 1.36719C5.69336 0.93099 6.48763 0.595703 7.33398 0.361328C8.18685 0.120443 9.07552 0 10 0ZM10 18.75C10.8008 18.75 11.5723 18.6458 12.3145 18.4375C13.0632 18.2292 13.7598 17.9362 14.4043 17.5586C15.0553 17.1745 15.6478 16.7155 16.1816 16.1816C16.7155 15.6478 17.1712 15.0586 17.5488 14.4141C17.9329 13.763 18.2292 13.0664 18.4375 12.3242C18.6458 11.582 18.75 10.8073 18.75 10C18.75 9.19922 18.6458 8.42773 18.4375 7.68555C18.2292 6.93685 17.9329 6.24023 17.5488 5.5957C17.1712 4.94466 16.7155 4.35221 16.1816 3.81836C15.6478 3.28451 15.0553 2.82878 14.4043 2.45117C13.7598 2.06706 13.0632 1.77083 12.3145 1.5625C11.5723 1.35417 10.8008 1.25 10 1.25C9.19922 1.25 8.42448 1.35417 7.67578 1.5625C6.93359 1.77083 6.23698 2.06706 5.58594 2.45117C4.94141 2.82878 4.35221 3.28451 3.81836 3.81836C3.28451 4.35221 2.82552 4.94466 2.44141 5.5957C2.0638 6.24023 1.77083 6.93685 1.5625 7.68555C1.35417 8.42773 1.25 9.19922 1.25 10C1.25 10.8008 1.35417 11.5755 1.5625 12.3242C1.77083 13.0664 2.0638 13.763 2.44141 14.4141C2.82552 15.0586 3.28451 15.6478 3.81836 16.1816C4.35221 16.7155 4.94141 17.1745 5.58594 17.5586C6.23698 17.9362 6.93359 18.2292 7.67578 18.4375C8.41797 18.6458 9.19271 18.75 10 18.75Z"
      fill="#107C10"
    />
  </svg>
);

CheckMarkIcon.defaultProps = {
  'aria-label': undefined,
  className: undefined
};

CheckMarkIcon.propTypes = {
  'aria-label': PropTypes.string,
  className: PropTypes.string
};

export default CheckMarkIcon;
