import { StrictStyleOptions } from 'botframework-webchat-api';

import { toByteArray } from 'base64-js';

const DEFAULT_IMAGE_BASE64 =
  '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';
const DEFAULT_IMAGE_TYPE = 'image/gif';

let defaultImageBlobURL;

export default function createSpinnerAnimationStyle({
  spinnerAnimationBackgroundImage,
  spinnerAnimationHeight,
  spinnerAnimationWidth,
  spinnerAnimationPadding
}: StrictStyleOptions) {
  defaultImageBlobURL ||
    (defaultImageBlobURL = URL.createObjectURL(
      new Blob([toByteArray(DEFAULT_IMAGE_BASE64)], { type: DEFAULT_IMAGE_TYPE })
    ));

  const backgroundImage = spinnerAnimationBackgroundImage || `url('${defaultImageBlobURL}')`;

  return {
    backgroundImage,
    backgroundRepeat: 'no-repeat',
    backgroundSize: 'contain',
    height: spinnerAnimationHeight,
    width: spinnerAnimationWidth,

    ':not(.webchat__spinner--rtl)': {
      marginRight: spinnerAnimationPadding
    },
    '.webchat__spinner--rtl': {
      marginLeft: spinnerAnimationPadding
    }
  };
}
