import React, { memo } from 'react';

type Props = Readonly<{ className?: string }>;

const ThumbDislike16Regular = memo(({ className }: Props) => (
  <svg className={className} fill="none" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M10.5776 9.99952C10.5944 10.133 10.6119 10.2848 10.6283 10.45C10.7019 11.1893 10.7593 12.2428 10.6146 13.1274C10.5427 13.5666 10.4137 14.0141 10.1727 14.3636C9.91609 14.7357 9.52604 14.9995 9.00016 14.9995C8.48357 14.9995 8.16907 14.6298 7.97616 14.3084C7.78384 13.9879 7.61527 13.553 7.44271 13.1078L7.42958 13.0739C6.88287 11.6637 6.13522 9.75708 4.1232 8.41574C3.81627 8.21111 3.5248 8.06386 3.26989 7.95815C2.5733 7.6693 1.94781 6.90105 2.11258 6.02165L2.33656 4.82627C2.47706 4.07638 3.03196 3.47175 3.76706 3.26756L8.71713 1.89254C10.6934 1.34358 12.716 2.60391 13.0939 4.61984L13.5475 7.03879C13.836 8.57733 12.6557 9.99952 11.0903 9.99952H10.5776ZM12.1111 4.80413C11.8411 3.36418 10.3964 2.46395 8.98478 2.85605L4.03471 4.23107C3.66715 4.33317 3.38971 4.63549 3.31945 5.01043L3.09548 6.20582C3.04235 6.48935 3.2566 6.87007 3.65293 7.03442C3.96222 7.16268 4.31198 7.33974 4.67791 7.58369C6.9648 9.10828 7.80648 11.2795 8.35387 12.6916L8.36197 12.7124C8.55151 13.2014 8.69067 13.5556 8.83359 13.7938C8.90275 13.909 8.95439 13.9644 8.98519 13.9886C8.99329 13.995 8.99862 13.9981 9.00124 13.9995C9.14311 13.9992 9.24643 13.9453 9.3495 13.7959C9.46849 13.6233 9.56579 13.3445 9.62769 12.966C9.75044 12.2154 9.70484 11.2689 9.63323 10.549C9.60484 10.2636 9.57314 10.0209 9.54862 9.85016C9.53637 9.76485 9.52595 9.69769 9.51867 9.65235L9.51029 9.60123L9.50819 9.58884L9.50772 9.58609C9.48227 9.44064 9.52236 9.29093 9.61735 9.17788C9.66884 9.11659 9.73358 9.06935 9.8056 9.03892C9.86646 9.01321 9.93252 8.99952 10.0002 8.99952H11.0903C12.0295 8.99952 12.7377 8.1462 12.5646 7.22308L12.1111 4.80413Z"
      fill="currentcolor"
    />
  </svg>
));

ThumbDislike16Regular.displayName = 'ThumbDislike16Regular';

export default ThumbDislike16Regular;
