import React, { memo } from 'react';

type Props = Readonly<{ className?: string }>;

const ThumbDislike16Filled = memo(({ className }: Props) => (
  <svg className={className} fill="none" height="16" viewBox="0 0 16 16" width="16" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M13.0939 4.61984C12.716 2.60391 10.6934 1.34358 8.71713 1.89254L3.76706 3.26756C3.03196 3.47175 2.47706 4.07638 2.33656 4.82627L2.11258 6.02165C1.94781 6.90105 2.5733 7.6693 3.26989 7.95815C3.5248 8.06386 3.81627 8.21111 4.1232 8.41574C5.80215 9.53503 6.60359 11.0523 7.13855 12.3413C7.23478 12.5731 7.32706 12.8106 7.41614 13.0399C7.56235 13.4162 7.69994 13.7703 7.83227 14.041C7.94336 14.2683 8.07685 14.4964 8.2515 14.6716C8.43773 14.8585 8.68676 14.9995 9.00016 14.9995C9.35735 14.9995 9.66579 14.8763 9.91159 14.6602C10.1473 14.453 10.3051 14.179 10.4137 13.8989C10.6282 13.3453 10.6952 12.648 10.7032 12.0058C10.7114 11.3524 10.6585 10.705 10.6045 10.2249C10.5955 10.1452 10.5865 10.0698 10.5776 9.99952H11.0903C12.6557 9.99952 13.836 8.57733 13.5475 7.03879L13.0939 4.61984Z"
      fill="currentcolor"
    />
  </svg>
));

ThumbDislike16Filled.displayName = 'ThumbDislike16Filled';

export default ThumbDislike16Filled;
