# Bot Framework Web Chat labelling guidelines

Our labelling guide is based off of the [Bot Framework SDK labelling guidelines](https://github.com/microsoft/botframework-sdk/blob/main/docs/BF%20Labeling%20Guide.md).

Below are a list of labels that differ from the recommended set from above:

### Area labels

-  `Area: Accessibility`
-  `Area: Direct Line Speech`
-  `Area: Docs`
-  `Area: Migration Support`
-  `Area: MockBot`
-  `Area: React Native`
-  `Area: Skills`
-  `Area: Speech`
-  `Area: SSO`

> -  More area labels may be added or removed as needed
> -  These labels are NOT mutually exclusive

### Status labels:

-  Instead of `needs-triage`, the following will be used:
   -  `needs-scheduling`
   -  `needs-scope`
   -  `needs-repro`
   -  `needs-design-input`
   -  `needs-author-feedback`
   -  `needs-team-attention`
-  `front-burner` (issues for consideration in the next two milestones/releases)
-  `backlog`

> -  These labels are NOT mutually exclusive

Label renames:

-  `Enhancement` ⇒ `feature-request`
-  `T-shirt-X` ⇒ `Size: X`
-  `QOL` ⇒ `team-agility`
-  `Tests` ⇒ `technical-debt`
-  `Help wanted` ⇒ `Community: Help wanted`

### Notes:

-  At the time of writing this document, automation labels have not been implemented in Web Chat
-  All bugs not scheduled for the current milestone should be listed in `front-burner`
