# Web Chat API Reference

There are several properties that you might pass into your Web Chat React Component (`<ReactWebChat>`) or the `renderWebChat()` method. Feel free to examine the source code starting with [`packages/component/src/Composer.js`](https://github.com/microsoft/BotFramework-WebChat/blob/main/packages/component/src/Composer.js#L378). Below is a short description of the available props.

| Property                   | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| -------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `activityMiddleware`       | A chain of middleware, modeled after [Redux middleware](https://medium.com/@jacobp100/you-arent-using-redux-middleware-enough-94ffe991e6), that allows the developer to add new DOM components on the currently existing DOM of Activities. The middleware signature is the following: `options => next => card => children => next(card)(children)`.                                                                                                                                                                                                                                                                                              |
| `activityRenderer`         | The "flattened" version of `activityMiddleware`, similar to the [store enhancer](https://github.com/reduxjs/redux/blob/master/docs/Glossary.md#store-enhancer) concept in Redux.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `adaptiveCardHostConfig`   | Pass in a custom Adaptive Cards host config. Be sure to verify your Host Config with the version of Adaptive Cards that is being used. See [Custom Host config](https://github.com/microsoft/BotFramework-WebChat/issues/2034#issuecomment-501818238) for more information.                                                                                                                                                                                                                                                                                                                                                                        |
| `attachmentMiddleware`     | A chain of middleware that allows the developer to add their own custom HTML Elements on attachments. The signature is the following: `options => next => card => next(card)`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `attachmentRenderer`       | The "flattened" version of `attachmentMiddleware`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `cardActionMiddleware`     | A chain of middleware that allows the developer to modify card actions, like Adaptive Cards or suggested actions. The middleware signature is the following: `cardActionMiddleware: () => next => ({ cardAction, getSignInUrl }) => next(cardAction)`                                                                                                                                                                                                                                                                                                                                                                                              |
| `createDirectLine`         | A factory method for instantiating the Direct Line object. Azure Government users should use `createDirectLine({ domain: 'https://directline.botframework.azure.us/v3/directline', token });` to change the endpoint. The full list of parameters are: `conversationId`, `domain`, `fetch`, `pollingInterval`, `secret`, `streamUrl`, `token`, `watermark` `webSocket`.                                                                                                                                                                                                                                                                            |
| `createStore`              | A chain of middleware that allows the developer to modify the store actions. The middleware signature is the following: `createStore: ({}, ({ dispatch }) => next => action => next(cardAction)`                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `directLine`               | Specify the DirectLine object with DirectLine token. We strongly recommend using the token API for authentication instead of providing the app with your secret. To learn more about why, see the [authentication documentation](https://docs.microsoft.com/en-us/azure/bot-service/rest-api/bot-framework-rest-direct-line-3-0-authentication?view=azure-bot-service-4.0) or [connecting client app to bot](#how-to-connect-client-app-to-bot)                                                                                                                                                                                                    |
| `disabled`                 | Disable the UI (i.e. for presentation mode) of Web Chat.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `grammars`                 | Specify a grammar list for Speech (Cognitive Services Speech Services).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `groupTimeStamp`           | Change default settings for timestamp groupings.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `locale`                   | Indicate the default language of Web Chat. Four letter codes (such as `en-US`) are strongly recommended.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| `renderMarkdown`           | Change the default Markdown renderer object.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `sendTypingIndicator`      | Display a typing signal from the user to the bot to indicate that the user is not idling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `store`                    | Specify a custom store, e.g. for adding programmatic activity to the bot.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `styleOptions`             | Object that stores customization values for your styling of Web Chat. For the complete list of (frequently updated) default style options, please see the [defaultStyleOptions.ts](https://github.com/microsoft/BotFramework-WebChat/blob/main/packages/api/src/defaultStyleOptions.ts) and [adaptiveCards/defaultStyleOptions.ts](https://github.com/microsoft/BotFramework-WebChat/blob/main/packages/bundle/src/adaptiveCards/defaultStyleOptions.ts) file.                                                                                                                                                                                 |
| `styleSet`                 | The non-recommended way of overriding styles.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `userID`                   | Specify a userID. There are two ways to specify the `userID`: in props, or in the token when generating the token call (`createDirectLine()`). If both methods are used to specify the userID, the token userID property will be used, and a `console.warn` will appear during runtime. If the `userID` is provided via props but is prefixed with `'dl'`, e.g. `'dl_1234'`, the value will be thrown and a new `ID` generated. If `userID` is not specified, it will default to a random user ID. Multiple users sharing the same user ID is not recommended; their user state will be shared, which creates a security risk when authenticating. |
| `username`                 | Specify a username.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `webSpeechPonyFillFactory` | Specify the Web Speech object for text-to-speech and speech-to-text.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
