<img align="right" height="207x" width="205px" alt="Banner" src="images/awesome_programming_discord.webp">

<!-- omit in toc -->
# Awesome Discord Communities [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

A curated list of awesome Discord communities for developers, game engineers, hackers, hobbyists, mathematicians and tech enthusiasts. [Discord](FAQ.md#what-is-discordcom-exactly) at heart, is a community-oriented instant messaging, voice and video call application. [__This is not a Discord listing, promotional, or affiliated site!__](FAQ.md#how-is-this-list-any-different-from-discord-listing-sites)

<!-- omit in toc -->
## Contents

- [How to Navigate](#how-to-navigate)
- [Programming in General](#programming-in-general)
  - [Support Communities](#support-communities)
  - [Competitive Programming](#competitive-programming)
- [Art of Computer Science](#art-of-computer-science)
  - [Computer Science](#computer-science)
  - [Mathematics](#mathematics)
  - [Physics](#physics)
  - [Other Sciences](#other-sciences)
- [Electrical](#electrical)
  - [Engineering](#engineering)
  - [Microprocessors and Microcontrollers](#microprocessors-and-microcontrollers)
  - [DIY](#diy)
  - [Internet of Things](#internet-of-things)
  - [IoT Applications](#iot-applications)
- [Hardware](#hardware)
  - [Phones](#phones)
  - [Smartwatches](#smartwatches)
  - [Keyboards](#keyboards)
  - [Retro Computers](#retro-computers)
- [Programming Languages](#programming-languages)
  - [Language Paradigms](#language-paradigms)
  - [Assembly](#assembly)
  - [C and C++](#c-and-c)
  - [C#](#c)
  - [Clojure](#clojure)
  - [CSS](#css)
  - [Elixir](#elixir)
  - [Go](#go)
  - [Haxe](#haxe)
  - [Java](#java)
  - [JavaScript](#javascript)
  - [Lisp](#lisp)
  - [Lua](#lua)
  - [Pascal](#pascal)
  - [PHP](#php)
  - [Python](#python)
  - [Ruby](#ruby)
  - [Rust](#rust)
  - [Scala](#scala)
  - [Swift](#swift)
  - [TypeScript](#typescript)
  - [V](#v)
  - [WebAssembly](#webassembly)
- [Web Development](#web-development)
  - [Web Frameworks](#web-frameworks)
  - [Node.js](#nodejs)
  - [React.js](#reactjs)
  - [Vue.js](#vuejs)
  - [WebAssembly Frameworks](#webassembly-frameworks)
  - [Web Libraries](#web-libraries)
  - [WordPress](#wordpress)
- [Development Environments](#development-environments)
- [Design and Illustrations](#design-and-illustrations)
- [Operating Systems](#operating-systems)
  - [Android](#android)
  - [Apple Systems](#apple-systems)
  - [Windows](#windows)
  - [Linux](#linux)
  - [Linux Distributions](#linux-distributions)
  - [Other OS](#other-os)
- [DevOps and System Administration](#devops-and-system-administration)
  - [Data Management](#data-management)
  - [API](#api)
  - [Containers](#containers)
  - [Server Applications](#server-applications)
- [Computer Security](#computer-security)
  - [Security Tools](#security-tools)
- [Blockchain and Cryptocurrency](#blockchain-and-cryptocurrency)
  - [Currencies](#currencies)
- [Simulation](#simulation)
  - [Flight Simulation](#flight-simulation)
- [Game Development](#game-development)
  - [Game Design](#game-design)
  - [Game Engines](#game-engines)
  - [Game Development Tools](#game-development-tools)
  - [Gaming on Linux](#gaming-on-linux)
- [Virtual Reality](#virtual-reality)
- [Machine Learning](#machine-learning)
  - [Data Science](#data-science)
- [Career](#career)
- [Discord Development](#discord-development)
- [Attribution](#attribution)

## How to Navigate

If you're familiar with other popular [awesome lists](https://github.com/sindresorhus/awesome/blob/main/readme.md), you may find this list a little anomalous. For starters take a look at the available [badges](./badges.md). `Notable channels` are exploratory, and can be used for looking up a particular topic. A community may offer channels dedicated to more than one spoken languages that `Language` is there for. You can start contributing from [here](./CONTRIBUTING.md). Read this [FAQ](./FAQ.md#what-about-discords-poor-privacy-policy) about Discord's __privacy policy__ and answers to other frequent questions.

- A quick lookup from browser `ctrl + f` may help to find communities by a topic
- Click on the [<img height="18px" width="18px" alt="Homepage URL" src="images/badges/homepage.webp">](#) or [<img height="18px" width="18px" alt="Git Repository" src="images/badges/git.webp">](#) icon to visit the community's official website or git repository page

## Programming in General

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Some Discord counterpart communities to Stack Overflow.

### Support Communities

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/devcord.webp">

[__Devcord__](https://discord.com/invite/devcord) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://devcord.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/devcord) \
Notable Channels: `#javascript`, `#frontend`, `#backend`, `#php`, `#mobile`, `#design`, `#devops`, `#career`, `#code-review`, `#webtopic`, `#desktopic`, `#community-projects`, `#paid-work`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/developer_s_keep.webp">

[__Developer's Keep__](https://discord.com/invite/vG5uukx) \
Notable Channels: `#project-showcase`, `#java-jvm`, `#python`, `#c-family`, `#javascript`, `#c-sharp`, `#hardware` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/engineerman.webp">

[__EngineerMan__](https://discord.com/invite/engineerman) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCrUL8K81R4VBzm-KOYwrcxQ) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/engineer-man) \
Notable Channels: `#linux`, `#c-cpp-csharp`, `#python`, `#go-rust`, `#js-ts-node-deno-html-css`, `#java-kotlin`, `#julia-ruby-swift`, `#datascience-sql`, `#os-hardware-robotics`, `#networking-security-mods` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/garbage_collectors.webp">

[__Garbage Collectors__](https://discord.com/invite/aJwTAgS) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/garbage-collectors-development) \
Notable Channels: `#python exercises`, `#code feedback`, `#collaboration`, `#csharp`,`#java`, `#c and cpp`, `#web`, `#mobile`, `#security`, `#algos and ds`, `#networking`, `#resources`, `#machinelearning` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/programming.webp">

[__Programming__](https://discord.com/invite/010z0Kw1A9ql5c1Qe) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/strinking/) \
Notable Channels: `#data-science`, `#graphics-programming`, `#dev-tools-and-ops`, `#unix-like`, `#web-dev`, `#security`, `#c-language`, `#java-jvm`, `#javascript`, `#odin-lang`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/programming_discussions.webp">

[__Programming Discussions__](https://discord.com/invite/9zT7NHP) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://progdisc.club/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/progdisc) \
Notable Channels: `#beginners`, `#interview-prep`, `#java-and-jvm`,`#c-sharp-and-dotnet`, `#ai-and-ml`, `#asm-and-systems`, `#cs-theory`, `#databses`, `#software-architecture`, `#shells`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_codinghelp.webp">

[__r/CodingHelp__](https://discord.com/invite/dbe5NnA) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/CodingHelp/) \
Notable Channels: `#general`, `#html-css`, `#javascript`, `#php`, `#java`, `#python`, `#csharp`, `#c-cpp` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_coding_den.webp">

[__The Coding Den__](https://discord.com/invite/code) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/TheCodingDen) \
Notable Channels: `#general`, `#cil-and-runtime`, `#kotlin`,`#scala`, `#android`, `#ios`, `#nodejs`, `#ruby`, `#php`, `#web-frameworks`, `#algorithms`, `#regex`, `#systems-and-servers`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_odin_project.webp">

[__The Odin Project__](https://discord.gg/V75WSQG) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.theodinproject.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/TheOdinProject) \
Notable Channels: `#odin-general`, `#creations-showcase`, `#ubuntu-help`,`#tech-support-general`, `#virtualbox-help`, `#git-help`, `#html-css-help`, `#javascript-help`, `#nodejs-help`, `#rails-help`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_programmers_hangout.webp">

[__The Programmer's Hangout__](https://discord.com/invite/programming) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://theprogrammershangout.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/the-programmers-hangout) \
Notable Channels: `#beginners`, `#javascript`, `#java`, `#kotlin`,`#rust-lang`, `#ruby`, `#ai-and-ml`, `#career-advice`, `#databases`, `#gamedev`, `#ux-and-ui`, `#shells`, `#version-control`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/webdev_and_web_design.webp">

[__webdev and web_design__](https://discord.com/invite/keD8rZp) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/webdev/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ljosberinn/webdev-support-bot) \
Notable Channels: `#dev-help`, `#dev-chat`, `#app-feedback`,`#design`, `#user-experience`, `#html`, `#css`, `#javascript`, `#typescript`, `js-framework`, `#react`, `#vue`, `#php`, `#dot-net`, `#devops`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/world_of_coding.webp">

[__World of Coding__](https://discord.com/invite/program) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://world-of-coding.tech/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/World-of-Coding) \
Notable Channels: `#hire-devs`, `#coding-help`, `#programming-help`, `#hacking`, `#infosec`, `#linux`, `#web-dev`, `#game-dev`, `#js`, `#python` \
Language: English

### Competitive Programming

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cp_community.webp">

[__CP Community__](https://discord.com/invite/algorithms) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://codeforces.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Codeforces) \
Notable Channels: `#beginner-questions`, `#general-cp`, `#problem-spoilers`, `#ioi`,`#icpc`, `#math`, `#errichto-yt`, `#vplanet` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/kilonova.webp">

[__Kilonova__](https://discord.com/invite/Qa6Ytgh) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://kilonova.ro/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/KiloProjects/Kilonova) \
Notable Channels: `#general`, `#platform-errors`, `#platform-bugs`, `#suggestions`, `#support`, `#solution-discussions` \
Language: Romanian \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/roalgo.webp">

[__RoAlgo__](https://discord.com/invite/roalgo) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/roalgo-discord) \
Notable Channels: `#general`, `#general-avansati`, `#resurse`, `#concursuri`, `#potd-problems`, `#ajutor`, `#cf-atcoder` \
Language: Romanian, English \
<br>

## Art of Computer Science

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Discussions on the concepts behind modern, and classical computing and its kin.

### Computer Science

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/computer_science.webp">

[__Computer Science__](https://discord.com/invite/eF3Wjsd) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/)\
Notable Channels: `#computer-science`, `#resources`, `#algorithms-and-data-structures`,`#theory-of-computation`, `#information-and-coding-theory`, `#cryptography`, `#artificial-intelligence` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cs50.webp">

[__cs50__](https://discord.com/invite/QYZQfZ6) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.edx.org/course/cs50s-introduction-to-computer-science) \
Notable Channels: `#lectures`, `#scratch`, `#hello`,`#mario`, `#cash`, `#credit`, `#readability`, `#caesar`, `#substitution`, `#plurality`, `#runoff`, `#tideman`, `#c-to-python-sentimental`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

### Mathematics

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/mathematics.webp">

[__Mathematics__](https://discord.com/invite/BacbVax) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/)\
Notable Channels: `#prealg-algebra`, `#calculus`, `#linear-algebra`,`#computing-software`, `#probability-statistics`, `#discrete-math`, `#abstract-algebra`, `#questions`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

### Physics

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/physics.webp">

[__Physics__](https://discord.com/invite/N5jVwsg) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/)\
Notable Channels: `#questions`, `#undergrad-physics`, `#graduate-physics` `#mathematical-physics`, `#astronomy-and-cosmology`, `#computational-physics`, `#engineering`, `#challenges` \
Language: English

### Other Sciences

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/biological_sciences.webp">

[__Biological Sciences__](https://discord.com/invite/QwSdffq) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/) \
Notable Channels: `#biology`, `#questions`, `#resources`, `#molecular-biology`, `#microbiology`, `#anatomy-and-physiology`, `#bioengineering`, `#bioinformatics`, `#ecology`, `#medical-sciences` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/chemistry.webp">

[__Chemistry__](https://discord.com/invite/eexdsFw) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/) \
Notable Channels: `#highschool-chemistry`, `#general-chemistry`, `#introductory-organic`, `#tech`, `#laboratory`, `#physical-chemistry`, `#inorganic-chemistry`, `#organic-chemistry`, `#biochemistry` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/climate_science.webp">

[__Climate Science__](https://discord.com/invite/QVtafau5Yp) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/) \
Notable Channels: `#climate-change-general`, `#resources`, `#questions-and-debates`, `#politics-activism-policy`, `#ecology-biology-sustainibility` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/homework_help.webp">

[__Homework Help__](https://discord.com/invite/YudDZtb) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](http://homework-help.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/spjy/hwh-bot) \
Notable Channels: `#challenges`, `#math`, `#post-calculus` `#biology`, `#chemistry`, `#physics`, `#english`, `#social-science`, `#history`, `#computer-science`, `#studio-art`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/science_and_technology.webp">

[__Science and Technology__](https://discord.com/invite/science) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/SciTechCommunity) \
Notable Channels: `#astronomy`, `#biology`, `#chemistry` `#engineering`, `#environment`, `#mathematics`, `#geometry`, `#calculus`, `#physics`, `#psychology`, `#technology`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

## Electrical

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Discussions on bare-bones circuit boards, microprocessors, and bleeding edge hardware.

### Engineering

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/_r_engineeringstudents.webp">

[__/r/EngineeringStudents__](https://discord.com/invite/engineeringstudents) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/EngineeringStudents/) \
Notable Channels: `#homework`, `#college-101-and-applications`, `#academics-and-teaching`, `#research`, `#jobs-resume-finance`, `#hobbies-and-projects` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/aerospace_and_mech_eng.webp">

[__Aerospace & Mech Eng__](https://discord.com/invite/fYkvJNQ) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/)\
Notable Channels: `#general-engineering`, `#events`, `#questions`, `#astronautics-aeronautics` `#thermo-fluids`, `#mechanics`, `#structural-analysis`, `#mechatronics`, `#design` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amulius___engineering____chill__.webp">

[__Embedded Engineering - Amulius__](https://discord.com/invite/SrJEYjq) \
Notable Channels: `#general`, `#electrical`, `#civil`, `#mechanical`, `#software`, `#chemical`, `#aerospace`, `#industrial`, `#engineering-lobby`, `#student-lobby`, `#careeer-advice`, `#projects-showcase` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/electrical_engineering.webp">

[__Electrical Engineering__](https://discord.com/invite/tUU9dPp) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.discordnetwork.com/)\
Notable Channels: `#electrical-engineering`, `#questions`, `#computer-engineering` `#electronics-engineering`, `#power-engineering`, `#signal-controls`, `#mechanical-engineering`, `#robotics` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/real_engineering_discord.webp">

[__Real Engineering Discord__](https://discord.com/invite/emx3W4Z) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCR1IuLEqb6UEA_zQ81kwXfg) \
Notable Channels: `#the-library-discussions`, `#study-and-career-help`, `#sustainable-engineering`, `#bioengineering`, `#mechanical-engineering`, `#aero-and-astronautical`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

### Microprocessors and Microcontrollers

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amulius___embedded_engineering__.webp">

[__Amulius - Embedded Engineering__](https://discord.com/invite/SrJEYjq) \
Notable Channels: `#general`, `#arm`, `#c-cpp`, `#esp32-espressif`, `#linux`, `#pic`, `#rust`, `#risc-v`, `#rtos-gpos`, `#projects-advice`, `#career`, `#dsp-machine-learning`, `#fpga`, `#pcb`, `#protocols-rf` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/arduino.webp">

[__Arduino__](https://discord.gg/jQJFwW7) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://arduino.cc/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/BluLightShow/arduino-bot) \
Notable Channels: `#arduino-discussion`, `#product-help`, `#coding-help`, `#pcb-help`,`#adafruit-help`, `#show-off-your-ideas`, `#project-ideas` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/raspberry_pi.webp">

[__Raspberry Pie__](https://discord.com/invite/raspberry-pie-204621105720328193) \
Notable Channels: `#tech-talk`, `#i-need-help`, `#python-dev`, `#projects-chat`,`#project-showcase`, `#show-off-your-ideas`, `#project-ideas` \
Language: English

### DIY

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/adafruit.webp">

[__Adafruit__](https://discord.com/invite/5FBsBHU) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.adafruit.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/adafruit) \
Notable Channels: `#circuitpython`, `#arduino`, `#3dprinting`, `#radio`,`#raspberry-pi`, `#wearables`, `#robotics`, `#help-with-projects`, `#iot`, `#events` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/diy_tech.webp">

[__DIY Tech__](https://discord.com/invite/diytech) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/KazWolfe/HuskyBot) \
Notable Channels: `#programming`, `#hardware-help`, `#software-help`,`#code-review`, `#project-showcase`, `#audio-tech`, `#retro-tech` \
Language: English

### Internet of Things

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/home_automation.webp">

[__/r/Home Automation__](https://discord.com/invite/homeautomation) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/homeautomation/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/dgparker/rosie-the-bot) \
Notable Channels: `#suggestions`, `#smartspeakers`, `#smarthub`, `#lighting`, `#security`, `#iot-dev`, `#buy-sell-trade` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/home_assistant.webp">

[__Home Assistant__](https://discord.com/invite/c5DvZ4e) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.home-assistant.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/home-assistant) \
Notable Channels: `#homeassistant`, `#support`, `#automations`, `#frontend`, `#devices`, `#templates`, `#add-ons`, `#apps`, `#cameras`, `#diy`, `#node-red`, `#voice-assistants`, `#zigbee`, `#development` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/homebridge.webp">

[__Homebridge__](https://discord.com/invite/Z8jmyvb) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://homebridge.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/homebridge) \
Notable Channels: `#general`, `#homekit`, `#ui`, `#config`, `#raspberry-pi`, `#raspbian-image`, `#macos`, `#bwindows`, `#docker`, `#verified-plugins`, `#plugins`, `#homebridge-beta-testing`, `#plugin-development` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_homekit.webp">

[__r/HomeKit__](https://discord.com/invite/vNANPCMaY9) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/HomeKit/) \
Notable Channels: `#general`, `#homekit-discussion`, `#hk-showcase`, `#hk-questions-help`, `#homepod-discussion`, `#hp-questions-help`, `#homebridge-discussion`, `#hb-plugin-showcase` \
Language: English

### IoT Applications

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/appdaemon.webp">

[__AppDaemon__](https://discord.com/invite/Mx5qafB) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/hassio-addons/addon-appdaemon) \
Notable Channels: `#appdaemon`, `#hadashboard` \
Language: English, Deutsch, Nederlands \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/deconz.webp">

[__deCONZ__](https://discord.com/invite/QFhTxqN) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/dresden-elektronik/deconz-rest-plugin) \
Notable Channels: `#advice`, `#device-issues`, `#home-assisstant-issues`, `#setup-issues`, `#other-issues`, `#phoscon` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/esphome.webp">

[__ESPHome__](https://discord.com/invite/KhAMKrd) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://esphome.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/esphome) \
Notable Channels: `#general`, `#devs` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tasmota.webp">

[__Tasmota__](https://discord.com/invite/Ks2Kzd4) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tasmota.github.io/docs/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/arendst/tasmota) \
Notable Channels: `#general`, `#issues`, `#3d-prints-and-cnc`, `#projects-gallery`, `#deals-and-promotions` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/zigbee2mqtt.webp">

[__zigbee2mqtt__](https://discord.com/invite/NyseBeK) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.zigbee2mqtt.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/koenkk/zigbee2mqtt) \
Notable Channels: `#release-branch`, `#development-branch`, `#installation-hassio`, `#installation-docker`, `#zigbee2mqtt`, `#zigbee-shepherd`, `#documentation`, `#hardware` \
Language: English

## Hardware

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

From fixing broken parts of various computer hardware to discussions on CPU, GPU, keyboards, mice, phones, tablets, smartwatches, headphones, and other related gadgets.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/dave2d.webp">

[__Dave2D__](https://discord.com/invite/dave2d) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCVYamHliCI9rw1tHR1xbkfw) \
Notable Channels: `#laptop-suggestions`, `#gaming-laptops-suggestions`, `#phones`, `#keyboards-mice`, `#desktops`, `#tablets`, `#vehicles`, `#deals`, `#tech-support` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/electronics_repair_school.webp">

[__Electronics Repair School__](http://invite.ers.repair/) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCooKQlg-HZ0PFAPc4Ymg3RA) \
Notable Channels: `#projects`, `#tools-and-parts`, `#networking`, `#automotive`, `#solar-energy`, `#beginners-area`, `#diy-arduino-rpi-stm32`, `#laptops`, `#pc-repair`, `#phones`, `#consoles`, `#tablets` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ltt_official.webp">

[__LTT Official__](https://discord.com/invite/ltt) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/user/LinusTechTips) \
Notable Channels: `#tech-chat`, `#tech-support`, `#my-rig`, `#overcloaking`, `#creative`, `#development`, `#crypto-currency`, `#networking`, `#audio`, `#vr` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/monitor_enthusiasts.webp">

[__Monitor Enthusiasts__](https://discord.com/invite/MZwg5cQ) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/Monitors/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/DWF967/MonitorBot) \
Notable Channels: `#monitors-discussion`, `#ultrawide-discussion`, `#mounts-and-desks`, `#help`, `#setups-and-battlestations` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/pc_master_race.webp">

[__PC MASTER RACE__](https://discord.com/invite/pcmr) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/pcmasterrace/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/izy521/Sera-PCMR) \
Notable Channels: `#build-help`, `#tech-support`, `#overclocking`, `#programming`, `#linux`, `#mac-os`, `#content-sharing` \
Language: English

### Phones

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/xiaomi_community.webp">

[__Xiaomi Community__](https://discord.com/invite/xiaomi) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/XiaomiWiki) \
Notable Channels: `#mi_a_series`, `#mi_mix_series`, `#mi_max_series`, `#mi_note_series`, `#mi_series`, `#redmi_k_series`, `#redmi_series`, `#poco_series`, `#mi_wearables`, `#mi_notebook`, `#mi_pad` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_googlepixel.webp">

[__r/GooglePixel__](https://discord.com/invite/googlepixel) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/GooglePixel/) \
Notable Channels: `#tech-support`, `#pixelography`, `#themes` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_iphone.webp" />

[__iPhone | iOS__](https://discord.com/invite/r5McVVhqqs) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://iphonediscord.info) \
Notable Channels: `#apple`, `#shot-on-iphone`, `#ios-beta`, `#setup-showcase`, `#support`, `#what-should-i-buy` \
Language: English
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_oneplus.webp">

[__r/oneplus__](https://discord.com/invite/oneplus) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/iphone/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Rithari/OnePlusBot) \
Notable Channels: `#oneplus`, `#oneplus-n10-n100`, `#oneplus8t`, `#oneplus-nord`, `#oneplus8-series`, `#oneplus7t-series`, `#oneplus7-series`, `#oneplus6-6t`, `#legacy`, `#accessories` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_samsung.webp">

[__r/Samsung__](https://discord.com/invite/qWUgeUk) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/samsung/) \
Notable Channels: `#samsung`, `#purchase-advice`, `#accessories`, `#roms`, `#support` \
Language: English \
<br>

### Smartwatches

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/fitbit.webp">

[__Fitbit__](https://discord.com/invite/4ujeheG) \
Notable Channels: `#fitbit`, `#fitbit-coding`, `#fitbit-design`, `#fitbit-animation`, `#fitbit-widgets`, `#fitbit-typescript` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_rebble_alliance.webp">

[__The Rebble Alliance__](https://discord.com/invite/aRUAYFN) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://rebble.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/pebble-dev) \
Notable Channels: `#pebble`, `#rebble-help`, `#app-dev`, `#rockyjs`, `#smartstraps`, `#rebble-grants`, `#firmware`, `#hardware`, `#mobile-apps`, `#appstore`, `#web-services`, `#bipdev` \
Language: English

### Keyboards

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/qmk.webp">

[__QMK__](https://discord.com/invite/Uq7gcHh) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://qmk.fm/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/qmk) \
Notable Channels: `#help`, `#firmware`, `#cli`, `#configurator`, `#via`, `#toolbox`, `#webhooks`, `#configurator_log`, `#hardware`, `#ergonomics`, `#programming` \
Language: English

### Retro Computers

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amigadev.webp">

[__AmigaDev__](https://discord.com/invite/Dfba7Yb) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.amigadev.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/AmigaPorts) \
Notable Channels: `#ace`, `#milkytracker`, `#sdl`, `#website`, `#scummvm`, `#68k-arm`, `#python`, `#arexx`, `#amos`, `#c-and-cpp`, `#amiga-68k`, `#amiga-ppc`, `#aros`, `#morphos`, `#warpos-sonnet`, `#vbcc` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/official_commodore_64.webp">

[__Official Commodore 64__](https://discord.com/invite/trDvARJ) \
Notable Channels: `#general`, `#hardware`, `#emulation`, `#programming`, `#support`, `#other-commodore-machines`, `#other-classic-computers` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/official_commodore_amiga.webp">

[__Official Commodore Amiga__](https://discord.com/invite/92RmK7ZUrE) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://forum.amiga.org) \
Notable Channels: `#general`, `#amigashell`, `#next-gen`, `#emulation-and-fpga`, `#hardware`, `#multimedia`, `#coding`, `#accessory-port` \
Language: English

## Programming Languages

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Programming languages used in embedded systems, web frameworks, automation and mobile apps.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/programming_language_development.webp">

[__Programming Language Development__](https://discord.com/invite/HDyqM2n) \
Notable Channels: `#langdev`, `#programming`, `#projects`, `#resources` \
Language: English \
<br>

### Language Paradigms

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/functional_programming.webp">

[__Functional Programming__](https://discord.com/invite/K6XHBSh) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/mniip/discord-eval) \
Notable Channels: `#haskell`, `#tooling`, `#lisp-beginners`, `#clojure`, `#dependent-types`, `#agda`, `#coq`, `#idris` `#compilers`, `#scala`, `#elm`, `#f-sharp`, `#elixir`, `#purescript`, `#type-theory` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/low_level_programming.webp">

[__Low-Level Programming__](https://discord.com/invite/5ssDFZS) \
Notable Channels: `#rust`, `#assembly`, `#c-lang`, `#c-cpp`, `#wasm`, `#compilers`, `#embedded`, `#game-dev`, `#hardware` `#linux`, `#os-development` \
Language: English

### Assembly

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/assemblers_assemble.webp">

[__Assemblers Assemble__](https://discord.com/invite/Km5VzKj) \
Notable Channels: `#x86`, `#arm`, `#z80`, `#6502`, `#jvm`, `#mips`, `#m68k`, `#brainfu*k`, `#nand-nor`, `#other` \
Language: English \
<br>

### C and C++

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/include.webp">

[__#include__](https://discord.com/invite/vSYgpmPrra) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.includecpp.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/mniip/discord-eval) \
Notable Channels: `#assembly`, `#c`, `#gpu`, `#audio`, `#build-systems`, `#cpp`, `#embedded`, `#learning`, `#security` `#conferences`, `#tooling`, `#2d-graphics`, `#clion`, `#catch2`, `#qt` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/c_plus_plus_help.webp">

[__C++ Help__](https://discord.com/invite/J5hBe8F) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Eelis/geordi) \
Notable Channels: `#cpp-questions`, `#help`, `#advanced`, `#gamedev`, `#project-showcase` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/together_c_and_c_plus_plus.webp">

[__Together C & C++__](https://discord.com/invite/vnyVmAE) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Headline/discord-compiler-bot) \
Notable Channels: `#c_general`, `#cpp_general`, `#assembly`, `#code_review`, `#gamedev`, `#graphics`, `#audio`, `#programming_environment`, `#collaboration`, `#unix`, `#other_langs_help`, `#math` \
Language: English

<!-- markdownlint-disable MD003-->
<!-- markdownlint-disable MD020-->
### C#

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/c_sharp.webp">

[__C#__](https://discord.com/invite/csharp) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](http://discord-csharp.github.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/discord-csharp) \
Notable Channels: `#general_csharp`, `#beginner_questions`, `#projects`, `#code-review`, `#career-talk`, `#web`, `#gui`, `#game-dev`, `#database`, `#architecture-and-tooling`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/c_sharp_inn.webp">

[__C# Inn__](https://discord.gg/rCMKcUU) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/csinn) \
Notable Channels: `#projects`, `#mentors`, `#learning-discussion`, `#questions`, `#architecture`, `#code-review`, `#web`, `#python`, `#ui-ux` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/entitas.webp">

[__Entitas__](https://discord.com/invite/uHrVx5Z) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/entitas_csharp) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/sschmid/Entitas-CSharp) \
Notable Channels: `#general`, `#showcase`, `#variants`, `#unity` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/opentk.webp">

[__opentk__](https://discord.com/invite/6HqD48s) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://opentk.net/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/opentk) \
Notable Channels: `#general`, `#support`, `#development`, `#showcase`, `#showcase-discussion` \
Language: English \
<br>

### Clojure

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/clojurians.webp">

[__Clojurians__](https://discord.com/invite/v9QMy9D) \
Notable Channels: `#general`, `#clojure`, `#clojurescript`, `#emacs`, `#editors`, `#interop-therapy`, `#boot`\
Language: English \
<br>

### CSS

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cascading-style-sheets.webp">

[__cascading-style-sheets__](https://discord.com/invite/pFc6XmH) \
Notable Channels: `#new-to-css`, `#intermediate-users`, `#blog-posts`, `#less`, `#sass`, `#scss`, `#native-css-feature`, `#tailwind`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tailwind_css.webp">

[__Tailwind CSS__](https://discord.com/invite/7NF8GNe) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tailwindcss.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tailwindcss) \
Notable Channels: `#help`, `#tailwind-css`, `#core-dev`, `#plugins`, `#docs`, `#tailwind-ui`, `#design`, `#development`, `#showcase` \
Language: English

### Elixir

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/elixir_language.webp">

[__Elixir Language__](https://discord.com/invite/elixir) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://elixir-lang.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/elixir-lang) \
Notable Channels: `#elixir`, `#erlang`, `#ecto`, `#nerves`, `#phoenix`, `#absinthe`, `#alchemy`, `#frontend`, `#jobs` \
Language: English \
<br>

### Go

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/discord_gophers.webp">

[__Discord Gophers__](https://discord.com/invite/PxwHvBS) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/bwmarrin/discordgo)\
Notable Channels: `#golang`, `#job-market-only`, `#go-art-only`, `#go-news-only`, `#discordgo`, `#disgord`, `#dca`, `#arikawa`\
Language: English

### Haxe

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/haxe.webp">

[__Haxe__](https://discord.com/invite/0uEuWH3spjck73Lo) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://haxe.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/HaxeFoundation) \
Notable Channels: `#general`, `#show-your-work`, `#tools`, `#flixel`, `#heaps`, `#kha`, `#nme`, `#haxepunk`, `#react`, `#haxe-ui`, `#lix`, `#coconut` \
Language: English

### Java

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/JavaDiscord.webp">

[__Java__](https://join.javadiscord.net) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://javadiscord.net) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Java-Discord) \
Notable Channels: `#question-of-the-week`, `#share-knowledge`, `#community-jam`, `#resources` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/together_java.webp">

[__Together Java__](https://discord.gg/hVtnwGd) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Together-Java) \
Notable Channels: `#geek-speak`, `#java-help`, `#android-help`, `#framework-help`, `#c_cpp_help`, `#algorithms_help`, `#architecture-help`, `#code_review`, `#ui_ux_help`\
Language: English

### JavaScript

[TypeScript↴](#typescript)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/deno.webp">

[__Deno__](https://discord.com/invite/deno) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://deno.land/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/denoland) \
Notable Channels: `#general`, `#showcase`, `#help`, `#dev`, `#rust-libs` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/electron.webp">

[__electron__](https://discord.com/invite/electron) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://electronjs.org) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/electron) \
Notable Channels: `#general`, `#help`, `#electron-builder`, `#electron-forge`, `#electron-packager`, `#fiddle`, `#security`, `#reactjs`, `#vuejs`, `#jobs`, `#projects` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/eslint.webp">

[__ESLint__](https://discord.com/invite/8szcydm) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://eslint.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/eslint) \
Notable Channels: `#tsc-meetings`, `#general`, `#help`, `#lookwhatimade`, `#developers`, `#season-of-docs` \
Language: English, 日本語 \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/reasonml.webp">

[__ReasonML__](https://discord.com/invite/reasonml) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://reasonml.github.io/en/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/facebook/reason) \
Notable Channels: `#general`, `#reasonconf`, `#native-development`, `#bucklescript`, `#job-openings`, `#react`, `#ocaml`, `#reason-dojo`, `#reason-core-dev`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/speakjs.webp">

[__SpeakJS__](https://discord.com/invite/dAF4F28) \
Notable Channels: `#collaboration`, `#code-review`, `#help`, `#react`, `#angular`, `#vue`, `#svelte`, `#jquery`, `#gatsby`, `#node`, `#graphql`, `#electron`, `#threejs`, `#webgl`\
Language: English

### Lisp

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/lisp.webp">

[__Lisp__](https://discord.com/invite/hhk46CE) \
Notable Channels: `#clojure`, `#common-lisp`, `#emacs-lisp`, `#racket`, `#scheme`, `#lisp-gamedev`, `#beginner-questions`, `#algorithms`, `#compiler-theory`\
Language: English

### Lua

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/lua_scripters.webp">

[__Lua Scripters__](https://discord.com/invite/7wu7ZsW) \
Notable Channels: `#scripting`, `#creations`, `#roblox`, `#gmod`, `#wow`, `#fivem`, `#luajit`, `#lua-c`, `#terra`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/luvit_io.webp">

[__Luvit.io__](https://discord.com/invite/luvit) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://luvit.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/luvit/luvit)\
Notable Channels: `#general`, `#lua`, `#luvit`, `#luvi`, `#luv`, `#lit` \
Language: English \
<br>

### Pascal

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/delphi_community.webp">

[__Delphi Community__](https://discord.com/invite/c382VBk) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://delphi-community.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Delphi-Community/Delphi-Community-Page) \
Notable Channels: `#general-chat`, `#programming`, `#user-interface`, `#network`, `#database`, `#homework`, `#user-projects`, `#job-exchange` \
Language: English, Deutsch, Pусский, Afrikaans, Português, Español, Français

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/delphi_programmers.webp">

[__Delphi Programmers__](https://discord.gg/invite/ZhtCdRzqQ4) \
Notable Channels: `#general`, `#general-rad-studio`, `#rtl`, `#ide-tooling`, `#vcl`, `#fmx`, `#crossvcl`, `#general-web`, `#datasnap`, `#radserver`, `#tmswebcore`, `#skia4delphi` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/free_pascal.webp">

[__Unofficial Free Pascal__](https://discord.gg/invite/mKPCyJ8) \
Notable Channels: `#general`, `#support-free-pascal`, `#support-lazarus`, `#support-delphi`, `#support-misc`, `#projects`, `#resources` \
Language: English

### PHP

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/flarum.webp">

[__Flarum__](https://discord.com/invite/3fnPSjA) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://flarum.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/flarum) \
Notable Channels: `#chitchat`, `#support`, `#extensions`, `#extend`, `#internals`, `#docs`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/grav.webp">

[__Grav__](https://discord.com/invite/5VhYVkR) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://getgrav.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/getgrav) \
Notable Channels: `#general`, `#theming`, `#development`, `#documentation`, `#plugin-requests`, `#social`, `#testing` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/laravel.webp">

[__Laravel__](https://discord.com/invite/mPZNm7A) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://laravel.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/laravel) \
Notable Channels: `#general`, `#cashier`, `#envoyer`, `#forge`, `#help`, `#homestead`, `#horizon`, `#hype`, `#internals`, `#lumen`, `#meetups`, `#nova`, `#passport`, `#jobs`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/php_community.webp">

[__PHP Community Chat__](https://discord.gg/nh9QV3u39U) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://phpcommunity.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/phpcommunity) \
Notable Channels: `#phpc`, `#php-internals`, `#php-doc`, `#php-internals`, `#phpc-foundation`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tenancy.webp">

[__Tenancy__](https://discord.com/invite/4amsQJ7) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tenancy.dev/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tenancy) \
Notable Channels: `#brewery`, `#coding`, `#support`, `#internals`, `#multi-tenant-support`\
Language: English \
<br>

### Python

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/microsoft-python.webp">

[__microsoft-python__](https://discord.com/invite/b8YJQPx) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/pythonvscode) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/microsoft/vscode-python) \
Notable Channels: `#python-virtual-labs`, `#azure`, `#data-science`, `#iot`, `#postgres`, `#vscode` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/python.webp">

[__Python__](https://discord.com/invite/python) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://pythondiscord.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/python-discord/) \
Notable Channels: `#python-discussion`, `#careers`, `#help`, `#async`, `#computer-science`, `#database`, `#data-science`, `#dev-ops`, `#discord-py`, `#game-development`, `#security`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<!-- omit in toc -->
#### Kivy

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/kivy.webp">

[__Kivy__](https://discord.com/invite/djPtTRJ) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://kivy.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/kivy) \
Notable Channels: `#general`, `#support`, `#your-projects`, `#dev`, `#python-for-android`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/kivymd.webp">

[__KivyMD__](https://discord.com/invite/wu3qBST) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCl72hvzwQ0rXUMBKTsKjRAA) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/HeaTTheatR/KivyMD) \
Notable Channels: `#general`, `#support`, `#suggestions-for-improvements`, `#users-gallery`, `#kivymd-studio` \
Language: English, русский \
<br>

### Ruby

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ruby.webp">

[__Ruby__](https://discord.com/invite/ruby-518658712081268738) \
Notable Channels: `#general`, `#ruby-steep`, `#ruby-help`, `#rails-help`, `#challenges`, `#ruby-arcana`, `#hiring`, `#seeking` \
Language: English

### Rust

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/arorust.webp">

[__Ärorust__](https://discord.com/invite/6wFvsFWfnu) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/AeroRust) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/AeroRust) \
Notable Channels: `#resources`, `#drones`, `#space`, `#general-aviation`, `#rtos`, `#osal`, `#splice`, `#godwit`, `#ideas`, `#books`, `#conferences` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/rust_programming_language_community_server.webp">

[__Rust Programming Language Community Server__](https://discord.com/invite/aVESxV8) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ivandardi/RustBot) \
Notable Channels: `#beginners`, `#code-review`, `#dev-tools`, `#black-magic`, `#macros`, `#async`, `#crypto-and-security`, `#games-and-graphics`, `#lang-dev`, `#net-and-web`, `#os-dev`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tauri_apps.webp">

[__Tauri Apps__](https://discord.com/invite/SpmNs4S) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tauri.studio) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tauri-apps) \
Notable Channels: `#webview`, `#didathing`, `#help`, `#gamedevs`, `#app-devs`, `#vue-cli-plugin`, `#testing-core`, `#documentation`, `#community-projects`, `#working-groups`, `#cli-node`, `#core-rust` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_rust_programming_language.webp">

[__The Rust Programming Language__](https://discord.com/invite/rust-lang) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.rust-lang.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/rust-lang) \
Notable Channels: `#beginners`, `#contribute`, `#community-team`, `#rustbridge`, `#design`, `#compiler`, `#wg-grammar`, `#wg-async-foundation`, `#type-theory`, `#wg-wasm`, `#wg-gamedev`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tokio.webp">

[__Tokio__](https://discord.com/invite/tokio) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tokio.rs/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tokio-rs) \
Notable Channels: `#tokio-users`, `#tokio-dev`, `#tokio-docs`, `#ecosystem`, `#butte`, `#hyper`, `#h3`, `#kube`, `#mio`, `#prost`, `#reqwest`, `#tonic`, `#tower`, `#tracing`, `#warp`, `#loom`, `#rdbc`, `#metrics` \
Language: English

### Scala

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/scala.webp">

[__Scala__](https://discord.com/invite/scala) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.scala-lang.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/scala) \
Notable Channels: `#scala-users`, `#scala-contributors`, `#scala-js`, `#scala-native`, `#tooling`, `#events`, `#jobs`, `#akka-users` \
Language: English

### Swift

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/swift.webp">

[__Swift__](https://discord.com/invite/0uZpB8GgRvoU12Ta) \
Notable Channels: `#wwdc`, `#general`, `#swift`, `#swiftui`, `#firebase`, `#xcode`, `#general-ios`, `#general-macos`, `#general-watchos`, `#interview`\
Language: English

### TypeScript

[JavaScript↰](#javascript)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/typescript_community.webp">

[__TypeScript Community__](https://discord.com/invite/typescript) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.typescriptlang.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/typescript-community) \
Notable Channels: `#ts-discussion`, `#help`, `#vue`, `#angular`, `#react`, `#language-design`, `#compiler`, `#architecture`, `#tooling`, `#devops`, `#site-localization`, `#deno`, `#meetups`, `#projects` \
Language: English

### V

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_v_language_and_apps.webp">

[__The V Language & Apps__](https://discord.com/invite/vlang) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vlang.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vlang) \
Notable Channels: `#v-development`, `#v-chat`, `#help`, `#bugs`, `#syntax`, `#ideas-and-suggestions`, `#documentation`, `#js-backend`, `#x64-backend`, `#v-ui`, `#volt`, `#gitly`, `#vid`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, français, 中文, español, 日本語, dansk, 한국어, português, polski, русский, tiếng-việt, italiano

### WebAssembly

[WebAssembly Frameworks↴](#webassembly-frameworks)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/assemblyscript.webp">

[__AssemblyScript__](https://discord.com/invite/assemblyscript) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.assemblyscript.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/AssemblyScript) \
Notable Channels: `#general`, `#help`, `#built-with-assemblyscript`, `#development`, `#community-group`, `#as-pect` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/webassembly.webp">

[__WebAssembly__](https://discord.com/invite/53u3EKq) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/WebAssembly) \
Notable Channels: `#general`, `#beginners`, `#cg`, `#jobs`, `#events`, `#summit`, `#wasm`, `#wasi`, `#web`, `#standalone`, `#generic`, `#emscripten`, `#javascript`, `#rust`, `#go` \
Language: English

## Web Development

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

The back-end of web, from single static page to complex web applications; usage of diverse frameworks, modules, linters, components, package managers, builders, Progressive Web Apps (PWA), everything that fuels the modern web.

### Web Frameworks

[WebAssembly Frameworks↴](#webassembly-frameworks)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/docusaurus.webp">

[__Docusaurus__](https://discord.com/invite/docusaurus) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://v2.docusaurus.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/facebook/Docusaurus) \
Notable Channels: `#docusaurus-users`, `#docusaurus-dev`, `#docusaurus-2-dogfooding`, `#docusaurus-2-dev`, `#docusaurus-zeit`, `#docusaurus-algolia`, `#docusaurus-1-to-2-migration` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/emberjs.webp">

[__emberjs__](https://discord.gg/emberjs) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://emberjs.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/emberjs) \
Notable Channels: `#ember-jobs`, `#help`, `#ember-clie`, `#ember-data`, `#topic-a11y`, `#topic-addon-development`, `#topic-backend`, `#dev-meta`, `#dev-ember-learning`, `#ember-addons`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, français, Deutsch, português, pусский, español

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/fastapi.webp">

[__FastAPI__](https://discord.com/invite/VQjSZaeJmf) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://fastapi.tiangolo.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tiangolo/fastapi) \
Notable Channels: `#discussion`, `#documentation`, `#advanced-questions`, `#articles-videos-podcasts`, `#showcase` \
Language: English, español, 中文, русский, português, italiano, Türkçe, Українська \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/fomantic-ui.webp">

[__Fomantic-UI__](https://discord.com/invite/UgzHNZF) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://fomantic-ui.com) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/fomantic) \
Notable Channels: `#general`, `#discussion`, `#need-help`, `#bugs`, `#feature-request` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/pallets_project.webp">

[__Pallets Project__](https://discord.gg/t6rrQZH) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://palletsprojects.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/pallets) \
Notable Channels: `#watercooler`, `#get-help`, `#sprint`, `#flask`, `#jinja`, `#click`, `#werkzeug`, `#flask-sqlalchemy`, `#flask-rebar`, `#wtforms`\
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/svelte.webp">

[__Svelte__](https://discord.gg/yy75DKs) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://svelte.dev/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/sveltejs/svelte) \
Notable Channels: `#svelte`, `#support`, `#sapper`, `#examples`, `#updates`, `#meetups`, `#future`, `#showcase`, `#nativedev`, `#internals`, `#gl`, `#jobs`, `#language-tools`, `#sveltesocietyday2020` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/uikit.webp">

[__UIkit__](https://discord.com/invite/NEt4Pv7) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://getuikit.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/uikit) \
Notable Channels: `#general`, `#i-made-this`, `#ideas`, `#uikit-4`, `#development`, `#html-css`, `#less`, `#js`, `#documentation` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vapor.webp">

[__VAPOR__](https://discord.com/invite/vapor) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vapor.codes/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vapor/vapor) \
Notable Channels: `#vapor`, `#leaf`, `#fluent`, `#auth`, `#async`, `#security`, `#meetups`, `#showcase`, `#today-i-learned`, `#apple-events`, `#deployment`, `#red`, `#cloud`, `#aws`, `swift`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, čeština, español, русский, Deutsch, 中文频道, Nederlands, 日本語, français, italiano, українська, 한국어

### Node.js

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/adonisjs_framework.webp">

[__AdonisJS Framework__](https://discord.gg/vDcEjq6) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://adonisjs.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/adonisjs) \
Notable Channels: `#proposals`, `#articles`, `#showcase`, `#general-v5`, `#auth`, `#database`, `#deploy`, `#testing`, `#validation`, `#view`, `#websocket` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nestjs.webp">

[__NestJS__](https://discord.com/invite/G7Qnnhy) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://nestjs.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nestjs) \
Notable Channels: `#support`, `#nestjs-core`, `#nestjs-config`, `#nestjs-graphql`, `#nestjs-mongoose`, `#nestjs-swagger`, `#nestjs-testing`, `#nestjs-typeform`, `#nestjs-cli`, `#internals` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nodecg.webp">

[__NodeCG__](https://discord.com/invite/GJ4r8a8) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://nodecg.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nodecg) \
Notable Channels: `#bundle-dev`, `#core-dev`, `#design`, `#typescript`, `#polymer`, `#vue`, `#react`, `#general`, `#post-your-work`, `#looking-for-dev` \
Language: English, 日本語

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nodeiflux.webp">

[__Nodeiflux__](https://discord.com/invite/vUsrbjd) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://nodejs.org/en/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nodejs) \
Notable Channels: `#general`, `#need-help`, `#i-made-this`, `#news-and-links`, `#libraries`, `#ops`, `#react`, `#jobs` \
Language: English \
<br>

### React.js

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/blitz_js.webp">

[__Blitz.js__](https://discord.com/invite/epMSc7Mpvt) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://blitzjs.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/blitz-js) \
Notable Channels: `#ideas`, `#help-blitz`, `#help-react`, `#help-prisma`, `#help-typescript`, `#blitz-content`, `#blitz-libraries`, `#built-with-blitz`, `#dev-general` \
Language: English, 中文, español

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gatsby.webp">

[__Gatsby__](https://discord.gg/gatsby) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.gatsbyjs.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://www.gatsbyjs.org) \
Notable Channels: `#general`, `#help`, `#showcase`, `#development`, `#starter-kits`, `#jobs`, `#graphql`, `#vuejs`, `#data-sourcing`, `#markdown`, `#drupal`, `#craft-cms`, `#dato-cms`, `#cockpit-cms` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/invertase_oss.webp">

[__Invertase OSS__](https://discord.com/invite/C9aK28N) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://rnfirebase.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/invertase) \
Notable Channels: `#notifee`, `#apple-authentication`, `#general`, `#i-need-help`, `#i-made-this`, `#contributing`, `#news`, `#modules` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/reactiflux.webp">

[__Reactiflux__](https://discord.gg/reactiflux) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reactiflux.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/reactiflux/reactiflux.com) \
Notable Channels: Notable Channels: `#help-react`, `#react-native`, `#js`, `#styling`, `#backend`, `#graphql`, `#code-review`, `#react-router`, `#redux`, `#react-bootstrap`, `#formik`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

### Vue.js

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/bootstrapvue.webp">

[__BootstrapVue__](https://discord.com/invite/j2Mtcny) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://bootstrap-vue.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/bootstrap-vue) \
Notable Channels: `#general`, `#i-made-this` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/buefy.webp">

[__Buefy__](https://discord.com/invite/ZkdFJMr) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://buefy.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/buefy) \
Notable Channels: `#general`, `#need-help`, `#feature-request`, `#i-made-this` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gridsome.webp">

[__Gridsome__](https://discord.com/invite/daeay6n) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://gridsome.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/gridsome) \
Notable Channels: `#general`, `#help`, `#documentation`, `#showcase`, `#development`, `#starter-kits`, `#plugin-releases`, `#graphql`, `#vuejs`, `#platforms` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nuxtjs.webp">

[__Nuxt.js__](https://discord.com/invite/b3dvQ9b) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://nuxtjs.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nuxt) \
Notable Channels: `#articles`, `#general`, `#showcase`, `#documentation`, `#proposals`, `#nuxt`, `#axios`, `#pwa`, `#webpack`, `#middleware`, `#apollo`, `#plugins`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, français, español, 日本語, português, русский, italiano, 中文,

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/quasar_framework.webp">

[__Quasar Framework__](https://discord.com/invite/5TDhbDg) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://quasar.dev/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/quasarframework/quasar) \
Notable Channels: `#i-made-this`, `#ideas`, `#jobs`, `#conferences`, `#upgrading`, `#app-extensions`, `#components`, `#cli`, `#spa`, `#ssr`, `#pwa`, `#umd`, `#cordova`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, اَلْعَرَبِيَّةُ‎, français, Türkçe, español, 日本語, dansk, 한국어, português, polski, русский

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vue_land.webp">

[__Vue Land__](https://discord.com/invite/HBherRA) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vue-land) \
Notable Channels: `#vuex-store`, `#vue-router`, `#code-help`, `#vue-cli`, `#vue-i18n`, `#vuepress`, `#composition-api`, `#vue3-discussions`, `#vue2-internals`, `#vue-testing`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, français, 汉语, español, 日本語, dansk, 한국어, português, polski, русский

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vue_material.webp">

[__Vue Material__](https://discord.com/invite/vuematerial) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vuematerial.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](http://github.com/vuematerial) \
Notable Channels: `#general`, `#need-help`, `#bugs`, `#ideas`, `#i-made-this` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vuesax.webp">

[__Vuesax__](https://discord.com/invite/2kHwpfe) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://lusaxweb.github.io/vuesax/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/lusaxweb/vuesax) \
Notable Channels: `#i-made-this`, `#issues`, `#ideas`, `#ssr`, `#design`, `#discord-help`, `#bugs`, `#pull-requests`, `#responsive`, `#proposals` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vuetify.webp">

[__Vuetify__](https://discord.com/invite/s93b7Fv) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vuetifyjs.com/en/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vuetifyjs) \
Notable Channels: `#help`, `#beginner-questions`, `#bug-reporting`, `#updating-versions`, `#tooling`, `#testing`, `#nuxt`, `#premium-theme-support`, `#women-who-vuetify`, `#frontend` \
Language: English, Deutsch, français, español, 日本語, 한국어, português, polski, русский

### WebAssembly Frameworks

[WebAssembly↰](#webassembly) • [Web Frameworks↰](#web-frameworks)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/seed_rs.webp">

[__seed-rs__](https://discord.com/invite/JHHcHp5) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://seed-rs.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/seed-rs) \
Notable Channels: `#app-architecture`, `#hooks-and-style`, `#devel`, `#support`, `#showcase`, `#documentation`, `#jobs` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/yew.webp">

[__Yew__](https://discord.com/invite/VQck8X4) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://yew.rs) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/yewstack) \
Notable Channels: `#development`, `#support`, `#showcase`, `#fetch`, `#functional`, `#router`, `#ssr`, `#gloo`, `#malvolio`, `#trunk`, `#ybc`, `#yewprint`, `#yew-state`, `#yew_styles` \
Language: English, 中文

### Web Libraries

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/docsify.webp">

[__docsify__](https://discord.com/invite/anXTEZk) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://docsify.js.org/#/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/docsifyjs) \
Notable Channels: `#general`, `#showcase`, `#help`, `#contribution-guidelines`, `#docsify-themeable`, `#plugins`, `#docsify-labs` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/egoist_oss.webp">

[__EGOIST OSS__](https://discord.com/invite/2t5mdCz) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://poi.js.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/egoist/poi) \
Notable Channels: `#ream`, `#saber`, `#poi`, `#cac`, `#bili`, `#sao`, `#codepan`, `#docup`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/solidjs.webp">

[__SolidJS__](https://discord.com/invite/solidjs) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://solidjs.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ryansolid/solid) \
Notable Channels: `#help`, `#reactivity`, `#ssr`, `#tooling`, `#typescript`, `#articles`, `#jobs`, `#showcase` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/storybook.webp">

[__storybook__](https://discord.gg/UUt2PJb) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://storybook.js.org/community/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/storybookjs/) \
Notable Channels: `#general`, `#support`, `#maintenance`, `#design`, `#presets`, `#documentation`, `#addons`, `#jobs`, `#frameworks`\
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/testing_library.webp">

[__Testing Library__](https://discord.com/invite/c6JN9fM) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://testing-library.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/testing-library) \
Notable Channels: `#general`, `#help`, `#dom`, `#react`, `#react-hooks`, `#native`, `#cypress`, `#vue`, `#angular`, `#svelte`, `#preact`, `#preact-hooks`, `#pptr`, `#testcafe`, `#nightwatch`, `#playground` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/yarnpkg.webp">

[__yarnpkg__](https://discord.com/invite/yarnpkg) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://classic.yarnpkg.com/en/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/yarnpkg) \
Notable Channels: `#contributing`, `#prs`, `#issues`, `#support`, `#general`\
Language: English \
<br>

### WordPress

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/wordpress.webp">

[__WordPress__](https://discord.com/invite/ysDu8W3) \
Notable Channels: `#general`, `#help`, `#gutenberg`, `#hosting-discussion`, `#themes`, `#plugins`, `#woocommerce`, `#ecommerce`, `#professional`, `#marketplace` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/wordpress_chat.webp">

[__WordPress Chat__](https://discord.com/invite/3gQGJQA) \
Notable Channels: `#security`, `#general`, `#devops`, `#plugin-development`, `#theme-development`, `#coding-questions`, `#css`, `#wp-cli`, `#seo`, `#beginner-help`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

## Development Environments

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Sketchbooks for software engineers; IDEs, text editors, modular editors, GUI terminals, emulators, or maybe a development utility so complex that can't be described in simple words?

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/blink.webp">

[__Blink__](https://discord.com/invite/ZTtMfvK) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://blink.sh/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/blinksh) \
Notable Channels: `#support`, `#themes-and-fonts`, `#shortcuts`, `#tips-and-tricks`, `#general`, `#dev`, `#design` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/doom_emacs.webp">

[__Doom Emacs__](https://discord.com/invite/v5rdp3kdDu) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/hlissner/doom-emacs) \
Notable Channels: `#troubleshooting`, `#how-do-i`, `#cli`, `#emacs-lisp`, `#protips`, `#project`, `#org-mode`, `#latex`, `#keyboards`, `#themes`, `#operating-systems`, `#hardware`, `#programming` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/files.webp">

[__Files__](https://discord.com/invite/files) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://files-community.github.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/files-community) \
Notable Channels: `#general`, `#design` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gitea.webp">

[__Gitea__](https://discord.com/invite/gitea) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://gitea.io) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/go-gitea) \
Notable Channels: `#configuration`, `#docker`, `#drone-integration`, `#reverse-proxies`, `#develop`, `#helm-chart`, `#tea` \
Language: English, Deutsch, português, 中文, français, español, Nederlands, русский, Czech \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/jetbrains_community.webp">

[__JetBrains Community__](https://discord.com/invite/yBQKN5b) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://jetbrains-community.github.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/JetBrains-Community) \
Notable Channels: `#general-os`, `#ideavim`, `#intellij-idea-community`, `#kotlin`, `#mps`, `#appcode`, `#clion`, `#datagrip`, `#datalore`, `#dotcover`, `#phpstorm`, `#pycharm`, `#resharper`, `#rider`, `#rubymine` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ms_paint_ide.webp">

[__MS Paint IDE__](https://discord.com/invite/RXmPkPJ) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://ms-paint-i.de/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/MSPaintIDE) \
Notable Channels: `#support`, `#ide-development`, `#newocr-development`, `#share-your-projects`, `#java` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ohmyzsh.webp">

[__ohmyzsh__](https://discord.com/invite/ohmyzsh) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://ohmyz.sh/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ohmyzsh) \
Notable Channels: `#discussion`, `#terminal-setups`, `#tech-support`, `#code`, `#suggestions`, `#wiki-rewrite` \
Language: English \
<br>

## Design and Illustrations

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

All about design systems, graphical illustrations, user interface and user experience.


<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/lospec.webp">

[__Lospec__](https://Lospec.com/Discord) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://lospec.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/lospec) \
Notable Channels: `#chat`, `#feedback`, `#collaboration`, `#fydo-tiles`, `#pixel-art`, `#palettes`, `#voxel-art`, `#low-poly-3d`, `#textmode`, `#chpitune`, `#programming`, `#in-game-builds`, `#events`, `#jobs` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/pixel_art.webp">

[__Pixel Art__](https://discord.com/invite/HPdmz4P) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/PixelArtDiscord/) \
Notable Channels: `#pixelart`, `#gamedev`, `#pixel-challenges`, `#featured-gallery`, `#art-gallery`, `#gallery-discussion`, `#pixelart-feedback`, `#animation-feedback`, `#tutorials` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_design_collective.webp">

[__The Design Collective__](https://discord.com/invite/zM5pgrc) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://medium.com/the-design-collective) \
Notable Channels: `#challenge`, `#design`, `#illustration`, `#ui-ux`, `#photo-film`, `#animation`, `#dev`, `#3d`, `#general-one`, `#client-area`, `#collab` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_spot.webp">

[__The Spot__](https://discord.gg/uz8JDW9) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.thespot.design/) \
Notable Channels: `#the-spotlight`, `#discussions`, `#critique`, `#showcase`, `#tech-help`, `#resources`, `#inspiration`, `#traditional`, `#illustration`, `#photography` \
Language: English

## Operating Systems

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

The underlying kernels that are responsible for managing application processes.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/operating_system_development.webp">

[__Operating System Development__](https://discord.com/invite/RnCtsqD) \
Notable Channels: `#osdev`, `#programming`, `#beginner`, `#bootloader-dev`, `#wiki`, `#projects`, `#resources` \
Language: English \
<br>

### Android

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_androiddev.webp">

[__/r/AndroidDev__](https://discord.gg/D2cNrqX) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/androiddev/) \
Notable Channels: `#beginner`, `#intermediate`, `#rom`, `#general`, `#flutter`, `#kotlin`, `#firebase`, `#dependency-injection`, `#rx`, `#design` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_androidroot.webp">

[__/r/AndroidRoot__](https://discord.gg/Uq7r6kF) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/androidroot/) \
Notable Channels: `#root`, `#custom-roms`, `#theming`, `#development`, `#magisk`, `#twrp`, `#substratum`, `#support-room` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_flutterdev.webp">

[__/r/FlutterDev__](https://discord.com/invite/N7Yshp4) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/FlutterDev/) \
Notable Channels: `#beginner`, `#intermediate`, `#general`, `#android`, `#ios`, `#web`, `#desktop`, `#app-showcase`, `#hiring` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/android_discord.webp">

[__Android Discord__](https://discord.com/invite/android) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/Android/) \
Notable Channels: `#android`, `#whatphone`, `#tech-support`, `#phone-questions`, `#themes`, `#phonetography` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/xda-developers.webp">

[__XDA-Developers__](https://discord.com/invite/xda-422814981520621569) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://forum.xda-developers.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/xda) \
Notable Channels: `#general-tech`, `#help`, `#development`, `#theming`, `#devices`, `#google-general`, `#huawei-general`, `#oneplus-general`, `#samsung-general`, `#nokia-general` \
Language: English

### Apple Systems

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_hackintosh_paradise.webp">

[__/r/Hackintosh Paradise__](https://discord.com/invite/Wxam8aH) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/hackintosh/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://hackintosh.gitbook.io/-r-hackintosh-vanilla-desktop-guide/) \
Notable Channels: `#hackintosh-help`, `#laptop-prebuilt`, `#smbios`, `#macos`, `#linux`, `#windows`, `#retro-gaming`, `#hardware` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amd_os_x.webp">

<!--lint ignore awesome-spell-check-->
[__AMD OS X__](https://discord.com/invite/EfCYAJW) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://amd-osx.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/AMD-OSX) \
Notable Channels: `#big_sur_discussions`, `#development_discussions`, `#b550_development`, `#install_support`, `#post_install_support`, `#gpu_support`, `#networking_support`, `#hardware_discussion` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/apple_betas.webp">

[__Apple Betas__](https://discord.com/invite/4EEkWjS) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/iOSBeta/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/23Aaron/JeffBot) \
Notable Channels: `#releases`, `#general`, `#ios`, `#ipados`, `#macos`, `#watchos`, `#tvos`, `#xcode`, `#development` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/unsupported_macs.webp">

[__Unsupported Macs__](https://discord.com/invite/XbbWAsE) \
Notable Channels: `#barrykn-patcher`, `#bensova-patcher`, `#dosdude1-patchers`, `#big-sur`, `#catalina`, `#mojave`, `#high-sieraa`, `#sierra`, `#el-capitan`, `#yosemite`, `#mavericks`, `#mountain-lion` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_apple.webp">

[__r/Apple__](https://discord.com/invite/apple) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/Apple) \
Notable Channels: `#apple`, `#purchase-advice`, `#shot-on-iphone`, `#homescreen`, `#ios-ipados`, `#macos`, `#watchos`, `#xcode`, `#services`, `#jailbreak-info`, `#support` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_jailbreak.webp">

[__r/Jailbreak__](https://discord.com/invite/jb) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/jailbreak/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Emy/janet) \
Notable Channels: `#showcase`, `#common-issues`, `#jailbreak`, `#general`, `#themes`, `#legacy`, `#unc0ver`, `#tvos-jailbreaks`, `#checkra1n`, `#chimera`, `#flex`, `#ncontrol`, `#support` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/hackintosh_x86.webp">

[__Hackintosh x86__](https://discord.com/invite/hackintosh-x86-447936233084026890) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](http://www.hackintoshx86.co.uk/) \
Notable Channels: `#support-1`, `#vm-kvm-support`, `#apple-silicon-macs`, `#apple-pre-silicon`, `#starlink-general-info` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/shortcuts.webp">

[__Shortcuts__](https://discord.gg/HrzAhUu) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/shortcuts/) \
Notable Channels: `#general`, `#shorcut-sharing`, `#help-and-support`, `#shortcast-info`, `#shortcasts-content-suggestions`\
Language: English

### Windows

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/microsoft_community.webp">

[__Microsoft Community__](https://discord.com/invite/microsoft) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://msft.chat/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/sylveon/SatyaNadella) \
Notable Channels: `#general-chat`, `#insiders-chat`, `#tech-support`, `#purchase-advice`, `#development`, `#it-pros`, `#servers`, `#surface`, `#office`, `#unix` \
Language: English

### Linux

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nix_nest.webp">

[__*nix nest__](https://discord.com/invite/svhXktFkAG) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nixnest) \
Notable Channels: `#home`, `#dev-random`, `#support`, `#unixporn`, `#programming`, `#media`, `#hardware`, `#gaming` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/discord_linux.webp">

[__Discord Linux__](https://discord.com/invite/discord-linux) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/discordlinux) \
Notable Channels: `#tech`, `#customization`, `#programming`, `#support-linux`, `#support-distro-installs`, `#support-games`, `#support-discord`, `#support-non-linux` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linux_cafe.webp">

[__Linux Café__](https://discord.com/invite/YY4zrNR) [<img height="16px" width="16px" alt="Reddit" src="images/badges/reddit.webp">](https://reddit.com/r/linuxcafe) [<img height="16px" width="16px" alt="CodeBerg Repository" src="images/badges/git.webp">](https://codeberg.org/LinuxCafeFederation) \
Notable Channels: `#tips-and-links`, `#news`, `#tech`, `#de-and-customization`, `#programming`, `#linux-support`, `#support-other` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linux_for_all.webp">

[__Linux For All__](https://discord.gg/gewCYyN) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/lfa_linux/) \
Notable Channels: `#linux-news`, `#general`, `#linux`, `#gaming`, `#suggestions`, `#developers`, `#themes`, `#support` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_unixporn.webp">

[__r/unixporn__](https://discord.com/invite/TnJ4h5K) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/unixporn/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/unixporn) \
Notable Channels: `#showcase`, `#ricing-theming`, `#tools`, `#wallpapers`, `#tech-support`, `#programming`, `#hardware` \
Language: English \
<br>

### Linux Distributions

[Gaming on Linux↴](#gaming-on-linux)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/arch_linux_unofficial.webp">

[__Arch Linux [unofficial]__](https://discord.com/invite/MrhPdhn) \
Notable Channels: `#news`, `#home`, `#arch-support`, `#other-distros`, `#programming`, `#ricing`, `#wallpapers` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/fedora_linux.webp">

[__Fedora Linux__](https://discord.com/invite/Fedora) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://getfedora.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/fedora-infra) \
Notable Channels: `#home`, `#man-pages`, `#silverblue-containers`, `#server-rhel-centos`, `#arm-raspberry`, `#showcase`, `#gaming-general`, `#hardware-for-linux` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gentoo_linux.webp">

[__Gentoo Linux__](https://discord.com/invite/gentoolinux) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.gentoo.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/gentoo) \
Notable Channels: `#chat`, `#support`, `#screenshots`, `#general-development`, `#ebuilds`, `#resources`, `#containers` \
Language: English, 日本語 \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linux_mint_community.webp">

[__Linux Mint Community__](https://discord.com/invite/mint) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/UtopicUnicorns/artemis) \
Notable Channels: `#support-mint`, `#support-lmde`, `#support-other-os`, `#support-nos`, `#general`, `#tech-talk`, `#user-created-content` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/manjaro_linux.webp">

[__Manjaro Linux__](https://discord.com/invite/t6GJuTC) \
Notable Channels: `#kde`, `#xfce`, `#gnome`, `#manjaro-arm`, `#help-general`, `#help-installation`, `#programming`, `#customizations` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/opensuse.webp">

[__openSUSE__](https://discord.com/invite/openSUSE) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.opensuse.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/openSUSE) \
Notable Channels: `#support`, `#chat`, `#project`, `#packaging`, `#factory`, `#admin`, `#artwork`, `#docs`, `#gnome`, `#xfce` \
Language: English, français, Deutsch, italiano, polski, español, Nederlands \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ubuntu_hideout.webp">

[__Ubuntu Hideout__](https://discord.com/invite/jcwJEJH) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://ubuntuhideout.com/) \
Notable Channels: `#tech-talk`, `#coding-cave`, `#system-installation`, `#software-installation,` `#desktop-environment`, `#hardware-drivers`, `#networking`, `#programming` \
Language: English

### Other OS

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/reactos_community.webp">

[__ReactOS Community__](https://discord.com/invite/7knjvhT) \
Notable Channels: `#general`, `#support`, `#working-programs`, `#working-hardware`, `#debugging`, `#teaching-room`, `#reactos-youtube`, `#git-highlights` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_chromeos.webp">

[__r/ChromeOS__](https://discord.com/invite/T7AMQUM) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/chromeos/) \
Notable Channels: `#chromeos`, `#chromium`, `#crostini`, `#purchase-advice`, `#dev-mode`, `#enterprise`, `#android`, `#gaming`, `#support`\
Language: English

## DevOps and System Administration

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

[Continuous development](https://en.wikipedia.org/wiki/DevOps#Toolchains), discussions on network management and infrastructure, IT homelab, containers, APIs, Kubernetes and applications that run on them.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_sysadmin.webp">

[__/r/sysadmin__](https://discord.com/invite/sysadmin) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/sysadmin) \
Notable Channels: `#sysadmin`, `#help`, `#security`, `#scripting`, `#microsoft`, `#linux`, `#career-advice`, `#networking` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amazon_web_services_aws_cloud.webp">

[__Amazon Web Services (AWS Cloud)__](https://discord.com/invite/vG7nVX5) \
Notable Channels: `#general-aws`, `#aws-rage`, `#ask-for-technical-help`, `#cloud-automation`, `#cloud-security`, `#getting-hired` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/data_engineering.webp">

[__Data Engineering__](https://discord.com/invite/2pER6dq) \
Notable Channels: `#general`, `#show`, `#help`, `#career`, `#data-science` `#resources`, `#architecture`, `#cloud`, `#databases`, `#etl-workflow` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/eddiejaoudecommunity.webp">

[__Eddie Jaoude Community__](https://discord.com/invite/jZQs6Wu) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](http://eddiejaoudecommunity.github.io) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](http://github.com/EddieJaoudeCommunity) \
Notable Channels: `#opensource`, `#first-timers`, `#help`, `#livestream`, `#hackathons`, `#careers` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/homelab.webp">

[__Homelab__](https://discord.com/invite/homelab) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/homelab/) \
Notable Channels: `#general`, `#labpics`, `#homelabquotes`, `#code` \
Language: English, Deutsch, français, Nederlands \
<br>

### Data Management

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/data_engineering.webp">

[__Data Engineering__](https://discord.com/invite/2pER6dq) \
Notable Channels: `#general`, `#show`, `#help`, `#career`, `#data-science` `#resources`, `#architecture`, `#cloud`, `#databases`, `#etl-workflow` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/grakn_labs.webp">

[__TypeDB__](https://discord.com/invite/typedb) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://typedb.com//) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vaticle) \
Notable Channels: `#questions`, `#cloud`, `#schema`, `#query`, `#inference`, `#studio`, `#troubleshooting`, `#drivers`, `#factoryci`, `#build`, `#engineering`, `#reasoner`, `#docs` \
Language: English

### API

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/appwrite.webp">

[__Appwrite__](https://discord.com/invite/GSeTUeA) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://appwrite.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/appwrite) \
Notable Channels: `#support`, `#maintainers`, `#account`, `#users`, `#database`, `#storage`, `#web`, `#flutter`, `#react-native`, `#ios`, `#android`, `#servers`, `#unity`, `#electron` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/disease_sh.webp">

[__disease.sh__](https://discord.com/invite/uypdG2h) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://disease.sh/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/disease-sh) \
Notable Channels: `#showcase`, `#feedback-suggestions`, `#commands`, `#api-support`, `#public-development` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/hasurahq.webp">

[__HasuraHQ__](https://discord.com/invite/hasura) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://hasura.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/hasura/graphql-engine) \
Notable Channels: `#graphql-engine`, `#new-to-graphql`, `#contrib`, `#look-what-i-built`, `#preview`, `#3factor-apps`, `#deployment-help` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/spaceuptech.webp">

[__SpaceUpTech__](https://discord.com/invite/RkGjW93) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://spaceuptech.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/spaceuptech) \
Notable Channels: `#general`, `#contributions` \
Language: English \
<br>

### Containers

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cryb.webp">

[__Cryb__](https://discord.com/invite/xdhEgD5) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://cryb.app/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/crybapp) \
Notable Channels: `#cryb`, `#getting-started`, `#support`, `#tech-support`, `#updates`, `#community`, `#interests` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linuxserver_io.webp">

[__Linuxserver.io__](https://discord.com/invite/YWrKVTn) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.linuxserver.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/linuxserver) \
Notable Channels: `#general-support`, `#docker-support`, `#heimdall`, `#linux-chat`, `#other-support`, `#hardware` \
Language: English \
<br>

### Server Applications

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_plex.webp">

[__/r/Plex__](https://discord.com/invite/plex) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/PleX/) \
Notable Channels: `#general`, `#software`, `#hardware`, `#media-suggestions` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/librenms.webp">

[__LibreNMS__](https://discord.com/invite/librenms) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.librenms.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/librenms) \
Notable Channels: `#general`, `#devel` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/organizr.webp">

[__Organizr__](https://discord.com/invite/TrNtY7N) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://organizr.app/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/causefx/Organizr) \
Notable Channels: `#general`, `#customization-theming`, `#groups`, `#organizr-support` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/pi_hole.webp">

[__Pi-hole & AdGuard__](https://discord.com/invite/DGscCVPRme) \
Notable Channels: `#blocklist-discussion`, `#gaming`, `#programming`, `#adguard-discussion`, `#adguard-support`, `#pihole-discussion`, `#pihole-support`, `#browser-adblocking`, `#mobile-adblocking` \
Language: English

## Computer Security

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Everything red and blue teams are leaglly allowed to do; securty asssessment, reverse engineering, loopholes in networks, vulnerability research and so on.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_many_hats_club.webp">

[__Շђє ๓คภץ ђคՇร Ċ̵͕l̶̀͘u̸̍͝b̵͌͐__](https://discord.gg/infosec) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://themanyhats.club/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/xdfcfc0xa/TMHC-Challenge-Platform) \
Notable Channels: `#infosec-general`, `#technical-chat`, `#student-zone`, `#blue-team-zone`, `#ctf`, `#malware-phishing`, `#cyber-threat-intel`, `#digital-forensics` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/defcon.webp">

[__DEFCON__](https://discord.com/invite/defcon) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.defcon.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://media.defcon.org/) \
Notable Channels: _Will open on August 5-8, 2021_ \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/hacker101.webp">

[__Hacker101__](https://discord.com/invite/32ZNZVN) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.hackerone.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Hacker0x01) \
Notable Channels: `#general`, `#hacking-resources`, `#questions-and-answers`, `#hacktivity`, `#hackthebox`, `#mother-ctfs`, `#h1-2006-ctf`, `#ctfs`, `#a-little-something-to-get-you-started` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/infosec_and_coding.webp">

[__InfoSec & Coding__](https://discord.gg/zSaDzRW) \
Notable Channels: `#general`, `#questions`, `#programming`, `#hacking`, `#webdev`, `#opearting-systems`, `#ctf`, `#resources` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/locke.webp">

[__LOCKE__](https://discord.gg/x4DwzGWR8r) \
Notable Channels: `#windows-os`, `#unix-family`, `#mac-os`, `#ethical-hacking`, `#ctf-discussion`, `#job-discussion`, `#networking`, `#cryptography`, `#mobile-devices`, `#web-dev`, `#python` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/reverse_engineering.webp">

[__Reverse Engineering__](https://discord.gg/PSfAu8N) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Cryptogenic/REBot) \
Notable Channels: `#help`, `#ctf`, `#starting-out`, `#mobile`, `#exploits-and-vulns`, `#hardware`, `#malware`, `#tools`, `#software-protections` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_cyber_mentor.webp">

[__The Cyber Mentor__](https://discord.com/invite/tcm) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.twitch.tv/thecybermentor) \
Notable Channels: `#web-app-course`, `#zero-to-hero`, `#red-teaming`, `#reverse-engineering`, `#linux`, `#web-apps`, `#htb`, `#tryhackme`, `#forensics`, `#job-postings` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/whitehat_hacking.webp">

[__Whitehat Hacking__](https://discord.com/invite/beczNYP) \
Notable Channels: `#cyber-news`, `#hacking`, `#mac-os`, `#windows`, `#linux`, `#ios`, `#android`, `#hardware`, `#coding`, `#malware-analysis`, `#training`, `#c-re-arm-x86-help` \
Language: English

### Security Tools

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ghidra.webp">

[__GHIDRA__](https://discord.gg/S4tQnUB) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://ghidra.re/) \
Notable Channels: `#general`, `#development` \
Language: English, русский \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/pince.webp">

[__PINCE__](https://discord.com/invite/jVt3BzTSpz) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/korcankaraokcu/PINCE) \
Notable Channels: `#general`, `#issues` \
Language: English \
<br>

## Blockchain and Cryptocurrency

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

The open-source development of cryptocurrencies and applications of blockchain.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cryptodevs.webp">

[__CryptoDevs__](https://discord.com/invite/EDA6M3R) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/cryptodevs/) \
Notable Channels: `#core-crypto-dev`, `#layer-2-dev`, `#any-dev`, `#eth-dev`, `#web3-dev`, `#solidity-dev`, `#vyper-dev`, `#evm-dev`, `#tools-and-resources`, `#events`, `#jobs`, `#bounties`, `#contribute` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/go_ethereum.webp">

[__Go Ethereum__](https://discord.com/invite/nthXNEv) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://geth.ethereum.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ethereum/go-ethereum) \
Notable Channels: `#general`, `#light-client`, `#abigen`, `#clef`, `#puppeth`, `#rinkeboy`, `#progpow`, `#firefly`, `#devp2p`, `#mobile` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/lbry_foundation.webp">

[__LBRY Foundation__](https://discord.com/invite/Z3bERWA) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://lbry.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/lbryio/) \
Notable Channels: `#general`, `#ideas-and-feedback`, `#content`, `#help` \
Language: English, język polski, Rumanian, 한국어, Deutsch, 中文, italiano, português, 日 本語, français, español, Türkçe, Nederlands, русский, हिन्दी, বাংলা, Czech, bahasa Indonesia, Pilipino

### Currencies

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cardano_community.webp">

[__Cardano Community__](https://discord.com/invite/TBQJZvZNey) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.cardano.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/input-output-hk/cardano-sl) \
Notable Channels: `#general`, `#learning`, `#trading`, `#yoroi-general`, `#yoroi-support`, `#daedalus-general`, `#daedalus-support`, `#dev-general`, `#cip` \
Language: English, 日本語, 中文, 한국어, Deutsch, Nedarlands, português, español, Czech

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ethergem_egem_and_sfrx.webp">

[__EtherGem / EGEM & SFRX__](https://discord.com/invite/zav3EkW) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://egem.io/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/TeamEGEM) \
Notable Channels: `#egem-chat`, `#sfrx-chat`, `#mn-talk`, `#docker-mn-talk`, `#otc-market`, `#trading-talk`, `#mining`, `#zero-coin`, `#dev-talks`, `#bounties` \
Language: English, português, 中文, français, Deutsch, русский, 日本語, 한국어, español

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/metrix_market.webp">

[__Metrix Market__](https://discord.com/invite/5nwrTwJ) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.metrixcoin.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/TheLindaProjectInc) \
Notable Channels: `#metrix-discussion`, `#day_trading` \
Language: English, Nederlands, עִבְרִית‎, 日本語, 中文, 한국어, Deutsch, português, español français, italiano, 한국어, русский, Türkçe, język polski

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/nano.webp">

[__Nano__](https://chat.nano.org/) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://nano.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/nanocurrency) \
Notable Channels: `#general`, `#documentation`, `#development`, `#decentralization`, `#graphic-design`, `#business`, `#events`, `#integration`, `#protocol`, `#roadmap`, `#support` \
Language: English, español, русский, bahasa Indonesia, italiano, Deutsch, 中文, français, português, Türkçe, Tiếng Việt

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vertcoin.webp">

[__Vertcoin - Official__](https://discord.com/invite/vertcoin) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vertcoin.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vertcoin-project) \
Notable Channels: `#general`, `#trading`, `#marketing`, `#development`, `#mining-help`, `#mining-rig-discussion` \
Language: English, 한국어, русский

## Simulation

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Computationally model natural or supernatural phenomena using the rigorous laws of physics and mathematics in your favorite application environment.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/manim.webp">

[__Manim__](https://discord.com/invite/mMRrZQW) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.manim.community) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ManimCommunity) \
Notable Channels: `#3blue1brown`, `#manim-help`, `#python-help`, `#math-discussion`, `#manim-dev`, `#projects`, `#docs` \
Language: English, español, português, français, Deutsch, русский \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/dimforge.webp">

[__dimforge__](https://discord.com/invite/vt9DJSW) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.dimforge.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/dimforge) \
Notable Channels: `#rapier`, `#bevy_rapier`, `#rapier-js`, `#parry`, `#salva`, `#nalgebra`, `#simba`, `#nphysics`, `#simba` \
Language: English \
<br>

### Flight Simulation

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/coders_craft.webp">

[__Coders Craft__](https://discord.com/invite/DA9qDXF) \
Notable Channels: `#general`, `#xpl-res`, `#dev-chat`, `#lua`, `#c-cpp`, `#microsoft-flight-simulation-dev-chat`, `#modeling-texture` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/flybywire_simulations.webp">

[__FlyByWire Simulations__](https://discord.com/invite/UjzuHMU) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/flybywiresim/a32nx) \
Notable Channels: `#help`, `#aviation-chat`, `#hardware-chat`, `#a32nx-chat`, `#a380x-chat`, `#dev-support`, `#atsu-api`, `#lighting`, `#modeling`, `#sound`, `#your-controls` \
Language: English

## Game Development

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Making of games, how to rasterize or real time ray tracing, the complexities behind each object movement, everything before publishing in the marketplace.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/brackeys.webp">

[__Brackeys__](https://discord.com/invite/brackeys) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/channel/UCYbK_tjZ2OrIZFBvU6CCMiA) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Brackeys) \
Notable Channels: `#tutorials_and_articles`, `#unity`, `#programming`, `#mobile`, `#code_optimization`, `#shaders`, `#game_jams`, `#art`, `#audio`, `#game_design`, `#marketing`, `#collaboration` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/game_dev_league.webp">

[__Game Dev League__](https://discord.com/invite/gamedev) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://gamedevleague.com/) \
Notable Channels: `#events`, `#unity`, `#unreal-engine`, `#gamemaker-studio`, `#open-source`, `#löve-dev`, `#monogame-and-libgdx-dev`, `#godot`, `#web-dev`, `#cryengine-dev`, `#vr-dev`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/game_dev_network.webp">

[__Game Dev Network__](https://discord.com/invite/gdn) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twitter.com/gamedevnetwork_) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Game-Dev-Network) \
Notable Channels: `#gamedev-talk`, `#career-advice`, `#gamejam`, `#work-in-progress`, `#unity`, `#unreal`, `#godot`, `#gamemaker`, `#stride-xenko`, `#roblox`, `#ui-ux`, `#3d-modeling`, `#sound`, `#looking-for-work` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/osu_dev.webp">

[__osu!dev__](https://discord.com/invite/ppy) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://ppy.sh/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/ppy) \
Notable Channels: `#osu-lazer`, `#osu-framework`, `#osu-dev`, `#difficulty-osu`, `#difficulty-taiko`, `#difficulty-catch`, `#difficulty-mania`, `#osu-wiki`, `#modding`, `#mappers-guild` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/reddit_r_gamedev.webp">

[__Reddit /r/gamedev__](https://discord.com/invite/reddit-gamedev) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/gamedev/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/r-gamedev) \
Notable Channels: `#gamedev-general`, `#show-off-your-stuff`, `#unity`, `#unreal`, `#godot`, `#lhtml5-javascript`, `#c-cpp-csharp-java`, `#opengl-vulkan`, `#gamemaker`, `#retro`, `#audio`, `#visuals`, `#jobs` \
Language: English

### Game Design

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_gamedesign.webp">

[__/r/GameDesign__](https://discord.com/invite/gamedesign) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/gamedesign/) \
Notable Channels: `#digital-game-design`, `#tabletop-game-design`, `#game-development`, `#music-and-art`, `#find-people`, `#get-found`, `#current-projects` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/graphics_programming.webp">

[__Graphics Programming__](https://discord.com/invite/6mgNGk7) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/GraphicsProgramming) \
Notable Channels: `#mathematics`, `#questions`, `#ray-tracing`, `#techniques`, `#directx`, `#gpu-compute`, `#opengl`, `#unity-unreal`, `#vulkan`, `#web`, `#algorithms`, `#bikeshed`, `#engine-dev`, `#low-level` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/openvfx_the_blender_hub.webp">

[__OpenVFX: The Blender Hub__](https://discord.com/invite/blender) \
Notable Channels: `#cgi-general`, `#resources`, `#3d-printing`, `#animation-rigging`, `#coding`, `#grease-pencil`, `#materials`, `#modeling`, `#physics`, `#rendering`, `#roblox`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, português, español, Nederlands, suomi, Magyar, svenska, dansk, हिन्दी

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/shadertoy.webp">

[__Shadertoy__](https://discord.com/invite/XtmMN6E) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.shadertoy.com) \
Notable Channels: `#shader-programming`, `#beginners`, `#mathematics`, `#showcase`, `#live-coding-streams`, `#resources` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/ttrpg_design_and_playtesting.webp">

[__TTRPG Design and Playtesting__](https://discord.com/invite/5XRWTj9) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/RPGdesign/) \
Notable Channels: `#business`, `#game-design`, `#math`, `#mechanics`, `#playtesting`, `#visual-design`, `#world-design`, `#writing`, `#game-critique`, `#mechanics-critique`, `#projects` \
Language: English

### Game Engines

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/amethyst.webp">

[__Amethyst__](https://discord.com/invite/amethyst) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.amethyst.rs/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/amethyst/) \
Notable Channels: `#general`, `#help`, `#logic`, `#art`, `#showcase-team`, `#gamejam`, `#engine-general`, `#bikeshed`, `#review-request`, `#assets`, `#audio`, `#documentation`, `#ecs`, `#editor`, `#rendering` \
Language: English, Deutsch, français, 日本語, русский, 中文, dansk

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/armory.webp">

[__Armory__](https://discord.com/invite/axq6qWV) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://armory3d.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/armory3d) \
Notable Channels: `#armory`, `#armor-paint`, `#general`, `#armory-dev`, `#haxe`, `#logic-nodes`, `#showcase` \
Language: English, français \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/bevy.webp">

[__Bevy Engine__](https://discord.com/invite/gMUk5Ph) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://bevyengine.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/bevyengine/) \
Notable Channels: `#general`, `#help`, `#code-review`, `#showcase`, `#tutorials`, `#dev-general`, `#assets`, `#audio`, `#documentation`, `#ecs`, `#ui`, `#rendering` \
Language: English
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/construct_community.webp">

[__Construct Community__](https://discord.com/invite/8RJBHbX) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/WebCreationClub) \
Notable Channels: `#general`, `#feedback`, `#ask`, `#js`, `#tips`, `#tools`, `#job-offers`, `#addons`, `#effects` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cryengine_community.webp">

[__CRYENGINE Community__](https://discord.com/invite/cryengine) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.cryengine.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/CRYTEK/CRYENGINE) \
Notable Channels: `#support`, `#licensing`, `#general`, `#showcase`, `#ask-for-help`, `#coding`, `#art-and-assets`, `#animation-and-physics`, `#audio`, `#shaders-and-rendering`, `#vfx-visual-effects`, `#jobs` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gamemaker.webp">

[__GameMaker__](https://discord.com/invite/By6u9pC) [<img height="16px" width="16px" alt="Reddit Badge" src="images/badges/reddit.webp">](badges.md#reddit-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.reddit.com/r/gamemaker/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/GameMakerDiscord) \
Notable Channels: `#gamedev`, `#technical`, `#game-design`, `#3d_in_gamemaker`, `#shaders`, `#netcode`, `#beta_2_3`, `#help`, `#gamemaker_showcase` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gdevelop.webp">

[__GDevelop__](https://discord.com/invite/rjdYHvj) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://gdevelop-app.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/4ian/GDevelop) \
Notable Channels: `#wip`, `#art-and-assets`, `#finished-games`, `#game-jam`, `#general`, `#quick-questions`, `#engine-development`, `#javascript`, `#extension`, `#wiki` \
Language: English, Deutsch, français, español, 日本語, português, русский, italiano

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/godot_engine.webp">

[__Godot Engine__](https://discord.com/invite/zH7NUgz) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://godotengine.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/godotengine/) \
Notable Channels: `#general`, `#showcase`, `#beginner-help`, `#help`, `#programming`, `#visual-script`, `#shaders`, `#networking`, `#engine`, `#mobile-dev`, `#gnative-dev`, `#plugins`, `#xr`, `#3d`, `#ui` \
Language: English, عربي, español, polski

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/official_unity_discord.webp">

[__Official Unity Discord__](https://discord.com/invite/unity) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://unity.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Unity-Technologies) \
Notable Channels: `#general-unity`, `#game-jams`, `#completed-projects`, `#unitytips`, `#general-code`, `#editor-extensions`, `#dots`, `#shaders`, `#mobile`, `#machine-learning`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/orx_community.webp">

[__ORX Engine Community__](https://discord.com/invite/aC84aJJ) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://orx-project.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/orx) \
Notable Channels: `#general`, `#support`, `#learning`, `#orx`, `#projects`, `#wiki`, `#live` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/panda3d.webp">

[__Panda3D__](https://discord.com/invite/UyepRMm) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.panda3d.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/panda3d) \
Notable Channels: `#general`, `#development` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/renpy.webp">

[__Ren'Py__](https://discord.com/invite/6ckxWYm) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](http://www.renpy.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/renpy) \
Notable Channels: `#renpy`, `#ontopic`, `#todayidid`, `#social` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/twine_games.webp">

[__Twine Games__](https://discord.com/invite/n5dJvPp) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://twinery.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/tweecode) \
Notable Channels: `#central-planning`, `#sugarcube`, `#harlowe`, `#chapbook`, `#snowman`, `#twine1-formats`, `#compilers`, `#general-twine-talk`, `#writing-discussion`, `#testing-and-released`, `#resources` \
Language: English, Deutsch, español, français

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/unity_developer_community.webp">

[__Unity Developer Community__](https://discord.com/invite/bu3bbby) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://corniflex.itch.io/) \
Notable Channels: `#unity-help`, `#general-programming`, `#advanced-programming`, `#physics-maths`, `#networking`, `#art-2d`, `#art-3d`, `#ui-design`, `#audio-engineering`, `#projects-showcase`, `#udc-jam-week` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/unreal_slackers.webp">

[__Unreal Slackers__](https://discord.com/invite/unrealsource) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://unrealslackers.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/unreal-slackers) \
Notable Channels: `#unreal-engine`, `#design-chat`, `#game-jams`, `#work-in-progress`, `#graphics`, `#animation`, `#audio`, `#cinematics`, `#level-design`, `#paper2d`, `#visual-fx`, `#niagra`, `#blueprint`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

### Game Development Tools

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/directx.webp">

[__DirectX__](https://discord.com/invite/directx) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://devblogs.microsoft.com/directx/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Microsoft/DirectX-Graphics-Samples) \
Notable Channels: `#dx-developer-day`, `#dx12-developers`, `#dx9-dx11-developers`, `#pix`, `#showcase`, `#bug-reports`, `#feature-requests`, `#dx-gaming-questions`, `#getting-started-guides` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/enginehub.webp">

[__EngineHub__](https://discord.com/invite/enginehub) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://enginehub.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/EngineHub) \
Notable Channels: `#wordedit`, `#worldguard`, `#craftbook`, `#commandbook`, `#enginehub`, `#api`, `#dev-team`, `#git-log`, `#showcase` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/intellectualsites.webp">

[__IntellectualSites__](https://discord.com/invite/KxkjDVg) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://intellectualsites.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/IntellectualSites) \
Notable Channels: `#fawe-support`, `#fawe-developer-chat`, `#ps-developer-chat`, `#hv-general-chat`, `#is-web`, `#programming` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linuxgsm_.webp">

[__LinuxGSM__](https://discord.com/invite/UM4VTpK) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://linuxgsm.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/GameServerManagers      ) \
Notable Channels: `#linuxgsm`, `#linux`, `#game-server`, `#general`, `#battlestations` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/raylib.webp">

[__raylib__](https://discord.com/invite/VkzNHUE) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.raylib.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/raysan5/raylib) \
Notable Channels: `#general`, `#madewithraylib`, `#help`, `#game-design`, `#raspberry-pi`, `#raylibtech`, `#rayfork`, `#raylib`, `#raygui`, `#rres`, `#challenges`, `#raylib-bindings` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/rpcs3.webp">

[__RPCS3__](https://discord.com/invite/Af7H9yp) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://rpcs3.net/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/rpcs3) \
Notable Channels: `#rpcs3`, `#help`, `#development`, `#media` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/steam_rom_manager.webp">

[__SteamGridDB__](https://discord.com/invite/bnSVJrz) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://dozennn.github.io/steam-rom-manager/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/SteamGridDB) \
Notable Channels: `#asset-requests`, `#games-research`, `#research-tips`, `#grid-showcase`, `#icon-showcase`, `#flash-project`, `#srm-discussion`, `#srm-support` \
Language: English \

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tes3mp.webp">

[__TES3MP__](https://discord.com/invite/ECJk293) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://tes3mp.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/TES3MP) \
Notable Channels: `#general`, `#technical-help`, `#scripting-help`, `#content_discussion`, `#bug_reports`, `#development`, `#suggestions` \
Language: English

### Gaming on Linux

[Linux Distributions↰](#linux-distributions)

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/gamingonlinux.webp">

[__GamingOnLinux__](https://discord.com/invite/AghnYbMjYg) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.gamingonlinux.com/) \
Notable Channels: `#linux-gaming`, `#proton-steamplay-gaming`, `#wine-gaming`, `#cloud-streaming-stadia`, `#tech-support`, `#emulation`, `#developer-stuff`, `#hardware`, `#vr_and_ar`, `#your-content` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/linux_gaming.webp">

[__Linux Gaming__](https://discord.com/invite/linuxgaming) \
Notable Channels: `#support-general`, `#support-hardware`, `#support-gaming`, `#new-to-linux`, `#tech-general`, `#coding`, `#unixporn`, `#original-content` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/lutris.webp">

[__Lutris__](https://discord.gg/Pnt5CuY) \
Notable Channels: `#news`, `#general`, `#irc`, `#requests_and_feedback`, `#lutris_support`, `#linux_support`, `#installer_creation` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/protondb_official_server.webp">

[__ProtonDB Official Server__](https://discord.com/invite/uuwK9EV) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.protondb.com/)  \
Notable Channels: `#protondb-website`, `#proton-game-support`, `#proton`, `#linux`, `#linux-support`, `#general-game-support` \
Language: English

## Virtual Reality

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Developing for virtual, augmented, and mixed reality; the head-mounted displays that stimulate our perception of a whole new world. The applications of VR are endless.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/project_north_star.webp">

[__Project North Star__](https://discord.com/invite/2aE2Nfq) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://developer.leapmotion.com/northstar) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/leapmotion/ProjectNorthStar) \
Notable Channels: `#build-planning`, `#northstar3-2`, `#jenson-redesing`, `#triton`, `#exii-raspberry-pi`, `#cad`, `#eye-tracking`, `#calibration`, `#steamvr`, `#mechanical`, `#firmware`, `#troubleshooting` \
Language: English, Deutsch, français, español, 日本語, 韓國語

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/vrchat.webp">

[__VRChat__](https://discord.com/invite/vrchat) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://vrchat.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/vrchat) \
Notable Channels: `#udon-questions`, `#vrchat-development`, `#avatars`, `#avatar-rigging`, `#animation`, `#shaders`, `#3d-modeling`, `#worlds`, `#world-lighting`, `#oculus-quest-development`, __[`so much more`](badges.md#so-much-more)__ \
Language: English, Deutsch, اَلْعَرَبِيَّةُ‎, français, 汉语, español, 日本語, dansk, 한국어, português, polski, русский

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/virtual_reality.webp">

[__Virtual Reality__](https://discord.com/invite/virtualreality) \
Notable Channels: `#vr-dev`, `#tech-advice`, `#oculus-quest`, `#oculus-rift`, `#oculus-go`, `#valve-index`, `#pimax-vr`, `#htc-vive`, `#windows-mixed-reality`, `#playstation-vr`, `#vr-flightsims` \
Language: English

## Machine Learning

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Data manupulation and visualization, machine learning frameworks and artificial intelligence.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/r_machinelearning.webp">

[__/r/machinelearning__](https://discord.com/invite/FVBUKzD) \
Notable Channels: `#quick-questions`, `#machine-learning-projects`, `#resources`, `#math-questions`, `#programming-questions`, `#andrew-ng-coursera-machine-learning` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/artificial_intelligence.webp">

[__Artificial Intelligence__](https://discord.com/invite/ZX45ZdK) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://discordnetwork.com/) \
Notable Channels: `#questions`, `#machine-learning`, `#deep-learning`, `#reinforcement-learning`, `#natural-language-processing`, `#systems-neuroscience`, `#computer-vision`, __[`so much more`](badges.md#so-much-more)__ \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/sentdex.webp">

[__Sentdex__](https://discord.com/invite/sentdex) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://www.youtube.com/user/sentdex) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/Sentdex) \
Notable Channels: `#__main__`, `#help` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/tensorflow.webp">

[__TensorFlow__](https://discord.com/invite/64MVzQX) \
Notable Channels: `#tf-general`, `#ai-ethics`, `#tensorflow-javascript`, `#tensorflow-python`, `#convolutional-neural-network`, `#recurrent-neural-network`, `#generative-adversarial-networks` \
Language: English

### Data Science

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/data_science.webp">

[__Data Science__](https://discord.com/invite/UYNaemm) \
Notable Channels: `#general`, `#machine-learning`, `#math`, `#programming`, `#career`, `#visualization`, `#resources`, `#colab`, `#papers` \
Language: English

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/dvc.webp">

[__Data Version Control__](https://discord.com/invite/dvwXA2N) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://dvc.org/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/iterative/dvc) \
Notable Channels: `#q-and-a`, `#need-help`, `#general`, `#dev-talk`, `#dev-docs` \
Language: English \
<br>

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/the_data_share.webp">

[__The Data Share__](https://discord.com/invite/eaPVRW3) \
Notable Channels: `#machine-learning`, `#natural-language-processing`, `#analytics`, `#programming`, `#data-engineering`, `#visualizations`, `#community` \
Language: English

## Career

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Discussions on interview challenges, resume reviews, job opportunities in the field of programming.

<img align="left" height="94px" width="94px" alt="Server Icon" src="images/server_icons/cs_career_hackers.webp">

[__CS Career Hub__](https://discord.com/invite/cscareerhub) [<img height="16px" width="16px" alt="Official Badge" src="images/badges/official.webp">](badges.md#official-identification-badge) [<img height="16px" width="16px" alt="Homepage URL" src="images/badges/homepage.webp">](https://cscareerhub.com/) [<img height="16px" width="16px" alt="Git Repository" src="images/badges/git.webp">](https://github.com/cscareerhub) \
Notable Channels: `#big-n-discussion`, `#job-search-blogs`, `#career-questions`, `#resume-review`, `#experienced`, `#students`, `#communication`, `#hiring`, `#for-hire`, `#devops`, `#programming-challenges` \
Language: English

## Discord Development

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Tools and libraries needed in your toolbelt to build a Discord bot or automation script through Discord APIs. The list
for that itself is quite long and diverse that it calls for its own awesome list. This unaffiliated [compilation of
Discord API libraries](https://libs.advaith.io/) (with comparisons) would be a great start to look for the right tool
for your Discord project. There is also an [official wiki](https://www.reddit.com/r/discordapp/wiki/developers) (though
maybe not frequently maintained) that lists similar tools with links to respective Discord servers.

## Attribution

[<img align="right" width="16" height="16" src="images/up_arrow.png" alt="Back to top">](#contents)

Badge icons are made by [Freepik](https://www.flaticon.com/authors/freepik) and [Pixel Buddha](https://www.flaticon.com/authors/pixel-buddha).

To attribute this awesome list (as restricted by the license) see [how to attribute](FAQ.md#FAQ.md#how-to-properly-attribute-to-compliment-the-license-cc-by-40).
