<!-- omit in toc -->
# Frequently Asked Questions

Answers to a few common questions that may come to your mind while exploring this awesome list:

- [What is Discord.com exactly?](#what-is-discordcom-exactly)
- [What about Discord's poor privacy policy?](#what-about-discords-poor-privacy-policy)
- [How to stay safe in Discord?](#how-to-stay-safe-in-discord)
- [How is this list any different from Discord listing sites?](#how-is-this-list-any-different-from-discord-listing-sites)
- [Are you or is this project affiliated?](#are-you-or-is-this-project-affiliated)
- [Why does this list not follow conventional Awesome list framework?](#why-does-this-list-not-follow-conventional-awesome-list-framework)
- [How to contribute?](#how-to-contribute)
- [How to report any issue with the Awesome list?](#how-to-report-any-issue-with-the-awesome-list)
- [How to properly attribute to compliment the license (CC BY 4.0)?](#how-to-properly-attribute-to-compliment-the-license-cc-by-40)

### What is Discord.com exactly?

From [Wikipedia](https://en.wikipedia.org/wiki/Discord_(software)):
> Discord is a proprietary freeware VoIP application and digital distribution platform designed for creating communities ranging from gamers to education and businesses. Discord specializes in text, image, video and audio communication between users in a chat channel. Discord runs on Windows, macOS, Android, iOS, Linux, and in web browsers. As of 21 July 2019, there are over 250 million users of the software.

Or as I once heard from a critique:
> Discord is just IRC with extra features.

A _server_ in Discord mainly refers to the community itself.

### What about Discord's poor privacy policy?

It has been raised many times about
the [awful privacy control](https://swordfishevaluations.com/2019/09/12/privacy-concerns-with-discord/),
[being a potential spyware](https://spyware.neocities.org/articles/discord.html),
[criticism by Richard Stallman](https://stallman.org/discord.html),
and [risks of online predators](https://www.wsj.com/articles/discord-where-teens-rule-and-parents-fear-to-tread-11560245402)
on a national newspaper. As much as I'd like to hate Discord because of this, it's hard to deny the wonderful growing communities that are no less productive than their counterparts in another privacy-focused platform. That alone encouraged me to create this list.

### How to stay safe in Discord?

Discord has a spiffy guide for [staying safe in communities](https://discord.com/new/safety/360043857751-Four-steps-to-a-super-safe-account) and [for your teenage kids](https://discord.com/new/safety/360044153831-Helping-your-teen-stay-safe-on-Discord). Like any other platform, Discord is often targeted for malicious attacks, but with a little caution, you'll be safe as houses.

### How is this list any different from Discord listing sites?

You may have come around websites that are known for listing Discord communities for showcasing and promotional purposes. This list is not one of them. Each community here is hand-picked, reviewed by a maintainer, and meets [certain criteria](CONTRIBUTING.md#review-policy), e.g., activity vs. productivity ratio, the support channels dedicated to users, friendliness -- before they can be accepted, whereas the listing websites often require servers to link closed-source bots that may collect user data and no manual review against possible toxic communities.

### Are you or is this project affiliated?

Neither I nor any part of this project is affiliated with Discord in any way.

### Why does this list not follow conventional Awesome list framework?

It was intentional since the very
first [commit](https://github.com/mhxion/awesome-discord-communities/commit/303990bcd36e4b10b4dfa80289c8303778d54f07).
Unlike other listings in Awesome lists, Discord communities are much more diverse, asymmetrical, and miscellaneous. E.g., the community [Game Dev League](https://gamedevleague.com/) and [Game Dev Network](https://twitter.com/gamedevnetwork_) are both independent and prominent, neither of them offers only one type of support. Rather, any general support relating to game development. A one-liner description would seem vague to the users. The differences that stand between the two servers are their channels and the spoken languages that they offer. This is true for 53% of all communities, but the channels don't always necessarily explain "what this community is." It was the biggest challenge to making this list. Instead of a description to define a community alongside its channels, languages, and at the same time to not condense the list -- [badges](badges.md) were adopted, notably, the [home badge](badges.md#home-badge), which on click takes you to the community-owned website. Other badges serve relevant features as well. Feel free to [open an issue](https://github.com/mhxion/awesome-discord-communities/issues/new/choose) if a new submission doesn't fit within this structure.

### How to contribute?

Refer to the [contributing](CONTRIBUTING.md) page. As for now, the pull requests aren't automated.

### How to report any issue with the Awesome list?

If you have found a typo or maybe an invalid invitation link, you can open a new
issue [here](https://github.com/mhxion/awesome-discord-communities/issues/new/choose), I'll try to fix it soon as possible.

### How to properly attribute to compliment the license (CC BY 4.0)?

I understand [CC-BY-4.0](https://creativecommons.org/licenses/by/4.0/) isn't the best open-source license, the only restriction is: it requires the user to attribute the owner. By mentioning the name `awesome-discord-communities` (along with its GitHub [link](https://github.com/mhxion/awesome-discord-communities)) anywhere on a separate attribution page or on the same page where you have used the list is enough and meets the proper validity in my eyes.
