ModernLife Project Overview
========================================================================
Conway's Game of Life and other Cellular Automata
Coded with C++/WinRT, WIL, WinUI3, Win2D, GSL

## Why?
I learned C++ on C++/98 so
 - This is a great way to learn about improvements in C++ from C++
   11/14/17/20
 - This is a great way to learn our recommended Windows App Development path
 - Cellular Automata is something that interests me
 - The project includes many good opportunities for learning
 - XAML, XAML binding
 - Multithreading
 - Synchronization
 - Timers
 - Canvas and drawing
 - std:: and gsl:: and wil::
 - Class design and much more

## Recommended reading
- https://abseil.io/tips/
- https://google.github.io/styleguide/cppguide.html
- http://isocpp.github.io/CppCoreGuidelines/

## Requires
- Visual Studio 2022 Preview https://visualstudio.microsoft.com/vs/preview/
- Git https://git-scm.com/downloads
- GitHub account

## Included in the Solution
- WinUI3 https://www.nuget.org/packages/Microsoft.WinUI
- CppWinRT https://www.nuget.org/packages/Microsoft.Windows.CppWinRT
- Win2D https://www.nuget.org/packages/Microsoft.Graphics.Win2D/
- WIL https://www.nuget.org/packages/Microsoft.Windows.ImplementationLibrary
- GSL https://github.com/microsoft/GSL

## Learn More
- Win2D http://microsoft.github.io/Win2D/WinUI3/html/Introduction.htm
- Windows App SDK here https://docs.microsoft.com/windows/apps/windows-app-sdk/
- WinUI3 here https://docs.microsoft.com/windows/apps/winui/winui3/
- C++/WinRT here http://aka.ms/cppwinrt/

## Contributing
Pick an issue from the list, fork the repo, make your changes, and submit a pull request.
If you find a problem, file it. Use the Performance Profiler to find bottlenecks and file issues. Run on different screen
resolutions and DPIs. Build and debug on ARM devices. Write tests. Write documentation. Write code. Write more code. Run Code Analysis
and file and fix issues. Clean up the class design. Go for it.

## Updating submodules
From Windows Terminal
In the butternut root
execute git submodule update --remote --merge
