# 文件及文件夹命名规范

### **1. 基本规则**

**1) 文件夹需要有清晰的目录结构, 相同类型文件使用文件夹分层次**

    - view
        - index.html
        - product.html
        - factory.html
    - css
        - index.css
        - base.css
        - product.css
        - factory.css
    - js
        - index.js
        - product.js
        - factory.js
        
        
**2) 文件和文件夹名称需要使用统一的英文翻译**

- 例: 工具类文件, `tools`, `utils`选用其一(推荐使用`utils.`)






### **2. 文件名称命名规则**

**1) 使用统一小写的英文字母(统一翻译的英文名字)， 数字和中划线的组合， 不得包含汉字，空格和特殊字符**

- `index.html`
- `jquery-ui.js`
- `product-list.css`
- `funnel-analyze.vue`

**2) 使用英文句号表示文件依赖关系, 范围大的在前面**

- `jquery.js`的表格扩展插件: `jquery.form.js`

**3) 经过压缩的文件添加`min`**

- `jquery.js`压缩后: `jquery.min.js`

**4) 使用数字代表版本号**

- `dw-min-1.2.js`



### **3. 文件夹的命名规范**
**1) 使用统一小写英文字母(统一翻译的英文名字), 数字和中划线的组合，不得包含汉字, 空格和特殊字符**
**2) 常用命名文件夹**

- 视图文件夹: *views*
- js文件夹: *js*
- 样式文件夹: *css*
- 工具类文件夹: *utils*
- 图片文件夹: *image*
- 测试文件夹: *test*
- 第三方库和插件文件夹: *libs*
- 字体文件文件夹:  *font*











