```
这里的文档很重要，
你可以在这里看到前端相关代码规范、开发规范、开发流程等，
如果你是新人，务必看完，
如果你是老员工，务必按这里的约定执行。
```
## 技术选型

+ 核心框架：[Vue](https://cn.vuejs.org/v2/guide/)
+ 状态管理：[Vuex](https://vuex.vuejs.org/zh-cn/intro.html)
+ 路由映射：[vue-router](https://router.vuejs.org/zh-cn/)
+ 模拟数据：[mock.js](http://mockjs.com/)
+ UI组件库：[Muse-UI](https://museui.github.io/#/index),[Element](http://element.eleme.io/#/zh-CN/component/quickstart)
+ HTTP请求库：[axios](https://github.com/mzabriskie/axios)
+ CSS的预处理框架: [Stylus](http://stylus-lang.com/),[中文文档](http://www.zhangxinxu.com/jq/stylus/),[sass](http://sass.bootcss.com/)
+ 资源加载打包工具：[Webpack](https://webpack.github.io/)
+ 代码规范工具：[eslint](http://eslint.org/)
+ 单元测试 [vue-test-utils](https://vue-test-utils.vuejs.org/zh-cn/)
+ 其他：[ES6](https://wohugb.gitbooks.io/ecmascript-6/content/index.html),[node.js](https://nodejs.org/en/),[npm](https://www.npmjs.com/),[alias](https://webpack.js.org/configuration/resolve/)


## 代码规范

+ [HTML规范](./html.md)
+ [CSS规范](./css.md)
+ [JS规范一（语法&格式篇）](./js.md)
+ [JS规范二（base）](./js-base.md)

## 前后端接口规范
+ [JSON-API](./json-api.md)

## 文件命名规范
+ [文件命名规范](./文件命名规范.md)
